/* switcher.c generated by valac 0.16.0, the Vala compiler
 * generated from switcher.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2011 Peng Huang <shawn.p.huang@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <ibus.h>
#include <gdk/gdk.h>
#include <atk/atk.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>


#define TYPE_SWITCHER (switcher_get_type ())
#define SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SWITCHER, Switcher))
#define SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SWITCHER, SwitcherClass))
#define IS_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SWITCHER))
#define IS_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SWITCHER))
#define SWITCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SWITCHER, SwitcherClass))

typedef struct _Switcher Switcher;
typedef struct _SwitcherClass SwitcherClass;
typedef struct _SwitcherPrivate SwitcherPrivate;

#define SWITCHER_TYPE_IBUS_ENGINE_BUTTON (switcher_ibus_engine_button_get_type ())
#define SWITCHER_IBUS_ENGINE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWITCHER_TYPE_IBUS_ENGINE_BUTTON, SwitcherIBusEngineButton))
#define SWITCHER_IBUS_ENGINE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWITCHER_TYPE_IBUS_ENGINE_BUTTON, SwitcherIBusEngineButtonClass))
#define SWITCHER_IS_IBUS_ENGINE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWITCHER_TYPE_IBUS_ENGINE_BUTTON))
#define SWITCHER_IS_IBUS_ENGINE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWITCHER_TYPE_IBUS_ENGINE_BUTTON))
#define SWITCHER_IBUS_ENGINE_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWITCHER_TYPE_IBUS_ENGINE_BUTTON, SwitcherIBusEngineButtonClass))

typedef struct _SwitcherIBusEngineButton SwitcherIBusEngineButton;
typedef struct _SwitcherIBusEngineButtonClass SwitcherIBusEngineButtonClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SwitcherIBusEngineButtonPrivate SwitcherIBusEngineButtonPrivate;

#define TYPE_ICON_WIDGET (icon_widget_get_type ())
#define ICON_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ICON_WIDGET, IconWidget))
#define ICON_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ICON_WIDGET, IconWidgetClass))
#define IS_ICON_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ICON_WIDGET))
#define IS_ICON_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ICON_WIDGET))
#define ICON_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ICON_WIDGET, IconWidgetClass))

typedef struct _IconWidget IconWidget;
typedef struct _IconWidgetClass IconWidgetClass;

struct _Switcher {
	GtkWindow parent_instance;
	SwitcherPrivate * priv;
};

struct _SwitcherClass {
	GtkWindowClass parent_class;
};

struct _SwitcherPrivate {
	GtkBox* m_box;
	GtkLabel* m_label;
	SwitcherIBusEngineButton** m_buttons;
	gint m_buttons_length1;
	gint _m_buttons_size_;
	IBusEngineDesc** m_engines;
	gint m_engines_length1;
	gint _m_engines_size_;
	guint m_selected_engine;
	guint m_keyval;
	guint m_modifiers;
	GdkModifierType m_primary_modifier;
	GMainLoop* m_loop;
	gint m_result;
};

struct _Block5Data {
	int _ref_count_;
	Switcher * self;
	gint index;
	SwitcherIBusEngineButton* button;
};

struct _SwitcherIBusEngineButton {
	GtkButton parent_instance;
	SwitcherIBusEngineButtonPrivate * priv;
};

struct _SwitcherIBusEngineButtonClass {
	GtkButtonClass parent_class;
};

struct _SwitcherIBusEngineButtonPrivate {
	gchar* _longname;
};


static gpointer switcher_parent_class = NULL;
static gpointer switcher_ibus_engine_button_parent_class = NULL;

GType switcher_get_type (void) G_GNUC_CONST;
static GType switcher_ibus_engine_button_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define SWITCHER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SWITCHER, SwitcherPrivate))
enum  {
	SWITCHER_DUMMY_PROPERTY
};
#define SWITCHER_DEFAULT_FONT_SIZE 16
#define SWITCHER_DESC_LABEL_MAX_LEN 20
#define SWITCHER_ICON_SIZE 48
Switcher* switcher_new (void);
Switcher* switcher_construct (GType object_type);
gint switcher_run (Switcher* self, guint keyval, guint state, GdkEvent* event, IBusEngineDesc** engines, int engines_length1, gint index);
GdkModifierType keybinding_manager_get_primary_modifier (guint binding_mask);
#define KEYBINDING_MANAGER_MODIFIER_FILTER ((guint) (GDK_MODIFIER_MASK & (~(((((((((GDK_LOCK_MASK | GDK_MOD2_MASK) | GDK_BUTTON1_MASK) | GDK_BUTTON2_MASK) | GDK_BUTTON3_MASK) | GDK_BUTTON4_MASK) | GDK_BUTTON5_MASK) | GDK_SUPER_MASK) | GDK_HYPER_MASK) | GDK_META_MASK))))
static void switcher_update_engines (Switcher* self, IBusEngineDesc** engines, int engines_length1);
static const gchar* switcher_ibus_engine_button_get_longname (SwitcherIBusEngineButton* self);
static gboolean ___lambda15_ (Switcher* self);
static gboolean ____lambda15__gsource_func (gpointer self);
static IBusEngineDesc** _vala_array_dup5 (IBusEngineDesc** self, int length);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static SwitcherIBusEngineButton* switcher_ibus_engine_button_new (IBusEngineDesc* engine);
static SwitcherIBusEngineButton* switcher_ibus_engine_button_construct (GType object_type, IBusEngineDesc* engine);
static gboolean _____lambda13_ (Block5Data* _data5_, GdkEventCrossing* e);
static gboolean ______lambda13__gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static gboolean _____lambda14_ (Block5Data* _data5_, GdkEventButton* e);
static gboolean ______lambda14__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void switcher_ibus_engine_button_set_longname (SwitcherIBusEngineButton* self, const gchar* value);
static void _vala_array_add17 (SwitcherIBusEngineButton*** array, int* length, int* size, SwitcherIBusEngineButton* value);
static void switcher_next_engine (Switcher* self);
static void switcher_previous_engine (Switcher* self);
static void switcher_real_show (GtkWidget* base);
static gboolean switcher_real_key_press_event (GtkWidget* base, GdkEventKey* e);
static gboolean switcher_real_key_release_event (GtkWidget* base, GdkEventKey* e);
gboolean keybinding_manager_primary_modifier_still_pressed (GdkEvent* event, guint primary_modifier);
#define SWITCHER_IBUS_ENGINE_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SWITCHER_TYPE_IBUS_ENGINE_BUTTON, SwitcherIBusEngineButtonPrivate))
enum  {
	SWITCHER_IBUS_ENGINE_BUTTON_DUMMY_PROPERTY,
	SWITCHER_IBUS_ENGINE_BUTTON_LONGNAME
};
IconWidget* icon_widget_new (const gchar* icon, gint size);
IconWidget* icon_widget_construct (GType object_type, const gchar* icon, gint size);
GType icon_widget_get_type (void) G_GNUC_CONST;
static void switcher_ibus_engine_button_finalize (GObject* obj);
static void _vala_switcher_ibus_engine_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_switcher_ibus_engine_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void switcher_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


Switcher* switcher_construct (GType object_type) {
	Switcher * self = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* vbox;
	GtkAlignment* _tmp2_;
	GtkAlignment* _tmp3_;
	GtkAlignment* align;
	GtkBox* _tmp4_;
	GtkBox* _tmp5_;
	GtkBox* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	AtkObject* _tmp10_ = NULL;
	AtkObject* _tmp11_;
	AtkObject* obj;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	self = (Switcher*) g_object_new (object_type, "type", GTK_WINDOW_POPUP, "events", GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK, "window-position", GTK_WIN_POS_CENTER, "accept-focus", TRUE, "decorated", FALSE, "modal", TRUE, "focus-visible", TRUE, NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	_tmp1_ = g_object_ref_sink (_tmp0_);
	vbox = _tmp1_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) vbox);
	_tmp2_ = (GtkAlignment*) gtk_alignment_new (0.5f, 0.5f, 0.0f, 0.0f);
	_tmp3_ = g_object_ref_sink (_tmp2_);
	align = _tmp3_;
	gtk_box_pack_start (vbox, (GtkWidget*) align, TRUE, TRUE, (guint) 0);
	_tmp4_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	_tmp5_ = g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->m_box);
	self->priv->m_box = _tmp5_;
	_tmp6_ = self->priv->m_box;
	gtk_container_add ((GtkContainer*) align, (GtkWidget*) _tmp6_);
	_tmp7_ = (GtkLabel*) gtk_label_new ("");
	_tmp8_ = g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->m_label);
	self->priv->m_label = _tmp8_;
	_tmp9_ = self->priv->m_label;
	_tmp10_ = gtk_widget_get_accessible ((GtkWidget*) _tmp9_);
	_tmp11_ = _g_object_ref0 (_tmp10_);
	obj = _tmp11_;
	atk_object_set_role (obj, ATK_ROLE_STATUSBAR);
	_tmp12_ = self->priv->m_label;
	gtk_misc_set_padding ((GtkMisc*) _tmp12_, 3, 3);
	_tmp13_ = self->priv->m_label;
	gtk_box_pack_end (vbox, (GtkWidget*) _tmp13_, FALSE, FALSE, (guint) 0);
	gtk_widget_grab_focus ((GtkWidget*) self);
	_g_object_unref0 (obj);
	_g_object_unref0 (align);
	_g_object_unref0 (vbox);
	return self;
}


Switcher* switcher_new (void) {
	return switcher_construct (TYPE_SWITCHER);
}


static gboolean ___lambda15_ (Switcher* self) {
	gboolean result = FALSE;
	GdkWindow* _tmp0_ = NULL;
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_set_opacity (_tmp0_, 1.0);
	result = FALSE;
	return result;
}


static gboolean ____lambda15__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda15_ (self);
	return result;
}


gint switcher_run (Switcher* self, guint keyval, guint state, GdkEvent* event, IBusEngineDesc** engines, int engines_length1, gint index) {
	gint result = 0;
	GMainLoop* _tmp0_;
	gint _tmp1_;
	IBusEngineDesc** _tmp2_;
	gint _tmp2__length1;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	GdkModifierType _tmp6_ = 0;
	IBusEngineDesc** _tmp7_;
	gint _tmp7__length1;
	gint _tmp8_;
	GtkLabel* _tmp9_;
	SwitcherIBusEngineButton** _tmp10_;
	gint _tmp10__length1;
	gint _tmp11_;
	SwitcherIBusEngineButton* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	SwitcherIBusEngineButton** _tmp15_;
	gint _tmp15__length1;
	gint _tmp16_;
	SwitcherIBusEngineButton* _tmp17_;
	GdkEvent* _tmp18_;
	GdkDevice* _tmp19_ = NULL;
	GdkDevice* _tmp20_;
	GdkDevice* device;
	GdkDevice* _tmp21_;
	GdkDevice* keyboard = NULL;
	GdkDevice* pointer = NULL;
	GdkDevice* _tmp32_;
	GdkInputSource _tmp33_ = 0;
	gboolean _tmp44_ = FALSE;
	GdkGrabStatus status = 0;
	GdkDevice* _tmp46_;
	GdkWindow* _tmp47_ = NULL;
	GdkGrabStatus _tmp48_ = 0;
	GdkGrabStatus _tmp49_;
	GdkDevice* _tmp51_;
	GdkWindow* _tmp52_ = NULL;
	GdkGrabStatus _tmp53_ = 0;
	GdkGrabStatus _tmp54_;
	GMainLoop* _tmp56_;
	GMainLoop* _tmp57_;
	GdkDevice* _tmp58_;
	GdkDevice* _tmp59_;
	gint _tmp61_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (event != NULL, 0);
	_tmp0_ = self->priv->m_loop;
	g_assert (_tmp0_ == NULL);
	_tmp1_ = index;
	_tmp2_ = engines;
	_tmp2__length1 = engines_length1;
	g_assert (_tmp1_ < _tmp2__length1);
	_tmp3_ = keyval;
	self->priv->m_keyval = _tmp3_;
	_tmp4_ = state;
	self->priv->m_modifiers = _tmp4_;
	_tmp5_ = state;
	_tmp6_ = keybinding_manager_get_primary_modifier (_tmp5_ & KEYBINDING_MANAGER_MODIFIER_FILTER);
	self->priv->m_primary_modifier = _tmp6_;
	_tmp7_ = engines;
	_tmp7__length1 = engines_length1;
	switcher_update_engines (self, _tmp7_, _tmp7__length1);
	gtk_window_resize ((GtkWindow*) self, 1, 1);
	_tmp8_ = index;
	self->priv->m_selected_engine = (guint) _tmp8_;
	_tmp9_ = self->priv->m_label;
	_tmp10_ = self->priv->m_buttons;
	_tmp10__length1 = self->priv->m_buttons_length1;
	_tmp11_ = index;
	_tmp12_ = _tmp10_[_tmp11_];
	_tmp13_ = switcher_ibus_engine_button_get_longname (_tmp12_);
	_tmp14_ = _tmp13_;
	gtk_label_set_text (_tmp9_, _tmp14_);
	_tmp15_ = self->priv->m_buttons;
	_tmp15__length1 = self->priv->m_buttons_length1;
	_tmp16_ = index;
	_tmp17_ = _tmp15_[_tmp16_];
	gtk_widget_grab_focus ((GtkWidget*) _tmp17_);
	_tmp18_ = event;
	_tmp19_ = gdk_event_get_device (_tmp18_);
	_tmp20_ = _g_object_ref0 (_tmp19_);
	device = _tmp20_;
	_tmp21_ = device;
	if (_tmp21_ == NULL) {
		GdkDisplay* _tmp22_ = NULL;
		GdkDisplay* _tmp23_;
		GdkDisplay* display;
		GdkDisplay* _tmp24_;
		GdkDeviceManager* _tmp25_ = NULL;
		GdkDeviceManager* _tmp26_;
		GdkDeviceManager* device_manager;
		GdkDeviceManager* _tmp27_;
		GList* _tmp28_ = NULL;
		GList* _tmp29_;
		gconstpointer _tmp30_;
		GdkDevice* _tmp31_;
		_tmp22_ = gtk_widget_get_display ((GtkWidget*) self);
		_tmp23_ = _g_object_ref0 (_tmp22_);
		display = _tmp23_;
		_tmp24_ = display;
		_tmp25_ = gdk_display_get_device_manager (_tmp24_);
		_tmp26_ = _g_object_ref0 (_tmp25_);
		device_manager = _tmp26_;
		_tmp27_ = device_manager;
		_tmp28_ = gdk_device_manager_list_devices (_tmp27_, GDK_DEVICE_TYPE_MASTER);
		_tmp29_ = _tmp28_;
		_tmp30_ = _tmp29_->data;
		_tmp31_ = _g_object_ref0 ((GdkDevice*) _tmp30_);
		_g_object_unref0 (device);
		device = _tmp31_;
		_g_list_free0 (_tmp29_);
		_g_object_unref0 (device_manager);
		_g_object_unref0 (display);
	}
	_tmp32_ = device;
	_tmp33_ = gdk_device_get_source (_tmp32_);
	if (_tmp33_ == GDK_SOURCE_KEYBOARD) {
		GdkDevice* _tmp34_;
		GdkDevice* _tmp35_;
		GdkDevice* _tmp36_;
		GdkDevice* _tmp37_ = NULL;
		GdkDevice* _tmp38_;
		_tmp34_ = device;
		_tmp35_ = _g_object_ref0 (_tmp34_);
		_g_object_unref0 (keyboard);
		keyboard = _tmp35_;
		_tmp36_ = device;
		_tmp37_ = gdk_device_get_associated_device (_tmp36_);
		_tmp38_ = _g_object_ref0 (_tmp37_);
		_g_object_unref0 (pointer);
		pointer = _tmp38_;
	} else {
		GdkDevice* _tmp39_;
		GdkDevice* _tmp40_;
		GdkDevice* _tmp41_;
		GdkDevice* _tmp42_ = NULL;
		GdkDevice* _tmp43_;
		_tmp39_ = device;
		_tmp40_ = _g_object_ref0 (_tmp39_);
		_g_object_unref0 (pointer);
		pointer = _tmp40_;
		_tmp41_ = device;
		_tmp42_ = gdk_device_get_associated_device (_tmp41_);
		_tmp43_ = _g_object_ref0 (_tmp42_);
		_g_object_unref0 (keyboard);
		keyboard = _tmp43_;
	}
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp44_ = gtk_widget_is_composited ((GtkWidget*) self);
	if (_tmp44_) {
		GdkWindow* _tmp45_ = NULL;
		_tmp45_ = gtk_widget_get_window ((GtkWidget*) self);
		gdk_window_set_opacity (_tmp45_, 0.0);
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ____lambda15__gsource_func, g_object_ref (self), g_object_unref);
	}
	_tmp46_ = keyboard;
	_tmp47_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp48_ = gdk_device_grab (_tmp46_, _tmp47_, GDK_OWNERSHIP_NONE, TRUE, GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK, NULL, (guint32) GDK_CURRENT_TIME);
	status = _tmp48_;
	_tmp49_ = status;
	if (_tmp49_ != GDK_GRAB_SUCCESS) {
		GdkGrabStatus _tmp50_;
		_tmp50_ = status;
		g_warning ("switcher.vala:180: Grab keyboard failed! status = %d", (gint) _tmp50_);
	}
	_tmp51_ = pointer;
	_tmp52_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp53_ = gdk_device_grab (_tmp51_, _tmp52_, GDK_OWNERSHIP_NONE, TRUE, GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK, NULL, (guint32) GDK_CURRENT_TIME);
	status = _tmp53_;
	_tmp54_ = status;
	if (_tmp54_ != GDK_GRAB_SUCCESS) {
		GdkGrabStatus _tmp55_;
		_tmp55_ = status;
		g_warning ("switcher.vala:190: Grab pointer failed! status = %d", (gint) _tmp55_);
	}
	_tmp56_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->m_loop);
	self->priv->m_loop = _tmp56_;
	_tmp57_ = self->priv->m_loop;
	g_main_loop_run (_tmp57_);
	_g_main_loop_unref0 (self->priv->m_loop);
	self->priv->m_loop = NULL;
	_tmp58_ = keyboard;
	gdk_device_ungrab (_tmp58_, (guint32) GDK_CURRENT_TIME);
	_tmp59_ = pointer;
	gdk_device_ungrab (_tmp59_, (guint32) GDK_CURRENT_TIME);
	gtk_widget_hide ((GtkWidget*) self);
	while (TRUE) {
		gboolean _tmp60_ = FALSE;
		_tmp60_ = gtk_events_pending ();
		if (!_tmp60_) {
			break;
		}
		gtk_main_iteration ();
	}
	_tmp61_ = self->priv->m_result;
	result = _tmp61_;
	_g_object_unref0 (pointer);
	_g_object_unref0 (keyboard);
	_g_object_unref0 (device);
	return result;
}


static IBusEngineDesc** _vala_array_dup5 (IBusEngineDesc** self, int length) {
	IBusEngineDesc** result;
	int i;
	result = g_new0 (IBusEngineDesc*, length + 1);
	for (i = 0; i < length; i++) {
		IBusEngineDesc* _tmp0_;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		Switcher * self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->button);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static gboolean _____lambda13_ (Block5Data* _data5_, GdkEventCrossing* e) {
	Switcher * self;
	gboolean result = FALSE;
	SwitcherIBusEngineButton* _tmp0_;
	gint _tmp1_;
	self = _data5_->self;
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = _data5_->button;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
	_tmp1_ = _data5_->index;
	self->priv->m_selected_engine = (guint) _tmp1_;
	result = TRUE;
	return result;
}


static gboolean ______lambda13__gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = _____lambda13_ (self, event);
	return result;
}


static gboolean _____lambda14_ (Block5Data* _data5_, GdkEventButton* e) {
	Switcher * self;
	gboolean result = FALSE;
	gint _tmp0_;
	guint _tmp1_;
	GMainLoop* _tmp2_;
	self = _data5_->self;
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = _data5_->index;
	self->priv->m_selected_engine = (guint) _tmp0_;
	_tmp1_ = self->priv->m_selected_engine;
	self->priv->m_result = (gint) _tmp1_;
	_tmp2_ = self->priv->m_loop;
	g_main_loop_quit (_tmp2_);
	result = TRUE;
	return result;
}


static gboolean ______lambda14__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = _____lambda14_ (self, event);
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static void _vala_array_add17 (SwitcherIBusEngineButton*** array, int* length, int* size, SwitcherIBusEngineButton* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (SwitcherIBusEngineButton*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void switcher_update_engines (Switcher* self, IBusEngineDesc** engines, int engines_length1) {
	SwitcherIBusEngineButton** _tmp0_;
	gint _tmp0__length1;
	SwitcherIBusEngineButton** _tmp3_ = NULL;
	IBusEngineDesc** _tmp4_;
	gint _tmp4__length1;
	IBusEngineDesc** _tmp6_;
	gint _tmp6__length1;
	IBusEngineDesc** _tmp7_;
	gint _tmp7__length1;
	gint max_label_width;
	GtkLabel* _tmp47_;
	SwitcherIBusEngineButton** _tmp48_;
	gint _tmp48__length1;
	SwitcherIBusEngineButton* _tmp49_;
	const gchar* _tmp50_;
	const gchar* _tmp51_;
	GtkLabel* _tmp52_;
	GdkDisplay* _tmp53_ = NULL;
	GdkDisplay* _tmp54_;
	GdkDisplay* display;
	GdkScreen* _tmp55_ = NULL;
	GdkDisplay* _tmp56_;
	GdkScreen* _tmp59_;
	GdkScreen* _tmp60_;
	GdkScreen* screen;
	gint screen_width;
	GdkScreen* _tmp61_;
	gboolean _tmp64_ = FALSE;
	gint _tmp65_;
	gboolean _tmp68_;
	gint _tmp70_;
	gint _tmp71_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_buttons;
	_tmp0__length1 = self->priv->m_buttons_length1;
	{
		SwitcherIBusEngineButton** button_collection = NULL;
		gint button_collection_length1 = 0;
		gint _button_collection_size_ = 0;
		gint button_it = 0;
		button_collection = _tmp0_;
		button_collection_length1 = _tmp0__length1;
		for (button_it = 0; button_it < _tmp0__length1; button_it = button_it + 1) {
			SwitcherIBusEngineButton* _tmp1_;
			SwitcherIBusEngineButton* button = NULL;
			_tmp1_ = _g_object_ref0 (button_collection[button_it]);
			button = _tmp1_;
			{
				SwitcherIBusEngineButton* _tmp2_;
				_tmp2_ = button;
				gtk_widget_destroy ((GtkWidget*) _tmp2_);
				_g_object_unref0 (button);
			}
		}
	}
	_tmp3_ = g_new0 (SwitcherIBusEngineButton*, 0 + 1);
	self->priv->m_buttons = (_vala_array_free (self->priv->m_buttons, self->priv->m_buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->m_buttons = _tmp3_;
	self->priv->m_buttons_length1 = 0;
	self->priv->_m_buttons_size_ = self->priv->m_buttons_length1;
	_tmp4_ = engines;
	_tmp4__length1 = engines_length1;
	if (_tmp4_ == NULL) {
		IBusEngineDesc** _tmp5_ = NULL;
		_tmp5_ = g_new0 (IBusEngineDesc*, 0 + 1);
		self->priv->m_engines = (_vala_array_free (self->priv->m_engines, self->priv->m_engines_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_engines = _tmp5_;
		self->priv->m_engines_length1 = 0;
		self->priv->_m_engines_size_ = self->priv->m_engines_length1;
		return;
	}
	_tmp6_ = engines;
	_tmp6__length1 = engines_length1;
	_tmp7_ = (_tmp6_ != NULL) ? _vala_array_dup5 (_tmp6_, _tmp6__length1) : ((gpointer) _tmp6_);
	_tmp7__length1 = _tmp6__length1;
	self->priv->m_engines = (_vala_array_free (self->priv->m_engines, self->priv->m_engines_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->m_engines = _tmp7_;
	self->priv->m_engines_length1 = _tmp7__length1;
	self->priv->_m_engines_size_ = self->priv->m_engines_length1;
	max_label_width = 0;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp8_;
			_tmp8_ = TRUE;
			while (TRUE) {
				Block5Data* _data5_;
				gboolean _tmp9_;
				gint _tmp11_;
				IBusEngineDesc** _tmp12_;
				gint _tmp12__length1;
				gint _tmp13_;
				IBusEngineDesc** _tmp14_;
				gint _tmp14__length1;
				gint _tmp15_;
				IBusEngineDesc* _tmp16_;
				IBusEngineDesc* _tmp17_;
				IBusEngineDesc* engine;
				IBusEngineDesc* _tmp18_;
				SwitcherIBusEngineButton* _tmp19_;
				SwitcherIBusEngineButton* _tmp20_;
				IBusEngineDesc* _tmp21_;
				const gchar* _tmp22_ = NULL;
				gchar* _tmp23_;
				gchar* longname;
				SwitcherIBusEngineButton* _tmp24_;
				SwitcherIBusEngineButton* _tmp25_;
				SwitcherIBusEngineButton* _tmp26_;
				SwitcherIBusEngineButton* _tmp27_;
				const gchar* _tmp28_;
				gint _tmp29_;
				gint _tmp30_;
				SwitcherIBusEngineButton* _tmp33_;
				const gchar* _tmp34_;
				GtkLabel* _tmp35_;
				const gchar* _tmp36_;
				gint width = 0;
				GtkLabel* _tmp37_;
				gint _tmp38_ = 0;
				gint _tmp39_;
				gint _tmp40_;
				gint _tmp41_ = 0;
				GtkBox* _tmp42_;
				SwitcherIBusEngineButton* _tmp43_;
				SwitcherIBusEngineButton** _tmp44_;
				gint _tmp44__length1;
				SwitcherIBusEngineButton* _tmp45_;
				SwitcherIBusEngineButton* _tmp46_;
				_data5_ = g_slice_new0 (Block5Data);
				_data5_->_ref_count_ = 1;
				_data5_->self = g_object_ref (self);
				_tmp9_ = _tmp8_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp11_ = i;
				_tmp12_ = self->priv->m_engines;
				_tmp12__length1 = self->priv->m_engines_length1;
				if (!(_tmp11_ < _tmp12__length1)) {
					block5_data_unref (_data5_);
					_data5_ = NULL;
					break;
				}
				_tmp13_ = i;
				_data5_->index = _tmp13_;
				_tmp14_ = self->priv->m_engines;
				_tmp14__length1 = self->priv->m_engines_length1;
				_tmp15_ = i;
				_tmp16_ = _tmp14_[_tmp15_];
				_tmp17_ = _g_object_ref0 (_tmp16_);
				engine = _tmp17_;
				_tmp18_ = engine;
				_tmp19_ = switcher_ibus_engine_button_new (_tmp18_);
				_tmp20_ = g_object_ref_sink (_tmp19_);
				_data5_->button = _tmp20_;
				_tmp21_ = engine;
				_tmp22_ = ibus_engine_desc_get_longname (_tmp21_);
				_tmp23_ = g_strdup (_tmp22_);
				longname = _tmp23_;
				_tmp24_ = _data5_->button;
				gtk_button_set_relief ((GtkButton*) _tmp24_, GTK_RELIEF_NONE);
				_tmp25_ = _data5_->button;
				gtk_widget_show ((GtkWidget*) _tmp25_);
				_tmp26_ = _data5_->button;
				g_signal_connect_data ((GtkWidget*) _tmp26_, "enter-notify-event", (GCallback) ______lambda13__gtk_widget_enter_notify_event, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
				_tmp27_ = _data5_->button;
				g_signal_connect_data ((GtkWidget*) _tmp27_, "button-press-event", (GCallback) ______lambda14__gtk_widget_button_press_event, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
				_tmp28_ = longname;
				_tmp29_ = strlen (_tmp28_);
				_tmp30_ = _tmp29_;
				if (_tmp30_ > SWITCHER_DESC_LABEL_MAX_LEN) {
					const gchar* _tmp31_;
					gchar* _tmp32_ = NULL;
					_tmp31_ = longname;
					_tmp32_ = string_slice (_tmp31_, (glong) 0, (glong) SWITCHER_DESC_LABEL_MAX_LEN);
					_g_free0 (longname);
					longname = _tmp32_;
				}
				_tmp33_ = _data5_->button;
				_tmp34_ = longname;
				switcher_ibus_engine_button_set_longname (_tmp33_, _tmp34_);
				_tmp35_ = self->priv->m_label;
				_tmp36_ = longname;
				gtk_label_set_label (_tmp35_, _tmp36_);
				_tmp37_ = self->priv->m_label;
				gtk_widget_get_preferred_width ((GtkWidget*) _tmp37_, NULL, &_tmp38_);
				width = _tmp38_;
				_tmp39_ = max_label_width;
				_tmp40_ = width;
				_tmp41_ = MAX (_tmp39_, _tmp40_);
				max_label_width = _tmp41_;
				_tmp42_ = self->priv->m_box;
				_tmp43_ = _data5_->button;
				gtk_box_pack_start (_tmp42_, (GtkWidget*) _tmp43_, TRUE, TRUE, (guint) 0);
				_tmp44_ = self->priv->m_buttons;
				_tmp44__length1 = self->priv->m_buttons_length1;
				_tmp45_ = _data5_->button;
				_tmp46_ = _g_object_ref0 (_tmp45_);
				_vala_array_add17 (&self->priv->m_buttons, &self->priv->m_buttons_length1, &self->priv->_m_buttons_size_, _tmp46_);
				_g_free0 (longname);
				_g_object_unref0 (engine);
				block5_data_unref (_data5_);
				_data5_ = NULL;
			}
		}
	}
	_tmp47_ = self->priv->m_label;
	_tmp48_ = self->priv->m_buttons;
	_tmp48__length1 = self->priv->m_buttons_length1;
	_tmp49_ = _tmp48_[0];
	_tmp50_ = switcher_ibus_engine_button_get_longname (_tmp49_);
	_tmp51_ = _tmp50_;
	gtk_label_set_text (_tmp47_, _tmp51_);
	_tmp52_ = self->priv->m_label;
	gtk_label_set_ellipsize (_tmp52_, PANGO_ELLIPSIZE_END);
	_tmp53_ = gdk_display_get_default ();
	_tmp54_ = _g_object_ref0 (_tmp53_);
	display = _tmp54_;
	_tmp56_ = display;
	if (_tmp56_ != NULL) {
		GdkDisplay* _tmp57_;
		GdkScreen* _tmp58_ = NULL;
		_tmp57_ = display;
		_tmp58_ = gdk_display_get_default_screen (_tmp57_);
		_tmp55_ = _tmp58_;
	} else {
		_tmp55_ = NULL;
	}
	_tmp59_ = _tmp55_;
	_tmp60_ = _g_object_ref0 (_tmp59_);
	screen = _tmp60_;
	screen_width = 0;
	_tmp61_ = screen;
	if (_tmp61_ != NULL) {
		GdkScreen* _tmp62_;
		gint _tmp63_ = 0;
		_tmp62_ = screen;
		_tmp63_ = gdk_screen_get_width (_tmp62_);
		screen_width = _tmp63_;
	}
	_tmp65_ = screen_width;
	if (_tmp65_ > 0) {
		gint _tmp66_;
		gint _tmp67_;
		_tmp66_ = max_label_width;
		_tmp67_ = screen_width;
		_tmp64_ = _tmp66_ > (_tmp67_ / 4);
	} else {
		_tmp64_ = FALSE;
	}
	_tmp68_ = _tmp64_;
	if (_tmp68_) {
		gint _tmp69_;
		_tmp69_ = screen_width;
		max_label_width = _tmp69_ / 4;
	}
	_tmp70_ = max_label_width;
	max_label_width = _tmp70_ + 20;
	_tmp71_ = max_label_width;
	gtk_window_set_default_size ((GtkWindow*) self, _tmp71_, -1);
	_g_object_unref0 (screen);
	_g_object_unref0 (display);
}


static void switcher_next_engine (Switcher* self) {
	guint _tmp0_;
	IBusEngineDesc** _tmp1_;
	gint _tmp1__length1;
	GtkLabel* _tmp3_;
	SwitcherIBusEngineButton** _tmp4_;
	gint _tmp4__length1;
	guint _tmp5_;
	SwitcherIBusEngineButton* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	SwitcherIBusEngineButton** _tmp9_;
	gint _tmp9__length1;
	guint _tmp10_;
	SwitcherIBusEngineButton* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_selected_engine;
	_tmp1_ = self->priv->m_engines;
	_tmp1__length1 = self->priv->m_engines_length1;
	if (_tmp0_ == ((guint) (_tmp1__length1 - 1))) {
		self->priv->m_selected_engine = (guint) 0;
	} else {
		guint _tmp2_;
		_tmp2_ = self->priv->m_selected_engine;
		self->priv->m_selected_engine = _tmp2_ + 1;
	}
	_tmp3_ = self->priv->m_label;
	_tmp4_ = self->priv->m_buttons;
	_tmp4__length1 = self->priv->m_buttons_length1;
	_tmp5_ = self->priv->m_selected_engine;
	_tmp6_ = _tmp4_[_tmp5_];
	_tmp7_ = switcher_ibus_engine_button_get_longname (_tmp6_);
	_tmp8_ = _tmp7_;
	gtk_label_set_text (_tmp3_, _tmp8_);
	_tmp9_ = self->priv->m_buttons;
	_tmp9__length1 = self->priv->m_buttons_length1;
	_tmp10_ = self->priv->m_selected_engine;
	_tmp11_ = _tmp9_[_tmp10_];
	gtk_window_set_focus ((GtkWindow*) self, (GtkWidget*) _tmp11_);
}


static void switcher_previous_engine (Switcher* self) {
	guint _tmp0_;
	GtkLabel* _tmp3_;
	SwitcherIBusEngineButton** _tmp4_;
	gint _tmp4__length1;
	guint _tmp5_;
	SwitcherIBusEngineButton* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	SwitcherIBusEngineButton** _tmp9_;
	gint _tmp9__length1;
	guint _tmp10_;
	SwitcherIBusEngineButton* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_selected_engine;
	if (_tmp0_ == ((guint) 0)) {
		IBusEngineDesc** _tmp1_;
		gint _tmp1__length1;
		_tmp1_ = self->priv->m_engines;
		_tmp1__length1 = self->priv->m_engines_length1;
		self->priv->m_selected_engine = (guint) (_tmp1__length1 - 1);
	} else {
		guint _tmp2_;
		_tmp2_ = self->priv->m_selected_engine;
		self->priv->m_selected_engine = _tmp2_ - 1;
	}
	_tmp3_ = self->priv->m_label;
	_tmp4_ = self->priv->m_buttons;
	_tmp4__length1 = self->priv->m_buttons_length1;
	_tmp5_ = self->priv->m_selected_engine;
	_tmp6_ = _tmp4_[_tmp5_];
	_tmp7_ = switcher_ibus_engine_button_get_longname (_tmp6_);
	_tmp8_ = _tmp7_;
	gtk_label_set_text (_tmp3_, _tmp8_);
	_tmp9_ = self->priv->m_buttons;
	_tmp9__length1 = self->priv->m_buttons_length1;
	_tmp10_ = self->priv->m_selected_engine;
	_tmp11_ = _tmp9_[_tmp10_];
	gtk_window_set_focus ((GtkWindow*) self, (GtkWidget*) _tmp11_);
}


static void switcher_real_show (GtkWidget* base) {
	Switcher * self;
	self = (Switcher*) base;
	GTK_WIDGET_CLASS (switcher_parent_class)->show ((GtkWidget*) GTK_WINDOW (self));
	gtk_window_set_focus_visible ((GtkWindow*) self, TRUE);
}


static gboolean switcher_real_key_press_event (GtkWidget* base, GdkEventKey* e) {
	Switcher * self;
	gboolean result = FALSE;
	gboolean retval;
	GdkEventKey* pe;
	self = (Switcher*) base;
	g_return_val_if_fail (e != NULL, FALSE);
	retval = TRUE;
	pe = e;
	{
		gboolean _tmp0_;
		_tmp0_ = TRUE;
		while (TRUE) {
			gboolean _tmp1_;
			GdkEventKey* _tmp2_;
			GdkModifierType _tmp3_;
			guint modifiers;
			gboolean _tmp4_ = FALSE;
			guint _tmp5_;
			guint _tmp6_;
			gboolean _tmp9_;
			GdkEventKey* _tmp10_;
			guint _tmp11_;
			guint _tmp12_;
			GdkEventKey* _tmp15_;
			guint _tmp16_;
			_tmp1_ = _tmp0_;
			if (!_tmp1_) {
				if (!FALSE) {
					break;
				}
			}
			_tmp0_ = FALSE;
			_tmp2_ = pe;
			_tmp3_ = (*_tmp2_).state;
			modifiers = KEYBINDING_MANAGER_MODIFIER_FILTER & _tmp3_;
			_tmp5_ = modifiers;
			_tmp6_ = self->priv->m_modifiers;
			if (_tmp5_ != _tmp6_) {
				guint _tmp7_;
				guint _tmp8_;
				_tmp7_ = modifiers;
				_tmp8_ = self->priv->m_modifiers;
				_tmp4_ = _tmp7_ != (_tmp8_ | GDK_SHIFT_MASK);
			} else {
				_tmp4_ = FALSE;
			}
			_tmp9_ = _tmp4_;
			if (_tmp9_) {
				break;
			}
			_tmp10_ = pe;
			_tmp11_ = (*_tmp10_).keyval;
			_tmp12_ = self->priv->m_keyval;
			if (_tmp11_ == _tmp12_) {
				guint _tmp13_;
				guint _tmp14_;
				_tmp13_ = modifiers;
				_tmp14_ = self->priv->m_modifiers;
				if (_tmp13_ == _tmp14_) {
					switcher_next_engine (self);
				} else {
					switcher_previous_engine (self);
				}
				break;
			}
			_tmp15_ = pe;
			_tmp16_ = (*_tmp15_).keyval;
			switch (_tmp16_) {
				case 0x08fb:
				case 0xff51:
				{
					switcher_previous_engine (self);
					break;
				}
				case 0x08fc:
				case 0xff52:
				{
					break;
				}
				case 0x08fd:
				case 0xff53:
				{
					switcher_next_engine (self);
					break;
				}
				case 0x08fe:
				case 0xff54:
				{
					break;
				}
				default:
				{
					GdkEventKey* _tmp17_;
					guint _tmp18_;
					_tmp17_ = pe;
					_tmp18_ = (*_tmp17_).keyval;
					g_debug ("switcher.vala:340: 0x%04x", _tmp18_);
					break;
				}
			}
		}
	}
	result = retval;
	return result;
}


static gboolean switcher_real_key_release_event (GtkWidget* base, GdkEventKey* e) {
	Switcher * self;
	gboolean result = FALSE;
	GdkEventKey* pe;
	GdkEventKey* _tmp0_;
	GdkModifierType _tmp1_;
	gboolean _tmp2_ = FALSE;
	GMainLoop* _tmp3_;
	GMainLoop* _tmp4_;
	guint _tmp5_;
	self = (Switcher*) base;
	g_return_val_if_fail (e != NULL, FALSE);
	pe = e;
	_tmp0_ = pe;
	_tmp1_ = self->priv->m_primary_modifier;
	_tmp2_ = keybinding_manager_primary_modifier_still_pressed ((GdkEvent*) _tmp0_, (guint) _tmp1_);
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	_tmp3_ = self->priv->m_loop;
	if (_tmp3_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp4_ = self->priv->m_loop;
	g_main_loop_quit (_tmp4_);
	_tmp5_ = self->priv->m_selected_engine;
	self->priv->m_result = (gint) _tmp5_;
	result = TRUE;
	return result;
}


static SwitcherIBusEngineButton* switcher_ibus_engine_button_construct (GType object_type, IBusEngineDesc* engine) {
	SwitcherIBusEngineButton * self = NULL;
	IBusEngineDesc* _tmp0_;
	const gchar* _tmp1_ = NULL;
	GtkAlignment* _tmp2_;
	GtkAlignment* _tmp3_;
	GtkAlignment* align;
	GtkAlignment* _tmp4_;
	g_return_val_if_fail (engine != NULL, NULL);
	self = (SwitcherIBusEngineButton*) g_object_new (object_type, NULL);
	_tmp0_ = engine;
	_tmp1_ = ibus_engine_desc_get_longname (_tmp0_);
	switcher_ibus_engine_button_set_longname (self, _tmp1_);
	_tmp2_ = (GtkAlignment*) gtk_alignment_new (0.5f, 0.5f, 0.0f, 0.0f);
	_tmp3_ = g_object_ref_sink (_tmp2_);
	align = _tmp3_;
	_tmp4_ = align;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp4_);
	if (!SWITCHER_USE_SYMBOL_ICON) {
		IBusEngineDesc* _tmp5_;
		const gchar* _tmp6_ = NULL;
		IconWidget* _tmp7_;
		IconWidget* _tmp8_;
		IconWidget* icon;
		GtkAlignment* _tmp9_;
		IconWidget* _tmp10_;
		_tmp5_ = engine;
		_tmp6_ = ibus_engine_desc_get_icon (_tmp5_);
		_tmp7_ = icon_widget_new (_tmp6_, SWITCHER_ICON_SIZE);
		_tmp8_ = g_object_ref_sink (_tmp7_);
		icon = _tmp8_;
		_tmp9_ = align;
		_tmp10_ = icon;
		gtk_container_add ((GtkContainer*) _tmp9_, (GtkWidget*) _tmp10_);
		_g_object_unref0 (icon);
	} else {
		IBusEngineDesc* _tmp11_;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		gchar* language;
		IBusEngineDesc* _tmp14_;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		gchar* symbol;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* id;
		const gchar* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		const gchar* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		const gchar* _tmp29_;
		GtkLabel* _tmp30_;
		GtkLabel* _tmp31_;
		GtkLabel* label;
		gchar* _tmp32_ = NULL;
		gchar* id_font;
		const gchar* _tmp33_;
		const gchar* _tmp34_;
		gchar* _tmp35_ = NULL;
		gchar* markup;
		GtkLabel* _tmp36_;
		const gchar* _tmp37_;
		GtkAlignment* _tmp38_;
		GtkLabel* _tmp39_;
		_tmp11_ = engine;
		_tmp12_ = ibus_engine_desc_get_language (_tmp11_);
		_tmp13_ = g_strdup (_tmp12_);
		language = _tmp13_;
		_tmp14_ = engine;
		_tmp15_ = ibus_engine_desc_get_symbol (_tmp14_);
		_tmp16_ = g_strdup (_tmp15_);
		symbol = _tmp16_;
		_tmp17_ = language;
		_tmp18_ = g_strdup (_tmp17_);
		id = _tmp18_;
		_tmp19_ = id;
		_tmp20_ = strlen (_tmp19_);
		_tmp21_ = _tmp20_;
		if (_tmp21_ > 2) {
			const gchar* _tmp22_;
			gchar* _tmp23_ = NULL;
			_tmp22_ = id;
			_tmp23_ = string_slice (_tmp22_, (glong) 0, (glong) 2);
			_g_free0 (id);
			id = _tmp23_;
		}
		_tmp24_ = symbol;
		_tmp25_ = strlen (_tmp24_);
		_tmp26_ = _tmp25_;
		if (_tmp26_ != 0) {
			const gchar* _tmp27_;
			gchar* _tmp28_;
			_tmp27_ = symbol;
			_tmp28_ = g_strdup (_tmp27_);
			_g_free0 (id);
			id = _tmp28_;
		}
		_tmp29_ = id;
		_tmp30_ = (GtkLabel*) gtk_label_new (_tmp29_);
		_tmp31_ = g_object_ref_sink (_tmp30_);
		label = _tmp31_;
		_tmp32_ = g_strdup_printf ("%d", SWITCHER_DEFAULT_FONT_SIZE);
		id_font = _tmp32_;
		_tmp33_ = id_font;
		_tmp34_ = id;
		_tmp35_ = g_strdup_printf ("<span font=\"%s\">%s</span>", _tmp33_, _tmp34_);
		markup = _tmp35_;
		_tmp36_ = label;
		_tmp37_ = markup;
		gtk_label_set_markup (_tmp36_, _tmp37_);
		_tmp38_ = align;
		_tmp39_ = label;
		gtk_container_add ((GtkContainer*) _tmp38_, (GtkWidget*) _tmp39_);
		_g_free0 (markup);
		_g_free0 (id_font);
		_g_object_unref0 (label);
		_g_free0 (id);
		_g_free0 (symbol);
		_g_free0 (language);
	}
	_g_object_unref0 (align);
	return self;
}


static SwitcherIBusEngineButton* switcher_ibus_engine_button_new (IBusEngineDesc* engine) {
	return switcher_ibus_engine_button_construct (SWITCHER_TYPE_IBUS_ENGINE_BUTTON, engine);
}


static const gchar* switcher_ibus_engine_button_get_longname (SwitcherIBusEngineButton* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_longname;
	result = _tmp0_;
	return result;
}


static void switcher_ibus_engine_button_set_longname (SwitcherIBusEngineButton* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_longname);
	self->priv->_longname = _tmp1_;
	g_object_notify ((GObject *) self, "longname");
}


static void switcher_ibus_engine_button_class_init (SwitcherIBusEngineButtonClass * klass) {
	switcher_ibus_engine_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SwitcherIBusEngineButtonPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_switcher_ibus_engine_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_switcher_ibus_engine_button_set_property;
	G_OBJECT_CLASS (klass)->finalize = switcher_ibus_engine_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHER_IBUS_ENGINE_BUTTON_LONGNAME, g_param_spec_string ("longname", "longname", "longname", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void switcher_ibus_engine_button_instance_init (SwitcherIBusEngineButton * self) {
	self->priv = SWITCHER_IBUS_ENGINE_BUTTON_GET_PRIVATE (self);
}


static void switcher_ibus_engine_button_finalize (GObject* obj) {
	SwitcherIBusEngineButton * self;
	self = SWITCHER_IBUS_ENGINE_BUTTON (obj);
	_g_free0 (self->priv->_longname);
	G_OBJECT_CLASS (switcher_ibus_engine_button_parent_class)->finalize (obj);
}


static GType switcher_ibus_engine_button_get_type (void) {
	static volatile gsize switcher_ibus_engine_button_type_id__volatile = 0;
	if (g_once_init_enter (&switcher_ibus_engine_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SwitcherIBusEngineButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switcher_ibus_engine_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwitcherIBusEngineButton), 0, (GInstanceInitFunc) switcher_ibus_engine_button_instance_init, NULL };
		GType switcher_ibus_engine_button_type_id;
		switcher_ibus_engine_button_type_id = g_type_register_static (GTK_TYPE_BUTTON, "SwitcherIBusEngineButton", &g_define_type_info, 0);
		g_once_init_leave (&switcher_ibus_engine_button_type_id__volatile, switcher_ibus_engine_button_type_id);
	}
	return switcher_ibus_engine_button_type_id__volatile;
}


static void _vala_switcher_ibus_engine_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SwitcherIBusEngineButton * self;
	self = SWITCHER_IBUS_ENGINE_BUTTON (object);
	switch (property_id) {
		case SWITCHER_IBUS_ENGINE_BUTTON_LONGNAME:
		g_value_set_string (value, switcher_ibus_engine_button_get_longname (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_switcher_ibus_engine_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SwitcherIBusEngineButton * self;
	self = SWITCHER_IBUS_ENGINE_BUTTON (object);
	switch (property_id) {
		case SWITCHER_IBUS_ENGINE_BUTTON_LONGNAME:
		switcher_ibus_engine_button_set_longname (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void switcher_class_init (SwitcherClass * klass) {
	switcher_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SwitcherPrivate));
	GTK_WIDGET_CLASS (klass)->show = switcher_real_show;
	GTK_WIDGET_CLASS (klass)->key_press_event = switcher_real_key_press_event;
	GTK_WIDGET_CLASS (klass)->key_release_event = switcher_real_key_release_event;
	G_OBJECT_CLASS (klass)->finalize = switcher_finalize;
}


static void switcher_instance_init (Switcher * self) {
	SwitcherIBusEngineButton** _tmp0_ = NULL;
	self->priv = SWITCHER_GET_PRIVATE (self);
	_tmp0_ = g_new0 (SwitcherIBusEngineButton*, 0 + 1);
	self->priv->m_buttons = _tmp0_;
	self->priv->m_buttons_length1 = 0;
	self->priv->_m_buttons_size_ = self->priv->m_buttons_length1;
}


static void switcher_finalize (GObject* obj) {
	Switcher * self;
	self = SWITCHER (obj);
	_g_object_unref0 (self->priv->m_box);
	_g_object_unref0 (self->priv->m_label);
	self->priv->m_buttons = (_vala_array_free (self->priv->m_buttons, self->priv->m_buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->m_engines = (_vala_array_free (self->priv->m_engines, self->priv->m_engines_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_main_loop_unref0 (self->priv->m_loop);
	G_OBJECT_CLASS (switcher_parent_class)->finalize (obj);
}


GType switcher_get_type (void) {
	static volatile gsize switcher_type_id__volatile = 0;
	if (g_once_init_enter (&switcher_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SwitcherClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switcher_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Switcher), 0, (GInstanceInitFunc) switcher_instance_init, NULL };
		GType switcher_type_id;
		switcher_type_id = g_type_register_static (GTK_TYPE_WINDOW, "Switcher", &g_define_type_info, 0);
		g_once_init_leave (&switcher_type_id__volatile, switcher_type_id);
	}
	return switcher_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



