/* iconwidget.c generated by valac 0.16.0, the Vala compiler
 * generated from iconwidget.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2011 Peng Huang <shawn.p.huang@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>


#define TYPE_ICON_WIDGET (icon_widget_get_type ())
#define ICON_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ICON_WIDGET, IconWidget))
#define ICON_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ICON_WIDGET, IconWidgetClass))
#define IS_ICON_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ICON_WIDGET))
#define IS_ICON_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ICON_WIDGET))
#define ICON_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ICON_WIDGET, IconWidgetClass))

typedef struct _IconWidget IconWidget;
typedef struct _IconWidgetClass IconWidgetClass;
typedef struct _IconWidgetPrivate IconWidgetPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _IconWidget {
	GtkImage parent_instance;
	IconWidgetPrivate * priv;
};

struct _IconWidgetClass {
	GtkImageClass parent_class;
};


static gpointer icon_widget_parent_class = NULL;

GType icon_widget_get_type (void) G_GNUC_CONST;
enum  {
	ICON_WIDGET_DUMMY_PROPERTY
};
IconWidget* icon_widget_new (const gchar* icon, gint size);
IconWidget* icon_widget_construct (GType object_type, const gchar* icon, gint size);


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


IconWidget* icon_widget_construct (GType object_type, const gchar* icon, gint size) {
	IconWidget * self = NULL;
	GdkPixbuf* pixbuf;
	GdkPixbuf* _tmp18_;
	GdkPixbuf* _tmp19_;
	gint _tmp20_ = 0;
	gfloat width;
	GdkPixbuf* _tmp21_;
	gint _tmp22_ = 0;
	gfloat height;
	gfloat _tmp23_ = 0.0F;
	gfloat _tmp24_;
	gfloat _tmp25_;
	gint _tmp28_;
	gfloat _tmp29_;
	gfloat scale;
	gfloat _tmp30_;
	gfloat _tmp31_;
	gfloat _tmp32_;
	gfloat _tmp33_;
	GdkPixbuf* _tmp34_;
	gfloat _tmp35_;
	gfloat _tmp36_;
	GdkPixbuf* _tmp37_ = NULL;
	GdkPixbuf* _tmp38_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (icon != NULL, NULL);
	self = (IconWidget*) g_object_new (object_type, NULL);
	pixbuf = NULL;
	{
		const gchar* _tmp0_;
		gchar _tmp1_ = '\0';
		_tmp0_ = icon;
		_tmp1_ = string_get (_tmp0_, (glong) 0);
		if (_tmp1_ == '/') {
			const gchar* _tmp2_;
			GdkPixbuf* _tmp3_;
			GdkPixbuf* _tmp4_;
			_tmp2_ = icon;
			_tmp3_ = gdk_pixbuf_new_from_file (_tmp2_, &_inner_error_);
			_tmp4_ = _tmp3_;
			if (_inner_error_ != NULL) {
				goto __catch0_g_error;
			}
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp4_;
		} else {
			GtkIconTheme* _tmp5_ = NULL;
			GtkIconTheme* _tmp6_;
			GtkIconTheme* theme;
			GtkIconTheme* _tmp7_;
			const gchar* _tmp8_;
			gint _tmp9_;
			GdkPixbuf* _tmp10_ = NULL;
			GdkPixbuf* _tmp11_;
			_tmp5_ = gtk_icon_theme_get_default ();
			_tmp6_ = _g_object_ref0 (_tmp5_);
			theme = _tmp6_;
			_tmp7_ = theme;
			_tmp8_ = icon;
			_tmp9_ = size;
			_tmp10_ = gtk_icon_theme_load_icon (_tmp7_, _tmp8_, _tmp9_, 0, &_inner_error_);
			_tmp11_ = _tmp10_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (theme);
				goto __catch0_g_error;
			}
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp11_;
			_g_object_unref0 (theme);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GtkIconTheme* _tmp12_ = NULL;
			GtkIconTheme* _tmp13_;
			GtkIconTheme* theme;
			GtkIconTheme* _tmp14_;
			gint _tmp15_;
			GdkPixbuf* _tmp16_ = NULL;
			GdkPixbuf* _tmp17_;
			_tmp12_ = gtk_icon_theme_get_default ();
			_tmp13_ = _g_object_ref0 (_tmp12_);
			theme = _tmp13_;
			_tmp14_ = theme;
			_tmp15_ = size;
			_tmp16_ = gtk_icon_theme_load_icon (_tmp14_, GTK_STOCK_MISSING_IMAGE, _tmp15_, 0, &_inner_error_);
			_tmp17_ = _tmp16_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (theme);
				goto __catch1_g_error;
			}
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp17_;
			_g_object_unref0 (theme);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally1:
		if (_inner_error_ != NULL) {
			_g_error_free0 (e);
			_g_error_free0 (e);
			_g_object_unref0 (pixbuf);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (pixbuf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp18_ = pixbuf;
	if (_tmp18_ == NULL) {
		_g_object_unref0 (pixbuf);
		return self;
	}
	_tmp19_ = pixbuf;
	_tmp20_ = gdk_pixbuf_get_width (_tmp19_);
	width = (gfloat) _tmp20_;
	_tmp21_ = pixbuf;
	_tmp22_ = gdk_pixbuf_get_height (_tmp21_);
	height = (gfloat) _tmp22_;
	_tmp24_ = width;
	_tmp25_ = height;
	if (_tmp24_ > _tmp25_) {
		gfloat _tmp26_;
		_tmp26_ = width;
		_tmp23_ = _tmp26_;
	} else {
		gfloat _tmp27_;
		_tmp27_ = height;
		_tmp23_ = _tmp27_;
	}
	_tmp28_ = size;
	_tmp29_ = _tmp23_;
	scale = _tmp28_ / _tmp29_;
	_tmp30_ = width;
	_tmp31_ = scale;
	width = _tmp30_ * _tmp31_;
	_tmp32_ = height;
	_tmp33_ = scale;
	height = _tmp32_ * _tmp33_;
	_tmp34_ = pixbuf;
	_tmp35_ = width;
	_tmp36_ = height;
	_tmp37_ = gdk_pixbuf_scale_simple (_tmp34_, (gint) _tmp35_, (gint) _tmp36_, GDK_INTERP_BILINEAR);
	_g_object_unref0 (pixbuf);
	pixbuf = _tmp37_;
	_tmp38_ = pixbuf;
	gtk_image_set_from_pixbuf ((GtkImage*) self, _tmp38_);
	gtk_widget_show ((GtkWidget*) self);
	_g_object_unref0 (pixbuf);
	return self;
}


IconWidget* icon_widget_new (const gchar* icon, gint size) {
	return icon_widget_construct (TYPE_ICON_WIDGET, icon, size);
}


static void icon_widget_class_init (IconWidgetClass * klass) {
	icon_widget_parent_class = g_type_class_peek_parent (klass);
}


static void icon_widget_instance_init (IconWidget * self) {
}


GType icon_widget_get_type (void) {
	static volatile gsize icon_widget_type_id__volatile = 0;
	if (g_once_init_enter (&icon_widget_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IconWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) icon_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IconWidget), 0, (GInstanceInitFunc) icon_widget_instance_init, NULL };
		GType icon_widget_type_id;
		icon_widget_type_id = g_type_register_static (GTK_TYPE_IMAGE, "IconWidget", &g_define_type_info, 0);
		g_once_init_leave (&icon_widget_type_id__volatile, icon_widget_type_id);
	}
	return icon_widget_type_id__volatile;
}



