<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_lua - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_lua</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_lua.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_lua.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Fournit des points d'entre Lua dans diffrentes parties du
traitement des requtes httpd</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Exprimental</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>lua_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_lua.c</td></tr>
<tr><th><a href="module-dict.html#Compatibility">Compatibilit:</a></th><td>versions 2.3 et suprieures</td></tr></table>
<h3>Sommaire</h3>

<p>Ce module permet d'ajouter au serveur des extensions sous forme de
scripts crits dans le langage de programmation Lua.
<code class="module"><a href="../mod/mod_lua.html">mod_lua</a></code> fournit de nombreuses extensions
(hooks) disponibles avec les modules natifs du serveur HTTP Apache,
comme les associations de requtes  des fichiers, la gnration de
rponses dynamiques, le contrle d'accs, l'authentification et
l'autorisation.</p>

<p>Vous trouverez davantage d'informations  propos du langage de
programmation Lua sur <a href="http://www.lua.org/">le site web de
Lua</a>.</p>

<div class="note"><code>mod_lua</code> est encore au stade exprimental. Son mode
d'utilisation et son comportement pourront changer  tout moment jusqu'
ce qu'il passe au stade stable, et ce mme entre deux versions stables
2.4.x. N'oublez pas de consulter le fichier CHANGES avant toute mise 
jour.</div>

</div>
<div id="quickview"><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#luaauthzprovider">LuaAuthzProvider</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#luahookaccesschecker">LuaHookAccessChecker</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#luahookauthchecker">LuaHookAuthChecker</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#luahookcheckuserid">LuaHookCheckUserID</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#luahookfixups">LuaHookFixups</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#luahookinsertfilter">LuaHookInsertFilter</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#luahookmaptostorage">LuaHookMapToStorage</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#luahooktranslatename">LuaHookTranslateName</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#luahooktypechecker">LuaHookTypeChecker</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#luainherit">LuaInherit</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#luapackagecpath">LuaPackageCPath</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#luapackagepath">LuaPackagePath</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#luaquickhandler">LuaQuickHandler</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#luaroot">LuaRoot</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#luascope">LuaScope</a></li>
</ul>
<h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#basicconf">Configuration de base</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#writinghandlers">Ecrire des gestionnaires</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#writingauthzproviders">Ecriture de fournisseurs d'autorisation</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#writinghooks">Ecriture de fonctions d'accroche
(hooks)</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#datastructures">Structures de donnes</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#logging">Fonctions de journalisation</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#apache2">Paquet apache2</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#databases">Connectivit aux bases de donnes</a></li>
</ul><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="basicconf" id="basicconf">Configuration de base</a></h2>

<p>La directive de base pour le chargement du module est</p>

<pre class="prettyprint lang-config">
    LoadModule lua_module modules/mod_lua.so
</pre>


<p>
<code>mod_lua</code> fournit un gestionnaire nomm
<code>lua-script</code> qui peut tre utilis avec une directive
<code>AddHandler</code> :</p>

<pre class="prettyprint lang-config">
AddHandler lua-script .lua
</pre>


<p>
Ceci aura pour effet de faire traiter les requtes pour les fichiers
dont l'extension est <code>.lua</code> par <code>mod_lua</code> en
invoquant cette fonction de <code>gestion</code> de fichier.
</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="writinghandlers" id="writinghandlers">Ecrire des gestionnaires</a></h2>
<p>Dans l'API du serveur HTTP Apache, un gestionnaire est une sorte de
point d'accroche (hook) spcifique responsable de la gnration de la
rponse. <code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code>, <code class="module"><a href="../mod/mod_cgi.html">mod_cgi</a></code> et
<code class="module"><a href="../mod/mod_status.html">mod_status</a></code> sont des exemples de modules comportant un
gestionnaire.</p>

<p><code>mod_lua</code> cherche toujours  invoquer une fonction Lua pour le
gestionnaire, plutt que de simplement valuer le corps d'un script dans
le style de CGI. Une fonction de gestionnaire se prsente comme suit :</p>


<pre class="prettyprint lang-lua">
<strong>example.lua</strong>
-- exemple de gestionnaire

require "string"

--[[
     Il s'agit du nom de mthode par dfaut pour les gestionnaires Lua ;
     voir les noms de fonctions optionnels dans la directive
     LuaMapHandler pour choisir un point d'entre diffrent.
--]]
function handle(r)
    r.content_type = "text/plain"
    r:puts("Hello Lua World!\n")

    if r.method == 'GET' then
        for k, v in pairs( r:parseargs() ) do
            r:puts( string.format("%s: %s\n", k, v) )
         end
    elseif r.method == 'POST' then
        for k, v in pairs( r:parsebody() ) do
            r:puts( string.format("%s: %s\n", k, v) )
        end
	
    else
        r:puts("Unsupported HTTP method " .. r.method)
    end
end
</pre>


<p>
Ce gestionnaire se contente d'afficher les arguments cods d'un uri ou
d'un formulaire dans un page au format texte.
</p>

<p>
Cela signifie que vous pouvez (et tes encourag ) avoir plusieurs
gestionnaires (ou points d'entre, ou filtres) dans le mme script.
</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="writingauthzproviders" id="writingauthzproviders">Ecriture de fournisseurs d'autorisation</a></h2>


<p><code class="module"><a href="../mod/mod_authz_core.html">mod_authz_core</a></code> fournit une interface d'autorisation
de haut niveau bien plus facile  utiliser que dans les hooks
correspondants. Le premier argument de la directive <code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code> permet de spcifier le
fournisseur d'autorisation  utiliser. Pour chaque directive <code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code>,
<code class="module"><a href="../mod/mod_authz_core.html">mod_authz_core</a></code> appellera le fournisseur d'autorisation
spcifi, le reste de la ligne constituant les paramtres. Le
fournisseur considr va alors vrifier les autorisations et fournir le
rsultat dans une valeur de retour.</p>

<p>En gnral, le fournisseur authz est appel avant l'authentification.
S'il doit connatre le nom d'utilisateur authentifi (ou si
l'utilisateur est appel  tre authentifi), le fournisseur doit
renvoyer <code>apache2.AUTHZ_DENIED_NO_USER</code>, ce qui va
dclancher le processus d'authentification et un deuxime appel du
fournisseur authz.</p>

<p>La fonction du fournisseur authz ci-dessous accepte deux arguments,
une adresse IP et un nom d'utilisateur. Elle autorise l'accs dans le
cas o la requte provient de l'adresse IP spcifie, ou si
l'utilisateur authentifi correspond au second argument :</p>

<pre class="prettyprint lang-lua">
<strong>authz_provider.lua</strong><br />

require 'apache2'

function authz_check_foo(r, ip, user)
    if r.useragent_ip == ip then
        return apache2.AUTHZ_GRANTED
    elseif r.user == nil then
        return apache2.AUTHZ_DENIED_NO_USER
    elseif r.user == user then
        return apache2.AUTHZ_GRANTED
    else
        return apache2.AUTHZ_DENIED
    end
end
</pre>


<p>La configuration suivante enregistre cette fonction en tant que
fournisseur <code>foo</code>, et la configure por l'URL <code>/</code> :</p>
<pre class="prettyprint lang-config">
LuaAuthzProvider foo authz_provider.lua authz_check_foo
&lt;Location /&gt;
  Require foo 10.1.2.3 john_doe
&lt;/Location&gt;
</pre>


</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="writinghooks" id="writinghooks">Ecriture de fonctions d'accroche
(hooks)</a></h2>

<p>Les fonctions d'accroche dterminent la manire dont les modules (et
les scripts Lua) participent au traitement des requtes. Chaque type
d'accroche propos par le serveur a un rle spcifique, comme
l'association de requtes au systme de fichiers, le contrle d'accs,
ou la dfinition de types MIME. Il existe aussi des accroches  usage
gnral qui s'excutent simplement  des moments opportuns du cycle
de vie de la requte.</p>

<p>Les fonctions d'accroche acceptent l'objet de la requte comme seul
et unique argument. Elles peuvent renvoyer une valeur, selon la
fonction, mais il s'agit en gnral d'un
code d'tat HTTP ou des valeurs OK, DONE, ou DECLINED,
que vous pouvez crire dans lua sous la forme <code>apache2.OK</code>,
<code>apache2.DONE</code>, ou <code>apache2.DECLINED</code>.</p>

<pre class="prettyprint lang-lua">
<strong>translate_name.lua</strong>
-- exemple d'accroche qui rcrit un URI en chemin du systme de
fichiers.

require 'apache2'

function translate_name(r)
    if r.uri == "/translate-name" then
        r.filename = r.document_root .. "/find_me.txt"
        return apache2.OK
    end
    -- on ne gre pas cette URL et on donne sa chance  un autre module
    return apache2.DECLINED
end
</pre>


<pre class="prettyprint lang-lua">
<strong>translate_name2.lua</strong>
--[[ exemple d'accroche qui rcrit un URI vers un autre URI. Il renvoie
	un apache2.DECLINED pour permettre  un autre interprteur d'URL de
	travailler sur la substitution, y compris l'accroche translate_name
	de base dont les tables de correspondances se basent sur DocumentRoot.

     Note: actuellement, il est impossible de prvoir si cette action
     s'excute avant ou aprs mod_alias.
--]]

require 'apache2'

function translate_name(r)
    if r.uri == "/translate-name" then
        r.uri = "/find_me.txt"
        return apache2.DECLINED
    end
    return apache2.DECLINED
end
</pre>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="datastructures" id="datastructures">Structures de donnes</a></h2>

<dl>
<dt>request_rec</dt>
        <dd>
        <p>request_rec est considre en tant que donne utilisateur.
	Elle possde une mtatable qui vous permet d'accomplir des
	choses intressantes. Pour la plus grande partie, elle possde
	les mmes champs que la structure request_rec (voir httpd.h en
	attendant que cette documentation soit plus complte), la
	plupart d'entre eux tant accessibles en lecture et criture (le
	contenu des champs de la table peut tre modifi, mais les
	champs eux-mmes ne peuvent pas tre tablis en tant que tables
	distinctes).</p>

	<table class="bordered">

        <tr>
          <th><strong>Nom</strong></th>
          <th><strong>Type Lua</strong></th>
          <th><strong>Modifiable</strong></th>
        </tr>
        <tr>
          <td><code>ap_auth_type</code></td>
          <td>string</td>
          <td>non</td>
        </tr>
        <tr>
          <td><code>args</code></td>
          <td>string</td>
          <td>oui</td>
        </tr>
        <tr>
          <td><code>assbackwards</code></td>
          <td>boolean</td>
          <td>non</td>
        </tr>

        <tr>
          <td><code>canonical_filename</code></td>
          <td>string</td>
          <td>non</td>
        </tr>
        <tr>
          <td><code>content_encoding</code></td>
          <td>string</td>
          <td>non</td>
        </tr>
        <tr>
          <td><code>content_type</code></td>
          <td>string</td>
          <td>oui</td>
        </tr>
	<tr>
          <td><code>context_prefix</code></td>
          <td>string</td>
          <td>non</td>
        </tr>
        <tr>
          <td><code>context_document_root</code></td>
          <td>string</td>
          <td>non</td>
        </tr>

        <tr>
          <td><code>document_root</code></td>
          <td>string</td>
          <td>non</td>
        </tr>
        <tr>
          <td><code>err_headers_out</code></td>
          <td>table</td>
          <td>non</td>
        </tr>
        <tr>
          <td><code>filename</code></td>
          <td>string</td>
          <td>oui</td>
        </tr>
        <tr>
          <td><code>handler</code></td>
          <td>string</td>
          <td>oui</td>
        </tr>
        <tr>
	  <td><code>headers_in</code></td>
          <td>table</td>
          <td>oui</td>
        </tr>
        <tr>
          <td><code>headers_out</code></td>
          <td>table</td>
          <td>oui</td>
        </tr>
        <tr>
          <td><code>hostname</code></td>
          <td>string</td>
          <td>non</td>
        </tr>
        <tr>
          <td><code>log_id</code></td>
          <td>string</td>
          <td>non</td>
        </tr>
        <tr>
          <td><code>method</code></td>
          <td>string</td>
          <td>non</td>
        </tr>
        <tr>
          <td><code>notes</code></td>
          <td>table</td>
          <td>oui</td>
        </tr>
        <tr>
          <td><code>path_info</code></td>
          <td>string</td>
          <td>non</td>
        </tr>
        <tr>
          <td><code>protocol</code></td>
          <td>string</td>
          <td>non</td>
        </tr>
        <tr>
          <td><code>proxyreq</code></td>
          <td>string</td>
          <td>oui</td>
        </tr>
        <tr>
	  <td><code>range</code></td>
          <td>string</td>
          <td>non</td>
        </tr>
        <tr>
          <td><code>subprocess_env</code></td>
          <td>table</td>
          <td>oui</td>
        </tr>
        <tr>
	  <td><code>status</code></td>
          <td>number</td>
          <td>oui</td>
        </tr>
        <tr>
          <td><code>the_request</code></td>
          <td>string</td>
          <td>non</td>
        </tr>
        <tr>
          <td><code>unparsed_uri</code></td>
          <td>string</td>
          <td>non</td>
        </tr>
        <tr>
          <td><code>uri</code></td>
          <td>string</td>
          <td>oui</td>
        </tr>
        <tr>
          <td><code>user</code></td>
          <td>string</td>
          <td>oui</td>
        </tr>
	<tr>
          <td><code>useragent_ip</code></td>
          <td>string</td>
          <td>non</td>
        </tr>
        </table>

        <p>La structure request_rec possde (au minimum) les mthodes
	suivantes :</p>

        <pre class="prettyprint lang-lua">
        r:addoutputfilter(name|function) -- ajoute un filtre en sortie
        </pre>


        <pre class="prettyprint lang-lua">
        r:parseargs() -- renvoie une table lua contenant la chane
	d'arguments de la requte
        </pre>


        <pre class="prettyprint lang-lua">
        r:parsebody()([sizeLimit]) -- interprte le corps de la requte
	en tant que POST et renvoie une table lua. Un nombre optionnel
	peut tre fourni pour spcifier le nombre maximal d'octets 
	interprter. La valeur par dfaut est 8192.
        </pre>


        <pre class="prettyprint lang-lua">
        r:puts("bonjour", " le monde", "!") -- affichage dans le corps de la rponse
        </pre>


	<pre class="prettyprint lang-lua">
        r:write("une simple chane") -- affichage dans le
	corps de la rponse
        </pre>


	<pre class="prettyprint lang-lua">
	r:dbacquire(dbType[, dbParams]) -- Acquiert une connexion  une
base de donnes et renvoie une classe database. Voir '<a href="#databases">Connectivit aux bases de donnes</a>' pour plus de
dtails.
        </pre>

        </dd>
    </dl>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="logging" id="logging">Fonctions de journalisation</a></h2>

<pre class="prettyprint lang-lua">
	-- exemples de messages de journalisation
	r:trace1("Ceci est un message de journalisation de niveau
	trace") -- les niveaux valides vont de trace1  trace8 <br />
        r:debug("Ceci est un message de journalisation de niveau debug")<br />
        r:info("Ceci est un message de journalisation de niveau info")<br />
        r:notice("Ceci est un message de journalisation de niveau notice")<br />
        r:warn("Ceci est un message de journalisation de niveau warn")<br />
        r:err("Ceci est un message de journalisation de niveau err")<br />
        r:alert("Ceci est un message de journalisation de niveau alert")<br />
        r:crit("Ceci est un message de journalisation de niveau crit")<br />
        r:emerg("Ceci est un message de journalisation de niveau emerg")<br />
</pre>


</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="apache2" id="apache2">Paquet apache2</a></h2>
<p>Le paquet nomm <code>apache2</code> est fourni avec (au minimum) le
contenu suivant :</p>
<dl>
  <dt>apache2.OK</dt>
  <dd>Constante interne OK. Les gestionnaires renverront cette valeur
  s'ils ont trait la requte.</dd>
  <dt>apache2.DECLINED</dt>
  <dd>Constante interne DECLINED. Les gestionnaires renverront cette
  valeur s'ils n'ont pas l'intention de traiter la requte.</dd>
  <dt>apache2.DONE</dt>
  <dd>Constante interne DONE.</dd>
  <dt>apache2.version</dt>
  <dd>Chane contenant la version du serveur HTTP Apache</dd>
  <dt>apache2.HTTP_MOVED_TEMPORARILY</dt>
  <dd>Code d'tat HTTP</dd>
  <dt>apache2.PROXYREQ_NONE, apache2.PROXYREQ_PROXY, apache2.PROXYREQ_REVERSE, apache2.PROXYREQ_RESPONSE</dt>
  <dd>Constantes internes utilises par <code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code></dd>
</dl>
<p>Les autres codes d'tat HTTP ne sont pas encore implments.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="databases" id="databases">Connectivit aux bases de donnes</a></h2>
    
    <p>Mod_lua implmente une fonctionnalit basique de connexion aux
bases de donnes permettant d'envoyer des requtes ou d'excuter des
commandes auprs des moteurs de base de donnes les plus courants
(mySQL, PostgreSQL, FreeTDS, ODBC, SQLite, Oracle), ainsi que mod_dbd.
    </p>
    <p>L'exemple suivant montre comment se connecter  une base de
donnes et extraire des informations d'une table :</p>
    <pre class="prettyprint lang-lua">
function handler(r)
    -- connexion  la base de donnes
    local database, err = r:dbacquire("mysql", "server=localhost,user=root,dbname=mydb")
    if not err then
        -- Slection de certaines informations
        local results, err = database:select(r, "SELECT `name`, `age` FROM `people` WHERE 1")
        if not err then
            local rows = results(0) -- extrait tous les enregistrements en mode synchrone
            for k, row in pairs(rows) do
                r:puts( string.format("Name: %s, Age: %s&lt;br/&gt;", row[1], row[2]) )
            end
        else
            r:puts("Database query error: " .. err)
        end
        database:close()
    else
        r:puts("Connexion  la base de donnes impossible : " .. err)
    end
end
    </pre>

    <p>
    Pour utiliser <code class="module"><a href="../mod/mod_dbd.html">mod_dbd</a></code>, spcifiez
<code>mod_dbd</code> comme type de base de donnes, ou laissez le champ
vide :
    </p>
    <pre class="prettyprint lang-lua">
    local database = r:dbacquire("mod_dbd")
    </pre>

    <h3><a name="database_object" id="database_object">L'objet database et ses mthodes</a></h3>
        
        <p>L'objet database renvoy par <code>dbacquire</code> possde
les mthodes suivantes :</p>
        <p><strong>Slection normale et requte vers une base de donnes
:</strong></p>
    <pre class="prettyprint lang-lua">
-- Excution d'une requte et renvoie du nombre d'enregistrements
affects :
local affected, errmsg = database:query(r, "DELETE FROM `tbl` WHERE 1")

-- Excution d'une requte et renvoie du rsultat qui peut tre utilis
en mode synchrone ou asynchrone :
local result, errmsg = database:select(r, "SELECT * FROM `people` WHERE 1")
    </pre>

        <p><strong>Utilisation de requtes prpares (recommand) :</strong></p>
    <pre class="prettyprint lang-lua">
-- Cration et excution d'une requte prpare :
local statement, errmsg = database:prepare(r, "DELETE FROM `tbl` WHERE `age` &gt; %u")
if not errmsg then
    local result, errmsg = statement:query(20) -- excute la requte pour age &gt; 20
end

-- Extrait une requte prpare depuis une directive DBDPrepareSQL :
local statement, errmsg = database:prepared(r, "someTag")
if not errmsg then
    local result, errmsg = statement:select("John Doe", 123) -- injecte les valeurs "John Doe" et 123 dans la requte
end

</pre>

        <p><strong>Echappement de valeurs, fermeture de la base donnes,
etc...</strong></p>
    <pre class="prettyprint lang-lua">
-- Echappe une valeur pour pouvoir l'utiliser dans une requte :
local escaped = database:escape(r, [["'|blabla]])

-- Ferme une base de donnes et libre les liens vers cette dernire :
database:close()

-- Vrifie si une connexion  une base de donnes est en service et
oprationnelle :
local connected = database:active()
    </pre>

    
    <h3><a name="result_sets" id="result_sets">Travail avec les jeux d'enregistrements renvoys par les requtes</a></h3>
    
    <p>Les jeux d'enregistrements renvoys par <code>db:select</code> ou par des
requtes prpares cres par <code>db:prepare</code> permettent de
slectionner des enregistrements en mode synchrone ou
asynchrone, selon le nombre d'enregistrements spcifi :<br />
    <code>result(0)</code> slectionne tous les enregistrements en mode
synchrone en renvoyant une table d'enregistrements.<br />
    <code>result(-1)</code> slectionne le prochain enregistrement disponible en
mode asynchrone.<br />
    <code>result(N)</code> slectionne l'enregistrement numro
<code>N</code> en mode asynchrone.
    </p>
    <pre class="prettyprint lang-lua">
-- extrait un jeu d'enregistrements via une requte rgulire :
local result, err = db:select(r, "SELECT * FROM `tbl` WHERE 1")

local rows = result(0) -- slectionne tous les enregistrements en mode synchrone
local row = result(-1) -- slectionne le prochain enregistrement disponible en mode asynchrone
local row = result(1234) -- slectionne l'enregistrement 1234 en mode asynchrone
    </pre>

    <p>Il est possible de construire une fonction qui renvoie une
fonction itrative permettant de traiter tous les enregistrement en mode
synchrone ou asynchrone selon la valeur de l'argument async :
    </p>
    <pre class="prettyprint lang-lua">
function rows(resultset, async)
    local a = 0
    local function getnext()
        a = a + 1
        local row = resultset(-1)
        return row and a or nil, row
    end
    if not async then
        return pairs(resultset(0))
    else
        return getnext, self
    end
end

local statement, err = db:prepare(r, "SELECT * FROM `tbl` WHERE `age` &gt; %u")
if not err then
     -- slectionne des enregistrements en mode asynchrone :
    local result, err = statement:select(20)
    if not err then
        for index, row in rows(result, true) do
            ....
        end
    end

     -- slectionne des enregistrements en mode synchrone :
    local result, err = statement:select(20)
    if not err then
        for index, row in rows(result, false) do
            ....
        end
    end
end
    </pre>

    
    <h3><a name="closing_databases" id="closing_databases">Fermeture d'une connexion  une base de donnes</a></h3>
        

    <p>Lorsqu'elles ne sont plus utilises, les connexions aux bases de
donnes doivent tre fermes avec <code>database:close()</code>. Si vous
ne les fermez pas manuellement, mod_lua les fermera peut-tre en tant
que rsidus collects, mais si ce n'est pas le cas, vous pouvez finir
pas avoir trop de connexions vers la base de donnes inutilises. Les
deux mesures suivantes sont pratiquement identiques :
    </p>
    <pre class="prettyprint lang-lua">
-- Mthode 1 : fermeture manuelle de la connexion
local database = r:dbacquire("mod_dbd")
database:close() -- c'est tout

-- Mthode 2 : on laisse le collecteur de rsidus la fermer
local database = r:dbacquire("mod_dbd")
database = nil -- on coupe le lien
collectgarbage() -- fermeture de la connexion par le collecteur de rsidus
</pre>

    
    <h3><a name="database_caveat" id="database_caveat">Prcautions  prendre lorsque l'on travaille avec les bases
de donnes</a></h3>
    
    <p>Bien que les fonctions <code>query</code> et <code>run</code>
soient toujours disponibles, il est recommand d'utiliser des requtes
prpares chaque fois que possible, afin d'une part d'optimiser les
performances (si votre connexion reste longtemps en vie), et d'autre part
minimiser le risque d'attaques par injection SQL. Les fonctions
<code>run</code> et <code>query</code> ne doivent tre utilises que
lorsque la requte ne contient pas de variables (requte statique). Dans
le cas des requtes dynamiques, utilisez <code>db:prepare</code> ou
<code>db:prepared</code>.
    </p>
    

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="LuaAuthzProvider" id="LuaAuthzProvider">LuaAuthzProvider</a> <a name="luaauthzprovider" id="luaauthzprovider">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Branche une fonction fournisseur d'autorisation dans <code class="module"><a href="../mod/mod_authz_core.html">mod_authz_core</a></code>
</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LuaAuthzProvider provider_name /path/to/lua/script.lua function_name</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Exprimental</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_lua</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.4.3 du serveur HTTP Apache</td></tr>
</table>
<p>Lorsqu'une fonction lua a t enregistre en tant que fournisseur
d'autorisation, elle peut tre appele via la directive <code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code> :</p>


<div class="example"><pre class="prettyprint lang-config">
LuaRoot /usr/local/apache2/lua
LuaAuthzProvider foo authz.lua authz_check_foo
&lt;Location /&gt;
  Require foo bar
&lt;/Location&gt;
</pre>
</div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="LuaHookAccessChecker" id="LuaHookAccessChecker">LuaHookAccessChecker</a> <a name="luahookaccesschecker" id="luahookaccesschecker">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Fournit un point d'entre pour la phase access_checker du
traitement de la requte</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LuaHookAccessChecker  /chemin/vers/lua/script.lua  hook_function_name [early|late]</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Exprimental</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_lua</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Le troisime argument optionnel est disponible depuis la
version 2.3.15 du serveur HTTP Apache.</td></tr>
</table>
<p>Ajoute votre fonction d'accroche  la phase access_checker. Une
fonction d'accroche access checker renvoie en gnral OK, DECLINED, ou
HTTP_FORBIDDEN.</p>
<div class="note"><h3>Ordonnancement</h3><p>Les arguments optionnels
   "early" ou "late" permettent de contrler le moment auquel ce script
   s'excute par rapport aux autres modules.</p></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="LuaHookAuthChecker" id="LuaHookAuthChecker">LuaHookAuthChecker</a> <a name="luahookauthchecker" id="luahookauthchecker">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Fournit un point d'entre pour la phase auth_checker du
traitement de la requte</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LuaHookAuthChecker  /chemin/vers/lua/script.lua hook_function_name [early|late]</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Exprimental</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_lua</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Le troisime argument optionnel est disponible depuis la
version 2.3.15 du serveur HTTP Apache.</td></tr>
</table>
<p>Invoque une fonction lua au cours de la phase auth_checker du
traitement de la requte. Cette directive peut s'utiliser pour
implmenter une vrification arbitraire de l'authentification et de
l'autorisation. Voici un exemple trs simple :
</p>
<pre class="prettyprint lang-lua">
require 'apache2'

-- fonction d'accroche authcheck fictive
-- Si la requte ne contient aucune donne d'authentification, l'en-tte
-- de la rponse est dfini et un code 401 est renvoy afin de demander au
-- navigateur d'effectuer une authentification basique. Si la requte
-- comporte des donnes d'authentification, elles ne sont pas vraiment
-- consultes, mais on admet la prise en compte de l'utilisateur 'foo' et
-- on la valide. On vrifie ensuite si l'utilisateur est bien 'foo' et on
-- accepte la requte.
function authcheck_hook(r)

   -- recherche des informations d'authentification
   auth = r.headers_in['Authorization']
   if auth ~= nil then
     -- dfinition d'un utilisateur par dfaut
     r.user = 'foo'
   end

   if r.user == nil then
      r:debug("authcheck: user is nil, returning 401")
      r.err_headers_out['WWW-Authenticate'] = 'Basic realm="WallyWorld"'
      return 401
   elseif r.user == "foo" then
      r:debug('user foo: OK')
   else
      r:debug("authcheck: user='" .. r.user .. "'")
      r.err_headers_out['WWW-Authenticate'] = 'Basic realm="WallyWorld"'
      return 401
   end
   return apache2.OK
end
</pre>

<div class="note"><h3>Ordonnancement</h3><p>Les arguments optionnels
   "early" ou "late" permettent de contrler le moment auquel ce script
   s'excute par rapport aux autres modules.</p></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="LuaHookCheckUserID" id="LuaHookCheckUserID">LuaHookCheckUserID</a> <a name="luahookcheckuserid" id="luahookcheckuserid">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Fournit un point d'entre pour la phase check_user_id du
traitement de la requte</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LuaHookCheckUserID  /chemin/vers/lua/script.lua hook_function_name [early|late]</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Exprimental</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_lua</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Le troisime argument optionnel est disponible depuis la
version 2.3.15 du serveur HTTP Apache.</td></tr>
</table><p>...</p>
   <div class="note"><h3>Ordonnancement</h3><p>Les arguments optionnels
   "early" ou "late" permettent de contrler le moment auquel ce script
   s'excute par rapport aux autres modules.</p></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="LuaHookFixups" id="LuaHookFixups">LuaHookFixups</a> <a name="luahookfixups" id="luahookfixups">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Fournit un point d'entre pour la phase de correction du
traitement de la requte</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LuaHookFixups  /chemin/vers/lua/script.lua hook_function_name</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Exprimental</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_lua</td></tr>
</table>
<p>
    Idem LuaHookTranslateName, mais s'excute durant la phase de
    correction.
</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="LuaHookInsertFilter" id="LuaHookInsertFilter">LuaHookInsertFilter</a> <a name="luahookinsertfilter" id="luahookinsertfilter">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Fournit un point d'entre pour la phase insert_filter du
traitement de la requte</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LuaHookInsertFilter  /chemin/vers/lua/script.lua hook_function_name</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Exprimental</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_lua</td></tr>
</table><p>Non encore implment</p>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="LuaHookMapToStorage" id="LuaHookMapToStorage">LuaHookMapToStorage</a> <a name="luahookmaptostorage" id="luahookmaptostorage">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Fournit un point d'entre pour la phase map_to_storage du
traitement de la requte</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LuaHookMapToStorage  /chemin/vers/lua/script.lua hook_function_name</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Exprimental</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_lua</td></tr>
</table><p>...</p>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="LuaHookTranslateName" id="LuaHookTranslateName">LuaHookTranslateName</a> <a name="luahooktranslatename" id="luahooktranslatename">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Fournit un point d'entre  la phase du nom de
traduction du traitement de la requte</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LuaHookTranslateName  /chemin/vers/lua/script.lua  nom_fonction_hook [early|late]</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Exprimental</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_lua</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Le troisime argument optionnel est disponible depuis la
version 2.3.15 du serveur HTTP Apache.</td></tr>
</table><p>
    Cette directive permet d'ajouter un point d'entre (
    APR_HOOK_MIDDLE)  la phase du nom de traduction du traitement de la
    requte. La fonction hook accepte un seul argument, le request_rec,
    et doit renvoyer un code d'tat qui est soit un code d'erreur HTTP,
    ou une constante dfinie dans le module apache2 :  apache2.OK,
    apache2.DECLINED, ou apache2.DONE.</p>

    <p>Pour ceux qui ne sont pas familiers avec les points d'entre
    (hook), en gros, chaque hook sera invoqu jusqu' ce que l'un
    d'entre eux renvoie apache2.OK. Si un hook n'effectuer pas la
    traduction, il doit juste renvoyer apache2.DECLINED. Si le
    traitement de la requte doit tre interrompu, la valeur renvoye
    doit tre apache2.DONE.</p>

    <p>Exemple :</p>

<pre class="prettyprint lang-config">
# httpd.conf
LuaHookTranslateName /scripts/conf/hooks.lua silly_mapper
</pre>


<pre class="prettyprint lang-lua">
-- /scripts/conf/hooks.lua --
require "apache2"
function silly_mapper(r)
    if r.uri == "/" then
        r.filename = "/var/www/home.lua"
        return apache2.OK
    else
        return apache2.DECLINED
    end
end
</pre>


   <div class="note"><h3>Contexte</h3><p>Cette directive ne peut tre
   utilise ni  l'intrieur d'une section <code class="directive"><a href="../mod/core.html#directory">&lt;Directory&gt;</a></code> ou <code class="directive"><a href="../mod/core.html#files">&lt;Files&gt;</a></code>, ni dans un fichier htaccess.</p></div>

   <div class="note"><h3>Ordonnancement</h3><p>Les arguments optionnels
   "early" ou "late" permettent de contrler le moment auquel ce script
   s'excute par rapport aux autres modules.</p></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="LuaHookTypeChecker" id="LuaHookTypeChecker">LuaHookTypeChecker</a> <a name="luahooktypechecker" id="luahooktypechecker">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Fournit un point d'entre pour la phase type_checker du
traitement de la requte</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LuaHookTypeChecker  /chemin/vers/lua/script.lua hook_function_name</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Exprimental</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_lua</td></tr>
</table><p>...</p>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="LuaInherit" id="LuaInherit">LuaInherit</a> <a name="luainherit" id="luainherit">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Contrle la manire dont les sections de configuration
parentes sont fusionnes dans les enfants</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LuaInherit none|parent-first|parent-last</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>LuaInherit parent-first</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Exprimental</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_lua</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Versions 2.4.0 et suprieures</td></tr>
</table><p>Par dfaut, si des directives LuaHook* se trouvent dans
    des sections de configuration Directory ou Location qui se
    chevauchent, les scripts
    dfinis dans les sections les plus spcifiques s'excutent
    <em>aprs</em> ceux dfinis dans les sections plus gnriques
    (LuaInherit parent-first). Vous pouvez inverser cet ordre, ou faire
    en sorte que le contexte parent ne s'applique pas du tout.</p>

    <p>Jusqu'aux versions 2.3.x, le comportement par dfaut consistait 
    ignorer les directives LuaHook* situes dans les sections de
    configuration parentes.</p>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="LuaPackageCPath" id="LuaPackageCPath">LuaPackageCPath</a> <a name="luapackagecpath" id="luapackagecpath">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Ajoute un rpertoire au package.cpath de lua</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LuaPackageCPath /chemin/vers/include/?.soa</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Exprimental</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_lua</td></tr>
</table>
    <p>Cette directive permet d'ajouter un chemin  la liste des chemins
    de recherche des bibliothques partages de lua. Ceci modifie le
    package.cpath dans les vms lua.</p>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="LuaPackagePath" id="LuaPackagePath">LuaPackagePath</a> <a name="luapackagepath" id="luapackagepath">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Ajoute un rpertoire au package.path de lua</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LuaPackagePath /chemin/vers/include/?.lua</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Exprimental</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_lua</td></tr>
</table><p>Cette directive permet d'ajouter un chemin  la liste des
    chemins de recherche du module lua. Elle suit les mmes conventions
    que lua. Ceci modifie le package.path dans les vms lua.</p>

    <div class="example"><h3>Exemples :</h3><pre class="prettyprint lang-config">
LuaPackagePath /scripts/lib/?.lua
LuaPackagePath /scripts/lib/?/init.lua
    </pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="LuaQuickHandler" id="LuaQuickHandler">LuaQuickHandler</a> <a name="luaquickhandler" id="luaquickhandler">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Fournit un point d'entre pour la gestion rapide du
traitement de la requte</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LuaQuickHandler /path/to/script.lua hook_function_name</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Exprimental</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_lua</td></tr>
</table><p>...</p>
   <div class="note"><h3>Contexte</h3><p>Cette directive ne peut tre
   utilise ni  l'intrieur d'une section <code class="directive"><a href="../mod/core.html#directory">&lt;Directory&gt;</a></code> ou <code class="directive"><a href="../mod/core.html#files">&lt;Files&gt;</a></code>, ni dans un fichier htaccess.</p></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="LuaRoot" id="LuaRoot">LuaRoot</a> <a name="luaroot" id="luaroot">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Spcifie le chemin de base pour la rsolution des chemins
relatifs dans les directives de mod_lua</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LuaRoot /chemin/vers/un/rpertoire</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Exprimental</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_lua</td></tr>
</table>
    <p>Cette directive permet de spcifier le chemin de base qui sera
    utilis pour valuer tous les chemins relatifs dans mod_lua. En
    l'absence de cette directive, les chemins relatifs sont rsolus par
    rapport au rpertoire de travail courant, ce qui ne sera pas
    toujours appropri pour un serveur.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="LuaScope" id="LuaScope">LuaScope</a> <a name="luascope" id="luascope">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Une valeur parmi once, request, conn, thread -- la valeur
par dfaut est once</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LuaScope once|request|conn|thread -- la valeur par dfaur est
once</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>LuaScope once</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Exprimental</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_lua</td></tr>
</table>
    <p>Cette directive permet de spcifier la dure de vie de
    l'interprteur Lua qui sera utilis dans ce "rpertoire". La valeur
    par dfaut est "once".</p>

   <dl>
    <dt>once:</dt> <dd>utilise l'interprteur une fois.</dd>

    <dt>request:</dt> <dd>utilise l'interprteur pour traiter tout ce
    qui est bas sur le mme fichier dans la requte, et qui se trouve
    aussi dans la porte de la requte.</dd>

    <dt>conn:</dt> <dd>idem request, mais attach  connection_rec</dd>
    <dt>thread:</dt> <dd>Utilise l'interprteur pendant toute la dure
    de vie du thread qui traite la requte (disponible seulement avec
    les MPMs threads).</dd>

   </dl>

</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_lua.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_lua.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_lua.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2013 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>