<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Tutoriel Apache : Contenu dynamique bas sur CGI - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Recettes et tutoriels</a></div><div id="page-content"><div id="preamble"><h1>Tutoriel Apache : Contenu dynamique bas sur CGI</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/howto/cgi.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/howto/cgi.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/howto/cgi.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/howto/cgi.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div>
<div class="outofdate">Cette traduction peut tre prime. Vrifiez la version
            anglaise pour les changements rcents.</div>
</div>
<div id="quickview"><ul id="toc"><li><img alt="" src="../images/down.gif" /> <a href="#intro">Introduction</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#configuring">Configurer Apache pour autoriser CGI</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#writing">Ecrire un programme CGI</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#troubleshoot">Mais a ne marche toujours pas !</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#behindscenes">Que se passe-t-il en coulisse</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#libraries">Bibliothques et modules CGI</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#moreinfo">Pour plus d'informations</a></li>
</ul><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="intro" id="intro">Introduction</a></h2>
    

    <table class="related"><tr><th>Modules Apparents</th><th>Directives Apparentes</th></tr><tr><td><ul><li><code class="module"><a href="../mod/mod_alias.html">mod_alias</a></code></li><li><code class="module"><a href="../mod/mod_cgi.html">mod_cgi</a></code></li></ul></td><td><ul><li><code class="directive"><a href="../mod/mod_mime.html#addhandler">AddHandler</a></code></li><li><code class="directive"><a href="../mod/core.html#options">Options</a></code></li><li><code class="directive"><a href="../mod/mod_alias.html#scriptalias">ScriptAlias</a></code></li></ul></td></tr></table>

    <p>CGI (Common Gateway Interface) dfinit une mthode d'interaction
    entre un serveur web et des programmes gnrateurs de contenu
    externes, plus souvent appels programmes CGI ou scripts CGI. Il
    s'agit de la mthode la plus simple, et la plus
    courante, pour ajouter du contenu dynamique  votre site web. Ce
    document est une introduction  la configuration de CGI sur votre
    serveur web Apache, et une initiation  l'criture de programmes
    CGI.</p>
  </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="configuring" id="configuring">Configurer Apache pour autoriser CGI</a></h2>
    

    <p>Apache doit tre configur pour permettre l'excution des
    programmes CGI, pour que vos programmes CGI puissent fonctionner
    correctement. Il existe plusieurs mthodes pour y parvenir.</p>

    <div class="warning">Note: si Apache a t compil avec le support
    des modules partags (DSO), vous devez vous assurer que le module CGI est
    charg ; vous devez pour cela vrifier que la directive <code class="directive"><a href="../mod/mod_so.html#loadmodule">LoadModule</a></code> correspondante n'a pas t
    commente dans votre <code>httpd.conf</code>. Une directive correcte
    doit ressembler  ceci :

    <pre class="prettyprint lang-config">
      LoadModule cgi_module modules/mod_cgi.so
    </pre>
</div>

    <h3><a name="scriptalias" id="scriptalias">ScriptAlias</a></h3>
      

      <p>La directive <code class="directive"><a href="../mod/mod_alias.html#scriptalias">ScriptAlias</a></code> indique  Apache qu'un
      rpertoire particulier est ddi aux programmes CGI. Apache
      considrera que tout fichier situ dans ce rpertoire est un
      programme CGI, et tentera de l'excuter lorsque cette ressource
      fera l'objet d'une requte client.</p>

      <p>La directive <code class="directive"><a href="../mod/mod_alias.html#scriptalias">ScriptAlias</a></code> se prsente comme suit
      :</p>

      <pre class="prettyprint lang-config">
        ScriptAlias /cgi-bin/ /usr/local/apache2/cgi-bin/
      </pre>


      <p>Cet exemple est tir de votre fichier de configuration
      <code>httpd.conf</code> par dfaut, si vous avez install Apache
      dans son rpertoire par dfaut. La directive <code class="directive"><a href="../mod/mod_alias.html#scriptalias">ScriptAlias</a></code> est similaire  la
      directive <code class="directive"><a href="../mod/mod_alias.html#alias">Alias</a></code>, qui
      dfinit  quel rpertoire particulier doit correspondre un prfixe
      d'URL. <code class="directive">Alias</code> et
      <code class="directive">ScriptAlias</code> sont gnralement utiliss pour
      accder  des rpertoires situs en dehors du rpertoire dfini
      par la directive <code class="directive"><a href="../mod/core.html#documentroot">DocumentRoot</a></code>. La diffrence entre
      <code class="directive">Alias</code> et <code class="directive">ScriptAlias</code>
      rside dans le fait que <code class="directive">ScriptAlias</code> indique
      en plus que tout ce qui se trouve sous le prfixe d'URL doit tre
      considr comme un programme CGI. Ainsi, l'exemple ci-dessus
      indique  Apache que toute requte pour une ressource commenant
      par <code>/cgi-bin/</code> doit tre servie depuis le rpertoire
      <code>/usr/local/apache2/cgi-bin/</code>, et doit tre traite en
      tant que programme CGI.</p>

      <p>Par exemple, si une requte pour l'URL
      <code>http://www.example.com/cgi-bin/test.pl</code> est
      effectue, Apache tentera d'excuter le fichier
      <code>/usr/local/apache2/cgi-bin/test.pl</code> et en renverra la
      sortie. Bien entendu, le fichier doit exister, tre excutable, et
      retourner sa sortie d'une manire particulire, sinon Apache
      renverra un message d'erreur.</p>
    

    <h3><a name="nonscriptalias" id="nonscriptalias">CGI en dehors des rpertoires ScripAlias</a></h3>
      

      <p>Pour des raisons de scurit, la localisation des programmes
      CGI est souvent restreinte aux
      rpertoires dfinis par <code class="directive"><a href="../mod/mod_alias.html#scriptalias">ScriptAlias</a></code>. De cette manire, les administrateurs
      peuvent contrler prcisment qui est autoris  utiliser les
      programmes CGI. Cependant, si les prcautions adquates quant 
      la scurit sont prises, il n'y a aucune raison pour que les
      programmes CGI ne puissent pas tre excuts depuis d'autres
      rpertoires. Par exemple, vous pouvez autoriser les utilisateurs 
      enregistrer des contenus web dans leurs rpertoires home  l'aide
      de la directive <code class="directive"><a href="../mod/mod_userdir.html#userdir">UserDir</a></code>. S'ils veulent mettre en
      oeuvre leurs propres programmes CGI, mais n'ont pas l'autorisation
      d'accs au rpertoire <code>cgi-bin</code> principal, ils devront
      tre en mesure d'excuter ces programmes depuis un autre
      rpertoire.</p>

      <p>L'autorisation d'excution des programmes CGI dans un
      rpertoire arbitraire se fait en deux tapes. En premier lieu, le
      gestionnaire <code>cgi-script</code> doit tre activ  l'aide
      d'une directive <code class="directive"><a href="../mod/mod_mime.html#addhandler">AddHandler</a></code> ou <code class="directive"><a href="../mod/core.html#sethandler">SetHandler</a></code>. En second lieu,
      <code>ExecCGI</code> doit tre spcifi dans la directive <code class="directive"><a href="../mod/core.html#options">Options</a></code>.</p>
    

    <h3><a name="options" id="options">Utilisation d'options explicites pour permettre l'excution
      des programmes CGI</a></h3>
      

      <p>Vous pouvez utiliser de manire explicite la directive
      <code class="directive"><a href="../mod/core.html#options">Options</a></code> dans le fichier de
      configuration de votre serveur principal, pour indiquer que
      l'excution des programmes CGI est permise depuis un rpertoire
      particulier :</p>

      <pre class="prettyprint lang-config">
&lt;Directory /usr/local/apache2/htdocs/somedir&gt;
    Options +ExecCGI
&lt;/Directory&gt;
      </pre>


      <p>La directive ci-dessus indique  Apache qu'il doit permettre
      l'excution des fichiers CGI. Vous devez aussi indiquer au serveur
      quels fichiers sont des fichiers CGI. La directive <code class="directive"><a href="../mod/mod_mime.html#addhandler">AddHandler</a></code> suivante indique au
      serveur qu'il doit traiter tous les fichiers possdant une
      extension <code>cgi</code> ou <code>pl</code> en tant que
      programmes CGI :</p>

      <pre class="prettyprint lang-config">
        AddHandler cgi-script .cgi .pl
      </pre>

    

    <h3><a name="htaccess" id="htaccess">Fichiers .htaccess</a></h3>
      

      <p>Le <a href="htaccess.html"><code>tutoriel
      .htaccess</code></a> montre comment activer les programmes
      CGI si vous n'avez pas accs au
      fichier <code>httpd.conf</code>.</p>
    

    <h3><a name="userdir" id="userdir">Rpertoires utilisateurs</a></h3>
      

      <p>Pour permettre l'excution en tant que programme CGI de tout
      fichier possdant l'extension <code>.cgi</code> et situ dans un
      rpertoire utilisateur, vous pouvez utiliser la configuration
      suivante :</p>

      <pre class="prettyprint lang-config">
&lt;Directory /home/*/public_html&gt;
    Options +ExecCGI
    AddHandler cgi-script .cgi
&lt;/Directory&gt;
      </pre>


      <p>Pour indiquer un sous-rpertoire <code>cgi-bin</code> d'un
      rpertoire utilisateur o tout fichier sera trait en tant que
      programme CGI, vous pouvez utiliser ceci :</p>

      <pre class="prettyprint lang-config">
&lt;Directory /home/*/public_html/cgi-bin&gt;
    Options ExecCGI
    SetHandler cgi-script
&lt;/Directory&gt;
      </pre>


    

  </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="writing" id="writing">Ecrire un programme CGI</a></h2>
    

    <p>Il y a deux diffrences principales entre la programmation
    "standard" et la programmation CGI.</p>

    <p>En premier lieu, toute sortie de votre programme CGI doit tre
    prcde d'un en-tte <a class="glossarylink" href="../glossary.html#mime-type" title="voir glossaire">MIME-type</a>. Il s'agit d'un
    en-tte HTTP qui indique au client quel type de contenu il reoit.
    La plupart du temps, il se prsente comme suit :</p>

    <div class="example"><p><code>
      Content-type: text/html
    </code></p></div>

    <p>En second lieu, votre sortie doit tre en HTML, ou tout autre
    format qu'un navigateur est en mesure d'afficher. La plupart du
    temps, il s'agira de HTML, mais occasionnellement, vous pouvez tre
    amen  crire un programme CGI qui renvoie une image gif, ou un
    autre type de contenu non-HTML.</p>

    <p>A part ces deux diffrences, un programme CGI ressemblera  tout
    autre programme que vous pourriez tre amen  crire.</p>

    <h3><a name="firstcgi" id="firstcgi">Votre premier programme CGI</a></h3>
      

      <p>L'exemple suivant est un exemple de programme CGI qui permet
      d'afficher une ligne de caractres dans votre navigateur. Ecrivez
      ce qui suit, enregistrez le dans un fichier nomm
      <code>premier.pl</code>, et placez le dans votre rpertoire
      <code>cgi-bin</code>.</p>

      <pre class="prettyprint lang-perl">
#!/usr/bin/perl
print "Content-type: text/html\n\n";
print "Hello, World.";
      </pre>


      <p>Mme si Perl ne vous est pas familier, vous devriez tre
      capable de comprendre le fonctionnement de ce programme. La
      premire ligne indique  Apache (ou  toute interface  partir de
      laquelle le programme s'excute) que ce programme peut tre
      excut en fournissant son fichier  l'interprteur
      <code>/usr/bin/perl</code>. La seconde ligne affiche la
      dclaration du type de contenu considr, suivie de deux paires
      "Retour chariot - Nouvelle ligne". Ceci a pour effet d'insrer une
      ligne vide aprs l'en-tte pour marquer la fin des en-ttes HTTP,
      et le dbut du corps du document. La troisime ligne affiche la
      chane de caractres "Bonjour tout le monde . . .". Et c'est tout
      ce dont vous avez besoin.</p>

      <p>Si vous ouvrez votre navigateur favori et lui indiquez
      l'adresse</p>

      <div class="example"><p><code>
        http://www.example.com/cgi-bin/premier.pl
      </code></p></div>

      <p>ou toute autre URL correspondant  votre programme CGI, Vous
      verrez la ligne <code>Bonjour tout le monde . . .</code>
      s'afficher dans la fentre de votre navigateur. Ce n'est pas
      extraordinaire, mais si vous y tes parvenu, vous avez de bonnes
      chances d'y parvenir pour tout autre programme plus
      sophistiqu.</p>
    
  </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="troubleshoot" id="troubleshoot">Mais a ne marche toujours pas !</a></h2>
    

    <p>Vous devriez voir au moins une des quatre sorties suivantes dans
    votre navigateur lorsque vous essayez d'accder  votre programme
    CGI depuis le web :</p>

    <dl>
      <dt>Le flux de sortie de votre programme CGI</dt>
      <dd>Impeccable ! Cela signifie que tout fonctionne correctement.
      Si la sortie est correcte mais n'est pas traite correctement par
      le navigateur, assurez-vous d'avoir dfini
      <code>Content-Type</code> de manire approprie dans votre
      programme CGI.</dd>

      <dt>Le code source de votre programme CGI ou un message "POST
      Method Not Allowed"</dt>
      <dd>Cela signifie que vous n'avez pas configur Apache de manire
       ce qu'il puisse traiter votre programme CGI. Relisez la section
      sur la <a href="#configuring">configuration d'Apache</a>, et
      essayez de trouver votre erreur.</dd>

      <dt>Un message commenant par "Forbidden"</dt>
      <dd>Ce type de message est rvlateur d'un problme de
      droits. Consultez le <a href="#errorlogs">journal des erreurs
      d'Apache</a> et la section ci-dessous sur les <a href="#permissions">droits des fichiers</a>.</dd>

      <dt>Un message contenant "Internal Server Error"</dt>
      <dd>Si vous consultez le <a href="#errorlogs">journal des erreurs
      d'Apache</a>, vous y trouverez probablement des messages du type
      "Premature end of script headers" (Fin prmature des en-ttes de
      script), ventuellement accompagns d'un message d'erreur gnr
      par votre programme CGI. Dans ce cas, il va vous falloir lire
      chacune des sections ci-dessous pour dterminer ce qui empche
      votre programme CGI de gnrer les en-ttes appropris.</dd>
    </dl>

    <h3><a name="permissions" id="permissions">Droits des fichiers</a></h3>
      

      <p>Souvenez-vous que le serveur ne s'excute pas sous votre nom.
      En d'autres termes, lorsque le serveur a dmarr, il s'excute
      avec les droits d'un utilisateur non privilgi - en gnral
      <code>nobody</code>, ou <code>www</code> - et en consquence, il
      aura besoin de droits supplmentaires pour pouvoir excuter des
      fichiers dont vous tes le propritaire. En gnral, pour qu'un
      fichier ait des droits suffisants pour tre excutable par
      <code>nobody</code>, il suffit de lui attribuer des droits
      d'excution pour tout le monde :</p>

      <div class="example"><p><code>
        chmod a+x premier.pl
      </code></p></div>

      <p>En outre, si votre programme doit pouvoir accder en lecture
      et/ou criture  d'autres fichiers, ces derniers devront avoir les
      droits appropris.</p>

    

    <h3><a name="pathinformation" id="pathinformation">Chemin des excutables (PATH) et variables
      d'environnement</a></h3>
      

      <p>Lorsque vous lancez un programme depuis la ligne de commande,
      certaines informations sont passes au shell sans que vous vous en
      doutiez. Par exemple, la variable <code>PATH</code> indique au
      shell o il doit rechercher les excutables auxquels vous faites
      rfrence.</p>

      <p>Lorsqu'un programme s'excute depuis le serveur web en tant que
      programme CGI, sa variable <code>PATH</code> n'aura peut-tre pas
      la mme valeur. Tout programme que vous invoquez dans votre
      programme CGI ( comme par exemple <code>sendmail</code>) devra
      tre spcifi par son chemin complet, de faon  ce que le shell
      puisse le trouver lorsqu'il tentera d'excuter votre programme
      CGI.</p>

      <p>Un exemple typique de spcification de programme est le chemin
      vers l'interprteur de script (souvent <code>perl</code>) que l'on
      trouve  la premire ligne de votre programme CGI et qui va
      ressembler  ceci :</p>

      <pre class="prettyprint lang-perl">
        #!/usr/bin/perl
      </pre>


      <p>Assurez-vous qu'il s'agit bien du chemin correct vers
      l'interprteur.</p>

      <div class="warning">
      Lors de l'dition de scripts CGI sous Windows, il se peut que des
      caractres de fin de ligne soient ajouts au chemin de
      l'interprteur. Assurez-vous donc que les fichiers sont bien
      transmis au serveur en mode ASCII. Dans le cas contraire, l'OS
      pourra envoyer des avertissements "Command not found"  cause des
      caractres de fin de ligne non reconnus car considrs comme
      faisant partie du nom de fichier de l'interprteur.
      </div>

      

    <h3><a name="missingenv" id="missingenv">Variables d'environnement manquantes</a></h3>
      

      <p>Si votre programme CGI dpend de <a href="#env">variables
      d'environnement</a> non standards, vous devrez vous assurez que
      ces variables lui sont bien transmises par Apache.</p>

      <p>Lorsque des en-ttes HTTP ne sont pas transmis 
      l'environnement, assurez-vous qu'ils sont bien formats selon la
      <a href="http://tools.ietf.org/html/rfc2616">RFC 2616</a>, section
      4.2 : les noms d'en-ttes doivent commencer par une lettre,
      elle-mme suivie de lettres, chiffres ou traits d'union. Tout
      en-tte dont le nom viole cette rgle sera ignor.</p>

    

    <h3><a name="syntaxerrors" id="syntaxerrors">Erreurs inhrentes au programme</a></h3>
      

      <p>La plupart des checs dans l'excution d'un programme CGI
      proviennent du programme lui-mme. Ceci est particulirement vrai
      lorsque ce satan programme CGI se bloque, alors que vous avez
      appris  ne plus commettre les deux erreurs prcdentes. La
      premire chose  faire est de vous assurer que votre programme
      s'excute depuis la ligne de commande, avant de le tester  partir
      du serveur web. Par exemple, essayez :</p>

      <div class="example"><p><code>
      cd /usr/local/apache2/cgi-bin<br />
      ./premier.pl
      </code></p></div>

      <p>(N'invoquez pas l'interprteur <code>perl</code>. Le shell et
      Apache doivent tre capable de le dterminer  partir de <a href="#pathinformation">l'information sur le chemin</a> situe sur
      la premire ligne du script.)</p>

      <p>La premire chose que vous devriez voir affiche par votre
      programme est un ensemble d'en-ttes HTTP, comprenant entre autres
      le <code>Content-Type</code>, et suivi d'une ligne vide. Si vous
      voyez quoi que ce soit d'autre, Apache renverra l'erreur
      <code>Premature end of script headers</code> si vous tentez
      d'excuter le programme depuis le serveur. Voir <a href="#writing">Ecriture d'un programme CGI</a> ci-dessus pour
      plus de dtails.</p>
    

    <h3><a name="errorlogs" id="errorlogs">Journalisation des erreurs</a></h3>
      

      <p>Les journaux d'erreurs sont vos amis. Toute anomalie de
      fonctionnement est consigne dans le journal des erreurs et c'est
      ici que vous devez regarder en premier en cas de problme. Si
      l'hbergeur de votre site ne vous donne pas accs au journal des
      erreurs, vous avez tout intrt  vous tourner vers quelqu'un
      d'autre. Apprenez  dchiffrer les journaux d'erreurs, et vous
      vous apercevrez que la plupart des problmes seront rapidement
      identifis . . . et rsolus.</p>
    

    <h3><a name="suexec" id="suexec">Suexec</a></h3>
      

      <p>Le programme <a href="../suexec.html">suexec</a> permet
      d'excuter les programmes CGI avec des droits diffrents selon le
      serveur virtuel ou le rpertoire utilisateur dans lequel ils
      se situent. Suexec effectue une vrification des droits trs
      stricte, et toute anomalie dtecte au cours de cette vrification
      entranera un echec d'excution de votre programme CGI avec
      affichage de l'erreur <code>Premature end of script
      headers</code>.</p>

      <p>Pour savoir si vous pouvez utiliser suexec, tapez la commande
      <code>apachectl -V</code>, et regardez le chemin indiqu par
      <code>SUEXEC_BIN</code>. Si au dmarrage d'Apache, ce dernier
      trouve un excutable <code class="program"><a href="../programs/suexec.html">suexec</a></code> dans ce chemin,
      suexec sera activ.</p>

      <p>Si vous ne matrisez pas le fonctionnement de suexec, il vous
      est dconseill de l'utiliser. Pour dsactiver suexec, supprimer
      simplement (ou renommez) l'excutable <code class="program"><a href="../programs/suexec.html">suexec</a></code>
      point par <code>SUEXEC_BIN</code> et redmarrez le serveur. Si
      aprs une lecture de <a href="../suexec.html">suexec</a>, vous
      dcidez quand-mme de l'utiliser, tapez la commande <code>suexec
      -V</code> pour voir o se situe le journal de suexec, et utilisez
      ce dernier pour dterminer quelles rgles vous violez
      ventuellement.</p>
    
  </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="behindscenes" id="behindscenes">Que se passe-t-il en coulisse</a></h2>
    

    <p>Lorsque vos comptences en programmation CGI seront plus
    pousses, il s'avrera intressant pour vous de mieux comprendre ce
    qui se passe en coulisse, et en particulier la manire dont le
    navigateur et le serveur dialoguent entre eux. En effet, bien qu'il
    soit tout  fait louable d'crire un programme qui affiche "Bonjour
    tout le monde . . .", cela ne sert pas  grand chose.</p>

    <h3><a name="env" id="env">Variables d'environnement</a></h3>
      

      <p>Les variables d'environnement sont des valeurs qui gravitent
      autour de vous lorsque vous utilisez votre ordinateur. Elles sont
      trs utiles,  l'instar de votre chemin par dfaut (o votre
      ordinateur va rechercher le fichier physique correspondant  la
      commande que vous avez tape), votre nom d'utilisateur, le type de
      votre terminal, etc... Pour obtenir une liste complte des
      variables d'environnement standards que vous utilisez tous les
      jours, tapez <code>env</code> dans votre interprteur
      de commandes.</p>

      <p>Au cours de la transaction CGI, le serveur et le navigateur
      dfinissent aussi des variables d'environnement, de faon  ce
      qu'ils puissent communiquer entre eux. Ces variables dfinissent
      entre autre le type de navigateur (Netscape, IE, Lynx), le type de
      serveur (Apache, IIS, WebSite), le nom du programme CGI en cours
      d'excution, etc...</p>

      <p>Ces variables sont  la disposition du programmeur CGI, et
      elles constituent 50% de la communication client-serveur. La liste
      complte des variables requises se trouve 
      <a href="http://www.ietf.org/rfc/rfc3875">Common Gateway
      Interface RFC</a>.</p>

      <p>Ce programme CGI basique en Perl permet d'afficher toutes les
      variables d'environnement qui sont changes. Deux programmes
      similaires sont fournis avec la distribution d'Apache et situs
      dans le rpertoire <code>cgi-bin</code>.
      Notez que certaines variables sont
      obligatoires, alors que d'autres sont optionnelles, si bien que
      vous verrez s'afficher certaines variables qui ne font pas partie
      de la liste officielle. De plus, Apache vous propose de nombreuses
      mthodes pour <a href="../env.html">ajouter vos propres
      variables d'environnement</a> aux variables de base fournies par
      dfaut.</p>

      <pre class="prettyprint lang-perl">
#!/usr/bin/perl
print "Content-type: text/html\n\n";
foreach $key (keys %ENV) {
    print "$key --&gt; $ENV{$key}&lt;br&gt;";
}
      </pre>

    

    <h3><a name="stdin" id="stdin">STDIN et STDOUT</a></h3>
      

      <p>L'entre standard (<code>STDIN</code>) et la sortie standard
      (<code>STDOUT</code>) constituent d'autres voies de communication
      entre le client et le serveur. Dans un contexte normal,
      <code>STDIN</code> correspond au clavier, ou  un fichier fourni
      au programme  des fins de traitement, et <code>STDOUT</code>  la
      console ou  l'cran.</p>

      <p>Lorsque vous transmettez un formulaire web  un programme CGI
      par la mthode <code>POST</code>, les donnes de ce formulaire
      sont transcrites dans un format spcial et transmises  votre
      programme CGI via <code>STDIN</code>. Le programme peut alors les
      traiter comme si elles provenaient du clavier ou d'un
      fichier.</p>

      <p>Ce "format spcial" est trs simple. Un nom de champ et sa
      valeur sont relis entre eux par un signe "gal" (=), et chacune
      de ces paires nom champ/valeur est spare de la suivante par un
      "et" commercial (&amp;). Les caractres
      spciaux comme les espaces, les "et" commerciaux, et les signes
      "gal" sont convertis en leur quivalent hexadcimal pour viter
      qu'ils ne gchent le travail. La chane contenant les donnes doit
      ressembler  ceci :</p>

      <div class="example"><p><code>
        name=Rich%20Bowen&amp;city=Lexington&amp;state=KY&amp;sidekick=Squirrel%20Monkey
      </code></p></div>

      <p>Vous verrez aussi parfois une chane de ce type accole  une
      URL. Dans ce cas, le serveur enregistre cette chane dans la
      variable d'environnement appele <code>QUERY_STRING</code>. On a
      alors affaire  une requte de type <code>GET</code>. Votre
      formulaire HTML indique laquelle des mthodes <code>GET</code> ou
      <code>POST</code> est utilise pour transmettre les donnes, en
      dfinissant l'attribut <code>METHOD</code> au niveau de la balise
      <code>FORM</code>.</p>

      <p>Votre programme est ensuite charg d'extraire les informations
      utiles de cette chane. Heureusement, des bibliothques et des
      modules sont  votre disposition pour vous aider  traiter ces
      donnes, et  grer les diffrents aspects de votre programme
      CGI.</p>
    
  </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="libraries" id="libraries">Bibliothques et modules CGI</a></h2>
    

    <p>Pour crire un programme CGI, il vous est conseill d'utiliser
    une bibliothque de code, ou un module, qui effectueront une grande
    partie du travail de base pour vous. Ceci vous permettra de diminuer
    le nombre d'erreurs et d'acclrer le dveloppement.</p>

    <p>Si vous crivez des programmes CGI en Perl, des modules sont 
    votre disposition  <a href="http://www.cpan.org/">CPAN</a>. A ce
    sujet, le module le plus populaire est <code>CGI.pm</code>. Vous
    pouvez aussi essayer <code>CGI::Lite</code>, qui implmente les
    fonctionnalits strictement ncessaires, mais suffisantes pour
    la majorit des programmes.</p>

    <p>Si vous crivez des programmes CGI en C, vous disposez de
    nombreuses options. L'une d'elles est la bibliothque
    <code>CGIC</code> de <a href="http://www.boutell.com/cgic/">http://www.boutell.com/cgic/</a>.</p>
  </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="moreinfo" id="moreinfo">Pour plus d'informations</a></h2>
    

    <p>La spcification CGI actuelle est disponible dans la <a href="http://www.ietf.org/rfc/rfc3875">Common Gateway
    Interface RFC</a>.</p>

    <p>Lorsque vous postez une question  propos d'un problme CGI que
    vous rencontrez, que ce soit dans une liste de diffusion ou dans un
    newsgroup, faites en sorte de fournir suffisamment d'informations
    sur le problme rencontr, ce que vous attendiez exactement, et en
    quoi ce qui se produit est rellement diffrent de ce que vous
    attendiez, quel serveur vous utilisez, en quel langage votre
    programme CGI a t crit, et, si possible, son code source. Ceci
    permettra une rsolution plus aise de votre problme.</p>

    <p>Notez que les questions  propos de problmes CGI ne doivent
    <strong>jamais</strong> tre postes dans la base de donnes de
    bogues d'Apache,  moins que vous ne soyez sr d'avoir trouv un
    problme dans le code source d'Apache.</p>
  </div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/howto/cgi.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/howto/cgi.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/howto/cgi.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/howto/cgi.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/howto/cgi.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2012 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>