
#line 1 "../../src/hb-ot-shape-complex-indic-machine.rl"
/*
 * Copyright © 2011,2012  Google, Inc.
 *
 *  This is part of HarfBuzz, a text shaping library.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE COPYRIGHT HOLDER HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 * THE COPYRIGHT HOLDER SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE COPYRIGHT HOLDER HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * Google Author(s): Behdad Esfahbod
 */

#ifndef HB_OT_SHAPE_COMPLEX_INDIC_MACHINE_HH
#define HB_OT_SHAPE_COMPLEX_INDIC_MACHINE_HH

#include "hb-private.hh"


#line 36 "../../src/hb-ot-shape-complex-indic-machine.hh.tmp"
static const unsigned char _indic_syllable_machine_trans_keys[] = {
	1u, 16u, 13u, 13u, 5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 
	5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 4u, 4u, 6u, 6u, 
	16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 
	6u, 6u, 16u, 16u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 
	4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 1u, 16u, 13u, 13u, 5u, 7u, 5u, 7u, 
	7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 
	5u, 7u, 7u, 7u, 4u, 4u, 6u, 6u, 16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 
	4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 14u, 4u, 14u, 
	4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 
	1u, 16u, 13u, 13u, 5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 
	5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 4u, 4u, 6u, 6u, 
	16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 
	6u, 6u, 16u, 16u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 
	4u, 14u, 4u, 14u, 4u, 14u, 1u, 16u, 13u, 13u, 5u, 7u, 5u, 7u, 7u, 7u, 
	5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 
	7u, 7u, 4u, 4u, 6u, 6u, 16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 
	6u, 6u, 16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 14u, 4u, 14u, 4u, 14u, 
	4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 1u, 16u, 
	3u, 17u, 3u, 14u, 4u, 14u, 1u, 16u, 3u, 17u, 3u, 14u, 4u, 14u, 1u, 16u, 
	3u, 17u, 3u, 14u, 4u, 14u, 1u, 16u, 3u, 17u, 3u, 14u, 4u, 14u, 1u, 16u, 
	3u, 17u, 3u, 14u, 4u, 14u, 5u, 14u, 8u, 14u, 5u, 9u, 9u, 9u, 9u, 9u, 
	3u, 17u, 3u, 9u, 8u, 9u, 3u, 9u, 3u, 13u, 3u, 14u, 3u, 14u, 4u, 14u, 
	5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 
	4u, 14u, 6u, 14u, 3u, 14u, 4u, 14u, 1u, 16u, 3u, 14u, 3u, 14u, 1u, 16u, 
	1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 14u, 3u, 14u, 1u, 16u, 1u, 16u, 
	1u, 16u, 1u, 16u, 1u, 16u, 3u, 14u, 3u, 14u, 1u, 16u, 1u, 16u, 1u, 16u, 
	1u, 16u, 1u, 16u, 3u, 14u, 3u, 14u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 
	1u, 16u, 3u, 14u, 3u, 14u, 3u, 14u, 3u, 14u, 4u, 14u, 1u, 16u, 3u, 17u, 
	3u, 14u, 4u, 14u, 1u, 16u, 3u, 17u, 3u, 14u, 4u, 14u, 1u, 16u, 3u, 17u, 
	3u, 14u, 4u, 14u, 1u, 16u, 3u, 17u, 3u, 14u, 4u, 14u, 5u, 14u, 8u, 14u, 
	5u, 9u, 9u, 9u, 9u, 9u, 3u, 17u, 3u, 9u, 8u, 9u, 3u, 9u, 3u, 13u, 
	3u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 
	4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 6u, 14u, 3u, 14u, 1u, 16u, 3u, 14u, 
	3u, 14u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 14u, 3u, 14u, 
	1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 14u, 3u, 14u, 1u, 16u, 
	1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 14u, 3u, 14u, 1u, 16u, 1u, 16u, 
	1u, 16u, 1u, 16u, 4u, 14u, 1u, 16u, 3u, 14u, 3u, 14u, 4u, 14u, 1u, 16u, 
	3u, 17u, 3u, 14u, 4u, 14u, 1u, 16u, 3u, 17u, 3u, 14u, 4u, 14u, 1u, 16u, 
	3u, 17u, 3u, 14u, 4u, 14u, 1u, 16u, 3u, 17u, 3u, 14u, 4u, 14u, 5u, 14u, 
	8u, 14u, 5u, 9u, 9u, 9u, 9u, 9u, 3u, 17u, 3u, 9u, 8u, 9u, 3u, 9u, 
	3u, 13u, 3u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 
	3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 6u, 14u, 3u, 14u, 1u, 16u, 
	3u, 14u, 3u, 14u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 14u, 
	3u, 14u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 14u, 3u, 14u, 
	1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 14u, 3u, 14u, 1u, 16u, 
	1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 4u, 14u, 3u, 14u, 4u, 14u, 3u, 14u, 
	3u, 14u, 4u, 14u, 1u, 16u, 3u, 17u, 3u, 14u, 4u, 14u, 1u, 16u, 3u, 17u, 
	3u, 14u, 4u, 14u, 1u, 16u, 3u, 17u, 3u, 14u, 4u, 14u, 1u, 16u, 3u, 17u, 
	3u, 14u, 4u, 14u, 5u, 14u, 8u, 14u, 5u, 9u, 9u, 9u, 9u, 9u, 3u, 17u, 
	3u, 9u, 8u, 9u, 3u, 9u, 3u, 13u, 3u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 
	3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 
	6u, 14u, 3u, 14u, 1u, 16u, 3u, 14u, 3u, 14u, 1u, 16u, 1u, 16u, 1u, 16u, 
	1u, 16u, 1u, 16u, 3u, 14u, 3u, 14u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 
	1u, 16u, 3u, 14u, 3u, 14u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 
	3u, 14u, 3u, 14u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 14u, 
	1u, 16u, 3u, 17u, 1u, 16u, 0
};

static const char _indic_syllable_machine_key_spans[] = {
	16, 1, 3, 3, 1, 3, 3, 1, 
	3, 3, 1, 3, 3, 1, 1, 1, 
	1, 4, 1, 1, 4, 1, 1, 4, 
	1, 1, 11, 11, 11, 11, 11, 11, 
	11, 11, 11, 11, 16, 1, 3, 3, 
	1, 3, 3, 1, 3, 3, 1, 3, 
	3, 1, 1, 1, 1, 4, 1, 1, 
	4, 1, 1, 4, 1, 1, 11, 11, 
	11, 11, 11, 11, 11, 11, 11, 11, 
	16, 1, 3, 3, 1, 3, 3, 1, 
	3, 3, 1, 3, 3, 1, 1, 1, 
	1, 4, 1, 1, 4, 1, 1, 4, 
	1, 1, 11, 11, 11, 11, 11, 11, 
	11, 11, 11, 16, 1, 3, 3, 1, 
	3, 3, 1, 3, 3, 1, 3, 3, 
	1, 1, 1, 1, 4, 1, 1, 4, 
	1, 1, 4, 1, 1, 11, 11, 11, 
	11, 11, 11, 11, 11, 11, 11, 16, 
	15, 12, 11, 16, 15, 12, 11, 16, 
	15, 12, 11, 16, 15, 12, 11, 16, 
	15, 12, 11, 10, 7, 5, 1, 1, 
	15, 7, 2, 7, 11, 12, 12, 11, 
	10, 12, 11, 10, 12, 11, 10, 12, 
	11, 9, 12, 11, 16, 12, 12, 16, 
	16, 16, 16, 16, 12, 12, 16, 16, 
	16, 16, 16, 12, 12, 16, 16, 16, 
	16, 16, 12, 12, 16, 16, 16, 16, 
	16, 12, 12, 12, 12, 11, 16, 15, 
	12, 11, 16, 15, 12, 11, 16, 15, 
	12, 11, 16, 15, 12, 11, 10, 7, 
	5, 1, 1, 15, 7, 2, 7, 11, 
	12, 12, 11, 10, 12, 11, 10, 12, 
	11, 10, 12, 11, 9, 12, 16, 12, 
	12, 16, 16, 16, 16, 16, 12, 12, 
	16, 16, 16, 16, 16, 12, 12, 16, 
	16, 16, 16, 16, 12, 12, 16, 16, 
	16, 16, 11, 16, 12, 12, 11, 16, 
	15, 12, 11, 16, 15, 12, 11, 16, 
	15, 12, 11, 16, 15, 12, 11, 10, 
	7, 5, 1, 1, 15, 7, 2, 7, 
	11, 12, 12, 11, 10, 12, 11, 10, 
	12, 11, 10, 12, 11, 9, 12, 16, 
	12, 12, 16, 16, 16, 16, 16, 12, 
	12, 16, 16, 16, 16, 16, 12, 12, 
	16, 16, 16, 16, 16, 12, 12, 16, 
	16, 16, 16, 16, 11, 12, 11, 12, 
	12, 11, 16, 15, 12, 11, 16, 15, 
	12, 11, 16, 15, 12, 11, 16, 15, 
	12, 11, 10, 7, 5, 1, 1, 15, 
	7, 2, 7, 11, 12, 12, 11, 10, 
	12, 11, 10, 12, 11, 10, 12, 11, 
	9, 12, 16, 12, 12, 16, 16, 16, 
	16, 16, 12, 12, 16, 16, 16, 16, 
	16, 12, 12, 16, 16, 16, 16, 16, 
	12, 12, 16, 16, 16, 16, 16, 12, 
	16, 15, 16
};

static const short _indic_syllable_machine_index_offsets[] = {
	0, 17, 19, 23, 27, 29, 33, 37, 
	39, 43, 47, 49, 53, 57, 59, 61, 
	63, 65, 70, 72, 74, 79, 81, 83, 
	88, 90, 92, 104, 116, 128, 140, 152, 
	164, 176, 188, 200, 212, 229, 231, 235, 
	239, 241, 245, 249, 251, 255, 259, 261, 
	265, 269, 271, 273, 275, 277, 282, 284, 
	286, 291, 293, 295, 300, 302, 304, 316, 
	328, 340, 352, 364, 376, 388, 400, 412, 
	424, 441, 443, 447, 451, 453, 457, 461, 
	463, 467, 471, 473, 477, 481, 483, 485, 
	487, 489, 494, 496, 498, 503, 505, 507, 
	512, 514, 516, 528, 540, 552, 564, 576, 
	588, 600, 612, 624, 641, 643, 647, 651, 
	653, 657, 661, 663, 667, 671, 673, 677, 
	681, 683, 685, 687, 689, 694, 696, 698, 
	703, 705, 707, 712, 714, 716, 728, 740, 
	752, 764, 776, 788, 800, 812, 824, 836, 
	853, 869, 882, 894, 911, 927, 940, 952, 
	969, 985, 998, 1010, 1027, 1043, 1056, 1068, 
	1085, 1101, 1114, 1126, 1137, 1145, 1151, 1153, 
	1155, 1171, 1179, 1182, 1190, 1202, 1215, 1228, 
	1240, 1251, 1264, 1276, 1287, 1300, 1312, 1323, 
	1336, 1348, 1358, 1371, 1383, 1400, 1413, 1426, 
	1443, 1460, 1477, 1494, 1511, 1524, 1537, 1554, 
	1571, 1588, 1605, 1622, 1635, 1648, 1665, 1682, 
	1699, 1716, 1733, 1746, 1759, 1776, 1793, 1810, 
	1827, 1844, 1857, 1870, 1883, 1896, 1908, 1925, 
	1941, 1954, 1966, 1983, 1999, 2012, 2024, 2041, 
	2057, 2070, 2082, 2099, 2115, 2128, 2140, 2151, 
	2159, 2165, 2167, 2169, 2185, 2193, 2196, 2204, 
	2216, 2229, 2242, 2254, 2265, 2278, 2290, 2301, 
	2314, 2326, 2337, 2350, 2362, 2372, 2385, 2402, 
	2415, 2428, 2445, 2462, 2479, 2496, 2513, 2526, 
	2539, 2556, 2573, 2590, 2607, 2624, 2637, 2650, 
	2667, 2684, 2701, 2718, 2735, 2748, 2761, 2778, 
	2795, 2812, 2829, 2841, 2858, 2871, 2884, 2896, 
	2913, 2929, 2942, 2954, 2971, 2987, 3000, 3012, 
	3029, 3045, 3058, 3070, 3087, 3103, 3116, 3128, 
	3139, 3147, 3153, 3155, 3157, 3173, 3181, 3184, 
	3192, 3204, 3217, 3230, 3242, 3253, 3266, 3278, 
	3289, 3302, 3314, 3325, 3338, 3350, 3360, 3373, 
	3390, 3403, 3416, 3433, 3450, 3467, 3484, 3501, 
	3514, 3527, 3544, 3561, 3578, 3595, 3612, 3625, 
	3638, 3655, 3672, 3689, 3706, 3723, 3736, 3749, 
	3766, 3783, 3800, 3817, 3834, 3846, 3859, 3871, 
	3884, 3897, 3909, 3926, 3942, 3955, 3967, 3984, 
	4000, 4013, 4025, 4042, 4058, 4071, 4083, 4100, 
	4116, 4129, 4141, 4152, 4160, 4166, 4168, 4170, 
	4186, 4194, 4197, 4205, 4217, 4230, 4243, 4255, 
	4266, 4279, 4291, 4302, 4315, 4327, 4338, 4351, 
	4363, 4373, 4386, 4403, 4416, 4429, 4446, 4463, 
	4480, 4497, 4514, 4527, 4540, 4557, 4574, 4591, 
	4608, 4625, 4638, 4651, 4668, 4685, 4702, 4719, 
	4736, 4749, 4762, 4779, 4796, 4813, 4830, 4847, 
	4860, 4877, 4893
};

static const short _indic_syllable_machine_indicies[] = {
	1, 2, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 3, 0, 4, 4, 5, 0, 6, 
	6, 5, 0, 5, 0, 7, 7, 8, 
	0, 9, 9, 8, 0, 8, 0, 10, 
	10, 11, 0, 12, 12, 11, 0, 11, 
	0, 13, 13, 14, 0, 15, 15, 14, 
	0, 14, 0, 16, 0, 17, 0, 18, 
	0, 19, 13, 13, 14, 0, 20, 0, 
	21, 0, 22, 10, 10, 11, 0, 23, 
	0, 24, 0, 25, 7, 7, 8, 0, 
	26, 0, 27, 0, 28, 4, 4, 5, 
	0, 0, 0, 0, 0, 0, 28, 0, 
	28, 4, 4, 5, 0, 0, 0, 0, 
	0, 29, 28, 0, 30, 4, 4, 5, 
	0, 0, 0, 0, 0, 0, 30, 0, 
	30, 4, 4, 5, 0, 0, 0, 0, 
	0, 31, 30, 0, 32, 4, 4, 5, 
	0, 0, 0, 0, 0, 0, 32, 0, 
	32, 4, 4, 5, 0, 0, 0, 0, 
	0, 33, 32, 0, 34, 4, 4, 5, 
	0, 0, 0, 0, 0, 0, 34, 0, 
	34, 4, 4, 5, 0, 0, 0, 0, 
	0, 35, 34, 0, 36, 4, 4, 5, 
	0, 0, 0, 0, 0, 0, 36, 0, 
	36, 4, 4, 5, 0, 0, 0, 0, 
	0, 37, 36, 0, 39, 40, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 39, 38, 41, 38, 42, 
	42, 43, 38, 44, 44, 43, 38, 43, 
	38, 45, 45, 46, 38, 47, 47, 46, 
	38, 46, 38, 48, 48, 49, 38, 50, 
	50, 49, 38, 49, 38, 51, 51, 52, 
	38, 53, 53, 52, 38, 52, 38, 54, 
	38, 55, 38, 56, 38, 57, 51, 51, 
	52, 38, 58, 38, 59, 38, 60, 48, 
	48, 49, 38, 61, 38, 62, 38, 63, 
	45, 45, 46, 38, 64, 38, 65, 38, 
	66, 42, 42, 43, 38, 38, 38, 38, 
	38, 38, 66, 38, 66, 42, 42, 43, 
	38, 38, 38, 38, 38, 67, 66, 38, 
	68, 42, 42, 43, 38, 38, 38, 38, 
	38, 38, 68, 38, 68, 42, 42, 43, 
	38, 38, 38, 38, 38, 69, 68, 38, 
	70, 42, 42, 43, 38, 38, 38, 38, 
	38, 38, 70, 38, 70, 42, 42, 43, 
	38, 38, 38, 38, 38, 71, 70, 38, 
	72, 42, 42, 43, 38, 38, 38, 38, 
	38, 38, 72, 38, 72, 42, 42, 43, 
	38, 38, 38, 38, 38, 73, 72, 38, 
	74, 42, 42, 43, 38, 38, 38, 38, 
	38, 38, 74, 38, 74, 42, 42, 43, 
	38, 38, 38, 38, 38, 75, 74, 38, 
	77, 78, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 77, 
	76, 79, 76, 80, 80, 81, 76, 83, 
	83, 81, 82, 81, 82, 84, 84, 85, 
	76, 86, 86, 85, 76, 85, 76, 87, 
	87, 88, 76, 89, 89, 88, 76, 88, 
	76, 90, 90, 91, 76, 92, 92, 91, 
	76, 91, 76, 93, 76, 94, 76, 95, 
	76, 96, 90, 90, 91, 76, 97, 76, 
	98, 76, 99, 87, 87, 88, 76, 100, 
	76, 101, 76, 102, 84, 84, 85, 76, 
	103, 76, 104, 76, 105, 80, 80, 81, 
	76, 76, 76, 76, 76, 76, 105, 76, 
	105, 80, 80, 81, 76, 76, 76, 76, 
	76, 106, 105, 76, 107, 80, 80, 81, 
	76, 76, 76, 76, 76, 76, 107, 76, 
	107, 80, 80, 81, 76, 76, 76, 76, 
	76, 108, 107, 76, 109, 80, 80, 81, 
	76, 76, 76, 76, 76, 76, 109, 76, 
	109, 80, 80, 81, 76, 76, 76, 76, 
	76, 110, 109, 76, 111, 80, 80, 81, 
	76, 76, 76, 76, 76, 76, 111, 76, 
	111, 80, 80, 81, 76, 76, 76, 76, 
	76, 112, 111, 76, 113, 80, 80, 81, 
	76, 76, 76, 76, 76, 76, 113, 76, 
	115, 116, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 115, 
	114, 117, 114, 118, 118, 119, 114, 120, 
	120, 119, 114, 119, 114, 121, 121, 122, 
	114, 123, 123, 122, 114, 122, 114, 124, 
	124, 125, 114, 126, 126, 125, 114, 125, 
	114, 127, 127, 128, 114, 129, 129, 128, 
	114, 128, 114, 130, 114, 131, 114, 132, 
	114, 133, 127, 127, 128, 114, 134, 114, 
	135, 114, 136, 124, 124, 125, 114, 137, 
	114, 138, 114, 139, 121, 121, 122, 114, 
	140, 114, 141, 114, 142, 118, 118, 119, 
	114, 114, 114, 114, 114, 114, 142, 114, 
	142, 118, 118, 119, 114, 114, 114, 114, 
	114, 143, 142, 114, 144, 118, 118, 119, 
	114, 114, 114, 114, 114, 114, 144, 114, 
	144, 118, 118, 119, 114, 114, 114, 114, 
	114, 145, 144, 114, 146, 118, 118, 119, 
	114, 114, 114, 114, 114, 114, 146, 114, 
	146, 118, 118, 119, 114, 114, 114, 114, 
	114, 147, 146, 114, 148, 118, 118, 119, 
	114, 114, 114, 114, 114, 114, 148, 114, 
	148, 118, 118, 119, 114, 114, 114, 114, 
	114, 149, 148, 114, 150, 118, 118, 119, 
	114, 114, 114, 114, 114, 114, 150, 114, 
	150, 118, 118, 119, 114, 114, 114, 114, 
	114, 151, 150, 114, 153, 154, 155, 156, 
	157, 158, 81, 159, 160, 152, 161, 161, 
	162, 163, 164, 165, 152, 167, 168, 169, 
	170, 5, 171, 172, 173, 166, 166, 37, 
	174, 166, 166, 153, 166, 175, 168, 176, 
	176, 5, 171, 172, 173, 166, 166, 166, 
	174, 166, 168, 176, 176, 5, 171, 172, 
	173, 166, 166, 166, 174, 166, 177, 166, 
	166, 166, 18, 178, 166, 171, 172, 166, 
	166, 166, 166, 179, 166, 177, 166, 180, 
	181, 182, 183, 5, 171, 172, 173, 166, 
	166, 35, 184, 166, 166, 177, 166, 185, 
	181, 186, 186, 5, 171, 172, 173, 166, 
	166, 166, 184, 166, 181, 186, 186, 5, 
	171, 172, 173, 166, 166, 166, 184, 166, 
	187, 166, 166, 166, 18, 188, 166, 171, 
	172, 166, 166, 166, 166, 179, 166, 187, 
	166, 189, 190, 191, 192, 5, 171, 172, 
	173, 166, 166, 33, 193, 166, 166, 187, 
	166, 194, 190, 195, 195, 5, 171, 172, 
	173, 166, 166, 166, 193, 166, 190, 195, 
	195, 5, 171, 172, 173, 166, 166, 166, 
	193, 166, 196, 166, 166, 166, 18, 197, 
	166, 171, 172, 166, 166, 166, 166, 179, 
	166, 196, 166, 198, 199, 200, 201, 5, 
	171, 172, 173, 166, 166, 31, 202, 166, 
	166, 196, 166, 203, 199, 204, 204, 5, 
	171, 172, 173, 166, 166, 166, 202, 166, 
	199, 204, 204, 5, 171, 172, 173, 166, 
	166, 166, 202, 166, 205, 166, 166, 166, 
	18, 206, 166, 171, 172, 166, 166, 166, 
	166, 179, 166, 205, 166, 207, 208, 209, 
	210, 5, 171, 172, 173, 166, 166, 29, 
	211, 166, 166, 205, 166, 212, 208, 213, 
	213, 5, 171, 172, 173, 166, 166, 166, 
	211, 166, 208, 213, 213, 5, 171, 172, 
	173, 166, 166, 166, 211, 166, 18, 214, 
	166, 171, 172, 166, 166, 166, 166, 179, 
	166, 171, 172, 166, 166, 166, 166, 179, 
	166, 215, 166, 166, 166, 172, 166, 172, 
	166, 216, 166, 217, 166, 218, 219, 166, 
	171, 172, 166, 166, 166, 3, 166, 166, 
	166, 1, 166, 2, 166, 166, 166, 166, 
	171, 172, 166, 171, 172, 166, 217, 166, 
	166, 166, 166, 171, 172, 166, 217, 166, 
	218, 166, 166, 171, 172, 166, 166, 166, 
	3, 166, 18, 166, 220, 220, 5, 171, 
	172, 166, 166, 166, 166, 179, 166, 221, 
	27, 222, 223, 8, 171, 172, 166, 166, 
	166, 166, 179, 166, 27, 222, 223, 8, 
	171, 172, 166, 166, 166, 166, 179, 166, 
	222, 222, 8, 171, 172, 166, 166, 166, 
	166, 179, 166, 224, 24, 225, 226, 11, 
	171, 172, 166, 166, 166, 166, 179, 166, 
	24, 225, 226, 11, 171, 172, 166, 166, 
	166, 166, 179, 166, 225, 225, 11, 171, 
	172, 166, 166, 166, 166, 179, 166, 227, 
	21, 228, 229, 14, 171, 172, 166, 166, 
	166, 166, 179, 166, 21, 228, 229, 14, 
	171, 172, 166, 166, 166, 166, 179, 166, 
	228, 228, 14, 171, 172, 166, 166, 166, 
	166, 179, 166, 230, 18, 166, 231, 166, 
	171, 172, 166, 166, 166, 166, 179, 166, 
	18, 166, 231, 166, 171, 172, 166, 166, 
	166, 166, 179, 166, 232, 166, 171, 172, 
	166, 166, 166, 166, 179, 166, 18, 166, 
	166, 166, 166, 171, 172, 166, 166, 166, 
	166, 179, 166, 208, 213, 213, 5, 171, 
	172, 166, 166, 166, 166, 211, 166, 1, 
	2, 166, 166, 18, 214, 166, 171, 172, 
	166, 166, 166, 166, 179, 166, 1, 166, 
	207, 208, 213, 213, 5, 171, 172, 173, 
	166, 166, 166, 211, 166, 207, 208, 209, 
	213, 5, 171, 172, 173, 166, 166, 29, 
	211, 166, 205, 166, 233, 166, 220, 220, 
	5, 171, 172, 166, 166, 166, 166, 179, 
	166, 205, 166, 205, 166, 166, 166, 166, 
	166, 166, 171, 172, 166, 166, 166, 166, 
	179, 166, 205, 166, 205, 166, 166, 166, 
	166, 234, 166, 171, 172, 166, 166, 166, 
	166, 179, 166, 205, 166, 205, 166, 233, 
	166, 166, 166, 166, 171, 172, 166, 166, 
	166, 166, 179, 166, 205, 166, 205, 2, 
	166, 166, 18, 206, 166, 171, 172, 166, 
	166, 166, 166, 179, 166, 205, 166, 198, 
	199, 204, 204, 5, 171, 172, 173, 166, 
	166, 166, 202, 166, 198, 199, 200, 204, 
	5, 171, 172, 173, 166, 166, 31, 202, 
	166, 196, 166, 235, 166, 220, 220, 5, 
	171, 172, 166, 166, 166, 166, 179, 166, 
	196, 166, 196, 166, 166, 166, 166, 166, 
	166, 171, 172, 166, 166, 166, 166, 179, 
	166, 196, 166, 196, 166, 166, 166, 166, 
	236, 166, 171, 172, 166, 166, 166, 166, 
	179, 166, 196, 166, 196, 166, 235, 166, 
	166, 166, 166, 171, 172, 166, 166, 166, 
	166, 179, 166, 196, 166, 196, 2, 166, 
	166, 18, 197, 166, 171, 172, 166, 166, 
	166, 166, 179, 166, 196, 166, 189, 190, 
	195, 195, 5, 171, 172, 173, 166, 166, 
	166, 193, 166, 189, 190, 191, 195, 5, 
	171, 172, 173, 166, 166, 33, 193, 166, 
	187, 166, 237, 166, 220, 220, 5, 171, 
	172, 166, 166, 166, 166, 179, 166, 187, 
	166, 187, 166, 166, 166, 166, 166, 166, 
	171, 172, 166, 166, 166, 166, 179, 166, 
	187, 166, 187, 166, 166, 166, 166, 238, 
	166, 171, 172, 166, 166, 166, 166, 179, 
	166, 187, 166, 187, 166, 237, 166, 166, 
	166, 166, 171, 172, 166, 166, 166, 166, 
	179, 166, 187, 166, 187, 2, 166, 166, 
	18, 188, 166, 171, 172, 166, 166, 166, 
	166, 179, 166, 187, 166, 180, 181, 186, 
	186, 5, 171, 172, 173, 166, 166, 166, 
	184, 166, 180, 181, 182, 186, 5, 171, 
	172, 173, 166, 166, 35, 184, 166, 177, 
	166, 239, 166, 220, 220, 5, 171, 172, 
	166, 166, 166, 166, 179, 166, 177, 166, 
	177, 166, 166, 166, 166, 166, 166, 171, 
	172, 166, 166, 166, 166, 179, 166, 177, 
	166, 177, 166, 166, 166, 166, 240, 166, 
	171, 172, 166, 166, 166, 166, 179, 166, 
	177, 166, 177, 166, 239, 166, 166, 166, 
	166, 171, 172, 166, 166, 166, 166, 179, 
	166, 177, 166, 177, 2, 166, 166, 18, 
	178, 166, 171, 172, 166, 166, 166, 166, 
	179, 166, 177, 166, 167, 168, 176, 176, 
	5, 171, 172, 173, 166, 166, 166, 174, 
	166, 167, 168, 169, 176, 5, 171, 172, 
	173, 166, 166, 37, 174, 166, 242, 243, 
	244, 245, 43, 246, 247, 241, 241, 241, 
	75, 248, 241, 249, 243, 250, 245, 43, 
	246, 247, 241, 241, 241, 241, 248, 241, 
	243, 250, 245, 43, 246, 247, 241, 241, 
	241, 241, 248, 241, 251, 241, 241, 241, 
	56, 252, 241, 246, 247, 241, 241, 241, 
	241, 253, 241, 251, 241, 254, 255, 256, 
	257, 43, 246, 247, 241, 241, 241, 73, 
	258, 241, 241, 251, 241, 259, 255, 260, 
	260, 43, 246, 247, 241, 241, 241, 241, 
	258, 241, 255, 260, 260, 43, 246, 247, 
	241, 241, 241, 241, 258, 241, 261, 241, 
	241, 241, 56, 262, 241, 246, 247, 241, 
	241, 241, 241, 253, 241, 261, 241, 263, 
	264, 265, 266, 43, 246, 247, 241, 241, 
	241, 71, 267, 241, 241, 261, 241, 268, 
	264, 269, 269, 43, 246, 247, 241, 241, 
	241, 241, 267, 241, 264, 269, 269, 43, 
	246, 247, 241, 241, 241, 241, 267, 241, 
	270, 241, 241, 241, 56, 271, 241, 246, 
	247, 241, 241, 241, 241, 253, 241, 270, 
	241, 272, 273, 274, 275, 43, 246, 247, 
	241, 241, 241, 69, 276, 241, 241, 270, 
	241, 277, 273, 278, 278, 43, 246, 247, 
	241, 241, 241, 241, 276, 241, 273, 278, 
	278, 43, 246, 247, 241, 241, 241, 241, 
	276, 241, 279, 241, 241, 241, 56, 280, 
	241, 246, 247, 241, 241, 241, 241, 253, 
	241, 279, 241, 281, 282, 283, 284, 43, 
	246, 247, 241, 241, 241, 67, 285, 241, 
	241, 279, 241, 286, 282, 287, 287, 43, 
	246, 247, 241, 241, 241, 241, 285, 241, 
	282, 287, 287, 43, 246, 247, 241, 241, 
	241, 241, 285, 241, 56, 288, 241, 246, 
	247, 241, 241, 241, 241, 253, 241, 246, 
	247, 241, 241, 241, 241, 253, 241, 289, 
	241, 241, 241, 247, 241, 247, 241, 290, 
	241, 291, 241, 292, 293, 241, 246, 247, 
	241, 241, 241, 41, 241, 241, 241, 39, 
	241, 40, 241, 241, 241, 241, 246, 247, 
	241, 246, 247, 241, 291, 241, 241, 241, 
	241, 246, 247, 241, 291, 241, 292, 241, 
	241, 246, 247, 241, 241, 241, 41, 241, 
	56, 241, 294, 294, 43, 246, 247, 241, 
	241, 241, 241, 253, 241, 295, 65, 296, 
	297, 46, 246, 247, 241, 241, 241, 241, 
	253, 241, 65, 296, 297, 46, 246, 247, 
	241, 241, 241, 241, 253, 241, 296, 296, 
	46, 246, 247, 241, 241, 241, 241, 253, 
	241, 298, 62, 299, 300, 49, 246, 247, 
	241, 241, 241, 241, 253, 241, 62, 299, 
	300, 49, 246, 247, 241, 241, 241, 241, 
	253, 241, 299, 299, 49, 246, 247, 241, 
	241, 241, 241, 253, 241, 301, 59, 302, 
	303, 52, 246, 247, 241, 241, 241, 241, 
	253, 241, 59, 302, 303, 52, 246, 247, 
	241, 241, 241, 241, 253, 241, 302, 302, 
	52, 246, 247, 241, 241, 241, 241, 253, 
	241, 304, 56, 241, 305, 241, 246, 247, 
	241, 241, 241, 241, 253, 241, 56, 241, 
	305, 241, 246, 247, 241, 241, 241, 241, 
	253, 241, 306, 241, 246, 247, 241, 241, 
	241, 241, 253, 241, 56, 241, 241, 241, 
	241, 246, 247, 241, 241, 241, 241, 253, 
	241, 39, 40, 241, 241, 56, 288, 241, 
	246, 247, 241, 241, 241, 241, 253, 241, 
	39, 241, 281, 282, 287, 287, 43, 246, 
	247, 241, 241, 241, 241, 285, 241, 281, 
	282, 283, 287, 43, 246, 247, 241, 241, 
	241, 67, 285, 241, 279, 241, 307, 241, 
	294, 294, 43, 246, 247, 241, 241, 241, 
	241, 253, 241, 279, 241, 279, 241, 241, 
	241, 241, 241, 241, 246, 247, 241, 241, 
	241, 241, 253, 241, 279, 241, 279, 241, 
	241, 241, 241, 308, 241, 246, 247, 241, 
	241, 241, 241, 253, 241, 279, 241, 279, 
	241, 307, 241, 241, 241, 241, 246, 247, 
	241, 241, 241, 241, 253, 241, 279, 241, 
	279, 40, 241, 241, 56, 280, 241, 246, 
	247, 241, 241, 241, 241, 253, 241, 279, 
	241, 272, 273, 278, 278, 43, 246, 247, 
	241, 241, 241, 241, 276, 241, 272, 273, 
	274, 278, 43, 246, 247, 241, 241, 241, 
	69, 276, 241, 270, 241, 309, 241, 294, 
	294, 43, 246, 247, 241, 241, 241, 241, 
	253, 241, 270, 241, 270, 241, 241, 241, 
	241, 241, 241, 246, 247, 241, 241, 241, 
	241, 253, 241, 270, 241, 270, 241, 241, 
	241, 241, 310, 241, 246, 247, 241, 241, 
	241, 241, 253, 241, 270, 241, 270, 241, 
	309, 241, 241, 241, 241, 246, 247, 241, 
	241, 241, 241, 253, 241, 270, 241, 270, 
	40, 241, 241, 56, 271, 241, 246, 247, 
	241, 241, 241, 241, 253, 241, 270, 241, 
	263, 264, 269, 269, 43, 246, 247, 241, 
	241, 241, 241, 267, 241, 263, 264, 265, 
	269, 43, 246, 247, 241, 241, 241, 71, 
	267, 241, 261, 241, 311, 241, 294, 294, 
	43, 246, 247, 241, 241, 241, 241, 253, 
	241, 261, 241, 261, 241, 241, 241, 241, 
	241, 241, 246, 247, 241, 241, 241, 241, 
	253, 241, 261, 241, 261, 241, 241, 241, 
	241, 312, 241, 246, 247, 241, 241, 241, 
	241, 253, 241, 261, 241, 261, 241, 311, 
	241, 241, 241, 241, 246, 247, 241, 241, 
	241, 241, 253, 241, 261, 241, 261, 40, 
	241, 241, 56, 262, 241, 246, 247, 241, 
	241, 241, 241, 253, 241, 261, 241, 254, 
	255, 260, 260, 43, 246, 247, 241, 241, 
	241, 241, 258, 241, 254, 255, 256, 260, 
	43, 246, 247, 241, 241, 241, 73, 258, 
	241, 251, 241, 313, 241, 294, 294, 43, 
	246, 247, 241, 241, 241, 241, 253, 241, 
	251, 241, 251, 241, 241, 241, 241, 241, 
	241, 246, 247, 241, 241, 241, 241, 253, 
	241, 251, 241, 251, 241, 241, 241, 241, 
	314, 241, 246, 247, 241, 241, 241, 241, 
	253, 241, 251, 241, 251, 241, 313, 241, 
	241, 241, 241, 246, 247, 241, 241, 241, 
	241, 253, 241, 251, 241, 74, 42, 42, 
	43, 241, 241, 241, 241, 241, 241, 74, 
	241, 251, 40, 241, 241, 56, 252, 241, 
	246, 247, 241, 241, 241, 241, 253, 241, 
	251, 241, 242, 243, 250, 245, 43, 246, 
	247, 241, 241, 241, 241, 248, 241, 316, 
	156, 317, 317, 81, 159, 160, 315, 315, 
	315, 315, 163, 315, 156, 317, 317, 81, 
	159, 160, 315, 315, 315, 315, 163, 315, 
	318, 315, 315, 315, 95, 319, 315, 159, 
	160, 315, 315, 315, 315, 320, 315, 318, 
	315, 321, 322, 323, 324, 81, 159, 160, 
	315, 315, 315, 112, 325, 315, 315, 318, 
	315, 326, 322, 327, 327, 81, 159, 160, 
	315, 315, 315, 315, 325, 315, 322, 327, 
	327, 81, 159, 160, 315, 315, 315, 315, 
	325, 315, 328, 315, 315, 315, 95, 329, 
	315, 159, 160, 315, 315, 315, 315, 320, 
	315, 328, 315, 330, 331, 332, 333, 81, 
	159, 160, 315, 315, 315, 110, 334, 315, 
	315, 328, 315, 335, 331, 336, 336, 81, 
	159, 160, 315, 315, 315, 315, 334, 315, 
	331, 336, 336, 81, 159, 160, 315, 315, 
	315, 315, 334, 315, 337, 315, 315, 315, 
	95, 338, 315, 159, 160, 315, 315, 315, 
	315, 320, 315, 337, 315, 339, 340, 341, 
	342, 81, 159, 160, 315, 315, 315, 108, 
	343, 315, 315, 337, 315, 344, 340, 345, 
	345, 81, 159, 160, 315, 315, 315, 315, 
	343, 315, 340, 345, 345, 81, 159, 160, 
	315, 315, 315, 315, 343, 315, 346, 315, 
	315, 315, 95, 347, 315, 159, 160, 315, 
	315, 315, 315, 320, 315, 346, 315, 348, 
	349, 350, 351, 81, 159, 160, 315, 315, 
	315, 106, 352, 315, 315, 346, 315, 353, 
	349, 354, 354, 81, 159, 160, 315, 315, 
	315, 315, 352, 315, 349, 354, 354, 81, 
	159, 160, 315, 315, 315, 315, 352, 315, 
	95, 355, 315, 159, 160, 315, 315, 315, 
	315, 320, 315, 159, 160, 315, 315, 315, 
	315, 320, 315, 356, 315, 315, 315, 160, 
	315, 160, 315, 357, 315, 358, 315, 359, 
	360, 315, 159, 160, 315, 315, 315, 79, 
	315, 315, 315, 77, 315, 78, 315, 315, 
	315, 315, 159, 160, 315, 159, 160, 315, 
	358, 315, 315, 315, 315, 159, 160, 315, 
	358, 315, 359, 315, 315, 159, 160, 315, 
	315, 315, 79, 315, 95, 315, 361, 361, 
	81, 159, 160, 315, 315, 315, 315, 320, 
	315, 362, 104, 363, 364, 85, 159, 160, 
	315, 315, 315, 315, 320, 315, 104, 363, 
	364, 85, 159, 160, 315, 315, 315, 315, 
	320, 315, 363, 363, 85, 159, 160, 315, 
	315, 315, 315, 320, 315, 365, 101, 366, 
	367, 88, 159, 160, 315, 315, 315, 315, 
	320, 315, 101, 366, 367, 88, 159, 160, 
	315, 315, 315, 315, 320, 315, 366, 366, 
	88, 159, 160, 315, 315, 315, 315, 320, 
	315, 368, 98, 369, 370, 91, 159, 160, 
	315, 315, 315, 315, 320, 315, 98, 369, 
	370, 91, 159, 160, 315, 315, 315, 315, 
	320, 315, 369, 369, 91, 159, 160, 315, 
	315, 315, 315, 320, 315, 371, 95, 315, 
	372, 315, 159, 160, 315, 315, 315, 315, 
	320, 315, 95, 315, 372, 315, 159, 160, 
	315, 315, 315, 315, 320, 315, 373, 315, 
	159, 160, 315, 315, 315, 315, 320, 315, 
	95, 315, 315, 315, 315, 159, 160, 315, 
	315, 315, 315, 320, 315, 77, 78, 315, 
	315, 95, 355, 315, 159, 160, 315, 315, 
	315, 315, 320, 315, 77, 315, 348, 349, 
	354, 354, 81, 159, 160, 315, 315, 315, 
	315, 352, 315, 348, 349, 350, 354, 81, 
	159, 160, 315, 315, 315, 106, 352, 315, 
	346, 315, 374, 315, 361, 361, 81, 159, 
	160, 315, 315, 315, 315, 320, 315, 346, 
	315, 346, 315, 315, 315, 315, 315, 315, 
	159, 160, 315, 315, 315, 315, 320, 315, 
	346, 315, 346, 315, 315, 315, 315, 375, 
	315, 159, 160, 315, 315, 315, 315, 320, 
	315, 346, 315, 346, 315, 374, 315, 315, 
	315, 315, 159, 160, 315, 315, 315, 315, 
	320, 315, 346, 315, 346, 78, 315, 315, 
	95, 347, 315, 159, 160, 315, 315, 315, 
	315, 320, 315, 346, 315, 339, 340, 345, 
	345, 81, 159, 160, 315, 315, 315, 315, 
	343, 315, 339, 340, 341, 345, 81, 159, 
	160, 315, 315, 315, 108, 343, 315, 337, 
	315, 376, 315, 361, 361, 81, 159, 160, 
	315, 315, 315, 315, 320, 315, 337, 315, 
	337, 315, 315, 315, 315, 315, 315, 159, 
	160, 315, 315, 315, 315, 320, 315, 337, 
	315, 337, 315, 315, 315, 315, 377, 315, 
	159, 160, 315, 315, 315, 315, 320, 315, 
	337, 315, 337, 315, 376, 315, 315, 315, 
	315, 159, 160, 315, 315, 315, 315, 320, 
	315, 337, 315, 337, 78, 315, 315, 95, 
	338, 315, 159, 160, 315, 315, 315, 315, 
	320, 315, 337, 315, 330, 331, 336, 336, 
	81, 159, 160, 315, 315, 315, 315, 334, 
	315, 330, 331, 332, 336, 81, 159, 160, 
	315, 315, 315, 110, 334, 315, 328, 315, 
	378, 315, 361, 361, 81, 159, 160, 315, 
	315, 315, 315, 320, 315, 328, 315, 328, 
	315, 315, 315, 315, 315, 315, 159, 160, 
	315, 315, 315, 315, 320, 315, 328, 315, 
	328, 315, 315, 315, 315, 379, 315, 159, 
	160, 315, 315, 315, 315, 320, 315, 328, 
	315, 328, 315, 378, 315, 315, 315, 315, 
	159, 160, 315, 315, 315, 315, 320, 315, 
	328, 315, 328, 78, 315, 315, 95, 329, 
	315, 159, 160, 315, 315, 315, 315, 320, 
	315, 328, 315, 321, 322, 327, 327, 81, 
	159, 160, 315, 315, 315, 315, 325, 315, 
	321, 322, 323, 327, 81, 159, 160, 315, 
	315, 315, 112, 325, 315, 318, 315, 380, 
	315, 361, 361, 81, 159, 160, 315, 315, 
	315, 315, 320, 315, 318, 315, 318, 315, 
	315, 315, 315, 315, 315, 159, 160, 315, 
	315, 315, 315, 320, 315, 318, 315, 318, 
	315, 315, 315, 315, 381, 315, 159, 160, 
	315, 315, 315, 315, 320, 315, 318, 315, 
	318, 315, 380, 315, 315, 315, 315, 159, 
	160, 315, 315, 315, 315, 320, 315, 318, 
	315, 318, 78, 315, 315, 95, 319, 315, 
	159, 160, 315, 315, 315, 315, 320, 315, 
	318, 315, 113, 80, 80, 81, 382, 382, 
	382, 382, 382, 162, 113, 382, 155, 156, 
	317, 317, 81, 159, 160, 315, 315, 315, 
	315, 163, 315, 113, 80, 80, 81, 382, 
	382, 382, 382, 382, 382, 113, 382, 384, 
	385, 386, 387, 119, 388, 389, 383, 383, 
	383, 151, 390, 383, 391, 385, 387, 387, 
	119, 388, 389, 383, 383, 383, 383, 390, 
	383, 385, 387, 387, 119, 388, 389, 383, 
	383, 383, 383, 390, 383, 392, 383, 383, 
	383, 132, 393, 383, 388, 389, 383, 383, 
	383, 383, 394, 383, 392, 383, 395, 396, 
	397, 398, 119, 388, 389, 383, 383, 383, 
	149, 399, 383, 383, 392, 383, 400, 396, 
	401, 401, 119, 388, 389, 383, 383, 383, 
	383, 399, 383, 396, 401, 401, 119, 388, 
	389, 383, 383, 383, 383, 399, 383, 402, 
	383, 383, 383, 132, 403, 383, 388, 389, 
	383, 383, 383, 383, 394, 383, 402, 383, 
	404, 405, 406, 407, 119, 388, 389, 383, 
	383, 383, 147, 408, 383, 383, 402, 383, 
	409, 405, 410, 410, 119, 388, 389, 383, 
	383, 383, 383, 408, 383, 405, 410, 410, 
	119, 388, 389, 383, 383, 383, 383, 408, 
	383, 411, 383, 383, 383, 132, 412, 383, 
	388, 389, 383, 383, 383, 383, 394, 383, 
	411, 383, 413, 414, 415, 416, 119, 388, 
	389, 383, 383, 383, 145, 417, 383, 383, 
	411, 383, 418, 414, 419, 419, 119, 388, 
	389, 383, 383, 383, 383, 417, 383, 414, 
	419, 419, 119, 388, 389, 383, 383, 383, 
	383, 417, 383, 420, 383, 383, 383, 132, 
	421, 383, 388, 389, 383, 383, 383, 383, 
	394, 383, 420, 383, 422, 423, 424, 425, 
	119, 388, 389, 383, 383, 383, 143, 426, 
	383, 383, 420, 383, 427, 423, 428, 428, 
	119, 388, 389, 383, 383, 383, 383, 426, 
	383, 423, 428, 428, 119, 388, 389, 383, 
	383, 383, 383, 426, 383, 132, 429, 383, 
	388, 389, 383, 383, 383, 383, 394, 383, 
	388, 389, 383, 383, 383, 383, 394, 383, 
	430, 383, 383, 383, 389, 383, 389, 383, 
	431, 383, 432, 383, 433, 434, 383, 388, 
	389, 383, 383, 383, 117, 383, 383, 383, 
	115, 383, 116, 383, 383, 383, 383, 388, 
	389, 383, 388, 389, 383, 432, 383, 383, 
	383, 383, 388, 389, 383, 432, 383, 433, 
	383, 383, 388, 389, 383, 383, 383, 117, 
	383, 132, 383, 435, 435, 119, 388, 389, 
	383, 383, 383, 383, 394, 383, 436, 141, 
	437, 438, 122, 388, 389, 383, 383, 383, 
	383, 394, 383, 141, 437, 438, 122, 388, 
	389, 383, 383, 383, 383, 394, 383, 437, 
	437, 122, 388, 389, 383, 383, 383, 383, 
	394, 383, 439, 138, 440, 441, 125, 388, 
	389, 383, 383, 383, 383, 394, 383, 138, 
	440, 441, 125, 388, 389, 383, 383, 383, 
	383, 394, 383, 440, 440, 125, 388, 389, 
	383, 383, 383, 383, 394, 383, 442, 135, 
	443, 444, 128, 388, 389, 383, 383, 383, 
	383, 394, 383, 135, 443, 444, 128, 388, 
	389, 383, 383, 383, 383, 394, 383, 443, 
	443, 128, 388, 389, 383, 383, 383, 383, 
	394, 383, 445, 132, 383, 446, 383, 388, 
	389, 383, 383, 383, 383, 394, 383, 132, 
	383, 446, 383, 388, 389, 383, 383, 383, 
	383, 394, 383, 447, 383, 388, 389, 383, 
	383, 383, 383, 394, 383, 132, 383, 383, 
	383, 383, 388, 389, 383, 383, 383, 383, 
	394, 383, 115, 116, 383, 383, 132, 429, 
	383, 388, 389, 383, 383, 383, 383, 394, 
	383, 115, 383, 422, 423, 428, 428, 119, 
	388, 389, 383, 383, 383, 383, 426, 383, 
	422, 423, 424, 428, 119, 388, 389, 383, 
	383, 383, 143, 426, 383, 420, 383, 448, 
	383, 435, 435, 119, 388, 389, 383, 383, 
	383, 383, 394, 383, 420, 383, 420, 383, 
	383, 383, 383, 383, 383, 388, 389, 383, 
	383, 383, 383, 394, 383, 420, 383, 420, 
	383, 383, 383, 383, 449, 383, 388, 389, 
	383, 383, 383, 383, 394, 383, 420, 383, 
	420, 383, 448, 383, 383, 383, 383, 388, 
	389, 383, 383, 383, 383, 394, 383, 420, 
	383, 420, 116, 383, 383, 132, 421, 383, 
	388, 389, 383, 383, 383, 383, 394, 383, 
	420, 383, 413, 414, 419, 419, 119, 388, 
	389, 383, 383, 383, 383, 417, 383, 413, 
	414, 415, 419, 119, 388, 389, 383, 383, 
	383, 145, 417, 383, 411, 383, 450, 383, 
	435, 435, 119, 388, 389, 383, 383, 383, 
	383, 394, 383, 411, 383, 411, 383, 383, 
	383, 383, 383, 383, 388, 389, 383, 383, 
	383, 383, 394, 383, 411, 383, 411, 383, 
	383, 383, 383, 451, 383, 388, 389, 383, 
	383, 383, 383, 394, 383, 411, 383, 411, 
	383, 450, 383, 383, 383, 383, 388, 389, 
	383, 383, 383, 383, 394, 383, 411, 383, 
	411, 116, 383, 383, 132, 412, 383, 388, 
	389, 383, 383, 383, 383, 394, 383, 411, 
	383, 404, 405, 410, 410, 119, 388, 389, 
	383, 383, 383, 383, 408, 383, 404, 405, 
	406, 410, 119, 388, 389, 383, 383, 383, 
	147, 408, 383, 402, 383, 452, 383, 435, 
	435, 119, 388, 389, 383, 383, 383, 383, 
	394, 383, 402, 383, 402, 383, 383, 383, 
	383, 383, 383, 388, 389, 383, 383, 383, 
	383, 394, 383, 402, 383, 402, 383, 383, 
	383, 383, 453, 383, 388, 389, 383, 383, 
	383, 383, 394, 383, 402, 383, 402, 383, 
	452, 383, 383, 383, 383, 388, 389, 383, 
	383, 383, 383, 394, 383, 402, 383, 402, 
	116, 383, 383, 132, 403, 383, 388, 389, 
	383, 383, 383, 383, 394, 383, 402, 383, 
	395, 396, 401, 401, 119, 388, 389, 383, 
	383, 383, 383, 399, 383, 395, 396, 397, 
	401, 119, 388, 389, 383, 383, 383, 149, 
	399, 383, 392, 383, 454, 383, 435, 435, 
	119, 388, 389, 383, 383, 383, 383, 394, 
	383, 392, 383, 392, 383, 383, 383, 383, 
	383, 383, 388, 389, 383, 383, 383, 383, 
	394, 383, 392, 383, 392, 383, 383, 383, 
	383, 455, 383, 388, 389, 383, 383, 383, 
	383, 394, 383, 392, 383, 392, 383, 454, 
	383, 383, 383, 383, 388, 389, 383, 383, 
	383, 383, 394, 383, 392, 383, 392, 116, 
	383, 383, 132, 393, 383, 388, 389, 383, 
	383, 383, 383, 394, 383, 392, 383, 384, 
	385, 387, 387, 119, 388, 389, 383, 383, 
	383, 383, 390, 383, 153, 154, 382, 382, 
	382, 382, 382, 382, 382, 382, 161, 161, 
	382, 382, 382, 153, 382, 167, 456, 169, 
	170, 5, 171, 172, 173, 166, 166, 37, 
	174, 166, 166, 153, 166, 177, 154, 166, 
	166, 18, 178, 166, 171, 172, 166, 161, 
	161, 166, 179, 166, 177, 166, 0
};

static const short _indic_syllable_machine_trans_targs[] = {
	143, 168, 170, 171, 3, 174, 4, 6, 
	177, 7, 9, 180, 10, 12, 183, 13, 
	15, 16, 164, 18, 19, 182, 21, 22, 
	179, 24, 25, 176, 185, 189, 193, 196, 
	200, 203, 207, 210, 214, 217, 143, 243, 
	245, 246, 39, 249, 40, 42, 252, 43, 
	45, 255, 46, 48, 258, 49, 51, 52, 
	239, 54, 55, 257, 57, 58, 254, 60, 
	61, 251, 260, 263, 267, 270, 274, 277, 
	281, 284, 288, 292, 143, 316, 318, 319, 
	75, 322, 143, 76, 78, 325, 79, 81, 
	328, 82, 84, 331, 85, 87, 88, 312, 
	90, 91, 330, 93, 94, 327, 96, 97, 
	324, 333, 336, 340, 343, 347, 350, 354, 
	357, 361, 143, 391, 393, 394, 110, 397, 
	111, 113, 400, 114, 116, 403, 117, 119, 
	406, 120, 122, 123, 387, 125, 126, 405, 
	128, 129, 402, 131, 132, 399, 408, 411, 
	415, 418, 422, 425, 429, 432, 436, 439, 
	143, 144, 219, 293, 295, 364, 366, 313, 
	315, 367, 365, 363, 440, 441, 143, 145, 
	147, 35, 218, 165, 167, 187, 216, 146, 
	34, 148, 212, 0, 149, 151, 33, 211, 
	209, 150, 32, 152, 205, 153, 155, 31, 
	204, 202, 154, 30, 156, 198, 157, 159, 
	29, 197, 195, 158, 28, 160, 191, 161, 
	163, 27, 190, 188, 162, 26, 173, 166, 
	143, 169, 1, 172, 2, 175, 5, 23, 
	178, 8, 20, 181, 11, 17, 184, 14, 
	186, 192, 194, 199, 201, 206, 208, 213, 
	215, 143, 220, 222, 71, 290, 240, 242, 
	291, 221, 70, 223, 286, 36, 224, 226, 
	69, 285, 283, 225, 68, 227, 279, 228, 
	230, 67, 278, 276, 229, 66, 231, 272, 
	232, 234, 65, 271, 269, 233, 64, 235, 
	265, 236, 238, 63, 264, 262, 237, 62, 
	248, 241, 143, 244, 37, 247, 38, 250, 
	41, 59, 253, 44, 56, 256, 47, 53, 
	259, 50, 261, 266, 268, 273, 275, 280, 
	282, 287, 289, 143, 294, 106, 296, 359, 
	72, 297, 299, 105, 358, 356, 298, 104, 
	300, 352, 301, 303, 103, 351, 349, 302, 
	102, 304, 345, 305, 307, 101, 344, 342, 
	306, 100, 308, 338, 309, 311, 99, 337, 
	335, 310, 98, 321, 314, 143, 317, 73, 
	320, 74, 323, 77, 95, 326, 80, 92, 
	329, 83, 89, 332, 86, 334, 339, 341, 
	346, 348, 353, 355, 360, 362, 143, 143, 
	368, 370, 142, 141, 388, 390, 438, 369, 
	371, 434, 107, 372, 374, 140, 433, 431, 
	373, 139, 375, 427, 376, 378, 138, 426, 
	424, 377, 137, 379, 420, 380, 382, 136, 
	419, 417, 381, 135, 383, 413, 384, 386, 
	134, 412, 410, 385, 133, 396, 389, 143, 
	392, 108, 395, 109, 398, 112, 130, 401, 
	115, 127, 404, 118, 124, 407, 121, 409, 
	414, 416, 421, 423, 428, 430, 435, 437, 
	442
};

static const char _indic_syllable_machine_trans_actions[] = {
	1, 2, 0, 0, 0, 2, 0, 0, 
	2, 0, 0, 2, 0, 0, 2, 0, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 0, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	0, 0, 0, 2, 0, 0, 2, 0, 
	0, 2, 0, 0, 2, 0, 0, 0, 
	2, 0, 0, 2, 0, 0, 2, 0, 
	0, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 4, 2, 0, 0, 
	0, 2, 5, 0, 0, 2, 0, 0, 
	2, 0, 0, 2, 0, 0, 0, 2, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 2, 6, 2, 6, 2, 6, 2, 
	6, 2, 7, 2, 0, 0, 0, 2, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 0, 0, 2, 0, 0, 2, 
	0, 0, 2, 0, 0, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	10, 2, 2, 6, 2, 11, 11, 0, 
	0, 2, 6, 2, 0, 2, 12, 2, 
	2, 0, 2, 0, 0, 2, 2, 2, 
	0, 2, 2, 0, 2, 2, 0, 2, 
	2, 2, 0, 2, 2, 2, 2, 0, 
	2, 2, 2, 0, 2, 2, 2, 2, 
	0, 2, 2, 2, 0, 2, 2, 2, 
	2, 0, 2, 2, 2, 0, 2, 0, 
	13, 0, 0, 2, 0, 2, 0, 0, 
	2, 0, 0, 2, 0, 0, 2, 0, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 14, 2, 2, 0, 2, 0, 0, 
	2, 2, 0, 2, 2, 0, 2, 2, 
	0, 2, 2, 2, 0, 2, 2, 2, 
	2, 0, 2, 2, 2, 0, 2, 2, 
	2, 2, 0, 2, 2, 2, 0, 2, 
	2, 2, 2, 0, 2, 2, 2, 0, 
	2, 0, 15, 0, 0, 2, 0, 2, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 16, 6, 0, 6, 6, 
	0, 6, 2, 0, 6, 2, 6, 0, 
	6, 6, 6, 2, 0, 6, 2, 6, 
	0, 6, 6, 6, 2, 0, 6, 2, 
	6, 0, 6, 6, 6, 2, 0, 6, 
	2, 6, 0, 6, 0, 17, 0, 0, 
	2, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 0, 2, 0, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 18, 19, 
	2, 2, 0, 0, 0, 0, 2, 2, 
	2, 2, 0, 2, 2, 0, 2, 2, 
	2, 0, 2, 2, 2, 2, 0, 2, 
	2, 2, 0, 2, 2, 2, 2, 0, 
	2, 2, 2, 0, 2, 2, 2, 2, 
	0, 2, 2, 2, 0, 2, 0, 20, 
	0, 0, 2, 0, 2, 0, 0, 2, 
	0, 0, 2, 0, 0, 2, 0, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2
};

static const char _indic_syllable_machine_to_state_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 8, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0
};

static const char _indic_syllable_machine_from_state_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 9, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0
};

static const short _indic_syllable_machine_eof_trans[] = {
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	77, 77, 77, 83, 83, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 0, 
	167, 167, 167, 167, 167, 167, 167, 167, 
	167, 167, 167, 167, 167, 167, 167, 167, 
	167, 167, 167, 167, 167, 167, 167, 167, 
	167, 167, 167, 167, 167, 167, 167, 167, 
	167, 167, 167, 167, 167, 167, 167, 167, 
	167, 167, 167, 167, 167, 167, 167, 167, 
	167, 167, 167, 167, 167, 167, 167, 167, 
	167, 167, 167, 167, 167, 167, 167, 167, 
	167, 167, 167, 167, 167, 167, 167, 167, 
	167, 167, 167, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 383, 316, 383, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	383, 167, 167
};

static const int indic_syllable_machine_start = 143;
static const int indic_syllable_machine_first_final = 143;
static const int indic_syllable_machine_error = -1;

static const int indic_syllable_machine_en_main = 143;


#line 36 "../../src/hb-ot-shape-complex-indic-machine.rl"



#line 91 "../../src/hb-ot-shape-complex-indic-machine.rl"


#define found_syllable(syllable_type) \
  HB_STMT_START { \
    if (0) fprintf (stderr, "syllable %d..%d %s\n", last, p+1, #syllable_type); \
    for (unsigned int i = last; i < p+1; i++) \
      info[i].syllable() = (syllable_serial << 4) | syllable_type; \
    last = p+1; \
    syllable_serial++; \
    if (unlikely (syllable_serial == 16)) syllable_serial = 1; \
  } HB_STMT_END

static void
find_syllables (hb_buffer_t *buffer)
{
  unsigned int p, pe, eof, ts, te, act;
  int cs;
  hb_glyph_info_t *info = buffer->info;
  
#line 1161 "../../src/hb-ot-shape-complex-indic-machine.hh.tmp"
	{
	cs = indic_syllable_machine_start;
	ts = 0;
	te = 0;
	act = 0;
	}

#line 112 "../../src/hb-ot-shape-complex-indic-machine.rl"


  p = 0;
  pe = eof = buffer->len;

  unsigned int last = 0;
  unsigned int syllable_serial = 1;
  
#line 1178 "../../src/hb-ot-shape-complex-indic-machine.hh.tmp"
	{
	int _slen;
	int _trans;
	const unsigned char *_keys;
	const short *_inds;
	if ( p == pe )
		goto _test_eof;
_resume:
	switch ( _indic_syllable_machine_from_state_actions[cs] ) {
	case 9:
#line 1 "NONE"
	{ts = p;}
	break;
#line 1192 "../../src/hb-ot-shape-complex-indic-machine.hh.tmp"
	}

	_keys = _indic_syllable_machine_trans_keys + (cs<<1);
	_inds = _indic_syllable_machine_indicies + _indic_syllable_machine_index_offsets[cs];

	_slen = _indic_syllable_machine_key_spans[cs];
	_trans = _inds[ _slen > 0 && _keys[0] <=( info[p].indic_category()) &&
		( info[p].indic_category()) <= _keys[1] ?
		( info[p].indic_category()) - _keys[0] : _slen ];

_eof_trans:
	cs = _indic_syllable_machine_trans_targs[_trans];

	if ( _indic_syllable_machine_trans_actions[_trans] == 0 )
		goto _again;

	switch ( _indic_syllable_machine_trans_actions[_trans] ) {
	case 2:
#line 1 "NONE"
	{te = p+1;}
	break;
	case 13:
#line 83 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (consonant_syllable); }}
	break;
	case 15:
#line 84 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (vowel_syllable); }}
	break;
	case 20:
#line 85 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (standalone_cluster); }}
	break;
	case 17:
#line 86 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (broken_cluster); }}
	break;
	case 10:
#line 87 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (non_indic_cluster); }}
	break;
	case 12:
#line 83 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (consonant_syllable); }}
	break;
	case 14:
#line 84 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (vowel_syllable); }}
	break;
	case 19:
#line 85 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (standalone_cluster); }}
	break;
	case 16:
#line 86 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (broken_cluster); }}
	break;
	case 18:
#line 87 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (non_indic_cluster); }}
	break;
	case 1:
#line 83 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (consonant_syllable); }}
	break;
	case 3:
#line 84 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (vowel_syllable); }}
	break;
	case 7:
#line 85 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (standalone_cluster); }}
	break;
	case 4:
#line 86 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (broken_cluster); }}
	break;
	case 5:
#line 1 "NONE"
	{	switch( act ) {
	case 4:
	{{p = ((te))-1;} found_syllable (broken_cluster); }
	break;
	case 5:
	{{p = ((te))-1;} found_syllable (non_indic_cluster); }
	break;
	}
	}
	break;
	case 6:
#line 1 "NONE"
	{te = p+1;}
#line 86 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{act = 4;}
	break;
	case 11:
#line 1 "NONE"
	{te = p+1;}
#line 87 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{act = 5;}
	break;
#line 1294 "../../src/hb-ot-shape-complex-indic-machine.hh.tmp"
	}

_again:
	switch ( _indic_syllable_machine_to_state_actions[cs] ) {
	case 8:
#line 1 "NONE"
	{ts = 0;}
	break;
#line 1303 "../../src/hb-ot-shape-complex-indic-machine.hh.tmp"
	}

	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	if ( _indic_syllable_machine_eof_trans[cs] > 0 ) {
		_trans = _indic_syllable_machine_eof_trans[cs] - 1;
		goto _eof_trans;
	}
	}

	}

#line 121 "../../src/hb-ot-shape-complex-indic-machine.rl"

}

#endif /* HB_OT_SHAPE_COMPLEX_INDIC_MACHINE_HH */
