
#line 1 "../../src/hb-ot-shape-complex-indic-machine.rl"
/*
 * Copyright © 2011,2012  Google, Inc.
 *
 *  This is part of HarfBuzz, a text shaping library.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE COPYRIGHT HOLDER HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 * THE COPYRIGHT HOLDER SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE COPYRIGHT HOLDER HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * Google Author(s): Behdad Esfahbod
 */

#ifndef HB_OT_SHAPE_COMPLEX_INDIC_MACHINE_HH
#define HB_OT_SHAPE_COMPLEX_INDIC_MACHINE_HH

#include "hb-private.hh"


#line 36 "../../src/hb-ot-shape-complex-indic-machine.hh.tmp"
static const unsigned char _indic_syllable_machine_trans_keys[] = {
	1u, 16u, 13u, 13u, 4u, 14u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 
	5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 4u, 4u, 6u, 6u, 
	16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 
	6u, 6u, 16u, 16u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 
	4u, 14u, 4u, 14u, 4u, 14u, 1u, 16u, 13u, 13u, 4u, 14u, 5u, 7u, 7u, 7u, 
	5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 
	7u, 7u, 4u, 4u, 6u, 6u, 16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 
	6u, 6u, 16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 14u, 4u, 14u, 4u, 14u, 
	4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 1u, 16u, 13u, 13u, 
	4u, 14u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 
	7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 4u, 4u, 6u, 6u, 16u, 16u, 4u, 7u, 
	6u, 6u, 16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 
	4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 
	1u, 16u, 13u, 13u, 4u, 14u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 
	5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 4u, 4u, 6u, 6u, 
	16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 
	6u, 6u, 16u, 16u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 
	4u, 14u, 4u, 14u, 4u, 14u, 1u, 16u, 3u, 14u, 3u, 14u, 4u, 14u, 1u, 16u, 
	3u, 14u, 3u, 14u, 4u, 14u, 1u, 16u, 3u, 14u, 3u, 14u, 4u, 14u, 1u, 16u, 
	3u, 14u, 3u, 14u, 4u, 14u, 1u, 16u, 3u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 
	8u, 14u, 5u, 14u, 9u, 14u, 9u, 9u, 3u, 13u, 3u, 9u, 9u, 9u, 3u, 9u, 
	6u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 
	4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 4u, 14u, 1u, 16u, 3u, 14u, 1u, 16u, 
	1u, 16u, 1u, 16u, 3u, 14u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 14u, 1u, 16u, 
	1u, 16u, 1u, 16u, 3u, 14u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 14u, 3u, 14u, 
	3u, 14u, 4u, 14u, 1u, 16u, 3u, 14u, 3u, 14u, 4u, 14u, 1u, 16u, 3u, 14u, 
	3u, 14u, 4u, 14u, 1u, 16u, 3u, 14u, 3u, 14u, 4u, 14u, 1u, 16u, 3u, 14u, 
	3u, 14u, 4u, 14u, 5u, 14u, 8u, 14u, 5u, 14u, 9u, 14u, 9u, 9u, 3u, 13u, 
	3u, 9u, 9u, 9u, 3u, 9u, 6u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 
	4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 1u, 16u, 
	3u, 14u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 14u, 1u, 16u, 1u, 16u, 1u, 16u, 
	3u, 14u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 14u, 1u, 16u, 1u, 16u, 4u, 14u, 
	1u, 16u, 3u, 14u, 3u, 14u, 4u, 14u, 1u, 16u, 3u, 14u, 3u, 14u, 4u, 14u, 
	1u, 16u, 3u, 14u, 3u, 14u, 4u, 14u, 1u, 16u, 3u, 14u, 3u, 14u, 4u, 14u, 
	1u, 16u, 3u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 8u, 14u, 5u, 14u, 9u, 14u, 
	9u, 9u, 3u, 13u, 3u, 9u, 9u, 9u, 3u, 9u, 6u, 14u, 3u, 14u, 4u, 14u, 
	5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 
	4u, 14u, 1u, 16u, 3u, 14u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 14u, 1u, 16u, 
	1u, 16u, 1u, 16u, 3u, 14u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 14u, 1u, 16u, 
	1u, 16u, 1u, 16u, 4u, 14u, 3u, 14u, 4u, 14u, 3u, 14u, 3u, 14u, 4u, 14u, 
	1u, 16u, 3u, 14u, 3u, 14u, 4u, 14u, 1u, 16u, 3u, 14u, 3u, 14u, 4u, 14u, 
	1u, 16u, 3u, 14u, 3u, 14u, 4u, 14u, 1u, 16u, 3u, 14u, 3u, 14u, 4u, 14u, 
	5u, 14u, 8u, 14u, 5u, 14u, 9u, 14u, 9u, 9u, 3u, 13u, 3u, 9u, 9u, 9u, 
	3u, 9u, 6u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 
	3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 1u, 16u, 3u, 14u, 1u, 16u, 
	1u, 16u, 1u, 16u, 3u, 14u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 14u, 1u, 16u, 
	1u, 16u, 1u, 16u, 3u, 14u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 14u, 1u, 16u, 
	3u, 14u, 1u, 16u, 0
};

static const char _indic_syllable_machine_key_spans[] = {
	16, 1, 11, 3, 1, 3, 3, 1, 
	3, 3, 1, 3, 3, 1, 1, 1, 
	1, 4, 1, 1, 4, 1, 1, 4, 
	1, 1, 11, 11, 11, 11, 11, 11, 
	11, 11, 11, 16, 1, 11, 3, 1, 
	3, 3, 1, 3, 3, 1, 3, 3, 
	1, 1, 1, 1, 4, 1, 1, 4, 
	1, 1, 4, 1, 1, 11, 11, 11, 
	11, 11, 11, 11, 11, 11, 16, 1, 
	11, 3, 1, 3, 3, 1, 3, 3, 
	1, 3, 3, 1, 1, 1, 1, 4, 
	1, 1, 4, 1, 1, 4, 1, 1, 
	11, 11, 11, 11, 11, 11, 11, 11, 
	16, 1, 11, 3, 1, 3, 3, 1, 
	3, 3, 1, 3, 3, 1, 1, 1, 
	1, 4, 1, 1, 4, 1, 1, 4, 
	1, 1, 11, 11, 11, 11, 11, 11, 
	11, 11, 11, 16, 12, 12, 11, 16, 
	12, 12, 11, 16, 12, 12, 11, 16, 
	12, 12, 11, 16, 12, 12, 11, 10, 
	7, 10, 6, 1, 11, 7, 1, 7, 
	9, 12, 11, 10, 12, 11, 10, 12, 
	11, 10, 12, 11, 11, 16, 12, 16, 
	16, 16, 12, 16, 16, 16, 12, 16, 
	16, 16, 12, 16, 16, 16, 12, 12, 
	12, 11, 16, 12, 12, 11, 16, 12, 
	12, 11, 16, 12, 12, 11, 16, 12, 
	12, 11, 10, 7, 10, 6, 1, 11, 
	7, 1, 7, 9, 12, 11, 10, 12, 
	11, 10, 12, 11, 10, 12, 11, 16, 
	12, 16, 16, 16, 12, 16, 16, 16, 
	12, 16, 16, 16, 12, 16, 16, 11, 
	16, 12, 12, 11, 16, 12, 12, 11, 
	16, 12, 12, 11, 16, 12, 12, 11, 
	16, 12, 12, 11, 10, 7, 10, 6, 
	1, 11, 7, 1, 7, 9, 12, 11, 
	10, 12, 11, 10, 12, 11, 10, 12, 
	11, 16, 12, 16, 16, 16, 12, 16, 
	16, 16, 12, 16, 16, 16, 12, 16, 
	16, 16, 11, 12, 11, 12, 12, 11, 
	16, 12, 12, 11, 16, 12, 12, 11, 
	16, 12, 12, 11, 16, 12, 12, 11, 
	10, 7, 10, 6, 1, 11, 7, 1, 
	7, 9, 12, 11, 10, 12, 11, 10, 
	12, 11, 10, 12, 11, 16, 12, 16, 
	16, 16, 12, 16, 16, 16, 12, 16, 
	16, 16, 12, 16, 16, 16, 12, 16, 
	12, 16
};

static const short _indic_syllable_machine_index_offsets[] = {
	0, 17, 19, 31, 35, 37, 41, 45, 
	47, 51, 55, 57, 61, 65, 67, 69, 
	71, 73, 78, 80, 82, 87, 89, 91, 
	96, 98, 100, 112, 124, 136, 148, 160, 
	172, 184, 196, 208, 225, 227, 239, 243, 
	245, 249, 253, 255, 259, 263, 265, 269, 
	273, 275, 277, 279, 281, 286, 288, 290, 
	295, 297, 299, 304, 306, 308, 320, 332, 
	344, 356, 368, 380, 392, 404, 416, 433, 
	435, 447, 451, 453, 457, 461, 463, 467, 
	471, 473, 477, 481, 483, 485, 487, 489, 
	494, 496, 498, 503, 505, 507, 512, 514, 
	516, 528, 540, 552, 564, 576, 588, 600, 
	612, 629, 631, 643, 647, 649, 653, 657, 
	659, 663, 667, 669, 673, 677, 679, 681, 
	683, 685, 690, 692, 694, 699, 701, 703, 
	708, 710, 712, 724, 736, 748, 760, 772, 
	784, 796, 808, 820, 837, 850, 863, 875, 
	892, 905, 918, 930, 947, 960, 973, 985, 
	1002, 1015, 1028, 1040, 1057, 1070, 1083, 1095, 
	1106, 1114, 1125, 1132, 1134, 1146, 1154, 1156, 
	1164, 1174, 1187, 1199, 1210, 1223, 1235, 1246, 
	1259, 1271, 1282, 1295, 1307, 1319, 1336, 1349, 
	1366, 1383, 1400, 1413, 1430, 1447, 1464, 1477, 
	1494, 1511, 1528, 1541, 1558, 1575, 1592, 1605, 
	1618, 1631, 1643, 1660, 1673, 1686, 1698, 1715, 
	1728, 1741, 1753, 1770, 1783, 1796, 1808, 1825, 
	1838, 1851, 1863, 1874, 1882, 1893, 1900, 1902, 
	1914, 1922, 1924, 1932, 1942, 1955, 1967, 1978, 
	1991, 2003, 2014, 2027, 2039, 2050, 2063, 2075, 
	2092, 2105, 2122, 2139, 2156, 2169, 2186, 2203, 
	2220, 2233, 2250, 2267, 2284, 2297, 2314, 2331, 
	2343, 2360, 2373, 2386, 2398, 2415, 2428, 2441, 
	2453, 2470, 2483, 2496, 2508, 2525, 2538, 2551, 
	2563, 2580, 2593, 2606, 2618, 2629, 2637, 2648, 
	2655, 2657, 2669, 2677, 2679, 2687, 2697, 2710, 
	2722, 2733, 2746, 2758, 2769, 2782, 2794, 2805, 
	2818, 2830, 2847, 2860, 2877, 2894, 2911, 2924, 
	2941, 2958, 2975, 2988, 3005, 3022, 3039, 3052, 
	3069, 3086, 3103, 3115, 3128, 3140, 3153, 3166, 
	3178, 3195, 3208, 3221, 3233, 3250, 3263, 3276, 
	3288, 3305, 3318, 3331, 3343, 3360, 3373, 3386, 
	3398, 3409, 3417, 3428, 3435, 3437, 3449, 3457, 
	3459, 3467, 3477, 3490, 3502, 3513, 3526, 3538, 
	3549, 3562, 3574, 3585, 3598, 3610, 3627, 3640, 
	3657, 3674, 3691, 3704, 3721, 3738, 3755, 3768, 
	3785, 3802, 3819, 3832, 3849, 3866, 3883, 3896, 
	3913, 3926
};

static const short _indic_syllable_machine_indicies[] = {
	1, 2, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 3, 0, 4, 5, 5, 6, 0, 
	0, 0, 0, 0, 0, 4, 0, 7, 
	7, 6, 0, 6, 0, 8, 8, 9, 
	0, 10, 10, 9, 0, 9, 0, 11, 
	11, 12, 0, 13, 13, 12, 0, 12, 
	0, 14, 14, 15, 0, 16, 16, 15, 
	0, 15, 0, 17, 0, 18, 0, 19, 
	0, 20, 14, 14, 15, 0, 21, 0, 
	22, 0, 23, 11, 11, 12, 0, 24, 
	0, 25, 0, 26, 8, 8, 9, 0, 
	27, 0, 28, 0, 4, 5, 5, 6, 
	0, 0, 0, 0, 0, 29, 4, 0, 
	30, 5, 5, 6, 0, 0, 0, 0, 
	0, 0, 30, 0, 30, 5, 5, 6, 
	0, 0, 0, 0, 0, 31, 30, 0, 
	32, 5, 5, 6, 0, 0, 0, 0, 
	0, 0, 32, 0, 32, 5, 5, 6, 
	0, 0, 0, 0, 0, 33, 32, 0, 
	34, 5, 5, 6, 0, 0, 0, 0, 
	0, 0, 34, 0, 34, 5, 5, 6, 
	0, 0, 0, 0, 0, 35, 34, 0, 
	36, 5, 5, 6, 0, 0, 0, 0, 
	0, 0, 36, 0, 36, 5, 5, 6, 
	0, 0, 0, 0, 0, 37, 36, 0, 
	39, 40, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 39, 
	38, 41, 38, 42, 43, 43, 44, 38, 
	38, 38, 38, 38, 38, 42, 38, 45, 
	45, 44, 38, 44, 38, 46, 46, 47, 
	38, 48, 48, 47, 38, 47, 38, 49, 
	49, 50, 38, 51, 51, 50, 38, 50, 
	38, 52, 52, 53, 38, 54, 54, 53, 
	38, 53, 38, 55, 38, 56, 38, 57, 
	38, 58, 52, 52, 53, 38, 59, 38, 
	60, 38, 61, 49, 49, 50, 38, 62, 
	38, 63, 38, 64, 46, 46, 47, 38, 
	65, 38, 66, 38, 42, 43, 43, 44, 
	38, 38, 38, 38, 38, 67, 42, 38, 
	68, 43, 43, 44, 38, 38, 38, 38, 
	38, 38, 68, 38, 68, 43, 43, 44, 
	38, 38, 38, 38, 38, 69, 68, 38, 
	70, 43, 43, 44, 38, 38, 38, 38, 
	38, 38, 70, 38, 70, 43, 43, 44, 
	38, 38, 38, 38, 38, 71, 70, 38, 
	72, 43, 43, 44, 38, 38, 38, 38, 
	38, 38, 72, 38, 72, 43, 43, 44, 
	38, 38, 38, 38, 38, 73, 72, 38, 
	74, 43, 43, 44, 38, 38, 38, 38, 
	38, 38, 74, 38, 74, 43, 43, 44, 
	38, 38, 38, 38, 38, 75, 74, 38, 
	77, 78, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 77, 
	76, 79, 76, 80, 81, 81, 82, 76, 
	76, 76, 76, 76, 76, 80, 76, 84, 
	84, 82, 83, 82, 83, 85, 85, 86, 
	76, 87, 87, 86, 76, 86, 76, 88, 
	88, 89, 76, 90, 90, 89, 76, 89, 
	76, 91, 91, 92, 76, 93, 93, 92, 
	76, 92, 76, 94, 76, 95, 76, 96, 
	76, 97, 91, 91, 92, 76, 98, 76, 
	99, 76, 100, 88, 88, 89, 76, 101, 
	76, 102, 76, 103, 85, 85, 86, 76, 
	104, 76, 105, 76, 80, 81, 81, 82, 
	76, 76, 76, 76, 76, 106, 80, 76, 
	107, 81, 81, 82, 76, 76, 76, 76, 
	76, 76, 107, 76, 107, 81, 81, 82, 
	76, 76, 76, 76, 76, 108, 107, 76, 
	109, 81, 81, 82, 76, 76, 76, 76, 
	76, 76, 109, 76, 109, 81, 81, 82, 
	76, 76, 76, 76, 76, 110, 109, 76, 
	111, 81, 81, 82, 76, 76, 76, 76, 
	76, 76, 111, 76, 111, 81, 81, 82, 
	76, 76, 76, 76, 76, 112, 111, 76, 
	113, 81, 81, 82, 76, 76, 76, 76, 
	76, 76, 113, 76, 115, 116, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 115, 114, 117, 114, 118, 
	119, 119, 120, 114, 114, 114, 114, 114, 
	114, 118, 114, 121, 121, 120, 114, 120, 
	114, 122, 122, 123, 114, 124, 124, 123, 
	114, 123, 114, 125, 125, 126, 114, 127, 
	127, 126, 114, 126, 114, 128, 128, 129, 
	114, 130, 130, 129, 114, 129, 114, 131, 
	114, 132, 114, 133, 114, 134, 128, 128, 
	129, 114, 135, 114, 136, 114, 137, 125, 
	125, 126, 114, 138, 114, 139, 114, 140, 
	122, 122, 123, 114, 141, 114, 142, 114, 
	118, 119, 119, 120, 114, 114, 114, 114, 
	114, 143, 118, 114, 144, 119, 119, 120, 
	114, 114, 114, 114, 114, 114, 144, 114, 
	144, 119, 119, 120, 114, 114, 114, 114, 
	114, 145, 144, 114, 146, 119, 119, 120, 
	114, 114, 114, 114, 114, 114, 146, 114, 
	146, 119, 119, 120, 114, 114, 114, 114, 
	114, 147, 146, 114, 148, 119, 119, 120, 
	114, 114, 114, 114, 114, 114, 148, 114, 
	148, 119, 119, 120, 114, 114, 114, 114, 
	114, 149, 148, 114, 150, 119, 119, 120, 
	114, 114, 114, 114, 114, 114, 150, 114, 
	150, 119, 119, 120, 114, 114, 114, 114, 
	114, 151, 150, 114, 153, 154, 155, 156, 
	157, 158, 82, 159, 160, 152, 161, 161, 
	162, 163, 164, 165, 152, 167, 168, 169, 
	170, 6, 171, 172, 173, 166, 166, 37, 
	174, 166, 175, 168, 170, 170, 6, 171, 
	172, 173, 166, 166, 166, 174, 166, 168, 
	170, 170, 6, 171, 172, 173, 166, 166, 
	166, 174, 166, 176, 166, 166, 166, 19, 
	177, 166, 171, 172, 166, 166, 166, 166, 
	178, 166, 176, 166, 179, 180, 181, 182, 
	6, 171, 172, 173, 166, 166, 35, 183, 
	166, 184, 180, 182, 182, 6, 171, 172, 
	173, 166, 166, 166, 183, 166, 180, 182, 
	182, 6, 171, 172, 173, 166, 166, 166, 
	183, 166, 185, 166, 166, 166, 19, 186, 
	166, 171, 172, 166, 166, 166, 166, 178, 
	166, 185, 166, 187, 188, 189, 190, 6, 
	171, 172, 173, 166, 166, 33, 191, 166, 
	192, 188, 190, 190, 6, 171, 172, 173, 
	166, 166, 166, 191, 166, 188, 190, 190, 
	6, 171, 172, 173, 166, 166, 166, 191, 
	166, 193, 166, 166, 166, 19, 194, 166, 
	171, 172, 166, 166, 166, 166, 178, 166, 
	193, 166, 195, 196, 197, 198, 6, 171, 
	172, 173, 166, 166, 31, 199, 166, 200, 
	196, 198, 198, 6, 171, 172, 173, 166, 
	166, 166, 199, 166, 196, 198, 198, 6, 
	171, 172, 173, 166, 166, 166, 199, 166, 
	201, 166, 166, 166, 19, 202, 166, 171, 
	172, 166, 166, 166, 166, 178, 166, 201, 
	166, 203, 204, 205, 206, 6, 171, 172, 
	173, 166, 166, 29, 207, 166, 208, 204, 
	206, 206, 6, 171, 172, 173, 166, 166, 
	166, 207, 166, 204, 206, 206, 6, 171, 
	172, 173, 166, 166, 166, 207, 166, 19, 
	19, 166, 171, 172, 166, 166, 166, 166, 
	178, 166, 171, 172, 166, 166, 166, 166, 
	178, 166, 209, 166, 166, 166, 172, 166, 
	166, 166, 166, 178, 166, 172, 166, 166, 
	166, 166, 178, 166, 210, 166, 211, 166, 
	212, 166, 166, 166, 172, 166, 166, 166, 
	3, 166, 2, 166, 166, 166, 166, 166, 
	172, 166, 172, 166, 211, 166, 166, 166, 
	166, 166, 172, 166, 19, 166, 171, 172, 
	166, 166, 166, 166, 178, 166, 213, 28, 
	214, 215, 9, 171, 172, 166, 166, 166, 
	166, 178, 166, 28, 214, 215, 9, 171, 
	172, 166, 166, 166, 166, 178, 166, 214, 
	214, 9, 171, 172, 166, 166, 166, 166, 
	178, 166, 216, 25, 217, 218, 12, 171, 
	172, 166, 166, 166, 166, 178, 166, 25, 
	217, 218, 12, 171, 172, 166, 166, 166, 
	166, 178, 166, 217, 217, 12, 171, 172, 
	166, 166, 166, 166, 178, 166, 219, 22, 
	220, 221, 15, 171, 172, 166, 166, 166, 
	166, 178, 166, 22, 220, 221, 15, 171, 
	172, 166, 166, 166, 166, 178, 166, 220, 
	220, 15, 171, 172, 166, 166, 166, 166, 
	178, 166, 222, 19, 166, 223, 166, 171, 
	172, 166, 166, 166, 166, 178, 166, 19, 
	166, 223, 166, 171, 172, 166, 166, 166, 
	166, 178, 166, 204, 206, 206, 6, 171, 
	172, 166, 166, 166, 166, 207, 166, 1, 
	2, 166, 166, 19, 19, 166, 171, 172, 
	166, 166, 166, 166, 178, 166, 1, 166, 
	203, 204, 206, 206, 6, 171, 172, 173, 
	166, 166, 166, 207, 166, 201, 166, 166, 
	166, 166, 166, 166, 171, 172, 166, 166, 
	166, 166, 178, 166, 201, 166, 201, 166, 
	166, 166, 166, 202, 166, 171, 172, 166, 
	166, 166, 166, 178, 166, 201, 166, 201, 
	2, 166, 166, 19, 202, 166, 171, 172, 
	166, 166, 166, 166, 178, 166, 201, 166, 
	195, 196, 198, 198, 6, 171, 172, 173, 
	166, 166, 166, 199, 166, 193, 166, 166, 
	166, 166, 166, 166, 171, 172, 166, 166, 
	166, 166, 178, 166, 193, 166, 193, 166, 
	166, 166, 166, 194, 166, 171, 172, 166, 
	166, 166, 166, 178, 166, 193, 166, 193, 
	2, 166, 166, 19, 194, 166, 171, 172, 
	166, 166, 166, 166, 178, 166, 193, 166, 
	187, 188, 190, 190, 6, 171, 172, 173, 
	166, 166, 166, 191, 166, 185, 166, 166, 
	166, 166, 166, 166, 171, 172, 166, 166, 
	166, 166, 178, 166, 185, 166, 185, 166, 
	166, 166, 166, 186, 166, 171, 172, 166, 
	166, 166, 166, 178, 166, 185, 166, 185, 
	2, 166, 166, 19, 186, 166, 171, 172, 
	166, 166, 166, 166, 178, 166, 185, 166, 
	179, 180, 182, 182, 6, 171, 172, 173, 
	166, 166, 166, 183, 166, 176, 166, 166, 
	166, 166, 166, 166, 171, 172, 166, 166, 
	166, 166, 178, 166, 176, 166, 176, 166, 
	166, 166, 166, 177, 166, 171, 172, 166, 
	166, 166, 166, 178, 166, 176, 166, 176, 
	2, 166, 166, 19, 177, 166, 171, 172, 
	166, 166, 166, 166, 178, 166, 176, 166, 
	167, 168, 170, 170, 6, 171, 172, 173, 
	166, 166, 166, 174, 166, 225, 226, 227, 
	228, 44, 229, 230, 224, 224, 224, 75, 
	231, 224, 232, 226, 233, 228, 44, 229, 
	230, 224, 224, 224, 224, 231, 224, 226, 
	233, 228, 44, 229, 230, 224, 224, 224, 
	224, 231, 224, 234, 224, 224, 224, 57, 
	235, 224, 229, 230, 224, 224, 224, 224, 
	236, 224, 234, 224, 237, 238, 239, 240, 
	44, 229, 230, 224, 224, 224, 73, 241, 
	224, 242, 238, 240, 240, 44, 229, 230, 
	224, 224, 224, 224, 241, 224, 238, 240, 
	240, 44, 229, 230, 224, 224, 224, 224, 
	241, 224, 243, 224, 224, 224, 57, 244, 
	224, 229, 230, 224, 224, 224, 224, 236, 
	224, 243, 224, 245, 246, 247, 248, 44, 
	229, 230, 224, 224, 224, 71, 249, 224, 
	250, 246, 248, 248, 44, 229, 230, 224, 
	224, 224, 224, 249, 224, 246, 248, 248, 
	44, 229, 230, 224, 224, 224, 224, 249, 
	224, 251, 224, 224, 224, 57, 252, 224, 
	229, 230, 224, 224, 224, 224, 236, 224, 
	251, 224, 253, 254, 255, 256, 44, 229, 
	230, 224, 224, 224, 69, 257, 224, 258, 
	254, 256, 256, 44, 229, 230, 224, 224, 
	224, 224, 257, 224, 254, 256, 256, 44, 
	229, 230, 224, 224, 224, 224, 257, 224, 
	259, 224, 224, 224, 57, 260, 224, 229, 
	230, 224, 224, 224, 224, 236, 224, 259, 
	224, 261, 262, 263, 264, 44, 229, 230, 
	224, 224, 224, 67, 265, 224, 266, 262, 
	264, 264, 44, 229, 230, 224, 224, 224, 
	224, 265, 224, 262, 264, 264, 44, 229, 
	230, 224, 224, 224, 224, 265, 224, 57, 
	57, 224, 229, 230, 224, 224, 224, 224, 
	236, 224, 229, 230, 224, 224, 224, 224, 
	236, 224, 267, 224, 224, 224, 230, 224, 
	224, 224, 224, 236, 224, 230, 224, 224, 
	224, 224, 236, 224, 268, 224, 269, 224, 
	270, 224, 224, 224, 230, 224, 224, 224, 
	41, 224, 40, 224, 224, 224, 224, 224, 
	230, 224, 230, 224, 269, 224, 224, 224, 
	224, 224, 230, 224, 57, 224, 229, 230, 
	224, 224, 224, 224, 236, 224, 271, 66, 
	272, 273, 47, 229, 230, 224, 224, 224, 
	224, 236, 224, 66, 272, 273, 47, 229, 
	230, 224, 224, 224, 224, 236, 224, 272, 
	272, 47, 229, 230, 224, 224, 224, 224, 
	236, 224, 274, 63, 275, 276, 50, 229, 
	230, 224, 224, 224, 224, 236, 224, 63, 
	275, 276, 50, 229, 230, 224, 224, 224, 
	224, 236, 224, 275, 275, 50, 229, 230, 
	224, 224, 224, 224, 236, 224, 277, 60, 
	278, 279, 53, 229, 230, 224, 224, 224, 
	224, 236, 224, 60, 278, 279, 53, 229, 
	230, 224, 224, 224, 224, 236, 224, 278, 
	278, 53, 229, 230, 224, 224, 224, 224, 
	236, 224, 280, 57, 224, 281, 224, 229, 
	230, 224, 224, 224, 224, 236, 224, 57, 
	224, 281, 224, 229, 230, 224, 224, 224, 
	224, 236, 224, 39, 40, 224, 224, 57, 
	57, 224, 229, 230, 224, 224, 224, 224, 
	236, 224, 39, 224, 261, 262, 264, 264, 
	44, 229, 230, 224, 224, 224, 224, 265, 
	224, 259, 224, 224, 224, 224, 224, 224, 
	229, 230, 224, 224, 224, 224, 236, 224, 
	259, 224, 259, 224, 224, 224, 224, 260, 
	224, 229, 230, 224, 224, 224, 224, 236, 
	224, 259, 224, 259, 40, 224, 224, 57, 
	260, 224, 229, 230, 224, 224, 224, 224, 
	236, 224, 259, 224, 253, 254, 256, 256, 
	44, 229, 230, 224, 224, 224, 224, 257, 
	224, 251, 224, 224, 224, 224, 224, 224, 
	229, 230, 224, 224, 224, 224, 236, 224, 
	251, 224, 251, 224, 224, 224, 224, 252, 
	224, 229, 230, 224, 224, 224, 224, 236, 
	224, 251, 224, 251, 40, 224, 224, 57, 
	252, 224, 229, 230, 224, 224, 224, 224, 
	236, 224, 251, 224, 245, 246, 248, 248, 
	44, 229, 230, 224, 224, 224, 224, 249, 
	224, 243, 224, 224, 224, 224, 224, 224, 
	229, 230, 224, 224, 224, 224, 236, 224, 
	243, 224, 243, 224, 224, 224, 224, 244, 
	224, 229, 230, 224, 224, 224, 224, 236, 
	224, 243, 224, 243, 40, 224, 224, 57, 
	244, 224, 229, 230, 224, 224, 224, 224, 
	236, 224, 243, 224, 237, 238, 240, 240, 
	44, 229, 230, 224, 224, 224, 224, 241, 
	224, 234, 224, 224, 224, 224, 224, 224, 
	229, 230, 224, 224, 224, 224, 236, 224, 
	234, 224, 234, 224, 224, 224, 224, 235, 
	224, 229, 230, 224, 224, 224, 224, 236, 
	224, 234, 224, 74, 43, 43, 44, 224, 
	224, 224, 224, 224, 224, 74, 224, 234, 
	40, 224, 224, 57, 235, 224, 229, 230, 
	224, 224, 224, 224, 236, 224, 234, 224, 
	225, 226, 233, 228, 44, 229, 230, 224, 
	224, 224, 224, 231, 224, 283, 156, 284, 
	284, 82, 159, 160, 282, 282, 282, 282, 
	163, 282, 156, 284, 284, 82, 159, 160, 
	282, 282, 282, 282, 163, 282, 285, 282, 
	282, 282, 96, 286, 282, 159, 160, 282, 
	282, 282, 282, 287, 282, 285, 282, 288, 
	289, 290, 291, 82, 159, 160, 282, 282, 
	282, 112, 292, 282, 293, 289, 291, 291, 
	82, 159, 160, 282, 282, 282, 282, 292, 
	282, 289, 291, 291, 82, 159, 160, 282, 
	282, 282, 282, 292, 282, 294, 282, 282, 
	282, 96, 295, 282, 159, 160, 282, 282, 
	282, 282, 287, 282, 294, 282, 296, 297, 
	298, 299, 82, 159, 160, 282, 282, 282, 
	110, 300, 282, 301, 297, 299, 299, 82, 
	159, 160, 282, 282, 282, 282, 300, 282, 
	297, 299, 299, 82, 159, 160, 282, 282, 
	282, 282, 300, 282, 302, 282, 282, 282, 
	96, 303, 282, 159, 160, 282, 282, 282, 
	282, 287, 282, 302, 282, 304, 305, 306, 
	307, 82, 159, 160, 282, 282, 282, 108, 
	308, 282, 309, 305, 307, 307, 82, 159, 
	160, 282, 282, 282, 282, 308, 282, 305, 
	307, 307, 82, 159, 160, 282, 282, 282, 
	282, 308, 282, 310, 282, 282, 282, 96, 
	311, 282, 159, 160, 282, 282, 282, 282, 
	287, 282, 310, 282, 312, 313, 314, 315, 
	82, 159, 160, 282, 282, 282, 106, 316, 
	282, 317, 313, 315, 315, 82, 159, 160, 
	282, 282, 282, 282, 316, 282, 313, 315, 
	315, 82, 159, 160, 282, 282, 282, 282, 
	316, 282, 96, 96, 282, 159, 160, 282, 
	282, 282, 282, 287, 282, 159, 160, 282, 
	282, 282, 282, 287, 282, 318, 282, 282, 
	282, 160, 282, 282, 282, 282, 287, 282, 
	160, 282, 282, 282, 282, 287, 282, 319, 
	282, 320, 282, 321, 282, 282, 282, 160, 
	282, 282, 282, 79, 282, 78, 282, 282, 
	282, 282, 282, 160, 282, 160, 282, 320, 
	282, 282, 282, 282, 282, 160, 282, 96, 
	282, 159, 160, 282, 282, 282, 282, 287, 
	282, 322, 105, 323, 324, 86, 159, 160, 
	282, 282, 282, 282, 287, 282, 105, 323, 
	324, 86, 159, 160, 282, 282, 282, 282, 
	287, 282, 323, 323, 86, 159, 160, 282, 
	282, 282, 282, 287, 282, 325, 102, 326, 
	327, 89, 159, 160, 282, 282, 282, 282, 
	287, 282, 102, 326, 327, 89, 159, 160, 
	282, 282, 282, 282, 287, 282, 326, 326, 
	89, 159, 160, 282, 282, 282, 282, 287, 
	282, 328, 99, 329, 330, 92, 159, 160, 
	282, 282, 282, 282, 287, 282, 99, 329, 
	330, 92, 159, 160, 282, 282, 282, 282, 
	287, 282, 329, 329, 92, 159, 160, 282, 
	282, 282, 282, 287, 282, 331, 96, 282, 
	332, 282, 159, 160, 282, 282, 282, 282, 
	287, 282, 96, 282, 332, 282, 159, 160, 
	282, 282, 282, 282, 287, 282, 77, 78, 
	282, 282, 96, 96, 282, 159, 160, 282, 
	282, 282, 282, 287, 282, 77, 282, 312, 
	313, 315, 315, 82, 159, 160, 282, 282, 
	282, 282, 316, 282, 310, 282, 282, 282, 
	282, 282, 282, 159, 160, 282, 282, 282, 
	282, 287, 282, 310, 282, 310, 282, 282, 
	282, 282, 311, 282, 159, 160, 282, 282, 
	282, 282, 287, 282, 310, 282, 310, 78, 
	282, 282, 96, 311, 282, 159, 160, 282, 
	282, 282, 282, 287, 282, 310, 282, 304, 
	305, 307, 307, 82, 159, 160, 282, 282, 
	282, 282, 308, 282, 302, 282, 282, 282, 
	282, 282, 282, 159, 160, 282, 282, 282, 
	282, 287, 282, 302, 282, 302, 282, 282, 
	282, 282, 303, 282, 159, 160, 282, 282, 
	282, 282, 287, 282, 302, 282, 302, 78, 
	282, 282, 96, 303, 282, 159, 160, 282, 
	282, 282, 282, 287, 282, 302, 282, 296, 
	297, 299, 299, 82, 159, 160, 282, 282, 
	282, 282, 300, 282, 294, 282, 282, 282, 
	282, 282, 282, 159, 160, 282, 282, 282, 
	282, 287, 282, 294, 282, 294, 282, 282, 
	282, 282, 295, 282, 159, 160, 282, 282, 
	282, 282, 287, 282, 294, 282, 294, 78, 
	282, 282, 96, 295, 282, 159, 160, 282, 
	282, 282, 282, 287, 282, 294, 282, 288, 
	289, 291, 291, 82, 159, 160, 282, 282, 
	282, 282, 292, 282, 285, 282, 282, 282, 
	282, 282, 282, 159, 160, 282, 282, 282, 
	282, 287, 282, 285, 282, 285, 282, 282, 
	282, 282, 286, 282, 159, 160, 282, 282, 
	282, 282, 287, 282, 285, 282, 285, 78, 
	282, 282, 96, 286, 282, 159, 160, 282, 
	282, 282, 282, 287, 282, 285, 282, 113, 
	81, 81, 82, 333, 333, 333, 333, 333, 
	162, 113, 333, 155, 156, 284, 284, 82, 
	159, 160, 282, 282, 282, 282, 163, 282, 
	113, 81, 81, 82, 333, 333, 333, 333, 
	333, 333, 113, 333, 335, 336, 337, 338, 
	120, 339, 340, 334, 334, 334, 151, 341, 
	334, 342, 336, 338, 338, 120, 339, 340, 
	334, 334, 334, 334, 341, 334, 336, 338, 
	338, 120, 339, 340, 334, 334, 334, 334, 
	341, 334, 343, 334, 334, 334, 133, 344, 
	334, 339, 340, 334, 334, 334, 334, 345, 
	334, 343, 334, 346, 347, 348, 349, 120, 
	339, 340, 334, 334, 334, 149, 350, 334, 
	351, 347, 349, 349, 120, 339, 340, 334, 
	334, 334, 334, 350, 334, 347, 349, 349, 
	120, 339, 340, 334, 334, 334, 334, 350, 
	334, 352, 334, 334, 334, 133, 353, 334, 
	339, 340, 334, 334, 334, 334, 345, 334, 
	352, 334, 354, 355, 356, 357, 120, 339, 
	340, 334, 334, 334, 147, 358, 334, 359, 
	355, 357, 357, 120, 339, 340, 334, 334, 
	334, 334, 358, 334, 355, 357, 357, 120, 
	339, 340, 334, 334, 334, 334, 358, 334, 
	360, 334, 334, 334, 133, 361, 334, 339, 
	340, 334, 334, 334, 334, 345, 334, 360, 
	334, 362, 363, 364, 365, 120, 339, 340, 
	334, 334, 334, 145, 366, 334, 367, 363, 
	365, 365, 120, 339, 340, 334, 334, 334, 
	334, 366, 334, 363, 365, 365, 120, 339, 
	340, 334, 334, 334, 334, 366, 334, 368, 
	334, 334, 334, 133, 369, 334, 339, 340, 
	334, 334, 334, 334, 345, 334, 368, 334, 
	370, 371, 372, 373, 120, 339, 340, 334, 
	334, 334, 143, 374, 334, 375, 371, 373, 
	373, 120, 339, 340, 334, 334, 334, 334, 
	374, 334, 371, 373, 373, 120, 339, 340, 
	334, 334, 334, 334, 374, 334, 133, 133, 
	334, 339, 340, 334, 334, 334, 334, 345, 
	334, 339, 340, 334, 334, 334, 334, 345, 
	334, 376, 334, 334, 334, 340, 334, 334, 
	334, 334, 345, 334, 340, 334, 334, 334, 
	334, 345, 334, 377, 334, 378, 334, 379, 
	334, 334, 334, 340, 334, 334, 334, 117, 
	334, 116, 334, 334, 334, 334, 334, 340, 
	334, 340, 334, 378, 334, 334, 334, 334, 
	334, 340, 334, 133, 334, 339, 340, 334, 
	334, 334, 334, 345, 334, 380, 142, 381, 
	382, 123, 339, 340, 334, 334, 334, 334, 
	345, 334, 142, 381, 382, 123, 339, 340, 
	334, 334, 334, 334, 345, 334, 381, 381, 
	123, 339, 340, 334, 334, 334, 334, 345, 
	334, 383, 139, 384, 385, 126, 339, 340, 
	334, 334, 334, 334, 345, 334, 139, 384, 
	385, 126, 339, 340, 334, 334, 334, 334, 
	345, 334, 384, 384, 126, 339, 340, 334, 
	334, 334, 334, 345, 334, 386, 136, 387, 
	388, 129, 339, 340, 334, 334, 334, 334, 
	345, 334, 136, 387, 388, 129, 339, 340, 
	334, 334, 334, 334, 345, 334, 387, 387, 
	129, 339, 340, 334, 334, 334, 334, 345, 
	334, 389, 133, 334, 390, 334, 339, 340, 
	334, 334, 334, 334, 345, 334, 133, 334, 
	390, 334, 339, 340, 334, 334, 334, 334, 
	345, 334, 115, 116, 334, 334, 133, 133, 
	334, 339, 340, 334, 334, 334, 334, 345, 
	334, 115, 334, 370, 371, 373, 373, 120, 
	339, 340, 334, 334, 334, 334, 374, 334, 
	368, 334, 334, 334, 334, 334, 334, 339, 
	340, 334, 334, 334, 334, 345, 334, 368, 
	334, 368, 334, 334, 334, 334, 369, 334, 
	339, 340, 334, 334, 334, 334, 345, 334, 
	368, 334, 368, 116, 334, 334, 133, 369, 
	334, 339, 340, 334, 334, 334, 334, 345, 
	334, 368, 334, 362, 363, 365, 365, 120, 
	339, 340, 334, 334, 334, 334, 366, 334, 
	360, 334, 334, 334, 334, 334, 334, 339, 
	340, 334, 334, 334, 334, 345, 334, 360, 
	334, 360, 334, 334, 334, 334, 361, 334, 
	339, 340, 334, 334, 334, 334, 345, 334, 
	360, 334, 360, 116, 334, 334, 133, 361, 
	334, 339, 340, 334, 334, 334, 334, 345, 
	334, 360, 334, 354, 355, 357, 357, 120, 
	339, 340, 334, 334, 334, 334, 358, 334, 
	352, 334, 334, 334, 334, 334, 334, 339, 
	340, 334, 334, 334, 334, 345, 334, 352, 
	334, 352, 334, 334, 334, 334, 353, 334, 
	339, 340, 334, 334, 334, 334, 345, 334, 
	352, 334, 352, 116, 334, 334, 133, 353, 
	334, 339, 340, 334, 334, 334, 334, 345, 
	334, 352, 334, 346, 347, 349, 349, 120, 
	339, 340, 334, 334, 334, 334, 350, 334, 
	343, 334, 334, 334, 334, 334, 334, 339, 
	340, 334, 334, 334, 334, 345, 334, 343, 
	334, 343, 334, 334, 334, 334, 344, 334, 
	339, 340, 334, 334, 334, 334, 345, 334, 
	343, 334, 343, 116, 334, 334, 133, 344, 
	334, 339, 340, 334, 334, 334, 334, 345, 
	334, 343, 334, 335, 336, 338, 338, 120, 
	339, 340, 334, 334, 334, 334, 341, 334, 
	153, 154, 333, 333, 333, 333, 333, 333, 
	333, 333, 161, 161, 333, 333, 333, 153, 
	333, 167, 391, 169, 170, 6, 171, 172, 
	173, 166, 166, 37, 174, 166, 176, 154, 
	166, 166, 19, 177, 166, 171, 172, 166, 
	161, 161, 166, 178, 166, 176, 166, 0
};

static const short _indic_syllable_machine_trans_targs[] = {
	139, 164, 166, 167, 168, 3, 169, 4, 
	6, 172, 7, 9, 175, 10, 12, 178, 
	13, 15, 16, 160, 18, 19, 177, 21, 
	22, 174, 24, 25, 171, 182, 184, 186, 
	188, 190, 192, 194, 196, 198, 139, 223, 
	225, 226, 227, 38, 228, 39, 41, 231, 
	42, 44, 234, 45, 47, 237, 48, 50, 
	51, 219, 53, 54, 236, 56, 57, 233, 
	59, 60, 230, 240, 242, 244, 246, 248, 
	250, 252, 254, 257, 139, 281, 283, 284, 
	285, 73, 286, 139, 74, 76, 289, 77, 
	79, 292, 80, 82, 295, 83, 85, 86, 
	277, 88, 89, 294, 91, 92, 291, 94, 
	95, 288, 298, 300, 302, 304, 306, 308, 
	310, 312, 139, 341, 343, 344, 345, 107, 
	346, 108, 110, 349, 111, 113, 352, 114, 
	116, 355, 117, 119, 120, 337, 122, 123, 
	354, 125, 126, 351, 128, 129, 348, 358, 
	360, 362, 364, 366, 368, 370, 372, 374, 
	139, 140, 199, 258, 260, 314, 316, 278, 
	280, 317, 315, 313, 375, 376, 139, 141, 
	143, 34, 33, 161, 163, 180, 197, 142, 
	144, 195, 0, 145, 147, 32, 31, 193, 
	146, 148, 191, 149, 151, 30, 29, 189, 
	150, 152, 187, 153, 155, 28, 27, 185, 
	154, 156, 183, 157, 159, 26, 2, 181, 
	158, 162, 139, 165, 1, 170, 5, 23, 
	173, 8, 20, 176, 11, 17, 179, 14, 
	139, 200, 202, 69, 255, 220, 222, 256, 
	201, 68, 203, 253, 35, 204, 206, 67, 
	66, 251, 205, 207, 249, 208, 210, 65, 
	64, 247, 209, 211, 245, 212, 214, 63, 
	62, 243, 213, 215, 241, 216, 218, 61, 
	37, 239, 217, 221, 139, 224, 36, 229, 
	40, 58, 232, 43, 55, 235, 46, 52, 
	238, 49, 139, 259, 103, 261, 311, 70, 
	262, 264, 102, 101, 309, 263, 265, 307, 
	266, 268, 100, 99, 305, 267, 269, 303, 
	270, 272, 98, 97, 301, 271, 273, 299, 
	274, 276, 96, 72, 297, 275, 279, 139, 
	282, 71, 287, 75, 93, 290, 78, 90, 
	293, 81, 87, 296, 84, 139, 139, 318, 
	320, 138, 137, 338, 340, 373, 319, 321, 
	371, 104, 322, 324, 136, 135, 369, 323, 
	325, 367, 326, 328, 134, 133, 365, 327, 
	329, 363, 330, 332, 132, 131, 361, 331, 
	333, 359, 334, 336, 130, 106, 357, 335, 
	339, 139, 342, 105, 347, 109, 127, 350, 
	112, 124, 353, 115, 121, 356, 118, 377
};

static const char _indic_syllable_machine_trans_actions[] = {
	1, 2, 0, 0, 2, 0, 2, 0, 
	0, 2, 0, 0, 2, 0, 0, 2, 
	0, 0, 0, 2, 0, 0, 2, 0, 
	0, 2, 0, 0, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	0, 0, 2, 0, 2, 0, 0, 2, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	0, 2, 0, 0, 2, 0, 0, 2, 
	0, 0, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 4, 2, 0, 0, 
	2, 0, 2, 5, 0, 0, 2, 0, 
	0, 2, 0, 0, 2, 0, 0, 0, 
	2, 0, 0, 2, 0, 0, 2, 0, 
	0, 2, 6, 2, 6, 2, 6, 2, 
	6, 2, 7, 2, 0, 0, 2, 0, 
	2, 0, 0, 2, 0, 0, 2, 0, 
	0, 2, 0, 0, 0, 2, 0, 0, 
	2, 0, 0, 2, 0, 0, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	10, 2, 2, 6, 2, 11, 11, 2, 
	0, 2, 6, 2, 0, 2, 12, 2, 
	2, 0, 0, 2, 0, 2, 2, 2, 
	2, 2, 0, 2, 2, 0, 0, 2, 
	2, 2, 2, 2, 2, 0, 0, 2, 
	2, 2, 2, 2, 2, 0, 0, 2, 
	2, 2, 2, 2, 2, 0, 0, 2, 
	2, 2, 13, 0, 0, 2, 0, 0, 
	2, 0, 0, 2, 0, 0, 2, 0, 
	14, 2, 2, 0, 2, 2, 0, 2, 
	2, 0, 2, 2, 0, 2, 2, 0, 
	0, 2, 2, 2, 2, 2, 2, 0, 
	0, 2, 2, 2, 2, 2, 2, 0, 
	0, 2, 2, 2, 2, 2, 2, 0, 
	0, 2, 2, 2, 15, 0, 0, 2, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 16, 6, 0, 6, 2, 0, 
	6, 2, 0, 0, 2, 6, 6, 2, 
	6, 2, 0, 0, 2, 6, 6, 2, 
	6, 2, 0, 0, 2, 6, 6, 2, 
	6, 2, 0, 0, 2, 6, 2, 17, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 0, 2, 0, 18, 19, 2, 
	2, 0, 0, 2, 0, 2, 2, 2, 
	2, 0, 2, 2, 0, 0, 2, 2, 
	2, 2, 2, 2, 0, 0, 2, 2, 
	2, 2, 2, 2, 0, 0, 2, 2, 
	2, 2, 2, 2, 0, 0, 2, 2, 
	2, 20, 0, 0, 2, 0, 0, 2, 
	0, 0, 2, 0, 0, 2, 0, 2
};

static const char _indic_syllable_machine_to_state_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 8, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0
};

static const char _indic_syllable_machine_from_state_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 9, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0
};

static const short _indic_syllable_machine_eof_trans[] = {
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 77, 77, 
	77, 84, 84, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 0, 167, 167, 167, 167, 
	167, 167, 167, 167, 167, 167, 167, 167, 
	167, 167, 167, 167, 167, 167, 167, 167, 
	167, 167, 167, 167, 167, 167, 167, 167, 
	167, 167, 167, 167, 167, 167, 167, 167, 
	167, 167, 167, 167, 167, 167, 167, 167, 
	167, 167, 167, 167, 167, 167, 167, 167, 
	167, 167, 167, 167, 167, 167, 167, 225, 
	225, 225, 225, 225, 225, 225, 225, 225, 
	225, 225, 225, 225, 225, 225, 225, 225, 
	225, 225, 225, 225, 225, 225, 225, 225, 
	225, 225, 225, 225, 225, 225, 225, 225, 
	225, 225, 225, 225, 225, 225, 225, 225, 
	225, 225, 225, 225, 225, 225, 225, 225, 
	225, 225, 225, 225, 225, 225, 225, 225, 
	225, 225, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 334, 283, 334, 335, 335, 335, 
	335, 335, 335, 335, 335, 335, 335, 335, 
	335, 335, 335, 335, 335, 335, 335, 335, 
	335, 335, 335, 335, 335, 335, 335, 335, 
	335, 335, 335, 335, 335, 335, 335, 335, 
	335, 335, 335, 335, 335, 335, 335, 335, 
	335, 335, 335, 335, 335, 335, 335, 335, 
	335, 335, 335, 335, 335, 335, 335, 334, 
	167, 167
};

static const int indic_syllable_machine_start = 139;
static const int indic_syllable_machine_first_final = 139;
static const int indic_syllable_machine_error = -1;

static const int indic_syllable_machine_en_main = 139;


#line 36 "../../src/hb-ot-shape-complex-indic-machine.rl"



#line 90 "../../src/hb-ot-shape-complex-indic-machine.rl"


#define found_syllable(syllable_type) \
  HB_STMT_START { \
    if (0) fprintf (stderr, "syllable %d..%d %s\n", last, p+1, #syllable_type); \
    for (unsigned int i = last; i < p+1; i++) \
      info[i].syllable() = (syllable_serial << 4) | syllable_type; \
    last = p+1; \
    syllable_serial++; \
    if (unlikely (syllable_serial == 16)) syllable_serial = 1; \
  } HB_STMT_END

static void
find_syllables (const hb_ot_shape_plan_t *plan, hb_buffer_t *buffer, bool *had_broken_cluster)
{
  unsigned int p, pe, eof, ts, te, act;
  int cs;
  hb_glyph_info_t *info = buffer->info;
  
#line 974 "../../src/hb-ot-shape-complex-indic-machine.hh.tmp"
	{
	cs = indic_syllable_machine_start;
	ts = 0;
	te = 0;
	act = 0;
	}

#line 111 "../../src/hb-ot-shape-complex-indic-machine.rl"


  p = 0;
  pe = eof = buffer->len;

  unsigned int last = 0;
  unsigned int syllable_serial = 1;
  
#line 991 "../../src/hb-ot-shape-complex-indic-machine.hh.tmp"
	{
	int _slen;
	int _trans;
	const unsigned char *_keys;
	const short *_inds;
	if ( p == pe )
		goto _test_eof;
_resume:
	switch ( _indic_syllable_machine_from_state_actions[cs] ) {
	case 9:
#line 1 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{ts = p;}
	break;
#line 1005 "../../src/hb-ot-shape-complex-indic-machine.hh.tmp"
	}

	_keys = _indic_syllable_machine_trans_keys + (cs<<1);
	_inds = _indic_syllable_machine_indicies + _indic_syllable_machine_index_offsets[cs];

	_slen = _indic_syllable_machine_key_spans[cs];
	_trans = _inds[ _slen > 0 && _keys[0] <=( info[p].indic_category()) &&
		( info[p].indic_category()) <= _keys[1] ?
		( info[p].indic_category()) - _keys[0] : _slen ];

_eof_trans:
	cs = _indic_syllable_machine_trans_targs[_trans];

	if ( _indic_syllable_machine_trans_actions[_trans] == 0 )
		goto _again;

	switch ( _indic_syllable_machine_trans_actions[_trans] ) {
	case 2:
#line 1 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;}
	break;
	case 13:
#line 82 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (consonant_syllable); }}
	break;
	case 15:
#line 83 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (vowel_syllable); }}
	break;
	case 20:
#line 84 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (standalone_cluster); }}
	break;
	case 17:
#line 85 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (broken_cluster); *had_broken_cluster = true; }}
	break;
	case 10:
#line 86 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (non_indic_cluster); }}
	break;
	case 12:
#line 82 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (consonant_syllable); }}
	break;
	case 14:
#line 83 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (vowel_syllable); }}
	break;
	case 19:
#line 84 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (standalone_cluster); }}
	break;
	case 16:
#line 85 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (broken_cluster); *had_broken_cluster = true; }}
	break;
	case 18:
#line 86 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (non_indic_cluster); }}
	break;
	case 1:
#line 82 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (consonant_syllable); }}
	break;
	case 3:
#line 83 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (vowel_syllable); }}
	break;
	case 7:
#line 84 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (standalone_cluster); }}
	break;
	case 4:
#line 85 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (broken_cluster); *had_broken_cluster = true; }}
	break;
	case 5:
#line 1 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{	switch( act ) {
	case 4:
	{{p = ((te))-1;} found_syllable (broken_cluster); *had_broken_cluster = true; }
	break;
	case 5:
	{{p = ((te))-1;} found_syllable (non_indic_cluster); }
	break;
	}
	}
	break;
	case 6:
#line 1 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;}
#line 85 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{act = 4;}
	break;
	case 11:
#line 1 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;}
#line 86 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{act = 5;}
	break;
#line 1107 "../../src/hb-ot-shape-complex-indic-machine.hh.tmp"
	}

_again:
	switch ( _indic_syllable_machine_to_state_actions[cs] ) {
	case 8:
#line 1 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{ts = 0;}
	break;
#line 1116 "../../src/hb-ot-shape-complex-indic-machine.hh.tmp"
	}

	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	if ( _indic_syllable_machine_eof_trans[cs] > 0 ) {
		_trans = _indic_syllable_machine_eof_trans[cs] - 1;
		goto _eof_trans;
	}
	}

	}

#line 120 "../../src/hb-ot-shape-complex-indic-machine.rl"

}

#endif /* HB_OT_SHAPE_COMPLEX_INDIC_MACHINE_HH */
