/* == Start of generated table == */
/*
 * The following table is generated by running:
 *
 *   ./gen-arabic-table.py ArabicShaping.txt UnicodeData.txt Blocks.txt
 *
 * on files with these headers:
 *
 * # ArabicShaping-7.0.0.txt
 * # Date: 2014-02-14, 21:00:00 GMT [RP, KW, LI]
 * # Blocks-7.0.0.txt
 * # Date: 2014-04-03, 23:23:00 GMT [RP, KW]
 * UnicodeData.txt does not have a header.
 */

#ifndef HB_OT_SHAPE_COMPLEX_ARABIC_TABLE_HH
#define HB_OT_SHAPE_COMPLEX_ARABIC_TABLE_HH


#define X	JOINING_TYPE_X
#define R	JOINING_TYPE_R
#define U	JOINING_TYPE_U
#define A	JOINING_GROUP_ALAPH
#define DR	JOINING_GROUP_DALATH_RISH
#define L	JOINING_TYPE_L
#define C	JOINING_TYPE_C
#define D	JOINING_TYPE_D

static const uint8_t joining_table[] =
{

#define joining_offset_0x0600 0

  /* Arabic */

  /* 0600 */ U,U,U,U,U,U,X,X,U,X,X,U,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
  /* 0620 */ D,U,R,R,R,R,D,R,D,R,D,D,D,D,D,R,R,R,R,D,D,D,D,D,D,D,D,D,D,D,D,D,
  /* 0640 */ C,D,D,D,D,D,D,D,R,D,D,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
  /* 0660 */ X,X,X,X,X,X,X,X,X,X,X,X,X,X,D,D,X,R,R,R,U,R,R,R,D,D,D,D,D,D,D,D,
  /* 0680 */ D,D,D,D,D,D,D,D,R,R,R,R,R,R,R,R,R,R,R,R,R,R,R,R,R,R,D,D,D,D,D,D,
  /* 06A0 */ D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,
  /* 06C0 */ R,D,D,R,R,R,R,R,R,R,R,R,D,R,D,R,D,D,R,R,X,R,X,X,X,X,X,X,X,U,X,X,
  /* 06E0 */ X,X,X,X,X,X,X,X,X,X,X,X,X,X,R,R,X,X,X,X,X,X,X,X,X,X,D,D,D,X,X,D,

  /* Syriac */

  /* 0700 */ X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,A,X,D,D,D,DR,DR,R,R,R,D,D,D,D,R,D,
  /* 0720 */ D,D,D,D,D,D,D,D,R,D,DR,D,R,D,D,DR,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
  /* 0740 */ X,X,X,X,X,X,X,X,X,X,X,X,X,R,D,D,

  /* Arabic Supplement */

  /* 0740 */                                 D,D,D,D,D,D,D,D,D,R,R,R,D,D,D,D,
  /* 0760 */ D,D,D,D,D,D,D,D,D,D,D,R,R,D,D,D,D,R,D,R,R,D,D,D,R,R,D,D,D,D,D,D,

  /* FILLER */

  /* 0780 */ X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
  /* 07A0 */ X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,

  /* NKo */

  /* 07C0 */ X,X,X,X,X,X,X,X,X,X,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,
  /* 07E0 */ D,D,D,D,D,D,D,D,D,D,D,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,C,X,X,X,X,X,

  /* FILLER */

  /* 0800 */ X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
  /* 0820 */ X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,

  /* Mandaic */

  /* 0840 */ R,D,D,D,D,D,R,D,D,R,D,D,D,D,D,R,D,D,D,D,R,D,U,U,U,X,X,X,X,X,X,X,
  /* 0860 */ X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
  /* 0880 */ X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,

  /* Arabic Extended-A */

  /* 08A0 */ D,D,D,D,D,D,D,D,D,D,R,R,R,U,R,D,D,R,R,

#define joining_offset_0x1806 691

  /* Mongolian */

  /* 1800 */             U,D,X,X,C,X,X,X,U,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
  /* 1820 */ D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,
  /* 1840 */ D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,
  /* 1860 */ D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,X,X,X,X,X,X,X,X,
  /* 1880 */ U,U,U,U,U,U,U,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,
  /* 18A0 */ D,D,D,D,D,D,D,D,D,X,D,

#define joining_offset_0x200c 856

  /* General Punctuation */

  /* 2000 */                         U,C,

#define joining_offset_0x2066 858

  /* General Punctuation */

  /* 2060 */             U,U,U,U,

#define joining_offset_0xa840 862

  /* Phags-pa */

  /* A840 */ D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,
  /* A860 */ D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,L,U,

#define joining_offset_0x10ac0 914

  /* Manichaean */

  /* 10AC0 */ D,D,D,D,D,R,U,R,U,R,R,U,U,L,R,R,R,R,R,D,D,D,D,L,D,D,D,D,D,R,D,D,
  /* 10AE0 */ D,R,U,U,R,X,X,X,X,X,X,D,D,D,D,R,

#define joining_offset_0x10b80 962

  /* Psalter Pahlavi */

  /* 10B80 */ D,R,D,R,R,R,D,D,D,R,D,D,R,D,R,R,D,R,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
  /* 10BA0 */ X,X,X,X,X,X,X,X,X,R,R,R,R,D,D,U,

}; /* Table items: 1010; occupancy: 57% */


static unsigned int
joining_type (hb_codepoint_t u)
{
  switch (u >> 12)
  {
    case 0x0:
      if (0x0600 <= u && u <= 0x08B2) return joining_table[u - 0x0600 + joining_offset_0x0600];
      break;

    case 0x1:
      if (0x1806 <= u && u <= 0x18AA) return joining_table[u - 0x1806 + joining_offset_0x1806];
      break;

    case 0x2:
      if (0x200C <= u && u <= 0x200D) return joining_table[u - 0x200C + joining_offset_0x200c];
      if (0x2066 <= u && u <= 0x2069) return joining_table[u - 0x2066 + joining_offset_0x2066];
      break;

    case 0xA:
      if (0xA840 <= u && u <= 0xA873) return joining_table[u - 0xA840 + joining_offset_0xa840];
      break;

    case 0x10:
      if (0x10AC0 <= u && u <= 0x10AEF) return joining_table[u - 0x10AC0 + joining_offset_0x10ac0];
      if (0x10B80 <= u && u <= 0x10BAF) return joining_table[u - 0x10B80 + joining_offset_0x10b80];
      break;

    default:
      break;
  }
  return X;
}

#undef X
#undef R
#undef U
#undef A
#undef DR
#undef L
#undef C
#undef D


static const uint16_t shaping_table[][4] =
{
  {0x0000, 0x0000, 0x0000, 0xFE80}, /* U+0621 ARABIC LETTER HAMZA ISOLATED FORM */
  {0x0000, 0x0000, 0xFE82, 0xFE81}, /* U+0622 ARABIC LETTER ALEF WITH MADDA ABOVE */
  {0x0000, 0x0000, 0xFE84, 0xFE83}, /* U+0623 ARABIC LETTER ALEF WITH HAMZA ABOVE */
  {0x0000, 0x0000, 0xFE86, 0xFE85}, /* U+0624 ARABIC LETTER WAW WITH HAMZA ABOVE */
  {0x0000, 0x0000, 0xFE88, 0xFE87}, /* U+0625 ARABIC LETTER ALEF WITH HAMZA BELOW */
  {0xFE8B, 0xFE8C, 0xFE8A, 0xFE89}, /* U+0626 ARABIC LETTER YEH WITH HAMZA ABOVE */
  {0x0000, 0x0000, 0xFE8E, 0xFE8D}, /* U+0627 ARABIC LETTER ALEF */
  {0xFE91, 0xFE92, 0xFE90, 0xFE8F}, /* U+0628 ARABIC LETTER BEH */
  {0x0000, 0x0000, 0xFE94, 0xFE93}, /* U+0629 ARABIC LETTER TEH MARBUTA */
  {0xFE97, 0xFE98, 0xFE96, 0xFE95}, /* U+062A ARABIC LETTER TEH */
  {0xFE9B, 0xFE9C, 0xFE9A, 0xFE99}, /* U+062B ARABIC LETTER THEH */
  {0xFE9F, 0xFEA0, 0xFE9E, 0xFE9D}, /* U+062C ARABIC LETTER JEEM */
  {0xFEA3, 0xFEA4, 0xFEA2, 0xFEA1}, /* U+062D ARABIC LETTER HAH */
  {0xFEA7, 0xFEA8, 0xFEA6, 0xFEA5}, /* U+062E ARABIC LETTER KHAH */
  {0x0000, 0x0000, 0xFEAA, 0xFEA9}, /* U+062F ARABIC LETTER DAL */
  {0x0000, 0x0000, 0xFEAC, 0xFEAB}, /* U+0630 ARABIC LETTER THAL */
  {0x0000, 0x0000, 0xFEAE, 0xFEAD}, /* U+0631 ARABIC LETTER REH */
  {0x0000, 0x0000, 0xFEB0, 0xFEAF}, /* U+0632 ARABIC LETTER ZAIN */
  {0xFEB3, 0xFEB4, 0xFEB2, 0xFEB1}, /* U+0633 ARABIC LETTER SEEN */
  {0xFEB7, 0xFEB8, 0xFEB6, 0xFEB5}, /* U+0634 ARABIC LETTER SHEEN */
  {0xFEBB, 0xFEBC, 0xFEBA, 0xFEB9}, /* U+0635 ARABIC LETTER SAD */
  {0xFEBF, 0xFEC0, 0xFEBE, 0xFEBD}, /* U+0636 ARABIC LETTER DAD */
  {0xFEC3, 0xFEC4, 0xFEC2, 0xFEC1}, /* U+0637 ARABIC LETTER TAH */
  {0xFEC7, 0xFEC8, 0xFEC6, 0xFEC5}, /* U+0638 ARABIC LETTER ZAH */
  {0xFECB, 0xFECC, 0xFECA, 0xFEC9}, /* U+0639 ARABIC LETTER AIN */
  {0xFECF, 0xFED0, 0xFECE, 0xFECD}, /* U+063A ARABIC LETTER GHAIN */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+063B  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+063C  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+063D  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+063E  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+063F  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0640  */
  {0xFED3, 0xFED4, 0xFED2, 0xFED1}, /* U+0641 ARABIC LETTER FEH */
  {0xFED7, 0xFED8, 0xFED6, 0xFED5}, /* U+0642 ARABIC LETTER QAF */
  {0xFEDB, 0xFEDC, 0xFEDA, 0xFED9}, /* U+0643 ARABIC LETTER KAF */
  {0xFEDF, 0xFEE0, 0xFEDE, 0xFEDD}, /* U+0644 ARABIC LETTER LAM */
  {0xFEE3, 0xFEE4, 0xFEE2, 0xFEE1}, /* U+0645 ARABIC LETTER MEEM */
  {0xFEE7, 0xFEE8, 0xFEE6, 0xFEE5}, /* U+0646 ARABIC LETTER NOON */
  {0xFEEB, 0xFEEC, 0xFEEA, 0xFEE9}, /* U+0647 ARABIC LETTER HEH */
  {0x0000, 0x0000, 0xFEEE, 0xFEED}, /* U+0648 ARABIC LETTER WAW */
  {0xFBE8, 0xFBE9, 0xFEF0, 0xFEEF}, /* U+0649 ARABIC LETTER */
  {0xFEF3, 0xFEF4, 0xFEF2, 0xFEF1}, /* U+064A ARABIC LETTER YEH */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+064B  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+064C  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+064D  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+064E  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+064F  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0650  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0651  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0652  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0653  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0654  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0655  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0656  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0657  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0658  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0659  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+065A  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+065B  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+065C  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+065D  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+065E  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+065F  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0660  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0661  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0662  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0663  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0664  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0665  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0666  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0667  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0668  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0669  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+066A  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+066B  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+066C  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+066D  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+066E  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+066F  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0670  */
  {0x0000, 0x0000, 0xFB51, 0xFB50}, /* U+0671 ARABIC LETTER ALEF WASLA */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0672  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0673  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0674  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0675  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0676  */
  {0x0000, 0x0000, 0x0000, 0xFBDD}, /* U+0677 ARABIC LETTER U WITH HAMZA ABOVE ISOLATED FORM */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0678  */
  {0xFB68, 0xFB69, 0xFB67, 0xFB66}, /* U+0679 ARABIC LETTER TTEH */
  {0xFB60, 0xFB61, 0xFB5F, 0xFB5E}, /* U+067A ARABIC LETTER TTEHEH */
  {0xFB54, 0xFB55, 0xFB53, 0xFB52}, /* U+067B ARABIC LETTER BEEH */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+067C  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+067D  */
  {0xFB58, 0xFB59, 0xFB57, 0xFB56}, /* U+067E ARABIC LETTER PEH */
  {0xFB64, 0xFB65, 0xFB63, 0xFB62}, /* U+067F ARABIC LETTER TEHEH */
  {0xFB5C, 0xFB5D, 0xFB5B, 0xFB5A}, /* U+0680 ARABIC LETTER BEHEH */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0681  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0682  */
  {0xFB78, 0xFB79, 0xFB77, 0xFB76}, /* U+0683 ARABIC LETTER NYEH */
  {0xFB74, 0xFB75, 0xFB73, 0xFB72}, /* U+0684 ARABIC LETTER DYEH */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0685  */
  {0xFB7C, 0xFB7D, 0xFB7B, 0xFB7A}, /* U+0686 ARABIC LETTER TCHEH */
  {0xFB80, 0xFB81, 0xFB7F, 0xFB7E}, /* U+0687 ARABIC LETTER TCHEHEH */
  {0x0000, 0x0000, 0xFB89, 0xFB88}, /* U+0688 ARABIC LETTER DDAL */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0689  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+068A  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+068B  */
  {0x0000, 0x0000, 0xFB85, 0xFB84}, /* U+068C ARABIC LETTER DAHAL */
  {0x0000, 0x0000, 0xFB83, 0xFB82}, /* U+068D ARABIC LETTER DDAHAL */
  {0x0000, 0x0000, 0xFB87, 0xFB86}, /* U+068E ARABIC LETTER DUL */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+068F  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0690  */
  {0x0000, 0x0000, 0xFB8D, 0xFB8C}, /* U+0691 ARABIC LETTER RREH */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0692  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0693  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0694  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0695  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0696  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0697  */
  {0x0000, 0x0000, 0xFB8B, 0xFB8A}, /* U+0698 ARABIC LETTER JEH */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+0699  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+069A  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+069B  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+069C  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+069D  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+069E  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+069F  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+06A0  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+06A1  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+06A2  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+06A3  */
  {0xFB6C, 0xFB6D, 0xFB6B, 0xFB6A}, /* U+06A4 ARABIC LETTER VEH */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+06A5  */
  {0xFB70, 0xFB71, 0xFB6F, 0xFB6E}, /* U+06A6 ARABIC LETTER PEHEH */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+06A7  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+06A8  */
  {0xFB90, 0xFB91, 0xFB8F, 0xFB8E}, /* U+06A9 ARABIC LETTER KEHEH */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+06AA  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+06AB  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+06AC  */
  {0xFBD5, 0xFBD6, 0xFBD4, 0xFBD3}, /* U+06AD ARABIC LETTER NG */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+06AE  */
  {0xFB94, 0xFB95, 0xFB93, 0xFB92}, /* U+06AF ARABIC LETTER GAF */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+06B0  */
  {0xFB9C, 0xFB9D, 0xFB9B, 0xFB9A}, /* U+06B1 ARABIC LETTER NGOEH */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+06B2  */
  {0xFB98, 0xFB99, 0xFB97, 0xFB96}, /* U+06B3 ARABIC LETTER GUEH */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+06B4  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+06B5  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+06B6  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+06B7  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+06B8  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+06B9  */
  {0x0000, 0x0000, 0xFB9F, 0xFB9E}, /* U+06BA ARABIC LETTER NOON GHUNNA */
  {0xFBA2, 0xFBA3, 0xFBA1, 0xFBA0}, /* U+06BB ARABIC LETTER RNOON */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+06BC  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+06BD  */
  {0xFBAC, 0xFBAD, 0xFBAB, 0xFBAA}, /* U+06BE ARABIC LETTER HEH DOACHASHMEE */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+06BF  */
  {0x0000, 0x0000, 0xFBA5, 0xFBA4}, /* U+06C0 ARABIC LETTER HEH WITH YEH ABOVE */
  {0xFBA8, 0xFBA9, 0xFBA7, 0xFBA6}, /* U+06C1 ARABIC LETTER HEH GOAL */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+06C2  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+06C3  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+06C4  */
  {0x0000, 0x0000, 0xFBE1, 0xFBE0}, /* U+06C5 ARABIC LETTER KIRGHIZ OE */
  {0x0000, 0x0000, 0xFBDA, 0xFBD9}, /* U+06C6 ARABIC LETTER OE */
  {0x0000, 0x0000, 0xFBD8, 0xFBD7}, /* U+06C7 ARABIC LETTER U */
  {0x0000, 0x0000, 0xFBDC, 0xFBDB}, /* U+06C8 ARABIC LETTER YU */
  {0x0000, 0x0000, 0xFBE3, 0xFBE2}, /* U+06C9 ARABIC LETTER KIRGHIZ YU */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+06CA  */
  {0x0000, 0x0000, 0xFBDF, 0xFBDE}, /* U+06CB ARABIC LETTER VE */
  {0xFBFE, 0xFBFF, 0xFBFD, 0xFBFC}, /* U+06CC ARABIC LETTER FARSI YEH */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+06CD  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+06CE  */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+06CF  */
  {0xFBE6, 0xFBE7, 0xFBE5, 0xFBE4}, /* U+06D0 ARABIC LETTER E */
  {0x0000, 0x0000, 0x0000, 0x0000}, /* U+06D1  */
  {0x0000, 0x0000, 0xFBAF, 0xFBAE}, /* U+06D2 ARABIC LETTER YEH BARREE */
  {0x0000, 0x0000, 0xFBB1, 0xFBB0}, /* U+06D3 ARABIC LETTER YEH BARREE WITH HAMZA ABOVE */
};

#define SHAPING_TABLE_FIRST	0x0621
#define SHAPING_TABLE_LAST	0x06D3


static const struct ligature_set_t {
 uint16_t first;
 struct ligature_pairs_t {
   uint16_t second;
   uint16_t ligature;
 } ligatures[4];
} ligature_table[] =
{
  { 0xFEDF, {
    { 0xFE88, 0xFEF9 }, /* ARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW ISOLATED FORM */
    { 0xFE82, 0xFEF5 }, /* ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE ISOLATED FORM */
    { 0xFE8E, 0xFEFB }, /* ARABIC LIGATURE LAM WITH ALEF ISOLATED FORM */
    { 0xFE84, 0xFEF7 }, /* ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE ISOLATED FORM */
  }},
  { 0xFEE0, {
    { 0xFE88, 0xFEFA }, /* ARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW FINAL FORM */
    { 0xFE82, 0xFEF6 }, /* ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE FINAL FORM */
    { 0xFE8E, 0xFEFC }, /* ARABIC LIGATURE LAM WITH ALEF FINAL FORM */
    { 0xFE84, 0xFEF8 }, /* ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE FINAL FORM */
  }},
};


#endif /* HB_OT_SHAPE_COMPLEX_ARABIC_TABLE_HH */

/* == End of generated table == */
