/* Copyright (C) 2000, Ghostgum Software Pty Ltd.  All rights reserved.
  
  This file is part of GSview.
  
  This program is distributed with NO WARRANTY OF ANY KIND.  No author
  or distributor accepts any responsibility for the consequences of using it,
  or for whether it serves any particular purpose or works at all, unless he
  or she says so in writing.  Refer to the GSview Free Public Licence 
  (the "Licence") for full details.
  
  Every copy of GSview must include a copy of the Licence, normally in a 
  plain ASCII text file named LICENCE.  The Licence grants you the right 
  to copy, modify and redistribute GSview, but only under certain conditions 
  described in the Licence.  Among other things, the Licence requires that 
  the copyright notice and this notice be preserved on all copies.
*/
/* sk/gvxlang.c */

#include "gvx.h"
#include "gvxres.h"
#include "gvxlang.h"
#include "gvclang.h"

/* string table ids must be in order since we use a binary search */
STRING_ENTRY string_sk[] = {
#include "gvclang.rc"
#include "gvxlangh.rc"
};

int string_sk_len = sizeof(string_sk)/sizeof(STRING_ENTRY);

/* This is the GtkItemFactoryEntry structure used to generate new menus.
   Item 1: The menu path. The letter after the underscore indicates an
           accelerator key once the menu is open.
   Item 2: The accelerator key for the entry
   Item 3: The callback function.
   Item 4: The callback action.  This changes the parameters with
           which the function is called.  The default is 0.
   Item 5: The item type, used to define what kind of an item it is.
           Here are the possible values:

           NULL               -> "<Item>"
           ""                 -> "<Item>"
           "<Title>"          -> create a title item
           "<Item>"           -> create a simple item
           "<CheckItem>"      -> create a check item
           "<ToggleItem>"     -> create a toggle item
           "<RadioItem>"      -> create a radio item
           <path>             -> path of a radio item to link against
           "<Separator>"      -> create a separator
           "<Branch>"         -> create an item to hold sub items (optional)
           "<LastBranch>"     -> create a right justified branch 
*/

MENU_ENTRY menu_sk[] = {
  { "/_Sbor", 			NULL, 	NULL, 	IDM_FILEMENU, "<Branch>" },
  { "/Sbor/_Otvori...",     	"O", 	GS_CMD,	IDM_OPEN, NULL },
  { "/Sbor/_Vybra sbor...",    "S", 	GS_CMD,	IDM_SELECT, NULL },
  { "/Sbor/Uloi _ako...",     	"A", 	GS_CMD,	IDM_SAVEAS, NULL },
  { "/Sbor/_Zavrie",     	"C", 	GS_CMD,	IDM_CLOSE, NULL },
  { "/Sbor/_Informcie...",     	"I", 	GS_CMD,	IDM_INFO, NULL },
  { "/Sbor/sep1",     		NULL,   NULL, 		0, "<Separator>" },
  { "/Sbor/_Konvertova...",     	NULL, 	GS_CMD,	IDM_CONVERTFILE, NULL },
  { "/Sbor/_Extrahova...",     	"E", 	GS_CMD,	IDM_EXTRACT, NULL },
  { "/Sbor/PS do EPS",     	NULL, 	GS_CMD,	IDM_PSTOEPS, NULL },
  { "/Sbor/sep2",     		NULL,   NULL, 		0, "<Separator>" },
  { "/Sbor/_Tlai...",     	"P", 	GS_CMD,	IDM_PRINT, NULL },
  { "/Sbor/Tlai sbor...",     	NULL, 	GS_CMD,	IDM_SPOOL, NULL },
  { "/Sbor/sep3",     		NULL,   NULL, 		0, "<Separator>" },
  { "/Sbor/Zobrazi sprvy",     	"M", 	GS_CMD,	IDM_GSMESS, NULL },
  { "/Sbor/sep4",     		NULL,   NULL, 		0, "<Separator>" },
  { "/Sbor/1LASTFILE",     	NULL, 	GS_CMD,	IDM_LASTFILE1, NULL },
  { "/Sbor/2LASTFILE",     	NULL, 	GS_CMD,	IDM_LASTFILE2, NULL },
  { "/Sbor/3LASTFILE",     	NULL, 	GS_CMD,	IDM_LASTFILE3, NULL },
  { "/Sbor/4LASTFILE",     	NULL, 	GS_CMD,	IDM_LASTFILE4, NULL },
  { "/Sbor/sep5",     		NULL,   NULL, 		0, "<Separator>" },
  { "/Sbor/_Skoni",     		NULL, 	GS_CMD,	IDM_EXIT, NULL },

  { "/pr_avy",      		NULL,   NULL, 	IDM_EDITMENU, "<Branch>" },
/*
  { "/pravy/_Koprova",     		"<control>C", GS_CMD, IDM_COPYCLIP, NULL },
  { "/pravy/sep1",     		NULL,   NULL, 		0, "<Separator>" },
  { "/pravy/Konvertova _bitov mapu",    NULL,	GS_CMD,	IDM_CONVERT, NULL },
*/
  { "/pravy/Uloi obrzok ako bitov mapu",     	NULL,	GS_CMD,	IDM_PASTETO, NULL },
  { "/pravy/sep2",     		NULL,   NULL, 		0, "<Separator>" },
  { "/pravy/_Prida EPS nhad",   NULL,   NULL, 		0, "<Branch>" },
  { "/pravy/Prida EPS nhad/_Interchange", NULL,		GS_CMD, IDM_MAKEEPSI, NULL },
  { "/pravy/Prida EPS nhad/TIFF 4", NULL,		GS_CMD, IDM_MAKEEPST4, NULL },
  { "/pravy/Prida EPS nhad/_TIFF 6 bez kompresie", NULL,	GS_CMD, IDM_MAKEEPST6U, NULL },
  { "/pravy/Prida EPS nhad/TIFF 6 _balen bity", NULL,	GS_CMD, IDM_MAKEEPST6P, NULL },
  { "/pravy/Prida EPS nhad/_Windows Meta sbor", NULL,	GS_CMD, IDM_MAKEEPSW, NULL },
  { "/pravy/Prida EPS nhad/_Pouvatesk nhad",NULL,GS_CMD, IDM_MAKEEPSU, NULL },
  { "/pravy/_Extrahova EPS",   NULL,   NULL, 	IDM_EXTEPSMENU, "<Branch>" },
  { "/pravy/Extrahova EPS/_PostScript", NULL,		GS_CMD, IDM_EXTRACTPS, NULL },
  { "/pravy/Extrahova EPS/_Nhad", NULL,			GS_CMD, IDM_EXTRACTPRE, NULL },
  { "/pravy/sep3",     		NULL,   NULL, 		0, "<Separator>" },
  { "/pravy/Measure", NULL,				GS_CMD, IDM_MEASURE, NULL },
  { "/pravy/Konvertova na vektorov formt...", NULL,		GS_CMD, IDM_PSTOEDIT, NULL },
  { "/pravy/_Extrahova text...", NULL,			GS_CMD, IDM_TEXTEXTRACT, NULL },
  { "/pravy/_Hada...", "<control>F",			GS_CMD, IDM_TEXTFIND, NULL },
/*
  { "/pravy/Hada _alej", "<control>G",			GS_CMD, IDM_TEXTFINDNEXT, NULL },
*/
  { "/pravy/Hada _alej", "F3",			GS_CMD, IDM_TEXTFINDNEXT, NULL },

  { "/_Monosti",      		NULL,   NULL, 		0, "<Branch>" },
  { "/Monosti/Jednoduch nastavenia...", 	NULL,		GS_CMD, IDM_CFG, NULL },
  { "/Monosti/Rozren nastavenia...", 	NULL,		GS_CMD, IDM_GSCOMMAND, NULL },
  { "/Monosti/Zvuky...", 		NULL,		GS_CMD, IDM_SOUNDS, NULL },
  { "/Monosti/_Jendotky",      		NULL,   NULL, 		0, "<Branch>" },
  { "/Monosti/Jendotky/_pt", 		NULL,		GS_CMD, IDM_UNITPT, "<CheckItem>" },
  { "/Monosti/Jendotky/_mm", 		NULL,		GS_CMD, IDM_UNITMM, "<CheckItem>" },
  { "/Monosti/Jendotky/_inch", 		NULL,		GS_CMD, IDM_UNITINCH, "<CheckItem>" },
  { "/Monosti/Jendotky/sep1",     		NULL,   NULL, 		0, "<Separator>" },
  { "/Monosti/Jendotky/_Fine Resolution", 	NULL,		GS_CMD, IDM_UNITFINE, "<CheckItem>" },
  { "/Monosti/_Jazyk",      		NULL,   NULL, 		0, "<Branch>" },
  { "/Monosti/Jazyk/_English", 	NULL,		GS_CMD, IDM_LANGEN, "<CheckItem>" },
  { "/Monosti/Jazyk/Catalan", 	NULL,		GS_CMD, IDM_LANGCT, "<CheckItem>" },
  { "/Monosti/Jazyk/_Deutsch", 	NULL,		GS_CMD, IDM_LANGDE, "<CheckItem>" },
  { "/Monosti/Jazyk/_Greek", 	NULL,		GS_CMD, IDM_LANGGR, "<CheckItem>" },
  { "/Monosti/Jazyk/E_spaol", 	NULL,		GS_CMD, IDM_LANGES, "<CheckItem>" },
  { "/Monosti/Jazyk/_Franais", 	NULL,		GS_CMD, IDM_LANGFR, "<CheckItem>" },
  { "/Monosti/Jazyk/_Italiano", 	NULL,		GS_CMD, IDM_LANGIT, "<CheckItem>" },
  { "/Monosti/Jazyk/_Nederlands", 	NULL,		GS_CMD, IDM_LANGNL, "<CheckItem>" },
  { "/Monosti/Jazyk/Russian", 	NULL,		GS_CMD, IDM_LANGRU, "<CheckItem>" },
  { "/Monosti/Jazyk/Slovak", 	NULL,		GS_CMD, IDM_LANGSK, "<CheckItem>" },
  { "/Monosti/Jazyk/Svenska", 	NULL,		GS_CMD, IDM_LANGSE, "<CheckItem>" },
  { "/Monosti/PStoText",      		NULL,   NULL, 		0, "<Branch>" },
  { "/Monosti/PStoText/Vypnut", 	NULL,		GS_CMD, IDM_PSTOTEXTDIS, "<CheckItem>" },
  { "/Monosti/PStoText/Normlny", 	NULL,		GS_CMD, IDM_PSTOTEXTNORM, "<CheckItem>" },
  { "/Monosti/PStoText/Dvips Cork enkdovanie", 	NULL,	GS_CMD, IDM_PSTOTEXTCORK, "<CheckItem>" },
  { "/Monosti/DSC upozornenia",      		NULL,   NULL, 		0, "<Branch>" },
  { "/Monosti/DSC upozornenia/Vypnut", 	NULL,		GS_CMD, IDM_DSC_OFF, "<CheckItem>" },
  { "/Monosti/DSC upozornenia/Chyby", 	NULL,		GS_CMD, IDM_DSC_ERROR, "<CheckItem>" },
  { "/Monosti/DSC upozornenia/Upozornenia", 	NULL,		GS_CMD, IDM_DSC_WARN, "<CheckItem>" },
  { "/Monosti/DSC upozornenia/Vetky", 	NULL,		GS_CMD, IDM_DSC_INFO, "<CheckItem>" },
  { "/Monosti/Uloi nastavenia _teraz", 	NULL,		GS_CMD, IDM_SETTINGS, NULL },
  { "/Monosti/sep1",     		NULL,   NULL, 		0, "<Separator>" },
  { "/Monosti/_Uloi nastavenia pri skonen", 	NULL,		GS_CMD, IDM_SAVESETTINGS, "<CheckItem>" },
  { "/Monosti/Sa_fer", 			NULL,		GS_CMD, IDM_SAFER, "<CheckItem>" },
  { "/Monosti/Save Last _Directory", 	NULL,		GS_CMD, IDM_SAVEDIR, "<CheckItem>" },
  { "/Monosti/_Button Bar", 		NULL,		GS_CMD, IDM_BUTTONSHOW, "<CheckItem>" },
/*  { "/Monosti/_Fit Window to Page", 	NULL,		GS_CMD, IDM_FITPAGE, "<CheckItem>" }, */
/*  { "/Monosti/Quick Open", 		NULL,		GS_CMD, IDM_QUICK_OPEN, "<CheckItem>" }, */
  { "/Monosti/Auto _Redisplay", 	NULL,		GS_CMD, IDM_AUTOREDISPLAY, "<CheckItem>" },
  { "/Monosti/EPS _Clip", 		NULL,		GS_CMD, IDM_EPSFCLIP, "<CheckItem>" },
  { "/Monosti/EPS _Warn", 		NULL,		GS_CMD, IDM_EPSFWARN, "<CheckItem>" },
  { "/Monosti/_Ignorova DSC", 		NULL,		GS_CMD, IDM_IGNOREDSC, "<CheckItem>" },
  { "/Monosti/Show Bounding Bo_x", 	NULL,		GS_CMD, IDM_SHOWBBOX, "<CheckItem>" },

  { "/_View",      		NULL,   NULL, 		0, "<Branch>" },
  { "/View/_Next Page", 	"plus",	GS_CMD, 	IDM_NEXT, NULL },
  { "/View/Pre_vious Page", 	"minus",	GS_CMD, 	IDM_PREV, NULL },
  { "/View/_Goto Page", 	"G",	GS_CMD, 	IDM_GOTO, NULL },
  { "/View/Go _Back", 		"B",	GS_CMD, 	IDM_GOBACK, NULL },
  { "/View/Go _Forward",	NULL,	GS_CMD, 	IDM_GOFWD, NULL },
  { "/View/_Redisplay", 	"R",	GS_CMD, 	IDM_REDISPLAY, NULL },
  { "/View/sep1",     		NULL,   NULL, 		0, "<Separator>" },
  { "/View/Next Page and Home", "space",	GS_CMD, 	IDM_NEXTHOME, NULL },
  { "/View/Previous Page and Home", "<control>H",GS_CMD, 	IDM_PREVHOME, NULL },
  { "/View/sep2",     		NULL,   NULL, 		0, "<Separator>" },
  { "/View/Full _Screen", 	"F4",	GS_CMD, 	IDM_FULLSCREEN, NULL },
  { "/View/Fit _Window", 	"F6",	GS_CMD, 	IDM_FITWIN, NULL },

  { "/_Orientcia",      		NULL,   NULL, 		0, "<Branch>" },
  { "/Orientcia/_Automatick", 		NULL,	GS_CMD, 	IDM_AUTOORIENT, "<CheckItem>" },
  { "/Orientcia/sep1",     		NULL,   NULL, 		0, "<Separator>" },
  { "/Orientcia/_Portrait", 		NULL,	GS_CMD, 	IDM_PORTRAIT, "<CheckItem>" },
  { "/Orientcia/_Landscape", 		NULL,	GS_CMD, 	IDM_LANDSCAPE, "<CheckItem>" },
  { "/Orientcia/_Obrtene", 	NULL,	GS_CMD, 	IDM_UPSIDEDOWN, "<CheckItem>" },
  { "/Orientcia/_Seascape", 		NULL,	GS_CMD, 	IDM_SEASCAPE, "<CheckItem>" },
  { "/Orientcia/sep2",     		NULL,   NULL, 		0, "<Separator>" },
  { "/Orientcia/S_wap Landscape", 	NULL,	GS_CMD, 	IDM_SWAPLANDSCAPE, "<CheckItem>" },

  { "/_Formt", 			NULL,   NULL, 		0, "<Branch>" },
  { "/Formt/_Nastavenia zobrazenia...", NULL,GS_CMD, 	IDM_DISPLAYSETTINGS, NULL },
  { "/Formt/sep1", 		NULL,   NULL, 		0, "<Separator>" },
  { "/Formt/_Rotova mdium", 	NULL,	GS_CMD, 	IDM_MEDIAROTATE, "<CheckItem>"},
  { "/Formt/sep2",     		NULL,   NULL, 		0, "<Separator>" },
  { "/Formt/11x17", 		NULL,	GS_CMD, 	IDM_11x17, "<CheckItem>" },
  { "/Formt/A3", 		NULL,	GS_CMD, 	IDM_A3, "<CheckItem>" },
  { "/Formt/A4", 		NULL,	GS_CMD, 	IDM_A4, "<CheckItem>" },
  { "/Formt/A5", 		NULL,	GS_CMD, 	IDM_A5, "<CheckItem>" },
  { "/Formt/B4", 		NULL,	GS_CMD, 	IDM_B4, "<CheckItem>" },
  { "/Formt/B5", 		NULL,	GS_CMD, 	IDM_B5, "<CheckItem>" },
  { "/Formt/Ledger", 		NULL,	GS_CMD, 	IDM_LEDGER, "<CheckItem>" },
  { "/Formt/Legal", 		NULL,	GS_CMD, 	IDM_LEGAL, "<CheckItem>" },
  { "/Formt/Letter", 		NULL,	GS_CMD, 	IDM_LETTER, "<CheckItem>" },
  { "/Formt/Note", 		NULL,	GS_CMD, 	IDM_NOTE, "<CheckItem>" },
  { "/Formt/Pouvateom definovan...", 	NULL,	GS_CMD, 	IDM_USERSIZE, "<CheckItem>"},
  { "/Formt/USERSIZE1", 	NULL,	GS_CMD, 	IDM_USERSIZE1, "<CheckItem>"},
  { "/Formt/USERSIZE2", 	NULL,	GS_CMD, 	IDM_USERSIZE2, "<CheckItem>"},
  { "/Formt/USERSIZE3", 	NULL,	GS_CMD, 	IDM_USERSIZE3, "<CheckItem>"},
  { "/Formt/USERSIZE4", 	NULL,	GS_CMD, 	IDM_USERSIZE4, "<CheckItem>"},
  { "/Formt/USERSIZE5", 	NULL,	GS_CMD, 	IDM_USERSIZE5, "<CheckItem>"},
  { "/Formt/USERSIZE6", 	NULL,	GS_CMD, 	IDM_USERSIZE6, "<CheckItem>"},
  { "/Formt/USERSIZE7", 	NULL,	GS_CMD, 	IDM_USERSIZE7, "<CheckItem>"},
  { "/Formt/USERSIZE8", 	NULL,	GS_CMD, 	IDM_USERSIZE8, "<CheckItem>"},
  { "/Formt/USERSIZE9", 	NULL,	GS_CMD, 	IDM_USERSIZE9, "<CheckItem>"},
  { "/Formt/USERSIZE10", 	NULL,	GS_CMD, 	IDM_USERSIZE10, "<CheckItem>"},
  { "/Formt/USERSIZE11", 	NULL,	GS_CMD, 	IDM_USERSIZE11, "<CheckItem>"},
  { "/Formt/USERSIZE12", 	NULL,	GS_CMD, 	IDM_USERSIZE12, "<CheckItem>"},
  { "/Formt/USERSIZE13", 	NULL,	GS_CMD, 	IDM_USERSIZE13, "<CheckItem>"},

  { "/_Pomocnk",      		"F1",   NULL, 		0, "<Branch>" },
  { "/Pomocnk/_Obsah", 		NULL,	GS_CMD, 	IDM_HELPCONTENT, NULL },
  { "/Pomocnk/_Register", NULL,	GS_CMD, 	IDM_HELPSEARCH, NULL },
  { "/Pomocnk/_Klvesov skratky", 	NULL,	GS_CMD, 	IDM_HELPKEYS, NULL },
  { "/Pomocnk/sep1",		NULL,   NULL, 		0, "<Separator>" },
  { "/Pomocnk/R_egistrcia...", 	NULL,	GS_CMD, 	IDM_REGISTER, NULL },
  { "/Pomocnk/_o je...", 		NULL,	GS_CMD, 	IDM_ABOUT, NULL },
};

int menu_sk_len = sizeof (menu_sk) / sizeof (menu_sk[0]);

