# redhat/graphviz.spec.fedora.  Generated from graphviz.spec.fedora.in by configure.

#-- Global graphviz rpm and src.rpm tags-------------------------------------
Name:    graphviz
Summary: Graph Visualization Tools
Version: 2.42.3
Release: 1%{?dist}
Group:   Applications/Multimedia
License: EPL
URL:     http://www.graphviz.org/
Source0: http://www.graphviz.org/pub/graphviz/stable/SOURCES/graphviz-2.42.3.tar.gz

# Necessary conditionals
%ifarch %{mono_arches}
%global SHARP  1
%else
%global SHARP  0
%endif

# Assuming Fedora
%global LICENSE  1
%global GOLANG   1
%global OCAML    1
%global ARRRR    1
%global DEVIL    1
%global ANN      1
%global GTS      1
%global GTK      0
%global LASI     1
%global WEBP     1
%global PYTHON   0
%global PYTHON2  1
%global PYTHON3  1
%global QT5      1
# Not yet.
%global MING     0

# Overrides for RHEL
%if 0%{?rhel}
%global LICENSE  0
%global GOLANG   0
%global SHARP    0
%global ARRRR    0
%global DEVIL    0
%global ANN      0
%global GTS      0
%global GTK      0
%global LASI     0
%global WEBP     0
%global PYTHON   1
%global PYTHON2  0
%global PYTHON3  0
%endif

# Plugins version
%global pluginsver 6

BuildRoot:     %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires: zlib-devel expat-devel ksh bison m4 flex swig gcc-c++
BuildRequires: libXaw-devel libSM-devel libICE-devel libXpm-devel libXt-devel
BuildRequires: libXmu-devel libXext-devel libX11-devel gtk2-devel freeglut-devel
BuildRequires: freetype-devel fontconfig-devel cairo-devel pango-devel
BuildRequires: gmp-devel gd gd-devel librsvg2-devel
BuildRequires: ghostscript-devel poppler-glib-devel libtool-ltdl libtool-ltdl-devel
BuildRequires: ruby ruby-devel guile-devel java-devel php-devel lua-devel
BuildRequires: perl-devel perl-libs perl-ExtUtils-Embed tcl tcl-devel tk tk-devel

%if %{SHARP}
BuildRequires: mono-core
%endif
%if %{DEVIL}
BuildRequires: DevIL-devel
%endif
%if %{ARRRR}
BuildRequires: R-devel
%endif
%if %{OCAML}
BuildRequires: ocaml
%endif
%if %{ANN}
BuildRequires: ann-devel
%endif
%if %{GTS}
BuildRequires: gts-devel
%endif
%if %{WEBP}
BuildRequires: libwebp-devel
%endif
%if %{LASI}
BuildRequires: lasi-devel
%endif
%if %{PYTHON}
BuildRequires: python python-devel
%endif
%if %{PYTHON2}
BuildRequires: python2 python2-devel
%endif
%if %{PYTHON3}
BuildRequires: python3 python3-devel
%endif
%if %{GOLANG}
BuildRequires: golang gcc-go swig >= 3.0.2
%endif
%if %{GTK}
BuildRequires: libglade2-devel gtkglarea2-devel gtkglext-devel glade3-libgladeui-devel
%endif
%if %{QT5}
BuildRequires: qt5-qtbase-devel
%endif

# What a meal PHP makes of versioning !!!
%define php_extdir %(php-config --extension-dir 2>/dev/null || echo %{_libdir}/php4)
%global php_apiver %((echo 0; php -i 2>/dev/null | sed -n 's/^PHP API => //p') | tail -1)

%if "%{php_version}" < "5.6"
%global ini_name     %{name}.ini
%else
%global ini_name     40-%{name}.ini
%endif

# Fix private-shared-object-provides
# RPM 4.8
%{?filter_provides_in: %filter_provides_in %{php_extdir}/.*\.so$}
%{?filter_setup}
# RPM 4.9
%global __provides_exclude_from %{?__provides_exclude_from:%__provides_exclude_from|}%{php_extdir}/.*\\.so$

# Fix for the i386 extended precision (rhbz#772637)
%ifarch i386 i686
%global FFSTORE -ffloat-store
%endif

#-- main graphviz rpm ------------------------------------------------
Requires:         %{name}-nox = %{version}-%{release}
Requires:         %{name}-x = %{version}-%{release}

%description
A collection of tools for the manipulation and layout
of graphs (as in nodes and edges, not as in bar-charts).

%files
%defattr(-,root,root,-)
%if %{LICENSE}
%license COPYING
%endif
%doc COPYING AUTHORS ChangeLog NEWS README

#-- graphviz-nox rpm --------------------------------------------------
%package nox
Group:            Applications/Multimedia
Summary:          Graphviz commands with no X11 dependencies
Requires:         urw-fonts
Requires:         %{name}-libs = %{version}-%{release}
Requires:         %{name}-plugins-core = %{version}-%{release}
Provides:         %{name}-nox = %{version}-%{release}

%description nox
Graphviz plugins and commands that do not depend on x11. 
When used alone, this is intended for minimalist web-server apps
with no X11 on the server.

%files nox
%defattr(-,root,root,-)
%if %{LICENSE}
%license COPYING
%endif
%doc COPYING AUTHORS ChangeLog NEWS README
%exclude %{_bindir}/dot_builtins
%{_bindir}/acyclic
%{_bindir}/bcomps
%{_bindir}/ccomps
%{_bindir}/circo
%{_bindir}/cluster
%{_bindir}/dijkstra
%{_bindir}/dot
%{_bindir}/dot2gxl
%{_bindir}/fdp
%{_bindir}/gc
%{_bindir}/gml2gv
%{_bindir}/graphml2gv
%{_bindir}/gv2gml
%{_bindir}/gv2gxl
%{_bindir}/gvcolor
%{_bindir}/gvgen
%{_bindir}/gvmap
%{_bindir}/gvmap.sh
%{_bindir}/gvpack
%{_bindir}/gvpr
%{_bindir}/gxl2dot
%{_bindir}/gxl2gv
%if %{ANN}
%{_bindir}/mingle
%endif
%{_bindir}/edgepaint
%{_bindir}/mm2gv
%{_bindir}/neato
%{_bindir}/nop
%{_bindir}/osage
%{_bindir}/patchwork
%{_bindir}/prune
%{_bindir}/sccmap
%{_bindir}/sfdp
%{_bindir}/tred
%{_bindir}/twopi
%{_bindir}/unflatten
%{_mandir}/man1/acyclic.1*
%{_mandir}/man1/bcomps.1*
%{_mandir}/man1/ccomps.1*
%{_mandir}/man1/circo.1*
%{_mandir}/man1/cluster.1*
%{_mandir}/man1/dijkstra.1*
%{_mandir}/man1/dot.1*
%{_mandir}/man1/dot2gxl.1*
%{_mandir}/man1/fdp.1*
%{_mandir}/man1/gc.1*
%{_mandir}/man1/gml2gv.1*
%{_mandir}/man1/graphml2gv.1*
%{_mandir}/man1/gv2gml.1*
%{_mandir}/man1/gv2gxl.1*
%{_mandir}/man1/gvcolor.1*
%{_mandir}/man1/gvgen.1*
%{_mandir}/man1/gvmap.1*
%{_mandir}/man1/gvmap.sh.1*
%{_mandir}/man1/gvpack.1*
%{_mandir}/man1/gvpr.1*
%{_mandir}/man1/gxl2dot.1*
%{_mandir}/man1/gxl2gv.1*
%{_mandir}/man1/mingle.1*
%{_mandir}/man1/edgepaint.1*
%{_mandir}/man1/mm2gv.1*
%{_mandir}/man1/neato.1*
%{_mandir}/man1/nop.1*
%{_mandir}/man1/osage.1*
%{_mandir}/man1/patchwork.1*
%{_mandir}/man1/prune.1*
%{_mandir}/man1/sccmap.1*
%{_mandir}/man1/sfdp.1*
%{_mandir}/man1/tred.1*
%{_mandir}/man1/twopi.1*
%{_mandir}/man1/unflatten.1*
%{_mandir}/man7/graphviz.7*
%dir %{_datadir}/graphviz
%{_datadir}/graphviz/gvpr/*

#-- graphviz-libs rpm --------------------------------------------------
%package libs
Group:            Applications/Multimedia
Summary:          Graphviz base libs
Requires(post):   /sbin/ldconfig
Requires(postun): /sbin/ldconfig

%description libs
Graphviz core libs 

%post libs
/sbin/ldconfig

%postun libs
/sbin/ldconfig

%files libs
%defattr(-,root,root,-)
%{_libdir}/libcdt.so.*
%{_libdir}/libcgraph.so.*
%{_libdir}/libgvc.so.*
%{_libdir}/libgvpr.so.*
%{_libdir}/libpathplan.so.*
%{_libdir}/libxdot.so.4*
%{_libdir}/liblab_gamut.so.*
%exclude %{_libdir}/graphviz/*

#-- graphviz-plugins-core rpm --------------------------------------------------
%package plugins-core
Group:            Applications/Multimedia
Summary:          Graphviz plugins - core layout engines and text renderers
Requires:         %{name}-nox = %{version}-%{release}

%description plugins-core
Graphviz plugins - core layout engines and text renderers

# run "dot -c" to generate plugin config in {_libdir}/graphviz/config%{pluginsver}
%post plugins-core
LD_LIBRARY_PATH=$RPM_INSTALL_PREFIX0/%{_lib} $RPM_INSTALL_PREFIX0/bin/dot -c

# if there is no dot after everything else is done, then remove config
%postun plugins-core
if [ $1 -eq 0 ]; then
        rm -f $RPM_INSTALL_PREFIX0/%{_lib}/graphviz/config6 || :
fi

%files plugins-core
%defattr(-,root,root,-)
%dir %{_libdir}/graphviz
%{_libdir}/graphviz/libgvplugin_core.so.*
%{_libdir}/graphviz/libgvplugin_dot_layout.so.*
%{_libdir}/graphviz/libgvplugin_neato_layout.so.*

#-- graphviz-x rpm --------------------------------------------------
%package x
Group:            Applications/Multimedia
Summary:          Graphviz commands with X11 dependencies
Requires:         %{name}-nox = %{version}-%{release}
Requires:         %{name}-plugins-x = %{version}-%{release}

%description x
Graphviz commands with X11 dependencies

%files x
%defattr(-,root,root,-)
%if %{LICENSE}
%license COPYING
%endif
%doc COPYING AUTHORS ChangeLog NEWS README
%{_bindir}/lefty
%{_bindir}/lneato
%{_bindir}/dotty
%{_bindir}/vimdot
%{_mandir}/man1/lefty.1*
%{_mandir}/man1/lneato.1*
%{_mandir}/man1/dotty.1*
%{_mandir}/man1/vimdot.1*
%{_datadir}/graphviz/lefty
%if %{GTK}
%{_bindir}/smyrna
%{_datadir}/graphviz/smyrna
%{_mandir}/man1/smyrna.1*
%endif

#-- graphviz-plugins-x rpm --------------------------------------------------
%package plugins-x
Group:            Applications/Multimedia
Summary:          Graphviz plugins with X11 dependencies
Requires:         %{name} = %{version}-%{release}

%description plugins-x
Graphviz plugins that depend on x11 - most installations will want this.

# run "dot -c" to generate plugin config in {_libdir}/graphviz/config6
%post plugins-x
LD_LIBRARY_PATH=$RPM_INSTALL_PREFIX0/%{_lib} $RPM_INSTALL_PREFIX0/bin/dot -c

%postun plugins-x
[ -x $RPM_INSTALL_PREFIX0/bin/dot ] && LD_LIBRARY_PATH=$RPM_INSTALL_PREFIX0/%{_lib} $RPM_INSTALL_PREFIX0/bin/dot -c || :

%files plugins-x
%defattr(-,root,root,-)
%dir %{_libdir}/graphviz
%{_libdir}/graphviz/libgvplugin_xlib.so.*
%{_libdir}/graphviz/libgvplugin_pango.so.*
%{_libdir}/graphviz/libgvplugin_rsvg.so.*
%{_libdir}/graphviz/libgvplugin_gdk.so.*
%{_libdir}/graphviz/libgvplugin_gs.so.*
%{_libdir}/graphviz/libgvplugin_poppler.so.*
%if %{GTK}
%{_libdir}/graphviz/libgvplugin_gtk.so.*
%endif
%if %{LASI}
%{_libdir}/graphviz/libgvplugin_lasi.so.*
%endif

#-- graphviz-gd rpm --------------------------------------------------
%package gd
Group:            Applications/Multimedia
Summary:          Graphviz binaries that depend on libgd
Requires:         %{name} = %{version}-%{release}

# this next Requires is not strictly neccessary for diffimg,
#   but users will probably expect the plugins to get pulled in
Requires:         %{name}-plugins-gd = %{version}-%{release} 

%description gd
Graphviz binaries that depend on gd.  (Unless you absolutely have
to use GIF, you are recommended to use the PNG format instead because
of the better quality anti-aliased lines provided by the cairo+pango
based renderer.)

%files gd
%defattr(-,root,root,-)
%{_bindir}/diffimg
%{_mandir}/man1/diffimg.1*

#-- graphviz-plugins-gd rpm --------------------------------------------------
%package plugins-gd
Group:            Applications/Multimedia
Summary:          Graphviz plugin for gd renderers
Requires:         %{name} = %{version}-%{release}

%description plugins-gd
Graphviz plugin for image rendering using libgd.  (Unless you absolutely have
to use GIF, you are recommended to use the PNG format instead because
of the better quality anti-aliased lines provided by the cairo+pango
based renderer.)

# run "dot -c" to generate plugin config in {_libdir}/graphviz/config6
%post plugins-gd
LD_LIBRARY_PATH=$RPM_INSTALL_PREFIX0/%{_lib} $RPM_INSTALL_PREFIX0/bin/dot -c

%postun plugins-gd
[ -x $RPM_INSTALL_PREFIX0/bin/dot ] && LD_LIBRARY_PATH=$RPM_INSTALL_PREFIX0/%{_lib} $RPM_INSTALL_PREFIX0/bin/dot -c || :

%files plugins-gd
%defattr(-,root,root,-)
%dir %{_libdir}/graphviz
%{_libdir}/graphviz/libgvplugin_gd.so.*

#-- graphviz-plugins-webp rpm --------------------------------------------------
%if %{WEBP}
%package plugins-webp
Group:            Applications/Multimedia
Summary:          Graphviz plugin for webp format images, using libwebp
Requires:         %{name}-x = %{version}-%{release}
Obsoletes:        %{name}-webp <= 2.41
Provides:         %{name}-webp = %{version}-%{release}

%description plugins-webp
Graphviz plugin for webp image rendering. 

# run "dot -c" to generate plugin config in {_libdir}/graphviz/config6
%post plugins-webp
LD_LIBRARY_PATH=$RPM_INSTALL_PREFIX0/%{_lib} $RPM_INSTALL_PREFIX0/bin/dot -c

%postun plugins-webp
[ -x $RPM_INSTALL_PREFIX0/bin/dot ] && LD_LIBRARY_PATH=$RPM_INSTALL_PREFIX0/%{_lib} $RPM_INSTALL_PREFIX0/bin/dot -c || :

%files plugins-webp
%defattr(-,root,root,-)
%dir %{_libdir}/graphviz
%{_libdir}/graphviz/libgvplugin_webp.so.*
%endif

#-- graphviz-plugins-visio rpm --------------------------------------------------
%package plugins-visio
Group:            Applications/Multimedia
Summary:          Graphviz plugin for visio format images
Requires:         %{name}-nox = %{version}-%{release}

%description plugins-visio
Graphviz plugin for visio image rendering. 

# run "dot -c" to generate plugin config in {_libdir}/graphviz/config6
%post plugins-visio
LD_LIBRARY_PATH=$RPM_INSTALL_PREFIX0/%{_lib} $RPM_INSTALL_PREFIX0/bin/dot -c

%postun plugins-visio
[ -x $RPM_INSTALL_PREFIX0/bin/dot ] && LD_LIBRARY_PATH=$RPM_INSTALL_PREFIX0/%{_lib} $RPM_INSTALL_PREFIX0/bin/dot -c || :

%files plugins-visio
%defattr(-,root,root,-)
%dir %{_libdir}/graphviz
%{_libdir}/graphviz/libgvplugin_visio.so.*

#-- graphviz-plugins-devil rpm --------------------------------------------------
%if %{DEVIL}
%package plugins-devil
Group:            Applications/Multimedia
Summary:          Graphviz plugin for renderers based on DevIL
Requires:         %{name}-x = %{version}-%{release}
Obsoletes:        %{name}-devil <= 2.41
Provides:         %{name}-devil = %{version}-%{release}

%description plugins-devil
Graphviz plugin for renderers based on DevIL.  (Unless you absolutely have
to use BMP, TIF, or TGA, you are recommended to use the PNG format instead
supported directly by the cairo+pango based renderer in the base graphviz rpm.)

# run "dot -c" to generate plugin config in {_libdir}/graphviz/config6
%post plugins-devil
LD_LIBRARY_PATH=$RPM_INSTALL_PREFIX0/%{_lib} $RPM_INSTALL_PREFIX0/bin/dot -c

%postun plugins-devil
[ -x $RPM_INSTALL_PREFIX0/bin/dot ] && LD_LIBRARY_PATH=$RPM_INSTALL_PREFIX0/%{_lib} $RPM_INSTALL_PREFIX0/bin/dot -c || :

%files plugins-devil
%defattr(-,root,root,-)
%dir %{_libdir}/graphviz
%{_libdir}/graphviz/libgvplugin_devil.so.*
%endif

#-- graphviz-plugins-ming rpm --------------------------------------------------
%if %{MING}
%package plugins-ming
Group:            Applications/Multimedia
Summary:          Graphviz plugin for flash renderer based on ming
Requires:         %{name}-x = %{version}-%{release}
Obsoletes:        %{name}-ming <= 2.41
Provides:         %{name}-ming = %{version}-%{release}

%description plugins-ming
Graphviz plugin for -Tswf (flash) renderer based on ming.

# run "dot -c" to generate plugin config in {_libdir}/graphviz/config6
%post plugins-ming
LD_LIBRARY_PATH=$RPM_INSTALL_PREFIX0/%{_lib} $RPM_INSTALL_PREFIX0/bin/dot -c

%postun plugins-ming
[ -x $RPM_INSTALL_PREFIX0/bin/dot ] && LD_LIBRARY_PATH=$RPM_INSTALL_PREFIX0/%{_lib} $RPM_INSTALL_PREFIX0/bin/dot -c || :

%files plugins-ming
%{_libdir}/graphviz/libgvplugin_ming.so.*
%{_libdir}/graphviz/*fdb
%endif

#-- graphviz-qt rpm --------------------------------------------------
%package qt
Group:            Applications/Multimedia
Summary:          Graphviz applications using _QT
Requires:         %{name}-x = %{version}-%{release}

%description qt
Graphviz applications using _QT - currently just gvedit

%files qt
%defattr(-,root,root,-)
%{_bindir}/gvedit
%{_datadir}/graphviz/gvedit
%{_mandir}/man1/gvedit.1*

#-- graphviz-lang-sharp rpm --------------------------------------------
%if %{SHARP}
%package lang-sharp
Group:          Applications/Multimedia
Summary:        C# extension for graphviz
Requires:       %{name} = %{version}-%{release}, mono-core
Obsoletes:      %{name}-sharp <= 2.41
Provides:       %{name}-sharp = %{version}-%{release}

%description lang-sharp
C# extension for graphviz.

%files lang-sharp
%defattr(-,root,root,-)
%dir %{_libdir}/graphviz/sharp
%{_libdir}/graphviz/sharp/*
%{_mandir}/man3/*.3sharp.*
%endif

#-- graphviz-lang-go rpm --------------------------------------------
%if %{GOLANG}
%package lang-go
Group:          Applications/Multimedia
Summary:        GO extension for graphviz
Requires:       %{name} = %{version}-%{release}, golang
Obsoletes:      %{name}-go <= 2.41
Provides:       %{name}-go = %{version}-%{release}

%description lang-go
Guile extension for graphviz.

%files lang-go
%defattr(-,root,root,-)
%dir %{_libdir}/graphviz/go
%{_libdir}/graphviz/go/*
%{_mandir}/man3/*.3go.*
%endif

#-- graphviz-lang-guile rpm --------------------------------------------
%package lang-guile
Group:          Applications/Multimedia
Summary:        Guile extension for graphviz
Requires:       %{name} = %{version}-%{release}, guile
Obsoletes:      %{name}-guile <= 2.41
Provides:       %{name}-guile = %{version}-%{release}

%description lang-guile
Guile extension for graphviz.

%files lang-guile
%defattr(-,root,root,-)
%dir %{_libdir}/graphviz/guile
%{_libdir}/graphviz/guile/*
%{_mandir}/man3/*.3guile.*

#-- graphviz-lang-io rpm -----------------------------------------------
%if 0%{?_IO}
%package lang-io
Group:          Applications/Multimedia
Summary:        Io extension for graphviz
Requires:       %{name} = %{version}-%{release}, io
Obsoletes:      %{name}-io <= 2.41
Provides:       %{name}-io = %{version}-%{release}

%description lang-io
Io extension for graphviz.

%files lang-io
%defattr(-,root,root,-)
%{_mandir}/man3/*.3io.*
%endif

#-- graphviz-lang-java rpm ---------------------------------------------
%package lang-java
Group:          Applications/Multimedia
Summary:        Java extension for graphviz
Requires:       %{name} = %{version}-%{release}, java
Obsoletes:      %{name}-java <= 2.41
Provides:       %{name}-java = %{version}-%{release}

%description lang-java
Java extension for graphviz.

%files lang-java
%defattr(-,root,root,-)
%dir %{_libdir}/graphviz/java
%{_libdir}/graphviz/java/*
%{_mandir}/man3/*.3java.*

#-- graphviz-lang-lua rpm ----------------------------------------------
%package lang-lua
Group:          Applications/Multimedia
Summary:        Lua extension for graphviz
Requires:       %{name} = %{version}-%{release}, lua
Obsoletes:      %{name}-lua <= 2.41
Provides:       %{name}-lua = %{version}-%{release}

%description lang-lua
Lua extension for graphviz.

%files lang-lua
%defattr(-,root,root,-)
%{_libdir}/lua*/*
%{_datadir}/graphviz/demo/*.lua*
%{_mandir}/man3/*.3lua.*
%exclude %{_libdir}/graphviz/lua/*.so

#-- graphviz-lang-ocaml rpm --------------------------------------------
%if %{OCAML}
%package lang-ocaml
Group:          Applications/Multimedia
Summary:        Ocaml extension for graphviz
Requires:       %{name} = %{version}-%{release}, ocaml
Obsoletes:      %{name}-ocaml <= 2.41
Provides:       %{name}-ocaml = %{version}-%{release}

%description lang-ocaml
Ocaml extension for graphviz.

%files lang-ocaml
%defattr(-,root,root,-)
%dir %{_libdir}/graphviz/ocaml
%{_libdir}/graphviz/ocaml/*
%{_mandir}/man3/*.3ocaml.*
%endif

#-- graphviz-lang-perl rpm ---------------------------------------------
%package lang-perl
Group:          Applications/Multimedia
Summary:        Perl extension for graphviz
Requires:       %{name} = %{version}-%{release}, perl
Obsoletes:      %{name}-perl <= 2.41
Provides:       %{name}-perl = %{version}-%{release}

%description lang-perl
Perl extension for graphviz.

%files lang-perl
%defattr(-,root,root,-)
%{_libdir}/perl*/*
%{_datadir}/graphviz/demo/*.pl*
%{_mandir}/man3/*.3perl.*
%exclude %{_libdir}/graphviz/perl/*.so
%exclude %{_libdir}/graphviz/perl/*.pm

#-- graphviz-lang-php rpm ----------------------------------------------
%package lang-php
Group:          Applications/Multimedia
Summary:        PHP extension for graphviz
Requires:       %{name} = %{version}-%{release}, /usr/bin/php
Obsoletes:      %{name}-php <= 2.41
Provides:       %{name}-php = %{version}-%{release}

%description lang-php
PHP extension for graphviz.

%files lang-php
%defattr(-,root,root,-)
%config(noreplace) %{_sysconfdir}/php.d/%{name}.ini
%{php_extdir}/gv.so
%{_datadir}/php*/*
%{_datadir}/graphviz/demo/*.php*
%{_mandir}/man3/*.3php.*
%exclude %{_libdir}/graphviz/php/*.so
%exclude %{_libdir}/graphviz/php/*.php

#-- graphviz-lang-python rpm -------------------------------------------
%if %{PYTHON}
%package lang-python
Group:          Applications/Multimedia
Summary:        Python extension for graphviz
Requires:       %{name} = %{version}-%{release}, python
Obsoletes:      %{name}-python <= 2.41
Provides:       %{name}-python = %{version}-%{release}

%description lang-python
Python extension for graphviz.

%files lang-python
%defattr(-,root,root,-)
%{_libdir}/python*/*
%{_datadir}/graphviz/demo/*.py*
%{_mandir}/man3/gv.3python.*
%exclude %{_libdir}/graphviz/python*/*.so
%exclude %{_libdir}/graphviz/python*/*.py*
%endif

#-- graphviz-lang-python2 rpm -------------------------------------------
%if %{PYTHON2}
%package lang-python2
Group:          Applications/Multimedia
Summary:        Python extension for graphviz
Requires:       %{name} = %{version}-%{release}, python2
Conflicts:      %{name}-python <= 2.41
Conflicts:      %{name}-lang-python <= 2.41

%description lang-python2
Python extension for graphviz.

%files lang-python2
%defattr(-,root,root,-)
%{_libdir}/python2*/*
%{_datadir}/graphviz/demo/*.py*
%{_mandir}/man3/gv.3python.*
%exclude %{_libdir}/graphviz/python2/*.so
%exclude %{_libdir}/graphviz/python2/*.py*
%endif

#-- graphviz-lang-python3 rpm -------------------------------------------
%if %{PYTHON3}
%package lang-python3
Group:          Applications/Multimedia
Summary:        Python extension for graphviz
Requires:       %{name} = %{version}-%{release}, python3
Conflicts:      %{name}-python <= 2.41
Conflicts:      %{name}-lang-python <= 2.41

%description lang-python3
Python extension for graphviz.

%files lang-python3
%defattr(-,root,root,-)
%{_libdir}/python3*/*
%{_datadir}/graphviz/demo/*.py*
%{_mandir}/man3/gv.3python.*
%exclude %{_libdir}/graphviz/python3/*.so
%exclude %{_libdir}/graphviz/python3/*.py*
%endif

#-- graphviz-lang-R rpm ---------------------------------------------
%if %{ARRRR}
%package lang-R
Group:          Applications/Multimedia
Summary:        R extension for graphviz
Requires:       %{name} = %{version}-%{release}, R
Obsoletes:      %{name}-R <= 2.41
Provides:       %{name}-R = %{version}-%{release}

%description lang-R
R extension for graphviz.

%files lang-R
%defattr(-,root,root,-)
%dir %{_libdir}/graphviz/R
%{_libdir}/graphviz/R/*
%{_mandir}/man3/*.3r.*
%endif

#-- graphviz-lang-ruby rpm ---------------------------------------------
%package lang-ruby
Group:          Applications/Multimedia
Summary:        Ruby extension for graphviz
Requires:       %{name} = %{version}-%{release}, ruby
Obsoletes:      %{name}-ruby <= 2.41
Provides:       %{name}-ruby = %{version}-%{release}

%description lang-ruby
Ruby extension for graphviz.

%files lang-ruby
%defattr(-,root,root,-)
%{_libdir}/*ruby*/*
%{_datadir}/graphviz/demo/*.rb*
%{_mandir}/man3/*.3ruby.*
%exclude %{_libdir}/graphviz/ruby/*.so

#-- graphviz-lang-tcl rpm ----------------------------------------------
%package lang-tcl
Group:          Applications/Multimedia
Summary:        Tcl extension & tools for graphviz
Requires:       %{name} = %{version}-%{release}, tcl >= 8.3
Obsoletes:      %{name}-tcl <= 2.41
Provides:       %{name}-tcl = %{version}-%{release}

%description lang-tcl
Various tcl packages (extensions) for the graphviz tools.

%files lang-tcl
%defattr(-,root,root,-)
%{_libdir}/tcl*/*
%{_datadir}/graphviz/demo/*.tcl*
%{_datadir}/graphviz/demo/*_data
%{_datadir}/graphviz/demo/entities.html
%{_mandir}/man3/*.3tcl.*
%exclude %{_libdir}/graphviz/tcl/*

#-- graphviz-devel rpm --------------------------------------------
%package devel
Group:          Development/Libraries
Summary:        Development package for graphviz
Requires:       %{name}-libs = %{version}-%{release}, pkgconfig
Requires(post):   /sbin/ldconfig
Requires(postun): /sbin/ldconfig

%description devel
A collection of tools for the manipulation and layout
of graphs (as in nodes and edges, not as in bar-charts).
This package contains development files for graphviz-libs.

%post devel
/sbin/ldconfig

%postun devel
/sbin/ldconfig

%files devel
%defattr(-,root,root,-)
%{_includedir}/graphviz
%{_libdir}/libcdt.so
%{_mandir}/man3/cdt.3.*
%{_libdir}/pkgconfig/libcdt.pc
%{_libdir}/libcgraph.so
%{_mandir}/man3/cgraph.3.*
%{_libdir}/pkgconfig/libcgraph.pc
%{_libdir}/libgvc.so
%{_mandir}/man3/gvc.3.*
%{_libdir}/pkgconfig/libgvc.pc
%{_libdir}/libgvpr.so
%{_mandir}/man3/gvpr.3.*
%{_libdir}/pkgconfig/libgvpr.pc
%{_libdir}/libpathplan.so
%{_mandir}/man3/pathplan.3.*
%{_libdir}/pkgconfig/libpathplan.pc
%{_libdir}/libxdot.so
%{_mandir}/man3/xdot.3.*
%{_libdir}/pkgconfig/libxdot.pc
%{_libdir}/liblab_gamut.so
%{_mandir}/man3/lab_gamut.3.*
%{_libdir}/pkgconfig/liblab_gamut.pc
%{_mandir}/man3/expr.3.*
%{_mandir}/man3/pack.3.*
%exclude %{_libdir}/graphviz/libgvplugin*
%exclude %{_libdir}/graphviz/*.so

#-- graphviz-graphs rpm -------------------------------------------
%package graphs
Group:          Applications/Multimedia
Summary:        Demo graphs for graphviz
BuildArch:      noarch

%description graphs
Some demo graphs for graphviz.

%files graphs
%defattr(-,root,root,-)
%dir %{_datadir}/graphviz
%{_datadir}/graphviz/graphs
%if %{GTK}
%{_datadir}/graphviz/examples
%endif

#-- graphviz-doc rpm ----------------------------------------------
%package doc
Group:          Documentation
Summary:        PDF and HTML documents for graphviz
BuildArch:      noarch

%description doc
Provides some additional PDF and HTML documentation for graphviz.

%files doc
%defattr(-,root,root,-)
%doc __doc/*

#-- building --------------------------------------------------

%prep
%setup -q
for p in %{patches}; do
     patch -p1 < ${p} || exit 1
done

%build
CFLAGS="$RPM_OPT_FLAGS" \
./configure \
        --prefix=%{_prefix} \
        --bindir=%{_bindir} \
        --libdir=%{_libdir} \
        --includedir=%{_includedir} \
        --datadir=%{_datadir} \
        --mandir=%{_mandir} \
        --disable-static \
        --disable-dependency-tracking \
        --enable-sharp \
        --enable-guile \
        --disable-io \
        --enable-java \
        --enable-lua \
        --enable-perl \
        --enable-php \
        --enable-ruby \
        --enable-tcl \
        --with-gdk \
        --with-ghostscript \
        --without-glitz \
        --with-ipsepcola \
%if ! %{PYTHON}
        --disable-python \
%endif
%if ! %{PYTHON2}
        --disable-python2 \
%endif
%if ! %{PYTHON3}
        --disable-python3 \
%endif
%if ! %{GOLANG}
        --disable-go \
%endif
%if ! %{ANN}
        --without-ann \
%endif
%if ! %{LASI}
        --without-lasi \
%endif
%if ! %{GTS}
        --without-gts \
%endif
%if ! %{SHARP}
        --disable-sharp \
%endif
%if ! %{OCAML}
        --disable-ocaml \
%endif
%if ! %{MING}
        --without-ming \
%endif
%if ! %{ARRRR}
        --disable-r \
%endif
%if ! %{WEBP}
        --without-webp \
%endif
%if ! %{DEVIL}
        --without-devil \
%endif
%if ! %{GTK}
        --without-gtk \
        --without-gtkgl \
        --without-gtkglext \
        --without-smyrna \
%endif
        --with-qt \
        --with-visio \
        --with-pangocairo \
        --with-poppler \
        --with-rsvg \
        --with-ortho \
        --with-sfdp \
        --with-x
make %{?_smp_mflags}

%install
rm -rf %{buildroot} __doc
make DESTDIR=%{buildroot} \
        docdir=%{buildroot}%{_docdir}/%{name} \
        pkgconfigdir=%{_libdir}/pkgconfig \
        install
find %{buildroot} -type f -name "*.la" -exec rm -f {} ';'
chmod -x %{buildroot}%{_datadir}/%{name}/lefty/*
cp -a %{buildroot}%{_datadir}/%{name}/doc __doc
rm -rf %{buildroot}%{_datadir}/%{name}/doc

# PHP configuration file
%{__mkdir_p} %{buildroot}%{_sysconfdir}/php.d
%{__cat} << __EOF__ > %{buildroot}%{_sysconfdir}/php.d/%{name}.ini
; Enable %{name} extension module
extension=gv.so
__EOF__

# Remove executable modes from demos
find %{buildroot}%{_datadir}/%{name}/demo -type f -exec chmod a-x {} ';'

# Rename python demos to prevent byte compilation
find %{buildroot}%{_datadir}/%{name}/demo -type f -name "*.py" -exec mv {} {}.demo ';'

# # Remove metadata from generated PDFs
# pushd %{buildroot}%{_docdir}/%{name}/pdf
# for f in prune lneato.1 lefty.1 gvgen.1 gc.1 dotty.1 dot.1 cluster.1
# do
#   if [ -f $f.pdf ]
#   then
# # ugly, but there is probably no better solution
#     qpdf --empty --static-id --pages $f.pdf -- $f.pdf.$$
#     mv -f $f.pdf.$$ $f.pdf
#   fi
# done

# Ghost plugins config
touch %{buildroot}%{_libdir}/graphviz/config%{pluginsver}

%check
%ifnarch ppc64 ppc
# regression test, segfaults on ppc/ppc64, possible endian issues?
#cd rtest
#make rtest
%endif

%clean
# optional regression test using the products in the build tree
# FIXME - rtest not working reliably in rpm build environment - JCE
%if 0%{?rtest}
#cd rtest
#make rtest
%endif
# clean up temporary installation
rm -rf %{buildroot}

#-- changelog --------------------------------------------------

%changelog
* Thu Oct 10 2019 John Ellson <ellson@research.att.com> 2.42.3
- see git log
  (This automatically-replaced single-entry is used for frequent
  updates in the unstable development series of releases.
  A properly constructed changelog entry is a requirement
  for stable releases.)
