
#line 3 "lex.aag.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 36
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define aagconst const
#else
#define aagconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (aag_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((aag_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE aagrestart(aagin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(aag_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct aag_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t aag_size_t;
#endif

extern aag_size_t aagleng;

extern FILE *aagin, *aagout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define aagless(n) \
	do \
		{ \
		/* Undo effects of setting up aagtext. */ \
        int aagless_macro_arg = (n); \
        YY_LESS_LINENO(aagless_macro_arg);\
		*aag_cp = (aag_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(aag_c_buf_p) = aag_cp = aag_bp + aagless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up aagtext again */ \
		} \
	while ( 0 )

#define unput(c) aagunput( c, (aagtext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct aag_buffer_state
	{
	FILE *aag_input_file;

	char *aag_ch_buf;		/* input buffer */
	char *aag_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	aag_size_t aag_buf_size;

	/* Number of characters read into aag_ch_buf, not including EOB
	 * characters.
	 */
	aag_size_t aag_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int aag_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int aag_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int aag_at_bol;

    int aag_bs_lineno; /**< The line count. */
    int aag_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int aag_fill_buffer;

	int aag_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via aagrestart()), so that the user can continue scanning by
	 * just pointing aagin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t aag_buffer_stack_top = 0; /**< index of top of stack. */
static size_t aag_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * aag_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (aag_buffer_stack) \
                          ? (aag_buffer_stack)[(aag_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (aag_buffer_stack)[(aag_buffer_stack_top)]

/* aag_hold_char holds the character lost when aagtext is formed. */
static char aag_hold_char;
static aag_size_t aag_n_chars;		/* number of characters read into aag_ch_buf */
aag_size_t aagleng;

/* Points to current character in buffer. */
static char *aag_c_buf_p = (char *) 0;
static int aag_init = 0;		/* whether we need to initialize */
static int aag_start = 0;	/* start state number */

/* Flag which is used to allow aagwrap()'s to do buffer switches
 * instead of setting up a fresh aagin.  A bit of a hack ...
 */
static int aag_did_buffer_switch_on_eof;

void aagrestart (FILE *input_file  );
void aag_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE aag_create_buffer (FILE *file,int size  );
void aag_delete_buffer (YY_BUFFER_STATE b  );
void aag_flush_buffer (YY_BUFFER_STATE b  );
void aagpush_buffer_state (YY_BUFFER_STATE new_buffer  );
void aagpop_buffer_state (void );

static void aagensure_buffer_stack (void );
static void aag_load_buffer_state (void );
static void aag_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER aag_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE aag_scan_buffer (char *base,aag_size_t size  );
YY_BUFFER_STATE aag_scan_string (aagconst char *aag_str  );
YY_BUFFER_STATE aag_scan_bytes (aagconst char *bytes,aag_size_t len  );

void *aagalloc (aag_size_t  );
void *aagrealloc (void *,aag_size_t  );
void aagfree (void *  );

#define aag_new_buffer aag_create_buffer

#define aag_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        aagensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            aag_create_buffer(aagin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->aag_is_interactive = is_interactive; \
	}

#define aag_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        aagensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            aag_create_buffer(aagin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->aag_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->aag_at_bol)

/* Begin user sect3 */

typedef unsigned char YY_CHAR;

FILE *aagin = (FILE *) 0, *aagout = (FILE *) 0;

typedef int aag_state_type;

extern int aaglineno;

int aaglineno = 1;

extern char *aagtext;
#define aagtext_ptr aagtext

static aag_state_type aag_get_previous_state (void );
static aag_state_type aag_try_NUL_trans (aag_state_type current_state  );
static int aag_get_next_buffer (void );
static void aag_fatal_error (aagconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up aagtext.
 */
#define YY_DO_BEFORE_ACTION \
	(aagtext_ptr) = aag_bp; \
	aagleng = (size_t) (aag_cp - aag_bp); \
	(aag_hold_char) = *aag_cp; \
	*aag_cp = '\0'; \
	(aag_c_buf_p) = aag_cp;

#define YY_NUM_RULES 32
#define YY_END_OF_BUFFER 33
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct aag_trans_info
	{
	flex_int32_t aag_verify;
	flex_int32_t aag_nxt;
	};
static aagconst flex_int16_t aag_accept[89] =
    {   0,
        0,    0,    4,    4,   25,   25,   30,   30,   33,   31,
       10,    2,   21,    9,   31,   31,   31,   20,   26,    1,
       19,   19,   19,   19,   19,   19,    8,    4,    5,   25,
        2,   22,   25,   30,   29,   28,   27,    9,   18,    0,
       20,   17,   20,    3,    7,   20,   20,   19,   19,   19,
       19,   19,   19,   19,    8,    4,    5,    5,    6,   25,
       24,   23,   30,    7,   20,   19,   19,   19,   19,   19,
       19,   19,   12,   19,   11,   19,   19,   19,   13,   19,
       19,   19,   15,   19,   14,   19,   16,    0
    } ;

static aagconst flex_int32_t aag_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    4,    5,    1,    1,    1,    1,    1,
        1,    6,    1,    1,    7,    8,    9,   10,   10,   10,
       10,   10,   10,   10,   10,   10,   10,    1,    1,   11,
        1,   12,    1,   13,   14,   15,   16,   17,   18,   19,
       20,   21,   22,   19,   19,   19,   19,   23,   24,   25,
       19,   26,   27,   28,   29,   19,   19,   19,   19,   19,
        1,   30,    1,    1,   19,    1,   31,   32,   33,   34,

       35,   19,   36,   37,   38,   19,   19,   19,   19,   39,
       40,   41,   19,   42,   43,   44,   45,   19,   19,   19,
       19,   19,    1,    1,    1,    1,    1,   19,   19,   19,
       19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
       19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
       19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
       19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
       19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
       19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
       19,   19,   19,   19,   19,   19,   19,   19,   19,   19,

       19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
       19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
       19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
       19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
       19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
       19,   19,   19,   19,   19
    } ;

static aagconst flex_int32_t aag_meta[46] =
    {   0,
        1,    1,    2,    3,    1,    4,    1,    5,    1,    6,
        7,    7,    1,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    3,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6
    } ;

static aagconst flex_int16_t aag_base[101] =
    {   0,
        0,  137,   43,   44,   48,   50,   45,   52,  139,  224,
      224,  224,  224,    0,   58,  111,   52,   52,  224,  224,
        0,   37,   50,   43,   47,   44,    0,    0,   68,    0,
        0,  224,   78,    0,  224,  224,  224,    0,  224,  100,
       82,  224,   83,  224,    0,   86,  224,    0,   59,   63,
       72,   80,   74,   83,    0,    0,   95,   96,  224,    0,
      224,  224,    0,    0,   98,   81,   91,   86,   94,   95,
       98,   99,    0,   98,    0,  104,   96,   99,    0,   97,
      114,  110,    0,  107,    0,  115,    0,  224,  152,  159,
      166,  173,  176,   70,  182,  189,  196,  203,  210,  216

    } ;

static aagconst flex_int16_t aag_def[101] =
    {   0,
       88,    1,   89,   89,   90,   90,   91,   91,   88,   88,
       88,   88,   88,   92,   88,   88,   88,   93,   88,   88,
       94,   94,   94,   94,   94,   94,   95,   96,   97,   98,
       98,   88,   88,   99,   88,   88,   88,   92,   88,   88,
       93,   88,   93,   88,  100,   93,   88,   94,   94,   94,
       94,   94,   94,   94,   95,   96,   97,   97,   88,   98,
       88,   88,   99,  100,   93,   94,   94,   94,   94,   94,
       94,   94,   94,   94,   94,   94,   94,   94,   94,   94,
       94,   94,   94,   94,   94,   94,   94,    0,   88,   88,
       88,   88,   88,   88,   88,   88,   88,   88,   88,   88

    } ;

static aagconst flex_int16_t aag_nxt[270] =
    {   0,
       10,   11,   12,   13,   14,   10,   15,   16,   17,   18,
       19,   10,   20,   21,   21,   21,   22,   23,   21,   24,
       21,   21,   25,   21,   21,   21,   26,   21,   21,   10,
       21,   21,   21,   22,   23,   24,   21,   21,   25,   21,
       21,   21,   26,   21,   21,   12,   12,   35,   29,   29,
       31,   32,   31,   32,   35,   36,   37,   44,   49,   46,
       45,   41,   36,   37,   39,   40,   50,   41,   51,   42,
       52,   53,   54,   58,   49,   48,   59,   33,   66,   33,
       61,   62,   67,   50,   51,   68,   52,   53,   54,   46,
       88,   41,   43,   88,   66,   65,   69,   71,   67,   70,

       88,   58,   68,   88,   59,   88,   72,   65,   73,   43,
       74,   75,   78,   69,   71,   70,   76,   77,   79,   80,
       43,   81,   72,   82,   83,   73,   74,   84,   75,   78,
       85,   86,   76,   77,   79,   87,   80,   81,   88,   82,
       83,   27,   88,   88,   84,   88,   85,   86,   88,   88,
       88,   87,   28,   28,   28,   28,   28,   28,   28,   30,
       30,   30,   30,   30,   30,   30,   34,   34,   34,   34,
       34,   34,   34,   38,   88,   38,   38,   38,   38,   38,
       47,   47,   55,   88,   55,   55,   55,   55,   55,   56,
       88,   56,   88,   56,   56,   56,   57,   88,   57,   57,

       57,   57,   57,   60,   60,   88,   60,   60,   60,   60,
       63,   88,   63,   63,   63,   63,   64,   88,   64,   64,
       64,   64,   64,    9,   88,   88,   88,   88,   88,   88,
       88,   88,   88,   88,   88,   88,   88,   88,   88,   88,
       88,   88,   88,   88,   88,   88,   88,   88,   88,   88,
       88,   88,   88,   88,   88,   88,   88,   88,   88,   88,
       88,   88,   88,   88,   88,   88,   88,   88,   88
    } ;

static aagconst flex_int16_t aag_chk[270] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    3,    4,    7,    3,    4,
        5,    5,    6,    6,    8,    7,    7,   17,   22,   18,
       17,   18,    8,    8,   15,   15,   23,   15,   24,   15,
       25,   26,   26,   29,   22,   94,   29,    5,   49,    6,
       33,   33,   50,   23,   24,   51,   25,   26,   26,   41,
       43,   41,   43,   46,   49,   46,   52,   54,   50,   53,

       57,   58,   51,   57,   58,   65,   66,   65,   67,   40,
       68,   69,   72,   52,   54,   53,   70,   71,   74,   76,
       16,   77,   66,   78,   80,   67,   68,   81,   69,   72,
       82,   84,   70,   71,   74,   86,   76,   77,    9,   78,
       80,    2,    0,    0,   81,    0,   82,   84,    0,    0,
        0,   86,   89,   89,   89,   89,   89,   89,   89,   90,
       90,   90,   90,   90,   90,   90,   91,   91,   91,   91,
       91,   91,   91,   92,    0,   92,   92,   92,   92,   92,
       93,   93,   95,    0,   95,   95,   95,   95,   95,   96,
        0,   96,    0,   96,   96,   96,   97,    0,   97,   97,

       97,   97,   97,   98,   98,    0,   98,   98,   98,   98,
       99,    0,   99,   99,   99,   99,  100,    0,  100,  100,
      100,  100,  100,   88,   88,   88,   88,   88,   88,   88,
       88,   88,   88,   88,   88,   88,   88,   88,   88,   88,
       88,   88,   88,   88,   88,   88,   88,   88,   88,   88,
       88,   88,   88,   88,   88,   88,   88,   88,   88,   88,
       88,   88,   88,   88,   88,   88,   88,   88,   88
    } ;

static aag_state_type aag_last_accepting_state;
static char *aag_last_accepting_cpos;

extern int aag_flex_debug;
int aag_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define aagmore() aagmore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *aagtext;
#line 1 "../../lib/cgraph/scan.l"
/* $Id$ $Revision$ */
/* vim:set shiftwidth=4 ts=8: */
/*************************************************************************
 * Copyright (c) 2011 AT&T Intellectual Property 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors: See CVS logs. Details at http://www.graphviz.org/
 *************************************************************************/
/* requires flex (i.e. not lex)  */
#line 17 "../../lib/cgraph/scan.l"
#include <grammar.h>
#include <cghdr.h>
#include <ctype.h>
#define GRAPH_EOF_TOKEN		'@'		/* lex class must be defined below */
	/* this is a workaround for linux flex */
static int line_num = 1;
static int html_nest = 0;  /* nesting level for html strings */
static char* InputFile;
static Agdisc_t	*Disc;
static void 	*Ifile;
static int graphType;

  /* Reset line number */
void agreadline(int n) { line_num = n; }

  /* (Re)set file:
   */
void agsetfile(char* f) { InputFile = f; line_num = 1; }

/* There is a hole here, because switching channels 
 * requires pushing back whatever was previously read.
 * There probably is a right way of doing this.
 */
void aglexinit(Agdisc_t *disc, void *ifile) { Disc = disc; Ifile = ifile; graphType = 0;}

#define isatty(x) 0
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ((result = Disc->io->afread(Ifile, buf, max_size)) < 0) \
		YY_FATAL_ERROR( "input in flex scanner failed" )
#endif

/* buffer for arbitrary length strings (longer than BUFSIZ) */
static char	*Sbuf,*Sptr,*Send;
static void beginstr(void) {
	if (Sbuf == NIL(char*)) {
		Sbuf = malloc(BUFSIZ);
		Send = Sbuf + BUFSIZ;
	}
	Sptr = Sbuf;
	*Sptr = 0;
}

static void addstr(char *src) {
	char	c;
	if (Sptr > Sbuf) Sptr--;
	do {
		do {c = *Sptr++ = *src++;} while (c && (Sptr < Send));
		if (c) {
			long	sz = Send - Sbuf;
			long	off = Sptr - Sbuf;
			sz *= 2;
			Sbuf = (char*)realloc(Sbuf,sz);
			Send = Sbuf + sz;
			Sptr = Sbuf + off;
		}
	} while (c);
}

static void endstr(void) {
	aaglval.str = (char*)agstrdup(Ag_G_global,Sbuf);
}

static void endstr_html(void) {
	aaglval.str = (char*)agstrdup_html(Ag_G_global,Sbuf);
}

static void
storeFileName (char* fname, int len)
{
    static int cnt;
    static char* buf;

    if (len > cnt) {
	if (cnt) buf = (char*)realloc (buf, len+1);
	else buf = (char*)malloc (len+1);
	cnt = len;
    }
    strcpy (buf, fname);
    InputFile = buf;
}

/* ppDirective:
 * Process a possible preprocessor line directive.
 * aagtext = #.*
 */
static void ppDirective (void)
{
    int r, cnt, lineno;
    char buf[2];
    char* s = aagtext + 1;  /* skip initial # */

    if (strncmp(s, "line", 4) == 0) s += 4;
    r = sscanf(s, "%d %1[\"]%n", &lineno, buf, &cnt);
    if (r > 0) { /* got line number */ 
	line_num = lineno - 1;
	if (r > 1) { /* saw quote */
	    char* p = s + cnt;
	    char* e = p;
	    while (*e && (*e != '"')) e++; 
	    if (e != p) {
 		*e = '\0';
		storeFileName (p, e-p);
	    }
	}
    }
}

/* chkNum:
 * The regexp for NUMBER allows a terminating letter.
 * This way we can catch a number immediately followed by a name
 * and report this to the user.
 */
static int chkNum(void) {
  unsigned char	c = (unsigned char)aagtext[aagleng-1];   /* last character */
  if (!isdigit(c) && (c != '.')) {  /* c is letter */
	char	buf[BUFSIZ];
	sprintf(buf,"syntax error - badly formed number '%s' in line %d of %s\n",aagtext,line_num, InputFile);
    strcat (buf, "splits into two name tokens\n");
	agerr(AGWARN,buf);
    return 1;
  }
  else return 0;
}

/* The LETTER class below consists of ascii letters, underscore, all non-ascii
 * characters. This allows identifiers to have characters from any
 * character set independent of locale. The downside is that, for certain
 * character sets, non-letter and, in fact, undefined characters will be
 * accepted. This is not likely and, from dot's stand, shouldn't do any
 * harm. (Presumably undefined characters will be ignored in display.) And,
 * it allows a greater wealth of names. */



#line 686 "lex.aag.c"

#define INITIAL 0
#define comment 1
#define qstring 2
#define hstring 3

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int aag_init_globals (void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int aaglex_destroy (void );

int aagget_debug (void );

void aagset_debug (int debug_flag  );

YY_EXTRA_TYPE aagget_extra (void );

void aagset_extra (YY_EXTRA_TYPE user_defined  );

FILE *aagget_in (void );

void aagset_in  (FILE * in_str  );

FILE *aagget_out (void );

void aagset_out  (FILE * out_str  );

aag_size_t aagget_leng (void );

char *aagget_text (void );

int aagget_lineno (void );

void aagset_lineno (int line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int aagwrap (void );
#else
extern int aagwrap (void );
#endif
#endif

    static void aagunput (int c,char *buf_ptr  );
    
#ifndef aagtext_ptr
static void aag_flex_strncpy (char *,aagconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int aag_flex_strlen (aagconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int aaginput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( aagtext, aagleng, 1, aagout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->aag_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( aagin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( aagin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, aagin))==0 && ferror(aagin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(aagin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "aagterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef aagterminate
#define aagterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) aag_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int aaglex (void);

#define YY_DECL int aaglex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after aagtext and aagleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	if ( aagleng > 0 ) \
		YY_CURRENT_BUFFER_LVALUE->aag_at_bol = \
				(aagtext[aagleng - 1] == '\n'); \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register aag_state_type aag_current_state;
	register char *aag_cp, *aag_bp;
	register int aag_act;
    
#line 159 "../../lib/cgraph/scan.l"

#line 876 "lex.aag.c"

	if ( !(aag_init) )
		{
		(aag_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (aag_start) )
			(aag_start) = 1;	/* first start state */

		if ( ! aagin )
			aagin = stdin;

		if ( ! aagout )
			aagout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			aagensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				aag_create_buffer(aagin,YY_BUF_SIZE );
		}

		aag_load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		aag_cp = (aag_c_buf_p);

		/* Support of aagtext. */
		*aag_cp = (aag_hold_char);

		/* aag_bp points to the position in aag_ch_buf of the start of
		 * the current run.
		 */
		aag_bp = aag_cp;

		aag_current_state = (aag_start);
		aag_current_state += YY_AT_BOL();
aag_match:
		do
			{
			register YY_CHAR aag_c = aag_ec[YY_SC_TO_UI(*aag_cp)];
			if ( aag_accept[aag_current_state] )
				{
				(aag_last_accepting_state) = aag_current_state;
				(aag_last_accepting_cpos) = aag_cp;
				}
			while ( aag_chk[aag_base[aag_current_state] + aag_c] != aag_current_state )
				{
				aag_current_state = (int) aag_def[aag_current_state];
				if ( aag_current_state >= 89 )
					aag_c = aag_meta[(unsigned int) aag_c];
				}
			aag_current_state = aag_nxt[aag_base[aag_current_state] + (unsigned int) aag_c];
			++aag_cp;
			}
		while ( aag_base[aag_current_state] != 224 );

aag_find_action:
		aag_act = aag_accept[aag_current_state];
		if ( aag_act == 0 )
			{ /* have to back up */
			aag_cp = (aag_last_accepting_cpos);
			aag_current_state = (aag_last_accepting_state);
			aag_act = aag_accept[aag_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( aag_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*aag_cp = (aag_hold_char);
			aag_cp = (aag_last_accepting_cpos);
			aag_current_state = (aag_last_accepting_state);
			goto aag_find_action;

case 1:
YY_RULE_SETUP
#line 160 "../../lib/cgraph/scan.l"
return(EOF);
	YY_BREAK
case 2:
/* rule 2 can match eol */
YY_RULE_SETUP
#line 161 "../../lib/cgraph/scan.l"
line_num++;
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 162 "../../lib/cgraph/scan.l"
BEGIN(comment);
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 163 "../../lib/cgraph/scan.l"
/* eat anything not a '*' */
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 164 "../../lib/cgraph/scan.l"
/* eat up '*'s not followed by '/'s */
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 165 "../../lib/cgraph/scan.l"
BEGIN(INITIAL);
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 166 "../../lib/cgraph/scan.l"
/* ignore C++-style comments */
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 167 "../../lib/cgraph/scan.l"
ppDirective ();
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 168 "../../lib/cgraph/scan.l"
/* ignore shell-like comments */
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 169 "../../lib/cgraph/scan.l"
/* ignore whitespace */
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 170 "../../lib/cgraph/scan.l"
return(T_node);			/* see tokens in agcanonstr */
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 171 "../../lib/cgraph/scan.l"
return(T_edge);
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 172 "../../lib/cgraph/scan.l"
if (!graphType) graphType = T_graph; return(T_graph);
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 173 "../../lib/cgraph/scan.l"
if (!graphType) graphType = T_digraph; return(T_digraph);
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 174 "../../lib/cgraph/scan.l"
return(T_strict);
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 175 "../../lib/cgraph/scan.l"
return(T_subgraph);
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 176 "../../lib/cgraph/scan.l"
if (graphType == T_digraph) return(T_edgeop); else return('-');
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 177 "../../lib/cgraph/scan.l"
if (graphType == T_graph) return(T_edgeop); else return('-');
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 178 "../../lib/cgraph/scan.l"
{ aaglval.str = (char*)agstrdup(Ag_G_global,aagtext); return(T_atom); }
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 179 "../../lib/cgraph/scan.l"
{ if (chkNum()) aagless(aagleng-1); aaglval.str = (char*)agstrdup(Ag_G_global,aagtext); return(T_atom); }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 180 "../../lib/cgraph/scan.l"
BEGIN(qstring); beginstr();
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 181 "../../lib/cgraph/scan.l"
BEGIN(INITIAL); endstr(); return (T_qatom);
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 182 "../../lib/cgraph/scan.l"
addstr ("\"");
	YY_BREAK
case 24:
/* rule 24 can match eol */
YY_RULE_SETUP
#line 183 "../../lib/cgraph/scan.l"
line_num++; /* ignore escaped newlines */
	YY_BREAK
case 25:
/* rule 25 can match eol */
YY_RULE_SETUP
#line 184 "../../lib/cgraph/scan.l"
addstr(aagtext);
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 185 "../../lib/cgraph/scan.l"
BEGIN(hstring); html_nest = 1; beginstr();
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 186 "../../lib/cgraph/scan.l"
html_nest--; if (html_nest) addstr(aagtext); else {BEGIN(INITIAL); endstr_html(); return (T_qatom);}
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 187 "../../lib/cgraph/scan.l"
html_nest++; addstr(aagtext);
	YY_BREAK
case 29:
/* rule 29 can match eol */
YY_RULE_SETUP
#line 188 "../../lib/cgraph/scan.l"
addstr(aagtext); line_num++; /* add newlines */
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 189 "../../lib/cgraph/scan.l"
addstr(aagtext);
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 190 "../../lib/cgraph/scan.l"
return (aagtext[0]);
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 191 "../../lib/cgraph/scan.l"
ECHO;
	YY_BREAK
#line 1124 "lex.aag.c"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(comment):
case YY_STATE_EOF(qstring):
case YY_STATE_EOF(hstring):
	aagterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int aag_amount_of_matched_text = (int) (aag_cp - (aagtext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*aag_cp = (aag_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->aag_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed aagin at a new source and called
			 * aaglex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(aag_n_chars) = YY_CURRENT_BUFFER_LVALUE->aag_n_chars;
			YY_CURRENT_BUFFER_LVALUE->aag_input_file = aagin;
			YY_CURRENT_BUFFER_LVALUE->aag_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for aag_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since aag_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (aag_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->aag_ch_buf[(aag_n_chars)] )
			{ /* This was really a NUL. */
			aag_state_type aag_next_state;

			(aag_c_buf_p) = (aagtext_ptr) + aag_amount_of_matched_text;

			aag_current_state = aag_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * aag_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			aag_next_state = aag_try_NUL_trans( aag_current_state );

			aag_bp = (aagtext_ptr) + YY_MORE_ADJ;

			if ( aag_next_state )
				{
				/* Consume the NUL. */
				aag_cp = ++(aag_c_buf_p);
				aag_current_state = aag_next_state;
				goto aag_match;
				}

			else
				{
				aag_cp = (aag_c_buf_p);
				goto aag_find_action;
				}
			}

		else switch ( aag_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(aag_did_buffer_switch_on_eof) = 0;

				if ( aagwrap( ) )
					{
					/* Note: because we've taken care in
					 * aag_get_next_buffer() to have set up
					 * aagtext, we can now set up
					 * aag_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(aag_c_buf_p) = (aagtext_ptr) + YY_MORE_ADJ;

					aag_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (aag_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(aag_c_buf_p) =
					(aagtext_ptr) + aag_amount_of_matched_text;

				aag_current_state = aag_get_previous_state(  );

				aag_cp = (aag_c_buf_p);
				aag_bp = (aagtext_ptr) + YY_MORE_ADJ;
				goto aag_match;

			case EOB_ACT_LAST_MATCH:
				(aag_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->aag_ch_buf[(aag_n_chars)];

				aag_current_state = aag_get_previous_state(  );

				aag_cp = (aag_c_buf_p);
				aag_bp = (aagtext_ptr) + YY_MORE_ADJ;
				goto aag_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of aaglex */

/* aag_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int aag_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->aag_ch_buf;
	register char *source = (aagtext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (aag_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->aag_ch_buf[(aag_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->aag_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (aag_c_buf_p) - (aagtext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((aag_c_buf_p) - (aagtext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->aag_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->aag_n_chars = (aag_n_chars) = 0;

	else
		{
			aag_size_t num_to_read =
			YY_CURRENT_BUFFER_LVALUE->aag_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int aag_c_buf_p_offset =
				(int) ((aag_c_buf_p) - b->aag_ch_buf);

			if ( b->aag_is_our_buffer )
				{
				aag_size_t new_size = b->aag_buf_size * 2;

				if ( new_size <= 0 )
					b->aag_buf_size += b->aag_buf_size / 8;
				else
					b->aag_buf_size *= 2;

				b->aag_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					aagrealloc((void *) b->aag_ch_buf,b->aag_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->aag_ch_buf = 0;

			if ( ! b->aag_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(aag_c_buf_p) = &b->aag_ch_buf[aag_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->aag_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->aag_ch_buf[number_to_move]),
			(aag_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->aag_n_chars = (aag_n_chars);
		}

	if ( (aag_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			aagrestart(aagin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->aag_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((aag_size_t) ((aag_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->aag_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		aag_size_t new_size = (aag_n_chars) + number_to_move + ((aag_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->aag_ch_buf = (char *) aagrealloc((void *) YY_CURRENT_BUFFER_LVALUE->aag_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->aag_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in aag_get_next_buffer()" );
	}

	(aag_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->aag_ch_buf[(aag_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->aag_ch_buf[(aag_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(aagtext_ptr) = &YY_CURRENT_BUFFER_LVALUE->aag_ch_buf[0];

	return ret_val;
}

/* aag_get_previous_state - get the state just before the EOB char was reached */

    static aag_state_type aag_get_previous_state (void)
{
	register aag_state_type aag_current_state;
	register char *aag_cp;
    
	aag_current_state = (aag_start);
	aag_current_state += YY_AT_BOL();

	for ( aag_cp = (aagtext_ptr) + YY_MORE_ADJ; aag_cp < (aag_c_buf_p); ++aag_cp )
		{
		register YY_CHAR aag_c = (*aag_cp ? aag_ec[YY_SC_TO_UI(*aag_cp)] : 1);
		if ( aag_accept[aag_current_state] )
			{
			(aag_last_accepting_state) = aag_current_state;
			(aag_last_accepting_cpos) = aag_cp;
			}
		while ( aag_chk[aag_base[aag_current_state] + aag_c] != aag_current_state )
			{
			aag_current_state = (int) aag_def[aag_current_state];
			if ( aag_current_state >= 89 )
				aag_c = aag_meta[(unsigned int) aag_c];
			}
		aag_current_state = aag_nxt[aag_base[aag_current_state] + (unsigned int) aag_c];
		}

	return aag_current_state;
}

/* aag_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = aag_try_NUL_trans( current_state );
 */
    static aag_state_type aag_try_NUL_trans  (aag_state_type aag_current_state )
{
	register int aag_is_jam;
    	register char *aag_cp = (aag_c_buf_p);

	register YY_CHAR aag_c = 1;
	if ( aag_accept[aag_current_state] )
		{
		(aag_last_accepting_state) = aag_current_state;
		(aag_last_accepting_cpos) = aag_cp;
		}
	while ( aag_chk[aag_base[aag_current_state] + aag_c] != aag_current_state )
		{
		aag_current_state = (int) aag_def[aag_current_state];
		if ( aag_current_state >= 89 )
			aag_c = aag_meta[(unsigned int) aag_c];
		}
	aag_current_state = aag_nxt[aag_base[aag_current_state] + (unsigned int) aag_c];
	aag_is_jam = (aag_current_state == 88);

		return aag_is_jam ? 0 : aag_current_state;
}

    static void aagunput (int c, register char * aag_bp )
{
	register char *aag_cp;
    
    aag_cp = (aag_c_buf_p);

	/* undo effects of setting up aagtext */
	*aag_cp = (aag_hold_char);

	if ( aag_cp < YY_CURRENT_BUFFER_LVALUE->aag_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register aag_size_t number_to_move = (aag_n_chars) + 2;
		register char *dest = &YY_CURRENT_BUFFER_LVALUE->aag_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->aag_buf_size + 2];
		register char *source =
				&YY_CURRENT_BUFFER_LVALUE->aag_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->aag_ch_buf )
			*--dest = *--source;

		aag_cp += (int) (dest - source);
		aag_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->aag_n_chars =
			(aag_n_chars) = YY_CURRENT_BUFFER_LVALUE->aag_buf_size;

		if ( aag_cp < YY_CURRENT_BUFFER_LVALUE->aag_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--aag_cp = (char) c;

	(aagtext_ptr) = aag_bp;
	(aag_hold_char) = *aag_cp;
	(aag_c_buf_p) = aag_cp;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int aaginput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(aag_c_buf_p) = (aag_hold_char);

	if ( *(aag_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* aag_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (aag_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->aag_ch_buf[(aag_n_chars)] )
			/* This was really a NUL. */
			*(aag_c_buf_p) = '\0';

		else
			{ /* need more input */
			aag_size_t offset = (aag_c_buf_p) - (aagtext_ptr);
			++(aag_c_buf_p);

			switch ( aag_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because aag_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					aagrestart(aagin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( aagwrap( ) )
						return EOF;

					if ( ! (aag_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return aaginput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(aag_c_buf_p) = (aagtext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (aag_c_buf_p);	/* cast for 8-bit char's */
	*(aag_c_buf_p) = '\0';	/* preserve aagtext */
	(aag_hold_char) = *++(aag_c_buf_p);

	YY_CURRENT_BUFFER_LVALUE->aag_at_bol = (c == '\n');

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void aagrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        aagensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            aag_create_buffer(aagin,YY_BUF_SIZE );
	}

	aag_init_buffer(YY_CURRENT_BUFFER,input_file );
	aag_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void aag_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		aagpop_buffer_state();
	 *		aagpush_buffer_state(new_buffer);
     */
	aagensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(aag_c_buf_p) = (aag_hold_char);
		YY_CURRENT_BUFFER_LVALUE->aag_buf_pos = (aag_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->aag_n_chars = (aag_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	aag_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (aagwrap()) processing, but the only time this flag
	 * is looked at is after aagwrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(aag_did_buffer_switch_on_eof) = 1;
}

static void aag_load_buffer_state  (void)
{
    	(aag_n_chars) = YY_CURRENT_BUFFER_LVALUE->aag_n_chars;
	(aagtext_ptr) = (aag_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->aag_buf_pos;
	aagin = YY_CURRENT_BUFFER_LVALUE->aag_input_file;
	(aag_hold_char) = *(aag_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE aag_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) aagalloc(sizeof( struct aag_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in aag_create_buffer()" );

	b->aag_buf_size = size;

	/* aag_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->aag_ch_buf = (char *) aagalloc(b->aag_buf_size + 2  );
	if ( ! b->aag_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in aag_create_buffer()" );

	b->aag_is_our_buffer = 1;

	aag_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with aag_create_buffer()
 * 
 */
    void aag_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->aag_is_our_buffer )
		aagfree((void *) b->aag_ch_buf  );

	aagfree((void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a aagrestart() or at EOF.
 */
    static void aag_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	aag_flush_buffer(b );

	b->aag_input_file = file;
	b->aag_fill_buffer = 1;

    /* If b is the current buffer, then aag_init_buffer was _probably_
     * called from aagrestart() or through aag_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->aag_bs_lineno = 1;
        b->aag_bs_column = 0;
    }

        b->aag_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void aag_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->aag_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->aag_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->aag_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->aag_buf_pos = &b->aag_ch_buf[0];

	b->aag_at_bol = 1;
	b->aag_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		aag_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void aagpush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	aagensure_buffer_stack();

	/* This block is copied from aag_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(aag_c_buf_p) = (aag_hold_char);
		YY_CURRENT_BUFFER_LVALUE->aag_buf_pos = (aag_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->aag_n_chars = (aag_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(aag_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from aag_switch_to_buffer. */
	aag_load_buffer_state( );
	(aag_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void aagpop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	aag_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((aag_buffer_stack_top) > 0)
		--(aag_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		aag_load_buffer_state( );
		(aag_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void aagensure_buffer_stack (void)
{
	aag_size_t num_to_alloc;
    
	if (!(aag_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(aag_buffer_stack) = (struct aag_buffer_state**)aagalloc
								(num_to_alloc * sizeof(struct aag_buffer_state*)
								);
		if ( ! (aag_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in aagensure_buffer_stack()" );
								  
		memset((aag_buffer_stack), 0, num_to_alloc * sizeof(struct aag_buffer_state*));
				
		(aag_buffer_stack_max) = num_to_alloc;
		(aag_buffer_stack_top) = 0;
		return;
	}

	if ((aag_buffer_stack_top) >= ((aag_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (aag_buffer_stack_max) + grow_size;
		(aag_buffer_stack) = (struct aag_buffer_state**)aagrealloc
								((aag_buffer_stack),
								num_to_alloc * sizeof(struct aag_buffer_state*)
								);
		if ( ! (aag_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in aagensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((aag_buffer_stack) + (aag_buffer_stack_max), 0, grow_size * sizeof(struct aag_buffer_state*));
		(aag_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE aag_scan_buffer  (char * base, aag_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) aagalloc(sizeof( struct aag_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in aag_scan_buffer()" );

	b->aag_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->aag_buf_pos = b->aag_ch_buf = base;
	b->aag_is_our_buffer = 0;
	b->aag_input_file = 0;
	b->aag_n_chars = b->aag_buf_size;
	b->aag_is_interactive = 0;
	b->aag_at_bol = 1;
	b->aag_fill_buffer = 0;
	b->aag_buffer_status = YY_BUFFER_NEW;

	aag_switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to aaglex() will
 * scan from a @e copy of @a str.
 * @param aagstr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       aag_scan_bytes() instead.
 */
YY_BUFFER_STATE aag_scan_string (aagconst char * aagstr )
{
    
	return aag_scan_bytes(aagstr,strlen(aagstr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to aaglex() will
 * scan from a @e copy of @a bytes.
 * @param aagbytes the byte buffer to scan
 * @param _aagbytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE aag_scan_bytes  (aagconst char * aagbytes, aag_size_t  _aagbytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	aag_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _aagbytes_len + 2;
	buf = (char *) aagalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in aag_scan_bytes()" );

	for ( i = 0; i < _aagbytes_len; ++i )
		buf[i] = aagbytes[i];

	buf[_aagbytes_len] = buf[_aagbytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = aag_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in aag_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->aag_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void aag_fatal_error (aagconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine aagless() so it works in section 3 code. */

#undef aagless
#define aagless(n) \
	do \
		{ \
		/* Undo effects of setting up aagtext. */ \
        int aagless_macro_arg = (n); \
        YY_LESS_LINENO(aagless_macro_arg);\
		aagtext[aagleng] = (aag_hold_char); \
		(aag_c_buf_p) = aagtext + aagless_macro_arg; \
		(aag_hold_char) = *(aag_c_buf_p); \
		*(aag_c_buf_p) = '\0'; \
		aagleng = aagless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int aagget_lineno  (void)
{
        
    return aaglineno;
}

/** Get the input stream.
 * 
 */
FILE *aagget_in  (void)
{
        return aagin;
}

/** Get the output stream.
 * 
 */
FILE *aagget_out  (void)
{
        return aagout;
}

/** Get the length of the current token.
 * 
 */
aag_size_t aagget_leng  (void)
{
        return aagleng;
}

/** Get the current token.
 * 
 */

char *aagget_text  (void)
{
        return aagtext;
}

/** Set the current line number.
 * @param line_number
 * 
 */
void aagset_lineno (int  line_number )
{
    
    aaglineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see aag_switch_to_buffer
 */
void aagset_in (FILE *  in_str )
{
        aagin = in_str ;
}

void aagset_out (FILE *  out_str )
{
        aagout = out_str ;
}

int aagget_debug  (void)
{
        return aag_flex_debug;
}

void aagset_debug (int  bdebug )
{
        aag_flex_debug = bdebug ;
}

static int aag_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from aaglex_destroy(), so don't allocate here.
     */

    (aag_buffer_stack) = 0;
    (aag_buffer_stack_top) = 0;
    (aag_buffer_stack_max) = 0;
    (aag_c_buf_p) = (char *) 0;
    (aag_init) = 0;
    (aag_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    aagin = stdin;
    aagout = stdout;
#else
    aagin = (FILE *) 0;
    aagout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * aaglex_init()
     */
    return 0;
}

/* aaglex_destroy is for both reentrant and non-reentrant scanners. */
int aaglex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		aag_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		aagpop_buffer_state();
	}

	/* Destroy the stack itself. */
	aagfree((aag_buffer_stack) );
	(aag_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * aaglex() is called, initialization will occur. */
    aag_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef aagtext_ptr
static void aag_flex_strncpy (char* s1, aagconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int aag_flex_strlen (aagconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *aagalloc (aag_size_t  size )
{
	return (void *) malloc( size );
}

void *aagrealloc  (void * ptr, aag_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void aagfree (void * ptr )
{
	free( (char *) ptr );	/* see aagrealloc() for (char *) cast */
}

#define YYTABLES_NAME "aagtables"

#line 191 "../../lib/cgraph/scan.l"


void aagerror(char *str)
{
	char	buf[BUFSIZ];
	if (InputFile)
		sprintf(buf,"%s:%d: %s in line %d near '%s'\n",InputFile, line_num,
			str,line_num,aagtext);
	else
		sprintf(buf," %s in line %d near '%s'\n", str,line_num,aagtext);
	agerr(AGWARN,buf);
}
/* must be here to see flex's macro defns */
void aglexeof() { unput(GRAPH_EOF_TOKEN); }

#ifndef YY_CALL_ONLY_ARG
# define YY_CALL_ONLY_ARG void
#endif

int aagwrap(YY_CALL_ONLY_ARG)
{
	return 1;
}


