/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpfont_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "stamp-pdbgen.h"

#include "gimp.h"


/**
 * SECTION: gimpfont
 * @title: gimpfont
 * @short_description: Installable object used by text tools.
 *
 * Installable object used by text tools.
 **/


/**
 * _gimp_font_get_lookup_name:
 * @font: GimpFont object.
 *
 * Retrieve the font lookup name.
 *
 * Retrieve the font lookup name.
 *
 * Returns: (transfer full): font lookup name.
 *          The returned value must be freed with g_free().
 **/
gchar *
_gimp_font_get_lookup_name (GimpFont *font)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *lookup_name = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_FONT, font,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-font-get-lookup-name",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    lookup_name = GIMP_VALUES_DUP_STRING (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return lookup_name;
}

/**
 * gimp_font_get_by_name:
 * @name: The name of the font.
 *
 * Returns a font with the given name.
 *
 * If several fonts are named identically, the one which is returned by
 * this function should be considered random. This can be used when you
 * know you won't have multiple fonts of this name or that you don't
 * want to choose (non-interactive scripts, etc.).
 * If you need more control, you should use gimp_fonts_get_by_name()
 * instead.
 * Returns %NULL when no font exists of that name.
 *
 * Returns: (nullable) (transfer none): The font.
 *
 * Since: 3.0
 **/
GimpFont *
gimp_font_get_by_name (const gchar *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpFont *font = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, name,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-font-get-by-name",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    font = GIMP_VALUES_GET_FONT (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return font;
}

/**
 * gimp_fonts_get_by_name:
 * @name: The name of the font.
 * @num_fonts: (out): The number of fonts with the given name.
 *
 * Returns the fonts with the given name.
 *
 * Returns the fonts with the given name. There may be more than one.
 *
 * Returns: (array length=num_fonts) (element-type GimpFont) (transfer container):
 *          The fonts with the given name.
 *          The returned value must be freed with g_free().
 *
 * Since: 3.0
 **/
GimpFont **
gimp_fonts_get_by_name (const gchar *name,
                        gint        *num_fonts)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpFont **fonts = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, name,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-fonts-get-by-name",
                                               args);
  gimp_value_array_unref (args);

  *num_fonts = 0;

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    {
      *num_fonts = GIMP_VALUES_GET_INT (return_vals, 1);
      { GimpObjectArray *a = g_value_get_boxed (gimp_value_array_index (return_vals, 2)); if (a) fonts = g_memdup2 (a->data, a->length * sizeof (gpointer)); };
    }

  gimp_value_array_unref (return_vals);

  return fonts;
}
