import os
import sys

gi.require_version('Gegl', '0.4')
from gi.repository import Gegl

input1_path = '../gimp-data/images/logo/setup-base.svg'
input2_path = '../gimp-data/images/logo/gimp-logo-shadow.svg'
input3_path = '../gimp-data/images/logo/setup-hover.svg'
output_path = 'build/windows/installer/setup.ico'
# List of sizes come from these links:
# https://learn.microsoft.com/en-us/windows/apps/design/style/iconography/app-icon-construction
# https://learn.microsoft.com/en-us/windows/win32/uxguide/vis-icons
# Application icons and control panel items:
sizes       = [ 16, 32, 48, 256 ]
# Quick Launch area:
sizes      += [ 40 ]
# Additional sizes: we don't generate sizes: 8, 10 and 14 because we don't have
# pixel-perfect raster for these and it's so small that I wonder if it's worth
# it.
sizes      += [ 22, 24, 64, 96, 128 ]
# A bit of prettifying for the order of generated layers.
sizes.sort()

image_size = max(sizes)
image = Gimp.Image.new(image_size, image_size, Gimp.ImageBaseType.RGB)

for size in sizes:
  # 1. Loading the box SVG base.
  procedure   = Gimp.get_pdb().lookup_procedure("file-svg-load")
  config      = procedure.create_config()
  config.set_property("file", Gio.file_new_for_path(input1_path))
  config.set_property("width",  size)
  config.set_property("height", size)
  Gimp.Procedure.run(procedure, config)
  v = Gimp.Procedure.run(procedure, config)

  if v.index(0) != Gimp.PDBStatusType.SUCCESS:
    sys.exit(os.EX_SOFTWARE)

  tmp_image = v.index(1)
  drawables = tmp_image.get_selected_drawables()
  layer1 = Gimp.Layer.new_from_drawable (drawables[0], image)
  image.insert_layer(layer1, None, 0)
  tmp_image.delete()


  # 2. Loading Wilber.
  config.set_property("file", Gio.file_new_for_path(input2_path))
  wilber_size = size * 7 / 8
  config.set_property("width",  wilber_size)
  config.set_property("height", wilber_size)
  Gimp.Procedure.run(procedure, config)
  v = Gimp.Procedure.run(procedure, config)

  if v.index(0) != Gimp.PDBStatusType.SUCCESS:
    sys.exit(os.EX_SOFTWARE)

  tmp_image = v.index(1)
  drawables = tmp_image.get_selected_drawables()
  layer2 = Gimp.Layer.new_from_drawable (drawables[0], image)
  image.insert_layer(layer2, None, 0)
  layer2.set_offsets((size - wilber_size) * 0.4, (size - wilber_size) * -0.4)
  tmp_image.delete()

  image.merge_down(layer2, Gimp.MergeType.CLIP_TO_BOTTOM_LAYER)


  # 3. Loading the box SVG hover.
  procedure   = Gimp.get_pdb().lookup_procedure("file-svg-load")
  config      = procedure.create_config()
  config.set_property("file", Gio.file_new_for_path(input3_path))
  config.set_property("width",  size)
  config.set_property("height", size)
  Gimp.Procedure.run(procedure, config)
  v = Gimp.Procedure.run(procedure, config)

  if v.index(0) != Gimp.PDBStatusType.SUCCESS:
    sys.exit(os.EX_SOFTWARE)

  tmp_image = v.index(1)
  drawables = tmp_image.get_selected_drawables()
  layer3 = Gimp.Layer.new_from_drawable (drawables[0], image)
  image.insert_layer(layer3, None, 0)
  tmp_image.delete()

  image.merge_down(layer3, Gimp.MergeType.CLIP_TO_BOTTOM_LAYER)


procedure = Gimp.get_pdb().lookup_procedure("file-ico-export")
config    = procedure.create_config()
drawables = image.get_selected_drawables()
config.set_property("image", image)
config.set_property("file", Gio.file_new_for_path(output_path))
Gimp.Procedure.run(procedure, config)

v = Gimp.Procedure.run(procedure, config)

if v.index(0) != Gimp.PDBStatusType.SUCCESS:
  sys.exit(os.EX_SOFTWARE)
