<?xml version="1.0" encoding="utf-8"?> 

<!-- this stylesheet was copied and is part of the inkscape project!!! -->
<!-- all credits goes to the creators of this script -->
<!-- see the inkscape project in $inkscape/docs -->

<xsl:stylesheet
   xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
   xmlns="http://www.w3.org/2000/svg"
   xmlns:k="http://www.inkscape.org/namespaces/keys"
   xmlns:h="http://www.w3.org/1999/xhtml"
   xmlns:inkscape="http://www.inkscape.org/namespaces/inkscape"
   xmlns:sodipodi="http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd"
   xmlns:xlink="http://www.w3.org/1999/xlink"
   exclude-result-prefixes="k"
>

<xsl:output method="xml" encoding="utf-8" indent="no"/>

<xsl:variable name="style-section"
    select="'fill:black;fill-opacity:1;stroke:none;font-family:Bitstream Vera Sans;font-style:normal;font-weight:bold;font-size:16;text-anchor:start;writing-mode:lr;letter-spacing:-2;'"/>
<xsl:variable name="space-section" select="28"/>
<xsl:variable name="skip-section-title" select="21"/>
<xsl:variable name="skip-section-content" select="25"/>

<xsl:variable name="space-group" select="3"/>
<xsl:variable name="skip-group-content" select="1.5"/>

<xsl:variable name="style-title" select="'fill:black;fill-opacity:1;stroke:none;font-family:Bitstream Vera Sans;font-style:oblique;font-weight:bold;font-size:7.4;text-anchor:start;writing-mode:lr;letter-spacing:-0.2;'"/>
<xsl:variable name="space-title" select="7"/>
<xsl:variable name="skip-title-content" select="5"/>

<xsl:variable name="space-keys" select="8"/>
<xsl:variable name="skip-keys-content" select="1"/>
<xsl:variable name="skip-keys-action" select="5"/> <!-- from keys-content -->

<xsl:variable name="space-mouse" select="11.5"/>
<xsl:variable name="skip-mouse-content" select="1.5"/>
<xsl:variable name="skip-mouse-action" select="5"/> <!-- from mouse-content -->

<xsl:variable name="style-note" select="'fill:black;fill-opacity:1;stroke:none;font-family:Bitstream Vera Sans;font-style:normal;font-weight:normal;font-size:3;text-anchor:start;writing-mode:lr;letter-spacing:0;'"/>
<xsl:variable name="space-note" select="4"/>
<xsl:variable name="skip-note-content" select="3"/>

<xsl:variable name="style-letterkey" select="'fill:black;fill-opacity:1;stroke:none;font-family:Bitstream Vera Sans;font-style:normal;font-weight:normal;font-size:4.4;text-anchor:start;writing-mode:lr;'"/>
<xsl:variable name="style-keyf" select="'fill:black;fill-opacity:1;stroke:none;font-family:Bitstream Vera Sans;font-style:normal;font-weight:normal;font-size:3.3;text-anchor:start;writing-mode:lr;letter-spacing:-0.4;'"/>
<xsl:variable name="style-keymisc" select="'fill:black;fill-opacity:1;stroke:none;font-family:Bitstream Vera Sans;font-style:normal;font-weight:normal;font-size:3.4;text-anchor:start;writing-mode:lr;letter-spacing:-0.2;'"/>
<xsl:variable name="style-action" select="'fill:black;fill-opacity:1;stroke:none;font-family:Bitstream Vera Sans;font-style:normal;font-weight:normal;font-size:6.4;text-anchor:start;writing-mode:lr;letter-spacing:-0.4;'"/>

<xsl:variable name="section-width" select="215"/>
<xsl:variable name="section-hskip" select="2"/>
<xsl:variable name="note-hskip" select="6"/>

<xsl:variable name="action-hskip" select="3"/>

<xsl:variable name="w-shift" select="15.46"/>
<xsl:variable name="w-ctrl" select="12.38"/>
<xsl:variable name="w-alt" select="10.67"/>
<xsl:variable name="w-left" select="8.7"/>
<xsl:variable name="w-right" select="10.9"/>
<xsl:variable name="w-letterkey" select="8.00"/>
<xsl:variable name="w-misc-wide" select="17.46"/>
<xsl:variable name="w-misc" select="12.38"/>
<xsl:variable name="w-arrows" select="12.38"/>
<xsl:variable name="w-mouse" select="7.0"/>
<xsl:variable name="w-key" select="31"/>

<xsl:param name="svg_template" 
    select="document('../templates/svg_template.xml')" />
<xsl:param name="wilber"
    select="document('../templates/wilber.svg')" />

<xsl:template match="k:root">
    <xsl:comment>

        Do not edit this file.
        It is generated automatically from doc/keys.xml by doc/keys-svg.xsl.

    </xsl:comment>
    <svg
        version="1.0"
        x="0"
        y="0"
        width="1000"
        height="1200"
        id="svg559"
        sodipodi:version="0.32"
        inkscape:version="0.37cvs"
        sodipodi:docname="keys-sample.svg"
        xmlns="http://www.w3.org/2000/svg"
        xmlns:svg="http://www.w3.org/2000/svg"
        xmlns:inkscape="http://www.inkscape.org/namespaces/inkscape"
        xmlns:sodipodi="http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd"
        xmlns:xlink="http://www.w3.org/1999/xlink"
        sodipodi:docbase="/home/d/ink/inkscape">
        <sodipodi:namedview
            id="base"
            inkscape:zoom="0.48"
            inkscape:cx="736"
            inkscape:cy="588"
            inkscape:window-width="780"
            inkscape:window-height="580"
            inkscape:window-x="0"
            inkscape:window-y="0"
            showborder="true" />
        <xsl:copy-of select="$svg_template//svg:svg/svg:defs" />
        <!-- don't display key and mouse image definitions,
             which are used
             throughout the quickreference -->
        <g style="display:none">
            <xsl:copy-of select="$svg_template//svg:svg/svg:g" />
        </g>

        <!-- GIMP Quickreference title -->
        <text id="quickreference_title"
            style="font-size: 43px;"
            x="94"
            y="82">
            <tspan>
                <xsl:value-of select="//k:root/k:title" />
            </tspan>
        </text>

        <!-- Wilber -->
        <g
            id="wilber"
            inkscape:label="wilber reading"
            transform="matrix(2.5822219,0,0,2.5822219,622.45494,24.994751)">
            <xsl:copy-of select="$wilber" />
        </g>

        <!-- Reference -->
        <g id="outer_group"
            transform="matrix(1.24, 0, 0, 1.24, 91.82, 136.99)">
            <xsl:apply-templates/>
        </g>
    </svg>
</xsl:template>

<xsl:template match="k:root/text() | k:column/text() | k:root/k:p"/>

<xsl:template match="k:column">
<xsl:variable name="y" select="
 count(preceding::k:section)*$space-section + 
 count(preceding::k:group)*$space-group + 
 count(preceding::k:title)*$space-title + 
 count(preceding::k:keys)*$space-keys + 
 count(preceding::k:mouse)*$space-mouse + 
 count(preceding::k:note)*$space-note"/>
<xsl:variable name="x" select="count(preceding::k:column)*$section-width"/>
 <g transform="translate({$x},{-$y})">
  <xsl:apply-templates/>
 </g>
</xsl:template>

<xsl:template match="k:section">
<xsl:variable name="y" select="
 count(preceding::k:section)*$space-section + 
 count(preceding::k:group)*$space-group + 
 count(preceding::k:title)*$space-title + 
 count(preceding::k:keys)*$space-keys + 
 count(preceding::k:mouse)*$space-mouse + 
 count(preceding::k:note)*$space-note"/>
<xsl:variable name="h" select="
 $space-section + 
 count(descendant::k:group)*$space-group + 
 count(descendant::k:title)*$space-title + 
 count(descendant::k:keys)*$space-keys + 
 count(descendant::k:mouse)*$space-mouse + 
 count(descendant::k:note)*$space-note"/>
  <rect
     style="fill:#{@color};fill-rule:evenodd;stroke:none"
     width="{$section-width}"
     height="{$h}"
     x="0"
     y="{$y}"/>
  <text
     xml:space="preserve"
     style="{$style-section}"
     x="{$section-hskip + 1*$w-key}"
     y="{$y + $skip-section-title}"
     id="sect{count(preceding-sibling::k:section) + 1}"
     ><tspan
       x="{$section-hskip + 1*$w-key}"
       y="{$y + $skip-section-title}"
       sodipodi:role="line"
       id="sect-tspan{count(preceding-sibling::k:section) + 1}"
       ><xsl:value-of select="child::k:title"/></tspan></text>
<xsl:apply-templates/>
</xsl:template>

<xsl:template match="//k:group/k:title">
<xsl:variable name="y" select="
 count(preceding::k:section) * $space-section + 
 count(preceding::k:group)*$space-group + 
 count(preceding::k:title)*$space-title + 
 count(preceding::k:keys)*$space-keys + 
 count(preceding::k:mouse)*$space-mouse + 
 count(preceding::k:note)*$space-note +
 $skip-section-content +
 $skip-group-content +
 $skip-title-content"/>
  <text
     xml:space="preserve"
     style="{$style-title}"
     x="{$section-hskip + 1*$w-key}"
     y="{$y}"
     id="title{count(preceding::k:title)+1}"
     ><tspan
       x="{$section-hskip + 1*$w-key}"
       y="{$y}"
       sodipodi:role="line"
       id="title-tspan{count(preceding::k:title)+1}"><xsl:value-of select="text()"/></tspan></text>

</xsl:template>

<xsl:template match="k:note">
<xsl:variable name="y" select="
 count(preceding::k:section) * $space-section + 
 count(preceding::k:group)*$space-group + 
 count(preceding::k:title)*$space-title + 
 count(preceding::k:keys)*$space-keys + 
 count(preceding::k:mouse)*$space-mouse + 
 count(preceding::k:note)*$space-note +
 $skip-section-content +
 $skip-group-content +
 $skip-note-content"/>

  <text
     xml:space="preserve"
     style="{$style-note}"
     x="{$section-hskip + $note-hskip}"
     y="{$y}"
     id="note{count(preceding::k:note)+1}"
     ><tspan
       x="{$section-hskip + $note-hskip}"
       y="{$y}"
       sodipodi:role="line"
       id="note-tspan{count(preceding::k:note)+1}"><xsl:value-of select="text()"/></tspan></text>

</xsl:template>


<xsl:template match="k:keys">
<xsl:variable name="y" select="
 count(preceding::k:section) * $space-section + 
 count(preceding::k:group)*$space-group + 
 count(preceding::k:title)*$space-title + 
 count(preceding::k:keys)*$space-keys + 
 count(preceding::k:mouse)*$space-mouse + 
 count(preceding::k:note)*$space-note +
 $skip-section-content +
 $skip-group-content +
 $skip-keys-content"/>
<xsl:apply-templates select="k:key | k:action">
<xsl:with-param name="y" select="$y"/>
</xsl:apply-templates>
</xsl:template>

<xsl:template match="k:mouse">
<xsl:variable name="y" select="
 count(preceding::k:section) * $space-section + 
 count(preceding::k:group)*$space-group + 
 count(preceding::k:title)*$space-title + 
 count(preceding::k:keys)*$space-keys + 
 count(preceding::k:mouse)*$space-mouse + 
 count(preceding::k:note)*$space-note +
 $skip-section-content +
 $skip-group-content +
 $skip-mouse-content"/>
<xsl:apply-templates select="k:key | k:action">
<xsl:with-param name="y" select="$y"/>
</xsl:apply-templates>
</xsl:template>

<xsl:template match="k:action">
<xsl:param name="y"/>
<xsl:variable name="x" select="2*$w-key + $section-hskip + $action-hskip"/> <!--max two keys-->
  <text
     xml:space="preserve"
     style="{$style-action}"
     x="{$x}"
     y="{$y + $skip-keys-action}"
     id="action{count(preceding::k:action)+1}"
     ><tspan
       x="{$x}"
       y="{$y + $skip-keys-action}"
       sodipodi:role="line"
       id="action-tspan{count(preceding::k:action)+1}"
       ><xsl:value-of select="text()"/></tspan></text>
</xsl:template>

<xsl:template match="k:key">
<xsl:param name="y"/>
<xsl:variable name="x" select="(1 - count(following-sibling::k:key))*$w-key + $section-hskip"/> <!--max two keys-->
<xsl:apply-templates>
<xsl:with-param name="x" select="$x"/>
<xsl:with-param name="y" select="$y"/>
</xsl:apply-templates>
<xsl:variable name="comma-skip">
<xsl:choose>
<xsl:when test="k:wheel | k:left-click | k:left-drag | k:mid-click | k:mid-drag | k:right-click | k:right-drag">0.4</xsl:when>
<xsl:otherwise>1.0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="following-sibling::k:key/node()">
  <text
     xml:space="preserve"
     style="{$style-action}"
     x="{$x + $w-key - $comma-skip}"
     y="{$y + $skip-keys-action}"
     ><tspan
       x="{$x + $w-key - $comma-skip}"
       y="{$y + $skip-keys-action}"
       sodipodi:role="line"
       >,</tspan></text>
</xsl:if>
</xsl:template>

<xsl:template match="k:left-click | k:shift | k:ctrl | k:alt | k:left | k:right">
<xsl:param name="x"/>
<xsl:param name="y"/>
<xsl:variable name="xx" select="
 $x +
 $w-key - 
 count(following-sibling::k:shift | self::k:shift)*$w-shift -
 count(following-sibling::k:ctrl | self::k:ctrl)*$w-ctrl -
 count(following-sibling::k:alt | self::k:alt)*$w-alt -
 count(following-sibling::k:left | self::k:left)*$w-left -
 count(following-sibling::k:right | self::k:right)*$w-right -
 count(following-sibling::text())*$w-letterkey -
 count(following-sibling::k:keyf)*$w-letterkey -
 count(following-sibling::k:misc-wide)*$w-misc-wide -
 count(following-sibling::k:misc)*$w-misc -
 count(following-sibling::k:arrows)*$w-arrows -
 count(following-sibling::k:wheel | following-sibling::k:left-click | following-sibling::k:left-drag | following-sibling::k:mid-click | following-sibling::k:mid-drag | following-sibling::k:right-click | following-sibling::k:right-drag | self::k:left-click)*$w-mouse
"/>
<use xlink:href="#{name()}"
transform="translate({$xx},{$y})"/>
</xsl:template>

<xsl:template match="k:key/text()">
<xsl:param name="x"/>
<xsl:param name="y"/>
<xsl:variable name="xx" select="
 $x +
 $w-key - 
 $w-letterkey"/>
<use xlink:href="#letterkey"
transform="translate({$xx},{$y})"/>
    <text
       xml:space="preserve"
       style="{$style-letterkey}"
       x="{1.7 + $xx}"
       y="{4.66851145 + $y}"
       ><tspan
         x="{1.7 + $xx}"
         y="{4.66851145 + $y}"
         sodipodi:role="line"
         ><xsl:value-of select="."/></tspan></text>
</xsl:template>

<xsl:template match="k:keyf">
<xsl:param name="x"/>
<xsl:param name="y"/>
<xsl:variable name="xx" select="
 $x +
 $w-key - 
 $w-letterkey"/>
<use xlink:href="#letterkey"
transform="translate({$xx},{$y})"/>
    <text
       xml:space="preserve"
       style="{$style-keyf}"
       x="{0.9 + $xx}"
       y="{3.5 + $y}"
       ><tspan
         x="{0.9 + $xx}"
         y="{3.5 + $y}"
         sodipodi:role="line"
         ><xsl:value-of select="@f"/></tspan></text>
</xsl:template>

<xsl:template match="k:misc-wide">
<xsl:param name="x"/>
<xsl:param name="y"/>
<xsl:variable name="xx" select="
 $x +
 $w-key - 
 $w-misc-wide"/>
<use xlink:href="#misc-wide"
transform="translate({$xx},{$y})"/>
    <text
       xml:space="preserve"
       style="{$style-keymisc}"
       x="{1.1 + $xx}"
       y="{3.7 + $y}"
       ><tspan
         x="{1.1 + $xx}"
         y="{3.7 + $y}"
         sodipodi:role="line"
         ><xsl:value-of select="@f"/></tspan></text>
</xsl:template>

<xsl:template match="k:misc">
<xsl:param name="x"/>
<xsl:param name="y"/>
<xsl:variable name="xx" select="
 $x +
 $w-key - 
 $w-misc"/>
<use xlink:href="#misc"
transform="translate({$xx},{$y})"/>
    <text
       xml:space="preserve"
       style="{$style-keymisc}"
       x="{1.1 + $xx}"
       y="{3.7 + $y}"
       ><tspan
         x="{1.1 + $xx}"
         y="{3.7 + $y}"
         sodipodi:role="line"
         ><xsl:value-of select="@f"/></tspan></text>
</xsl:template>

<xsl:template match="k:arrows">
<xsl:param name="x"/>
<xsl:param name="y"/>
<xsl:variable name="xx" select="
 $x +
 $w-key - 
 $w-arrows"/>
<use xlink:href="#arrows"
transform="translate({$xx},{$y})"/>
</xsl:template>

<xsl:template match="k:up | k:down | k:left-arrow | k:right-arrow">
<xsl:param name="x"/>
<xsl:param name="y"/>
<xsl:variable name="xx" select="
 $x +
 $w-key - 
 $w-letterkey"/>
<use xlink:href="#{name()}"
transform="translate({$xx},{$y})"/>
</xsl:template>

<xsl:template match="k:wheel | k:left-drag | k:mid-click | k:mid-drag | k:right-click | k:right-drag">
<xsl:param name="x"/>
<xsl:param name="y"/>
<xsl:variable name="xx" select="
 $x +
 $w-key - 
 $w-mouse -
 count(following-sibling::k:misc-wide)*($w-misc-wide + 1)"/>
<use xlink:href="#{name()}"
transform="translate({$xx},{$y})"/>
</xsl:template>

</xsl:stylesheet>
