/*
 * Generated by gdbus-codegen 2.54.3. DO NOT EDIT.
 *
 * The license of this code is the same as for the source it was derived from.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "gclue-manager-interface.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  gboolean use_gvariant;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.GeoClue2.Manager
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GClueDBusManager
 * @title: GClueDBusManager
 * @short_description: Generated C code for the org.freedesktop.GeoClue2.Manager D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Manager.top_of_page">org.freedesktop.GeoClue2.Manager</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.GeoClue2.Manager ---- */

static const _ExtendedGDBusArgInfo _gclue_dbus_manager_method_info_get_client_OUT_ARG_client =
{
  {
    -1,
    (gchar *) "client",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _gclue_dbus_manager_method_info_get_client_OUT_ARG_pointers[] =
{
  &_gclue_dbus_manager_method_info_get_client_OUT_ARG_client,
  NULL
};

static const _ExtendedGDBusMethodInfo _gclue_dbus_manager_method_info_get_client =
{
  {
    -1,
    (gchar *) "GetClient",
    NULL,
    (GDBusArgInfo **) &_gclue_dbus_manager_method_info_get_client_OUT_ARG_pointers,
    NULL
  },
  "handle-get-client",
  FALSE
};

static const _ExtendedGDBusArgInfo _gclue_dbus_manager_method_info_add_agent_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _gclue_dbus_manager_method_info_add_agent_IN_ARG_pointers[] =
{
  &_gclue_dbus_manager_method_info_add_agent_IN_ARG_id,
  NULL
};

static const _ExtendedGDBusMethodInfo _gclue_dbus_manager_method_info_add_agent =
{
  {
    -1,
    (gchar *) "AddAgent",
    (GDBusArgInfo **) &_gclue_dbus_manager_method_info_add_agent_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-add-agent",
  FALSE
};

static const _ExtendedGDBusMethodInfo * const _gclue_dbus_manager_method_info_pointers[] =
{
  &_gclue_dbus_manager_method_info_get_client,
  &_gclue_dbus_manager_method_info_add_agent,
  NULL
};

static const _ExtendedGDBusPropertyInfo _gclue_dbus_manager_property_info_in_use =
{
  {
    -1,
    (gchar *) "InUse",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "in-use",
  FALSE
};

static const _ExtendedGDBusPropertyInfo _gclue_dbus_manager_property_info_available_accuracy_level =
{
  {
    -1,
    (gchar *) "AvailableAccuracyLevel",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "available-accuracy-level",
  FALSE
};

static const _ExtendedGDBusPropertyInfo * const _gclue_dbus_manager_property_info_pointers[] =
{
  &_gclue_dbus_manager_property_info_in_use,
  &_gclue_dbus_manager_property_info_available_accuracy_level,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _gclue_dbus_manager_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.GeoClue2.Manager",
    (GDBusMethodInfo **) &_gclue_dbus_manager_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_gclue_dbus_manager_property_info_pointers,
    NULL
  },
  "manager",
};


/**
 * gclue_dbus_manager_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Manager.top_of_page">org.freedesktop.GeoClue2.Manager</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
gclue_dbus_manager_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_gclue_dbus_manager_interface_info.parent_struct;
}

/**
 * gclue_dbus_manager_override_properties:
 * @klass: The class structure for a #GObject<!-- -->-derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GClueDBusManager interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
gclue_dbus_manager_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "in-use");
  g_object_class_override_property (klass, property_id_begin++, "available-accuracy-level");
  return property_id_begin - 1;
}



/**
 * GClueDBusManager:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Manager.top_of_page">org.freedesktop.GeoClue2.Manager</link>.
 */

/**
 * GClueDBusManagerIface:
 * @parent_iface: The parent interface.
 * @handle_add_agent: Handler for the #GClueDBusManager::handle-add-agent signal.
 * @handle_get_client: Handler for the #GClueDBusManager::handle-get-client signal.
 * @get_available_accuracy_level: Getter for the #GClueDBusManager:available-accuracy-level property.
 * @get_in_use: Getter for the #GClueDBusManager:in-use property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Manager.top_of_page">org.freedesktop.GeoClue2.Manager</link>.
 */

typedef GClueDBusManagerIface GClueDBusManagerInterface;
G_DEFINE_INTERFACE (GClueDBusManager, gclue_dbus_manager, G_TYPE_OBJECT)

static void
gclue_dbus_manager_default_init (GClueDBusManagerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * GClueDBusManager::handle-get-client:
   * @object: A #GClueDBusManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.GetClient">GetClient()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gclue_dbus_manager_complete_get_client() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-client",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GClueDBusManagerIface, handle_get_client),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GClueDBusManager::handle-add-agent:
   * @object: A #GClueDBusManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.AddAgent">AddAgent()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gclue_dbus_manager_complete_add_agent() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-add-agent",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GClueDBusManagerIface, handle_add_agent),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /* GObject properties for D-Bus properties: */
  /**
   * GClueDBusManager:in-use:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-GeoClue2-Manager.InUse">"InUse"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("in-use", "InUse", "InUse", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GClueDBusManager:available-accuracy-level:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-GeoClue2-Manager.AvailableAccuracyLevel">"AvailableAccuracyLevel"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("available-accuracy-level", "AvailableAccuracyLevel", "AvailableAccuracyLevel", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * gclue_dbus_manager_get_in_use: (skip)
 * @object: A #GClueDBusManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Manager.InUse">"InUse"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
gclue_dbus_manager_get_in_use (GClueDBusManager *object)
{
  return GCLUE_DBUS_MANAGER_GET_IFACE (object)->get_in_use (object);
}

/**
 * gclue_dbus_manager_set_in_use: (skip)
 * @object: A #GClueDBusManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Manager.InUse">"InUse"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gclue_dbus_manager_set_in_use (GClueDBusManager *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "in-use", value, NULL);
}

/**
 * gclue_dbus_manager_get_available_accuracy_level: (skip)
 * @object: A #GClueDBusManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Manager.AvailableAccuracyLevel">"AvailableAccuracyLevel"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
gclue_dbus_manager_get_available_accuracy_level (GClueDBusManager *object)
{
  return GCLUE_DBUS_MANAGER_GET_IFACE (object)->get_available_accuracy_level (object);
}

/**
 * gclue_dbus_manager_set_available_accuracy_level: (skip)
 * @object: A #GClueDBusManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Manager.AvailableAccuracyLevel">"AvailableAccuracyLevel"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gclue_dbus_manager_set_available_accuracy_level (GClueDBusManager *object, guint value)
{
  g_object_set (G_OBJECT (object), "available-accuracy-level", value, NULL);
}

/**
 * gclue_dbus_manager_call_get_client:
 * @proxy: A #GClueDBusManagerProxy.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.GetClient">GetClient()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call gclue_dbus_manager_call_get_client_finish() to get the result of the operation.
 *
 * See gclue_dbus_manager_call_get_client_sync() for the synchronous, blocking version of this method.
 */
void
gclue_dbus_manager_call_get_client (
    GClueDBusManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetClient",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gclue_dbus_manager_call_get_client_finish:
 * @proxy: A #GClueDBusManagerProxy.
 * @out_client: (out): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gclue_dbus_manager_call_get_client().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gclue_dbus_manager_call_get_client().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
gclue_dbus_manager_call_get_client_finish (
    GClueDBusManager *proxy,
    gchar **out_client,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_client);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gclue_dbus_manager_call_get_client_sync:
 * @proxy: A #GClueDBusManagerProxy.
 * @out_client: (out): Return location for return parameter or %NULL to ignore.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.GetClient">GetClient()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gclue_dbus_manager_call_get_client() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
gclue_dbus_manager_call_get_client_sync (
    GClueDBusManager *proxy,
    gchar **out_client,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetClient",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_client);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gclue_dbus_manager_call_add_agent:
 * @proxy: A #GClueDBusManagerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.AddAgent">AddAgent()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call gclue_dbus_manager_call_add_agent_finish() to get the result of the operation.
 *
 * See gclue_dbus_manager_call_add_agent_sync() for the synchronous, blocking version of this method.
 */
void
gclue_dbus_manager_call_add_agent (
    GClueDBusManager *proxy,
    const gchar *arg_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "AddAgent",
    g_variant_new ("(s)",
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gclue_dbus_manager_call_add_agent_finish:
 * @proxy: A #GClueDBusManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gclue_dbus_manager_call_add_agent().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gclue_dbus_manager_call_add_agent().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
gclue_dbus_manager_call_add_agent_finish (
    GClueDBusManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gclue_dbus_manager_call_add_agent_sync:
 * @proxy: A #GClueDBusManagerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.AddAgent">AddAgent()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gclue_dbus_manager_call_add_agent() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
gclue_dbus_manager_call_add_agent_sync (
    GClueDBusManager *proxy,
    const gchar *arg_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "AddAgent",
    g_variant_new ("(s)",
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gclue_dbus_manager_complete_get_client:
 * @object: A #GClueDBusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @client: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.GetClient">GetClient()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gclue_dbus_manager_complete_get_client (
    GClueDBusManager *object,
    GDBusMethodInvocation *invocation,
    const gchar *client)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   client));
}

/**
 * gclue_dbus_manager_complete_add_agent:
 * @object: A #GClueDBusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.AddAgent">AddAgent()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gclue_dbus_manager_complete_add_agent (
    GClueDBusManager *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * GClueDBusManagerProxy:
 *
 * The #GClueDBusManagerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GClueDBusManagerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GClueDBusManagerProxy.
 */

struct _GClueDBusManagerProxyPrivate
{
  GData *qdata;
};

static void gclue_dbus_manager_proxy_iface_init (GClueDBusManagerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GClueDBusManagerProxy, gclue_dbus_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GClueDBusManagerProxy)
                         G_IMPLEMENT_INTERFACE (GCLUE_DBUS_TYPE_MANAGER, gclue_dbus_manager_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GClueDBusManagerProxy, gclue_dbus_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GCLUE_DBUS_TYPE_MANAGER, gclue_dbus_manager_proxy_iface_init))

#endif
static void
gclue_dbus_manager_proxy_finalize (GObject *object)
{
  GClueDBusManagerProxy *proxy = GCLUE_DBUS_MANAGER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (gclue_dbus_manager_proxy_parent_class)->finalize (object);
}

static void
gclue_dbus_manager_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = _gclue_dbus_manager_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
gclue_dbus_manager_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.GeoClue2.Manager: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
gclue_dbus_manager_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = _gclue_dbus_manager_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.GeoClue2.Manager", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) gclue_dbus_manager_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
gclue_dbus_manager_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_gclue_dbus_manager_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GCLUE_DBUS_TYPE_MANAGER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GCLUE_DBUS_TYPE_MANAGER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
gclue_dbus_manager_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GClueDBusManagerProxy *proxy = GCLUE_DBUS_MANAGER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gclue_dbus_manager_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gclue_dbus_manager_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gboolean 
gclue_dbus_manager_proxy_get_in_use (GClueDBusManager *object)
{
  GClueDBusManagerProxy *proxy = GCLUE_DBUS_MANAGER_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "InUse");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
gclue_dbus_manager_proxy_get_available_accuracy_level (GClueDBusManager *object)
{
  GClueDBusManagerProxy *proxy = GCLUE_DBUS_MANAGER_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "AvailableAccuracyLevel");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
gclue_dbus_manager_proxy_init (GClueDBusManagerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = gclue_dbus_manager_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GCLUE_DBUS_TYPE_MANAGER_PROXY, GClueDBusManagerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), gclue_dbus_manager_interface_info ());
}

static void
gclue_dbus_manager_proxy_class_init (GClueDBusManagerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = gclue_dbus_manager_proxy_finalize;
  gobject_class->get_property = gclue_dbus_manager_proxy_get_property;
  gobject_class->set_property = gclue_dbus_manager_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = gclue_dbus_manager_proxy_g_signal;
  proxy_class->g_properties_changed = gclue_dbus_manager_proxy_g_properties_changed;

  gclue_dbus_manager_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GClueDBusManagerProxyPrivate));
#endif
}

static void
gclue_dbus_manager_proxy_iface_init (GClueDBusManagerIface *iface)
{
  iface->get_in_use = gclue_dbus_manager_proxy_get_in_use;
  iface->get_available_accuracy_level = gclue_dbus_manager_proxy_get_available_accuracy_level;
}

/**
 * gclue_dbus_manager_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Manager.top_of_page">org.freedesktop.GeoClue2.Manager</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call gclue_dbus_manager_proxy_new_finish() to get the result of the operation.
 *
 * See gclue_dbus_manager_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
gclue_dbus_manager_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GCLUE_DBUS_TYPE_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.GeoClue2.Manager", NULL);
}

/**
 * gclue_dbus_manager_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gclue_dbus_manager_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gclue_dbus_manager_proxy_new().
 *
 * Returns: (transfer full) (type GClueDBusManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
GClueDBusManager *
gclue_dbus_manager_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GCLUE_DBUS_MANAGER (ret);
  else
    return NULL;
}

/**
 * gclue_dbus_manager_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Manager.top_of_page">org.freedesktop.GeoClue2.Manager</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gclue_dbus_manager_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GClueDBusManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
GClueDBusManager *
gclue_dbus_manager_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GCLUE_DBUS_TYPE_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.GeoClue2.Manager", NULL);
  if (ret != NULL)
    return GCLUE_DBUS_MANAGER (ret);
  else
    return NULL;
}


/**
 * gclue_dbus_manager_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like gclue_dbus_manager_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call gclue_dbus_manager_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See gclue_dbus_manager_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
gclue_dbus_manager_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GCLUE_DBUS_TYPE_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.GeoClue2.Manager", NULL);
}

/**
 * gclue_dbus_manager_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gclue_dbus_manager_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gclue_dbus_manager_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GClueDBusManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
GClueDBusManager *
gclue_dbus_manager_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GCLUE_DBUS_MANAGER (ret);
  else
    return NULL;
}

/**
 * gclue_dbus_manager_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like gclue_dbus_manager_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gclue_dbus_manager_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GClueDBusManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
GClueDBusManager *
gclue_dbus_manager_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GCLUE_DBUS_TYPE_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.GeoClue2.Manager", NULL);
  if (ret != NULL)
    return GCLUE_DBUS_MANAGER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GClueDBusManagerSkeleton:
 *
 * The #GClueDBusManagerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GClueDBusManagerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GClueDBusManagerSkeleton.
 */

struct _GClueDBusManagerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_gclue_dbus_manager_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GClueDBusManagerSkeleton *skeleton = GCLUE_DBUS_MANAGER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GCLUE_DBUS_TYPE_MANAGER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GCLUE_DBUS_TYPE_MANAGER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_gclue_dbus_manager_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GClueDBusManagerSkeleton *skeleton = GCLUE_DBUS_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gclue_dbus_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_gclue_dbus_manager_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GClueDBusManagerSkeleton *skeleton = GCLUE_DBUS_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gclue_dbus_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _gclue_dbus_manager_skeleton_vtable =
{
  _gclue_dbus_manager_skeleton_handle_method_call,
  _gclue_dbus_manager_skeleton_handle_get_property,
  _gclue_dbus_manager_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
gclue_dbus_manager_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return gclue_dbus_manager_interface_info ();
}

static GDBusInterfaceVTable *
gclue_dbus_manager_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_gclue_dbus_manager_skeleton_vtable;
}

static GVariant *
gclue_dbus_manager_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GClueDBusManagerSkeleton *skeleton = GCLUE_DBUS_MANAGER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_gclue_dbus_manager_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _gclue_dbus_manager_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _gclue_dbus_manager_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _gclue_dbus_manager_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.GeoClue2.Manager", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _gclue_dbus_manager_emit_changed (gpointer user_data);

static void
gclue_dbus_manager_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  GClueDBusManagerSkeleton *skeleton = GCLUE_DBUS_MANAGER_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _gclue_dbus_manager_emit_changed (skeleton);
}

static void gclue_dbus_manager_skeleton_iface_init (GClueDBusManagerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GClueDBusManagerSkeleton, gclue_dbus_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GClueDBusManagerSkeleton)
                         G_IMPLEMENT_INTERFACE (GCLUE_DBUS_TYPE_MANAGER, gclue_dbus_manager_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GClueDBusManagerSkeleton, gclue_dbus_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GCLUE_DBUS_TYPE_MANAGER, gclue_dbus_manager_skeleton_iface_init))

#endif
static void
gclue_dbus_manager_skeleton_finalize (GObject *object)
{
  GClueDBusManagerSkeleton *skeleton = GCLUE_DBUS_MANAGER_SKELETON (object);
  guint n;
  for (n = 0; n < 2; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (gclue_dbus_manager_skeleton_parent_class)->finalize (object);
}

static void
gclue_dbus_manager_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  GClueDBusManagerSkeleton *skeleton = GCLUE_DBUS_MANAGER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_gclue_dbus_manager_emit_changed (gpointer user_data)
{
  GClueDBusManagerSkeleton *skeleton = GCLUE_DBUS_MANAGER_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.GeoClue2.Manager",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_gclue_dbus_manager_schedule_emit_changed (GClueDBusManagerSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
gclue_dbus_manager_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  GClueDBusManagerSkeleton *skeleton = GCLUE_DBUS_MANAGER_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _gclue_dbus_manager_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _gclue_dbus_manager_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
gclue_dbus_manager_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  GClueDBusManagerSkeleton *skeleton = GCLUE_DBUS_MANAGER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL)
        _gclue_dbus_manager_schedule_emit_changed (skeleton, _gclue_dbus_manager_property_info_pointers[prop_id - 1], prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
gclue_dbus_manager_skeleton_init (GClueDBusManagerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = gclue_dbus_manager_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GCLUE_DBUS_TYPE_MANAGER_SKELETON, GClueDBusManagerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 2);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_UINT);
}

static gboolean 
gclue_dbus_manager_skeleton_get_in_use (GClueDBusManager *object)
{
  GClueDBusManagerSkeleton *skeleton = GCLUE_DBUS_MANAGER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
gclue_dbus_manager_skeleton_get_available_accuracy_level (GClueDBusManager *object)
{
  GClueDBusManagerSkeleton *skeleton = GCLUE_DBUS_MANAGER_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
gclue_dbus_manager_skeleton_class_init (GClueDBusManagerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = gclue_dbus_manager_skeleton_finalize;
  gobject_class->get_property = gclue_dbus_manager_skeleton_get_property;
  gobject_class->set_property = gclue_dbus_manager_skeleton_set_property;
  gobject_class->notify       = gclue_dbus_manager_skeleton_notify;


  gclue_dbus_manager_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = gclue_dbus_manager_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = gclue_dbus_manager_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = gclue_dbus_manager_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = gclue_dbus_manager_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GClueDBusManagerSkeletonPrivate));
#endif
}

static void
gclue_dbus_manager_skeleton_iface_init (GClueDBusManagerIface *iface)
{
  iface->get_in_use = gclue_dbus_manager_skeleton_get_in_use;
  iface->get_available_accuracy_level = gclue_dbus_manager_skeleton_get_available_accuracy_level;
}

/**
 * gclue_dbus_manager_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Manager.top_of_page">org.freedesktop.GeoClue2.Manager</link>.
 *
 * Returns: (transfer full) (type GClueDBusManagerSkeleton): The skeleton object.
 */
GClueDBusManager *
gclue_dbus_manager_skeleton_new (void)
{
  return GCLUE_DBUS_MANAGER (g_object_new (GCLUE_DBUS_TYPE_MANAGER_SKELETON, NULL));
}

