/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver;

import java.io.File;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import net.sourceforge.retroweaver.DefaultWeaveListener;
import net.sourceforge.retroweaver.RefVerifier;
import net.sourceforge.retroweaver.RetroWeaver;
import net.sourceforge.retroweaver.RetroWeaverException;
import net.sourceforge.retroweaver.translator.NameSpace;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.EmptyVisitor;

public class Weaver {
    private static final String VERSION;
    private static final String BUILD_NUMBER_STRING;
    private static final int BUILD_NUMBER;
    private static final int UNKNOWN_BUILD_NUMBER = -1;
    public static final int VERSION_1_6 = 50;
    public static final int VERSION_1_5 = 49;
    public static final int VERSION_1_4 = 48;
    public static final int VERSION_1_3 = 47;
    public static final int VERSION_1_2 = 46;
    private static final String nl;

    public static final String getVersion() {
        return VERSION + " (build " + BUILD_NUMBER_STRING + ')';
    }

    public static final int getBuildNumber() {
        return BUILD_NUMBER;
    }

    public static void main(String[] args) {
        String source = null;
        String sourceJar = null;
        String destJar = null;
        int target = 48;
        int currentArg = 0;
        boolean lazy = false;
        boolean stripSignatures = false;
        boolean stripAttributes = false;
        boolean verbose = false;
        String verifyPath = null;
        ArrayList<NameSpace> namespaces = new ArrayList<NameSpace>();
        while (currentArg < args.length) {
            String command = args[currentArg];
            ++currentArg;
            if (command.equals("-source")) {
                source = args[currentArg++];
                continue;
            }
            if (command.equals("-jar")) {
                if (!(sourceJar = args[currentArg++]).equals(destJar = args[currentArg++])) continue;
                System.out.println("source and destination jar files can not be identical");
                System.out.println();
                System.exit(1);
                continue;
            }
            if (command.equals("-namespace")) {
                String oldPrefix = args[currentArg++];
                String newPrefix = args[currentArg++];
                NameSpace n = new NameSpace(oldPrefix, newPrefix);
                namespaces.add(n);
                continue;
            }
            if (command.equals("-version")) {
                System.out.println("Retroweaver version " + Weaver.getVersion());
                System.exit(0);
                continue;
            }
            if (command.equals("-target")) {
                String verStr;
                if ((verStr = args[currentArg++]).equals("1.4")) {
                    target = 48;
                    continue;
                }
                if (verStr.equals("1.3")) {
                    target = 47;
                    continue;
                }
                if (verStr.equals("1.2")) {
                    target = 46;
                    continue;
                }
                System.out.println("Invalid target version: " + verStr);
                System.out.println();
                System.out.println(Weaver.getUsage());
                System.exit(1);
                continue;
            }
            if (command.equals("-lazy")) {
                lazy = true;
                continue;
            }
            if (command.equals("-stripSignatures")) {
                stripSignatures = true;
                continue;
            }
            if (command.equals("-stripAttributes")) {
                stripAttributes = true;
                continue;
            }
            if (command.equals("-verbose")) {
                verbose = true;
                continue;
            }
            if (command.equals("-verifyrefs")) {
                verifyPath = args[currentArg++];
                continue;
            }
            System.out.println("I don't understand the command: " + command);
            System.out.println();
            System.out.println(Weaver.getUsage());
            System.exit(1);
        }
        if (source == null && sourceJar == null) {
            System.out.println("Option \"-source\" or \"-jar\" is required.");
            System.out.println();
            System.out.println(Weaver.getUsage());
            System.exit(1);
        }
        if (source != null && sourceJar != null) {
            System.out.println("Only one of \"-source\" or \"-jar\" can be specified.");
            System.out.println();
            System.out.println(Weaver.getUsage());
            System.exit(1);
        }
        File sourcePath = null;
        RetroWeaver weaver = new RetroWeaver(target);
        weaver.setListener(new DefaultWeaveListener(verbose));
        weaver.setLazy(lazy);
        weaver.setStripSignatures(stripSignatures);
        weaver.setStripAttributes(stripAttributes);
        weaver.addNameSpaces(namespaces);
        if (verifyPath != null) {
            ArrayList<String> paths = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(verifyPath, File.pathSeparator);
            while (st.hasMoreTokens()) {
                paths.add(st.nextToken());
            }
            RefVerifier rv = new RefVerifier(target, (ClassVisitor)new EmptyVisitor(), paths, new RefVerifier.DefaultListener(verbose));
            weaver.setVerifier(rv);
        }
        try {
            if (source != null) {
                sourcePath = new File(source);
                weaver.weave(sourcePath);
            } else {
                weaver.weaveJarFile(sourceJar, destJar);
            }
        }
        catch (Exception e) {
            throw new RetroWeaverException("Weaving failed", e);
        }
    }

    private static String getUsage() {
        return "Usage: Weaver <options>" + nl + " Options: " + nl + " -source <source dir>" + nl + " -jar <source jar> <target jar>" + nl + " -target <target VM version> (one of {1.4, 1.3, 1.2}, default is 1.4)" + nl + " -verifyrefs <classpath>" + nl + " -stripSignatures (strip generic signatures, off by default)" + nl + " -stripAttributes (strip custom attributes, off by default)" + nl + " -verbose (message for each processed class)" + nl + " -version (display version number and exit)" + nl + nl + "One of \"-source\" or \"-jar\" is required.";
    }

    static {
        int n;
        ResourceBundle bundle = ResourceBundle.getBundle("retroweaver");
        VERSION = bundle.getString("retroweaver.version");
        BUILD_NUMBER_STRING = bundle.getString("retroweaver.buildNumber");
        try {
            n = Integer.parseInt(BUILD_NUMBER_STRING);
        }
        catch (NumberFormatException e) {
            n = -1;
        }
        BUILD_NUMBER = n;
        nl = System.getProperty("line.separator");
    }
}

