/* Copyright (C) 2000-2012 by George Williams */
/*
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.

 * The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.

 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include "fontforgeui.h"

static GClut magnify0_clut = { 2, 0, 1,
    { 0x0, 0xb0b0b0 } };

static uint8 magnify0_data[] = {
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0x7, 0xff, 
    0xfc, 0xf9, 0xff, 
    0xfd, 0xdd, 0xff, 
    0xfb, 0xde, 0xff, 
    0xfb, 0xde, 0xff, 
    0xfa, 0x2, 0xff, 
    0xfb, 0xde, 0xff, 
    0xfb, 0xde, 0xff, 
    0xfd, 0xdd, 0xff, 
    0xfc, 0xf9, 0xff, 
    0xff, 0x6, 0xff, 
    0xff, 0xff, 0x7f, 
    0xff, 0xff, 0xbf, 
    0xff, 0xff, 0xdf, 
    0xff, 0xff, 0xef, 
    0xff, 0xff, 0xf7, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
};

static struct _GImage magnify0_base = {
    it_mono,
    2080,24,24,3,
    (uint8 *) magnify0_data,
    &magnify0_clut,
    1
};

static uint8 pointer0_data[] = {
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0x7f, 0xff, 
    0xff, 0x3f, 0xff, 
    0xff, 0x1f, 0xff, 
    0xff, 0xf, 0xff, 
    0xff, 0x7, 0xff, 
    0xff, 0x3, 0xff, 
    0xff, 0xf, 0xff, 
    0xff, 0x4f, 0xff, 
    0xff, 0x67, 0xff, 
    0xff, 0xe7, 0xff, 
    0xff, 0xf3, 0xff, 
    0xff, 0xf3, 0xff, 
    0xff, 0xf9, 0xff, 
    0xff, 0xf9, 0xff, 
    0xff, 0xfc, 0xff, 
    0xff, 0xfc, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
};

static struct _GImage pointer0_base = {
    it_mono,
    2080,24,24,3,
    (uint8 *) pointer0_data,
    &magnify0_clut,
    1
};

static uint8 ruler0_data[] = {
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xdf, 0xff, 0xf7, 
    0xdf, 0xff, 0xf7, 
    0xdf, 0xef, 0xf7, 
    0xdf, 0xef, 0xf7, 
    0xdb, 0x6d, 0xb7, 
    0xdb, 0x6d, 0xb7, 
    0xdb, 0x6d, 0xb7, 
    0xc0, 0x0, 0x7, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
};

static struct _GImage ruler0_base = {
    it_mono,
    2080,24,24,3,
    (uint8 *) ruler0_data,
    &magnify0_clut,
    1
};

static uint8 knife0_data[] = {
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0x80, 0x0, 0x1, 
    0xf1, 0xff, 0xdf, 
    0xfe, 0x3f, 0xdf, 
    0xff, 0xc7, 0xc1, 
    0xff, 0xf8, 0xdf, 
    0xff, 0xff, 0x1f, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
};

static struct _GImage knife0_base = {
    it_mono,
    2080,24,24,3,
    (uint8 *) knife0_data,
    &magnify0_clut,
    1
};

static uint8 corner0_data[] = {
    0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x0, 0x1, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2
};

static GClut corner0_clut = { 3, 0, 2,
    { 0x0, 0xff0000, 0xc0c0c0 } };

static struct _GImage corner0_base = {
    it_index,
    2080,24,24,24,
    (uint8 *) corner0_data,
    &corner0_clut,
    2
};

static uint8 curve0_data[] = {
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2
};

static struct _GImage curve0_base = {
    it_index,
    2080,24,24,24,
    (uint8 *) curve0_data,
    &corner0_clut,
    2
};

static uint8 hvcurve0_data[] = {
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x4, 0x2, 0x4, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x4, 0x4, 0x2, 0x4, 0x4, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 
    0x3, 0x1, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x4, 0x4, 0x4, 0x2, 0x4, 0x4, 0x4, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x1, 0x3, 
    0x3, 0x3, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x4, 0x4, 0x4, 0x2, 0x4, 0x4, 0x4, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x4, 0x4, 0x4, 0x2, 0x4, 0x4, 0x4, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x4, 0x4, 0x2, 0x4, 0x4, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x4, 0x2, 0x4, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3
};

static GClut hvcurve0_clut = { 5, 0, 3,
    { 0x0, 0x7f7f7f, 0x0, 0xc0c0c0, 0xff0000 } };

static struct _GImage hvcurve0_base = {
    it_index,
    15420,24,24,24,
    (uint8 *) hvcurve0_data,
    &hvcurve0_clut,
    3
};

static uint8 tangent0_data[] = {
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2
};

static uint8 corner1_data[] = {
    0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
};

static struct _GImage corner1_base = {
    it_index,
    2080,16,16,16,
    (uint8 *) corner1_data,
    &corner0_clut,
    2
};

static uint8 curve1_data[] = {
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
};

static struct _GImage curve1_base = {
    it_index,
    2080,16,16,16,
    (uint8 *) curve1_data,
    &corner0_clut,
    2
};

static uint8 hvcurve1_data[] = {
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x4, 0x2, 0x4, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x2, 0x4, 0x4, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x4, 0x2, 0x4, 0x4, 0x4, 0x3, 0x3, 0x3, 0x3, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x4, 0x2, 0x4, 0x4, 0x4, 0x1, 0x1, 0x1, 0x1, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x4, 0x2, 0x4, 0x4, 0x4, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x2, 0x4, 0x4, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x4, 0x2, 0x4, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
};

static struct _GImage hvcurve1_base = {
    it_index,
    15420,16,16,16,
    (uint8 *) hvcurve1_data,
    &hvcurve0_clut,
    3
};

static uint8 tangent1_data[] = {
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
};

static struct _GImage tangent1_base = {
    it_index,
    2080,16,16,16,
    (uint8 *) tangent1_data,
    &corner0_clut,
    2
};

static struct _GImage tangent0_base = {
    it_index,
    2080,24,24,24,
    (uint8 *) tangent0_data,
    &corner0_clut,
    2
};

static uint8 spirocorner0_data[] = {
    0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x1, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x1, 0x3, 0x2, 0x2, 0x3, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x3, 0x1, 0x2, 0x3, 0x2, 0x2, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 
    0x2, 0x3, 0x2, 0x2, 0x1, 0x2, 0x2, 0x3, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 
    0x3, 0x2, 0x2, 0x3, 0x2, 0x1, 0x3, 0x2, 
	0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 
    0x3, 0x2, 0x3, 0x2, 0x2, 0x3, 0x1, 0x2, 
	0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 
    0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x2, 0x1, 
	0x2, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 
	0x1, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x3, 0x2, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 
	0x3, 0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x2, 
	0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 
	0x3, 0x2, 0x1, 0x4, 0x4, 0x4, 0x4, 0x3, 
	0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 
	0x3, 0x2, 0x4, 0x1, 0x4, 0x4, 0x4, 0x3, 
	0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 
	0x3, 0x2, 0x4, 0x4, 0x1, 0x4, 0x4, 0x3, 
	0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 
	0x3, 0x2, 0x4, 0x4, 0x1, 0x4, 0x4, 0x3, 
	0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 
	0x2, 0x3, 0x4, 0x4, 0x1, 0x4, 0x4, 0x2, 
	0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x2, 0x3, 
	0x2, 0x2, 0x3, 0x3, 0x1, 0x3, 0x2, 0x2, 
	0x3, 0x2, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 
	0x3, 0x2, 0x2, 0x2, 0x1, 0x2, 0x2, 0x3, 
	0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 
	0x2, 0x3, 0x3, 0x3, 0x1, 0x3, 0x3, 0x2, 
	0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 
    0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 
	0x2, 0x2, 0x2, 0x2, 0x1, 0x2, 0x2, 0x2, 
	0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 
    0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 
	0x3, 0x3, 0x3, 0x3, 0x1, 0x3, 0x3, 0x3, 
	0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x1, 0x3, 0x3, 0x3, 
	0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x1, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2
};

static GClut spirocorner0_clut = { 5, 1, 2,
    { 0xffffff, 0x0, 0xb0b0b0, 0x808080, 0xff0000 } };

static struct _GImage spirocorner0_base = {
    it_index,
    15420,24,24,24,
    (uint8 *) spirocorner0_data,
    &spirocorner0_clut,
    2
};

static uint8 spirocurve0_data[] = {
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
	0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 
    0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
	0x1, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
    0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x2, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x1, 0x1, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x1, 0x2, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 
	0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x1, 0x4, 0x3, 0x4, 0x2, 0x1, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x4, 0x4, 0x3, 0x4, 0x4, 0x2, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x4, 0x4, 0x4, 0x3, 0x4, 0x4, 0x4, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x4, 0x4, 0x4, 0x3, 0x4, 0x4, 0x4, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x4, 0x4, 0x4, 0x3, 0x4, 0x4, 0x4, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x1, 0x2, 0x4, 0x4, 0x3, 0x4, 0x4, 0x1, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x1, 0x1, 0x2, 0x4, 0x3, 0x4, 0x1, 0x1, 
	0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x2, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x2, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
	0x1, 0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x1, 
	0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
    0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 
	0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
	0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1
};

static GClut spirocurve0_clut = { 5, 1, 1,
    { 0xffffff, 0xb0b0b0, 0x808080, 0x0, 0xff0000 } };

static struct _GImage spirocurve0_base = {
    it_index,
    15420,24,24,24,
    (uint8 *) spirocurve0_data,
    &spirocurve0_clut,
    1
};

static uint8 spirog2curve0_data[] = {
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 
    0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
    0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x4, 0x3, 0x4, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x4, 0x4, 0x3, 0x4, 0x4, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x4, 0x4, 0x4, 0x3, 0x4, 0x4, 0x4, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x4, 0x4, 0x4, 0x4, 0x3, 0x4, 0x4, 0x4, 0x4, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x4, 0x4, 0x4, 0x3, 0x4, 0x4, 0x4, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x4, 0x4, 0x3, 0x4, 0x4, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x4, 0x3, 0x4, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
    0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1
};

static GClut spirog2curve0_clut = { 5, 1, 1,
    { 0xffffff, 0xb0b0b0, 0x808080, 0x0, 0xff0000 } };

static struct _GImage spirog2curve0_base = {
    it_index,
    15420,24,24,24,
    (uint8 *) spirog2curve0_data,
    &spirog2curve0_clut,
    1
};

static uint8 spiroright0_data[] = {
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 
    0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
	0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
    0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x1, 0x1, 
	0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x3, 0x3, 0x3, 0x3, 0x2, 0x1, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x2, 0x1, 0x3, 0x3, 0x1, 0x2, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x2, 0x1, 0x3, 0x3, 0x1, 0x2, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x2, 0x1, 0x3, 0x3, 0x1, 0x2, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x1, 0x2, 0x3, 0x3, 0x1, 0x2, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x2, 0x1, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x1, 0x1, 0x3, 0x3, 0x3, 0x3, 0x1, 0x1, 
	0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
	0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 
	0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
    0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1
};

static GClut spiroright0_clut = { 4, 1, 1,
    { 0xffffff, 0xb0b0b0, 0x808080, 0xff0000 } };

static struct _GImage spiroright0_base = {
    it_index,
    15420,24,24,24,
    (uint8 *) spiroright0_data,
    &spiroright0_clut,
    1
};

static uint8 spiroleft0_data[] = {
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 
    0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
	0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
    0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x1, 0x2, 0x1, 0x1, 0x3, 0x3, 0x3, 0x3, 
	0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x2, 0x1, 0x3, 0x3, 0x1, 0x2, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x2, 0x1, 0x3, 0x3, 0x1, 0x2, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x2, 0x1, 0x3, 0x3, 0x1, 0x2, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x1, 0x2, 0x3, 0x3, 0x1, 0x2, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x1, 0x2, 0x1, 0x1, 0x3, 0x3, 0x3, 0x3, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x3, 0x3, 
	0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
	0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 
	0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
    0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1
};

static GClut spiroleft0_clut = { 4, 1, 1,
    { 0xffffff, 0xb0b0b0, 0x808080, 0xff0000 } };

static struct _GImage spiroleft0_base = {
    it_index,
    15420,24,24,24,
    (uint8 *) spiroleft0_data,
    &spiroleft0_clut,
    1
};

static uint8 spirodisabled0_data[] = {
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
    0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
    0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
    0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x3, 0x2, 
	0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x3, 0x2, 0x1, 
	0x3, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x3, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
    0x1, 0x2, 0x1, 0x2, 0x3, 0x2, 0x1, 0x3, 
	0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x1, 0x2, 0x3, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x3, 0x1, 0x3, 0x2, 
	0x2, 0x3, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x3, 0x1, 0x2, 0x3, 0x2, 0x1, 0x2, 0x1, 
    0x1, 0x2, 0x1, 0x2, 0x3, 0x2, 0x3, 0x1, 
	0x3, 0x2, 0x1, 0x3, 0x3, 0x3, 0x3, 0x2, 
	0x2, 0x3, 0x1, 0x3, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x3, 0x1, 0x3, 0x2, 
	0x3, 0x1, 0x3, 0x1, 0x2, 0x1, 0x2, 0x3, 
	0x1, 0x3, 0x2, 0x3, 0x2, 0x1, 0x2, 0x1, 
    0x1, 0x2, 0x1, 0x2, 0x3, 0x2, 0x3, 0x1, 
	0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x1, 0x3, 
	0x2, 0x3, 0x1, 0x3, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x3, 0x1, 0x3, 0x2, 
	0x3, 0x1, 0x3, 0x1, 0x2, 0x3, 0x2, 0x3, 
	0x1, 0x3, 0x2, 0x3, 0x2, 0x1, 0x2, 0x1, 
    0x1, 0x2, 0x1, 0x2, 0x3, 0x2, 0x3, 0x1, 
	0x3, 0x2, 0x1, 0x3, 0x3, 0x2, 0x1, 0x3, 
	0x2, 0x3, 0x1, 0x3, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x3, 0x1, 0x3, 0x2, 
	0x2, 0x3, 0x2, 0x1, 0x2, 0x1, 0x3, 0x1, 
	0x2, 0x3, 0x2, 0x3, 0x2, 0x1, 0x2, 0x1, 
    0x1, 0x2, 0x1, 0x2, 0x3, 0x2, 0x1, 0x3, 
	0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x1, 0x2, 
	0x3, 0x2, 0x1, 0x3, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x3, 0x2, 0x1, 
	0x3, 0x2, 0x1, 0x2, 0x1, 0x2, 0x2, 0x3, 
	0x2, 0x1, 0x3, 0x1, 0x2, 0x1, 0x2, 0x1, 
    0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x3, 0x2, 
	0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x2, 
	0x1, 0x3, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x3, 
	0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x3, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
    0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
    0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
    0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2
};

static GClut spirodisabled0_clut = { 4, 0, -1,
    { 0x0, 0x9e9e9e, 0xffffff, 0x0 } };

static struct _GImage spirodisabled0_base = {
    it_index,
    15420,24,24,24,
    (uint8 *) spirodisabled0_data,
    &spirodisabled0_clut,
    -1
};
static uint8 spirodown0_data[] = {
    0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 
    0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 
	0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 
	0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 
	0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 
	0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x3, 0x1, 0x1, 0x3, 
	0x1, 0x1, 0x3, 0x3, 0x3, 0x3, 0x1, 0x1, 
	0x3, 0x1, 0x1, 0x3, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x3, 0x1, 0x3, 0x1, 
	0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 
	0x1, 0x3, 0x1, 0x3, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x3, 0x1, 0x3, 0x1, 
	0x3, 0x1, 0x1, 0x3, 0x3, 0x1, 0x1, 0x3, 
	0x1, 0x3, 0x1, 0x3, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x3, 0x1, 0x3, 0x1, 
	0x3, 0x1, 0x3, 0x1, 0x1, 0x3, 0x1, 0x3, 
	0x1, 0x3, 0x1, 0x3, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x3, 0x1, 0x3, 0x1, 
	0x3, 0x1, 0x1, 0x3, 0x1, 0x3, 0x1, 0x3, 
	0x1, 0x3, 0x1, 0x3, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x3, 0x1, 0x3, 0x1, 
	0x3, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x3, 
	0x1, 0x3, 0x1, 0x3, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x3, 0x1, 0x3, 0x1, 
	0x1, 0x3, 0x3, 0x3, 0x3, 0x1, 0x1, 0x3, 
	0x1, 0x3, 0x1, 0x3, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x3, 0x1, 0x1, 0x3, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 
	0x1, 0x3, 0x1, 0x3, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x1, 
	0x3, 0x1, 0x1, 0x3, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 
	0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 
	0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x3, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 
	0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 
	0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x3, 0x4, 
    0x3, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 
	0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 
	0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x3
};

static GClut spirodown0_clut = { 5, 0, 1,
    { 0x0, 0xbbbbbb, 0x5b5b5b, 0x0, 0xe2e2e2 } };

static struct _GImage spirodown0_base = {
    it_index,
    15420,24,24,24,
    (uint8 *) spirodown0_data,
    &spirodown0_clut,
    1
};

static uint8 spiroup0_data[] = {
    0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 
    0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 
	0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 
	0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x3, 0x1, 0x1, 0x3, 
	0x1, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x3, 0x1, 0x3, 0x1, 
	0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x3, 0x1, 0x1, 0x3, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x3, 0x1, 0x3, 0x1, 
	0x3, 0x1, 0x1, 0x3, 0x3, 0x3, 0x3, 0x1, 
	0x1, 0x3, 0x1, 0x3, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x3, 0x1, 0x3, 0x1, 
	0x3, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x3, 
	0x1, 0x3, 0x1, 0x3, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x3, 0x1, 0x3, 0x1, 
	0x3, 0x1, 0x3, 0x1, 0x3, 0x1, 0x1, 0x3, 
	0x1, 0x3, 0x1, 0x3, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x3, 0x1, 0x3, 0x1, 
	0x3, 0x1, 0x3, 0x1, 0x1, 0x3, 0x1, 0x3, 
	0x1, 0x3, 0x1, 0x3, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x3, 0x1, 0x3, 0x1, 
	0x3, 0x1, 0x1, 0x3, 0x3, 0x1, 0x1, 0x3, 
	0x1, 0x3, 0x1, 0x3, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x3, 0x1, 0x3, 0x1, 
	0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 
	0x1, 0x3, 0x1, 0x3, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x3, 0x1, 0x1, 0x3, 
	0x1, 0x1, 0x3, 0x3, 0x3, 0x3, 0x1, 0x1, 
	0x3, 0x1, 0x1, 0x3, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 
	0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 
	0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 
	0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 
	0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x3, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 
	0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 
	0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x3, 0x4, 
    0x3, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 
	0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 
	0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x3
};

static GClut spiroup0_clut = { 5, 0, 1,
    { 0x0, 0xbbbbbb, 0xe2e2e2, 0x0, 0x5b5b5b } };

static struct _GImage spiroup0_base = {
    it_index,
    15420,24,24,24,
    (uint8 *) spiroup0_data,
    &spiroup0_clut,
    1
};

static uint8 rotate0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 
	0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x2, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x3, 
	0x0, 0x0, 0x1, 0x0, 0x2, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x3, 
	0x0, 0x0, 0x1, 0x0, 0x2, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x2, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x1, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x3, 0x1, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static GClut rotate0_clut = { 6, 0, 0,
    { 0xc0c0c0, 0xff0000, 0x0, 0x00ff00, 0x0000ff, 0x4040ff } };

static struct _GImage rotate0_base = {
    it_index,
    2080,24,24,24,
    (uint8 *) rotate0_data,
    &rotate0_clut,
    0
};


static uint8 skew0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage skew0_base = {
    it_index,
    2080,24,24,24,
    (uint8 *) skew0_data,
    &rotate0_clut,
    0
};


static uint8 flip0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage flip0_base = {
    it_index,
    2080,24,24,24,
    (uint8 *) flip0_data,
    &rotate0_clut,
    0
};


static uint8 scale0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x0, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x3, 0x3, 0x3, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage scale0_base = {
    it_index,
    2080,24,24,24,
    (uint8 *) scale0_data,
    &rotate0_clut,
    0
};

static uint8 rotate3d0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x2, 0x0, 0x2, 0x0, 0x2, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage rotate3d0_base = {
    it_index,
    15420,24,24,24,
    (uint8 *) rotate3d0_data,
    &rotate0_clut,
    0
};


static uint8 perspective0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x4, 0x0, 0x4, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x4, 0x0, 0x4, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x4, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x4, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 
	0x3, 0x3, 0x3, 0x1, 0x3, 0x3, 0x3, 0x0, 
	0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 
	0x3, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x0, 
	0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 
	0x3, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x0, 
	0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 
	0x3, 0x1, 0x0, 0x0, 0x0, 0x1, 0x3, 0x0, 
	0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 
	0x3, 0x1, 0x0, 0x0, 0x0, 0x1, 0x3, 0x0, 
	0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 
	0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x0, 
	0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x4, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x4, 0x2, 0x0, 0x0, 
    0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 
    0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage perspective0_base = {
    it_index,
    15420,24,24,24,
    (uint8 *) perspective0_data,
    &rotate0_clut,
    0
};


static uint8 pen0_data[] = {
    0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 
	0x0, 0x0, 0x0, 0x5, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x2, 0x2, 0x0, 0x0, 0x1, 0x1, 
	0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x5, 0x0, 0x5, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x4, 0x4, 0x4, 0x4, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 
	0x4, 0x5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 
	0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x5, 0x0, 0x5, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 
	0x0, 0x0, 0x0, 0x5, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x2, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x2, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x2, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 
	0x2, 0x0, 0x2, 0x0, 0x0, 0x2, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage pen0_base = {
    it_index,
    2080,24,24,24,
    (uint8 *) pen0_data,
    &rotate0_clut,
    0
};

static uint8 beveljoin0_data[] = {
    0xff, 0xff, 
    0xfe, 0x0, 
    0xfd, 0xff, 
    0xfb, 0xff, 
    0xf7, 0xff, 
    0xef, 0xff, 
    0xdf, 0xff, 
    0xbe, 0xaa, 
    0xbf, 0xff, 
    0xbe, 0xff, 
    0xbf, 0xff, 
    0xbe, 0xff, 
    0xbf, 0xf8, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
};

static struct _GImage beveljoin0_base = {
    it_mono,
    2069,16,16,2,
    (uint8 *) beveljoin0_data,
    &magnify0_clut,
    1
};


static uint8 buttcap0_data[] = {
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0x80, 0x3, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
};

static struct _GImage buttcap0_base = {
    it_mono,
    2069,16,16,2,
    (uint8 *) buttcap0_data,
    &magnify0_clut,
    1
};


static uint8 miterjoin0_data[] = {
    0xff, 0xff, 
    0x80, 0x0, 
    0xbf, 0xff, 
    0xbf, 0xff, 
    0xbf, 0xff, 
    0xbf, 0xff, 
    0xbf, 0xff, 
    0xbe, 0xaa, 
    0xbf, 0xff, 
    0xbe, 0xff, 
    0xbf, 0xff, 
    0xbe, 0xff, 
    0xbf, 0xf8, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
};

static struct _GImage miterjoin0_base = {
    it_mono,
    2069,16,16,2,
    (uint8 *) miterjoin0_data,
    &magnify0_clut,
    1
};


static uint8 roundcap0_data[] = {
    0xff, 0xff, 
    0xf8, 0x3f, 
    0xe7, 0xcf, 
    0xdf, 0xf7, 
    0xdf, 0xf7, 
    0xbf, 0xfb, 
    0xbf, 0xfb, 
    0xb6, 0xdb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
};

static struct _GImage roundcap0_base = {
    it_mono,
    2069,16,16,2,
    (uint8 *) roundcap0_data,
    &magnify0_clut,
    1
};


static uint8 roundjoin0_data[] = {
    0xff, 0xff, 
    0xf8, 0x0, 
    0xe7, 0xff, 
    0xdf, 0xff, 
    0xdf, 0xff, 
    0xbf, 0xff, 
    0xbf, 0xff, 
    0xbe, 0xaa, 
    0xbf, 0xff, 
    0xbe, 0xff, 
    0xbf, 0xff, 
    0xbe, 0xff, 
    0xbf, 0xf8, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
};

static struct _GImage roundjoin0_base = {
    it_mono,
    2069,16,16,2,
    (uint8 *) roundjoin0_data,
    &magnify0_clut,
    1
};


static uint8 squarecap0_data[] = {
    0xff, 0xff, 
    0x80, 0x3, 
    0xbf, 0xfb, 
    0xbf, 0xfb, 
    0xbf, 0xfb, 
    0xbf, 0xfb, 
    0xbf, 0xfb, 
    0xb6, 0xdb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
};

static struct _GImage squarecap0_base = {
    it_mono,
    2069,16,16,2,
    (uint8 *) squarecap0_data,
    &magnify0_clut,
    1
};

static uint8 rect0_data[] = {
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0x80, 0x0, 0x1, 
    0xbf, 0xff, 0xfd, 
    0xbf, 0xff, 0xfd, 
    0xbf, 0xff, 0xfd, 
    0xbf, 0xff, 0xfd, 
    0xbf, 0xff, 0xfd, 
    0xbf, 0xff, 0xfd, 
    0xbf, 0xff, 0xfd, 
    0x80, 0x0, 0x1, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xeb, 
    0xff, 0xff, 0xf7, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xeb, 
    0xff, 0xff, 0xf7, 
    0xff, 0xff, 0xff, 
};

static struct _GImage rect0_base = {
    it_mono,
    2069,24,24,3,
    (uint8 *) rect0_data,
    &magnify0_clut,
    1
};

static uint8 rrect0_data[] = {
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xf0, 0x0, 0xf, 
    0xcf, 0xff, 0xf3, 
    0xdf, 0xff, 0xfb, 
    0xbf, 0xff, 0xfd, 
    0xbf, 0xff, 0xfd, 
    0xbf, 0xff, 0xfd, 
    0xdf, 0xff, 0xfb, 
    0xcf, 0xff, 0xf3, 
    0xf0, 0x0, 0xf, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xeb, 
    0xff, 0xff, 0xf7, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xeb, 
    0xff, 0xff, 0xf7, 
    0xff, 0xff, 0xff, 
};

static struct _GImage rrect0_base = {
    it_mono,
    2069,24,24,3,
    (uint8 *) rrect0_data,
    &magnify0_clut,
    1
};


static uint8 elipse0_data[] = {
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0x81, 0xff, 
    0xf8, 0x7e, 0x1f, 
    0xe7, 0xff, 0xe7, 
    0xdf, 0xff, 0xfb, 
    0xbf, 0xff, 0xfd, 
    0xbf, 0xff, 0xfd, 
    0xdf, 0xff, 0xfb, 
    0xe7, 0xff, 0xe7, 
    0xf8, 0x7e, 0x1f, 
    0xff, 0x81, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xeb, 
    0xff, 0xff, 0xf7, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xeb, 
    0xff, 0xff, 0xf7, 
    0xff, 0xff, 0xff, 
};

static struct _GImage elipse0_base = {
    it_mono,
    2069,24,24,3,
    (uint8 *) elipse0_data,
    &magnify0_clut,
    1
};


static uint8 poly0_data[] = {
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xe7, 0xff, 
    0xff, 0x99, 0xff, 
    0xfe, 0x7e, 0x7f, 
    0xf9, 0xff, 0x9f, 
    0xfb, 0xff, 0xdf, 
    0xfb, 0xff, 0xdf, 
    0xfb, 0xff, 0xdf, 
    0xfb, 0xff, 0xdf, 
    0xfb, 0xff, 0xdf, 
    0xfb, 0xff, 0xdf, 
    0xfb, 0xff, 0xdf, 
    0xf9, 0xff, 0x9f, 
    0xfe, 0x7e, 0x7f, 
    0xff, 0x99, 0xff, 
    0xff, 0xe7, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xeb, 
    0xff, 0xff, 0xf7, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xeb, 
    0xff, 0xff, 0xf7, 
    0xff, 0xff, 0xff, 
};

static struct _GImage poly0_base = {
    it_mono,
    2069,24,24,3,
    (uint8 *) poly0_data,
    &magnify0_clut,
    1
};


static uint8 star0_data[] = {
    0xfd, 0xff, 0xbf, 
    0xfc, 0x7e, 0x3f, 
    0xfd, 0x99, 0xbf, 
    0xfd, 0xe7, 0xbf, 
    0xfd, 0xff, 0xbf, 
    0xfd, 0xff, 0xbf, 
    0xfb, 0xff, 0xdf, 
    0xe7, 0xff, 0xe7, 
    0x9f, 0xff, 0xf9, 
    0x7f, 0xff, 0xfe, 
    0x9f, 0xff, 0xf9, 
    0xe7, 0xff, 0xe7, 
    0xfb, 0xff, 0xdf, 
    0xfd, 0xff, 0xbf, 
    0xfd, 0xff, 0xbf, 
    0xfd, 0xe7, 0xbf, 
    0xfd, 0x99, 0xbf, 
    0xfc, 0x7e, 0x3f, 
    0xfd, 0xff, 0xab, 
    0xff, 0xff, 0xf7, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xeb, 
    0xff, 0xff, 0xf7, 
    0xff, 0xff, 0xff, 
};

static struct _GImage star0_base = {
    it_mono,
    2069,24,24,3,
    (uint8 *) star0_data,
    &magnify0_clut,
    1
};

static uint8 shift0_data[] = {
    0xff, 0xef, 0xff, 
    0xff, 0xd7, 0xff, 
    0xff, 0x93, 0xff, 
    0xff, 0x55, 0xff, 
    0xff, 0xd7, 0xff, 
    0xff, 0xd7, 0xff, 
    0xff, 0xd7, 0xff, 
    0xff, 0xd7, 0xff, 
    0xef, 0xd7, 0xef, 
    0xdf, 0xd7, 0xf7, 
    0x80, 0x0, 0x3, 
    0x7f, 0xd7, 0xfd, 
    0x80, 0x0, 0x3, 
    0xdf, 0xd7, 0xf7, 
    0xef, 0xd7, 0xef, 
    0xff, 0xd7, 0xff, 
    0xff, 0xd7, 0xff, 
    0xff, 0xd7, 0xff, 
    0xff, 0xd7, 0xff, 
    0xff, 0x55, 0xff, 
    0xff, 0x93, 0xff, 
    0xff, 0xd7, 0xff, 
    0xff, 0xef, 0xff, 
    0xff, 0xff, 0xff, 
};

static struct _GImage shift0_base = {
    it_mono,
    2069,24,24,3,
    (uint8 *) shift0_data,
    &magnify0_clut,
    1
};


static uint8 pencil0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x2, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x1, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x2, 0x2, 0x1, 0x3, 0x3, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x1, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x3, 0x3, 0x3, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x3, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static GClut pencil0_clut = { 4, 0, 0,
    { 0xffffff, 0x0, 0xd0d000, 0xeed0d0 } };

static struct _GImage pencil0_base = {
    it_index,
    2069,24,24,24,
    (uint8 *) pencil0_data,
    &pencil0_clut,
    0
};


static uint8 freehand0_data[] = {
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x2, 0x2, 
	0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
    0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x2, 0x2, 
	0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x0, 0x2, 
    0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x2, 0x0, 
	0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x0, 0x2, 
    0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x0, 0x2, 
    0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
    0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x0, 0x2, 0x2, 0x1, 0x1, 0x1, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x0, 0x2, 0x1, 0x1, 0x1, 
	0x2, 0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x0, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x0, 0x2, 0x2, 0x0, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x0, 0x0, 
	0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x1, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x1, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x1, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x0, 0x2, 
    0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x0, 0x0, 0x2, 0x1, 
	0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x0, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 
	0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2
};

static struct _GImage freehand0_base = {
    it_index,
    15420,24,24,24,
    (uint8 *) freehand0_data,
    &corner0_clut,
    2
};

static GClut greyfree0_clut = { 3, 0, 2,
    { 0x404040, 0xc00000, 0x808080 } };

static struct _GImage greyfree0_base = {
    it_index,
    15420,24,24,24,
    (uint8 *) freehand0_data,
    &greyfree0_clut,
    2
};


static uint8 line0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x1, 0x3, 0x1, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x1, 
	0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x1, 0x3, 0x1, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
	0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x1, 0x3, 0x1, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage line0_base = {
    it_index,
    2069,24,24,24,
    (uint8 *) line0_data,
    &pencil0_clut,
    0
};


static uint8 hand0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x3, 0x3, 0x1, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x0, 0x1, 0x3, 0x3, 0x1, 0x1, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x1, 
	0x0, 0x1, 0x3, 0x3, 0x1, 0x3, 0x3, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x1, 
	0x0, 0x1, 0x3, 0x3, 0x1, 0x3, 0x3, 0x1, 
	0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x3, 
	0x1, 0x1, 0x3, 0x3, 0x1, 0x3, 0x3, 0x1, 
	0x1, 0x3, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 
	0x1, 0x1, 0x3, 0x3, 0x1, 0x3, 0x3, 0x1, 
	0x1, 0x3, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 
	0x3, 0x1, 0x3, 0x3, 0x1, 0x3, 0x3, 0x1, 
	0x3, 0x3, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x0, 0x1, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x3, 0x3, 0x1, 0x1, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x3, 0x3, 0x3, 0x1, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3, 0x3, 0x3, 0x3, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3, 0x3, 0x3, 0x3, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage hand0_base = {
    it_index,
    2069,24,24,24,
    (uint8 *) hand0_data,
    &pencil0_clut,
    0
};

static uint8 press2ptr0_data[] = {
    0xff, 0xf2, 
    0xef, 0x9c, 
    0xec, 0xf8, 
    0xef, 0xf0, 
    0xff, 0xe0, 
    0x11, 0xc0, 
    0xff, 0xf0, 
    0xef, 0xf2, 
    0xef, 0xe6, 
    0xef, 0xe7, 
};

static struct _GImage press2ptr0_base = {
    it_mono,
    2069,16,10,2,
    (uint8 *) press2ptr0_data,
    &magnify0_clut,
    1
};

GImage GIcon_press2ptr = { 0, { &press2ptr0_base }, NULL };
GImage GIcon_hand = { 0, { &hand0_base }, NULL };
GImage GIcon_line = { 0, { &line0_base }, NULL };
GImage GIcon_pencil = { 0, { &pencil0_base }, NULL };
GImage GIcon_shift = { 0, { &shift0_base }, NULL };
GImage GIcon_star = { 0, { &star0_base }, NULL };
GImage GIcon_poly = { 0, { &poly0_base }, NULL };
GImage GIcon_elipse = { 0, { &elipse0_base }, NULL };
GImage GIcon_rrect = { 0, { &rrect0_base }, NULL };
GImage GIcon_rect = { 0, { &rect0_base }, NULL };
GImage GIcon_squarecap = { 0, { &squarecap0_base }, NULL };
GImage GIcon_roundjoin = { 0, { &roundjoin0_base }, NULL };
GImage GIcon_roundcap = { 0, { &roundcap0_base }, NULL };
GImage GIcon_miterjoin = { 0, { &miterjoin0_base }, NULL };
GImage GIcon_buttcap = { 0, { &buttcap0_base }, NULL };
GImage GIcon_beveljoin = { 0, { &beveljoin0_base }, NULL };
GImage GIcon_freehand = { 0, { &freehand0_base }, NULL };
GImage GIcon_greyfree = { 0, { &greyfree0_base }, NULL };
GImage GIcon_pen = { 0, { &pen0_base }, NULL };
GImage GIcon_knife = { 0, { &knife0_base }, NULL };
GImage GIcon_scale = { 0, { &scale0_base }, NULL };
GImage GIcon_flip = { 0, { &flip0_base }, NULL };
GImage GIcon_skew = { 0, { &skew0_base }, NULL };
GImage GIcon_rotate = { 0, { &rotate0_base }, NULL };
GImage GIcon_3drotate = { 0, { &rotate3d0_base }, NULL };
GImage GIcon_perspective = { 0, { &perspective0_base }, NULL };
GImage GIcon_tangent = { 0, { &tangent0_base }, NULL };
GImage GIcon_curve = { 0, { &curve0_base }, NULL };
GImage GIcon_hvcurve = { 0, { &hvcurve0_base }, NULL };
GImage GIcon_corner = { 0, { &corner0_base }, NULL };
GImage GIcon_spirocorner = { 0, { &spirocorner0_base }, NULL };
GImage GIcon_spirocurve = { 0, { &spirocurve0_base }, NULL };
GImage GIcon_spirog2curve = { 0, { &spirog2curve0_base }, NULL };
GImage GIcon_spiroright = { 0, { &spiroright0_base }, NULL };
GImage GIcon_spiroleft = { 0, { &spiroleft0_base }, NULL };
GImage GIcon_spirodisabled = { 0, { &spirodisabled0_base }, NULL };
GImage GIcon_spiroup = { 0, { &spiroup0_base }, NULL };
GImage GIcon_spirodown = { 0, { &spirodown0_base }, NULL };
GImage GIcon_ruler = { 0, { &ruler0_base }, NULL };
GImage GIcon_pointer = { 0, { &pointer0_base }, NULL };
GImage GIcon_magnify = { 0, { &magnify0_base }, NULL };

GImage GIcon_midtangent = { 0, { &tangent1_base }, NULL };
GImage GIcon_midcurve = { 0, { &curve1_base }, NULL };
GImage GIcon_midhvcurve = { 0, { &hvcurve1_base }, NULL };
GImage GIcon_midcorner = { 0, { &corner1_base }, NULL };

/* Small (16x12) images */

static uint8 smallstar0_data[] = {
    0xf7, 0xef, 
    0xf1, 0x8f, 
    0xf6, 0x6f, 
    0xf7, 0xef, 
    0xef, 0xf7, 
    0x9f, 0xf9, 
    0x7f, 0xfe, 
    0x9f, 0xf9, 
    0xef, 0xf7, 
    0xf7, 0xef, 
    0xf6, 0x6f, 
    0xf1, 0x8f, 
};

static struct _GImage smallstar0_base = {
    it_mono,
    15420,16,12,2,
    (uint8 *) smallstar0_data,
    &magnify0_clut,
    1
};

static uint8 smallruler0_data[] = {
    0xff, 0xff, 
    0xef, 0xff, 
    0xdf, 0xff, 
    0x81, 0xfe, 
    0xdd, 0xfe, 
    0xed, 0xfe, 
    0xfd, 0xfe, 
    0xfd, 0xb6, 
    0xfd, 0xb6, 
    0xfd, 0xb6, 
    0xfc, 0x0, 
    0xff, 0xff, 
};

static struct _GImage smallruler0_base = {
    it_mono,
    15420,16,12,2,
    (uint8 *) smallruler0_data,
    &magnify0_clut,
    1
};

static uint8 smallrect0_data[] = {
    0xff, 0xff, 
    0xff, 0xff, 
    0xc0, 0x3, 
    0xdf, 0xfb, 
    0xdf, 0xfb, 
    0xdf, 0xfb, 
    0xdf, 0xfb, 
    0xdf, 0xfb, 
    0xc0, 0x3, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
};

static struct _GImage smallrect0_base = {
    it_mono,
    15420,16,12,2,
    (uint8 *) smallrect0_data,
    &magnify0_clut,
    1
};

static uint8 smallelipse0_data[] = {
    0xff, 0xff, 
    0xff, 0xff, 
    0xfc, 0x3f, 
    0xf3, 0xcf, 
    0xef, 0xf7, 
    0xdf, 0xfb, 
    0xef, 0xf7, 
    0xf3, 0xcf, 
    0xfc, 0x3f, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
};

static struct _GImage smallelipse0_base = {
    it_mono,
    15420,16,12,2,
    (uint8 *) smallelipse0_data,
    &magnify0_clut,
    1
};

static uint8 smallpoly0_data[] = {
    0xff, 0xff, 
    0xfd, 0xff, 
    0xf2, 0x7f, 
    0xef, 0xbf, 
    0xdf, 0xdf, 
    0xdf, 0xdf, 
    0xdf, 0xdf, 
    0xdf, 0xdf, 
    0xdf, 0xdf, 
    0xef, 0xbf, 
    0xf2, 0x7f, 
    0xfd, 0xff, 
};

static struct _GImage smallpoly0_base = {
    it_mono,
    15420,16,12,2,
    (uint8 *) smallpoly0_data,
    &magnify0_clut,
    1
};

static uint8 smallpointer0_data[] = {
    0xdf, 0xff, 
    0xcf, 0xff, 
    0xc7, 0xff, 
    0xc3, 0xff, 
    0xc1, 0xff, 
    0xc0, 0xff, 
    0xc3, 0xff, 
    0xd9, 0xff, 
    0xf9, 0xff, 
    0xfc, 0xff, 
    0xfc, 0xff, 
    0xff, 0xff, 
};

static struct _GImage smallpointer0_base = {
    it_mono,
    15420,16,12,2,
    (uint8 *) smallpointer0_data,
    &magnify0_clut,
    1
};

static uint8 smallpen0_data[] = {
    0xff, 0xff, 
    0xff, 0x1f, 
    0xfc, 0xef, 
    0xe3, 0xf0, 
    0x1f, 0xb7, 
    0x0, 0x57, 
    0x1f, 0xb7, 
    0xe3, 0xf0, 
    0xfc, 0xef, 
    0xff, 0x1f, 
    0xff, 0xff, 
    0xff, 0xff, 
};

static struct _GImage smallpen0_base = {
    it_mono,
    15420,16,12,2,
    (uint8 *) smallpen0_data,
    &magnify0_clut,
    1
};

static uint8 smallpencil0_data[] = {
    0xc7, 0xff, 
    0xcb, 0xff, 
    0xdd, 0xff, 
    0xee, 0xff, 
    0xf7, 0x7f, 
    0xfb, 0xbf, 
    0xfd, 0xdf, 
    0xfe, 0xef, 
    0xff, 0x67, 
    0xff, 0x9b, 
    0xff, 0xd7, 
    0xff, 0xef, 
};

static struct _GImage smallpencil0_base = {
    it_mono,
    15420,16,12,2,
    (uint8 *) smallpencil0_data,
    &magnify0_clut,
    1
};

static uint8 smallknife0_data[] = {
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0x0, 0x1, 
    0xc7, 0xef, 
    0xf8, 0xe1, 
    0xff, 0xf, 
    0xff, 0xef, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
};

static struct _GImage smallknife0_base = {
    it_mono,
    15420,16,12,2,
    (uint8 *) smallknife0_data,
    &magnify0_clut,
    1
};

static uint8 smallmag0_data[] = {
    0xff, 0xff, 
    0xf1, 0xff, 
    0xee, 0xff, 
    0xdf, 0x7f, 
    0xdf, 0x7f, 
    0xdf, 0x7f, 
    0xee, 0xff, 
    0xf1, 0x7f, 
    0xff, 0xbf, 
    0xff, 0xdf, 
    0xff, 0xef, 
    0xff, 0xff, 
};

static struct _GImage smallmag0_base = {
    it_mono,
    15420,16,12,2,
    (uint8 *) smallmag0_data,
    &magnify0_clut,
    1
};

static uint8 smallhand0_data[] = {
    0xfe, 0x7f, 
    0xfd, 0xbf, 
    0xed, 0x8f, 
    0xd5, 0xb7, 
    0xd5, 0xb5, 
    0xd9, 0xb2, 
    0xe9, 0xb2, 
    0xed, 0xb6, 
    0x97, 0xfe, 
    0x67, 0xfd, 
    0xb7, 0xfd, 
    0xdf, 0xfd, 
};

static struct _GImage smallhand0_base = {
    it_mono,
    15420,16,12,2,
    (uint8 *) smallhand0_data,
    &magnify0_clut,
    1
};

static uint8 smallcurve0_data[] = {
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 
	0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x0, 0x1, 0x1, 0x1, 
    0x0, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x1, 0x0, 0x0, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 
	0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1
};

static GClut smallcurve0_clut = { 3, 0, 1,
    { 0x0, 0xb0b0b0, 0xff0000 } };

static struct _GImage smallcurve0_base = {
    it_index,
    15420,16,12,16,
    (uint8 *) smallcurve0_data,
    &smallcurve0_clut,
    1
};

static uint8 smallhvcurve0_data[] = {
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 
	0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x0, 0x1, 0x1, 0x1, 
    0x0, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x1, 0x0, 0x0, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 
	0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1
};

static struct _GImage smallhvcurve0_base = {
    it_index,
    15420,16,12,16,
    (uint8 *) smallhvcurve0_data,
    &smallcurve0_clut,
    1
};

static uint8 smallcorner0_data[] = {
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1
};

static struct _GImage smallcorner0_base = {
    it_index,
    15420,16,12,16,
    (uint8 *) smallcorner0_data,
    &smallcurve0_clut,
    1
};

static uint8 smalltangent0_data[] = {
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x1, 0x1, 0x1, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1
};

static struct _GImage smalltangent0_base = {
    it_index,
    15420,16,12,16,
    (uint8 *) smalltangent0_data,
    &smallcurve0_clut,
    1
};

static uint8 smallspirocorner0_data[] = {
    0x2, 0x1, 0x3, 0x2, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 
    0x2, 0x3, 0x1, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 
    0x3, 0x2, 0x2, 0x1, 0x2, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x3, 0x2, 0x1, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x3, 0x2, 0x3, 0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x2, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x1, 0x4, 0x4, 0x4, 0x4, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x4, 0x1, 0x4, 0x4, 0x4, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x4, 0x4, 0x1, 0x4, 0x4, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x4, 0x4, 0x1, 0x4, 0x4, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x3, 0x2, 0x2, 0x3, 0x4, 0x4, 0x1, 0x4, 0x4, 0x2, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x3, 0x1, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 
    0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x1, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x3, 
    0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x3, 0x3, 0x1, 0x3, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 
    0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 0x1, 0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 
};

static GClut smallspirocorner0_clut = { 5, 1, 0,
    { 0xffffff, 0x0, 0xc0c0c0, 0x808080, 0xff0000 } };

static struct _GImage smallspirocorner0_base = {
    it_index,
    15420,20,14,20,
    (uint8 *) smallspirocorner0_data,
    &smallspirocorner0_clut,
    0x2
};

static uint8 smallspirog2curve0_data[] = {
    0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
    0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x4, 0x3, 0x4, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x4, 0x4, 0x3, 0x4, 0x4, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x4, 0x4, 0x4, 0x3, 0x4, 0x4, 0x4, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x4, 0x4, 0x4, 0x4, 0x3, 0x4, 0x4, 0x4, 0x4, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x4, 0x4, 0x4, 0x3, 0x4, 0x4, 0x4, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x4, 0x4, 0x3, 0x4, 0x4, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x4, 0x3, 0x4, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
};

static GClut smallspirog2curve0_clut = { 5, 1, 0,
    { 0xffffff, 0xc0c0c0, 0x808080, 0x0, 0xff0000 } };

static struct _GImage smallspirog2curve0_base = {
    it_index,
    15420,20,14,20,
    (uint8 *) smallspirog2curve0_data,
    &smallspirog2curve0_clut,
    1
};

static uint8 smallspiroright0_data[] = {
    0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
    0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x3, 0x3, 0x3, 0x3, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x3, 0x3, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x3, 0x3, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x3, 0x3, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x3, 0x3, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x3, 0x3, 0x3, 0x3, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
};

static GClut smallspiroright0_clut = { 4, 1, 0,
    { 0xffffff, 0xc0c0c0, 0x808080, 0xff0000 } };

static struct _GImage smallspiroright0_base = {
    it_index,
    15420,20,14,20,
    (uint8 *) smallspiroright0_data,
    &smallspiroright0_clut,
    1
};

static uint8 smallspiroleft0_data[] = {
    0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
    0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x3, 0x3, 0x3, 0x3, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x3, 0x3, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x3, 0x3, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x3, 0x3, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x3, 0x3, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x3, 0x3, 0x3, 0x3, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x3, 0x3, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
};

static GClut smallspiroleft0_clut = { 4, 1, 0,
    { 0xffffff, 0xc0c0c0, 0x808080, 0xff0000 } };

static struct _GImage smallspiroleft0_base = {
    it_index,
    15420,20,14,20,
    (uint8 *) smallspiroleft0_data,
    &smallspiroleft0_clut,
    0x1
};

static uint8 smallspirocurve0_data[] = {
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
    0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 
    0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x4, 0x4, 0x4, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x4, 0x4, 0x4, 0x4, 0x4, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x1, 0x2, 0x1, 0x2, 0x1, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x1, 0x2, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x3, 0x3, 0x3, 0x2, 0x1, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x1, 0x2, 
    0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x4, 0x4, 0x4, 0x4, 0x4, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x3, 0x3, 
    0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x4, 0x4, 0x4, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 
    0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
};

static GClut smallspirocurve0_clut = { 5, 1, 0,
    { 0xffffff, 0xc0c0c0, 0x808080, 0x0, 0xff0000 } };

static struct _GImage smallspirocurve0_base = {
    it_index,
    15420,20,14,20,
    (uint8 *) smallspirocurve0_data,
    &smallspirocurve0_clut,
    1
};

static uint8 smallflip0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 
	0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 
	0x2, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x0, 
	0x0, 0x0, 0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x0, 
	0x2, 0x0, 0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x2, 0x0, 
	0x0, 0x0, 0x3, 0x0, 0x3, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x2, 0x0, 
	0x2, 0x0, 0x3, 0x0, 0x3, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x2, 0x0, 
	0x0, 0x0, 0x3, 0x0, 0x0, 0x3, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x2, 0x0, 
	0x2, 0x0, 0x3, 0x0, 0x0, 0x3, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 
	0x0, 0x0, 0x3, 0x3, 0x3, 0x3, 0x3, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage smallflip0_base = {
    it_index,
    15420,16,12,16,
    (uint8 *) smallflip0_data,
    &rotate0_clut,
    0
};

static uint8 smallrotate0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x3, 0x0, 0x2, 0x2, 0x3, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x3, 0x0, 0x0, 0x2, 0x0, 0x0, 
	0x3, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x3, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 
	0x0, 0x3, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x3, 0x0, 0x0, 0x2, 0x0, 0x0, 
	0x3, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x3, 0x0, 0x2, 0x0, 0x3, 
	0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x3, 0x2, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage smallrotate0_base = {
    it_index,
    15420,16,12,16,
    (uint8 *) smallrotate0_data,
    &rotate0_clut,
    0
};

static uint8 smallscale0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x3, 0x3, 0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage smallscale0_base = {
    it_index,
    15420,16,12,16,
    (uint8 *) smallscale0_data,
    &rotate0_clut,
    0
};

static uint8 smallskew0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x3, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 
    0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage smallskew0_base = {
    it_index,
    15420,16,12,16,
    (uint8 *) smallskew0_data,
    &rotate0_clut,
    0
};

static uint8 small3drotate0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage small3drotate0_base = {
    it_index,
    15420,16,12,16,
    (uint8 *) small3drotate0_data,
    &rotate0_clut,
    0
};

static uint8 smallperspective0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x0, 0x0, 0x3, 0x3, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x0, 0x3, 0x0, 0x0, 0x3, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x0, 0x3, 0x0, 0x0, 0x3, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x3, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x3, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage smallperspective0_base = {
    it_index,
    15420,16,12,16,
    (uint8 *) smallperspective0_data,
    &rotate0_clut,
    0
};

static uint8 logo_data[] = {
    0x25, 0x1a, 0x1f, 0x00, 0x00, 0x1a, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x26, 0x3b, 0x38, 0x28, 0x20, 0x3b, 0x38, 0x2f, 0x25, 0x00, 0x00, 0x00, 0x00,
    0x25, 0x16, 0x32, 0x3a, 0x16, 0x16, 0x32, 0x3a, 0x16, 0x26, 0x21, 0x00, 0x00,
    0x00, 0x25, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x21, 0x00, 0x00,
    0x00, 0x25, 0x16, 0x33, 0x37, 0x08, 0x16, 0x33, 0x37, 0x08, 0x0f, 0x00, 0x00,
    0x00, 0x00, 0x0f, 0x19, 0x3e, 0x29, 0x0f, 0x19, 0x3e, 0x29, 0x17, 0x00, 0x00,
    0x00, 0x00, 0x0f, 0x07, 0x36, 0x34, 0x0f, 0x0f, 0x35, 0x36, 0x14, 0x00, 0x00,
    0x00, 0x00, 0x17, 0x17, 0x23, 0x3d, 0x27, 0x19, 0x1e, 0x3e, 0x30, 0x22, 0x25,
    0x00, 0x00, 0x18, 0x2e, 0x05, 0x31, 0x39, 0x3c, 0x11, 0x29, 0x39, 0x3c, 0x25,
    0x00, 0x00, 0x13, 0x2d, 0x24, 0x10, 0x02, 0x0a, 0x24, 0x10, 0x02, 0x0a, 0x25,
    0x00, 0x00, 0x04, 0x1b, 0x0c, 0x0e, 0x01, 0x12, 0x0e, 0x1c, 0x08, 0x00, 0x00,
    0x00, 0x00, 0x09, 0x2a, 0x2a, 0x2b, 0x15, 0x2a, 0x2a, 0x2c, 0x0d, 0x00, 0x00,
    0x00, 0x00, 0x03, 0x0b, 0x09, 0x09, 0x06, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00
};

static GClut logo_clut = { 64, 1, 1,
  { 0x000000, 0x302A25, 0x36362F, 0x3B342F, 0x323331, 0x383937, 0x3D3D36, 0x3A3B39,
    0x3C3E3B, 0x433C36, 0x43423B, 0x46403A, 0x4E453A, 0x4A433D, 0x52493F, 0x414340,
    0x4A4942, 0x4A4B49, 0x574E43, 0x554E48, 0x544F4E, 0x55544D, 0x4B4F51, 0x535452,
    0x5B5A52, 0x585A57, 0x575B5D, 0x635A4F, 0x6D6458, 0x5B6062, 0x616360, 0x616668,
    0x69676B, 0x676B6E, 0x6F6A69, 0x6C6E6B, 0x736B65, 0x706F67, 0x6B6F72, 0x787372,
    0x73777A, 0x7B7D7A, 0x82786C, 0x857B6F, 0x8C8276, 0x898678, 0x8A827C, 0x7B8083,
    0x858784, 0x8D8887, 0x818689, 0xABADAA, 0xC7C2C1, 0xC4C6C3, 0xCED0CC, 0xD4D6D3,
    0xD1D7D9, 0xDEE0DD, 0xD9DEE1, 0xDCE2E4, 0xE5E7E4, 0xEEE8E7, 0xE9EBE8, 0xEDEFEB } };

static struct _GImage logo_base = {
    it_index,
    15420,13,13,13,
    (uint8 *) logo_data,
    &logo_clut,
    0
};

static GClut logoback_clut = { 2, 0, 1,
    { 0x808080, 0xb0b0b0 } };

static uint8 logoback_data[] = {
    0xff, 0xff, 
    0xfe, 0x7f, 
    0xe5, 0xbf, 
    0xd9, 0xff, 
    0xdd, 0xff, 
    0xdd, 0xff, 
    0x80, 0x7f, 
    0xdd, 0xff, 
    0xdd, 0xff, 
    0xdd, 0xff, 
    0xdd, 0xff, 
    0x0, 0x3f, 
    0xff, 0xff, 
};

static struct _GImage logoback_base = {
    it_mono,
    15420,11,13,2,
    (uint8 *) logoback_data,
    &logoback_clut,
    1
};

static uint8 logogrid_data[] = {
    0xbf, 0xff, 
    0x3f, 0xff, 
    0xbf, 0xff, 
    0x9f, 0xff, 
    0xaf, 0xff, 
    0xb7, 0xff, 
    0xbb, 0xff, 
    0xbd, 0xff, 
    0xbe, 0xff, 
    0x0, 0x1f, 
    0xbf, 0xbf, 
    0xbf, 0xdf, 
    0xbf, 0xff, 
};

static GClut def_clut = { 2, 0, 1,
    { 0x0, 0xb0b0b0 } };

static struct _GImage logogrid_base = {
    it_mono,
    15420,11,13,2,
    (uint8 *) logogrid_data,
    &def_clut,
    1
};

static uint8 image_data[] = {
    0x00, 0x00,
    0x7f, 0xfe,
    0x7f, 0xfe,
    0x7f, 0xfe,
    0x7f, 0xfe,
    0x7f, 0xfe,
    0x7f, 0xfe,
    0x7f, 0xfe,
    0x7f, 0xfe,
    0x7f, 0xfe,
    0x7f, 0xfe,
    0x00, 0x00,
};

static struct _GImage def_base = {
    it_mono,
    0,16,12,2,
    (uint8 *) image_data,
    &def_clut,
    1
};
static GClut red_clut = { 2, 0, COLOR_UNKNOWN,
    { 0x0, 0xff0000 } };
static struct _GImage red_base = {
    it_mono,
    0,16,12,2,
    (uint8 *) image_data,
    &red_clut,
    COLOR_UNKNOWN
};
static GClut blue_clut = { 2, 0, COLOR_UNKNOWN,
    { 0x0, 0x0000ff } };
static struct _GImage blue_base = {
    it_mono,
    0,16,12,2,
    (uint8 *) image_data,
    &blue_clut,
    COLOR_UNKNOWN
};
static GClut green_clut = { 2, 0, COLOR_UNKNOWN,
    { 0x0, 0x00ff00 } };
static struct _GImage green_base = {
    it_mono,
    0,16,12,2,
    (uint8 *) image_data,
    &green_clut,
    COLOR_UNKNOWN
};
static GClut magenta_clut = { 2, 0, COLOR_UNKNOWN,
    { 0x0, 0xff00ff } };
static struct _GImage magenta_base = {
    it_mono,
    0,16,12,2,
    (uint8 *) image_data,
    &magenta_clut,
    COLOR_UNKNOWN
};
static GClut cyan_clut = { 2, 0, COLOR_UNKNOWN,
    { 0x0, 0x00ffff } };
static struct _GImage cyan_base = {
    it_mono,
    0,16,12,2,
    (uint8 *) image_data,
    &cyan_clut,
    COLOR_UNKNOWN
};
static GClut yellow_clut = { 2, 0, COLOR_UNKNOWN,
    { 0x0, 0xffff00 } };
static struct _GImage yellow_base = {
    it_mono,
    0,16,12,2,
    (uint8 *) image_data,
    &yellow_clut,
    COLOR_UNKNOWN
};
static GClut white_clut = { 2, 0, COLOR_UNKNOWN,
    { 0x0, 0xffffff } };
static struct _GImage white_base = {
    it_mono,
    0,16,12,2,
    (uint8 *) image_data,
    &white_clut,
    COLOR_UNKNOWN
};
static GClut custom_clut = { 2, 0, COLOR_UNKNOWN,
    { 0x0, 0xffff00 } };
static struct _GImage custom_base = {
    it_mono,
    0,16,12,2,
    (uint8 *) image_data,
    &custom_clut,
    COLOR_UNKNOWN
};

GImage def_image = { 0, { &def_base }, NULL };
GImage red_image = { 0, { &red_base }, NULL };
GImage blue_image = { 0, { &blue_base }, NULL };
GImage green_image = { 0, { &green_base }, NULL };
GImage magenta_image = { 0, { &magenta_base }, NULL };
GImage yellow_image = { 0, { &yellow_base }, NULL };
GImage cyan_image = { 0, { &cyan_base }, NULL };
GImage white_image = { 0, { &white_base }, NULL };
GImage customcolor_image = { 0, { &custom_base }, NULL };

static uint8 continue_data[] = {
    0xfe, 0xff, 
    0xff, 0x7f, 
    0xf0, 0x3f, 
    0xef, 0x7f, 
    0xfe, 0xff, 
    0x6f, 0xed, 
    0x6f, 0xed, 
    0x6f, 0xed, 
    0x6f, 0xed, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
};

static struct _GImage continue_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) continue_data,
    &magnify0_clut,
    1
};

static uint8 stepout_data[] = {
    0xfe, 0x1f, 
    0xfd, 0xef, 
    0xfd, 0xc7, 
    0xfd, 0xef, 
    0xfd, 0xff, 
    0x6d, 0xed, 
    0x6d, 0xed, 
    0x6d, 0xed, 
    0x6d, 0xed, 
    0xfd, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
};

static struct _GImage stepout_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) stepout_data,
    &magnify0_clut,
    1
};

static uint8 stepover_data[] = {
    0xf0, 0x1f, 
    0xef, 0xef, 
    0xef, 0xc7, 
    0xef, 0xef, 
    0xff, 0xff, 
    0x6f, 0xed, 
    0x6f, 0xed, 
    0x6f, 0xed, 
    0x6f, 0xed, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
};

static struct _GImage stepover_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) stepover_data,
    &magnify0_clut,
    1
};

static uint8 stepinto_data[] = {
    0xff, 0xff, 
    0xf3, 0xff, 
    0xed, 0xff, 
    0xed, 0xff, 
    0xfd, 0xff, 
    0x6d, 0xed, 
    0x6d, 0xed, 
    0x6d, 0xed, 
    0x6d, 0xed, 
    0xf8, 0xff, 
    0xfd, 0xff, 
    0xff, 0xff, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
};

static struct _GImage stepinto_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) stepinto_data,
    &magnify0_clut,
    1
};

static uint8 watchpnt_data[] = {
    1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 0, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 0, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 0, 1, 1, 
    1, 1, 1, 1, 1, 1, 0, 1, 
	1, 1, 1, 1, 1, 0, 1, 1, 
    1, 1, 1, 1, 1, 1, 0, 1, 
	1, 1, 1, 1, 0, 1, 1, 1, 
    1, 1, 1, 1, 1, 0, 1, 1, 
	1, 1, 1, 1, 0, 1, 1, 1, 
    1, 1, 1, 1, 0, 1, 1, 1, 
	1, 1, 1, 2, 2, 2, 1, 1, 
    1, 1, 0, 0, 3, 3, 1, 1, 
	1, 1, 2, 2, 2, 2, 2, 1, 
    0, 0, 3, 3, 3, 3, 1, 1, 
	1, 1, 2, 2, 2, 2, 2, 1, 
    1, 1, 0, 0, 3, 3, 1, 1, 
	1, 1, 2, 2, 2, 2, 2, 1, 
    1, 1, 1, 1, 0, 1, 1, 1, 
	1, 1, 1, 2, 2, 2, 1, 1, 
    1, 1, 1, 1, 1, 0, 1, 1, 
	1, 1, 1, 1, 0, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 0, 1, 
	1, 1, 1, 1, 0, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 0, 1, 
	1, 1, 1, 1, 1, 0, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 0, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 0, 1, 1
};

static GClut watchpnt_clut = { 4, 0, 1,
    { 0x000000, 0xb0b0b0, 0xff0000, 0x0000ff } };

static struct _GImage watchpnt_base = {
    it_index,
    15420,16,16,16,
    (uint8 *) watchpnt_data,
    &watchpnt_clut,
    1
};

static uint8 menudelta_data[] = {
    0xff, 0xff, 
    0xff, 0xff, 
    0xe0, 0x3, 
    0xef, 0xfb, 
    0xf7, 0xf7, 
    0xf7, 0xf7, 
    0xfb, 0xef, 
    0xfb, 0xef, 
    0xfd, 0xdf, 
    0xfd, 0xdf, 
    0xfe, 0xbf, 
    0xfe, 0xbf, 
    0xff, 0x7f, 
    0xff, 0x7f, 
    0xff, 0xff, 
    0xff, 0xff, 
};

static struct _GImage menudelta_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) menudelta_data,
    &magnify0_clut,
    1
};

static uint8 exit_data[] = {
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0x8a, 0xa3, 
    0xba, 0xb7, 
    0xba, 0xb7, 
    0xbd, 0xb7, 
    0x9d, 0xb7, 
    0xbd, 0xb7, 
    0xba, 0xb7, 
    0xba, 0xb7, 
    0x8a, 0xb7, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
};

static struct _GImage exit_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) exit_data,
    &magnify0_clut,
    1
};

static uint8 stopped_data[] = {
    1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 0, 1, 1, 
	1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 0, 0, 1, 
	1, 1, 1, 1, 
    1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 1, 1, 1, 
    1, 0, 0, 2, 2, 0, 2, 2, 
	2, 0, 0, 2, 0, 0, 2, 2, 
	0, 0, 2, 2, 0, 0, 2, 2, 
	2, 0, 2, 2, 0, 0, 0, 0, 
	0, 1, 1, 1, 
    1, 0, 2, 0, 0, 0, 0, 2, 
	0, 0, 2, 0, 2, 0, 2, 0, 
	2, 0, 2, 0, 2, 0, 2, 0, 
	0, 0, 2, 0, 2, 0, 0, 0, 
	0, 0, 1, 1, 
    1, 0, 0, 2, 0, 0, 0, 2, 
	0, 0, 2, 0, 2, 0, 2, 2, 
	0, 0, 2, 2, 0, 0, 2, 2, 
	0, 0, 2, 0, 2, 0, 0, 0, 
	0, 0, 0, 1, 
    1, 0, 0, 0, 2, 0, 0, 2, 
	0, 0, 2, 0, 2, 0, 2, 0, 
	0, 0, 2, 0, 0, 0, 2, 0, 
	0, 0, 2, 0, 2, 0, 0, 0, 
	0, 0, 1, 1, 
    1, 0, 2, 2, 0, 0, 0, 2, 
	0, 0, 0, 2, 0, 0, 2, 0, 
	0, 0, 2, 0, 0, 0, 2, 2, 
	2, 0, 2, 2, 0, 0, 0, 0, 
	0, 1, 1, 1, 
    1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 0, 0, 1, 
	1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 0, 1, 1, 
	1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1
};

static GClut stopped_clut = { 3, 0, 1,
    { 0xff0000, 0xb0b0b0, 0xffffff } };

static struct _GImage stopped_base = {
    it_index,
    15420,36,12,36,
    (uint8 *) stopped_data,
    &stopped_clut,
    1
};

static uint8 stop_data[] = {
    1, 1, 1, 1, 1, 1, 0, 0, 
	0, 0, 0, 0, 0, 1, 1, 1, 
	1, 1, 1, 
    1, 1, 1, 1, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 1, 
	1, 1, 1, 
    1, 1, 1, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	1, 1, 1, 
    1, 1, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 1, 1, 
    1, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 1, 
    1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 
    1, 0, 0, 2, 2, 0, 2, 2, 
	2, 0, 0, 2, 0, 0, 2, 2, 
	0, 0, 1, 
    1, 0, 2, 0, 0, 0, 0, 2, 
	0, 0, 2, 0, 2, 0, 2, 0, 
	2, 0, 1, 
    1, 0, 0, 2, 0, 0, 0, 2, 
	0, 0, 2, 0, 2, 0, 2, 2, 
	0, 0, 1, 
    1, 0, 0, 0, 2, 0, 0, 2, 
	0, 0, 2, 0, 2, 0, 2, 0, 
	0, 0, 1, 
    1, 0, 2, 2, 0, 0, 0, 2, 
	0, 0, 0, 2, 0, 0, 2, 0, 
	0, 0, 1, 
    1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 
    1, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 1, 
    1, 1, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 1, 1, 
    1, 1, 1, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	1, 1, 1, 
    1, 1, 1, 1, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 1, 
	1, 1, 1, 
    1, 1, 1, 1, 1, 1, 0, 0, 
	0, 0, 0, 0, 0, 1, 1, 1, 
	1, 1, 1
};

static struct _GImage stop_base = {
    it_index,
    15420,19,17,19,
    (uint8 *) stop_data,
    &stopped_clut,
    1
};

static uint8 exclude_data[] = {
    0xff, 0xff, 0xff, 0xff, 0xff, 
    0x80, 0x1f, 0xff, 0xff, 0xff, 
    0xbf, 0xdf, 0xff, 0xff, 0xff, 
    0xbf, 0xdf, 0xff, 0xff, 0xff, 
    0xbf, 0xdf, 0xef, 0xff, 0xff, 
    0xbf, 0xdf, 0xf7, 0xff, 0xff, 
    0xbe, 0x0, 0x83, 0xff, 0x81, 
    0xbe, 0xde, 0xfd, 0xff, 0xbd, 
    0xbe, 0xde, 0x83, 0xff, 0xbd, 
    0x80, 0x1e, 0xf7, 0xfc, 0x3d, 
    0xfe, 0xfe, 0xef, 0xfd, 0xfd, 
    0xfe, 0xfe, 0xff, 0xfd, 0xfd, 
    0xfe, 0xfe, 0xff, 0xfd, 0xfd, 
    0xfe, 0xfe, 0xff, 0xfd, 0xfd, 
    0xfe, 0x0, 0xff, 0xfc, 0x1, 
    0xff, 0xff, 0xff, 0xff, 0xff, 
};

static struct _GImage exclude_base = {
    it_mono,
    15420,40,16,5,
    (uint8 *) exclude_data,
    &magnify0_clut,
    1
};

static uint8 intersection_data[] = {
    0xff, 0xff, 0xff, 0xff, 0xff, 
    0x80, 0x1f, 0xff, 0xff, 0xff, 
    0xbf, 0xdf, 0xff, 0xff, 0xff, 
    0xbf, 0xdf, 0xff, 0xff, 0xff, 
    0xbf, 0xdf, 0xef, 0xff, 0xff, 
    0xbf, 0xdf, 0xf7, 0xff, 0xff, 
    0xbe, 0x0, 0x83, 0xfc, 0x3f, 
    0xbe, 0xde, 0xfd, 0xfd, 0xbf, 
    0xbe, 0xde, 0x83, 0xfd, 0xbf, 
    0x80, 0x1e, 0xf7, 0xfc, 0x3f, 
    0xfe, 0xfe, 0xef, 0xff, 0xff, 
    0xfe, 0xfe, 0xff, 0xff, 0xff, 
    0xfe, 0xfe, 0xff, 0xff, 0xff, 
    0xfe, 0xfe, 0xff, 0xff, 0xff, 
    0xfe, 0x0, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 
};

static struct _GImage intersection_base = {
    it_mono,
    15420,40,16,5,
    (uint8 *) intersection_data,
    &magnify0_clut,
    1
};

static uint8 rmoverlap_data[] = {
    0xff, 0xff, 0xff, 0xff, 0xff, 
    0x80, 0x1f, 0xff, 0x0, 0x3f, 
    0xbf, 0xdf, 0xff, 0x7f, 0xbf, 
    0xbf, 0xdf, 0xff, 0x7f, 0xbf, 
    0xbf, 0xdf, 0xef, 0x7f, 0xbf, 
    0xbf, 0xdf, 0xf7, 0x7f, 0xbf, 
    0xbe, 0x0, 0x83, 0x7f, 0x81, 
    0xbe, 0xde, 0xfd, 0x7f, 0xfd, 
    0xbe, 0xde, 0x83, 0x7f, 0xfd, 
    0x80, 0x1e, 0xf7, 0x1, 0xfd, 
    0xfe, 0xfe, 0xef, 0xfd, 0xfd, 
    0xfe, 0xfe, 0xff, 0xfd, 0xfd, 
    0xfe, 0xfe, 0xff, 0xfd, 0xfd, 
    0xfe, 0xfe, 0xff, 0xfd, 0xfd, 
    0xfe, 0x0, 0xff, 0xfc, 0x1, 
    0xff, 0xff, 0xff, 0xff, 0xff, 
};

static struct _GImage rmoverlap_base = {
    it_mono,
    15420,40,16,5,
    (uint8 *) rmoverlap_data,
    &magnify0_clut,
    1
};

static uint8 findinter_data[] = {
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x2, 0x0, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
    0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 
	0x2, 0x0, 0x2, 0x1, 0x1, 0x1, 0x0, 0x1, 
    0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x0, 0x2, 
	0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 
    0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x0, 0x2, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1
};

static struct _GImage findinter_base = {
    it_index,
    15420,40,16,40,
    (uint8 *) findinter_data,
    &smallcurve0_clut,
    1
};

static uint8 styles_data[] = {
    0xfc, 0xc0, 0x7f, 
    0xfa, 0x40, 0x3f, 
    0xfb, 0xc0, 0x1f, 
    0xfb, 0xc7, 0x1f, 
    0xfb, 0xc7, 0x1f, 
    0xe1, 0xc0, 0x3f, 
    0xf7, 0xc0, 0x3f, 
    0xf7, 0xc0, 0x1f, 
    0xf7, 0xc7, 0x1f, 
    0xf7, 0xc7, 0x1f, 
    0xef, 0xc0, 0x1f, 
    0xef, 0xc0, 0x1f, 
    0xef, 0xc0, 0x3f, 
    0xef, 0xff, 0xff, 
    0x2f, 0xff, 0xff, 
    0x9f, 0xff, 0xff, 
};

static struct _GImage styles_base = {
    it_mono,
    15420,20,16,3,
    (uint8 *) styles_data,
    NULL,
    1
};

static uint8 bold_data[] = {
    0xff, 0xff, 
    0x80, 0x7f, 
    0x80, 0x3f, 
    0x80, 0x1f, 
    0x8f, 0x1f, 
    0x8f, 0x1f, 
    0x80, 0x1f, 
    0x80, 0x3f, 
    0x80, 0x3f, 
    0x8f, 0x1f, 
    0x8f, 0x1f, 
    0x8f, 0x1f, 
    0x80, 0x1f, 
    0x80, 0x1f, 
    0x80, 0x3f, 
    0xff, 0xff, 
};

static struct _GImage bold_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) bold_data,
    &magnify0_clut,
    1
};

static uint8 changexheight_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x0, 0x0, 0x3, 0x0, 0x3, 0x0, 0x3, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 
	0x2, 0x0, 0x4, 0x0, 0x4, 0x0, 0x4, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x5, 0x5, 0x0, 0x0, 0x1, 0x0, 
	0x2, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x5, 0x0, 0x1, 0x0, 
	0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x5, 0x0, 0x1, 0x0, 
	0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x5, 0x0, 0x1, 0x0, 
	0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x5, 0x0, 0x1, 0x0, 
	0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static GClut changexheight_clut = { 7, 1, 0,
    { 0xffffff, 0x0, 0x9f00, 0x80aa80, 0x808080, 0xff0000, 0xff8080 } };

static struct _GImage changexheight_base = {
    it_index,
    15420,16,16,16,
    (uint8 *) changexheight_data,
    &changexheight_clut,
    0
};

static uint8 smallcaps_data[] = {
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0x83, 0xff, 
    0xbd, 0xff, 
    0xbd, 0xff, 
    0xbd, 0xff, 
    0x83, 0xff, 
    0xbd, 0xff, 
    0xbd, 0xff, 
    0xbd, 0xff, 
    0xbd, 0xff, 
    0x83, 0xff, 
    0xff, 0xff, 
};

static struct _GImage smallcaps_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) smallcaps_data,
    NULL,
    1
};

static uint8 subsuper0_data[] = {
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xef, 
    0xff, 0xcf, 
    0xff, 0xef, 
    0xf5, 0xef, 
    0xff, 0xc7, 
    0xdf, 0x7f, 
    0xff, 0xff, 
    0xbf, 0xbf, 
    0xff, 0xff, 
    0xdf, 0x6f, 
    0xff, 0xd7, 
    0xf5, 0xf7, 
    0xff, 0xef, 
    0xff, 0xc7, 
};

static struct _GImage subsuper0_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) subsuper0_data,
    NULL,
    1
};

static uint8 italic0_data[] = {
    0xfe, 0x7f, 
    0xfd, 0x3f, 
    0xfd, 0xff, 
    0xfd, 0xff, 
    0xfd, 0xff, 
    0xf0, 0xff, 
    0xfb, 0xff, 
    0xfb, 0xff, 
    0xfb, 0xff, 
    0xfb, 0xff, 
    0xf7, 0xff, 
    0xf7, 0xff, 
    0xf7, 0xff, 
    0xf7, 0xff, 
    0x97, 0xff, 
    0xcf, 0xff, 
};

static struct _GImage italic_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) italic0_data,
    NULL,
    0x1
};


static uint8 oblique_data[] = {
    0xfc, 0x7f, 
    0xfd, 0x7f, 
    0xfb, 0xff, 
    0xfb, 0xff, 
    0xf1, 0xff, 
    0xfb, 0xff, 
    0xfb, 0xff, 
    0xf7, 0xff, 
    0xf7, 0xff, 
    0xf7, 0xff, 
    0xf7, 0xff, 
    0xe3, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
};

static struct _GImage oblique_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) oblique_data,
    &magnify0_clut,
    1
};

static uint8 condense_data[] = {
    0xff, 0xff, 
    0x8f, 0xff, 
    0xb7, 0xff, 
    0xbb, 0xff, 
    0xbb, 0xff, 
    0xbb, 0xff, 
    0xb7, 0xff, 
    0x8f, 0xff, 
    0xb7, 0xff, 
    0xbb, 0xff, 
    0xbb, 0xff, 
    0xbb, 0xff, 
    0xbb, 0xff, 
    0xb7, 0xff, 
    0x8f, 0xff, 
    0xff, 0xff, 
};

static struct _GImage condense_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) condense_data,
    &magnify0_clut,
    1
};

static uint8 outline_data[] = {
    0xff, 0xff, 
    0x80, 0xf, 
    0xbf, 0xef, 
    0xbf, 0xef, 
    0xbf, 0xef, 
    0x87, 0xf, 
    0xf7, 0x7f, 
    0xf7, 0x7f, 
    0xf7, 0x7f, 
    0xf7, 0x7f, 
    0x87, 0xf, 
    0xbf, 0xef, 
    0xbf, 0xef, 
    0xbf, 0xef, 
    0x80, 0xf, 
    0xff, 0xff, 
};

static struct _GImage outline_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) outline_data,
    &magnify0_clut,
    1
};

static uint8 inline_data[] = {
    0xff, 0xff, 
    0x80, 0xf, 
    0xbf, 0xef, 
    0xa0, 0x2f, 
    0xbd, 0xef, 
    0x85, 0xf, 
    0xf5, 0x7f, 
    0xf5, 0x7f, 
    0xf5, 0x7f, 
    0xf5, 0x7f, 
    0x85, 0xf, 
    0xbd, 0xef, 
    0xa0, 0x2f, 
    0xbf, 0xef, 
    0x80, 0xf, 
    0xff, 0xff, 
};

static struct _GImage inline_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) inline_data,
    &magnify0_clut,
    1
};

static uint8 shadow_data[] = {
    0xff, 0xff, 
    0xc0, 0x1f, 
    0xdf, 0xcf, 
    0xc2, 0xf, 
    0xfa, 0xf, 
    0xfa, 0x7f, 
    0xfa, 0x7f, 
    0xfa, 0x7f, 
    0xfa, 0x7f, 
    0xfa, 0x7f, 
    0xc2, 0x1f, 
    0xdf, 0xcf, 
    0xc0, 0xf, 
    0xe0, 0xf, 
    0xff, 0xff, 
    0xff, 0xff, 
};

static struct _GImage shadow_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) shadow_data,
    &magnify0_clut,
    1
};

static unsigned char wireframe_data[] = {
    0xff, 0xff, 
    0x80, 0x3f, 
    0xbf, 0x9f, 
    0x84, 0x2f, 
    0xf4, 0xd7, 
    0xf5, 0x67, 
    0xf5, 0x87, 
    0xf5, 0xbf, 
    0xf5, 0xbf, 
    0xf5, 0xbf, 
    0x84, 0x3f, 
    0xbf, 0x9f, 
    0x80, 0x2f, 
    0xdf, 0xd7, 
    0xef, 0xe7, 
    0xf0, 0x7, 
};

static struct _GImage wireframe_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) wireframe_data,
    &magnify0_clut,
    1
};

static uint8 menumark_data[] = {
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1a, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
    0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x04, 0x01, 
    0x01, 0x3, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 
    0x01, 0x3, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 
    0x01, 0x3, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 
    0x01, 0x3, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 
    0x01, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x01, 
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01
};

static GClut menumark_clut = { 6, 0, 1,
    { 0x0, 0xb0b0b0, 0xf7f7f7, 0xdddddd, 0x808080, 0x666666 } };

static struct _GImage menumark_base = {
    it_index,
    15420,16,10,16,
    (uint8 *) menumark_data,
    &menumark_clut,
    0xffffffff
};

static uint8 upicon0_data[] = {
    0xff, 
    0xef, 
    0xef, 
    0xef, 
    0xd7, 
    0xd7, 
    0xd7, 
    0xbb, 
    0xbb, 
    0xbb, 
    0xff, 
};

static struct _GImage upicon0_base = {
    it_mono,
    15420,7,11,1,
    (uint8 *) upicon0_data,
    &magnify0_clut,
    1
};

static uint8 downicon0_data[] = {
    0xff, 
    0xbb, 
    0xbb, 
    0xbb, 
    0xd7, 
    0xd7, 
    0xd7, 
    0xef, 
    0xef, 
    0xef, 
    0xff, 
};

static struct _GImage downicon0_base = {
    it_mono,
    15420,7,11,1,
    (uint8 *) downicon0_data,
    &magnify0_clut,
    1
};

static uint8 lock0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x2, 0x2, 0x2, 0x1, 0x0, 
    0x0, 0x2, 0x1, 0x0, 0x1, 0x2, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x2, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x2, 0x0, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x3, 0x3, 0x3, 0x2, 0x2, 
    0x2, 0x2, 0x4, 0x0, 0x4, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x1, 0x2, 0x2, 0x2, 
    0x4, 0x2, 0x2, 0x1, 0x2, 0x2, 0x4, 
    0x0, 0x5, 0x2, 0x2, 0x2, 0x5, 0x0, 
    0x0, 0x0, 0x2, 0x2, 0x2, 0x0, 0x0
};

static GClut lock0_clut = { 6, 1, 0,
    { 0xffffff, 0xa2a2a2, 0x0, 0x272727, 0x747474, 0x171717 } };

static struct _GImage lock0_base = {
    it_index,
    15420,7,12,7,
    (uint8 *) lock0_data,
    &lock0_clut,
    0
};


GImage GIcon_small3drotate = { 0, { &small3drotate0_base }, NULL };
GImage GIcon_smallperspective = { 0, { &smallperspective0_base }, NULL };
GImage GIcon_smallskew = { 0, { &smallskew0_base }, NULL };
GImage GIcon_smallscale = { 0, { &smallscale0_base }, NULL };
GImage GIcon_smallrotate = { 0, { &smallrotate0_base }, NULL };
GImage GIcon_smallflip = { 0, { &smallflip0_base }, NULL };
GImage GIcon_smalltangent = { 0, { &smalltangent0_base }, NULL };
GImage GIcon_smallcorner = { 0, { &smallcorner0_base }, NULL };
GImage GIcon_smallcurve = { 0, { &smallcurve0_base }, NULL };
GImage GIcon_smallhvcurve = { 0, { &smallhvcurve0_base }, NULL };
GImage GIcon_smallspirocorner = { 0, { &smallspirocorner0_base }, NULL };
GImage GIcon_smallspirog2curve = { 0, { &smallspirog2curve0_base }, NULL };
GImage GIcon_smallspirocurve = { 0, { &smallspirocurve0_base }, NULL };
GImage GIcon_smallspiroright = { 0, { &smallspiroright0_base }, NULL };
GImage GIcon_smallspiroleft = { 0, { &smallspiroleft0_base }, NULL };
GImage GIcon_smallmag = { 0, { &smallmag0_base }, NULL };
GImage GIcon_smallknife = { 0, { &smallknife0_base }, NULL };
GImage GIcon_smallhand = { 0, { &smallhand0_base }, NULL };
GImage GIcon_smallpen = { 0, { &smallpen0_base }, NULL };
GImage GIcon_smallpencil = { 0, { &smallpencil0_base }, NULL };
GImage GIcon_smallpointer = { 0, { &smallpointer0_base }, NULL };
GImage GIcon_smallruler = { 0, { &smallruler0_base }, NULL };
GImage GIcon_smallelipse = { 0, { &smallelipse0_base }, NULL };
GImage GIcon_smallrect = { 0, { &smallrect0_base }, NULL };
GImage GIcon_smallpoly = { 0, { &smallpoly0_base }, NULL };
GImage GIcon_smallstar = { 0, { &smallstar0_base }, NULL };
GImage GIcon_FontForgeLogo = { 0, { &logo_base }, NULL };
GImage GIcon_FontForgeBack = { 0, { &logoback_base }, NULL };
GImage GIcon_FontForgeGuide = { 0, { &logogrid_base }, NULL };

GImage GIcon_continue = { 0, { &continue_base }, NULL };
GImage GIcon_stepout = { 0, { &stepout_base }, NULL };
GImage GIcon_stepover = { 0, { &stepover_base }, NULL };
GImage GIcon_stepinto = { 0, { &stepinto_base }, NULL };
GImage GIcon_watchpnt = { 0, { &watchpnt_base }, NULL };
GImage GIcon_menudelta = { 0, { &menudelta_base }, NULL };
GImage GIcon_exit = { 0, { &exit_base }, NULL };

GImage GIcon_Stopped = { 0, { &stopped_base }, NULL };
GImage GIcon_Stop = { 0, { &stop_base }, NULL };

GImage GIcon_exclude = { 0, { &exclude_base }, NULL };
GImage GIcon_intersection = { 0, { &intersection_base }, NULL };
GImage GIcon_rmoverlap = { 0, { &rmoverlap_base }, NULL };
GImage GIcon_findinter = { 0, { &findinter_base }, NULL };

GImage GIcon_styles = { 0, { &styles_base }, NULL };
GImage GIcon_bold = { 0, { &bold_base }, NULL };
GImage GIcon_italic = { 0, { &italic_base }, NULL };
GImage GIcon_oblique = { 0, { &oblique_base }, NULL };
GImage GIcon_changexheight = { 0, { &changexheight_base }, NULL };
GImage GIcon_smallcaps = { 0, { &smallcaps_base }, NULL };
GImage GIcon_subsup = { 0, { &subsuper0_base }, NULL };
GImage GIcon_condense = { 0, { &condense_base }, NULL };
GImage GIcon_outline = { 0, { &outline_base }, NULL };
GImage GIcon_inline = { 0, { &inline_base }, NULL };
GImage GIcon_shadow = { 0, { &shadow_base }, NULL };
GImage GIcon_wireframe = { 0, { &wireframe_base }, NULL };

GImage GIcon_menumark = { 0, { &menumark_base }, NULL };

GImage GIcon_up = { 0, { &upicon0_base }, NULL };
GImage GIcon_down = { 0, { &downicon0_base }, NULL };

GImage GIcon_lock = { 0, { &lock0_base }, NULL };

static uint8 OFL_logo0_data[] = {
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xb, 0x10, 0x2, 0xe, 0x14, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x3, 0x5, 0x12, 0x19, 0x17, 0x5, 0x1, 0x17, 
	0x19, 0x19, 0x17, 0x1a, 0x7, 0x19, 0x19, 0x19, 
	0x19, 0x5, 0x17, 0x17, 0x3, 0x3, 0x7, 0x19, 
	0xf, 0x3, 0x3, 0x7, 0x19, 0x19, 0x19, 0x19, 
	0x1a, 0x3, 0x1, 0x17, 0x19, 0xf, 0x3, 0x7, 
	0x19, 0x18, 0x3, 0x5, 0x17, 0x17, 0x17, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x1, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x13, 0xc, 0xa, 0x1e, 0x1c, 0x11, 
	0xd, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x5, 0x19, 0x1, 0x1a, 0x1b, 0x19, 0x1a, 0x19, 
	0xf, 0x1a, 0x19, 0x16, 0x3, 0x11, 0x18, 0x3, 
	0x17, 0x3, 0xf, 0x11, 0x12, 0x3, 0x3, 0x11, 
	0x18, 0x3, 0x3, 0x3, 0x11, 0x18, 0x3, 0x12, 
	0x3, 0x1, 0x19, 0x5, 0x18, 0x1c, 0xf, 0x3, 
	0x11, 0x1c, 0x1a, 0x3, 0xf, 0x19, 0x1b, 0x3, 
	0xf, 0x19, 0x3, 0x19, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x13, 0x1c, 0x14, 0x0, 0x0, 0x14, 0x11, 
	0x1c, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x15, 0x17, 0x3, 0x3, 0x7, 0x11, 0x1a, 0x19, 
	0xf, 0x3, 0x18, 0x1c, 0x3, 0x11, 0x18, 0x3, 
	0x3, 0x3, 0xf, 0x1c, 0x11, 0x7, 0x3, 0x11, 
	0x18, 0x3, 0x3, 0x3, 0x11, 0x18, 0x3, 0x3, 
	0x3, 0x17, 0x7, 0x3, 0x3, 0x12, 0x16, 0x3, 
	0x11, 0x1c, 0x1b, 0x3, 0xf, 0x19, 0x3, 0x3, 
	0xf, 0x19, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0xe, 0x0, 0x0, 0x0, 0x0, 0x11, 
	0xc, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x19, 0xf, 0x3, 0x3, 0x3, 0x11, 0x18, 0x19, 
	0x17, 0x18, 0x17, 0x7, 0x3, 0x11, 0x1b, 0x1c, 
	0x7, 0x3, 0xf, 0x19, 0x12, 0x1c, 0x1a, 0x11, 
	0x18, 0x3, 0x3, 0x3, 0x11, 0x1b, 0x16, 0x18, 
	0x3, 0x11, 0x18, 0x3, 0x3, 0x18, 0x11, 0x3, 
	0x11, 0x7, 0x1c, 0x12, 0xf, 0x19, 0x3, 0x3, 
	0xf, 0x19, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x13, 0x11, 0x10, 0x0, 0x0, 0x0, 0x0, 0x11, 
	0x2, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x19, 0x17, 0x3, 0x3, 0x3, 0x11, 0x1a, 0x19, 
	0x19, 0xf, 0x18, 0x3, 0x3, 0x11, 0x18, 0x3, 
	0x3, 0x3, 0xf, 0x19, 0x3, 0x1b, 0x1b, 0x11, 
	0x18, 0x3, 0x3, 0x3, 0x11, 0x18, 0x3, 0x3, 
	0x3, 0x11, 0x7, 0x3, 0x3, 0x18, 0x16, 0x3, 
	0x11, 0x18, 0x7, 0x11, 0x1b, 0x19, 0x3, 0x3, 
	0xf, 0x19, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x10, 0x11, 0x14, 0x0, 0x0, 0x0, 0x0, 0x11, 
	0xa, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x15, 0x1c, 0x5, 0x3, 0x7, 0x17, 0x3, 0x19, 
	0xf, 0x3, 0x3, 0x3, 0x3, 0x11, 0x18, 0x3, 
	0x1, 0x1, 0xf, 0x19, 0x3, 0x1a, 0x1c, 0x11, 
	0x18, 0x3, 0x3, 0x3, 0x11, 0x18, 0x3, 0x3, 
	0x3, 0x17, 0x19, 0x3, 0x3, 0x12, 0x15, 0x3, 
	0x11, 0x18, 0x3, 0x12, 0x11, 0x19, 0x3, 0x3, 
	0xf, 0x19, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0xe, 0x11, 0x0, 0x0, 0x0, 0x0, 0x14, 0x11, 
	0x4, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x5, 0x1b, 0x16, 0xf, 0x17, 0x5, 0x5, 0x1b, 
	0x17, 0x1a, 0x3, 0x3, 0x1a, 0x11, 0x17, 0xf, 
	0x19, 0x7, 0x17, 0x16, 0x1a, 0x3, 0x7, 0x11, 
	0x18, 0x3, 0x3, 0x1a, 0x11, 0xf, 0x5, 0x3, 
	0x3, 0x1, 0x1c, 0x19, 0x12, 0x12, 0x3, 0x1a, 
	0x11, 0xf, 0x3, 0x5, 0x1b, 0x19, 0x3, 0x5, 
	0x17, 0x16, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0xd, 0xe, 0x2, 0xa, 0xb, 0x0, 0xb, 0x4, 
	0x6, 0x11, 0x4, 0x4, 0x4, 0x1d, 0xd, 0x11, 
	0x14, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x18, 0x1, 0x3, 0x3, 0x1a, 0x18, 
	0x18, 0x5, 0x3, 0x3, 0x1, 0x18, 0x18, 0x18, 
	0x18, 0x5, 0x18, 0x18, 0x5, 0x3, 0x3, 0x1, 
	0x3, 0x3, 0x3, 0x1, 0x18, 0x18, 0x3, 0x3, 
	0x3, 0x3, 0x5, 0x18, 0x1a, 0x3, 0x3, 0x1, 
	0x18, 0x1, 0x3, 0x3, 0x5, 0x1a, 0x3, 0x1a, 
	0x18, 0x18, 0x1a, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0x2, 
	0x1e, 0x4, 0x2, 0x11, 0x6, 0xb, 0xd, 0x4, 
	0x11, 0x6, 0x4, 0x1e, 0xc, 0xb, 0x4, 0x11, 
	0x1f, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0xb, 0xc, 0xd, 
	0x0, 0x0, 0x0, 0xe, 0x11, 0x10, 0x0, 0x0, 
	0x11, 0x2, 0x0, 0x0, 0x0, 0x0, 0xe, 0x11, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x1e, 0xc, 0x0, 
	0x0, 0x0, 0x0, 0x13, 0x11, 0xe, 0x0, 0x13, 
	0x11, 0x4, 0x0, 0x0, 0x0, 0x0, 0xc, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0xb, 0x11, 0x4, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x11, 0x2, 0x0, 0x14, 
	0x11, 0x4, 0x0, 0x0, 0x0, 0x0, 0x11, 0x1e, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x12, 0x19, 0x7, 0x3, 0x3, 0x1, 0x19, 0x17, 
	0x5, 0x3, 0x18, 0x17, 0x19, 0x17, 0x18, 0x19, 
	0x19, 0x19, 0x19, 0x18, 0x17, 0x17, 0x3, 0x3, 
	0x7, 0x19, 0xf, 0x3, 0x7, 0x19, 0x19, 0x7, 
	0x7, 0x19, 0x19, 0x19, 0x19, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x1d, 0x11, 0x14, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x11, 0xe, 0x0, 0xd, 
	0x11, 0x1d, 0x0, 0x0, 0x0, 0x13, 0x11, 0x4, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x18, 0x11, 0x3, 0x3, 0x3, 0x3, 0x19, 0xf, 
	0x3, 0x7, 0x17, 0x5, 0x18, 0x15, 0x3, 0x19, 
	0xf, 0x3, 0xf, 0x1a, 0xf, 0x11, 0x12, 0x3, 
	0x3, 0x11, 0x18, 0x7, 0x1b, 0x3, 0x12, 0x1, 
	0x3, 0x11, 0x18, 0x3, 0x17, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x4, 0x11, 0x14, 0x0, 
	0x0, 0x0, 0x0, 0x1f, 0x11, 0x10, 0x0, 0x4, 
	0x11, 0x14, 0x0, 0x0, 0x0, 0x14, 0x11, 0x1d, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x18, 0x11, 0x3, 0x3, 0x3, 0x3, 0x19, 0xf, 
	0x3, 0x1c, 0x1a, 0x3, 0x3, 0x3, 0x3, 0x19, 
	0xf, 0x3, 0x3, 0x3, 0xf, 0x1c, 0x11, 0x7, 
	0x3, 0x11, 0x18, 0x15, 0x11, 0xf, 0x5, 0x3, 
	0x3, 0x11, 0x18, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x4, 0x11, 0xd, 0x0, 
	0x0, 0x0, 0x0, 0xd, 0x11, 0x1f, 0x0, 0x1e, 
	0x11, 0x1f, 0x0, 0x0, 0x0, 0x4, 0x11, 0x14, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x18, 0x11, 0x3, 0x3, 0x3, 0x3, 0x19, 0xf, 
	0x18, 0x11, 0x3, 0x3, 0x3, 0x3, 0x3, 0x19, 
	0x16, 0x16, 0x12, 0x3, 0xf, 0x19, 0x12, 0x1c, 
	0x1a, 0x11, 0x18, 0x5, 0x17, 0x11, 0x1c, 0x7, 
	0x3, 0x11, 0x1b, 0x1c, 0x7, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x1d, 0x11, 0x1e, 0x0, 
	0x0, 0x0, 0x0, 0x2, 0xa, 0x0, 0x0, 0x2, 
	0x11, 0x0, 0x0, 0x0, 0x0, 0xa, 0x11, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x18, 0x11, 0x3, 0x3, 0x3, 0x3, 0x19, 0xf, 
	0x18, 0x11, 0x5, 0x3, 0x3, 0x3, 0x3, 0x19, 
	0xf, 0x3, 0x3, 0x3, 0xf, 0x19, 0x3, 0x1b, 
	0x1b, 0x11, 0x18, 0x3, 0x3, 0x1a, 0x1b, 0x1c, 
	0x3, 0x11, 0x18, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0xb, 0x1c, 0x11, 0xd, 
	0x0, 0x0, 0x10, 0xc, 0xb, 0x0, 0x0, 0xc, 
	0x6, 0x0, 0x0, 0x0, 0x0, 0x2, 0x11, 0x0, 
	0x13, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x18, 0x11, 0x3, 0x3, 0x7, 0x5, 0x19, 0xf, 
	0x5, 0x1c, 0xf, 0x3, 0x3, 0x7, 0x5, 0x19, 
	0xf, 0x3, 0x5, 0x7, 0xf, 0x19, 0x3, 0x1a, 
	0x1c, 0x11, 0x18, 0x7, 0x7, 0x3, 0x18, 0x16, 
	0x3, 0x11, 0x18, 0x3, 0x1, 0x1, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0xd, 0x11, 0x11, 
	0xc, 0xc, 0xa, 0xb, 0x0, 0x0, 0x0, 0x11, 
	0xe, 0x0, 0x0, 0x0, 0x0, 0xe, 0x11, 0x1c, 
	0x10, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x7, 0x11, 0x12, 0xf, 0x16, 0x5, 0x1b, 0x17, 
	0x5, 0x7, 0x11, 0x17, 0x17, 0x12, 0x5, 0x1b, 
	0x1b, 0xf, 0x17, 0x17, 0x17, 0x16, 0x1a, 0x3, 
	0x7, 0x11, 0x18, 0xf, 0x1c, 0x12, 0x19, 0x1, 
	0x1a, 0x11, 0x17, 0xf, 0x19, 0x7, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x10, 
	0x4, 0x1f, 0x0, 0x0, 0x0, 0x0, 0x13, 0x11, 
	0xd, 0x0, 0x0, 0x0, 0x0, 0x13, 0xd, 0xb, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x18, 0x18, 0x18, 0x18, 0x1, 0x1a, 0x18, 0x18, 
	0x3, 0x3, 0x5, 0x18, 0x1a, 0x3, 0x1a, 0x18, 
	0x18, 0x18, 0x18, 0x1a, 0x18, 0x18, 0x5, 0x3, 
	0x3, 0x1, 0x3, 0x3, 0x1, 0x18, 0x5, 0x3, 
	0x1, 0x18, 0x18, 0x18, 0x18, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0x1c, 
	0xb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x4, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1d, 0x6, 0xb, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x13, 0x6, 0x13, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0xd, 0x13, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3
};

static GClut OFL_logo0_clut = { 32, 1, -1,
  { 0x336699, 0x838383, 0xcdd9e6, 0x666666, 0x99b3cc, 0x707070, 0xe6ecf3, 0x999999, 
    0x4d667f, 0x738da6, 0xa6bcd3, 0x40709f, 0xd9e3ec, 0x80a0bf, 0xc0d0df, 0xb3b3b3, 
    0x8da9c6, 0xffffff, 0xbcbcbc, 0x5983ac, 0x668cb3, 0xa9a9a9, 0xececec, 0xcccccc, 
    0x8c8c8c, 0xd9d9d9, 0x797979, 0xe3e3e3, 0xf6f6f6, 0x7396b9, 0xb3c6d9, 0x4d79a6 } };

static struct _GImage OFL_logo0_base = {
    it_index,
    15420,88,31,88,
    (uint8 *) OFL_logo0_data,
    &OFL_logo0_clut,
    0xffffffff
};

GImage OFL_logo = { 0, { &OFL_logo0_base }, NULL };

static GClut clut = { 2, 0, 1,
    { 0x0, 0xb0b0b0 } };

static uint8 rightpointer0_data[] = {
    0xfb, 
    0xf3, 
    0xe3, 
    0xc3, 
    0x83, 
    0x3, 
    0xc3, 
    0xcb, 
    0x9b, 
    0x9f, 
};

static struct _GImage rightpointer0_base = {
    it_mono,
    2081,8,10,1,
    (uint8 *) rightpointer0_data,
    &clut,
    1
};

static uint8 sel2ptr0_data[] = {
    0xff, 0xe5, 
    0xff, 0x39, 
    0xf9, 0xf1, 
    0x8f, 0xe1, 
    0x77, 0xc1, 
    0x77, 0x81, 
    0x77, 0xe1, 
    0x8f, 0xe5, 
    0xff, 0xcd, 
    0xff, 0xcf, 
};

static struct _GImage sel2ptr0_base = {
    it_mono,
    2081,16,10,2,
    (uint8 *) sel2ptr0_data,
    &clut,
    1
};

static uint8 selectedpoint0_data[] = {
    0xdf, 
    0xef, 
    0xef, 
    0xc7, 
    0xbb, 
    0xbb, 
    0xbb, 
    0xc7, 
    0xef, 
    0xef, 
};

static struct _GImage selectedpoint0_base = {
    it_mono,
    2081,8,10,1,
    (uint8 *) selectedpoint0_data,
    &clut,
    1
};

static uint8 distance0_data[] = {
    0xff, 0xff, 
    0xbf, 0xfe, 
    0xbb, 0xee, 
    0xb7, 0xf6, 
    0xaa, 0xaa, 
    0xb7, 0xf6, 
    0xbb, 0xee, 
    0xbf, 0xfe, 
    0xbf, 0xfe, 
    0xff, 0xff, 
};

static struct _GImage distance0_base = {
    it_mono,
    2081,16,10,2,
    (uint8 *) distance0_data,
    &clut,
    1
};

static uint8 angle0_data[] = {
    0xff, 0xff, 
    0xff, 0xcf, 
    0xff, 0x9f, 
    0xfe, 0x6f, 
    0xfd, 0xef, 
    0xf3, 0xf7, 
    0xef, 0xf7, 
    0x9f, 0xf7, 
    0x0, 0x1, 
    0xff, 0xff, 
};

static struct _GImage angle0_base = {
    it_mono,
    2081,16,10,2,
    (uint8 *) angle0_data,
    &clut,
    1
};

static uint8 magicon0_data[] = {
    0xc7, 
    0xbb, 
    0x6d, 
    0x45, 
    0x6d, 
    0xbb, 
    0xc3, 
    0xfb, 
    0xfd, 
    0xfd, 
};

static struct _GImage magicon0_base = {
    it_mono,
    2069,8,10,1,
    (uint8 *) magicon0_data,
    &clut,
    1
};

GImage GIcon_mag = { 0, { &magicon0_base }, NULL };
GImage GIcon_angle = { 0, { &angle0_base }, NULL };
GImage GIcon_distance = { 0, { &distance0_base }, NULL };
GImage GIcon_selectedpoint = { 0, { &selectedpoint0_base }, NULL };
GImage GIcon_sel2ptr = { 0, { &sel2ptr0_base }, NULL };
GImage GIcon_rightpointer = { 0, { &rightpointer0_base }, NULL };

static uint8 BottomSerifs0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x5, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x7, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x9, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0xa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xb, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xd, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0xe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x33, 0x26, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xf, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 
	0x34, 0x35, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x11, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x12, 0x0, 0x0, 0x0, 0x0, 0x13, 0x14, 
	0x2, 0x36, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x15, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x16, 0x0, 0x0, 0x17, 0x18, 0x2, 0x2, 
	0xb, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x19, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x15, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1a, 0x1b, 0x2, 0x2, 0x1c, 0x1d, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1e, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x1f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1a, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x20, 0x21, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x22, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x23, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x24, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x25, 0x19, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x26, 0xa, 0xa, 0xa, 0xb, 0x27, 0x28, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x29, 0x2a, 0x2b, 0xa, 0xa, 0xa, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x2c, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2d, 0x2e, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x10, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2f, 0x2, 0x2, 0x2, 
	0x2, 0x3, 0x1e, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x10, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x30, 0x6, 0x2f, 0x31, 
	0x32, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0
};

static GClut BottomSerifs0_clut = { 55, 1, 0,
  { 0xffffff, 0xd0d0d, 0x0, 0x313131, 0x464646, 0xd5d5d5, 0x5c5c5c, 0xbababa, 
    0x707070, 0x9f9f9f, 0x878787, 0x848484, 0x9b9b9b, 0x6d6d6d, 0xafafaf, 0x5f5f5f, 
    0xb6b6b6, 0x535353, 0xa3a3a3, 0x787878, 0x10101, 0x4d4d4d, 0x5d5d5d, 0xbdbdbd, 
    0x2b2b2b, 0xe8e8e8, 0x575757, 0x393939, 0xa0a0a, 0xaaaaaa, 0xc7c7c7, 0xdddddd, 
    0x1e1e1e, 0xcdcdcd, 0x6e6e6e, 0xa2a2a2, 0x717171, 0x434343, 0xdbdbdb, 0x7a7a7a, 
    0x484848, 0x131313, 0x747474, 0x858585, 0xadadad, 0x40404, 0x808080, 0x2e2e2e, 
    0xe4e4e4, 0x4f4f4f, 0xa9a9a9, 0xe5e5e5, 0x171717, 0x343434, 0x606060 } };

static struct _GImage BottomSerifs0_base = {
    it_index,
    15420,68,24,68,
    (uint8 *) BottomSerifs0_data,
    &BottomSerifs0_clut,
    0
};

static uint8 TopSerifs_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x2, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x4, 0x5, 0x6, 0x7, 0x8, 
	0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x9, 0xa, 0xb, 0xc, 
	0xc, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0xd, 0xe, 0xc, 0xc, 0xc, 0xc, 
	0xf, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x10, 0x11, 0x12, 0x13, 0xc, 0xc, 0xc, 0xc, 
	0xc, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x14, 0x15, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 
	0x16, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x17, 0x18, 0x19, 0x1a, 0x1b, 
	0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 
	0xc, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1c, 
	0xe, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 
	0x1d, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1e, 0xc, 0xc, 0xc, 0xc, 
	0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 
	0xc, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 
	0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x20, 0xc, 
	0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 
	0x21, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x22, 0x13, 0x13, 0x13, 0x23, 
	0xe, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 
	0xc, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x24, 0x25, 0xc, 0xc, 
	0x26, 0x27, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 
	0x28, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x29, 0x2a, 0xc, 0xc, 0xc, 0xc, 0xc, 
	0xc, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x29, 0x2b, 0xc, 0x2c, 0x2d, 
	0x0, 0x0, 0x2e, 0xc, 0xc, 0xc, 0xc, 0xc, 
	0x11, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x2f, 0xc, 0xc, 0xc, 0xc, 0xc, 
	0xc, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x11, 0xe, 0xc, 0x30, 0x31, 0x0, 
	0x0, 0x0, 0x32, 0xc, 0xc, 0xc, 0xc, 0xc, 
	0xf, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x33, 0xc, 0xc, 0xc, 0xc, 0xc, 
	0xc, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 
	0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x34, 0x1b, 0x11, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x35, 0xc, 0xc, 0xc, 0xc, 0xc, 
	0x36, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x37, 0xc, 0xc, 0xc, 0xc, 0xc, 
	0xc, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x9, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x38, 0xc, 0xc, 0xc, 0xc, 0xc, 
	0x4, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xc, 0xc, 0xc, 0xc, 0xc, 
	0xc, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x39, 0xc, 0xc, 0xc, 0xc, 0xc, 
	0x31, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xc, 0xc, 0xc, 0xc, 0xc, 
	0xc, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3a, 0xc, 0xc, 0xc, 0xc, 0xe, 
	0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xc, 0xc, 0xc, 0xc, 0xc, 
	0xc, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x2, 0xc, 0xc, 0xc, 0xc, 0x3b, 
	0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0
};

static GClut TopSerifs_clut = { 60, 1, 0,
  { 0xffffff, 0xdbdbdb, 0x767676, 0x4d4d4d, 0xe3e3e3, 0x686868, 0x151515, 0x90909, 
    0x707070, 0xd8d8d8, 0x848484, 0x2c2c2c, 0x0, 0x797979, 0x40404, 0xb6b6b6, 
    0xd9d9d9, 0x9e9e9e, 0x5f5f5f, 0x181818, 0xd4d4d4, 0x262626, 0x7b7b7b, 0xfbfbfb, 
    0x818181, 0x5e5e5e, 0x343434, 0x70707, 0x969696, 0x737373, 0xe9e9e9, 0xfefefe, 
    0x575757, 0x7a7a7a, 0xebebeb, 0x141414, 0xe6e6e6, 0x2d2d2d, 0x464646, 0x292929, 
    0x888888, 0xc4c4c4, 0x191919, 0x121212, 0x202020, 0xc7c7c7, 0x3b3b3b, 0xa0a0a0, 
    0x5c5c5c, 0xf9f9f9, 0xa6a6a6, 0xdfdfdf, 0x979797, 0xb9b9b9, 0xcbcbcb, 0xf8f8f8, 
    0xb8b8b8, 0xababab, 0x919191, 0x1b1b1b } };

static struct _GImage TopSerifs_base = {
    it_index,
    15420,61,24,61,
    (uint8 *) TopSerifs_data,
    &TopSerifs_clut,
    0
};

static uint8 DiagSerifs_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 
	0x2, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x4, 0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0x2, 0x2, 
	0x6, 0x7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x8, 0x2, 0x9, 0xa, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0xb, 0xc, 0x2, 0x2, 
	0xd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0xe, 0x2, 0xf, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x10, 0x2, 0x2, 0x11, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x12, 0x2, 0x13, 0x14, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x15, 0x2, 0x2, 0x16, 0x17, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x18, 0x2, 0x19, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1a, 0x16, 0x2, 0x2, 0x1b, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1c, 
	0x2, 0x1d, 0x14, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1e, 0x1f, 0x2, 0x2, 0x20, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0x21, 
	0x22, 0x23, 0x0, 0x0, 0x0, 0x0, 0x24, 0x25, 
	0x2, 0x26, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x27, 0x2, 0x2, 0x2, 0x28, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x29, 0x2, 
	0x2, 0x2, 0x2a, 0x2b, 0x7, 0x2c, 0x2d, 0x2, 
	0x2e, 0xa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2f, 0x2, 0x2, 0x2, 0x30, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x31, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x32, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x33, 
	0xe, 0x2, 0x2, 0x2, 0x34, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x18, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0x2a, 
	0x2, 0x2, 0x2, 0x9, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1b, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x35, 0x36, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x37, 0x2f, 0x38, 0x13, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x38, 0x39, 0x3a, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3b, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x5, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x3c, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x33, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x12, 0x1, 0x3d, 0xc, 0x18, 0x3e, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0
};

static GClut DiagSerifs_clut = { 63, 1, 0,
  { 0xffffff, 0x343434, 0x0, 0x4f4f4f, 0xd6d6d6, 0x838383, 0xc0c0c, 0xe3e3e3, 
    0x6a6a6a, 0xa0a0a, 0xefefef, 0xd0d0d0, 0x40404, 0x909090, 0xd0d0d, 0x707070, 
    0x2c2c2c, 0x333333, 0x939393, 0x60606, 0xe5e5e5, 0x777777, 0x30303, 0xcdcdcd, 
    0x272727, 0x696969, 0xc6c6c6, 0x727272, 0xacacac, 0x70707, 0xf6f6f6, 0x242424, 
    0x1f1f1f, 0x7f7f7f, 0x7a7a7a, 0xb6b6b6, 0xf2f2f2, 0x202020, 0x767676, 0x6c6c6c, 
    0xb2b2b2, 0x222222, 0x1a1a1a, 0x8a8a8a, 0xe9e9e9, 0x434343, 0x111111, 0xb0b0b0, 
    0x444444, 0xe0e0e0, 0x8f8f8f, 0xd5d5d5, 0xc5c5c5, 0x10101, 0xc2c2c2, 0xe2e2e2, 
    0x666666, 0xbdbdbd, 0xd3d3d3, 0x3f3f3f, 0x606060, 0x90909, 0x9c9c9c } };

static struct _GImage DiagSerifs_base = {
    it_index,
    15420,68,24,68,
    (uint8 *) DiagSerifs_data,
    &DiagSerifs_clut,
    0
};

static uint8 FlatSerif_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x7, 0x8, 0x8, 0x8, 0x9, 0xa, 0xb, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0xc, 0xd, 0xe, 0x8, 0x8, 0x8, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0xf, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0xf, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0
};

static GClut FlatSerif_clut = { 16, 1, 0,
  { 0xffffff, 0x0, 0xe8e8e8, 0xc7c7c7, 0xdddddd, 0x6e6e6e, 0xa2a2a2, 0xdbdbdb, 
    0x878787, 0x848484, 0x7a7a7a, 0x484848, 0x131313, 0x747474, 0x858585, 0xb6b6b6 } };

static struct _GImage FlatSerif_base = {
    it_index,
    15420,49,24,49,
    (uint8 *) FlatSerif_data,
    &FlatSerif_clut,
    0
};

static uint8 SlantSerif_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x7, 0x8, 0x8, 0x8, 0x9, 0xa, 0xb, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0xc, 0xd, 0xe, 0x8, 0x8, 0x8, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0xf, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x10, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x10, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0
};

static GClut SlantSerif_clut = { 17, 1, 0,
  { 0xffffff, 0x000000, 0xe8e8e8, 0xc7c7c7, 0xdddddd, 0x6e6e6e, 0xa2a2a2, 0xdbdbdb, 
    0x878787, 0x848484, 0x7a7a7a, 0x484848, 0x131313, 0x747474, 0x858585, 0x808080, 
    0xb6b6b6 } };

static struct _GImage SlantSerif_base = {
    it_index,
    15420,49,24,49,
    (uint8 *) SlantSerif_data,
    &SlantSerif_clut,
    0
};

static uint8 PenSerif_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x7, 0x8, 0x8, 0x8, 0x9, 0xa, 0xb, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0xc, 0xd, 0xe, 0x8, 0x8, 0x8, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x10, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x10, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0
};

static struct _GImage PenSerif_base = {
    it_index,
    15420,49,24,49,
    (uint8 *) PenSerif_data,
    &SlantSerif_clut,
    0
};

static uint8 aItalic_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x3, 0x4, 
	0x5, 0x6, 0x7, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x8, 0x9, 0xa, 0xb, 0xb, 0xb, 
	0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xc, 0xd, 0xe, 0x0, 0x0, 
	0xf, 0x10, 0xb, 0x11, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0xb, 
	0x18, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x19, 0x1a, 0x0, 0x0, 0x0, 
	0x0, 0x15, 0xb, 0x1b, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0xb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1c, 0x1d, 0x7, 0x0, 0x0, 0x0, 0x1e, 0xb, 
	0x1f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x20, 0xb, 0x21, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0xb, 0xb, 0xb, 0xb, 0xb, 0xb, 
	0xb, 0xb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x22, 0xb, 0x23, 0x0, 0x0, 0x24, 0x5, 0xb, 
	0x11, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x25, 0x26, 0x27, 
	0x28, 0x29, 0xb, 0xb, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0xb, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2a, 0x17, 0x2b, 0x0, 0x0, 0x20, 0xb, 0xb, 
	0x2c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x2d, 0x2e, 0xa, 0x2f, 0x30, 
	0x0, 0x2d, 0xb, 0xb, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xb, 0x0, 0x0, 0x0, 0x0, 
	0x31, 0x32, 0x0, 0x0, 0x0, 0x2c, 0xb, 0xb, 
	0x33, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x27, 0xb, 0x34, 0x0, 0x0, 
	0x0, 0x2d, 0xb, 0xb, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0xb, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x35, 0x36, 0x0, 0x0, 0x0, 0x37, 0xb, 0xb, 
	0x38, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x39, 0x5, 0xb, 0x3a, 0x0, 0x0, 
	0x0, 0xc, 0xb, 0xb, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0xb, 0xb, 0xb, 0xb, 0xb, 0xb, 
	0xb, 0xb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x3b, 0x27, 0x0, 0x0, 0x3c, 0x3d, 0xb, 0xb, 
	0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3a, 0xb, 0xb, 0xe, 0x0, 0x0, 
	0x3e, 0x3f, 0xb, 0xb, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0xb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2b, 
	0xb, 0x40, 0x0, 0x0, 0x9, 0x3e, 0xb, 0xb, 
	0x39, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x28, 0xb, 0x35, 0x1f, 0x41, 
	0x42, 0xf, 0xb, 0xb, 0x39, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0xa, 0x43, 0x0, 0x1f, 0x22, 0x0, 0xb, 0x44, 
	0x2b, 0x45, 0x46, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x47, 0x48, 0x49, 0xa, 0x4a, 
	0x2b, 0x2d, 0xb, 0xb, 0x4b, 0x4c, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1b, 0xb, 0x4d, 0x4e, 0x0, 0x0, 0x3b, 0xb, 
	0x4f, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x51, 0x52, 0x4a, 0x0, 0x0, 0x0, 0x53, 0x36, 
	0x25, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0
};

static GClut aItalic_clut = { 84, 1, 0,
  { 0xffffff, 0xe2e2e2, 0x808080, 0x4e4e4e, 0x1e1e1e, 0x404040, 0x242424, 0x8b8b8b, 
    0xe1e1e1, 0x5e5e5e, 0xd0d0d0, 0x000000, 0xe8e8e8, 0x707070, 0xc9c9c9, 0xd5d5d5, 
    0x2a2a2a, 0x989898, 0xc2c2c2, 0x202020, 0x9b9b9b, 0xb9b9b9, 0x848484, 0xc0c0c0, 
    0x717171, 0xebebeb, 0x6e6e6e, 0x373737, 0xf6f6f6, 0x1a1a1a, 0x191919, 0x858585, 
    0xdfdfdf, 0xe0e0e0, 0xaeaeae, 0xd6d6d6, 0xfcfcfc, 0xd8d8d8, 0x888888, 0x515151, 
    0x414141, 0x484848, 0x6b6b6b, 0xfefefe, 0xacacac, 0xefefef, 0x535353, 0x8f8f8f, 
    0xe6e6e6, 0x3a3a3a, 0x303030, 0xbfbfbf, 0xa7a7a7, 0x171717, 0x474747, 0x5b5b5b, 
    0xd2d2d2, 0xf9f9f9, 0xf8f8f8, 0x303030, 0xd9d9d9, 0x6d6d6d, 0xececec, 0x505050, 
    0x4b4b4b, 0x757575, 0x585858, 0x272727, 0x606060, 0xb1b1b1, 0xcccccc, 0xe5e5e5, 
    0x4d4d4d, 0xa0a0a0, 0x8d8d8d, 0x343434, 0x878787, 0x2b2b2b, 0x7d7d7d, 0x393939, 
    0xa2a2a2, 0xa8a8a8, 0x111111, 0x2e2e2e } };

static struct _GImage aItalic_base = {
    it_index,
    15420,68,24,68,
    (uint8 *) aItalic_data,
    &aItalic_clut,
    0
};

static uint8 fImage_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x5, 
	0x6, 0x7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x8, 0x9, 0xa, 0xa, 0xb, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xd, 0xe, 
	0xf, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x17, 0x18, 0x11, 0x0, 
	0x19, 0x1a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1b, 0xa, 0x1c, 0x0, 0x0, 0x1d, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x1e, 0xa, 0x1f, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x20, 0xa, 0x21, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x22, 0xa, 0x23, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x24, 0x25, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x21, 0xa, 0xa, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x26, 0x27, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x28, 0xa, 0xa, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x29, 0x2a, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2b, 0x11, 0xa, 0xa, 0x2c, 0x2d, 
	0x2e, 0x2f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0xa, 0xa, 0xa, 0xa, 0xa, 0xa, 0xa, 0xa, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x30, 
	0x31, 0xa, 0xa, 0x25, 0x25, 0x32, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x33, 0x34, 0xa, 0xa, 0x35, 0x35, 
	0x35, 0x19, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0xa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x36, 0x22, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x28, 0xa, 0xa, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0xa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x36, 0x37, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x28, 0xa, 0xa, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0xa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x38, 0x39, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x28, 0xa, 0xa, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0xa, 0xa, 0xa, 0xa, 0xa, 0xa, 0xa, 0xa, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x29, 0x3a, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x28, 0xa, 0xa, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x29, 0x3b, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x28, 0xa, 0xa, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x36, 0x3c, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x28, 0xa, 0xa, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2a, 0x3d, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x28, 0xa, 0xa, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0xf, 0x1e, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x3e, 0xa, 0xa, 0x17, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x3f, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x41, 0x42, 0x43, 0xa, 0xa, 0x37, 0x42, 
	0x2b, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x16, 0xa, 0x44, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x41, 0xa, 0x45, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x46, 0xa, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x47, 0x48, 0x23, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x49, 0x4a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x4b, 0x2b, 0x19, 
	0x37, 0x47, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x4c, 0x4d, 0x4e, 
	0x4f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x50, 0x51, 0x52, 
	0x53, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0
};

static GClut fImage_clut = { 84, 1, 0,
  { 0xffffff, 0xebebeb, 0xbcbcbc, 0xd8d8d8, 0xdbdbdb, 0x434343, 0x606060, 0x6b6b6b, 
    0xb2b2b2, 0xe0e0e0, 0x000000, 0xd2d2d2, 0xe6e6e6, 0x1e1e1e, 0x212121, 0xc0c0c0, 
    0x4b4b4b, 0x989898, 0x343434, 0xb4b4b4, 0x949494, 0x1a1a1a, 0xfbfbfb, 0xf5f5f5, 
    0x313131, 0xf3f3f3, 0xb5b5b5, 0xb1b1b1, 0xc5c5c5, 0xececec, 0x787878, 0xe9e9e9, 
    0x484848, 0xf8f8f8, 0x202020, 0xfcfcfc, 0x272727, 0x707070, 0x1d1d1d, 0xd0d0d0, 
    0xefefef, 0x171717, 0x111111, 0xf9f9f9, 0x686868, 0x616161, 0x5a5a5a, 0xe3e3e3, 
    0x858585, 0x373737, 0x757575, 0x828282, 0x535353, 0x606060, 0x141414, 0x2e2e2e, 
    0x161616, 0x3b3b3b, 0x464646, 0x515151, 0x5d5d5d, 0x6a6a6a, 0xe2e2e2, 0x404040, 
    0x888888, 0xeeeeee, 0x444444, 0x2a2a2a, 0x9e9e9e, 0xb7b7b7, 0xdcdcdc, 0xc2c2c2, 
    0xa0a0a0, 0x959595, 0x505050, 0xa8a8a8, 0x303030, 0x131313, 0x101010, 0x717171, 
    0x242424, 0x191919, 0x8d8d8d, 0xfefefe } };

static struct _GImage fImage_base = {
    it_index,
    15420,68,26,68,
    (uint8 *) fImage_data,
    &fImage_clut,
    0
};

static uint8 f2Italic_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x3, 
	0x4, 0x5, 0x6, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x7, 0x8, 0x9, 0xa, 0xb, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0xc, 0xd, 0xe, 0xf, 
	0x10, 0x11, 0x12, 0x13, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x14, 
	0x15, 0x16, 0x17, 0x18, 0x11, 0x19, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x1a, 0x11, 0x1b, 0x0, 
	0x0, 0x11, 0x11, 0x1c, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1d, 
	0x11, 0x1e, 0x0, 0x1f, 0x20, 0x12, 0x21, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x22, 0x11, 0x23, 0x0, 
	0x0, 0x24, 0x25, 0x26, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x27, 
	0x11, 0x28, 0x0, 0x0, 0x29, 0x29, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x2a, 0x11, 0x11, 0x21, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x15, 
	0x11, 0x2b, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x28, 0x11, 0x11, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x26, 0x11, 
	0x11, 0x2b, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x2c, 0x11, 0x11, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x11, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x11, 0x11, 0x11, 
	0x11, 0x11, 0x11, 0x11, 0x2d, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 
	0x2f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x11, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1c, 0x1c, 0x30, 
	0x11, 0x1e, 0x1c, 0x1c, 0x13, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x31, 0x32, 0x33, 0x11, 0x11, 0x32, 0x32, 
	0x34, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x35, 
	0x11, 0x36, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x2c, 0x11, 0x11, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x11, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 
	0x11, 0x37, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x2c, 0x11, 0x11, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x11, 0x0, 0x0, 0x0, 0x0, 0x0, 0x38, 
	0x11, 0x39, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x2c, 0x11, 0x11, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x11, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 
	0x11, 0x3a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x2c, 0x11, 0x11, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3b, 
	0x11, 0x33, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x2c, 0x11, 0x11, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x11, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3b, 
	0x11, 0x2d, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x2c, 0x11, 0x11, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x11, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 
	0x11, 0x3c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x2c, 0x11, 0x11, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 
	0x11, 0x33, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x3d, 0x11, 0x11, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x35, 
	0x11, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x3f, 0x11, 0x11, 0x40, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x41, 0x11, 
	0x11, 0x42, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x43, 0x12, 0x11, 0x11, 0x11, 0x11, 0x35, 
	0x1f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x32, 0x11, 
	0x11, 0x3d, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3e, 0x11, 
	0x11, 0x43, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x44, 0x11, 
	0x11, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x45, 0x46, 
	0x47, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0
};

static GClut f2Italic_clut = { 72, 1, 0,
  { 0xffffff, 0xeeeeee, 0x6b6b6b, 0x191919, 0x303030, 0x272727, 0xb8b8b8, 0xb9b9b9, 
    0x313131, 0x1c1c1c, 0x1e1e1e, 0x686868, 0xf2f2f2, 0x2a2a2a, 0xa0a0a0, 0xa8a8a8, 
    0xe9e9e9, 0x000000, 0xe0e0e0, 0xf6f6f6, 0xd4d4d4, 0x606060, 0x545454, 0xfefefe, 
    0x808080, 0x3a3a3a, 0x787878, 0x8f8f8f, 0xdcdcdc, 0x656565, 0xb4b4b4, 0xb2b2b2, 
    0x707070, 0xf9f9f9, 0x1a1a1a, 0xe1e1e1, 0x3e3e3e, 0x3b3b3b, 0xfcfcfc, 0x232323, 
    0xd9d9d9, 0xf3f3f3, 0xececec, 0xe5e5e5, 0xd8d8d8, 0xbcbcbc, 0xa4a4a4, 0x444444, 
    0x909090, 0xf5f5f5, 0xe3e3e3, 0xbfbfbf, 0xebebeb, 0x111111, 0xcfcfcf, 0xcbcbcb, 
    0x212121, 0xc6c6c6, 0xc2c2c2, 0x2b2b2b, 0xbbbbbb, 0xd6d6d6, 0xc5c5c5, 0xb1b1b1, 
    0xdbdbdb, 0xfbfbfb, 0xcccccc, 0xe2e2e2, 0xa2a2a2, 0x818181, 0x2e2e2e, 0x5b5b5b } };

static struct _GImage f2Italic_base = {
    it_index,
    15420,68,26,68,
    (uint8 *) f2Italic_data,
    &f2Italic_clut,
    0
};

static uint8 gItalic_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x2, 0x3, 0x4, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x5, 0x6, 0x7, 0x7, 0x8, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x9, 0xa, 0xb, 0xc, 0xd, 
	0xd, 0xe, 0xf, 0x10, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 
	0x17, 0x18, 0x7, 0x19, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1a, 0xd, 0x1b, 0x1c, 0x0, 0x0, 
	0x1d, 0x1e, 0x1b, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1f, 0x7, 0x20, 0x21, 0x22, 0x1c, 0x23, 
	0x24, 0x7, 0x7, 0x19, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x25, 0x7, 0x26, 0x0, 0x0, 0x0, 
	0x0, 0x27, 0x7, 0x2, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x28, 0x7, 0x7, 0x29, 0x0, 0x0, 0x0, 0x0, 
	0x2a, 0x7, 0x7, 0x19, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2b, 0x7, 0x2c, 0x0, 0x0, 0x0, 
	0x0, 0x17, 0x7, 0x7, 0x2d, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2e, 0x7, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1a, 0x7, 0x7, 0x19, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2f, 0x7, 0x22, 0x0, 0x0, 0x0, 
	0x0, 0x30, 0x7, 0x7, 0x2d, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 
	0x7, 0x7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x31, 
	0x7, 0x7, 0x32, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x33, 0x7, 0x7, 0x19, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x34, 0x7, 0x16, 0x0, 0x0, 0x0, 
	0x0, 0x35, 0x7, 0xd, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x7, 0x0, 0x0, 0x0, 0x0, 0x36, 
	0x7, 0x7, 0x37, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x38, 0x7, 0x7, 0x19, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x39, 0x3a, 0x2b, 0x3b, 0x3c, 0x9, 
	0x3d, 0x3e, 0x2b, 0x2a, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x7, 0x0, 0x0, 0x0, 0x3f, 
	0x7, 0x7, 0x2c, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x19, 0x7, 0x7, 0x19, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x17, 0x40, 0x7, 0x7, 0x7, 0x41, 
	0x42, 0x43, 0x44, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x7, 0x0, 0x0, 0x0, 0x0, 0x2c, 
	0x7, 0x7, 0x1c, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x16, 0x7, 0x7, 0x19, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x45, 0x7, 0x46, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 
	0x7, 0x7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x47, 
	0x48, 0x7, 0x49, 0x0, 0x0, 0x0, 0x0, 0x47, 
	0x4a, 0x7, 0x7, 0x19, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2f, 0x7, 0x4b, 0x9, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x4c, 0x7, 0xd, 0x47, 0x0, 0x0, 0x0, 0x1f, 
	0x34, 0x7, 0x7, 0x19, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x13, 0x7, 0x7, 0x41, 0x4d, 0x34, 
	0x4e, 0xa, 0x4f, 0x1d, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x5, 0x50, 0x7, 0x51, 0x1c, 0x52, 0x45, 0x53, 
	0x46, 0x7, 0x7, 0x19, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x16, 0x7, 0x7, 0x7, 0x7, 0x7, 
	0x7, 0x7, 0x7, 0x54, 0x40, 0x3c, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x47, 0x4, 0x55, 0x14, 0x1b, 0x43, 0x56, 
	0x17, 0x7, 0x7, 0x1c, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x57, 0x58, 0x23, 0x59, 0x16, 0x5a, 0xe, 
	0x5b, 0x13, 0x7, 0x7, 0x7, 0x5c, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x5d, 0x7, 0x7, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x5e, 0x5f, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x44, 0x45, 0x7, 0x15, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x60, 0x61, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x62, 0x7, 0x2b, 0x17, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x63, 0x2c, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x57, 0x7, 0x64, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 
	0x1b, 0x7, 0x65, 0x0, 0x0, 0x0, 0x0, 0x60, 
	0x3e, 0x7, 0x66, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x18, 0x67, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x59, 0x7, 0x3b, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x68, 
	0x1e, 0x7, 0x14, 0x32, 0x1d, 0x9, 0x35, 0x15, 
	0x54, 0x69, 0x68, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x11, 0x13, 0x50, 0x3f, 0x6a, 0x5, 0x47, 
	0x33, 0x37, 0x4e, 0x3a, 0x6b, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x5, 0x6c, 0x12, 0x6d, 0x54, 0x63, 0xc, 0x4e, 
	0x6e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1d, 0x16, 0xf, 0x6d, 0x41, 0x54, 
	0x1b, 0x6f, 0x70, 0x38, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0
};

static GClut gItalic_clut = { 113, 1, 0,
  { 0xffffff, 0xd6d6d6, 0x373737, 0xc0c0c0, 0x8e8e8e, 0xfbfbfb, 0x272727, 0x000000, 
    0x484848, 0xf8f8f8, 0x8f8f8f, 0x343434, 0x292929, 0x333333, 0x4e4e4e, 0x444444, 
    0xf3f3f3, 0xbfbfbf, 0x4a4a4a, 0x101010, 0x404040, 0x2e2e2e, 0x8b8b8b, 0xf9f9f9, 
    0x242424, 0xc4c4c4, 0xefefef, 0x141414, 0xc5c5c5, 0xececec, 0x3e3e3e, 0x858585, 
    0x606060, 0x7e7e7e, 0xcccccc, 0x7b7b7b, 0x3a3a3a, 0x636363, 0x959595, 0xcbcbcb, 
    0xb1b1b1, 0xa8a8a8, 0xc9c9c9, 0xd0d0d0, 0xcfcfcf, 0xe6e6e6, 0x2b2b2b, 0x909090, 
    0xf5f5f5, 0xdbdbdb, 0x8d8d8d, 0xe9e9e9, 0x464646, 0xbbbbbb, 0xb4b4b4, 0xbcbcbc, 
    0xdedede, 0xcecece, 0xa0a0a0, 0xa5a5a5, 0xf2f2f2, 0xb9b9b9, 0x232323, 0xafafaf, 
    0x545454, 0x303030, 0x202020, 0x656565, 0xdcdcdc, 0x616161, 0xdfdfdf, 0xfcfcfc, 
    0x161616, 0x989898, 0x2d2d2d, 0xa7a7a7, 0x888888, 0x212121, 0x6b6b6b, 0xb7b7b7, 
    0x4b4b4b, 0x515151, 0xc6c6c6, 0x1d1d1d, 0x101010, 0x2a2a2a, 0xe8e8e8, 0xf6f6f6, 
    0x707070, 0xababab, 0x6e6e6e, 0x303030, 0x727272, 0xe3e3e3, 0x5e5e5e, 0x828282, 
    0xf1f1f1, 0xe5e5e5, 0x9f9f9f, 0x707070, 0x404040, 0x979797, 0x808080, 0x7a7a7a, 
    0xfefefe, 0x787878, 0xe2e2e2, 0x8a8a8a, 0xa1a1a1, 0x171717, 0xd2d2d2, 0x3b3b3b, 
    0x7d7d7d } };

static struct _GImage gItalic_base = {
    it_index,
    15420,68,24,68,
    (uint8 *) gItalic_data,
    &gItalic_clut,
    0
};

static uint8 kItalic_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x3, 0x4, 0x5, 0x2, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x6, 0x2, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x7, 0x8, 0x2, 0x2, 0x9, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0xa, 0x2, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xb, 0x2, 0xc, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0xa, 0x2, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xd, 0x2, 0xe, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0xa, 0x2, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xf, 0x2, 0x10, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0xa, 0x2, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x11, 0x2, 0x12, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0xa, 0x2, 0x2, 0x0, 
	0x0, 0x13, 0x14, 0x2, 0x2, 0x2, 0x2, 0x15, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x16, 0x2, 0x17, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0xa, 0x2, 0x2, 0x0, 
	0x0, 0x0, 0x18, 0x2, 0x19, 0x1a, 0x1b, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1c, 0x2, 0x1d, 0x0, 0x1e, 
	0x1f, 0x14, 0x20, 0x11, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0xa, 0x2, 0x2, 0x0, 
	0x0, 0x21, 0x22, 0xc, 0x23, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x24, 0x2, 0x25, 0x26, 0x27, 
	0x28, 0x29, 0x2a, 0x2, 0xf, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0xa, 0x2, 0x2, 0x0, 
	0x21, 0x25, 0x2b, 0x2c, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x2d, 0x2, 0x22, 0x2e, 0x2f, 
	0x0, 0x0, 0x30, 0x2, 0x28, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0xa, 0x2, 0x2, 0x21, 
	0x22, 0x2, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x31, 0x2, 0x27, 0x31, 0x0, 
	0x0, 0x0, 0x32, 0x2, 0x33, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0xa, 0x2, 0x2, 0x22, 
	0x34, 0x2, 0x35, 0x36, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x37, 0x2, 0x14, 0x38, 0x0, 
	0x1b, 0x39, 0x35, 0x3a, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0xa, 0x2, 0x2, 0x3b, 
	0x3c, 0x3d, 0x2, 0x3e, 0x3f, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x40, 0x2, 0x41, 0x31, 0x2, 
	0x2, 0x42, 0x43, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0xa, 0x2, 0x2, 0x38, 
	0x0, 0x16, 0x2, 0x2, 0x44, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x45, 0x2, 0x46, 0x0, 0x0, 
	0x47, 0x13, 0x18, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0xa, 0x2, 0x2, 0x0, 
	0x0, 0x0, 0x48, 0x2, 0x34, 0x49, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x42, 0x2, 0x37, 0x0, 0x0, 
	0xf, 0x2, 0x4a, 0x0, 0x0, 0x1, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x6, 0x2, 0x2, 0x0, 
	0x0, 0x0, 0x4b, 0x8, 0x2, 0x2e, 0x4c, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x4d, 0x2, 0x31, 0x0, 0x0, 
	0x4e, 0x14, 0x4f, 0x50, 0x21, 0x51, 0x52, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x26, 0x2, 0x2, 0x53, 
	0x0, 0x0, 0x0, 0x54, 0x2, 0x2, 0x12, 0x23, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x48, 0x2, 0xb, 0x0, 0x0, 
	0x0, 0x7, 0x2, 0x7, 0x55, 0x56, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x4, 0x57, 0x2, 0x2, 0x2, 0x2, 
	0x3d, 0x0, 0x58, 0x14, 0x2, 0x2, 0x2, 0x2, 
	0x59, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x5a, 0x2, 0x5b, 0x0, 0x0, 
	0x0, 0x5c, 0x41, 0x14, 0x56, 0x5c, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0
};

static GClut kItalic_clut = { 93, 1, 0,
  { 0xffffff, 0x8f8f8f, 0x000000, 0xf3f3f3, 0xe2e2e2, 0x9a9a9a, 0xd6d6d6, 0x545454, 
    0x1a1a1a, 0x141414, 0xd8d8d8, 0x8b8b8b, 0x1d1d1d, 0xb8b8b8, 0x242424, 0xb5b5b5, 
    0x2d2d2d, 0xacacac, 0x343434, 0x131313, 0x404040, 0x717171, 0xa5a5a5, 0x3d3d3d, 
    0xdbdbdb, 0x909090, 0x7b7b7b, 0xdcdcdc, 0x9c9c9c, 0x444444, 0xababab, 0x272727, 
    0x2e2e2e, 0xf9f9f9, 0x4b4b4b, 0xd2d2d2, 0x959595, 0x4d4d4d, 0xafafaf, 0x707070, 
    0x656565, 0x777777, 0xc0c0c0, 0x1e1e1e, 0xdfdfdf, 0x8e8e8e, 0x212121, 0xc2c2c2, 
    0x949494, 0x858585, 0x787878, 0xa8a8a8, 0x303030, 0xd0d0d0, 0xdedede, 0x7e7e7e, 
    0xefefef, 0x606060, 0x979797, 0x313131, 0xcfcfcf, 0x111111, 0x3a3a3a, 0xfcfcfc, 
    0x757575, 0x3b3b3b, 0x676767, 0xebebeb, 0x808080, 0x6e6e6e, 0x686868, 0x636363, 
    0x575757, 0xc5c5c5, 0x515151, 0xececec, 0xeeeeee, 0x5e5e5e, 0xf2f2f2, 0x101010, 
    0xe3e3e3, 0x202020, 0xbcbcbc, 0xd9d9d9, 0x929292, 0x585858, 0x414141, 0xe0e0e0, 
    0x292929, 0x535353, 0x4e4e4e, 0x919191, 0xe6e6e6 } };

static struct _GImage kItalic_base = {
    it_index,
    15420,68,24,68,
    (uint8 *) kItalic_data,
    &kItalic_clut,
    0
};

static uint8 pItalic_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x3, 
	0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0xa, 0xb, 0xc, 0xc, 0xd, 
	0xe, 0xc, 0xc, 0xc, 0xc, 0xc, 0x5, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0xf, 0x10, 0x7, 0x0, 0x0, 0x11, 
	0x12, 0x13, 0x14, 0x15, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x16, 0xc, 0xc, 0x17, 
	0x18, 0x19, 0x4, 0x1a, 0xe, 0xc, 0xc, 0x1b, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1c, 0x1d, 0xc, 0x1e, 0x0, 0x1f, 0xa, 
	0x20, 0x21, 0xc, 0x22, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x23, 0xc, 0xc, 0x24, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x25, 0xc, 0x26, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x27, 0x28, 0x29, 0x2a, 0xc, 0x29, 0x2b, 0x2c, 
	0x0, 0x0, 0x6, 0xc, 0x2d, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xc, 0x2e, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xc, 0x1e, 
	0x11, 0x0, 0x0, 0x0, 0xc, 0xc, 0xc, 0xc, 
	0xc, 0xc, 0xc, 0xc, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x30, 0xc, 0x2, 0x31, 0x0, 
	0x0, 0x0, 0x32, 0xc, 0x15, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xc, 0x33, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x34, 0xc, 0xc, 
	0x34, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0xc, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x35, 0xc, 0x36, 0x0, 0x0, 
	0x0, 0x0, 0x37, 0xc, 0x38, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xc, 0x33, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x39, 0xc, 0x1d, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x35, 0xc, 0x3a, 0x0, 0x0, 
	0x0, 0x0, 0x3b, 0xc, 0x3c, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xc, 0x33, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x2c, 0xc, 0x3d, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0xc, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x35, 0xc, 0x3e, 0x0, 0x0, 
	0x0, 0x0, 0x25, 0x3f, 0x29, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xc, 0x33, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x40, 0x41, 0x42, 
	0x0, 0x0, 0x0, 0x0, 0xc, 0xc, 0xc, 0xc, 
	0xc, 0xc, 0xc, 0xc, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x35, 0xc, 0x29, 0x0, 0x0, 
	0x0, 0x23, 0x43, 0xa, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xc, 0x1b, 
	0x0, 0x0, 0x0, 0x0, 0x44, 0x45, 0x46, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x35, 0xc, 0x0, 0x0, 0x0, 
	0x0, 0x47, 0xc, 0x3a, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xc, 0x1e, 
	0x20, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x35, 0xc, 0x0, 0x0, 0x0, 
	0x0, 0x4d, 0x4e, 0x23, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xc, 0x4f, 
	0x50, 0xc, 0x14, 0x51, 0x29, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x35, 0xc, 0x37, 0x52, 0x2f, 
	0x3b, 0x20, 0x11, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xc, 0x33, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x35, 0xc, 0xc, 0x53, 0x54, 
	0x55, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xc, 0x33, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x35, 0xc, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xc, 0x33, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x35, 0xc, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xc, 0x33, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x35, 0xc, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x23, 0xc, 0xc, 0x33, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x35, 0xc, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x3c, 0xc, 0xc, 0x2c, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x35, 0xc, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x39, 0xc, 0xc, 0xc, 0xc, 0xc, 
	0xc, 0x39, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x35, 0xc, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x56, 0x24, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0
};

static GClut pItalic_clut = { 87, 1, 0,
  { 0xffffff, 0xe5e5e5, 0x9b9b9b, 0xf3f3f3, 0xfbfbfb, 0x818181, 0x363636, 0x2e2e2e, 
    0x5d5d5d, 0xc5c5c5, 0x444444, 0x1c1c1c, 0x000000, 0xebebeb, 0x545454, 0xd9d9d9, 
    0x414141, 0xf9f9f9, 0x808080, 0x1a1a1a, 0x171717, 0xcccccc, 0xd6d6d6, 0x4d4d4d, 
    0x848484, 0xe6e6e6, 0xd2d2d2, 0xb1b1b1, 0xababab, 0x272727, 0x101010, 0xf2f2f2, 
    0x616161, 0x636363, 0x3b3b3b, 0xfefefe, 0x9a9a9a, 0x4b4b4b, 0x373737, 0xdbdbdb, 
    0x8f8f8f, 0xfcfcfc, 0x707070, 0x585858, 0xcfcfcf, 0xececec, 0xeeeeee, 0xc4c4c4, 
    0xa0a0a0, 0xb7b7b7, 0x6b6b6b, 0xefefef, 0xf6f6f6, 0xc0c0c0, 0x656565, 0x7a7a7a, 
    0xc9c9c9, 0xf8f8f8, 0xa7a7a7, 0x6e6e6e, 0xdedede, 0x7b7b7b, 0xe3e3e3, 0x909090, 
    0x777777, 0xd0d0d0, 0xe8e8e8, 0x141414, 0xcbcbcb, 0xe0e0e0, 0xa8a8a8, 0xc2c2c2, 
    0xaeaeae, 0xb9b9b9, 0x7d7d7d, 0x404040, 0xd4d4d4, 0x515151, 0x535353, 0x5a5a5a, 
    0x161616, 0x878787, 0xbfbfbf, 0x303030, 0x393939, 0xb4b4b4, 0x6a6a6a } };

static struct _GImage pItalic_base = {
    it_index,
    15420,68,24,68,
    (uint8 *) pItalic_data,
    &pItalic_clut,
    0
};

static uint8 vItalic_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x2, 0x3, 0x1, 0x4, 0x1, 
	0x0, 0x0, 0x5, 0x6, 0x3, 0x7, 0x8, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x9, 0xa, 0xa, 0xa, 0xa, 
	0xb, 0x0, 0xc, 0xd, 0xe, 0xf, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x10, 0x11, 0xa, 0xa, 0x1, 0x12, 
	0x0, 0x0, 0x13, 0x14, 0x15, 0x16, 0x17, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 
	0x1d, 0x0, 0x1e, 0xb, 0xa, 0x1f, 0x20, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x21, 0x22, 0xa, 0x23, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x24, 0x25, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0xa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x26, 0x0, 0x0, 0x27, 0x28, 
	0x0, 0x0, 0x0, 0x0, 0x29, 0xa, 0x2a, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x2b, 0xa, 0x2c, 0x0, 
	0x0, 0x0, 0x0, 0x23, 0x2d, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0xa, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x20, 0x0, 0x0, 0x2e, 0x1e, 
	0x0, 0x0, 0x0, 0x0, 0xf, 0xa, 0x2f, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x30, 0xa, 0x31, 0x32, 
	0x0, 0x0, 0x0, 0x33, 0x34, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0xa, 0xa, 0xa, 0xa, 
	0xa, 0xa, 0xa, 0xa, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x35, 0x36, 0x37, 
	0x0, 0x0, 0x0, 0x0, 0x38, 0xa, 0x27, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2d, 0xa, 0x39, 
	0x0, 0x0, 0x3a, 0x3b, 0x3c, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0xa, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x33, 0x3d, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3e, 0x22, 0x3a, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xa, 0x3f, 
	0x0, 0x0, 0x1, 0x19, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x40, 0x41, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1e, 0x42, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3a, 0x43, 0xa, 
	0x35, 0x0, 0x44, 0x37, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0xa, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x45, 0x16, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x46, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x47, 0xa, 
	0x48, 0x1d, 0x49, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0xa, 0xa, 0xa, 0xa, 
	0xa, 0xa, 0xa, 0xa, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x4a, 0x4b, 0xc, 
	0x0, 0x0, 0x0, 0x32, 0x2d, 0x3c, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4c, 0x36, 
	0x4d, 0x42, 0x4c, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0xa, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x4e, 0xa, 0x4f, 
	0x0, 0x0, 0x0, 0x46, 0x17, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x50, 
	0xa, 0x51, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0xa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x13, 0x43, 0x22, 
	0x52, 0x17, 0x53, 0x54, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1b, 
	0xa, 0x55, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x38, 0x4a, 
	0x22, 0x56, 0x57, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0
};

static GClut vItalic_clut = { 88, 1, 0,
  { 0xffffff, 0x9f9f9f, 0x989898, 0x9e9e9e, 0x979797, 0xd1d1d1, 0x959595, 0x9b9b9b, 
    0x929292, 0x4a4a4a, 0x000000, 0x343434, 0xf2f2f2, 0x414141, 0x131313, 0xb9b9b9, 
    0xc6c6c6, 0x555555, 0xc8c8c8, 0xe6e6e6, 0xb4b4b4, 0x141414, 0x212121, 0xb2b2b2, 
    0x232323, 0x888888, 0xa2a2a2, 0xbcbcbc, 0x5e5e5e, 0xbfbfbf, 0xa7a7a7, 0x1d1d1d, 
    0xfcfcfc, 0xe2e2e2, 0x404040, 0xcccccc, 0x191919, 0xb5b5b5, 0x6b6b6b, 0xd5d5d5, 
    0x474747, 0x6d6d6d, 0xd4d4d4, 0x545454, 0x676767, 0x2e2e2e, 0x404040, 0xc5c5c5, 
    0xc1c1c1, 0xc0c0c0, 0xf1f1f1, 0x686868, 0xa1a1a1, 0xc2c2c2, 0x101010, 0xefefef, 
    0xcfcfcf, 0x949494, 0xf6f6f6, 0x2a2a2a, 0xf9f9f9, 0x202020, 0xc9c9c9, 0x2b2b2b, 
    0x333333, 0x303030, 0x3d3d3d, 0x111111, 0x3e3e3e, 0x242424, 0x656565, 0x757575, 
    0x585858, 0x717171, 0x3a3a3a, 0x303030, 0xdfdfdf, 0x606060, 0x777777, 0x8b8b8b, 
    0x4e4e4e, 0x484848, 0x828282, 0x5a5a5a, 0x818181, 0xa4a4a4, 0x272727, 0xa5a5a5 } };

static struct _GImage vItalic_base = {
    it_index,
    15420,68,24,68,
    (uint8 *) vItalic_data,
    &vItalic_clut,
    0
};

static uint8 wItalic_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 
	0x0, 0x0, 0x0, 0x4, 0x5, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x2, 0x2, 0x2, 0x6, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0x8, 0x8, 
	0x8, 0x8, 0x9, 0xa, 0x0, 0x0, 0xb, 0xc, 
	0x0, 0x0, 0xd, 0xe, 0xf, 0x10, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x11, 0x12, 0x8, 0x8, 0x13, 0x11, 
	0x0, 0x0, 0x0, 0x14, 0x15, 0x16, 0x0, 0x0, 
	0x0, 0x17, 0x1, 0x8, 0x18, 0x11, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x19, 0x3, 0x1a, 
	0x1b, 0x1c, 0x1d, 0x0, 0x0, 0x0, 0x8, 0x1e, 
	0x0, 0x0, 0x1f, 0x20, 0x8, 0x21, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x22, 0x23, 0x8, 0x24, 0x0, 
	0x0, 0x0, 0x0, 0x25, 0x8, 0x1d, 0x0, 0x0, 
	0x0, 0x0, 0x26, 0xc, 0x17, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x27, 0x0, 0x0, 
	0x28, 0x25, 0x4, 0x0, 0x0, 0x0, 0x8, 0x1e, 
	0x0, 0x0, 0x0, 0x22, 0xf, 0x29, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x2a, 0x8, 0x18, 0x0, 
	0x0, 0x0, 0x2b, 0x2c, 0x8, 0xf, 0x0, 0x0, 
	0x0, 0x0, 0x2d, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 
	0x2e, 0x2, 0x0, 0x0, 0x0, 0x0, 0x8, 0x1e, 
	0x0, 0x0, 0x0, 0x0, 0x2f, 0x30, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x1b, 0x8, 0x31, 0x0, 
	0x0, 0x0, 0x32, 0x1b, 0x33, 0x8, 0x34, 0x0, 
	0x0, 0x16, 0x9, 0x35, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x36, 
	0x37, 0x38, 0x0, 0x0, 0x0, 0x4, 0x8, 0x1e, 
	0x0, 0x0, 0x0, 0x0, 0x39, 0xe, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x11, 0x1e, 0x8, 0x3a, 
	0x0, 0x3b, 0x33, 0x0, 0x3c, 0x8, 0x3d, 0x0, 
	0x0, 0x5, 0x3d, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3e, 
	0x8, 0x3f, 0x0, 0x0, 0x0, 0x35, 0x8, 0x1e, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x40, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x41, 0x8, 0x1, 
	0x0, 0x42, 0x43, 0x0, 0x28, 0x44, 0x45, 0x46, 
	0x0, 0x47, 0x38, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x47, 
	0x48, 0x0, 0x0, 0x0, 0x0, 0x1b, 0x8, 0x45, 
	0x0, 0x0, 0x0, 0x0, 0x49, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x43, 0x8, 0x4a, 
	0x28, 0x19, 0x3f, 0x0, 0x0, 0x4b, 0x8, 0x4c, 
	0x10, 0x25, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x25, 
	0x8, 0x4d, 0x0, 0x0, 0x0, 0x4e, 0x8, 0x8, 
	0x4f, 0x0, 0x0, 0x0, 0x20, 0x3a, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x50, 0x8, 0x44, 
	0x51, 0x52, 0x0, 0x0, 0x0, 0x53, 0x8, 0x54, 
	0x3e, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x41, 
	0x8, 0x55, 0x0, 0x0, 0x4d, 0x56, 0x48, 0x8, 
	0x57, 0x0, 0x0, 0x58, 0x3d, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x59, 0x8, 
	0x5a, 0x5b, 0x0, 0x0, 0x0, 0x4f, 0x20, 0x8, 
	0x5c, 0x35, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5d, 
	0x8, 0x5e, 0x0, 0x0, 0x5f, 0xa, 0x60, 0x8, 
	0x61, 0x0, 0x4d, 0x62, 0x10, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1c, 0x8, 
	0x63, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x8, 
	0x62, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x57, 
	0x5c, 0x45, 0x1, 0x39, 0x4e, 0x0, 0x52, 0x8, 
	0x25, 0x64, 0x62, 0x53, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x65, 0x8, 
	0x66, 0x0, 0x0, 0x0, 0x0, 0x0, 0x67, 0x48, 
	0x1d, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x68, 0x60, 0x30, 0x69, 0x0, 0x0, 0x6a, 0x6b, 
	0x37, 0x62, 0x55, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0
};

static GClut wItalic_clut = { 108, 1, 0,
  { 0xffffff, 0x959595, 0x848484, 0x858585, 0xfcfcfc, 0xa5a5a5, 0x9c9c9c, 0x4d4d4d, 
    0x000000, 0x111111, 0xeeeeee, 0x303030, 0x1a1a1a, 0xd2d2d2, 0x1d1d1d, 0x2e2e2e, 
    0xe6e6e6, 0xf9f9f9, 0x888888, 0xc5c5c5, 0xaeaeae, 0xa0a0a0, 0xf3f3f3, 0xf8f8f8, 
    0x787878, 0x1e1e1e, 0x9f9f9f, 0xbbbbbb, 0x828282, 0x989898, 0xc0c0c0, 0x747474, 
    0x242424, 0x636363, 0xfbfbfb, 0x191919, 0xc2c2c2, 0x3b3b3b, 0xababab, 0x656565, 
    0xefefef, 0x1c1c1c, 0x6d6d6d, 0xc8c8c8, 0x262626, 0x575757, 0x6b6b6b, 0x757575, 
    0xd0d0d0, 0x2d2d2d, 0x545454, 0x343434, 0xc6c6c6, 0xe9e9e9, 0xe2e2e2, 0x404040, 
    0xcccccc, 0x8b8b8b, 0xe1e1e1, 0xdfdfdf, 0x979797, 0x5e5e5e, 0x878787, 0xf6f6f6, 
    0x434343, 0x515151, 0x6e6e6e, 0x9e9e9e, 0x909090, 0x707070, 0xececec, 0x4b4b4b, 
    0x303030, 0x616161, 0x4a4a4a, 0x5d5d5d, 0x8e8e8e, 0xf5f5f5, 0x949494, 0xfefefe, 
    0xe8e8e8, 0x808080, 0x727272, 0xbfbfbf, 0x272727, 0xcfcfcf, 0x9b9b9b, 0xebebeb, 
    0xbcbcbc, 0x363636, 0x606060, 0xdcdcdc, 0x101010, 0x8d8d8d, 0x7d7d7d, 0x8f8f8f, 
    0x202020, 0xb5b5b5, 0x414141, 0x484848, 0xacacac, 0xcecece, 0xb2b2b2, 0xe5e5e5, 
    0xbebebe, 0x7b7b7b, 0xf1f1f1, 0x444444 } };

static struct _GImage wItalic_base = {
    it_index,
    15420,68,24,68,
    (uint8 *) wItalic_data,
    &wItalic_clut,
    0
};

static uint8 xItalic_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x2, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x4, 0x5, 0x6, 0x7, 0x2, 0x0, 0x0, 
	0x0, 0x0, 0x8, 0x6, 0x9, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xb, 
	0xc, 0xd, 0xe, 0x0, 0x0, 0xf, 0x10, 0x11, 
	0x12, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x13, 0x14, 0x6, 0x15, 0x16, 0x0, 
	0x0, 0x17, 0x18, 0x19, 0x1a, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1b, 0x14, 
	0x1c, 0x6, 0x1d, 0x0, 0x1a, 0x1e, 0x7, 0x6, 
	0x1f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x20, 0x21, 0x6, 0x22, 0x0, 
	0x23, 0x11, 0x24, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x16, 0x25, 0x0, 
	0xa, 0x5, 0x21, 0x26, 0x24, 0x8, 0x26, 0x27, 
	0x26, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x19, 0x6, 0x18, 0x28, 
	0x29, 0x2a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x6, 0x6, 0x6, 0x6, 0x6, 0x6, 0x6, 0x6, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2b, 0x6, 0x2c, 0x2d, 0x26, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2e, 0x6, 0xc, 
	0x2f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x30, 0x31, 0x32, 0x33, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x34, 0x32, 0x6, 
	0x35, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x36, 0x37, 0x34, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2c, 0x38, 0x11, 
	0x18, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x39, 0x6, 0x17, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x28, 0x3a, 0x20, 0x3b, 
	0x6, 0x3c, 0x3d, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x6, 0x6, 0x6, 0x6, 0x6, 0x6, 0x6, 0x6, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x36, 0x5, 0x1e, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x3e, 0x1c, 0x3f, 0x0, 0x0, 
	0x40, 0x6, 0x10, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2c, 0x17, 0x41, 0x6, 0x42, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1f, 0x43, 0x44, 0x0, 0x0, 0x0, 
	0xf, 0x1c, 0x6, 0x45, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2c, 0x0, 
	0x46, 0x47, 0x48, 0x49, 0x6, 0x4a, 0x0, 0x26, 
	0x17, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x19, 0x4b, 0x4c, 0x16, 0x0, 0x0, 0x0, 
	0x0, 0x4d, 0x4e, 0x6, 0x4f, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x29, 0x50, 
	0x32, 0x24, 0x0, 0x1a, 0x51, 0x6, 0x47, 0x52, 
	0x53, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4a, 0x54, 
	0x55, 0x0, 0x0, 0x0, 0x56, 0x57, 0x51, 0x53, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0
};

static GClut xItalic_clut = { 88, 1, 0,
  { 0xffffff, 0xfcfcfc, 0xc2c2c2, 0xbfbfbf, 0xafafaf, 0x111111, 0x000000, 0x606060, 
    0x575757, 0x484848, 0xe2e2e2, 0x232323, 0x909090, 0x5d5d5d, 0xf8f8f8, 0xe9e9e9, 
    0x3e3e3e, 0xd0d0d0, 0xeeeeee, 0xe5e5e5, 0x373737, 0x1d1d1d, 0xf3f3f3, 0x9f9f9f, 
    0x303030, 0xa8a8a8, 0xfefefe, 0x636363, 0x161616, 0x7b7b7b, 0x414141, 0xebebeb, 
    0xe1e1e1, 0x101010, 0x707070, 0xd9d9d9, 0xa2a2a2, 0x848484, 0xf6f6f6, 0xc8c8c8, 
    0xc5c5c5, 0x343434, 0x929292, 0x8a8a8a, 0xacacac, 0x444444, 0x5e5e5e, 0x828282, 
    0xefefef, 0x707070, 0x1a1a1a, 0xb1b1b1, 0xf2f2f2, 0x858585, 0x585858, 0x404040, 
    0x313131, 0x989898, 0x1c1c1c, 0x9e9e9e, 0x171717, 0xe6e6e6, 0xdbdbdb, 0xb8b8b8, 
    0x4e4e4e, 0x616161, 0xd6d6d6, 0x242424, 0x717171, 0x777777, 0xe8e8e8, 0x3d3d3d, 
    0xfbfbfb, 0xbbbbbb, 0x515151, 0x212121, 0x1e1e1e, 0xb2b2b2, 0x101010, 0x3b3b3b, 
    0x4b4b4b, 0x2a2a2a, 0x2e2e2e, 0xc9c9c9, 0xa0a0a0, 0x7e7e7e, 0xcbcbcb, 0x191919 } };

static struct _GImage xItalic_base = {
    it_index,
    15420,68,24,68,
    (uint8 *) xItalic_data,
    &xItalic_clut,
    0
};

static uint8 yItalic_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x2, 0x3, 0x3, 0x4, 0x5, 
	0x0, 0x0, 0x6, 0x2, 0x3, 0x3, 0x2, 0x6, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x7, 0x8, 0x9, 0xa, 0x0, 0x0, 
	0x0, 0x0, 0xb, 0xc, 0xd, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0xe, 0xf, 0x10, 0x10, 0x11, 0x1, 
	0x0, 0x0, 0x12, 0x13, 0x14, 0x15, 0x2, 0x12, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x16, 0x17, 0x18, 0x10, 0x19, 0x0, 0x0, 
	0x0, 0x0, 0x1a, 0x10, 0x1b, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1c, 0x1d, 0x10, 0x1e, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1f, 0x20, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x21, 0x1a, 0x1c, 0x20, 0x10, 0x5, 0x0, 0x0, 
	0x0, 0x0, 0x22, 0x10, 0x13, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x23, 0x10, 0x24, 0x0, 
	0x0, 0x0, 0x0, 0x25, 0x26, 0x27, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x28, 0x10, 0x29, 0x0, 0x0, 
	0x0, 0x0, 0xf, 0x10, 0x2a, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x2b, 0x10, 0x2c, 0x2d, 
	0x0, 0x0, 0x0, 0x8, 0x2e, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x16, 0x10, 0x2f, 0x0, 0x0, 
	0x0, 0x0, 0x14, 0x10, 0x7, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x30, 0x10, 0x31, 
	0x0, 0x0, 0x32, 0x33, 0x12, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
	0x10, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x34, 0x10, 0x35, 0x0, 0x0, 
	0x0, 0x36, 0x10, 0x37, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x38, 0x10, 0x39, 
	0x0, 0x0, 0x3a, 0x3b, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3c, 0x3d, 0x0, 0x0, 
	0x0, 0x3e, 0x10, 0x3f, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x40, 0x26, 0x10, 
	0x41, 0x0, 0x42, 0x43, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x44, 0x45, 0x0, 0x0, 
	0x46, 0x47, 0x10, 0x23, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x48, 0x10, 
	0x2f, 0x49, 0x4a, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x30, 0x2c, 0x4b, 0x0, 
	0x4c, 0x4d, 0x10, 0x4e, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x36, 0x4f, 
	0x2c, 0x30, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
	0x10, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3b, 0x10, 0xe, 0x51, 
	0x48, 0x50, 0x10, 0x28, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x52, 
	0x10, 0x26, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x53, 0x10, 0x54, 0x55, 
	0x40, 0x56, 0x10, 0x57, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x58, 
	0x10, 0x1b, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x12, 0x59, 0x3f, 0x5a, 
	0x0, 0x5b, 0x1d, 0x4b, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x32, 
	0x54, 0x5c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x5d, 0x5e, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x13, 
	0x5f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x60, 0x2e, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x30, 
	0x49, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x61, 0x10, 0x16, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x62, 0x63, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x32, 0x5c, 0x0, 0x0, 0x0, 
	0x50, 0x3f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x64, 0x4b, 0x65, 0x66, 0x38, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1f, 0x67, 0x0, 0x0, 0x0, 
	0x17, 0x2a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x7, 0x54, 0x26, 0x54, 0x68, 0x4b, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x63, 0x59, 0x69, 0x40, 0x1b, 
	0x67, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x6a, 0x33, 0x18, 0x2f, 0x34, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x69, 0x6b, 0x2c, 0x6c, 0x6d, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0
};

static GClut yItalic_clut = { 110, 1, 0,
  { 0xffffff, 0xb5b5b5, 0x9b9b9b, 0xa2a2a2, 0x9e9e9e, 0x989898, 0xdcdcdc, 0xf3f3f3, 
    0x656565, 0x1a1a1a, 0xf5f5f5, 0xc2c2c2, 0x4a4a4a, 0x686868, 0xc8c8c8, 0x4b4b4b, 
    0x000000, 0x717171, 0xe8e8e8, 0xa5a5a5, 0x232323, 0xa0a0a0, 0xd5d5d5, 0x414141, 
    0xc0c0c0, 0xbcbcbc, 0x7d7d7d, 0x7e7e7e, 0xf1f1f1, 0xd0d0d0, 0xaaaaaa, 0x313131, 
    0x8b8b8b, 0xfbfbfb, 0x646464, 0x6b6b6b, 0x515151, 0xcccccc, 0x171717, 0xf6f6f6, 
    0xbbbbbb, 0x787878, 0xcecece, 0xd4d4d4, 0x404040, 0xe9e9e9, 0x808080, 0x5e5e5e, 
    0x3e3e3e, 0x8e8e8e, 0xf2f2f2, 0x111111, 0xefefef, 0x474747, 0xe1e1e1, 0x1d1d1d, 
    0xa8a8a8, 0x2b2b2b, 0x979797, 0x5b5b5b, 0x909090, 0x303030, 0x8a8a8a, 0x444444, 
    0xf9f9f9, 0xcbcbcb, 0x2e2e2e, 0xc9c9c9, 0x242424, 0x191919, 0xfcfcfc, 0x464646, 
    0x7b7b7b, 0xc6c6c6, 0x363636, 0xfefefe, 0x8f8f8f, 0x919191, 0x949494, 0x101010, 
    0xa4a4a4, 0xacacac, 0x4e4e4e, 0x888888, 0x707070, 0x3b3b3b, 0x878787, 0xe2e2e2, 
    0xb2b2b2, 0x212121, 0xeeeeee, 0x6a6a6a, 0xe6e6e6, 0x484848, 0x3d3d3d, 0x585858, 
    0x1e1e1e, 0xebebeb, 0xbfbfbf, 0x343434, 0xbebebe, 0xdfdfdf, 0x202020, 0x959595, 
    0x434343, 0xd9d9d9, 0xcfcfcf, 0x373737, 0x333333, 0xb1b1b1 } };

static struct _GImage yItalic_base = {
    it_index,
    15420,68,24,68,
    (uint8 *) yItalic_data,
    &yItalic_clut,
    0
};

static uint8 zItalic_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x3, 
	0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0xb, 0xc, 0xc, 0xc, 0xc, 0xc, 
	0xc, 0xc, 0xc, 0xc, 0xd, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xf, 0x10, 
	0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x8, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x17, 0x18, 0x19, 0x1a, 0x0, 0x0, 
	0xa, 0x1b, 0xc, 0xe, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1c, 0x1d, 0x0, 
	0x0, 0x0, 0x0, 0x1e, 0x1f, 0x20, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x5, 0x21, 0x0, 0x0, 0x0, 0x8, 
	0x22, 0xc, 0x23, 0x8, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x24, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x25, 0x26, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1d, 0x27, 0x0, 0x0, 0x0, 0x28, 
	0xc, 0x29, 0x19, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x2a, 0x2b, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2c, 0xc, 
	0x12, 0x2d, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2e, 0x2f, 0x30, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x31, 0x32, 0x33, 
	0x34, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x27, 0x35, 0x2d, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x2d, 0x12, 0xc, 0x36, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x18, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x37, 0x38, 0xc, 0x18, 0x0, 
	0x0, 0x0, 0x0, 0x24, 0xd, 0x0, 0x0, 0x0, 
	0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x39, 
	0x1c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3a, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x30, 0x3b, 0xc, 0x3c, 0x3d, 0x0, 
	0x0, 0x0, 0x0, 0x3e, 0x3f, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x40, 0x2f, 
	0x27, 0x0, 0x0, 0x0, 0x0, 0x0, 0x41, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x8, 0x42, 0xc, 0x43, 0x44, 0x0, 0x0, 
	0x0, 0x0, 0x27, 0x35, 0x45, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x3d, 0x46, 0x47, 
	0x43, 0x48, 0x12, 0x49, 0x2f, 0x3b, 0x32, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x4a, 0xc, 0xc, 0x12, 0x38, 0x38, 0x38, 
	0xf, 0x1b, 0x4b, 0xc, 0x4c, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x31, 0x4d, 0x37, 
	0x4e, 0x4f, 0x2c, 0x50, 0x38, 0x33, 0x12, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0
};

static GClut zItalic_clut = { 81, 1, 0,
  { 0xffffff, 0xa2a2a2, 0xd0d0d0, 0xc0c0c0, 0x414141, 0x858585, 0xbfbfbf, 0xebebeb, 
    0xfcfcfc, 0x757575, 0xe9e9e9, 0xaaaaaa, 0x000000, 0xe1e1e1, 0x777777, 0x212121, 
    0x3d3d3d, 0x2a2a2a, 0x111111, 0x707070, 0x1a1a1a, 0x262626, 0x393939, 0x9b9b9b, 
    0x616161, 0xf1f1f1, 0xfefefe, 0x171717, 0x606060, 0xe3e3e3, 0xececec, 0x2d2d2d, 
    0xdfdfdf, 0xababab, 0x444444, 0x4b4b4b, 0xe5e5e5, 0x4e4e4e, 0xaeaeae, 0xf3f3f3, 
    0x6e6e6e, 0x272727, 0x929292, 0x6b6b6b, 0x989898, 0xd9d9d9, 0xcfcfcf, 0x373737, 
    0xf8f8f8, 0xbcbcbc, 0x404040, 0x303030, 0xb9b9b9, 0x343434, 0x8f8f8f, 0xeeeeee, 
    0x242424, 0xa7a7a7, 0xbebebe, 0x3e3e3e, 0x3a3a3a, 0xf9f9f9, 0x7d7d7d, 0xb1b1b1, 
    0xdedede, 0x585858, 0x535353, 0x1d1d1d, 0xe8e8e8, 0xd6d6d6, 0x363636, 0x2b2b2b, 
    0x909090, 0x232323, 0x8b8b8b, 0x10101, 0xefefef, 0x808080, 0xf6f6f6, 0xd1d1d1, 
    0x5b5b5b } };

static struct _GImage zItalic_base = {
    it_index,
    15420,68,24,68,
    (uint8 *) zItalic_data,
    &zItalic_clut,
    0
};

static uint8 u432Italic_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x2, 0x3, 0x3, 0x3, 0x4, 
	0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 
	0xc, 0xd, 0xe, 0xf, 0x10, 0x11, 0x12, 0x13, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x14, 0x3, 0x3, 0x15, 
	0x0, 0x0, 0x0, 0x16, 0x17, 0x3, 0x18, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x19, 
	0x3, 0x1a, 0x1b, 0x1c, 0x1d, 0x12, 0x3, 0x1e, 
	0x1f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x20, 0x3, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x21, 0x3, 0x22, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x23, 
	0x3, 0x24, 0x0, 0x0, 0x0, 0x0, 0x25, 0x3, 
	0x26, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x27, 0x3, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x28, 0x3, 0x29, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 
	0x3, 0x27, 0x0, 0x0, 0x0, 0x0, 0x2a, 0x3, 
	0x2b, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x27, 0x3, 0x3, 0x0, 
	0x0, 0x2c, 0x2d, 0x2b, 0x2e, 0x17, 0x2f, 0x0, 
	0x0, 0x0, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 
	0x3, 0x27, 0x0, 0x0, 0x1c, 0x30, 0x3, 0x25, 
	0x31, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x27, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x23, 0x32, 0x33, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x34, 0x30, 
	0x13, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x27, 0x3, 0x3, 0x0, 
	0x0, 0x35, 0x15, 0x36, 0x37, 0x38, 0x39, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x3, 
	0x3, 0x27, 0x0, 0x2c, 0x3a, 0x3b, 0x3c, 0x3, 
	0xe, 0x2f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x27, 0x3, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3d, 0x3, 0x34, 0x35, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x3, 
	0x3, 0x27, 0x0, 0x0, 0x0, 0x0, 0x3e, 0x1e, 
	0x3, 0x3f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x27, 0x3, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2c, 0x3, 0x3, 0x2d, 
	0x0, 0x0, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 
	0x3, 0x27, 0x0, 0x0, 0x0, 0x0, 0x0, 0x40, 
	0x3, 0x7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x41, 0x3, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x42, 0x3, 0x43, 0x2c, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x3, 0x44, 0x0, 0x0, 0x0, 0x0, 0x31, 0x43, 
	0x3, 0x45, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x46, 0x3, 0x3, 0x18, 
	0x47, 0x47, 0x2f, 0x48, 0xf, 0x2e, 0x21, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x30, 
	0x3, 0x40, 0x24, 0x0, 0x47, 0xa, 0x49, 0x3, 
	0x4a, 0x4b, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x4c, 0xf, 0x3, 0x3, 0x3, 0x3, 
	0xf, 0x10, 0x2, 0x3f, 0xc, 0x1b, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x35, 
	0x4d, 0x8, 0x4e, 0x4f, 0x10, 0x5, 0x45, 0x50, 
	0x47, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0
};

static GClut u432Italic_clut = { 81, 1, 0,
  { 0xffffff, 0xbcbcbc, 0x1d1d1d, 0x000000, 0x707070, 0x222222, 0x272727, 0x1f1f1f, 
    0x2f2f2f, 0x666666, 0xcccccc, 0xf9f9f9, 0x8a8a8a, 0x373737, 0xf0f0f0, 0x101010, 
    0x909090, 0x242424, 0x696969, 0xe2e2e2, 0x909090, 0xe3e3e3, 0xc5c5c5, 0x2a2a2a, 
    0x9c9c9c, 0x555555, 0x707070, 0xeeeeee, 0xf0f0f0, 0xcdcdcd, 0x141414, 0xe8e8e8, 
    0xd2d2d2, 0xc2c2c2, 0x111111, 0x303030, 0xd8d8d8, 0x3f3f3f, 0x838383, 0xd9d9d9, 
    0xb3b3b3, 0x232323, 0x424242, 0x939393, 0xfbfbfb, 0xdddddd, 0x131313, 0xd0d0d0, 
    0x797979, 0xf5f5f5, 0x5c5c5c, 0xebebeb, 0x171717, 0xfcfcfc, 0x989898, 0x101010, 
    0xd0d0d0, 0xbbbbbb, 0xe0e0e0, 0xa5a5a5, 0x2c2c2c, 0xb9b9b9, 0xf2f2f2, 0x444444, 
    0x494949, 0xd6d6d6, 0xa0a0a0, 0x161616, 0xcbcbcb, 0x5a5a5a, 0x969696, 0xfefefe, 
    0x6d6d6d, 0x404040, 0x343434, 0xe9e9e9, 0xb2b2b2, 0x868686, 0xa0a0a0, 0x404040, 
    0xb0b0b0 } };

static struct _GImage u432Italic_base = {
    it_index,
    15420,68,24,68,
    (uint8 *) u432Italic_data,
    &u432Italic_clut,
    0
};

static uint8 u433Italic_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x5, 
	0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0xd, 0xe, 0x2, 0x2, 0xf, 0x10, 
	0x11, 0x12, 0x13, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x14, 0x15, 0x2, 
	0x16, 0x17, 0x0, 0x18, 0x19, 0x2, 0x1a, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x2, 0x2, 0x1b, 0x0, 
	0x0, 0x1c, 0x12, 0x1d, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1e, 0x2, 0x1f, 
	0x0, 0x0, 0x0, 0x0, 0x20, 0x2, 0x2, 0x21, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x22, 0x2, 0x2, 0x0, 0x0, 
	0x0, 0x0, 0x23, 0x24, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x25, 0xd, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x26, 0x2, 0x2, 0x1c, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x22, 0x2, 0x2, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x27, 0x3, 0xa, 0x2, 0x2, 0x13, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x22, 0x2, 0x2, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x17, 0x5, 
	0x28, 0x2, 0x2, 0x2, 0x29, 0x2a, 0x2b, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x22, 0x2, 0x2, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x0, 0x0, 0x0, 0x0, 0x14, 0x15, 0x2, 
	0x2, 0x2c, 0x2d, 0x2e, 0xd, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x22, 0x2, 0x2, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x2f, 0x30, 0x2, 0x31, 
	0x32, 0x33, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x22, 0x2, 0x2, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x21, 0x2, 0x2, 0x34, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x35, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x36, 0x2, 0x2, 0x37, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x25, 0x31, 0x2, 0x10, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x38, 0x39, 0x26, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x3a, 0x2, 0x2, 0x3b, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x2c, 0x3d, 
	0x1c, 0x0, 0x0, 0x3e, 0xf, 0x30, 0x3f, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x40, 0x41, 0x2, 0x2, 0x2, 0x2c, 0x42, 
	0x2f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x38, 0x43, 
	0x44, 0x9, 0x9, 0x28, 0x45, 0x2b, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0
};

static GClut u433Italic_clut = { 70, 1, 0,
  { 0xffffff, 0xc0c0c0, 0x000000, 0x999999, 0xe6e6e6, 0x858585, 0x3f3f3f, 0x141414, 
    0x161616, 0x131313, 0x3d3d3d, 0x9c9c9c, 0xfefefe, 0xe3e3e3, 0x333333, 0x5f5f5f, 
    0xbcbcbc, 0x868686, 0xd0d0d0, 0x373737, 0xafafaf, 0xa0a0a0, 0x707070, 0xe8e8e8, 
    0xf6f6f6, 0x666666, 0x5d5d5d, 0xf5f5f5, 0xd0d0d0, 0xd8d8d8, 0x4f4f4f, 0x808080, 
    0xd6d6d6, 0xdbdbdb, 0xd9d9d9, 0x9d9d9d, 0xa3a3a3, 0xf8f8f8, 0x7d7d7d, 0xe5e5e5, 
    0x303030, 0x101010, 0x525252, 0xececec, 0x404040, 0x404040, 0x909090, 0xfbfbfb, 
    0x111111, 0xf0f0f0, 0x929292, 0xefefef, 0xa6a6a6, 0xf2f2f2, 0xd2d2d2, 0xfcfcfc, 
    0xd3d3d3, 0x393939, 0x898989, 0xb9b9b9, 0xa9a9a9, 0x2f2f2f, 0xcbcbcb, 0x969696, 
    0xcdcdcd, 0x2a2a2a, 0x363636, 0x626262, 0x202020, 0x828282 } };

static struct _GImage u433Italic_base = {
    it_index,
    15420,68,24,68,
    (uint8 *) u433Italic_data,
    &u433Italic_clut,
    0
};

static uint8 u434Italic_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x2, 0x3, 0x3, 0x3, 0x4, 0x5, 
	0x6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x7, 0x8, 0x9, 0x8, 0xa, 0xb, 
	0xc, 0xd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 
	0xf, 0x3, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x11, 0x12, 0x3, 0x13, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x14, 0x15, 0x16, 0x17, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x18, 0x19, 0x4, 0x3, 
	0x1a, 0x1b, 0x1c, 0x1d, 0x3, 0x3, 0x4, 0x1b, 
	0x1e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1f, 0x3, 0x20, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x21, 0x3, 
	0x22, 0x0, 0x0, 0x1, 0x3, 0x3, 0x23, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x11, 0x24, 0x25, 0x26, 
	0x1a, 0x1d, 0x27, 0x3, 0x3, 0x28, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x29, 0x3, 
	0x2a, 0x0, 0x0, 0x0, 0x3, 0x3, 0x17, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x2b, 0x2c, 0x3, 0x2d, 0x17, 
	0x2e, 0x2f, 0x30, 0x3, 0x3, 0x31, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x32, 0x3, 
	0x23, 0x0, 0x0, 0x0, 0x3, 0x3, 0x33, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x34, 0x3, 0x20, 0x0, 0x0, 
	0x0, 0x0, 0x2e, 0x35, 0x3, 0x1d, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x21, 0x3, 
	0x28, 0x0, 0x0, 0x0, 0x3, 0x3, 0x33, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x36, 0x3, 0x3, 0x32, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x37, 0x3, 0x3, 0x38, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x39, 0x3a, 
	0x3b, 0x0, 0x0, 0x0, 0x3, 0x3, 0x33, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3c, 0x3, 0x35, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x3d, 0x3, 0x3, 0x3e, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x40, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0x33, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x41, 0x3, 0x42, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x29, 0x3, 0x3, 0x43, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x35, 0x44, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0x33, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x41, 0x3, 0x41, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x17, 0x3, 0x3, 0x45, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x3, 0x46, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0x33, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3c, 0x3, 0x47, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x2f, 0x3, 0x3, 0x48, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x49, 0x3b, 
	0x0, 0x0, 0x0, 0x11, 0x3, 0x3, 0x17, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x4a, 0x3, 0xc, 0x4b, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x4c, 0x3, 0x4, 0x4d, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x11, 0x11, 0x4e, 0x1a, 0x4f, 0x11, 
	0x11, 0x11, 0xe, 0x50, 0x3, 0x3, 0x8, 0xe, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x51, 0x3, 0x10, 0x0, 0x0, 
	0x0, 0x0, 0x52, 0x53, 0x3, 0x37, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2b, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x23, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x2b, 0x12, 0x3, 0x10, 0x29, 
	0x2b, 0x36, 0x54, 0x3, 0x55, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x56, 0x3, 0x57, 0x58, 0x11, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x2b, 0x59, 0x3a, 
	0x5a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x5b, 0x42, 0x26, 
	0x3, 0x5c, 0x5d, 0x4a, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x5e, 0x5f, 0xe, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x60, 
	0x61, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x62, 0x63, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x64, 
	0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0
};

static GClut u434Italic_clut = { 101, 1, 0,
  { 0xffffff, 0xececec, 0xc0c0c0, 0x000000, 0xa0a0a0, 0x4f4f4f, 0xcccccc, 0x8c8c8c, 
    0x9c9c9c, 0xa6a6a6, 0x7a7a7a, 0x272727, 0x101010, 0x7f7f7f, 0xfbfbfb, 0x5f5f5f, 
    0x696969, 0xfefefe, 0x464646, 0x8d8d8d, 0xe2e2e2, 0x707070, 0x606060, 0xd8d8d8, 
    0xbfbfbf, 0x3a3a3a, 0x404040, 0x3c3c3c, 0x404040, 0x242424, 0xbcbcbc, 0x626262, 
    0x4d4d4d, 0xb6b6b6, 0x6a6a6a, 0xb3b3b3, 0xa3a3a3, 0x3f3f3f, 0xd0d0d0, 0x4c4c4c, 
    0xd5d5d5, 0xdbdbdb, 0x959595, 0xf5f5f5, 0x474747, 0x5a5a5a, 0xf3f3f3, 0xbdbdbd, 
    0x343434, 0x737373, 0xd0d0d0, 0xd9d9d9, 0x565656, 0x1c1c1c, 0xc6c6c6, 0x868686, 
    0xe8e8e8, 0x909090, 0x303030, 0xf9f9f9, 0x707070, 0xc2c2c2, 0xb9b9b9, 0x5d5d5d, 
    0x2c2c2c, 0x494949, 0x424242, 0x9d9d9d, 0x676767, 0x999999, 0xb0b0b0, 0x2d2d2d, 
    0xb2b2b2, 0x111111, 0xc5c5c5, 0xe9e9e9, 0x838383, 0xf0f0f0, 0xb8b8b8, 0x5c5c5c, 
    0xafafaf, 0x535353, 0xf2f2f2, 0x1a1a1a, 0x363636, 0x727272, 0xcfcfcf, 0x595959, 
    0xe0e0e0, 0x9f9f9f, 0x8f8f8f, 0xa5a5a5, 0x171717, 0x575757, 0xa9a9a9, 0x222222, 
    0x666666, 0x6c6c6c, 0xa0a0a0, 0x969696, 0xd3d3d3 } };

static struct _GImage u434Italic_base = {
    it_index,
    15420,68,24,68,
    (uint8 *) u434Italic_data,
    &u434Italic_clut,
    0
};

static uint8 u436Italic_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x0, 
	0x7, 0x8, 0x9, 0x9, 0x9, 0xa, 0xb, 0x0, 
	0xc, 0xd, 0xe, 0xf, 0x10, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x11, 
	0x12, 0x3, 0x13, 0x14, 0x15, 0x0, 0x0, 0x0, 
	0x9, 0x9, 0x16, 0x0, 0x0, 0x17, 0x18, 0x19, 
	0x1a, 0x1b, 0x1c, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1d, 0x9, 0x9, 0x1e, 0x1f, 0x20, 0x0, 
	0x0, 0x21, 0x13, 0x9, 0x22, 0x0, 0x0, 0x1, 
	0xf, 0x23, 0x24, 0x9, 0x12, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x25, 0x1f, 
	0x11, 0x1d, 0x1c, 0x13, 0x26, 0x27, 0x0, 0x0, 
	0x9, 0x9, 0x16, 0x0, 0x28, 0x26, 0x9, 0x29, 
	0x0, 0x2a, 0x9, 0x2b, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2c, 0x2d, 0x2e, 0x1d, 0x23, 0x1f, 0x0, 
	0x0, 0x0, 0xf, 0x9, 0x2f, 0x0, 0x0, 0x30, 
	0x9, 0x31, 0x32, 0x33, 0x34, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x35, 0x2d, 0x36, 
	0x0, 0x0, 0x0, 0x37, 0x9, 0x38, 0x1, 0x0, 
	0x9, 0x9, 0x16, 0x39, 0x4, 0x9, 0x3a, 0x36, 
	0x0, 0x3b, 0x9, 0x3, 0x1, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x26, 0x31, 
	0x0, 0x0, 0x38, 0x9, 0x3c, 0x0, 0x0, 0x23, 
	0x2e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x9, 0x9, 0x9, 0x9, 0x9, 0x9, 0x9, 
	0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x3d, 0x9, 0x9, 0x3e, 0x0, 
	0x9, 0x9, 0x16, 0x3f, 0x9, 0x9, 0x40, 0x0, 
	0x0, 0x0, 0x33, 0x2e, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0x37, 
	0x0, 0x0, 0x38, 0x9, 0x41, 0x0, 0x39, 0x42, 
	0x43, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x2c, 0x26, 0x9, 0x23, 0x0, 
	0x9, 0x9, 0x16, 0x23, 0x9, 0x9, 0x3f, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x44, 
	0x44, 0x45, 0x1a, 0x9, 0x46, 0x1c, 0x47, 0x3e, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x9, 0x9, 0x9, 
	0x9, 0x9, 0x9, 0x9, 0x9, 0x9, 0x48, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x31, 0x7, 0x49, 
	0x35, 0x0, 0x38, 0x9, 0x4a, 0x2c, 0x4b, 0x49, 
	0x4c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x36, 0x9, 0x9, 0x4d, 0x0, 
	0x9, 0x9, 0x16, 0x4e, 0x9, 0x9, 0x4f, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xf, 0x9, 0x50, 
	0x0, 0x0, 0x38, 0x9, 0x41, 0x0, 0x0, 0x51, 
	0x9, 0x44, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x9, 0x9, 0x9, 0x9, 0x9, 0x9, 0x9, 
	0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2c, 
	0x0, 0x0, 0x0, 0x52, 0x9, 0x9, 0x47, 0x0, 
	0x9, 0x9, 0x16, 0x3f, 0x9, 0x9, 0x53, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x54, 0x9, 0x55, 0x0, 
	0x0, 0x0, 0x38, 0x9, 0x3c, 0x0, 0x0, 0x27, 
	0x9, 0x9, 0x3d, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2d, 0x56, 
	0x57, 0x0, 0x0, 0x58, 0x9, 0x9, 0x32, 0x0, 
	0x9, 0x9, 0x16, 0x4f, 0x26, 0x9, 0x59, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x5a, 0x50, 0x0, 0x57, 0x5b, 0x9, 0x22, 0x0, 
	0x0, 0x0, 0xf, 0x9, 0x4e, 0x0, 0x0, 0x5c, 
	0x9, 0x9, 0x54, 0x0, 0x1, 0x59, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5d, 0x9, 
	0x5e, 0x0, 0x0, 0x5f, 0x9, 0xe, 0x60, 0x0, 
	0x9, 0x9, 0x16, 0x0, 0x2d, 0x9, 0x47, 0x0, 
	0x0, 0x0, 0x1, 0x61, 0x62, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x63, 0x64, 0x11, 0x65, 0x9, 0x9, 0x66, 0x0, 
	0x0, 0x36, 0x3, 0x9, 0x25, 0x0, 0x0, 0x0, 
	0x42, 0x9, 0x13, 0x34, 0x67, 0x68, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x59, 0x9, 
	0x2b, 0x0, 0x62, 0x9, 0x9, 0x69, 0x0, 0x0, 
	0x9, 0x9, 0x16, 0x0, 0x60, 0x1a, 0x9, 0x41, 
	0x1d, 0x15, 0x6a, 0x6b, 0x36, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1d, 0x6c, 0x56, 0x3, 0x25, 0x2c, 0x0, 
	0x6d, 0x1f, 0x9, 0x9, 0x6e, 0x46, 0x5, 0x0, 
	0x6f, 0x70, 0x6e, 0xf, 0x37, 0x2c, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 
	0xd, 0x71, 0x72, 0x14, 0x73, 0x0, 0x0, 0x0, 
	0x9, 0x9, 0x16, 0x0, 0x0, 0x74, 0x47, 0x24, 
	0xe, 0x75, 0x66, 0x6, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0
};

static GClut u436Italic_clut = { 118, 1, 0,
  { 0xffffff, 0xfefefe, 0x5d5d5d, 0xa0a0a0, 0x111111, 0x6f6f6f, 0xfcfcfc, 0x626262, 
    0x232323, 0x000000, 0x494949, 0x666666, 0xd0d0d0, 0x373737, 0x404040, 0x1f1f1f, 
    0xb2b2b2, 0xadadad, 0x3f3f3f, 0x707070, 0x3a3a3a, 0xbbbbbb, 0xd9d9d9, 0xc2c2c2, 
    0x474747, 0xd0d0d0, 0x141414, 0x2d2d2d, 0x969696, 0xd3d3d3, 0x5a5a5a, 0x2f2f2f, 
    0x898989, 0xf0f0f0, 0x575757, 0x7a7a7a, 0xf0f0f0, 0x606060, 0x101010, 0xb5b5b5, 
    0xaaaaaa, 0x737373, 0xa3a3a3, 0x7c7c7c, 0xfbfbfb, 0x525252, 0x3d3d3d, 0x7f7f7f, 
    0xc3c3c3, 0xe8e8e8, 0x858585, 0x343434, 0xa0a0a0, 0xc6c6c6, 0xf8f8f8, 0x797979, 
    0x202020, 0xf5f5f5, 0x131313, 0xf6f6f6, 0x838383, 0xcbcbcb, 0xbcbcbc, 0xa9a9a9, 
    0x696969, 0x868686, 0x222222, 0xcccccc, 0x727272, 0x9c9c9c, 0x535353, 0x555555, 
    0xd6d6d6, 0x2a2a2a, 0x888888, 0x767676, 0x989898, 0x464646, 0x828282, 0xe9e9e9, 
    0xbdbdbd, 0x4f4f4f, 0xcdcdcd, 0xd8d8d8, 0x5f5f5f, 0x242424, 0x101010, 0xeeeeee, 
    0x8d8d8d, 0xa6a6a6, 0xe6e6e6, 0x606060, 0xebebeb, 0x323232, 0xcfcfcf, 0x303030, 
    0xe0e0e0, 0x656565, 0x999999, 0xececec, 0x272727, 0x595959, 0x909090, 0x757575, 
    0x6c6c6c, 0x8c8c8c, 0x404040, 0x424242, 0x4c4c4c, 0x6a6a6a, 0x303030, 0xc8c8c8, 
    0x292929, 0x171717, 0x909090, 0xb0b0b0, 0xdddddd, 0x2c2c2c } };

static struct _GImage u436Italic_base = {
    it_index,
    15420,68,24,68,
    (uint8 *) u436Italic_data,
    &u436Italic_clut,
    0
};

static uint8 u438Italic_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x2, 0x3, 0x3, 0x3, 0x4, 
	0x5, 0x0, 0x0, 0x1, 0x2, 0x3, 0x3, 0x3, 
	0x6, 0x5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x7, 0x8, 0x9, 0xa, 0xb, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0x3, 0x3, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0xc, 0x3, 0x3, 0xd, 0xe, 
	0x0, 0x0, 0x0, 0x0, 0xc, 0x3, 0x3, 0xf, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x10, 0x11, 0x3, 0x3, 0xb, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0x3, 0x3, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x12, 0x3, 0x3, 0x13, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x14, 0x3, 0x3, 0x15, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x16, 0x3, 0x3, 0xb, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0x3, 0x3, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0xb, 0x0, 
	0x0, 0x0, 0x0, 0x17, 0x18, 0x3, 0x3, 0xb, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0xb, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0x3, 0x3, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0xb, 0x0, 
	0x0, 0x12, 0x19, 0x1a, 0x6, 0x3, 0x3, 0xb, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0xb, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0x3, 0x3, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0xb, 0x0, 
	0x1b, 0x1c, 0x3, 0x8, 0x1d, 0x3, 0x3, 0xb, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0xb, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0x3, 0x3, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0x13, 0x1e, 
	0x1f, 0x20, 0x21, 0x0, 0x0, 0x3, 0x3, 0xb, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0xb, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0x3, 0x3, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0x6, 0x3, 
	0x22, 0x23, 0x0, 0x0, 0x0, 0x3, 0x3, 0xb, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0xb, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0x3, 0x3, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0x24, 0x25, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0xb, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0x26, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x13, 0x3, 0x3, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x12, 0x3, 0x3, 0x1b, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x12, 0x3, 0x3, 0x27, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x28, 0x3, 0x29, 
	0x0, 0x0, 0x0, 0x0, 0x29, 0x2a, 0x3, 0x3, 
	0x2b, 0x0, 0xe, 0x2c, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x21, 0x3, 0x3, 0x2d, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2e, 0x3, 0x3, 0x2f, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x30, 0x3, 0x31, 
	0x32, 0x33, 0x34, 0x5, 0x35, 0x36, 0x37, 0x3, 
	0x38, 0x29, 0x39, 0x3a, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x2, 0x3, 0x3, 0x3, 0x6, 
	0x5, 0x0, 0x0, 0x3b, 0x2, 0x3, 0x3, 0x3, 
	0x3c, 0x5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x3d, 0x3e, 0x3f, 
	0x3, 0x4, 0x39, 0x33, 0x0, 0x0, 0x40, 0x11, 
	0x1f, 0x41, 0x42, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0
};

static GClut u438Italic_clut = { 67, 1, 0,
  { 0xffffff, 0x333333, 0x404040, 0x000000, 0x161616, 0x373737, 0x171717, 0x7c7c7c, 
    0x5c5c5c, 0x2c2c2c, 0x101010, 0xd9d9d9, 0xb3b3b3, 0x6f6f6f, 0xfefefe, 0x707070, 
    0xaaaaaa, 0x3d3d3d, 0xfbfbfb, 0xd0d0d0, 0xf8f8f8, 0xd2d2d2, 0xe8e8e8, 0xd5d5d5, 
    0x363636, 0x828282, 0x606060, 0xcdcdcd, 0x2f2f2f, 0xeeeeee, 0x777777, 0x303030, 
    0x1c1c1c, 0xb6b6b6, 0x676767, 0xf2f2f2, 0x232323, 0xc0c0c0, 0xd8d8d8, 0xd3d3d3, 
    0xf0f0f0, 0xb0b0b0, 0x242424, 0xe5e5e5, 0xe6e6e6, 0x727272, 0xb8b8b8, 0x737373, 
    0x5f5f5f, 0x1a1a1a, 0x9a9a9a, 0xb5b5b5, 0x8f8f8f, 0x3c3c3c, 0xdcdcdc, 0x2a2a2a, 
    0x3f3f3f, 0x525252, 0x888888, 0x343434, 0x191919, 0xf5f5f5, 0x666666, 0x111111, 
    0xdddddd, 0x1f1f1f, 0x959595 } };

static struct _GImage u438Italic_base = {
    it_index,
    15420,68,24,68,
    (uint8 *) u438Italic_data,
    &u438Italic_clut,
    0
};

static uint8 u43cItalic_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x2, 0x3, 0x3, 0x3, 0x4, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 
	0x3, 0x3, 0x3, 0x6, 0x7, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 
	0x3, 0x3, 0x3, 0x9, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0xa, 0x3, 0x3, 0xb, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0xc, 0x3, 0xd, 0x3, 0xe, 0xf, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 
	0x11, 0x3, 0x3, 0x12, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x13, 0x3, 0x14, 0x3, 0x15, 0x0, 0x0, 0x0, 
	0x16, 0x14, 0x3, 0x3, 0xb, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x17, 0x3, 0x18, 0x3, 0x3, 0x19, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1a, 0x3, 
	0x1b, 0x3, 0x3, 0x17, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x17, 0x3, 0x1c, 0x3, 0x1d, 0x0, 0x0, 0x0, 
	0x1e, 0x1f, 0x3, 0x3, 0xb, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0xb, 0x3, 0x0, 0x20, 0x3, 0x21, 
	0x22, 0x0, 0x0, 0x0, 0x0, 0x23, 0x24, 0x1c, 
	0x0, 0x3, 0x3, 0xb, 0x0, 0x0, 0x0, 0x0, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0xb, 0x3, 0x25, 0x3, 0xd, 0x0, 0x0, 0x0, 
	0x26, 0x4, 0x3, 0x3, 0xb, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0xb, 0x3, 0x0, 0x27, 0x3, 0x3, 
	0x28, 0x0, 0x0, 0x0, 0x0, 0x29, 0x2a, 0x2b, 
	0x0, 0x3, 0x3, 0xb, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0xb, 0x3, 0x22, 0x2c, 0x2d, 0x2e, 0x0, 0x2f, 
	0x30, 0x31, 0x3, 0x3, 0xb, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0xb, 0x3, 0x0, 0x0, 0x1c, 0x3, 
	0x32, 0x33, 0x0, 0x0, 0x34, 0x35, 0x36, 0x0, 
	0x0, 0x3, 0x3, 0xb, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0xb, 0x3, 0x0, 0x37, 0x3, 0x38, 0x0, 0x38, 
	0x39, 0x0, 0x3, 0x3, 0xb, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0xb, 0x3, 0x0, 0x0, 0x16, 0x3, 
	0x3, 0x36, 0x0, 0x0, 0x3a, 0x3b, 0x3c, 0x0, 
	0x0, 0x3, 0x3, 0xb, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0xb, 0x3, 0x0, 0x3d, 0x3, 0x3e, 0x0, 0x3f, 
	0x40, 0x0, 0x3, 0x3, 0xb, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0xb, 0x3, 0x0, 0x0, 0x0, 0x41, 
	0x3, 0x35, 0x2e, 0x27, 0x3, 0x13, 0x0, 0x0, 
	0x0, 0x3, 0x3, 0xb, 0x0, 0x0, 0x0, 0x0, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0xb, 0x2d, 0x0, 0x42, 0x43, 0x30, 0x2f, 0x2c, 
	0x15, 0x0, 0x3, 0x3, 0xb, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0xb, 0x3, 0x0, 0x0, 0x0, 0x17, 
	0x44, 0x3, 0x45, 0x46, 0x26, 0x0, 0x0, 0x0, 
	0x0, 0x3, 0x3, 0xb, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x47, 0x48, 0x0, 0x0, 0x49, 0x3, 0x37, 0x9, 
	0x0, 0x0, 0x3, 0x3, 0x17, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x17, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x4a, 0x3, 0x3, 0x3, 0x5, 0x0, 0x0, 0x0, 
	0x0, 0x3, 0x3, 0x17, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x4b, 0x4c, 0x4d, 0x4e, 
	0x25, 0x4f, 0x0, 0x0, 0x50, 0x3, 0x3, 0x29, 
	0x0, 0x0, 0x3, 0x3, 0x51, 0x0, 0x0, 0x2e, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x52, 0x3, 0x53, 0x0, 0x0, 0x0, 
	0x15, 0x30, 0x3, 0x3a, 0x0, 0x0, 0x0, 0x0, 
	0x53, 0x3, 0x3, 0x12, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x16, 0x3, 0x3, 0x54, 
	0x55, 0x56, 0x0, 0x0, 0xf, 0x32, 0x3, 0x16, 
	0x0, 0x0, 0x4c, 0x3, 0x57, 0x3d, 0x58, 0x37, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x7, 0x6, 0x3, 0xe, 0x59, 0x51, 0x0, 
	0x0, 0x45, 0x35, 0x34, 0x0, 0x0, 0x15, 0x59, 
	0xe, 0x3, 0x3, 0x5a, 0x7, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x5b, 0x35, 0x2c, 
	0x4a, 0x5c, 0x0, 0x0, 0x0, 0x4a, 0x5d, 0x0, 
	0x0, 0x0, 0x17, 0x5e, 0x30, 0x6, 0x5f, 0x42, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0
};

static GClut u43cItalic_clut = { 96, 1, 0,
  { 0xffffff, 0x5d5d5d, 0x111111, 0x000000, 0x9d9d9d, 0xc6c6c6, 0x131313, 0x5f5f5f, 
    0x636363, 0x2f2f2f, 0x1d1d1d, 0xd9d9d9, 0xb5b5b5, 0x3c3c3c, 0x1f1f1f, 0xf9f9f9, 
    0x363636, 0x2a2a2a, 0xb8b8b8, 0xa0a0a0, 0x707070, 0xdfdfdf, 0xd0d0d0, 0xd8d8d8, 
    0xc0c0c0, 0x909090, 0xa3a3a3, 0xbcbcbc, 0x4f4f4f, 0x8d8d8d, 0x828282, 0x4d4d4d, 
    0x444444, 0x161616, 0xf5f5f5, 0xf6f6f6, 0x1a1a1a, 0xa6a6a6, 0x343434, 0xc9c9c9, 
    0x858585, 0x7f7f7f, 0x606060, 0xdcdcdc, 0x909090, 0x101010, 0xe8e8e8, 0xe6e6e6, 
    0x404040, 0xebebeb, 0xf0f0f0, 0xeeeeee, 0xe3e3e3, 0xa0a0a0, 0x777777, 0x555555, 
    0x999999, 0x3f3f3f, 0x5c5c5c, 0x171717, 0xf3f3f3, 0xacacac, 0x474747, 0x4c4c4c, 
    0x8f8f8f, 0x575757, 0xf8f8f8, 0xc0c0c0, 0x303030, 0x696969, 0x393939, 0xd2d2d2, 
    0x101010, 0x5a5a5a, 0x606060, 0xf0f0f0, 0x292929, 0x242424, 0xe0e0e0, 0x3d3d3d, 
    0xb2b2b2, 0xbdbdbd, 0xb3b3b3, 0xdddddd, 0x595959, 0x2d2d2d, 0x989898, 0x272727, 
    0x6c6c6c, 0x656565, 0x141414, 0x626262, 0xfcfcfc, 0x202020, 0x424242, 0x727272 } };

static struct _GImage u43cItalic_base = {
    it_index,
    15420,68,24,68,
    (uint8 *) u43cItalic_data,
    &u43cItalic_clut,
    0
};

static uint8 u43fItalic_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x2, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 
	0x4, 0xa, 0xb, 0x7, 0xc, 0x5, 0xd, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0xe, 0x3, 0x3, 0xf, 0xf, 
	0xf, 0xf, 0xf, 0xf, 0x3, 0x3, 0x10, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x11, 0x12, 0x3, 0x3, 0x13, 0x14, 
	0x15, 0x16, 0x17, 0x18, 0x2, 0x3, 0xf, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x19, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0x1a, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1b, 0x3, 0x3, 0x1c, 0x8, 
	0x0, 0x0, 0x0, 0x0, 0x1d, 0x3, 0x1e, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0x8, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0x1f, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1f, 0x3, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0x8, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0x8, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0x8, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0x8, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0x8, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0x8, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0x8, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0x8, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0x8, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0x8, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x20, 0x3, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x21, 0x3, 0x3, 0x22, 0x0, 
	0x0, 0x0, 0x0, 0x23, 0x3, 0x3, 0x19, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0x8, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x24, 0x3, 0x3, 0x25, 
	0x0, 0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x26, 0x3, 0x3, 0x27, 0x0, 
	0x0, 0x0, 0x0, 0x27, 0x3, 0x3, 0x28, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0x8, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x29, 0x3, 0x2a, 
	0x2b, 0x6, 0x2c, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x2d, 0x3, 0x3, 0x3, 0x2e, 0x2f, 
	0x0, 0x0, 0x2f, 0x2e, 0x3, 0x3, 0x3, 0x2, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0x8, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x30, 0x31, 0x32, 
	0x2d, 0x33, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0
};

static GClut u43fItalic_clut = { 52, 1, 0,
  { 0xffffff, 0xcbcbcb, 0x2a2a2a, 0x000000, 0x9c9c9c, 0x767676, 0x373737, 0x101010, 
    0xd9d9d9, 0xf9f9f9, 0x434343, 0x111111, 0x1d1d1d, 0xf8f8f8, 0x929292, 0x656565, 
    0x959595, 0x727272, 0x1a1a1a, 0x909090, 0x262626, 0x626262, 0xb5b5b5, 0xd5d5d5, 
    0xb3b3b3, 0xd3d3d3, 0xd6d6d6, 0xdddddd, 0x363636, 0xc3c3c3, 0xf0f0f0, 0xd8d8d8, 
    0xdbdbdb, 0xd2d2d2, 0xfcfcfc, 0xfbfbfb, 0xeeeeee, 0xe3e3e3, 0x888888, 0xb6b6b6, 
    0x8c8c8c, 0x393939, 0x444444, 0xafafaf, 0xd0d0d0, 0x292929, 0x404040, 0x333333, 
    0xe2e2e2, 0x3f3f3f, 0x303030, 0xadadad } };

static struct _GImage u43fItalic_base = {
    it_index,
    15420,68,24,68,
    (uint8 *) u43fItalic_data,
    &u43fItalic_clut,
    0
};

static uint8 u442Italic_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x2, 0x2, 0x2, 0x3, 
	0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x4, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 
	0xd, 0xe, 0xf, 0x10, 0x0, 0x11, 0x12, 0xe, 
	0x8, 0x13, 0x14, 0x15, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x0, 
	0x2, 0x2, 0x9, 0x15, 0x1b, 0x1c, 0x3, 0x1a, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x14, 0x1d, 0x2, 0x2, 0x7, 0x1e, 0x1f, 0x20, 
	0x21, 0x22, 0x2, 0x23, 0x24, 0x25, 0x26, 0x27, 
	0x28, 0x29, 0x2, 0x2a, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2b, 0x2c, 0x2d, 0x0, 0x0, 0x0, 
	0x2, 0x2, 0x9, 0x0, 0x0, 0x2e, 0x23, 0x2f, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x30, 0x2, 0x2, 0x31, 0x0, 0x0, 0x0, 
	0x0, 0x30, 0x2, 0x2, 0x32, 0x0, 0x0, 0x0, 
	0x0, 0x33, 0x2, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x34, 0x35, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x2, 0x9, 0x0, 0x0, 0x0, 0x36, 0x14, 
	0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x2, 0x2, 0x9, 0x0, 0x0, 0x0, 
	0x0, 0x2d, 0x2, 0x2, 0x9, 0x0, 0x0, 0x0, 
	0x0, 0x37, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x2, 0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x2, 0x2, 0x9, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x2, 0x2, 0x9, 0x0, 0x0, 0x0, 
	0x0, 0x9, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x2, 0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x2, 0x2, 0x9, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x2, 0x2, 0x9, 0x0, 0x0, 0x0, 
	0x0, 0x9, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x2, 0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x2, 0x2, 0x9, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x2, 0x2, 0x9, 0x0, 0x0, 0x0, 
	0x0, 0x9, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x2, 0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x2, 0x2, 0x9, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x2, 0x2, 0x9, 0x0, 0x0, 0x0, 
	0x0, 0x9, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x2, 0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x2, 0x2, 0x9, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x2, 0x2, 0x9, 0x0, 0x0, 0x0, 
	0x0, 0x9, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x38, 
	0x2, 0x2, 0x39, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x2, 0x2, 0x9, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x2, 0x2, 0x9, 0x0, 0x0, 0x0, 
	0x0, 0x35, 0x2, 0x2, 0x10, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x28, 
	0x2, 0x2, 0x2b, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x2, 0x2, 0x9, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x2, 0x2, 0x9, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3a, 0x2, 0x3b, 0x3c, 0x3d, 0x30, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x16, 0x3e, 0xd, 
	0x2, 0x2, 0x2, 0x3f, 0x40, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x2, 0x2, 0x9, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x2, 0x2, 0x9, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x30, 0x1e, 0xd, 0x41, 0x42, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0
};

static GClut u442Italic_clut = { 67, 1, 0,
  { 0xffffff, 0x4c4c4c, 0x000000, 0xa0a0a0, 0x606060, 0x9c9c9c, 0x767676, 0x373737, 
    0x101010, 0xd9d9d9, 0xc0c0c0, 0x595959, 0x191919, 0x303030, 0x141414, 0x636363, 
    0xeeeeee, 0xb6b6b6, 0x4d4d4d, 0x1c1c1c, 0x727272, 0xf8f8f8, 0xe8e8e8, 0x404040, 
    0x3f3f3f, 0xbbbbbb, 0xf5f5f5, 0xb9b9b9, 0x363636, 0x1a1a1a, 0x393939, 0x9d9d9d, 
    0xd0d0d0, 0xbfbfbf, 0x3a3a3a, 0x3c3c3c, 0x555555, 0x3d3d3d, 0xa5a5a5, 0xd3d3d3, 
    0xb0b0b0, 0x222222, 0x5f5f5f, 0x8c8c8c, 0x4a4a4a, 0xfefefe, 0xf9f9f9, 0x9f9f9f, 
    0xdddddd, 0x969696, 0x989898, 0xb3b3b3, 0x666666, 0xe3e3e3, 0xd8d8d8, 0xd6d6d6, 
    0xfbfbfb, 0xd5d5d5, 0x333333, 0x505050, 0xb2b2b2, 0x525252, 0x303030, 0x2a2a2a, 
    0xcdcdcd, 0x272727, 0xa3a3a3 } };

static struct _GImage u442Italic_base = {
    it_index,
    15420,68,24,68,
    (uint8 *) u442Italic_data,
    &u442Italic_clut,
    0
};

static uint8 u444Italic_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x2, 0x3, 0x4, 0x5, 0x6, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 
	0x8, 0x6, 0x9, 0xa, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xc, 
	0xd, 0xe, 0xf, 0x10, 0x11, 0x12, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x13, 0x14, 
	0x10, 0x10, 0x10, 0x15, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x16, 0x10, 
	0xa, 0x0, 0x17, 0x18, 0x19, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1a, 0x10, 0x10, 0x15, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1b, 0x1c, 0x10, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x12, 0x10, 0x10, 0x15, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1d, 0x10, 0x10, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x10, 0x10, 0x15, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x15, 0x10, 0x10, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1e, 0x1f, 0x20, 0x11, 0x21, 0x22, 
	0x0, 0x10, 0x10, 0x15, 0x23, 0x24, 0x11, 0x4, 
	0x5, 0x25, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1b, 0x26, 
	0x27, 0x4, 0x28, 0x1f, 0x29, 0x1, 0x10, 0x10, 
	0x0, 0x8, 0x2a, 0x2b, 0x4, 0x2c, 0x22, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2d, 0x10, 0x2e, 0x1e, 0x2f, 0x30, 0x31, 
	0x32, 0x10, 0x10, 0x33, 0x2, 0x34, 0x8, 0x35, 
	0x36, 0x10, 0x37, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0x38, 0x10, 
	0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x27, 0x10, 0x10, 
	0x3e, 0x3f, 0x40, 0x41, 0x3c, 0x42, 0x10, 0x19, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x43, 0x10, 0x2b, 0x8, 0x0, 0x0, 0x0, 0x0, 
	0x44, 0x10, 0x10, 0x45, 0x0, 0x0, 0x0, 0x0, 
	0x46, 0x47, 0x10, 0x48, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x12, 0x49, 0x10, 0x1f, 
	0x4a, 0x0, 0x0, 0x0, 0x0, 0x1e, 0x10, 0x10, 
	0x32, 0x4b, 0x0, 0x0, 0x0, 0x4c, 0x2e, 0x10, 
	0x23, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x4d, 0x10, 0x4e, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x10, 0x10, 0x15, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x4f, 0x10, 0x4d, 0x0, 0x0, 0x0, 0x10, 
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x50, 0x10, 0x10, 0x51, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x10, 0x10, 
	0x4d, 0x0, 0x0, 0x0, 0x0, 0x0, 0x52, 0x10, 
	0x16, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x53, 0x10, 0xb, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x10, 0x10, 0x15, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x3b, 0x10, 0x4, 0x12, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 
	0x0, 0x0, 0x0, 0x0, 0x4d, 0x10, 0x54, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x3b, 0x10, 0x10, 
	0x4b, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1a, 0x10, 
	0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x10, 0x10, 0x4c, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x10, 0x10, 0x15, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0xe, 0x10, 0x10, 0x1d, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x10, 0x0, 0x0, 0x0, 0x55, 0x10, 0x56, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x57, 0x10, 0x10, 
	0x58, 0x0, 0x0, 0x0, 0x0, 0x0, 0x23, 0x10, 
	0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x10, 0x10, 0x7, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x10, 0x10, 0x15, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x17, 0x10, 0x10, 0x2f, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 
	0x0, 0x0, 0x0, 0x0, 0x59, 0x10, 0x5a, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x5b, 0x10, 0x10, 
	0x12, 0x0, 0x0, 0x0, 0x0, 0x0, 0x29, 0x10, 
	0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x20, 0x10, 0x2f, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x10, 0x10, 0x15, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1d, 0x10, 0x28, 0x17, 0x0, 0x0, 0x10, 
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x5c, 0x10, 0x5d, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0x10, 0x10, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x19, 0x10, 
	0x14, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x5e, 0x10, 0x5f, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x10, 0x10, 0x15, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x60, 0x10, 0x56, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x61, 0x10, 0x62, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x63, 0x64, 0x10, 0x10, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x12, 0x3f, 0x10, 
	0x61, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x34, 0x1c, 0x65, 0x46, 0x0, 0x0, 0x0, 0x0, 
	0x46, 0x10, 0x10, 0x3c, 0x0, 0x0, 0x0, 0x0, 
	0x66, 0x55, 0x1c, 0x67, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x11, 0x10, 0x5b, 
	0x0, 0x0, 0x0, 0x12, 0x68, 0x2a, 0x10, 0x10, 
	0x58, 0x0, 0x0, 0x0, 0x0, 0x40, 0x10, 0x2b, 
	0x69, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x44, 0x10, 0x62, 0x1e, 0x2f, 0x6a, 0x26, 
	0x14, 0x10, 0x10, 0x47, 0x6b, 0x30, 0x2f, 0x6c, 
	0x36, 0x10, 0x6d, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x6c, 0x53, 0x4, 
	0x6e, 0x23, 0x6f, 0x70, 0x4d, 0x3b, 0x10, 0x10, 
	0x71, 0x61, 0x35, 0x1e, 0x68, 0x10, 0x72, 0x6, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x73, 0x16, 0x11, 0x74, 0x62, 0x37, 
	0x2f, 0x10, 0x10, 0x75, 0x6e, 0x76, 0x53, 0x28, 
	0x77, 0x78, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x79, 0x2, 
	0x64, 0x53, 0x49, 0x44, 0x17, 0x1, 0x10, 0x10, 
	0x1b, 0x7a, 0x36, 0x74, 0x47, 0x7b, 0x13, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x10, 0x10, 0x15, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x7c, 0x10, 0x20, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x10, 0x10, 0x15, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x6a, 0x10, 0x2e, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x10, 0x10, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 
	0x41, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x10, 0x56, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x7d, 0x10, 0x10, 0x7e, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x32, 
	0x10, 0x32, 0x7, 0x0, 0x0, 0x7f, 0x10, 0x80, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0x6f, 
	0x71, 0x10, 0x10, 0x38, 0x81, 0x46, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x60, 
	0x10, 0x10, 0x32, 0x63, 0x6a, 0x47, 0x82, 0x7, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x83, 0x84, 
	0x84, 0x84, 0x84, 0x84, 0x84, 0x2f, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x22, 0x71, 0x28, 0x53, 0x27, 0x44, 0x17, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0
};

static GClut u444Italic_clut = { 133, 1, 0,
  { 0xffffff, 0xd8d8d8, 0x525252, 0xf0f0f0, 0x606060, 0x363636, 0xbdbdbd, 0xfefefe, 
    0xe3e3e3, 0x989898, 0xf0f0f0, 0xd2d2d2, 0xd0d0d0, 0x898989, 0xf8f8f8, 0x696969, 
    0x000000, 0xa0a0a0, 0xfbfbfb, 0xdcdcdc, 0x1f1f1f, 0xd9d9d9, 0x424242, 0xfcfcfc, 
    0x7a7a7a, 0x6f6f6f, 0xaaaaaa, 0xf5f5f5, 0x101010, 0xdddddd, 0xa9a9a9, 0x393939, 
    0x707070, 0x3a3a3a, 0xa3a3a3, 0xb3b3b3, 0x404040, 0xa5a5a5, 0x868686, 0x2f2f2f, 
    0x909090, 0xa0a0a0, 0x5c5c5c, 0x111111, 0x343434, 0x707070, 0x202020, 0xe0e0e0, 
    0xcdcdcd, 0x656565, 0x595959, 0x555555, 0xc8c8c8, 0xb0b0b0, 0x242424, 0x6c6c6c, 
    0x262626, 0x333333, 0xacacac, 0xd3d3d3, 0xc0c0c0, 0x666666, 0xe5e5e5, 0x1c1c1c, 
    0x727272, 0xcbcbcb, 0x3d3d3d, 0xb8b8b8, 0x909090, 0x6d6d6d, 0xe8e8e8, 0x141414, 
    0xb6b6b6, 0x2d2d2d, 0xf9f9f9, 0x9d9d9d, 0xf6f6f6, 0x444444, 0x858585, 0x888888, 
    0x999999, 0xc5c5c5, 0x808080, 0x404040, 0x1d1d1d, 0x191919, 0x4f4f4f, 0xc6c6c6, 
    0xdbdbdb, 0x131313, 0x606060, 0xa8a8a8, 0x303030, 0x535353, 0x4d4d4d, 0x939393, 
    0x929292, 0x757575, 0x222222, 0xeeeeee, 0x101010, 0x171717, 0xebebeb, 0xc9c9c9, 
    0x4c4c4c, 0xe9e9e9, 0xd0d0d0, 0x797979, 0xadadad, 0x8d8d8d, 0x777777, 0x9c9c9c, 
    0x323232, 0x373737, 0xc0c0c0, 0xbcbcbc, 0x303030, 0xc3c3c3, 0x272727, 0x3f3f3f, 
    0xb9b9b9, 0xcfcfcf, 0x7f7f7f, 0x5f5f5f, 0xd6d6d6, 0xdfdfdf, 0xbbbbbb, 0x8c8c8c, 
    0xa2a2a2, 0x969696, 0x4a4a4a, 0xececec, 0x959595 } };

static struct _GImage u444Italic_base = {
    it_index,
    15420,68,24,68,
    (uint8 *) u444Italic_data,
    &u444Italic_clut,
    0
};

static uint8 u446Italic_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x6, 0x6, 0x5, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x7, 0x8, 0x6, 0x6, 0x6, 0x4, 0x9, 
	0xa, 0xb, 0xc, 0x6, 0x6, 0x6, 0xd, 0xe, 
	0xf, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x10, 0x11, 0x6, 0x6, 0x5, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x6, 0x6, 0x5, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x12, 0x6, 0x6, 0x13, 0x0, 
	0x0, 0x0, 0x0, 0x14, 0x6, 0x6, 0x15, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x16, 0x6, 0x6, 0x5, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x6, 0x6, 0x5, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x17, 0x6, 0x6, 0x18, 0x0, 
	0x0, 0x0, 0x0, 0x17, 0x6, 0x6, 0x19, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x6, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x6, 0x6, 0x5, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x6, 0x6, 0x5, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x5, 0x6, 0x6, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x5, 0x6, 0x6, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x6, 0x6, 0x6, 0x6, 
	0x6, 0x6, 0x6, 0x6, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x6, 0x6, 0x5, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x6, 0x6, 0x5, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x5, 0x6, 0x6, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x5, 0x6, 0x6, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x6, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x6, 0x6, 0x5, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x6, 0x6, 0x5, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x5, 0x6, 0x6, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x5, 0x6, 0x6, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x6, 0x6, 0x5, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x6, 0x6, 0x5, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x5, 0x6, 0x6, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x5, 0x6, 0x6, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x6, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x6, 0x6, 0x5, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x6, 0x6, 0x5, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x5, 0x6, 0x6, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x5, 0x6, 0x6, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x6, 0x6, 0x6, 0x6, 
	0x6, 0x6, 0x6, 0x6, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x6, 0x6, 0x1a, 0x0, 0x0, 
	0x0, 0x0, 0x1b, 0x6, 0x6, 0x1a, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x5, 0x6, 0x6, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x5, 0x6, 0x6, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x6, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1c, 0x6, 0x1d, 0x0, 0x0, 
	0x0, 0xa, 0x1e, 0x4, 0x6, 0x1f, 0x0, 0x0, 
	0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x21, 0x6, 0x6, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x5, 0x6, 0x6, 0x22, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x23, 0x6, 0x24, 0x25, 0x26, 
	0x27, 0x28, 0x29, 0x2a, 0x6, 0x2b, 0x26, 0x2c, 
	0x2d, 0x18, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x2e, 0x6, 0x6, 0x2f, 0x2f, 
	0x2f, 0x2f, 0x2f, 0x30, 0x6, 0x6, 0x31, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x32, 0x23, 0x33, 0x34, 0x2b, 
	0x1, 0x35, 0x0, 0x36, 0x30, 0x37, 0x34, 0x6, 
	0x25, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x38, 0x39, 0x3a, 0x6, 0x6, 0x6, 0x6, 
	0x6, 0x6, 0x6, 0x6, 0x6, 0x6, 0xd, 0x28, 
	0x1a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3b, 0x3c, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x3d, 0x3e, 0x6, 
	0x13, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x40, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x41, 
	0x42, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x38, 0x43, 0x44, 0x45, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x46, 
	0x47, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x48, 0x37, 0x2a, 0x1b, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0
};

static GClut u446Italic_clut = { 73, 1, 0,
  { 0xffffff, 0x7c7c7c, 0x5d5d5d, 0x2d2d2d, 0x101010, 0xd9d9d9, 0x000000, 0xcbcbcb, 
    0x292929, 0x2f2f2f, 0xdddddd, 0xbdbdbd, 0x272727, 0x303030, 0x323232, 0xe9e9e9, 
    0xaaaaaa, 0x3f3f3f, 0x868686, 0xadadad, 0x858585, 0xb3b3b3, 0xececec, 0xd2d2d2, 
    0xfbfbfb, 0xfcfcfc, 0xd8d8d8, 0xf9f9f9, 0x161616, 0xb6b6b6, 0x3d3d3d, 0xbbbbbb, 
    0xe8e8e8, 0xd5d5d5, 0xfefefe, 0x626262, 0x232323, 0xa6a6a6, 0xacacac, 0x696969, 
    0x1f1f1f, 0xbcbcbc, 0x565656, 0x262626, 0x6c6c6c, 0x1c1c1c, 0x9f9f9f, 0x656565, 
    0x555555, 0xc0c0c0, 0xf3f3f3, 0xf0f0f0, 0x404040, 0xefefef, 0xf0f0f0, 0x707070, 
    0xd3d3d3, 0x4a4a4a, 0x606060, 0x2c2c2c, 0x606060, 0xeeeeee, 0x828282, 0xa0a0a0, 
    0xc5c5c5, 0x464646, 0x898989, 0xbfbfbf, 0x909090, 0xc2c2c2, 0xb8b8b8, 0x838383, 
    0x404040 } };

static struct _GImage u446Italic_base = {
    it_index,
    15420,68,24,68,
    (uint8 *) u446Italic_data,
    &u446Italic_clut,
    0
};

static uint8 u449Italic_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x2, 0x3, 0x3, 0x3, 0x4, 0x5, 
	0x6, 0x7, 0x8, 0x3, 0x3, 0x3, 0x4, 0x5, 
	0x6, 0x7, 0x8, 0x3, 0x3, 0x3, 0x9, 0xa, 
	0xb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0xc, 0xd, 0xe, 0x4, 0xf, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3, 0x3, 0xf, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0xf, 0x3, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x10, 0x3, 0x3, 0x11, 0x0, 
	0x0, 0x0, 0x0, 0x12, 0x3, 0x3, 0x13, 0x0, 
	0x0, 0x0, 0x0, 0x12, 0x3, 0x3, 0x14, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x15, 0x16, 0x3, 0x3, 0xf, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3, 0x3, 0xf, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0xf, 0x3, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x17, 0x3, 0x3, 0x18, 0x0, 
	0x0, 0x0, 0x0, 0x17, 0x3, 0x3, 0x19, 0x0, 
	0x0, 0x0, 0x0, 0x17, 0x3, 0x3, 0x19, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1a, 0x3, 0x3, 0xf, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3, 0x3, 0xf, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0xf, 0x3, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0xf, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xf, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xf, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3, 0x3, 0xf, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3, 0x3, 0xf, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0xf, 0x3, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0xf, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xf, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xf, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3, 0x3, 0xf, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3, 0x3, 0xf, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0xf, 0x3, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0xf, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xf, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xf, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3, 0x3, 0xf, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3, 0x3, 0xf, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0xf, 0x3, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0xf, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xf, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xf, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3, 0x3, 0xf, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3, 0x3, 0xf, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0xf, 0x3, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0xf, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xf, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xf, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3, 0x3, 0xf, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3, 0x3, 0xf, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0xf, 0x3, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0xf, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xf, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xf, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3, 0x3, 0x1b, 0x0, 0x0, 0x0, 
	0x0, 0x18, 0x3, 0x3, 0x1b, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1c, 0x3, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1d, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xf, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xf, 0x3, 0x3, 0x1e, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1f, 0x3, 0x20, 0x0, 0x0, 0x0, 
	0x21, 0x22, 0x23, 0x3, 0x13, 0x0, 0x0, 0x0, 
	0x0, 0x13, 0x24, 0x3, 0x3, 0x25, 0x0, 0x1e, 
	0x46, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x26, 0x3, 0x3, 0x27, 0x27, 
	0x27, 0x27, 0x27, 0x28, 0x3, 0x3, 0x27, 0x27, 
	0x27, 0x27, 0x27, 0x28, 0x3, 0x3, 0x29, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0xd, 0x3, 0x2a, 0x2b, 0x2c, 0x2d, 
	0x2e, 0x2f, 0x30, 0x3, 0x31, 0x32, 0x33, 0x34, 
	0x35, 0x36, 0x37, 0x38, 0x3, 0x39, 0x13, 0x3a, 
	0x47, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x38, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3b, 0xa, 
	0x1a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3c, 0x3d, 0x1f, 0x9, 0x24, 0x3e, 
	0x3f, 0x0, 0x40, 0x41, 0x2e, 0x3, 0x42, 0x3a, 
	0x33, 0x0, 0x0, 0x43, 0x16, 0x9, 0x44, 0x45, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0
};

static GClut u449Italic_clut = { 72, 1, 0,
  { 0xffffff, 0xcbcbcb, 0x292929, 0x000000, 0x101010, 0x2f2f2f, 0xdbdbdb, 0xbbbbbb, 
    0x272727, 0x303030, 0x323232, 0xe9e9e9, 0x7c7c7c, 0x5c5c5c, 0x2c2c2c, 0xd9d9d9, 
    0x868686, 0xadadad, 0x858585, 0xb0b0b0, 0xb3b3b3, 0xaaaaaa, 0x3d3d3d, 0xd2d2d2, 
    0xfbfbfb, 0xfcfcfc, 0xe8e8e8, 0xd8d8d8, 0xd0d0d0, 0xd3d3d3, 0xfefefe, 0xf0f0f0, 
    0xb8b8b8, 0xc0c0c0, 0x303030, 0x606060, 0x242424, 0xe5e5e5, 0x939393, 0x656565, 
    0x555555, 0xbdbdbd, 0x222222, 0xa5a5a5, 0x9f9f9f, 0x434343, 0x111111, 0xafafaf, 
    0x5d5d5d, 0x1a1a1a, 0x9a9a9a, 0xb5b5b5, 0x8f8f8f, 0x373737, 0x3c3c3c, 0xdcdcdc, 
    0x2a2a2a, 0x3f3f3f, 0x525252, 0x404040, 0xf0f0f0, 0x5f5f5f, 0x777777, 0xebebeb, 
    0xf2f2f2, 0x636363, 0x161616, 0xdddddd, 0x1f1f1f, 0x959595, 0xe6e6e6, 0x888888 } };

static struct _GImage u449Italic_base = {
    it_index,
    15420,68,24,68,
    (uint8 *) u449Italic_data,
    &u449Italic_clut,
    0
};

static uint8 u452Italic_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x2, 0x3, 0x4, 0x5, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x6, 0x7, 0x5, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x8, 0x9, 0xa, 0x7, 0xb, 0x9, 
	0x9, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0xd, 0x7, 0x7, 0x7, 0x7, 0x7, 
	0x7, 0xe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0xa, 0xf, 0x10, 0x7, 0x11, 0xf, 
	0xf, 0x12, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x9, 0x7, 0x5, 0x0, 
	0x13, 0x14, 0x15, 0x16, 0x17, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x9, 0x7, 0x5, 0x18, 
	0x19, 0x1a, 0x1b, 0x7, 0x1c, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0x1d, 
	0x14, 0x1e, 0x7, 0x1f, 0x1e, 0x20, 0x21, 0x22, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x9, 0x7, 0x1f, 0x23, 
	0x0, 0x0, 0x0, 0x24, 0x7, 0x25, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x26, 0x0, 
	0x0, 0x0, 0x7, 0x27, 0x0, 0x0, 0x28, 0x22, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x9, 0x7, 0x5, 0x0, 
	0x0, 0x0, 0x0, 0x29, 0x7, 0x2a, 0x0, 0x0, 
	0x0, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 
	0x7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2a, 0x0, 
	0x0, 0x0, 0x7, 0x27, 0x0, 0x0, 0x0, 0x2b, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x9, 0x7, 0x5, 0x0, 
	0x0, 0x0, 0x0, 0x2c, 0x7, 0x2d, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x7, 0x27, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x9, 0x7, 0x5, 0x0, 
	0x0, 0x0, 0x0, 0x2c, 0x7, 0x2d, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x7, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x7, 0x27, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x9, 0x7, 0x5, 0x0, 
	0x0, 0x0, 0x0, 0x2c, 0x7, 0x2d, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x7, 0x27, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x9, 0x7, 0x5, 0x0, 
	0x0, 0x0, 0x0, 0x2c, 0x7, 0x2d, 0x0, 0x0, 
	0x0, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 
	0x7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x7, 0x27, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x9, 0x7, 0x5, 0x0, 
	0x0, 0x0, 0x0, 0x2c, 0x7, 0x2d, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x7, 0x27, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x2e, 0x7, 0x2f, 0x0, 
	0x0, 0x0, 0x0, 0x2c, 0x7, 0x2d, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x7, 0x14, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x30, 0x31, 0x7, 0x7, 0x29, 
	0x32, 0x0, 0x0, 0x2c, 0x7, 0x2a, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0xa, 0x33, 0x7, 0x7, 0x34, 0x8, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x2c, 0x7, 0x35, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x36, 0x7, 0x25, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xe, 0x15, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x37, 
	0x24, 0x38, 0x0, 0x24, 0x39, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3a, 
	0x7, 0x24, 0x3b, 0xe, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x32, 0x3c, 0x2e, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0
};

static GClut u452Italic_clut = { 61, 1, 0,
  { 0xffffff, 0xbababa, 0xbfbfbf, 0x4f4f4f, 0xa0a0a0, 0x151515, 0xc0c0c0, 0x000000, 
    0xf0f0f0, 0xeaeaea, 0xd5d5d5, 0x131313, 0xf2f2f2, 0x383838, 0x515151, 0xc6c6c6, 
    0xb4b4b4, 0x101010, 0xd9d9d9, 0x8d8d8d, 0x232323, 0x909090, 0x393939, 0xd3d3d3, 
    0x656565, 0x717171, 0xadadad, 0x6c6c6c, 0x1f1f1f, 0xd0d0d0, 0x252525, 0x404040, 
    0x202020, 0x303030, 0x959595, 0xbdbdbd, 0x2f2f2f, 0xc4c4c4, 0x434343, 0x282828, 
    0xc7c7c7, 0x565656, 0xa7a7a7, 0xb7b7b7, 0x595959, 0xa6a6a6, 0xdcdcdc, 0x707070, 
    0xc1c1c1, 0x454545, 0xcacaca, 0x808080, 0x7e7e7e, 0xababab, 0x585858, 0x424242, 
    0xefefef, 0x6a6a6a, 0x494949, 0x5f5f5f, 0xb6b6b6 } };

static struct _GImage u452Italic_base = {
    it_index,
    15420,68,26,68,
    (uint8 *) u452Italic_data,
    &u452Italic_clut,
    0
};

static uint8 u45fItalic_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x2, 0x3, 0x3, 0x3, 0x4, 0x5, 
	0x0, 0x0, 0x5, 0x4, 0x3, 0x3, 0x3, 0x6, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x7, 0x8, 0x9, 0xa, 0xb, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xb, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0xc, 0x3, 0x3, 0xd, 0x0, 
	0x0, 0x0, 0x0, 0xe, 0x3, 0x3, 0xf, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x10, 0x11, 0x3, 0x3, 0xb, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xb, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x12, 0x3, 0x3, 0x13, 0x0, 
	0x0, 0x0, 0x0, 0x13, 0x3, 0x3, 0x14, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x15, 0x3, 0x3, 0xb, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xb, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0xb, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0xb, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x3, 0x3, 0xb, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xb, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0xb, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0xb, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x3, 0x3, 0xb, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xb, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0xb, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0xb, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x3, 0x3, 0xb, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xb, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0xb, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0xb, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x3, 0x3, 0xb, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xb, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0xb, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0xb, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x3, 0x3, 0xb, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xb, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0xb, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0xb, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x3, 0x3, 0x16, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x17, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x14, 0x3, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0x18, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x19, 0x3, 0x1a, 0x0, 0x0, 
	0x0, 0x0, 0x1a, 0x1b, 0x3, 0x3, 0x1c, 0x0, 
	0x1d, 0x1e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1f, 0x3, 0x3, 0x20, 0x20, 
	0x20, 0x20, 0x20, 0x20, 0x3, 0x3, 0x21, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x22, 0x3, 0x23, 0x24, 0xe, 
	0x25, 0x26, 0x27, 0x28, 0x6, 0x3, 0x29, 0x1a, 
	0x2a, 0x2b, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x6, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x9, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x2c, 0x2d, 0x2e, 0x3, 0x2f, 
	0x2a, 0xe, 0x0, 0x0, 0x30, 0x11, 0x31, 0x32, 
	0x33, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0
};

static GClut u45fItalic_clut = { 52, 1, 0,
  { 0xffffff, 0xcbcbcb, 0x292929, 0x000000, 0x404040, 0x343434, 0x2a2a2a, 0x7c7c7c, 
    0x5c5c5c, 0x2c2c2c, 0x101010, 0xd9d9d9, 0x868686, 0xb6b6b6, 0xb5b5b5, 0x8a8a8a, 
    0xaaaaaa, 0x3d3d3d, 0xd2d2d2, 0xfbfbfb, 0xd3d3d3, 0xe8e8e8, 0xd8d8d8, 0xd0d0d0, 
    0xd6d6d6, 0xf0f0f0, 0xb0b0b0, 0x242424, 0xe5e5e5, 0xfefefe, 0xe6e6e6, 0x939393, 
    0x656565, 0x969696, 0x5f5f5f, 0x1a1a1a, 0x9a9a9a, 0x8f8f8f, 0x373737, 0x3c3c3c, 
    0xdcdcdc, 0x3f3f3f, 0x525252, 0x888888, 0xf5f5f5, 0x666666, 0x111111, 0x161616, 
    0xdddddd, 0x303030, 0x1f1f1f, 0x959595 } };

static struct _GImage u45fItalic_base = {
    it_index,
    15420,68,24,68,
    (uint8 *) u45fItalic_data,
    &u45fItalic_clut,
    0
};

GImage GIcon_u45fItalic = { 0, { &u45fItalic_base }, NULL };
GImage GIcon_u452Italic = { 0, { &u452Italic_base }, NULL };
GImage GIcon_u448Italic = { 0, { &u449Italic_base }, NULL };
GImage GIcon_u446Italic = { 0, { &u446Italic_base }, NULL };
GImage GIcon_u444Italic = { 0, { &u444Italic_base }, NULL };
GImage GIcon_u442Italic = { 0, { &u442Italic_base }, NULL };
GImage GIcon_u43fItalic = { 0, { &u43fItalic_base }, NULL };
GImage GIcon_u43cItalic = { 0, { &u43cItalic_base }, NULL };
GImage GIcon_u438Italic = { 0, { &u438Italic_base }, NULL };
GImage GIcon_u436Italic = { 0, { &u436Italic_base }, NULL };
GImage GIcon_u434Italic = { 0, { &u434Italic_base }, NULL };
GImage GIcon_u433Italic = { 0, { &u433Italic_base }, NULL };
GImage GIcon_u432Italic = { 0, { &u432Italic_base }, NULL };
GImage GIcon_zItalic = { 0, { &zItalic_base }, NULL };
GImage GIcon_yItalic = { 0, { &yItalic_base }, NULL };
GImage GIcon_xItalic = { 0, { &xItalic_base }, NULL };
GImage GIcon_wItalic = { 0, { &wItalic_base }, NULL };
GImage GIcon_vItalic = { 0, { &vItalic_base }, NULL };
GImage GIcon_pItalic = { 0, { &pItalic_base }, NULL };
GImage GIcon_kItalic = { 0, { &kItalic_base }, NULL };
GImage GIcon_gItalic = { 0, { &gItalic_base }, NULL };
GImage GIcon_f2Italic = { 0, { &f2Italic_base }, NULL };
GImage GIcon_fItalic = { 0, { &fImage_base }, NULL };
GImage GIcon_aItalic = { 0, { &aItalic_base }, NULL };
GImage GIcon_FlatSerif = { 0, { &FlatSerif_base }, NULL };
GImage GIcon_SlantSerif = { 0, { &SlantSerif_base }, NULL };
GImage GIcon_PenSerif = { 0, { &PenSerif_base }, NULL };
GImage GIcon_TopSerifs = { 0, { &TopSerifs_base }, NULL };
GImage GIcon_BottomSerifs = { 0, { &BottomSerifs0_base }, NULL };
GImage GIcon_DiagSerifs = { 0, { &DiagSerifs_base }, NULL };

void InitToolIconClut(Color bg) {
    if ( bg==0x000000 ) {
	magnify0_clut.clut[0] = 0xffffff;
	corner0_clut.clut[0] = 0xffffff;
	rotate0_clut.clut[2] = 0xffffff;
	pencil0_clut.clut[0] = 0x000000;
	pencil0_clut.clut[1] = 0xffffff;
	smallcurve0_clut.clut[0] = 0xffffff;
	watchpnt_clut.clut[0] = 0xffffff;
	menumark_clut.clut[0] = 0xffffff;
	corner0_clut.clut[0] = 0xffffff;
	corner0_clut.clut[0] = 0xffffff;
	corner0_clut.clut[0] = 0xffffff;
	clut.clut[0] = 0xffffff;
    } else if ( COLOR_GREEN(bg)>COLOR_BLUE(bg) ) {
	rotate0_clut.clut[3] = 0x0000ff;
	rotate0_clut.clut[4] = 0x00ff00;
    }
}

/* Some icons in this file, so that FontForge could show anything meaningful */
/* when devoid of its external images. But if these are available and set up */
/* by means of X resources, this routine polls them for fancy icons to use */
/* instead of rudimentary pixmaps hardcoded above. */
void InitToolIcons(void) {
    static int done = false;
    
    if ( ! done) {
        done = true;
        GGadgetInit();

        /* Large 24x24 icons for CharView tool palettes */
        TryGGadgetImageCache(&GIcon_hand, "palettehand.png");
        TryGGadgetImageCache(&GIcon_line, "paletteline.png");
        TryGGadgetImageCache(&GIcon_pencil, "palettepencil.png");
        TryGGadgetImageCache(&GIcon_shift, "paletteshift.png");
        TryGGadgetImageCache(&GIcon_star, "palettestar.png");
        TryGGadgetImageCache(&GIcon_poly, "palettepoly.png");
        TryGGadgetImageCache(&GIcon_elipse, "paletteelipse.png");
        TryGGadgetImageCache(&GIcon_rect, "paletterect.png");
        TryGGadgetImageCache(&GIcon_freehand, "palettefreehand.png");
        TryGGadgetImageCache(&GIcon_greyfree, "palettegreyfree.png");
        TryGGadgetImageCache(&GIcon_pen, "palettepen.png");
        TryGGadgetImageCache(&GIcon_knife, "paletteknife.png");
        TryGGadgetImageCache(&GIcon_scale, "palettescale.png");
        TryGGadgetImageCache(&GIcon_flip, "paletteflip.png");
        TryGGadgetImageCache(&GIcon_skew, "paletteskew.png");
        TryGGadgetImageCache(&GIcon_rotate, "paletterotate.png");
        TryGGadgetImageCache(&GIcon_3drotate, "palette3drotate.png");
        TryGGadgetImageCache(&GIcon_perspective, "paletteperspective.png");
        TryGGadgetImageCache(&GIcon_tangent, "palettetangent.png");
        TryGGadgetImageCache(&GIcon_curve, "palettecurve.png");
        TryGGadgetImageCache(&GIcon_hvcurve, "palettehvcurve.png");
        TryGGadgetImageCache(&GIcon_corner, "palettecorner.png");
        TryGGadgetImageCache(&GIcon_spirocorner, "palettespirocorner.png");
        TryGGadgetImageCache(&GIcon_spirocurve, "palettespirocurve.png");
        TryGGadgetImageCache(&GIcon_spirog2curve, "palettespirog2curve.png");
        TryGGadgetImageCache(&GIcon_spiroright, "palettespiroright.png");
        TryGGadgetImageCache(&GIcon_spiroleft, "palettespiroleft.png");
        TryGGadgetImageCache(&GIcon_spirodisabled, "palettespirodisabled.png");
        TryGGadgetImageCache(&GIcon_spiroup, "palettespiroup.png");
        TryGGadgetImageCache(&GIcon_spirodown, "palettespirodown.png");
        TryGGadgetImageCache(&GIcon_ruler, "paletteruler.png");
        TryGGadgetImageCache(&GIcon_pointer, "palettepointer.png");
        TryGGadgetImageCache(&GIcon_magnify, "palettemagnify.png");

        /* Small 16x12 icons for CharView tool palettes */
        TryGGadgetImageCache(&GIcon_small3drotate, "palettesmall3drotate.png");
        TryGGadgetImageCache(&GIcon_smallperspective, "palettesmallperspective.png");
        TryGGadgetImageCache(&GIcon_smallskew, "palettesmallskew.png");
        TryGGadgetImageCache(&GIcon_smallscale, "palettesmallscale.png");
        TryGGadgetImageCache(&GIcon_smallrotate, "palettesmallrotate.png");
        TryGGadgetImageCache(&GIcon_smallflip, "palettesmallflip.png");
        TryGGadgetImageCache(&GIcon_smalltangent, "palettesmalltangent.png");
        TryGGadgetImageCache(&GIcon_smallcorner, "palettesmallcorner.png");
        TryGGadgetImageCache(&GIcon_smallcurve, "palettesmallcurve.png");
        TryGGadgetImageCache(&GIcon_smallhvcurve, "palettesmallhvcurve.png");
        TryGGadgetImageCache(&GIcon_smallspirocorner, "palettesmallspirocorner.png");
        TryGGadgetImageCache(&GIcon_smallspirog2curve, "palettesmallspirog2curve.png");
        TryGGadgetImageCache(&GIcon_smallspirocurve, "palettesmallspirocurve.png");
        TryGGadgetImageCache(&GIcon_smallspiroright, "palettesmallspiroright.png");
        TryGGadgetImageCache(&GIcon_smallspiroleft, "palettesmallspiroleft.png");
        TryGGadgetImageCache(&GIcon_smallmag, "palettesmallmag.png");
        TryGGadgetImageCache(&GIcon_smallknife, "palettesmallknife.png");
        TryGGadgetImageCache(&GIcon_smallhand, "palettesmallhand.png");
        TryGGadgetImageCache(&GIcon_smallpen, "palettesmallpen.png");
        TryGGadgetImageCache(&GIcon_smallpencil, "palettesmallpencil.png");
        TryGGadgetImageCache(&GIcon_smallpointer, "palettesmallpointer.png");
        TryGGadgetImageCache(&GIcon_smallruler, "palettesmallruler.png");
        TryGGadgetImageCache(&GIcon_smallelipse, "palettesmallelipse.png");
        TryGGadgetImageCache(&GIcon_smallrect, "palettesmallrect.png");
        TryGGadgetImageCache(&GIcon_smallpoly, "palettesmallpoly.png");
        TryGGadgetImageCache(&GIcon_smallstar, "palettesmallstar.png");

        /* 16x16 icons for point types in point info window */
        /* Note: spiro mode uses smaller (16x12) icons from CharView tool palette. */
        TryGGadgetImageCache(&GIcon_midtangent, "ptinfotangent.png");
        TryGGadgetImageCache(&GIcon_midcurve, "ptinfocurve.png");
        TryGGadgetImageCache(&GIcon_midhvcurve, "ptinfohvcurve.png");
        TryGGadgetImageCache(&GIcon_midcorner, "ptinfocorner.png");

        /* Icons for truetype debugger */
        TryGGadgetImageCache(&GIcon_continue, "ttdebugcontinue.png");
        TryGGadgetImageCache(&GIcon_stepout, "ttdebugstepout.png");
        TryGGadgetImageCache(&GIcon_stepover, "ttdebugstepover.png");
        TryGGadgetImageCache(&GIcon_stepinto, "ttdebugstepinto.png");
        TryGGadgetImageCache(&GIcon_watchpnt, "ttdebugwatchpnt.png");
        TryGGadgetImageCache(&GIcon_menudelta, "ttdebugmenudelta.png");
        TryGGadgetImageCache(&GIcon_exit, "ttdebugexit.png");
        TryGGadgetImageCache(&GIcon_Stopped, "ttdebugstopped.png");
        TryGGadgetImageCache(&GIcon_Stop, "ttdebugstop.png");
    }
}

