/* tpf-persona-store.c generated by valac 0.16.0, the Vala compiler
 * generated from tpf-persona-store.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <telepathy-glib/telepathy-glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <tp-lowlevel.h>


#define TPF_TYPE_PERSONA_STORE (tpf_persona_store_get_type ())
#define TPF_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TPF_TYPE_PERSONA_STORE, TpfPersonaStore))
#define TPF_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TPF_TYPE_PERSONA_STORE, TpfPersonaStoreClass))
#define TPF_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TPF_TYPE_PERSONA_STORE))
#define TPF_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TPF_TYPE_PERSONA_STORE))
#define TPF_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TPF_TYPE_PERSONA_STORE, TpfPersonaStoreClass))

typedef struct _TpfPersonaStore TpfPersonaStore;
typedef struct _TpfPersonaStoreClass TpfPersonaStoreClass;
typedef struct _TpfPersonaStorePrivate TpfPersonaStorePrivate;

#define TPF_TYPE_PERSONA (tpf_persona_get_type ())
#define TPF_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TPF_TYPE_PERSONA, TpfPersona))
#define TPF_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TPF_TYPE_PERSONA, TpfPersonaClass))
#define TPF_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TPF_TYPE_PERSONA))
#define TPF_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TPF_TYPE_PERSONA))
#define TPF_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TPF_TYPE_PERSONA, TpfPersonaClass))

typedef struct _TpfPersona TpfPersona;
typedef struct _TpfPersonaClass TpfPersonaClass;

#define TYPE_LOGGER (logger_get_type ())
#define LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LOGGER, Logger))
#define LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LOGGER, LoggerClass))
#define IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LOGGER))
#define IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LOGGER))
#define LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LOGGER, LoggerClass))

typedef struct _Logger Logger;
typedef struct _LoggerClass LoggerClass;

#define TPF_TYPE_PERSONA_STORE_CACHE (tpf_persona_store_cache_get_type ())
#define TPF_PERSONA_STORE_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TPF_TYPE_PERSONA_STORE_CACHE, TpfPersonaStoreCache))
#define TPF_PERSONA_STORE_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TPF_TYPE_PERSONA_STORE_CACHE, TpfPersonaStoreCacheClass))
#define TPF_IS_PERSONA_STORE_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TPF_TYPE_PERSONA_STORE_CACHE))
#define TPF_IS_PERSONA_STORE_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TPF_TYPE_PERSONA_STORE_CACHE))
#define TPF_PERSONA_STORE_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TPF_TYPE_PERSONA_STORE_CACHE, TpfPersonaStoreCacheClass))

typedef struct _TpfPersonaStoreCache TpfPersonaStoreCache;
typedef struct _TpfPersonaStoreCacheClass TpfPersonaStoreCacheClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TpfPersonaStorePrepareData TpfPersonaStorePrepareData;
typedef struct _TpfPersonaStoreInitialiseFavouriteContactsData TpfPersonaStoreInitialiseFavouriteContactsData;
typedef struct _TpfPersonaStoreNotifyConnectionCbAsyncData TpfPersonaStoreNotifyConnectionCbAsyncData;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _TpfPersonaStoreLoadCacheData TpfPersonaStoreLoadCacheData;
typedef struct _TpfPersonaStoreStoreCacheData TpfPersonaStoreStoreCacheData;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
typedef struct _TpfPersonaStoreRemovePersonaData TpfPersonaStoreRemovePersonaData;
typedef struct _TpfPersonaStoreChannelGroupPendIncomingAddsData TpfPersonaStoreChannelGroupPendIncomingAddsData;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _TpfPersonaStoreChangeGroupMembershipData TpfPersonaStoreChangeGroupMembershipData;
typedef struct _TpfPersonaStoreAddStandardChannelData TpfPersonaStoreAddStandardChannelData;
typedef struct _TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData;
typedef struct _TpfPersonaStoreEnsurePersonasFromContactIdsData TpfPersonaStoreEnsurePersonasFromContactIdsData;
typedef struct _TpfPersonaStoreAddPersonaFromDetailsData TpfPersonaStoreAddPersonaFromDetailsData;
typedef struct _TpfPersonaStoreChangeIsFavouriteData TpfPersonaStoreChangeIsFavouriteData;
typedef struct _TpfPersonaStoreChangeAliasData TpfPersonaStoreChangeAliasData;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define __vala_TpContactInfoField_free0(var) ((var == NULL) ? NULL : (var = (_vala_TpContactInfoField_free (var), NULL)))
typedef struct _TpfPersonaStoreChangeUserBirthdayData TpfPersonaStoreChangeUserBirthdayData;
typedef struct _TpfPersonaStoreChangeUserFullNameData TpfPersonaStoreChangeUserFullNameData;
typedef struct _TpfPersonaStoreChangeUserDetailsData TpfPersonaStoreChangeUserDetailsData;
#define __g_list_free___vala_TpContactInfoField_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free___vala_TpContactInfoField_free0_ (var), NULL)))
typedef struct _TpfPersonaStoreChangeUserContactInfoData TpfPersonaStoreChangeUserContactInfoData;

struct _TpfPersonaStore {
	FolksPersonaStore parent_instance;
	TpfPersonaStorePrivate * priv;
	GeeHashSet* _supported_fields;
	GeeSet* _supported_fields_ro;
};

struct _TpfPersonaStoreClass {
	FolksPersonaStoreClass parent_class;
};

struct _TpfPersonaStorePrivate {
	GeeHashMap* _personas;
	GeeMap* _personas_ro;
	GeeHashSet* _persona_set;
	GeeHashMap* _handle_persona_map;
	GeeHashMap* _weakly_referenced_contacts;
	GeeHashMap* _channel_group_personas_map;
	GeeHashMap* _channel_group_incoming_adds;
	GeeHashMap* _group_outgoing_adds;
	GeeHashMap* _group_outgoing_removes;
	GeeHashMap* _standard_channels_unready;
	GeeHashMap* _group_channels_unready;
	GeeHashMap* _groups;
	GeeHashSet* _favourite_handles;
	TpChannel* _publish;
	TpChannel* _stored;
	TpChannel* _subscribe;
	TpConnection* _conn;
	TpAccountManager* _account_manager;
	Logger* _logger;
	TpContact* _self_contact;
	FolksMaybeBool _can_add_personas;
	FolksMaybeBool _can_alias_personas;
	FolksMaybeBool _can_group_personas;
	FolksMaybeBool _can_remove_personas;
	gboolean _is_prepared;
	GStaticRecMutex __lock__is_prepared;
	gboolean _prepare_pending;
	gboolean _is_quiescent;
	gboolean _got_stored_channel_members;
	gboolean _got_self_handle;
	FolksDebug* _debug;
	TpfPersonaStoreCache* _cache;
	GCancellable* _load_cache_cancellable;
	gboolean _cached;
	TpAccount* _account;
};

struct _TpfPersonaStorePrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	TpAccountManager* _tmp6_;
	TpAccountManager* _tmp7_;
	TpAccountManager* _tmp8_;
	TpAccountManager* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	Logger* _tmp12_;
	Logger* _tmp13_;
	Logger* _tmp14_;
	Logger* _tmp15_;
	GError* e;
	const gchar* _tmp16_;
	gboolean _tmp17_;
	TpAccount* _tmp18_;
	TpAccount* _tmp19_;
	TpAccount* _tmp20_;
	TpAccount* _tmp21_;
	TpConnection* _tmp22_;
	TpConnection* _tmp23_;
	TpAccount* _tmp24_;
	TpAccount* _tmp25_;
	gboolean _tmp26_;
	gboolean _tmp27_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreInitialiseFavouriteContactsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	Logger* _tmp0_;
	Logger* _tmp1_;
	gint _tmp2_;
	gchar** _tmp3_;
	gchar** contacts;
	gint contacts_length1;
	gint _contacts_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	TpConnection* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	GError* e;
	const gchar* _tmp7_;
	GError* _tmp8_;
	const gchar* _tmp9_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreNotifyConnectionCbAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	TpAccount* _tmp2_;
	TpAccount* _tmp3_;
	TpConnection* _tmp4_;
	TpConnection* _tmp5_;
	GQuark* _tmp6_;
	gint _tmp6__length1;
	TpAccount* _tmp7_;
	TpAccount* _tmp8_;
	TpConnection* _tmp9_;
	TpConnection* _tmp10_;
	TpConnection* _tmp11_;
	TpConnection* conn;
	TpConnection* _tmp12_;
	gboolean connection_ready;
	TpConnection* _tmp13_;
	gboolean _tmp14_;
	TpConnection* _tmp15_;
	TpConnection* _tmp16_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreLoadCacheData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	gboolean _tmp0_;
	TpAccount* _tmp1_;
	TpAccount* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	TpAccount* _tmp5_;
	TpAccount* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	const gchar* _tmp10_;
	TpAccount* _tmp11_;
	TpAccount* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	const gchar* _tmp15_;
	TpAccount* _tmp16_;
	TpAccount* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	GCancellable* _tmp26_;
	GCancellable* cancellable;
	GCancellable* _tmp27_;
	GCancellable* _tmp28_;
	GCancellable* _tmp29_;
	GCancellable* _tmp30_;
	GCancellable* _tmp31_;
	TpfPersonaStoreCache* _tmp32_;
	GCancellable* _tmp33_;
	GeeSet* _tmp34_;
	GeeSet* cached_personas;
	GeeHashSet* _tmp35_;
	GeeHashSet* _tmp36_;
	GeeHashSet* old_personas;
	GCancellable* _tmp37_;
	gboolean _tmp38_;
	GCancellable* _tmp39_;
	GeeHashSet* _tmp40_;
	GeeSet* _tmp41_;
	GeeSet* _tmp42_;
	GeeIterator* _tmp43_;
	GeeIterator* _p_it;
	GeeIterator* _tmp44_;
	gboolean _tmp45_;
	GeeIterator* _tmp46_;
	gpointer _tmp47_;
	TpfPersona* p;
	GeeHashMap* _tmp48_;
	TpfPersona* _tmp49_;
	const gchar* _tmp50_;
	const gchar* _tmp51_;
	TpfPersona* _tmp52_;
	GeeHashSet* _tmp53_;
	TpfPersona* _tmp54_;
	GeeSet* _tmp55_;
	GeeHashSet* _tmp56_;
};

struct _TpfPersonaStoreStoreCacheData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	TpfPersonaStoreCache* _tmp2_;
	GeeHashSet* _tmp3_;
};

struct _TpfPersonaStoreRemovePersonaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	FolksPersona* persona;
	FolksPersona* _tmp0_;
	TpfPersona* _tmp1_;
	TpfPersona* tp_persona;
	gboolean _tmp2_;
	TpfPersona* _tmp3_;
	TpContact* _tmp4_;
	TpContact* _tmp5_;
	TpContact* _tmp6_;
	TpfPersona* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	const gchar* _tmp11_;
	GError* _tmp12_;
	TpfPersona* _tmp13_;
	TpContact* _tmp14_;
	TpContact* _tmp15_;
	TpfPersona* _tmp16_;
	TpChannel* _tmp17_;
	TpfPersona* _tmp18_;
	TpContact* _tmp19_;
	TpContact* _tmp20_;
	guint _tmp21_;
	guint _tmp22_;
	GError* e1;
	const gchar* _tmp23_;
	TpfPersona* _tmp24_;
	TpContact* _tmp25_;
	TpContact* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	GError* _tmp29_;
	const gchar* _tmp30_;
	TpChannel* _tmp31_;
	TpfPersona* _tmp32_;
	TpContact* _tmp33_;
	TpContact* _tmp34_;
	guint _tmp35_;
	guint _tmp36_;
	GError* e2;
	const gchar* _tmp37_;
	TpfPersona* _tmp38_;
	TpContact* _tmp39_;
	TpContact* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	GError* _tmp43_;
	const gchar* _tmp44_;
	TpChannel* _tmp45_;
	TpfPersona* _tmp46_;
	TpContact* _tmp47_;
	TpContact* _tmp48_;
	guint _tmp49_;
	guint _tmp50_;
	GError* e3;
	const gchar* _tmp51_;
	TpfPersona* _tmp52_;
	TpContact* _tmp53_;
	TpContact* _tmp54_;
	const gchar* _tmp55_;
	const gchar* _tmp56_;
	GError* _tmp57_;
	const gchar* _tmp58_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreChannelGroupPendIncomingAddsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	TpChannel* channel;
	GArray* adds;
	gboolean create_personas;
	guint _tmp0_;
	GArray* _tmp1_;
	GArray* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint adds_length;
	guint _tmp5_;
	gboolean _tmp6_;
	TpChannel* _tmp7_;
	GArray* _tmp8_;
	gint i;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GArray* _tmp13_;
	guint _tmp14_;
	GArray* _tmp15_;
	gint _tmp16_;
	guint _tmp17_;
	TpHandle channel_handle;
	TpChannel* _tmp18_;
	TpHandle _tmp19_;
	TpHandle _tmp20_;
	TpHandle contact_handle;
	GeeHashMap* _tmp21_;
	TpChannel* _tmp22_;
	gpointer _tmp23_;
	GeeHashSet* contact_handles;
	GeeHashSet* _tmp24_;
	GeeHashSet* _tmp25_;
	GeeHashMap* _tmp26_;
	TpChannel* _tmp27_;
	GeeHashSet* _tmp28_;
	GeeHashSet* _tmp29_;
	TpHandle _tmp30_;
};

struct _TpfPersonaStoreChangeGroupMembershipData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	FolksPersona* persona;
	gchar* group;
	gboolean is_member;
	FolksPersona* _tmp0_;
	TpfPersona* _tmp1_;
	TpfPersona* tp_persona;
	GeeHashMap* _tmp2_;
	const gchar* _tmp3_;
	gpointer _tmp4_;
	TpChannel* channel;
	GeeHashMap* _tmp5_;
	gboolean _tmp6_;
	GeeHashMap* _tmp7_;
	GeeHashMap* _tmp8_;
	GeeHashMap* _tmp9_;
	GeeHashMap* _tmp10_;
	GeeHashMap* change_map;
	GeeHashMap* _tmp11_;
	const gchar* _tmp12_;
	gpointer _tmp13_;
	GeeHashSet* change_set;
	GeeHashSet* _tmp14_;
	GeeHashSet* _tmp15_;
	GeeHashMap* _tmp16_;
	const gchar* _tmp17_;
	GeeHashSet* _tmp18_;
	GeeHashSet* _tmp19_;
	TpfPersona* _tmp20_;
	TpChannel* _tmp21_;
	TpAccount* _tmp22_;
	TpAccount* _tmp23_;
	TpConnection* _tmp24_;
	TpConnection* _tmp25_;
	const gchar* _tmp26_;
	TpChannel* _tmp27_;
};

struct _TpfPersonaStoreAddStandardChannelData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	TpConnection* conn;
	gchar* name;
	TpChannel* result;
	TpChannel* channel;
	const gchar* _tmp0_;
	TpConnection* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	TpConnection* _tmp4_;
	const gchar* _tmp5_;
	TpChannel* _tmp6_;
	TpChannel* _tmp7_;
	TpChannel* _tmp8_;
	GError* e;
	const gchar* _tmp9_;
	GError* _tmp10_;
	const gchar* _tmp11_;
	TpChannel* _tmp12_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	TpChannel* channel;
	GArray* channel_handles;
	guint* _tmp0_;
	guint* contact_handles;
	gint contact_handles_length1;
	gint _contact_handles_size_;
	gint i;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GArray* _tmp5_;
	guint _tmp6_;
	GArray* _tmp7_;
	gint _tmp8_;
	guint _tmp9_;
	TpHandle channel_handle;
	TpChannel* _tmp10_;
	TpHandle _tmp11_;
	TpHandle _tmp12_;
	TpHandle contact_handle;
	GeeHashMap* _tmp13_;
	TpHandle _tmp14_;
	gpointer _tmp15_;
	TpfPersona* persona;
	TpfPersona* _tmp16_;
	guint* _tmp17_;
	gint _tmp17__length1;
	TpHandle _tmp18_;
	TpfPersona* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	TpfPersona* _tmp22_;
	guint* _tmp23_;
	gint _tmp23__length1;
	TpConnection* _tmp24_;
	guint* _tmp25_;
	gint _tmp25__length1;
	TpContactFeature* _tmp26_;
	gint _tmp26__length1;
	GList* _tmp27_;
	GList* contacts;
	gboolean _tmp28_;
	GList* _tmp29_;
	GList* _tmp30_;
	guint _tmp31_;
	gboolean _tmp32_;
	GList* _tmp33_;
	guint _tmp34_;
	TpContact** _tmp35_;
	TpContact** contacts_array;
	gint contacts_array_length1;
	gint _contacts_array_size_;
	gint j;
	GList* _tmp36_;
	GList* l;
	gboolean _tmp37_;
	gboolean _tmp38_;
	GList* _tmp39_;
	GList* _tmp40_;
	GList* _tmp41_;
	TpContact** _tmp42_;
	gint _tmp42__length1;
	gint _tmp43_;
	GList* _tmp44_;
	gconstpointer _tmp45_;
	TpContact* _tmp46_;
	TpContact* _tmp47_;
	gint _tmp48_;
	TpContact** _tmp49_;
	gint _tmp49__length1;
	GError* e;
	const gchar* _tmp50_;
	TpChannel* _tmp51_;
	const gchar* _tmp52_;
	GError* _tmp53_;
	const gchar* _tmp54_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreEnsurePersonasFromContactIdsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	gchar** contact_ids;
	gint contact_ids_length1;
	GeeHashSet* result;
	GeeHashSet* _tmp0_;
	GeeHashSet* personas;
	GeeHashSet* _tmp1_;
	GeeHashSet* personas_added;
	gchar** _tmp2_;
	gint _tmp2__length1;
	TpConnection* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	TpContactFeature* _tmp5_;
	gint _tmp5__length1;
	GList* _tmp6_;
	GList* contacts;
	GList* l;
	GList* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GList* _tmp10_;
	GList* _tmp11_;
	GList* _tmp12_;
	GList* _tmp13_;
	gconstpointer _tmp14_;
	TpContact* _tmp15_;
	TpContact* contact;
	TpContact* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gboolean added;
	TpContact* _tmp19_;
	gboolean _tmp20_;
	TpfPersona* _tmp21_;
	TpfPersona* persona;
	gboolean _tmp22_;
	GeeHashSet* _tmp23_;
	TpfPersona* _tmp24_;
	GeeHashSet* _tmp25_;
	TpfPersona* _tmp26_;
	GeeHashSet* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	GeeHashSet* _tmp30_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreAddPersonaFromDetailsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	GHashTable* details;
	FolksPersona* result;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* contact_id;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	GError* _tmp10_;
	GHashTable* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* add_message;
	const gchar* _tmp14_;
	TpAccount* _tmp15_;
	TpAccount* _tmp16_;
	TpConnectionStatus _tmp17_;
	TpConnectionStatus status;
	gboolean _tmp18_;
	gboolean _tmp19_;
	TpConnectionStatus _tmp20_;
	TpConnectionStatus _tmp21_;
	gboolean _tmp22_;
	TpConnection* _tmp23_;
	gboolean _tmp24_;
	const gchar* _tmp25_;
	GError* _tmp26_;
	gchar** _tmp27_;
	gchar** contact_ids;
	gint contact_ids_length1;
	gint _contact_ids_size_;
	gchar** _tmp28_;
	gint _tmp28__length1;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar** _tmp32_;
	gint _tmp32__length1;
	GeeHashSet* _tmp33_;
	GeeHashSet* personas;
	GeeHashSet* _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	GeeHashSet* _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	TpfPersona* persona;
	GeeHashSet* _tmp40_;
	GeeIterator* _tmp41_;
	GeeIterator* _p_it;
	GeeIterator* _tmp42_;
	gboolean _tmp43_;
	GeeIterator* _tmp44_;
	gpointer _tmp45_;
	TpfPersona* p;
	TpfPersona* _tmp46_;
	TpfPersona* _tmp47_;
	TpChannel* _tmp48_;
	TpChannel* _tmp49_;
	TpfPersona* _tmp50_;
	const gchar* _tmp51_;
	TpChannel* _tmp52_;
	TpChannel* _tmp53_;
	TpChannelGroupFlags _tmp54_;
	TpChannelGroupFlags flags;
	TpChannelGroupFlags _tmp55_;
	TpChannel* _tmp56_;
	TpfPersona* _tmp57_;
	const gchar* _tmp58_;
	GeeHashSet* _tmp59_;
	gint _tmp60_;
	gint _tmp61_;
	gint num_personas;
	gint _tmp62_;
	const gchar* _tmp63_;
	gchar* _tmp64_;
	gchar* message;
	const gchar* _tmp65_;
	gint _tmp66_;
	GError* _tmp67_;
	GError* e;
	const gchar* _tmp68_;
	GError* _tmp69_;
	const gchar* _tmp70_;
	GError* _tmp71_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreChangeIsFavouriteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	FolksPersona* persona;
	gboolean is_favourite;
	Logger* _tmp0_;
	const gchar* _tmp1_;
	GError* _tmp2_;
	FolksPersona* _tmp3_;
	TpContact* _tmp4_;
	TpContact* _tmp5_;
	const gchar* _tmp6_;
	GError* _tmp7_;
	FolksPersona* _tmp8_;
	TpContact* _tmp9_;
	TpContact* _tmp10_;
	const gchar* _tmp11_;
	const gchar* id;
	gboolean _tmp12_;
	Logger* _tmp13_;
	const gchar* _tmp14_;
	Logger* _tmp15_;
	const gchar* _tmp16_;
	GError* e;
	const gchar* _tmp17_;
	FolksPersona* _tmp18_;
	TpContact* _tmp19_;
	TpContact* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	GError* _tmp23_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreChangeAliasData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	TpfPersona* persona;
	gchar* alias;
	const gchar* _tmp0_;
	TpfPersona* _tmp1_;
	TpContact* _tmp2_;
	TpContact* _tmp3_;
	TpfPersona* _tmp4_;
	const gchar* _tmp5_;
	TpfPersona* _tmp6_;
	TpContact* _tmp7_;
	TpContact* _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	const gchar* _tmp11_;
	TpConnection* _tmp12_;
	TpfPersona* _tmp13_;
	TpContact* _tmp14_;
	TpContact* _tmp15_;
	guint _tmp16_;
	guint _tmp17_;
	const gchar* _tmp18_;
};

struct _TpfPersonaStoreChangeUserBirthdayData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	TpfPersona* persona;
	GDateTime* birthday;
	gchar* birthday_str;
	GDateTime* _tmp0_;
	gchar* _tmp1_;
	GDateTime* _tmp2_;
	gchar* _tmp3_;
	GeeHashSet* _tmp4_;
	GeeHashSet* info_set;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** values;
	gint values_length1;
	gint _values_size_;
	gchar** _tmp8_;
	gchar** parameters;
	gint parameters_length1;
	gint _parameters_size_;
	TpContactInfoField* _tmp9_;
	TpContactInfoField* field;
	TpfPersona* _tmp10_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreChangeUserFullNameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	TpfPersona* persona;
	gchar* full_name;
	const gchar* _tmp0_;
	GeeHashSet* _tmp1_;
	GeeHashSet* info_set;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** values;
	gint values_length1;
	gint _values_size_;
	gchar** _tmp5_;
	gchar** parameters;
	gint parameters_length1;
	gint _parameters_size_;
	TpContactInfoField* _tmp6_;
	TpContactInfoField* field;
	TpfPersona* _tmp7_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreChangeUserDetailsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	TpfPersona* persona;
	GeeSet* details;
	gchar* field_name;
	GeeHashSet* _tmp0_;
	GeeHashSet* info_set;
	GeeSet* _tmp1_;
	GeeIterator* _tmp2_;
	GeeIterator* _afd_it;
	GeeIterator* _tmp3_;
	gboolean _tmp4_;
	GeeIterator* _tmp5_;
	gpointer _tmp6_;
	FolksAbstractFieldDetails* afd;
	FolksAbstractFieldDetails* _tmp7_;
	gconstpointer _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gchar** values;
	gint values_length1;
	gint _values_size_;
	gchar** _tmp12_;
	gchar** parameters;
	gint parameters_length1;
	gint _parameters_size_;
	FolksAbstractFieldDetails* _tmp13_;
	GeeMultiMap* _tmp14_;
	GeeMultiMap* _tmp15_;
	GeeSet* _tmp16_;
	GeeSet* _tmp17_;
	GeeIterator* _tmp18_;
	GeeIterator* _tmp19_;
	GeeIterator* _param_name_it;
	GeeIterator* _tmp20_;
	gboolean _tmp21_;
	GeeIterator* _tmp22_;
	gpointer _tmp23_;
	gchar* param_name;
	FolksAbstractFieldDetails* _tmp24_;
	GeeMultiMap* _tmp25_;
	GeeMultiMap* _tmp26_;
	const gchar* _tmp27_;
	GeeCollection* _tmp28_;
	GeeCollection* param_values;
	GeeCollection* _tmp29_;
	GeeIterator* _tmp30_;
	GeeIterator* _param_value_it;
	GeeIterator* _tmp31_;
	gboolean _tmp32_;
	GeeIterator* _tmp33_;
	gpointer _tmp34_;
	gchar* param_value;
	gchar** _tmp35_;
	gint _tmp35__length1;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	gchar** _tmp41_;
	gint _tmp41__length1;
	gchar** _tmp42_;
	const gchar* _tmp43_;
	gchar** _tmp44_;
	gint _tmp44__length1;
	gchar** _tmp45_;
	gint _tmp45__length1;
	TpContactInfoField* _tmp46_;
	TpContactInfoField* field;
	GeeHashSet* _tmp47_;
	TpContactInfoField* _tmp48_;
	TpfPersona* _tmp49_;
	GeeHashSet* _tmp50_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreChangeUserContactInfoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	TpfPersona* persona;
	GeeHashSet* info_set;
	TpfPersona* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp3_;
	GError* _tmp4_;
	GeeHashSet* _tmp5_;
	GList* _tmp6_;
	GList* info_list;
	TpAccount* _tmp7_;
	TpAccount* _tmp8_;
	TpConnection* _tmp9_;
	TpConnection* _tmp10_;
	GError* _error_;
	gboolean success;
	TpAccount* _tmp11_;
	TpAccount* _tmp12_;
	TpConnection* _tmp13_;
	TpConnection* _tmp14_;
	GList* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	GError* e;
	GError* _tmp18_;
	GError* _tmp19_;
	gboolean _tmp20_;
	GError* _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	const gchar* _tmp24_;
	GError* _tmp25_;
	GError* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	GError* _tmp30_;
	GError * _inner_error_;
};


static gpointer tpf_persona_store_parent_class = NULL;
static gchar* tpf_persona_store__tp_channel_iface;
static gchar* tpf_persona_store__tp_channel_iface = NULL;
static gchar* tpf_persona_store__tp_channel_contact_list_type;
static gchar* tpf_persona_store__tp_channel_contact_list_type = NULL;
static gchar* tpf_persona_store__tp_channel_channel_type;
static gchar* tpf_persona_store__tp_channel_channel_type = NULL;
static gchar* tpf_persona_store__tp_channel_handle_type;
static gchar* tpf_persona_store__tp_channel_handle_type = NULL;
static gchar** tpf_persona_store__undisplayed_groups;
static gint tpf_persona_store__undisplayed_groups_length1;
static gchar** tpf_persona_store__undisplayed_groups = NULL;
static gint tpf_persona_store__undisplayed_groups_length1 = 0;
static gint _tpf_persona_store__undisplayed_groups_size_ = 0;
static TpContactFeature* tpf_persona_store__contact_features;
static gint tpf_persona_store__contact_features_length1;
static TpContactFeature* tpf_persona_store__contact_features = NULL;
static gint tpf_persona_store__contact_features_length1 = 0;
static gint _tpf_persona_store__contact_features_size_ = 0;
static GQuark* tpf_persona_store__connection_features;
static gint tpf_persona_store__connection_features_length1;
static GQuark* tpf_persona_store__connection_features = NULL;
static gint tpf_persona_store__connection_features_length1 = 0;
static gint _tpf_persona_store__connection_features_size_ = 0;
static GeeHashMap* tpf_persona_store__persona_stores_by_account;
static GStaticRecMutex __lock_tpf_persona_store__persona_stores_by_account = {0};
static GeeHashMap* tpf_persona_store__persona_stores_by_account = NULL;
static GeeMap* tpf_persona_store__persona_stores_by_account_ro;
static GeeMap* tpf_persona_store__persona_stores_by_account_ro = NULL;

GType tpf_persona_store_get_type (void) G_GNUC_CONST;
GType tpf_persona_get_type (void) G_GNUC_CONST;
GType logger_get_type (void) G_GNUC_CONST;
GType tpf_persona_store_cache_get_type (void) G_GNUC_CONST;
#define TPF_PERSONA_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TPF_TYPE_PERSONA_STORE, TpfPersonaStorePrivate))
enum  {
	TPF_PERSONA_STORE_DUMMY_PROPERTY,
	TPF_PERSONA_STORE_ACCOUNT,
	TPF_PERSONA_STORE_TYPE_ID,
	TPF_PERSONA_STORE_CAN_ADD_PERSONAS,
	TPF_PERSONA_STORE_CAN_ALIAS_PERSONAS,
	TPF_PERSONA_STORE_CAN_GROUP_PERSONAS,
	TPF_PERSONA_STORE_CAN_REMOVE_PERSONAS,
	TPF_PERSONA_STORE_IS_PREPARED,
	TPF_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES,
	TPF_PERSONA_STORE_IS_QUIESCENT,
	TPF_PERSONA_STORE_PERSONAS,
	TPF_PERSONA_STORE_SUPPORTED_FIELDS
};
static void _tpf_persona_store_reset (TpfPersonaStore* self);
static void _tpf_persona_store_remove_store_from_map (TpfPersonaStore* store);
static void _tpf_persona_store_debug_print_status (TpfPersonaStore* self, FolksDebug* debug);
static void __tpf_persona_store_debug_print_status_folks_debug_print_status (FolksDebug* _sender, gpointer self);
static void _tpf_persona_store_logger_invalidated_cb (TpfPersonaStore* self);
static void __tpf_persona_store_logger_invalidated_cb_logger_invalidated (Logger* _sender, gpointer self);
static void _tpf_persona_store_account_invalidated_cb (TpfPersonaStore* self, guint domain, gint code, const gchar* message);
static void __tpf_persona_store_account_invalidated_cb_tp_proxy_invalidated (TpProxy* _sender, guint domain, gint code, const gchar* message, gpointer self);
static void _tpf_persona_store_account_manager_invalidated_cb (TpfPersonaStore* self, guint domain, gint code, const gchar* message);
static void __tpf_persona_store_account_manager_invalidated_cb_tp_proxy_invalidated (TpProxy* _sender, guint domain, gint code, const gchar* message, gpointer self);
static void _tpf_persona_store_notify_if_is_quiescent (TpfPersonaStore* self);
TpfPersonaStore* tpf_persona_store_new (TpAccount* account);
TpfPersonaStore* tpf_persona_store_construct (GType object_type, TpAccount* account);
static gchar* _tpf_persona_store_format_maybe_bool (TpfPersonaStore* self, FolksMaybeBool input);
gboolean tpf_persona_get_is_in_contact_list (TpfPersona* self);
TpContact* tpf_persona_get_contact (TpfPersona* self);
TpAccount* tpf_persona_store_get_account (TpfPersonaStore* self);
static void _tpf_persona_store_self_handle_changed_cb (TpfPersonaStore* self, GObject* s, GParamSpec* p);
static void __tpf_persona_store_self_handle_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona_store_contact_weak_notify_cb (TpfPersonaStore* self, GObject* obj);
static void __tpf_persona_store_contact_weak_notify_cb_gweak_notify (gpointer self, GObject* object);
static void _tpf_persona_store_disconnect_from_standard_channel (TpfPersonaStore* self, TpChannel* channel);
static void _tpf_persona_store_disconnect_from_group_channel (TpfPersonaStore* self, TpChannel* channel);
static void _tpf_persona_store_remove_store (TpfPersonaStore* self);
static void tpf_persona_store_real_prepare_data_free (gpointer _data);
static void tpf_persona_store_real_prepare (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_store_real_prepare_co (TpfPersonaStorePrepareData* _data_);
static void _____lambda8_ (TpfPersonaStore* self, TpAccount* a);
static void ______lambda8__tp_account_manager_account_removed (TpAccountManager* _sender, TpAccount* account, gpointer self);
static void _____lambda9_ (TpfPersonaStore* self, TpAccount* a, gboolean valid);
static void ______lambda9__tp_account_manager_account_validity_changed (TpAccountManager* _sender, TpAccount* account, gboolean valid, gpointer self);
Logger* logger_new (const gchar* account_path);
Logger* logger_construct (GType object_type, const gchar* account_path);
void logger_prepare (Logger* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean logger_prepare_finish (Logger* self, GAsyncResult* _res_, GError** error);
static void tpf_persona_store_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _tpf_persona_store_favourite_contacts_changed_cb (TpfPersonaStore* self, gchar** added, int added_length1, gchar** removed, int removed_length1);
static void __tpf_persona_store_favourite_contacts_changed_cb_logger_favourite_contacts_changed (Logger* _sender, gchar** added, int added_length1, gchar** removed, int removed_length1, gpointer self);
static void _tpf_persona_store_notify_connection_cb (TpfPersonaStore* self, GObject* s, GParamSpec* p);
static void __tpf_persona_store_notify_connection_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona_store_load_cache (TpfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _tpf_persona_store_load_cache_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static void _tpf_persona_store_initialise_favourite_contacts_data_free (gpointer _data);
static void _tpf_persona_store_initialise_favourite_contacts (TpfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _tpf_persona_store_initialise_favourite_contacts_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static gboolean _tpf_persona_store_initialise_favourite_contacts_co (TpfPersonaStoreInitialiseFavouriteContactsData* _data_);
void logger_get_favourite_contacts (Logger* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar** logger_get_favourite_contacts_finish (Logger* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void _tpf_persona_store_initialise_favourite_contacts_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void ___lambda19_ (TpfPersonaStore* self, TpConnection* c, TpHandleType ht, guint* h, int h_length1, gchar** i, int i_length1, GError* e, GObject* w);
static void _tpf_persona_store_change_favourites_by_request_handles (TpfPersonaStore* self, TpHandle* handles, int handles_length1, gchar** ids, int ids_length1, GError* _error_, gboolean add, GError** error);
static void ____lambda19__tp_connection_request_handles_cb (TpConnection* connection, TpHandleType handle_type, guint n_handles, guint* handles, gchar** ids, GError* _error_, gpointer self, GObject* weak_object);
static void ___lambda10_ (TpfPersonaStore* self, TpConnection* c, TpHandleType ht, guint* h, int h_length1, gchar** i, int i_length1, GError* e, GObject* w);
static void ____lambda10__tp_connection_request_handles_cb (TpConnection* connection, TpHandleType handle_type, guint n_handles, guint* handles, gchar** ids, GError* _error_, gpointer self, GObject* weak_object);
static void ___lambda11_ (TpfPersonaStore* self, TpConnection* c, TpHandleType ht, guint* h, int h_length1, gchar** i, int i_length1, GError* e, GObject* w);
static void ____lambda11__tp_connection_request_handles_cb (TpConnection* connection, TpHandleType handle_type, guint n_handles, guint* handles, gchar** ids, GError* _error_, gpointer self, GObject* weak_object);
static void _tpf_persona_store_store_cache (TpfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _tpf_persona_store_store_cache_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static void ____lambda12_ (TpfPersonaStore* self, GObject* o, GAsyncResult* r);
static void __lambda13_ (TpfPersonaStore* self, GObject* o2, GAsyncResult* r2);
static void ___lambda13__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _____lambda12__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _tpf_persona_store_notify_connection_cb_async (TpfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _tpf_persona_store_notify_connection_cb_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static void _tpf_persona_store_notify_connection_cb_async_data_free (gpointer _data);
static gboolean _tpf_persona_store_notify_connection_cb_async_co (TpfPersonaStoreNotifyConnectionCbAsyncData* _data_);
static void _tpf_persona_store_notify_connection_cb_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _tpf_persona_store_unload_cache (TpfPersonaStore* self);
static void _tpf_persona_store_connection_ready_cb (TpfPersonaStore* self, GObject* s, GParamSpec* p);
static void __tpf_persona_store_connection_ready_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona_store_new_group_channels_cb (TpfPersonaStore* self, TpChannel* channel, GAsyncResult* _result_);
static void __tpf_persona_store_new_group_channels_cb_folks_tp_lowlevel_new_group_channels_callback (TpChannel* channel, GAsyncResult* _result_, gpointer self);
static void _tpf_persona_store_marshall_supported_fields (TpfPersonaStore* self);
static void __lambda15_ (TpfPersonaStore* self, GObject* s2, GAsyncResult* res);
static void ___lambda15__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda16_ (TpfPersonaStore* self, GObject* s3, GAsyncResult* res3);
static GValue* _g_value_dup (GValue* self);
static void _vala_GValue_free (GValue* self);
static void ___lambda16__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _tpf_persona_store_add_standard_channel (TpfPersonaStore* self, TpConnection* conn, const gchar* name, GAsyncReadyCallback _callback_, gpointer _user_data_);
static TpChannel* _tpf_persona_store_add_standard_channel_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static void _tpf_persona_store_load_cache_data_free (gpointer _data);
static gboolean _tpf_persona_store_load_cache_co (TpfPersonaStoreLoadCacheData* _data_);
static void _tpf_persona_store_load_cache_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _tpf_persona_store_store_cache_data_free (gpointer _data);
static gboolean _tpf_persona_store_store_cache_co (TpfPersonaStoreStoreCacheData* _data_);
static void _tpf_persona_store_store_cache_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _tpf_persona_store_ignore_by_handle (TpfPersonaStore* self, guint handle, const gchar* message, TpfPersona* actor, FolksGroupDetailsChangeReason reason);
static void __lambda6_ (TpfPersonaStore* self, TpConnection* conn, TpContact** contacts, int contacts_length1, TpHandle* failed, int failed_length1, GError* _error_, GObject* weak_object);
static TpfPersona* _tpf_persona_store_add_persona_from_contact (TpfPersonaStore* self, TpContact* contact, gboolean from_contact_list, gboolean* added);
static void ___lambda6__tp_connection_contacts_by_handle_cb (TpConnection* connection, guint n_contacts, TpContact** contacts, guint n_failed, TpHandle* failed, GError* _error_, gpointer self, GObject* weak_object);
static void _tpf_persona_store_set_up_new_group_channel (TpfPersonaStore* self, TpChannel* channel);
static void _tpf_persona_store_channel_group_changes_resolve (TpfPersonaStore* self, TpChannel* channel);
static void _tpf_persona_store_set_up_new_standard_channel (TpfPersonaStore* self, TpChannel* channel);
static void __lambda17_ (TpfPersonaStore* self, GObject* s, GParamSpec* p);
static void _tpf_persona_store_publish_channel_group_members_changed_detailed_cb (TpfPersonaStore* self, TpChannel* channel, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details);
static void __tpf_persona_store_publish_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed (TpChannel* _sender, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details, gpointer self);
static void _tpf_persona_store_stored_channel_group_members_changed_detailed_cb (TpfPersonaStore* self, TpChannel* channel, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details);
static void __tpf_persona_store_stored_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed (TpChannel* _sender, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details, gpointer self);
static void _tpf_persona_store_subscribe_channel_group_members_changed_detailed_cb (TpfPersonaStore* self, TpChannel* channel, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details);
static void __tpf_persona_store_subscribe_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed (TpChannel* _sender, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details, gpointer self);
static void _tpf_persona_store_subscribe_channel_group_flags_changed_cb (TpfPersonaStore* self, TpChannel* channel, guint added, guint removed);
static void __tpf_persona_store_subscribe_channel_group_flags_changed_cb_tp_channel_group_flags_changed (TpChannel* _sender, guint added, guint removed, gpointer self);
static void _tpf_persona_store_channel_invalidated_cb (TpfPersonaStore* self, TpProxy* proxy, guint domain, gint code, const gchar* message);
static void __tpf_persona_store_channel_invalidated_cb_tp_proxy_invalidated (TpProxy* _sender, guint domain, gint code, const gchar* message, gpointer self);
static void _tpf_persona_store_channel_group_pend_incoming_adds (TpfPersonaStore* self, TpChannel* channel, GArray* adds, gboolean create_personas, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _tpf_persona_store_channel_group_pend_incoming_adds_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static void ___lambda18_ (TpfPersonaStore* self, GObject* obj, GAsyncResult* res);
static void ____lambda18__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void ___lambda17__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona_store_ignore_by_handle_if_needed (TpfPersonaStore* self, guint handle, GHashTable* details);
static void ___lambda7_ (TpfPersonaStore* self, GObject* obj, GAsyncResult* res);
static void ____lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _tpf_persona_store_update_capability (TpfPersonaStore* self, TpChannelGroupFlags added, TpChannelGroupFlags removed, TpChannelGroupFlags tp_flag, FolksMaybeBool* private_member, const gchar* prop_name);
static FolksGroupDetailsChangeReason _tpf_persona_store_change_reason_from_tp_reason (guint reason);
static void tpf_persona_store_real_remove_persona_data_free (gpointer _data);
static void tpf_persona_store_real_remove_persona (FolksPersonaStore* base, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_store_real_remove_persona_co (TpfPersonaStoreRemovePersonaData* _data_);
static void _tpf_persona_store_channel_group_pend_incoming_adds_data_free (gpointer _data);
static gboolean _tpf_persona_store_channel_group_pend_incoming_adds_co (TpfPersonaStoreChannelGroupPendIncomingAddsData* _data_);
static void _tpf_persona_store_create_personas_from_channel_handles_async (TpfPersonaStore* self, TpChannel* channel, GArray* channel_handles, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _tpf_persona_store_create_personas_from_channel_handles_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static void _tpf_persona_store_channel_group_pend_incoming_adds_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _tpf_persona_store_channel_groups_add_new_personas (TpfPersonaStore* self);
static void _tpf_persona_store_channel_group_handle_incoming_removes (TpfPersonaStore* self, TpChannel* channel, GArray* removes);
static gboolean _tpf_persona_store_group_is_display_group (TpfPersonaStore* self, const gchar* group);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void __lambda14_ (TpfPersonaStore* self, GObject* s, GParamSpec* p);
static void _tpf_persona_store_channel_group_members_changed_detailed_cb (TpfPersonaStore* self, TpChannel* channel, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details);
static void __tpf_persona_store_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed (TpChannel* _sender, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details, gpointer self);
static void ___lambda14__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona_store_change_group_membership_data_free (gpointer _data);
void _tpf_persona_store_change_group_membership (TpfPersonaStore* self, FolksPersona* persona, const gchar* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _tpf_persona_store_change_group_membership_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static gboolean _tpf_persona_store_change_group_membership_co (TpfPersonaStoreChangeGroupMembershipData* _data_);
static void _tpf_persona_store_change_standard_contact_list_membership (TpfPersonaStore* self, TpChannel* channel, FolksPersona* persona, gboolean is_member, const gchar* message);
static void _tpf_persona_store_add_standard_channel_data_free (gpointer _data);
static gboolean _tpf_persona_store_add_standard_channel_co (TpfPersonaStoreAddStandardChannelData* _data_);
static void _tpf_persona_store_add_standard_channel_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _tpf_persona_store_create_personas_from_channel_handles_async_data_free (gpointer _data);
static gboolean _tpf_persona_store_create_personas_from_channel_handles_async_co (TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData* _data_);
static void _vala_array_add6 (guint** array, int* length, int* size, guint value);
void tpf_persona_set_is_in_contact_list (TpfPersona* self, gboolean value);
static void _tpf_persona_store_create_personas_from_channel_handles_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _tpf_persona_store_add_new_personas_from_contacts (TpfPersonaStore* self, TpContact** contacts, int contacts_length1);
static void _tpf_persona_store_ensure_personas_from_contact_ids_data_free (gpointer _data);
static void _tpf_persona_store_ensure_personas_from_contact_ids (TpfPersonaStore* self, gchar** contact_ids, int contact_ids_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
static GeeHashSet* _tpf_persona_store_ensure_personas_from_contact_ids_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static gboolean _tpf_persona_store_ensure_personas_from_contact_ids_co (TpfPersonaStoreEnsurePersonasFromContactIdsData* _data_);
static void _tpf_persona_store_ensure_personas_from_contact_ids_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
TpfPersona* _tpf_persona_store_ensure_persona_from_contact (TpfPersonaStore* self, TpContact* contact);
TpfPersona* tpf_persona_new (TpContact* contact, TpfPersonaStore* store);
TpfPersona* tpf_persona_construct (GType object_type, TpContact* contact, TpfPersonaStore* store);
static void tpf_persona_store_real_add_persona_from_details_data_free (gpointer _data);
static void tpf_persona_store_real_add_persona_from_details (FolksPersonaStore* base, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_store_real_add_persona_from_details_co (TpfPersonaStoreAddPersonaFromDetailsData* _data_);
static void tpf_persona_store_add_persona_from_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tpf_persona_store_change_is_favourite_data_free (gpointer _data);
void tpf_persona_store_change_is_favourite (TpfPersonaStore* self, FolksPersona* persona, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_is_favourite_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static gboolean tpf_persona_store_change_is_favourite_co (TpfPersonaStoreChangeIsFavouriteData* _data_);
void logger_add_favourite_contact (Logger* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void logger_add_favourite_contact_finish (Logger* self, GAsyncResult* _res_, GError** error);
static void tpf_persona_store_change_is_favourite_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void logger_remove_favourite_contact (Logger* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void logger_remove_favourite_contact_finish (Logger* self, GAsyncResult* _res_, GError** error);
static void tpf_persona_store_change_alias_data_free (gpointer _data);
void tpf_persona_store_change_alias (TpfPersonaStore* self, TpfPersona* persona, const gchar* alias, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_alias_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static gboolean tpf_persona_store_change_alias_co (TpfPersonaStoreChangeAliasData* _data_);
static void tpf_persona_store_change_user_birthday_data_free (gpointer _data);
void tpf_persona_store_change_user_birthday (TpfPersonaStore* self, TpfPersona* persona, GDateTime* birthday, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_user_birthday_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static gboolean tpf_persona_store_change_user_birthday_co (TpfPersonaStoreChangeUserBirthdayData* _data_);
static TpContactInfoField* _vala_TpContactInfoField_copy (TpContactInfoField* self);
static void _vala_TpContactInfoField_free (TpContactInfoField* self);
static void _tpf_persona_store_change_user_contact_info (TpfPersonaStore* self, TpfPersona* persona, GeeHashSet* info_set, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _tpf_persona_store_change_user_contact_info_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static void tpf_persona_store_change_user_birthday_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tpf_persona_store_change_user_full_name_data_free (gpointer _data);
void tpf_persona_store_change_user_full_name (TpfPersonaStore* self, TpfPersona* persona, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_user_full_name_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static gboolean tpf_persona_store_change_user_full_name_co (TpfPersonaStoreChangeUserFullNameData* _data_);
static void tpf_persona_store_change_user_full_name_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _tpf_persona_store_change_user_details_data_free (gpointer _data);
void _tpf_persona_store_change_user_details (TpfPersonaStore* self, TpfPersona* persona, GeeSet* details, const gchar* field_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _tpf_persona_store_change_user_details_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static gboolean _tpf_persona_store_change_user_details_co (TpfPersonaStoreChangeUserDetailsData* _data_);
static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value);
static void _tpf_persona_store_change_user_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _tpf_persona_store_change_user_contact_info_data_free (gpointer _data);
static gboolean _tpf_persona_store_change_user_contact_info_co (TpfPersonaStoreChangeUserContactInfoData* _data_);
static GList* _tpf_persona_store_contact_info_set_to_list (GeeHashSet* info_set);
static void _tpf_persona_store_change_user_contact_info_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void __vala_TpContactInfoField_free0_ (gpointer var);
static void _g_list_free___vala_TpContactInfoField_free0_ (GList* self);
GeeMap* tpf_persona_store_list_persona_stores (void);
static void _tpf_persona_store_store_removed_cb (FolksPersonaStore* store);
static void _tpf_persona_store_add_store_to_map (TpfPersonaStore* store);
static void __tpf_persona_store_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self);
TpfPersonaStore* tpf_persona_store_dup_for_account (TpAccount* account);
static void tpf_persona_store_set_account (TpfPersonaStore* self, TpAccount* value);
GeeSet* tpf_persona_store_get_supported_fields (TpfPersonaStore* self);
static void g_cclosure_user_marshal_VOID__STRING_POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * tpf_persona_store_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
TpfPersonaStoreCache* tpf_persona_store_cache_new (TpfPersonaStore* store);
TpfPersonaStoreCache* tpf_persona_store_cache_construct (GType object_type, TpfPersonaStore* store);
static void tpf_persona_store_finalize (GObject* obj);
static void _vala_tpf_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tpf_persona_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const gchar* TPF_PERSONA_STORE__always_writeable_properties[1] = {"is-favourite"};

static void __tpf_persona_store_debug_print_status_folks_debug_print_status (FolksDebug* _sender, gpointer self) {
	_tpf_persona_store_debug_print_status (self, _sender);
}


static void __tpf_persona_store_logger_invalidated_cb_logger_invalidated (Logger* _sender, gpointer self) {
	_tpf_persona_store_logger_invalidated_cb (self);
}


static void __tpf_persona_store_account_invalidated_cb_tp_proxy_invalidated (TpProxy* _sender, guint domain, gint code, const gchar* message, gpointer self) {
	_tpf_persona_store_account_invalidated_cb (self, domain, code, message);
}


static void __tpf_persona_store_account_manager_invalidated_cb_tp_proxy_invalidated (TpProxy* _sender, guint domain, gint code, const gchar* message, gpointer self) {
	_tpf_persona_store_account_manager_invalidated_cb (self, domain, code, message);
}


static void _tpf_persona_store_notify_if_is_quiescent (TpfPersonaStore* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean _tmp4_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp2_ = self->priv->_got_stored_channel_members;
	if (_tmp2_ == TRUE) {
		gboolean _tmp3_;
		_tmp3_ = self->priv->_got_self_handle;
		_tmp1_ = _tmp3_ == TRUE;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp4_ = _tmp1_;
	if (_tmp4_) {
		gboolean _tmp5_;
		_tmp5_ = self->priv->_is_quiescent;
		_tmp0_ = _tmp5_ == FALSE;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp6_ = _tmp0_;
	if (_tmp6_) {
		self->priv->_is_quiescent = TRUE;
		g_object_notify ((GObject*) self, "is-quiescent");
	}
}


/**
   * Create a new PersonaStore.
   *
   * Create a new persona store to store the {@link Persona}s for the contacts
   * in the Telepathy account provided by `account`.
   *
   * @param account the Telepathy account being represented by the persona store
   */
TpfPersonaStore* tpf_persona_store_construct (GType object_type, TpAccount* account) {
	TpfPersonaStore * self = NULL;
	TpAccount* _tmp0_;
	TpAccount* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	TpAccount* _tmp4_;
	const gchar* _tmp5_ = NULL;
	g_return_val_if_fail (account != NULL, NULL);
	_tmp0_ = account;
	_tmp1_ = account;
	_tmp2_ = tp_account_get_display_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = account;
	_tmp5_ = tp_proxy_get_object_path ((TpProxy*) _tmp4_);
	self = (TpfPersonaStore*) g_object_new (object_type, "account", _tmp0_, "display-name", _tmp3_, "id", _tmp5_, NULL);
	return self;
}


TpfPersonaStore* tpf_persona_store_new (TpAccount* account) {
	return tpf_persona_store_construct (TPF_TYPE_PERSONA_STORE, account);
}


static gchar* _tpf_persona_store_format_maybe_bool (TpfPersonaStore* self, FolksMaybeBool input) {
	gchar* result = NULL;
	FolksMaybeBool _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = input;
	switch (_tmp0_) {
		case FOLKS_MAYBE_BOOL_UNSET:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("unset");
			result = _tmp1_;
			return result;
		}
		case FOLKS_MAYBE_BOOL_TRUE:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("true");
			result = _tmp2_;
			return result;
		}
		case FOLKS_MAYBE_BOOL_FALSE:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("false");
			result = _tmp3_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static void _tpf_persona_store_debug_print_status (TpfPersonaStore* self, FolksDebug* debug) {
	static const char domain[] = FOLKS_DEBUG_STATUS_LOG_DOMAIN;
	static const GLogLevelFlags level = G_LOG_LEVEL_INFO;
	FolksDebug* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_;
	FolksDebug* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	TpChannel* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	TpChannel* _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	TpChannel* _tmp19_;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	TpConnection* _tmp22_;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_;
	TpAccountManager* _tmp25_;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_;
	TpContact* _tmp28_;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_;
	FolksMaybeBool _tmp31_;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_;
	FolksMaybeBool _tmp34_;
	gchar* _tmp35_ = NULL;
	gchar* _tmp36_;
	FolksMaybeBool _tmp37_;
	gchar* _tmp38_ = NULL;
	gchar* _tmp39_;
	FolksMaybeBool _tmp40_;
	gchar* _tmp41_ = NULL;
	gchar* _tmp42_;
	FolksDebug* _tmp43_;
	GeeHashSet* _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	FolksDebug* _tmp47_;
	FolksDebug* _tmp81_;
	FolksDebug* _tmp82_;
	GeeHashMap* _tmp83_;
	gint _tmp84_;
	gint _tmp85_;
	FolksDebug* _tmp86_;
	GeeHashMap* _tmp87_;
	GeeMapIterator* _tmp88_ = NULL;
	GeeMapIterator* iter1;
	FolksDebug* _tmp96_;
	FolksDebug* _tmp97_;
	GeeHashMap* _tmp98_;
	gint _tmp99_;
	gint _tmp100_;
	FolksDebug* _tmp101_;
	GeeHashMap* _tmp102_;
	GeeMapIterator* _tmp103_ = NULL;
	GeeMapIterator* iter2;
	FolksDebug* _tmp122_;
	FolksDebug* _tmp123_;
	GeeHashMap* _tmp124_;
	gint _tmp125_;
	gint _tmp126_;
	FolksDebug* _tmp127_;
	GeeHashMap* _tmp128_;
	GeeMapIterator* _tmp129_ = NULL;
	GeeMapIterator* iter3;
	FolksDebug* _tmp148_;
	FolksDebug* _tmp149_;
	GeeHashMap* _tmp150_;
	gint _tmp151_;
	gint _tmp152_;
	FolksDebug* _tmp153_;
	GeeHashMap* _tmp154_;
	GeeMapIterator* _tmp155_ = NULL;
	GeeMapIterator* iter4;
	FolksDebug* _tmp175_;
	FolksDebug* _tmp176_;
	GeeHashMap* _tmp177_;
	gint _tmp178_;
	gint _tmp179_;
	FolksDebug* _tmp180_;
	GeeHashMap* _tmp181_;
	GeeMapIterator* _tmp182_ = NULL;
	GeeMapIterator* iter5;
	FolksDebug* _tmp202_;
	FolksDebug* _tmp203_;
	GeeHashMap* _tmp204_;
	gint _tmp205_;
	gint _tmp206_;
	FolksDebug* _tmp207_;
	GeeHashMap* _tmp208_;
	GeeMapIterator* _tmp209_ = NULL;
	GeeMapIterator* iter6;
	FolksDebug* _tmp218_;
	FolksDebug* _tmp219_;
	GeeHashMap* _tmp220_;
	gint _tmp221_;
	gint _tmp222_;
	FolksDebug* _tmp223_;
	GeeHashMap* _tmp224_;
	GeeMapIterator* _tmp225_ = NULL;
	GeeMapIterator* iter7;
	FolksDebug* _tmp234_;
	FolksDebug* _tmp235_;
	GeeHashMap* _tmp236_;
	gint _tmp237_;
	gint _tmp238_;
	FolksDebug* _tmp239_;
	GeeHashMap* _tmp240_;
	GeeMapIterator* _tmp241_ = NULL;
	GeeMapIterator* iter8;
	FolksDebug* _tmp250_;
	FolksDebug* _tmp251_;
	GeeHashSet* _tmp252_;
	gint _tmp253_;
	gint _tmp254_;
	FolksDebug* _tmp255_;
	FolksDebug* _tmp264_;
	FolksDebug* _tmp265_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (debug != NULL);
	_tmp0_ = debug;
	folks_debug_print_heading (_tmp0_, domain, level, "Tpf.PersonaStore (%p)", self);
	_tmp2_ = self->priv->_is_prepared;
	if (_tmp2_) {
		_tmp1_ = "yes";
	} else {
		_tmp1_ = "no";
	}
	_tmp4_ = self->priv->_got_stored_channel_members;
	if (_tmp4_) {
		_tmp3_ = "yes";
	} else {
		_tmp3_ = "no";
	}
	_tmp6_ = self->priv->_got_self_handle;
	if (_tmp6_) {
		_tmp5_ = "yes";
	} else {
		_tmp5_ = "no";
	}
	_tmp7_ = debug;
	_tmp8_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp1_;
	_tmp11_ = _tmp3_;
	_tmp12_ = _tmp5_;
	_tmp13_ = self->priv->_publish;
	_tmp14_ = g_strdup_printf ("%p", _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = self->priv->_stored;
	_tmp17_ = g_strdup_printf ("%p", _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = self->priv->_subscribe;
	_tmp20_ = g_strdup_printf ("%p", _tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = self->priv->_conn;
	_tmp23_ = g_strdup_printf ("%p", _tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = self->priv->_account_manager;
	_tmp26_ = g_strdup_printf ("%p", _tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = self->priv->_self_contact;
	_tmp29_ = g_strdup_printf ("%p", _tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = self->priv->_can_add_personas;
	_tmp32_ = _tpf_persona_store_format_maybe_bool (self, _tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = self->priv->_can_alias_personas;
	_tmp35_ = _tpf_persona_store_format_maybe_bool (self, _tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = self->priv->_can_group_personas;
	_tmp38_ = _tpf_persona_store_format_maybe_bool (self, _tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = self->priv->_can_remove_personas;
	_tmp41_ = _tpf_persona_store_format_maybe_bool (self, _tmp40_);
	_tmp42_ = _tmp41_;
	folks_debug_print_key_value_pairs (_tmp7_, domain, level, "ID", _tmp9_, "Prepared?", _tmp10_, "Has stored contact members?", _tmp11_, "Has self handle?", _tmp12_, "Publish TpChannel", _tmp15_, "Stored TpChannel", _tmp18_, "Subscribe TpChannel", _tmp21_, "TpConnection", _tmp24_, "TpAccountManager", _tmp27_, "Self-TpContact", _tmp30_, "Can add personas?", _tmp33_, "Can alias personas?", _tmp36_, "Can group personas?", _tmp39_, "Can remove personas?", _tmp42_, NULL);
	_g_free0 (_tmp42_);
	_g_free0 (_tmp39_);
	_g_free0 (_tmp36_);
	_g_free0 (_tmp33_);
	_g_free0 (_tmp30_);
	_g_free0 (_tmp27_);
	_g_free0 (_tmp24_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp15_);
	_tmp43_ = debug;
	_tmp44_ = self->priv->_persona_set;
	_tmp45_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp44_);
	_tmp46_ = _tmp45_;
	folks_debug_print_line (_tmp43_, domain, level, "%u Personas:", (guint) _tmp46_);
	_tmp47_ = debug;
	folks_debug_indent (_tmp47_);
	{
		GeeHashSet* _tmp48_;
		GeeIterator* _tmp49_ = NULL;
		GeeIterator* _persona_it;
		_tmp48_ = self->priv->_persona_set;
		_tmp49_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp48_);
		_persona_it = _tmp49_;
		while (TRUE) {
			GeeIterator* _tmp50_;
			gboolean _tmp51_ = FALSE;
			GeeIterator* _tmp52_;
			gpointer _tmp53_ = NULL;
			TpfPersona* persona;
			FolksDebug* _tmp54_;
			TpfPersona* _tmp55_;
			const gchar* _tmp56_ = NULL;
			TpfPersona* _tmp57_;
			gboolean _tmp58_;
			gboolean _tmp59_;
			const gchar* _tmp60_ = NULL;
			TpfPersona* _tmp61_;
			gboolean _tmp62_;
			gboolean _tmp63_;
			FolksDebug* _tmp64_;
			TpfPersona* _tmp65_;
			const gchar* _tmp66_;
			const gchar* _tmp67_;
			TpfPersona* _tmp68_;
			const gchar* _tmp69_;
			const gchar* _tmp70_;
			TpfPersona* _tmp71_;
			const gchar* _tmp72_;
			const gchar* _tmp73_;
			const gchar* _tmp74_;
			const gchar* _tmp75_;
			TpfPersona* _tmp76_;
			TpContact* _tmp77_;
			TpContact* _tmp78_;
			gchar* _tmp79_ = NULL;
			gchar* _tmp80_;
			_tmp50_ = _persona_it;
			_tmp51_ = gee_iterator_next (_tmp50_);
			if (!_tmp51_) {
				break;
			}
			_tmp52_ = _persona_it;
			_tmp53_ = gee_iterator_get (_tmp52_);
			persona = (TpfPersona*) _tmp53_;
			_tmp54_ = debug;
			_tmp55_ = persona;
			folks_debug_print_heading (_tmp54_, domain, level, "Persona (%p)", _tmp55_);
			_tmp57_ = persona;
			_tmp58_ = folks_persona_get_is_user ((FolksPersona*) _tmp57_);
			_tmp59_ = _tmp58_;
			if (_tmp59_) {
				_tmp56_ = "yes";
			} else {
				_tmp56_ = "no";
			}
			_tmp61_ = persona;
			_tmp62_ = tpf_persona_get_is_in_contact_list (_tmp61_);
			_tmp63_ = _tmp62_;
			if (_tmp63_) {
				_tmp60_ = "yes";
			} else {
				_tmp60_ = "no";
			}
			_tmp64_ = debug;
			_tmp65_ = persona;
			_tmp66_ = folks_persona_get_uid ((FolksPersona*) _tmp65_);
			_tmp67_ = _tmp66_;
			_tmp68_ = persona;
			_tmp69_ = folks_persona_get_iid ((FolksPersona*) _tmp68_);
			_tmp70_ = _tmp69_;
			_tmp71_ = persona;
			_tmp72_ = folks_persona_get_display_id ((FolksPersona*) _tmp71_);
			_tmp73_ = _tmp72_;
			_tmp74_ = _tmp56_;
			_tmp75_ = _tmp60_;
			_tmp76_ = persona;
			_tmp77_ = tpf_persona_get_contact (_tmp76_);
			_tmp78_ = _tmp77_;
			_tmp79_ = g_strdup_printf ("%p", _tmp78_);
			_tmp80_ = _tmp79_;
			folks_debug_print_key_value_pairs (_tmp64_, domain, level, "UID", _tmp67_, "IID", _tmp70_, "Display ID", _tmp73_, "User?", _tmp74_, "In contact list?", _tmp75_, "TpContact", _tmp80_, NULL);
			_g_free0 (_tmp80_);
			_g_object_unref0 (persona);
		}
		_g_object_unref0 (_persona_it);
	}
	_tmp81_ = debug;
	folks_debug_unindent (_tmp81_);
	_tmp82_ = debug;
	_tmp83_ = self->priv->_handle_persona_map;
	_tmp84_ = gee_abstract_map_get_size ((GeeMap*) _tmp83_);
	_tmp85_ = _tmp84_;
	folks_debug_print_line (_tmp82_, domain, level, "%u handle–Persona mappings:", (guint) _tmp85_);
	_tmp86_ = debug;
	folks_debug_indent (_tmp86_);
	_tmp87_ = self->priv->_handle_persona_map;
	_tmp88_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp87_);
	iter1 = _tmp88_;
	while (TRUE) {
		GeeMapIterator* _tmp89_;
		gboolean _tmp90_ = FALSE;
		FolksDebug* _tmp91_;
		GeeMapIterator* _tmp92_;
		gpointer _tmp93_ = NULL;
		GeeMapIterator* _tmp94_;
		gpointer _tmp95_ = NULL;
		_tmp89_ = iter1;
		_tmp90_ = gee_map_iterator_next (_tmp89_);
		if (!(_tmp90_ == TRUE)) {
			break;
		}
		_tmp91_ = debug;
		_tmp92_ = iter1;
		_tmp93_ = gee_map_iterator_get_key (_tmp92_);
		_tmp94_ = iter1;
		_tmp95_ = gee_map_iterator_get_value (_tmp94_);
		folks_debug_print_line (_tmp91_, domain, level, "%u → %p", GPOINTER_TO_UINT (_tmp93_), (TpfPersona*) _tmp95_);
	}
	_tmp96_ = debug;
	folks_debug_unindent (_tmp96_);
	_tmp97_ = debug;
	_tmp98_ = self->priv->_channel_group_personas_map;
	_tmp99_ = gee_abstract_map_get_size ((GeeMap*) _tmp98_);
	_tmp100_ = _tmp99_;
	folks_debug_print_line (_tmp97_, domain, level, "%u channel group Persona sets:", (guint) _tmp100_);
	_tmp101_ = debug;
	folks_debug_indent (_tmp101_);
	_tmp102_ = self->priv->_channel_group_personas_map;
	_tmp103_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp102_);
	iter2 = _tmp103_;
	while (TRUE) {
		GeeMapIterator* _tmp104_;
		gboolean _tmp105_ = FALSE;
		FolksDebug* _tmp106_;
		GeeMapIterator* _tmp107_;
		gpointer _tmp108_ = NULL;
		FolksDebug* _tmp109_;
		FolksDebug* _tmp121_;
		_tmp104_ = iter2;
		_tmp105_ = gee_map_iterator_next (_tmp104_);
		if (!(_tmp105_ == TRUE)) {
			break;
		}
		_tmp106_ = debug;
		_tmp107_ = iter2;
		_tmp108_ = gee_map_iterator_get_key (_tmp107_);
		folks_debug_print_heading (_tmp106_, domain, level, "Channel (%p):", (TpChannel*) _tmp108_);
		_tmp109_ = debug;
		folks_debug_indent (_tmp109_);
		{
			GeeMapIterator* _tmp110_;
			gpointer _tmp111_ = NULL;
			GeeHashSet* _tmp112_;
			GeeIterator* _tmp113_ = NULL;
			GeeIterator* _tmp114_;
			GeeIterator* _persona_it;
			_tmp110_ = iter2;
			_tmp111_ = gee_map_iterator_get_value (_tmp110_);
			_tmp112_ = (GeeHashSet*) _tmp111_;
			_tmp113_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp112_);
			_tmp114_ = _tmp113_;
			_g_object_unref0 (_tmp112_);
			_persona_it = _tmp114_;
			while (TRUE) {
				GeeIterator* _tmp115_;
				gboolean _tmp116_ = FALSE;
				GeeIterator* _tmp117_;
				gpointer _tmp118_ = NULL;
				TpfPersona* persona;
				FolksDebug* _tmp119_;
				TpfPersona* _tmp120_;
				_tmp115_ = _persona_it;
				_tmp116_ = gee_iterator_next (_tmp115_);
				if (!_tmp116_) {
					break;
				}
				_tmp117_ = _persona_it;
				_tmp118_ = gee_iterator_get (_tmp117_);
				persona = (TpfPersona*) _tmp118_;
				_tmp119_ = debug;
				_tmp120_ = persona;
				folks_debug_print_line (_tmp119_, domain, level, "%p", _tmp120_);
				_g_object_unref0 (persona);
			}
			_g_object_unref0 (_persona_it);
		}
		_tmp121_ = debug;
		folks_debug_unindent (_tmp121_);
	}
	_tmp122_ = debug;
	folks_debug_unindent (_tmp122_);
	_tmp123_ = debug;
	_tmp124_ = self->priv->_channel_group_incoming_adds;
	_tmp125_ = gee_abstract_map_get_size ((GeeMap*) _tmp124_);
	_tmp126_ = _tmp125_;
	folks_debug_print_line (_tmp123_, domain, level, "%u channel group incoming handle sets:", (guint) _tmp126_);
	_tmp127_ = debug;
	folks_debug_indent (_tmp127_);
	_tmp128_ = self->priv->_channel_group_incoming_adds;
	_tmp129_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp128_);
	iter3 = _tmp129_;
	while (TRUE) {
		GeeMapIterator* _tmp130_;
		gboolean _tmp131_ = FALSE;
		FolksDebug* _tmp132_;
		GeeMapIterator* _tmp133_;
		gpointer _tmp134_ = NULL;
		FolksDebug* _tmp135_;
		FolksDebug* _tmp147_;
		_tmp130_ = iter3;
		_tmp131_ = gee_map_iterator_next (_tmp130_);
		if (!(_tmp131_ == TRUE)) {
			break;
		}
		_tmp132_ = debug;
		_tmp133_ = iter3;
		_tmp134_ = gee_map_iterator_get_key (_tmp133_);
		folks_debug_print_heading (_tmp132_, domain, level, "Channel (%p):", (TpChannel*) _tmp134_);
		_tmp135_ = debug;
		folks_debug_indent (_tmp135_);
		{
			GeeMapIterator* _tmp136_;
			gpointer _tmp137_ = NULL;
			GeeHashSet* _tmp138_;
			GeeIterator* _tmp139_ = NULL;
			GeeIterator* _tmp140_;
			GeeIterator* _handle_it;
			_tmp136_ = iter3;
			_tmp137_ = gee_map_iterator_get_value (_tmp136_);
			_tmp138_ = (GeeHashSet*) _tmp137_;
			_tmp139_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp138_);
			_tmp140_ = _tmp139_;
			_g_object_unref0 (_tmp138_);
			_handle_it = _tmp140_;
			while (TRUE) {
				GeeIterator* _tmp141_;
				gboolean _tmp142_ = FALSE;
				GeeIterator* _tmp143_;
				gpointer _tmp144_ = NULL;
				guint handle;
				FolksDebug* _tmp145_;
				guint _tmp146_;
				_tmp141_ = _handle_it;
				_tmp142_ = gee_iterator_next (_tmp141_);
				if (!_tmp142_) {
					break;
				}
				_tmp143_ = _handle_it;
				_tmp144_ = gee_iterator_get (_tmp143_);
				handle = GPOINTER_TO_UINT (_tmp144_);
				_tmp145_ = debug;
				_tmp146_ = handle;
				folks_debug_print_line (_tmp145_, domain, level, "%u", _tmp146_);
			}
			_g_object_unref0 (_handle_it);
		}
		_tmp147_ = debug;
		folks_debug_unindent (_tmp147_);
	}
	_tmp148_ = debug;
	folks_debug_unindent (_tmp148_);
	_tmp149_ = debug;
	_tmp150_ = self->priv->_group_outgoing_adds;
	_tmp151_ = gee_abstract_map_get_size ((GeeMap*) _tmp150_);
	_tmp152_ = _tmp151_;
	folks_debug_print_line (_tmp149_, domain, level, "%u group outgoing add sets:", (guint) _tmp152_);
	_tmp153_ = debug;
	folks_debug_indent (_tmp153_);
	_tmp154_ = self->priv->_group_outgoing_adds;
	_tmp155_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp154_);
	iter4 = _tmp155_;
	while (TRUE) {
		GeeMapIterator* _tmp156_;
		gboolean _tmp157_ = FALSE;
		FolksDebug* _tmp158_;
		GeeMapIterator* _tmp159_;
		gpointer _tmp160_ = NULL;
		gchar* _tmp161_;
		FolksDebug* _tmp162_;
		FolksDebug* _tmp174_;
		_tmp156_ = iter4;
		_tmp157_ = gee_map_iterator_next (_tmp156_);
		if (!(_tmp157_ == TRUE)) {
			break;
		}
		_tmp158_ = debug;
		_tmp159_ = iter4;
		_tmp160_ = gee_map_iterator_get_key (_tmp159_);
		_tmp161_ = (gchar*) _tmp160_;
		folks_debug_print_heading (_tmp158_, domain, level, "Group (%s):", _tmp161_);
		_g_free0 (_tmp161_);
		_tmp162_ = debug;
		folks_debug_indent (_tmp162_);
		{
			GeeMapIterator* _tmp163_;
			gpointer _tmp164_ = NULL;
			GeeHashSet* _tmp165_;
			GeeIterator* _tmp166_ = NULL;
			GeeIterator* _tmp167_;
			GeeIterator* _persona_it;
			_tmp163_ = iter4;
			_tmp164_ = gee_map_iterator_get_value (_tmp163_);
			_tmp165_ = (GeeHashSet*) _tmp164_;
			_tmp166_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp165_);
			_tmp167_ = _tmp166_;
			_g_object_unref0 (_tmp165_);
			_persona_it = _tmp167_;
			while (TRUE) {
				GeeIterator* _tmp168_;
				gboolean _tmp169_ = FALSE;
				GeeIterator* _tmp170_;
				gpointer _tmp171_ = NULL;
				TpfPersona* persona;
				FolksDebug* _tmp172_;
				TpfPersona* _tmp173_;
				_tmp168_ = _persona_it;
				_tmp169_ = gee_iterator_next (_tmp168_);
				if (!_tmp169_) {
					break;
				}
				_tmp170_ = _persona_it;
				_tmp171_ = gee_iterator_get (_tmp170_);
				persona = (TpfPersona*) _tmp171_;
				_tmp172_ = debug;
				_tmp173_ = persona;
				folks_debug_print_line (_tmp172_, domain, level, "%p", _tmp173_);
				_g_object_unref0 (persona);
			}
			_g_object_unref0 (_persona_it);
		}
		_tmp174_ = debug;
		folks_debug_unindent (_tmp174_);
	}
	_tmp175_ = debug;
	folks_debug_unindent (_tmp175_);
	_tmp176_ = debug;
	_tmp177_ = self->priv->_group_outgoing_removes;
	_tmp178_ = gee_abstract_map_get_size ((GeeMap*) _tmp177_);
	_tmp179_ = _tmp178_;
	folks_debug_print_line (_tmp176_, domain, level, "%u group outgoing remove sets:", (guint) _tmp179_);
	_tmp180_ = debug;
	folks_debug_indent (_tmp180_);
	_tmp181_ = self->priv->_group_outgoing_removes;
	_tmp182_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp181_);
	iter5 = _tmp182_;
	while (TRUE) {
		GeeMapIterator* _tmp183_;
		gboolean _tmp184_ = FALSE;
		FolksDebug* _tmp185_;
		GeeMapIterator* _tmp186_;
		gpointer _tmp187_ = NULL;
		gchar* _tmp188_;
		FolksDebug* _tmp189_;
		FolksDebug* _tmp201_;
		_tmp183_ = iter5;
		_tmp184_ = gee_map_iterator_next (_tmp183_);
		if (!(_tmp184_ == TRUE)) {
			break;
		}
		_tmp185_ = debug;
		_tmp186_ = iter5;
		_tmp187_ = gee_map_iterator_get_key (_tmp186_);
		_tmp188_ = (gchar*) _tmp187_;
		folks_debug_print_heading (_tmp185_, domain, level, "Group (%s):", _tmp188_);
		_g_free0 (_tmp188_);
		_tmp189_ = debug;
		folks_debug_indent (_tmp189_);
		{
			GeeMapIterator* _tmp190_;
			gpointer _tmp191_ = NULL;
			GeeHashSet* _tmp192_;
			GeeIterator* _tmp193_ = NULL;
			GeeIterator* _tmp194_;
			GeeIterator* _persona_it;
			_tmp190_ = iter5;
			_tmp191_ = gee_map_iterator_get_value (_tmp190_);
			_tmp192_ = (GeeHashSet*) _tmp191_;
			_tmp193_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp192_);
			_tmp194_ = _tmp193_;
			_g_object_unref0 (_tmp192_);
			_persona_it = _tmp194_;
			while (TRUE) {
				GeeIterator* _tmp195_;
				gboolean _tmp196_ = FALSE;
				GeeIterator* _tmp197_;
				gpointer _tmp198_ = NULL;
				TpfPersona* persona;
				FolksDebug* _tmp199_;
				TpfPersona* _tmp200_;
				_tmp195_ = _persona_it;
				_tmp196_ = gee_iterator_next (_tmp195_);
				if (!_tmp196_) {
					break;
				}
				_tmp197_ = _persona_it;
				_tmp198_ = gee_iterator_get (_tmp197_);
				persona = (TpfPersona*) _tmp198_;
				_tmp199_ = debug;
				_tmp200_ = persona;
				folks_debug_print_line (_tmp199_, domain, level, "%p", _tmp200_);
				_g_object_unref0 (persona);
			}
			_g_object_unref0 (_persona_it);
		}
		_tmp201_ = debug;
		folks_debug_unindent (_tmp201_);
	}
	_tmp202_ = debug;
	folks_debug_unindent (_tmp202_);
	_tmp203_ = debug;
	_tmp204_ = self->priv->_standard_channels_unready;
	_tmp205_ = gee_abstract_map_get_size ((GeeMap*) _tmp204_);
	_tmp206_ = _tmp205_;
	folks_debug_print_line (_tmp203_, domain, level, "%u unready standard channels:", (guint) _tmp206_);
	_tmp207_ = debug;
	folks_debug_indent (_tmp207_);
	_tmp208_ = self->priv->_standard_channels_unready;
	_tmp209_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp208_);
	iter6 = _tmp209_;
	while (TRUE) {
		GeeMapIterator* _tmp210_;
		gboolean _tmp211_ = FALSE;
		FolksDebug* _tmp212_;
		GeeMapIterator* _tmp213_;
		gpointer _tmp214_ = NULL;
		gchar* _tmp215_;
		GeeMapIterator* _tmp216_;
		gpointer _tmp217_ = NULL;
		_tmp210_ = iter6;
		_tmp211_ = gee_map_iterator_next (_tmp210_);
		if (!(_tmp211_ == TRUE)) {
			break;
		}
		_tmp212_ = debug;
		_tmp213_ = iter6;
		_tmp214_ = gee_map_iterator_get_key (_tmp213_);
		_tmp215_ = (gchar*) _tmp214_;
		_tmp216_ = iter6;
		_tmp217_ = gee_map_iterator_get_value (_tmp216_);
		folks_debug_print_line (_tmp212_, domain, level, "%s → %p", _tmp215_, (TpChannel*) _tmp217_);
		_g_free0 (_tmp215_);
	}
	_tmp218_ = debug;
	folks_debug_unindent (_tmp218_);
	_tmp219_ = debug;
	_tmp220_ = self->priv->_group_channels_unready;
	_tmp221_ = gee_abstract_map_get_size ((GeeMap*) _tmp220_);
	_tmp222_ = _tmp221_;
	folks_debug_print_line (_tmp219_, domain, level, "%u unready group channels:", (guint) _tmp222_);
	_tmp223_ = debug;
	folks_debug_indent (_tmp223_);
	_tmp224_ = self->priv->_group_channels_unready;
	_tmp225_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp224_);
	iter7 = _tmp225_;
	while (TRUE) {
		GeeMapIterator* _tmp226_;
		gboolean _tmp227_ = FALSE;
		FolksDebug* _tmp228_;
		GeeMapIterator* _tmp229_;
		gpointer _tmp230_ = NULL;
		gchar* _tmp231_;
		GeeMapIterator* _tmp232_;
		gpointer _tmp233_ = NULL;
		_tmp226_ = iter7;
		_tmp227_ = gee_map_iterator_next (_tmp226_);
		if (!(_tmp227_ == TRUE)) {
			break;
		}
		_tmp228_ = debug;
		_tmp229_ = iter7;
		_tmp230_ = gee_map_iterator_get_key (_tmp229_);
		_tmp231_ = (gchar*) _tmp230_;
		_tmp232_ = iter7;
		_tmp233_ = gee_map_iterator_get_value (_tmp232_);
		folks_debug_print_line (_tmp228_, domain, level, "%s → %p", _tmp231_, (TpChannel*) _tmp233_);
		_g_free0 (_tmp231_);
	}
	_tmp234_ = debug;
	folks_debug_unindent (_tmp234_);
	_tmp235_ = debug;
	_tmp236_ = self->priv->_groups;
	_tmp237_ = gee_abstract_map_get_size ((GeeMap*) _tmp236_);
	_tmp238_ = _tmp237_;
	folks_debug_print_line (_tmp235_, domain, level, "%u ready group channels:", (guint) _tmp238_);
	_tmp239_ = debug;
	folks_debug_indent (_tmp239_);
	_tmp240_ = self->priv->_groups;
	_tmp241_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp240_);
	iter8 = _tmp241_;
	while (TRUE) {
		GeeMapIterator* _tmp242_;
		gboolean _tmp243_ = FALSE;
		FolksDebug* _tmp244_;
		GeeMapIterator* _tmp245_;
		gpointer _tmp246_ = NULL;
		gchar* _tmp247_;
		GeeMapIterator* _tmp248_;
		gpointer _tmp249_ = NULL;
		_tmp242_ = iter8;
		_tmp243_ = gee_map_iterator_next (_tmp242_);
		if (!(_tmp243_ == TRUE)) {
			break;
		}
		_tmp244_ = debug;
		_tmp245_ = iter8;
		_tmp246_ = gee_map_iterator_get_key (_tmp245_);
		_tmp247_ = (gchar*) _tmp246_;
		_tmp248_ = iter8;
		_tmp249_ = gee_map_iterator_get_value (_tmp248_);
		folks_debug_print_line (_tmp244_, domain, level, "%s → %p", _tmp247_, (TpChannel*) _tmp249_);
		_g_free0 (_tmp247_);
	}
	_tmp250_ = debug;
	folks_debug_unindent (_tmp250_);
	_tmp251_ = debug;
	_tmp252_ = self->priv->_favourite_handles;
	_tmp253_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp252_);
	_tmp254_ = _tmp253_;
	folks_debug_print_line (_tmp251_, domain, level, "%u favourite handles:", (guint) _tmp254_);
	_tmp255_ = debug;
	folks_debug_indent (_tmp255_);
	{
		GeeHashSet* _tmp256_;
		GeeIterator* _tmp257_ = NULL;
		GeeIterator* _handle_it;
		_tmp256_ = self->priv->_favourite_handles;
		_tmp257_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp256_);
		_handle_it = _tmp257_;
		while (TRUE) {
			GeeIterator* _tmp258_;
			gboolean _tmp259_ = FALSE;
			GeeIterator* _tmp260_;
			gpointer _tmp261_ = NULL;
			guint handle;
			FolksDebug* _tmp262_;
			guint _tmp263_;
			_tmp258_ = _handle_it;
			_tmp259_ = gee_iterator_next (_tmp258_);
			if (!_tmp259_) {
				break;
			}
			_tmp260_ = _handle_it;
			_tmp261_ = gee_iterator_get (_tmp260_);
			handle = GPOINTER_TO_UINT (_tmp261_);
			_tmp262_ = debug;
			_tmp263_ = handle;
			folks_debug_print_line (_tmp262_, domain, level, "%u", _tmp263_);
		}
		_g_object_unref0 (_handle_it);
	}
	_tmp264_ = debug;
	folks_debug_unindent (_tmp264_);
	_tmp265_ = debug;
	folks_debug_print_line (_tmp265_, domain, level, "");
	_g_object_unref0 (iter8);
	_g_object_unref0 (iter7);
	_g_object_unref0 (iter6);
	_g_object_unref0 (iter5);
	_g_object_unref0 (iter4);
	_g_object_unref0 (iter3);
	_g_object_unref0 (iter2);
	_g_object_unref0 (iter1);
}


static void __tpf_persona_store_self_handle_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona_store_self_handle_changed_cb (self, _sender, pspec);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __tpf_persona_store_contact_weak_notify_cb_gweak_notify (gpointer self, GObject* object) {
	_tpf_persona_store_contact_weak_notify_cb (self, object);
}


static void _tpf_persona_store_reset (TpfPersonaStore* self) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	TpAccount* _tmp3_;
	TpAccount* _tmp4_;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp9_;
	GeeHashMap* _tmp10_;
	GeeHashMap* _tmp11_;
	GeeMap* _tmp12_;
	GeeMap* _tmp13_;
	GeeHashSet* _tmp14_;
	TpConnection* _tmp15_;
	GeeHashMap* _tmp19_;
	GeeHashMap* _tmp28_;
	GeeHashMap* _tmp29_;
	GeeHashMap* _tmp30_;
	GeeHashMap* _tmp31_;
	GeeHashMap* _tmp32_;
	GeeHashMap* _tmp33_;
	TpChannel* _tmp34_;
	TpChannel* _tmp36_;
	TpChannel* _tmp38_;
	GeeHashMap* _tmp40_;
	GeeHashMap* _tmp41_;
	GeeHashMap* _tmp42_;
	GeeHashSet* _tmp55_;
	GeeHashSet* _tmp56_;
	GeeSet* _tmp57_;
	GeeSet* _tmp58_;
	GeeHashMap* _tmp59_;
	GeeHashSet* _tmp60_;
	g_return_if_fail (self != NULL);
	_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp1_ = _tmp0_;
	g_debug ("tpf-persona-store.vala:523: Resetting Tpf.PersonaStore %p ('%s')", self, _tmp1_);
	_tmp3_ = tpf_persona_store_get_account (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = tp_account_get_protocol (_tmp4_);
	if (g_strcmp0 (_tmp5_, "local-xmpp") == 0) {
		_tmp2_ = TRUE;
	} else {
		TpAccount* _tmp6_;
		TpAccount* _tmp7_;
		const gchar* _tmp8_ = NULL;
		_tmp6_ = tpf_persona_store_get_account (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = tp_account_get_protocol (_tmp7_);
		_tmp2_ = g_strcmp0 (_tmp8_, "irc") == 0;
	}
	_tmp9_ = _tmp2_;
	if (_tmp9_) {
		folks_persona_store_set_trust_level ((FolksPersonaStore*) self, FOLKS_PERSONA_STORE_TRUST_NONE);
	} else {
		folks_persona_store_set_trust_level ((FolksPersonaStore*) self, FOLKS_PERSONA_STORE_TRUST_PARTIAL);
	}
	_tmp10_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_personas);
	self->priv->_personas = _tmp10_;
	_tmp11_ = self->priv->_personas;
	_tmp12_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp11_);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (self->priv->_personas_ro);
	self->priv->_personas_ro = _tmp13_;
	_tmp14_ = gee_hash_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	_g_object_unref0 (self->priv->_persona_set);
	self->priv->_persona_set = _tmp14_;
	_tmp15_ = self->priv->_conn;
	if (_tmp15_ != NULL) {
		TpConnection* _tmp16_;
		guint _tmp17_ = 0U;
		GQuark _tmp18_ = 0U;
		_tmp16_ = self->priv->_conn;
		g_signal_parse_name ("notify::self-handle", G_TYPE_OBJECT, &_tmp17_, &_tmp18_, TRUE);
		g_signal_handlers_disconnect_matched ((GObject*) _tmp16_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp17_, _tmp18_, NULL, (GCallback) __tpf_persona_store_self_handle_changed_cb_g_object_notify, self);
		_g_object_unref0 (self->priv->_conn);
		self->priv->_conn = NULL;
	}
	_tmp19_ = self->priv->_weakly_referenced_contacts;
	if (_tmp19_ != NULL) {
		GeeHashMap* _tmp20_;
		GeeMapIterator* _tmp21_ = NULL;
		GeeMapIterator* iter;
		_tmp20_ = self->priv->_weakly_referenced_contacts;
		_tmp21_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp20_);
		iter = _tmp21_;
		while (TRUE) {
			GeeMapIterator* _tmp22_;
			gboolean _tmp23_ = FALSE;
			GeeMapIterator* _tmp24_;
			gpointer _tmp25_ = NULL;
			TpContact* _tmp26_;
			TpContact* contact;
			TpContact* _tmp27_;
			_tmp22_ = iter;
			_tmp23_ = gee_map_iterator_next (_tmp22_);
			if (!(_tmp23_ == TRUE)) {
				break;
			}
			_tmp24_ = iter;
			_tmp25_ = gee_map_iterator_get_key (_tmp24_);
			_tmp26_ = _g_object_ref0 ((TpContact*) _tmp25_);
			contact = _tmp26_;
			_tmp27_ = contact;
			g_object_weak_unref ((GObject*) _tmp27_, __tpf_persona_store_contact_weak_notify_cb_gweak_notify, self);
			_g_object_unref0 (contact);
		}
		_g_object_unref0 (iter);
	}
	_tmp28_ = gee_hash_map_new (tp_contact_get_type (), NULL, NULL, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_weakly_referenced_contacts);
	self->priv->_weakly_referenced_contacts = _tmp28_;
	_tmp29_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_handle_persona_map);
	self->priv->_handle_persona_map = _tmp29_;
	_tmp30_ = gee_hash_map_new (tp_channel_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, GEE_TYPE_HASH_SET, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_channel_group_personas_map);
	self->priv->_channel_group_personas_map = _tmp30_;
	_tmp31_ = gee_hash_map_new (tp_channel_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, GEE_TYPE_HASH_SET, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_channel_group_incoming_adds);
	self->priv->_channel_group_incoming_adds = _tmp31_;
	_tmp32_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_HASH_SET, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_group_outgoing_adds);
	self->priv->_group_outgoing_adds = _tmp32_;
	_tmp33_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_HASH_SET, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_group_outgoing_removes);
	self->priv->_group_outgoing_removes = _tmp33_;
	_tmp34_ = self->priv->_publish;
	if (_tmp34_ != NULL) {
		TpChannel* _tmp35_;
		_tmp35_ = self->priv->_publish;
		_tpf_persona_store_disconnect_from_standard_channel (self, _tmp35_);
		_g_object_unref0 (self->priv->_publish);
		self->priv->_publish = NULL;
	}
	_tmp36_ = self->priv->_stored;
	if (_tmp36_ != NULL) {
		TpChannel* _tmp37_;
		_tmp37_ = self->priv->_stored;
		_tpf_persona_store_disconnect_from_standard_channel (self, _tmp37_);
		_g_object_unref0 (self->priv->_stored);
		self->priv->_stored = NULL;
	}
	_tmp38_ = self->priv->_subscribe;
	if (_tmp38_ != NULL) {
		TpChannel* _tmp39_;
		_tmp39_ = self->priv->_subscribe;
		_tpf_persona_store_disconnect_from_standard_channel (self, _tmp39_);
		_g_object_unref0 (self->priv->_subscribe);
		self->priv->_subscribe = NULL;
	}
	_tmp40_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, tp_channel_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_standard_channels_unready);
	self->priv->_standard_channels_unready = _tmp40_;
	_tmp41_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, tp_channel_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_group_channels_unready);
	self->priv->_group_channels_unready = _tmp41_;
	_tmp42_ = self->priv->_groups;
	if (_tmp42_ != NULL) {
		{
			GeeHashMap* _tmp43_;
			GeeCollection* _tmp44_;
			GeeCollection* _tmp45_;
			GeeCollection* _tmp46_;
			GeeIterator* _tmp47_ = NULL;
			GeeIterator* _tmp48_;
			GeeIterator* _channel_it;
			_tmp43_ = self->priv->_groups;
			_tmp44_ = gee_abstract_map_get_values ((GeeMap*) _tmp43_);
			_tmp45_ = _tmp44_;
			_tmp46_ = _tmp45_;
			_tmp47_ = gee_iterable_iterator ((GeeIterable*) _tmp46_);
			_tmp48_ = _tmp47_;
			_g_object_unref0 (_tmp46_);
			_channel_it = _tmp48_;
			while (TRUE) {
				GeeIterator* _tmp49_;
				gboolean _tmp50_ = FALSE;
				GeeIterator* _tmp51_;
				gpointer _tmp52_ = NULL;
				TpChannel* channel;
				TpChannel* _tmp53_;
				_tmp49_ = _channel_it;
				_tmp50_ = gee_iterator_next (_tmp49_);
				if (!_tmp50_) {
					break;
				}
				_tmp51_ = _channel_it;
				_tmp52_ = gee_iterator_get (_tmp51_);
				channel = (TpChannel*) _tmp52_;
				_tmp53_ = channel;
				if (_tmp53_ != NULL) {
					TpChannel* _tmp54_;
					_tmp54_ = channel;
					_tpf_persona_store_disconnect_from_group_channel (self, _tmp54_);
				}
				_g_object_unref0 (channel);
			}
			_g_object_unref0 (_channel_it);
		}
	}
	_tmp55_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	_g_object_unref0 (self->_supported_fields);
	self->_supported_fields = _tmp55_;
	_tmp56_ = self->_supported_fields;
	_tmp57_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp56_);
	_tmp58_ = _tmp57_;
	_g_object_unref0 (self->_supported_fields_ro);
	self->_supported_fields_ro = _tmp58_;
	_tmp59_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, tp_channel_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_groups);
	self->priv->_groups = _tmp59_;
	_tmp60_ = gee_hash_set_new (G_TYPE_UINT, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_favourite_handles);
	self->priv->_favourite_handles = _tmp60_;
	_g_object_unref0 (self->priv->_self_contact);
	self->priv->_self_contact = NULL;
}


static void _tpf_persona_store_remove_store (TpfPersonaStore* self) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GeeHashSet* _tmp2_;
	TpfPersonaStoreCache* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp1_ = _tmp0_;
	g_debug ("tpf-persona-store.vala:605: Removing store %s (%p)", _tmp1_, self);
	_tmp2_ = self->priv->_persona_set;
	_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, NULL, (GeeSet*) _tmp2_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	_tmp3_ = self->priv->_cache;
	folks_object_cache_clear_cache ((FolksObjectCache*) _tmp3_, NULL, NULL);
	g_signal_emit_by_name ((FolksPersonaStore*) self, "removed");
}


static void tpf_persona_store_real_prepare_data_free (gpointer _data) {
	TpfPersonaStorePrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStorePrepareData, _data_);
}


static void tpf_persona_store_real_prepare (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStore * self;
	TpfPersonaStorePrepareData* _data_;
	TpfPersonaStore* _tmp0_;
	self = (TpfPersonaStore*) base;
	_data_ = g_slice_new0 (TpfPersonaStorePrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_real_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_real_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	tpf_persona_store_real_prepare_co (_data_);
}


static void tpf_persona_store_real_prepare_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaStorePrepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Prepare the PersonaStore for use.
   *
   * See {@link Folks.PersonaStore.prepare}.
   */
static void _____lambda8_ (TpfPersonaStore* self, TpAccount* a) {
	TpAccount* _tmp0_;
	TpAccount* _tmp1_;
	TpAccount* _tmp2_;
	g_return_if_fail (a != NULL);
	_tmp0_ = tpf_persona_store_get_account (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = a;
	if (_tmp1_ == _tmp2_) {
		_tpf_persona_store_remove_store (self);
	}
}


static void ______lambda8__tp_account_manager_account_removed (TpAccountManager* _sender, TpAccount* account, gpointer self) {
	_____lambda8_ (self, account);
}


static void _____lambda9_ (TpfPersonaStore* self, TpAccount* a, gboolean valid) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	TpAccount* _tmp2_;
	TpAccount* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_;
	gboolean _tmp12_;
	g_return_if_fail (a != NULL);
	_tmp1_ = valid;
	if (_tmp1_) {
		_tmp0_ = "true";
	} else {
		_tmp0_ = "false";
	}
	_tmp2_ = a;
	_tmp3_ = a;
	_tmp4_ = tp_account_get_display_name (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp0_;
	g_debug ("tpf-persona-store.vala:644: Account validity changed for %p (‘%s’) to " \
"%s.", _tmp2_, _tmp5_, _tmp6_);
	_tmp8_ = valid;
	if (!_tmp8_) {
		TpAccount* _tmp9_;
		TpAccount* _tmp10_;
		TpAccount* _tmp11_;
		_tmp9_ = tpf_persona_store_get_account (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = a;
		_tmp7_ = _tmp10_ == _tmp11_;
	} else {
		_tmp7_ = FALSE;
	}
	_tmp12_ = _tmp7_;
	if (_tmp12_) {
		_tpf_persona_store_remove_store (self);
	}
}


static void ______lambda9__tp_account_manager_account_validity_changed (TpAccountManager* _sender, TpAccount* account, gboolean valid, gpointer self) {
	_____lambda9_ (self, account, valid);
}


static void tpf_persona_store_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStorePrepareData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_store_real_prepare_co (_data_);
}


static void __tpf_persona_store_favourite_contacts_changed_cb_logger_favourite_contacts_changed (Logger* _sender, gchar** added, int added_length1, gchar** removed, int removed_length1, gpointer self) {
	_tpf_persona_store_favourite_contacts_changed_cb (self, added, added_length1, removed, removed_length1);
}


static void __tpf_persona_store_notify_connection_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona_store_notify_connection_cb (self, _sender, pspec);
}


static gboolean tpf_persona_store_real_prepare_co (TpfPersonaStorePrepareData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->_is_prepared;
		g_static_rec_mutex_lock (&_data_->self->priv->__lock__is_prepared);
		{
			_data_->_tmp2_ = _data_->self->priv->_is_prepared;
			if (_data_->_tmp2_) {
				_data_->_tmp1_ = TRUE;
			} else {
				_data_->_tmp3_ = _data_->self->priv->_prepare_pending;
				_data_->_tmp1_ = _data_->_tmp3_;
			}
			_data_->_tmp4_ = _data_->_tmp1_;
			if (_data_->_tmp4_) {
				{
					_data_->_tmp5_ = _data_->self->priv->_is_prepared;
					g_static_rec_mutex_unlock (&_data_->self->priv->__lock__is_prepared);
				}
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			{
				_data_->self->priv->_prepare_pending = TRUE;
				_data_->_tmp6_ = NULL;
				_data_->_tmp6_ = tp_account_manager_dup ();
				_g_object_unref0 (_data_->self->priv->_account_manager);
				_data_->self->priv->_account_manager = _data_->_tmp6_;
				_data_->_tmp7_ = _data_->self->priv->_account_manager;
				g_signal_connect_object ((TpProxy*) _data_->_tmp7_, "invalidated", (GCallback) __tpf_persona_store_account_manager_invalidated_cb_tp_proxy_invalidated, _data_->self, 0);
				_data_->_tmp8_ = _data_->self->priv->_account_manager;
				g_signal_connect_object (_data_->_tmp8_, "account-removed", (GCallback) ______lambda8__tp_account_manager_account_removed, _data_->self, 0);
				_data_->_tmp9_ = _data_->self->priv->_account_manager;
				g_signal_connect_object (_data_->_tmp9_, "account-validity-changed", (GCallback) ______lambda9__tp_account_manager_account_validity_changed, _data_->self, 0);
				{
					_data_->_tmp10_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
					_data_->_tmp11_ = _data_->_tmp10_;
					_data_->_tmp12_ = logger_new (_data_->_tmp11_);
					_g_object_unref0 (_data_->self->priv->_logger);
					_data_->self->priv->_logger = _data_->_tmp12_;
					_data_->_tmp13_ = _data_->self->priv->_logger;
					_data_->_state_ = 1;
					logger_prepare (_data_->_tmp13_, tpf_persona_store_prepare_ready, _data_);
					return FALSE;
					_state_1:
					logger_prepare_finish (_data_->_tmp13_, _data_->_res_, &_data_->_inner_error_);
					if (_data_->_inner_error_ != NULL) {
						goto __catch6_g_error;
					}
					_data_->_tmp14_ = _data_->self->priv->_logger;
					g_signal_connect_object (_data_->_tmp14_, "invalidated", (GCallback) __tpf_persona_store_logger_invalidated_cb_logger_invalidated, _data_->self, 0);
					_data_->_tmp15_ = _data_->self->priv->_logger;
					g_signal_connect_object (_data_->_tmp15_, "favourite-contacts-changed", (GCallback) __tpf_persona_store_favourite_contacts_changed_cb_logger_favourite_contacts_changed, _data_->self, 0);
				}
				goto __finally6;
				__catch6_g_error:
				{
					_data_->e = _data_->_inner_error_;
					_data_->_inner_error_ = NULL;
					_data_->_tmp16_ = NULL;
					_data_->_tmp16_ = _ ("Couldn't connect to the telepathy-logger service.");
					g_warning ("tpf-persona-store.vala:667: %s", _data_->_tmp16_);
					_g_object_unref0 (_data_->self->priv->_logger);
					_data_->self->priv->_logger = NULL;
					_g_error_free0 (_data_->e);
				}
				__finally6:
				if (_data_->_inner_error_ != NULL) {
					{
						_data_->self->priv->_prepare_pending = FALSE;
					}
					{
						_data_->_tmp17_ = _data_->self->priv->_is_prepared;
						g_static_rec_mutex_unlock (&_data_->self->priv->__lock__is_prepared);
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
				_data_->_tmp18_ = tpf_persona_store_get_account (_data_->self);
				_data_->_tmp19_ = _data_->_tmp18_;
				g_signal_connect_object ((GObject*) _data_->_tmp19_, "notify::connection", (GCallback) __tpf_persona_store_notify_connection_cb_g_object_notify, _data_->self, 0);
				_data_->_tmp20_ = tpf_persona_store_get_account (_data_->self);
				_data_->_tmp21_ = _data_->_tmp20_;
				_data_->_tmp22_ = tp_account_get_connection (_data_->_tmp21_);
				_data_->_tmp23_ = _data_->_tmp22_;
				if (_data_->_tmp23_ != NULL) {
					_data_->_tmp24_ = tpf_persona_store_get_account (_data_->self);
					_data_->_tmp25_ = _data_->_tmp24_;
					_tpf_persona_store_notify_connection_cb (_data_->self, (GObject*) _data_->_tmp25_, NULL);
				} else {
					_data_->_state_ = 2;
					_tpf_persona_store_load_cache (_data_->self, tpf_persona_store_prepare_ready, _data_);
					return FALSE;
					_state_2:
					_tpf_persona_store_load_cache_finish (_data_->self, _data_->_res_);
					_data_->self->priv->_got_self_handle = TRUE;
					_data_->self->priv->_got_stored_channel_members = TRUE;
					_tpf_persona_store_notify_if_is_quiescent (_data_->self);
				}
				_data_->self->priv->_is_prepared = TRUE;
				g_object_notify ((GObject*) _data_->self, "is-prepared");
			}
			__finally5:
			{
				_data_->self->priv->_prepare_pending = FALSE;
			}
			if (_data_->_inner_error_ != NULL) {
				{
					_data_->_tmp26_ = _data_->self->priv->_is_prepared;
					g_static_rec_mutex_unlock (&_data_->self->priv->__lock__is_prepared);
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
		__finally4:
		{
			_data_->_tmp27_ = _data_->self->priv->_is_prepared;
			g_static_rec_mutex_unlock (&_data_->self->priv->__lock__is_prepared);
		}
		if (_data_->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _tpf_persona_store_account_manager_invalidated_cb (TpfPersonaStore* self, guint domain, gint code, const gchar* message) {
	guint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = domain;
	_tmp1_ = code;
	_tmp2_ = message;
	_tmp3_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp4_ = _tmp3_;
	g_debug ("TpAccountManager invalidated (%u, %i, “%s”) for " "Tpf.PersonaStore %p (‘%s’).", _tmp0_, _tmp1_, _tmp2_, self, _tmp4_);
	_tpf_persona_store_remove_store (self);
}


static void _tpf_persona_store_account_invalidated_cb (TpfPersonaStore* self, guint domain, gint code, const gchar* message) {
	guint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = domain;
	_tmp1_ = code;
	_tmp2_ = message;
	_tmp3_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp4_ = _tmp3_;
	g_debug ("TpAccount invalidated (%u, %i, “%s”) for " "Tpf.PersonaStore %p (‘%s’).", _tmp0_, _tmp1_, _tmp2_, self, _tmp4_);
	_tpf_persona_store_remove_store (self);
}


static void _tpf_persona_store_logger_invalidated_cb (TpfPersonaStore* self) {
	Logger* _tmp0_;
	guint _tmp1_ = 0U;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_logger;
	g_signal_parse_name ("invalidated", TYPE_LOGGER, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) __tpf_persona_store_logger_invalidated_cb_logger_invalidated, self);
	_tmp2_ = _ ("Lost connection to the telepathy-logger service.");
	g_warning ("tpf-persona-store.vala:722: %s", _tmp2_);
	_g_object_unref0 (self->priv->_logger);
	self->priv->_logger = NULL;
}


static void _tpf_persona_store_initialise_favourite_contacts_data_free (gpointer _data) {
	TpfPersonaStoreInitialiseFavouriteContactsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreInitialiseFavouriteContactsData, _data_);
}


static void _tpf_persona_store_initialise_favourite_contacts (TpfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreInitialiseFavouriteContactsData* _data_;
	TpfPersonaStore* _tmp0_;
	_data_ = g_slice_new0 (TpfPersonaStoreInitialiseFavouriteContactsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_initialise_favourite_contacts);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_initialise_favourite_contacts_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tpf_persona_store_initialise_favourite_contacts_co (_data_);
}


static void _tpf_persona_store_initialise_favourite_contacts_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpfPersonaStoreInitialiseFavouriteContactsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _tpf_persona_store_initialise_favourite_contacts_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreInitialiseFavouriteContactsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_store_initialise_favourite_contacts_co (_data_);
}


static void ___lambda19_ (TpfPersonaStore* self, TpConnection* c, TpHandleType ht, guint* h, int h_length1, gchar** i, int i_length1, GError* e, GObject* w) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (c != NULL);
	g_return_if_fail (w != NULL);
	{
		guint* _tmp0_;
		gint _tmp0__length1;
		gchar** _tmp1_;
		gint _tmp1__length1;
		GError* _tmp2_;
		_tmp0_ = h;
		_tmp0__length1 = h_length1;
		_tmp1_ = i;
		_tmp1__length1 = i_length1;
		_tmp2_ = e;
		_tpf_persona_store_change_favourites_by_request_handles (self, (TpHandle*) _tmp0_, _tmp0__length1, _tmp1_, _tmp1__length1, _tmp2_, TRUE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = _ ("Couldn't get list of favorite contacts: %s");
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning (_tmp3_, _tmp5_);
		_g_error_free0 (e);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ____lambda19__tp_connection_request_handles_cb (TpConnection* connection, TpHandleType handle_type, guint n_handles, guint* handles, gchar** ids, GError* _error_, gpointer self, GObject* weak_object) {
	___lambda19_ (self, connection, handle_type, handles, n_handles, ids, n_handles, _error_, weak_object);
}


static gboolean _tpf_persona_store_initialise_favourite_contacts_co (TpfPersonaStoreInitialiseFavouriteContactsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_logger;
	if (_data_->_tmp0_ == NULL) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp1_ = _data_->self->priv->_logger;
		_data_->_tmp2_ = 0;
		_data_->_state_ = 1;
		logger_get_favourite_contacts (_data_->_tmp1_, _tpf_persona_store_initialise_favourite_contacts_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = logger_get_favourite_contacts_finish (_data_->_tmp1_, _data_->_res_, &_data_->_tmp2_, &_data_->_inner_error_);
		_data_->contacts = _data_->_tmp3_;
		_data_->contacts_length1 = _data_->_tmp2_;
		_data_->_contacts_size_ = _data_->contacts_length1;
		if (_data_->_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		_data_->_tmp4_ = _data_->contacts;
		_data_->_tmp4__length1 = _data_->contacts_length1;
		if (_data_->_tmp4__length1 == 0) {
			_data_->contacts = (_vala_array_free (_data_->contacts, _data_->contacts_length1, (GDestroyNotify) g_free), NULL);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp5_ = _data_->self->priv->_conn;
		_data_->_tmp6_ = _data_->contacts;
		_data_->_tmp6__length1 = _data_->contacts_length1;
		tp_connection_request_handles (_data_->_tmp5_, -1, TP_HANDLE_TYPE_CONTACT, _data_->_tmp6_, ____lambda19__tp_connection_request_handles_cb, g_object_ref (_data_->self), g_object_unref, (GObject*) _data_->self);
		_data_->contacts = (_vala_array_free (_data_->contacts, _data_->contacts_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally7;
	__catch7_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _ ("Couldn't get list of favorite contacts: %s");
		_data_->_tmp8_ = _data_->e;
		_data_->_tmp9_ = _data_->_tmp8_->message;
		g_warning (_data_->_tmp7_, _data_->_tmp9_);
		_g_error_free0 (_data_->e);
	}
	__finally7:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void _tpf_persona_store_change_favourites_by_request_handles (TpfPersonaStore* self, TpHandle* handles, int handles_length1, gchar** ids, int ids_length1, GError* _error_, gboolean add, GError** error) {
	GError* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = _error_;
	if (_tmp0_ != NULL) {
		GError* _tmp1_;
		GError* _tmp2_;
		_tmp1_ = _error_;
		_tmp2_ = _g_error_copy0 (_tmp1_);
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gint _tmp6_;
				TpHandle* _tmp7_;
				gint _tmp7__length1;
				TpHandle* _tmp8_;
				gint _tmp8__length1;
				gint _tmp9_;
				TpHandle _tmp10_;
				TpHandle h;
				GeeHashMap* _tmp11_;
				TpHandle _tmp12_;
				gpointer _tmp13_ = NULL;
				TpfPersona* p;
				gboolean _tmp14_;
				gboolean _tmp19_ = FALSE;
				TpfPersona* _tmp20_;
				gboolean _tmp35_;
				TpfPersona* _tmp40_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = handles;
				_tmp7__length1 = handles_length1;
				if (!(_tmp6_ < _tmp7__length1)) {
					break;
				}
				_tmp8_ = handles;
				_tmp8__length1 = handles_length1;
				_tmp9_ = i;
				_tmp10_ = _tmp8_[_tmp9_];
				h = _tmp10_;
				_tmp11_ = self->priv->_handle_persona_map;
				_tmp12_ = h;
				_tmp13_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, GUINT_TO_POINTER ((guint) _tmp12_));
				p = (TpfPersona*) _tmp13_;
				_tmp14_ = add;
				if (_tmp14_) {
					GeeHashSet* _tmp15_;
					TpHandle _tmp16_;
					_tmp15_ = self->priv->_favourite_handles;
					_tmp16_ = h;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, GUINT_TO_POINTER ((guint) _tmp16_));
				} else {
					GeeHashSet* _tmp17_;
					TpHandle _tmp18_;
					_tmp17_ = self->priv->_favourite_handles;
					_tmp18_ = h;
					gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp17_, GUINT_TO_POINTER ((guint) _tmp18_));
				}
				_tmp20_ = p;
				if (_tmp20_ == NULL) {
					gboolean _tmp21_ = FALSE;
					gboolean _tmp22_ = FALSE;
					TpContact* _tmp23_;
					gboolean _tmp27_;
					gboolean _tmp34_;
					_tmp23_ = self->priv->_self_contact;
					if (_tmp23_ == NULL) {
						GeeHashMap* _tmp24_;
						gint _tmp25_;
						gint _tmp26_;
						_tmp24_ = self->priv->_handle_persona_map;
						_tmp25_ = gee_abstract_map_get_size ((GeeMap*) _tmp24_);
						_tmp26_ = _tmp25_;
						_tmp22_ = _tmp26_ > 0;
					} else {
						_tmp22_ = FALSE;
					}
					_tmp27_ = _tmp22_;
					if (_tmp27_) {
						_tmp21_ = TRUE;
					} else {
						gboolean _tmp28_ = FALSE;
						TpContact* _tmp29_;
						gboolean _tmp33_;
						_tmp29_ = self->priv->_self_contact;
						if (_tmp29_ != NULL) {
							GeeHashMap* _tmp30_;
							gint _tmp31_;
							gint _tmp32_;
							_tmp30_ = self->priv->_handle_persona_map;
							_tmp31_ = gee_abstract_map_get_size ((GeeMap*) _tmp30_);
							_tmp32_ = _tmp31_;
							_tmp28_ = _tmp32_ > 1;
						} else {
							_tmp28_ = FALSE;
						}
						_tmp33_ = _tmp28_;
						_tmp21_ = _tmp33_;
					}
					_tmp34_ = _tmp21_;
					_tmp19_ = _tmp34_;
				} else {
					_tmp19_ = FALSE;
				}
				_tmp35_ = _tmp19_;
				if (_tmp35_) {
					const gchar* _tmp36_ = NULL;
					gchar** _tmp37_;
					gint _tmp37__length1;
					gint _tmp38_;
					const gchar* _tmp39_;
					_tmp36_ = _ ("Unknown Telepathy contact ‘%s’ in favorites list.");
					_tmp37_ = ids;
					_tmp37__length1 = ids_length1;
					_tmp38_ = i;
					_tmp39_ = _tmp37_[_tmp38_];
					g_warning (_tmp36_, _tmp39_);
					_g_object_unref0 (p);
					continue;
				}
				_tmp40_ = p;
				if (_tmp40_ != NULL) {
					TpfPersona* _tmp41_;
					gboolean _tmp42_;
					_tmp41_ = p;
					_tmp42_ = add;
					folks_favourite_details_set_is_favourite ((FolksFavouriteDetails*) _tmp41_, _tmp42_);
				}
				_g_object_unref0 (p);
			}
		}
	}
}


static void ___lambda10_ (TpfPersonaStore* self, TpConnection* c, TpHandleType ht, guint* h, int h_length1, gchar** i, int i_length1, GError* e, GObject* w) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (c != NULL);
	g_return_if_fail (w != NULL);
	{
		guint* _tmp0_;
		gint _tmp0__length1;
		gchar** _tmp1_;
		gint _tmp1__length1;
		GError* _tmp2_;
		_tmp0_ = h;
		_tmp0__length1 = h_length1;
		_tmp1_ = i;
		_tmp1__length1 = i_length1;
		_tmp2_ = e;
		_tpf_persona_store_change_favourites_by_request_handles (self, (TpHandle*) _tmp0_, _tmp0__length1, _tmp1_, _tmp1__length1, _tmp2_, TRUE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = _ ("Couldn't add favorite contacts: %s");
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning (_tmp3_, _tmp5_);
		_g_error_free0 (e);
	}
	__finally9:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ____lambda10__tp_connection_request_handles_cb (TpConnection* connection, TpHandleType handle_type, guint n_handles, guint* handles, gchar** ids, GError* _error_, gpointer self, GObject* weak_object) {
	___lambda10_ (self, connection, handle_type, handles, n_handles, ids, n_handles, _error_, weak_object);
}


static void ___lambda11_ (TpfPersonaStore* self, TpConnection* c, TpHandleType ht, guint* h, int h_length1, gchar** i, int i_length1, GError* e, GObject* w) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (c != NULL);
	g_return_if_fail (w != NULL);
	{
		guint* _tmp0_;
		gint _tmp0__length1;
		gchar** _tmp1_;
		gint _tmp1__length1;
		GError* _tmp2_;
		_tmp0_ = h;
		_tmp0__length1 = h_length1;
		_tmp1_ = i;
		_tmp1__length1 = i_length1;
		_tmp2_ = e;
		_tpf_persona_store_change_favourites_by_request_handles (self, (TpHandle*) _tmp0_, _tmp0__length1, _tmp1_, _tmp1__length1, _tmp2_, FALSE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = _ ("Couldn't remove favorite contacts: %s");
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning (_tmp3_, _tmp5_);
		_g_error_free0 (e);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ____lambda11__tp_connection_request_handles_cb (TpConnection* connection, TpHandleType handle_type, guint n_handles, guint* handles, gchar** ids, GError* _error_, gpointer self, GObject* weak_object) {
	___lambda11_ (self, connection, handle_type, handles, n_handles, ids, n_handles, _error_, weak_object);
}


static void _tpf_persona_store_favourite_contacts_changed_cb (TpfPersonaStore* self, gchar** added, int added_length1, gchar** removed, int removed_length1) {
	TpConnection* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_conn;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = added;
	_tmp1__length1 = added_length1;
	if (_tmp1__length1 > 0) {
		TpConnection* _tmp2_;
		gchar** _tmp3_;
		gint _tmp3__length1;
		_tmp2_ = self->priv->_conn;
		_tmp3_ = added;
		_tmp3__length1 = added_length1;
		tp_connection_request_handles (_tmp2_, -1, TP_HANDLE_TYPE_CONTACT, _tmp3_, ____lambda10__tp_connection_request_handles_cb, g_object_ref (self), g_object_unref, (GObject*) self);
	}
	_tmp4_ = removed;
	_tmp4__length1 = removed_length1;
	if (_tmp4__length1 > 0) {
		TpConnection* _tmp5_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		_tmp5_ = self->priv->_conn;
		_tmp6_ = removed;
		_tmp6__length1 = removed_length1;
		tp_connection_request_handles (_tmp5_, -1, TP_HANDLE_TYPE_CONTACT, _tmp6_, ____lambda11__tp_connection_request_handles_cb, g_object_ref (self), g_object_unref, (GObject*) self);
	}
}


static void __lambda13_ (TpfPersonaStore* self, GObject* o2, GAsyncResult* r2) {
	GAsyncResult* _tmp0_;
	g_return_if_fail (r2 != NULL);
	_tmp0_ = r2;
	_tpf_persona_store_load_cache_finish (self, _tmp0_);
}


static void ___lambda13__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda13_ (self, source_object, res);
	g_object_unref (self);
}


static void ____lambda12_ (TpfPersonaStore* self, GObject* o, GAsyncResult* r) {
	GAsyncResult* _tmp0_;
	g_return_if_fail (r != NULL);
	_tmp0_ = r;
	_tpf_persona_store_store_cache_finish (self, _tmp0_);
	_tpf_persona_store_load_cache (self, ___lambda13__gasync_ready_callback, g_object_ref (self));
}


static void _____lambda12__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	____lambda12_ (self, source_object, res);
	g_object_unref (self);
}


static void _tpf_persona_store_notify_connection_cb (TpfPersonaStore* self, GObject* s, GParamSpec* p) {
	GObject* _tmp0_;
	TpAccount* _tmp1_;
	TpAccount* account;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	TpAccount* _tmp4_;
	TpConnection* _tmp5_;
	TpConnection* _tmp6_;
	TpAccount* _tmp7_;
	TpConnection* _tmp8_;
	TpConnection* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	_tmp0_ = s;
	_tmp1_ = _g_object_ref0 (TP_IS_ACCOUNT (_tmp0_) ? ((TpAccount*) _tmp0_) : NULL);
	account = _tmp1_;
	_tmp2_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = account;
	_tmp5_ = tp_account_get_connection (_tmp4_);
	_tmp6_ = _tmp5_;
	g_debug ("tpf-persona-store.vala:869: Account '%s' connection changed to %p", _tmp3_, _tmp6_);
	_tmp7_ = account;
	_tmp8_ = tp_account_get_connection (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == NULL) {
		GeeHashSet* _tmp10_;
		TpConnection* _tmp11_;
		TpAccount* _tmp12_;
		TpAccount* _tmp13_;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_;
		_tmp10_ = self->_supported_fields;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp10_);
		g_object_notify ((GObject*) self, "supported-fields");
		_tmp11_ = self->priv->_conn;
		if (_tmp11_ != NULL) {
			_g_object_unref0 (self->priv->_conn);
			self->priv->_conn = NULL;
			_tpf_persona_store_store_cache (self, _____lambda12__gasync_ready_callback, g_object_ref (self));
		}
		_tmp12_ = tpf_persona_store_get_account (self);
		_tmp13_ = _tmp12_;
		g_object_get (_tmp13_, "enabled", &_tmp14_, NULL);
		_tmp15_ = _tmp14_;
		if (_tmp15_ == FALSE) {
			_tpf_persona_store_remove_store (self);
		}
		self->priv->_got_self_handle = TRUE;
		self->priv->_got_stored_channel_members = TRUE;
		_tpf_persona_store_notify_if_is_quiescent (self);
		_g_object_unref0 (account);
		return;
	}
	_tpf_persona_store_notify_connection_cb_async (self, NULL, NULL);
	_g_object_unref0 (account);
}


static void _tpf_persona_store_notify_connection_cb_async_data_free (gpointer _data) {
	TpfPersonaStoreNotifyConnectionCbAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreNotifyConnectionCbAsyncData, _data_);
}


static void _tpf_persona_store_notify_connection_cb_async (TpfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreNotifyConnectionCbAsyncData* _data_;
	TpfPersonaStore* _tmp0_;
	_data_ = g_slice_new0 (TpfPersonaStoreNotifyConnectionCbAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_notify_connection_cb_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_notify_connection_cb_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tpf_persona_store_notify_connection_cb_async_co (_data_);
}


static void _tpf_persona_store_notify_connection_cb_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error) {
	TpfPersonaStoreNotifyConnectionCbAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _tpf_persona_store_notify_connection_cb_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreNotifyConnectionCbAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_store_notify_connection_cb_async_co (_data_);
}


static void __tpf_persona_store_connection_ready_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona_store_connection_ready_cb (self, _sender, pspec);
}


static gboolean _tpf_persona_store_notify_connection_cb_async_co (TpfPersonaStoreNotifyConnectionCbAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	g_debug ("tpf-persona-store.vala:929: _notify_connection_cb_async() for Tpf.Pers" \
"onaStore %p ('%s').", _data_->self, _data_->_tmp1_);
	_data_->_tmp2_ = tpf_persona_store_get_account (_data_->self);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = tp_account_get_connection (_data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = tpf_persona_store__connection_features;
	_data_->_tmp6__length1 = tpf_persona_store__connection_features_length1;
	_data_->_state_ = 1;
	tp_proxy_prepare_async ((TpProxy*) _data_->_tmp5_, _data_->_tmp6_, _tpf_persona_store_notify_connection_cb_async_ready, _data_);
	return FALSE;
	_state_1:
	tp_proxy_prepare_finish ((TpProxy*) _data_->_tmp5_, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_tpf_persona_store_unload_cache (_data_->self);
	_data_->_tmp7_ = tpf_persona_store_get_account (_data_->self);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = tp_account_get_connection (_data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = _g_object_ref0 (_data_->_tmp10_);
	_data_->conn = _data_->_tmp11_;
	_data_->_tmp12_ = _data_->conn;
	g_signal_connect_object ((GObject*) _data_->_tmp12_, "notify::connection-ready", (GCallback) __tpf_persona_store_connection_ready_cb_g_object_notify, _data_->self, 0);
	_data_->connection_ready = FALSE;
	_data_->_tmp13_ = _data_->conn;
	g_object_get ((GObject*) _data_->_tmp13_, "connection-ready", &_data_->connection_ready, NULL);
	_data_->_tmp14_ = _data_->connection_ready;
	if (_data_->_tmp14_ == TRUE) {
		_data_->_tmp15_ = _data_->conn;
		_tpf_persona_store_connection_ready_cb (_data_->self, (GObject*) _data_->_tmp15_, NULL);
	} else {
		_data_->_tmp16_ = _data_->conn;
		_data_->_state_ = 2;
		tp_proxy_prepare_async ((TpProxy*) _data_->_tmp16_, NULL, _tpf_persona_store_notify_connection_cb_async_ready, _data_);
		return FALSE;
		_state_2:
		tp_proxy_prepare_finish ((TpProxy*) _data_->_tmp16_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->conn);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->conn);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void __tpf_persona_store_new_group_channels_cb_folks_tp_lowlevel_new_group_channels_callback (TpChannel* channel, GAsyncResult* _result_, gpointer self) {
	_tpf_persona_store_new_group_channels_cb (self, channel, _result_);
}


static void __lambda15_ (TpfPersonaStore* self, GObject* s2, GAsyncResult* res) {
	FolksMaybeBool new_can_alias;
	FolksMaybeBool _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (res != NULL);
	new_can_alias = FOLKS_MAYBE_BOOL_FALSE;
	{
		GAsyncResult* _tmp0_;
		TpConnectionAliasFlags _tmp1_ = 0;
		TpConnectionAliasFlags flags;
		_tmp0_ = res;
		_tmp1_ = folks_tp_lowlevel_connection_get_alias_flags_finish (_tmp0_, &_inner_error_);
		flags = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
		if ((flags & TP_CONNECTION_ALIAS_FLAG_USER_SET) > 0) {
			new_can_alias = FOLKS_MAYBE_BOOL_TRUE;
		}
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _ ("Failed to determine whether we can set aliases on Telepathy account '%" \
"s': %s");
		_tmp3_ = folks_persona_store_get_display_name ((FolksPersonaStore*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning (_tmp2_, _tmp4_, _tmp6_);
		_g_error_free0 (e);
	}
	__finally11:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = new_can_alias;
	self->priv->_can_alias_personas = _tmp7_;
	g_object_notify ((GObject*) self, "can-alias-personas");
}


static void ___lambda15__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda15_ (self, source_object, res);
	g_object_unref (self);
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static void __lambda16_ (TpfPersonaStore* self, GObject* s3, GAsyncResult* res3) {
	FolksMaybeBool new_can_group;
	FolksMaybeBool _tmp41_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (res3 != NULL);
	new_can_group = FOLKS_MAYBE_BOOL_FALSE;
	{
		GPtrArray* v = NULL;
		gint i = 0;
		GAsyncResult* _tmp0_;
		GPtrArray* _tmp1_ = NULL;
		GPtrArray* _tmp2_;
		_tmp0_ = res3;
		_tmp1_ = folks_tp_lowlevel_connection_get_requestable_channel_classes_finish (_tmp0_, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			_g_ptr_array_unref0 (v);
			goto __catch12_g_error;
		}
		_g_ptr_array_unref0 (v);
		v = _tmp2_;
		{
			gboolean _tmp3_;
			i = 0;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gint _tmp6_;
				GPtrArray* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				GPtrArray* _tmp10_;
				gint _tmp11_;
				gconstpointer _tmp12_ = NULL;
				GValueArray* class;
				GValueArray* _tmp13_;
				GValue* _tmp14_ = NULL;
				GValue* _tmp15_;
				GValue* val;
				GValue* _tmp16_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = v;
				_tmp8_ = g_ptr_array_get_length (_tmp7_);
				_tmp9_ = _tmp8_;
				if (!(_tmp6_ < _tmp9_)) {
					break;
				}
				_tmp10_ = v;
				_tmp11_ = i;
				_tmp12_ = g_ptr_array_index (_tmp10_, (guint) _tmp11_);
				class = (GValueArray*) _tmp12_;
				_tmp13_ = class;
				_tmp14_ = g_value_array_get_nth (_tmp13_, (guint) 0);
				_tmp15_ = __g_value_dup0 (_tmp14_);
				val = _tmp15_;
				_tmp16_ = val;
				if (_tmp16_ != NULL) {
					GValue* _tmp17_;
					void* _tmp18_ = NULL;
					GHashTable* _tmp19_;
					GHashTable* props;
					GHashTable* _tmp20_;
					const gchar* _tmp21_;
					const gchar* _tmp22_ = NULL;
					gchar* _tmp23_;
					gchar* channel_type;
					gboolean handle_type_valid = FALSE;
					GHashTable* _tmp24_;
					const gchar* _tmp25_;
					gboolean _tmp26_ = FALSE;
					guint32 _tmp27_ = 0U;
					guint32 handle_type;
					gboolean _tmp28_ = FALSE;
					gboolean _tmp29_ = FALSE;
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					gboolean _tmp33_;
					gboolean _tmp35_;
					_tmp17_ = val;
					_tmp18_ = g_value_get_boxed (_tmp17_);
					_tmp19_ = _g_hash_table_ref0 ((GHashTable*) _tmp18_);
					props = _tmp19_;
					_tmp20_ = props;
					_tmp21_ = tpf_persona_store__tp_channel_channel_type;
					_tmp22_ = tp_asv_get_string (_tmp20_, _tmp21_);
					_tmp23_ = g_strdup (_tmp22_);
					channel_type = _tmp23_;
					_tmp24_ = props;
					_tmp25_ = tpf_persona_store__tp_channel_handle_type;
					_tmp27_ = tp_asv_get_uint32 (_tmp24_, _tmp25_, &_tmp26_);
					handle_type_valid = _tmp26_;
					handle_type = _tmp27_;
					_tmp30_ = channel_type;
					_tmp31_ = tpf_persona_store__tp_channel_contact_list_type;
					if (g_strcmp0 (_tmp30_, _tmp31_) == 0) {
						gboolean _tmp32_;
						_tmp32_ = handle_type_valid;
						_tmp29_ = _tmp32_;
					} else {
						_tmp29_ = FALSE;
					}
					_tmp33_ = _tmp29_;
					if (_tmp33_) {
						guint32 _tmp34_;
						_tmp34_ = handle_type;
						_tmp28_ = _tmp34_ == ((guint32) TP_HANDLE_TYPE_GROUP);
					} else {
						_tmp28_ = FALSE;
					}
					_tmp35_ = _tmp28_;
					if (_tmp35_) {
						new_can_group = FOLKS_MAYBE_BOOL_TRUE;
						_g_free0 (channel_type);
						_g_hash_table_unref0 (props);
						__vala_GValue_free0 (val);
						break;
					}
					_g_free0 (channel_type);
					_g_hash_table_unref0 (props);
				}
				__vala_GValue_free0 (val);
			}
		}
		_g_ptr_array_unref0 (v);
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e3 = NULL;
		const gchar* _tmp36_ = NULL;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		GError* _tmp39_;
		const gchar* _tmp40_;
		e3 = _inner_error_;
		_inner_error_ = NULL;
		_tmp36_ = _ ("Failed to determine whether we can set groups on Telepathy account '%s" \
"': %s");
		_tmp37_ = folks_persona_store_get_display_name ((FolksPersonaStore*) self);
		_tmp38_ = _tmp37_;
		_tmp39_ = e3;
		_tmp40_ = _tmp39_->message;
		g_warning (_tmp36_, _tmp38_, _tmp40_);
		_g_error_free0 (e3);
	}
	__finally12:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp41_ = new_can_group;
	self->priv->_can_group_personas = _tmp41_;
	g_object_notify ((GObject*) self, "can-group-personas");
}


static void ___lambda16__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda16_ (self, source_object, res);
	g_object_unref (self);
}


static void _tpf_persona_store_connection_ready_cb (TpfPersonaStore* self, GObject* s, GParamSpec* p) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GObject* _tmp2_;
	TpConnection* _tmp3_;
	TpConnection* c;
	TpConnection* _tmp4_;
	TpConnection* _tmp5_;
	TpConnection* _tmp6_;
	TpConnection* _tmp7_;
	TpConnection* _tmp8_;
	TpConnection* _tmp9_;
	TpConnection* _tmp10_;
	TpConnection* _tmp11_;
	TpConnection* _tmp12_;
	TpConnection* _tmp13_;
	guint _tmp14_;
	guint _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp1_ = _tmp0_;
	g_debug ("tpf-persona-store.vala:955: _connection_ready_cb() for Tpf.PersonaStor" \
"e %p ('%s').", self, _tmp1_);
	_tmp2_ = s;
	_tmp3_ = _g_object_ref0 (TP_CONNECTION (_tmp2_));
	c = _tmp3_;
	_tmp4_ = c;
	folks_tp_lowlevel_connection_connect_to_new_group_channels (_tmp4_, __tpf_persona_store_new_group_channels_cb_folks_tp_lowlevel_new_group_channels_callback, self);
	_tpf_persona_store_marshall_supported_fields (self);
	g_object_notify ((GObject*) self, "supported-fields");
	_tmp5_ = c;
	folks_tp_lowlevel_connection_get_alias_flags_async (_tmp5_, ___lambda15__gasync_ready_callback, g_object_ref (self));
	_tmp6_ = c;
	folks_tp_lowlevel_connection_get_requestable_channel_classes_async (_tmp6_, ___lambda16__gasync_ready_callback, g_object_ref (self));
	_tmp7_ = c;
	_tpf_persona_store_add_standard_channel (self, _tmp7_, "publish", NULL, NULL);
	_tmp8_ = c;
	_tpf_persona_store_add_standard_channel (self, _tmp8_, "stored", NULL, NULL);
	_tmp9_ = c;
	_tpf_persona_store_add_standard_channel (self, _tmp9_, "subscribe", NULL, NULL);
	_tmp10_ = c;
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_g_object_unref0 (self->priv->_conn);
	self->priv->_conn = _tmp11_;
	_tmp12_ = self->priv->_conn;
	g_signal_connect_object ((GObject*) _tmp12_, "notify::self-handle", (GCallback) __tpf_persona_store_self_handle_changed_cb_g_object_notify, self, 0);
	_tmp13_ = self->priv->_conn;
	_tmp14_ = tp_connection_get_self_handle (_tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != ((guint) 0)) {
		TpConnection* _tmp16_;
		_tmp16_ = self->priv->_conn;
		_tpf_persona_store_self_handle_changed_cb (self, (GObject*) _tmp16_, NULL);
	}
	_tpf_persona_store_initialise_favourite_contacts (self, NULL, NULL);
	_g_object_unref0 (c);
}


static void _tpf_persona_store_marshall_supported_fields (TpfPersonaStore* self) {
	TpAccount* _tmp0_;
	TpAccount* _tmp1_;
	TpConnection* _tmp2_;
	TpConnection* _tmp3_;
	TpConnection* _tmp4_;
	TpConnection* connection;
	TpConnection* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tpf_persona_store_get_account (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = tp_account_get_connection (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	connection = _tmp4_;
	_tmp5_ = connection;
	if (_tmp5_ != NULL) {
		GeeHashSet* _tmp6_;
		TpConnection* _tmp7_;
		TpContactInfoFlags _tmp8_ = 0;
		TpContactInfoFlags ci_flags;
		TpContactInfoFlags _tmp9_;
		_tmp6_ = self->_supported_fields;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp6_);
		_tmp7_ = connection;
		_tmp8_ = tp_connection_get_contact_info_flags (_tmp7_);
		ci_flags = _tmp8_;
		_tmp9_ = ci_flags;
		if ((_tmp9_ & TP_CONTACT_INFO_FLAG_CAN_SET) != 0) {
			TpConnection* _tmp10_;
			GList* _tmp11_ = NULL;
			GList* field_specs;
			GList* _tmp12_;
			_tmp10_ = connection;
			_tmp11_ = tp_connection_get_contact_info_supported_fields (_tmp10_);
			field_specs = _tmp11_;
			_tmp12_ = field_specs;
			{
				GList* field_spec_collection = NULL;
				GList* field_spec_it = NULL;
				field_spec_collection = _tmp12_;
				for (field_spec_it = field_spec_collection; field_spec_it != NULL; field_spec_it = field_spec_it->next) {
					TpContactInfoFieldSpec* field_spec = NULL;
					field_spec = (TpContactInfoFieldSpec*) field_spec_it->data;
					{
						GeeHashSet* _tmp13_;
						TpContactInfoFieldSpec* _tmp14_;
						const gchar* _tmp15_;
						_tmp13_ = self->_supported_fields;
						_tmp14_ = field_spec;
						_tmp15_ = _tmp14_->name;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp15_);
					}
				}
			}
			_g_list_free0 (field_specs);
		}
	}
	_g_object_unref0 (connection);
}


static void _tpf_persona_store_load_cache_data_free (gpointer _data) {
	TpfPersonaStoreLoadCacheData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreLoadCacheData, _data_);
}


static void _tpf_persona_store_load_cache (TpfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreLoadCacheData* _data_;
	TpfPersonaStore* _tmp0_;
	_data_ = g_slice_new0 (TpfPersonaStoreLoadCacheData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_load_cache);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_load_cache_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tpf_persona_store_load_cache_co (_data_);
}


static void _tpf_persona_store_load_cache_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpfPersonaStoreLoadCacheData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * If our account is disconnected, we want to continue to export a static
   * view of personas from the cache.
   */
static void _tpf_persona_store_load_cache_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreLoadCacheData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_store_load_cache_co (_data_);
}


static gboolean _tpf_persona_store_load_cache_co (TpfPersonaStoreLoadCacheData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = tpf_persona_store_get_account (_data_->self);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = FALSE;
	g_object_get (_data_->_tmp2_, "enabled", &_data_->_tmp3_, NULL);
	_data_->_tmp4_ = _data_->_tmp3_;
	if (_data_->_tmp4_ == FALSE) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp5_ = tpf_persona_store_get_account (_data_->self);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = FALSE;
		g_object_get (_data_->_tmp6_, "valid", &_data_->_tmp7_, NULL);
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp0_ = _data_->_tmp8_ == FALSE;
	}
	_data_->_tmp9_ = _data_->_tmp0_;
	if (_data_->_tmp9_) {
		_data_->_tmp11_ = tpf_persona_store_get_account (_data_->self);
		_data_->_tmp12_ = _data_->_tmp11_;
		_data_->_tmp13_ = FALSE;
		g_object_get (_data_->_tmp12_, "enabled", &_data_->_tmp13_, NULL);
		_data_->_tmp14_ = _data_->_tmp13_;
		if (_data_->_tmp14_) {
			_data_->_tmp10_ = "yes";
		} else {
			_data_->_tmp10_ = "no";
		}
		_data_->_tmp16_ = tpf_persona_store_get_account (_data_->self);
		_data_->_tmp17_ = _data_->_tmp16_;
		_data_->_tmp18_ = FALSE;
		g_object_get (_data_->_tmp17_, "valid", &_data_->_tmp18_, NULL);
		_data_->_tmp19_ = _data_->_tmp18_;
		if (_data_->_tmp19_) {
			_data_->_tmp15_ = "yes";
		} else {
			_data_->_tmp15_ = "no";
		}
		_data_->_tmp20_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
		_data_->_tmp21_ = _data_->_tmp20_;
		_data_->_tmp22_ = _data_->_tmp10_;
		_data_->_tmp23_ = _data_->_tmp15_;
		g_debug ("Skipping loading cache for Tpf.PersonaStore %p ('%s'): " "enabled: %s, valid: %s.", _data_->self, _data_->_tmp21_, _data_->_tmp22_, _data_->_tmp23_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp24_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp25_ = _data_->_tmp24_;
	g_debug ("tpf-persona-store.vala:1102: Loading cache for Tpf.PersonaStore %p ('%" \
"s').", _data_->self, _data_->_tmp25_);
	_data_->_tmp26_ = g_cancellable_new ();
	_data_->cancellable = _data_->_tmp26_;
	_data_->_tmp27_ = _data_->self->priv->_load_cache_cancellable;
	if (_data_->_tmp27_ != NULL) {
		_data_->_tmp28_ = _data_->self->priv->_load_cache_cancellable;
		g_debug ("tpf-persona-store.vala:1108:     Cancelling ongoing loading operation " \
"(cancellable: %p).", _data_->_tmp28_);
		_data_->_tmp29_ = _data_->self->priv->_load_cache_cancellable;
		g_cancellable_cancel (_data_->_tmp29_);
	}
	_data_->_tmp30_ = _data_->cancellable;
	_data_->_tmp31_ = _g_object_ref0 (_data_->_tmp30_);
	_g_object_unref0 (_data_->self->priv->_load_cache_cancellable);
	_data_->self->priv->_load_cache_cancellable = _data_->_tmp31_;
	_data_->_tmp32_ = _data_->self->priv->_cache;
	_data_->_tmp33_ = _data_->cancellable;
	_data_->_state_ = 1;
	folks_object_cache_load_objects ((FolksObjectCache*) _data_->_tmp32_, _data_->_tmp33_, _tpf_persona_store_load_cache_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp34_ = NULL;
	_data_->_tmp34_ = folks_object_cache_load_objects_finish ((FolksObjectCache*) _data_->_tmp32_, _data_->_res_);
	_data_->cached_personas = _data_->_tmp34_;
	_data_->_tmp35_ = _data_->self->priv->_persona_set;
	_data_->_tmp36_ = _g_object_ref0 (_data_->_tmp35_);
	_data_->old_personas = _data_->_tmp36_;
	_data_->_tmp37_ = _data_->cancellable;
	_data_->_tmp38_ = FALSE;
	_data_->_tmp38_ = g_cancellable_is_cancelled (_data_->_tmp37_);
	if (_data_->_tmp38_ == TRUE) {
		_data_->_tmp39_ = _data_->cancellable;
		g_debug ("tpf-persona-store.vala:1123:     Cancelled (cancellable: %p).", _data_->_tmp39_);
		_g_object_unref0 (_data_->old_personas);
		_g_object_unref0 (_data_->cached_personas);
		_g_object_unref0 (_data_->cancellable);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_tpf_persona_store_reset (_data_->self);
	_data_->self->priv->_cached = TRUE;
	_data_->_tmp40_ = gee_hash_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	_g_object_unref0 (_data_->self->priv->_persona_set);
	_data_->self->priv->_persona_set = _data_->_tmp40_;
	_data_->_tmp41_ = _data_->cached_personas;
	if (_data_->_tmp41_ != NULL) {
		{
			_data_->_tmp42_ = _data_->cached_personas;
			_data_->_tmp43_ = NULL;
			_data_->_tmp43_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp42_);
			_data_->_p_it = _data_->_tmp43_;
			while (TRUE) {
				_data_->_tmp44_ = _data_->_p_it;
				_data_->_tmp45_ = FALSE;
				_data_->_tmp45_ = gee_iterator_next (_data_->_tmp44_);
				if (!_data_->_tmp45_) {
					break;
				}
				_data_->_tmp46_ = _data_->_p_it;
				_data_->_tmp47_ = NULL;
				_data_->_tmp47_ = gee_iterator_get (_data_->_tmp46_);
				_data_->p = (TpfPersona*) _data_->_tmp47_;
				_data_->_tmp48_ = _data_->self->priv->_personas;
				_data_->_tmp49_ = _data_->p;
				_data_->_tmp50_ = folks_persona_get_iid ((FolksPersona*) _data_->_tmp49_);
				_data_->_tmp51_ = _data_->_tmp50_;
				_data_->_tmp52_ = _data_->p;
				gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp48_, _data_->_tmp51_, _data_->_tmp52_);
				_data_->_tmp53_ = _data_->self->priv->_persona_set;
				_data_->_tmp54_ = _data_->p;
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp53_, _data_->_tmp54_);
				_g_object_unref0 (_data_->p);
			}
			_g_object_unref0 (_data_->_p_it);
		}
	}
	_data_->_tmp55_ = _data_->cached_personas;
	_data_->_tmp56_ = _data_->old_personas;
	_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) _data_->self, _data_->_tmp55_, (GeeSet*) _data_->_tmp56_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	_data_->self->priv->_can_add_personas = FOLKS_MAYBE_BOOL_FALSE;
	_data_->self->priv->_can_alias_personas = FOLKS_MAYBE_BOOL_FALSE;
	_data_->self->priv->_can_group_personas = FOLKS_MAYBE_BOOL_FALSE;
	_data_->self->priv->_can_remove_personas = FOLKS_MAYBE_BOOL_FALSE;
	_g_object_unref0 (_data_->old_personas);
	_g_object_unref0 (_data_->cached_personas);
	_g_object_unref0 (_data_->cancellable);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _tpf_persona_store_store_cache_data_free (gpointer _data) {
	TpfPersonaStoreStoreCacheData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreStoreCacheData, _data_);
}


static void _tpf_persona_store_store_cache (TpfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreStoreCacheData* _data_;
	TpfPersonaStore* _tmp0_;
	_data_ = g_slice_new0 (TpfPersonaStoreStoreCacheData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_store_cache);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_store_cache_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tpf_persona_store_store_cache_co (_data_);
}


static void _tpf_persona_store_store_cache_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpfPersonaStoreStoreCacheData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * When we're about to disconnect, store the current set of personas to the
   * cache file so that we can access them once offline.
   */
static void _tpf_persona_store_store_cache_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreStoreCacheData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_store_store_cache_co (_data_);
}


static gboolean _tpf_persona_store_store_cache_co (TpfPersonaStoreStoreCacheData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	g_debug ("tpf-persona-store.vala:1155: Storing cache for Tpf.PersonaStore %p ('%" \
"s').", _data_->self, _data_->_tmp1_);
	_data_->_tmp2_ = _data_->self->priv->_cache;
	_data_->_tmp3_ = _data_->self->priv->_persona_set;
	_data_->_state_ = 1;
	folks_object_cache_store_objects ((FolksObjectCache*) _data_->_tmp2_, (GeeSet*) _data_->_tmp3_, NULL, _tpf_persona_store_store_cache_ready, _data_);
	return FALSE;
	_state_1:
	folks_object_cache_store_objects_finish ((FolksObjectCache*) _data_->_tmp2_, _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * When our account is connected again, we can unload the the personas which
   * we're advertising from the cache.
   */
static void _tpf_persona_store_unload_cache (TpfPersonaStore* self) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GCancellable* _tmp2_;
	GeeHashSet* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp1_ = _tmp0_;
	g_debug ("tpf-persona-store.vala:1166: Unloading cache for Tpf.PersonaStore %p (" \
"'%s').", self, _tmp1_);
	_tmp2_ = self->priv->_load_cache_cancellable;
	if (_tmp2_ != NULL) {
		GCancellable* _tmp3_;
		GCancellable* _tmp4_;
		_tmp3_ = self->priv->_load_cache_cancellable;
		g_debug ("tpf-persona-store.vala:1171:     Cancelling ongoing loading operation " \
"(cancellable: %p).", _tmp3_);
		_tmp4_ = self->priv->_load_cache_cancellable;
		g_cancellable_cancel (_tmp4_);
	}
	_tmp5_ = self->priv->_persona_set;
	_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, NULL, (GeeSet*) _tmp5_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	_tpf_persona_store_reset (self);
	self->priv->_cached = FALSE;
}


static void __lambda6_ (TpfPersonaStore* self, TpConnection* conn, TpContact** contacts, int contacts_length1, TpHandle* failed, int failed_length1, GError* _error_, GObject* weak_object) {
	GError* _tmp0_;
	TpContact** _tmp7_;
	gint _tmp7__length1;
	TpContact* _tmp8_;
	TpContact* _tmp9_;
	TpContact* contact;
	gboolean added = FALSE;
	TpContact* _tmp10_;
	gboolean _tmp11_ = FALSE;
	TpfPersona* _tmp12_ = NULL;
	TpfPersona* persona;
	GeeHashSet* _tmp13_;
	GeeHashSet* personas;
	gboolean _tmp14_;
	TpContact* _tmp17_;
	TpContact* _tmp18_;
	GeeHashSet* _tmp19_;
	g_return_if_fail (conn != NULL);
	g_return_if_fail (weak_object != NULL);
	_tmp0_ = _error_;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_ = NULL;
		TpConnection* _tmp2_;
		guint _tmp3_;
		guint _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		_tmp1_ = _ ("Failed to create contact for self handle '%u': %s");
		_tmp2_ = conn;
		_tmp3_ = tp_connection_get_self_handle (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _error_;
		_tmp6_ = _tmp5_->message;
		g_warning (_tmp1_, _tmp4_, _tmp6_);
		return;
	}
	g_debug ("tpf-persona-store.vala:1220: Creating persona from self-handle");
	_tmp7_ = contacts;
	_tmp7__length1 = contacts_length1;
	_tmp8_ = _tmp7_[0];
	_tmp9_ = _g_object_ref0 (_tmp8_);
	contact = _tmp9_;
	_tmp10_ = contact;
	_tmp12_ = _tpf_persona_store_add_persona_from_contact (self, _tmp10_, FALSE, &_tmp11_);
	added = _tmp11_;
	persona = _tmp12_;
	_tmp13_ = gee_hash_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	personas = _tmp13_;
	_tmp14_ = added;
	if (_tmp14_) {
		GeeHashSet* _tmp15_;
		TpfPersona* _tmp16_;
		_tmp15_ = personas;
		_tmp16_ = persona;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, _tmp16_);
	}
	_tmp17_ = contact;
	_tmp18_ = _g_object_ref0 (_tmp17_);
	_g_object_unref0 (self->priv->_self_contact);
	self->priv->_self_contact = _tmp18_;
	_tmp19_ = personas;
	_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, (GeeSet*) _tmp19_, NULL, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	self->priv->_got_self_handle = TRUE;
	_tpf_persona_store_notify_if_is_quiescent (self);
	_g_object_unref0 (personas);
	_g_object_unref0 (persona);
	_g_object_unref0 (contact);
}


static void ___lambda6__tp_connection_contacts_by_handle_cb (TpConnection* connection, guint n_contacts, TpContact** contacts, guint n_failed, TpHandle* failed, GError* _error_, gpointer self, GObject* weak_object) {
	__lambda6_ (self, connection, contacts, n_contacts, failed, n_failed, _error_, weak_object);
}


static void _tpf_persona_store_self_handle_changed_cb (TpfPersonaStore* self, GObject* s, GParamSpec* p) {
	GObject* _tmp0_;
	TpConnection* _tmp1_;
	TpConnection* c;
	TpContact* _tmp2_;
	TpConnection* _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	TpConnection* _tmp9_;
	guint _tmp10_;
	guint _tmp11_;
	guint* _tmp12_ = NULL;
	guint* contact_handles;
	gint contact_handles_length1;
	gint _contact_handles_size_;
	TpConnection* _tmp13_;
	guint* _tmp14_;
	gint _tmp14__length1;
	TpContactFeature* _tmp15_;
	gint _tmp15__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	_tmp0_ = s;
	_tmp1_ = _g_object_ref0 (TP_CONNECTION (_tmp0_));
	c = _tmp1_;
	_tmp2_ = self->priv->_self_contact;
	if (_tmp2_ != NULL) {
		TpContact* _tmp3_;
		guint _tmp4_;
		guint _tmp5_;
		_tmp3_ = self->priv->_self_contact;
		_tmp4_ = tp_contact_get_handle (_tmp3_);
		_tmp5_ = _tmp4_;
		_tpf_persona_store_ignore_by_handle (self, _tmp5_, NULL, NULL, 0);
	}
	_tmp6_ = c;
	_tmp7_ = tp_connection_get_self_handle (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == ((guint) 0)) {
		self->priv->_got_self_handle = TRUE;
		_tpf_persona_store_notify_if_is_quiescent (self);
		_g_object_unref0 (c);
		return;
	}
	_tmp9_ = c;
	_tmp10_ = tp_connection_get_self_handle (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_new0 (guint, 1);
	_tmp12_[0] = _tmp11_;
	contact_handles = _tmp12_;
	contact_handles_length1 = 1;
	_contact_handles_size_ = contact_handles_length1;
	_tmp13_ = c;
	_tmp14_ = contact_handles;
	_tmp14__length1 = contact_handles_length1;
	_tmp15_ = tpf_persona_store__contact_features;
	_tmp15__length1 = tpf_persona_store__contact_features_length1;
	tp_connection_get_contacts_by_handle (_tmp13_, (guint) _tmp14__length1, _tmp14_, (guint) _tmp15__length1, (guint*) _tmp15_, ___lambda6__tp_connection_contacts_by_handle_cb, g_object_ref (self), g_object_unref, (GObject*) self);
	contact_handles = (g_free (contact_handles), NULL);
	_g_object_unref0 (c);
}


static void _tpf_persona_store_new_group_channels_cb (TpfPersonaStore* self, TpChannel* channel, GAsyncResult* _result_) {
	TpChannel* _tmp0_;
	TpChannel* _tmp2_;
	TpChannel* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = channel;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = _ ("Error creating channel for NewChannels signal.");
		g_warning ("tpf-persona-store.vala:1247: %s", _tmp1_);
		return;
	}
	_tmp2_ = channel;
	_tpf_persona_store_set_up_new_group_channel (self, _tmp2_);
	_tmp3_ = channel;
	_tpf_persona_store_channel_group_changes_resolve (self, _tmp3_);
}


static void _tpf_persona_store_channel_group_changes_resolve (TpfPersonaStore* self, TpChannel* channel) {
	TpChannel* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* group;
	GeeHashMap* _tmp2_;
	GeeHashMap* change_maps;
	GeeHashMap* _tmp3_;
	const gchar* _tmp4_;
	gpointer _tmp5_ = NULL;
	GeeHashSet* _tmp6_;
	gboolean _tmp7_;
	GeeHashMap* _tmp13_;
	const gchar* _tmp14_;
	gpointer _tmp15_ = NULL;
	GeeHashSet* _tmp16_;
	gboolean _tmp17_;
	GeeHashMap* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = channel;
	_tmp1_ = tp_channel_get_identifier (_tmp0_);
	group = _tmp1_;
	_tmp2_ = gee_hash_map_new (GEE_TYPE_HASH_SET, (GBoxedCopyFunc) g_object_ref, g_object_unref, G_TYPE_BOOLEAN, NULL, NULL, NULL, NULL, NULL);
	change_maps = _tmp2_;
	_tmp3_ = self->priv->_group_outgoing_adds;
	_tmp4_ = group;
	_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, _tmp4_);
	_tmp6_ = (GeeHashSet*) _tmp5_;
	_tmp7_ = _tmp6_ != NULL;
	_g_object_unref0 (_tmp6_);
	if (_tmp7_) {
		GeeHashMap* _tmp8_;
		GeeHashMap* _tmp9_;
		const gchar* _tmp10_;
		gpointer _tmp11_ = NULL;
		GeeHashSet* _tmp12_;
		_tmp8_ = change_maps;
		_tmp9_ = self->priv->_group_outgoing_adds;
		_tmp10_ = group;
		_tmp11_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, _tmp10_);
		_tmp12_ = (GeeHashSet*) _tmp11_;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, _tmp12_, GINT_TO_POINTER (TRUE));
		_g_object_unref0 (_tmp12_);
	}
	_tmp13_ = self->priv->_group_outgoing_removes;
	_tmp14_ = group;
	_tmp15_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp13_, _tmp14_);
	_tmp16_ = (GeeHashSet*) _tmp15_;
	_tmp17_ = _tmp16_ != NULL;
	_g_object_unref0 (_tmp16_);
	if (_tmp17_) {
		GeeHashMap* _tmp18_;
		GeeHashMap* _tmp19_;
		const gchar* _tmp20_;
		gpointer _tmp21_ = NULL;
		GeeHashSet* _tmp22_;
		_tmp18_ = change_maps;
		_tmp19_ = self->priv->_group_outgoing_removes;
		_tmp20_ = group;
		_tmp21_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp19_, _tmp20_);
		_tmp22_ = (GeeHashSet*) _tmp21_;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp18_, _tmp22_, GINT_TO_POINTER (FALSE));
		_g_object_unref0 (_tmp22_);
	}
	_tmp23_ = change_maps;
	_tmp24_ = gee_abstract_map_get_size ((GeeMap*) _tmp23_);
	_tmp25_ = _tmp24_;
	if (_tmp25_ < 1) {
		_g_object_unref0 (change_maps);
		return;
	}
	{
		GeeHashMap* _tmp26_;
		GeeSet* _tmp27_;
		GeeSet* _tmp28_;
		GeeSet* _tmp29_;
		GeeIterator* _tmp30_ = NULL;
		GeeIterator* _tmp31_;
		GeeIterator* _entry_it;
		_tmp26_ = change_maps;
		_tmp27_ = gee_abstract_map_get_entries ((GeeMap*) _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = _tmp28_;
		_tmp30_ = gee_iterable_iterator ((GeeIterable*) _tmp29_);
		_tmp31_ = _tmp30_;
		_g_object_unref0 (_tmp29_);
		_entry_it = _tmp31_;
		while (TRUE) {
			GeeIterator* _tmp32_;
			gboolean _tmp33_ = FALSE;
			GeeIterator* _tmp34_;
			gpointer _tmp35_ = NULL;
			GeeMapEntry* entry;
			GeeMapEntry* _tmp36_;
			gconstpointer _tmp37_;
			GeeHashSet* _tmp38_;
			GeeHashSet* _tmp39_;
			GeeHashSet* changes;
			GeeHashSet* _tmp82_;
			_tmp32_ = _entry_it;
			_tmp33_ = gee_iterator_next (_tmp32_);
			if (!_tmp33_) {
				break;
			}
			_tmp34_ = _entry_it;
			_tmp35_ = gee_iterator_get (_tmp34_);
			entry = (GeeMapEntry*) _tmp35_;
			_tmp36_ = entry;
			_tmp37_ = gee_map_entry_get_key (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = _g_object_ref0 ((GeeHashSet*) _tmp38_);
			changes = _tmp39_;
			{
				GeeHashSet* _tmp40_;
				GeeIterator* _tmp41_ = NULL;
				GeeIterator* _persona_it;
				_tmp40_ = changes;
				_tmp41_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp40_);
				_persona_it = _tmp41_;
				while (TRUE) {
					GeeIterator* _tmp42_;
					gboolean _tmp43_ = FALSE;
					GeeIterator* _tmp44_;
					gpointer _tmp45_ = NULL;
					TpfPersona* persona;
					_tmp42_ = _persona_it;
					_tmp43_ = gee_iterator_next (_tmp42_);
					if (!_tmp43_) {
						break;
					}
					_tmp44_ = _persona_it;
					_tmp45_ = gee_iterator_get (_tmp44_);
					persona = (TpfPersona*) _tmp45_;
					{
						TpChannel* _tmp46_;
						TpfPersona* _tmp47_;
						TpContact* _tmp48_;
						TpContact* _tmp49_;
						guint _tmp50_;
						guint _tmp51_;
						GeeMapEntry* _tmp52_;
						gconstpointer _tmp53_;
						gboolean _tmp54_;
						_tmp46_ = channel;
						_tmp47_ = persona;
						_tmp48_ = tpf_persona_get_contact (_tmp47_);
						_tmp49_ = _tmp48_;
						_tmp50_ = tp_contact_get_handle (_tmp49_);
						_tmp51_ = _tmp50_;
						_tmp52_ = entry;
						_tmp53_ = gee_map_entry_get_value (_tmp52_);
						_tmp54_ = _tmp53_;
						folks_tp_lowlevel_channel_group_change_membership (_tmp46_, (guint) ((TpHandle) _tmp51_), GPOINTER_TO_INT (_tmp54_), NULL, &_inner_error_);
						if (_inner_error_ != NULL) {
							goto __catch13_g_error;
						}
					}
					goto __finally13;
					__catch13_g_error:
					{
						GError* e = NULL;
						GeeMapEntry* _tmp55_;
						gconstpointer _tmp56_;
						gboolean _tmp57_;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp55_ = entry;
						_tmp56_ = gee_map_entry_get_value (_tmp55_);
						_tmp57_ = _tmp56_;
						if (GPOINTER_TO_INT (_tmp57_) == TRUE) {
							const gchar* _tmp58_ = NULL;
							TpfPersona* _tmp59_;
							TpContact* _tmp60_;
							TpContact* _tmp61_;
							const gchar* _tmp67_ = NULL;
							const gchar* _tmp68_;
							const gchar* _tmp69_;
							_tmp59_ = persona;
							_tmp60_ = tpf_persona_get_contact (_tmp59_);
							_tmp61_ = _tmp60_;
							if (_tmp61_ != NULL) {
								TpfPersona* _tmp62_;
								TpContact* _tmp63_;
								TpContact* _tmp64_;
								const gchar* _tmp65_;
								const gchar* _tmp66_;
								_tmp62_ = persona;
								_tmp63_ = tpf_persona_get_contact (_tmp62_);
								_tmp64_ = _tmp63_;
								_tmp65_ = tp_contact_get_identifier (_tmp64_);
								_tmp66_ = _tmp65_;
								_tmp58_ = _tmp66_;
							} else {
								_tmp58_ = "(nil)";
							}
							_tmp67_ = _ ("Failed to add Telepathy contact ‘%s’ to group ‘%s’.");
							_tmp68_ = _tmp58_;
							_tmp69_ = group;
							g_warning (_tmp67_, _tmp68_, _tmp69_);
						} else {
							const gchar* _tmp70_ = NULL;
							TpfPersona* _tmp71_;
							TpContact* _tmp72_;
							TpContact* _tmp73_;
							const gchar* _tmp79_ = NULL;
							const gchar* _tmp80_;
							const gchar* _tmp81_;
							_tmp71_ = persona;
							_tmp72_ = tpf_persona_get_contact (_tmp71_);
							_tmp73_ = _tmp72_;
							if (_tmp73_ != NULL) {
								TpfPersona* _tmp74_;
								TpContact* _tmp75_;
								TpContact* _tmp76_;
								const gchar* _tmp77_;
								const gchar* _tmp78_;
								_tmp74_ = persona;
								_tmp75_ = tpf_persona_get_contact (_tmp74_);
								_tmp76_ = _tmp75_;
								_tmp77_ = tp_contact_get_identifier (_tmp76_);
								_tmp78_ = _tmp77_;
								_tmp70_ = _tmp78_;
							} else {
								_tmp70_ = "(nil)";
							}
							_tmp79_ = _ ("Failed to remove Telepathy contact ‘%s’ from group ‘%s’.");
							_tmp80_ = _tmp70_;
							_tmp81_ = group;
							g_warning (_tmp79_, _tmp80_, _tmp81_);
						}
						_g_error_free0 (e);
					}
					__finally13:
					if (_inner_error_ != NULL) {
						_g_object_unref0 (persona);
						_g_object_unref0 (_persona_it);
						_g_object_unref0 (changes);
						_g_object_unref0 (entry);
						_g_object_unref0 (_entry_it);
						_g_object_unref0 (change_maps);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_g_object_unref0 (persona);
				}
				_g_object_unref0 (_persona_it);
			}
			_tmp82_ = changes;
			gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp82_);
			_g_object_unref0 (changes);
			_g_object_unref0 (entry);
		}
		_g_object_unref0 (_entry_it);
	}
	_g_object_unref0 (change_maps);
}


static void __tpf_persona_store_publish_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed (TpChannel* _sender, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details, gpointer self) {
	_tpf_persona_store_publish_channel_group_members_changed_detailed_cb (self, _sender, added, removed, local_pending, remote_pending, details);
}


static void __tpf_persona_store_stored_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed (TpChannel* _sender, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details, gpointer self) {
	_tpf_persona_store_stored_channel_group_members_changed_detailed_cb (self, _sender, added, removed, local_pending, remote_pending, details);
}


static void __tpf_persona_store_subscribe_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed (TpChannel* _sender, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details, gpointer self) {
	_tpf_persona_store_subscribe_channel_group_members_changed_detailed_cb (self, _sender, added, removed, local_pending, remote_pending, details);
}


static void __tpf_persona_store_subscribe_channel_group_flags_changed_cb_tp_channel_group_flags_changed (TpChannel* _sender, guint added, guint removed, gpointer self) {
	_tpf_persona_store_subscribe_channel_group_flags_changed_cb (self, _sender, added, removed);
}


static void __tpf_persona_store_channel_invalidated_cb_tp_proxy_invalidated (TpProxy* _sender, guint domain, gint code, const gchar* message, gpointer self) {
	_tpf_persona_store_channel_invalidated_cb (self, _sender, domain, code, message);
}


static void ___lambda18_ (TpfPersonaStore* self, GObject* obj, GAsyncResult* res) {
	GAsyncResult* _tmp0_;
	g_return_if_fail (res != NULL);
	_tmp0_ = res;
	_tpf_persona_store_channel_group_pend_incoming_adds_finish (self, _tmp0_);
	self->priv->_got_stored_channel_members = TRUE;
	_tpf_persona_store_notify_if_is_quiescent (self);
}


static void ____lambda18__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda18_ (self, source_object, res);
	g_object_unref (self);
}


static void __lambda17_ (TpfPersonaStore* self, GObject* s, GParamSpec* p) {
	GObject* _tmp0_;
	TpChannel* _tmp1_;
	TpChannel* c;
	TpChannel* _tmp2_;
	const gchar* _tmp3_ = NULL;
	const gchar* name;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GeeHashMap* _tmp21_;
	const gchar* _tmp22_;
	TpChannel* _tmp23_;
	TpChannel* _tmp24_;
	TpIntset* _tmp25_ = NULL;
	TpIntset* members;
	gboolean _tmp26_ = FALSE;
	TpIntset* _tmp27_;
	gboolean _tmp29_;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = s;
	_tmp1_ = _g_object_ref0 (TP_CHANNEL (_tmp0_));
	c = _tmp1_;
	_tmp2_ = c;
	_tmp3_ = tp_channel_get_identifier (_tmp2_);
	name = _tmp3_;
	_tmp4_ = name;
	g_debug ("tpf-persona-store.vala:1325: Channel '%s' is ready.", _tmp4_);
	_tmp5_ = name;
	if (g_strcmp0 (_tmp5_, "publish") == 0) {
		TpChannel* _tmp6_;
		TpChannel* _tmp7_;
		TpChannel* _tmp8_;
		_tmp6_ = c;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_g_object_unref0 (self->priv->_publish);
		self->priv->_publish = _tmp7_;
		_tmp8_ = c;
		g_signal_connect_object (_tmp8_, "group-members-changed-detailed", (GCallback) __tpf_persona_store_publish_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed, self, 0);
	} else {
		const gchar* _tmp9_;
		_tmp9_ = name;
		if (g_strcmp0 (_tmp9_, "stored") == 0) {
			TpChannel* _tmp10_;
			TpChannel* _tmp11_;
			TpChannel* _tmp12_;
			_tmp10_ = c;
			_tmp11_ = _g_object_ref0 (_tmp10_);
			_g_object_unref0 (self->priv->_stored);
			self->priv->_stored = _tmp11_;
			_tmp12_ = c;
			g_signal_connect_object (_tmp12_, "group-members-changed-detailed", (GCallback) __tpf_persona_store_stored_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed, self, 0);
		} else {
			const gchar* _tmp13_;
			_tmp13_ = name;
			if (g_strcmp0 (_tmp13_, "subscribe") == 0) {
				TpChannel* _tmp14_;
				TpChannel* _tmp15_;
				TpChannel* _tmp16_;
				TpChannel* _tmp17_;
				TpChannel* _tmp18_;
				TpChannel* _tmp19_;
				TpChannelGroupFlags _tmp20_ = 0;
				_tmp14_ = c;
				_tmp15_ = _g_object_ref0 (_tmp14_);
				_g_object_unref0 (self->priv->_subscribe);
				self->priv->_subscribe = _tmp15_;
				_tmp16_ = c;
				g_signal_connect_object (_tmp16_, "group-members-changed-detailed", (GCallback) __tpf_persona_store_subscribe_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed, self, 0);
				_tmp17_ = c;
				g_signal_connect_object (_tmp17_, "group-flags-changed", (GCallback) __tpf_persona_store_subscribe_channel_group_flags_changed_cb_tp_channel_group_flags_changed, self, 0);
				_tmp18_ = c;
				_tmp19_ = c;
				_tmp20_ = tp_channel_group_get_flags (_tmp19_);
				_tpf_persona_store_subscribe_channel_group_flags_changed_cb (self, _tmp18_, (guint) _tmp20_, (guint) 0);
			}
		}
	}
	_tmp21_ = self->priv->_standard_channels_unready;
	_tmp22_ = name;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp21_, _tmp22_, NULL);
	_tmp23_ = c;
	g_signal_connect_object ((TpProxy*) _tmp23_, "invalidated", (GCallback) __tpf_persona_store_channel_invalidated_cb_tp_proxy_invalidated, self, 0);
	_tmp24_ = c;
	_tmp25_ = tp_channel_group_get_members (_tmp24_);
	members = _tmp25_;
	_tmp27_ = members;
	if (_tmp27_ != NULL) {
		const gchar* _tmp28_;
		_tmp28_ = name;
		_tmp26_ = g_strcmp0 (_tmp28_, "stored") == 0;
	} else {
		_tmp26_ = FALSE;
	}
	_tmp29_ = _tmp26_;
	if (_tmp29_) {
		TpChannel* _tmp30_;
		TpIntset* _tmp31_;
		GArray* _tmp32_ = NULL;
		GArray* _tmp33_;
		_tmp30_ = c;
		_tmp31_ = members;
		_tmp32_ = tp_intset_to_array (_tmp31_);
		_tmp33_ = _tmp32_;
		_tpf_persona_store_channel_group_pend_incoming_adds (self, _tmp30_, _tmp33_, TRUE, ____lambda18__gasync_ready_callback, g_object_ref (self));
		_g_array_unref0 (_tmp33_);
	} else {
		TpIntset* _tmp34_;
		_tmp34_ = members;
		if (_tmp34_ != NULL) {
			TpChannel* _tmp35_;
			TpIntset* _tmp36_;
			GArray* _tmp37_ = NULL;
			GArray* _tmp38_;
			_tmp35_ = c;
			_tmp36_ = members;
			_tmp37_ = tp_intset_to_array (_tmp36_);
			_tmp38_ = _tmp37_;
			_tpf_persona_store_channel_group_pend_incoming_adds (self, _tmp35_, _tmp38_, TRUE, NULL, NULL);
			_g_array_unref0 (_tmp38_);
		}
	}
	_g_object_unref0 (c);
}


static void ___lambda17__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda17_ (self, _sender, pspec);
}


static void _tpf_persona_store_set_up_new_standard_channel (TpfPersonaStore* self, TpChannel* channel) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	TpChannel* _tmp2_;
	const gchar* _tmp3_ = NULL;
	GeeHashMap* _tmp4_;
	TpChannel* _tmp5_;
	const gchar* _tmp6_ = NULL;
	TpChannel* _tmp7_;
	TpChannel* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = channel;
	_tmp3_ = tp_channel_get_identifier (_tmp2_);
	g_debug ("Setting up new standard channel '%s' for Tpf.PersonaStore " "%p ('%s').", self, _tmp1_, _tmp3_);
	_tmp4_ = self->priv->_standard_channels_unready;
	_tmp5_ = channel;
	_tmp6_ = tp_channel_get_identifier (_tmp5_);
	_tmp7_ = channel;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp4_, _tmp6_, _tmp7_);
	_tmp8_ = channel;
	g_signal_connect_object ((GObject*) _tmp8_, "notify::channel-ready", (GCallback) ___lambda17__g_object_notify, self, 0);
}


static void _tpf_persona_store_disconnect_from_standard_channel (TpfPersonaStore* self, TpChannel* channel) {
	TpChannel* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* name;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	TpChannel* _tmp6_;
	guint _tmp7_ = 0U;
	const gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = channel;
	_tmp1_ = tp_channel_get_identifier (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	name = _tmp2_;
	_tmp3_ = name;
	_tmp4_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp5_ = _tmp4_;
	g_debug ("tpf-persona-store.vala:1383: Disconnecting from channel '%s' for Tpf.P" \
"ersonaStore %p ('%s').", _tmp3_, self, _tmp5_);
	_tmp6_ = channel;
	g_signal_parse_name ("invalidated", tp_proxy_get_type (), &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((TpProxy*) _tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) __tpf_persona_store_channel_invalidated_cb_tp_proxy_invalidated, self);
	_tmp8_ = name;
	if (g_strcmp0 (_tmp8_, "publish") == 0) {
		TpChannel* _tmp9_;
		guint _tmp10_ = 0U;
		_tmp9_ = channel;
		g_signal_parse_name ("group-members-changed-detailed", tp_channel_get_type (), &_tmp10_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) __tpf_persona_store_publish_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed, self);
	} else {
		const gchar* _tmp11_;
		_tmp11_ = name;
		if (g_strcmp0 (_tmp11_, "stored") == 0) {
			TpChannel* _tmp12_;
			guint _tmp13_ = 0U;
			_tmp12_ = channel;
			g_signal_parse_name ("group-members-changed-detailed", tp_channel_get_type (), &_tmp13_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp12_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp13_, 0, NULL, (GCallback) __tpf_persona_store_stored_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed, self);
		} else {
			const gchar* _tmp14_;
			_tmp14_ = name;
			if (g_strcmp0 (_tmp14_, "subscribe") == 0) {
				TpChannel* _tmp15_;
				guint _tmp16_ = 0U;
				TpChannel* _tmp17_;
				guint _tmp18_ = 0U;
				_tmp15_ = channel;
				g_signal_parse_name ("group-members-changed-detailed", tp_channel_get_type (), &_tmp16_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp15_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp16_, 0, NULL, (GCallback) __tpf_persona_store_subscribe_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed, self);
				_tmp17_ = channel;
				g_signal_parse_name ("group-flags-changed", tp_channel_get_type (), &_tmp18_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp17_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp18_, 0, NULL, (GCallback) __tpf_persona_store_subscribe_channel_group_flags_changed_cb_tp_channel_group_flags_changed, self);
			}
		}
	}
	_g_free0 (name);
}


static void _tpf_persona_store_publish_channel_group_members_changed_detailed_cb (TpfPersonaStore* self, TpChannel* channel, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details) {
	GArray* _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	g_return_if_fail (local_pending != NULL);
	g_return_if_fail (remote_pending != NULL);
	g_return_if_fail (details != NULL);
	_tmp0_ = added;
	_tmp1_ = _tmp0_->len;
	if (_tmp1_ > ((guint) 0)) {
		TpChannel* _tmp2_;
		GArray* _tmp3_;
		_tmp2_ = channel;
		_tmp3_ = added;
		_tpf_persona_store_channel_group_pend_incoming_adds (self, _tmp2_, _tmp3_, TRUE, NULL, NULL);
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				gint _tmp7_;
				GArray* _tmp8_;
				guint _tmp9_;
				GArray* _tmp10_;
				gint _tmp11_;
				guint _tmp12_ = 0U;
				guint handle;
				guint _tmp13_;
				GHashTable* _tmp14_;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = removed;
				_tmp9_ = _tmp8_->len;
				if (!(((guint) _tmp7_) < _tmp9_)) {
					break;
				}
				_tmp10_ = removed;
				_tmp11_ = i;
				_tmp12_ = g_array_index (_tmp10_, guint, (guint) _tmp11_);
				handle = _tmp12_;
				_tmp13_ = handle;
				_tmp14_ = details;
				_tpf_persona_store_ignore_by_handle_if_needed (self, _tmp13_, _tmp14_);
			}
		}
	}
}


static void ___lambda7_ (TpfPersonaStore* self, GObject* obj, GAsyncResult* res) {
	GAsyncResult* _tmp0_;
	g_return_if_fail (res != NULL);
	_tmp0_ = res;
	_tpf_persona_store_channel_group_pend_incoming_adds_finish (self, _tmp0_);
	self->priv->_got_stored_channel_members = TRUE;
	_tpf_persona_store_notify_if_is_quiescent (self);
}


static void ____lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda7_ (self, source_object, res);
	g_object_unref (self);
}


static void _tpf_persona_store_stored_channel_group_members_changed_detailed_cb (TpfPersonaStore* self, TpChannel* channel, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details) {
	GArray* _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	g_return_if_fail (local_pending != NULL);
	g_return_if_fail (remote_pending != NULL);
	g_return_if_fail (details != NULL);
	_tmp0_ = added;
	_tmp1_ = _tmp0_->len;
	if (_tmp1_ > ((guint) 0)) {
		TpChannel* _tmp2_;
		GArray* _tmp3_;
		_tmp2_ = channel;
		_tmp3_ = added;
		_tpf_persona_store_channel_group_pend_incoming_adds (self, _tmp2_, _tmp3_, TRUE, ____lambda7__gasync_ready_callback, g_object_ref (self));
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				gint _tmp7_;
				GArray* _tmp8_;
				guint _tmp9_;
				GArray* _tmp10_;
				gint _tmp11_;
				guint _tmp12_ = 0U;
				guint handle;
				guint _tmp13_;
				GHashTable* _tmp14_;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = removed;
				_tmp9_ = _tmp8_->len;
				if (!(((guint) _tmp7_) < _tmp9_)) {
					break;
				}
				_tmp10_ = removed;
				_tmp11_ = i;
				_tmp12_ = g_array_index (_tmp10_, guint, (guint) _tmp11_);
				handle = _tmp12_;
				_tmp13_ = handle;
				_tmp14_ = details;
				_tpf_persona_store_ignore_by_handle_if_needed (self, _tmp13_, _tmp14_);
			}
		}
	}
}


static void _tpf_persona_store_subscribe_channel_group_flags_changed_cb (TpfPersonaStore* self, TpChannel* channel, guint added, guint removed) {
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = added;
	_tmp1_ = removed;
	_tpf_persona_store_update_capability (self, (TpChannelGroupFlags) _tmp0_, (TpChannelGroupFlags) _tmp1_, TP_CHANNEL_GROUP_FLAG_CAN_ADD, &self->priv->_can_add_personas, "can-add-personas");
	_tmp2_ = added;
	_tmp3_ = removed;
	_tpf_persona_store_update_capability (self, (TpChannelGroupFlags) _tmp2_, (TpChannelGroupFlags) _tmp3_, TP_CHANNEL_GROUP_FLAG_CAN_REMOVE, &self->priv->_can_remove_personas, "can-remove-personas");
}


static void _tpf_persona_store_update_capability (TpfPersonaStore* self, TpChannelGroupFlags added, TpChannelGroupFlags removed, TpChannelGroupFlags tp_flag, FolksMaybeBool* private_member, const gchar* prop_name) {
	FolksMaybeBool _tmp0_;
	FolksMaybeBool new_value;
	TpChannelGroupFlags _tmp1_;
	TpChannelGroupFlags _tmp2_;
	TpChannelGroupFlags _tmp3_;
	TpChannelGroupFlags _tmp4_;
	FolksMaybeBool _tmp5_;
	FolksMaybeBool _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prop_name != NULL);
	_tmp0_ = *private_member;
	new_value = _tmp0_;
	_tmp1_ = added;
	_tmp2_ = tp_flag;
	if ((_tmp1_ & _tmp2_) != 0) {
		new_value = FOLKS_MAYBE_BOOL_TRUE;
	}
	_tmp3_ = removed;
	_tmp4_ = tp_flag;
	if ((_tmp3_ & _tmp4_) != 0) {
		new_value = FOLKS_MAYBE_BOOL_FALSE;
	}
	_tmp5_ = new_value;
	_tmp6_ = *private_member;
	if (_tmp5_ != _tmp6_) {
		FolksMaybeBool _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = new_value;
		*private_member = _tmp7_;
		_tmp8_ = prop_name;
		g_object_notify ((GObject*) self, _tmp8_);
	}
}


static void _tpf_persona_store_subscribe_channel_group_members_changed_detailed_cb (TpfPersonaStore* self, TpChannel* channel, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details) {
	GArray* _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	g_return_if_fail (local_pending != NULL);
	g_return_if_fail (remote_pending != NULL);
	g_return_if_fail (details != NULL);
	_tmp0_ = added;
	_tmp1_ = _tmp0_->len;
	if (_tmp1_ > ((guint) 0)) {
		TpChannel* _tmp2_;
		GArray* _tmp3_;
		TpChannel* _tmp4_;
		_tmp2_ = channel;
		_tmp3_ = added;
		_tpf_persona_store_channel_group_pend_incoming_adds (self, _tmp2_, _tmp3_, TRUE, NULL, NULL);
		_tmp4_ = self->priv->_publish;
		if (_tmp4_ != NULL) {
			TpChannel* _tmp5_;
			GArray* _tmp6_;
			_tmp5_ = self->priv->_publish;
			_tmp6_ = added;
			_tpf_persona_store_channel_group_pend_incoming_adds (self, _tmp5_, _tmp6_, TRUE, NULL, NULL);
		}
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				gboolean _tmp8_;
				gint _tmp10_;
				GArray* _tmp11_;
				guint _tmp12_;
				GArray* _tmp13_;
				gint _tmp14_;
				guint _tmp15_ = 0U;
				guint handle;
				guint _tmp16_;
				GHashTable* _tmp17_;
				_tmp8_ = _tmp7_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp10_ = i;
				_tmp11_ = removed;
				_tmp12_ = _tmp11_->len;
				if (!(((guint) _tmp10_) < _tmp12_)) {
					break;
				}
				_tmp13_ = removed;
				_tmp14_ = i;
				_tmp15_ = g_array_index (_tmp13_, guint, (guint) _tmp14_);
				handle = _tmp15_;
				_tmp16_ = handle;
				_tmp17_ = details;
				_tpf_persona_store_ignore_by_handle_if_needed (self, _tmp16_, _tmp17_);
			}
		}
	}
}


static void _tpf_persona_store_channel_invalidated_cb (TpfPersonaStore* self, TpProxy* proxy, guint domain, gint code, const gchar* message) {
	TpProxy* _tmp0_;
	TpChannel* _tmp1_;
	TpChannel* channel;
	GeeHashMap* _tmp2_;
	TpChannel* _tmp3_;
	GeeHashMap* _tmp4_;
	TpChannel* _tmp5_;
	TpProxy* _tmp6_;
	TpChannel* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (proxy != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = proxy;
	_tmp1_ = _g_object_ref0 (TP_CHANNEL (_tmp0_));
	channel = _tmp1_;
	_tmp2_ = self->priv->_channel_group_personas_map;
	_tmp3_ = channel;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp2_, _tmp3_, NULL);
	_tmp4_ = self->priv->_channel_group_incoming_adds;
	_tmp5_ = channel;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp4_, _tmp5_, NULL);
	_tmp6_ = proxy;
	_tmp7_ = self->priv->_publish;
	if (_tmp6_ == TP_PROXY (_tmp7_)) {
		_g_object_unref0 (self->priv->_publish);
		self->priv->_publish = NULL;
	} else {
		TpProxy* _tmp8_;
		TpChannel* _tmp9_;
		_tmp8_ = proxy;
		_tmp9_ = self->priv->_stored;
		if (_tmp8_ == TP_PROXY (_tmp9_)) {
			_g_object_unref0 (self->priv->_stored);
			self->priv->_stored = NULL;
		} else {
			TpProxy* _tmp10_;
			TpChannel* _tmp11_;
			_tmp10_ = proxy;
			_tmp11_ = self->priv->_subscribe;
			if (_tmp10_ == TP_PROXY (_tmp11_)) {
				_g_object_unref0 (self->priv->_subscribe);
				self->priv->_subscribe = NULL;
			} else {
				guint _tmp12_;
				gint _tmp13_;
				const gchar* _tmp14_;
				GError* _tmp15_;
				GError* _error_;
				TpChannel* _tmp16_;
				const gchar* _tmp17_ = NULL;
				gchar* _tmp18_;
				gchar* name;
				const gchar* _tmp19_;
				GError* _tmp20_;
				GeeHashMap* _tmp21_;
				const gchar* _tmp22_;
				_tmp12_ = domain;
				_tmp13_ = code;
				_tmp14_ = message;
				_tmp15_ = g_error_new ((GQuark) _tmp12_, _tmp13_, "%s", _tmp14_);
				_error_ = _tmp15_;
				_tmp16_ = channel;
				_tmp17_ = tp_channel_get_identifier (_tmp16_);
				_tmp18_ = g_strdup (_tmp17_);
				name = _tmp18_;
				_tmp19_ = name;
				_tmp20_ = _error_;
				g_signal_emit_by_name (self, "group-removed", _tmp19_, _tmp20_);
				_tmp21_ = self->priv->_groups;
				_tmp22_ = name;
				gee_abstract_map_unset ((GeeAbstractMap*) _tmp21_, _tmp22_, NULL);
				_g_free0 (name);
				_g_error_free0 (_error_);
			}
		}
	}
	_g_object_unref0 (channel);
}


static void _tpf_persona_store_ignore_by_handle_if_needed (TpfPersonaStore* self, guint handle, GHashTable* details) {
	TpIntset* members = NULL;
	TpChannel* _tmp0_;
	TpChannel* _tmp11_;
	GHashTable* _tmp17_;
	const gchar* _tmp18_ = NULL;
	const gchar* message;
	gboolean valid = FALSE;
	TpfPersona* actor;
	GHashTable* _tmp19_;
	gboolean _tmp20_ = FALSE;
	guint32 _tmp21_ = 0U;
	guint32 actor_handle;
	gboolean _tmp22_ = FALSE;
	guint32 _tmp23_;
	gboolean _tmp25_;
	FolksGroupDetailsChangeReason reason;
	GHashTable* _tmp29_;
	gboolean _tmp30_ = FALSE;
	guint32 _tmp31_ = 0U;
	guint32 tp_reason;
	gboolean _tmp32_;
	guint _tmp35_;
	const gchar* _tmp36_;
	TpfPersona* _tmp37_;
	FolksGroupDetailsChangeReason _tmp38_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (details != NULL);
	_tmp0_ = self->priv->_subscribe;
	if (_tmp0_ != NULL) {
		TpChannel* _tmp1_;
		TpIntset* _tmp2_ = NULL;
		TpIntset* _tmp3_;
		guint _tmp4_;
		gboolean _tmp5_ = FALSE;
		TpChannel* _tmp6_;
		TpIntset* _tmp7_ = NULL;
		TpIntset* _tmp8_;
		guint _tmp9_;
		gboolean _tmp10_ = FALSE;
		_tmp1_ = self->priv->_subscribe;
		_tmp2_ = tp_channel_group_get_members (_tmp1_);
		members = _tmp2_;
		_tmp3_ = members;
		_tmp4_ = handle;
		_tmp5_ = tp_intset_is_member (_tmp3_, _tmp4_);
		if (_tmp5_) {
			return;
		}
		_tmp6_ = self->priv->_subscribe;
		_tmp7_ = tp_channel_group_get_remote_pending (_tmp6_);
		members = _tmp7_;
		_tmp8_ = members;
		_tmp9_ = handle;
		_tmp10_ = tp_intset_is_member (_tmp8_, _tmp9_);
		if (_tmp10_) {
			return;
		}
	}
	_tmp11_ = self->priv->_publish;
	if (_tmp11_ != NULL) {
		TpChannel* _tmp12_;
		TpIntset* _tmp13_ = NULL;
		TpIntset* _tmp14_;
		guint _tmp15_;
		gboolean _tmp16_ = FALSE;
		_tmp12_ = self->priv->_publish;
		_tmp13_ = tp_channel_group_get_members (_tmp12_);
		members = _tmp13_;
		_tmp14_ = members;
		_tmp15_ = handle;
		_tmp16_ = tp_intset_is_member (_tmp14_, _tmp15_);
		if (_tmp16_) {
			return;
		}
	}
	_tmp17_ = details;
	_tmp18_ = tp_asv_get_string (_tmp17_, "message");
	message = _tmp18_;
	actor = NULL;
	_tmp19_ = details;
	_tmp21_ = tp_asv_get_uint32 (_tmp19_, "actor", &_tmp20_);
	valid = _tmp20_;
	actor_handle = _tmp21_;
	_tmp23_ = actor_handle;
	if (_tmp23_ > ((guint32) 0)) {
		gboolean _tmp24_;
		_tmp24_ = valid;
		_tmp22_ = _tmp24_;
	} else {
		_tmp22_ = FALSE;
	}
	_tmp25_ = _tmp22_;
	if (_tmp25_) {
		GeeHashMap* _tmp26_;
		guint32 _tmp27_;
		gpointer _tmp28_ = NULL;
		_tmp26_ = self->priv->_handle_persona_map;
		_tmp27_ = actor_handle;
		_tmp28_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp26_, GUINT_TO_POINTER ((guint) _tmp27_));
		_g_object_unref0 (actor);
		actor = (TpfPersona*) _tmp28_;
	}
	reason = FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE;
	_tmp29_ = details;
	_tmp31_ = tp_asv_get_uint32 (_tmp29_, "change-reason", &_tmp30_);
	valid = _tmp30_;
	tp_reason = _tmp31_;
	_tmp32_ = valid;
	if (_tmp32_) {
		guint32 _tmp33_;
		FolksGroupDetailsChangeReason _tmp34_ = 0;
		_tmp33_ = tp_reason;
		_tmp34_ = _tpf_persona_store_change_reason_from_tp_reason ((guint) _tmp33_);
		reason = _tmp34_;
	}
	_tmp35_ = handle;
	_tmp36_ = message;
	_tmp37_ = actor;
	_tmp38_ = reason;
	_tpf_persona_store_ignore_by_handle (self, _tmp35_, _tmp36_, _tmp37_, _tmp38_);
	_g_object_unref0 (actor);
}


static FolksGroupDetailsChangeReason _tpf_persona_store_change_reason_from_tp_reason (guint reason) {
	FolksGroupDetailsChangeReason result = 0;
	guint _tmp0_;
	_tmp0_ = reason;
	result = (FolksGroupDetailsChangeReason) _tmp0_;
	return result;
}


static void _tpf_persona_store_ignore_by_handle (TpfPersonaStore* self, guint handle, const gchar* message, TpfPersona* actor, FolksGroupDetailsChangeReason reason) {
	GeeHashMap* _tmp0_;
	guint _tmp1_;
	gpointer _tmp2_ = NULL;
	TpfPersona* persona;
	guint _tmp3_;
	TpfPersona* _tmp4_;
	gboolean _tmp5_ = FALSE;
	TpContact* _tmp6_;
	gboolean _tmp11_;
	GeeHashMap* _tmp12_;
	guint _tmp13_;
	TpfPersona* _tmp14_;
	gboolean _tmp15_ = FALSE;
	TpfPersona* _tmp16_;
	TpContact* _tmp17_;
	TpContact* _tmp18_;
	gboolean _tmp24_;
	GeeHashSet* _tmp60_;
	GeeHashSet* personas;
	GeeHashSet* _tmp61_;
	TpfPersona* _tmp62_;
	GeeHashSet* _tmp63_;
	const gchar* _tmp64_;
	TpfPersona* _tmp65_;
	FolksGroupDetailsChangeReason _tmp66_;
	GeeHashMap* _tmp67_;
	TpfPersona* _tmp68_;
	const gchar* _tmp69_;
	const gchar* _tmp70_;
	GeeHashSet* _tmp71_;
	TpfPersona* _tmp72_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_handle_persona_map;
	_tmp1_ = handle;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, GUINT_TO_POINTER (_tmp1_));
	persona = (TpfPersona*) _tmp2_;
	_tmp3_ = handle;
	_tmp4_ = persona;
	g_debug ("tpf-persona-store.vala:1601: Ignoring handle %u (persona: %p)", _tmp3_, _tmp4_);
	_tmp6_ = self->priv->_self_contact;
	if (_tmp6_ != NULL) {
		TpContact* _tmp7_;
		guint _tmp8_;
		guint _tmp9_;
		guint _tmp10_;
		_tmp7_ = self->priv->_self_contact;
		_tmp8_ = tp_contact_get_handle (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = handle;
		_tmp5_ = _tmp9_ == _tmp10_;
	} else {
		_tmp5_ = FALSE;
	}
	_tmp11_ = _tmp5_;
	if (_tmp11_) {
		_g_object_unref0 (self->priv->_self_contact);
		self->priv->_self_contact = NULL;
	}
	_tmp12_ = self->priv->_handle_persona_map;
	_tmp13_ = handle;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp12_, GUINT_TO_POINTER (_tmp13_), NULL);
	_tmp14_ = persona;
	if (_tmp14_ == NULL) {
		_g_object_unref0 (persona);
		return;
	}
	_tmp16_ = persona;
	_tmp17_ = tpf_persona_get_contact (_tmp16_);
	_tmp18_ = _tmp17_;
	if (_tmp18_ != NULL) {
		GeeHashMap* _tmp19_;
		TpfPersona* _tmp20_;
		TpContact* _tmp21_;
		TpContact* _tmp22_;
		gboolean _tmp23_ = FALSE;
		_tmp19_ = self->priv->_weakly_referenced_contacts;
		_tmp20_ = persona;
		_tmp21_ = tpf_persona_get_contact (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = gee_abstract_map_unset ((GeeAbstractMap*) _tmp19_, _tmp22_, NULL);
		_tmp15_ = _tmp23_ == TRUE;
	} else {
		_tmp15_ = FALSE;
	}
	_tmp24_ = _tmp15_;
	if (_tmp24_) {
		TpfPersona* _tmp25_;
		TpContact* _tmp26_;
		TpContact* _tmp27_;
		_tmp25_ = persona;
		_tmp26_ = tpf_persona_get_contact (_tmp25_);
		_tmp27_ = _tmp26_;
		g_object_weak_unref ((GObject*) _tmp27_, __tpf_persona_store_contact_weak_notify_cb_gweak_notify, self);
	}
	{
		GeeHashMap* _tmp28_;
		GeeSet* _tmp29_;
		GeeSet* _tmp30_;
		GeeSet* _tmp31_;
		GeeIterator* _tmp32_ = NULL;
		GeeIterator* _tmp33_;
		GeeIterator* _channel_it;
		_tmp28_ = self->priv->_channel_group_personas_map;
		_tmp29_ = gee_abstract_map_get_keys ((GeeMap*) _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = _tmp30_;
		_tmp32_ = gee_iterable_iterator ((GeeIterable*) _tmp31_);
		_tmp33_ = _tmp32_;
		_g_object_unref0 (_tmp31_);
		_channel_it = _tmp33_;
		while (TRUE) {
			GeeIterator* _tmp34_;
			gboolean _tmp35_ = FALSE;
			GeeIterator* _tmp36_;
			gpointer _tmp37_ = NULL;
			TpChannel* channel;
			GeeHashMap* _tmp38_;
			TpChannel* _tmp39_;
			gpointer _tmp40_ = NULL;
			GeeHashSet* members;
			GeeHashSet* _tmp41_;
			_tmp34_ = _channel_it;
			_tmp35_ = gee_iterator_next (_tmp34_);
			if (!_tmp35_) {
				break;
			}
			_tmp36_ = _channel_it;
			_tmp37_ = gee_iterator_get (_tmp36_);
			channel = (TpChannel*) _tmp37_;
			_tmp38_ = self->priv->_channel_group_personas_map;
			_tmp39_ = channel;
			_tmp40_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp38_, _tmp39_);
			members = (GeeHashSet*) _tmp40_;
			_tmp41_ = members;
			if (_tmp41_ != NULL) {
				GeeHashSet* _tmp42_;
				TpfPersona* _tmp43_;
				_tmp42_ = members;
				_tmp43_ = persona;
				gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp42_, _tmp43_);
			}
			_g_object_unref0 (members);
			_g_object_unref0 (channel);
		}
		_g_object_unref0 (_channel_it);
	}
	{
		GeeHashMap* _tmp44_;
		GeeSet* _tmp45_;
		GeeSet* _tmp46_;
		GeeSet* _tmp47_;
		GeeIterator* _tmp48_ = NULL;
		GeeIterator* _tmp49_;
		GeeIterator* _name_it;
		_tmp44_ = self->priv->_group_outgoing_adds;
		_tmp45_ = gee_abstract_map_get_keys ((GeeMap*) _tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = _tmp46_;
		_tmp48_ = gee_iterable_iterator ((GeeIterable*) _tmp47_);
		_tmp49_ = _tmp48_;
		_g_object_unref0 (_tmp47_);
		_name_it = _tmp49_;
		while (TRUE) {
			GeeIterator* _tmp50_;
			gboolean _tmp51_ = FALSE;
			GeeIterator* _tmp52_;
			gpointer _tmp53_ = NULL;
			gchar* name;
			GeeHashMap* _tmp54_;
			const gchar* _tmp55_;
			gpointer _tmp56_ = NULL;
			GeeHashSet* members;
			GeeHashSet* _tmp57_;
			_tmp50_ = _name_it;
			_tmp51_ = gee_iterator_next (_tmp50_);
			if (!_tmp51_) {
				break;
			}
			_tmp52_ = _name_it;
			_tmp53_ = gee_iterator_get (_tmp52_);
			name = (gchar*) _tmp53_;
			_tmp54_ = self->priv->_group_outgoing_adds;
			_tmp55_ = name;
			_tmp56_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp54_, _tmp55_);
			members = (GeeHashSet*) _tmp56_;
			_tmp57_ = members;
			if (_tmp57_ != NULL) {
				GeeHashSet* _tmp58_;
				TpfPersona* _tmp59_;
				_tmp58_ = members;
				_tmp59_ = persona;
				gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp58_, _tmp59_);
			}
			_g_object_unref0 (members);
			_g_free0 (name);
		}
		_g_object_unref0 (_name_it);
	}
	_tmp60_ = gee_hash_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	personas = _tmp60_;
	_tmp61_ = personas;
	_tmp62_ = persona;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp61_, _tmp62_);
	_tmp63_ = personas;
	_tmp64_ = message;
	_tmp65_ = actor;
	_tmp66_ = reason;
	_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, NULL, (GeeSet*) _tmp63_, _tmp64_, (FolksPersona*) _tmp65_, _tmp66_);
	_tmp67_ = self->priv->_personas;
	_tmp68_ = persona;
	_tmp69_ = folks_persona_get_iid ((FolksPersona*) _tmp68_);
	_tmp70_ = _tmp69_;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp67_, _tmp70_, NULL);
	_tmp71_ = self->priv->_persona_set;
	_tmp72_ = persona;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp71_, _tmp72_);
	_g_object_unref0 (personas);
	_g_object_unref0 (persona);
}


static void tpf_persona_store_real_remove_persona_data_free (gpointer _data) {
	TpfPersonaStoreRemovePersonaData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreRemovePersonaData, _data_);
}


static void tpf_persona_store_real_remove_persona (FolksPersonaStore* base, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStore * self;
	TpfPersonaStoreRemovePersonaData* _data_;
	TpfPersonaStore* _tmp0_;
	FolksPersona* _tmp1_;
	FolksPersona* _tmp2_;
	self = (TpfPersonaStore*) base;
	_data_ = g_slice_new0 (TpfPersonaStoreRemovePersonaData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_real_remove_persona);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_real_remove_persona_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->persona = _tmp2_;
	tpf_persona_store_real_remove_persona_co (_data_);
}


static void tpf_persona_store_real_remove_persona_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaStoreRemovePersonaData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Remove a {@link Persona} from the PersonaStore.
   *
   * See {@link Folks.PersonaStore.remove_persona}.
   */
static gboolean tpf_persona_store_real_remove_persona_co (TpfPersonaStoreRemovePersonaData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->persona;
	_data_->_tmp1_ = _g_object_ref0 (TPF_PERSONA (_data_->_tmp0_));
	_data_->tp_persona = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->tp_persona;
	_data_->_tmp4_ = tpf_persona_get_contact (_data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = _data_->self->priv->_self_contact;
	if (_data_->_tmp5_ == _data_->_tmp6_) {
		_data_->_tmp7_ = _data_->tp_persona;
		_data_->_tmp8_ = tpf_persona_get_is_in_contact_list (_data_->_tmp7_);
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp2_ = _data_->_tmp9_ == FALSE;
	} else {
		_data_->_tmp2_ = FALSE;
	}
	_data_->_tmp10_ = _data_->_tmp2_;
	if (_data_->_tmp10_) {
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _ ("Telepathy contacts representing the local user may not be removed.");
		_data_->_tmp12_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_UNSUPPORTED_ON_USER, _data_->_tmp11_);
		_data_->_inner_error_ = _data_->_tmp12_;
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->tp_persona);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->tp_persona);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp13_ = _data_->tp_persona;
	_data_->_tmp14_ = tpf_persona_get_contact (_data_->_tmp13_);
	_data_->_tmp15_ = _data_->_tmp14_;
	if (_data_->_tmp15_ == NULL) {
		_data_->_tmp16_ = _data_->tp_persona;
		g_warning ("Skipping server-side removal of Tpf.Persona %p because " "it has no attached TpContact", _data_->_tmp16_);
		_g_object_unref0 (_data_->tp_persona);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp17_ = _data_->self->priv->_stored;
		_data_->_tmp18_ = _data_->tp_persona;
		_data_->_tmp19_ = tpf_persona_get_contact (_data_->_tmp18_);
		_data_->_tmp20_ = _data_->_tmp19_;
		_data_->_tmp21_ = tp_contact_get_handle (_data_->_tmp20_);
		_data_->_tmp22_ = _data_->_tmp21_;
		folks_tp_lowlevel_channel_group_change_membership (_data_->_tmp17_, (guint) ((TpHandle) _data_->_tmp22_), FALSE, NULL, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch14_g_error;
		}
	}
	goto __finally14;
	__catch14_g_error:
	{
		_data_->e1 = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = _ ("Failed to remove Telepathy contact ‘%s’ from ‘%s’ list: %s");
		_data_->_tmp24_ = _data_->tp_persona;
		_data_->_tmp25_ = tpf_persona_get_contact (_data_->_tmp24_);
		_data_->_tmp26_ = _data_->_tmp25_;
		_data_->_tmp27_ = tp_contact_get_identifier (_data_->_tmp26_);
		_data_->_tmp28_ = _data_->_tmp27_;
		_data_->_tmp29_ = _data_->e1;
		_data_->_tmp30_ = _data_->_tmp29_->message;
		g_warning (_data_->_tmp23_, _data_->_tmp28_, "stored", _data_->_tmp30_);
		_g_error_free0 (_data_->e1);
	}
	__finally14:
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->tp_persona);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->tp_persona);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	{
		_data_->_tmp31_ = _data_->self->priv->_subscribe;
		_data_->_tmp32_ = _data_->tp_persona;
		_data_->_tmp33_ = tpf_persona_get_contact (_data_->_tmp32_);
		_data_->_tmp34_ = _data_->_tmp33_;
		_data_->_tmp35_ = tp_contact_get_handle (_data_->_tmp34_);
		_data_->_tmp36_ = _data_->_tmp35_;
		folks_tp_lowlevel_channel_group_change_membership (_data_->_tmp31_, (guint) ((TpHandle) _data_->_tmp36_), FALSE, NULL, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch15_g_error;
		}
	}
	goto __finally15;
	__catch15_g_error:
	{
		_data_->e2 = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp37_ = NULL;
		_data_->_tmp37_ = _ ("Failed to remove Telepathy contact ‘%s’ from ‘%s’ list: %s");
		_data_->_tmp38_ = _data_->tp_persona;
		_data_->_tmp39_ = tpf_persona_get_contact (_data_->_tmp38_);
		_data_->_tmp40_ = _data_->_tmp39_;
		_data_->_tmp41_ = tp_contact_get_identifier (_data_->_tmp40_);
		_data_->_tmp42_ = _data_->_tmp41_;
		_data_->_tmp43_ = _data_->e2;
		_data_->_tmp44_ = _data_->_tmp43_->message;
		g_warning (_data_->_tmp37_, _data_->_tmp42_, "subscribe", _data_->_tmp44_);
		_g_error_free0 (_data_->e2);
	}
	__finally15:
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->tp_persona);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->tp_persona);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	{
		_data_->_tmp45_ = _data_->self->priv->_publish;
		_data_->_tmp46_ = _data_->tp_persona;
		_data_->_tmp47_ = tpf_persona_get_contact (_data_->_tmp46_);
		_data_->_tmp48_ = _data_->_tmp47_;
		_data_->_tmp49_ = tp_contact_get_handle (_data_->_tmp48_);
		_data_->_tmp50_ = _data_->_tmp49_;
		folks_tp_lowlevel_channel_group_change_membership (_data_->_tmp45_, (guint) ((TpHandle) _data_->_tmp50_), FALSE, NULL, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch16_g_error;
		}
	}
	goto __finally16;
	__catch16_g_error:
	{
		_data_->e3 = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp51_ = NULL;
		_data_->_tmp51_ = _ ("Failed to remove Telepathy contact ‘%s’ from ‘%s’ list: %s");
		_data_->_tmp52_ = _data_->tp_persona;
		_data_->_tmp53_ = tpf_persona_get_contact (_data_->_tmp52_);
		_data_->_tmp54_ = _data_->_tmp53_;
		_data_->_tmp55_ = tp_contact_get_identifier (_data_->_tmp54_);
		_data_->_tmp56_ = _data_->_tmp55_;
		_data_->_tmp57_ = _data_->e3;
		_data_->_tmp58_ = _data_->_tmp57_->message;
		g_warning (_data_->_tmp51_, _data_->_tmp56_, "publish", _data_->_tmp58_);
		_g_error_free0 (_data_->e3);
	}
	__finally16:
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->tp_persona);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->tp_persona);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->tp_persona);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _tpf_persona_store_channel_group_pend_incoming_adds_data_free (gpointer _data) {
	TpfPersonaStoreChannelGroupPendIncomingAddsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->channel);
	_g_array_unref0 (_data_->adds);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreChannelGroupPendIncomingAddsData, _data_);
}


static gpointer _g_array_ref0 (gpointer self) {
	return self ? g_array_ref (self) : NULL;
}


static void _tpf_persona_store_channel_group_pend_incoming_adds (TpfPersonaStore* self, TpChannel* channel, GArray* adds, gboolean create_personas, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreChannelGroupPendIncomingAddsData* _data_;
	TpfPersonaStore* _tmp0_;
	TpChannel* _tmp1_;
	TpChannel* _tmp2_;
	GArray* _tmp3_;
	GArray* _tmp4_;
	gboolean _tmp5_;
	_data_ = g_slice_new0 (TpfPersonaStoreChannelGroupPendIncomingAddsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_channel_group_pend_incoming_adds);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_channel_group_pend_incoming_adds_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = channel;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->channel = _tmp2_;
	_tmp3_ = adds;
	_tmp4_ = _g_array_ref0 (_tmp3_);
	_data_->adds = _tmp4_;
	_tmp5_ = create_personas;
	_data_->create_personas = _tmp5_;
	_tpf_persona_store_channel_group_pend_incoming_adds_co (_data_);
}


static void _tpf_persona_store_channel_group_pend_incoming_adds_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpfPersonaStoreChannelGroupPendIncomingAddsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _tpf_persona_store_channel_group_pend_incoming_adds_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreChannelGroupPendIncomingAddsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_store_channel_group_pend_incoming_adds_co (_data_);
}


static gboolean _tpf_persona_store_channel_group_pend_incoming_adds_co (TpfPersonaStoreChannelGroupPendIncomingAddsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->adds;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = _data_->adds;
		_data_->_tmp3_ = _data_->_tmp2_->len;
		_data_->_tmp0_ = _data_->_tmp3_;
	} else {
		_data_->_tmp0_ = (guint) 0;
	}
	_data_->_tmp4_ = _data_->_tmp0_;
	_data_->adds_length = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->adds_length;
	if (_data_->_tmp5_ >= ((guint) 1)) {
		_data_->_tmp6_ = _data_->create_personas;
		if (_data_->_tmp6_) {
			_data_->_tmp7_ = _data_->channel;
			_data_->_tmp8_ = _data_->adds;
			_data_->_state_ = 1;
			_tpf_persona_store_create_personas_from_channel_handles_async (_data_->self, _data_->_tmp7_, _data_->_tmp8_, _tpf_persona_store_channel_group_pend_incoming_adds_ready, _data_);
			return FALSE;
			_state_1:
			_tpf_persona_store_create_personas_from_channel_handles_finish (_data_->self, _data_->_res_);
		}
		{
			_data_->i = 0;
			{
				_data_->_tmp9_ = TRUE;
				while (TRUE) {
					_data_->_tmp10_ = _data_->_tmp9_;
					if (!_data_->_tmp10_) {
						_data_->_tmp11_ = _data_->i;
						_data_->i = _data_->_tmp11_ + 1;
					}
					_data_->_tmp9_ = FALSE;
					_data_->_tmp12_ = _data_->i;
					_data_->_tmp13_ = _data_->adds;
					_data_->_tmp14_ = _data_->_tmp13_->len;
					if (!(((guint) _data_->_tmp12_) < _data_->_tmp14_)) {
						break;
					}
					_data_->_tmp15_ = _data_->adds;
					_data_->_tmp16_ = _data_->i;
					_data_->_tmp17_ = 0U;
					_data_->_tmp17_ = g_array_index (_data_->_tmp15_, guint, (guint) _data_->_tmp16_);
					_data_->channel_handle = (TpHandle) _data_->_tmp17_;
					_data_->_tmp18_ = _data_->channel;
					_data_->_tmp19_ = _data_->channel_handle;
					_data_->_tmp20_ = 0U;
					_data_->_tmp20_ = tp_channel_group_get_handle_owner (_data_->_tmp18_, _data_->_tmp19_);
					_data_->contact_handle = _data_->_tmp20_;
					_data_->_tmp21_ = _data_->self->priv->_channel_group_incoming_adds;
					_data_->_tmp22_ = _data_->channel;
					_data_->_tmp23_ = NULL;
					_data_->_tmp23_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp21_, _data_->_tmp22_);
					_data_->contact_handles = (GeeHashSet*) _data_->_tmp23_;
					_data_->_tmp24_ = _data_->contact_handles;
					if (_data_->_tmp24_ == NULL) {
						_data_->_tmp25_ = gee_hash_set_new (G_TYPE_UINT, NULL, NULL, NULL, NULL);
						_g_object_unref0 (_data_->contact_handles);
						_data_->contact_handles = _data_->_tmp25_;
						_data_->_tmp26_ = _data_->self->priv->_channel_group_incoming_adds;
						_data_->_tmp27_ = _data_->channel;
						_data_->_tmp28_ = _data_->contact_handles;
						gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp26_, _data_->_tmp27_, _data_->_tmp28_);
					}
					_data_->_tmp29_ = _data_->contact_handles;
					_data_->_tmp30_ = _data_->contact_handle;
					gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp29_, GUINT_TO_POINTER ((guint) _data_->_tmp30_));
					_g_object_unref0 (_data_->contact_handles);
				}
			}
		}
	}
	_tpf_persona_store_channel_groups_add_new_personas (_data_->self);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void _tpf_persona_store_channel_group_handle_incoming_removes (TpfPersonaStore* self, TpChannel* channel, GArray* removes) {
	guint _tmp0_ = 0U;
	GArray* _tmp1_;
	guint _tmp4_;
	guint removes_length;
	guint _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	g_return_if_fail (removes != NULL);
	_tmp1_ = removes;
	if (_tmp1_ != NULL) {
		GArray* _tmp2_;
		guint _tmp3_;
		_tmp2_ = removes;
		_tmp3_ = _tmp2_->len;
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = (guint) 0;
	}
	_tmp4_ = _tmp0_;
	removes_length = _tmp4_;
	_tmp5_ = removes_length;
	if (_tmp5_ >= ((guint) 1)) {
		GList* members_removed;
		GeeHashMap* _tmp6_;
		TpChannel* _tmp7_;
		gpointer _tmp8_ = NULL;
		GeeHashSet* members;
		GeeHashSet* _tmp9_;
		GeeHashMap* _tmp31_;
		TpChannel* _tmp32_;
		GeeHashSet* _tmp33_;
		TpChannel* _tmp34_;
		const gchar* _tmp35_ = NULL;
		gchar* _tmp36_;
		gchar* name;
		gboolean _tmp37_ = FALSE;
		const gchar* _tmp38_;
		gboolean _tmp39_ = FALSE;
		gboolean _tmp42_;
		members_removed = NULL;
		_tmp6_ = self->priv->_channel_group_personas_map;
		_tmp7_ = channel;
		_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp6_, _tmp7_);
		members = (GeeHashSet*) _tmp8_;
		_tmp9_ = members;
		if (_tmp9_ == NULL) {
			GeeHashSet* _tmp10_;
			_tmp10_ = gee_hash_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
			_g_object_unref0 (members);
			members = _tmp10_;
		}
		{
			gint i;
			i = 0;
			{
				gboolean _tmp11_;
				_tmp11_ = TRUE;
				while (TRUE) {
					gboolean _tmp12_;
					gint _tmp14_;
					GArray* _tmp15_;
					guint _tmp16_;
					GArray* _tmp17_;
					gint _tmp18_;
					guint _tmp19_ = 0U;
					TpHandle channel_handle;
					TpChannel* _tmp20_;
					TpHandle _tmp21_;
					TpHandle _tmp22_ = 0U;
					TpHandle contact_handle;
					GeeHashMap* _tmp23_;
					TpHandle _tmp24_;
					gpointer _tmp25_ = NULL;
					TpfPersona* persona;
					TpfPersona* _tmp26_;
					_tmp12_ = _tmp11_;
					if (!_tmp12_) {
						gint _tmp13_;
						_tmp13_ = i;
						i = _tmp13_ + 1;
					}
					_tmp11_ = FALSE;
					_tmp14_ = i;
					_tmp15_ = removes;
					_tmp16_ = _tmp15_->len;
					if (!(((guint) _tmp14_) < _tmp16_)) {
						break;
					}
					_tmp17_ = removes;
					_tmp18_ = i;
					_tmp19_ = g_array_index (_tmp17_, guint, (guint) _tmp18_);
					channel_handle = (TpHandle) _tmp19_;
					_tmp20_ = channel;
					_tmp21_ = channel_handle;
					_tmp22_ = tp_channel_group_get_handle_owner (_tmp20_, _tmp21_);
					contact_handle = _tmp22_;
					_tmp23_ = self->priv->_handle_persona_map;
					_tmp24_ = contact_handle;
					_tmp25_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp23_, GUINT_TO_POINTER ((guint) _tmp24_));
					persona = (TpfPersona*) _tmp25_;
					_tmp26_ = persona;
					if (_tmp26_ != NULL) {
						GeeHashSet* _tmp27_;
						TpfPersona* _tmp28_;
						TpfPersona* _tmp29_;
						TpfPersona* _tmp30_;
						_tmp27_ = members;
						_tmp28_ = persona;
						gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp27_, _tmp28_);
						_tmp29_ = persona;
						_tmp30_ = _g_object_ref0 (_tmp29_);
						members_removed = g_list_prepend (members_removed, _tmp30_);
					}
					_g_object_unref0 (persona);
				}
			}
		}
		_tmp31_ = self->priv->_channel_group_personas_map;
		_tmp32_ = channel;
		_tmp33_ = members;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp31_, _tmp32_, _tmp33_);
		_tmp34_ = channel;
		_tmp35_ = tp_channel_get_identifier (_tmp34_);
		_tmp36_ = g_strdup (_tmp35_);
		name = _tmp36_;
		_tmp38_ = name;
		_tmp39_ = _tpf_persona_store_group_is_display_group (self, _tmp38_);
		if (_tmp39_) {
			GList* _tmp40_;
			guint _tmp41_ = 0U;
			_tmp40_ = members_removed;
			_tmp41_ = g_list_length (_tmp40_);
			_tmp37_ = _tmp41_ > ((guint) 0);
		} else {
			_tmp37_ = FALSE;
		}
		_tmp42_ = _tmp37_;
		if (_tmp42_) {
			const gchar* _tmp43_;
			GList* _tmp44_;
			members_removed = g_list_reverse (members_removed);
			_tmp43_ = name;
			_tmp44_ = members_removed;
			g_signal_emit_by_name (self, "group-members-changed", _tmp43_, NULL, _tmp44_);
		}
		_g_free0 (name);
		_g_object_unref0 (members);
		__g_list_free__g_object_unref0_0 (members_removed);
	}
}


static void __tpf_persona_store_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed (TpChannel* _sender, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details, gpointer self) {
	_tpf_persona_store_channel_group_members_changed_detailed_cb (self, _sender, added, removed, local_pending, remote_pending, details);
}


static void __lambda14_ (TpfPersonaStore* self, GObject* s, GParamSpec* p) {
	GObject* _tmp0_;
	TpChannel* _tmp1_;
	TpChannel* c;
	TpChannel* _tmp2_;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* name;
	GeeHashMap* _tmp5_;
	const gchar* _tmp6_;
	gpointer _tmp7_ = NULL;
	TpChannel* existing_channel;
	TpChannel* _tmp8_;
	GeeHashMap* _tmp13_;
	const gchar* _tmp14_;
	TpChannel* _tmp15_;
	GeeHashMap* _tmp16_;
	const gchar* _tmp17_;
	TpChannel* _tmp18_;
	TpChannel* _tmp19_;
	TpChannel* _tmp20_;
	TpIntset* _tmp21_ = NULL;
	TpIntset* members;
	TpIntset* _tmp22_;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = s;
	_tmp1_ = _g_object_ref0 (TP_CHANNEL (_tmp0_));
	c = _tmp1_;
	_tmp2_ = c;
	_tmp3_ = tp_channel_get_identifier (_tmp2_);
	_tmp4_ = g_strdup (_tmp3_);
	name = _tmp4_;
	_tmp5_ = self->priv->_groups;
	_tmp6_ = name;
	_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, _tmp6_);
	existing_channel = (TpChannel*) _tmp7_;
	_tmp8_ = existing_channel;
	if (_tmp8_ != NULL) {
		TpChannel* _tmp9_;
		GeeHashMap* _tmp10_;
		const gchar* _tmp11_;
		TpChannel* _tmp12_;
		_tmp9_ = existing_channel;
		g_object_ref ((GObject*) _tmp9_);
		_tmp10_ = self->priv->_groups;
		_tmp11_ = name;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp10_, _tmp11_, NULL);
		_tmp12_ = existing_channel;
		g_object_unref ((GObject*) _tmp12_);
	}
	_g_object_unref0 (existing_channel);
	existing_channel = NULL;
	_tmp13_ = self->priv->_groups;
	_tmp14_ = name;
	_tmp15_ = c;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, _tmp14_, _tmp15_);
	_tmp16_ = self->priv->_group_channels_unready;
	_tmp17_ = name;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp16_, _tmp17_, NULL);
	_tmp18_ = c;
	g_signal_connect_object ((TpProxy*) _tmp18_, "invalidated", (GCallback) __tpf_persona_store_channel_invalidated_cb_tp_proxy_invalidated, self, 0);
	_tmp19_ = c;
	g_signal_connect_object (_tmp19_, "group-members-changed-detailed", (GCallback) __tpf_persona_store_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed, self, 0);
	_tmp20_ = c;
	_tmp21_ = tp_channel_group_get_members (_tmp20_);
	members = _tmp21_;
	_tmp22_ = members;
	if (_tmp22_ != NULL) {
		TpChannel* _tmp23_;
		TpIntset* _tmp24_;
		GArray* _tmp25_ = NULL;
		GArray* _tmp26_;
		_tmp23_ = c;
		_tmp24_ = members;
		_tmp25_ = tp_intset_to_array (_tmp24_);
		_tmp26_ = _tmp25_;
		_tpf_persona_store_channel_group_pend_incoming_adds (self, _tmp23_, _tmp26_, FALSE, NULL, NULL);
		_g_array_unref0 (_tmp26_);
	}
	_g_object_unref0 (existing_channel);
	_g_free0 (name);
	_g_object_unref0 (c);
}


static void ___lambda14__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda14_ (self, _sender, pspec);
}


static void _tpf_persona_store_set_up_new_group_channel (TpfPersonaStore* self, TpChannel* channel) {
	GeeHashMap* _tmp0_;
	TpChannel* _tmp1_;
	const gchar* _tmp2_ = NULL;
	TpChannel* _tmp3_;
	TpChannel* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = self->priv->_group_channels_unready;
	_tmp1_ = channel;
	_tmp2_ = tp_channel_get_identifier (_tmp1_);
	_tmp3_ = channel;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, _tmp2_, _tmp3_);
	_tmp4_ = channel;
	g_signal_connect_object ((GObject*) _tmp4_, "notify::channel-ready", (GCallback) ___lambda14__g_object_notify, self, 0);
}


static void _tpf_persona_store_disconnect_from_group_channel (TpfPersonaStore* self, TpChannel* channel) {
	TpChannel* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* name;
	TpChannel* _tmp3_;
	guint _tmp4_ = 0U;
	TpChannel* _tmp5_;
	guint _tmp6_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = channel;
	_tmp1_ = tp_channel_get_identifier (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	name = _tmp2_;
	g_debug ("tpf-persona-store.vala:1844: Disconnecting from group channel '%s'.", name);
	_tmp3_ = channel;
	g_signal_parse_name ("group-members-changed-detailed", tp_channel_get_type (), &_tmp4_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) __tpf_persona_store_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed, self);
	_tmp5_ = channel;
	g_signal_parse_name ("invalidated", tp_proxy_get_type (), &_tmp6_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((TpProxy*) _tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) __tpf_persona_store_channel_invalidated_cb_tp_proxy_invalidated, self);
	_g_free0 (name);
}


static void _tpf_persona_store_channel_group_members_changed_detailed_cb (TpfPersonaStore* self, TpChannel* channel, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details) {
	GArray* _tmp0_;
	GArray* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	g_return_if_fail (local_pending != NULL);
	g_return_if_fail (remote_pending != NULL);
	g_return_if_fail (details != NULL);
	_tmp0_ = added;
	if (_tmp0_ != NULL) {
		TpChannel* _tmp1_;
		GArray* _tmp2_;
		_tmp1_ = channel;
		_tmp2_ = added;
		_tpf_persona_store_channel_group_pend_incoming_adds (self, _tmp1_, _tmp2_, FALSE, NULL, NULL);
	}
	_tmp3_ = removed;
	if (_tmp3_ != NULL) {
		TpChannel* _tmp4_;
		GArray* _tmp5_;
		_tmp4_ = channel;
		_tmp5_ = removed;
		_tpf_persona_store_channel_group_handle_incoming_removes (self, _tmp4_, _tmp5_);
	}
}


static void _tpf_persona_store_change_group_membership_data_free (gpointer _data) {
	TpfPersonaStoreChangeGroupMembershipData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_free0 (_data_->group);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreChangeGroupMembershipData, _data_);
}


void _tpf_persona_store_change_group_membership (TpfPersonaStore* self, FolksPersona* persona, const gchar* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreChangeGroupMembershipData* _data_;
	TpfPersonaStore* _tmp0_;
	FolksPersona* _tmp1_;
	FolksPersona* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	_data_ = g_slice_new0 (TpfPersonaStoreChangeGroupMembershipData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_change_group_membership);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_change_group_membership_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->persona = _tmp2_;
	_tmp3_ = group;
	_tmp4_ = g_strdup (_tmp3_);
	_data_->group = _tmp4_;
	_tmp5_ = is_member;
	_data_->is_member = _tmp5_;
	_tpf_persona_store_change_group_membership_co (_data_);
}


void _tpf_persona_store_change_group_membership_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpfPersonaStoreChangeGroupMembershipData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean _tpf_persona_store_change_group_membership_co (TpfPersonaStoreChangeGroupMembershipData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->persona;
	_data_->_tmp1_ = _g_object_ref0 (TPF_PERSONA (_data_->_tmp0_));
	_data_->tp_persona = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->self->priv->_groups;
	_data_->_tmp3_ = _data_->group;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp2_, _data_->_tmp3_);
	_data_->channel = (TpChannel*) _data_->_tmp4_;
	_data_->_tmp6_ = _data_->is_member;
	if (_data_->_tmp6_) {
		_data_->_tmp7_ = _data_->self->priv->_group_outgoing_adds;
		_data_->_tmp5_ = _data_->_tmp7_;
	} else {
		_data_->_tmp8_ = _data_->self->priv->_group_outgoing_removes;
		_data_->_tmp5_ = _data_->_tmp8_;
	}
	_data_->_tmp9_ = _data_->_tmp5_;
	_data_->_tmp10_ = _g_object_ref0 (_data_->_tmp9_);
	_data_->change_map = _data_->_tmp10_;
	_data_->_tmp11_ = _data_->change_map;
	_data_->_tmp12_ = _data_->group;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp11_, _data_->_tmp12_);
	_data_->change_set = (GeeHashSet*) _data_->_tmp13_;
	_data_->_tmp14_ = _data_->change_set;
	if (_data_->_tmp14_ == NULL) {
		_data_->_tmp15_ = gee_hash_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
		_g_object_unref0 (_data_->change_set);
		_data_->change_set = _data_->_tmp15_;
		_data_->_tmp16_ = _data_->change_map;
		_data_->_tmp17_ = _data_->group;
		_data_->_tmp18_ = _data_->change_set;
		gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp16_, _data_->_tmp17_, _data_->_tmp18_);
	}
	_data_->_tmp19_ = _data_->change_set;
	_data_->_tmp20_ = _data_->tp_persona;
	gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp19_, _data_->_tmp20_);
	_data_->_tmp21_ = _data_->channel;
	if (_data_->_tmp21_ == NULL) {
		_data_->_tmp22_ = tpf_persona_store_get_account (_data_->self);
		_data_->_tmp23_ = _data_->_tmp22_;
		_data_->_tmp24_ = tp_account_get_connection (_data_->_tmp23_);
		_data_->_tmp25_ = _data_->_tmp24_;
		_data_->_tmp26_ = _data_->group;
		folks_tp_lowlevel_connection_create_group_async (_data_->_tmp25_, _data_->_tmp26_);
	} else {
		_data_->_tmp27_ = _data_->channel;
		_tpf_persona_store_channel_group_changes_resolve (_data_->self, _data_->_tmp27_);
	}
	_g_object_unref0 (_data_->change_set);
	_g_object_unref0 (_data_->change_map);
	_g_object_unref0 (_data_->channel);
	_g_object_unref0 (_data_->tp_persona);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _tpf_persona_store_change_standard_contact_list_membership (TpfPersonaStore* self, TpChannel* channel, FolksPersona* persona, gboolean is_member, const gchar* message) {
	FolksPersona* _tmp0_;
	TpfPersona* _tmp1_;
	TpfPersona* tp_persona;
	TpfPersona* _tmp2_;
	TpContact* _tmp3_;
	TpContact* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	g_return_if_fail (persona != NULL);
	_tmp0_ = persona;
	_tmp1_ = _g_object_ref0 (TPF_PERSONA (_tmp0_));
	tp_persona = _tmp1_;
	_tmp2_ = tp_persona;
	_tmp3_ = tpf_persona_get_contact (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		TpfPersona* _tmp5_;
		_tmp5_ = tp_persona;
		g_warning ("Skipping Tpf.Persona %p contact list change because it " "has no attached TpContact", _tmp5_);
		_g_object_unref0 (tp_persona);
		return;
	}
	{
		TpChannel* _tmp6_;
		TpfPersona* _tmp7_;
		TpContact* _tmp8_;
		TpContact* _tmp9_;
		guint _tmp10_;
		guint _tmp11_;
		gboolean _tmp12_;
		const gchar* _tmp13_;
		_tmp6_ = channel;
		_tmp7_ = tp_persona;
		_tmp8_ = tpf_persona_get_contact (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = tp_contact_get_handle (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = is_member;
		_tmp13_ = message;
		folks_tp_lowlevel_channel_group_change_membership (_tmp6_, (guint) ((TpHandle) _tmp11_), _tmp12_, _tmp13_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch17_g_error;
		}
	}
	goto __finally17;
	__catch17_g_error:
	{
		GError* e = NULL;
		gboolean _tmp14_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = is_member;
		if (_tmp14_ == TRUE) {
			const gchar* _tmp15_ = NULL;
			TpfPersona* _tmp16_;
			TpContact* _tmp17_;
			TpContact* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			TpChannel* _tmp21_;
			const gchar* _tmp22_ = NULL;
			GError* _tmp23_;
			const gchar* _tmp24_;
			_tmp15_ = _ ("Failed to add Telepathy contact ‘%s’ to ‘%s’ list: %s");
			_tmp16_ = tp_persona;
			_tmp17_ = tpf_persona_get_contact (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = tp_contact_get_identifier (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = channel;
			_tmp22_ = tp_channel_get_identifier (_tmp21_);
			_tmp23_ = e;
			_tmp24_ = _tmp23_->message;
			g_warning (_tmp15_, _tmp20_, _tmp22_, _tmp24_);
		} else {
			const gchar* _tmp25_ = NULL;
			TpfPersona* _tmp26_;
			TpContact* _tmp27_;
			TpContact* _tmp28_;
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			TpChannel* _tmp31_;
			const gchar* _tmp32_ = NULL;
			GError* _tmp33_;
			const gchar* _tmp34_;
			_tmp25_ = _ ("Failed to remove Telepathy contact ‘%s’ from ‘%s’ list: %s");
			_tmp26_ = tp_persona;
			_tmp27_ = tpf_persona_get_contact (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = tp_contact_get_identifier (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = channel;
			_tmp32_ = tp_channel_get_identifier (_tmp31_);
			_tmp33_ = e;
			_tmp34_ = _tmp33_->message;
			g_warning (_tmp25_, _tmp30_, _tmp32_, _tmp34_);
		}
		_g_error_free0 (e);
	}
	__finally17:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (tp_persona);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (tp_persona);
}


static void _tpf_persona_store_add_standard_channel_data_free (gpointer _data) {
	TpfPersonaStoreAddStandardChannelData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->conn);
	_g_free0 (_data_->name);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreAddStandardChannelData, _data_);
}


static void _tpf_persona_store_add_standard_channel (TpfPersonaStore* self, TpConnection* conn, const gchar* name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreAddStandardChannelData* _data_;
	TpfPersonaStore* _tmp0_;
	TpConnection* _tmp1_;
	TpConnection* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	_data_ = g_slice_new0 (TpfPersonaStoreAddStandardChannelData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_add_standard_channel);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_add_standard_channel_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = conn;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->conn = _tmp2_;
	_tmp3_ = name;
	_tmp4_ = g_strdup (_tmp3_);
	_data_->name = _tmp4_;
	_tpf_persona_store_add_standard_channel_co (_data_);
}


static TpChannel* _tpf_persona_store_add_standard_channel_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpChannel* result;
	TpfPersonaStoreAddStandardChannelData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void _tpf_persona_store_add_standard_channel_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreAddStandardChannelData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_store_add_standard_channel_co (_data_);
}


static gboolean _tpf_persona_store_add_standard_channel_co (TpfPersonaStoreAddStandardChannelData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->channel = NULL;
	_data_->_tmp0_ = _data_->name;
	_data_->_tmp1_ = _data_->conn;
	_data_->_tmp2_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp3_ = _data_->_tmp2_;
	g_debug ("Adding standard channel '%s' to connection %p for " "Tpf.PersonaStore %p ('%s').", _data_->_tmp0_, _data_->_tmp1_, _data_->self, _data_->_tmp3_);
	{
		_data_->_tmp4_ = _data_->conn;
		_data_->_tmp5_ = _data_->name;
		_data_->_state_ = 1;
		folks_tp_lowlevel_connection_open_contact_list_channel_async (_data_->_tmp4_, _data_->_tmp5_, _tpf_persona_store_add_standard_channel_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = folks_tp_lowlevel_connection_open_contact_list_channel_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp7_ = _data_->_tmp6_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch18_g_error;
		}
		_data_->_tmp8_ = _g_object_ref0 (_data_->_tmp7_);
		_g_object_unref0 (_data_->channel);
		_data_->channel = _data_->_tmp8_;
	}
	goto __finally18;
	__catch18_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp9_ = _data_->name;
		_data_->_tmp10_ = _data_->e;
		_data_->_tmp11_ = _data_->_tmp10_->message;
		g_debug ("tpf-persona-store.vala:1959: Failed to add channel '%s': %s", _data_->_tmp9_, _data_->_tmp11_);
		_data_->self->priv->_got_stored_channel_members = TRUE;
		_tpf_persona_store_notify_if_is_quiescent (_data_->self);
		_data_->result = NULL;
		_g_error_free0 (_data_->e);
		_g_object_unref0 (_data_->channel);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally18:
	if (_data_->_inner_error_ != NULL) {
		_g_object_unref0 (_data_->channel);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp12_ = _data_->channel;
	_tpf_persona_store_set_up_new_standard_channel (_data_->self, _data_->_tmp12_);
	_data_->result = _data_->channel;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->channel);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _tpf_persona_store_create_personas_from_channel_handles_async_data_free (gpointer _data) {
	TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->channel);
	_g_array_unref0 (_data_->channel_handles);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData, _data_);
}


static void _tpf_persona_store_create_personas_from_channel_handles_async (TpfPersonaStore* self, TpChannel* channel, GArray* channel_handles, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData* _data_;
	TpfPersonaStore* _tmp0_;
	TpChannel* _tmp1_;
	TpChannel* _tmp2_;
	GArray* _tmp3_;
	GArray* _tmp4_;
	_data_ = g_slice_new0 (TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_create_personas_from_channel_handles_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_create_personas_from_channel_handles_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = channel;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->channel = _tmp2_;
	_tmp3_ = channel_handles;
	_tmp4_ = _g_array_ref0 (_tmp3_);
	_data_->channel_handles = _tmp4_;
	_tpf_persona_store_create_personas_from_channel_handles_async_co (_data_);
}


static void _tpf_persona_store_create_personas_from_channel_handles_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _vala_array_add6 (guint** array, int* length, int* size, guint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _tpf_persona_store_create_personas_from_channel_handles_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_store_create_personas_from_channel_handles_async_co (_data_);
}


static gboolean _tpf_persona_store_create_personas_from_channel_handles_async_co (TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = g_new0 (guint, 0);
	_data_->contact_handles = _data_->_tmp0_;
	_data_->contact_handles_length1 = 0;
	_data_->_contact_handles_size_ = _data_->contact_handles_length1;
	{
		_data_->i = 0;
		{
			_data_->_tmp1_ = TRUE;
			while (TRUE) {
				_data_->_tmp2_ = _data_->_tmp1_;
				if (!_data_->_tmp2_) {
					_data_->_tmp3_ = _data_->i;
					_data_->i = _data_->_tmp3_ + 1;
				}
				_data_->_tmp1_ = FALSE;
				_data_->_tmp4_ = _data_->i;
				_data_->_tmp5_ = _data_->channel_handles;
				_data_->_tmp6_ = _data_->_tmp5_->len;
				if (!(((guint) _data_->_tmp4_) < _data_->_tmp6_)) {
					break;
				}
				_data_->_tmp7_ = _data_->channel_handles;
				_data_->_tmp8_ = _data_->i;
				_data_->_tmp9_ = 0U;
				_data_->_tmp9_ = g_array_index (_data_->_tmp7_, guint, (guint) _data_->_tmp8_);
				_data_->channel_handle = (TpHandle) _data_->_tmp9_;
				_data_->_tmp10_ = _data_->channel;
				_data_->_tmp11_ = _data_->channel_handle;
				_data_->_tmp12_ = 0U;
				_data_->_tmp12_ = tp_channel_group_get_handle_owner (_data_->_tmp10_, _data_->_tmp11_);
				_data_->contact_handle = _data_->_tmp12_;
				_data_->_tmp13_ = _data_->self->priv->_handle_persona_map;
				_data_->_tmp14_ = _data_->contact_handle;
				_data_->_tmp15_ = NULL;
				_data_->_tmp15_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp13_, GUINT_TO_POINTER ((guint) _data_->_tmp14_));
				_data_->persona = (TpfPersona*) _data_->_tmp15_;
				_data_->_tmp16_ = _data_->persona;
				if (_data_->_tmp16_ == NULL) {
					_data_->_tmp17_ = _data_->contact_handles;
					_data_->_tmp17__length1 = _data_->contact_handles_length1;
					_data_->_tmp18_ = _data_->contact_handle;
					_vala_array_add6 (&_data_->contact_handles, &_data_->contact_handles_length1, &_data_->_contact_handles_size_, (guint) _data_->_tmp18_);
				} else {
					_data_->_tmp19_ = _data_->persona;
					_data_->_tmp20_ = folks_persona_get_uid ((FolksPersona*) _data_->_tmp19_);
					_data_->_tmp21_ = _data_->_tmp20_;
					g_debug ("tpf-persona-store.vala:2005: Setting is-in-contact-list for '%s' to tr" \
"ue", _data_->_tmp21_);
					_data_->_tmp22_ = _data_->persona;
					tpf_persona_set_is_in_contact_list (_data_->_tmp22_, TRUE);
				}
				_g_object_unref0 (_data_->persona);
			}
		}
	}
	{
		_data_->_tmp23_ = _data_->contact_handles;
		_data_->_tmp23__length1 = _data_->contact_handles_length1;
		if (_data_->_tmp23__length1 < 1) {
			_data_->contact_handles = (g_free (_data_->contact_handles), NULL);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp24_ = _data_->self->priv->_conn;
		_data_->_tmp25_ = _data_->contact_handles;
		_data_->_tmp25__length1 = _data_->contact_handles_length1;
		_data_->_tmp26_ = tpf_persona_store__contact_features;
		_data_->_tmp26__length1 = tpf_persona_store__contact_features_length1;
		_data_->_state_ = 1;
		folks_tp_lowlevel_connection_get_contacts_by_handle_async (_data_->_tmp24_, _data_->_tmp25_, (guint) _data_->_tmp25__length1, (guint*) _data_->_tmp26_, (guint) _data_->_tmp26__length1, _tpf_persona_store_create_personas_from_channel_handles_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp27_ = NULL;
		_data_->_tmp27_ = folks_tp_lowlevel_connection_get_contacts_by_handle_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->contacts = _data_->_tmp27_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch19_g_error;
		}
		_data_->_tmp29_ = _data_->contacts;
		if (_data_->_tmp29_ == NULL) {
			_data_->_tmp28_ = TRUE;
		} else {
			_data_->_tmp30_ = _data_->contacts;
			_data_->_tmp31_ = 0U;
			_data_->_tmp31_ = g_list_length (_data_->_tmp30_);
			_data_->_tmp28_ = _data_->_tmp31_ < ((guint) 1);
		}
		_data_->_tmp32_ = _data_->_tmp28_;
		if (_data_->_tmp32_) {
			__g_list_free__g_object_unref0_0 (_data_->contacts);
			_data_->contact_handles = (g_free (_data_->contact_handles), NULL);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp33_ = _data_->contacts;
		_data_->_tmp34_ = 0U;
		_data_->_tmp34_ = g_list_length (_data_->_tmp33_);
		_data_->_tmp35_ = NULL;
		_data_->_tmp35_ = g_new0 (TpContact*, _data_->_tmp34_ + 1);
		_data_->contacts_array = _data_->_tmp35_;
		_data_->contacts_array_length1 = _data_->_tmp34_;
		_data_->_contacts_array_size_ = _data_->contacts_array_length1;
		_data_->j = 0;
		_data_->_tmp36_ = _data_->contacts;
		_data_->l = _data_->_tmp36_;
		{
			_data_->_tmp37_ = TRUE;
			while (TRUE) {
				_data_->_tmp38_ = _data_->_tmp37_;
				if (!_data_->_tmp38_) {
					_data_->_tmp39_ = _data_->l;
					_data_->_tmp40_ = _data_->_tmp39_->next;
					_data_->l = _data_->_tmp40_;
				}
				_data_->_tmp37_ = FALSE;
				_data_->_tmp41_ = _data_->l;
				if (!(_data_->_tmp41_ != NULL)) {
					break;
				}
				_data_->_tmp42_ = _data_->contacts_array;
				_data_->_tmp42__length1 = _data_->contacts_array_length1;
				_data_->_tmp43_ = _data_->j;
				_data_->_tmp44_ = _data_->l;
				_data_->_tmp45_ = _data_->_tmp44_->data;
				_data_->_tmp46_ = _g_object_ref0 ((TpContact*) _data_->_tmp45_);
				_g_object_unref0 (_data_->_tmp42_[_data_->_tmp43_]);
				_data_->_tmp42_[_data_->_tmp43_] = _data_->_tmp46_;
				_data_->_tmp47_ = _data_->_tmp42_[_data_->_tmp43_];
				_data_->_tmp48_ = _data_->j;
				_data_->j = _data_->_tmp48_ + 1;
			}
		}
		_data_->_tmp49_ = _data_->contacts_array;
		_data_->_tmp49__length1 = _data_->contacts_array_length1;
		_tpf_persona_store_add_new_personas_from_contacts (_data_->self, _data_->_tmp49_, _data_->_tmp49__length1);
		_data_->contacts_array = (_vala_array_free (_data_->contacts_array, _data_->contacts_array_length1, (GDestroyNotify) g_object_unref), NULL);
		__g_list_free__g_object_unref0_0 (_data_->contacts);
	}
	goto __finally19;
	__catch19_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp50_ = NULL;
		_data_->_tmp50_ = _ ("Failed to create incoming Telepathy contacts from channel ‘%s’: %s");
		_data_->_tmp51_ = _data_->channel;
		_data_->_tmp52_ = NULL;
		_data_->_tmp52_ = tp_channel_get_identifier (_data_->_tmp51_);
		_data_->_tmp53_ = _data_->e;
		_data_->_tmp54_ = _data_->_tmp53_->message;
		g_warning (_data_->_tmp50_, _data_->_tmp52_, _data_->_tmp54_);
		_g_error_free0 (_data_->e);
	}
	__finally19:
	if (_data_->_inner_error_ != NULL) {
		_data_->contact_handles = (g_free (_data_->contact_handles), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->contact_handles = (g_free (_data_->contact_handles), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _tpf_persona_store_ensure_personas_from_contact_ids_data_free (gpointer _data) {
	TpfPersonaStoreEnsurePersonasFromContactIdsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreEnsurePersonasFromContactIdsData, _data_);
}


static void _tpf_persona_store_ensure_personas_from_contact_ids (TpfPersonaStore* self, gchar** contact_ids, int contact_ids_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreEnsurePersonasFromContactIdsData* _data_;
	TpfPersonaStore* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	_data_ = g_slice_new0 (TpfPersonaStoreEnsurePersonasFromContactIdsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_ensure_personas_from_contact_ids);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_ensure_personas_from_contact_ids_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = contact_ids;
	_tmp1__length1 = contact_ids_length1;
	_data_->contact_ids = _tmp1_;
	_data_->contact_ids_length1 = _tmp1__length1;
	_tpf_persona_store_ensure_personas_from_contact_ids_co (_data_);
}


static GeeHashSet* _tpf_persona_store_ensure_personas_from_contact_ids_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error) {
	GeeHashSet* result;
	TpfPersonaStoreEnsurePersonasFromContactIdsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void _tpf_persona_store_ensure_personas_from_contact_ids_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreEnsurePersonasFromContactIdsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_store_ensure_personas_from_contact_ids_co (_data_);
}


static gboolean _tpf_persona_store_ensure_personas_from_contact_ids_co (TpfPersonaStoreEnsurePersonasFromContactIdsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gee_hash_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	_data_->personas = _data_->_tmp0_;
	_data_->_tmp1_ = gee_hash_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	_data_->personas_added = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->contact_ids;
	_data_->_tmp2__length1 = _data_->contact_ids_length1;
	if (_data_->_tmp2__length1 == 0) {
		_data_->result = _data_->personas;
		_g_object_unref0 (_data_->personas_added);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->self->priv->_conn;
	_data_->_tmp4_ = _data_->contact_ids;
	_data_->_tmp4__length1 = _data_->contact_ids_length1;
	_data_->_tmp5_ = tpf_persona_store__contact_features;
	_data_->_tmp5__length1 = tpf_persona_store__contact_features_length1;
	_data_->_state_ = 1;
	folks_tp_lowlevel_connection_get_contacts_by_id_async (_data_->_tmp3_, _data_->_tmp4_, (guint) _data_->_tmp4__length1, (guint*) _data_->_tmp5_, (guint) _data_->_tmp5__length1, _tpf_persona_store_ensure_personas_from_contact_ids_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = folks_tp_lowlevel_connection_get_contacts_by_id_finish (_data_->_res_, &_data_->_inner_error_);
	_data_->contacts = _data_->_tmp6_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->personas_added);
		_g_object_unref0 (_data_->personas);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp7_ = _data_->contacts;
		_data_->l = _data_->_tmp7_;
		_data_->_tmp8_ = TRUE;
		while (TRUE) {
			_data_->_tmp9_ = _data_->_tmp8_;
			if (!_data_->_tmp9_) {
				_data_->_tmp10_ = _data_->l;
				_data_->_tmp11_ = _data_->_tmp10_->next;
				_data_->l = _data_->_tmp11_;
			}
			_data_->_tmp8_ = FALSE;
			_data_->_tmp12_ = _data_->l;
			if (!(_data_->_tmp12_ != NULL)) {
				break;
			}
			_data_->_tmp13_ = _data_->l;
			_data_->_tmp14_ = _data_->_tmp13_->data;
			_data_->_tmp15_ = _g_object_ref0 ((TpContact*) _data_->_tmp14_);
			_data_->contact = _data_->_tmp15_;
			_data_->_tmp16_ = _data_->contact;
			_data_->_tmp17_ = tp_contact_get_identifier (_data_->_tmp16_);
			_data_->_tmp18_ = _data_->_tmp17_;
			g_debug ("tpf-persona-store.vala:2062: Creating persona from contact '%s'", _data_->_tmp18_);
			_data_->_tmp19_ = _data_->contact;
			_data_->_tmp20_ = FALSE;
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = _tpf_persona_store_add_persona_from_contact (_data_->self, _data_->_tmp19_, TRUE, &_data_->_tmp20_);
			_data_->added = _data_->_tmp20_;
			_data_->persona = _data_->_tmp21_;
			_data_->_tmp22_ = _data_->added;
			if (_data_->_tmp22_) {
				_data_->_tmp23_ = _data_->personas_added;
				_data_->_tmp24_ = _data_->persona;
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp23_, _data_->_tmp24_);
			}
			_data_->_tmp25_ = _data_->personas;
			_data_->_tmp26_ = _data_->persona;
			gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp25_, _data_->_tmp26_);
			_g_object_unref0 (_data_->persona);
			_g_object_unref0 (_data_->contact);
		}
	}
	_data_->_tmp27_ = _data_->personas_added;
	_data_->_tmp28_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp27_);
	_data_->_tmp29_ = _data_->_tmp28_;
	if (_data_->_tmp29_ > 0) {
		_data_->_tmp30_ = _data_->personas_added;
		_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) _data_->self, (GeeSet*) _data_->_tmp30_, NULL, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	}
	_data_->result = _data_->personas;
	__g_list_free__g_object_unref0_0 (_data_->contacts);
	_g_object_unref0 (_data_->personas_added);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	__g_list_free__g_object_unref0_0 (_data_->contacts);
	_g_object_unref0 (_data_->personas_added);
	_g_object_unref0 (_data_->personas);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _tpf_persona_store_contact_weak_notify_cb (TpfPersonaStore* self, GObject* obj) {
	GObject* _tmp0_;
	TpContact* _tmp1_;
	TpContact* c;
	GeeHashMap* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	_tmp0_ = obj;
	_tmp1_ = _g_object_ref0 (TP_IS_CONTACT (_tmp0_) ? ((TpContact*) _tmp0_) : NULL);
	c = _tmp1_;
	_tmp2_ = self->priv->_weakly_referenced_contacts;
	if (_tmp2_ != NULL) {
		GeeHashMap* _tmp3_;
		TpContact* _tmp4_;
		gpointer _tmp5_ = NULL;
		TpHandle handle;
		GeeHashMap* _tmp6_;
		TpContact* _tmp7_;
		TpHandle _tmp8_;
		_tmp3_ = self->priv->_weakly_referenced_contacts;
		_tmp4_ = c;
		_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, _tmp4_);
		handle = (TpHandle) GPOINTER_TO_UINT (_tmp5_);
		_tmp6_ = self->priv->_weakly_referenced_contacts;
		_tmp7_ = c;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp6_, _tmp7_, NULL);
		_tmp8_ = handle;
		if (_tmp8_ != ((TpHandle) 0)) {
			TpHandle _tmp9_;
			_tmp9_ = handle;
			_tpf_persona_store_ignore_by_handle (self, (guint) ((TpHandle) _tmp9_), NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
		}
	}
	_g_object_unref0 (c);
}


TpfPersona* _tpf_persona_store_ensure_persona_from_contact (TpfPersonaStore* self, TpContact* contact) {
	TpfPersona* result = NULL;
	TpContact* _tmp0_;
	TpHandle _tmp1_ = 0U;
	guint handle;
	TpContact* _tmp2_;
	guint _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	guint _tmp6_;
	GeeHashMap* _tmp7_;
	guint _tmp8_;
	gpointer _tmp9_ = NULL;
	TpfPersona* persona;
	TpfPersona* _tmp10_;
	gboolean added = FALSE;
	TpContact* _tmp11_;
	gboolean _tmp12_ = FALSE;
	TpfPersona* _tmp13_ = NULL;
	gboolean _tmp14_;
	TpContact* _tmp15_;
	GeeHashMap* _tmp16_;
	TpContact* _tmp17_;
	guint _tmp18_;
	GeeHashSet* _tmp19_;
	GeeHashSet* personas;
	GeeHashSet* _tmp20_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (contact != NULL, NULL);
	_tmp0_ = contact;
	_tmp1_ = tp_contact_get_handle (_tmp0_);
	handle = (guint) _tmp1_;
	_tmp2_ = contact;
	_tmp3_ = handle;
	_tmp4_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp5_ = _tmp4_;
	g_debug ("Ensuring contact %p (handle: %u) exists in Tpf.PersonaStore " "%p ('%s').", _tmp2_, _tmp3_, self, _tmp5_);
	_tmp6_ = handle;
	if (_tmp6_ == ((guint) 0)) {
		result = NULL;
		return result;
	}
	_tmp7_ = self->priv->_handle_persona_map;
	_tmp8_ = handle;
	_tmp9_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp7_, GUINT_TO_POINTER (_tmp8_));
	persona = (TpfPersona*) _tmp9_;
	_tmp10_ = persona;
	if (_tmp10_ != NULL) {
		result = persona;
		return result;
	}
	_tmp11_ = contact;
	_tmp13_ = _tpf_persona_store_add_persona_from_contact (self, _tmp11_, FALSE, &_tmp12_);
	added = _tmp12_;
	_g_object_unref0 (persona);
	persona = _tmp13_;
	_tmp14_ = added;
	if (!_tmp14_) {
		result = NULL;
		_g_object_unref0 (persona);
		return result;
	}
	_tmp15_ = contact;
	g_object_weak_ref ((GObject*) _tmp15_, __tpf_persona_store_contact_weak_notify_cb_gweak_notify, self);
	_tmp16_ = self->priv->_weakly_referenced_contacts;
	_tmp17_ = contact;
	_tmp18_ = handle;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp16_, _tmp17_, GUINT_TO_POINTER (_tmp18_));
	_tmp19_ = gee_hash_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	personas = _tmp19_;
	_tmp20_ = personas;
	_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, (GeeSet*) _tmp20_, NULL, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	result = persona;
	_g_object_unref0 (personas);
	return result;
}


static TpfPersona* _tpf_persona_store_add_persona_from_contact (TpfPersonaStore* self, TpContact* contact, gboolean from_contact_list, gboolean* added) {
	gboolean _vala_added = FALSE;
	TpfPersona* result = NULL;
	TpContact* _tmp0_;
	TpHandle _tmp1_ = 0U;
	TpHandle h;
	TpfPersona* persona;
	TpContact* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GeeHashMap* _tmp5_;
	TpHandle _tmp6_;
	gpointer _tmp7_ = NULL;
	TpfPersona* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (contact != NULL, NULL);
	_tmp0_ = contact;
	_tmp1_ = tp_contact_get_handle (_tmp0_);
	h = _tmp1_;
	persona = NULL;
	_tmp2_ = contact;
	_tmp3_ = tp_contact_get_identifier (_tmp2_);
	_tmp4_ = _tmp3_;
	g_debug ("tpf-persona-store.vala:2147: Adding persona from contact '%s'", _tmp4_);
	_tmp5_ = self->priv->_handle_persona_map;
	_tmp6_ = h;
	_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, GUINT_TO_POINTER ((guint) _tmp6_));
	_g_object_unref0 (persona);
	persona = (TpfPersona*) _tmp7_;
	_tmp8_ = persona;
	if (_tmp8_ == NULL) {
		TpContact* _tmp9_;
		TpfPersona* _tmp10_;
		GeeHashMap* _tmp11_;
		TpfPersona* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		TpfPersona* _tmp15_;
		GeeHashSet* _tmp16_;
		TpfPersona* _tmp17_;
		GeeHashMap* _tmp18_;
		TpHandle _tmp19_;
		TpfPersona* _tmp20_;
		TpfPersona* _tmp21_;
		GeeHashSet* _tmp22_;
		TpHandle _tmp23_;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_;
		TpfPersona* _tmp26_;
		gboolean _tmp27_;
		_tmp9_ = contact;
		_tmp10_ = tpf_persona_new (_tmp9_, self);
		_g_object_unref0 (persona);
		persona = _tmp10_;
		_tmp11_ = self->priv->_personas;
		_tmp12_ = persona;
		_tmp13_ = folks_persona_get_iid ((FolksPersona*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = persona;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp11_, _tmp14_, _tmp15_);
		_tmp16_ = self->priv->_persona_set;
		_tmp17_ = persona;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp17_);
		_tmp18_ = self->priv->_handle_persona_map;
		_tmp19_ = h;
		_tmp20_ = persona;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp18_, GUINT_TO_POINTER ((guint) _tmp19_), _tmp20_);
		_tmp21_ = persona;
		_tmp22_ = self->priv->_favourite_handles;
		_tmp23_ = h;
		_tmp24_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp22_, GUINT_TO_POINTER ((guint) _tmp23_));
		folks_favourite_details_set_is_favourite ((FolksFavouriteDetails*) _tmp21_, _tmp24_);
		_tmp25_ = from_contact_list;
		if (_tmp25_ == FALSE) {
			g_debug ("tpf-persona-store.vala:2168:     Setting is-in-contact-list to false");
		}
		_tmp26_ = persona;
		_tmp27_ = from_contact_list;
		tpf_persona_set_is_in_contact_list (_tmp26_, _tmp27_);
		_vala_added = TRUE;
	} else {
		gboolean _tmp28_ = FALSE;
		TpfPersona* _tmp29_;
		gboolean _tmp30_;
		gboolean _tmp31_;
		gboolean _tmp33_;
		g_debug ("tpf-persona-store.vala:2177:     ...already exists.");
		_tmp29_ = persona;
		_tmp30_ = tpf_persona_get_is_in_contact_list (_tmp29_);
		_tmp31_ = _tmp30_;
		if (_tmp31_ == FALSE) {
			gboolean _tmp32_;
			_tmp32_ = from_contact_list;
			_tmp28_ = _tmp32_ == TRUE;
		} else {
			_tmp28_ = FALSE;
		}
		_tmp33_ = _tmp28_;
		if (_tmp33_) {
			TpfPersona* _tmp34_;
			g_debug ("tpf-persona-store.vala:2187:     Setting is-in-contact-list to true");
			_tmp34_ = persona;
			tpf_persona_set_is_in_contact_list (_tmp34_, TRUE);
		}
		_vala_added = FALSE;
	}
	result = persona;
	if (added) {
		*added = _vala_added;
	}
	return result;
}


static void _tpf_persona_store_add_new_personas_from_contacts (TpfPersonaStore* self, TpContact** contacts, int contacts_length1) {
	GeeHashSet* _tmp0_;
	GeeHashSet* personas;
	TpContact** _tmp1_;
	gint _tmp1__length1;
	GeeHashSet* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	personas = _tmp0_;
	_tmp1_ = contacts;
	_tmp1__length1 = contacts_length1;
	{
		TpContact** contact_collection = NULL;
		gint contact_collection_length1 = 0;
		gint _contact_collection_size_ = 0;
		gint contact_it = 0;
		contact_collection = _tmp1_;
		contact_collection_length1 = _tmp1__length1;
		for (contact_it = 0; contact_it < _tmp1__length1; contact_it = contact_it + 1) {
			TpContact* _tmp2_;
			TpContact* contact = NULL;
			_tmp2_ = _g_object_ref0 (contact_collection[contact_it]);
			contact = _tmp2_;
			{
				gboolean added = FALSE;
				TpContact* _tmp3_;
				gboolean _tmp4_ = FALSE;
				TpfPersona* _tmp5_ = NULL;
				TpfPersona* persona;
				gboolean _tmp6_;
				_tmp3_ = contact;
				_tmp5_ = _tpf_persona_store_add_persona_from_contact (self, _tmp3_, TRUE, &_tmp4_);
				added = _tmp4_;
				persona = _tmp5_;
				_tmp6_ = added;
				if (_tmp6_) {
					GeeHashSet* _tmp7_;
					TpfPersona* _tmp8_;
					_tmp7_ = personas;
					_tmp8_ = persona;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp8_);
				}
				_g_object_unref0 (persona);
				_g_object_unref0 (contact);
			}
		}
	}
	_tpf_persona_store_channel_groups_add_new_personas (self);
	_tmp9_ = personas;
	_tmp10_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ > 0) {
		GeeHashSet* _tmp12_;
		_tmp12_ = personas;
		_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, (GeeSet*) _tmp12_, NULL, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	}
	_g_object_unref0 (personas);
}


static void _tpf_persona_store_channel_groups_add_new_personas (TpfPersonaStore* self) {
	g_return_if_fail (self != NULL);
	{
		GeeHashMap* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_;
		GeeIterator* _entry_it;
		_tmp0_ = self->priv->_channel_group_incoming_adds;
		_tmp1_ = gee_abstract_map_get_entries ((GeeMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_entry_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeIterator* _tmp8_;
			gpointer _tmp9_ = NULL;
			GeeMapEntry* entry;
			GeeMapEntry* _tmp10_;
			gconstpointer _tmp11_;
			TpChannel* _tmp12_;
			TpChannel* _tmp13_;
			TpChannel* channel;
			GList* members_added;
			GeeHashMap* _tmp14_;
			TpChannel* _tmp15_;
			gpointer _tmp16_ = NULL;
			GeeHashSet* members;
			GeeHashSet* _tmp17_;
			TpChannel* _tmp19_;
			const gchar* _tmp20_ = NULL;
			GeeMapEntry* _tmp21_;
			gconstpointer _tmp22_;
			GeeHashSet* _tmp23_;
			GeeHashSet* _tmp24_;
			GeeHashSet* contact_handles;
			gboolean _tmp25_ = FALSE;
			GeeHashSet* _tmp26_;
			gboolean _tmp30_;
			GeeHashSet* _tmp59_;
			gint _tmp60_;
			gint _tmp61_;
			TpChannel* _tmp65_;
			const gchar* _tmp66_ = NULL;
			gchar* _tmp67_;
			gchar* name;
			gboolean _tmp68_ = FALSE;
			const gchar* _tmp69_;
			gboolean _tmp70_ = FALSE;
			gboolean _tmp73_;
			_tmp6_ = _entry_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _entry_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			entry = (GeeMapEntry*) _tmp9_;
			_tmp10_ = entry;
			_tmp11_ = gee_map_entry_get_key (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = _g_object_ref0 (TP_CHANNEL ((TpChannel*) _tmp12_));
			channel = _tmp13_;
			members_added = NULL;
			_tmp14_ = self->priv->_channel_group_personas_map;
			_tmp15_ = channel;
			_tmp16_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp14_, _tmp15_);
			members = (GeeHashSet*) _tmp16_;
			_tmp17_ = members;
			if (_tmp17_ == NULL) {
				GeeHashSet* _tmp18_;
				_tmp18_ = gee_hash_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
				_g_object_unref0 (members);
				members = _tmp18_;
			}
			_tmp19_ = channel;
			_tmp20_ = tp_channel_get_identifier (_tmp19_);
			g_debug ("tpf-persona-store.vala:2227: Adding members to channel '%s':", _tmp20_);
			_tmp21_ = entry;
			_tmp22_ = gee_map_entry_get_value (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = _g_object_ref0 ((GeeHashSet*) _tmp23_);
			contact_handles = _tmp24_;
			_tmp26_ = contact_handles;
			if (_tmp26_ != NULL) {
				GeeHashSet* _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				_tmp27_ = contact_handles;
				_tmp28_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp27_);
				_tmp29_ = _tmp28_;
				_tmp25_ = _tmp29_ > 0;
			} else {
				_tmp25_ = FALSE;
			}
			_tmp30_ = _tmp25_;
			if (_tmp30_) {
				GeeHashSet* _tmp31_;
				GeeHashSet* contact_handles_added;
				_tmp31_ = gee_hash_set_new (G_TYPE_UINT, NULL, NULL, NULL, NULL);
				contact_handles_added = _tmp31_;
				{
					GeeHashSet* _tmp32_;
					GeeIterator* _tmp33_ = NULL;
					GeeIterator* _contact_handle_it;
					_tmp32_ = contact_handles;
					_tmp33_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp32_);
					_contact_handle_it = _tmp33_;
					while (TRUE) {
						GeeIterator* _tmp34_;
						gboolean _tmp35_ = FALSE;
						GeeIterator* _tmp36_;
						gpointer _tmp37_ = NULL;
						guint contact_handle;
						GeeHashMap* _tmp38_;
						guint _tmp39_;
						gpointer _tmp40_ = NULL;
						TpfPersona* persona;
						TpfPersona* _tmp41_;
						_tmp34_ = _contact_handle_it;
						_tmp35_ = gee_iterator_next (_tmp34_);
						if (!_tmp35_) {
							break;
						}
						_tmp36_ = _contact_handle_it;
						_tmp37_ = gee_iterator_get (_tmp36_);
						contact_handle = GPOINTER_TO_UINT (_tmp37_);
						_tmp38_ = self->priv->_handle_persona_map;
						_tmp39_ = contact_handle;
						_tmp40_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp38_, GUINT_TO_POINTER (_tmp39_));
						persona = (TpfPersona*) _tmp40_;
						_tmp41_ = persona;
						if (_tmp41_ != NULL) {
							TpfPersona* _tmp42_;
							const gchar* _tmp43_;
							const gchar* _tmp44_;
							GeeHashSet* _tmp45_;
							TpfPersona* _tmp46_;
							TpfPersona* _tmp47_;
							TpfPersona* _tmp48_;
							GeeHashSet* _tmp49_;
							guint _tmp50_;
							_tmp42_ = persona;
							_tmp43_ = folks_persona_get_uid ((FolksPersona*) _tmp42_);
							_tmp44_ = _tmp43_;
							g_debug ("tpf-persona-store.vala:2238:     %s", _tmp44_);
							_tmp45_ = members;
							_tmp46_ = persona;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp45_, _tmp46_);
							_tmp47_ = persona;
							_tmp48_ = _g_object_ref0 (_tmp47_);
							members_added = g_list_prepend (members_added, _tmp48_);
							_tmp49_ = contact_handles_added;
							_tmp50_ = contact_handle;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp49_, GUINT_TO_POINTER (_tmp50_));
						}
						_g_object_unref0 (persona);
					}
					_g_object_unref0 (_contact_handle_it);
				}
				{
					GeeHashSet* _tmp51_;
					GeeIterator* _tmp52_ = NULL;
					GeeIterator* _handle_it;
					_tmp51_ = contact_handles_added;
					_tmp52_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp51_);
					_handle_it = _tmp52_;
					while (TRUE) {
						GeeIterator* _tmp53_;
						gboolean _tmp54_ = FALSE;
						GeeIterator* _tmp55_;
						gpointer _tmp56_ = NULL;
						guint handle;
						GeeHashSet* _tmp57_;
						guint _tmp58_;
						_tmp53_ = _handle_it;
						_tmp54_ = gee_iterator_next (_tmp53_);
						if (!_tmp54_) {
							break;
						}
						_tmp55_ = _handle_it;
						_tmp56_ = gee_iterator_get (_tmp55_);
						handle = GPOINTER_TO_UINT (_tmp56_);
						_tmp57_ = contact_handles;
						_tmp58_ = handle;
						gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp57_, GUINT_TO_POINTER (_tmp58_));
					}
					_g_object_unref0 (_handle_it);
				}
				_g_object_unref0 (contact_handles_added);
			}
			_tmp59_ = members;
			_tmp60_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp59_);
			_tmp61_ = _tmp60_;
			if (_tmp61_ > 0) {
				GeeHashMap* _tmp62_;
				TpChannel* _tmp63_;
				GeeHashSet* _tmp64_;
				_tmp62_ = self->priv->_channel_group_personas_map;
				_tmp63_ = channel;
				_tmp64_ = members;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp62_, _tmp63_, _tmp64_);
			}
			_tmp65_ = channel;
			_tmp66_ = tp_channel_get_identifier (_tmp65_);
			_tmp67_ = g_strdup (_tmp66_);
			name = _tmp67_;
			_tmp69_ = name;
			_tmp70_ = _tpf_persona_store_group_is_display_group (self, _tmp69_);
			if (_tmp70_) {
				GList* _tmp71_;
				guint _tmp72_ = 0U;
				_tmp71_ = members_added;
				_tmp72_ = g_list_length (_tmp71_);
				_tmp68_ = _tmp72_ > ((guint) 0);
			} else {
				_tmp68_ = FALSE;
			}
			_tmp73_ = _tmp68_;
			if (_tmp73_) {
				const gchar* _tmp74_;
				GList* _tmp75_;
				members_added = g_list_reverse (members_added);
				_tmp74_ = name;
				_tmp75_ = members_added;
				g_signal_emit_by_name (self, "group-members-changed", _tmp74_, _tmp75_, NULL);
			}
			_g_free0 (name);
			_g_object_unref0 (contact_handles);
			_g_object_unref0 (members);
			__g_list_free__g_object_unref0_0 (members_added);
			_g_object_unref0 (channel);
			_g_object_unref0 (entry);
		}
		_g_object_unref0 (_entry_it);
	}
}


static gboolean _tpf_persona_store_group_is_display_group (TpfPersonaStore* self, const gchar* group) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (group != NULL, FALSE);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				gchar** _tmp4_;
				gint _tmp4__length1;
				gchar** _tmp5_;
				gint _tmp5__length1;
				gint _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = tpf_persona_store__undisplayed_groups;
				_tmp4__length1 = tpf_persona_store__undisplayed_groups_length1;
				if (!(_tmp3_ < _tmp4__length1)) {
					break;
				}
				_tmp5_ = tpf_persona_store__undisplayed_groups;
				_tmp5__length1 = tpf_persona_store__undisplayed_groups_length1;
				_tmp6_ = i;
				_tmp7_ = _tmp5_[_tmp6_];
				_tmp8_ = group;
				if (g_strcmp0 (_tmp7_, _tmp8_) == 0) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static void tpf_persona_store_real_add_persona_from_details_data_free (gpointer _data) {
	TpfPersonaStoreAddPersonaFromDetailsData* _data_;
	_data_ = _data;
	_g_hash_table_unref0 (_data_->details);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreAddPersonaFromDetailsData, _data_);
}


static void tpf_persona_store_real_add_persona_from_details (FolksPersonaStore* base, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStore * self;
	TpfPersonaStoreAddPersonaFromDetailsData* _data_;
	TpfPersonaStore* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	self = (TpfPersonaStore*) base;
	_data_ = g_slice_new0 (TpfPersonaStoreAddPersonaFromDetailsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_real_add_persona_from_details);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_real_add_persona_from_details_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = details;
	_tmp2_ = _g_hash_table_ref0 (_tmp1_);
	_data_->details = _tmp2_;
	tpf_persona_store_real_add_persona_from_details_co (_data_);
}


static FolksPersona* tpf_persona_store_real_add_persona_from_details_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	FolksPersona* result;
	TpfPersonaStoreAddPersonaFromDetailsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
   * Add a new {@link Persona} to the PersonaStore.
   *
   * See {@link Folks.PersonaStore.add_persona_from_details}.
   */
static void tpf_persona_store_add_persona_from_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreAddPersonaFromDetailsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_store_real_add_persona_from_details_co (_data_);
}


static gboolean tpf_persona_store_real_add_persona_from_details_co (TpfPersonaStoreAddPersonaFromDetailsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->details;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = tp_asv_get_string (_data_->_tmp0_, "contact");
	_data_->_tmp2_ = g_strdup (_data_->_tmp1_);
	_data_->contact_id = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->contact_id;
	if (_data_->_tmp3_ == NULL) {
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _ ("Persona store (%s, %s) requires the following details:\n" \
"    contact (provided: '%s')\n");
		_data_->_tmp5_ = folks_persona_store_get_type_id ((FolksPersonaStore*) _data_->self);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp9_ = _data_->contact_id;
		_data_->_tmp10_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_INVALID_ARGUMENT, _data_->_tmp4_, _data_->_tmp6_, _data_->_tmp8_, _data_->_tmp9_);
		_data_->_inner_error_ = _data_->_tmp10_;
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_free0 (_data_->contact_id);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_free0 (_data_->contact_id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp11_ = _data_->details;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = tp_asv_get_string (_data_->_tmp11_, "message");
	_data_->_tmp13_ = g_strdup (_data_->_tmp12_);
	_data_->add_message = _data_->_tmp13_;
	_data_->_tmp14_ = _data_->add_message;
	if (g_strcmp0 (_data_->_tmp14_, "") == 0) {
		_g_free0 (_data_->add_message);
		_data_->add_message = NULL;
	}
	_data_->_tmp15_ = tpf_persona_store_get_account (_data_->self);
	_data_->_tmp16_ = _data_->_tmp15_;
	_data_->_tmp17_ = 0;
	_data_->_tmp17_ = tp_account_get_connection_status (_data_->_tmp16_, NULL);
	_data_->status = _data_->_tmp17_;
	_data_->_tmp20_ = _data_->status;
	if (_data_->_tmp20_ == TP_CONNECTION_STATUS_DISCONNECTED) {
		_data_->_tmp19_ = TRUE;
	} else {
		_data_->_tmp21_ = _data_->status;
		_data_->_tmp19_ = _data_->_tmp21_ == TP_CONNECTION_STATUS_CONNECTING;
	}
	_data_->_tmp22_ = _data_->_tmp19_;
	if (_data_->_tmp22_) {
		_data_->_tmp18_ = TRUE;
	} else {
		_data_->_tmp23_ = _data_->self->priv->_conn;
		_data_->_tmp18_ = _data_->_tmp23_ == NULL;
	}
	_data_->_tmp24_ = _data_->_tmp18_;
	if (_data_->_tmp24_) {
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = _ ("Cannot create a new Telepathy contact while offline.");
		_data_->_tmp26_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE, _data_->_tmp25_);
		_data_->_inner_error_ = _data_->_tmp26_;
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_free0 (_data_->add_message);
			_g_free0 (_data_->contact_id);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_free0 (_data_->add_message);
			_g_free0 (_data_->contact_id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp27_ = NULL;
	_data_->_tmp27_ = g_new0 (gchar*, 1 + 1);
	_data_->contact_ids = _data_->_tmp27_;
	_data_->contact_ids_length1 = 1;
	_data_->_contact_ids_size_ = _data_->contact_ids_length1;
	_data_->_tmp28_ = _data_->contact_ids;
	_data_->_tmp28__length1 = _data_->contact_ids_length1;
	_data_->_tmp29_ = _data_->contact_id;
	_data_->_tmp30_ = g_strdup (_data_->_tmp29_);
	_g_free0 (_data_->_tmp28_[0]);
	_data_->_tmp28_[0] = _data_->_tmp30_;
	_data_->_tmp31_ = _data_->_tmp28_[0];
	{
		_data_->_tmp32_ = _data_->contact_ids;
		_data_->_tmp32__length1 = _data_->contact_ids_length1;
		_data_->_state_ = 1;
		_tpf_persona_store_ensure_personas_from_contact_ids (_data_->self, _data_->_tmp32_, _data_->_tmp32__length1, tpf_persona_store_add_persona_from_details_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp33_ = NULL;
		_data_->_tmp33_ = _tpf_persona_store_ensure_personas_from_contact_ids_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		_data_->personas = _data_->_tmp33_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch20_g_error;
		}
		_data_->_tmp34_ = _data_->personas;
		_data_->_tmp35_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp34_);
		_data_->_tmp36_ = _data_->_tmp35_;
		if (_data_->_tmp36_ == 0) {
			_data_->result = NULL;
			_g_object_unref0 (_data_->personas);
			_data_->contact_ids = (_vala_array_free (_data_->contact_ids, _data_->contact_ids_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (_data_->add_message);
			_g_free0 (_data_->contact_id);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_data_->_tmp37_ = _data_->personas;
			_data_->_tmp38_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp37_);
			_data_->_tmp39_ = _data_->_tmp38_;
			if (_data_->_tmp39_ == 1) {
				_data_->persona = NULL;
				{
					_data_->_tmp40_ = _data_->personas;
					_data_->_tmp41_ = NULL;
					_data_->_tmp41_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _data_->_tmp40_);
					_data_->_p_it = _data_->_tmp41_;
					while (TRUE) {
						_data_->_tmp42_ = _data_->_p_it;
						_data_->_tmp43_ = FALSE;
						_data_->_tmp43_ = gee_iterator_next (_data_->_tmp42_);
						if (!_data_->_tmp43_) {
							break;
						}
						_data_->_tmp44_ = _data_->_p_it;
						_data_->_tmp45_ = NULL;
						_data_->_tmp45_ = gee_iterator_get (_data_->_tmp44_);
						_data_->p = (TpfPersona*) _data_->_tmp45_;
						_data_->_tmp46_ = _data_->p;
						_data_->_tmp47_ = _g_object_ref0 (_data_->_tmp46_);
						_g_object_unref0 (_data_->persona);
						_data_->persona = _data_->_tmp47_;
						_g_object_unref0 (_data_->p);
						break;
					}
					_g_object_unref0 (_data_->_p_it);
				}
				_data_->_tmp48_ = _data_->self->priv->_subscribe;
				if (_data_->_tmp48_ != NULL) {
					_data_->_tmp49_ = _data_->self->priv->_subscribe;
					_data_->_tmp50_ = _data_->persona;
					_data_->_tmp51_ = _data_->add_message;
					_tpf_persona_store_change_standard_contact_list_membership (_data_->self, _data_->_tmp49_, (FolksPersona*) _data_->_tmp50_, TRUE, _data_->_tmp51_);
				}
				_data_->_tmp52_ = _data_->self->priv->_publish;
				if (_data_->_tmp52_ != NULL) {
					_data_->_tmp53_ = _data_->self->priv->_publish;
					_data_->_tmp54_ = 0;
					_data_->_tmp54_ = tp_channel_group_get_flags (_data_->_tmp53_);
					_data_->flags = _data_->_tmp54_;
					_data_->_tmp55_ = _data_->flags;
					if ((_data_->_tmp55_ & TP_CHANNEL_GROUP_FLAG_CAN_ADD) == TP_CHANNEL_GROUP_FLAG_CAN_ADD) {
						_data_->_tmp56_ = _data_->self->priv->_publish;
						_data_->_tmp57_ = _data_->persona;
						_data_->_tmp58_ = _data_->add_message;
						_tpf_persona_store_change_standard_contact_list_membership (_data_->self, _data_->_tmp56_, (FolksPersona*) _data_->_tmp57_, TRUE, _data_->_tmp58_);
					}
				}
				_data_->result = (FolksPersona*) _data_->persona;
				_g_object_unref0 (_data_->personas);
				_data_->contact_ids = (_vala_array_free (_data_->contact_ids, _data_->contact_ids_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_data_->add_message);
				_g_free0 (_data_->contact_id);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_data_->_tmp59_ = _data_->personas;
				_data_->_tmp60_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp59_);
				_data_->_tmp61_ = _data_->_tmp60_;
				_data_->num_personas = _data_->_tmp61_;
				_data_->_tmp62_ = _data_->num_personas;
				_data_->_tmp63_ = NULL;
				_data_->_tmp63_ = ngettext ("Requested a single persona, but got %u persona back.", "Requested a single persona, but got %u personas back.", (gulong) _data_->_tmp62_);
				_data_->_tmp64_ = g_strdup (_data_->_tmp63_);
				_data_->message = _data_->_tmp64_;
				_data_->_tmp65_ = _data_->message;
				_data_->_tmp66_ = _data_->num_personas;
				_data_->_tmp67_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_CREATE_FAILED, _data_->_tmp65_, _data_->_tmp66_);
				_data_->_inner_error_ = _data_->_tmp67_;
				_g_free0 (_data_->message);
				_g_object_unref0 (_data_->personas);
				goto __catch20_g_error;
			}
		}
		_g_object_unref0 (_data_->personas);
	}
	goto __finally20;
	__catch20_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp68_ = NULL;
		_data_->_tmp68_ = _ ("Failed to add a persona from details: %s");
		_data_->_tmp69_ = _data_->e;
		_data_->_tmp70_ = _data_->_tmp69_->message;
		_data_->_tmp71_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_CREATE_FAILED, _data_->_tmp68_, _data_->_tmp70_);
		_data_->_inner_error_ = _data_->_tmp71_;
		_g_error_free0 (_data_->e);
		goto __finally20;
	}
	__finally20:
	if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_data_->contact_ids = (_vala_array_free (_data_->contact_ids, _data_->contact_ids_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_data_->add_message);
		_g_free0 (_data_->contact_id);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->contact_ids = (_vala_array_free (_data_->contact_ids, _data_->contact_ids_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_data_->add_message);
		_g_free0 (_data_->contact_id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->contact_ids = (_vala_array_free (_data_->contact_ids, _data_->contact_ids_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_data_->add_message);
	_g_free0 (_data_->contact_id);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tpf_persona_store_change_is_favourite_data_free (gpointer _data) {
	TpfPersonaStoreChangeIsFavouriteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreChangeIsFavouriteData, _data_);
}


void tpf_persona_store_change_is_favourite (TpfPersonaStore* self, FolksPersona* persona, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreChangeIsFavouriteData* _data_;
	TpfPersonaStore* _tmp0_;
	FolksPersona* _tmp1_;
	FolksPersona* _tmp2_;
	gboolean _tmp3_;
	_data_ = g_slice_new0 (TpfPersonaStoreChangeIsFavouriteData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_change_is_favourite);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_change_is_favourite_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->persona = _tmp2_;
	_tmp3_ = is_favourite;
	_data_->is_favourite = _tmp3_;
	tpf_persona_store_change_is_favourite_co (_data_);
}


void tpf_persona_store_change_is_favourite_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error) {
	TpfPersonaStoreChangeIsFavouriteData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Change the favourite status of a persona in this store.
   *
   * This function is idempotent, but relies upon having a connection to the
   * Telepathy logger service, so may fail if that connection is not present.
   */
static void tpf_persona_store_change_is_favourite_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreChangeIsFavouriteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_store_change_is_favourite_co (_data_);
}


static gboolean tpf_persona_store_change_is_favourite_co (TpfPersonaStoreChangeIsFavouriteData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_logger;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _ ("Failed to change favorite without a connection to the telepathy-logger" \
" service.");
		_data_->_tmp2_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR, _data_->_tmp1_);
		_data_->_inner_error_ = _data_->_tmp2_;
		if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp3_ = _data_->persona;
	_data_->_tmp4_ = tpf_persona_get_contact (TPF_PERSONA (_data_->_tmp3_));
	_data_->_tmp5_ = _data_->_tmp4_;
	if (_data_->_tmp5_ == NULL) {
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _ ("Failed to change favorite status of Telepathy Persona because it has n" \
"o attached TpContact.");
		_data_->_tmp7_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_INVALID_VALUE, _data_->_tmp6_);
		_data_->_inner_error_ = _data_->_tmp7_;
		if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	{
		_data_->_tmp8_ = _data_->persona;
		_data_->_tmp9_ = tpf_persona_get_contact (TPF_PERSONA (_data_->_tmp8_));
		_data_->_tmp10_ = _data_->_tmp9_;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = tp_contact_get_identifier (_data_->_tmp10_);
		_data_->id = _data_->_tmp11_;
		_data_->_tmp12_ = _data_->is_favourite;
		if (_data_->_tmp12_) {
			_data_->_tmp13_ = _data_->self->priv->_logger;
			_data_->_tmp14_ = _data_->id;
			_data_->_state_ = 1;
			logger_add_favourite_contact (_data_->_tmp13_, _data_->_tmp14_, tpf_persona_store_change_is_favourite_ready, _data_);
			return FALSE;
			_state_1:
			logger_add_favourite_contact_finish (_data_->_tmp13_, _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				goto __catch21_g_error;
			}
		} else {
			_data_->_tmp15_ = _data_->self->priv->_logger;
			_data_->_tmp16_ = _data_->id;
			_data_->_state_ = 2;
			logger_remove_favourite_contact (_data_->_tmp15_, _data_->_tmp16_, tpf_persona_store_change_is_favourite_ready, _data_);
			return FALSE;
			_state_2:
			logger_remove_favourite_contact_finish (_data_->_tmp15_, _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				goto __catch21_g_error;
			}
		}
	}
	goto __finally21;
	__catch21_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = _ ("Failed to change favorite status for Telepathy contact ‘%s’.");
		_data_->_tmp18_ = _data_->persona;
		_data_->_tmp19_ = tpf_persona_get_contact (TPF_PERSONA (_data_->_tmp18_));
		_data_->_tmp20_ = _data_->_tmp19_;
		_data_->_tmp21_ = tp_contact_get_identifier (_data_->_tmp20_);
		_data_->_tmp22_ = _data_->_tmp21_;
		_data_->_tmp23_ = g_error_new (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR, _data_->_tmp17_, _data_->_tmp22_);
		_data_->_inner_error_ = _data_->_tmp23_;
		_g_error_free0 (_data_->e);
		goto __finally21;
	}
	__finally21:
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tpf_persona_store_change_alias_data_free (gpointer _data) {
	TpfPersonaStoreChangeAliasData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_free0 (_data_->alias);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreChangeAliasData, _data_);
}


void tpf_persona_store_change_alias (TpfPersonaStore* self, TpfPersona* persona, const gchar* alias, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreChangeAliasData* _data_;
	TpfPersonaStore* _tmp0_;
	TpfPersona* _tmp1_;
	TpfPersona* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	_data_ = g_slice_new0 (TpfPersonaStoreChangeAliasData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_change_alias);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_change_alias_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->persona = _tmp2_;
	_tmp3_ = alias;
	_tmp4_ = g_strdup (_tmp3_);
	_data_->alias = _tmp4_;
	tpf_persona_store_change_alias_co (_data_);
}


void tpf_persona_store_change_alias_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpfPersonaStoreChangeAliasData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean tpf_persona_store_change_alias_co (TpfPersonaStoreChangeAliasData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->alias;
	if (_data_->_tmp0_ == NULL) {
		_data_->alias = "";
	}
	_data_->_tmp1_ = _data_->persona;
	_data_->_tmp2_ = tpf_persona_get_contact (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	if (_data_->_tmp3_ == NULL) {
		_data_->_tmp4_ = _data_->persona;
		_data_->_tmp5_ = _data_->alias;
		g_warning ("Skipping Tpf.Persona %p alias change to '%s' because it " "has no attached TpContact", _data_->_tmp4_, _data_->_tmp5_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->persona;
	_data_->_tmp7_ = tpf_persona_get_contact (_data_->_tmp6_);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = tp_contact_get_handle (_data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = _data_->alias;
	g_debug ("tpf-persona-store.vala:2429: Changing alias of persona %u to '%s'.", _data_->_tmp10_, _data_->_tmp11_);
	_data_->_tmp12_ = _data_->self->priv->_conn;
	_data_->_tmp13_ = _data_->persona;
	_data_->_tmp14_ = tpf_persona_get_contact (_data_->_tmp13_);
	_data_->_tmp15_ = _data_->_tmp14_;
	_data_->_tmp16_ = tp_contact_get_handle (_data_->_tmp15_);
	_data_->_tmp17_ = _data_->_tmp16_;
	_data_->_tmp18_ = _data_->alias;
	folks_tp_lowlevel_connection_set_contact_alias (_data_->_tmp12_, (guint) ((TpHandle) _data_->_tmp17_), _data_->_tmp18_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tpf_persona_store_change_user_birthday_data_free (gpointer _data) {
	TpfPersonaStoreChangeUserBirthdayData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_date_time_unref0 (_data_->birthday);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreChangeUserBirthdayData, _data_);
}


static gpointer _g_date_time_ref0 (gpointer self) {
	return self ? g_date_time_ref (self) : NULL;
}


void tpf_persona_store_change_user_birthday (TpfPersonaStore* self, TpfPersona* persona, GDateTime* birthday, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreChangeUserBirthdayData* _data_;
	TpfPersonaStore* _tmp0_;
	TpfPersona* _tmp1_;
	TpfPersona* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	_data_ = g_slice_new0 (TpfPersonaStoreChangeUserBirthdayData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_change_user_birthday);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_change_user_birthday_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->persona = _tmp2_;
	_tmp3_ = birthday;
	_tmp4_ = _g_date_time_ref0 (_tmp3_);
	_data_->birthday = _tmp4_;
	tpf_persona_store_change_user_birthday_co (_data_);
}


void tpf_persona_store_change_user_birthday_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error) {
	TpfPersonaStoreChangeUserBirthdayData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gchar* g_date_time_to_string (GDateTime* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}


static TpContactInfoField* _vala_TpContactInfoField_copy (TpContactInfoField* self) {
	return g_boxed_copy (tp_contact_info_field_get_type (), self);
}


static void _vala_TpContactInfoField_free (TpContactInfoField* self) {
	g_boxed_free (tp_contact_info_field_get_type (), self);
}


static void tpf_persona_store_change_user_birthday_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreChangeUserBirthdayData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_store_change_user_birthday_co (_data_);
}


static gboolean tpf_persona_store_change_user_birthday_co (TpfPersonaStoreChangeUserBirthdayData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->birthday;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = g_strdup ("");
		_g_free0 (_data_->birthday_str);
		_data_->birthday_str = _data_->_tmp1_;
	} else {
		_data_->_tmp2_ = _data_->birthday;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = g_date_time_to_string (_data_->_tmp2_);
		_g_free0 (_data_->birthday_str);
		_data_->birthday_str = _data_->_tmp3_;
	}
	_data_->_tmp4_ = gee_hash_set_new (tp_contact_info_field_get_type (), (GBoxedCopyFunc) _vala_TpContactInfoField_copy, _vala_TpContactInfoField_free, NULL, NULL);
	_data_->info_set = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->birthday_str;
	_data_->_tmp6_ = g_strdup (_data_->_tmp5_);
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = g_new0 (gchar*, 1 + 1);
	_data_->_tmp7_[0] = _data_->_tmp6_;
	_data_->values = _data_->_tmp7_;
	_data_->values_length1 = 1;
	_data_->_values_size_ = _data_->values_length1;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = g_new0 (gchar*, 1 + 1);
	_data_->_tmp8_[0] = NULL;
	_data_->parameters = _data_->_tmp8_;
	_data_->parameters_length1 = 1;
	_data_->_parameters_size_ = _data_->parameters_length1;
	_data_->_tmp9_ = tp_contact_info_field_new ("bday", _data_->parameters, _data_->values);
	_data_->field = _data_->_tmp9_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _data_->info_set, _data_->field);
	_data_->_tmp10_ = _data_->persona;
	_data_->_state_ = 1;
	_tpf_persona_store_change_user_contact_info (_data_->self, _data_->_tmp10_, _data_->info_set, tpf_persona_store_change_user_birthday_ready, _data_);
	return FALSE;
	_state_1:
	_tpf_persona_store_change_user_contact_info_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			__vala_TpContactInfoField_free0 (_data_->field);
			_data_->parameters = (_vala_array_free (_data_->parameters, _data_->parameters_length1, (GDestroyNotify) g_free), NULL);
			_data_->values = (_vala_array_free (_data_->values, _data_->values_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->info_set);
			_g_free0 (_data_->birthday_str);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			__vala_TpContactInfoField_free0 (_data_->field);
			_data_->parameters = (_vala_array_free (_data_->parameters, _data_->parameters_length1, (GDestroyNotify) g_free), NULL);
			_data_->values = (_vala_array_free (_data_->values, _data_->values_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->info_set);
			_g_free0 (_data_->birthday_str);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	__vala_TpContactInfoField_free0 (_data_->field);
	_data_->parameters = (_vala_array_free (_data_->parameters, _data_->parameters_length1, (GDestroyNotify) g_free), NULL);
	_data_->values = (_vala_array_free (_data_->values, _data_->values_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->info_set);
	_g_free0 (_data_->birthday_str);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tpf_persona_store_change_user_full_name_data_free (gpointer _data) {
	TpfPersonaStoreChangeUserFullNameData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_free0 (_data_->full_name);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreChangeUserFullNameData, _data_);
}


void tpf_persona_store_change_user_full_name (TpfPersonaStore* self, TpfPersona* persona, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreChangeUserFullNameData* _data_;
	TpfPersonaStore* _tmp0_;
	TpfPersona* _tmp1_;
	TpfPersona* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	_data_ = g_slice_new0 (TpfPersonaStoreChangeUserFullNameData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_change_user_full_name);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_change_user_full_name_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->persona = _tmp2_;
	_tmp3_ = full_name;
	_tmp4_ = g_strdup (_tmp3_);
	_data_->full_name = _tmp4_;
	tpf_persona_store_change_user_full_name_co (_data_);
}


void tpf_persona_store_change_user_full_name_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error) {
	TpfPersonaStoreChangeUserFullNameData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tpf_persona_store_change_user_full_name_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreChangeUserFullNameData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_store_change_user_full_name_co (_data_);
}


static gboolean tpf_persona_store_change_user_full_name_co (TpfPersonaStoreChangeUserFullNameData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->full_name;
	if (_data_->_tmp0_ == NULL) {
		_data_->full_name = "";
	}
	_data_->_tmp1_ = gee_hash_set_new (tp_contact_info_field_get_type (), (GBoxedCopyFunc) _vala_TpContactInfoField_copy, _vala_TpContactInfoField_free, NULL, NULL);
	_data_->info_set = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->full_name;
	_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_new0 (gchar*, 1 + 1);
	_data_->_tmp4_[0] = _data_->_tmp3_;
	_data_->values = _data_->_tmp4_;
	_data_->values_length1 = 1;
	_data_->_values_size_ = _data_->values_length1;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = g_new0 (gchar*, 1 + 1);
	_data_->_tmp5_[0] = NULL;
	_data_->parameters = _data_->_tmp5_;
	_data_->parameters_length1 = 1;
	_data_->_parameters_size_ = _data_->parameters_length1;
	_data_->_tmp6_ = tp_contact_info_field_new ("fn", _data_->parameters, _data_->values);
	_data_->field = _data_->_tmp6_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _data_->info_set, _data_->field);
	_data_->_tmp7_ = _data_->persona;
	_data_->_state_ = 1;
	_tpf_persona_store_change_user_contact_info (_data_->self, _data_->_tmp7_, _data_->info_set, tpf_persona_store_change_user_full_name_ready, _data_);
	return FALSE;
	_state_1:
	_tpf_persona_store_change_user_contact_info_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			__vala_TpContactInfoField_free0 (_data_->field);
			_data_->parameters = (_vala_array_free (_data_->parameters, _data_->parameters_length1, (GDestroyNotify) g_free), NULL);
			_data_->values = (_vala_array_free (_data_->values, _data_->values_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->info_set);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			__vala_TpContactInfoField_free0 (_data_->field);
			_data_->parameters = (_vala_array_free (_data_->parameters, _data_->parameters_length1, (GDestroyNotify) g_free), NULL);
			_data_->values = (_vala_array_free (_data_->values, _data_->values_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->info_set);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	__vala_TpContactInfoField_free0 (_data_->field);
	_data_->parameters = (_vala_array_free (_data_->parameters, _data_->parameters_length1, (GDestroyNotify) g_free), NULL);
	_data_->values = (_vala_array_free (_data_->values, _data_->values_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->info_set);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _tpf_persona_store_change_user_details_data_free (gpointer _data) {
	TpfPersonaStoreChangeUserDetailsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_object_unref0 (_data_->details);
	_g_free0 (_data_->field_name);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreChangeUserDetailsData, _data_);
}


void _tpf_persona_store_change_user_details (TpfPersonaStore* self, TpfPersona* persona, GeeSet* details, const gchar* field_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreChangeUserDetailsData* _data_;
	TpfPersonaStore* _tmp0_;
	TpfPersona* _tmp1_;
	TpfPersona* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	_data_ = g_slice_new0 (TpfPersonaStoreChangeUserDetailsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_change_user_details);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_change_user_details_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->persona = _tmp2_;
	_tmp3_ = details;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data_->details = _tmp4_;
	_tmp5_ = field_name;
	_tmp6_ = g_strdup (_tmp5_);
	_data_->field_name = _tmp6_;
	_tpf_persona_store_change_user_details_co (_data_);
}


void _tpf_persona_store_change_user_details_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error) {
	TpfPersonaStoreChangeUserDetailsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _tpf_persona_store_change_user_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreChangeUserDetailsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_store_change_user_details_co (_data_);
}


static gboolean _tpf_persona_store_change_user_details_co (TpfPersonaStoreChangeUserDetailsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gee_hash_set_new (tp_contact_info_field_get_type (), (GBoxedCopyFunc) _vala_TpContactInfoField_copy, _vala_TpContactInfoField_free, NULL, NULL);
	_data_->info_set = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _data_->details;
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp1_);
		_data_->_afd_it = _data_->_tmp2_;
		while (TRUE) {
			_data_->_tmp3_ = _data_->_afd_it;
			_data_->_tmp4_ = FALSE;
			_data_->_tmp4_ = gee_iterator_next (_data_->_tmp3_);
			if (!_data_->_tmp4_) {
				break;
			}
			_data_->_tmp5_ = _data_->_afd_it;
			_data_->_tmp6_ = NULL;
			_data_->_tmp6_ = gee_iterator_get (_data_->_tmp5_);
			_data_->afd = (FolksAbstractFieldDetails*) _data_->_tmp6_;
			_data_->_tmp7_ = _data_->afd;
			_data_->_tmp8_ = folks_abstract_field_details_get_value (_data_->_tmp7_);
			_data_->_tmp9_ = _data_->_tmp8_;
			_data_->_tmp10_ = g_strdup ((const gchar*) _data_->_tmp9_);
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = g_new0 (gchar*, 1 + 1);
			_data_->_tmp11_[0] = _data_->_tmp10_;
			_data_->values = _data_->_tmp11_;
			_data_->values_length1 = 1;
			_data_->_values_size_ = _data_->values_length1;
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = g_new0 (gchar*, 0 + 1);
			_data_->parameters = _data_->_tmp12_;
			_data_->parameters_length1 = 0;
			_data_->_parameters_size_ = _data_->parameters_length1;
			{
				_data_->_tmp13_ = _data_->afd;
				_data_->_tmp14_ = folks_abstract_field_details_get_parameters (_data_->_tmp13_);
				_data_->_tmp15_ = _data_->_tmp14_;
				_data_->_tmp16_ = NULL;
				_data_->_tmp16_ = gee_multi_map_get_keys (_data_->_tmp15_);
				_data_->_tmp17_ = _data_->_tmp16_;
				_data_->_tmp18_ = NULL;
				_data_->_tmp18_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp17_);
				_data_->_tmp19_ = _data_->_tmp18_;
				_g_object_unref0 (_data_->_tmp17_);
				_data_->_param_name_it = _data_->_tmp19_;
				while (TRUE) {
					_data_->_tmp20_ = _data_->_param_name_it;
					_data_->_tmp21_ = FALSE;
					_data_->_tmp21_ = gee_iterator_next (_data_->_tmp20_);
					if (!_data_->_tmp21_) {
						break;
					}
					_data_->_tmp22_ = _data_->_param_name_it;
					_data_->_tmp23_ = NULL;
					_data_->_tmp23_ = gee_iterator_get (_data_->_tmp22_);
					_data_->param_name = (gchar*) _data_->_tmp23_;
					_data_->_tmp24_ = _data_->afd;
					_data_->_tmp25_ = folks_abstract_field_details_get_parameters (_data_->_tmp24_);
					_data_->_tmp26_ = _data_->_tmp25_;
					_data_->_tmp27_ = _data_->param_name;
					_data_->_tmp28_ = NULL;
					_data_->_tmp28_ = gee_multi_map_get (_data_->_tmp26_, _data_->_tmp27_);
					_data_->param_values = _data_->_tmp28_;
					{
						_data_->_tmp29_ = _data_->param_values;
						_data_->_tmp30_ = NULL;
						_data_->_tmp30_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp29_);
						_data_->_param_value_it = _data_->_tmp30_;
						while (TRUE) {
							_data_->_tmp31_ = _data_->_param_value_it;
							_data_->_tmp32_ = FALSE;
							_data_->_tmp32_ = gee_iterator_next (_data_->_tmp31_);
							if (!_data_->_tmp32_) {
								break;
							}
							_data_->_tmp33_ = _data_->_param_value_it;
							_data_->_tmp34_ = NULL;
							_data_->_tmp34_ = gee_iterator_get (_data_->_tmp33_);
							_data_->param_value = (gchar*) _data_->_tmp34_;
							_data_->_tmp35_ = _data_->parameters;
							_data_->_tmp35__length1 = _data_->parameters_length1;
							_data_->_tmp36_ = _data_->param_name;
							_data_->_tmp37_ = NULL;
							_data_->_tmp37_ = string_to_string (_data_->_tmp36_);
							_data_->_tmp38_ = _data_->param_value;
							_data_->_tmp39_ = NULL;
							_data_->_tmp39_ = string_to_string (_data_->_tmp38_);
							_data_->_tmp40_ = NULL;
							_data_->_tmp40_ = g_strconcat (_data_->_tmp37_, "=", _data_->_tmp39_, NULL);
							_vala_array_add7 (&_data_->parameters, &_data_->parameters_length1, &_data_->_parameters_size_, _data_->_tmp40_);
							_g_free0 (_data_->param_value);
						}
						_g_object_unref0 (_data_->_param_value_it);
					}
					_g_object_unref0 (_data_->param_values);
					_g_free0 (_data_->param_name);
				}
				_g_object_unref0 (_data_->_param_name_it);
			}
			_data_->_tmp41_ = _data_->parameters;
			_data_->_tmp41__length1 = _data_->parameters_length1;
			if (_data_->_tmp41__length1 == 0) {
				_data_->_tmp42_ = NULL;
				_data_->_tmp42_ = g_new0 (gchar*, 1 + 1);
				_data_->_tmp42_[0] = NULL;
				_data_->parameters = (_vala_array_free (_data_->parameters, _data_->parameters_length1, (GDestroyNotify) g_free), NULL);
				_data_->parameters = _data_->_tmp42_;
				_data_->parameters_length1 = 1;
				_data_->_parameters_size_ = _data_->parameters_length1;
			}
			_data_->_tmp43_ = _data_->field_name;
			_data_->_tmp44_ = _data_->parameters;
			_data_->_tmp44__length1 = _data_->parameters_length1;
			_data_->_tmp45_ = _data_->values;
			_data_->_tmp45__length1 = _data_->values_length1;
			_data_->_tmp46_ = tp_contact_info_field_new (_data_->_tmp43_, _data_->_tmp44_, _data_->_tmp45_);
			_data_->field = _data_->_tmp46_;
			_data_->_tmp47_ = _data_->info_set;
			_data_->_tmp48_ = _data_->field;
			gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp47_, _data_->_tmp48_);
			__vala_TpContactInfoField_free0 (_data_->field);
			_data_->parameters = (_vala_array_free (_data_->parameters, _data_->parameters_length1, (GDestroyNotify) g_free), NULL);
			_data_->values = (_vala_array_free (_data_->values, _data_->values_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->afd);
		}
		_g_object_unref0 (_data_->_afd_it);
	}
	_data_->_tmp49_ = _data_->persona;
	_data_->_tmp50_ = _data_->info_set;
	_data_->_state_ = 1;
	_tpf_persona_store_change_user_contact_info (_data_->self, _data_->_tmp49_, _data_->_tmp50_, _tpf_persona_store_change_user_details_ready, _data_);
	return FALSE;
	_state_1:
	_tpf_persona_store_change_user_contact_info_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->info_set);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->info_set);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->info_set);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _tpf_persona_store_change_user_contact_info_data_free (gpointer _data) {
	TpfPersonaStoreChangeUserContactInfoData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_object_unref0 (_data_->info_set);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreChangeUserContactInfoData, _data_);
}


static void _tpf_persona_store_change_user_contact_info (TpfPersonaStore* self, TpfPersona* persona, GeeHashSet* info_set, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreChangeUserContactInfoData* _data_;
	TpfPersonaStore* _tmp0_;
	TpfPersona* _tmp1_;
	TpfPersona* _tmp2_;
	GeeHashSet* _tmp3_;
	GeeHashSet* _tmp4_;
	_data_ = g_slice_new0 (TpfPersonaStoreChangeUserContactInfoData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_change_user_contact_info);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_change_user_contact_info_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->persona = _tmp2_;
	_tmp3_ = info_set;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data_->info_set = _tmp4_;
	_tpf_persona_store_change_user_contact_info_co (_data_);
}


static void _tpf_persona_store_change_user_contact_info_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error) {
	TpfPersonaStoreChangeUserContactInfoData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _tpf_persona_store_change_user_contact_info_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreChangeUserContactInfoData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_store_change_user_contact_info_co (_data_);
}


static void __vala_TpContactInfoField_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_TpContactInfoField_free (var), NULL));
}


static void _g_list_free___vala_TpContactInfoField_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) __vala_TpContactInfoField_free0_, NULL);
	g_list_free (self);
}


static gboolean _tpf_persona_store_change_user_contact_info_co (TpfPersonaStoreChangeUserContactInfoData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->persona;
	_data_->_tmp1_ = folks_persona_get_is_user ((FolksPersona*) _data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	if (!_data_->_tmp2_) {
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _ ("Extended information may only be set on the user's Telepathy contact.");
		_data_->_tmp4_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_UNSUPPORTED_ON_NON_USER, _data_->_tmp3_);
		_data_->_inner_error_ = _data_->_tmp4_;
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp5_ = _data_->info_set;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _tpf_persona_store_contact_info_set_to_list (_data_->_tmp5_);
	_data_->info_list = _data_->_tmp6_;
	_data_->_tmp7_ = tpf_persona_store_get_account (_data_->self);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = tp_account_get_connection (_data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	if (_data_->_tmp10_ != NULL) {
		_data_->_error_ = NULL;
		_data_->success = FALSE;
		{
			_data_->_tmp11_ = tpf_persona_store_get_account (_data_->self);
			_data_->_tmp12_ = _data_->_tmp11_;
			_data_->_tmp13_ = tp_account_get_connection (_data_->_tmp12_);
			_data_->_tmp14_ = _data_->_tmp13_;
			_data_->_tmp15_ = _data_->info_list;
			_data_->_state_ = 1;
			tp_connection_set_contact_info_async (_data_->_tmp14_, _data_->_tmp15_, _tpf_persona_store_change_user_contact_info_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp16_ = FALSE;
			_data_->_tmp16_ = tp_connection_set_contact_info_finish (_data_->_tmp14_, _data_->_res_, &_data_->_inner_error_);
			_data_->_tmp17_ = _data_->_tmp16_;
			if (_data_->_inner_error_ != NULL) {
				goto __catch22_g_error;
			}
			_data_->success = _data_->_tmp17_;
		}
		goto __finally22;
		__catch22_g_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp18_ = _data_->e;
			_data_->_tmp19_ = _g_error_copy0 (_data_->_tmp18_);
			_g_error_free0 (_data_->_error_);
			_data_->_error_ = _data_->_tmp19_;
			_g_error_free0 (_data_->e);
		}
		__finally22:
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_error_free0 (_data_->_error_);
				__g_list_free___vala_TpContactInfoField_free0_0 (_data_->info_list);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_error_free0 (_data_->_error_);
				__g_list_free___vala_TpContactInfoField_free0_0 (_data_->info_list);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
		_data_->_tmp21_ = _data_->_error_;
		if (_data_->_tmp21_ != NULL) {
			_data_->_tmp20_ = TRUE;
		} else {
			_data_->_tmp22_ = _data_->success;
			_data_->_tmp20_ = !_data_->_tmp22_;
		}
		_data_->_tmp23_ = _data_->_tmp20_;
		if (_data_->_tmp23_) {
			_data_->_tmp25_ = _data_->_error_;
			if (_data_->_tmp25_ != NULL) {
				_data_->_tmp26_ = _data_->_error_;
				_data_->_tmp27_ = _data_->_tmp26_->message;
				_data_->_tmp24_ = _data_->_tmp27_;
			} else {
				_data_->_tmp24_ = "(reason unknown)";
			}
			_data_->_tmp28_ = _data_->_tmp24_;
			g_warning ("Failed to set extended information on user's " "Telepathy contact: %s", _data_->_tmp28_);
		}
		_g_error_free0 (_data_->_error_);
	} else {
		_data_->_tmp29_ = NULL;
		_data_->_tmp29_ = _ ("Extended information cannot be written because the store is disconnect" \
"ed.");
		_data_->_tmp30_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE, _data_->_tmp29_);
		_data_->_inner_error_ = _data_->_tmp30_;
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			__g_list_free___vala_TpContactInfoField_free0_0 (_data_->info_list);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			__g_list_free___vala_TpContactInfoField_free0_0 (_data_->info_list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	__g_list_free___vala_TpContactInfoField_free0_0 (_data_->info_list);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static GList* _tpf_persona_store_contact_info_set_to_list (GeeHashSet* info_set) {
	GList* result = NULL;
	GList* info_list;
	g_return_val_if_fail (info_set != NULL, NULL);
	info_list = NULL;
	{
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _info_field_it;
		_tmp0_ = info_set;
		_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
		_info_field_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gboolean _tmp3_ = FALSE;
			GeeIterator* _tmp4_;
			gpointer _tmp5_ = NULL;
			TpContactInfoField* info_field;
			TpContactInfoField* _tmp6_;
			const gchar* _tmp7_;
			TpContactInfoField* _tmp8_;
			gchar** _tmp9_;
			gint _tmp9__length1;
			TpContactInfoField* _tmp10_;
			gchar** _tmp11_;
			gint _tmp11__length1;
			TpContactInfoField* _tmp12_;
			_tmp2_ = _info_field_it;
			_tmp3_ = gee_iterator_next (_tmp2_);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = _info_field_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			info_field = (TpContactInfoField*) _tmp5_;
			_tmp6_ = info_field;
			_tmp7_ = _tmp6_->field_name;
			_tmp8_ = info_field;
			_tmp9_ = _tmp8_->parameters;
			_tmp9__length1 = _vala_array_length (_tmp8_->parameters);
			_tmp10_ = info_field;
			_tmp11_ = _tmp10_->field_value;
			_tmp11__length1 = _vala_array_length (_tmp10_->field_value);
			_tmp12_ = tp_contact_info_field_new (_tmp7_, _tmp9_, _tmp11_);
			info_list = g_list_prepend (info_list, _tmp12_);
			__vala_TpContactInfoField_free0 (info_field);
		}
		_g_object_unref0 (_info_field_it);
	}
	info_list = g_list_reverse (info_list);
	result = info_list;
	return result;
}


/**
   * Get a map of all the currently constructed {@link Tpf.PersonaStore}s.
   *
   * If a {@link Folks.BackendStore} has been prepared, this map will be
   * complete, containing every store known to the Telepathy account manager. If
   * no {@link Folks.BackendStore} has been prepared, this map will only contain
   * the stores which have been created by calling
   * {@link Tpf.PersonaStore.dup_for_account}.
   *
   * This map is read-only. Use {@link Folks.BackendStore} or
   * {@link Tpf.PersonaStore.dup_for_account} to add stores.
   *
   * @return map from {@link Folks.PersonaStore.id} to {@link Tpf.PersonaStore}
   * @since 0.6.6
   */
GeeMap* tpf_persona_store_list_persona_stores (void) {
	GeeMap* result = NULL;
	GeeMap* store = NULL;
	GError * _inner_error_ = NULL;
	{
		GeeHashMap* _tmp0_;
		_tmp0_ = tpf_persona_store__persona_stores_by_account;
		g_static_rec_mutex_lock (&__lock_tpf_persona_store__persona_stores_by_account);
		{
			GeeHashMap* _tmp1_;
			GeeMap* _tmp6_;
			_tmp1_ = tpf_persona_store__persona_stores_by_account;
			if (_tmp1_ == NULL) {
				GeeHashMap* _tmp2_;
				GeeHashMap* _tmp3_;
				GeeMap* _tmp4_;
				GeeMap* _tmp5_;
				_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, TPF_TYPE_PERSONA_STORE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
				_g_object_unref0 (tpf_persona_store__persona_stores_by_account);
				tpf_persona_store__persona_stores_by_account = _tmp2_;
				_tmp3_ = tpf_persona_store__persona_stores_by_account;
				_tmp4_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp3_);
				_tmp5_ = _tmp4_;
				_g_object_unref0 (tpf_persona_store__persona_stores_by_account_ro);
				tpf_persona_store__persona_stores_by_account_ro = _tmp5_;
			}
			_tmp6_ = tpf_persona_store__persona_stores_by_account_ro;
			store = _tmp6_;
		}
		__finally23:
		{
			GeeHashMap* _tmp7_;
			_tmp7_ = tpf_persona_store__persona_stores_by_account;
			g_static_rec_mutex_unlock (&__lock_tpf_persona_store__persona_stores_by_account);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = store;
	return result;
}


static void _tpf_persona_store_store_removed_cb (FolksPersonaStore* store) {
	FolksPersonaStore* _tmp0_;
	g_return_if_fail (store != NULL);
	_tmp0_ = store;
	_tpf_persona_store_remove_store_from_map (TPF_PERSONA_STORE (_tmp0_));
}


static void __tpf_persona_store_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self) {
	_tpf_persona_store_store_removed_cb (_sender);
}


static void _tpf_persona_store_add_store_to_map (TpfPersonaStore* store) {
	TpfPersonaStore* _tmp0_;
	TpfPersonaStore* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (store != NULL);
	_tmp0_ = store;
	_tmp1_ = store;
	_tmp2_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp1_);
	_tmp3_ = _tmp2_;
	g_debug ("tpf-persona-store.vala:2610: Adding PersonaStore %p ('%s') to map.", _tmp0_, _tmp3_);
	{
		GeeHashMap* _tmp4_;
		_tmp4_ = tpf_persona_store__persona_stores_by_account;
		g_static_rec_mutex_lock (&__lock_tpf_persona_store__persona_stores_by_account);
		{
			GeeHashMap* _tmp5_;
			GeeHashMap* _tmp10_;
			TpfPersonaStore* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gboolean _tmp14_ = FALSE;
			GeeHashMap* _tmp15_;
			TpfPersonaStore* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			TpfPersonaStore* _tmp19_;
			TpfPersonaStore* _tmp20_;
			_tmp5_ = tpf_persona_store__persona_stores_by_account;
			if (_tmp5_ == NULL) {
				GeeHashMap* _tmp6_;
				GeeHashMap* _tmp7_;
				GeeMap* _tmp8_;
				GeeMap* _tmp9_;
				_tmp6_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, TPF_TYPE_PERSONA_STORE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
				_g_object_unref0 (tpf_persona_store__persona_stores_by_account);
				tpf_persona_store__persona_stores_by_account = _tmp6_;
				_tmp7_ = tpf_persona_store__persona_stores_by_account;
				_tmp8_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp7_);
				_tmp9_ = _tmp8_;
				_g_object_unref0 (tpf_persona_store__persona_stores_by_account_ro);
				tpf_persona_store__persona_stores_by_account_ro = _tmp9_;
			}
			_tmp10_ = tpf_persona_store__persona_stores_by_account;
			_tmp11_ = store;
			_tmp12_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp10_, _tmp13_);
			g_assert (!_tmp14_);
			_tmp15_ = tpf_persona_store__persona_stores_by_account;
			_tmp16_ = store;
			_tmp17_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = store;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, _tmp18_, _tmp19_);
			_tmp20_ = store;
			g_signal_connect ((FolksPersonaStore*) _tmp20_, "removed", (GCallback) __tpf_persona_store_store_removed_cb_folks_persona_store_removed, NULL);
		}
		__finally24:
		{
			GeeHashMap* _tmp21_;
			_tmp21_ = tpf_persona_store__persona_stores_by_account;
			g_static_rec_mutex_unlock (&__lock_tpf_persona_store__persona_stores_by_account);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void _tpf_persona_store_remove_store_from_map (TpfPersonaStore* store) {
	TpfPersonaStore* _tmp0_;
	TpfPersonaStore* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (store != NULL);
	_tmp0_ = store;
	_tmp1_ = store;
	_tmp2_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp1_);
	_tmp3_ = _tmp2_;
	g_debug ("tpf-persona-store.vala:2634: Removing PersonaStore %p ('%s') from map.", _tmp0_, _tmp3_);
	{
		GeeHashMap* _tmp4_;
		_tmp4_ = tpf_persona_store__persona_stores_by_account;
		g_static_rec_mutex_lock (&__lock_tpf_persona_store__persona_stores_by_account);
		{
			gboolean _tmp5_ = FALSE;
			GeeHashMap* _tmp6_;
			gboolean _tmp12_;
			TpfPersonaStore* _tmp14_;
			guint _tmp15_ = 0U;
			GeeHashMap* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			_tmp6_ = tpf_persona_store__persona_stores_by_account;
			if (_tmp6_ == NULL) {
				_tmp5_ = TRUE;
			} else {
				GeeHashMap* _tmp7_;
				TpfPersonaStore* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				gboolean _tmp11_ = FALSE;
				_tmp7_ = tpf_persona_store__persona_stores_by_account;
				_tmp8_ = store;
				_tmp9_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = gee_abstract_map_unset ((GeeAbstractMap*) _tmp7_, _tmp10_, NULL);
				_tmp5_ = !_tmp11_;
			}
			_tmp12_ = _tmp5_;
			if (_tmp12_) {
				{
					GeeHashMap* _tmp13_;
					_tmp13_ = tpf_persona_store__persona_stores_by_account;
					g_static_rec_mutex_unlock (&__lock_tpf_persona_store__persona_stores_by_account);
				}
				return;
			}
			_tmp14_ = store;
			g_signal_parse_name ("removed", FOLKS_TYPE_PERSONA_STORE, &_tmp15_, NULL, FALSE);
			g_signal_handlers_disconnect_matched ((FolksPersonaStore*) _tmp14_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp15_, 0, NULL, (GCallback) __tpf_persona_store_store_removed_cb_folks_persona_store_removed, NULL);
			_tmp16_ = tpf_persona_store__persona_stores_by_account;
			_tmp17_ = gee_abstract_map_get_size ((GeeMap*) _tmp16_);
			_tmp18_ = _tmp17_;
			if (_tmp18_ == 0) {
				_g_object_unref0 (tpf_persona_store__persona_stores_by_account_ro);
				tpf_persona_store__persona_stores_by_account_ro = NULL;
				_g_object_unref0 (tpf_persona_store__persona_stores_by_account);
				tpf_persona_store__persona_stores_by_account = NULL;
			}
		}
		__finally25:
		{
			GeeHashMap* _tmp19_;
			_tmp19_ = tpf_persona_store__persona_stores_by_account;
			g_static_rec_mutex_unlock (&__lock_tpf_persona_store__persona_stores_by_account);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
   * Look up a {@link Tpf.PersonaStore} by its {@link TelepathyGLib.Account}.
   *
   * If found, a new reference to the persona store will be returned. If not
   * found, a new {@link Tpf.PersonaStore} will be created for the account.
   *
   * See the documentation for {@link Tpf.PersonaStore.list_persona_stores} for
   * information on the lifecycle of these stores when a
   * {@link Folks.BackendStore} is and is not present.
   *
   * @param account the Telepathy account of the persona store
   * @return the persona store associated with the account
   * @since 0.6.6
   */
TpfPersonaStore* tpf_persona_store_dup_for_account (TpAccount* account) {
	TpfPersonaStore* result = NULL;
	TpfPersonaStore* store;
	TpAccount* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (account != NULL, NULL);
	store = NULL;
	_tmp0_ = account;
	g_debug ("tpf-persona-store.vala:2676: Tpf.PersonaStore.dup_for_account (%p):", _tmp0_);
	{
		GeeHashMap* _tmp1_;
		_tmp1_ = tpf_persona_store__persona_stores_by_account;
		g_static_rec_mutex_lock (&__lock_tpf_persona_store__persona_stores_by_account);
		{
			GeeHashMap* _tmp2_;
			TpfPersonaStore* _tmp7_;
			_tmp2_ = tpf_persona_store__persona_stores_by_account;
			if (_tmp2_ != NULL) {
				GeeHashMap* _tmp3_;
				TpAccount* _tmp4_;
				const gchar* _tmp5_ = NULL;
				gpointer _tmp6_ = NULL;
				_tmp3_ = tpf_persona_store__persona_stores_by_account;
				_tmp4_ = account;
				_tmp5_ = tp_proxy_get_object_path ((TpProxy*) _tmp4_);
				_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, _tmp5_);
				_g_object_unref0 (store);
				store = (TpfPersonaStore*) _tmp6_;
			}
			_tmp7_ = store;
			if (_tmp7_ == NULL) {
				TpAccount* _tmp8_;
				TpfPersonaStore* _tmp9_;
				g_debug ("tpf-persona-store.vala:2692:     Creating new PersonaStore.");
				_tmp8_ = account;
				_tmp9_ = tpf_persona_store_new (_tmp8_);
				_g_object_unref0 (store);
				store = _tmp9_;
			} else {
				TpfPersonaStore* _tmp10_;
				TpfPersonaStore* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				_tmp10_ = store;
				_tmp11_ = store;
				_tmp12_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp11_);
				_tmp13_ = _tmp12_;
				g_debug ("tpf-persona-store.vala:2697:     Found existing PersonaStore %p ('%s')" \
".", _tmp10_, _tmp13_);
			}
		}
		__finally26:
		{
			GeeHashMap* _tmp14_;
			_tmp14_ = tpf_persona_store__persona_stores_by_account;
			g_static_rec_mutex_unlock (&__lock_tpf_persona_store__persona_stores_by_account);
		}
		if (_inner_error_ != NULL) {
			_g_object_unref0 (store);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = store;
	return result;
}


TpAccount* tpf_persona_store_get_account (TpfPersonaStore* self) {
	TpAccount* result;
	TpAccount* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_account;
	result = _tmp0_;
	return result;
}


static void tpf_persona_store_set_account (TpfPersonaStore* self, TpAccount* value) {
	TpAccount* _tmp0_;
	TpAccount* _tmp1_;
	TpAccount* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_account);
	self->priv->_account = _tmp1_;
	_tmp2_ = self->priv->_account;
	g_signal_connect_object ((TpProxy*) _tmp2_, "invalidated", (GCallback) __tpf_persona_store_account_invalidated_cb_tp_proxy_invalidated, self, 0);
	g_object_notify ((GObject *) self, "account");
}


static const gchar* tpf_persona_store_real_get_type_id (FolksPersonaStore* base) {
	const gchar* result;
	TpfPersonaStore* self;
	self = (TpfPersonaStore*) base;
	result = BACKEND_NAME;
	return result;
}


static FolksMaybeBool tpf_persona_store_real_get_can_add_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	TpfPersonaStore* self;
	FolksMaybeBool _tmp0_;
	self = (TpfPersonaStore*) base;
	_tmp0_ = self->priv->_can_add_personas;
	result = _tmp0_;
	return result;
}


static FolksMaybeBool tpf_persona_store_real_get_can_alias_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	TpfPersonaStore* self;
	FolksMaybeBool _tmp0_;
	self = (TpfPersonaStore*) base;
	_tmp0_ = self->priv->_can_alias_personas;
	result = _tmp0_;
	return result;
}


static FolksMaybeBool tpf_persona_store_real_get_can_group_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	TpfPersonaStore* self;
	FolksMaybeBool _tmp0_;
	self = (TpfPersonaStore*) base;
	_tmp0_ = self->priv->_can_group_personas;
	result = _tmp0_;
	return result;
}


static FolksMaybeBool tpf_persona_store_real_get_can_remove_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	TpfPersonaStore* self;
	FolksMaybeBool _tmp0_;
	self = (TpfPersonaStore*) base;
	_tmp0_ = self->priv->_can_remove_personas;
	result = _tmp0_;
	return result;
}


static gboolean tpf_persona_store_real_get_is_prepared (FolksPersonaStore* base) {
	gboolean result;
	TpfPersonaStore* self;
	gboolean _tmp0_;
	self = (TpfPersonaStore*) base;
	_tmp0_ = self->priv->_is_prepared;
	result = _tmp0_;
	return result;
}


static gchar** tpf_persona_store_real_get_always_writeable_properties (FolksPersonaStore* base, int* result_length1) {
	gchar** result;
	TpfPersonaStore* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	self = (TpfPersonaStore*) base;
	_tmp0_ = TPF_PERSONA_STORE__always_writeable_properties;
	_tmp0__length1 = G_N_ELEMENTS (TPF_PERSONA_STORE__always_writeable_properties);
	if (result_length1) {
		*result_length1 = _tmp0__length1;
	}
	result = _tmp0_;
	return result;
}


static gboolean tpf_persona_store_real_get_is_quiescent (FolksPersonaStore* base) {
	gboolean result;
	TpfPersonaStore* self;
	gboolean _tmp0_;
	self = (TpfPersonaStore*) base;
	_tmp0_ = self->priv->_is_quiescent;
	result = _tmp0_;
	return result;
}


static GeeMap* tpf_persona_store_real_get_personas (FolksPersonaStore* base) {
	GeeMap* result;
	TpfPersonaStore* self;
	GeeMap* _tmp0_;
	self = (TpfPersonaStore*) base;
	_tmp0_ = self->priv->_personas_ro;
	result = _tmp0_;
	return result;
}


GeeSet* tpf_persona_store_get_supported_fields (TpfPersonaStore* self) {
	GeeSet* result;
	GeeSet* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->_supported_fields_ro;
	result = _tmp0_;
	return result;
}


static void g_cclosure_user_marshal_VOID__STRING_POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_POINTER_POINTER) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_POINTER_POINTER callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_POINTER_POINTER) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_pointer (param_values + 2), g_value_get_pointer (param_values + 3), data2);
}


static void g_cclosure_user_marshal_VOID__STRING_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_POINTER) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_POINTER callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_POINTER) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_pointer (param_values + 2), data2);
}


static GObject * tpf_persona_store_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	TpfPersonaStore * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	TpAccount* _tmp2_;
	TpAccount* _tmp3_;
	FolksDebug* _tmp4_ = NULL;
	FolksDebug* _tmp5_;
	TpfPersonaStoreCache* _tmp6_;
	parent_class = G_OBJECT_CLASS (tpf_persona_store_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = TPF_PERSONA_STORE (obj);
	_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = tpf_persona_store_get_account (self);
	_tmp3_ = _tmp2_;
	g_debug ("tpf-persona-store.vala:271: Creating new Tpf.PersonaStore %p ('%s') fo" \
"r TpAccount %p.", self, _tmp1_, _tmp3_);
	_tmp4_ = folks_debug_dup ();
	_g_object_unref0 (self->priv->_debug);
	self->priv->_debug = _tmp4_;
	_tmp5_ = self->priv->_debug;
	g_signal_connect_object (_tmp5_, "print-status", (GCallback) __tpf_persona_store_debug_print_status_folks_debug_print_status, self, 0);
	_tpf_persona_store_add_store_to_map (self);
	_tmp6_ = tpf_persona_store_cache_new (self);
	_g_object_unref0 (self->priv->_cache);
	self->priv->_cache = _tmp6_;
	_tpf_persona_store_reset (self);
	return obj;
}


static void tpf_persona_store_class_init (TpfPersonaStoreClass * klass) {
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_ = NULL;
	TpContactFeature* _tmp11_ = NULL;
	GQuark _tmp12_ = 0U;
	GQuark* _tmp13_ = NULL;
	tpf_persona_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TpfPersonaStorePrivate));
	FOLKS_PERSONA_STORE_CLASS (klass)->prepare = tpf_persona_store_real_prepare;
	FOLKS_PERSONA_STORE_CLASS (klass)->prepare_finish = tpf_persona_store_real_prepare_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->remove_persona = tpf_persona_store_real_remove_persona;
	FOLKS_PERSONA_STORE_CLASS (klass)->remove_persona_finish = tpf_persona_store_real_remove_persona_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->add_persona_from_details = tpf_persona_store_real_add_persona_from_details;
	FOLKS_PERSONA_STORE_CLASS (klass)->add_persona_from_details_finish = tpf_persona_store_real_add_persona_from_details_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_type_id = tpf_persona_store_real_get_type_id;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_add_personas = tpf_persona_store_real_get_can_add_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_alias_personas = tpf_persona_store_real_get_can_alias_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_group_personas = tpf_persona_store_real_get_can_group_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_remove_personas = tpf_persona_store_real_get_can_remove_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_is_prepared = tpf_persona_store_real_get_is_prepared;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_always_writeable_properties = tpf_persona_store_real_get_always_writeable_properties;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_is_quiescent = tpf_persona_store_real_get_is_quiescent;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_personas = tpf_persona_store_real_get_personas;
	G_OBJECT_CLASS (klass)->get_property = _vala_tpf_persona_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tpf_persona_store_set_property;
	G_OBJECT_CLASS (klass)->constructor = tpf_persona_store_constructor;
	G_OBJECT_CLASS (klass)->finalize = tpf_persona_store_finalize;
	/**
	   * The Telepathy account this store is based upon.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_ACCOUNT, g_param_spec_object ("account", "account", "account", tp_account_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * The type of persona store this is.
	   *
	   * See {@link Folks.PersonaStore.type_id}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_TYPE_ID, g_param_spec_string ("type-id", "type-id", "type-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can add {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_add_personas}.
	   *
	   * @since 0.3.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_CAN_ADD_PERSONAS, g_param_spec_enum ("can-add-personas", "can-add-personas", "can-add-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can set the alias of {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_alias_personas}.
	   *
	   * @since 0.3.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_CAN_ALIAS_PERSONAS, g_param_spec_enum ("can-alias-personas", "can-alias-personas", "can-alias-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can set the groups of {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_group_personas}.
	   *
	   * @since 0.3.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_CAN_GROUP_PERSONAS, g_param_spec_enum ("can-group-personas", "can-group-personas", "can-group-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can remove {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_remove_personas}.
	   *
	   * @since 0.3.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_CAN_REMOVE_PERSONAS, g_param_spec_enum ("can-remove-personas", "can-remove-personas", "can-remove-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore has been prepared.
	   *
	   * See {@link Folks.PersonaStore.is_prepared}.
	   *
	   * @since 0.3.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_IS_PREPARED, g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.2
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES, g_param_spec_boxed ("always-writeable-properties", "always-writeable-properties", "always-writeable-properties", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_IS_QUIESCENT, g_param_spec_boolean ("is-quiescent", "is-quiescent", "is-quiescent", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * The {@link Persona}s exposed by this PersonaStore.
	   *
	   * See {@link Folks.PersonaStore.personas}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_PERSONAS, g_param_spec_object ("personas", "personas", "personas", GEE_TYPE_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_SUPPORTED_FIELDS, g_param_spec_object ("supported-fields", "supported-fields", "supported-fields", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("group_members_changed", TPF_TYPE_PERSONA_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_POINTER_POINTER, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_POINTER, G_TYPE_POINTER);
	g_signal_new ("group_removed", TPF_TYPE_PERSONA_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_POINTER, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_POINTER);
	_tmp0_ = g_strdup ("org.freedesktop.Telepathy.Channel");
	tpf_persona_store__tp_channel_iface = _tmp0_;
	_tmp1_ = tpf_persona_store__tp_channel_iface;
	_tmp2_ = g_strconcat (_tmp1_, ".Type.ContactList", NULL);
	tpf_persona_store__tp_channel_contact_list_type = _tmp2_;
	_tmp3_ = tpf_persona_store__tp_channel_iface;
	_tmp4_ = g_strconcat (_tmp3_, ".ChannelType", NULL);
	tpf_persona_store__tp_channel_channel_type = _tmp4_;
	_tmp5_ = tpf_persona_store__tp_channel_iface;
	_tmp6_ = g_strconcat (_tmp5_, ".TargetHandleType", NULL);
	tpf_persona_store__tp_channel_handle_type = _tmp6_;
	_tmp7_ = g_strdup ("publish");
	_tmp8_ = g_strdup ("stored");
	_tmp9_ = g_strdup ("subscribe");
	_tmp10_ = g_new0 (gchar*, 3 + 1);
	_tmp10_[0] = _tmp7_;
	_tmp10_[1] = _tmp8_;
	_tmp10_[2] = _tmp9_;
	tpf_persona_store__undisplayed_groups = _tmp10_;
	tpf_persona_store__undisplayed_groups_length1 = 3;
	_tmp11_ = g_new0 (TpContactFeature, 7);
	_tmp11_[0] = TP_CONTACT_FEATURE_ALIAS;
	_tmp11_[1] = TP_CONTACT_FEATURE_AVATAR_DATA;
	_tmp11_[2] = TP_CONTACT_FEATURE_AVATAR_TOKEN;
	_tmp11_[3] = TP_CONTACT_FEATURE_CAPABILITIES;
	_tmp11_[4] = TP_CONTACT_FEATURE_CLIENT_TYPES;
	_tmp11_[5] = TP_CONTACT_FEATURE_PRESENCE;
	_tmp11_[6] = TP_CONTACT_FEATURE_CONTACT_INFO;
	tpf_persona_store__contact_features = _tmp11_;
	tpf_persona_store__contact_features_length1 = 7;
	_tmp12_ = tp_connection_get_feature_quark_contact_info ();
	_tmp13_ = g_new0 (GQuark, 2);
	_tmp13_[0] = _tmp12_;
	_tmp13_[1] = (GQuark) 0;
	tpf_persona_store__connection_features = _tmp13_;
	tpf_persona_store__connection_features_length1 = 2;
	g_static_rec_mutex_init (&__lock_tpf_persona_store__persona_stores_by_account);
}


static void tpf_persona_store_instance_init (TpfPersonaStore * self) {
	self->priv = TPF_PERSONA_STORE_GET_PRIVATE (self);
	self->priv->_can_add_personas = FOLKS_MAYBE_BOOL_UNSET;
	self->priv->_can_alias_personas = FOLKS_MAYBE_BOOL_UNSET;
	self->priv->_can_group_personas = FOLKS_MAYBE_BOOL_UNSET;
	self->priv->_can_remove_personas = FOLKS_MAYBE_BOOL_UNSET;
	g_static_rec_mutex_init (&self->priv->__lock__is_prepared);
	self->priv->_is_prepared = FALSE;
	self->priv->_prepare_pending = FALSE;
	self->priv->_is_quiescent = FALSE;
	self->priv->_got_stored_channel_members = FALSE;
	self->priv->_got_self_handle = FALSE;
	self->priv->_load_cache_cancellable = NULL;
	self->priv->_cached = FALSE;
}


static void tpf_persona_store_finalize (GObject* obj) {
	TpfPersonaStore * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	FolksDebug* _tmp2_;
	guint _tmp3_ = 0U;
	Logger* _tmp4_;
	TpAccount* _tmp7_;
	guint _tmp8_ = 0U;
	TpAccountManager* _tmp9_;
	self = TPF_PERSONA_STORE (obj);
	_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp1_ = _tmp0_;
	g_debug ("tpf-persona-store.vala:288: Destroying Tpf.PersonaStore %p ('%s').", self, _tmp1_);
	_tpf_persona_store_reset (self);
	_tpf_persona_store_remove_store_from_map (self);
	_tmp2_ = self->priv->_debug;
	g_signal_parse_name ("print-status", FOLKS_TYPE_DEBUG, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) __tpf_persona_store_debug_print_status_folks_debug_print_status, self);
	_g_object_unref0 (self->priv->_debug);
	self->priv->_debug = NULL;
	_tmp4_ = self->priv->_logger;
	if (_tmp4_ != NULL) {
		Logger* _tmp5_;
		guint _tmp6_ = 0U;
		_tmp5_ = self->priv->_logger;
		g_signal_parse_name ("invalidated", TYPE_LOGGER, &_tmp6_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) __tpf_persona_store_logger_invalidated_cb_logger_invalidated, self);
	}
	_tmp7_ = self->priv->_account;
	g_signal_parse_name ("invalidated", tp_proxy_get_type (), &_tmp8_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((TpProxy*) _tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) __tpf_persona_store_account_invalidated_cb_tp_proxy_invalidated, self);
	_tmp9_ = self->priv->_account_manager;
	if (_tmp9_ != NULL) {
		TpAccountManager* _tmp10_;
		guint _tmp11_ = 0U;
		_tmp10_ = self->priv->_account_manager;
		g_signal_parse_name ("invalidated", tp_proxy_get_type (), &_tmp11_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((TpProxy*) _tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) __tpf_persona_store_account_manager_invalidated_cb_tp_proxy_invalidated, self);
		_g_object_unref0 (self->priv->_account_manager);
		self->priv->_account_manager = NULL;
	}
	_g_object_unref0 (self->priv->_personas);
	_g_object_unref0 (self->priv->_personas_ro);
	_g_object_unref0 (self->priv->_persona_set);
	_g_object_unref0 (self->priv->_handle_persona_map);
	_g_object_unref0 (self->priv->_weakly_referenced_contacts);
	_g_object_unref0 (self->priv->_channel_group_personas_map);
	_g_object_unref0 (self->priv->_channel_group_incoming_adds);
	_g_object_unref0 (self->priv->_group_outgoing_adds);
	_g_object_unref0 (self->priv->_group_outgoing_removes);
	_g_object_unref0 (self->priv->_standard_channels_unready);
	_g_object_unref0 (self->priv->_group_channels_unready);
	_g_object_unref0 (self->priv->_groups);
	_g_object_unref0 (self->priv->_favourite_handles);
	_g_object_unref0 (self->priv->_publish);
	_g_object_unref0 (self->priv->_stored);
	_g_object_unref0 (self->priv->_subscribe);
	_g_object_unref0 (self->priv->_conn);
	_g_object_unref0 (self->priv->_account_manager);
	_g_object_unref0 (self->priv->_logger);
	_g_object_unref0 (self->priv->_self_contact);
	g_static_rec_mutex_free (&self->priv->__lock__is_prepared);
	_g_object_unref0 (self->priv->_debug);
	_g_object_unref0 (self->priv->_cache);
	_g_object_unref0 (self->priv->_load_cache_cancellable);
	_g_object_unref0 (self->_supported_fields);
	_g_object_unref0 (self->_supported_fields_ro);
	_g_object_unref0 (self->priv->_account);
	G_OBJECT_CLASS (tpf_persona_store_parent_class)->finalize (obj);
}


/**
 * A persona store which is associated with a single Telepathy account. It will
 * create {@link Persona}s for each of the contacts in the published, stored or
 * subscribed
 * [[http://people.collabora.co.uk/~danni/telepathy-book/chapter.channel.html|channels]]
 * of the account.
 */
GType tpf_persona_store_get_type (void) {
	static volatile gsize tpf_persona_store_type_id__volatile = 0;
	if (g_once_init_enter (&tpf_persona_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TpfPersonaStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tpf_persona_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TpfPersonaStore), 0, (GInstanceInitFunc) tpf_persona_store_instance_init, NULL };
		GType tpf_persona_store_type_id;
		tpf_persona_store_type_id = g_type_register_static (FOLKS_TYPE_PERSONA_STORE, "TpfPersonaStore", &g_define_type_info, 0);
		g_once_init_leave (&tpf_persona_store_type_id__volatile, tpf_persona_store_type_id);
	}
	return tpf_persona_store_type_id__volatile;
}


static void _vala_tpf_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TpfPersonaStore * self;
	self = TPF_PERSONA_STORE (object);
	switch (property_id) {
		case TPF_PERSONA_STORE_ACCOUNT:
		g_value_set_object (value, tpf_persona_store_get_account (self));
		break;
		case TPF_PERSONA_STORE_TYPE_ID:
		g_value_set_string (value, folks_persona_store_get_type_id ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_CAN_ADD_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_add_personas ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_CAN_ALIAS_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_alias_personas ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_CAN_GROUP_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_group_personas ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_CAN_REMOVE_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_remove_personas ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_IS_PREPARED:
		g_value_set_boolean (value, folks_persona_store_get_is_prepared ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_store_get_always_writeable_properties ((FolksPersonaStore*) self, &length));
		}
		break;
		case TPF_PERSONA_STORE_IS_QUIESCENT:
		g_value_set_boolean (value, folks_persona_store_get_is_quiescent ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_PERSONAS:
		g_value_set_object (value, folks_persona_store_get_personas ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_SUPPORTED_FIELDS:
		g_value_set_object (value, tpf_persona_store_get_supported_fields (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tpf_persona_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TpfPersonaStore * self;
	self = TPF_PERSONA_STORE (object);
	switch (property_id) {
		case TPF_PERSONA_STORE_ACCOUNT:
		tpf_persona_store_set_account (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



