# Copyright (c) 2012 The WebRTC project authors. All Rights Reserved.
#
# Use of this source code is governed by a BSD-style license
# that can be found in the LICENSE file in the root of the source
# tree. An additional intellectual property rights grant can be found
# in the file PATENTS.  All contributing project authors may
# be found in the AUTHORS file in the root of the source tree.

{
  'variables': {
    'codecs': [
      'cng',
      'g711',
      'pcm16b',
    ],
    'neteq_defines': [],
    'conditions': [
      ['include_ilbc==1', {
        'codecs': ['ilbc',],
        'neteq_defines': ['WEBRTC_CODEC_ILBC',],
      }],
      ['include_opus==1', {
        'codecs': ['webrtc_opus',],
        'neteq_defines': ['WEBRTC_CODEC_OPUS',],
      }],
      ['include_g722==1', {
        'codecs': ['g722',],
        'neteq_defines': ['WEBRTC_CODEC_G722',],
      }],
      ['include_isac==1', {
        'codecs': ['isac', 'isac_fix',],
        'neteq_defines': ['WEBRTC_CODEC_ISAC', 'WEBRTC_CODEC_ISACFIX',],
      }],
    ],
    'neteq_dependencies': [
      '<@(codecs)',
      '<(webrtc_root)/common_audio/common_audio.gyp:common_audio',
      '<(webrtc_root)/system_wrappers/system_wrappers.gyp:system_wrappers',
      'audio_decoder_interface',
    ],
  },
  'targets': [
    {
      'target_name': 'neteq',
      'type': 'static_library',
      'dependencies': [
        '<@(neteq_dependencies)',
        '<(webrtc_root)/common.gyp:webrtc_common',
        'builtin_audio_decoder_factory',
        'rent_a_codec',
      ],
      'defines': [
        '<@(neteq_defines)',
      ],
      'sources': [
        'include/neteq.h',
        'accelerate.cc',
        'accelerate.h',
        'audio_decoder_impl.cc',
        'audio_decoder_impl.h',
        'audio_multi_vector.cc',
        'audio_multi_vector.h',
        'audio_vector.cc',
        'audio_vector.h',
        'background_noise.cc',
        'background_noise.h',
        'buffer_level_filter.cc',
        'buffer_level_filter.h',
        'comfort_noise.cc',
        'comfort_noise.h',
        'cross_correlation.cc',
        'cross_correlation.h',
        'decision_logic.cc',
        'decision_logic.h',
        'decision_logic_fax.cc',
        'decision_logic_fax.h',
        'decision_logic_normal.cc',
        'decision_logic_normal.h',
        'decoder_database.cc',
        'decoder_database.h',
        'defines.h',
        'delay_manager.cc',
        'delay_manager.h',
        'delay_peak_detector.cc',
        'delay_peak_detector.h',
        'dsp_helper.cc',
        'dsp_helper.h',
        'dtmf_buffer.cc',
        'dtmf_buffer.h',
        'dtmf_tone_generator.cc',
        'dtmf_tone_generator.h',
        'expand.cc',
        'expand.h',
        'merge.cc',
        'merge.h',
        'nack_tracker.h',
        'nack_tracker.cc',
        'neteq_impl.cc',
        'neteq_impl.h',
        'neteq.cc',
        'statistics_calculator.cc',
        'statistics_calculator.h',
        'normal.cc',
        'normal.h',
        'packet.cc',
        'packet.h',
        'packet_buffer.cc',
        'packet_buffer.h',
        'red_payload_splitter.cc',
        'red_payload_splitter.h',
        'post_decode_vad.cc',
        'post_decode_vad.h',
        'preemptive_expand.cc',
        'preemptive_expand.h',
        'random_vector.cc',
        'random_vector.h',
        'rtcp.cc',
        'rtcp.h',
        'sync_buffer.cc',
        'sync_buffer.h',
        'tick_timer.cc',
        'tick_timer.h',
        'timestamp_scaler.cc',
        'timestamp_scaler.h',
        'time_stretch.cc',
        'time_stretch.h',
      ],
    },
  ], # targets
}
