
#ifndef cheddar_generated_mp4parse_h
#define cheddar_generated_mp4parse_h


#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>
#include <stdbool.h>

// THIS FILE IS AUTOGENERATED BY mp4parse-rust/build.rs - DO NOT EDIT

// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at https://mozilla.org/MPL/2.0/.

typedef enum mp4parse_status {
	mp4parse_status_OK = 0,
	mp4parse_status_BAD_ARG = 1,
	mp4parse_status_INVALID = 2,
	mp4parse_status_UNSUPPORTED = 3,
	mp4parse_status_EOF = 4,
	mp4parse_status_IO = 5,
	mp4parse_status_TABLE_TOO_LARGE = 6,
	mp4parse_status_OOM = 7,
} mp4parse_status;

typedef enum mp4parse_track_type {
	mp4parse_track_type_VIDEO = 0,
	mp4parse_track_type_AUDIO = 1,
} mp4parse_track_type;

typedef enum mp4parse_codec {
	mp4parse_codec_UNKNOWN,
	mp4parse_codec_AAC,
	mp4parse_codec_FLAC,
	mp4parse_codec_OPUS,
	mp4parse_codec_AVC,
	mp4parse_codec_VP9,
	mp4parse_codec_MP3,
	mp4parse_codec_MP4V,
	mp4parse_codec_JPEG,
	mp4parse_codec_AC3,
	mp4parse_codec_EC3,
} mp4parse_codec;

typedef struct mp4parse_track_info {
	mp4parse_track_type track_type;
	mp4parse_codec codec;
	uint32_t track_id;
	uint64_t duration;
	int64_t media_time;
} mp4parse_track_info;

typedef struct mp4parse_indice {
	uint64_t start_offset;
	uint64_t end_offset;
	int64_t start_composition;
	int64_t end_composition;
	int64_t start_decode;
	bool sync;
} mp4parse_indice;

typedef struct mp4parse_byte_data {
	uint32_t length;
	uint8_t const* data;
	mp4parse_indice const* indices;
} mp4parse_byte_data;

typedef struct mp4parse_pssh_info {
	mp4parse_byte_data data;
} mp4parse_pssh_info;

typedef struct mp4parse_sinf_info {
	uint32_t is_encrypted;
	uint8_t iv_size;
	mp4parse_byte_data kid;
} mp4parse_sinf_info;

typedef struct mp4parse_track_audio_info {
	uint16_t channels;
	uint16_t bit_depth;
	uint32_t sample_rate;
	uint16_t profile;
	mp4parse_byte_data codec_specific_config;
	mp4parse_byte_data extra_data;
	mp4parse_sinf_info protected_data;
} mp4parse_track_audio_info;

typedef struct mp4parse_track_video_info {
	uint32_t display_width;
	uint32_t display_height;
	uint16_t image_width;
	uint16_t image_height;
	uint16_t rotation;
	mp4parse_byte_data extra_data;
	mp4parse_sinf_info protected_data;
} mp4parse_track_video_info;

typedef struct mp4parse_fragment_info {
	uint64_t fragment_duration;
} mp4parse_fragment_info;

typedef struct mp4parse_parser mp4parse_parser;

typedef struct mp4parse_io {
	intptr_t (*read)(uint8_t* buffer, uintptr_t size, void* userdata);
	void* userdata;
} mp4parse_io;

/// Allocate an `mp4parse_parser*` to read from the supplied `mp4parse_io`.
mp4parse_parser* mp4parse_new(mp4parse_io const* io);

/// Free an `mp4parse_parser*` allocated by `mp4parse_new()`.
void mp4parse_free(mp4parse_parser* parser);

/// Enable `mp4_parser` log.
void mp4parse_log(bool enable);

void mp4parse_fallible_allocation(bool enable);

/// Run the `mp4parse_parser*` allocated by `mp4parse_new()` until EOF or error.
mp4parse_status mp4parse_read(mp4parse_parser* parser);

/// Return the number of tracks parsed by previous `mp4parse_read()` call.
mp4parse_status mp4parse_get_track_count(mp4parse_parser const* parser, uint32_t* count);

/// Fill the supplied `mp4parse_track_info` with metadata for `track`.
mp4parse_status mp4parse_get_track_info(mp4parse_parser* parser, uint32_t track_index, mp4parse_track_info* info);

/// Fill the supplied `mp4parse_track_audio_info` with metadata for `track`.
mp4parse_status mp4parse_get_track_audio_info(mp4parse_parser* parser, uint32_t track_index, mp4parse_track_audio_info* info);

/// Fill the supplied `mp4parse_track_video_info` with metadata for `track`.
mp4parse_status mp4parse_get_track_video_info(mp4parse_parser* parser, uint32_t track_index, mp4parse_track_video_info* info);

mp4parse_status mp4parse_get_indice_table(mp4parse_parser* parser, uint32_t track_id, mp4parse_byte_data* indices);

/// Fill the supplied `mp4parse_fragment_info` with metadata from fragmented file.
mp4parse_status mp4parse_get_fragment_info(mp4parse_parser* parser, mp4parse_fragment_info* info);

/// A fragmented file needs mvex table and contains no data in stts, stsc, and stco boxes.
mp4parse_status mp4parse_is_fragmented(mp4parse_parser* parser, uint32_t track_id, uint8_t* fragmented);

/// Get 'pssh' system id and 'pssh' box content for eme playback.
///
/// The data format of the `info` struct passed to gecko is:
///
/// - system id (16 byte uuid)
/// - pssh box size (32-bit native endian)
/// - pssh box content (including header)
mp4parse_status mp4parse_get_pssh_info(mp4parse_parser* parser, mp4parse_pssh_info* info);



#ifdef __cplusplus
}
#endif


#endif
