/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef GFX_WEBRENDERIMAGELAYER_H
#define GFX_WEBRENDERIMAGELAYER_H

#include "ImageLayers.h"
#include "mozilla/layers/WebRenderLayer.h"
#include "mozilla/layers/WebRenderLayerManager.h"

namespace mozilla {
namespace layers {

class ImageClient;

class WebRenderImageLayer : public WebRenderLayer,
                            public ImageLayer {
public:
  explicit WebRenderImageLayer(WebRenderLayerManager* aLayerManager);

  virtual already_AddRefed<gfx::SourceSurface> GetAsSourceSurface() override;

  virtual void ClearCachedResources() override;

  virtual bool SupportsAsyncUpdate() override;

protected:
  virtual ~WebRenderImageLayer();

public:
  Layer* GetLayer() override { return this; }
  void RenderLayer(wr::DisplayListBuilder& aBuilder,
                   wr::IpcResourceUpdateQueue& aResources,
                   const StackingContextHelper& aSc) override;
  Maybe<wr::WrImageMask> RenderMaskLayer(const StackingContextHelper& aSc,
                                         const gfx::Matrix4x4& aTransform,
                                         wr::IpcResourceUpdateQueue& aResources) override;

protected:
  CompositableType GetImageClientType();
  void ClearWrResources();

  void AddWRVideoImage(size_t aChannelNumber);

  Maybe<wr::ImageKey>
  UpdateImageKey(ImageClientSingle* aImageClient,
                 ImageContainer* aContainer,
                 Maybe<wr::ImageKey>& aOldKey,
                 wr::ExternalImageId& aExternalImageId,
                 wr::IpcResourceUpdateQueue& aResources);

  wr::MaybeExternalImageId mExternalImageId;
  Maybe<wr::ImageKey> mKey;
  RefPtr<ImageClient> mImageClient;
  CompositableType mImageClientContainerType;
  Maybe<wr::PipelineId> mPipelineId;
};

} // namespace layers
} // namespace mozilla

#endif // GFX_WEBRENDERIMAGELAYER_H
