// Copyright (C) 2016 the V8 project authors. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.
/*---
esid: sec-%typedarray%.prototype.reduceright
description: >
  callbackfn `this` value
info: >
  22.2.3.21 %TypedArray%.prototype.reduceRight ( callbackfn [ , initialValue ] )

  %TypedArray%.prototype.reduceRight is a distinct function that implements the
  same algorithm as Array.prototype.reduceRight as defined in 22.1.3.20 except
  that the this object's [[ArrayLength]] internal slot is accessed in place of
  performing a [[Get]] of "length".

  22.1.3.20 Array.prototype.reduceRight ( callbackfn [ , initialValue ] )

  ...
  8. Repeat, while k ≥ 0
    ...
    c. If kPresent is true, then
      i. Let kValue be ? Get(O, Pk).
      ii. Let accumulator be ? Call(callbackfn, undefined, « accumulator,
      kValue, k, O »).
    d. Decrease k by 1.
  ...
includes: [testTypedArray.js]
---*/

var expected = (function() { return this; })();

testWithTypedArrayConstructors(function(TA) {
  var sample = new TA(3);

  var results = [];

  sample.reduceRight(function() {
    results.push(this);
  }, 0);

  assert.sameValue(results.length, 3, "results.length");
  assert.sameValue(results[0], expected, "[0]");
  assert.sameValue(results[1], expected, "[1]");
  assert.sameValue(results[2], expected, "[2]");
});

reportCompare(0, 0);
