/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

"use strict";

this.EXPORTED_SYMBOLS = [ "isAddonPartOfE10SRollout" ];

const Cu = Components.utils;
Cu.import("resource://gre/modules/Preferences.jsm");
Cu.import("resource://gre/modules/Services.jsm");

const PREF_E10S_ADDON_BLOCKLIST = "extensions.e10s.rollout.blocklist";
const PREF_E10S_ADDON_POLICY    = "extensions.e10s.rollout.policy";

const ADDONS = {
  "Greasemonkey": { // Greasemonkey
    id: "{e4a8a97b-f2ed-450b-b12d-ee082ba24781}", minVersion: "3.8",
  },

  "DYTV": { // Download YouTube Videos as MP4
    id: "{b9bfaf1c-a63f-47cd-8b9a-29526ced9060}", minVersion: "1.8.7",
  },

  "VDH": { // Video Download Helper
    id: "{b9db16a4-6edc-47ec-a1f4-b86292ed211d}", minVersion: "5.6.1",
  },

  "Lightbeam": { // Lightbeam
    id: "jid1-F9UJ2thwoAm5gQ@jetpack", minVersion: "1.3.0.1",
  },

  "ABP": { // Adblock Plus
    id: "{d10d0bf8-f5b5-c8b4-a8b2-2b9879e08c5d}", minVersion: "2.7.3",
  },

  "uBlockOrigin": { // uBlock Origin
    id: "uBlock0@raymondhill.net", minVersion: "1.7.6",
  },

  "Emoji": { // Emoji Cheatsheet
    id: "jid1-Xo5SuA6qc1DFpw@jetpack", minVersion: "1.1.1",
  },

  "ASP": { // Awesome Screenshot Plus
    id: "jid0-GXjLLfbCoAx0LcltEdFrEkQdQPI@jetpack", minVersion: "3.0.10",
  },

  "PersonasPlus": { // PersonasPlus
    id: "personas@christopher.beard", minVersion: "1.8.0",
  },

  "ACR": { // Add-on Compatibility Reporter
    id: "compatibility@addons.mozilla.org", minVersion: "2.2.0",
  },

  // Add-ons used for testing
  "test1": {
    id: "bootstrap1@tests.mozilla.org", minVersion: "1.0",
  },

  "test2": {
    id: "bootstrap2@tests.mozilla.org", minVersion: "1.0",
  },
};

// NOTE: Do not modify sets or policies after they have already been
// published to users. They must remain unchanged to provide valid data.

// Set 2 used during 48 Beta cycle. Kept here for historical reasons.
const set2 = [ADDONS.Greasemonkey,
              ADDONS.DYTV,
              ADDONS.VDH,
              ADDONS.Lightbeam,
              ADDONS.ABP,
              ADDONS.uBlockOrigin,
              ADDONS.Emoji,
              ADDONS.ASP,
              ADDONS.PersonasPlus];

const set49Release = [
  ADDONS.Greasemonkey,
  ADDONS.DYTV,
  ADDONS.VDH,
  ADDONS.Lightbeam,
  ADDONS.ABP,
  ADDONS.uBlockOrigin,
  ADDONS.Emoji,
  ADDONS.ASP,
  ADDONS.PersonasPlus,
  ADDONS.ACR
];

// These are only the add-ons in the Add-Ons Manager Discovery
// pane. This set is here in case we need to reduce add-ons
// exposure live on Release.
const set49PaneOnly = [
  ADDONS.ABP,
  ADDONS.VDH,
  ADDONS.Emoji,
  ADDONS.ASP,
  ADDONS.ACR
]

// ================== ADDONS FOR 51 RELEASE ==================
//
// During the 51 beta cycle, we tested e10s with all addons
// except those explicitly marked as being incompatible.
// For release, instead of opening this up, we assembled
// the lists below with all addons that were seen on beta
// and had over 50 installs.
//
// This list is in a new format to allow fast access and also
// to allow controlling by the number of addons installed.

const set51Release = {
  "_65Members_@download.fromdoctopdf.com": {minVersion: "7.102.10.4221", installs: 32092},
  "light_plugin_ACF0E80077C511E59DED005056C00008@kaspersky.com": {minVersion: "4.6.3-15", installs: 27758},
  "_ceMembers_@free.easypdfcombine.com": {minVersion: "7.102.10.4117", installs: 17797},
  "caa1-aDOiCAxFFMOVIX@jetpack": {minVersion: "0.1.7", installs: 13150},
  "{4ED1F68A-5463-4931-9384-8FFF5ED91D92}": {minVersion: "5.0.248.0", installs: 12774},
  "_dbMembers_@free.getformsonline.com": {minVersion: "7.102.10.4251", installs: 11909},
  "_4zMembers_@www.videodownloadconverter.com": {minVersion: "7.102.10.5033", installs: 11612},
  "light_plugin_F6F079488B53499DB99380A7E11A93F6@kaspersky.com": {minVersion: "5.0.141-4-20161031140250", installs: 10944},
  "YoutubeDownloader@PeterOlayev.com": {minVersion: "2.4.1", installs: 10722},
  "{82AF8DCA-6DE9-405D-BD5E-43525BDAD38A}": {minVersion: "8.0.0.9103", installs: 8856},
  "client@anonymox.net": {minVersion: "2.5.2", installs: 8225},
  "_8hMembers_@download.allin1convert.com": {minVersion: "7.102.10.3584", installs: 7681},
  "light_plugin_D772DC8D6FAF43A29B25C4EBAA5AD1DE@kaspersky.com": {minVersion: "4.6.2-42-20160922074409", installs: 7177},
  "_dzMembers_@www.pconverter.com": {minVersion: "7.102.10.4851", installs: 7115},
  "fxdevtools-adapters@mozilla.org": {minVersion: "0.3.5", installs: 6926},
  "_9pMembers_@free.onlinemapfinder.com": {minVersion: "7.102.10.4836", installs: 6583},
  "@DownloadManager": {minVersion: "0.2.1", installs: 6412},
  "ar1er-ewrgfdgomusix@jetpack": {minVersion: "1.0.6", installs: 5975},
  "_agMembers_@free.premierdownloadmanager.com": {minVersion: "7.102.10.4846", installs: 5605},
  "_paMembers_@www.filmfanatic.com": {minVersion: "7.102.10.4163", installs: 5448},
  "_gtMembers_@free.gamingwonderland.com": {minVersion: "7.102.10.4263", installs: 5241},
  "LVD-SAE@iacsearchandmedia.com": {minVersion: "8.5", installs: 4694},
  "_fsMembers_@free.pdfconverterhq.com": {minVersion: "7.102.10.4849", installs: 4526},
  "_6xMembers_@www.readingfanatic.com": {minVersion: "7.102.10.4914", installs: 4417},
  "@mysmartprice-ff": {minVersion: "0.0.6", installs: 4381},
  "jid1-YcMV6ngYmQRA2w@jetpack": {minVersion: "1.37.9", installs: 3899},
  "{58d735b4-9d6c-4e37-b146-7b9f7e79e318}": {minVersion: "1.6", installs: 3733},
  "anttoolbar@ant.com": {minVersion: "2.4.7.47", installs: 3720},
  "adblockpopups@jessehakanen.net": {minVersion: "0.9.2.1-signed.1-signed", installs: 3602},
  "ERAIL.IN.FFPLUGIN@jetpack": {minVersion: "6.0.rev142", installs: 3545},
  "WebProtection@360safe.com": {minVersion: "5.0.0.1005", installs: 3475},
  "yasearch@yandex.ru": {minVersion: "8.20.4", installs: 3299},
  "{19503e42-ca3c-4c27-b1e2-9cdb2170ee34}": {minVersion: "1.5.6.14", installs: 3106},
  "{C1A2A613-35F1-4FCF-B27F-2840527B6556}": {minVersion: "2016.8.1.9", installs: 3083},
  "_b7Members_@free.mytransitguide.com": {minVersion: "7.102.10.4812", installs: 3011},
  "_9tMembers_@free.internetspeedtracker.com": {minVersion: "7.102.10.4339", installs: 2828},
  "_64Members_@www.televisionfanatic.com": {minVersion: "7.102.10.4968", installs: 2821},
  "info@youtube-mp3.org": {minVersion: "1.0.9.1-signed.1-signed", installs: 2717},
  "ffext_basicvideoext@startpage24": {minVersion: "1.97.37.1-signed.1-signed", installs: 2663},
  "MUB-SAE@iacsearchandmedia.com": {minVersion: "8.7", installs: 2650},
  "_4jMembers_@www.radiorage.com": {minVersion: "7.102.10.4916", installs: 2631},
  "@Email": {minVersion: "4.0.12", installs: 2583},
  "_gcMembers_@www.weatherblink.com": {minVersion: "7.38.8.56523", installs: 2519},
  "_dqMembers_@www.downspeedtest.com": {minVersion: "7.102.10.3827", installs: 2445},
  "translator@zoli.bod": {minVersion: "2.1.0.5.1.1-signed", installs: 2310},
  "{a38384b3-2d1d-4f36-bc22-0f7ae402bcd7}": {minVersion: "1.0.0.51", installs: 2190},
  "_1eMembers_@www.videoscavenger.com": {minVersion: "7.38.8.45273", installs: 2185},
  "tvplusnewtab-the-extension1@mozilla.com": {minVersion: "0.1.5", installs: 2155},
  "homepage@mail.ru": {minVersion: "1.0.2", installs: 2124},
  "search@mail.ru": {minVersion: "1.0.7", installs: 2038},
  "_69Members_@www.packagetracer.com": {minVersion: "7.102.10.4831", installs: 2036},
  "{7b8a500a-a464-4624-bd4f-73eaafe0f766}": {minVersion: "3", installs: 2027},
  "paulsaintuzb@gmail.com": {minVersion: "8.2.1", installs: 2005},
  "k7srff_enUS@k7computing.com": {minVersion: "2.4", installs: 1929},
  "_e5Members_@www.productivityboss.com": {minVersion: "7.38.8.46590", installs: 1892},
  "vdpure@link64": {minVersion: "1.97.43", installs: 1860},
  "_9tMembers_@download.internetspeedtracker.com": {minVersion: "7.38.8.56171", installs: 1824},
  "_g3Members_@free.easyphotoedit.com": {minVersion: "7.102.10.4108", installs: 1822},
  "_64Members_@download.televisionfanatic.com": {minVersion: "7.38.9.3004", installs: 1730},
  "_8iMembers_@download.audiotoaudio.com": {minVersion: "7.102.10.3585", installs: 1704},
  "adblockultimate@adblockultimate.net": {minVersion: "2.25", installs: 1648},
  "eagleget_ffext@eagleget.com": {minVersion: "3.8", installs: 1640},
  "_9eMembers_@free.findmefreebies.com": {minVersion: "7.102.10.4193", installs: 1638},
  "content_blocker_663BE8@kaspersky.com": {minVersion: "4.5.4.19.1", installs: 1625},
  "virtual_keyboard_074028@kaspersky.com": {minVersion: "4.5.4.19.1", installs: 1624},
  "browsec@browsec.com": {minVersion: "2.0.3", installs: 1610},
  "@Maps": {minVersion: "4.0.0", installs: 1587},
  "_exMembers_@free.easydocmerge.com": {minVersion: "7.102.10.4137", installs: 1493},
  "{635abd67-4fe9-1b23-4f01-e679fa7484c1}": {minVersion: "5.0.2", installs: 1490},
  "abb@amazon.com": {minVersion: "10.1612.1.304", installs: 1463},
  "{1BC9BA34-1EED-42ca-A505-6D2F1A935BBB}": {minVersion: "6.2.18.1", installs: 1436},
  "mp4downloader@jeff.net": {minVersion: "1.3.3.1-signed.1-signed", installs: 1410},
  "jid1-16aeif9OQIRKxA@jetpack": {minVersion: "1.1.4", installs: 1399},
  "{c45c406e-ab73-11d8-be73-000a95be3b12}": {minVersion: "1.2.11", installs: 1367},
  "online_banking_08806E@kaspersky.com": {minVersion: "4.5.4.19.1", installs: 1356},
  "_ewMembers_@free.mergedocsonline.com": {minVersion: "7.102.10.4710", installs: 1337},
  "@DiscreteSearch": {minVersion: "0.2.1", installs: 1306},
  "{6AC85730-7D0F-4de0-B3FA-21142DD85326}": {minVersion: "2.8.2", installs: 1286},
  "{063DA41A-2561-401B-91FA-AC75E460F4EB}": {minVersion: "1.0.7.1", installs: 1280},
  "netvideohunter@netvideohunter.com": {minVersion: "1.2", installs: 1260},
  "_8eMembers_@download.howtosimplified.com": {minVersion: "7.102.10.4285", installs: 1230},
  "FGZ-SAE@iacsearchandmedia.com": {minVersion: "8.5", installs: 1220},
  "adguardadblocker@adguard.com": {minVersion: "2.4.14", installs: 1172},
  "_39Members_@www.mapsgalaxy.com": {minVersion: "7.102.10.4730", installs: 1171},
  "_euMembers_@free.filesendsuite.com": {minVersion: "7.102.10.4154", installs: 1166},
  "_brMembers_@free.yourtemplatefinder.com": {minVersion: "7.102.10.5047", installs: 1159},
  "_8jMembers_@download.myimageconverter.com": {minVersion: "7.102.10.4778", installs: 1150},
  "_12Members_@free.myscrapnook.com": {minVersion: "7.102.10.4739", installs: 1113},
  "_7eMembers_@www.homeworksimplified.com": {minVersion: "7.102.10.4290", installs: 1109},
  "{fe272bd1-5f76-4ea4-8501-a05d35d823fc}": {minVersion: "2.1.9.1-signed.1-let-fixed.1-signed", installs: 1108},
  "_frMembers_@free.testforspeed.com": {minVersion: "7.102.10.4993", installs: 1107},
  "{068e178c-61a9-4a63-b74f-87404a6f5ea1}": {minVersion: "2", installs: 1104},
  "@Package": {minVersion: "0.2.0", installs: 1092},
  "6asa42dfa4784fsf368g@youtubeconverter.me": {minVersion: "0.1", installs: 1071},
  "_diMembers_@www.free.easymaillogin.com": {minVersion: "7.102.10.4112", installs: 1043},
  "_v4Members_@www.dictionaryboss.com": {minVersion: "7.102.10.3797", installs: 1035},
  "colorPicker@colorPicker": {minVersion: "3.0.1-signed.1-signed", installs: 1023},
  "hotspot-shield@anchorfree.com": {minVersion: "1.2.87", installs: 1000},
  "manishjain9@hotmail.com_easiestyoutube": {minVersion: "7.2.1-signed.1-let-fixed.1-signed", installs: 993},
  "{cd617375-6743-4ee8-bac4-fbf10f35729e}": {minVersion: "2.9.6", installs: 987},
  "@Converter": {minVersion: "4.1.0", installs: 986},
  "{dd3d7613-0246-469d-bc65-2a3cc1668adc}": {minVersion: "1.1.8.1-signed.1-signed", installs: 983},
  "ubufox@ubuntu.com": {minVersion: "3.2", installs: 950},
  "jid1-lpoiffmusixlib@jetpack": {minVersion: "0.1.9", installs: 945},
  "_5aMembers_@download.mywebface.com": {minVersion: "7.102.10.4837", installs: 930},
  "leethax@leethax.net": {minVersion: "2016.12.02", installs: 930},
  "{1A2D0EC4-75F5-4c91-89C4-3656F6E44B68}": {minVersion: "0.6.3.1-signed.1-signed", installs: 885},
  "{64161300-e22b-11db-8314-0800200c9a66}": {minVersion: "0.9.6.18", installs: 875},
  "_bfMembers_@free.snapmyscreen.com": {minVersion: "7.102.10.4951", installs: 827},
  "uriloader@pdf.js": {minVersion: "1.0.277.1-signed.1-signed", installs: 815},
  "{e968fc70-8f95-4ab9-9e79-304de2a71ee1}": {minVersion: "0.7.3.1-signed.1-signed", installs: 805},
  "save-as-pdf-ff@pdfcrowd.com": {minVersion: "1.5.1-signed.1-signed", installs: 804},
  "{75CEEE46-9B64-46f8-94BF-54012DE155F0}": {minVersion: "0.4.15", installs: 794},
  "safesearchplus2@avira.com": {minVersion: "1.4.1.371", installs: 786},
  "easyscreenshot@mozillaonline.com": {minVersion: "1.2.8", installs: 785},
  "_eeMembers_@download.freeradiocast.com": {minVersion: "7.38.8.46366", installs: 783},
  "_89Members_@download.safepcrepair.com": {minVersion: "7.39.8.51080", installs: 777},
  "{a3a5c777-f583-4fef-9380-ab4add1bc2a5}": {minVersion: "2.4.2.1-signed", installs: 771},
  "content_blocker@kaspersky.com": {minVersion: "4.0.10.15", installs: 770},
  "safesearch@avira.com": {minVersion: "1.4.1.371", installs: 767},
  "youtube2mp3@mondayx.de": {minVersion: "1.2.3.1-signed.1-signed", installs: 748},
  "2020Player_IKEA@2020Technologies.com": {minVersion: "5.0.94.1", installs: 736},
  "_edMembers_@free.myradioaccess.com": {minVersion: "7.102.10.4797", installs: 734},
  "_dmMembers_@free.gounzip.com": {minVersion: "7.102.10.4277", installs: 733},
  "Media-Newtab-the-extension1@mozilla.com": {minVersion: "0.1.6", installs: 732},
  "foxmarks@kei.com": {minVersion: "4.3.19", installs: 728},
  "{e8deb9e5-5688-4655-838a-b7a121a9f16e}": {minVersion: "48.4", installs: 726},
  "{195A3098-0BD5-4e90-AE22-BA1C540AFD1E}": {minVersion: "4.1.0.1-signed.1-signed", installs: 722},
  "jid1-4P0kohSJxU1qGg@jetpack": {minVersion: "1.22.550", installs: 719},
  "DailymotionVideoDownloader@PeterOlayev.com": {minVersion: "1.0.6.1-signed.1-signed", installs: 717},
  "jid1-P34HaABBBpOerQ@jetpack": {minVersion: "0.2.1-signed.1-signed", installs: 715},
  "SQLiteManager@mrinalkant.blogspot.com": {minVersion: "0.8.3.1-signed.1-signed", installs: 700},
  "2.0@disconnect.me": {minVersion: "3.15.3.1-signed.1-signed", installs: 693},
  "multifox@hultmann": {minVersion: "3.2.3", installs: 690},
  "_5mMembers_@download.myfuncards.com": {minVersion: "7.102.10.4783", installs: 679},
  "_btMembers_@free.catsandcatapults.com": {minVersion: "7.102.10.3677", installs: 673},
  "pavel.sherbakov@gmail.com": {minVersion: "19.1.1", installs: 666},
  "_fbMembers_@free.smarterpassword.com": {minVersion: "7.102.10.4936", installs: 644},
  "jid2-l8SPBzHJWBIiHQ@jetpack": {minVersion: "3.1", installs: 639},
  "{B17C1C5A-04B1-11DB-9804-B622A1EF5492}": {minVersion: "1.3.2", installs: 633},
  "myplaycitycom@gametab": {minVersion: "1.6", installs: 616},
  "{ad0d925d-88f8-47f1-85ea-8463569e756e}": {minVersion: "2.0.5", installs: 604},
  "{37964A3C-4EE8-47b1-8321-34DE2C39BA4D}": {minVersion: "2.5.4.174", installs: 603},
  "youtubemp3podcaster@jeremy.d.gregorio.com": {minVersion: "3.9.0", installs: 601},
  "caa1-aDOiCAxFFPRIVATE@jetpack": {minVersion: "0.2.0", installs: 598},
  "_f5Members_@free.typingfanatic.com": {minVersion: "7.102.10.5014", installs: 595},
  "_94Members_@www.motitags.com": {minVersion: "7.102.10.4744", installs: 594},
  "{888d99e7-e8b5-46a3-851e-1ec45da1e644}": {minVersion: "45.0.0", installs: 581},
  "_1cMembers_@www.bringmesports.com": {minVersion: "7.102.10.3646", installs: 580},
  "{a6fd85ed-e919-4a43-a5af-8da18bda539f}": {minVersion: "2.9.1.1-signed", installs: 572},
  "{0fc22c4c-93ed-48ea-ad12-dc8039cf3795}": {minVersion: "1.3", installs: 568},
  "homeutil@yandex.ru": {minVersion: "1.0.13", installs: 565},
  "_doMembers_@free.convertanyfile.com": {minVersion: "7.38.8.45860", installs: 563},
  "SocialNewPages-the-extension1@mozilla.com": {minVersion: "0.1.9", installs: 561},
  "wappalyzer@crunchlabz.com": {minVersion: "3.2.7", installs: 557},
  "_5qMembers_@www.zwinky.com": {minVersion: "7.38.8.45270", installs: 551},
  "{0545b830-f0aa-4d7e-8820-50a4629a56fe}": {minVersion: "31.0.9", installs: 531},
  "vk@sergeykolosov.mp": {minVersion: "0.3.9.5", installs: 522},
  "{77b819fa-95ad-4f2c-ac7c-486b356188a9}": {minVersion: "4.0.20130422.1-signed.1-signed", installs: 505},
  "@true-key": {minVersion: "1.23.0.2433", installs: 501},
  "_1pMembers_@www.referenceboss.com": {minVersion: "7.102.10.4932", installs: 499},
  "{C7AE725D-FA5C-4027-BB4C-787EF9F8248A}": {minVersion: "1.0.0.4", installs: 494},
  "alx-ffdeveloper@amazon.com": {minVersion: "3.0.2", installs: 493},
  "{3d7eb24f-2740-49df-8937-200b1cc08f8a}": {minVersion: "1.5.20", installs: 491},
  "_1gMembers_@www.inboxace.com": {minVersion: "7.38.8.56535", installs: 488},
  "{7DD78D43-0962-4d9b-BC76-ABF13B3B2ED1}": {minVersion: "3.5.0.1428", installs: 484},
  "imageblock@hemantvats.com": {minVersion: "3.1", installs: 472},
  "online_banking@kaspersky.com": {minVersion: "4.0.10.15", installs: 463},
  "virtual_keyboard@kaspersky.com": {minVersion: "4.0.10.15", installs: 463},
  "button@scholar.google.com": {minVersion: "1.1.1-signed.1-signed", installs: 463},
  "anti_banner@kaspersky.com": {minVersion: "4.0.10.15", installs: 462},
  "url_advisor@kaspersky.com": {minVersion: "4.0.10.15", installs: 461},
  "{6d96bb5e-1175-4ebf-8ab5-5f56f1c79f65}": {minVersion: "0.9.8", installs: 457},
  "_14Members_@download.totalrecipesearch.com": {minVersion: "7.102.10.4983", installs: 456},
  "{394DCBA4-1F92-4f8e-8EC9-8D2CB90CB69B}": {minVersion: "5.1.1", installs: 447},
  "_57Members_@free.marineaquariumfree.com": {minVersion: "7.102.10.4716", installs: 446},
  "e67f8350-7edf-11e3-baa7-0800200c9a66@fri-gate.org": {minVersion: "2.2.1.1-signed", installs: 446},
  "FireXPath@pierre.tholence.com": {minVersion: "0.9.7.1.1-signed.1-signed", installs: 442},
  "@youtube_downloader": {minVersion: "0.0.9", installs: 435},
  "ff_hpset@jetpack": {minVersion: "1.0.8", installs: 428},
  "{d0bfdcce-52c7-4b32-bb45-948f62db8d3f}": {minVersion: "49.1", installs: 406},
  "_j2Members_@www.soccerinferno.com": {minVersion: "7.102.10.4948", installs: 405},
  "autoform@olifozzy": {minVersion: "1.2.4.1-signed.1-signed", installs: 405},
  "FunSafeTab-the-extension1@mozilla.com": {minVersion: "0.1.9", installs: 405},
  "testpilot@labs.mozilla.com": {minVersion: "1.2.3.1-signed", installs: 405},
  "vwof@drev.com": {minVersion: "3.1.2", installs: 401},
  "_ftMembers_@free.mytelevisionhq.com": {minVersion: "7.102.10.4817", installs: 397},
  "{e001c731-5e37-4538-a5cb-8168736a2360}": {minVersion: "0.9.9.152", installs: 396},
  "{95E84BD3-3604-4AAC-B2CA-D9AC3E55B64B}": {minVersion: "2.0.0.78", installs: 393},
  "_8lMembers_@free.filesharefanatic.com": {minVersion: "7.102.10.4171", installs: 389},
  "clipconverter@clipconverter.cc": {minVersion: "1.5.2", installs: 387},
  "_7jMembers_@download.gardeningenthusiast.com": {minVersion: "7.102.10.4260", installs: 383},
  "antmark@ant.com": {minVersion: "1.1.14", installs: 383},
  "_flMembers_@free.myformsfinder.com": {minVersion: "7.102.10.4784", installs: 381},
  "{c36177c0-224a-11da-8cd6-0800200c9a91}": {minVersion: "3.9.85.1-signed.1-signed", installs: 375},
  "@searchincognito": {minVersion: "0.1.0", installs: 375},
  "{f13b157f-b174-47e7-a34d-4815ddfdfeb8}": {minVersion: "0.9.89.1-signed.1-signed", installs: 373},
  "_5eMembers_@www.translationbuddy.com": {minVersion: "7.38.8.45962", installs: 372},
  "{9c51bd27-6ed8-4000-a2bf-36cb95c0c947}": {minVersion: "11.0.1.1-signed.1-signed", installs: 370},
  "clickclean@hotcleaner.com": {minVersion: "4.1.1-signed.1-signed", installs: 366},
  "jid1-xKH0EoS44u1a2w@jetpack": {minVersion: "0.1.1-signed.1-signed", installs: 366},
  "{c2056674-a37f-4b29-9300-2004759d74fe}": {minVersion: "2.0.0.1090", installs: 361},
  "newtab-tv-the-extension1@mozilla.com": {minVersion: "0.1.5", installs: 359},
  "ascsurfingprotectionnew@iobit.com": {minVersion: "2.1.3", installs: 355},
  "FunTabSafe-the-extension1@mozilla.com": {minVersion: "0.1.9", installs: 353},
  "d.lehr@chello.at": {minVersion: "1.2", installs: 350},
  "anticontainer@downthemall.net": {minVersion: "1.5", installs: 348},
  "{F8A55C97-3DB6-4961-A81D-0DE0080E53CB}": {minVersion: "1.0.10", installs: 347},
  "@FormsApp": {minVersion: "0.2.0", installs: 346},
  "multilinksplus@hugsmile.eu": {minVersion: "3.9.3", installs: 343},
  "jid1-KWFaW5zc0EbtBQ@jetpack": {minVersion: "0.2.0", installs: 335},
  "{e8f509f0-b677-11de-8a39-0800200c9a66}": {minVersion: "1.12.1-signed.1-let-fixed.1-signed", installs: 334},
  "{37E4D8EA-8BDA-4831-8EA1-89053939A250}": {minVersion: "3.0.0.2.1-signed.1-signed", installs: 333},
  "{c8d3bc80-0810-4d21-a2c2-be5f2b2832ac}": {minVersion: "0.98", installs: 332},
  "{cb40da56-497a-4add-955d-3377cae4c33b}": {minVersion: "10.2.0.271", installs: 331},
  "{5546F97E-11A5-46b0-9082-32AD74AAA920}": {minVersion: "0.76.1-signed.1-signed", installs: 325},
  "_14Members_@www.totalrecipesearch.com": {minVersion: "7.38.8.45925", installs: 324},
  "info@mp3it.eu": {minVersion: "1.4.1.1-signed.1-signed", installs: 324},
  "firefox-autofill@googlegroups.com": {minVersion: "3.6.1-signed.1-signed", installs: 317},
  "jid1-TQvJxTBYHA8qXg@jetpack": {minVersion: "0.4.1-signed.1-signed", installs: 315},
  "{8f8fe09b-0bd3-4470-bc1b-8cad42b8203a}": {minVersion: "0.17.1-signed.1-signed", installs: 311},
  "{D4DD63FA-01E4-46a7-B6B1-EDAB7D6AD389}": {minVersion: "0.9.10.1-signed.1-signed", installs: 311},
  "{d7f46ca0-899d-11da-a72b-0800200c9a65}": {minVersion: "0.1.2.1-signed.1-signed", installs: 311},
  "twoo@twoo.com": {minVersion: "1.6.0.1-signed", installs: 303},
  "_29Members_@www.headlinealley.com": {minVersion: "7.38.8.56537", installs: 302},
  "_e2Members_@free.coolpopulargames.com": {minVersion: "7.38.8.45873", installs: 300},
  "TopTVTab-the-extension1@mozilla.com": {minVersion: "0.1.9", installs: 300},
  "tmbepff@trendmicro.com": {minVersion: "9.2.0.1026", installs: 293},
  "_2vMembers_@www.dailybibleguide.com": {minVersion: "7.38.8.52880", installs: 289},
  "{54e46280-0211-11e3-b778-0800200c9a66}": {minVersion: "0.3", installs: 285},
  "_49Members_@www.utilitychest.com": {minVersion: "7.38.8.45977", installs: 284},
  "amcontextmenu@loucypher": {minVersion: "0.4.2.1-signed.1-signed", installs: 284},
  "jid1-r1tDuNiNb4SEww@jetpack": {minVersion: "1.1.2673", installs: 283},
  "_erMembers_@free.getvideoconvert.com": {minVersion: "7.102.10.5038", installs: 281},
  "{b1df372d-8b32-4c7d-b6b4-9c5b78cf6fb1}": {minVersion: "0.87.1-signed.1-signed", installs: 281},
  "jid1-cHKBMlArKdIVEg@jetpack": {minVersion: "1.24.1-signed.1-signed", installs: 281},
  "@90B817C8-8A5C-413B-9DDD-B2C61ED6E79A": {minVersion: "1.09", installs: 278},
  "smarterwiki@wikiatic.com": {minVersion: "5.2.1.1-signed.1-signed", installs: 278},
  "whatsapppanel@alejandrobrizuela.com.ar": {minVersion: "1.1.1.1-signed.1-signed", installs: 277},
  "lazarus@interclue.com": {minVersion: "2.3.1-signed.1-signed", installs: 275},
  "{DEDA1132-B316-11DD-8BC1-4E5D56D89593}": {minVersion: "0.18", installs: 274},
  "_h2Members_@free.calendarspark.com": {minVersion: "7.102.10.3641", installs: 273},
  "@youtubedownloadere": {minVersion: "0.0.1", installs: 273},
  "multirevenue@googlemail.com": {minVersion: "6.1.1", installs: 272},
  "_d9Members_@www.everydaylookup.com": {minVersion: "7.102.10.4140", installs: 271},
  "belgiumeid@eid.belgium.be": {minVersion: "1.0.21", installs: 271},
  "{62DD0A97-FDD4-421b-94A5-D1A9434450C7}": {minVersion: "3.1", installs: 270},
  "the-addon-bar@GeekInTraining-GiT": {minVersion: "3.2.9-compat-fixed-4", installs: 264},
  "@phextension": {minVersion: "6.0.2", installs: 262},
  "FunMediaTab-the-extension1@mozilla.com": {minVersion: "0.1.9", installs: 262},
  "{7f57cf46-4467-4c2d-adfa-0cba7c507e54}": {minVersion: "4.0.1", installs: 259},
  "safefacebook@bkav": {minVersion: "1.0.4", installs: 255},
  "content_blocker_6418E0D362104DADA084DC312DFA8ABC@kaspersky.com": {minVersion: "4.5.3.8", installs: 254},
  "virtual_keyboard_294FF26A1D5B455495946778FDE7CEDB@kaspersky.com": {minVersion: "4.5.3.8", installs: 254},
  "{B821BF60-5C2D-41EB-92DC-3E4CCD3A22E4}": {minVersion: "4.3.1.10", installs: 252},
  "@E9438230-A7DF-4D1F-8F2D-CA1D0F0F7924": {minVersion: "1.08.8.66", installs: 252},
  "jid1-6MGm94JnyY2VkA@jetpack": {minVersion: "2.1.8", installs: 250},
  "{20a82645-c095-46ed-80e3-08825760534b}": {minVersion: "1.3.1.1-signed", installs: 246},
  "{a192bf54-089f-4325-ac25-7eafcd17a342}": {minVersion: "3.2", installs: 246},
  "e389d8c2-5554-4ba2-a36e-ac7a57093130@gmail.com": {minVersion: "1.44.275", installs: 244},
  "yslow@yahoo-inc.com": {minVersion: "3.1.8.1-signed.1-signed", installs: 244},
  "avg@safeguard": {minVersion: "19.6.0.592", installs: 243},
  "@windscribeff": {minVersion: "0.1.43", installs: 242},
  "jid1-PBNne26X1Kn6hQ@jetpack": {minVersion: "3.3.3", installs: 240},
  "{53A03D43-5363-4669-8190-99061B2DEBA5}": {minVersion: "1.5.14", installs: 239},
  "@offersolymp": {minVersion: "0.0.2", installs: 238},
  "firefox@dotvpn.com": {minVersion: "1.0.2", installs: 238},
  "{62760FD6-B943-48C9-AB09-F99C6FE96088}": {minVersion: "4.2.9", installs: 236},
  "jid1-sNL73VCI4UB0Fw@jetpack": {minVersion: "2.1.4", installs: 236},
  "low_quality_flash@pie2k.com": {minVersion: "0.2.1-signed.1-signed", installs: 236},
  "jid1-l6VQSR2FeKnliQ@jetpack": {minVersion: "2.0.1-signed", installs: 235},
  "_5zMembers_@www.couponxplorer.com": {minVersion: "7.102.10.3738", installs: 234},
  "adonis.cuhk@gmail.com": {minVersion: "1.8.9.1-signed.1-signed", installs: 234},
  "_e1Members_@free.actionclassicgames.com": {minVersion: "7.38.8.45834", installs: 232},
  "{ea4637dc-e014-4c17-9c2c-879322d23268}": {minVersion: "2.1.1-signed.1-signed", installs: 229},
  "{4DC70064-89E2-4a55-8FC6-E8CDEAE3618C}": {minVersion: "0.7.7.1-signed.1-signed", installs: 228},
  "odyssey_crypto_control@odysseytec.com": {minVersion: "3.5", installs: 228},
  "seostatus@rubyweb": {minVersion: "1.5.9.1-signed.1-signed", installs: 228},
  "_apMembers_@free.puzzlegamesdaily.com": {minVersion: "7.102.10.4865", installs: 227},
  "@safesearchincognito": {minVersion: "0.1.8", installs: 226},
  "jid1-HfCj61J5q2gaGQ@jetpack": {minVersion: "1.0.3", installs: 224},
  "@stopads": {minVersion: "0.0.4", installs: 224},
  "dta3noaero@vano": {minVersion: "1.0.1", installs: 224},
  "rainbow@colors.org": {minVersion: "1.6.1-signed.1-signed", installs: 223},
  "{146f1820-2b0d-49ef-acbf-d85a6986e10c}": {minVersion: "0.1.9.3.1-signed.1-signed", installs: 222},
  "{b2bfe60c-eef8-4e20-8334-c53afdc1ffdd}": {minVersion: "3.2", installs: 222},
  "{b7870b41-bfb3-44cd-8cc2-e392e51b0874}": {minVersion: "3.8", installs: 222},
  "printPages2Pdf@reinhold.ripper": {minVersion: "0.1.9.3.1-signed", installs: 221},
  "YouTubetoALL@ALLPlayer.org": {minVersion: "0.8.5.1-signed.1-signed", installs: 221},
  "{7a526449-3a92-426f-8ca4-47439918f2b1}": {minVersion: "3.2", installs: 219},
  "jdwimqhayu@yahoo.com": {minVersion: "0.0.0.6", installs: 219},
  "{54FBE89E-C878-46bb-A064-AB327EE26EBC}": {minVersion: "3.8", installs: 214},
  "modernDownloadManager@teo.pl": {minVersion: "0.2.2", installs: 214},
  "{eb8fff7e-1dce-4f3f-a51d-d9513ed6bab4}": {minVersion: "3.8", installs: 211},
  "jid0-YQz0l1jthOIz179ehuitYAOdBEs@jetpack": {minVersion: "2.0.2", installs: 211},
  "{7e80e173-7e63-464e-8252-fe170b15c15a}": {minVersion: "2.3", installs: 210},
  "{35d6291e-1d4b-f9b4-c52f-77e6410d1326}": {minVersion: "4.11.1.0", installs: 209},
  "{3c59c791-aeec-44bb-af60-ff112eea18e3}": {minVersion: "3.2", installs: 209},
  "{90477448-b59c-48cd-98af-6a298cbc15d2}": {minVersion: "3.8", installs: 209},
  "{24d26487-6274-48b1-b500-22f24884f971}": {minVersion: "2.3", installs: 208},
  "{b7389dbc-6646-412f-bbd5-53168ee68a98}": {minVersion: "49", installs: 208},
  "{22181a4d-af90-4ca3-a569-faed9118d6bc}": {minVersion: "11.0.0.1181", installs: 207},
  "printpdf@pavlov.net": {minVersion: "0.76.1-signed.1-signed", installs: 207},
  "@com.virtualjame.disableads": {minVersion: "0.1.0", installs: 206},
  "{9AA46F4F-4DC7-4c06-97AF-6665170634FE}": {minVersion: "1.11.6.1-signed.1-signed", installs: 205},
  "tinyjsdebugger@enigmail.net": {minVersion: "1.1.5", installs: 204},
  "_foMembers_@free.flightsearchapp.com": {minVersion: "7.102.10.4176", installs: 202},
  "jid1-rs90nxQtPi3Asg@jetpack": {minVersion: "1.8.1-signed.1-signed", installs: 201},
  "vlcplaylist@helgatauscher.de": {minVersion: "0.8.1-signed.1-signed", installs: 201},
  "jid1-G80Ec8LLEbK5fQ@jetpack": {minVersion: "1.3.8", installs: 200},
  "_gpMembers_@free.mymapswizard.com": {minVersion: "7.102.10.4775", installs: 199},
  "BestMediaTab-the-extension1@mozilla.com": {minVersion: "0.1.9", installs: 199},
  "info@convert2mp3.net": {minVersion: "2.5.1-signed.1-signed", installs: 199},
  "partnerdefaults@mozilla.com": {minVersion: "1.0.1", installs: 199},
  "qwantcomforfirefox@jetpack": {minVersion: "3.0.28", installs: 199},
  "{65e41d20-f092-41b7-bb83-c6e8a9ab0f57}": {minVersion: "1.2.6", installs: 198},
  "amznUWL2@amazon.com": {minVersion: "1.11", installs: 197},
  "{1b80ae74-4912-44fc-9f27-30f9252a5ad7}": {minVersion: "2.3", installs: 197},
  "{c9b4cd26-6f0e-4972-a9e0-8b77e811aa8f}": {minVersion: "2.3", installs: 197},
  "shopcbtoolbar2@befrugal.com": {minVersion: "2013.3.23.1", installs: 197},
  "trafficlight@bitdefender.com": {minVersion: "0.2.23.1-signed.1-signed", installs: 197},
  "webrank-toolbar@probcomp.com": {minVersion: "4.4.1.1-signed.1-signed", installs: 197},
  "_4lMembers_@www.bibletriviatime.com": {minVersion: "7.102.10.4330", installs: 196},
  "xthunder@lshai.com": {minVersion: "1.3.4.1-signed.1-signed", installs: 196},
  "extension@hidemyass.com": {minVersion: "1.3.2", installs: 195},
  "jid1-MIAJd5BiK7V4Pw@jetpack": {minVersion: "0.9.1-signed.1-signed", installs: 195},
  "{51aa69f8-8825-4def-916a-a766c5e3c0fd}": {minVersion: "3.8", installs: 194},
  "{2bc72c53-9bde-4db2-8479-eda9a5e71f4e}": {minVersion: "3.2", installs: 193},
  "{a95d8332-e4b4-6e7f-98ac-20b733364387}": {minVersion: "1.0.5", installs: 191},
  "ocr@babylon.com": {minVersion: "1.1", installs: 191},
  "{d3b9472c-f8b1-4a10-935b-1087bac8417f}": {minVersion: "3.8", installs: 189},
  "windowpromo@dm73.net": {minVersion: "1.6", installs: 188},
  "alldownloader@link64": {minVersion: "1.00.17.1-signed.1-signed", installs: 187},
  "{3e0e7d2a-070f-4a47-b019-91fe5385ba79}": {minVersion: "3.6.5.2", installs: 185},
  "jid1-vFmnfCkyf5VeSA@jetpack": {minVersion: "0.4.0", installs: 185},
  "@greatdealz": {minVersion: "0.0.3", installs: 184},
  "superstart@enjoyfreeware.org": {minVersion: "7.4.0.1-signed", installs: 183},
  "{c2fc3c2b-a65a-453c-bf95-101fde56ed1d}": {minVersion: "2.3", installs: 182},
  "{53152e75-fd90-472f-9d30-5cba3679eab9}": {minVersion: "48.3", installs: 180},
  "jid0-raWjElI57dRa4jx9CCiYm5qZUQU@jetpack": {minVersion: "3.0.12.1.1-signed.1-signed", installs: 180},
  "_ivMembers_@free.simplepictureedit.com": {minVersion: "7.102.10.14166", installs: 179},
  "jid1-wKRSK9TpFpr9Hw@jetpack": {minVersion: "0.92", installs: 179},
  "emailExtractor@penzil.com": {minVersion: "1.3.1-signed.1-signed", installs: 178},
  "{60B7679C-BED9-11E5-998D-8526BB8E7F8B}": {minVersion: "6.3", installs: 177},
  "@pdfit": {minVersion: "0.1.9", installs: 177},
  "jid1-6AyZ1PQXsR9LgQ@jetpack": {minVersion: "0.2.1", installs: 177},
  "_6oMembers_@free.heroicplay.com": {minVersion: "7.38.8.46626", installs: 175},
  "{4BBDD651-70CF-4821-84F8-2B918CF89CA3}": {minVersion: "8.9.3.1", installs: 173},
  "jid1-GeRCnsiDhZiTvA@jetpack": {minVersion: "1.0.3", installs: 172},
  "jid0-zs24wecdcQo0Lp18D7QOV4WSZFo@jetpack": {minVersion: "0.2.1-signed.1-signed", installs: 171},
  "{c50ca3c4-5656-43c2-a061-13e717f73fc8}": {minVersion: "5.0.1.48.1-signed.1-signed", installs: 170},
  "selenium_ide_buttons@egarracingteam.com.ar": {minVersion: "1.2.0.1-signed.1-signed", installs: 170},
  "WSVCU@Wondershare.com": {minVersion: "7.1.0", installs: 169},
  "{4cc4a13b-94a6-7568-370d-5f9de54a9c7f}": {minVersion: "2.7.1-signed.1-signed", installs: 168},
  "{aa84ce40-4253-a00a-8cd6-0800200f9a67}": {minVersion: "3.12.0", installs: 168},
  "FasterFox_Lite@BigRedBrent": {minVersion: "3.9.9Lite.1-signed.1-signed", installs: 167},
  "{6cc0f0f7-a6e2-4834-9682-24de2229b51e}": {minVersion: "23.6", installs: 166},
  "{b749fc7c-e949-447f-926c-3f4eed6accfe}": {minVersion: "0.7.1.1.1-signed.1-signed", installs: 166},
  "@mendeleyimporter": {minVersion: "1.6.8", installs: 166},
  "ALone-live@ya.ru": {minVersion: "1.4.11", installs: 166},
  "{4093c4de-454a-4329-8aff-c6b0b123c386}": {minVersion: "0.8.14.1-signed.1-signed", installs: 165},
  "cookiemgr@jayapal.com": {minVersion: "5.12", installs: 164},
  "touchenex@raon.co.kr": {minVersion: "1.0.1.11", installs: 163},
  "{b0e1b4a6-2c6f-4e99-94f2-8e625d7ae255}": {minVersion: "3.5.0.1-signed.1-signed", installs: 162},
  "isreaditlater@ideashower.com": {minVersion: "3.0.6.1-signed", installs: 161},
  "safesearchplus@avira.com": {minVersion: "1.4.1.371", installs: 161},
  "_e0Members_@www.downshotfree.com": {minVersion: "7.102.10.3833", installs: 159},
  "LDSI_plashcor@gmail.com": {minVersion: "1.1.0.3", installs: 159},
  "jid1-9ETkKdBARv7Iww@jetpack": {minVersion: "0.20.1-signed.1-signed", installs: 157},
  "jid1-CGxMej0nDJTjwQ@jetpack": {minVersion: "1.0.1-signed.1-signed", installs: 157},
  "{00f7ab9f-62f4-4145-b2f9-38d579d639f6}": {minVersion: "49", installs: 156},
  "googledictionary@toptip.ca": {minVersion: "7.5", installs: 156},
  "shopearn@prodege.com": {minVersion: "219", installs: 156},
  "fvdmedia@gmail.com": {minVersion: "11.0.1", installs: 155},
  "magicplayer_unlisted@acestream.org": {minVersion: "1.1.42", installs: 155},
  "{0538E3E3-7E9B-4d49-8831-A227C80A7AD3}": {minVersion: "2.2.2.1-signed.1-let-fixed.1-signed", installs: 154},
  "{73007fef-a6e0-47d3-b4e7-dfc116ed6f65}": {minVersion: "1.15.1-signed.1-signed", installs: 153},
  "{cd617372-6743-4ee4-bac4-fbf60f35719e}": {minVersion: "2.0.1-signed.1-signed", installs: 152},
  "TopSecurityTab-the-extension1@mozilla.com": {minVersion: "0.1.9", installs: 152},
  "jid1-hDf2iQXGiUjzGQ@jetpack": {minVersion: "2.5.0", installs: 151},
  "_dnMembers_@www.free.webmailworld.com": {minVersion: "7.102.10.5052", installs: 149},
  "jid1-rrMTK7JqsxNOeQ@jetpack": {minVersion: "2.1.0", installs: 149},
  "jid1-XgC5trUcILmXBw@jetpack": {minVersion: "2.0.3", installs: 149},
  "online_banking_69A4E213815F42BD863D889007201D82@kaspersky.com": {minVersion: "4.5.3.8", installs: 148},
  "jid1-AXn9cXcB4fD1QQ@jetpack": {minVersion: "0.7.4", installs: 148},
  "feedly@devhd": {minVersion: "16.0.528.1-signed.1-signed", installs: 147},
  "{6E727987-C8EA-44DA-8749-310C0FBE3C3E}": {minVersion: "2.0.0.11", installs: 146},
  "{1082eb84-f0f2-11e5-8e18-9bb85ab7992e}": {minVersion: "1.07", installs: 146},
  "{c151d79e-e61b-4a90-a887-5a46d38fba99}": {minVersion: "2.8.8", installs: 146},
  "public.proartex@gmail.com": {minVersion: "1.1.3", installs: 145},
  "jid1-8J7ayxTha4KqKQ@jetpack": {minVersion: "1.1.1-signed.1-signed", installs: 144},
  "stealthyextension@gmail.com": {minVersion: "3.0.1.1-signed", installs: 144},
  "_beMembers_@free.dailylocalguide.com": {minVersion: "7.38.9.7920", installs: 143},
  "mytube@ashishmishra.in": {minVersion: "0.979.1-signed.1-signed", installs: 142},
  "@A3592ADB-854A-443A-854E-EB92130D470D": {minVersion: "1.08.8.88", installs: 139},
  "FunkyTVTabs-the-extension1@mozilla.com": {minVersion: "0.1.9", installs: 139},
  "jid1-QpHD8URtZWJC2A@jetpack": {minVersion: "4.3.0", installs: 138},
  "savedeo-video-downloader@fczbkk.com": {minVersion: "0.4.1.1-signed.1-signed", installs: 137},
  "toolbar@shopathome.com": {minVersion: "8.20.3.1", installs: 137},
  "_dyMembers_@www.dezipper.com": {minVersion: "7.102.10.3775", installs: 135},
  "jid0-zXo3XFGyiDalgkeEO4UYJTUwo2I@jetpack": {minVersion: "1.0.0", installs: 134},
  "{d57c9ff1-6389-48fc-b770-f78bd89b6e8a}": {minVersion: "1.46.1-signed.1-signed", installs: 133},
  "@searchlock-fx": {minVersion: "1.1.6", installs: 133},
  "dm@jetpack": {minVersion: "0.0.2", installs: 133},
  "proxyselector@mozilla.org": {minVersion: "1.31.1-signed.1-signed", installs: 133},
  "{065829BC-17B5-4C0B-9429-3173C361092E}": {minVersion: "1.0.8", installs: 132},
  "{ada4b710-8346-4b82-8199-5de2b400a6ae}": {minVersion: "2.1.5.5.3", installs: 132},
  "readable@evernote.com": {minVersion: "10.2.1.7.1-signed", installs: 131},
  "{d48a39ba-8f80-4fce-8ee1-bc710561c55d}": {minVersion: "3.1.0.1-signed.1-signed", installs: 131},
  "autorefresh@plugin": {minVersion: "1.0.2.1-signed.1-signed", installs: 130},
  "SafeBrowseSearch-the-extension1@mozilla.com": {minVersion: "0.1.2", installs: 130},
  "browsermodulecorp@browcorporation.org": {minVersion: "2.3", installs: 129},
  "wisestamp@wisestamp.com": {minVersion: "4.14.20", installs: 127},
  "_63Members_@www.aplusgamer.com": {minVersion: "7.38.8.45832", installs: 126},
  "bestproxyswitcher@bestproxyswitcher.com": {minVersion: "3.4.6.1-signed.1-signed", installs: 126},
  "jid1-AVgCeF1zoVzMjA@jetpack": {minVersion: "0.9.5.6", installs: 126},
  "{ce7e73df-6a44-4028-8079-5927a588c948}": {minVersion: "1.1.4", installs: 125},
  "{E71B541F-5E72-5555-A47C-E47863195841}": {minVersion: "3.0.3", installs: 125},
  "{F5DDF39C-9293-4d5e-9AA8-E04E6DD5E9B4}": {minVersion: "1.6.3.1-signed.1-signed", installs: 125},
  "@simplepopupblocker": {minVersion: "1.2.1", installs: 125},
  "commonfix@mozillaonline.com": {minVersion: "0.13", installs: 125},
  "searchme@mybrowserbar.com": {minVersion: "2.8", installs: 125},
  "_4wMembers_@www.retrogamer.com": {minVersion: "7.38.8.46604", installs: 124},
  "{71328583-3CA7-4809-B4BA-570A85818FBB}": {minVersion: "0.8.6.3.1-let-fixed", installs: 123},
  "dmremote@westbyte.com": {minVersion: "1.9.3", installs: 123},
  "@google-translate-menu": {minVersion: "1.0.1", installs: 122},
  "_aaMembers_@free.eliteunzip.com": {minVersion: "7.39.8.50909", installs: 121},
  "{8620c15f-30dc-4dba-a131-7c5d20cf4a29}": {minVersion: "3.9", installs: 121},
  "{eb4b28c8-7f2d-4327-a00c-40de4299ba44}": {minVersion: "1.7", installs: 121},
  "flashlight@stephennolan.com.au": {minVersion: "1.2.1-signed.1-signed", installs: 121},
  "useragentoverrider@qixinglu.com": {minVersion: "0.4.1", installs: 121},
  "{1B33E42F-EF14-4cd3-B6DC-174571C4349C}": {minVersion: "4.7", installs: 120},
  "_dxMembers_@www.download-freemaps.com": {minVersion: "7.38.8.46371", installs: 120},
  "{95ab36d4-fb6f-47b0-8b8d-e5f3bd547953}": {minVersion: "4.20.13.1-signed.1-signed", installs: 120},
  "FirefoxAddon@similarWeb.com": {minVersion: "4.0.6", installs: 120},
  "flashstopper@byo.co.il": {minVersion: "1.4.2", installs: 120},
  "{15e67a59-bd3d-49ae-90dd-b3d3fd14c2ed}": {minVersion: "1.0.3.1-signed.1-signed", installs: 119},
  "{c37bac34-849a-4d28-be41-549b2c76c64e}": {minVersion: "2.6", installs: 119},
  "{03B08592-E5B4-45ff-A0BE-C1D975458688}": {minVersion: "1.1.1-signed.1-signed", installs: 118},
  "newtabgoogle@graememcc.co.uk": {minVersion: "1.0.2.1-signed.1-signed", installs: 118},
  "SocialNewtabs-the-extension1@mozilla.com": {minVersion: "0.1.9", installs: 118},
  "@kikikokicicidada": {minVersion: "2.1.2", installs: 117},
  "{9D6218B8-03C7-4b91-AA43-680B305DD35C}": {minVersion: "4.0.5", installs: 116},
  "extension@one-tab.com": {minVersion: "1.17.0", installs: 116},
  "{22119944-ED35-4ab1-910B-E619EA06A115}": {minVersion: "7.9.21.5", installs: 115},
  "admin@hide-my-ip.org": {minVersion: "9.6.3", installs: 115},
  "bdwteffv19@bitdefender.com": {minVersion: "2.2.1", installs: 115},
  "exif_viewer@mozilla.doslash.org": {minVersion: "2.00.1-signed.1-signed", installs: 115},
  "MyStartab-the-extension1@mozilla.com": {minVersion: "0.1.9", installs: 115},
  "coralietab@mozdev.org": {minVersion: "2.04.20110724.1-signed.1-signed", installs: 113},
  "gaurangnshah@gmail.com": {minVersion: "1.3.2.1-signed.1-signed", installs: 113},
  "ImagePicker@topolog.org": {minVersion: "1.9.4", installs: 113},
  "{d49a148e-817e-4025-bee3-5d541376de3b}": {minVersion: "3.1.1-signed.1-signed", installs: 112},
  "firebug@tools.sitepoint.com": {minVersion: "1.6.1-signed.1-signed", installs: 111},
  "add-to-searchbox@maltekraus.de": {minVersion: "2.9", installs: 110},
  "captiondownloader@hiephm.com": {minVersion: "2.3.1-signed.1-signed", installs: 110},
  "jid1-LYopfl0r00ZV5k@jetpack": {minVersion: "1.0.1-signed.1-signed", installs: 110},
  "{7CA9CF31-1C73-46CD-8377-85AB71EA771F}": {minVersion: "5.0.12", installs: 109},
  "jid1-HdwPLukcGQeOSh@jetpack": {minVersion: "1.2.3", installs: 108},
  "{0AA9101C-D3C1-4129-A9B7-D778C6A17F82}": {minVersion: "2.09.1-signed", installs: 107},
  "CookiesIE@yahoo.com": {minVersion: "1.0.1-signed.1-signed", installs: 107},
  "selenium-expert_selenium-ide@Samit.Badle": {minVersion: "0.25.1-signed.1-signed", installs: 107},
  "{19EB90DC-A456-458b-8AAC-616D91AAFCE1}": {minVersion: "1.0.1-signed", installs: 105},
  "application@itineraire.info": {minVersion: "4.5.0", installs: 105},
  "rest-easy@quickmediasolutions.com": {minVersion: "0.3.1.1-signed", installs: 105},
  "TopSocialHub-the-extension1@mozilla.com": {minVersion: "0.1.9", installs: 105},
  "{7affbfae-c4e2-4915-8c0f-00fa3ec610a1}": {minVersion: "6.36.32", installs: 104},
  "azhang@cloudacl.com": {minVersion: "0.19.6.9.1-signed.1-signed", installs: 104},
  "FunCyberTab-the-extension1@mozilla.com": {minVersion: "0.1.9", installs: 104},
  "SkipScreen@SkipScreen": {minVersion: "0.7.2.1-signed.1-signed", installs: 104},
  "toolbar@seomoz.org": {minVersion: "3.1.18", installs: 104},
  "{8b86149f-01fb-4842-9dd8-4d7eb02fd055}": {minVersion: "0.26.1-signed.1-signed", installs: 103},
  "fbp@fbpurity.com": {minVersion: "9.3.2.1-signed", installs: 103},
  "jid1-V8ev2melBDV3qQ@jetpack": {minVersion: "1.0.12.1-signed.1-signed", installs: 103},
  "_fvMembers_@free.directionsace.com": {minVersion: "7.102.10.3790", installs: 102},
  "{b6b1a201-b252-484f-b9fe-68efbb273fbd}": {minVersion: "1.10.1-signed.1-signed", installs: 102},
  "flashfirebug@o-minds.com": {minVersion: "4.9.1", installs: 102},
  "_ebMembers_@download.metrohotspot.com": {minVersion: "7.102.10.4735", installs: 101},
  "{2e17e2b2-b8d4-4a67-8d7b-fafa6cc9d1d0}": {minVersion: "1.2.7.0.1-signed.1-signed", installs: 101},
  "{ea61041c-1e22-4400-99a0-aea461e69d04}": {minVersion: "0.2.4.1-signed.1-signed", installs: 101},
  "rapportive@rapportive.com": {minVersion: "1.4.0.1.1-signed.1-signed", installs: 101},
  "_dvMembers_@www.testinetspeed.com": {minVersion: "7.38.8.45918", installs: 100},
  "{9aad3da6-6c46-4ef0-9109-6df5eaaf597c}": {minVersion: "1.4.1.1-signed.1-signed", installs: 100},
  "{c2b1f3ae-5cd5-49b7-8a0c-2c3bcbbbb294}": {minVersion: "1.1.1-signed.1-signed", installs: 100},
  "jid0-w1UVmoLd6VGudaIERuRJCPQx1dQ@jetpack": {minVersion: "1.6.8.1-signed", installs: 100},
  "_cxMembers_@www.autopcbackup.com": {minVersion: "7.102.10.3597", installs: 99},
  "vpn@hide-my-ip.org": {minVersion: "10.6.2", installs: 99},
  "{1a5dabbd-0e74-41da-b532-a364bb552cab}": {minVersion: "1.0.9.1-signed", installs: 98},
  "FirePHPExtension-Build@firephp.org": {minVersion: "0.7.4.1-signed.1-signed", installs: 98},
  "jid1-UXDr6c69BeyPVw@jetpack": {minVersion: "0.8.2", installs: 98},
  "TopSafeTab-the-extension1@mozilla.com": {minVersion: "0.1.9", installs: 98},
  "{3b56bcc7-54e5-44a2-9b44-66c3ef58c13e}": {minVersion: "0.9.7.4", installs: 97},
  "autoreload@yz.com": {minVersion: "1.21", installs: 97},
  "manish.p05@gmail.com": {minVersion: "12.9", installs: 97},
  "videoresumer@jetpack": {minVersion: "1.1.4", installs: 97},
  "@Radio": {minVersion: "0.2.0", installs: 96},
  "_hfMembers_@free.everydaymanuals.com": {minVersion: "7.102.10.4142", installs: 96},
  "jid0-jJRRRBMgoShUhb07IvnxTBAl29w@jetpack": {minVersion: "2.0.4", installs: 96},
  "rikaichan-jpen@polarcloud.com": {minVersion: "2.01.160101", installs: 96},
  "{7c6cdf7c-8ea8-4be7-ae5a-0b3effe14d66}": {minVersion: "49.1", installs: 95},
  "{FDBAD97E-A258-4fe3-9CF6-60CF386C4422}": {minVersion: "2.0.1.6", installs: 95},
  "intgcal@egarracingteam.com.ar": {minVersion: "1.5.1", installs: 95},
  "MediaNewTab-the-extension1@mozilla.com": {minVersion: "0.1.6", installs: 95},
  "{9EB34849-81D3-4841-939D-666D522B889A}": {minVersion: "2.4.0.157", installs: 94},
  "{158d7cb3-7039-4a75-8e0b-3bd0a464edd2}": {minVersion: "2.7.1-signed.1-signed", installs: 94},
  "jid1-ach2kaGSshPJCg@jetpack": {minVersion: "0.1.1-signed.1-signed", installs: 94},
  "jid1-cwbvBTE216jjpg@jetpack": {minVersion: "2.1.0.1-signed.1-signed", installs: 94},
  "{f36c6cd1-da73-491d-b290-8fc9115bfa55}": {minVersion: "3.0.9.1-signed.1-let-fixed.1-signed", installs: 93},
  "dmpluginff@westbyte.com": {minVersion: "1.4.12", installs: 93},
  "firefox@serptrends.com": {minVersion: "0.8.14", installs: 93},
  "panel-plugin@effectivemeasure.com": {minVersion: "4.0.0", installs: 93},
  "_evMembers_@www.free.bestbackground.com": {minVersion: "7.102.10.3607", installs: 92},
  "canitbecheaper@trafficbroker.co.uk": {minVersion: "3.9.78", installs: 92},
  "favorites_selenium-ide@Samit.Badle": {minVersion: "2.0.1-signed.1-signed", installs: 92},
  "{5F590AA2-1221-4113-A6F4-A4BB62414FAC}": {minVersion: "0.45.8.20130519.3.1-signed.1-signed", installs: 90},
  "{3e9bb2a7-62ca-4efa-a4e6-f6f6168a652d}": {minVersion: "2.7.7.1-signed.1-signed", installs: 90},
  "{ab4b5718-3998-4a2c-91ae-18a7c2db513e}": {minVersion: "1.2.0.1-signed.1-signed", installs: 90},
  "2020Player_WEB@2020Technologies.com": {minVersion: "5.0.94.0", installs: 90},
  "translator@dontfollowme.net": {minVersion: "2.0.5", installs: 90},
  "YouTubeAutoReplay@arikv.com": {minVersion: "3.3.1-signed.1-signed", installs: 90},
  "{a949831f-d9c0-45ae-8c60-91c2a86fbfb6}": {minVersion: "0.2.1-signed.1-signed", installs: 89},
  "@vpn-unlimited-secure-proxy": {minVersion: "4.4", installs: 89},
  "jid1-JcGokIiQyjoBAQ@jetpack": {minVersion: "0.6.1-signed.1-signed", installs: 89},
  "_73Members_@www.easyhomedecorating.com": {minVersion: "7.102.10.4129", installs: 88},
  "{065ee92a-ad57-42a2-b6d5-466b6fd8e24d}": {minVersion: "0.11.6.1-signed.1-signed", installs: 88},
  "{455D905A-D37C-4643-A9E2-F6FEFAA0424A}": {minVersion: "0.8.17.1-signed.1-signed", installs: 88},
  "{7eb3f691-25b4-4a85-9038-9e57e2bcd537}": {minVersion: "0.4.4.1-signed.1-signed", installs: 88},
  "FunSocialTab-the-extension1@mozilla.com": {minVersion: "0.1.9", installs: 88},
  "Lucifox@lucidor.org": {minVersion: "0.9.13", installs: 88},
  "YourMediaTab-the-extension1@mozilla.com": {minVersion: "0.1.9", installs: 88},
  "youtube-video-player@lejenome.me": {minVersion: "0.2.38.1-signed.1-signed", installs: 88},
  "_hgMembers_@free.atozmanuals.com": {minVersion: "7.102.10.3604", installs: 87},
  "abb-acer@amazon.com": {minVersion: "10.161.13.1002", installs: 87},
  "gmail_panel@alejandrobrizuela.com.ar": {minVersion: "1.2.0", installs: 87},
  "izer@camelcamelcamel.com": {minVersion: "2.8.2", installs: 87},
  "tvnewtab-the-extension1@mozilla.com": {minVersion: "0.1.5", installs: 87},
  "vlc_shortcut@kosan.kosan": {minVersion: "0.8.3.0", installs: 87},
  "youtubeunblocker@unblocker.yt": {minVersion: "0.6.20", installs: 86},
  "email@jetpack": {minVersion: "0.0.16", installs: 86},
  "extensions@gismeteo.com": {minVersion: "5.1.0.2", installs: 86},
  "idaremote@westbyte.com": {minVersion: "1.6.3", installs: 86},
  "{725fc0a6-1f6b-4cf9-ae17-748d111dc16d}": {minVersion: "1.1.0", installs: 85},
  "jid1-461B0PwxL3oTt1@jetpack": {minVersion: "0.2.1-signed.1-signed", installs: 85},
  "webdavlauncher@benryan.com": {minVersion: "1.1.0", installs: 85},
  "jid1-ZM3BerwS6FsQAg@jetpack": {minVersion: "0.4.1-signed", installs: 84},
  "_fwMembers_@free.howtosuite.com": {minVersion: "7.102.10.4280", installs: 84},
  "{023e9ca0-63f3-47b1-bcb2-9badf9d9ef28}": {minVersion: "4.4.3.1-signed.1-signed", installs: 84},
  "{25A1388B-6B18-46c3-BEBA-A81915D0DE8F}": {minVersion: "1.7.8.5.1-signed.1-signed", installs: 84},
  "{75493B06-1504-4976-9A55-B6FE240FF0BF}": {minVersion: "3.4.0.0", installs: 84},
  "facepaste.firefox.addon@azabani.com": {minVersion: "2.91", installs: 84},
  "jid1-cplLTTY501TB2Q@jetpack": {minVersion: "0.5.1", installs: 84},
  "_d1Members_@free.mysocialshortcut.com": {minVersion: "7.102.10.4792", installs: 83},
  "{761a54f1-8ccf-4112-9e48-dbf72adf6244}": {minVersion: "2.3.1-signed.1-signed", installs: 83},
  "{BBB77B49-9FF4-4d5c-8FE2-92B1D6CD696C}": {minVersion: "2.0.0.1083", installs: 83},
  "{a3a5c777-f583-4fef-9380-ab4add1bc2a2}": {minVersion: "2.1.4", installs: 82},
  "{eb80b076-a444-444c-a590-5aee5d977d80}": {minVersion: "2.6.18", installs: 82},
  "KVAllmytube@KeepVid.com": {minVersion: "4.10.0", installs: 82},
  "lumerias-instagram@lumerias.com": {minVersion: "1.3", installs: 82},
  "omnibar@ajitk.com": {minVersion: "0.7.28.20141004.1-signed.1-signed", installs: 81},
  "@autofillanyforms-easytatkal": {minVersion: "7.51.0", installs: 81},
  "@youtuberightclick": {minVersion: "0.0.3", installs: 81},
  "autoproxy@autoproxy.org": {minVersion: "0.4b2.2013051811.1-signed.1-let-fixed.1-signed", installs: 80},
  "{e33788ea-0bb9-4502-9c77-bdc551afc8ad}": {minVersion: "1.0.4", installs: 80},
  "dmmm@westbyte.com": {minVersion: "1.3.4", installs: 80},
  "easycopy@smokyink.com": {minVersion: "2.7.0", installs: 80},
  "jid1-LelsJ0Oz0rt71A@jetpack": {minVersion: "2.0.0", installs: 80},
  "_f7Members_@download.smsfrombrowser.com": {minVersion: "7.38.8.45917", installs: 79},
  "{6614d11d-d21d-b211-ae23-815234e1ebb5}": {minVersion: "3.9.13", installs: 79},
  "FunTvTab-the-extension1@mozilla.com": {minVersion: "0.1.9", installs: 79},
  "{4204c864-50bf-467a-95b3-0912b7f15869}": {minVersion: "1.2.00.1-signed.1-signed", installs: 78},
  "{987311C6-B504-4aa2-90BF-60CC49808D42}": {minVersion: "3.1-signed.1-signed", installs: 78},
  "uploader@adblockfilters.mozdev.org": {minVersion: "2.1.1-signed.1-let-fixed.1-signed", installs: 77},
  "PageRank@addonfactory.in": {minVersion: "2.0.1-signed.1-signed", installs: 77},
  "restartbutton@strk.jp": {minVersion: "0.1.5.1-signed.1-signed", installs: 77},
  "text2voice@vik.josh": {minVersion: "1.15", installs: 77},
  "_dpMembers_@free.findyourmaps.com": {minVersion: "7.102.10.4185", installs: 76},
  "53ffxtbr@www.dailyfitnesscenter.com": {minVersion: "7.36.8.15623", installs: 76},
  "gary@builtwith.com": {minVersion: "1.9.6.1-signed.1-signed", installs: 76},
  "idamm@westbyte.com": {minVersion: "1.3.2", installs: 76},
  "jid1-3gu11JeYBiIuJA@jetpack": {minVersion: "3.1.1", installs: 76},
  "jid1-zV8eHYwTDNUtwQ@jetpack": {minVersion: "1.0.4", installs: 76},
  "nst@neiron.ru": {minVersion: "7.3.0.2", installs: 76},
  "service@touchpdf.com": {minVersion: "1.15.1-signed.1-signed", installs: 76},
  "{02450954-cdd9-410f-b1da-db804e18c671}": {minVersion: "0.96.3.1-signed.1-signed", installs: 75},
  "{4176DFF4-4698-11DE-BEEB-45DA55D89593}": {minVersion: "0.8.50.1-signed.1-signed", installs: 75},
  "{DAD0F81A-CF67-4eed-98D6-26F6E47274CA}": {minVersion: "1.8.1-signed.1-signed", installs: 75},
  "dealxplorermysites770@yahoo.com": {minVersion: "0.0.0.1", installs: 75},
  "firefox@online-convert.com": {minVersion: "1.4.1-signed.1-signed", installs: 75},
  "jid1-zmgYgiQPXJtjNA@jetpack": {minVersion: "1.23", installs: 75},
  "_evMembers_@www.bestbackground.com": {minVersion: "7.38.9.7654", installs: 74},
  "dmbarff@westbyte.com": {minVersion: "1.5.11", installs: 74},
  "inf@youtube-mp3.video": {minVersion: "0.1", installs: 74},
  "jid1-e7w0SHT82Gv9qA@jetpack": {minVersion: "1.2", installs: 74},
  "NewTabTVCool-the-extension1@mozilla.com": {minVersion: "0.1.9", installs: 74},
  "{E173B749-DB5B-4fd2-BA0E-94ECEA0CA55B}": {minVersion: "7.4.1-signed", installs: 73},
  "{9BAE5926-8513-417d-8E47-774955A7C60D}": {minVersion: "1.1.1d.1-signed.1-signed", installs: 73},
  "{3cc6c6ba-654c-417e-a8af-6997ac388ae1}": {minVersion: "49", installs: 72},
  "{daf44bf7-a45e-4450-979c-91cf07434c3d}": {minVersion: "2.0.5", installs: 72},
  "{dbac9680-d559-4cd4-9765-059879e8c467}": {minVersion: "5.0.5", installs: 72},
  "application@recettes.net": {minVersion: "4.5.0", installs: 72},
  "idapluginff@westbyte.com": {minVersion: "1.5.9", installs: 71},
  "imgflashblocker@shimon.chohen": {minVersion: "0.7.1-signed.1-signed", installs: 71},
  "inspector@mozilla.org": {minVersion: "2.0.16.1-signed", installs: 71},
  "jid1-ReWlW1efOwaQJQ@jetpack": {minVersion: "1.1.2", installs: 71},
  "youtubedownloader@trafficterminal.com": {minVersion: "1.0.1.1-signed.1-signed", installs: 71},
  "FavIconReloader@mozilla.org": {minVersion: "0.8.1-signed", installs: 70},
  "_2bMembers_@www.bettercareersearch.com": {minVersion: "7.38.8.45828", installs: 70},
  "{5e594888-3e8e-47da-b2c6-b0b545112f84}": {minVersion: "1.3.18", installs: 70},
  "@greatdealzu": {minVersion: "0.0.3", installs: 70},
  "86ffxtbr@download.yourvideochat.com": {minVersion: "7.36.8.15938", installs: 70},
  "google@hitachi.com": {minVersion: "0.3.1-signed.1-signed", installs: 70},
  "{6e84150a-d526-41f1-a480-a67d3fed910d}": {minVersion: "1.5.6.1-signed.1-signed", installs: 69},
  "firepicker@thedarkone": {minVersion: "1.4.3.1-signed.1-signed", installs: 69},
  "jid0-AocRXUCRsLTCYvn6bgJERnwfuqw@jetpack": {minVersion: "2.8.3.1-signed.1-signed", installs: 69},
  "nortonsecurity@symantec.com": {minVersion: "7.2.0f90", installs: 69},
  "{ef4e370e-d9f0-4e00-b93e-a4f274cfdd5a}": {minVersion: "1.4.10.1-signed", installs: 68},
  "{d4e0dc9c-c356-438e-afbe-dca439f4399d}": {minVersion: "49.1", installs: 68},
  "{E6C93316-271E-4b3d-8D7E-FE11B4350AEB}": {minVersion: "2.1.25.1-signed.1-signed", installs: 68},
  "{fa8476cf-a98c-4e08-99b4-65a69cb4b7d4}": {minVersion: "1.7.6.1", installs: 68},
  "simplesiteblocker@example.com": {minVersion: "1.1.1-signed.1-signed", installs: 68},
  "_fpMembers_@free.passwordlogic.com": {minVersion: "7.102.10.4853", installs: 67},
  "{6e764c17-863a-450f-bdd0-6772bd5aaa18}": {minVersion: "1.0.3.1-signed.1-signed", installs: 67},
  "adbeaver@adbeaver.org": {minVersion: "0.7.2.9", installs: 67},
  "application2@allo-pages.fr": {minVersion: "4.5.0", installs: 67},
  "arf3@getcartt.com": {minVersion: "1.2.3", installs: 67},
  "clearcache@michel.de.almeida": {minVersion: "2.0.1.1-signed.1-signed", installs: 67},
  "fbmessengerpanel@alejandrobrizuela.com.ar": {minVersion: "1.0.3.1-signed.1-signed", installs: 67},
  "tilt@mozilla.com": {minVersion: "1.0.1.1-signed.1-signed", installs: 67},
  "toolbar_AVIRA-V7@apn.ask.com": {minVersion: "127.25", installs: 67},
  "{524B8EF8-C312-11DB-8039-536F56D89593}": {minVersion: "4.91.0.0", installs: 66},
  "{9d1f059c-cada-4111-9696-41a62d64e3ba}": {minVersion: "0.17.0.1", installs: 66},
  "{B068AC18-0121-4e67-9A7E-6386F93F4F7A}": {minVersion: "2.4", installs: 66},
  "@lottadealsun": {minVersion: "0.0.1", installs: 66},
  "@thebestyoutubedownloader": {minVersion: "1.0.0.7", installs: 66},
  "TopSocialTab-the-extension1@mozilla.com": {minVersion: "0.1.9", installs: 66},
  "{11483926-db67-4190-91b1-ef20fcec5f33}": {minVersion: "0.4.9.1", installs: 65},
  "{8AA36F4F-6DC7-4c06-77AF-5035170634FE}": {minVersion: "2016.9.16", installs: 65},
  "dam@tensons.com": {minVersion: "5.0.7", installs: 65},
  "jid1-D7momAzRw417Ag@jetpack": {minVersion: "4.5.13", installs: 65},
  "support@videoadd.ru": {minVersion: "2.8.1.1-signed.1-signed", installs: 65},
  "{95322c08-05ff-4f3c-85fd-8ceb821988dd}": {minVersion: "49", installs: 64},
  "AllMyTube@Wondershare.com": {minVersion: "4.9.1", installs: 64},
  "azan-times@hamid.net": {minVersion: "1.2.3.1-signed.1-signed", installs: 64},
  "check-compatibility@dactyl.googlecode.com": {minVersion: "1.3.1-signed.1-signed", installs: 64},
  "ifamebook@stormvision.it": {minVersion: "4.03.1-signed", installs: 64},
  "jid1-vRJA7N8VwBoiXw@jetpack": {minVersion: "1.1.1.1-signed", installs: 64},
  "{04426594-bce6-4705-b811-bcdba2fd9c7b}": {minVersion: "1.7.1-signed.1-signed", installs: 63},
  "{f3f219f9-cbce-467e-b8fe-6e076d29665c}": {minVersion: "50", installs: 63},
  "fireforce@scrt.ch": {minVersion: "2.2.1-signed.1-signed", installs: 63},
  "FunkyMediaTab-the-extension1@mozilla.com": {minVersion: "0.1.9", installs: 63},
  "TopTabTV-the-extension1@mozilla.com": {minVersion: "0.1.9", installs: 63},
  "{018f3160-1a6f-4650-84fd-aad8c13609c8}": {minVersion: "0.1.1-signed.1-signed", installs: 62},
  "{2e710e6b-5e9d-44ba-8f4e-09a040978b49}": {minVersion: "1.7", installs: 62},
  "{c1970c0d-dbe6-4d91-804f-c9c0de643a57}": {minVersion: "1.3.2.13.1-signed.1-signed", installs: 62},
  "{c9b4529a-eeba-4e48-976e-f3d3f9026e04}": {minVersion: "1.1.1-signed.1-signed", installs: 62},
  "{df4e4df5-5cb7-46b0-9aef-6c784c3249f8}": {minVersion: "1.3.0.1-signed.1-signed", installs: 62},
  "@stremio": {minVersion: "1.0.2", installs: 62},
  "application@les-pages.com": {minVersion: "4.4.0", installs: 62},
  "ffvkontaktemusic@chupakabr.ru": {minVersion: "2.2.1-signed.1-signed", installs: 62},
  "firefinder@robertnyman.com": {minVersion: "1.4.1-signed.1-signed", installs: 62},
  "formhistory@yahoo.com": {minVersion: "1.4.0.6", installs: 62},
  "fxclickonce@rushyo.com": {minVersion: "0.1.1-signed.1-signed", installs: 62},
  "gmail@borsosfisoft.com": {minVersion: "1.0.1.1-signed.1-signed", installs: 62},
  "HighlightedTextToFile@bobbyrne01.org": {minVersion: "2.7.1", installs: 62},
  "jid1-n85lxPv1NAWVTQ@jetpack": {minVersion: "0.96.1.1-signed", installs: 62},
  "ramback@pavlov.net": {minVersion: "1.0.1-signed.1-signed", installs: 62},
  "VacuumPlacesImproved@lultimouomo-gmail.com": {minVersion: "1.2.1-signed.1-signed", installs: 62},
  "@News": {minVersion: "0.2.0", installs: 61},
  "{45d8ff86-d909-11db-9705-005056c00008}": {minVersion: "1.3.4.8", installs: 61},
  "{686fc9c5-c339-43db-b93a-5181a217f9a6}": {minVersion: "1.11", installs: 61},
  "{ea2b95c2-9be8-48ed-bdd1-5fcd2ad0ff99}": {minVersion: "0.3.8.1.1-signed.1-signed", installs: 61},
  "@chomikuj": {minVersion: "1.2.0", installs: 61},
  "avg@wtu3": {minVersion: "3.7.0.0", installs: 61},
  "jid1-f7dnBeTj8ElpWQ@jetpack": {minVersion: "1.34.1-signed.1-signed", installs: 61},
  "jid1-OY8Xu5BsKZQa6A@jetpack": {minVersion: "2.0.21", installs: 61},
  "jid1-u9RbFp9JcoEGGw@jetpack": {minVersion: "1.2.2.1-signed.1-signed", installs: 61},
  "plugin@okta.com": {minVersion: "5.8.0", installs: 61},
  "showpassword@pratikpoddar": {minVersion: "1.7.1-signed.1-signed", installs: 61},
  "IGF.F3@igufei.com": {minVersion: "3.2.11", installs: 60},
  "{12b6fdcd-4423-4276-82a3-73fdbff5f7e4}": {minVersion: "50", installs: 60},
  "{8F6A6FD9-0619-459f-B9D0-81DE065D4E21}": {minVersion: "1.13", installs: 60},
  "jid1-mW7iuA66Ny8Ziw@jetpack": {minVersion: "0.9.1-signed.1-signed", installs: 60},
  "nishan.naseer.googimagesearch@gmail.com": {minVersion: "0.5.1-signed.1-signed", installs: 60},
  "quicksearch@yandex.ru": {minVersion: "1.0.13", installs: 60},
  "{902D2C4A-457A-4EF9-AD43-7014562929FF}": {minVersion: "0.6.4", installs: 59},
  "@yset": {minVersion: "0.0.10", installs: 59},
  "csscoverage@spaghetticoder.org": {minVersion: "0.3.4.1-signed.1-signed", installs: 59},
  "dgnria2@nuance.com": {minVersion: "15.00.000.058", installs: 59},
  "firequery@binaryage.com": {minVersion: "2.0.4", installs: 59},
  "IBM-cck@firefox-extensions.ibm.com": {minVersion: "2.3.0", installs: 59},
  "trackmenot@mrl.nyu.edu": {minVersion: "0.9.2", installs: 59},
  "_chMembers_@free.discoverancestry.com": {minVersion: "7.102.10.3818", installs: 58},
  "{338e0b96-2285-4424-b4c8-e25560750fa3}": {minVersion: "3.1-signed.1-signed", installs: 58},
  "{8b5bea8c-6194-4c7c-a440-d5ca181480c3}": {minVersion: "1.500.000.11", installs: 58},
  "{e30e9060-21d5-11e3-8224-0800200c9a66}": {minVersion: "1.2.12", installs: 58},
  "LDshowpicture_plashcor@gmail.com": {minVersion: "3.2", installs: 58},
  "open.about.permissions@jasnapaka.com": {minVersion: "1.2.1-signed.1-signed", installs: 58},
  "sqlime@security.compass": {minVersion: "0.4.7.1-signed.1-signed", installs: 58},
  "@jetpack-easy-turism2": {minVersion: "7.1.0", installs: 57},
  "check4change-owner@mozdev.org": {minVersion: "1.9.8.1", installs: 57},
  "jid1-SDFC9fEAZRW7ab@jetpack": {minVersion: "0.1.3.1-signed.1-signed", installs: 57},
  "linkgopher@oooninja.com": {minVersion: "1.3.3.1-signed.1-signed", installs: 57},
  "pixelperfectplugin@openhouseconcepts.com": {minVersion: "2.0.14", installs: 57},
  "YoutubeDownloader@huangho.net76.net": {minVersion: "1.6.5.1-signed.1-signed", installs: 57},
  "lwthemes-manager@loucypher": {minVersion: "0.2.1-signed.1-let-fixed.1-signed", installs: 56},
  "_eiMembers_@www.100sofrecipes.com": {minVersion: "7.102.10.3580", installs: 56},
  "{068c594c-1a69-4f51-888d-1e231eac59a3}": {minVersion: "1", installs: 56},
  "{139C4B80-60ED-11E4-80EC-84041E5D46B0}": {minVersion: "1.3", installs: 56},
  "{4c7097f7-08f2-4ef2-9b9f-f95fa4cbb064}": {minVersion: "1.1", installs: 56},
  "{776f38cb-6255-4b92-b5cf-e5c71ff2b688}": {minVersion: "1.6", installs: 56},
  "{79c50f9a-2ffe-4ee0-8a37-fae4f5dacd4f}": {minVersion: "5.1.3", installs: 56},
  "{8BCA0E8A-E57B-425b-A05B-CD3868EB577E}": {minVersion: "1.4.1-signed.1-signed", installs: 56},
  "easycopypaste@everhelper.me": {minVersion: "1.1.0.1-signed.1-signed", installs: 56},
  "NoiaFoxoption@davidvincent.tld": {minVersion: "3.0.2.1-signed", installs: 56},
  "r2d2b2g@mozilla.org": {minVersion: "4.0.4.1-signed", installs: 56},
  "TFToolbarX@torrent-finder": {minVersion: "1.3.1.1-signed.1-signed", installs: 56},
  "{E4091D66-127C-11DB-903A-DE80D2EFDFE8}": {minVersion: "1.6.5.5.1-signed.1-signed", installs: 55},
  "downintab@max.max": {minVersion: "1.00.1-signed.1-signed", installs: 55},
  "flv2mp3@hotger.com": {minVersion: "2.3.2-signed", installs: 55},
  "ISVCU@iSkysoft.com": {minVersion: "5.1.0", installs: 55},
  "jid1-n5ARdBzHkUEdAA@jetpack": {minVersion: "3.8.7", installs: 55},
  "rpnetdownloadhelper@gmail.com": {minVersion: "3.0.1-signed.1-signed", installs: 55},
  "shpassword@shpassword.fr": {minVersion: "0.3.1-signed.1-signed", installs: 55},
  "snt@simplenewtab.com": {minVersion: "1.3", installs: 55},
  "admin@djamol.com": {minVersion: "4.31.1-signed.1-signed", installs: 54},
  "{22870005-adef-4c9d-ae36-d0e1f2f27e5a}": {minVersion: "0.4.0.9.1.1-signed.1-signed", installs: 54},
  "{DBBB3167-6E81-400f-BBFD-BD8921726F52}": {minVersion: "7125.2016.0115.2213", installs: 54},
  "{e4f94d1e-2f53-401e-8885-681602c0ddd8}": {minVersion: "1.0.1-signed.1-signed", installs: 54},
  "{FBF6D7FB-F305-4445-BB3D-FEF66579A033}": {minVersion: "6", installs: 54},
  "5aa55fd5-6e61-4896-b186-fdc6f298ec92@mozilla": {minVersion: "0.1.2.1-signed", installs: 54},
  "fireml@sirma.bg": {minVersion: "1.1.11.1-signed.1-signed", installs: 54},
  "info@priceblink.com": {minVersion: "4.8", installs: 54},
  "jid0-f82gosWvE8oeGQt6WDCGRF1Dy7Q@jetpack": {minVersion: "1.0.003", installs: 54},
  "jid0-hyjN250ZzTOOX3evFwwAQBxE4ik@jetpack": {minVersion: "6.0.1-signed.1-signed", installs: 54},
  "restart@restart.org": {minVersion: "0.5.1-signed.1-signed", installs: 54},
  "webmaster@keep-tube.com": {minVersion: "1.2.1-signed.1-signed", installs: 54},
  "eliteproxyswitcher@my-proxy.com": {minVersion: "1.2.0.2.1-signed.1-signed", installs: 53},
  "foxfilter@inspiredeffect.net": {minVersion: "7.7.1-signed.1-signed", installs: 53},
  "searchprivacy@searchprivacy.co": {minVersion: "1.15", installs: 53},
  "SignPlugin@pekao.pl": {minVersion: "1.4.0.73", installs: 53},
  "{15fe27f3-e5ab-2d59-4c5c-dadc7945bdbd}": {minVersion: "2.1.1.1-signed.1-signed", installs: 52},
  "ipfuck@p4ul.info": {minVersion: "1.2.1.1-signed.1-signed", installs: 52},
  "jyboy.yy@gmail.com": {minVersion: "1.0.4.1-signed.1-signed", installs: 52},
  "MySafeTabs-the-extension1@mozilla.com": {minVersion: "0.1.9", installs: 52},
  "saiful.neo@gmail.com": {minVersion: "3.0.1-signed.1-signed", installs: 52},
  "sendtokindle@amazon.com": {minVersion: "1.0.2.76", installs: 52},
  "smile1Button@amazon.com": {minVersion: "1.0.1-signed.1-signed", installs: 52},
  "whodeletedme@deleted.io": {minVersion: "0.3.3", installs: 52},
  "{C0CB8BA3-6C1B-47e8-A6AB-1FAB889562D9}": {minVersion: "0.7.6", installs: 51},
  "@irctctatkal": {minVersion: "2.0.0", installs: 51},
  "antgroup@antdownloadmanager.com": {minVersion: "0.1.7", installs: 51},
  "downloadplan@firefoxmania.uci.cu": {minVersion: "1.3.1-signed.1-signed", installs: 51},
  "jid1-AoXeeOB4j7kFdA@jetpack": {minVersion: "8.1", installs: 51},
  "memoryrestart@teamextension.com": {minVersion: "1.18.1-signed.1-signed", installs: 51},
  "multifox-toolbar-button@rbaldwin": {minVersion: "4.28.1-signed.1-signed", installs: 51},
  "soaclient@santoso": {minVersion: "0.2.1-signed.1-signed", installs: 51},
  "speeddns@gmail.com": {minVersion: "0.2.1-signed.1-signed", installs: 51},
  "windowandtablimiter@weintraut.net": {minVersion: "4.28.1-signed.1-signed", installs: 51},
  "@Recipes": {minVersion: "0.2.0", installs: 50},
  "{e6a9a96e-4a08-4719-b9bd-0e91c35aaabc}": {minVersion: "1.3.1.1-signed.1-signed", installs: 50},
  "autopager@mozilla.org": {minVersion: "0.8.0.10.1-signed.1-signed", installs: 50},
  "btpersonas@brandthunder.com": {minVersion: "2.0.4.7", installs: 50},
  "gdrivepanel@alejandrobrizuela.com.ar": {minVersion: "1.0.2.1-signed.1-signed", installs: 50},
  "jid1-m3kqTBs1zKXXaA@jetpack": {minVersion: "0.2.6.1-signed.1-signed", installs: 50},
  "qqmail_plugin_for_firefox@tencent.com": {minVersion: "1.0.0.22", installs: 50},
  "savefileto@mozdev.org": {minVersion: "2.5.5", installs: 50},
  "seodoctor@prelovac.com": {minVersion: "1.6.5.1-signed.1-signed", installs: 50},
  "support@todoist.com": {minVersion: "4.0.5", installs: 50},
  "toolbar_TeoMediaTB@apn.ask.com": {minVersion: "135.3", installs: 50},
  "txftn@tencent.com": {minVersion: "1.0.0.7", installs: 50},
};

// ================== END OF LIST FOR 51 ======================


// We use these named policies to correlate the telemetry
// data with them, in order to understand how each set
// is behaving in the wild.
const RolloutPolicy = {
  // Used during 48 Beta cycle
  "2a": { addons: set2, webextensions: true },
  "2b": { addons: set2, webextensions: false },

  // Set agreed for Release 49
  "49a": { addons: set49Release, webextensions: true },
  "49b": { addons: set49Release, webextensions: false },

  // Smaller set that can be used for Release 49
  "49limiteda": { addons: set49PaneOnly, webextensions: true },
  "49limitedb": { addons: set49PaneOnly, webextensions: false },

  // Beta testing on 50
  "50allmpc": { addons: [], webextensions: true, mpc: true },

  // Beta testing on 51
  "51alladdons": { addons: [], webextensions: true, alladdons: true },

  // 51 release
  "51set1": { addonsv2: set51Release, installs:   50, webextensions: true, mpc: true },
  "51set2": { addonsv2: set51Release, installs:  100, webextensions: true, mpc: true },
  "51set3": { addonsv2: set51Release, installs:  300, webextensions: true, mpc: true },
  "51set4": { addonsv2: set51Release, installs: 1000, webextensions: true, mpc: true },

  // ESR
  "esrA": { addons: [], mpc: true, webextensions: true },
  "esrB": { addons: [], mpc: true, webextensions: false },
  "esrC": { addons: [], mpc: false, webextensions: true },

  "xpcshell-test": { addons: [ADDONS.test1, ADDONS.test2], webextensions: false },
};

Object.defineProperty(this, "isAddonPartOfE10SRollout", {
  configurable: false,
  enumerable: false,
  writable: false,
  value: function isAddonPartOfE10SRollout(aAddon) {
    let blocklist = Preferences.get(PREF_E10S_ADDON_BLOCKLIST, "");
    let policyId = Preferences.get(PREF_E10S_ADDON_POLICY, "");

    if (!policyId || !RolloutPolicy.hasOwnProperty(policyId)) {
      return false;
    }

    if (blocklist && blocklist.indexOf(aAddon.id) > -1) {
      return false;
    }

    let policy = RolloutPolicy[policyId];

    if (aAddon.mpcOptedOut == true) {
      return false;
    }

    if (policy.alladdons) {
      return true;
    }

    if (policy.webextensions && (aAddon.type == "webextension" || aAddon.type == "webextension-theme")) {
      return true;
    }

    if (policy.mpc && aAddon.multiprocessCompatible) {
      return true;
    }

    if (policy.addonsv2) {
      if (aAddon.id in policy.addonsv2) {
        let rolloutAddon = policy.addonsv2[aAddon.id];

        if (rolloutAddon.installs >= policy.installs &&
            Services.vc.compare(aAddon.version, rolloutAddon.minVersion) >= 0) {
          return true;
        }
      }
      return false;
    }

    for (let rolloutAddon of policy.addons) {
      if (aAddon.id == rolloutAddon.id &&
          Services.vc.compare(aAddon.version, rolloutAddon.minVersion) >= 0) {
        return true;
      }
    }

    return false;
  },
});
