// Copyright (c) 2015 Marshall A. Greenblatt. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//    * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//    * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
//    * Neither the name of Google Inc. nor the name Chromium Embedded
// Framework nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool and should not be edited
// by hand. See the translator.README.txt file in the tools directory for
// more information.
//

#![allow(non_snake_case, unused_imports)]

use eutil;
use interfaces;
use types;
use wrappers::CefWrap;

use libc;
use std::collections::HashMap;
use std::mem;
use std::ptr;

//
// Structure used to represent an entry in navigation history.
//
#[repr(C)]
pub struct _cef_navigation_entry_t {
  //
  // Base structure.
  //
  pub base: types::cef_base_t,

  //
  // Returns true (1) if this object is valid. Do not call any other functions
  // if this function returns false (0).
  //
  pub is_valid: Option<extern "C" fn(
      this: *mut cef_navigation_entry_t) -> libc::c_int>,

  //
  // Returns the actual URL of the page. For some pages this may be data: URL or
  // similar. Use get_display_url() to return a display-friendly version.
  //
  // The resulting string must be freed by calling cef_string_userfree_free().
  pub get_url: Option<extern "C" fn(
      this: *mut cef_navigation_entry_t) -> types::cef_string_userfree_t>,

  //
  // Returns a display-friendly version of the URL.
  //
  // The resulting string must be freed by calling cef_string_userfree_free().
  pub get_display_url: Option<extern "C" fn(
      this: *mut cef_navigation_entry_t) -> types::cef_string_userfree_t>,

  //
  // Returns the original URL that was entered by the user before any redirects.
  //
  // The resulting string must be freed by calling cef_string_userfree_free().
  pub get_original_url: Option<extern "C" fn(
      this: *mut cef_navigation_entry_t) -> types::cef_string_userfree_t>,

  //
  // Returns the title set by the page. This value may be NULL.
  //
  // The resulting string must be freed by calling cef_string_userfree_free().
  pub get_title: Option<extern "C" fn(
      this: *mut cef_navigation_entry_t) -> types::cef_string_userfree_t>,

  //
  // Returns the transition type which indicates what the user did to move to
  // this page from the previous page.
  //
  pub get_transition_type: Option<extern "C" fn(
      this: *mut cef_navigation_entry_t) -> types::cef_transition_type_t>,

  //
  // Returns true (1) if this navigation includes post data.
  //
  pub has_post_data: Option<extern "C" fn(
      this: *mut cef_navigation_entry_t) -> libc::c_int>,

  //
  // Returns the time for the last known successful navigation completion. A
  // navigation may be completed more than once if the page is reloaded. May be
  // 0 if the navigation has not yet completed.
  //
  pub get_completion_time: Option<extern "C" fn(
      this: *mut cef_navigation_entry_t) -> types::cef_time_t>,

  //
  // Returns the HTTP status code for the last known successful navigation
  // response. May be 0 if the response has not yet been received or if the
  // navigation has not yet completed.
  //
  pub get_http_status_code: Option<extern "C" fn(
      this: *mut cef_navigation_entry_t) -> libc::c_int>,

  //
  // The reference count. This will only be present for Rust instances!
  //
  pub ref_count: u32,

  //
  // Extra data. This will only be present for Rust instances!
  //
  pub extra: u8,
}

pub type cef_navigation_entry_t = _cef_navigation_entry_t;


//
// Structure used to represent an entry in navigation history.
//
pub struct CefNavigationEntry {
  c_object: *mut cef_navigation_entry_t,
}

impl Clone for CefNavigationEntry {
  fn clone(&self) -> CefNavigationEntry{
    unsafe {
      if !self.c_object.is_null() {
        ((*self.c_object).base.add_ref.unwrap())(&mut (*self.c_object).base);
      }
      CefNavigationEntry {
        c_object: self.c_object,
      }
    }
  }
}

impl Drop for CefNavigationEntry {
  fn drop(&mut self) {
    unsafe {
      if !self.c_object.is_null() {
        ((*self.c_object).base.release.unwrap())(&mut (*self.c_object).base);
      }
    }
  }
}

impl CefNavigationEntry {
  pub unsafe fn from_c_object(c_object: *mut cef_navigation_entry_t) -> CefNavigationEntry {
    CefNavigationEntry {
      c_object: c_object,
    }
  }

  pub unsafe fn from_c_object_addref(c_object: *mut cef_navigation_entry_t) -> CefNavigationEntry {
    if !c_object.is_null() {
      ((*c_object).base.add_ref.unwrap())(&mut (*c_object).base);
    }
    CefNavigationEntry {
      c_object: c_object,
    }
  }

  pub fn c_object(&self) -> *mut cef_navigation_entry_t {
    self.c_object
  }

  pub fn c_object_addrefed(&self) -> *mut cef_navigation_entry_t {
    unsafe {
      if !self.c_object.is_null() {
        eutil::add_ref(self.c_object as *mut types::cef_base_t);
      }
      self.c_object
    }
  }

  pub fn is_null_cef_object(&self) -> bool {
    self.c_object.is_null()
  }
  pub fn is_not_null_cef_object(&self) -> bool {
    !self.c_object.is_null()
  }

  //
  // Returns true (1) if this object is valid. Do not call any other functions
  // if this function returns false (0).
  //
  pub fn is_valid(&self) -> libc::c_int {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).is_valid.unwrap())(
          self.c_object))
    }
  }

  //
  // Returns the actual URL of the page. For some pages this may be data: URL or
  // similar. Use get_display_url() to return a display-friendly version.
  //
  // The resulting string must be freed by calling cef_string_userfree_free().
  pub fn get_url(&self) -> String {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).get_url.unwrap())(
          self.c_object))
    }
  }

  //
  // Returns a display-friendly version of the URL.
  //
  // The resulting string must be freed by calling cef_string_userfree_free().
  pub fn get_display_url(&self) -> String {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).get_display_url.unwrap())(
          self.c_object))
    }
  }

  //
  // Returns the original URL that was entered by the user before any redirects.
  //
  // The resulting string must be freed by calling cef_string_userfree_free().
  pub fn get_original_url(&self) -> String {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).get_original_url.unwrap())(
          self.c_object))
    }
  }

  //
  // Returns the title set by the page. This value may be NULL.
  //
  // The resulting string must be freed by calling cef_string_userfree_free().
  pub fn get_title(&self) -> String {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).get_title.unwrap())(
          self.c_object))
    }
  }

  //
  // Returns the transition type which indicates what the user did to move to
  // this page from the previous page.
  //
  pub fn get_transition_type(&self) -> types::cef_transition_type_t {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).get_transition_type.unwrap())(
          self.c_object))
    }
  }

  //
  // Returns true (1) if this navigation includes post data.
  //
  pub fn has_post_data(&self) -> libc::c_int {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).has_post_data.unwrap())(
          self.c_object))
    }
  }

  //
  // Returns the time for the last known successful navigation completion. A
  // navigation may be completed more than once if the page is reloaded. May be
  // 0 if the navigation has not yet completed.
  //
  pub fn get_completion_time(&self) -> types::cef_time_t {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).get_completion_time.unwrap())(
          self.c_object))
    }
  }

  //
  // Returns the HTTP status code for the last known successful navigation
  // response. May be 0 if the response has not yet been received or if the
  // navigation has not yet completed.
  //
  pub fn get_http_status_code(&self) -> libc::c_int {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).get_http_status_code.unwrap())(
          self.c_object))
    }
  }
} 

impl CefWrap<*mut cef_navigation_entry_t> for CefNavigationEntry {
  fn to_c(rust_object: CefNavigationEntry) -> *mut cef_navigation_entry_t {
    rust_object.c_object_addrefed()
  }
  unsafe fn to_rust(c_object: *mut cef_navigation_entry_t) -> CefNavigationEntry {
    CefNavigationEntry::from_c_object_addref(c_object)
  }
}
impl CefWrap<*mut cef_navigation_entry_t> for Option<CefNavigationEntry> {
  fn to_c(rust_object: Option<CefNavigationEntry>) -> *mut cef_navigation_entry_t {
    match rust_object {
      None => ptr::null_mut(),
      Some(rust_object) => rust_object.c_object_addrefed(),
    }
  }
  unsafe fn to_rust(c_object: *mut cef_navigation_entry_t) -> Option<CefNavigationEntry> {
    if c_object.is_null() {
      None
    } else {
      Some(CefNavigationEntry::from_c_object_addref(c_object))
    }
  }
}

