/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

"use strict";

/* exported DomainWhitelist */
this.EXPORTED_SYMBOLS = ["DomainWhitelist"];

this.DomainWhitelist = Object.freeze({
  check(domain) {
    return gWhitelist.has(domain);
  }
});

// Convert the multiline list of domains into a Set for lookup.
const gWhitelist = new Set(`
01net.com
07073.com
10086.cn
104.com.tw
1111.com.tw
114la.com
11st.co.kr
120ask.com
12306.cn
123cha.com
123rf.com
126.com
1337x.to
163.com
1688.com
16lao.com
17173.com
178.com
17k.com
17ok.com
17track.net
189.cn
1905.com
1and1.com
1edisource.com
1tv.ru
1und1.de
20minutes.fr
20minutos.es
2345.com
247sports.com
24h.com.vn
24hourfitness.com
28.com
2ch-c.net
2ch.net
2chan.net
2chblog.jp
2gis.ru
315che.com
360.cn
360.com
360doc.com
39.net
3dmgame.com
3m.com
3tailer.com
42mr.com
4399.com
4chan.org
4dsply.com
4gamer.net
4pda.ru
4shared.com
500px.com
51.la
51auto.com
51cto.com
51sole.com
51yes.com
525j.com.cn
58.com
58pic.com
5dcar.com
6park.com
6pm.com
7769domain.com
99acres.com
9gag.com
a10.com
aa.com
aafp.org
aamc.org
aao.org
aaos.org
aarp.org
aastocks.com
abc.es
abc.net.au
abchina.com
abebooks.com
abercrombie.com
about.com
abplive.in
abril.com.br
abs-cbn.com
absoluteclickscom.com
academia.edu
academy.com
accommodationforstudents.com
accorhotels.com
accuweather.com
acer.com
acfun.tv
activerain.com
ad-tech.com
ad4game.com
adcash.com
additudemag.com
addthis.com
adf.ly
adidas.com
adk2x.com
admaimai.com
adme.ru
adnetworkperformance.com
adobe.com
adorama.com
adp.com
adplxmd.com
adservingsolutionsinc.com
adservone.com
adslgate.com
ae.com
aegeanair.com
aerlingus.com
aeroflot.ru
aeromexico.com
aeroplan.com
aerosoles.com
aftonbladet.se
agar.io
agoda.com
ahg.com
ahit.com
ahrq.gov
airarabia.com
airasia.com
airastana.com
airberlin.com
airbnb.com
aircanada.com
aireuropa.com
airfrance.com
airlinequality.com
airmiles.ca
airnewzealand.co.nz
airtel.in
ajanshaber.com
akamaihd.net
akb48matomemory.com
alarabiya.net
alaskaair.com
albawabhnews.com
alexa.cn
alexa.com
alfabank.ru
alfalfalfa.com
alfredangelo.com
ali213.net
alibaba.com
alicdn.com
alice.it
aliexpress.com
alimama.com
alipay.com
alitalia.com
aliyun.com
aljaras.com
aljazeera.net
all-free-download.com
all2lnk.com
allabout.co.jp
allegiantair.com
allegro.pl
allmyvideos.net
allocine.fr
allrecipes.com
almasryalyoum.com
altervista.org
alwafd.org
alz.org
am15.net
ama-assn.org
amadeus.net
amarujala.com
amazon.ca
amazon.cn
amazon.co.jp
amazon.co.uk
amazon.com
amazon.de
amazon.es
amazon.fr
amazon.in
amazon.it
amazonaws.com
ameba.jp
ameblo.jp
americanas.com.br
americanexpress.com
americanschoolnj.com
amorepacific.com
ampclicks.com
ampxchange.com
ana.co.jp
ancestry.com
android.com
androidauthority.com
androidcentral.com
angieslist.com
anitube.se
anjuke.com
annualcreditreport.com
answers.com
anthropologie.com
aol.com
apa.org
apache.org
aparat.com
apartmenttherapy.com
aplaceformom.com
apple.com
appledaily.com.tw
appraisalbuzz.com
appraisalinstitute.org
appraisers.org
appraisersforum.com
appraiserusa.com
arbeitsagentur.de
arcelik.com.tr
archive.org
archiveofourown.org
arcot.com
arcteryx.com
arduino.cc
areaa.org
argaam.com
argos.co.uk
ariba.com
arinet.com
arstechnica.com
as.com
asahi.com
asana.com
ascii.jp
asda.com
asha.org
ashleyfurniture.com
asia-lists.com
asiatravel.com
asicsamerica.com
ask.com
ask.fm
askmebazaar.com
askubuntu.com
asos.com
asriran.com
assetline.com
asus.com
atkins.com
atlassian.net
att.com
att.net
atwiki.jp
aucfan.com
auction.co.kr
audible.com
audio-technica.com
auntyacid.com
ausopen.com
austrian.com
authoritynutrition.com
auto.ru
autoblog.com
autobytel.com
autodesk.com
autohome.com.cn
autoscout24.de
autotrader.co.uk
autotrader.com
avast.com
avclub.com
aveda.com
avery.com
avforums.com
avg.com
avira.com
avito.ma
avito.ru
aweber.com
axia.com
axisbank.co.in
axisbank.com
azet.sk
azlyrics.com
b2btech.com
b3net.com
b9dm.com
bab.la
babycenter.com
babylon.com
babytree.com
backcountry.com
backpage.com
backyardchickens.com
badoo.com
bahn.de
baidu.com
baike.com
baimao.com
baixaki.com.br
bandcamp.com
banggood.com
banki.ru
bankmellat.ir
bankofamerica.com
bankrate.com
barbie.com
barbour.com
barcelo.com
barclaycardus.com
barclays.co.uk
barnesandnoble.com
bartarinha.ir
basecamp.com
bassettfurniture.com
basspro.com
bastillepost.com
bathandbodyworks.com
battle.net
battlefield.com
bayt.com
bb.com.br
bbb.org
bbc.co.uk
bbc.com
bbt.com
bbteam.com
bc.vc
bedandbreakfast.com
bedbathandbeyond.com
beeline.ru
behance.net
belkin.com
benetton.com
beretta.com
berkeley.edu
bestadbid.com
bestbuy.com
bestwestern.com
bet365.com
bettycrocker.com
beytoote.com
bgr.com
bhaskar.com
bhg.com
bhphotovideo.com
biblegateway.com
bidvertiser.com
big5sportinggoods.com
biglike.com
biglobe.ne.jp
bild.de
bilibili.com
billboard.com
billdesk.com
bing.com
bintang.com
biobiochile.cl
biomedcentral.com
bioyun.com
birdsallinteractive.com
bissell.com
bitauto.com
bitbucket.org
bitly.com
bizjournals.com
bkstr.com
blablacar.es
blackboard.com
blackhatworld.com
bleacherreport.com
blkget.com
blobla.com
blocket.se
blog.com
blog.ir
blog.jp
blog.me
blogfa.com
blogger.com
blogimg.jp
blogphongthuy.com
blogsky.com
blomaga.jp
bloomberg.com
blu-ray.com
bluehost.com
bmi.ir
bmj.com
bobvila.com
boc.cn
bodybuilding.com
bol.com
bollywoodbubble.com
bom.gov.au
boma.org
bomb01.com
bonanza.com
bonappetit.com
bongda60.net
booking.com
bookmyshow.com
boredpanda.com
bose.com
bottlenose-wine.com
box.com
boxofficemojo.com
boylesoftware.com
bp.blogspot.com
bradesco.com.br
brainyquote.com
brassring.com
braun.com
breastcancer.org
breitbart.com
brides.com.cn
bridgestreet.com
britishairways.com
brusselsairlines.com
bs.to
bsnl.in
bt.com
btolat.com
bttiantang.com
buffiniandcompany.com
bukalapak.com
bullhorn.com
burton.com
buscape.com.br
businessinsider.com
businessol.com
businessweekly.com.tw
bustle.com
buyerzone.com
buyreman.com
buzzfeed.com
buzzfil.net
buzzlie.com
c-loans.com
c3i-inc.com
ca.gov
cabelas.com
caf.fr
cafemom.com
cafepress.com
caijing.com.cn
caisse-epargne.fr
caixa.gov.br
caixin.com
cambridge.org
camdenliving.com
camelbak.com
cameloteurope.com
cancer.gov
cancer.org
cankaoxiaoxi.com
cannondale.com
canva.com
capitalone.com
capitalone360.com
carcomplaints.com
care.com
careerbuilder.com
careerwebschool.com
carfax.com
cargurus.com
carhartt.com
carmax.com
carnival.com
cars.com
carsensor.net
carters.com
cartier.com
carview.co.jp
carwale.com
casasbahia.com.br
cateye.com
cathaypacific.com
cb01.co
cbc.ca
cbre.com
cbrehotels.com
cbs.com
cbslocal.com
cbsnews.com
cbssports.com
cc.com
ccb.com
ccb.com.cn
ccim.com
ccm.net
cda.pl
cdc.gov
cdiscount.com
cdstm.cn
ce.cn
cebupacificair.com
cecil.de
ceconline.com
celebritycruises.com
ceneo.pl
century21.com
cerner.com
cesweb.org
championat.com
championsschool.com
change.org
charitynavigator.org
charter.net
chase.com
chatwork.com
cheapflights.co.uk
cheaptickets.com
cheezburger.com
chefkoch.de
chegg.com
chekb.com
chess.com
chicagotribune.com
childrensplace.com
china-airlines.com
china.com
china.com.cn
chinadaily.com.cn
chinaso.com
chinatimes.com
chinaz.com
chip.de
chiphell.com
choicehotels.com
chosun.com
chouftv.ma
christian-dogma.com
christianlouboutin.com
chron.com
ci123.com
cimls.com
cinemablend.com
cisco.com
citi.com
citibank.co.in
citibankonline.com
citilink.ru
citizensadvice.org.uk
citrixonline.com
city-data.com
cityadspix.com
cityheaven.net
ck101.com
clarin.com
clarkhoward.com
cleartrip.com
clevelandclinic.org
clickadu.com
clickbank.com
clicksvenue.com
clien.net
cliftonlabs.com
clinicaltrials.gov
clinique.com
clipconverter.cc
clixsense.com
cloudflare.com
cloudsrvtrk.com
cms.gov
cna.com.tw
cnbc.com
cnbeta.com
cnblogs.com
cnet.com
cnmo.com
cnn.com
cnnic.cn
cntraveler.com
cntv.cn
cnzz.com
coccoc.com
cocolog-nifty.com
codecademy.com
codecanyon.net
codepen.io
codeproject.com
coldwellbanker.com
colgate.com
collegeboard.org
collegerentals.com
colliers.com
columbia.com
columbia.edu
comcast.net
comenity.net
commbank.com.au
commentcamarche.net
commerx.com
complaintsboard.com
complex.com
computerbild.de
concursolutions.com
condor.com
conservativetribune.com
constantcontact.com
consumeraffairs.com
consumercomplaints.in
consumerist.com
consumerlab.com
consumerreports.org
consumersearch.com
containerstore.com
contentabc.com
continuingedexpress.com
convert2mp3.net
cookinglight.com
cookpad.com
cooks.com
cooksillustrated.com
coolmath-games.com
copaair.com
corelogic.com
cornell.edu
corporatehousingbyowner.com
correios.com.br
corriere.it
cosmopolitan.com
costar.com
costco.com
couchsurfing.com
countryliving.com
coupons.com
coursera.org
covalentworks.com
cox.net
cpasbien.io
cpsc.gov
cqnews.net
cracked.com
craigslist.ca
craigslist.org
crateandbarrel.com
creativemarket.com
credai.org
credit-agricole.fr
creditkarma.com
creditmutuel.fr
crefcoa.com
crewnetwork.org
crhoy.com
cricbuzz.com
criteo.com
crm-daily.com
crmbuyer.com
crs.com
crunchbase.com
crunchyroll.com
crutchfield.com
csc.com
csdn.net
ctitv.com.tw
ctrip.com
cuisinart.com
cushwake.com
custhelp.com
cvs.com
cxml.org
cygnet-infotech.com
dafont.com
daikynguyenvn.com
daily.co.jp
dailykos.com
dailymail.co.uk
dailymotion.com
dailypakistan.com.pk
dailysnark.com
danawa.com
dangdang.com
dantri.com.vn
dartappraisal.com
dataart.com
daum.net
daveramsey.com
davidsbridal.com
davita.com
dawn.com
deadspin.com
dealnews.com
debate.com.mx
decathlon.co.uk
deere.com
deesign.com
deezer.com
dell.com
delta.com
demandstar.com
demc.com
depositphotos.com
descartes.com
dessy.com
detik.com
deviantart.com
deviantart.net
dhgate.com
dhl.com
dhl.de
diabetes.co.uk
diabetes.org
diamondresorts.com
dianping.com
dickssportinggoods.com
dict.cc
diesel.com
digg.com
digikala.com
digitalenterprise.org
digitalmesh.com
digitalocean.com
digitalriver.com
digitaltrends.com
digitas.com
dillards.com
dingit.tv
diply.com
directrev.com
directv.com
discogs.com
discover.com
discovercard.com
discuss.com.hk
dish.com
disney.com
disneystore.com
disq.us
disqus.com
divar.ir
diynetwork.com
djpunjab.info
dl-protect.com
dmm.com
dmv.org
dnaindia.com
dns-shop.ru
docin.com
doculabs.com
docusign.net
dogfoodadvisor.com
doisongphapluat.com
domaintools.com
dominos.com
donanimhaber.com
donga.com
doodle.com
doorblog.jp
dostor.org
douban.com
doubleclick.net
douguo.com
douyutv.com
dpreview.com
dreamstime.com
dribbble.com
drive2.ru
drom.ru
dropbooks.tv
dropbox.com
dropboxusercontent.com
drudgereport.com
drugabuse.gov
drugs.com
drugstore.com
drweil.com
dslreports.com
dsw.com
dtz.com
duba.com
duckduckgo.com
dummies.com
duolingo.com
duowan.com
dw.com
dx.com
dynamicnet.net
dytt8.net
e-bizsoft.com
e-global.es
ea.com
earthclinic.com
earthlink.net
earthwaterfire.com
eastday.com
eastmoney.com
easyjet.com
easypano.com
eatingwell.com
ebates.com
ebay-kleinanzeigen.de
ebay.ca
ebay.co.uk
ebay.com
ebay.com.au
ebay.de
ebay.es
ebay.fr
ebay.in
ebay.it
ebookers.com
ebrun.com
ecco.com
echo.msk.ru
ecnavi.jp
ecollege.com
ecommerce-digest.com
ecommercebytes.com
ecommercepartners.net
ecommercetimes.com
economist.com
ed.gov
eddiebauer.com
edeal.com
edmodo.com
edmunds.com
edx.org
eenadu.net
egain.com
egou.com
ehow.com
eia.gov
ekantipur.com
eksisozluk.com
el-nacional.com
elcomercio.com
elcomercio.pe
elconfidencial.com
elcorteingles.es
eldorado.ru
electronicmarkets.org
elevenia.co.id
elfagr.org
elintransigente.com
elmogaz.com
elmundo.es
elpais.com
elsevier.com
eluniverso.com
elwatannews.com
emao.com
emarketingassociation.com
emgn.com
emirates.com
emol.com
enet.com.cn
enews.com.tw
engadget.com
engageya.com
ensonhaber.com
entrepreneur.com
envato.com
eonline.com
epic.com
epicurious.com
epochtimes.com
epweike.com
era.com
eram.fr
ergotron.com
ernestjones.co.uk
ero-advertising.com
ero-video.net
eroterest.net
espncricinfo.com
esquire.com
esuteru.com
etao.com
ethanallen.com
etrade.com
etsy.com
ettoday.net
europa.eu
eventbrite.com
evernote.com
evite.com
ew.com
ex.ua
examine.com
exblog.jp
excite.co.jp
execustay.com
exhentai.org
exhibitions.co.uk
exoclick.com
expedia.ca
expedia.com
express-scripts.com
express.co.uk
express.pk
extra.com.br
extratorrent.cc
eyny.com
eztv.ag
face-masr.com
facebook.com
facenama.com
faithtap.com
familydoctor.com.cn
familydoctor.org
famitsu.com
fanatik.com.tr
fandango.com
fanfiction.net
fang.com
fanhuan.com
fanli.com
fanniemae.com
fanpage.gr
farfesh.com
farsnews.com
fashiongo.net
fastclass.com
fastcompany.com
fatosdesconhecidos.com.br
fatwallet.com
faz.net
fbcdn.net
fc2.com
fda.gov
federaltitle.com
fedex.com
feedly.com
fema.gov
feng.com
fibre2fashion.com
fidelity.com
fiducia.de
filehippo.com
filmesonlinegratis.net
filmibeat.com
filmon.com
filmweb.pl
finecooking.com
finishclueobscure.info
finishline.com
finn.no
finnair.com
firmseek.com
firstpost.com
fisher-price.com
fitbit.com
fitnessmagazine.com
fitpregnancy.com
fiverr.com
fivethirtyeight.com
fixya.com
flashscore.com
flashx.tv
flatmates.com.au
flickr.com
flightnetwork.com
flightradar24.com
flipboard.com
flipkart.com
flirchi.com
flybe.com
flyfrontier.com
flysaa.com
flyuia.com
fnac.com
fnb.co.za
fntic.com
focus.cn
focus.de
fodors.com
food.com
food52.com
foodandwine.com
foodnetwork.com
fool.com
forbes.com
force.com
ford.com
forestcity.net
forever21.com
forgeofempires.com
forocoches.com
fortune.com
fotostrana.ru
foursquare.com
foxnews.com
foxsports.com
free.fr
freecharge.in
freejobalert.com
freelancer.com
freepeople.com
freepik.com
frigidaire.com
friv.com
fromdoctopdf.com
frommers.com
frontpoint.it
frys.com
ft.com
fueleconomy.gov
furnishedhousing.com
g2a.com
gaana.com
galleryofguns.com
gamefactory.jp
gamefaqs.com
gameforge.com
gamepedia.com
gamer.com.tw
gamersky.com
gamespot.com
gamestop.com
gamewith.jp
gamme.com.tw
gap.com
garanti.com.tr
gardenweb.com
garmin.com
gasbuddy.com
gawker.com
gazeta.pl
gazeta.ru
gazetaexpress.com
gazetevatan.com
gazzetta.it
ge.com
geappliances.com
gearbest.com
geekologie.com
geico.com
gemius.pl
genius.com
geocities.jp
getbootstrap.com
gethuman.com
getpocket.com
gfycat.com
ghanaweb.com
gia.edu
giant-bicycles.com
gidonline.club
gigazine.net
giphy.com
gismeteo.ru
github.com
gittigidiyor.com
givemesport.com
gizmodo.com
gizmodo.jp
glassdoor.com
globalpropertyguide.com
globalsources.com
globaltestmarket.com
globaltimes.cn
globest.com
globo.com
glock.com
gmanetwork.com
gmarket.co.kr
gmw.cn
gmx.net
gnavi.co.jp
gnc.com
go.com
go2000.com
go2cloud.org
goal.com
gocomics.com
godaddy.com
gofundme.com
goibibo.com
goldcoastschools.com
gome.com.cn
gongchang.com
goo-net.com
goo.gl
goo.ne.jp
goodgamestudios.com
goodhousekeeping.com
goodreads.com
goodrx.com
google-analytics.com
google.ae
google.at
google.az
google.ba
google.be
google.bg
google.by
google.ca
google.ch
google.cl
google.cn
google.co.id
google.co.il
google.co.in
google.co.jp
google.co.kr
google.co.ma
google.co.nz
google.co.th
google.co.tz
google.co.uk
google.co.ve
google.co.za
google.com
google.com.af
google.com.ar
google.com.au
google.com.bd
google.com.bo
google.com.br
google.com.co
google.com.do
google.com.ec
google.com.eg
google.com.gh
google.com.gt
google.com.hk
google.com.kw
google.com.ly
google.com.mx
google.com.my
google.com.ng
google.com.pe
google.com.ph
google.com.pk
google.com.pr
google.com.sa
google.com.sg
google.com.tr
google.com.tw
google.com.ua
google.com.vn
google.cz
google.de
google.dk
google.dz
google.es
google.fi
google.fr
google.gr
google.hr
google.hu
google.ie
google.iq
google.it
google.kz
google.lk
google.lt
google.lv
google.nl
google.no
google.pl
google.pt
google.ro
google.rs
google.ru
google.se
google.si
google.sk
google.tn
googleadservices.com
googleusercontent.com
gorillavid.in
gotomeeting.com
gotowebinar.com
gotporn.com
gougou.com
govome.com
gracobaby.com
grammarly.com
graphicriver.net
greatandhra.com
greatclips.com
greatergood.com
groupon.com
gs1.org
gsmarena.com
gstatic.com
guess.com
guidestar.org
gulfair.com
gumtree.co.za
gumtree.com
gumtree.com.au
gumtree.pl
gunbroker.com
gutefrage.net
gyazo.com
gymboree.com
haber7.com
haberler.com
haberturk.com
habrahabr.ru
haier.com
halifax-online.co.uk
hamariweb.com
hamusoku.com
hanleywood.com
hao123.com
haosou.com
harborfreight.com
harmankardon.com
harrods.com
harvard.edu
hasbro.com
hatena.ne.jp
hatenablog.com
hawaiianairlines.com
hclips.com
hdfcbank.com
hdfilmifullizle.com.tr
health.com
healthboards.com
healthcare.gov
healthgrades.com
healthline.com
healthstream.com
heart.org
heise.de
hellou.co.uk
hellyhansen.com
hepsiburada.com
here.com
hermanmiller.com
hespress.com
hexun.com
hfflp.com
hgtv.com
hh.ru
hibapress.com
highrisehq.com
hihi2.com
hillspet.com
hilton.com
himado.in
himasoku.com
hindustantimes.com
hines.com
histats.com
hitc.com
hizliresim.com
hm.com
holiday-weather.com
hollandamerica.com
hollywoodlife.com
hollywoodreporter.com
homeaway.com
homedepot.com
homepage-web.com
homes.co.jp
homesalez.com
hongkiat.com
hootsuite.com
hopkinsmedicine.org
horizonhobby.com
hostelbookers.com
hostelworld.com
hostgator.com
hotel.de
hotels.com
hoteltravel.com
hotnewhiphop.com
hotpepper.jp
hotstar.com
hottopic.com
hotukdeals.com
hotwire.com
house365.com
housemaster.com
houzz.com
howardforums.com
howstuffworks.com
howtogeek.com
hp.com
hrblock.com
href.li
hrs.de
hsbc.co.uk
hsbc.com.hk
hse.gov.uk
hsn.com
huaban.com
huanqiu.com
huawei.com
hubpages.com
hubspot.com
hud.gov
huffingtonpost.com
hulu.com
hulu.jp
humblebundle.com
hupu.com
hurriyet.com.tr
husqvarna.com
huya.com
hyatt.com
i.ua
i2x.net
ibanking-services.com
ibba.org
iberia.com
ibm.com
ibnlive.com
ibtimes.co.in
ibtimes.co.uk
ibtimes.com
icbc.com.cn
icc.net
iciba.com
icicibank.com
icims.com
icloud.com
icolor.com.cn
iconosquare.com
icook.tw
id.net
idata.com
ideafit.com
idealista.com
idealo.de
idnes.cz
ifeng.com
iflscience.com
ifma.org
ig.com.br
ign.com
iheart.com
iherb.com
ihg.com
ihwy.com
ijreview.com
ikea.com
ilfattoquotidiano.it
ilmeteo.it
iltalehti.fi
iltasanomat.fi
imagebam.com
images-amazon.com
imaging-resource.com
imamerchants.org
imdb.com
imgchili.net
imgur.com
immobilienscout24.de
imobile.com.cn
impress.co.jp
inc.com
indeed.co.in
indeed.co.uk
indeed.com
independent.co.uk
index.hu
india.com
indiamart.com
indianexpress.com
indianrail.gov.in
indiatimes.com
indiegogo.com
infoaccess.net
infobae.com
informaticsinc.com
informer.com
infoseek.co.jp
infusionsoft.com
ing.nl
ink361.com
inman.com
inmotionhosting.com
innfrad.com
innotrac.com
innshopper.com
inquirer.net
inquisitr.com
inspectionnews.net
inspectorsjournal.com
inspsearch.com
instacommerce.net
instagram.com
instituteonline.com
instructables.com
instructure.com
integrativenutrition.com
integro.com
intel.com
interactivesoftware.co.uk
interia.pl
intermountainhealthcare.org
internetdownloadmanager.com
internethaber.com
interpark.com
intervalworld.com
intoday.in
intrabench.com
intuit.com
invaluable.com
investing.com
investopedia.com
ioffer.com
ionidea.com
ipko.pl
iqiyi.com
irctc.co.in
irecommend.ru
irei.com
irem.org
ironplanet.com
irpopup.ir
irs.gov
issuu.com
istockphoto.com
it4profit.com
itasoftware.com
itau.com.br
itelligencegroup.com
itmedia.co.jp
ivanhoecambridge.com
ivc.cn
ivc.com
ivenue.com
ivi.ru
iwillteachyoutoberich.com
iza.ne.jp
j-cast.com
jabong.com
jagran.com
jal.co.jp
jalan.net
jalopnik.com
jamieoliver.com
japanpost.jp
jav68.me
java.com
javedch.com
jb51.net
jbl.com
jcpenney.com
jcrew.com
jd.com
jet.com
jetairways.com
jetblue.com
jeuxvideo.com
jezebel.com
jia360.com
jimdo.com
jin115.com
jjwxc.net
jma.go.jp
jnj.com
joann.com
jobrapido.com
johnlewis.com
joins.com
jomashop.com
joneslanglasalle.com
journaldesfemmes.com
jquery.com
jqw.com
jrj.com.cn
jsfiddle.net
jugem.jp
jumeirah.com
jumia.com.ng
junbi-tracker.com
justdial.com
jw.org
k618.cn
kaiserpermanente.org
kakaku.com
kana.com
kao.com
kapook.com
kapre.com
kaskus.co.id
kaspersky.com
kat.cr
kay.com
kayak.com
kbb.com
kddi.com
kdnet.net
keenfootwear.com
keepvid.com
kenh14.vn
kenwood.com
kevinmd.com
khabaronline.ir
khanacademy.org
kicker.de
kickstarter.com
kidshealth.org
kidspot.com.au
kienthuc.net.vn
kijiji.ca
kimberamerica.com
kinja.com
kinogo.co
kinopoisk.ru
kinox.to
kinozal.tv
kiplinger.com
kissanime.to
kizi.com
kizlarsoruyor.com
klikbca.com
klipsch.com
klm.com
kmart.com
kmp.co.uk
kohls.com
kompas.com
kompasiana.com
konga.com
kongregate.com
kooora.com
korabia.com
koreanair.com
kotaku.com
kouclo.com
kp.ru
kraftrecipes.com
ksl.com
kt9267.com
kuronekoyamato.co.jp
kuwo.cn
kyosho.com
la-z-boy.com
labanquepostale.fr
labcorp.com
labtestsonline.org
lacaixa.es
lady8844.com
lagaceta.com.ar
lamoda.ru
lan.com
lanacion.com.ar
lancome-usa.com
landcentral.com
landflip.com
landlords.org.uk
landsend.com
landwatch.com
lapatilla.com
laposte.net
laredoute.fr
last.fm
lastpass.com
laterooms.com
latimes.com
layalina.com
lazada.co.id
ldblog.jp
lds.com
lds.org
leadzupc.com
leagueoflegends.com
leboncoin.fr
lefigaro.fr
legacy.com
lego.com
lemonde.fr
lenovo.com
lenscrafters.com
lenta.ru
leo.org
lequipe.fr
letv.com
lg.com
libero.it
lifebuzz.com
lifehack.org
lifehacker.com
lifenews.ru
lightinthebox.com
lightwellinc.com
likemag.com
likes.com
lindaikejisblog.com
line.me
linkedin.com
linkwithin.com
linternaute.com
liputan6.com
liquor.com
list-manage.com
list-manage1.com
littlethings.com
live.com
liveadexchanger.com
livedoor.biz
livedoor.com
livedoor.jp
livehelper.com
liveinternet.ru
livejournal.com
liveleak.com
liveperson.net
livescore.com
livestrong.com
livetv.sx
livingsocial.com
llbean.com
lloydsbank.co.uk
loading-delivery2.com
lockerdome.com
logicsoftware.co.uk
logitech.com
lohaco.jp
lolesports.com
lonelyplanet.com
longchamp.com
loopnet.com
lordandtaylor.com
lorealparisusa.com
lostfilm.tv
lot.com
lotterypost.com
lowensign.com
lowes.com
ltn.com.tw
lufthansa.com
lululemon.com
lun.com
luxtarget.com
luxuryhomemarketing.com
luxuryhomes.com
luxuryrealestate.com
lvmama.com
lynda.com
mackeeper.com
mackolik.com
macromill.com
macrumors.com
macys.com
made-in-china.com
mail.com
mail.ru
mailchimp.com
mainichi.jp
makeleio.gr
makemytrip.com
makeupalley.com
makeuseof.com
mama.cn
mangafox.me
mangahere.co
mangareader.net
mango.com
manoramaonline.com
manta.com
manualsonline.com
manufacturing.net
mapquest.com
mapsofindia.com
marc-o-polo.com
marca.com
marketgid.com
marketwatch.com
marksandspencer.com
marktplaats.nl
marmiton.org
marmot.com
marriott.com
marthastewart.com
marykay.com
mashable.com
mashreghnews.ir
masralarabia.com
masrawy.com
massageenvy.com
match.com
mattel.com
maxtalk.com
maybank2u.com.my
maybelline.com
mayoclinic.org
mbank.pl
mbc.net
mcafee.com
mcfadyen.com
mckesson.com
mckissock.com
mdanderson.org
meaww.com
meb.gov.tr
mec.gov.br
mediafire.com
mediaplex.com
mediaset.it
medicare.gov
medicinenet.com
medium.com
medscape.com
meetup.com
mega.co.nz
mega.nz
megapopads.com
meituan.com
melia.com
memecats.com
mensfitness.com
menshealth.co.uk
menshealth.com
mentalfloss.com
meowshare.com
mercadolibre.com.ar
mercadolibre.com.mx
mercadolibre.com.ve
mercadolivre.com.br
mercola.com
merdeka.com
mergent.com
merriam-webster.com
messenger.com
mesteel.com
metacritic.com
meteofrance.com
metro.co.uk
metroer.com
metrolyrics.com
metrotvnews.com
mgid.com
mheducation.com
mi.com
mic.com
microsoft.com
microsoftonline.com
microsoftstore.com
midwayusa.com
mihanblog.com
mikeferry.com
milanuncios.com
mileroticos.com
military.com
millersamuel.com
milliyet.com.tr
minecraft.net
miniclip.com
mint.com
mirror.co.uk
mirtesen.ru
misr5.com
mit.edu
miui.com
mixi.jp
mizuhobank.co.jp
mlb.com
mobafire.com
mobfactory.info
mobikwik.com
mobile.de
mobile01.com
mobile9.com
modcloth.com
momoshop.com.tw
monarch.co.uk
moneycontrol.com
moneysavingexpert.com
moneytalksnews.com
monotaro.com
monster.com
montblanc.com
montgomerycountymd.gov
mos.ru
moseley.org
motherearthnews.com
motortrend.com
moudamepo.com
mountainhardwear.com
mouthshut.com
moveandstay.com
movoto.com
moz.com
mozilla.org
mr-johal.com
mskcc.org
msn.com
msnbc.com
mts.ru
mtsindia.in
mtv.com
mufg.jp
multihousingnews.com
mundo.com
mundosexanuncio.com
munrvscurlms.com
musica.com
musiciansfriend.com
mvideo.ru
mxttrf.com
my-hit.org
myanimelist.net
mydala.com
mydomainadvisor.com
mydrivers.com
myfico.com
myfitnesspal.com
mynavi.jp
mynet.com
mypearson.com
myshopify.com
mysmartprice.com
myspace.com
mysql.com
mystart.com
mystartsearch.com
myway.com
n-tv.de
n11.com
n121adserv.com
naahq.org
nachi.org
nacion.com
nahi.org
naiglobal.com
naiop.org
nairaland.com
namecheap.com
nametests.com
namu.wiki
narod.ru
narpm.org
nasa.gov
nat.com
nate.com
national-lottery.co.uk
nationalgeographic.com
nationalmssociety.org
naturallycurly.com
nature.com
naukri.com
nautica.com
naver.com
naver.jp
navyfederal.org
nba.com
nbc.com
nbcnews.com
nbcsports.com
ncl.com
ncsha.org
ndtv.com
neimanmarcus.com
nejm.org
neobux.com
nesn.com
nespresso.com
net-a-porter.com
netcasters.com
netdna-cdn.com
netdoctor.co.uk
netflix.com
netpartnering.com
netshoes.com.br
netsuite.com
netteller.com
netx.net
newbalance.com
newegg.com
newhomesdirectory.com
news-us.jp
news.com.au
news24.com
newsmth.net
newsnow.co.uk
newtab-tv.com
newyorker.com
nextag.com
nextdoor.com
nexternal.com
nextmedia.com
nexusmods.com
nfl.com
ngacn.cc
nguoiduatin.vn
nguyentandung.org
nhadatso.com
nhk.or.jp
nhl.com
nicovideo.jp
nifty.com
nih.gov
niiz.info
nike.com
nikkansports.com
nikkei.com
nikkeibp.co.jp
ning.com
nipic.com
nitroflare.com
niuche.com
nj.com
nlihc.org
nmhc.org
nmisr.com
nnm-club.me
noaa.gov
nocookie.net
nomadicmatt.com
nordictrack.com
nordstrom.com
norton.com
nosub.tv
nouvelobs.com
novinky.cz
nownews.com
nowtv.de
nowvideo.sx
npr.org
nreionline.com
nrk.no
ns5n.com
nta.go.jp
ntdtv.com
nttdocomo.co.jp
nu.nl
nuance.com
nur.kz
nutrition.org
ny.gov
nyaa.eu
nyaa.se
nydailynews.com
nymag.com
nypost.com
nyrei.com
nytimes.com
o2.pl
oakley.com
oakwood.com
obeo.com
ocn.ne.jp
oeeee.com
office.com
office365.com
officedepot.com
ok.ru
okcupid.com
okezone.com
okta.com
okwave.jp
oldnavy.com
oldrepublictitle.com
olx.co.id
olx.com.br
olx.in
olx.kz
olx.pl
olx.ro
olx.ua
omegawatches.com
onclickads.net
onclicktop.com
onedio.com
oneindia.com
onestopclick.com
onet.pl
onetravel.com
onkyo.com
online-convert.com
onlinecreditcenter6.com
onlinekhabar.com
onliner.by
onlinesbi.com
ontests.me
opencrm.co.uk
opendns.com
openload.co
opensooq.com
opensubtitles.org
opentable.com
oracle.com
orange.fr
orbitz.com
orf.at
orientaltrading.com
origin.com
oschina.net
osha.gov
otomoto.pl
otto.de
ouo.io
outbrain.com
outeredgeuk.com
over-blog.com
overdrive.com
overstock.com
ownersdirect.co.uk
oyaide.com
ozon.ru
p30download.com
p5w.net
padsdel.com
pagesjaunes.fr
paidverts.com
pampers.com
panasonic.com
panasonic.jp
panda.tv
pandora.com
pandora.net
panet.co.il
pantip.com
papajohns.com
parenting.com
parents.com
partners.org
pastebin.com
patagonia.com
patch.com
patheos.com
patient.info
paulaschoice.com
payoneer.com
paypal.com
payseal.com
paytm.com
paytm.in
pbs.org
pcadvisor.co.uk
pcgamer.com
pch.com
pchome.com.tw
pchome.net
pcmag.com
pcworld.com
pearsoncmg.com
pelis24.com
pendleton-usa.com
people.com
perfect.com
periscope.tv
persianblog.ir
petco.com
petmd.com
petsafe.net
petsmart.com
pex.jp
peyvandha.ir
peza.gov.ph
philippineairlines.com
philips.com
phoenixads.co.in
phonearena.com
photobucket.com
photoplan.co.uk
photosigns.com.au
php.net
piac.com.pk
picmonkey.com
picofile.com
pier1.com
pikabu.ru
pillsbury.com
pinimg.com
pinterest.com
pioneerelectronics.com
piriform.com
pissedconsumer.com
pitchfork.com
pixabay.com
pixelplanet.com
pixiv.net
pixlr.com
pixnet.net
pizzahut.com
planetecomsolutions.com
planetromeo.com
plannedparenthood.org
plarium.com
play1topgame.com
playstation.com
plurk.com
plurotech.com
plymouth.ac.uk
pnc.com
po.st
pochta.ru
pof.com
pogo.com
polar.com
pole-emploi.fr
politico.com
polyvore.com
ponparemall.com
popads.net
popcash.net
popmaster.ir
popmyads.com
popped.biz
popsugar.com
popundertotal.com
portplus.com
postbank.de
poste.it
postimg.org
potterybarn.com
powerball.com
ppomppu.co.kr
pps.tv
prana.com
predictivadvertising.com
premierleague.com
pretty52.com
prevention.com
prezi.com
pricegrabber.com
priceline.com
priceminister.com
primewire.ag
princess.com
principlevaluation.com
privatbank.ua
privateislandsonline.com
prntscr.com
proboards.com
prodapt.com
programme-tv.net
projectfreetv.so
prologis.com
prom.ua
pronto.com
propertypanorama.com
proschools.com
prospectsoft.com
protect0r.com
prothom-alo.com
protothema.gr
prou.net
providence.org
prpops.com
psu.edu
psychologytoday.com
ptt.cc
pubcon.com
pudelek.pl
purdue.edu
pureadexchange.com
putlocker.is
python.org
qantas.com.au
qatarairways.com
qidian.com
qingdaonews.com
qiwi.com
qq.com
qualtrics.com
quanjing.com
quikr.com
quiksilver.com
quizlet.com
quora.com
qvc.com
qz.com
r10.net
rabobank.nl
rackcdn.com
rackspace.com
radikal.com.tr
rakuten-bank.co.jp
rakuten-card.co.jp
rakuten.co.jp
rakuten.com
rakuten.ne.jp
ralphlauren.com
rambler.ru
ranker.com
rapidgator.net
rappler.com
rarbg.to
ravelry.com
rbc.ru
rbcroyalbank.com
rci.com
rdsa2012.com
realclearpolitics.com
realestate.com.au
realestatece.com
realestateexpress.com
realestatetomato.com
realogy.com
realsimple.com
realstar.ca
realtor.com
realtourvision.com
realtyexecutives.com
realtytimes.com
rebac.net
reclameaqui.com.br
redappleapartments.com
redbox.com
redbubble.com
redcrossblood.org
reddit.com
redfin.com
rediff.com
redirectvoluum.com
rednet.cn
reduxmediia.com
redwingshoes.com
reference.com
refinery29.com
rei.com
reimageplus.com
reis.com
rejournals.com
related.com
remax.com
remedi.com
remington.com
remonline.com
renren.com
rentalsite.com
repelis.tv
repubblica.it
republika.co.id
researchgate.net
resellerratings.com
resultados-futbol.com
retailmenot.com
reuters.com
revacomm.com
reverb.com
reverso.net
rfptemplates.org
ria.ru
ricksteves.com
ricoh-usa.com
rightmove.co.uk
rimanews.com
ripoffreport.com
rismedia.com
rivals.com
roblox.com
rockanddirt.com
rocketnews24.com
rockport.com
rockwellinstitute.com
rodalesorganiclife.com
roku.com
rolex.com
rollingstone.com
rottentomatoes.com
roughguides.com
royalbank.com
royalcaribbean.com
rozblog.com
rozetka.com.ua
rr.com
rrbonlinereg.in
rrbonlinereg.net
rt.com
ruger.com
rusbiz.com
rush.edu
ruten.com.tw
rutracker.org
rutube.ru
rxlist.com
ryanair.com
sabah.com.tr
sabq.org
sahibinden.com
saisoncard.co.jp
saksfifthavenue.com
sakura.ne.jp
salesforce.com
salespage.com
salon.com
samhsa.gov
sammydress.com
samplicio.us
samsclub.com
samsung.com
sankei.com
sanook.com
sanspo.com
santander.co.uk
sap.com
sapient.com
sapo.pt
saramin.co.kr
sasontnwc.net
saudiairlines.com
savefrom.net
saveur.com
savills.com
savingstar.com
sberbank.ru
sbisec.co.jp
sbnation.com
scarymommy.com
scholastic.com
schwab.com
sciencedirect.com
scoop.it
scoopwhoop.com
scotiabank.com
scribd.com
sdsu.edu
searchalgo.com
searchengineland.com
searchlock.com
sears.com
seasonvar.ru
seatguru.com
secureinternetbank.com
secureserver.net
seek.com.au
seekingalpha.com
seesaa.net
selectleaders.com
self.com
seniorsrealestate.com
sennheiser.com
sephora.com
serverfault.com
serving-sys.com
sesconference.com
setn.com
seznam.cz
sfgate.com
sfr.fr
sh.st
shaadi.com
shahrekhabar.com
shangri-la.com
shaparak.ir
shareasale.com
sharecare.com
sharepoint.com
sharpusa.com
shasha.ps
shermanstravel.com
shimano.com
shine.com
shiseido.co.jp
shoecarnival.com
shop-pro.jp
shopathome.com
shopbop.com
shopclues.com
shopify.com
shopping.com
shoutmeloud.com
shufoo.net
shutterfly.com
shutterstock.com
si.com
sierratradingpost.com
sigsauer.com
similarweb.com
simplyrecipes.com
sina.com.cn
sinaimg.cn
sindonews.com
siriusxm.com
siteadvisor.com
sitepoint.com
skroutz.gr
sky.com
skycn.com
skype.com
skyscanner.com
skyscanner.net
skysports.com
slack.com
slashdot.org
slate.com
slickdeals.net
slideshare.net
slidesharecdn.com
slimspots.com
slopeaota.com
smallpdf.com
smallseotools.com
smartnewtab.com
smartshopping.com
smbc-card.com
smh.com.au
smi2.ru
smith-wesson.com
smittenkitchen.com
smzdm.com
snapdeal.com
snopes.com
so-net.ne.jp
so.com
socialsecurity.gov
societegenerale.fr
softbank.jp
softcare.com
softonic.com
softpedia.com
softwarefolks.com
sogou.com
sohu.com
solarmovie.ph
sonos.com
sony.com
sony.jp
sonyentertainmentnetwork.com
sopitas.com
soso.com
sothebysrealty.com
sou300.com
soundcloud.com
souq.com
sourceforge.net
southernliving.com
southwest.com
sozcu.com.tr
sp.gov.br
spaceshipads.com
spanishdict.com
specialized.com
speedtest.net
spicejet.com
spiegel.de
spine-health.com
spirit.com
sponichi.co.jp
sport1.de
sports.ru
sportsauthority.com
sportsdirect.com
sportsmansguide.com
spotify.com
springer.com
springfield-armory.com
sprint.com
spscommerce.com
sputniknews.com
sq.cn
square-enix.com
squarespace.com
squaretrade.com
squareup.com
squiz.net
sram.com
srilankan.com
srv2trking.com
ssa.gov
ssisurveys.com
stackexchange.com
stackoverflow.com
standardmedia.co.ke
stanford.edu
staples.com
starbucks.com
starsports.com
startimes.com
starwoodhotels.com
statcounter.com
state.gov
state.tx.us
staticflickr.com
staticwebdom.com
steamcommunity.com
steampowered.com
sterlingcommerce.com
stjude.org
stockstar.com
stokke.com
storebuilder.co.uk
storefrontconsulting.com
straightsell.com.au
strava.com
streamcloud.eu
streamin.to
stubhub.com
studentdoctor.net
studentuniverse.com
study.com
stuff.tv
stumbleupon.com
styleforum.net
suara.com
subito.it
submarino.com.br
subscene.com
sueddeutsche.de
sugarcrm.com
sulekha.com
sunbeltnetwork.com
suning.com
sunset.com
suntrust.com
super.cz
superuser.com
surplusglobal.com
suruga-ya.jp
surveymonkey.com
sutterhealth.org
suumo.jp
suunto.com
svmsolutions.com
swagbucks.com
swarovski.com
swatch.com
sweetwater.com
swiss.com
synchronycredit.com
syosetu.com
szn.cz
sznews.com
t-mobile.com
t-online.de
t.co
t411.in
tabelog.com
tabnak.ir
taboola.com
tagged.com
tagheuer.com
tagonline.com
tahrirnews.com
taimienphi.vn
takungpao.com
taleo.net
talk.tw
tamiya.com
taobao.com
target.com
taringa.net
tarladalal.com
tasify.com
tattoodo.com
taxact.com
td.com
tdbank.com
teacherspayteachers.com
teamviewer.com
tebyan.net
techbang.com
techcrunch.com
techindia.com
techradar.com
techtarget.com
techtudo.com.br
ted.com
teepr.com
telegraaf.nl
telegraf.com.ua
telegrafi.com
telegram.me
telegram.org
telegraph.co.uk
telekom.com
templatemonster.com
tempo.co
tenki.jp
terra.com.br
terraclicks.com
tesco.com
tf1.fr
tgbus.com
thaiairways.com
theatlantic.com
theblaze.com
thechive.com
thedailybeast.com
thefreedictionary.com
theguardian.com
thehill.com
thehindu.com
thekitchn.com
thekrazycouponlady.com
theladbible.com
thelancet.com
themeforest.net
themoneyconverter.com
themovechannel.com
thenextweb.com
thenorthface.com
theonion.com
thepennyhoarder.com
thepiratebay.se
thesaurus.com
thesimpledollar.com
thesportbible.com
thestreet.com
theverge.com
thevideo.me
thewatchseries.to
theweathernetwork.com
thewhizmarketing.com
thisav.com
thomascook.com
thriftyfun.com
thrillist.com
tianya.cn
ticketmaster.com
ticketmonster.co.kr
tigerdirect.com
tilestwra.com
tim.it
timberland.com
time.com
timeanddate.com
timeout.com
timewarnercable.com
tinypic.com
tirerack.com
tiscali.it
tistory.com
titleonecorp.com
tiu.ru
tlbb8.com
tmall.com
tmz.com
to8to.com
today.com
todayhumor.co.kr
togetter.com
tokopedia.com
tomsguide.com
tomshardware.com
tomtop.com
tonyrobbins.com
top10homeremedies.com
topix.com
toptenreviews.com
toranoana.jp
torcache.net
torrentkim1.net
torrentz.com
torrentz.eu
torrentz.in
toshiba.com
totalbeauty.com
tourfactory.com
toyokeizai.net
toysrus.com
tpmco.com
trackingclick.net
trackvoluum.com
tradeadexchange.com
tradedoubler.com
trademe.co.nz
traffichunt.com
trafficmonsoon.com
trafficserving.com
traidnt.net
travelandleisure.com
travelocity.com
travelzoo.com
traxxas.com
treasury.gov
trekbikes.com
trello.com
tribunnews.com
trinityinsight.com
tripadvisor.co.uk
tripadvisor.com
tripadvisor.in
triseptsolutions.com
triumph.com
trklnks.com
trkute.com
truecaller.com
trulia.com
truste.com
trustpilot.com
tsite.jp
tubepatrol.net
tudou.com
tumblr.com
tums.ac.ir
tunein.com
turbobit.net
turkishairlines.com
tut.by
tutorialspoint.com
tutsplus.com
tv.com
tvguide.com
tvn24.pl
twimg.com
twitch.tv
twitter.com
twoo.com
txxx.com
typepad.com
uber.com
ubergizmo.com
ubi.com
ubuntu.com
ucla.edu
ucoz.ru
udacity.com
udemy.com
udn.com
ukr.net
ulmart.ru
ulta.com
ultimate-guitar.com
umblr.com
umich.edu
unam.mx
unblocked.li
underarmour.com
unicredit.it
unikron.com
unilever.com
uniqlo.com
uniquehomes.com
united.com
unity3d.com
uol.com.br
uploaded.net
upmc.com
upornia.com
uproxx.com
ups.com
uptobox.com
uptodown.com
upwork.com
urbandictionary.com
urbanoutfitters.com
urdupoint.com
usaa.com
usatoday.com
usbank.com
userscloud.com
usmagazine.com
usnews.com
usps.com
ustream.tv
utexas.edu
utorrent.com
uzone.id
v1.cn
vacationstogo.com
vagalume.com.br
vaned.com
vanguard.com
variety.com
varzesh3.com
vcommission.com
vector.co.jp
vegas.com
vegrecipesofindia.com
vendormanagedinventory.com
venere.com
vente-privee.com
venturead.com
verizon.com
verizonwireless.com
vesti.ru
vetogate.com
vg.no
viamichelin.com
vice.com
victoriassecret.com
vid.me
videodownloadconverter.com
videomega.tv
videoyoum7.com
vidto.me
vidzi.tv
vikingrivercruises.com
vimeo.com
vine.co
vip.com
viralands.com
viralthread.com
virgilio.it
virgin-atlantic.com
virginaustralia.com
virginmedia.com
virtualtourist.com
visahq.com
vistaprint.com
visualtour.com
vitacost.com
vitals.com
vitamix.com
viva.co.id
viviun.com
vk.com
vk.me
vmware.com
vnexpress.net
voc.com.cn
vodafone.in
vodlocker.com
voluumtrk.com
vox.com
vrbo.com
vsuch.com
vulture.com
w3.org
w3schools.com
walgreens.com
walmart.com
wanyh.com
wargaming.net
warmportrait.com
warriorforum.com
washington.edu
washingtonpost.com
watchfree.to
watchseries.li
wattpad.com
wav.tv
way2sms.com
wayfair.com
wbresearch.com
wcr.org
weather.com
weather.com.cn
weather.gov
weathernews.jp
web.de
webcrawler.com
weber.com
webex.com
webjaguar.com
webkinz.com
weblio.jp
webmd.com
webmoney.ru
webmonkey.com
webpro.com
webssearches.com
websta.me
webtretho.com
weebly.com
weheartit.com
weibo.com
weightwatchers.com
wellness.com
wellsfargo.com
welt.de
westelm.com
westernjournalism.com
westjet.com
westmonroepartners.com
wetalk.tw
wetransfer.com
wetter.com
wgsn.com
what-character-are-you.com
whatsapp.com
whfoods.com
whirlpool.com
whitecapcanada.com
whitepages.com
who.int
who.is
wholesalesuppliesplus.com
wikia.com
wikihow.com
wikimedia.org
wikipedia.org
wikispaces.com
wikitravel.org
wikivoyage.org
wikiwiki.jp
wiktionary.org
wildberries.ru
wiley.com
williamhill.com
williams-sonoma.com
windows.com
windows.net
wingtaiasia.com.sg
wiocha.pl
wipro.com
wired.com
wisc.edu
wish.com
witiger.com
wittyfeed.com
wix.com
wmaraci.com
wmpoweruser.com
wnd.com
wolframalpha.com
woot.com
wordpress.com
wordpress.org
wordreference.com
workercn.cn
workingre.com
worldfirst.com
worldlifestyle.com
worldmarket.com
worldoftanks.ru
worldstarhiphop.com
worldweb.com
worldwise.net
wotif.com
wowhead.com
wp.com
wp.pl
wpbeginner.com
wsj.com
wunderground.com
wunderlist.com
wuxiaworld.com
wwe.com
www.gov.uk
www.nhs.uk
wyborcza.pl
wyndham.com
x-rates.com
xbox.com
xda-developers.com
xe.com
xerox.com
xfinity.com
xiami.com
xiaomi.com
xing.com
xinhuanet.com
xkcd.com
xl415.com
xmediaserve.com
xn--igbhe7b5a3d5a.com
xoriant.com
xuite.net
xunlei.com
xywy.com
y8.com
yadi.sk
yahoo-mbga.jp
yahoo.co.jp
yahoo.com
yallakora.com
yam.com
yandex.by
yandex.com
yandex.com.tr
yandex.kz
yandex.ru
yandex.ua
yaolan.com
yaplakal.com
yaraon-blog.com
yellowpages.com
yelp.com
yenisafak.com
yesky.com
yhd.com
yjc.ir
ynet.co.il
yodobashi.com
yomiuri.co.jp
yoo.com
yoox.com
youboy.com
youdao.com
youku.com
youm7.com
youneedabudget.com
youradexchange.com
yourdictionary.com
youth.cn
youtube-mp3.org
youtube.com
yr.no
ytimg.com
yts.ag
zalando.de
zalukaj.tv
zaman.com.tr
zappos.com
zara.com
zazzle.com
zdf.de
zdnet.com
zedo.com
zeit.de
zendesk.com
zergnet.com
zerohedge.com
zeroredirect1.com
zhaopin.com
zhihu.com
zillow.com
zimbio.com
zimuzu.tv
zing.vn
zippyshare.com
zocdoc.com
zoho.com
zol.com.cn
zomato.com
zone-telechargement.com
zoopla.co.uk
zougla.gr
zozo.jp
zulily.com
zwaar.net
zybang.com
`.trim().split("\n"));
