# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

# /!\ Please make sure to update the following comment when you touch this
# file. Thank you /!\

# The traditional Mozilla build system relied on going through the entire
# build tree a number of times with different targets, and many of the
# things happening at each step required other things happening in previous
# steps without any documentation of those dependencies.
#
# This new build system tries to start afresh by establishing what files or
# operations are needed for the build, and applying the necessary rules to
# have those in place, relying on make dependencies to get them going.
#
# As of writing, only building non-compiled parts of Firefox is supported
# here (a few other things are also left out). This is a starting point, with
# the intent to grow this build system to make it more complete.
#
# This file contains rules and dependencies to get things working. The intent
# is for a Makefile to define some dependencies and variables, and include
# this file. What needs to be defined there, and ends up being generated by
# python/mozbuild/mozbuild/backend/fastermake.py is the following:
# - TOPSRCDIR/TOPOBJDIR, respectively the top source directory and the top
#   object directory
# - BACKEND, the path to the file the backend will always update when running
#   mach build-backend
# - PYTHON, the path to the python executable
# - ACDEFINES, which contains a set of -Dvar=name to be used during
#   preprocessing
# - INSTALL_MANIFESTS, which defines the list of base directories handled
#   by install manifests, see further below
# - MANIFEST_TARGETS, which defines the file paths of chrome manifests, see
#   further below
#
# A convention used between this file and the Makefile including it is that
# global Make variables names are uppercase, while "local" Make variables
# applied to specific targets are lowercase.

# Targets to be triggered for a default build
default: $(addprefix install-,$(INSTALL_MANIFESTS))

# Explicit files to be built for a default build
default: $(addprefix $(TOPOBJDIR)/,$(MANIFEST_TARGETS))
ifndef TEST_MOZBUILD
default: $(TOPOBJDIR)/dist/bin/platform.ini
endif

ifndef NO_XPIDL
# Targets from the recursive make backend to be built for a default build
default: $(TOPOBJDIR)/config/makefiles/xpidl/xpidl
endif

ifeq (cocoa,$(MOZ_WIDGET_TOOLKIT))
# Mac builds require to copy things in dist/bin/*.app
# TODO: remove the MOZ_WIDGET_TOOLKIT and MOZ_BUILD_APP variables from
# faster/Makefile and python/mozbuild/mozbuild/test/backend/test_build.py
# when this is not required anymore.
default:
	$(MAKE) -C $(TOPOBJDIR)/$(MOZ_BUILD_APP)/app repackage
endif

.PHONY: FORCE

# Extra define to trigger some workarounds. We should strive to limit the
# use of those. As of writing the only ones are in
# toolkit/content/buildconfig.html and browser/locales/jar.mn.
ACDEFINES += -DBUILD_FASTER

# Generic rule to fall back to the recursive make backend
$(TOPOBJDIR)/%: FORCE
	$(MAKE) -C $(dir $@) $(notdir $@)

# Files under the faster/ sub-directory, however, are not meant to use the
# fallback
$(TOPOBJDIR)/faster/%: ;

# Files under the python virtualenv, which are dependencies of the BACKEND
# file, are not meant to use the fallback either.
$(TOPOBJDIR)/_virtualenv/%: ;

# And files under dist/ are meant to be copied from their first dependency
# if there is no other rule.
$(TOPOBJDIR)/dist/%:
	rm -f $@
	mkdir -p $(@D)
	cp $< $@

# Refresh backend
$(BACKEND):
	cd $(TOPOBJDIR) && $(PYTHON) config.status --backend FasterMake

$(MAKEFILE_LIST): $(BACKEND)

# Install files using install manifests
#
# The list of base directories is given in INSTALL_MANIFESTS. The
# corresponding install manifests are named correspondingly, with forward
# slashes replaced with underscores, and prefixed with `install_`. That is,
# the install manifest for `dist/bin` would be `install_dist_bin`.
$(addprefix install-,$(INSTALL_MANIFESTS)): install-%: $(TOPOBJDIR)/config/buildid
	@# For now, force preprocessed files to be reprocessed every time.
	@# The overhead is not that big, and this avoids waiting for proper
	@# support for defines tracking in process_install_manifest.
	@touch install_$(subst /,_,$*)
	$(PYTHON) -m mozbuild.action.process_install_manifest \
		--track install_$(subst /,_,$*).track \
		$(TOPOBJDIR)/$* \
		-DAB_CD=en-US \
		-DMOZ_APP_BUILDID=$(shell cat $(TOPOBJDIR)/config/buildid) \
		$(ACDEFINES) \
		$(MOZ_DEBUG_DEFINES) \
		install_$(subst /,_,$*)

# Create some chrome manifests
# This rule is forced to run every time because it may be updating files that
# already exit.
#
# The list of chrome manifests is given in MANIFEST_TARGETS, relative to the
# top object directory. The content for those manifests is given in the
# `content` variable associated with the target. For example:
#   MANIFEST_TARGETS = foo
#   $(TOPOBJDIR)/foo: content = "manifest foo.manifest" "manifest bar.manifest"
$(addprefix $(TOPOBJDIR)/,$(MANIFEST_TARGETS)): FORCE
	$(PYTHON) -m mozbuild.action.buildlist \
		$@ \
		$(content)

# ============================================================================
# Below is a set of additional dependencies and variables used to build things
# that are not supported by data in moz.build.

# Files to build with the recursive backend and simply copy
$(TOPOBJDIR)/dist/bin/platform.ini: $(TOPOBJDIR)/toolkit/xre/platform.ini

$(TOPOBJDIR)/toolkit/xre/platform.ini: $(TOPOBJDIR)/config/buildid

# The xpidl target in config/makefiles/xpidl requires the install manifest for
# dist/idl to have been processed.
$(TOPOBJDIR)/config/makefiles/xpidl/xpidl: $(TOPOBJDIR)/install-dist_idl
