/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

///////////////////////////////////////////////////////////////////////////////
// This is an automatically generated file. If you're not
// nsNSSIOLayer.cpp, you shouldn't be #including it.
///////////////////////////////////////////////////////////////////////////////

static const char* const kIntolerantFallbackList[] =
{
  "1800registry.com",
  "5linx.com",
  "aa.com", // bug 1141604
  "aa.com.br", // bug 1141604
  "aa.com.do", // bug 1141604
  "aa.com.pe", // bug 1141604
  "aa.com.ve", // bug 1141604
  "aacoprod.aacounty.org",
  "aavacations.com", // bug 1141604
  "absolwenci.amu.edu.pl",
  "access.boekhuis.nl", // bug 1151580
  "access.dogproblems.com",
  "account.61.com.tw",
  "account.loknstore.co.uk",
  "accountmanager.8x8.com",
  "acs.sia.eu", // RC4
  "actu.macif.fr",
  "adman.you.gr",
  "admin.leaguestat.com",
  "admin.sagefundraisingonline.com",
  "adminweb.uthscsa.edu",
  "affiliates.dragonoptions.com",
  "afs.fortunaaffiliates.com",
  "ag.bcbhomes.com",
  "agenda.uc.cl",
  "agentweb.manulife.co.jp",
  "aim.nextjump.com",
  "airportwifi.com", // bug 1116891
  "allbankonline.in", // bug 1156441
  "allyours.virginmedia.com", // bug 1129887
  "altitude.aircanada.com", // bug 1143325
  "alumni.georgetown.edu",
  "american-airlines.co.kr", // bug 1141604
  "american-airlines.nl", // bug 1141604
  "americanairlines.be", // bug 1141604
  "americanairlines.ch", // bug 1141604
  "americanairlines.cl", // bug 1141604
  "americanairlines.cn", // bug 1141604
  "americanairlines.co.cr", // bug 1141604
  "americanairlines.co.uk", // bug 1141604
  "americanairlines.com", // bug 1141604
  "americanairlines.com.au", // bug 1141604
  "americanairlines.com.ru", // bug 1141604
  "americanairlines.es", // bug 1141604
  "americanairlines.fr", // bug 1141604
  "americanairlines.hu", // bug 1141604
  "americanairlines.ie", // bug 1141604
  "americanairlines.in", // bug 1141604
  "americanairlines.jp", // bug 1141604
  "ap.meitetsuunyu.co.jp",
  "applications.marykayintouch.com",
  "apply.hkbn.net", // bug 1138451
  "apps.amerch.com",
  "apps.boostmobile.com",
  "apps.sasken.com",
  "apps.sgu.edu",
  "apps.state.or.us", // bug 1130472
  "appsrv.restat.com",
  "arcgames.com", // bug 1182932
  "asko.fi", // bug 1158584
  "auth.hitachi-capital.co.jp",
  "auth.visiblemeasures.com",
  "b2b.feib.com.tw",
  "baybloorradio.com", // bug 1173661
  "be-my-guest.com",
  "beehive.miit.ru",
  "bgw.wangyin.com", // bug 1145521
  "bianmin.chinapay.com", // bug 1137983
  "bigflix.com",
  "biiab.bii.org",
  "biibas.bii.org",
  "billing.surfsafevpn.com",
  "blackboard.tru.ca",
  "blastam.com",
  "blogwatcher.co.jp",
  "bmypage.kuronekoyamato.co.jp",
  "boards.lineage2.com",
  "bonds.euronext.com", // bug 1136091
  "books.wwnorton.com", // bug 1116891
  "borrowsmart.afford.com",
  "bursar.ou.edu",
  "buttons.verticalresponse.com",
  "buy.lh.or.kr",
  "bv.ac-lille.fr",
  "bv.dealbase.vc",
  "c2g.jupiter.fl.us",
  "campusnet.csuohio.edu",
  "canadaca.geotrust.com", // bug 1137677
  "careers.aucklandcouncil.govt.nz",
  "careers.aut.ac.nz",
  "careers.nzte.govt.nz",
  "careers.state.co.nz",
  "catalog.lapl.org",
  "cbsfnotes1.blood.org.tw",
  "celebrity.ebay.com",
  "central.acadiau.ca", // bug 1152377
  "centrezone.bii.org",
  "charity.5linx.com",
  "chat.youtradefx.com",
  "cherry.de", // bug 1141521
  "cias.rit.edu",
  "civilization.com", // bug 1156004
  "client.alor.ru",
  "clientes.chilectra.cl",
  "club.guosen.com.cn",
  "clubs.bii.org",
  "cmypage.kuronekoyamato.co.jp",
  "coagov.aurora-il.org",
  "codem.codemasters.com",
  "community.bentley.edu",
  "comune.milano.it",
  "consulting.nonghyup.com",
  "controlpanel.globalinx.com",
  "cooeps.coomeva.com.co",
  "copyfaxes.com",
  "corporbank.nbcb.com.cn",
  "crm.et2008.com",
  "cualerts.dupaco.com", // bug 1116892
  "cuconnect.colorado.edu",
  "customers.logistafrance.fr", // bug 1153951
  "cwu.edu",
  "daveosborne.com",
  "dbank.hxb.com.cn",
  "dealer.autobytel.com",
  "demo.hotforex.com",
  "device.panasonic.cn",
  "dheb.delavska-hranilnica.si",
  "dialog.tatrabanka.sk",
  "digibet.com",
  "digitalsecurity.intel.com", // bug 1148744
  "dismoiou.fr",
  "docs.otpp.com",
  "doktorski.unizg.hr",
  "drc.ohiolink.edu",
  "dream-prize.com",
  "dwwsyw.bjgjj.gov.cn",
  "eatm.scsb.com.tw",
  "eb.bankcomm.com.hk", // bug 1141742
  "ebank-public.hzbank.com.cn",
  "ebank.hxb.com.cn",
  "ebank.hzbank.com.cn",
  "ebank.rcbcy.com", // bug 1146755
  "ebanking.vietabank.com.vn",
  "ebill2.virginmedia.com", // bug 1129887
  "ebpp.airtel.lk",
  "ebspay.boc.cn", // bug 1155567
  "ec-line.cn",
  "echo.com",
  "echotrak.com",
  "ecom.morethangourmet.com",
  "ecommerce.saa.org",
  "ecourses.uthscsa.edu",
  "edu.ingang.go.kr",
  "egov.town-menasha.com", // bug 1157536
  "emaildvla.direct.gov.uk", // bug 1116891
  "enrollment.fcbresource.com",
  "epay.regionalacceptance.com",
  "epicreg.com",
  "eps.hrdkorea.or.kr",
  "eremit.sbising.com",
  "eremit.unionbankofindia.co.in",
  "erewards.regionalacceptance.com",
  "eseries.ansi.org",
  "eservice.americangeneral.com",
  "eservices.palomar.edu",
  "espaceparticuliers.meteofrance.com",
  "espaceprofessionnels.meteofrance.com",
  "espanol.raileurope-world.com",
  "etest.chosun.com",
  "event.kasite.net",
  "events.illinoisstate.edu",
  "ewh.ieee.org",
  "eximonline.exim.gov",
  "experience.edinboro.edu",
  "extranet.eurocontrol.int",
  "extranet.meilleursagents.com",
  "ez.cityofchesapeake.net",
  "ezpay.com.tw",
  "fabulousfurs.com",
  "facultadmedicina.uc.cl",
  "fallback.test", // Used by gtest
  "famigros.migros.ch",
  "fastcheck.sita.aero", // bug 1174974
  "fastlane.echo.com",
  "fhsaa.org",
  "fibi-online.co.il", // bug 1165580
  "finance.bankhapoalim.co.il",
  "finance.car.com",
  "finweb.rit.edu",
  "flyingcart.com",
  "form.kuronekoyamato.co.jp",
  "fr.starbucks.ca",
  "friends.freshandeasy.com",
  "fubar.com",
  "gateway.halton.gov.uk",
  "gay.jadedvideo.com",
  "gbe-bund.de",
  "gc.guitarcenter.com",
  "gestionesytramites.madrid.org",
  "giftcertificates.com",
  "gradschool.edinboro.edu",
  "hercle.com",
  "hospitals.unm.edu",
  "hpshop.gr",
  "hq.flyingcart.com",
  "ibank.scsb.com.tw",
  "identity.virginmedia.com", // bug 1129887
  "ifobs.kredobank.com.ua",
  "ifund.allianzglobalinvestors.com.tw",
  "ig1.i-grasp.com", // bug 1167894
  "ig4.i-grasp.com", // bug 1167894
  "ihr.suburbanpropane.com",
  "images.d2pass.com",
  "inetbank.zapsibkombank.ru",
  "info.hottracks.co.kr",
  "inside.i-med.ac.at",
  "international.amu.edu.pl",
  "international.unizg.hr",
  "ioumate.com",
  "its.bocmacau.com",
  "jbclick.jaxbchfl.net", // bug 1158465
  "jobpostings.adecco.de",
  "jobsstatic.civilservice.gov.uk",
  "jst.doded.mil", // bug 1152627
  "justtherightbook.com",
  "keirin.jp",
  "killfish.ru",
  "king-solarman.com", // bug 1190706
  "kjp.keinet.ne.jp",
  "kjp.oo.kawai-juku.ac.jp",
  "len.scsb.gov.sa",
  "lewisham.gov.uk",
  "life.xl.co.id",
  "live.hotforex.com",
  "lm-order.de",
  "login.bankhapoalim.co.il",
  "login.chicagopolice.org",
  "login.ermis.gov.gr",
  "login.ivenue.com",
  "lovetyres.com",
  "m.e-hon.ne.jp",
  "mail.izhnet.ru",
  "map.infonavit.org.mx",
  "mchrono.com",
  "media.preachingtoday.com",
  "media.renewedvision.com",
  "member.at.or.kr",
  "member.edenredticket.com",
  "member.franchise.org",
  "member.shinsegaepoint.com",
  "members.otpp.com",
  "membership.usairways.com",
  "merchant.edenredticket.com",
  "meta-ehealth.com",
  "mobile.aa.com", // bug 1141604
  "mobile.dream-prize.com",
  "mobile.globalinx.com",
  "mon-ulb.ulb.ac.be",
  "my.if.com", // bug 1173592
  "my.kyivstar.ua",
  "my.miit.ru",
  "my.mimeo.com",
  "myaccount.allstate.com", // bug 1143031
  "myaccount.mobicom.mn",
  "myaccountum.sdge.com",
  "myaccountum.socalgas.com",
  "myadecco.adecco.de",
  "mybank.nbcb.com.cn",
  "mycuinfo.colorado.edu",
  "myhancock.hancockcollege.edu",
  "mypinoy.tv",
  "myportal.brother.co.jp",
  "myvia.viainfo.net",
  "mywebreservations.com",
  "na.aiononline.com", // bug 1139782
  "national.virginmedia.com", // bug 1129887
  "nbank.hxb.com.cn",
  "netbanking.yesbank.co.in", // bug 1146090
  "new.fibi-online.co.il", // bug 1187242
  "newunivera.com",
  "nmsmp.alsok.co.jp",
  "no1.nipponrentacar.co.jp",
  "obos1.obos.no",
  "officials.fhsaa.org",
  "ois.emu.ee",
  "ok.sberbank.ru",
  "online.bankotsar.co.il", // bug 1187242
  "online.cibeg.com",
  "online.edinboro.edu",
  "online.newindia.co.in",
  "online.sainsburysbank.co.uk",
  "openwebosproject.org", // bug 1151990
  "opus.unizg.hr",
  "order.ps-webhosting.de",
  "otherpeoplespixels.com",
  "owa.byui.edu",
  "ozone.ou.edu",
  "parents.ou.edu",
  "parking.leicester.gov.uk",
  "partnerweb.vmware.com", // bug 1142187
  "parts.andersenstormdoors.com",
  "parts.andersenwindows.com",
  "payment.condor.com", // bug 1152347
  "payment.safepass.cn",
  "payments.virginmedia.com", // bug 1129887
  "payments2.tutorvista.com",
  "piloto.viajanet.com.ve",
  "pointofsale.milo.com",
  "policies.usc.edu",
  "portal.cooley.edu",
  "portal.eztec.com.br",
  "portal.questonline.gr",
  "portal.testvalley.gov.uk",
  "portal.uem.es",
  "pr.myacn.com",
  "pracownicy.amu.edu.pl",
  "preventivo.conte.it",
  "profiles.uthscsa.edu",
  "prolinestadium.alc.ca",
  "promo.grosvenorcasinos.com",
  "ps.btl.gov.il",
  "publicjobs.ie",
  "publicrecords.com",
  "purebaby.com.au",
  "pwm.svsu.edu",
  "racenet.codemasters.com", // bug 1163716
  "recoup.com",
  "recruitment.santos.com",
  "redlaser.com",
  "reg.ymcabv.org",
  "register.ohioathletics.com",
  "registration.o2.co.uk",
  "renewals.cipd.co.uk",
  "repair.kuroneko-kadendr.jp", // bug 1128366
  "repairmb.kuroneko-kadendr.jp", // bug 1128366
  "repo.clalbit.co.il",
  "reputation.com",
  "reservations.loknstore.co.uk",
  "reservations.rwsentosa.com",
  "reservations.usairways.com", // bug 1165400
  "reward-me.nescafe.co.uk",
  "rietumu.lv",
  "roxyaffiliates.com",
  "sales.newchinalife.com",
  "sbank.hxb.com.cn",
  "sboseweb.mcpsweb.org",
  "secure.aroundhawaii.com",
  "secure.bankersinsurance.com",
  "secure.bg-mania.jp",
  "secure.blackbearprinting.com",
  "secure.collegesavingsmd.org",
  "secure.crbonline.gov.uk", // bug 1166644
  "secure.eoncode.com",
  "secure.fortisbc.com",
  "secure.groupspaces.com",
  "secure.lhj.com",
  "secure.massresort.com",
  "secure.math.ubc.ca",
  "secure.ncsoft.com", // bug 1139782
  "secure.nissan.co.jp",
  "secure.particleweb.com",
  "secure.pinnion.com",
  "secure.rxprint.com",
  "secure.smartcart.com",
  "secure.thorlo.com",
  "secure.whatsonsale.com.au",
  "secure.wish.org",
  "secure.zooprinting.com",
  "secureonline.dwp.gov.uk",
  "selfcare.tdc.dk",
  "sems.hrd.ccsd.net",
  "service.d2pass.com",
  "services.apvma.gov.au",
  "services.geotrust.com", // bug 1137677
  "servizionline.infogroup.it",
  "shop.icewarp.com",
  "shop.inlinevision.com",
  "shop.kagome.co.jp",
  "shop.nanairo.coop", // bug 1128318
  "shop.naturemill.com",
  "shop.wildstar-online.com", // bug 1139782
  "shopping.girlsgonewild.com",
  "shopping.usairways.com",
  "siv.interieur.gouv.fr",
  "slovanet.sk",
  "smartcart.com",
  "smlogin.aa.com",
  "sna1.coomeva.com.co",
  "soeasy.sodexo.be", // bug 1117157
  "sportsbookings.leicester.gov.uk",
  "ss5.sfcollege.edu",
  "ssb.okbu.edu", // for port 8910, bug 1153749
  "sso.acadiau.ca", // bug 1152377
  "sso.newsobserver.com",
  "starbucks.co.uk",
  "static.markilux.com",
  "stenhouse.com",
  "store.bibleworks.com",
  "store.lineage2.com",
  "store.tretorn.com",
  "store.vicorpower.com",
  "studenci.amu.edu.pl",
  "suggestions.lyonaeroports.com",
  "surfsafevpn.com",
  "swdownloads.blackberry.com", // bug 1182997
  "syncd.com",
  "syzygy.co.uk",
  "tarjetacencosud.cl",
  "tele2.hr",
  "telebank.nomos.ru",
  "termlife.allstate.com",
  "thewigcompany.com",
  "tiendas.mediamarkt.es",
  "transer.com",
  "transfers.edinboro.edu",
  "uralsg.megafon.ru", // bug 1153168
  "us.ncsoft.com",
  "usacycling.org", // bug 1163791
  "usc.unist.ac.kr",
  "utradehub.or.kr",
  "vdesk.pugetsound.edu",
  "visawebapp.boca.gov.tw",
  "vo.5linx.com",
  "wapp.adecco.ch",
  "watch.sportsnet.ca", // bug 1144769
  "web.asta.org",
  "web.nccu.edu",
  "web.svsu.edu",
  "webapps.ou.edu",
  "webatm.landbank.com.tw",
  "webmail.ac-reunion.fr",
  "webmail.iyte.edu.tr",
  "webmail.unavarra.es",
  "websites.zooprinting.com",
  "websiti.cnbv.gob.mx",
  "webtv.tv2.no",
  "weddings.realresorts.com",
  "wis.ntu.edu.sg",
  "wszg.nbcs.gov.cn",
  "www.101phones.com",
  "www.2kgames.com",
  "www.2ksports.com",
  "www.5x2.de",
  "www.a-pat.jra.go.jp",
  "www.aa.co.uk", // bug 1141604
  "www.aa.com", // bug 1141604
  "www.aa.com.br", // bug 1141604
  "www.aa.com.do", // bug 1141604
  "www.aa.com.pe", // bug 1141604
  "www.aa.com.ve", // bug 1141604
  "www.aacargo.com",
  "www.aavacations.com", // bug 1141604
  "www.abetterstay.com",
  "www.absak.com",
  "www.accessallstate.com",
  "www.accessingram.com",
  "www.advanceweb.com",
  "www.aeroplan.com", // bug 1137543
  "www.affiliatepowergroup.com",
  "www.afford.com",
  "www.agenttrax.com",
  "www.aimp.ru",
  "www.akmembers.com",
  "www.alaskacommunications.com",
  "www.alc.ca",
  "www.all-spec.com",
  "www.allamericanswim.com",
  "www.allbankonline.in", // bug 1156441
  "www.allfoodequipment.com.au",
  "www.allinpay.com",
  "www.allnatura.de",
  "www.alphashirt.com",
  "www.american-airlines.co.kr", // bug 1141604
  "www.american-airlines.nl", // bug 1141604
  "www.americanairlines.be", // bug 1141604
  "www.americanairlines.ch", // bug 1141604
  "www.americanairlines.cl", // bug 1141604
  "www.americanairlines.cn", // bug 1141604
  "www.americanairlines.co.cr", // bug 1141604
  "www.americanairlines.co.uk", // bug 1141604
  "www.americanairlines.com", // bug 1141604
  "www.americanairlines.com.au", // bug 1141604
  "www.americanairlines.com.ru", // bug 1141604
  "www.americanairlines.de", // bug 1141604
  "www.americanairlines.es", // bug 1141604
  "www.americanairlines.fi", // bug 1141604
  "www.americanairlines.fr", // bug 1141604
  "www.americanairlines.hu", // bug 1141604
  "www.americanairlines.ie", // bug 1141604
  "www.americanairlines.in", // bug 1141604
  "www.americanairlines.it", // bug 1141604
  "www.americanairlines.jp", // bug 1141604
  "www.americanexpress.co.il",
  "www.amica.com", // bug 1139563
  "www.amleo.com",
  "www.amu.edu.pl",
  "www.amway.ca",
  "www.amway.co.jp",
  "www.amway.com",
  "www.amway.com.ar",
  "www.amway.com.co",
  "www.amway.com.do",
  "www.amway.my",
  "www.amztrainingacademy.com",
  "www.ancelutil.com.uy",
  "www.angelsport.de",
  "www.animate-onlineshop.jp", // bug 1126652
  "www.apeasternpower.com",
  "www.arcgames.com", // bug 1182932
  "www.arex.or.kr",
  "www.argentina.citibank.com",
  "www.art-of-craft.co.uk",
  "www.ase.org.uk",
  "www.asko.fi", // bug 1158584
  "www.assuralia.be",
  "www.auroragov.org",
  "www.bancocredichile.cl",
  "www.bankcomm.com.hk", // bug 1141742
  "www.bankhapoalim.biz",
  "www.bankhapoalim.co.il", // bug 1138231
  "www.bannersusa.com",
  "www.barefootconsultants.com",
  "www.baseballrampage.com",
  "www.baseballwarehouse.com",
  "www.bauschonline.com",
  "www.baybloorradio.com", // bug 1173661
  "www.bbsfonline.com",
  "www.bectu.org.uk",
  "www.belwue.de",
  "www.betterhealthusa.com",
  "www.bger.ch",
  "www.bigflix.com",
  "www.bigshotbikes.com",
  "www.bikejames.com",
  "www.bill36524.com",
  "www.bizzclick.com",
  "www.blastam.com",
  "www.blissmo.com",
  "www.blogwatcher.co.jp",
  "www.blueprintonline.co.za",
  "www.bluewateryachting.com",
  "www.bookdirect2save.com.au",
  "www.bookpubco.com",
  "www.bookstore.usu.edu",
  "www.boostmobilesales.com", // bug 1112178
  "www.borsaitaliana.it",
  "www.bottegaverde.es",
  "www.bottegaverde.it",
  "www.bottegaverde.pt",
  "www.bpmcarte.it",
  "www.builderdepot.com",
  "www.buildinggreen.com",
  "www.buppin.e-aichi.jp",
  "www.businessdirect.bt.com",
  "www.buy-trees.co.uk",
  "www.buzone.com.mx",
  "www.cafedumonde.jp",
  "www.cafis.jp",
  "www.calguns.net",
  "www.calvinkleinpreferred.com",
  "www.cambridgenetwork.co.uk",
  "www.carbidedepot.com",
  "www.carbonlessondemand.com",
  "www.careers.asio.gov.au",
  "www.carewireless.com",
  "www.carhistory.or.kr",
  "www.carpartparadise.com",
  "www.cbd.ae",
  "www.cellcom.co.il",
  "www.centralbank.net.in",
  "www.centurynovelty.com",
  "www.cg-express.com",
  "www.cgfns.org",
  "www.cherry.de", // bug 1141521
  "www.chinapay.com", // bug 1137983
  "www.cincinnatibell.com",
  "www.cincinnatichildrens.org",
  "www.cipd.co.uk",
  "www.citychiconline.com",
  "www.civilization.com", // bug 1156004
  "www.clalbit.co.il",
  "www.club-animate.jp",
  "www.clublacosta.com",
  "www.codan.dk",
  "www.companyformations.ie",
  "www.companyformations123.co.uk",
  "www.connexuscu.org",
  "www.contraloria.cl",
  "www.coolcarpartsonline.com",
  "www.corpone.org",
  "www.crazyegg.com",
  "www.credem.it",
  "www.crediscotia.com.mx",
  "www.creditagricole.info",
  "www.css-club.net",
  "www.ctfeshop.com.cn",
  "www.cubizone.com",
  "www.cwu.edu", // bug 1143035
  "www.d2pass.com",
  "www.dabs.com",
  "www.dabs.ie",
  "www.dabs4work.ie",
  "www.daiichi-engei.co.jp",
  "www.davidyurman.com",
  "www.dburnsdesign.com",
  "www.decopac.com",
  "www.deepdiscount.com",
  "www.delcity.net",
  "www.dennismillerradio.com",
  "www.derayah.com",
  "www.diamondresorts.com",
  "www.digibet.com",
  "www.digieco.co.kr",
  "www.diplom.de",
  "www.diplomarbeiten24.de",
  "www.doortodoor.co.kr",
  "www.dotbank.md",
  "www.drawing-tutorials-online.com",
  "www.drcsurveys.com",
  "www.dream-prize.com",
  "www.drewaltizer.com",
  "www.drlaura.com",
  "www.drvoip.com",
  "www.duskin.co.jp",
  "www.duskin.jp",
  "www.e-hapi.com",
  "www.easy.cl",
  "www.eatright.org",
  "www.ebs.co.kr",
  "www.ebse.co.kr",
  "www.ebsi.co.kr",
  "www.ec-line.cn",
  "www.echo.com",
  "www.echodesign.com",
  "www.echotrak.com",
  "www.edinboro.edu",
  "www.educatingforsuccess.com",
  "www.edunet4u.net",
  "www.emailtracker.cargill.com",
  "www.emich.edu",
  "www.encompassinsurance.com",
  "www.eoutlet4u.com",
  "www.epicreg.com",
  "www.equity.org.uk",
  "www.ermis.gov.gr",
  "www.esadealumni.net",
  "www.esavingsaccount.co.uk",
  "www.esgbl.com",
  "www.euplatesc.ro",
  "www.events.runningroom.com",
  "www.everyd.com",
  "www.evirtualservices.com",
  "www.examicus.de",
  "www.examiner.com",
  "www.expertpay.com",
  "www.expireddomains.co.nz",
  "www.expo2012.kr",
  "www.ezding.com.tw",
  "www.ezpay.com.tw",
  "www.f1autocentres.co.uk",
  "www.faeriesdance.com",
  "www.familyvideo.com",
  "www.farmtek.com",
  "www.farnell.com",
  "www.fashionscarvesandshawls.com",
  "www.favori.com.tr",
  "www.ffbh.com",
  "www.fgmarket.com",
  "www.fhsaa.org",
  "www.fibi-online.co.il", // bug 1165580
  "www.ficg.mx",
  "www.finestwatches.com",
  "www.fj96336.com",
  "www.fontdiner.com",
  "www.foodpyramidonline.com",
  "www.fordpartsuk.com",
  "www.forplaycatalog.com",
  "www.forplayinc.com",
  "www.foundersc.com",
  "www.framesbymail.com",
  "www.fubar.com",
  "www.gamers-onlineshop.jp", // bug 1126654
  "www.gardens4you.co.uk",
  "www.gbe-bund.de",
  "www.getkombucha.com",
  "www.getpark.co.uk",
  "www.giftcertificates.com",
  "www.girlsdressline.com",
  "www.giving.runningroom.com",
  "www.globalinx.com",
  "www.golf18network.com",
  "www.goodvibeuniversity.com",
  "www.gopresto.com",
  "www.goyada.com",
  "www.gpknives.com",
  "www.greatinternetmarketingtraining.com",
  "www.grin.com",
  "www.growerssupply.com",
  "www.gsmeasy.nl",
  "www.gtja.com",
  "www.guiders.de",
  "www.hacademia.com",
  "www.halkbank.com.tr",
  "www.handshoemouse.com",
  "www.hanyang.ac.kr",
  "www.harlequin.com",
  "www.hausarbeiten.de",
  "www.hbc.com",
  "www.hdis.com",
  "www.healthaffairs.org",
  "www.heart.org",
  "www.heidiandfrank.com",
  "www.hercle.com",
  "www.highstreetvouchers.com",
  "www.hipgirlclips.com",
  "www.hn.10086.cn",
  "www.hockeystrengthandconditioning.com",
  "www.holidaysplease.co.uk",
  "www.hornerschool.com",
  "www.horror-shop.com",
  "www.hotkeys.com",
  "www.hottopic.com",
  "www.hottracks.co.kr",
  "www.hpshop.gr",
  "www.hsbank.cc",
  "www.hursthardwoods.com",
  "www.hx168.com.cn",
  "www.i-mom.co.kr",
  "www.id90.com",
  "www.ilsos.gov",
  "www.infomex.org.mx",
  "www.ingramentertainment.com",
  "www.innerwolf.co.uk",
  "www.institut-entreprise.fr",
  "www.insuranceonline.state.co.nz",
  "www.insureportal.co.uk",
  "www.interpark.com",
  "www.interspire.com",
  "www.ipsww.com",
  "www.isracard.co.il", // bug 1165582
  "www.itsinyourjeans.co.uk",
  "www.jacksonandperkins.com",
  "www.jadedvideo.com",
  "www.jaf.or.jp",
  "www.jafp.or.jp",
  "www.jewelboxco.com",
  "www.jewelsbyparklane.com",
  "www.jumbo.cl",
  "www.kab.co.il",
  "www.kasite.net",
  "www.keyclient.it",
  "www.khan.co.kr",
  "www.kik-textilien.com",
  "www.kimptonhotels.com",
  "www.kinesissurvey.com",
  "www.king-solarman.com", // bug 1190706
  "www.kissmycart.net",
  "www.kitchenstuff.com",
  "www.knifecave.com",
  "www.knou.ac.kr",
  "www.korea.ac.kr",
  "www.koroad.or.kr",
  "www.kredodirect.com.ua", // bug 1095507
  "www.krivet.re.kr",
  "www.kt.com",
  "www.kubotacreditusa.com",
  "www.kuponan.ph",
  "www.lauraingraham.com",
  "www.law888.com.tw",
  "www.lespac.com",
  "www.lewisham.gov.uk",
  "www.lexus.ca",
  "www.libraryvideo.com",
  "www.lightonvedicastrology.com",
  "www.lightwerk.de",
  "www.lineage2.com",
  "www.lionbrand.com",
  "www.liveexpert.ru",
  "www.livinglebanese.com",
  "www.lm-order.de",
  "www.location-u.com",
  "www.londonmagicstore.co.uk",
  "www.londonstockexchange.com",
  "www.lotte.co.kr",
  "www.lottesuper.co.kr",
  "www.love2reward.co.uk",
  "www.lovelineshow.com",
  "www.loweslink.com",
  "www.luggagepoint.com",
  "www.lurongliving.com",
  "www.maccjcc.org",
  "www.madriverglen.com",
  "www.magnation.com",
  "www.marcospecialties.com",
  "www.math.ubc.ca",
  "www.matkahuolto.info",
  "www.matrics.or.jp",
  "www.maxkravmaga.com",
  "www.mchrono.com",
  "www.med-ed.virginia.edu",
  "www.medicalartspress.com",
  "www.meilleursagents.com",
  "www.meingartenshop.de",
  "www.membershipsiteowner.com",
  "www.mergernetwork.com",
  "www.meta-ehealth.com",
  "www.mikarose.com",
  "www.mimple.net",
  "www.ministrymatters.com",
  "www.minttwist.com",
  "www.mirrormate.com",
  "www.misterdonut.jp",
  "www.mit.gov.tr",
  "www.mitsubishimotors-mirage.com",
  "www.mixapparel.com.au",
  "www.monsterhouseplans.com",
  "www.moody.edu",
  "www.moodyradio.org",
  "www.mp2.aeroport.fr",
  "www.mpay.co.th",
  "www.mtsindia.in", // RC4
  "www.my.airdo.jp", // bug 1129773
  "www.myacn.com",
  "www.myacncanada.ca",
  "www.myagent.gov.ab.ca", // bug 1152827
  "www.myanycar.com",
  "www.mycarpaltunnel.com",
  "www.mychabad.org",
  "www.mycontact.co.nz",
  "www.myfloridacounty.com",
  "www.myfloridaremit.com",
  "www.myleather.com",
  "www.mymeetings.com",
  "www.myricoh.com",
  "www.mysick.com",
  "www.myticketin.com",
  "www.mywebreservations.com",
  "www.myxxxchurch.com",
  "www.ncsoft.com", // bug 1139782
  "www.nec-nexs.com",
  "www.nec.go.kr",
  "www.nescafe.es",
  "www.nestle-family.com",
  "www.nestle.com.br",
  "www.nestle.com.ec",
  "www.nestle.es",
  "www.nestlebaby.es",
  "www.nestleprofessional.com",
  "www.newchinalife.com",
  "www.newvitality.com",
  "www.nexon.net",
  "www.nicheology.com",
  "www.nite.org.il",
  "www.nomercysupply.nl",
  "www.ntsource.com",
  "www.oakstore.de",
  "www.ocbcwhhk.com", // bug 1141746
  "www.olatheks.org",
  "www.onlinephonestore.com",
  "www.ooshirts.com",
  "www.openwebosproject.org", // bug 1151990
  "www.oralsteroids.com",
  "www.osk188.com",
  "www.ou.edu",
  "www.paypal-media.com",
  "www.pbdink.com",
  "www.pdfscripting.com",
  "www.pen-kanagawa.ed.jp",
  "www.perfumania.com",
  "www.ph-online.ac.at",
  "www.physiciansmutual.com",
  "www.pioneer.com",
  "www.polla.cl",
  "www.pooldeals.com",
  "www.preparedpantry.com",
  "www.primcast.com",
  "www.prosearchplus.com",
  "www.ptg.org",
  "www.publicjobs.ie",
  "www.publicrecords.com",
  "www.pulmuoneshop.co.kr",
  "www.pvh.com",
  "www.pwcrecruiting.com",
  "www.q-net.or.kr",
  "www.races.runningroom.com",
  "www.raileurope-gcc.com",
  "www.raileurope-world.com",
  "www.raileurope.cn",
  "www.raileurope.co.in",
  "www.raileurope.com.ar",
  "www.raileurope.com.au",
  "www.raileurope.com.br",
  "www.razorgator.com",
  "www.realestatepipeline.com",
  "www.reclameaqui.com.br",
  "www.recoup.com",
  "www.recoverydatabase.net",
  "www.redcaptour.com",
  "www.redenergy.com.au",
  "www.redletterdays.co.uk",
  "www.registrarstats.com",
  "www.regonline.ca",
  "www.regonline.co.uk",
  "www.regonline.sg",
  "www.remotepc.net",
  "www.renaultcredit.com.ar",
  "www.reputation.com",
  "www.rg.fft.fr",
  "www.rietumu.lv",
  "www.rimac.com.pe",
  "www.riverguide.go.kr",
  "www.roadtoroota.com",
  "www.rosebrides.com",
  "www.roxyaffiliates.com",
  "www.rsagroup.com",
  "www.runningroom.com",
  "www.rwbaird.com",
  "www.s-book.net",
  "www.s20.co.kr",
  "www.sac.or.kr",
  "www.sacticket.co.kr",
  "www.safepass.cn",
  "www.sagetelecom.net",
  "www.samba.com",
  "www.saminfo.com",
  "www.samsungfire.com",
  "www.scion.ca",
  "www.sda.co.kr",
  "www.sdauhak.com",
  "www.securesites.com",
  "www.seedparade.co.uk",
  "www.seeuthere.com",
  "www.selfpointonline.it",
  "www.seouldesign.or.kr",
  "www.sermonsearch.com",
  "www.servicebench.com",
  "www.sesamnet.ch",
  "www.session.ne.jp",
  "www.seur.com",
  "www.shacomsecurities.com.hk", // bug 1141989
  "www.shakeout.org",
  "www.shop.bt.com",
  "www.shop.runningroom.com",
  "www.shortstay-london.com",
  "www.singtelshop.com",
  "www.skycasters.com",
  "www.sleepphones.com",
  "www.slovanet.sk",
  "www.smartcart.com",
  "www.smileedi.com",
  "www.smithbrothers.com",
  "www.smotor.com",
  "www.soccerdrillstips.com",
  "www.sokamocka.com",
  "www.sorensystems.com",
  "www.soukai.com",
  "www.spedireweb.it",
  "www.sprint.net",
  "www.stanjames.com",
  "www.starbucks.ca",
  "www.statononline.com",
  "www.stenhouse.com",
  "www.stickerland.nl",
  "www.stiftungen.org",
  "www.subscribeonline.co.uk",
  "www.sunderland.gov.uk",
  "www.surveyequipment.com",
  "www.svsu.edu",
  "www.systeminsight.co.uk",
  "www.syzygy.co.uk",
  "www.t1shopper.com",
  "www.taiwangun.biz",
  "www.taku3.net",
  "www.tarjetacencosud.cl",
  "www.taxlienuniversity.com",
  "www.tealife.co.jp",
  "www.teddytank.com",
  "www.tele2.hr",
  "www.telebrands.net",
  "www.telefonbucheintrag.de",
  "www.tetsudo.com",
  "www.thediscountflooringco.com",
  "www.thehandbook.com",
  "www.thepermitstore.com",
  "www.ticketstogo.com",
  "www.toutatice.fr",
  "www.toyota.ca",
  "www.tpvvirtual.net",
  "www.tranas.se",
  "www.treasuretrails.co.uk",
  "www.trkd.thomsonreuters.com", // bug 1172793
  "www.trustitalia.it",
  "www.tscapparel.com",
  "www.tsptalk.com",
  "www.u-gakugei.ac.jp",
  "www.uccard.co.jp",
  "www.ukr.jp",
  "www.uksmobility.co.uk",
  "www.undercovercondoms.com",
  "www.undergroundstrengthcoach.com",
  "www.upad.co.uk",
  "www.uqac.ca",
  "www.ur-net.go.jp",
  "www.usacycling.org", // bug 1163791
  "www.usairways.com", // bug 1142703
  "www.usairwaysvacations.com",
  "www.usbnow.co.uk",
  "www.usc.edu",
  "www.useaamiles.com",
  "www.usg.edu",
  "www.utradehub.or.kr",
  "www.vandykes.com",
  "www.vdolg.ru",
  "www.viainfo.net",
  "www.viajanet.com.ve",
  "www.videosecrets.com",
  "www.vidmeup.com",
  "www.virgin.net",
  "www.virginiats.com",
  "www.vivatv.com.tw",
  "www.volume.at",
  "www.wagggsworld.org",
  "www.wallartforless.com",
  "www.wavecable.com",
  "www.waysidegardens.com",
  "www.weberz.com",
  "www.webrun.com.br",
  "www.webventure.com.br",
  "www.wetax.go.kr",
  "www.wheelsthroughtime.com",
  "www.wingarc.com",
  "www.winner.co.il",
  "www.wohnservice-wien.at",
  "www.workingabroad.com",
  "www.workoncruiseships.com",
  "www.worshiphousemedia.com",
  "www.xrentdvd.com",
  "www.yakult.co.kr",
  "www.yeoin.com",
  "www.youtradefx.com",
  "www.ytfxaffiliates.com",
  "www.zenfolio.com",
  "www.zoominfo.com",
  "www.zzzs.si",
  "www1.aeroplan.com", // bug 1137543
  "www1.isracard.co.il", // bug 1165582
  "www2.aeroplan.com", // bug 1137543
  "www2.nfb.ca",
  "www2.uwplatt.edu",
  "www2.wou.edu",
  "www3.aeroplan.com", // bug 1137543
  "www3.ibac.co.jp",
  "www3.taiheiyo-ferry.co.jp",
  "www4.aeroplan.com", // bug 1137543
  "xyk.cebbank.com", // bug 1145524
  "zenfolio.com",
  "ziniarasciai.secure.su.lt",
  "zoominfo.com",
};
