/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.app.Instrumentation;
import android.view.View;
import android.widget.EditText;
import com.jayway.android.robotium.solo.ActivityUtils;
import com.jayway.android.robotium.solo.Clicker;
import junit.framework.Assert;

class TextEnterer {
    private final Instrumentation inst;
    private final Clicker clicker;
    private final ActivityUtils activityUtils;

    public TextEnterer(Instrumentation inst, ActivityUtils activityUtils, Clicker clicker) {
        this.inst = inst;
        this.activityUtils = activityUtils;
        this.clicker = clicker;
    }

    public void setEditText(final EditText editText, final String text) {
        if (editText != null) {
            final String previousText = editText.getText().toString();
            this.inst.runOnMainSync(new Runnable(){

                public void run() {
                    editText.setInputType(0);
                    editText.performClick();
                    TextEnterer.this.activityUtils.hideSoftKeyboard(editText, true, false);
                    if (text.equals("")) {
                        editText.setText((CharSequence)text);
                    } else {
                        editText.setText((CharSequence)(previousText + text));
                        editText.setCursorVisible(false);
                    }
                }
            });
        }
    }

    public void typeText(final EditText editText, String text) {
        if (editText != null) {
            this.inst.runOnMainSync(new Runnable(){

                public void run() {
                    editText.setInputType(0);
                }
            });
            this.clicker.clickOnScreen((View)editText, false, 0);
            this.activityUtils.hideSoftKeyboard(editText, true, true);
            boolean successfull = false;
            int retry = 0;
            while (!successfull && retry < 10) {
                try {
                    this.inst.sendStringSync(text);
                    successfull = true;
                }
                catch (SecurityException e) {
                    this.activityUtils.hideSoftKeyboard(editText, true, true);
                    ++retry;
                }
            }
            if (!successfull) {
                Assert.assertTrue((String)"Text can not be typed!", (boolean)false);
            }
        }
    }
}

