/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.app.Activity;
import android.app.Instrumentation;
import android.graphics.PointF;
import android.os.Build;
import android.view.View;
import android.webkit.WebView;
import android.widget.AbsListView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CheckedTextView;
import android.widget.CompoundButton;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.RadioButton;
import android.widget.ScrollView;
import android.widget.SlidingDrawer;
import android.widget.TextView;
import android.widget.TimePicker;
import android.widget.ToggleButton;
import com.jayway.android.robotium.solo.ActivityUtils;
import com.jayway.android.robotium.solo.Asserter;
import com.jayway.android.robotium.solo.By;
import com.jayway.android.robotium.solo.Checker;
import com.jayway.android.robotium.solo.Clicker;
import com.jayway.android.robotium.solo.Condition;
import com.jayway.android.robotium.solo.DialogUtils;
import com.jayway.android.robotium.solo.Getter;
import com.jayway.android.robotium.solo.Presser;
import com.jayway.android.robotium.solo.Rotator;
import com.jayway.android.robotium.solo.ScreenshotTaker;
import com.jayway.android.robotium.solo.Scroller;
import com.jayway.android.robotium.solo.Searcher;
import com.jayway.android.robotium.solo.Sender;
import com.jayway.android.robotium.solo.Setter;
import com.jayway.android.robotium.solo.Sleeper;
import com.jayway.android.robotium.solo.Swiper;
import com.jayway.android.robotium.solo.Tapper;
import com.jayway.android.robotium.solo.TextEnterer;
import com.jayway.android.robotium.solo.Timeout;
import com.jayway.android.robotium.solo.ViewFetcher;
import com.jayway.android.robotium.solo.Waiter;
import com.jayway.android.robotium.solo.WebElement;
import com.jayway.android.robotium.solo.WebUtils;
import com.jayway.android.robotium.solo.Zoomer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Solo {
    protected final Asserter asserter;
    protected final ViewFetcher viewFetcher;
    protected final Checker checker;
    protected final Clicker clicker;
    protected final Presser presser;
    protected final Searcher searcher;
    protected final ActivityUtils activityUtils;
    protected final DialogUtils dialogUtils;
    protected final TextEnterer textEnterer;
    protected final Rotator rotator;
    protected final Scroller scroller;
    protected final Sleeper sleeper;
    protected final Swiper swiper;
    protected final Tapper tapper;
    protected final Waiter waiter;
    protected final Setter setter;
    protected final Getter getter;
    protected final WebUtils webUtils;
    protected final Sender sender;
    protected final ScreenshotTaker screenshotTaker;
    protected final Instrumentation instrumentation;
    protected final Zoomer zoomer;
    protected String webUrl = null;
    public static final int LANDSCAPE = 0;
    public static final int PORTRAIT = 1;
    public static final int RIGHT = 22;
    public static final int LEFT = 21;
    public static final int UP = 19;
    public static final int DOWN = 20;
    public static final int ENTER = 66;
    public static final int MENU = 82;
    public static final int DELETE = 67;
    public static final int CLOSED = 0;
    public static final int OPENED = 1;

    public Solo(Instrumentation instrumentation, Activity activity) {
        this.instrumentation = instrumentation;
        this.sleeper = new Sleeper();
        this.sender = new Sender(instrumentation, this.sleeper);
        this.activityUtils = new ActivityUtils(instrumentation, activity, this.sleeper);
        this.viewFetcher = new ViewFetcher(this.activityUtils);
        this.screenshotTaker = new ScreenshotTaker(this.activityUtils, this.viewFetcher, this.sleeper);
        this.dialogUtils = new DialogUtils(this.activityUtils, this.viewFetcher, this.sleeper);
        this.webUtils = new WebUtils(instrumentation, this.activityUtils, this.viewFetcher, this.sleeper);
        this.scroller = new Scroller(instrumentation, this.activityUtils, this.viewFetcher, this.sleeper);
        this.searcher = new Searcher(this.viewFetcher, this.webUtils, this.scroller, this.sleeper);
        this.waiter = new Waiter(this.activityUtils, this.viewFetcher, this.searcher, this.scroller, this.sleeper);
        this.setter = new Setter(this.activityUtils);
        this.getter = new Getter(instrumentation, this.activityUtils, this.waiter);
        this.asserter = new Asserter(this.activityUtils, this.waiter);
        this.checker = new Checker(this.viewFetcher, this.waiter);
        this.clicker = new Clicker(this.activityUtils, this.viewFetcher, this.sender, instrumentation, this.sleeper, this.waiter, this.webUtils, this.dialogUtils);
        this.zoomer = new Zoomer(instrumentation);
        this.swiper = new Swiper(instrumentation);
        this.tapper = new Tapper(instrumentation);
        this.rotator = new Rotator(instrumentation);
        this.presser = new Presser(this.clicker, instrumentation, this.sleeper, this.waiter, this.dialogUtils);
        this.textEnterer = new TextEnterer(instrumentation, this.activityUtils, this.clicker);
    }

    public Solo(Instrumentation instrumentation) {
        this(instrumentation, null);
    }

    public Instrumentation.ActivityMonitor getActivityMonitor() {
        return this.activityUtils.getActivityMonitor();
    }

    public ArrayList<View> getViews() {
        try {
            return this.viewFetcher.getViews(null, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ArrayList<View> getViews(View parent) {
        try {
            return this.viewFetcher.getViews(parent, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public View getTopParent(View view) {
        View topParent = this.viewFetcher.getTopParent(view);
        return topParent;
    }

    public boolean waitForText(String text) {
        return this.waiter.waitForText(text) != null;
    }

    public boolean waitForText(String text, int minimumNumberOfMatches, long timeout) {
        return this.waiter.waitForText(text, minimumNumberOfMatches, timeout) != null;
    }

    public boolean waitForText(String text, int minimumNumberOfMatches, long timeout, boolean scroll) {
        return this.waiter.waitForText(text, minimumNumberOfMatches, timeout, scroll) != null;
    }

    public boolean waitForText(String text, int minimumNumberOfMatches, long timeout, boolean scroll, boolean onlyVisible) {
        return this.waiter.waitForText(text, minimumNumberOfMatches, timeout, scroll, onlyVisible, true) != null;
    }

    public boolean waitForView(int id) {
        return this.waitForView(id, 0, Timeout.getLargeTimeout(), true);
    }

    public boolean waitForView(int id, int minimumNumberOfMatches, int timeout) {
        return this.waitForView(id, minimumNumberOfMatches, timeout, true);
    }

    public boolean waitForView(int id, int minimumNumberOfMatches, int timeout, boolean scroll) {
        int index = minimumNumberOfMatches - 1;
        if (index < 1) {
            index = 0;
        }
        return this.waiter.waitForView(id, index, timeout, scroll) != null;
    }

    public <T extends View> boolean waitForView(Class<T> viewClass) {
        return this.waiter.waitForView(viewClass, 0, Timeout.getLargeTimeout(), true);
    }

    public <T extends View> boolean waitForView(View view) {
        return this.waiter.waitForView(view);
    }

    public <T extends View> boolean waitForView(View view, int timeout, boolean scroll) {
        return this.waiter.waitForView(view, timeout, scroll);
    }

    public <T extends View> boolean waitForView(Class<T> viewClass, int minimumNumberOfMatches, int timeout) {
        int index = minimumNumberOfMatches - 1;
        if (index < 1) {
            index = 0;
        }
        return this.waiter.waitForView(viewClass, index, timeout, true);
    }

    public <T extends View> boolean waitForView(Class<T> viewClass, int minimumNumberOfMatches, int timeout, boolean scroll) {
        int index = minimumNumberOfMatches - 1;
        if (index < 1) {
            index = 0;
        }
        return this.waiter.waitForView(viewClass, index, timeout, scroll);
    }

    public boolean waitForWebElement(By by) {
        return this.waiter.waitForWebElement(by, 0, Timeout.getLargeTimeout(), true) != null;
    }

    public boolean waitForWebElement(By by, int timeout, boolean scroll) {
        return this.waiter.waitForWebElement(by, 0, timeout, scroll) != null;
    }

    public boolean waitForWebElement(By by, int minimumNumberOfMatches, int timeout, boolean scroll) {
        return this.waiter.waitForWebElement(by, minimumNumberOfMatches, timeout, scroll) != null;
    }

    public boolean waitForCondition(Condition condition, int timeout) {
        return this.waiter.waitForCondition(condition, timeout);
    }

    public boolean searchEditText(String text) {
        return this.searcher.searchWithTimeoutFor(EditText.class, text, 1, true, false);
    }

    public boolean searchButton(String text) {
        return this.searcher.searchWithTimeoutFor(Button.class, text, 0, true, false);
    }

    public boolean searchButton(String text, boolean onlyVisible) {
        return this.searcher.searchWithTimeoutFor(Button.class, text, 0, true, onlyVisible);
    }

    public boolean searchToggleButton(String text) {
        return this.searcher.searchWithTimeoutFor(ToggleButton.class, text, 0, true, false);
    }

    public boolean searchButton(String text, int minimumNumberOfMatches) {
        return this.searcher.searchWithTimeoutFor(Button.class, text, minimumNumberOfMatches, true, false);
    }

    public boolean searchButton(String text, int minimumNumberOfMatches, boolean onlyVisible) {
        return this.searcher.searchWithTimeoutFor(Button.class, text, minimumNumberOfMatches, true, onlyVisible);
    }

    public boolean searchToggleButton(String text, int minimumNumberOfMatches) {
        return this.searcher.searchWithTimeoutFor(ToggleButton.class, text, minimumNumberOfMatches, true, false);
    }

    public boolean searchText(String text) {
        return this.searcher.searchWithTimeoutFor(TextView.class, text, 0, true, false);
    }

    public boolean searchText(String text, boolean onlyVisible) {
        return this.searcher.searchWithTimeoutFor(TextView.class, text, 0, true, onlyVisible);
    }

    public boolean searchText(String text, int minimumNumberOfMatches) {
        return this.searcher.searchWithTimeoutFor(TextView.class, text, minimumNumberOfMatches, true, false);
    }

    public boolean searchText(String text, int minimumNumberOfMatches, boolean scroll) {
        return this.searcher.searchWithTimeoutFor(TextView.class, text, minimumNumberOfMatches, scroll, false);
    }

    public boolean searchText(String text, int minimumNumberOfMatches, boolean scroll, boolean onlyVisible) {
        return this.searcher.searchWithTimeoutFor(TextView.class, text, minimumNumberOfMatches, scroll, onlyVisible);
    }

    public void setActivityOrientation(int orientation) {
        this.activityUtils.setActivityOrientation(orientation);
    }

    public Activity getCurrentActivity() {
        return this.activityUtils.getCurrentActivity(false);
    }

    public void assertCurrentActivity(String message, String name) {
        this.asserter.assertCurrentActivity(message, name);
    }

    public void assertCurrentActivity(String message, Class activityClass) {
        this.asserter.assertCurrentActivity(message, activityClass);
    }

    public void assertCurrentActivity(String message, String name, boolean isNewInstance) {
        this.asserter.assertCurrentActivity(message, name, isNewInstance);
    }

    public void assertCurrentActivity(String message, Class activityClass, boolean isNewInstance) {
        this.asserter.assertCurrentActivity(message, activityClass, isNewInstance);
    }

    public void assertMemoryNotLow() {
        this.asserter.assertMemoryNotLow();
    }

    public boolean waitForDialogToOpen(long timeout) {
        return this.dialogUtils.waitForDialogToOpen(timeout);
    }

    public boolean waitForDialogToClose(long timeout) {
        return this.dialogUtils.waitForDialogToClose(timeout);
    }

    public void goBack() {
        this.sender.goBack();
    }

    public void clickOnScreen(float x, float y) {
        this.sleeper.sleep();
        this.clicker.clickOnScreen(x, y);
    }

    public void clickOnScreen(float x, float y, int numberOfClicks) {
        if (Build.VERSION.SDK_INT < 14) {
            throw new RuntimeException("clickOnScreen(float x, float y, int numberOfClicks) requires API level >= 14");
        }
        this.tapper.generateTapGesture(numberOfClicks, new PointF(x, y));
    }

    public void clickLongOnScreen(float x, float y) {
        this.clicker.clickLongOnScreen(x, y, 0);
    }

    public void clickLongOnScreen(float x, float y, int time) {
        this.clicker.clickLongOnScreen(x, y, time);
    }

    public void clickOnButton(String text) {
        this.clicker.clickOn(Button.class, text);
    }

    public void clickOnImageButton(int index) {
        this.clicker.clickOn(ImageButton.class, index);
    }

    public void clickOnToggleButton(String text) {
        this.clicker.clickOn(ToggleButton.class, text);
    }

    public void clickOnMenuItem(String text) {
        this.clicker.clickOnMenuItem(text);
    }

    public void clickOnMenuItem(String text, boolean subMenu) {
        this.clicker.clickOnMenuItem(text, subMenu);
    }

    public void clickOnWebElement(WebElement webElement) {
        if (webElement == null) {
            Assert.assertTrue((String)"WebElement is null and can therefore not be clicked!", (boolean)false);
        }
        this.clicker.clickOnScreen(webElement.getLocationX(), webElement.getLocationY());
    }

    public void clickOnWebElement(By by) {
        this.clicker.clickOnWebElement(by, 0, true);
    }

    public void clickOnWebElement(By by, int match) {
        this.clicker.clickOnWebElement(by, match, true);
    }

    public void clickOnWebElement(By by, int match, boolean scroll) {
        this.clicker.clickOnWebElement(by, match, scroll);
    }

    public void pressMenuItem(int index) {
        this.presser.pressMenuItem(index);
    }

    public void pressMenuItem(int index, int itemsPerRow) {
        this.presser.pressMenuItem(index, itemsPerRow);
    }

    public void pressSpinnerItem(int spinnerIndex, int itemIndex) {
        this.presser.pressSpinnerItem(spinnerIndex, itemIndex);
    }

    public void clickOnView(View view) {
        this.waiter.waitForView(view, Timeout.getSmallTimeout());
        this.clicker.clickOnScreen(view);
    }

    public void clickOnView(View view, boolean immediately) {
        if (immediately) {
            this.clicker.clickOnScreen(view);
        } else {
            this.waiter.waitForView(view, Timeout.getSmallTimeout());
            this.clicker.clickOnScreen(view);
        }
    }

    public void clickLongOnView(View view) {
        this.waiter.waitForView(view, Timeout.getSmallTimeout());
        this.clicker.clickOnScreen(view, true, 0);
    }

    public void clickLongOnView(View view, int time) {
        this.clicker.clickOnScreen(view, true, time);
    }

    public void clickOnText(String text) {
        this.clicker.clickOnText(text, false, 1, true, 0);
    }

    public void clickOnText(String text, int match) {
        this.clicker.clickOnText(text, false, match, true, 0);
    }

    public void clickOnText(String text, int match, boolean scroll) {
        this.clicker.clickOnText(text, false, match, scroll, 0);
    }

    public void clickLongOnText(String text) {
        this.clicker.clickOnText(text, true, 1, true, 0);
    }

    public void clickLongOnText(String text, int match) {
        this.clicker.clickOnText(text, true, match, true, 0);
    }

    public void clickLongOnText(String text, int match, boolean scroll) {
        this.clicker.clickOnText(text, true, match, scroll, 0);
    }

    public void clickLongOnText(String text, int match, int time) {
        this.clicker.clickOnText(text, true, match, true, time);
    }

    public void clickLongOnTextAndPress(String text, int index) {
        this.clicker.clickLongOnTextAndPress(text, index);
    }

    public void clickOnButton(int index) {
        this.clicker.clickOn(Button.class, index);
    }

    public void clickOnRadioButton(int index) {
        this.clicker.clickOn(RadioButton.class, index);
    }

    public void clickOnCheckBox(int index) {
        this.clicker.clickOn(CheckBox.class, index);
    }

    public void clickOnEditText(int index) {
        this.clicker.clickOn(EditText.class, index);
    }

    public ArrayList<TextView> clickInList(int line) {
        return this.clicker.clickInList(line);
    }

    public ArrayList<TextView> clickInList(int line, int index) {
        return this.clicker.clickInList(line, index, false, 0);
    }

    public ArrayList<TextView> clickLongInList(int line) {
        return this.clicker.clickInList(line, 0, true, 0);
    }

    public ArrayList<TextView> clickLongInList(int line, int index) {
        return this.clicker.clickInList(line, index, true, 0);
    }

    public ArrayList<TextView> clickLongInList(int line, int index, int time) {
        return this.clicker.clickInList(line, index, true, time);
    }

    public void clickOnActionBarItem(int id) {
        this.clicker.clickOnActionBarItem(id);
    }

    public void clickOnActionBarHomeButton() {
        this.clicker.clickOnActionBarHomeButton();
    }

    public void drag(float fromX, float toX, float fromY, float toY, int stepCount) {
        this.scroller.drag(fromX, toX, fromY, toY, stepCount);
    }

    public boolean scrollDown() {
        this.waiter.waitForViews(AbsListView.class, ScrollView.class, WebView.class);
        return this.scroller.scroll(0);
    }

    public void scrollToBottom() {
        this.waiter.waitForViews(AbsListView.class, ScrollView.class, WebView.class);
        this.scroller.scroll(0, true);
    }

    public boolean scrollUp() {
        this.waiter.waitForViews(AbsListView.class, ScrollView.class, WebView.class);
        return this.scroller.scroll(1);
    }

    public void scrollToTop() {
        this.waiter.waitForViews(AbsListView.class, ScrollView.class, WebView.class);
        this.scroller.scroll(1, true);
    }

    public boolean scrollDownList(AbsListView list) {
        return this.scroller.scrollList(list, 0, false);
    }

    public boolean scrollListToBottom(AbsListView list) {
        return this.scroller.scrollList(list, 0, true);
    }

    public boolean scrollUpList(AbsListView list) {
        return this.scroller.scrollList(list, 1, false);
    }

    public boolean scrollListToTop(AbsListView list) {
        return this.scroller.scrollList(list, 1, true);
    }

    public boolean scrollDownList(int index) {
        return this.scroller.scrollList((AbsListView)this.waiter.waitForAndGetView(index, ListView.class), 0, false);
    }

    public boolean scrollListToBottom(int index) {
        return this.scroller.scrollList((AbsListView)this.waiter.waitForAndGetView(index, ListView.class), 0, true);
    }

    public boolean scrollUpList(int index) {
        return this.scroller.scrollList((AbsListView)this.waiter.waitForAndGetView(index, ListView.class), 1, false);
    }

    public boolean scrollListToTop(int index) {
        return this.scroller.scrollList((AbsListView)this.waiter.waitForAndGetView(index, ListView.class), 1, true);
    }

    public void scrollListToLine(AbsListView absListView, int line) {
        this.scroller.scrollListToLine(absListView, line);
    }

    public void scrollListToLine(int index, int line) {
        this.scroller.scrollListToLine(this.waiter.waitForAndGetView(index, AbsListView.class), line);
    }

    public void scrollToSide(int side) {
        switch (side) {
            case 22: {
                this.scroller.scrollToSide(Scroller.Side.RIGHT);
                break;
            }
            case 21: {
                this.scroller.scrollToSide(Scroller.Side.LEFT);
            }
        }
    }

    public void scrollViewToSide(View view, int side) {
        switch (side) {
            case 22: {
                this.scroller.scrollViewToSide(view, Scroller.Side.RIGHT);
                break;
            }
            case 21: {
                this.scroller.scrollViewToSide(view, Scroller.Side.LEFT);
            }
        }
    }

    public void pinchToZoom(PointF startPoint1, PointF startPoint2, PointF endPoint1, PointF endPoint2) {
        if (Build.VERSION.SDK_INT < 14) {
            throw new RuntimeException("pinchToZoom() requires API level >= 14");
        }
        this.zoomer.generateZoomGesture(startPoint1, startPoint2, endPoint1, endPoint2);
    }

    public void swipe(PointF startPoint1, PointF startPoint2, PointF endPoint1, PointF endPoint2) {
        if (Build.VERSION.SDK_INT < 14) {
            throw new RuntimeException("swipe() requires API level >= 14");
        }
        this.swiper.generateSwipeGesture(startPoint1, startPoint2, endPoint1, endPoint2);
    }

    public void rotateLarge(PointF center1, PointF center2) {
        if (Build.VERSION.SDK_INT < 14) {
            throw new RuntimeException("rotateLarge(PointF center1, PointF center2) requires API level >= 14");
        }
        this.rotator.generateRotateGesture(0, center1, center2);
    }

    public void rotateSmall(PointF center1, PointF center2) {
        if (Build.VERSION.SDK_INT < 14) {
            throw new RuntimeException("rotateSmall(PointF center1, PointF center2) requires API level >= 14");
        }
        this.rotator.generateRotateGesture(1, center1, center2);
    }

    public void setDatePicker(int index, int year, int monthOfYear, int dayOfMonth) {
        this.setDatePicker(this.waiter.waitForAndGetView(index, DatePicker.class), year, monthOfYear, dayOfMonth);
    }

    public void setDatePicker(DatePicker datePicker, int year, int monthOfYear, int dayOfMonth) {
        this.waiter.waitForView((View)datePicker, Timeout.getSmallTimeout());
        this.setter.setDatePicker(datePicker, year, monthOfYear, dayOfMonth);
    }

    public void setTimePicker(int index, int hour, int minute) {
        this.setTimePicker(this.waiter.waitForAndGetView(index, TimePicker.class), hour, minute);
    }

    public void setTimePicker(TimePicker timePicker, int hour, int minute) {
        this.waiter.waitForView((View)timePicker, Timeout.getSmallTimeout());
        this.setter.setTimePicker(timePicker, hour, minute);
    }

    public void setProgressBar(int index, int progress) {
        this.setProgressBar(this.waiter.waitForAndGetView(index, ProgressBar.class), progress);
    }

    public void setProgressBar(ProgressBar progressBar, int progress) {
        this.waiter.waitForView((View)progressBar, Timeout.getSmallTimeout());
        this.setter.setProgressBar(progressBar, progress);
    }

    public void setSlidingDrawer(int index, int status) {
        this.setSlidingDrawer(this.waiter.waitForAndGetView(index, SlidingDrawer.class), status);
    }

    public void setSlidingDrawer(SlidingDrawer slidingDrawer, int status) {
        this.waiter.waitForView((View)slidingDrawer, Timeout.getSmallTimeout());
        this.setter.setSlidingDrawer(slidingDrawer, status);
    }

    public void enterText(int index, String text) {
        this.textEnterer.setEditText(this.waiter.waitForAndGetView(index, EditText.class), text);
    }

    public void enterText(EditText editText, String text) {
        this.waiter.waitForView((View)editText, Timeout.getSmallTimeout());
        this.textEnterer.setEditText(editText, text);
    }

    public void enterTextInWebElement(By by, String text) {
        if (this.waiter.waitForWebElement(by, 0, Timeout.getSmallTimeout(), false) == null) {
            Assert.assertTrue((String)("WebElement with " + this.webUtils.splitNameByUpperCase(by.getClass().getSimpleName()) + ": '" + by.getValue() + "' is not found!"), (boolean)false);
        }
        this.webUtils.enterTextIntoWebElement(by, text);
    }

    public void typeText(int index, String text) {
        this.textEnterer.typeText(this.waiter.waitForAndGetView(index, EditText.class), text);
    }

    public void typeText(EditText editText, String text) {
        this.waiter.waitForView((View)editText, Timeout.getSmallTimeout());
        this.textEnterer.typeText(editText, text);
    }

    public void typeTextInWebElement(By by, String text) {
        this.clickOnWebElement(by);
        this.activityUtils.hideSoftKeyboard(null, true, true);
        this.instrumentation.sendStringSync(text);
    }

    public void typeTextInWebElement(By by, String text, int match) {
        this.clickOnWebElement(by, match);
        this.activityUtils.hideSoftKeyboard(null, true, true);
        this.instrumentation.sendStringSync(text);
    }

    public void typeTextInWebElement(WebElement webElement, String text) {
        this.clickOnWebElement(webElement);
        this.activityUtils.hideSoftKeyboard(null, true, true);
        this.instrumentation.sendStringSync(text);
    }

    public void clearEditText(int index) {
        this.textEnterer.setEditText(this.waiter.waitForAndGetView(index, EditText.class), "");
    }

    public void clearEditText(EditText editText) {
        this.waiter.waitForView((View)editText, Timeout.getSmallTimeout());
        this.textEnterer.setEditText(editText, "");
    }

    public void clearTextInWebElement(By by) {
        this.webUtils.enterTextIntoWebElement(by, "");
    }

    public void clickOnImage(int index) {
        this.clicker.clickOn(ImageView.class, index);
    }

    public EditText getEditText(int index) {
        return this.getter.getView(EditText.class, index);
    }

    public Button getButton(int index) {
        return this.getter.getView(Button.class, index);
    }

    public TextView getText(int index) {
        return this.getter.getView(TextView.class, index);
    }

    public ImageView getImage(int index) {
        return this.getter.getView(ImageView.class, index);
    }

    public ImageButton getImageButton(int index) {
        return this.getter.getView(ImageButton.class, index);
    }

    public TextView getText(String text) {
        return this.getter.getView(TextView.class, text, false);
    }

    public TextView getText(String text, boolean onlyVisible) {
        return this.getter.getView(TextView.class, text, onlyVisible);
    }

    public Button getButton(String text) {
        return this.getter.getView(Button.class, text, false);
    }

    public Button getButton(String text, boolean onlyVisible) {
        return this.getter.getView(Button.class, text, onlyVisible);
    }

    public EditText getEditText(String text) {
        return this.getter.getView(EditText.class, text, false);
    }

    public EditText getEditText(String text, boolean onlyVisible) {
        return this.getter.getView(EditText.class, text, onlyVisible);
    }

    public View getView(int id) {
        return this.getView(id, 0);
    }

    public View getView(int id, int index) {
        View viewToReturn = this.getter.getView(id, index);
        if (viewToReturn == null) {
            int match = index + 1;
            if (match > 1) {
                Assert.assertTrue((String)(match + " Views with id: '" + id + "' are not found!"), (boolean)false);
            } else {
                Assert.assertTrue((String)("View with id: '" + id + "' is not found!"), (boolean)false);
            }
        }
        return viewToReturn;
    }

    public View getView(String id) {
        return this.getter.getView(id, 0);
    }

    public View getView(String id, int index) {
        View viewToReturn = this.getter.getView(id, index);
        if (viewToReturn == null) {
            int match = index + 1;
            if (match > 1) {
                Assert.assertTrue((String)(match + " Views with id: '" + id + "' are not found!"), (boolean)false);
            } else {
                Assert.assertTrue((String)("View with id: '" + id + "' is not found!"), (boolean)false);
            }
        }
        return viewToReturn;
    }

    public <T extends View> T getView(Class<T> viewClass, int index) {
        return this.waiter.waitForAndGetView(index, viewClass);
    }

    public WebElement getWebElement(By by, int index) {
        int match = index + 1;
        WebElement webElement = this.waiter.waitForWebElement(by, match, Timeout.getSmallTimeout(), true);
        if (webElement == null) {
            if (match > 1) {
                Assert.assertTrue((String)(match + " WebElements with " + this.webUtils.splitNameByUpperCase(by.getClass().getSimpleName()) + ": '" + by.getValue() + "' are not found!"), (boolean)false);
            } else {
                Assert.assertTrue((String)("WebElement with " + this.webUtils.splitNameByUpperCase(by.getClass().getSimpleName()) + ": '" + by.getValue() + "' is not found!"), (boolean)false);
            }
        }
        return webElement;
    }

    public String getWebUrl() {
        final WebView webView = this.waiter.waitForAndGetView(0, WebView.class);
        if (webView == null) {
            Assert.assertTrue((String)"WebView is not found!", (boolean)false);
        }
        this.instrumentation.runOnMainSync(new Runnable(){

            public void run() {
                Solo.this.webUrl = webView.getUrl();
            }
        });
        return this.webUrl;
    }

    public ArrayList<View> getCurrentViews() {
        return this.viewFetcher.getViews(null, true);
    }

    public <T extends View> ArrayList<T> getCurrentViews(Class<T> classToFilterBy) {
        return this.viewFetcher.getCurrentViews(classToFilterBy);
    }

    public <T extends View> ArrayList<T> getCurrentViews(Class<T> classToFilterBy, View parent) {
        return this.viewFetcher.getCurrentViews(classToFilterBy, parent);
    }

    public ArrayList<WebElement> getCurrentWebElements() {
        return this.webUtils.getCurrentWebElements();
    }

    public ArrayList<WebElement> getCurrentWebElements(By by) {
        return this.webUtils.getCurrentWebElements(by);
    }

    public boolean isRadioButtonChecked(int index) {
        return this.checker.isButtonChecked(RadioButton.class, index);
    }

    public boolean isRadioButtonChecked(String text) {
        return this.checker.isButtonChecked(RadioButton.class, text);
    }

    public boolean isCheckBoxChecked(int index) {
        return this.checker.isButtonChecked(CheckBox.class, index);
    }

    public boolean isToggleButtonChecked(String text) {
        return this.checker.isButtonChecked(ToggleButton.class, text);
    }

    public boolean isToggleButtonChecked(int index) {
        return this.checker.isButtonChecked(ToggleButton.class, index);
    }

    public boolean isCheckBoxChecked(String text) {
        return this.checker.isButtonChecked(CheckBox.class, text);
    }

    public boolean isTextChecked(String text) {
        this.waiter.waitForViews(CheckedTextView.class, CompoundButton.class);
        if (this.viewFetcher.getCurrentViews(CheckedTextView.class).size() > 0 && this.checker.isCheckedTextChecked(text)) {
            return true;
        }
        return this.viewFetcher.getCurrentViews(CompoundButton.class).size() > 0 && this.checker.isButtonChecked(CompoundButton.class, text);
    }

    public boolean isSpinnerTextSelected(String text) {
        return this.checker.isSpinnerTextSelected(text);
    }

    public boolean isSpinnerTextSelected(int index, String text) {
        return this.checker.isSpinnerTextSelected(index, text);
    }

    public void hideSoftKeyboard() {
        this.activityUtils.hideSoftKeyboard(null, true, false);
    }

    public void sendKey(int key) {
        this.sender.sendKeyCode(key);
    }

    public void goBackToActivity(String name) {
        this.activityUtils.goBackToActivity(name);
    }

    public boolean waitForActivity(String name) {
        return this.waiter.waitForActivity(name, Timeout.getLargeTimeout());
    }

    public boolean waitForActivity(String name, int timeout) {
        return this.waiter.waitForActivity(name, timeout);
    }

    public boolean waitForActivity(Class<? extends Activity> activityClass) {
        return this.waiter.waitForActivity(activityClass, Timeout.getLargeTimeout());
    }

    public boolean waitForActivity(Class<? extends Activity> activityClass, int timeout) {
        return this.waiter.waitForActivity(activityClass, timeout);
    }

    public boolean waitForFragmentByTag(String tag) {
        return this.waiter.waitForFragment(tag, 0, Timeout.getLargeTimeout());
    }

    public boolean waitForFragmentByTag(String tag, int timeout) {
        return this.waiter.waitForFragment(tag, 0, timeout);
    }

    public boolean waitForFragmentById(int id) {
        return this.waiter.waitForFragment(null, id, Timeout.getLargeTimeout());
    }

    public boolean waitForFragmentById(int id, int timeout) {
        return this.waiter.waitForFragment(null, id, timeout);
    }

    public boolean waitForLogMessage(String logMessage) {
        return this.waiter.waitForLogMessage(logMessage, Timeout.getLargeTimeout());
    }

    public boolean waitForLogMessage(String logMessage, int timeout) {
        return this.waiter.waitForLogMessage(logMessage, timeout);
    }

    public void clearLog() {
        this.waiter.clearLog();
    }

    public String getString(int id) {
        return this.activityUtils.getString(id);
    }

    public void sleep(int time) {
        this.sleeper.sleep(time);
    }

    public void finalize() throws Throwable {
        this.activityUtils.finalize();
    }

    public void finishOpenedActivities() {
        this.activityUtils.finishOpenedActivities();
    }

    public void takeScreenshot() {
        this.takeScreenshot(null);
    }

    public void takeScreenshot(String name) {
        this.takeScreenshot(name, 100);
    }

    public void takeScreenshot(String name, int quality) {
        this.screenshotTaker.takeScreenshot(name, quality);
    }

    public void startScreenshotSequence(String name) {
        this.startScreenshotSequence(name, 80, 400, 100);
    }

    public void startScreenshotSequence(String name, int quality, int frameDelay, int maxFrames) {
        this.screenshotTaker.startScreenshotSequence(name, quality, frameDelay, maxFrames);
    }

    public void stopScreenshotSequence() {
        this.screenshotTaker.stopScreenshotSequence();
    }

    private static int initializeTimeout(String property, int defaultValue) {
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            Method method = clazz.getDeclaredMethod("get", String.class);
            String value = (String)method.invoke(null, property);
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    static {
        Timeout.setLargeTimeout(Solo.initializeTimeout("solo_large_timeout", 20000));
        Timeout.setSmallTimeout(Solo.initializeTimeout("solo_small_timeout", 10000));
    }
}

