/* composite.c generated by valac 0.56.17, the Vala compiler
 * generated from composite.vala, do not modify */

/* libenchant: Composite dictionaries
 * Copyright (C) 2024 Reuben Thomas <rrt@sc3d.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along along with this program; if not, see
 * <https://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders
 * give permission to link the code of this program with
 * non-LGPL Spelling Provider libraries (eg: a MSFT Office
 * spell checker backend) and distribute linked combinations including
 * the two.  You must obey the GNU Lesser General Public License in all
 * respects for all of the code used other than said providers.  If you modify
 * this file, you may extend this exception to your version of the
 * file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ENCHANT_DICT (enchant_dict_get_type ())
#define ENCHANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_DICT, EnchantDict))
#define ENCHANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_DICT, EnchantDictClass))
#define IS_ENCHANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_DICT))
#define IS_ENCHANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_DICT))
#define ENCHANT_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_DICT, EnchantDictClass))

typedef struct _EnchantDict EnchantDict;
typedef struct _EnchantDictClass EnchantDictClass;
typedef struct _EnchantDictPrivate EnchantDictPrivate;

#define TYPE_ENCHANT_SESSION (enchant_session_get_type ())
#define ENCHANT_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_SESSION, EnchantSession))
#define ENCHANT_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_SESSION, EnchantSessionClass))
#define IS_ENCHANT_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_SESSION))
#define IS_ENCHANT_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_SESSION))
#define ENCHANT_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_SESSION, EnchantSessionClass))

typedef struct _EnchantSession EnchantSession;
typedef struct _EnchantSessionClass EnchantSessionClass;
typedef gint (*DictCheck) (EnchantDict* me, const gchar* word, size_t len);
typedef gchar** (*DictSuggest) (EnchantDict* me, const gchar* word, size_t len, size_t* result_length1);
typedef void (*DictAddToSession) (EnchantDict* me, const gchar* word, size_t len);
typedef void (*DictRemoveFromSession) (EnchantDict* me, const gchar* word, size_t len);
typedef const gchar* (*DictGetExtraWordCharacters) (EnchantDict* me);
typedef gint (*DictIsWordCharacter) (EnchantDict* me, guint32 uc_in, size_t n);

#define TYPE_ENCHANT_COMPOSITE_DICT (enchant_composite_dict_get_type ())
#define ENCHANT_COMPOSITE_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_COMPOSITE_DICT, EnchantCompositeDict))
#define ENCHANT_COMPOSITE_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_COMPOSITE_DICT, EnchantCompositeDictClass))
#define IS_ENCHANT_COMPOSITE_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_COMPOSITE_DICT))
#define IS_ENCHANT_COMPOSITE_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_COMPOSITE_DICT))
#define ENCHANT_COMPOSITE_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_COMPOSITE_DICT, EnchantCompositeDictClass))

typedef struct _EnchantCompositeDict EnchantCompositeDict;
typedef struct _EnchantCompositeDictClass EnchantCompositeDictClass;
typedef struct _EnchantCompositeDictPrivate EnchantCompositeDictPrivate;
typedef struct _EnchantBroker EnchantBroker;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _enchant_dict_unref0(var) ((var == NULL) ? NULL : (var = (enchant_dict_unref (var), NULL)))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _EnchantDict {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantDictPrivate * priv;
	void* user_data;
	EnchantSession* session;
	DictCheck check_method;
	DictSuggest suggest_method;
	DictAddToSession add_to_session_method;
	DictRemoveFromSession remove_from_session_method;
	DictGetExtraWordCharacters get_extra_word_characters_method;
	DictIsWordCharacter is_word_character_method;
};

struct _EnchantDictClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantDict *self);
};

struct _EnchantCompositeDict {
	EnchantDict parent_instance;
	EnchantCompositeDictPrivate * priv;
	GSList* dict_list;
};

struct _EnchantCompositeDictClass {
	EnchantDictClass parent_class;
};

struct _EnchantCompositeDictPrivate {
	EnchantBroker* broker;
};

static gint EnchantCompositeDict_private_offset;
static gpointer enchant_composite_dict_parent_class = NULL;

VALA_EXTERN gpointer enchant_dict_ref (gpointer instance);
VALA_EXTERN void enchant_dict_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_dict (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void value_set_enchant_dict (GValue* value,
                             gpointer v_object);
VALA_EXTERN void value_take_enchant_dict (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_dict (const GValue* value);
VALA_EXTERN GType enchant_dict_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantDict, enchant_dict_unref)
VALA_EXTERN gpointer enchant_session_ref (gpointer instance);
VALA_EXTERN void enchant_session_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_session (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_enchant_session (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_enchant_session (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_session (const GValue* value);
VALA_EXTERN GType enchant_session_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantSession, enchant_session_unref)
VALA_EXTERN GType enchant_composite_dict_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantCompositeDict, enchant_dict_unref)
VALA_EXTERN void enchant_broker_free (EnchantBroker * self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantBroker, enchant_broker_free)
VALA_EXTERN EnchantCompositeDict* enchant_composite_dict_new (EnchantBroker* broker,
                                                  GSList* dict_list);
VALA_EXTERN EnchantCompositeDict* enchant_composite_dict_construct (GType object_type,
                                                        EnchantBroker* broker,
                                                        GSList* dict_list);
VALA_EXTERN EnchantDict* enchant_dict_new (void);
VALA_EXTERN EnchantDict* enchant_dict_construct (GType object_type);
VALA_EXTERN gint composite_dict_check (EnchantDict* _self_,
                           const gchar* word_buf,
                           size_t len);
static gint _composite_dict_check_dict_check (EnchantDict* me,
                                       const gchar* word,
                                       size_t len);
VALA_EXTERN gchar** composite_dict_suggest (EnchantDict* me,
                                const gchar* word,
                                size_t len,
                                size_t* result_length1);
static gchar** _composite_dict_suggest_dict_suggest (EnchantDict* me,
                                              const gchar* word,
                                              size_t len,
                                              size_t* result_length1);
VALA_EXTERN void composite_dict_add_to_session (EnchantDict* me,
                                    const gchar* word,
                                    size_t len);
static void _composite_dict_add_to_session_dict_add_to_session (EnchantDict* me,
                                                         const gchar* word,
                                                         size_t len);
VALA_EXTERN void composite_dict_remove_from_session (EnchantDict* me,
                                         const gchar* word,
                                         size_t len);
static void _composite_dict_remove_from_session_dict_remove_from_session (EnchantDict* me,
                                                                   const gchar* word,
                                                                   size_t len);
static void enchant_composite_dict_finalize (EnchantDict * obj);
static GType enchant_composite_dict_get_type_once (void);
VALA_EXTERN gchar* buf_to_utf8_string (const gchar* str_buf,
                           gssize len);
VALA_EXTERN gint enchant_dict_check (EnchantDict* _self_,
                         const gchar* word_buf,
                         ssize_t len);
static void _g_free0_ (gpointer var);
static void _vala_gchar_free_function_content_of (gpointer data);
VALA_EXTERN gchar** enchant_dict_suggest (EnchantDict* self,
                              const gchar* word_buf,
                              ssize_t len,
                              size_t* result_length1);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
VALA_EXTERN void enchant_dict_add_to_session (EnchantDict* self,
                                  const gchar* word_buf,
                                  ssize_t len);
VALA_EXTERN void enchant_dict_remove_from_session (EnchantDict* self,
                                       const gchar* word_buf,
                                       ssize_t len);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
enchant_composite_dict_get_instance_private (EnchantCompositeDict* self)
{
	return G_STRUCT_MEMBER_P (self, EnchantCompositeDict_private_offset);
}

static gint
_composite_dict_check_dict_check (EnchantDict* me,
                                  const gchar* word,
                                  size_t len)
{
	gint result;
	result = composite_dict_check (me, word, len);
#line 36 "composite.vala"
	return result;
#line 247 "composite.c"
}

static gchar**
_composite_dict_suggest_dict_suggest (EnchantDict* me,
                                      const gchar* word,
                                      size_t len,
                                      size_t* result_length1)
{
	gchar** result;
	result = composite_dict_suggest (me, word, len, result_length1);
#line 37 "composite.vala"
	return result;
#line 260 "composite.c"
}

static void
_composite_dict_add_to_session_dict_add_to_session (EnchantDict* me,
                                                    const gchar* word,
                                                    size_t len)
{
#line 38 "composite.vala"
	composite_dict_add_to_session (me, word, len);
#line 270 "composite.c"
}

static void
_composite_dict_remove_from_session_dict_remove_from_session (EnchantDict* me,
                                                              const gchar* word,
                                                              size_t len)
{
#line 39 "composite.vala"
	composite_dict_remove_from_session (me, word, len);
#line 280 "composite.c"
}

EnchantCompositeDict*
enchant_composite_dict_construct (GType object_type,
                                  EnchantBroker* broker,
                                  GSList* dict_list)
{
	EnchantCompositeDict* self = NULL;
	GSList* _tmp0_;
#line 33 "composite.vala"
	g_return_val_if_fail (broker != NULL, NULL);
#line 33 "composite.vala"
	self = (EnchantCompositeDict*) enchant_dict_construct (object_type);
#line 34 "composite.vala"
	self->priv->broker = broker;
#line 35 "composite.vala"
	_tmp0_ = dict_list;
#line 35 "composite.vala"
	dict_list = NULL;
#line 35 "composite.vala"
	(self->dict_list == NULL) ? NULL : (self->dict_list = (g_slist_free (self->dict_list), NULL));
#line 35 "composite.vala"
	self->dict_list = _tmp0_;
#line 36 "composite.vala"
	((EnchantDict*) self)->check_method = _composite_dict_check_dict_check;
#line 37 "composite.vala"
	((EnchantDict*) self)->suggest_method = _composite_dict_suggest_dict_suggest;
#line 38 "composite.vala"
	((EnchantDict*) self)->add_to_session_method = _composite_dict_add_to_session_dict_add_to_session;
#line 39 "composite.vala"
	((EnchantDict*) self)->remove_from_session_method = _composite_dict_remove_from_session_dict_remove_from_session;
#line 33 "composite.vala"
	(dict_list == NULL) ? NULL : (dict_list = (g_slist_free (dict_list), NULL));
#line 33 "composite.vala"
	return self;
#line 316 "composite.c"
}

EnchantCompositeDict*
enchant_composite_dict_new (EnchantBroker* broker,
                            GSList* dict_list)
{
#line 33 "composite.vala"
	return enchant_composite_dict_construct (TYPE_ENCHANT_COMPOSITE_DICT, broker, dict_list);
#line 325 "composite.c"
}

static void
enchant_composite_dict_class_init (EnchantCompositeDictClass * klass,
                                   gpointer klass_data)
{
#line 29 "composite.vala"
	enchant_composite_dict_parent_class = g_type_class_peek_parent (klass);
#line 29 "composite.vala"
	((EnchantDictClass *) klass)->finalize = enchant_composite_dict_finalize;
#line 29 "composite.vala"
	g_type_class_adjust_private_offset (klass, &EnchantCompositeDict_private_offset);
#line 338 "composite.c"
}

static void
enchant_composite_dict_instance_init (EnchantCompositeDict * self,
                                      gpointer klass)
{
#line 29 "composite.vala"
	self->priv = enchant_composite_dict_get_instance_private (self);
#line 347 "composite.c"
}

static void
enchant_composite_dict_finalize (EnchantDict * obj)
{
	EnchantCompositeDict * self;
#line 29 "composite.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ENCHANT_COMPOSITE_DICT, EnchantCompositeDict);
#line 31 "composite.vala"
	(self->dict_list == NULL) ? NULL : (self->dict_list = (g_slist_free (self->dict_list), NULL));
#line 29 "composite.vala"
	ENCHANT_DICT_CLASS (enchant_composite_dict_parent_class)->finalize (obj);
#line 360 "composite.c"
}

static GType
enchant_composite_dict_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EnchantCompositeDictClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enchant_composite_dict_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EnchantCompositeDict), 0, (GInstanceInitFunc) enchant_composite_dict_instance_init, NULL };
	GType enchant_composite_dict_type_id;
	enchant_composite_dict_type_id = g_type_register_static (TYPE_ENCHANT_DICT, "EnchantCompositeDict", &g_define_type_info, 0);
	EnchantCompositeDict_private_offset = g_type_add_instance_private (enchant_composite_dict_type_id, sizeof (EnchantCompositeDictPrivate));
	return enchant_composite_dict_type_id;
}

GType
enchant_composite_dict_get_type (void)
{
	static volatile gsize enchant_composite_dict_type_id__once = 0;
	if (g_once_init_enter (&enchant_composite_dict_type_id__once)) {
		GType enchant_composite_dict_type_id;
		enchant_composite_dict_type_id = enchant_composite_dict_get_type_once ();
		g_once_init_leave (&enchant_composite_dict_type_id__once, enchant_composite_dict_type_id);
	}
	return enchant_composite_dict_type_id__once;
}

static gpointer
_enchant_dict_ref0 (gpointer self)
{
#line 52 "composite.vala"
	return self ? enchant_dict_ref (self) : NULL;
#line 390 "composite.c"
}

gint
composite_dict_check (EnchantDict* _self_,
                      const gchar* word_buf,
                      size_t len)
{
	gboolean _tmp0_ = FALSE;
	gchar* word = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	EnchantCompositeDict* cdict = NULL;
	EnchantCompositeDict* _tmp3_;
	gint err = 0;
	EnchantCompositeDict* _tmp4_;
	GSList* _tmp5_;
	gint result;
#line 43 "composite.vala"
	g_return_val_if_fail (word_buf != NULL, 0);
#line 44 "composite.vala"
	if (_self_ == NULL) {
#line 44 "composite.vala"
		_tmp0_ = TRUE;
#line 414 "composite.c"
	} else {
#line 44 "composite.vala"
		_tmp0_ = word_buf == NULL;
#line 418 "composite.c"
	}
#line 44 "composite.vala"
	if (_tmp0_) {
#line 45 "composite.vala"
		result = -1;
#line 45 "composite.vala"
		return result;
#line 426 "composite.c"
	}
#line 46 "composite.vala"
	_tmp1_ = buf_to_utf8_string (word_buf, (gssize) ((ssize_t) len));
#line 46 "composite.vala"
	word = _tmp1_;
#line 47 "composite.vala"
	_tmp2_ = word;
#line 47 "composite.vala"
	if (_tmp2_ == NULL) {
#line 48 "composite.vala"
		result = -1;
#line 48 "composite.vala"
		_g_free0 (word);
#line 48 "composite.vala"
		return result;
#line 442 "composite.c"
	}
#line 52 "composite.vala"
	_tmp3_ = _enchant_dict_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_self_, TYPE_ENCHANT_COMPOSITE_DICT, EnchantCompositeDict));
#line 52 "composite.vala"
	cdict = _tmp3_;
#line 53 "composite.vala"
	err = -1;
#line 54 "composite.vala"
	_tmp4_ = cdict;
#line 54 "composite.vala"
	_tmp5_ = _tmp4_->dict_list;
#line 454 "composite.c"
	{
		GSList* dict_collection = NULL;
		GSList* dict_it = NULL;
#line 54 "composite.vala"
		dict_collection = _tmp5_;
#line 54 "composite.vala"
		for (dict_it = dict_collection; dict_it != NULL; dict_it = dict_it->next) {
#line 462 "composite.c"
			EnchantDict* _tmp6_;
			EnchantDict* dict = NULL;
#line 54 "composite.vala"
			_tmp6_ = _enchant_dict_ref0 ((EnchantDict*) dict_it->data);
#line 54 "composite.vala"
			dict = _tmp6_;
#line 469 "composite.c"
			{
				gint found = 0;
				EnchantDict* _tmp7_;
				const gchar* _tmp8_;
#line 55 "composite.vala"
				_tmp7_ = dict;
#line 55 "composite.vala"
				_tmp8_ = word;
#line 55 "composite.vala"
				found = enchant_dict_check (_tmp7_, _tmp8_, (ssize_t) len);
#line 56 "composite.vala"
				if (found == 0) {
#line 57 "composite.vala"
					result = 0;
#line 57 "composite.vala"
					_enchant_dict_unref0 (dict);
#line 57 "composite.vala"
					_enchant_dict_unref0 (cdict);
#line 57 "composite.vala"
					_g_free0 (word);
#line 57 "composite.vala"
					return result;
#line 492 "composite.c"
				}
#line 58 "composite.vala"
				if (found == 1) {
#line 59 "composite.vala"
					err = 1;
#line 498 "composite.c"
				}
#line 54 "composite.vala"
				_enchant_dict_unref0 (dict);
#line 502 "composite.c"
			}
		}
	}
#line 61 "composite.vala"
	result = err;
#line 61 "composite.vala"
	_enchant_dict_unref0 (cdict);
#line 61 "composite.vala"
	_g_free0 (word);
#line 61 "composite.vala"
	return result;
#line 514 "composite.c"
}

static void
_g_free0_ (gpointer var)
{
#line 68 "composite.vala"
	var = (g_free (var), NULL);
#line 522 "composite.c"
}

static void
_vala_gchar_free_function_content_of (gpointer data)
{
	gchar* self;
#line 68 "composite.vala"
	self = *((gchar**) data);
#line 68 "composite.vala"
	_g_free0_ (self);
#line 533 "composite.c"
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
#line 80 "composite.vala"
	if (length >= 0) {
#line 542 "composite.c"
		gchar** result;
		gssize i;
#line 80 "composite.vala"
		result = g_new0 (gchar*, length + 1);
#line 80 "composite.vala"
		for (i = 0; i < length; i++) {
#line 549 "composite.c"
			gchar* _tmp0_;
#line 80 "composite.vala"
			_tmp0_ = g_strdup (self[i]);
#line 80 "composite.vala"
			result[i] = _tmp0_;
#line 555 "composite.c"
		}
#line 80 "composite.vala"
		return result;
#line 559 "composite.c"
	}
#line 80 "composite.vala"
	return NULL;
#line 563 "composite.c"
}

gchar**
composite_dict_suggest (EnchantDict* me,
                        const gchar* word,
                        size_t len,
                        size_t* result_length1)
{
	EnchantCompositeDict* cdict = NULL;
	EnchantCompositeDict* _tmp0_;
	gboolean _error_ = FALSE;
	GArray* res = NULL;
	GArray* _tmp1_;
	EnchantCompositeDict* _tmp2_;
	GSList* _tmp3_;
	GArray* _tmp18_;
	gpointer* _tmp19_;
	gint _tmp19__length1;
	gchar** _tmp20_;
	gint _tmp20__length1;
	gchar** _tmp21_;
	gint _tmp21__length1;
	gchar** result;
#line 65 "composite.vala"
	g_return_val_if_fail (me != NULL, NULL);
#line 65 "composite.vala"
	g_return_val_if_fail (word != NULL, NULL);
#line 66 "composite.vala"
	_tmp0_ = _enchant_dict_ref0 (G_TYPE_CHECK_INSTANCE_CAST (me, TYPE_ENCHANT_COMPOSITE_DICT, EnchantCompositeDict));
#line 66 "composite.vala"
	cdict = _tmp0_;
#line 67 "composite.vala"
	_error_ = TRUE;
#line 68 "composite.vala"
	_tmp1_ = g_array_new (TRUE, TRUE, sizeof (gchar*));
#line 68 "composite.vala"
	g_array_set_clear_func (_tmp1_, (GDestroyNotify) _vala_gchar_free_function_content_of);
#line 68 "composite.vala"
	res = _tmp1_;
#line 69 "composite.vala"
	_tmp2_ = cdict;
#line 69 "composite.vala"
	_tmp3_ = _tmp2_->dict_list;
#line 607 "composite.c"
	{
		GSList* dict_collection = NULL;
		GSList* dict_it = NULL;
#line 69 "composite.vala"
		dict_collection = _tmp3_;
#line 69 "composite.vala"
		for (dict_it = dict_collection; dict_it != NULL; dict_it = dict_it->next) {
#line 615 "composite.c"
			EnchantDict* _tmp4_;
			EnchantDict* dict = NULL;
#line 69 "composite.vala"
			_tmp4_ = _enchant_dict_ref0 ((EnchantDict*) dict_it->data);
#line 69 "composite.vala"
			dict = _tmp4_;
#line 622 "composite.c"
			{
				gchar** suggs = NULL;
				EnchantDict* _tmp5_;
				size_t _tmp6_ = 0;
				gchar** _tmp7_;
				gint suggs_length1;
				gint _suggs_size_;
				gchar** _tmp8_;
				gint _tmp8__length1;
#line 70 "composite.vala"
				_tmp5_ = dict;
#line 70 "composite.vala"
				_tmp7_ = enchant_dict_suggest (_tmp5_, word, (ssize_t) len, &_tmp6_);
#line 70 "composite.vala"
				suggs = _tmp7_;
#line 70 "composite.vala"
				suggs_length1 = _tmp6_;
#line 70 "composite.vala"
				_suggs_size_ = suggs_length1;
#line 71 "composite.vala"
				_tmp8_ = suggs;
#line 71 "composite.vala"
				_tmp8__length1 = suggs_length1;
#line 71 "composite.vala"
				if (_tmp8_ != NULL) {
#line 648 "composite.c"
					gchar** _tmp9_;
					gint _tmp9__length1;
#line 72 "composite.vala"
					_error_ = FALSE;
#line 73 "composite.vala"
					_tmp9_ = suggs;
#line 73 "composite.vala"
					_tmp9__length1 = suggs_length1;
#line 73 "composite.vala"
					if (_tmp9__length1 > 0) {
#line 659 "composite.c"
						{
							size_t i = 0UL;
#line 74 "composite.vala"
							i = (size_t) 0;
#line 664 "composite.c"
							{
								gboolean _tmp10_ = FALSE;
#line 74 "composite.vala"
								_tmp10_ = TRUE;
#line 74 "composite.vala"
								while (TRUE) {
#line 671 "composite.c"
									gchar** _tmp12_;
									gint _tmp12__length1;
									GArray* _tmp13_;
									gchar** _tmp14_;
									gint _tmp14__length1;
									const gchar* _tmp15_;
									gchar* _tmp16_;
#line 74 "composite.vala"
									if (!_tmp10_) {
#line 681 "composite.c"
										size_t _tmp11_;
#line 74 "composite.vala"
										_tmp11_ = i;
#line 74 "composite.vala"
										i = _tmp11_ + 1;
#line 687 "composite.c"
									}
#line 74 "composite.vala"
									_tmp10_ = FALSE;
#line 74 "composite.vala"
									_tmp12_ = suggs;
#line 74 "composite.vala"
									_tmp12__length1 = suggs_length1;
#line 74 "composite.vala"
									if (!(i < ((size_t) _tmp12__length1))) {
#line 74 "composite.vala"
										break;
#line 699 "composite.c"
									}
#line 75 "composite.vala"
									_tmp13_ = res;
#line 75 "composite.vala"
									_tmp14_ = suggs;
#line 75 "composite.vala"
									_tmp14__length1 = suggs_length1;
#line 75 "composite.vala"
									_tmp15_ = _tmp14_[i];
#line 75 "composite.vala"
									_tmp16_ = g_strdup (_tmp15_);
#line 75 "composite.vala"
									g_array_append_val (_tmp13_, _tmp16_);
#line 713 "composite.c"
								}
							}
						}
					}
				}
#line 69 "composite.vala"
				suggs = (_vala_array_free (suggs, suggs_length1, (GDestroyNotify) g_free), NULL);
#line 69 "composite.vala"
				_enchant_dict_unref0 (dict);
#line 723 "composite.c"
			}
		}
	}
#line 78 "composite.vala"
	if (_error_ == TRUE) {
#line 729 "composite.c"
		gchar** _tmp17_;
		gint _tmp17__length1;
#line 79 "composite.vala"
		_tmp17_ = NULL;
#line 79 "composite.vala"
		_tmp17__length1 = 0;
#line 79 "composite.vala"
		if (result_length1) {
#line 79 "composite.vala"
			*result_length1 = _tmp17__length1;
#line 740 "composite.c"
		}
#line 79 "composite.vala"
		result = _tmp17_;
#line 79 "composite.vala"
		_g_array_unref0 (res);
#line 79 "composite.vala"
		_enchant_dict_unref0 (cdict);
#line 79 "composite.vala"
		return result;
#line 750 "composite.c"
	}
#line 80 "composite.vala"
	_tmp18_ = res;
#line 80 "composite.vala"
	_tmp19_ = _tmp18_->data;
#line 80 "composite.vala"
	_tmp19__length1 = _tmp18_->len;
#line 80 "composite.vala"
	_tmp20_ = (_tmp19_ != NULL) ? _vala_array_dup1 (_tmp19_, _tmp19__length1) : _tmp19_;
#line 80 "composite.vala"
	_tmp20__length1 = _tmp19__length1;
#line 80 "composite.vala"
	_tmp21_ = _tmp20_;
#line 80 "composite.vala"
	_tmp21__length1 = _tmp20__length1;
#line 80 "composite.vala"
	if (result_length1) {
#line 80 "composite.vala"
		*result_length1 = _tmp21__length1;
#line 770 "composite.c"
	}
#line 80 "composite.vala"
	result = _tmp21_;
#line 80 "composite.vala"
	_g_array_unref0 (res);
#line 80 "composite.vala"
	_enchant_dict_unref0 (cdict);
#line 80 "composite.vala"
	return result;
#line 780 "composite.c"
}

void
composite_dict_add_to_session (EnchantDict* me,
                               const gchar* word,
                               size_t len)
{
	EnchantCompositeDict* cdict = NULL;
	EnchantCompositeDict* _tmp0_;
	GSList* _tmp1_;
	GSList* _tmp2_;
	gconstpointer _tmp3_;
#line 83 "composite.vala"
	g_return_if_fail (me != NULL);
#line 83 "composite.vala"
	g_return_if_fail (word != NULL);
#line 84 "composite.vala"
	_tmp0_ = _enchant_dict_ref0 (G_TYPE_CHECK_INSTANCE_CAST (me, TYPE_ENCHANT_COMPOSITE_DICT, EnchantCompositeDict));
#line 84 "composite.vala"
	cdict = _tmp0_;
#line 85 "composite.vala"
	_tmp1_ = cdict->dict_list;
#line 85 "composite.vala"
	_vala_assert (g_slist_length (_tmp1_) > ((guint) 0), "cdict.dict_list.length() > 0");
#line 86 "composite.vala"
	_tmp2_ = cdict->dict_list;
#line 86 "composite.vala"
	_tmp3_ = _tmp2_->data;
#line 86 "composite.vala"
	enchant_dict_add_to_session ((EnchantDict*) _tmp3_, word, (ssize_t) len);
#line 83 "composite.vala"
	_enchant_dict_unref0 (cdict);
#line 813 "composite.c"
}

void
composite_dict_remove_from_session (EnchantDict* me,
                                    const gchar* word,
                                    size_t len)
{
	EnchantCompositeDict* cdict = NULL;
	EnchantCompositeDict* _tmp0_;
	GSList* _tmp1_;
	GSList* _tmp2_;
	gconstpointer _tmp3_;
#line 89 "composite.vala"
	g_return_if_fail (me != NULL);
#line 89 "composite.vala"
	g_return_if_fail (word != NULL);
#line 90 "composite.vala"
	_tmp0_ = _enchant_dict_ref0 (G_TYPE_CHECK_INSTANCE_CAST (me, TYPE_ENCHANT_COMPOSITE_DICT, EnchantCompositeDict));
#line 90 "composite.vala"
	cdict = _tmp0_;
#line 91 "composite.vala"
	_tmp1_ = cdict->dict_list;
#line 91 "composite.vala"
	_vala_assert (g_slist_length (_tmp1_) > ((guint) 0), "cdict.dict_list.length() > 0");
#line 92 "composite.vala"
	_tmp2_ = cdict->dict_list;
#line 92 "composite.vala"
	_tmp3_ = _tmp2_->data;
#line 92 "composite.vala"
	enchant_dict_remove_from_session ((EnchantDict*) _tmp3_, word, (ssize_t) len);
#line 89 "composite.vala"
	_enchant_dict_unref0 (cdict);
#line 846 "composite.c"
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

