/* dict.c generated by valac 0.56.17, the Vala compiler
 * generated from dict.vala, do not modify */

/* enchant: Dict
 * Copyright (C) 2003, 2004 Dom Lachowicz
 * Copyright (C) 2016-2024 Reuben Thomas <rrt@sc3d.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along along with this program; if not, see
 * <https://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders
 * give permission to link the code of this program with
 * non-LGPL Spelling Provider libraries (eg: a MSFT Office
 * spell checker backend) and distribute linked combinations including
 * the two.  You must obey the GNU Lesser General Public License in all
 * respects for all of the code used other than said providers.  If you modify
 * this file, you may extend this exception to your version of the
 * file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <gmodule.h>
#include <enchant.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ENCHANT_DICT (enchant_dict_get_type ())
#define ENCHANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_DICT, EnchantDict))
#define ENCHANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_DICT, EnchantDictClass))
#define IS_ENCHANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_DICT))
#define IS_ENCHANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_DICT))
#define ENCHANT_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_DICT, EnchantDictClass))

typedef struct _EnchantDict EnchantDict;
typedef struct _EnchantDictClass EnchantDictClass;
typedef gint (*DictCheck) (EnchantDict* me, const gchar* word, size_t len);
typedef gchar** (*DictSuggest) (EnchantDict* me, const gchar* word, size_t len, size_t* result_length1);
typedef void (*DictAddToSession) (EnchantDict* me, const gchar* word, size_t len);
typedef void (*DictRemoveFromSession) (EnchantDict* me, const gchar* word, size_t len);
typedef const gchar* (*DictGetExtraWordCharacters) (EnchantDict* me);
typedef gint (*DictIsWordCharacter) (EnchantDict* me, guint32 uc_in, size_t n);
typedef struct _EnchantDictPrivate EnchantDictPrivate;

#define TYPE_ENCHANT_SESSION (enchant_session_get_type ())
#define ENCHANT_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_SESSION, EnchantSession))
#define ENCHANT_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_SESSION, EnchantSessionClass))
#define IS_ENCHANT_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_SESSION))
#define IS_ENCHANT_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_SESSION))
#define ENCHANT_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_SESSION, EnchantSessionClass))

typedef struct _EnchantSession EnchantSession;
typedef struct _EnchantSessionClass EnchantSessionClass;

#define TYPE_ENCHANT_PROVIDER (enchant_provider_get_type ())
#define ENCHANT_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_PROVIDER, EnchantProvider))
#define ENCHANT_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_PROVIDER, EnchantProviderClass))
#define IS_ENCHANT_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_PROVIDER))
#define IS_ENCHANT_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_PROVIDER))
#define ENCHANT_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_PROVIDER, EnchantProviderClass))

typedef struct _EnchantProvider EnchantProvider;
typedef struct _EnchantProviderClass EnchantProviderClass;
typedef struct _EnchantSessionPrivate EnchantSessionPrivate;

#define TYPE_ENCHANT_PWL (enchant_pwl_get_type ())
#define ENCHANT_PWL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_PWL, EnchantPWL))
#define ENCHANT_PWL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_PWL, EnchantPWLClass))
#define IS_ENCHANT_PWL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_PWL))
#define IS_ENCHANT_PWL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_PWL))
#define ENCHANT_PWL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_PWL, EnchantPWLClass))

typedef struct _EnchantPWL EnchantPWL;
typedef struct _EnchantPWLClass EnchantPWLClass;
typedef struct _EnchantProviderPrivate EnchantProviderPrivate;
typedef struct _EnchantBroker EnchantBroker;
typedef void (*ProviderDispose) (EnchantProvider* me);
typedef EnchantDict* (*ProviderRequestDict) (EnchantProvider* me, const gchar* tag);
typedef void (*ProviderDisposeDict) (EnchantProvider* me, EnchantDict* dict);
typedef gint (*ProviderDictionaryExists) (EnchantProvider* me, const gchar* tag);
typedef const gchar* (*ProviderIdentify) (EnchantProvider* me);
typedef const gchar* (*ProviderDescribe) (EnchantProvider* me);
typedef gchar** (*ProviderListDicts) (EnchantProvider* me, size_t* result_length1);
#define _enchant_session_unref0(var) ((var == NULL) ? NULL : (var = (enchant_session_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_strv_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_strv_builder_unref (var), NULL)))
typedef struct _ParamSpecEnchantDict ParamSpecEnchantDict;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _EnchantDict {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantDictPrivate * priv;
	void* user_data;
	EnchantSession* session;
	DictCheck check_method;
	DictSuggest suggest_method;
	DictAddToSession add_to_session_method;
	DictRemoveFromSession remove_from_session_method;
	DictGetExtraWordCharacters get_extra_word_characters_method;
	DictIsWordCharacter is_word_character_method;
};

struct _EnchantDictClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantDict *self);
};

struct _EnchantSession {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantSessionPrivate * priv;
	GHashTable* session_include;
	GHashTable* session_exclude;
	EnchantPWL* pwl;
	EnchantPWL* exclude_pwl;
	gchar* personal_filename;
	gchar* exclude_filename;
	gchar* language_tag;
	gchar* error;
	EnchantProvider* provider;
};

struct _EnchantSessionClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantSession *self);
};

struct _EnchantProvider {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantProviderPrivate * priv;
	void* user_data;
	GModule* module;
	EnchantBroker* owner;
	ProviderDispose dispose;
	ProviderRequestDict request_dict;
	ProviderDisposeDict dispose_dict;
	ProviderDictionaryExists dictionary_exists;
	ProviderIdentify identify;
	ProviderDescribe describe;
	ProviderListDicts list_dicts;
};

struct _EnchantProviderClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantProvider *self);
};

struct _ParamSpecEnchantDict {
	GParamSpec parent_instance;
};

static gpointer enchant_dict_parent_class = NULL;

VALA_EXTERN gpointer enchant_dict_ref (gpointer instance);
VALA_EXTERN void enchant_dict_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_dict (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void value_set_enchant_dict (GValue* value,
                             gpointer v_object);
VALA_EXTERN void value_take_enchant_dict (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_dict (const GValue* value);
VALA_EXTERN GType enchant_dict_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantDict, enchant_dict_unref)
VALA_EXTERN gpointer enchant_session_ref (gpointer instance);
VALA_EXTERN void enchant_session_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_session (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_enchant_session (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_enchant_session (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_session (const GValue* value);
VALA_EXTERN GType enchant_session_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantSession, enchant_session_unref)
VALA_EXTERN gpointer enchant_provider_ref (gpointer instance);
VALA_EXTERN void enchant_provider_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_provider (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void value_set_enchant_provider (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void value_take_enchant_provider (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_provider (const GValue* value);
VALA_EXTERN GType enchant_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantProvider, enchant_provider_unref)
VALA_EXTERN gpointer enchant_pwl_ref (gpointer instance);
VALA_EXTERN void enchant_pwl_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_pwl (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_enchant_pwl (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_enchant_pwl (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_pwl (const GValue* value);
VALA_EXTERN GType enchant_pwl_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantPWL, enchant_pwl_unref)
VALA_EXTERN void enchant_broker_free (EnchantBroker * self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantBroker, enchant_broker_free)
VALA_EXTERN const gchar* enchant_dict_get_extra_word_characters (EnchantDict* self);
VALA_EXTERN gint enchant_dict_is_word_character (EnchantDict* _self_,
                                     guint32 uc_in,
                                     size_t n);
VALA_EXTERN void enchant_dict_set_error (EnchantDict* self,
                             const gchar* err);
VALA_EXTERN void enchant_session_clear_error (EnchantSession* self);
VALA_EXTERN const gchar* enchant_dict_get_error (EnchantDict* self);
VALA_EXTERN gint enchant_dict_check (EnchantDict* _self_,
                         const gchar* word_buf,
                         ssize_t len);
VALA_EXTERN gchar* buf_to_utf8_string (const gchar* str_buf,
                           gssize len);
VALA_EXTERN gboolean enchant_session_exclude (EnchantSession* self,
                                  const gchar* word);
VALA_EXTERN gboolean enchant_session_contains (EnchantSession* self,
                                   const gchar* word);
static gchar** enchant_dict_filter_suggestions (EnchantDict* self,
                                         gchar** suggs,
                                         gint suggs_length1,
                                         gint* result_length1);
VALA_EXTERN gchar** enchant_dict_suggest (EnchantDict* self,
                              const gchar* word_buf,
                              ssize_t len,
                              size_t* result_length1);
VALA_EXTERN void enchant_dict_add (EnchantDict* self,
                       const gchar* word_buf,
                       ssize_t len);
VALA_EXTERN void enchant_dict_add_to_session (EnchantDict* self,
                                  const gchar* word_buf,
                                  ssize_t len);
VALA_EXTERN void enchant_pwl_add (EnchantPWL* self,
                      const gchar* word_buf,
                      ssize_t len);
VALA_EXTERN void enchant_pwl_remove (EnchantPWL* self,
                         const gchar* word_buf,
                         ssize_t len);
VALA_EXTERN void enchant_session_add (EnchantSession* self,
                          const gchar* word);
VALA_EXTERN gint enchant_dict_is_added (EnchantDict* self,
                            const gchar* word_buf,
                            ssize_t len);
VALA_EXTERN void enchant_dict_remove (EnchantDict* self,
                          const gchar* word_buf,
                          ssize_t len);
VALA_EXTERN void enchant_dict_remove_from_session (EnchantDict* self,
                                       const gchar* word_buf,
                                       ssize_t len);
VALA_EXTERN void enchant_session_remove (EnchantSession* self,
                             const gchar* word);
VALA_EXTERN gint enchant_dict_is_removed (EnchantDict* self,
                              const gchar* word_buf,
                              ssize_t len);
VALA_EXTERN void enchant_dict_store_replacement (EnchantDict* self,
                                     const gchar* mis,
                                     ssize_t mis_len,
                                     const gchar* cor,
                                     ssize_t cor_len);
VALA_EXTERN void enchant_dict_free_string_list (EnchantDict* self,
                                    gchar** string_list);
VALA_EXTERN void enchant_dict_describe (EnchantDict* self,
                            EnchantDictDescribeFn fn,
                            void* user_data);
VALA_EXTERN EnchantDict* enchant_dict_new (void);
VALA_EXTERN EnchantDict* enchant_dict_construct (GType object_type);
static void enchant_dict_finalize (EnchantDict * obj);
static GType enchant_dict_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

const gchar*
enchant_dict_get_extra_word_characters (EnchantDict* self)
{
	const gchar* _tmp0_ = NULL;
	DictGetExtraWordCharacters _tmp1_;
	const gchar* result;
#line 62 "dict.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 63 "dict.vala"
	_tmp1_ = self->get_extra_word_characters_method;
#line 63 "dict.vala"
	if (_tmp1_ != NULL) {
#line 337 "dict.c"
		DictGetExtraWordCharacters _tmp2_;
		const gchar* _tmp3_;
#line 64 "dict.vala"
		_tmp2_ = self->get_extra_word_characters_method;
#line 64 "dict.vala"
		_tmp3_ = _tmp2_ (self);
#line 64 "dict.vala"
		_tmp0_ = _tmp3_;
#line 346 "dict.c"
	} else {
#line 64 "dict.vala"
		_tmp0_ = "";
#line 350 "dict.c"
	}
#line 63 "dict.vala"
	result = _tmp0_;
#line 63 "dict.vala"
	return result;
#line 356 "dict.c"
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
#line 1313 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0U);
#line 1314 "glib-2.0.vapi"
	result = g_utf8_get_char (((gchar*) self) + index);
#line 1314 "glib-2.0.vapi"
	return result;
#line 370 "dict.c"
}

gint
enchant_dict_is_word_character (EnchantDict* _self_,
                                guint32 uc_in,
                                size_t n)
{
	gboolean _tmp0_ = FALSE;
	gunichar uc = 0U;
	gboolean _tmp3_ = FALSE;
	GUnicodeType type = 0;
	gint result;
#line 67 "dict.vala"
	_vala_return_val_if_fail (n <= ((size_t) 2), "n <= 2", 0);
#line 70 "dict.vala"
	if (_self_ != NULL) {
#line 387 "dict.c"
		DictIsWordCharacter _tmp1_;
#line 70 "dict.vala"
		_tmp1_ = _self_->is_word_character_method;
#line 70 "dict.vala"
		_tmp0_ = _tmp1_ != NULL;
#line 393 "dict.c"
	} else {
#line 70 "dict.vala"
		_tmp0_ = FALSE;
#line 397 "dict.c"
	}
#line 70 "dict.vala"
	if (_tmp0_) {
#line 401 "dict.c"
		DictIsWordCharacter _tmp2_;
#line 71 "dict.vala"
		_tmp2_ = _self_->is_word_character_method;
#line 71 "dict.vala"
		result = _tmp2_ (_self_, uc_in, n);
#line 71 "dict.vala"
		return result;
#line 409 "dict.c"
	}
#line 73 "dict.vala"
	uc = (gunichar) uc_in;
#line 76 "dict.vala"
	if (uc == string_get_char ("'", (glong) 0)) {
#line 76 "dict.vala"
		_tmp3_ = TRUE;
#line 417 "dict.c"
	} else {
#line 76 "dict.vala"
		_tmp3_ = uc == string_get_char ("’", (glong) 0);
#line 421 "dict.c"
	}
#line 76 "dict.vala"
	if (_tmp3_) {
#line 425 "dict.c"
		gint _tmp4_ = 0;
#line 77 "dict.vala"
		if (n < ((size_t) 2)) {
#line 77 "dict.vala"
			_tmp4_ = 1;
#line 431 "dict.c"
		} else {
#line 77 "dict.vala"
			_tmp4_ = 0;
#line 435 "dict.c"
		}
#line 77 "dict.vala"
		result = _tmp4_;
#line 77 "dict.vala"
		return result;
#line 441 "dict.c"
	}
#line 79 "dict.vala"
	type = g_unichar_type (uc);
#line 81 "dict.vala"
	switch (type) {
#line 81 "dict.vala"
		case G_UNICODE_MODIFIER_LETTER:
#line 81 "dict.vala"
		case G_UNICODE_LOWERCASE_LETTER:
#line 81 "dict.vala"
		case G_UNICODE_TITLECASE_LETTER:
#line 81 "dict.vala"
		case G_UNICODE_UPPERCASE_LETTER:
#line 81 "dict.vala"
		case G_UNICODE_OTHER_LETTER:
#line 81 "dict.vala"
		case G_UNICODE_SPACING_MARK:
#line 81 "dict.vala"
		case G_UNICODE_ENCLOSING_MARK:
#line 81 "dict.vala"
		case G_UNICODE_NON_SPACING_MARK:
#line 81 "dict.vala"
		case G_UNICODE_DECIMAL_NUMBER:
#line 81 "dict.vala"
		case G_UNICODE_LETTER_NUMBER:
#line 81 "dict.vala"
		case G_UNICODE_OTHER_NUMBER:
#line 81 "dict.vala"
		case G_UNICODE_CONNECT_PUNCTUATION:
#line 471 "dict.c"
		{
#line 94 "dict.vala"
			result = 1;
#line 94 "dict.vala"
			return result;
#line 477 "dict.c"
		}
#line 81 "dict.vala"
		case G_UNICODE_DASH_PUNCTUATION:
#line 481 "dict.c"
		{
			gboolean _tmp5_ = FALSE;
#line 97 "dict.vala"
			if (n == ((size_t) 1)) {
#line 97 "dict.vala"
				_tmp5_ = type == G_UNICODE_DASH_PUNCTUATION;
#line 488 "dict.c"
			} else {
#line 97 "dict.vala"
				_tmp5_ = FALSE;
#line 492 "dict.c"
			}
#line 97 "dict.vala"
			if (_tmp5_) {
#line 98 "dict.vala"
				result = 1;
#line 98 "dict.vala"
				return result;
#line 500 "dict.c"
			}
#line 99 "dict.vala"
			result = 0;
#line 99 "dict.vala"
			return result;
#line 506 "dict.c"
		}
		default:
		{
#line 102 "dict.vala"
			result = 0;
#line 102 "dict.vala"
			return result;
#line 514 "dict.c"
		}
	}
}

void
enchant_dict_set_error (EnchantDict* self,
                        const gchar* err)
{
	EnchantSession* _tmp0_;
	EnchantSession* _tmp1_;
	gchar* _tmp2_;
#line 106 "dict.vala"
	g_return_if_fail (self != NULL);
#line 106 "dict.vala"
	g_return_if_fail (err != NULL);
#line 107 "dict.vala"
	_tmp0_ = self->session;
#line 107 "dict.vala"
	enchant_session_clear_error (_tmp0_);
#line 108 "dict.vala"
	g_debug ("dict.vala:108: enchant_dict_set_error: %s", err);
#line 109 "dict.vala"
	_tmp1_ = self->session;
#line 109 "dict.vala"
	_tmp2_ = g_strdup (err);
#line 109 "dict.vala"
	_g_free0 (_tmp1_->error);
#line 109 "dict.vala"
	_tmp1_->error = _tmp2_;
#line 544 "dict.c"
}

const gchar*
enchant_dict_get_error (EnchantDict* self)
{
	EnchantSession* _tmp0_;
	const gchar* _tmp1_;
	const gchar* result;
#line 112 "dict.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 113 "dict.vala"
	_tmp0_ = self->session;
#line 113 "dict.vala"
	_tmp1_ = _tmp0_->error;
#line 113 "dict.vala"
	result = _tmp1_;
#line 113 "dict.vala"
	return result;
#line 563 "dict.c"
}

gint
enchant_dict_check (EnchantDict* _self_,
                    const gchar* word_buf,
                    ssize_t len)
{
	gboolean _tmp0_ = FALSE;
	gchar* word = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	EnchantSession* _tmp3_;
	EnchantSession* _tmp4_;
	const gchar* _tmp5_;
	EnchantSession* _tmp6_;
	const gchar* _tmp7_;
	DictCheck _tmp8_;
	DictCheck _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gint result;
#line 120 "dict.vala"
	if (_self_ == NULL) {
#line 120 "dict.vala"
		_tmp0_ = TRUE;
#line 591 "dict.c"
	} else {
#line 120 "dict.vala"
		_tmp0_ = word_buf == NULL;
#line 595 "dict.c"
	}
#line 120 "dict.vala"
	if (_tmp0_) {
#line 121 "dict.vala"
		result = -1;
#line 121 "dict.vala"
		return result;
#line 603 "dict.c"
	}
#line 122 "dict.vala"
	_tmp1_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 122 "dict.vala"
	word = _tmp1_;
#line 123 "dict.vala"
	_tmp2_ = word;
#line 123 "dict.vala"
	if (_tmp2_ == NULL) {
#line 124 "dict.vala"
		result = -1;
#line 124 "dict.vala"
		_g_free0 (word);
#line 124 "dict.vala"
		return result;
#line 619 "dict.c"
	}
#line 126 "dict.vala"
	_tmp3_ = _self_->session;
#line 126 "dict.vala"
	enchant_session_clear_error (_tmp3_);
#line 129 "dict.vala"
	_tmp4_ = _self_->session;
#line 129 "dict.vala"
	_tmp5_ = word;
#line 129 "dict.vala"
	if (enchant_session_exclude (_tmp4_, _tmp5_)) {
#line 130 "dict.vala"
		result = 1;
#line 130 "dict.vala"
		_g_free0 (word);
#line 130 "dict.vala"
		return result;
#line 637 "dict.c"
	}
#line 133 "dict.vala"
	_tmp6_ = _self_->session;
#line 133 "dict.vala"
	_tmp7_ = word;
#line 133 "dict.vala"
	if (enchant_session_contains (_tmp6_, _tmp7_)) {
#line 134 "dict.vala"
		result = 0;
#line 134 "dict.vala"
		_g_free0 (word);
#line 134 "dict.vala"
		return result;
#line 651 "dict.c"
	}
#line 137 "dict.vala"
	_tmp8_ = _self_->check_method;
#line 137 "dict.vala"
	if (_tmp8_ == NULL) {
#line 138 "dict.vala"
		result = 1;
#line 138 "dict.vala"
		_g_free0 (word);
#line 138 "dict.vala"
		return result;
#line 663 "dict.c"
	}
#line 139 "dict.vala"
	_tmp9_ = _self_->check_method;
#line 139 "dict.vala"
	_tmp10_ = word;
#line 139 "dict.vala"
	_tmp11_ = word;
#line 139 "dict.vala"
	_tmp12_ = strlen (_tmp11_);
#line 139 "dict.vala"
	_tmp13_ = _tmp12_;
#line 139 "dict.vala"
	result = _tmp9_ (_self_, _tmp10_, (size_t) _tmp13_);
#line 139 "dict.vala"
	_g_free0 (word);
#line 139 "dict.vala"
	return result;
#line 681 "dict.c"
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
#line 1622 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1623 "glib-2.0.vapi"
	result = self;
#line 1623 "glib-2.0.vapi"
	return result;
#line 694 "dict.c"
}

static gchar**
enchant_dict_filter_suggestions (EnchantDict* self,
                                 gchar** suggs,
                                 gint suggs_length1,
                                 gint* result_length1)
{
	GStrvBuilder* sb = NULL;
	GStrvBuilder* _tmp0_;
	GStrvBuilder* _tmp19_;
	gchar** _tmp20_;
	gchar** _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gchar** result;
#line 144 "dict.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 145 "dict.vala"
	_tmp0_ = g_strv_builder_new ();
#line 145 "dict.vala"
	sb = _tmp0_;
#line 717 "dict.c"
	{
		gchar** sugg_collection = NULL;
		gint sugg_collection_length1 = 0;
		gint _sugg_collection_size_ = 0;
		gint sugg_it = 0;
#line 146 "dict.vala"
		sugg_collection = suggs;
#line 146 "dict.vala"
		sugg_collection_length1 = suggs_length1;
#line 146 "dict.vala"
		for (sugg_it = 0; sugg_it < sugg_collection_length1; sugg_it = sugg_it + 1) {
#line 729 "dict.c"
			gchar* _tmp1_;
			gchar* sugg = NULL;
#line 146 "dict.vala"
			_tmp1_ = g_strdup (sugg_collection[sugg_it]);
#line 146 "dict.vala"
			sugg = _tmp1_;
#line 736 "dict.c"
			{
				const gchar* _tmp2_;
				gboolean _tmp13_ = FALSE;
				const gchar* _tmp14_;
#line 147 "dict.vala"
				_tmp2_ = sugg;
#line 147 "dict.vala"
				if (_tmp2_ == NULL) {
#line 745 "dict.c"
					EnchantSession* _tmp3_;
					EnchantSession* _tmp4_;
					EnchantProvider* _tmp5_;
					ProviderIdentify _tmp6_;
					EnchantSession* _tmp7_;
					EnchantProvider* _tmp8_;
					const gchar* _tmp9_;
					const gchar* _tmp10_;
					gchar* _tmp11_;
					gchar** _tmp12_;
					gint _tmp12__length1;
#line 148 "dict.vala"
					_tmp3_ = self->session;
#line 148 "dict.vala"
					_tmp4_ = self->session;
#line 148 "dict.vala"
					_tmp5_ = _tmp4_->provider;
#line 148 "dict.vala"
					_tmp6_ = _tmp5_->identify;
#line 148 "dict.vala"
					_tmp7_ = self->session;
#line 148 "dict.vala"
					_tmp8_ = _tmp7_->provider;
#line 148 "dict.vala"
					_tmp9_ = _tmp6_ (_tmp8_);
#line 148 "dict.vala"
					_tmp10_ = string_to_string (_tmp9_);
#line 148 "dict.vala"
					_tmp11_ = g_strconcat ("null entry in suggestions returned by ", _tmp10_, NULL);
#line 148 "dict.vala"
					_g_free0 (_tmp3_->error);
#line 148 "dict.vala"
					_tmp3_->error = _tmp11_;
#line 149 "dict.vala"
					_tmp12_ = NULL;
#line 149 "dict.vala"
					_tmp12__length1 = 0;
#line 149 "dict.vala"
					if (result_length1) {
#line 149 "dict.vala"
						*result_length1 = _tmp12__length1;
#line 787 "dict.c"
					}
#line 149 "dict.vala"
					result = _tmp12_;
#line 149 "dict.vala"
					_g_free0 (sugg);
#line 149 "dict.vala"
					_g_strv_builder_unref0 (sb);
#line 149 "dict.vala"
					return result;
#line 797 "dict.c"
				}
#line 151 "dict.vala"
				_tmp14_ = sugg;
#line 151 "dict.vala"
				if (g_utf8_validate (_tmp14_, (gssize) -1, NULL)) {
#line 803 "dict.c"
					EnchantSession* _tmp15_;
					const gchar* _tmp16_;
#line 151 "dict.vala"
					_tmp15_ = self->session;
#line 151 "dict.vala"
					_tmp16_ = sugg;
#line 151 "dict.vala"
					_tmp13_ = !enchant_session_exclude (_tmp15_, _tmp16_);
#line 812 "dict.c"
				} else {
#line 151 "dict.vala"
					_tmp13_ = FALSE;
#line 816 "dict.c"
				}
#line 151 "dict.vala"
				if (_tmp13_) {
#line 820 "dict.c"
					GStrvBuilder* _tmp17_;
					const gchar* _tmp18_;
#line 152 "dict.vala"
					_tmp17_ = sb;
#line 152 "dict.vala"
					_tmp18_ = sugg;
#line 152 "dict.vala"
					g_strv_builder_add (_tmp17_, _tmp18_);
#line 829 "dict.c"
				}
#line 146 "dict.vala"
				_g_free0 (sugg);
#line 833 "dict.c"
			}
		}
	}
#line 155 "dict.vala"
	_tmp19_ = sb;
#line 155 "dict.vala"
	_tmp21_ = _tmp20_ = g_strv_builder_end (_tmp19_);
#line 155 "dict.vala"
	_tmp22_ = _tmp21_;
#line 155 "dict.vala"
	_tmp22__length1 = _vala_array_length (_tmp20_);
#line 155 "dict.vala"
	if (result_length1) {
#line 155 "dict.vala"
		*result_length1 = _tmp22__length1;
#line 849 "dict.c"
	}
#line 155 "dict.vala"
	result = _tmp22_;
#line 155 "dict.vala"
	_g_strv_builder_unref0 (sb);
#line 155 "dict.vala"
	return result;
#line 857 "dict.c"
}

gchar**
enchant_dict_suggest (EnchantDict* self,
                      const gchar* word_buf,
                      ssize_t len,
                      size_t* result_length1)
{
	DictSuggest _tmp0_;
	gchar* word = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	EnchantSession* _tmp5_;
	gchar** dict_suggs = NULL;
	DictSuggest _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	size_t _tmp11_ = 0;
	gchar** _tmp12_;
	gint dict_suggs_length1;
	gint _dict_suggs_size_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gchar** _tmp17_;
	gint _tmp17__length1;
	gchar** result;
#line 159 "dict.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 159 "dict.vala"
	g_return_val_if_fail (word_buf != NULL, NULL);
#line 160 "dict.vala"
	_tmp0_ = self->suggest_method;
#line 160 "dict.vala"
	if (_tmp0_ == NULL) {
#line 894 "dict.c"
		gchar** _tmp1_;
		gint _tmp1__length1;
#line 161 "dict.vala"
		_tmp1_ = NULL;
#line 161 "dict.vala"
		_tmp1__length1 = 0;
#line 161 "dict.vala"
		if (result_length1) {
#line 161 "dict.vala"
			*result_length1 = _tmp1__length1;
#line 905 "dict.c"
		}
#line 161 "dict.vala"
		result = _tmp1_;
#line 161 "dict.vala"
		return result;
#line 911 "dict.c"
	}
#line 162 "dict.vala"
	_tmp2_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 162 "dict.vala"
	word = _tmp2_;
#line 163 "dict.vala"
	_tmp3_ = word;
#line 163 "dict.vala"
	if (_tmp3_ == NULL) {
#line 921 "dict.c"
		gchar** _tmp4_;
		gint _tmp4__length1;
#line 164 "dict.vala"
		_tmp4_ = NULL;
#line 164 "dict.vala"
		_tmp4__length1 = 0;
#line 164 "dict.vala"
		if (result_length1) {
#line 164 "dict.vala"
			*result_length1 = _tmp4__length1;
#line 932 "dict.c"
		}
#line 164 "dict.vala"
		result = _tmp4_;
#line 164 "dict.vala"
		_g_free0 (word);
#line 164 "dict.vala"
		return result;
#line 940 "dict.c"
	}
#line 166 "dict.vala"
	_tmp5_ = self->session;
#line 166 "dict.vala"
	enchant_session_clear_error (_tmp5_);
#line 169 "dict.vala"
	_tmp6_ = self->suggest_method;
#line 169 "dict.vala"
	_tmp7_ = word;
#line 169 "dict.vala"
	_tmp8_ = word;
#line 169 "dict.vala"
	_tmp9_ = strlen (_tmp8_);
#line 169 "dict.vala"
	_tmp10_ = _tmp9_;
#line 169 "dict.vala"
	_tmp12_ = _tmp6_ (self, _tmp7_, (size_t) _tmp10_, &_tmp11_);
#line 169 "dict.vala"
	dict_suggs = _tmp12_;
#line 169 "dict.vala"
	dict_suggs_length1 = _tmp11_;
#line 169 "dict.vala"
	_dict_suggs_size_ = dict_suggs_length1;
#line 170 "dict.vala"
	_tmp13_ = dict_suggs;
#line 170 "dict.vala"
	_tmp13__length1 = dict_suggs_length1;
#line 170 "dict.vala"
	if (_tmp13_ != NULL) {
#line 970 "dict.c"
		gchar** _tmp14_;
		gint _tmp14__length1;
		gint _tmp15_ = 0;
		gchar** _tmp16_;
#line 171 "dict.vala"
		_tmp14_ = dict_suggs;
#line 171 "dict.vala"
		_tmp14__length1 = dict_suggs_length1;
#line 171 "dict.vala"
		_tmp16_ = enchant_dict_filter_suggestions (self, _tmp14_, (gint) _tmp14__length1, &_tmp15_);
#line 171 "dict.vala"
		dict_suggs = (_vala_array_free (dict_suggs, dict_suggs_length1, (GDestroyNotify) g_free), NULL);
#line 171 "dict.vala"
		dict_suggs = _tmp16_;
#line 171 "dict.vala"
		dict_suggs_length1 = _tmp15_;
#line 171 "dict.vala"
		_dict_suggs_size_ = dict_suggs_length1;
#line 989 "dict.c"
	}
#line 173 "dict.vala"
	_tmp17_ = dict_suggs;
#line 173 "dict.vala"
	_tmp17__length1 = dict_suggs_length1;
#line 173 "dict.vala"
	if (result_length1) {
#line 173 "dict.vala"
		*result_length1 = _tmp17__length1;
#line 999 "dict.c"
	}
#line 173 "dict.vala"
	result = _tmp17_;
#line 173 "dict.vala"
	_g_free0 (word);
#line 173 "dict.vala"
	return result;
#line 1007 "dict.c"
}

void
enchant_dict_add (EnchantDict* self,
                  const gchar* word_buf,
                  ssize_t len)
{
	EnchantSession* _tmp0_;
	EnchantPWL* _tmp1_;
	EnchantSession* _tmp2_;
	EnchantPWL* _tmp3_;
#line 176 "dict.vala"
	g_return_if_fail (self != NULL);
#line 176 "dict.vala"
	g_return_if_fail (word_buf != NULL);
#line 177 "dict.vala"
	enchant_dict_add_to_session (self, word_buf, len);
#line 178 "dict.vala"
	_tmp0_ = self->session;
#line 178 "dict.vala"
	_tmp1_ = _tmp0_->pwl;
#line 178 "dict.vala"
	enchant_pwl_add (_tmp1_, word_buf, len);
#line 179 "dict.vala"
	_tmp2_ = self->session;
#line 179 "dict.vala"
	_tmp3_ = _tmp2_->exclude_pwl;
#line 179 "dict.vala"
	enchant_pwl_remove (_tmp3_, word_buf, len);
#line 1037 "dict.c"
}

void
enchant_dict_add_to_session (EnchantDict* self,
                             const gchar* word_buf,
                             ssize_t len)
{
	gchar* word = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	EnchantSession* _tmp2_;
	EnchantSession* _tmp3_;
	const gchar* _tmp4_;
	DictAddToSession _tmp5_;
#line 182 "dict.vala"
	g_return_if_fail (self != NULL);
#line 182 "dict.vala"
	g_return_if_fail (word_buf != NULL);
#line 183 "dict.vala"
	_tmp0_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 183 "dict.vala"
	word = _tmp0_;
#line 184 "dict.vala"
	_tmp1_ = word;
#line 184 "dict.vala"
	if (_tmp1_ == NULL) {
#line 185 "dict.vala"
		_g_free0 (word);
#line 185 "dict.vala"
		return;
#line 1068 "dict.c"
	}
#line 186 "dict.vala"
	_tmp2_ = self->session;
#line 186 "dict.vala"
	enchant_session_clear_error (_tmp2_);
#line 187 "dict.vala"
	_tmp3_ = self->session;
#line 187 "dict.vala"
	_tmp4_ = word;
#line 187 "dict.vala"
	enchant_session_add (_tmp3_, _tmp4_);
#line 188 "dict.vala"
	_tmp5_ = self->add_to_session_method;
#line 188 "dict.vala"
	if (_tmp5_ != NULL) {
#line 1084 "dict.c"
		DictAddToSession _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
#line 189 "dict.vala"
		_tmp6_ = self->add_to_session_method;
#line 189 "dict.vala"
		_tmp7_ = word;
#line 189 "dict.vala"
		_tmp8_ = word;
#line 189 "dict.vala"
		_tmp9_ = strlen (_tmp8_);
#line 189 "dict.vala"
		_tmp10_ = _tmp9_;
#line 189 "dict.vala"
		_tmp6_ (self, _tmp7_, (size_t) _tmp10_);
#line 1102 "dict.c"
	}
#line 182 "dict.vala"
	_g_free0 (word);
#line 1106 "dict.c"
}

gint
enchant_dict_is_added (EnchantDict* self,
                       const gchar* word_buf,
                       ssize_t len)
{
	gchar* word = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	EnchantSession* _tmp2_;
	gint _tmp3_ = 0;
	EnchantSession* _tmp4_;
	const gchar* _tmp5_;
	gint result;
#line 192 "dict.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 192 "dict.vala"
	g_return_val_if_fail (word_buf != NULL, 0);
#line 193 "dict.vala"
	_tmp0_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 193 "dict.vala"
	word = _tmp0_;
#line 194 "dict.vala"
	_tmp1_ = word;
#line 194 "dict.vala"
	if (_tmp1_ == NULL) {
#line 195 "dict.vala"
		result = 0;
#line 195 "dict.vala"
		_g_free0 (word);
#line 195 "dict.vala"
		return result;
#line 1140 "dict.c"
	}
#line 196 "dict.vala"
	_tmp2_ = self->session;
#line 196 "dict.vala"
	enchant_session_clear_error (_tmp2_);
#line 197 "dict.vala"
	_tmp4_ = self->session;
#line 197 "dict.vala"
	_tmp5_ = word;
#line 197 "dict.vala"
	if (enchant_session_contains (_tmp4_, _tmp5_)) {
#line 197 "dict.vala"
		_tmp3_ = 1;
#line 1154 "dict.c"
	} else {
#line 197 "dict.vala"
		_tmp3_ = 0;
#line 1158 "dict.c"
	}
#line 197 "dict.vala"
	result = _tmp3_;
#line 197 "dict.vala"
	_g_free0 (word);
#line 197 "dict.vala"
	return result;
#line 1166 "dict.c"
}

void
enchant_dict_remove (EnchantDict* self,
                     const gchar* word_buf,
                     ssize_t len)
{
	EnchantSession* _tmp0_;
	EnchantPWL* _tmp1_;
	EnchantSession* _tmp2_;
	EnchantPWL* _tmp3_;
#line 200 "dict.vala"
	g_return_if_fail (self != NULL);
#line 200 "dict.vala"
	g_return_if_fail (word_buf != NULL);
#line 201 "dict.vala"
	enchant_dict_remove_from_session (self, word_buf, len);
#line 202 "dict.vala"
	_tmp0_ = self->session;
#line 202 "dict.vala"
	_tmp1_ = _tmp0_->pwl;
#line 202 "dict.vala"
	enchant_pwl_remove (_tmp1_, word_buf, len);
#line 203 "dict.vala"
	_tmp2_ = self->session;
#line 203 "dict.vala"
	_tmp3_ = _tmp2_->exclude_pwl;
#line 203 "dict.vala"
	enchant_pwl_add (_tmp3_, word_buf, len);
#line 1196 "dict.c"
}

void
enchant_dict_remove_from_session (EnchantDict* self,
                                  const gchar* word_buf,
                                  ssize_t len)
{
	gchar* word = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	EnchantSession* _tmp2_;
	EnchantSession* _tmp3_;
	const gchar* _tmp4_;
	DictRemoveFromSession _tmp5_;
#line 206 "dict.vala"
	g_return_if_fail (self != NULL);
#line 206 "dict.vala"
	g_return_if_fail (word_buf != NULL);
#line 207 "dict.vala"
	_tmp0_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 207 "dict.vala"
	word = _tmp0_;
#line 208 "dict.vala"
	_tmp1_ = word;
#line 208 "dict.vala"
	if (_tmp1_ == NULL) {
#line 209 "dict.vala"
		_g_free0 (word);
#line 209 "dict.vala"
		return;
#line 1227 "dict.c"
	}
#line 210 "dict.vala"
	_tmp2_ = self->session;
#line 210 "dict.vala"
	enchant_session_clear_error (_tmp2_);
#line 211 "dict.vala"
	_tmp3_ = self->session;
#line 211 "dict.vala"
	_tmp4_ = word;
#line 211 "dict.vala"
	enchant_session_remove (_tmp3_, _tmp4_);
#line 212 "dict.vala"
	_tmp5_ = self->remove_from_session_method;
#line 212 "dict.vala"
	if (_tmp5_ != NULL) {
#line 1243 "dict.c"
		DictRemoveFromSession _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
#line 213 "dict.vala"
		_tmp6_ = self->remove_from_session_method;
#line 213 "dict.vala"
		_tmp7_ = word;
#line 213 "dict.vala"
		_tmp8_ = word;
#line 213 "dict.vala"
		_tmp9_ = strlen (_tmp8_);
#line 213 "dict.vala"
		_tmp10_ = _tmp9_;
#line 213 "dict.vala"
		_tmp6_ (self, _tmp7_, (size_t) _tmp10_);
#line 1261 "dict.c"
	}
#line 206 "dict.vala"
	_g_free0 (word);
#line 1265 "dict.c"
}

gint
enchant_dict_is_removed (EnchantDict* self,
                         const gchar* word_buf,
                         ssize_t len)
{
	gchar* word = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	EnchantSession* _tmp2_;
	gint _tmp3_ = 0;
	EnchantSession* _tmp4_;
	const gchar* _tmp5_;
	gint result;
#line 216 "dict.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 216 "dict.vala"
	g_return_val_if_fail (word_buf != NULL, 0);
#line 217 "dict.vala"
	_tmp0_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 217 "dict.vala"
	word = _tmp0_;
#line 218 "dict.vala"
	_tmp1_ = word;
#line 218 "dict.vala"
	if (_tmp1_ == NULL) {
#line 219 "dict.vala"
		result = 0;
#line 219 "dict.vala"
		_g_free0 (word);
#line 219 "dict.vala"
		return result;
#line 1299 "dict.c"
	}
#line 220 "dict.vala"
	_tmp2_ = self->session;
#line 220 "dict.vala"
	enchant_session_clear_error (_tmp2_);
#line 221 "dict.vala"
	_tmp4_ = self->session;
#line 221 "dict.vala"
	_tmp5_ = word;
#line 221 "dict.vala"
	if (enchant_session_exclude (_tmp4_, _tmp5_)) {
#line 221 "dict.vala"
		_tmp3_ = 1;
#line 1313 "dict.c"
	} else {
#line 221 "dict.vala"
		_tmp3_ = 0;
#line 1317 "dict.c"
	}
#line 221 "dict.vala"
	result = _tmp3_;
#line 221 "dict.vala"
	_g_free0 (word);
#line 221 "dict.vala"
	return result;
#line 1325 "dict.c"
}

void
enchant_dict_store_replacement (EnchantDict* self,
                                const gchar* mis,
                                ssize_t mis_len,
                                const gchar* cor,
                                ssize_t cor_len)
{
#line 225 "dict.vala"
	g_return_if_fail (self != NULL);
#line 225 "dict.vala"
	g_return_if_fail (mis != NULL);
#line 225 "dict.vala"
	g_return_if_fail (cor != NULL);
#line 1341 "dict.c"
}

void
enchant_dict_free_string_list (EnchantDict* self,
                               gchar** string_list)
{
	EnchantSession* _tmp0_;
	gchar** _tmp1_;
#line 228 "dict.vala"
	g_return_if_fail (self != NULL);
#line 229 "dict.vala"
	_tmp0_ = self->session;
#line 229 "dict.vala"
	enchant_session_clear_error (_tmp0_);
#line 230 "dict.vala"
	_tmp1_ = string_list;
#line 230 "dict.vala"
	string_list = NULL;
#line 230 "dict.vala"
	g_strfreev ((gchar**) _tmp1_);
#line 1362 "dict.c"
}

void
enchant_dict_describe (EnchantDict* self,
                       EnchantDictDescribeFn fn,
                       void* user_data)
{
	EnchantSession* _tmp0_;
	EnchantProvider* provider = NULL;
	EnchantSession* _tmp1_;
	EnchantProvider* _tmp2_;
	gchar* name = NULL;
	gchar* desc = NULL;
	gchar* file = NULL;
	EnchantProvider* _tmp3_;
	gchar* tag = NULL;
	EnchantSession* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
#line 233 "dict.vala"
	g_return_if_fail (self != NULL);
#line 233 "dict.vala"
	_vala_return_if_fail (fn != NULL, "fn != null");
#line 236 "dict.vala"
	_tmp0_ = self->session;
#line 236 "dict.vala"
	enchant_session_clear_error (_tmp0_);
#line 237 "dict.vala"
	_tmp1_ = self->session;
#line 237 "dict.vala"
	_tmp2_ = _tmp1_->provider;
#line 237 "dict.vala"
	provider = _tmp2_;
#line 242 "dict.vala"
	_tmp3_ = provider;
#line 242 "dict.vala"
	if (_tmp3_ != NULL) {
#line 1403 "dict.c"
		EnchantProvider* _tmp4_;
		GModule* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		EnchantProvider* _tmp8_;
		ProviderIdentify _tmp9_;
		EnchantProvider* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		EnchantProvider* _tmp13_;
		ProviderDescribe _tmp14_;
		EnchantProvider* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
#line 243 "dict.vala"
		_tmp4_ = provider;
#line 243 "dict.vala"
		_tmp5_ = _tmp4_->module;
#line 243 "dict.vala"
		_tmp6_ = g_module_name (_tmp5_);
#line 243 "dict.vala"
		_tmp7_ = g_strdup (_tmp6_);
#line 243 "dict.vala"
		_g_free0 (file);
#line 243 "dict.vala"
		file = _tmp7_;
#line 244 "dict.vala"
		_tmp8_ = provider;
#line 244 "dict.vala"
		_tmp9_ = _tmp8_->identify;
#line 244 "dict.vala"
		_tmp10_ = provider;
#line 244 "dict.vala"
		_tmp11_ = _tmp9_ (_tmp10_);
#line 244 "dict.vala"
		_tmp12_ = g_strdup (_tmp11_);
#line 244 "dict.vala"
		_g_free0 (name);
#line 244 "dict.vala"
		name = _tmp12_;
#line 245 "dict.vala"
		_tmp13_ = provider;
#line 245 "dict.vala"
		_tmp14_ = _tmp13_->describe;
#line 245 "dict.vala"
		_tmp15_ = provider;
#line 245 "dict.vala"
		_tmp16_ = _tmp14_ (_tmp15_);
#line 245 "dict.vala"
		_tmp17_ = g_strdup (_tmp16_);
#line 245 "dict.vala"
		_g_free0 (desc);
#line 245 "dict.vala"
		desc = _tmp17_;
#line 1458 "dict.c"
	} else {
		EnchantSession* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
#line 247 "dict.vala"
		_tmp18_ = self->session;
#line 247 "dict.vala"
		_tmp19_ = _tmp18_->personal_filename;
#line 247 "dict.vala"
		_tmp20_ = g_strdup (_tmp19_);
#line 247 "dict.vala"
		_g_free0 (file);
#line 247 "dict.vala"
		file = _tmp20_;
#line 248 "dict.vala"
		_tmp21_ = g_strdup ("Personal Wordlist");
#line 248 "dict.vala"
		_g_free0 (name);
#line 248 "dict.vala"
		name = _tmp21_;
#line 249 "dict.vala"
		_tmp22_ = g_strdup ("Personal Wordlist");
#line 249 "dict.vala"
		_g_free0 (desc);
#line 249 "dict.vala"
		desc = _tmp22_;
#line 1487 "dict.c"
	}
#line 252 "dict.vala"
	_tmp23_ = self->session;
#line 252 "dict.vala"
	_tmp24_ = _tmp23_->language_tag;
#line 252 "dict.vala"
	_tmp25_ = g_strdup (_tmp24_);
#line 252 "dict.vala"
	tag = _tmp25_;
#line 253 "dict.vala"
	_tmp26_ = name;
#line 253 "dict.vala"
	_tmp27_ = desc;
#line 253 "dict.vala"
	_tmp28_ = file;
#line 253 "dict.vala"
	fn (tag, _tmp26_, _tmp27_, _tmp28_, user_data);
#line 233 "dict.vala"
	_g_free0 (tag);
#line 233 "dict.vala"
	_g_free0 (file);
#line 233 "dict.vala"
	_g_free0 (desc);
#line 233 "dict.vala"
	_g_free0 (name);
#line 1513 "dict.c"
}

EnchantDict*
enchant_dict_construct (GType object_type)
{
	EnchantDict* self = NULL;
#line 44 "dict.vala"
	self = (EnchantDict*) g_type_create_instance (object_type);
#line 44 "dict.vala"
	return self;
#line 1524 "dict.c"
}

EnchantDict*
enchant_dict_new (void)
{
#line 44 "dict.vala"
	return enchant_dict_construct (TYPE_ENCHANT_DICT);
#line 1532 "dict.c"
}

static void
value_enchant_dict_init (GValue* value)
{
#line 44 "dict.vala"
	value->data[0].v_pointer = NULL;
#line 1540 "dict.c"
}

static void
value_enchant_dict_free_value (GValue* value)
{
#line 44 "dict.vala"
	if (value->data[0].v_pointer) {
#line 44 "dict.vala"
		enchant_dict_unref (value->data[0].v_pointer);
#line 1550 "dict.c"
	}
}

static void
value_enchant_dict_copy_value (const GValue* src_value,
                               GValue* dest_value)
{
#line 44 "dict.vala"
	if (src_value->data[0].v_pointer) {
#line 44 "dict.vala"
		dest_value->data[0].v_pointer = enchant_dict_ref (src_value->data[0].v_pointer);
#line 1562 "dict.c"
	} else {
#line 44 "dict.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1566 "dict.c"
	}
}

static gpointer
value_enchant_dict_peek_pointer (const GValue* value)
{
#line 44 "dict.vala"
	return value->data[0].v_pointer;
#line 1575 "dict.c"
}

static gchar*
value_enchant_dict_collect_value (GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
#line 44 "dict.vala"
	if (collect_values[0].v_pointer) {
#line 1586 "dict.c"
		EnchantDict * object;
		object = collect_values[0].v_pointer;
#line 44 "dict.vala"
		if (object->parent_instance.g_class == NULL) {
#line 44 "dict.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1593 "dict.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 44 "dict.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1597 "dict.c"
		}
#line 44 "dict.vala"
		value->data[0].v_pointer = enchant_dict_ref (object);
#line 1601 "dict.c"
	} else {
#line 44 "dict.vala"
		value->data[0].v_pointer = NULL;
#line 1605 "dict.c"
	}
#line 44 "dict.vala"
	return NULL;
#line 1609 "dict.c"
}

static gchar*
value_enchant_dict_lcopy_value (const GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	EnchantDict ** object_p;
	object_p = collect_values[0].v_pointer;
#line 44 "dict.vala"
	if (!object_p) {
#line 44 "dict.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1624 "dict.c"
	}
#line 44 "dict.vala"
	if (!value->data[0].v_pointer) {
#line 44 "dict.vala"
		*object_p = NULL;
#line 1630 "dict.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 44 "dict.vala"
		*object_p = value->data[0].v_pointer;
#line 1634 "dict.c"
	} else {
#line 44 "dict.vala"
		*object_p = enchant_dict_ref (value->data[0].v_pointer);
#line 1638 "dict.c"
	}
#line 44 "dict.vala"
	return NULL;
#line 1642 "dict.c"
}

GParamSpec*
param_spec_enchant_dict (const gchar* name,
                         const gchar* nick,
                         const gchar* blurb,
                         GType object_type,
                         GParamFlags flags)
{
	ParamSpecEnchantDict* spec;
#line 44 "dict.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ENCHANT_DICT), NULL);
#line 44 "dict.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 44 "dict.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 44 "dict.vala"
	return G_PARAM_SPEC (spec);
#line 1661 "dict.c"
}

gpointer
value_get_enchant_dict (const GValue* value)
{
#line 44 "dict.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_DICT), NULL);
#line 44 "dict.vala"
	return value->data[0].v_pointer;
#line 1671 "dict.c"
}

void
value_set_enchant_dict (GValue* value,
                        gpointer v_object)
{
	EnchantDict * old;
#line 44 "dict.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_DICT));
#line 44 "dict.vala"
	old = value->data[0].v_pointer;
#line 44 "dict.vala"
	if (v_object) {
#line 44 "dict.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENCHANT_DICT));
#line 44 "dict.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 44 "dict.vala"
		value->data[0].v_pointer = v_object;
#line 44 "dict.vala"
		enchant_dict_ref (value->data[0].v_pointer);
#line 1693 "dict.c"
	} else {
#line 44 "dict.vala"
		value->data[0].v_pointer = NULL;
#line 1697 "dict.c"
	}
#line 44 "dict.vala"
	if (old) {
#line 44 "dict.vala"
		enchant_dict_unref (old);
#line 1703 "dict.c"
	}
}

void
value_take_enchant_dict (GValue* value,
                         gpointer v_object)
{
	EnchantDict * old;
#line 44 "dict.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_DICT));
#line 44 "dict.vala"
	old = value->data[0].v_pointer;
#line 44 "dict.vala"
	if (v_object) {
#line 44 "dict.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENCHANT_DICT));
#line 44 "dict.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 44 "dict.vala"
		value->data[0].v_pointer = v_object;
#line 1724 "dict.c"
	} else {
#line 44 "dict.vala"
		value->data[0].v_pointer = NULL;
#line 1728 "dict.c"
	}
#line 44 "dict.vala"
	if (old) {
#line 44 "dict.vala"
		enchant_dict_unref (old);
#line 1734 "dict.c"
	}
}

static void
enchant_dict_class_init (EnchantDictClass * klass,
                         gpointer klass_data)
{
#line 44 "dict.vala"
	enchant_dict_parent_class = g_type_class_peek_parent (klass);
#line 44 "dict.vala"
	((EnchantDictClass *) klass)->finalize = enchant_dict_finalize;
#line 1746 "dict.c"
}

static void
enchant_dict_instance_init (EnchantDict * self,
                            gpointer klass)
{
#line 44 "dict.vala"
	self->ref_count = 1;
#line 1755 "dict.c"
}

static void
enchant_dict_finalize (EnchantDict * obj)
{
	EnchantDict * self;
	EnchantProvider* owner = NULL;
	EnchantSession* _tmp0_;
	EnchantProvider* _tmp1_;
	EnchantProvider* _tmp2_;
#line 44 "dict.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ENCHANT_DICT, EnchantDict);
#line 44 "dict.vala"
	g_signal_handlers_destroy (self);
#line 57 "dict.vala"
	_tmp0_ = self->session;
#line 57 "dict.vala"
	_tmp1_ = _tmp0_->provider;
#line 57 "dict.vala"
	owner = _tmp1_;
#line 58 "dict.vala"
	_tmp2_ = owner;
#line 58 "dict.vala"
	if (_tmp2_ != NULL) {
#line 1780 "dict.c"
		EnchantProvider* _tmp3_;
		ProviderDisposeDict _tmp4_;
		EnchantProvider* _tmp5_;
#line 59 "dict.vala"
		_tmp3_ = owner;
#line 59 "dict.vala"
		_tmp4_ = _tmp3_->dispose_dict;
#line 59 "dict.vala"
		_tmp5_ = owner;
#line 59 "dict.vala"
		_tmp4_ (_tmp5_, self);
#line 1792 "dict.c"
	}
#line 46 "dict.vala"
	_enchant_session_unref0 (self->session);
#line 1796 "dict.c"
}

static GType
enchant_dict_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_enchant_dict_init, value_enchant_dict_free_value, value_enchant_dict_copy_value, value_enchant_dict_peek_pointer, "p", value_enchant_dict_collect_value, "p", value_enchant_dict_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (EnchantDictClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enchant_dict_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EnchantDict), 0, (GInstanceInitFunc) enchant_dict_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType enchant_dict_type_id;
	enchant_dict_type_id = g_type_register_fundamental (g_type_fundamental_next (), "EnchantDict", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return enchant_dict_type_id;
}

GType
enchant_dict_get_type (void)
{
	static volatile gsize enchant_dict_type_id__once = 0;
	if (g_once_init_enter (&enchant_dict_type_id__once)) {
		GType enchant_dict_type_id;
		enchant_dict_type_id = enchant_dict_get_type_once ();
		g_once_init_leave (&enchant_dict_type_id__once, enchant_dict_type_id);
	}
	return enchant_dict_type_id__once;
}

gpointer
enchant_dict_ref (gpointer instance)
{
	EnchantDict * self;
	self = instance;
#line 44 "dict.vala"
	g_atomic_int_inc (&self->ref_count);
#line 44 "dict.vala"
	return instance;
#line 1831 "dict.c"
}

void
enchant_dict_unref (gpointer instance)
{
	EnchantDict * self;
	self = instance;
#line 44 "dict.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 44 "dict.vala"
		ENCHANT_DICT_GET_CLASS (self)->finalize (self);
#line 44 "dict.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1845 "dict.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

