/* dict.c generated by valac 0.56.0, the Vala compiler
 * generated from dict.vala, do not modify */

/* enchant: Dict
 * Copyright (C) 2003, 2004 Dom Lachowicz
 * Copyright (C) 2016-2024 Reuben Thomas <rrt@sc3d.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along along with this program; if not, see
 * <https://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders
 * give permission to link the code of this program with
 * non-LGPL Spelling Provider libraries (eg: a MSFT Office
 * spell checker backend) and distribute linked combinations including
 * the two.  You must obey the GNU Lesser General Public License in all
 * respects for all of the code used other than said providers.  If you modify
 * this file, you may extend this exception to your version of the
 * file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <gmodule.h>
#include <enchant.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ENCHANT_DICT (enchant_dict_get_type ())
#define ENCHANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_DICT, EnchantDict))
#define ENCHANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_DICT, EnchantDictClass))
#define IS_ENCHANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_DICT))
#define IS_ENCHANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_DICT))
#define ENCHANT_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_DICT, EnchantDictClass))

typedef struct _EnchantDict EnchantDict;
typedef struct _EnchantDictClass EnchantDictClass;
typedef gint (*DictCheck) (EnchantDict* me, const gchar* word, size_t len);
typedef gchar** (*DictSuggest) (EnchantDict* me, const gchar* word, size_t len, size_t* result_length1);
typedef void (*DictAddToSession) (EnchantDict* me, const gchar* word, size_t len);
typedef void (*DictRemoveFromSession) (EnchantDict* me, const gchar* word, size_t len);
typedef const gchar* (*DictGetExtraWordCharacters) (EnchantDict* me);
typedef gint (*DictIsWordCharacter) (EnchantDict* me, guint32 uc_in, size_t n);
typedef struct _EnchantDictPrivate EnchantDictPrivate;

#define TYPE_ENCHANT_SESSION (enchant_session_get_type ())
#define ENCHANT_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_SESSION, EnchantSession))
#define ENCHANT_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_SESSION, EnchantSessionClass))
#define IS_ENCHANT_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_SESSION))
#define IS_ENCHANT_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_SESSION))
#define ENCHANT_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_SESSION, EnchantSessionClass))

typedef struct _EnchantSession EnchantSession;
typedef struct _EnchantSessionClass EnchantSessionClass;

#define TYPE_ENCHANT_PROVIDER (enchant_provider_get_type ())
#define ENCHANT_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_PROVIDER, EnchantProvider))
#define ENCHANT_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_PROVIDER, EnchantProviderClass))
#define IS_ENCHANT_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_PROVIDER))
#define IS_ENCHANT_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_PROVIDER))
#define ENCHANT_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_PROVIDER, EnchantProviderClass))

typedef struct _EnchantProvider EnchantProvider;
typedef struct _EnchantProviderClass EnchantProviderClass;
typedef struct _EnchantSessionPrivate EnchantSessionPrivate;

#define TYPE_ENCHANT_PWL (enchant_pwl_get_type ())
#define ENCHANT_PWL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_PWL, EnchantPWL))
#define ENCHANT_PWL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_PWL, EnchantPWLClass))
#define IS_ENCHANT_PWL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_PWL))
#define IS_ENCHANT_PWL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_PWL))
#define ENCHANT_PWL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_PWL, EnchantPWLClass))

typedef struct _EnchantPWL EnchantPWL;
typedef struct _EnchantPWLClass EnchantPWLClass;
typedef struct _EnchantProviderPrivate EnchantProviderPrivate;
typedef struct _EnchantBroker EnchantBroker;
typedef void (*ProviderDispose) (EnchantProvider* me);
typedef EnchantDict* (*ProviderRequestDict) (EnchantProvider* me, const gchar* tag);
typedef void (*ProviderDisposeDict) (EnchantProvider* me, EnchantDict* dict);
typedef gint (*ProviderDictionaryExists) (EnchantProvider* me, const gchar* tag);
typedef const gchar* (*ProviderIdentify) (EnchantProvider* me);
typedef const gchar* (*ProviderDescribe) (EnchantProvider* me);
typedef gchar** (*ProviderListDicts) (EnchantProvider* me, size_t* result_length1);
#define _enchant_session_unref0(var) ((var == NULL) ? NULL : (var = (enchant_session_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_strv_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_strv_builder_unref (var), NULL)))
typedef struct _ParamSpecEnchantDict ParamSpecEnchantDict;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _EnchantDict {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantDictPrivate * priv;
	void* user_data;
	EnchantSession* session;
	DictCheck check_method;
	DictSuggest suggest_method;
	DictAddToSession add_to_session_method;
	DictRemoveFromSession remove_from_session_method;
	DictGetExtraWordCharacters get_extra_word_characters_method;
	DictIsWordCharacter is_word_character_method;
};

struct _EnchantDictClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantDict *self);
};

struct _EnchantSession {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantSessionPrivate * priv;
	GHashTable* session_include;
	GHashTable* session_exclude;
	EnchantPWL* pwl;
	EnchantPWL* exclude_pwl;
	gchar* personal_filename;
	gchar* exclude_filename;
	gchar* language_tag;
	gchar* error;
	gboolean is_pwl;
	EnchantProvider* provider;
};

struct _EnchantSessionClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantSession *self);
};

struct _EnchantProvider {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantProviderPrivate * priv;
	void* user_data;
	GModule* module;
	EnchantBroker* owner;
	ProviderDispose dispose;
	ProviderRequestDict request_dict;
	ProviderDisposeDict dispose_dict;
	ProviderDictionaryExists dictionary_exists;
	ProviderIdentify identify;
	ProviderDescribe describe;
	ProviderListDicts list_dicts;
};

struct _EnchantProviderClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantProvider *self);
};

struct _ParamSpecEnchantDict {
	GParamSpec parent_instance;
};

static gpointer enchant_dict_parent_class = NULL;

VALA_EXTERN gpointer enchant_dict_ref (gpointer instance);
VALA_EXTERN void enchant_dict_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_dict (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void value_set_enchant_dict (GValue* value,
                             gpointer v_object);
VALA_EXTERN void value_take_enchant_dict (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_dict (const GValue* value);
VALA_EXTERN GType enchant_dict_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantDict, enchant_dict_unref)
VALA_EXTERN gpointer enchant_session_ref (gpointer instance);
VALA_EXTERN void enchant_session_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_session (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_enchant_session (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_enchant_session (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_session (const GValue* value);
VALA_EXTERN GType enchant_session_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantSession, enchant_session_unref)
VALA_EXTERN gpointer enchant_provider_ref (gpointer instance);
VALA_EXTERN void enchant_provider_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_provider (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void value_set_enchant_provider (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void value_take_enchant_provider (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_provider (const GValue* value);
VALA_EXTERN GType enchant_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantProvider, enchant_provider_unref)
VALA_EXTERN gpointer enchant_pwl_ref (gpointer instance);
VALA_EXTERN void enchant_pwl_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_pwl (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_enchant_pwl (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_enchant_pwl (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_pwl (const GValue* value);
VALA_EXTERN GType enchant_pwl_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantPWL, enchant_pwl_unref)
VALA_EXTERN void enchant_broker_free (EnchantBroker * self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantBroker, enchant_broker_free)
VALA_EXTERN const gchar* enchant_dict_get_extra_word_characters (EnchantDict* self);
VALA_EXTERN gint enchant_dict_is_word_character (EnchantDict* _self_,
                                     guint32 uc_in,
                                     size_t n);
VALA_EXTERN void enchant_dict_set_error (EnchantDict* self,
                             const gchar* err);
VALA_EXTERN void enchant_session_clear_error (EnchantSession* self);
VALA_EXTERN const gchar* enchant_dict_get_error (EnchantDict* self);
VALA_EXTERN gint enchant_dict_check (EnchantDict* _self_,
                         const gchar* word_buf,
                         ssize_t len);
VALA_EXTERN gchar* buf_to_utf8_string (const gchar* str_buf,
                           gssize len);
VALA_EXTERN gboolean enchant_session_exclude (EnchantSession* self,
                                  const gchar* word);
VALA_EXTERN gboolean enchant_session_contains (EnchantSession* self,
                                   const gchar* word);
static gchar** enchant_dict_filter_suggestions (EnchantDict* self,
                                         gchar** suggs,
                                         gint suggs_length1,
                                         gint* result_length1);
VALA_EXTERN gchar** enchant_dict_suggest (EnchantDict* self,
                              const gchar* word_buf,
                              ssize_t len,
                              size_t* out_n_suggs);
VALA_EXTERN void enchant_dict_add (EnchantDict* self,
                       const gchar* word_buf,
                       ssize_t len);
VALA_EXTERN void enchant_dict_add_to_session (EnchantDict* self,
                                  const gchar* word_buf,
                                  ssize_t len);
VALA_EXTERN void enchant_pwl_add (EnchantPWL* self,
                      const gchar* word_buf,
                      ssize_t len);
VALA_EXTERN void enchant_pwl_remove (EnchantPWL* self,
                         const gchar* word_buf,
                         ssize_t len);
VALA_EXTERN void enchant_session_add (EnchantSession* self,
                          const gchar* word);
VALA_EXTERN gint enchant_dict_is_added (EnchantDict* self,
                            const gchar* word_buf,
                            ssize_t len);
VALA_EXTERN void enchant_dict_remove (EnchantDict* self,
                          const gchar* word_buf,
                          ssize_t len);
VALA_EXTERN void enchant_dict_remove_from_session (EnchantDict* self,
                                       const gchar* word_buf,
                                       ssize_t len);
VALA_EXTERN void enchant_session_remove (EnchantSession* self,
                             const gchar* word);
VALA_EXTERN gint enchant_dict_is_removed (EnchantDict* self,
                              const gchar* word_buf,
                              ssize_t len);
VALA_EXTERN void enchant_dict_store_replacement (EnchantDict* self,
                                     const gchar* mis,
                                     ssize_t mis_len,
                                     const gchar* cor,
                                     ssize_t cor_len);
VALA_EXTERN void enchant_dict_free_string_list (EnchantDict* self,
                                    gchar** string_list);
VALA_EXTERN void enchant_dict_describe (EnchantDict* self,
                            EnchantDictDescribeFn fn,
                            void* user_data);
VALA_EXTERN EnchantDict* enchant_dict_new (void);
VALA_EXTERN EnchantDict* enchant_dict_construct (GType object_type);
static void enchant_dict_finalize (EnchantDict * obj);
static GType enchant_dict_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

const gchar*
enchant_dict_get_extra_word_characters (EnchantDict* self)
{
	const gchar* _tmp0_ = NULL;
	DictGetExtraWordCharacters _tmp1_;
	const gchar* result;
#line 62 "dict.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 63 "dict.vala"
	_tmp1_ = self->get_extra_word_characters_method;
#line 63 "dict.vala"
	if (_tmp1_ != NULL) {
#line 330 "dict.c"
		DictGetExtraWordCharacters _tmp2_;
		const gchar* _tmp3_;
#line 64 "dict.vala"
		_tmp2_ = self->get_extra_word_characters_method;
#line 64 "dict.vala"
		_tmp3_ = _tmp2_ (self);
#line 64 "dict.vala"
		_tmp0_ = _tmp3_;
#line 339 "dict.c"
	} else {
#line 64 "dict.vala"
		_tmp0_ = "";
#line 343 "dict.c"
	}
#line 63 "dict.vala"
	result = _tmp0_;
#line 63 "dict.vala"
	return result;
#line 349 "dict.c"
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
#line 1262 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0U);
#line 1263 "glib-2.0.vapi"
	result = g_utf8_get_char (((gchar*) self) + index);
#line 1263 "glib-2.0.vapi"
	return result;
#line 363 "dict.c"
}

gint
enchant_dict_is_word_character (EnchantDict* _self_,
                                guint32 uc_in,
                                size_t n)
{
	gboolean _tmp0_ = FALSE;
	gunichar uc = 0U;
	gboolean _tmp3_ = FALSE;
	GUnicodeType type = 0;
	gint result;
#line 67 "dict.vala"
	_vala_return_val_if_fail (n <= ((size_t) 2), "n <= 2", 0);
#line 70 "dict.vala"
	if (_self_ != NULL) {
#line 380 "dict.c"
		DictIsWordCharacter _tmp1_;
#line 70 "dict.vala"
		_tmp1_ = _self_->is_word_character_method;
#line 70 "dict.vala"
		_tmp0_ = _tmp1_ != NULL;
#line 386 "dict.c"
	} else {
#line 70 "dict.vala"
		_tmp0_ = FALSE;
#line 390 "dict.c"
	}
#line 70 "dict.vala"
	if (_tmp0_) {
#line 394 "dict.c"
		DictIsWordCharacter _tmp2_;
#line 71 "dict.vala"
		_tmp2_ = _self_->is_word_character_method;
#line 71 "dict.vala"
		result = _tmp2_ (_self_, uc_in, n);
#line 71 "dict.vala"
		return result;
#line 402 "dict.c"
	}
#line 73 "dict.vala"
	uc = (gunichar) uc_in;
#line 76 "dict.vala"
	if (uc == string_get_char ("'", (glong) 0)) {
#line 76 "dict.vala"
		_tmp3_ = TRUE;
#line 410 "dict.c"
	} else {
#line 76 "dict.vala"
		_tmp3_ = uc == string_get_char ("’", (glong) 0);
#line 414 "dict.c"
	}
#line 76 "dict.vala"
	if (_tmp3_) {
#line 418 "dict.c"
		gint _tmp4_ = 0;
#line 77 "dict.vala"
		if (n < ((size_t) 2)) {
#line 77 "dict.vala"
			_tmp4_ = 1;
#line 424 "dict.c"
		} else {
#line 77 "dict.vala"
			_tmp4_ = 0;
#line 428 "dict.c"
		}
#line 77 "dict.vala"
		result = _tmp4_;
#line 77 "dict.vala"
		return result;
#line 434 "dict.c"
	}
#line 79 "dict.vala"
	type = g_unichar_type (uc);
#line 81 "dict.vala"
	switch (type) {
#line 81 "dict.vala"
		case G_UNICODE_MODIFIER_LETTER:
#line 81 "dict.vala"
		case G_UNICODE_LOWERCASE_LETTER:
#line 81 "dict.vala"
		case G_UNICODE_TITLECASE_LETTER:
#line 81 "dict.vala"
		case G_UNICODE_UPPERCASE_LETTER:
#line 81 "dict.vala"
		case G_UNICODE_OTHER_LETTER:
#line 81 "dict.vala"
		case G_UNICODE_COMBINING_MARK:
#line 81 "dict.vala"
		case G_UNICODE_ENCLOSING_MARK:
#line 81 "dict.vala"
		case G_UNICODE_NON_SPACING_MARK:
#line 81 "dict.vala"
		case G_UNICODE_DECIMAL_NUMBER:
#line 81 "dict.vala"
		case G_UNICODE_LETTER_NUMBER:
#line 81 "dict.vala"
		case G_UNICODE_OTHER_NUMBER:
#line 81 "dict.vala"
		case G_UNICODE_CONNECT_PUNCTUATION:
#line 464 "dict.c"
		{
#line 94 "dict.vala"
			result = 1;
#line 94 "dict.vala"
			return result;
#line 470 "dict.c"
		}
#line 81 "dict.vala"
		case G_UNICODE_DASH_PUNCTUATION:
#line 474 "dict.c"
		{
			gboolean _tmp5_ = FALSE;
#line 97 "dict.vala"
			if (n == ((size_t) 1)) {
#line 97 "dict.vala"
				_tmp5_ = type == G_UNICODE_DASH_PUNCTUATION;
#line 481 "dict.c"
			} else {
#line 97 "dict.vala"
				_tmp5_ = FALSE;
#line 485 "dict.c"
			}
#line 97 "dict.vala"
			if (_tmp5_) {
#line 98 "dict.vala"
				result = 1;
#line 98 "dict.vala"
				return result;
#line 493 "dict.c"
			}
#line 99 "dict.vala"
			result = 0;
#line 99 "dict.vala"
			return result;
#line 499 "dict.c"
		}
		default:
#line 81 "dict.vala"
		case G_UNICODE_CONTROL:
#line 81 "dict.vala"
		case G_UNICODE_FORMAT:
#line 81 "dict.vala"
		case G_UNICODE_UNASSIGNED:
#line 81 "dict.vala"
		case G_UNICODE_PRIVATE_USE:
#line 81 "dict.vala"
		case G_UNICODE_SURROGATE:
#line 81 "dict.vala"
		case G_UNICODE_CLOSE_PUNCTUATION:
#line 81 "dict.vala"
		case G_UNICODE_FINAL_PUNCTUATION:
#line 81 "dict.vala"
		case G_UNICODE_INITIAL_PUNCTUATION:
#line 81 "dict.vala"
		case G_UNICODE_OTHER_PUNCTUATION:
#line 81 "dict.vala"
		case G_UNICODE_OPEN_PUNCTUATION:
#line 81 "dict.vala"
		case G_UNICODE_CURRENCY_SYMBOL:
#line 81 "dict.vala"
		case G_UNICODE_MODIFIER_SYMBOL:
#line 81 "dict.vala"
		case G_UNICODE_MATH_SYMBOL:
#line 81 "dict.vala"
		case G_UNICODE_OTHER_SYMBOL:
#line 81 "dict.vala"
		case G_UNICODE_LINE_SEPARATOR:
#line 81 "dict.vala"
		case G_UNICODE_PARAGRAPH_SEPARATOR:
#line 81 "dict.vala"
		case G_UNICODE_SPACE_SEPARATOR:
#line 536 "dict.c"
		{
#line 119 "dict.vala"
			result = 0;
#line 119 "dict.vala"
			return result;
#line 542 "dict.c"
		}
	}
}

void
enchant_dict_set_error (EnchantDict* self,
                        const gchar* err)
{
	EnchantSession* _tmp0_;
	EnchantSession* _tmp1_;
	gchar* _tmp2_;
#line 123 "dict.vala"
	g_return_if_fail (self != NULL);
#line 123 "dict.vala"
	g_return_if_fail (err != NULL);
#line 124 "dict.vala"
	_tmp0_ = self->session;
#line 124 "dict.vala"
	enchant_session_clear_error (_tmp0_);
#line 125 "dict.vala"
	g_debug ("dict.vala:125: enchant_dict_set_error: %s", err);
#line 126 "dict.vala"
	_tmp1_ = self->session;
#line 126 "dict.vala"
	_tmp2_ = g_strdup (err);
#line 126 "dict.vala"
	_g_free0 (_tmp1_->error);
#line 126 "dict.vala"
	_tmp1_->error = _tmp2_;
#line 572 "dict.c"
}

const gchar*
enchant_dict_get_error (EnchantDict* self)
{
	EnchantSession* _tmp0_;
	const gchar* _tmp1_;
	const gchar* result;
#line 129 "dict.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 130 "dict.vala"
	_tmp0_ = self->session;
#line 130 "dict.vala"
	_tmp1_ = _tmp0_->error;
#line 130 "dict.vala"
	result = _tmp1_;
#line 130 "dict.vala"
	return result;
#line 591 "dict.c"
}

gint
enchant_dict_check (EnchantDict* _self_,
                    const gchar* word_buf,
                    ssize_t len)
{
	gboolean _tmp0_ = FALSE;
	gchar* word = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	EnchantSession* _tmp3_;
	EnchantSession* _tmp4_;
	const gchar* _tmp5_;
	EnchantSession* _tmp6_;
	const gchar* _tmp7_;
	DictCheck _tmp8_;
	gint result;
#line 137 "dict.vala"
	if (_self_ == NULL) {
#line 137 "dict.vala"
		_tmp0_ = TRUE;
#line 614 "dict.c"
	} else {
#line 137 "dict.vala"
		_tmp0_ = word_buf == NULL;
#line 618 "dict.c"
	}
#line 137 "dict.vala"
	if (_tmp0_) {
#line 138 "dict.vala"
		result = -1;
#line 138 "dict.vala"
		return result;
#line 626 "dict.c"
	}
#line 139 "dict.vala"
	_tmp1_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 139 "dict.vala"
	word = _tmp1_;
#line 140 "dict.vala"
	_tmp2_ = word;
#line 140 "dict.vala"
	if (_tmp2_ == NULL) {
#line 141 "dict.vala"
		result = -1;
#line 141 "dict.vala"
		_g_free0 (word);
#line 141 "dict.vala"
		return result;
#line 642 "dict.c"
	}
#line 143 "dict.vala"
	_tmp3_ = _self_->session;
#line 143 "dict.vala"
	enchant_session_clear_error (_tmp3_);
#line 146 "dict.vala"
	_tmp4_ = _self_->session;
#line 146 "dict.vala"
	_tmp5_ = word;
#line 146 "dict.vala"
	if (enchant_session_exclude (_tmp4_, _tmp5_)) {
#line 147 "dict.vala"
		result = 1;
#line 147 "dict.vala"
		_g_free0 (word);
#line 147 "dict.vala"
		return result;
#line 660 "dict.c"
	}
#line 150 "dict.vala"
	_tmp6_ = _self_->session;
#line 150 "dict.vala"
	_tmp7_ = word;
#line 150 "dict.vala"
	if (enchant_session_contains (_tmp6_, _tmp7_)) {
#line 151 "dict.vala"
		result = 0;
#line 151 "dict.vala"
		_g_free0 (word);
#line 151 "dict.vala"
		return result;
#line 674 "dict.c"
	}
#line 153 "dict.vala"
	_tmp8_ = _self_->check_method;
#line 153 "dict.vala"
	if (_tmp8_ != NULL) {
#line 680 "dict.c"
		DictCheck _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
#line 154 "dict.vala"
		_tmp9_ = _self_->check_method;
#line 154 "dict.vala"
		_tmp10_ = word;
#line 154 "dict.vala"
		_tmp11_ = word;
#line 154 "dict.vala"
		_tmp12_ = strlen (_tmp11_);
#line 154 "dict.vala"
		_tmp13_ = _tmp12_;
#line 154 "dict.vala"
		result = _tmp9_ (_self_, _tmp10_, (size_t) _tmp13_);
#line 154 "dict.vala"
		_g_free0 (word);
#line 154 "dict.vala"
		return result;
#line 702 "dict.c"
	} else {
		EnchantSession* _tmp14_;
#line 155 "dict.vala"
		_tmp14_ = _self_->session;
#line 155 "dict.vala"
		if (_tmp14_->is_pwl) {
#line 156 "dict.vala"
			result = 1;
#line 156 "dict.vala"
			_g_free0 (word);
#line 156 "dict.vala"
			return result;
#line 715 "dict.c"
		}
	}
#line 158 "dict.vala"
	result = -1;
#line 158 "dict.vala"
	_g_free0 (word);
#line 158 "dict.vala"
	return result;
#line 724 "dict.c"
}

static gchar**
enchant_dict_filter_suggestions (EnchantDict* self,
                                 gchar** suggs,
                                 gint suggs_length1,
                                 gint* result_length1)
{
	GStrvBuilder* sb = NULL;
	GStrvBuilder* _tmp0_;
	GStrvBuilder* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar** result;
#line 163 "dict.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 164 "dict.vala"
	_tmp0_ = g_strv_builder_new ();
#line 164 "dict.vala"
	sb = _tmp0_;
#line 747 "dict.c"
	{
		gchar** sugg_collection = NULL;
		gint sugg_collection_length1 = 0;
		gint _sugg_collection_size_ = 0;
		gint sugg_it = 0;
#line 165 "dict.vala"
		sugg_collection = suggs;
#line 165 "dict.vala"
		sugg_collection_length1 = suggs_length1;
#line 165 "dict.vala"
		for (sugg_it = 0; sugg_it < sugg_collection_length1; sugg_it = sugg_it + 1) {
#line 759 "dict.c"
			gchar* _tmp1_;
			gchar* sugg = NULL;
#line 165 "dict.vala"
			_tmp1_ = g_strdup (sugg_collection[sugg_it]);
#line 165 "dict.vala"
			sugg = _tmp1_;
#line 766 "dict.c"
			{
				gboolean _tmp2_ = FALSE;
				const gchar* _tmp3_;
#line 166 "dict.vala"
				_tmp3_ = sugg;
#line 166 "dict.vala"
				if (g_utf8_validate (_tmp3_, (gssize) -1, NULL)) {
#line 774 "dict.c"
					EnchantSession* _tmp4_;
					const gchar* _tmp5_;
#line 166 "dict.vala"
					_tmp4_ = self->session;
#line 166 "dict.vala"
					_tmp5_ = sugg;
#line 166 "dict.vala"
					_tmp2_ = !enchant_session_exclude (_tmp4_, _tmp5_);
#line 783 "dict.c"
				} else {
#line 166 "dict.vala"
					_tmp2_ = FALSE;
#line 787 "dict.c"
				}
#line 166 "dict.vala"
				if (_tmp2_) {
#line 791 "dict.c"
					GStrvBuilder* _tmp6_;
					const gchar* _tmp7_;
#line 167 "dict.vala"
					_tmp6_ = sb;
#line 167 "dict.vala"
					_tmp7_ = sugg;
#line 167 "dict.vala"
					g_strv_builder_add (_tmp6_, _tmp7_);
#line 800 "dict.c"
				}
#line 165 "dict.vala"
				_g_free0 (sugg);
#line 804 "dict.c"
			}
		}
	}
#line 169 "dict.vala"
	_tmp8_ = sb;
#line 169 "dict.vala"
	_tmp10_ = _tmp9_ = g_strv_builder_end (_tmp8_);
#line 169 "dict.vala"
	_tmp11_ = _tmp10_;
#line 169 "dict.vala"
	_tmp11__length1 = _vala_array_length (_tmp9_);
#line 169 "dict.vala"
	if (result_length1) {
#line 169 "dict.vala"
		*result_length1 = _tmp11__length1;
#line 820 "dict.c"
	}
#line 169 "dict.vala"
	result = _tmp11_;
#line 169 "dict.vala"
	_g_strv_builder_unref0 (sb);
#line 169 "dict.vala"
	return result;
#line 828 "dict.c"
}

gchar**
enchant_dict_suggest (EnchantDict* self,
                      const gchar* word_buf,
                      ssize_t len,
                      size_t* out_n_suggs)
{
	gchar* word = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	EnchantSession* _tmp2_;
	gchar** dict_suggs = NULL;
	gint dict_suggs_length1;
	gint _dict_suggs_size_;
	DictSuggest _tmp3_;
	gchar** result;
#line 173 "dict.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 173 "dict.vala"
	g_return_val_if_fail (word_buf != NULL, NULL);
#line 174 "dict.vala"
	_tmp0_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 174 "dict.vala"
	word = _tmp0_;
#line 175 "dict.vala"
	_tmp1_ = word;
#line 175 "dict.vala"
	if (_tmp1_ == NULL) {
#line 176 "dict.vala"
		result = NULL;
#line 176 "dict.vala"
		_g_free0 (word);
#line 176 "dict.vala"
		return result;
#line 864 "dict.c"
	}
#line 178 "dict.vala"
	_tmp2_ = self->session;
#line 178 "dict.vala"
	enchant_session_clear_error (_tmp2_);
#line 181 "dict.vala"
	dict_suggs = NULL;
#line 181 "dict.vala"
	dict_suggs_length1 = 0;
#line 181 "dict.vala"
	_dict_suggs_size_ = dict_suggs_length1;
#line 182 "dict.vala"
	_tmp3_ = self->suggest_method;
#line 182 "dict.vala"
	if (_tmp3_ != NULL) {
#line 880 "dict.c"
		DictSuggest _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		size_t _tmp9_ = 0;
		gchar** _tmp10_;
		gchar** _tmp11_;
		gint _tmp11__length1;
#line 183 "dict.vala"
		_tmp4_ = self->suggest_method;
#line 183 "dict.vala"
		_tmp5_ = word;
#line 183 "dict.vala"
		_tmp6_ = word;
#line 183 "dict.vala"
		_tmp7_ = strlen (_tmp6_);
#line 183 "dict.vala"
		_tmp8_ = _tmp7_;
#line 183 "dict.vala"
		_tmp10_ = _tmp4_ (self, _tmp5_, (size_t) _tmp8_, &_tmp9_);
#line 183 "dict.vala"
		dict_suggs = (_vala_array_free (dict_suggs, dict_suggs_length1, (GDestroyNotify) g_free), NULL);
#line 183 "dict.vala"
		dict_suggs = _tmp10_;
#line 183 "dict.vala"
		dict_suggs_length1 = _tmp9_;
#line 183 "dict.vala"
		_dict_suggs_size_ = dict_suggs_length1;
#line 184 "dict.vala"
		_tmp11_ = dict_suggs;
#line 184 "dict.vala"
		_tmp11__length1 = dict_suggs_length1;
#line 184 "dict.vala"
		if (_tmp11_ != NULL) {
#line 916 "dict.c"
			gchar** _tmp12_;
			gint _tmp12__length1;
			gint _tmp13_ = 0;
			gchar** _tmp14_;
			gchar** _tmp15_;
			gint _tmp15__length1;
#line 185 "dict.vala"
			_tmp12_ = dict_suggs;
#line 185 "dict.vala"
			_tmp12__length1 = dict_suggs_length1;
#line 185 "dict.vala"
			_tmp14_ = enchant_dict_filter_suggestions (self, _tmp12_, (gint) _tmp12__length1, &_tmp13_);
#line 185 "dict.vala"
			dict_suggs = (_vala_array_free (dict_suggs, dict_suggs_length1, (GDestroyNotify) g_free), NULL);
#line 185 "dict.vala"
			dict_suggs = _tmp14_;
#line 185 "dict.vala"
			dict_suggs_length1 = _tmp13_;
#line 185 "dict.vala"
			_dict_suggs_size_ = dict_suggs_length1;
#line 186 "dict.vala"
			_tmp15_ = dict_suggs;
#line 186 "dict.vala"
			_tmp15__length1 = dict_suggs_length1;
#line 186 "dict.vala"
			if (_tmp15__length1 == 0) {
#line 187 "dict.vala"
				dict_suggs = (_vala_array_free (dict_suggs, dict_suggs_length1, (GDestroyNotify) g_free), NULL);
#line 187 "dict.vala"
				dict_suggs = NULL;
#line 187 "dict.vala"
				dict_suggs_length1 = 0;
#line 187 "dict.vala"
				_dict_suggs_size_ = dict_suggs_length1;
#line 951 "dict.c"
			}
		}
	}
#line 191 "dict.vala"
	if (out_n_suggs != NULL) {
#line 957 "dict.c"
		gint _tmp16_ = 0;
		gchar** _tmp17_;
		gint _tmp17__length1;
#line 192 "dict.vala"
		_tmp17_ = dict_suggs;
#line 192 "dict.vala"
		_tmp17__length1 = dict_suggs_length1;
#line 192 "dict.vala"
		if (_tmp17_ != NULL) {
#line 967 "dict.c"
			gchar** _tmp18_;
			gint _tmp18__length1;
#line 192 "dict.vala"
			_tmp18_ = dict_suggs;
#line 192 "dict.vala"
			_tmp18__length1 = dict_suggs_length1;
#line 192 "dict.vala"
			_tmp16_ = _tmp18__length1;
#line 976 "dict.c"
		} else {
#line 192 "dict.vala"
			_tmp16_ = 0;
#line 980 "dict.c"
		}
#line 192 "dict.vala"
		*out_n_suggs = (size_t) _tmp16_;
#line 984 "dict.c"
	}
#line 194 "dict.vala"
	result = dict_suggs;
#line 194 "dict.vala"
	_g_free0 (word);
#line 194 "dict.vala"
	return result;
#line 992 "dict.c"
}

void
enchant_dict_add (EnchantDict* self,
                  const gchar* word_buf,
                  ssize_t len)
{
	EnchantSession* _tmp0_;
	EnchantPWL* _tmp1_;
	EnchantSession* _tmp2_;
	EnchantPWL* _tmp3_;
#line 197 "dict.vala"
	g_return_if_fail (self != NULL);
#line 197 "dict.vala"
	g_return_if_fail (word_buf != NULL);
#line 198 "dict.vala"
	enchant_dict_add_to_session (self, word_buf, len);
#line 199 "dict.vala"
	_tmp0_ = self->session;
#line 199 "dict.vala"
	_tmp1_ = _tmp0_->pwl;
#line 199 "dict.vala"
	enchant_pwl_add (_tmp1_, word_buf, len);
#line 200 "dict.vala"
	_tmp2_ = self->session;
#line 200 "dict.vala"
	_tmp3_ = _tmp2_->exclude_pwl;
#line 200 "dict.vala"
	enchant_pwl_remove (_tmp3_, word_buf, len);
#line 1022 "dict.c"
}

void
enchant_dict_add_to_session (EnchantDict* self,
                             const gchar* word_buf,
                             ssize_t len)
{
	gchar* word = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	EnchantSession* _tmp2_;
	EnchantSession* _tmp3_;
	const gchar* _tmp4_;
	DictAddToSession _tmp5_;
#line 203 "dict.vala"
	g_return_if_fail (self != NULL);
#line 203 "dict.vala"
	g_return_if_fail (word_buf != NULL);
#line 204 "dict.vala"
	_tmp0_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 204 "dict.vala"
	word = _tmp0_;
#line 205 "dict.vala"
	_tmp1_ = word;
#line 205 "dict.vala"
	if (_tmp1_ == NULL) {
#line 206 "dict.vala"
		_g_free0 (word);
#line 206 "dict.vala"
		return;
#line 1053 "dict.c"
	}
#line 207 "dict.vala"
	_tmp2_ = self->session;
#line 207 "dict.vala"
	enchant_session_clear_error (_tmp2_);
#line 208 "dict.vala"
	_tmp3_ = self->session;
#line 208 "dict.vala"
	_tmp4_ = word;
#line 208 "dict.vala"
	enchant_session_add (_tmp3_, _tmp4_);
#line 209 "dict.vala"
	_tmp5_ = self->add_to_session_method;
#line 209 "dict.vala"
	if (_tmp5_ != NULL) {
#line 1069 "dict.c"
		DictAddToSession _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
#line 210 "dict.vala"
		_tmp6_ = self->add_to_session_method;
#line 210 "dict.vala"
		_tmp7_ = word;
#line 210 "dict.vala"
		_tmp8_ = word;
#line 210 "dict.vala"
		_tmp9_ = strlen (_tmp8_);
#line 210 "dict.vala"
		_tmp10_ = _tmp9_;
#line 210 "dict.vala"
		_tmp6_ (self, _tmp7_, (size_t) _tmp10_);
#line 1087 "dict.c"
	}
#line 203 "dict.vala"
	_g_free0 (word);
#line 1091 "dict.c"
}

gint
enchant_dict_is_added (EnchantDict* self,
                       const gchar* word_buf,
                       ssize_t len)
{
	gchar* word = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	EnchantSession* _tmp2_;
	gint _tmp3_ = 0;
	EnchantSession* _tmp4_;
	const gchar* _tmp5_;
	gint result;
#line 213 "dict.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 213 "dict.vala"
	g_return_val_if_fail (word_buf != NULL, 0);
#line 214 "dict.vala"
	_tmp0_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 214 "dict.vala"
	word = _tmp0_;
#line 215 "dict.vala"
	_tmp1_ = word;
#line 215 "dict.vala"
	if (_tmp1_ == NULL) {
#line 216 "dict.vala"
		result = 0;
#line 216 "dict.vala"
		_g_free0 (word);
#line 216 "dict.vala"
		return result;
#line 1125 "dict.c"
	}
#line 217 "dict.vala"
	_tmp2_ = self->session;
#line 217 "dict.vala"
	enchant_session_clear_error (_tmp2_);
#line 218 "dict.vala"
	_tmp4_ = self->session;
#line 218 "dict.vala"
	_tmp5_ = word;
#line 218 "dict.vala"
	if (enchant_session_contains (_tmp4_, _tmp5_)) {
#line 218 "dict.vala"
		_tmp3_ = 1;
#line 1139 "dict.c"
	} else {
#line 218 "dict.vala"
		_tmp3_ = 0;
#line 1143 "dict.c"
	}
#line 218 "dict.vala"
	result = _tmp3_;
#line 218 "dict.vala"
	_g_free0 (word);
#line 218 "dict.vala"
	return result;
#line 1151 "dict.c"
}

void
enchant_dict_remove (EnchantDict* self,
                     const gchar* word_buf,
                     ssize_t len)
{
	EnchantSession* _tmp0_;
	EnchantPWL* _tmp1_;
	EnchantSession* _tmp2_;
	EnchantPWL* _tmp3_;
#line 221 "dict.vala"
	g_return_if_fail (self != NULL);
#line 221 "dict.vala"
	g_return_if_fail (word_buf != NULL);
#line 222 "dict.vala"
	enchant_dict_remove_from_session (self, word_buf, len);
#line 223 "dict.vala"
	_tmp0_ = self->session;
#line 223 "dict.vala"
	_tmp1_ = _tmp0_->pwl;
#line 223 "dict.vala"
	enchant_pwl_remove (_tmp1_, word_buf, len);
#line 224 "dict.vala"
	_tmp2_ = self->session;
#line 224 "dict.vala"
	_tmp3_ = _tmp2_->exclude_pwl;
#line 224 "dict.vala"
	enchant_pwl_add (_tmp3_, word_buf, len);
#line 1181 "dict.c"
}

void
enchant_dict_remove_from_session (EnchantDict* self,
                                  const gchar* word_buf,
                                  ssize_t len)
{
	gchar* word = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	EnchantSession* _tmp2_;
	EnchantSession* _tmp3_;
	const gchar* _tmp4_;
	DictRemoveFromSession _tmp5_;
#line 227 "dict.vala"
	g_return_if_fail (self != NULL);
#line 227 "dict.vala"
	g_return_if_fail (word_buf != NULL);
#line 228 "dict.vala"
	_tmp0_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 228 "dict.vala"
	word = _tmp0_;
#line 229 "dict.vala"
	_tmp1_ = word;
#line 229 "dict.vala"
	if (_tmp1_ == NULL) {
#line 230 "dict.vala"
		_g_free0 (word);
#line 230 "dict.vala"
		return;
#line 1212 "dict.c"
	}
#line 231 "dict.vala"
	_tmp2_ = self->session;
#line 231 "dict.vala"
	enchant_session_clear_error (_tmp2_);
#line 232 "dict.vala"
	_tmp3_ = self->session;
#line 232 "dict.vala"
	_tmp4_ = word;
#line 232 "dict.vala"
	enchant_session_remove (_tmp3_, _tmp4_);
#line 233 "dict.vala"
	_tmp5_ = self->remove_from_session_method;
#line 233 "dict.vala"
	if (_tmp5_ != NULL) {
#line 1228 "dict.c"
		DictRemoveFromSession _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
#line 234 "dict.vala"
		_tmp6_ = self->remove_from_session_method;
#line 234 "dict.vala"
		_tmp7_ = word;
#line 234 "dict.vala"
		_tmp8_ = word;
#line 234 "dict.vala"
		_tmp9_ = strlen (_tmp8_);
#line 234 "dict.vala"
		_tmp10_ = _tmp9_;
#line 234 "dict.vala"
		_tmp6_ (self, _tmp7_, (size_t) _tmp10_);
#line 1246 "dict.c"
	}
#line 227 "dict.vala"
	_g_free0 (word);
#line 1250 "dict.c"
}

gint
enchant_dict_is_removed (EnchantDict* self,
                         const gchar* word_buf,
                         ssize_t len)
{
	gchar* word = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	EnchantSession* _tmp2_;
	gint _tmp3_ = 0;
	EnchantSession* _tmp4_;
	const gchar* _tmp5_;
	gint result;
#line 237 "dict.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 237 "dict.vala"
	g_return_val_if_fail (word_buf != NULL, 0);
#line 238 "dict.vala"
	_tmp0_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 238 "dict.vala"
	word = _tmp0_;
#line 239 "dict.vala"
	_tmp1_ = word;
#line 239 "dict.vala"
	if (_tmp1_ == NULL) {
#line 240 "dict.vala"
		result = 0;
#line 240 "dict.vala"
		_g_free0 (word);
#line 240 "dict.vala"
		return result;
#line 1284 "dict.c"
	}
#line 241 "dict.vala"
	_tmp2_ = self->session;
#line 241 "dict.vala"
	enchant_session_clear_error (_tmp2_);
#line 242 "dict.vala"
	_tmp4_ = self->session;
#line 242 "dict.vala"
	_tmp5_ = word;
#line 242 "dict.vala"
	if (enchant_session_exclude (_tmp4_, _tmp5_)) {
#line 242 "dict.vala"
		_tmp3_ = 1;
#line 1298 "dict.c"
	} else {
#line 242 "dict.vala"
		_tmp3_ = 0;
#line 1302 "dict.c"
	}
#line 242 "dict.vala"
	result = _tmp3_;
#line 242 "dict.vala"
	_g_free0 (word);
#line 242 "dict.vala"
	return result;
#line 1310 "dict.c"
}

void
enchant_dict_store_replacement (EnchantDict* self,
                                const gchar* mis,
                                ssize_t mis_len,
                                const gchar* cor,
                                ssize_t cor_len)
{
#line 246 "dict.vala"
	g_return_if_fail (self != NULL);
#line 246 "dict.vala"
	g_return_if_fail (mis != NULL);
#line 246 "dict.vala"
	g_return_if_fail (cor != NULL);
#line 1326 "dict.c"
}

void
enchant_dict_free_string_list (EnchantDict* self,
                               gchar** string_list)
{
	EnchantSession* _tmp0_;
	gchar** _tmp1_;
#line 249 "dict.vala"
	g_return_if_fail (self != NULL);
#line 250 "dict.vala"
	_tmp0_ = self->session;
#line 250 "dict.vala"
	enchant_session_clear_error (_tmp0_);
#line 251 "dict.vala"
	_tmp1_ = string_list;
#line 251 "dict.vala"
	string_list = NULL;
#line 251 "dict.vala"
	g_strfreev ((gchar**) _tmp1_);
#line 1347 "dict.c"
}

void
enchant_dict_describe (EnchantDict* self,
                       EnchantDictDescribeFn fn,
                       void* user_data)
{
	EnchantSession* _tmp0_;
	EnchantProvider* provider = NULL;
	EnchantSession* _tmp1_;
	EnchantProvider* _tmp2_;
	gchar* name = NULL;
	gchar* desc = NULL;
	gchar* file = NULL;
	EnchantProvider* _tmp3_;
	gchar* tag = NULL;
	EnchantSession* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
#line 254 "dict.vala"
	g_return_if_fail (self != NULL);
#line 254 "dict.vala"
	_vala_return_if_fail (fn != NULL, "fn != null");
#line 257 "dict.vala"
	_tmp0_ = self->session;
#line 257 "dict.vala"
	enchant_session_clear_error (_tmp0_);
#line 258 "dict.vala"
	_tmp1_ = self->session;
#line 258 "dict.vala"
	_tmp2_ = _tmp1_->provider;
#line 258 "dict.vala"
	provider = _tmp2_;
#line 263 "dict.vala"
	_tmp3_ = provider;
#line 263 "dict.vala"
	if (_tmp3_ != NULL) {
#line 1388 "dict.c"
		EnchantProvider* _tmp4_;
		GModule* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		EnchantProvider* _tmp8_;
		ProviderIdentify _tmp9_;
		EnchantProvider* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		EnchantProvider* _tmp13_;
		ProviderDescribe _tmp14_;
		EnchantProvider* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
#line 264 "dict.vala"
		_tmp4_ = provider;
#line 264 "dict.vala"
		_tmp5_ = _tmp4_->module;
#line 264 "dict.vala"
		_tmp6_ = g_module_name (_tmp5_);
#line 264 "dict.vala"
		_tmp7_ = g_strdup (_tmp6_);
#line 264 "dict.vala"
		_g_free0 (file);
#line 264 "dict.vala"
		file = _tmp7_;
#line 265 "dict.vala"
		_tmp8_ = provider;
#line 265 "dict.vala"
		_tmp9_ = _tmp8_->identify;
#line 265 "dict.vala"
		_tmp10_ = provider;
#line 265 "dict.vala"
		_tmp11_ = _tmp9_ (_tmp10_);
#line 265 "dict.vala"
		_tmp12_ = g_strdup (_tmp11_);
#line 265 "dict.vala"
		_g_free0 (name);
#line 265 "dict.vala"
		name = _tmp12_;
#line 266 "dict.vala"
		_tmp13_ = provider;
#line 266 "dict.vala"
		_tmp14_ = _tmp13_->describe;
#line 266 "dict.vala"
		_tmp15_ = provider;
#line 266 "dict.vala"
		_tmp16_ = _tmp14_ (_tmp15_);
#line 266 "dict.vala"
		_tmp17_ = g_strdup (_tmp16_);
#line 266 "dict.vala"
		_g_free0 (desc);
#line 266 "dict.vala"
		desc = _tmp17_;
#line 1443 "dict.c"
	} else {
		EnchantSession* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
#line 268 "dict.vala"
		_tmp18_ = self->session;
#line 268 "dict.vala"
		_tmp19_ = _tmp18_->personal_filename;
#line 268 "dict.vala"
		_tmp20_ = g_strdup (_tmp19_);
#line 268 "dict.vala"
		_g_free0 (file);
#line 268 "dict.vala"
		file = _tmp20_;
#line 269 "dict.vala"
		_tmp21_ = g_strdup ("Personal Wordlist");
#line 269 "dict.vala"
		_g_free0 (name);
#line 269 "dict.vala"
		name = _tmp21_;
#line 270 "dict.vala"
		_tmp22_ = g_strdup ("Personal Wordlist");
#line 270 "dict.vala"
		_g_free0 (desc);
#line 270 "dict.vala"
		desc = _tmp22_;
#line 1472 "dict.c"
	}
#line 273 "dict.vala"
	_tmp23_ = self->session;
#line 273 "dict.vala"
	_tmp24_ = _tmp23_->language_tag;
#line 273 "dict.vala"
	_tmp25_ = g_strdup (_tmp24_);
#line 273 "dict.vala"
	tag = _tmp25_;
#line 274 "dict.vala"
	_tmp26_ = name;
#line 274 "dict.vala"
	_tmp27_ = desc;
#line 274 "dict.vala"
	_tmp28_ = file;
#line 274 "dict.vala"
	fn (tag, _tmp26_, _tmp27_, _tmp28_, user_data);
#line 254 "dict.vala"
	_g_free0 (tag);
#line 254 "dict.vala"
	_g_free0 (file);
#line 254 "dict.vala"
	_g_free0 (desc);
#line 254 "dict.vala"
	_g_free0 (name);
#line 1498 "dict.c"
}

EnchantDict*
enchant_dict_construct (GType object_type)
{
	EnchantDict* self = NULL;
#line 44 "dict.vala"
	self = (EnchantDict*) g_type_create_instance (object_type);
#line 44 "dict.vala"
	return self;
#line 1509 "dict.c"
}

EnchantDict*
enchant_dict_new (void)
{
#line 44 "dict.vala"
	return enchant_dict_construct (TYPE_ENCHANT_DICT);
#line 1517 "dict.c"
}

static void
value_enchant_dict_init (GValue* value)
{
#line 44 "dict.vala"
	value->data[0].v_pointer = NULL;
#line 1525 "dict.c"
}

static void
value_enchant_dict_free_value (GValue* value)
{
#line 44 "dict.vala"
	if (value->data[0].v_pointer) {
#line 44 "dict.vala"
		enchant_dict_unref (value->data[0].v_pointer);
#line 1535 "dict.c"
	}
}

static void
value_enchant_dict_copy_value (const GValue* src_value,
                               GValue* dest_value)
{
#line 44 "dict.vala"
	if (src_value->data[0].v_pointer) {
#line 44 "dict.vala"
		dest_value->data[0].v_pointer = enchant_dict_ref (src_value->data[0].v_pointer);
#line 1547 "dict.c"
	} else {
#line 44 "dict.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1551 "dict.c"
	}
}

static gpointer
value_enchant_dict_peek_pointer (const GValue* value)
{
#line 44 "dict.vala"
	return value->data[0].v_pointer;
#line 1560 "dict.c"
}

static gchar*
value_enchant_dict_collect_value (GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
#line 44 "dict.vala"
	if (collect_values[0].v_pointer) {
#line 1571 "dict.c"
		EnchantDict * object;
		object = collect_values[0].v_pointer;
#line 44 "dict.vala"
		if (object->parent_instance.g_class == NULL) {
#line 44 "dict.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1578 "dict.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 44 "dict.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1582 "dict.c"
		}
#line 44 "dict.vala"
		value->data[0].v_pointer = enchant_dict_ref (object);
#line 1586 "dict.c"
	} else {
#line 44 "dict.vala"
		value->data[0].v_pointer = NULL;
#line 1590 "dict.c"
	}
#line 44 "dict.vala"
	return NULL;
#line 1594 "dict.c"
}

static gchar*
value_enchant_dict_lcopy_value (const GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	EnchantDict ** object_p;
	object_p = collect_values[0].v_pointer;
#line 44 "dict.vala"
	if (!object_p) {
#line 44 "dict.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1609 "dict.c"
	}
#line 44 "dict.vala"
	if (!value->data[0].v_pointer) {
#line 44 "dict.vala"
		*object_p = NULL;
#line 1615 "dict.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 44 "dict.vala"
		*object_p = value->data[0].v_pointer;
#line 1619 "dict.c"
	} else {
#line 44 "dict.vala"
		*object_p = enchant_dict_ref (value->data[0].v_pointer);
#line 1623 "dict.c"
	}
#line 44 "dict.vala"
	return NULL;
#line 1627 "dict.c"
}

GParamSpec*
param_spec_enchant_dict (const gchar* name,
                         const gchar* nick,
                         const gchar* blurb,
                         GType object_type,
                         GParamFlags flags)
{
	ParamSpecEnchantDict* spec;
#line 44 "dict.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ENCHANT_DICT), NULL);
#line 44 "dict.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 44 "dict.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 44 "dict.vala"
	return G_PARAM_SPEC (spec);
#line 1646 "dict.c"
}

gpointer
value_get_enchant_dict (const GValue* value)
{
#line 44 "dict.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_DICT), NULL);
#line 44 "dict.vala"
	return value->data[0].v_pointer;
#line 1656 "dict.c"
}

void
value_set_enchant_dict (GValue* value,
                        gpointer v_object)
{
	EnchantDict * old;
#line 44 "dict.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_DICT));
#line 44 "dict.vala"
	old = value->data[0].v_pointer;
#line 44 "dict.vala"
	if (v_object) {
#line 44 "dict.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENCHANT_DICT));
#line 44 "dict.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 44 "dict.vala"
		value->data[0].v_pointer = v_object;
#line 44 "dict.vala"
		enchant_dict_ref (value->data[0].v_pointer);
#line 1678 "dict.c"
	} else {
#line 44 "dict.vala"
		value->data[0].v_pointer = NULL;
#line 1682 "dict.c"
	}
#line 44 "dict.vala"
	if (old) {
#line 44 "dict.vala"
		enchant_dict_unref (old);
#line 1688 "dict.c"
	}
}

void
value_take_enchant_dict (GValue* value,
                         gpointer v_object)
{
	EnchantDict * old;
#line 44 "dict.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_DICT));
#line 44 "dict.vala"
	old = value->data[0].v_pointer;
#line 44 "dict.vala"
	if (v_object) {
#line 44 "dict.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENCHANT_DICT));
#line 44 "dict.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 44 "dict.vala"
		value->data[0].v_pointer = v_object;
#line 1709 "dict.c"
	} else {
#line 44 "dict.vala"
		value->data[0].v_pointer = NULL;
#line 1713 "dict.c"
	}
#line 44 "dict.vala"
	if (old) {
#line 44 "dict.vala"
		enchant_dict_unref (old);
#line 1719 "dict.c"
	}
}

static void
enchant_dict_class_init (EnchantDictClass * klass,
                         gpointer klass_data)
{
#line 44 "dict.vala"
	enchant_dict_parent_class = g_type_class_peek_parent (klass);
#line 44 "dict.vala"
	((EnchantDictClass *) klass)->finalize = enchant_dict_finalize;
#line 1731 "dict.c"
}

static void
enchant_dict_instance_init (EnchantDict * self,
                            gpointer klass)
{
#line 44 "dict.vala"
	self->ref_count = 1;
#line 1740 "dict.c"
}

static void
enchant_dict_finalize (EnchantDict * obj)
{
	EnchantDict * self;
	EnchantProvider* owner = NULL;
	EnchantSession* _tmp0_;
	EnchantProvider* _tmp1_;
	EnchantProvider* _tmp2_;
#line 44 "dict.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ENCHANT_DICT, EnchantDict);
#line 44 "dict.vala"
	g_signal_handlers_destroy (self);
#line 57 "dict.vala"
	_tmp0_ = self->session;
#line 57 "dict.vala"
	_tmp1_ = _tmp0_->provider;
#line 57 "dict.vala"
	owner = _tmp1_;
#line 58 "dict.vala"
	_tmp2_ = owner;
#line 58 "dict.vala"
	if (_tmp2_ != NULL) {
#line 1765 "dict.c"
		EnchantProvider* _tmp3_;
		ProviderDisposeDict _tmp4_;
		EnchantProvider* _tmp5_;
#line 59 "dict.vala"
		_tmp3_ = owner;
#line 59 "dict.vala"
		_tmp4_ = _tmp3_->dispose_dict;
#line 59 "dict.vala"
		_tmp5_ = owner;
#line 59 "dict.vala"
		_tmp4_ (_tmp5_, self);
#line 1777 "dict.c"
	}
#line 46 "dict.vala"
	_enchant_session_unref0 (self->session);
#line 1781 "dict.c"
}

static GType
enchant_dict_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_enchant_dict_init, value_enchant_dict_free_value, value_enchant_dict_copy_value, value_enchant_dict_peek_pointer, "p", value_enchant_dict_collect_value, "p", value_enchant_dict_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (EnchantDictClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enchant_dict_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EnchantDict), 0, (GInstanceInitFunc) enchant_dict_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType enchant_dict_type_id;
	enchant_dict_type_id = g_type_register_fundamental (g_type_fundamental_next (), "EnchantDict", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return enchant_dict_type_id;
}

GType
enchant_dict_get_type (void)
{
	static volatile gsize enchant_dict_type_id__once = 0;
	if (g_once_init_enter (&enchant_dict_type_id__once)) {
		GType enchant_dict_type_id;
		enchant_dict_type_id = enchant_dict_get_type_once ();
		g_once_init_leave (&enchant_dict_type_id__once, enchant_dict_type_id);
	}
	return enchant_dict_type_id__once;
}

gpointer
enchant_dict_ref (gpointer instance)
{
	EnchantDict * self;
	self = instance;
#line 44 "dict.vala"
	g_atomic_int_inc (&self->ref_count);
#line 44 "dict.vala"
	return instance;
#line 1816 "dict.c"
}

void
enchant_dict_unref (gpointer instance)
{
	EnchantDict * self;
	self = instance;
#line 44 "dict.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 44 "dict.vala"
		ENCHANT_DICT_GET_CLASS (self)->finalize (self);
#line 44 "dict.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1830 "dict.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

