/* api.c generated by valac 0.56.0, the Vala compiler
 * generated from api.vala, do not modify */

/* enchant: miscellaneous public APIs
 * Copyright (C) 2003, 2004 Dom Lachowicz
 * Copyright (C) 2016-2024 Reuben Thomas <rrt@sc3d.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along along with this program; if not, see
 * <https://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders
 * give permission to link the code of this program with
 * non-LGPL Spelling Provider libraries (eg: a MSFT Office
 * spell checker backend) and distribute linked combinations including
 * the two.  You must obey the GNU Lesser General Public License in all
 * respects for all of the code used other than said providers.  If you modify
 * this file, you may extend this exception to your version of the
 * file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <relocatable.h>
#include <configmake.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

VALA_EXTERN void enchant_set_prefix_dir (const gchar* new_prefix);
VALA_EXTERN const gchar* enchant_get_version (void);
VALA_EXTERN gchar* enchant_get_user_language (void);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

void
enchant_set_prefix_dir (const gchar* new_prefix)
{
#line 33 "api.vala"
	g_return_if_fail (new_prefix != NULL);
#line 34 "api.vala"
	set_relocation_prefix (INSTALLPREFIX, new_prefix);
#line 75 "api.c"
}

const gchar*
enchant_get_version (void)
{
	const gchar* result;
#line 38 "api.vala"
	result = ENCHANT_VERSION_STRING;
#line 38 "api.vala"
	return result;
#line 86 "api.c"
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
#line 43 "api.vala"
	if (length >= 0) {
#line 95 "api.c"
		gchar** result;
		gssize i;
#line 43 "api.vala"
		result = g_new0 (gchar*, length + 1);
#line 43 "api.vala"
		for (i = 0; i < length; i++) {
#line 102 "api.c"
			gchar* _tmp0_;
#line 43 "api.vala"
			_tmp0_ = g_strdup (self[i]);
#line 43 "api.vala"
			result[i] = _tmp0_;
#line 108 "api.c"
		}
#line 43 "api.vala"
		return result;
#line 112 "api.c"
	}
#line 43 "api.vala"
	return NULL;
#line 116 "api.c"
}

gchar*
enchant_get_user_language (void)
{
	gchar** languages = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint languages_length1;
	gint _languages_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_ = NULL;
	gchar** _tmp5_;
	gint _tmp5__length1;
	const gchar* _tmp6_;
	gchar* _tmp9_;
	gchar* result;
#line 43 "api.vala"
	_tmp1_ = _tmp0_ = g_get_language_names ();
#line 43 "api.vala"
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup1 (_tmp1_, _vala_array_length (_tmp0_)) : _tmp1_;
#line 43 "api.vala"
	_tmp2__length1 = _vala_array_length (_tmp0_);
#line 43 "api.vala"
	languages = _tmp2_;
#line 43 "api.vala"
	languages_length1 = _tmp2__length1;
#line 43 "api.vala"
	_languages_size_ = languages_length1;
#line 44 "api.vala"
	_tmp3_ = languages;
#line 44 "api.vala"
	_tmp3__length1 = languages_length1;
#line 44 "api.vala"
	_vala_assert (_tmp3_ != NULL, "languages != null");
#line 46 "api.vala"
	_tmp5_ = languages;
#line 46 "api.vala"
	_tmp5__length1 = languages_length1;
#line 46 "api.vala"
	_tmp6_ = _tmp5_[0];
#line 46 "api.vala"
	if (g_strcmp0 (_tmp6_, "C") == 0) {
#line 46 "api.vala"
		_tmp4_ = "en";
#line 165 "api.c"
	} else {
		gchar** _tmp7_;
		gint _tmp7__length1;
		const gchar* _tmp8_;
#line 46 "api.vala"
		_tmp7_ = languages;
#line 46 "api.vala"
		_tmp7__length1 = languages_length1;
#line 46 "api.vala"
		_tmp8_ = _tmp7_[0];
#line 46 "api.vala"
		_tmp4_ = _tmp8_;
#line 178 "api.c"
	}
#line 46 "api.vala"
	_tmp9_ = g_strdup (_tmp4_);
#line 46 "api.vala"
	result = _tmp9_;
#line 46 "api.vala"
	languages = (_vala_array_free (languages, languages_length1, (GDestroyNotify) g_free), NULL);
#line 46 "api.vala"
	return result;
#line 188 "api.c"
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

