/* provider.c generated by valac 0.56.0, the Vala compiler
 * generated from provider.vala, do not modify */

/* enchant: Provider
 * Copyright (C) 2003, 2004 Dom Lachowicz
 * Copyright (C) 2016-2024 Reuben Thomas <rrt@sc3d.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along along with this program; if not, see
 * <https://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders
 * give permission to link the code of this program with
 * non-LGPL Spelling Provider libraries (eg: a MSFT Office
 * spell checker backend) and distribute linked combinations including
 * the two.  You must obey the GNU Lesser General Public License in all
 * respects for all of the code used other than said providers.  If you modify
 * this file, you may extend this exception to your version of the
 * file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <relocatable.h>
#include <configmake.h>
#include <glib-object.h>
#include <gmodule.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_ENCHANT_PROVIDER (enchant_provider_get_type ())
#define ENCHANT_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_PROVIDER, EnchantProvider))
#define ENCHANT_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_PROVIDER, EnchantProviderClass))
#define IS_ENCHANT_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_PROVIDER))
#define IS_ENCHANT_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_PROVIDER))
#define ENCHANT_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_PROVIDER, EnchantProviderClass))

typedef struct _EnchantProvider EnchantProvider;
typedef struct _EnchantProviderClass EnchantProviderClass;
typedef void (*ProviderDispose) (EnchantProvider* me);

#define TYPE_ENCHANT_DICT (enchant_dict_get_type ())
#define ENCHANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_DICT, EnchantDict))
#define ENCHANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_DICT, EnchantDictClass))
#define IS_ENCHANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_DICT))
#define IS_ENCHANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_DICT))
#define ENCHANT_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_DICT, EnchantDictClass))

typedef struct _EnchantDict EnchantDict;
typedef struct _EnchantDictClass EnchantDictClass;
typedef EnchantDict* (*ProviderRequestDict) (EnchantProvider* me, const gchar* tag);
typedef void (*ProviderDisposeDict) (EnchantProvider* me, EnchantDict* dict);
typedef gint (*ProviderDictionaryExists) (EnchantProvider* me, const gchar* tag);
typedef const gchar* (*ProviderIdentify) (EnchantProvider* me);
typedef const gchar* (*ProviderDescribe) (EnchantProvider* me);
typedef gchar** (*ProviderListDicts) (EnchantProvider* me, size_t* result_length1);
typedef struct _EnchantProviderPrivate EnchantProviderPrivate;
typedef struct _EnchantBroker EnchantBroker;
#define _g_module_close0(var) ((var == NULL) ? NULL : (var = (g_module_close (var), NULL)))
typedef struct _ParamSpecEnchantProvider ParamSpecEnchantProvider;

struct _EnchantProvider {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantProviderPrivate * priv;
	void* user_data;
	GModule* module;
	EnchantBroker* owner;
	ProviderDispose dispose;
	ProviderRequestDict request_dict;
	ProviderDisposeDict dispose_dict;
	ProviderDictionaryExists dictionary_exists;
	ProviderIdentify identify;
	ProviderDescribe describe;
	ProviderListDicts list_dicts;
};

struct _EnchantProviderClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantProvider *self);
};

struct _ParamSpecEnchantProvider {
	GParamSpec parent_instance;
};

static gpointer enchant_provider_parent_class = NULL;

VALA_EXTERN gchar* enchant_get_user_config_dir (void);
VALA_EXTERN GSList* enchant_get_conf_dirs (void);
VALA_EXTERN gchar* enchant_get_prefix_dir (void);
VALA_EXTERN gpointer enchant_provider_ref (gpointer instance);
VALA_EXTERN void enchant_provider_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_provider (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void value_set_enchant_provider (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void value_take_enchant_provider (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_provider (const GValue* value);
VALA_EXTERN GType enchant_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantProvider, enchant_provider_unref)
VALA_EXTERN gpointer enchant_dict_ref (gpointer instance);
VALA_EXTERN void enchant_dict_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_dict (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void value_set_enchant_dict (GValue* value,
                             gpointer v_object);
VALA_EXTERN void value_take_enchant_dict (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_dict (const GValue* value);
VALA_EXTERN GType enchant_dict_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantDict, enchant_dict_unref)
VALA_EXTERN void enchant_broker_free (EnchantBroker * self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantBroker, enchant_broker_free)
VALA_EXTERN gboolean enchant_provider_is_valid (EnchantProvider* provider);
VALA_EXTERN void enchant_provider_set_error (EnchantProvider* self,
                                 const gchar* err);
VALA_EXTERN void enchant_broker_set_error (EnchantBroker* self,
                               const gchar* value);
VALA_EXTERN gint _enchant_provider_dictionary_exists (EnchantProvider* self,
                                          const gchar* tag);
VALA_EXTERN gchar* enchant_provider_get_user_dict_dir (EnchantProvider* self);
VALA_EXTERN EnchantProvider* enchant_provider_new (void);
VALA_EXTERN EnchantProvider* enchant_provider_construct (GType object_type);
static void enchant_provider_finalize (EnchantProvider * obj);
static GType enchant_provider_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

gchar*
enchant_get_user_config_dir (void)
{
	const gchar* env = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 33 "provider.vala"
	_tmp0_ = g_getenv ("ENCHANT_CONFIG_DIR");
#line 33 "provider.vala"
	env = _tmp0_;
#line 34 "provider.vala"
	_tmp1_ = env;
#line 34 "provider.vala"
	if (_tmp1_ != NULL) {
#line 183 "provider.c"
		{
			gchar* _tmp2_ = NULL;
			const gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
#line 36 "provider.vala"
			_tmp3_ = env;
#line 36 "provider.vala"
			_tmp4_ = g_filename_to_utf8 (_tmp3_, (gssize) -1, NULL, NULL, &_inner_error0_);
#line 36 "provider.vala"
			_tmp2_ = _tmp4_;
#line 36 "provider.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 36 "provider.vala"
				if (_inner_error0_->domain == G_CONVERT_ERROR) {
#line 199 "provider.c"
					goto __catch0_g_convert_error;
				}
#line 36 "provider.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 36 "provider.vala"
				g_clear_error (&_inner_error0_);
#line 36 "provider.vala"
				return NULL;
#line 208 "provider.c"
			}
#line 36 "provider.vala"
			_tmp5_ = _tmp2_;
#line 36 "provider.vala"
			_tmp2_ = NULL;
#line 36 "provider.vala"
			result = _tmp5_;
#line 36 "provider.vala"
			_g_free0 (_tmp2_);
#line 36 "provider.vala"
			return result;
#line 220 "provider.c"
		}
		goto __finally0;
		__catch0_g_convert_error:
		{
#line 35 "provider.vala"
			g_clear_error (&_inner_error0_);
#line 38 "provider.vala"
			result = NULL;
#line 38 "provider.vala"
			return result;
#line 231 "provider.c"
		}
		__finally0:
#line 35 "provider.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 35 "provider.vala"
		g_clear_error (&_inner_error0_);
#line 35 "provider.vala"
		return NULL;
#line 240 "provider.c"
	}
#line 40 "provider.vala"
	_tmp6_ = g_get_user_config_dir ();
#line 40 "provider.vala"
	_tmp7_ = g_build_filename (_tmp6_, "enchant", NULL);
#line 40 "provider.vala"
	result = _tmp7_;
#line 40 "provider.vala"
	return result;
#line 250 "provider.c"
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
#line 1555 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1556 "glib-2.0.vapi"
	res = (guint8*) self;
#line 1556 "glib-2.0.vapi"
	res_length1 = -1;
#line 1556 "glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1557 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1557 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1557 "glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1558 "glib-2.0.vapi"
	_tmp2_ = res;
#line 1558 "glib-2.0.vapi"
	_tmp2__length1 = res_length1;
#line 1558 "glib-2.0.vapi"
	if (result_length1) {
#line 1558 "glib-2.0.vapi"
		*result_length1 = _tmp2__length1;
#line 287 "provider.c"
	}
#line 1558 "glib-2.0.vapi"
	result = _tmp2_;
#line 1558 "glib-2.0.vapi"
	return result;
#line 293 "provider.c"
}

static gchar*
_vala_relocate (const gchar* path)
{
	const gchar* newpath = NULL;
	const gchar* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_ = 0;
	guint8* _tmp6_;
	gint _tmp6__length1;
	gchar* _tmp7_;
	gchar* result;
#line 77 "gnu.vapi"
	g_return_val_if_fail (path != NULL, NULL);
#line 78 "gnu.vapi"
	_tmp0_ = relocate (path);
#line 78 "gnu.vapi"
	newpath = _tmp0_;
#line 81 "gnu.vapi"
	_tmp1_ = string_get_data (newpath, &_tmp2_);
#line 81 "gnu.vapi"
	_tmp1__length1 = _tmp2_;
#line 81 "gnu.vapi"
	_tmp3_ = _tmp1_;
#line 81 "gnu.vapi"
	_tmp3__length1 = _tmp1__length1;
#line 81 "gnu.vapi"
	_tmp4_ = string_get_data (path, &_tmp5_);
#line 81 "gnu.vapi"
	_tmp4__length1 = _tmp5_;
#line 81 "gnu.vapi"
	_tmp6_ = _tmp4_;
#line 81 "gnu.vapi"
	_tmp6__length1 = _tmp4__length1;
#line 81 "gnu.vapi"
	g_return_val_if_fail (_tmp3_ == _tmp6_, newpath);
#line 83 "gnu.vapi"
	_tmp7_ = g_strdup (newpath);
#line 83 "gnu.vapi"
	result = _tmp7_;
#line 83 "gnu.vapi"
	return result;
#line 343 "provider.c"
}

GSList*
enchant_get_conf_dirs (void)
{
	GSList* conf_dirs = NULL;
	gchar* pkgdatadir = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* sysconfdir = NULL;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* user_config_dir = NULL;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	GSList* result;
#line 44 "provider.vala"
	conf_dirs = NULL;
#line 46 "provider.vala"
	_tmp0_ = g_strdup_printf ("%s-%s", PKGDATADIR, ENCHANT_MAJOR_VERSION);
#line 46 "provider.vala"
	_tmp1_ = _tmp0_;
#line 46 "provider.vala"
	_tmp2_ = _vala_relocate (_tmp1_);
#line 46 "provider.vala"
	_tmp3_ = _tmp2_;
#line 46 "provider.vala"
	_g_free0 (_tmp1_);
#line 46 "provider.vala"
	pkgdatadir = _tmp3_;
#line 47 "provider.vala"
	_tmp4_ = pkgdatadir;
#line 47 "provider.vala"
	if (_tmp4_ != NULL) {
#line 381 "provider.c"
		const gchar* _tmp5_;
		gchar* _tmp6_;
#line 48 "provider.vala"
		_tmp5_ = pkgdatadir;
#line 48 "provider.vala"
		_tmp6_ = g_strdup (_tmp5_);
#line 48 "provider.vala"
		conf_dirs = g_slist_append (conf_dirs, _tmp6_);
#line 390 "provider.c"
	}
#line 50 "provider.vala"
	_tmp7_ = _vala_relocate (SYSCONFDIR);
#line 50 "provider.vala"
	sysconfdir = _tmp7_;
#line 51 "provider.vala"
	_tmp8_ = sysconfdir;
#line 51 "provider.vala"
	if (_tmp8_ != NULL) {
#line 400 "provider.c"
		gchar* pkgconfdir = NULL;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
#line 52 "provider.vala"
		_tmp9_ = sysconfdir;
#line 52 "provider.vala"
		_tmp10_ = g_strdup_printf ("enchant-%s", ENCHANT_MAJOR_VERSION);
#line 52 "provider.vala"
		_tmp11_ = _tmp10_;
#line 52 "provider.vala"
		_tmp12_ = g_build_filename (_tmp9_, _tmp11_, NULL);
#line 52 "provider.vala"
		_tmp13_ = _tmp12_;
#line 52 "provider.vala"
		_g_free0 (_tmp11_);
#line 52 "provider.vala"
		pkgconfdir = _tmp13_;
#line 53 "provider.vala"
		_tmp14_ = pkgconfdir;
#line 53 "provider.vala"
		if (_tmp14_ != NULL) {
#line 426 "provider.c"
			const gchar* _tmp15_;
			gchar* _tmp16_;
#line 54 "provider.vala"
			_tmp15_ = pkgconfdir;
#line 54 "provider.vala"
			_tmp16_ = g_strdup (_tmp15_);
#line 54 "provider.vala"
			conf_dirs = g_slist_append (conf_dirs, _tmp16_);
#line 435 "provider.c"
		}
#line 51 "provider.vala"
		_g_free0 (pkgconfdir);
#line 439 "provider.c"
	}
#line 57 "provider.vala"
	_tmp17_ = enchant_get_user_config_dir ();
#line 57 "provider.vala"
	user_config_dir = _tmp17_;
#line 58 "provider.vala"
	_tmp18_ = user_config_dir;
#line 58 "provider.vala"
	if (_tmp18_ != NULL) {
#line 449 "provider.c"
		const gchar* _tmp19_;
		gchar* _tmp20_;
#line 59 "provider.vala"
		_tmp19_ = user_config_dir;
#line 59 "provider.vala"
		_tmp20_ = g_strdup (_tmp19_);
#line 59 "provider.vala"
		conf_dirs = g_slist_append (conf_dirs, _tmp20_);
#line 458 "provider.c"
	}
#line 61 "provider.vala"
	result = conf_dirs;
#line 61 "provider.vala"
	_g_free0 (user_config_dir);
#line 61 "provider.vala"
	_g_free0 (sysconfdir);
#line 61 "provider.vala"
	_g_free0 (pkgdatadir);
#line 61 "provider.vala"
	return result;
#line 470 "provider.c"
}

gchar*
enchant_get_prefix_dir (void)
{
	gchar* _tmp0_;
	gchar* result;
#line 65 "provider.vala"
	_tmp0_ = _vala_relocate (INSTALLPREFIX);
#line 65 "provider.vala"
	result = _tmp0_;
#line 65 "provider.vala"
	return result;
#line 484 "provider.c"
}

gboolean
enchant_provider_is_valid (EnchantProvider* provider)
{
	gboolean result;
#line 105 "provider.vala"
	g_return_val_if_fail (provider != NULL, FALSE);
#line 106 "provider.vala"
	if (provider == NULL) {
#line 107 "provider.vala"
		g_warning ("provider.vala:107: EnchantProvider cannot be NULL");
#line 497 "provider.c"
	} else {
		ProviderRequestDict _tmp0_;
#line 108 "provider.vala"
		_tmp0_ = provider->request_dict;
#line 108 "provider.vala"
		if (_tmp0_ == NULL) {
#line 109 "provider.vala"
			g_warning ("provider.vala:109: EnchantProvider's request_dict method cannot be NUL" \
"L");
#line 506 "provider.c"
		} else {
			ProviderDisposeDict _tmp1_;
#line 110 "provider.vala"
			_tmp1_ = provider->dispose_dict;
#line 110 "provider.vala"
			if (_tmp1_ == NULL) {
#line 111 "provider.vala"
				g_warning ("provider.vala:111: EnchantProvider's dispose_dict method cannot be NUL" \
"L");
#line 515 "provider.c"
			} else {
				ProviderIdentify _tmp2_;
#line 112 "provider.vala"
				_tmp2_ = provider->identify;
#line 112 "provider.vala"
				if (_tmp2_ == NULL) {
#line 113 "provider.vala"
					g_warning ("provider.vala:113: EnchantProvider's identify method cannot be NULL");
#line 524 "provider.c"
				} else {
					ProviderIdentify _tmp3_;
					const gchar* _tmp4_;
#line 114 "provider.vala"
					_tmp3_ = provider->identify;
#line 114 "provider.vala"
					_tmp4_ = _tmp3_ (provider);
#line 114 "provider.vala"
					if (!g_utf8_validate (_tmp4_, (gssize) -1, NULL)) {
#line 115 "provider.vala"
						g_warning ("provider.vala:115: EnchantProvider's identify method does not return v" \
"alid UTF-8");
#line 536 "provider.c"
					} else {
						ProviderDescribe _tmp5_;
#line 116 "provider.vala"
						_tmp5_ = provider->describe;
#line 116 "provider.vala"
						if (_tmp5_ == NULL) {
#line 117 "provider.vala"
							g_warning ("provider.vala:117: EnchantProvider's describe method cannot be NULL");
#line 545 "provider.c"
						} else {
							ProviderDescribe _tmp6_;
							const gchar* _tmp7_;
#line 118 "provider.vala"
							_tmp6_ = provider->describe;
#line 118 "provider.vala"
							_tmp7_ = _tmp6_ (provider);
#line 118 "provider.vala"
							if (!g_utf8_validate (_tmp7_, (gssize) -1, NULL)) {
#line 119 "provider.vala"
								g_warning ("provider.vala:119: EnchantProvider's describe method does not return v" \
"alid UTF-8");
#line 557 "provider.c"
							} else {
								ProviderListDicts _tmp8_;
#line 120 "provider.vala"
								_tmp8_ = provider->list_dicts;
#line 120 "provider.vala"
								if (_tmp8_ == NULL) {
#line 121 "provider.vala"
									g_warning ("provider.vala:121: EnchantProvider's list_dicts method cannot be NULL");
#line 566 "provider.c"
								} else {
#line 123 "provider.vala"
									result = TRUE;
#line 123 "provider.vala"
									return result;
#line 572 "provider.c"
								}
							}
						}
					}
				}
			}
		}
	}
#line 125 "provider.vala"
	result = FALSE;
#line 125 "provider.vala"
	return result;
#line 585 "provider.c"
}

void
enchant_provider_set_error (EnchantProvider* self,
                            const gchar* err)
{
	EnchantBroker* broker = NULL;
	EnchantBroker* _tmp0_;
	EnchantBroker* _tmp1_;
	EnchantBroker* _tmp2_;
#line 128 "provider.vala"
	g_return_if_fail (self != NULL);
#line 128 "provider.vala"
	g_return_if_fail (err != NULL);
#line 129 "provider.vala"
	_tmp0_ = self->owner;
#line 129 "provider.vala"
	broker = _tmp0_;
#line 130 "provider.vala"
	_tmp1_ = broker;
#line 130 "provider.vala"
	if (_tmp1_ == NULL) {
#line 131 "provider.vala"
		return;
#line 610 "provider.c"
	}
#line 133 "provider.vala"
	g_debug ("provider.vala:133: enchant_provider_set_error: %s", err);
#line 134 "provider.vala"
	_tmp2_ = broker;
#line 134 "provider.vala"
	enchant_broker_set_error (_tmp2_, err);
#line 618 "provider.c"
}

gint
_enchant_provider_dictionary_exists (EnchantProvider* self,
                                     const gchar* tag)
{
	ProviderDictionaryExists _tmp0_;
	ProviderListDicts _tmp2_;
	size_t _tmp3_ = 0;
	gchar** _tmp4_;
	gint result;
#line 137 "provider.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 137 "provider.vala"
	g_return_val_if_fail (tag != NULL, 0);
#line 138 "provider.vala"
	_tmp0_ = self->dictionary_exists;
#line 138 "provider.vala"
	if (_tmp0_ != NULL) {
#line 638 "provider.c"
		ProviderDictionaryExists _tmp1_;
#line 139 "provider.vala"
		_tmp1_ = self->dictionary_exists;
#line 139 "provider.vala"
		result = _tmp1_ (self, tag);
#line 139 "provider.vala"
		return result;
#line 646 "provider.c"
	}
#line 141 "provider.vala"
	_tmp2_ = self->list_dicts;
#line 141 "provider.vala"
	_tmp4_ = _tmp2_ (self, &_tmp3_);
#line 652 "provider.c"
	{
		gchar** dict_collection = NULL;
		gint dict_collection_length1 = 0;
		gint _dict_collection_size_ = 0;
		gint dict_it = 0;
#line 141 "provider.vala"
		dict_collection = _tmp4_;
#line 141 "provider.vala"
		dict_collection_length1 = _tmp3_;
#line 141 "provider.vala"
		for (dict_it = 0; dict_it < dict_collection_length1; dict_it = dict_it + 1) {
#line 664 "provider.c"
			gchar* _tmp5_;
			gchar* dict = NULL;
#line 141 "provider.vala"
			_tmp5_ = g_strdup (dict_collection[dict_it]);
#line 141 "provider.vala"
			dict = _tmp5_;
#line 671 "provider.c"
			{
				const gchar* _tmp6_;
#line 142 "provider.vala"
				_tmp6_ = dict;
#line 142 "provider.vala"
				if (g_strcmp0 (_tmp6_, tag) == 0) {
#line 143 "provider.vala"
					result = 1;
#line 143 "provider.vala"
					_g_free0 (dict);
#line 143 "provider.vala"
					dict_collection = (_vala_array_free (dict_collection, dict_collection_length1, (GDestroyNotify) g_free), NULL);
#line 143 "provider.vala"
					return result;
#line 686 "provider.c"
				}
#line 141 "provider.vala"
				_g_free0 (dict);
#line 690 "provider.c"
			}
		}
#line 141 "provider.vala"
		dict_collection = (_vala_array_free (dict_collection, dict_collection_length1, (GDestroyNotify) g_free), NULL);
#line 695 "provider.c"
	}
#line 144 "provider.vala"
	result = 0;
#line 144 "provider.vala"
	return result;
#line 701 "provider.c"
}

gchar*
enchant_provider_get_user_dict_dir (EnchantProvider* self)
{
	gchar* config_dir = NULL;
	gchar* _tmp0_;
	ProviderIdentify _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
#line 147 "provider.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 148 "provider.vala"
	_tmp0_ = enchant_get_user_config_dir ();
#line 148 "provider.vala"
	config_dir = _tmp0_;
#line 149 "provider.vala"
	_tmp1_ = self->identify;
#line 149 "provider.vala"
	_tmp2_ = _tmp1_ (self);
#line 149 "provider.vala"
	_tmp3_ = g_build_filename (config_dir, _tmp2_, NULL);
#line 149 "provider.vala"
	result = _tmp3_;
#line 149 "provider.vala"
	_g_free0 (config_dir);
#line 149 "provider.vala"
	return result;
#line 731 "provider.c"
}

EnchantProvider*
enchant_provider_construct (GType object_type)
{
	EnchantProvider* self = NULL;
#line 85 "provider.vala"
	self = (EnchantProvider*) g_type_create_instance (object_type);
#line 85 "provider.vala"
	return self;
#line 742 "provider.c"
}

EnchantProvider*
enchant_provider_new (void)
{
#line 85 "provider.vala"
	return enchant_provider_construct (TYPE_ENCHANT_PROVIDER);
#line 750 "provider.c"
}

static void
value_enchant_provider_init (GValue* value)
{
#line 85 "provider.vala"
	value->data[0].v_pointer = NULL;
#line 758 "provider.c"
}

static void
value_enchant_provider_free_value (GValue* value)
{
#line 85 "provider.vala"
	if (value->data[0].v_pointer) {
#line 85 "provider.vala"
		enchant_provider_unref (value->data[0].v_pointer);
#line 768 "provider.c"
	}
}

static void
value_enchant_provider_copy_value (const GValue* src_value,
                                   GValue* dest_value)
{
#line 85 "provider.vala"
	if (src_value->data[0].v_pointer) {
#line 85 "provider.vala"
		dest_value->data[0].v_pointer = enchant_provider_ref (src_value->data[0].v_pointer);
#line 780 "provider.c"
	} else {
#line 85 "provider.vala"
		dest_value->data[0].v_pointer = NULL;
#line 784 "provider.c"
	}
}

static gpointer
value_enchant_provider_peek_pointer (const GValue* value)
{
#line 85 "provider.vala"
	return value->data[0].v_pointer;
#line 793 "provider.c"
}

static gchar*
value_enchant_provider_collect_value (GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
#line 85 "provider.vala"
	if (collect_values[0].v_pointer) {
#line 804 "provider.c"
		EnchantProvider * object;
		object = collect_values[0].v_pointer;
#line 85 "provider.vala"
		if (object->parent_instance.g_class == NULL) {
#line 85 "provider.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 811 "provider.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 85 "provider.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 815 "provider.c"
		}
#line 85 "provider.vala"
		value->data[0].v_pointer = enchant_provider_ref (object);
#line 819 "provider.c"
	} else {
#line 85 "provider.vala"
		value->data[0].v_pointer = NULL;
#line 823 "provider.c"
	}
#line 85 "provider.vala"
	return NULL;
#line 827 "provider.c"
}

static gchar*
value_enchant_provider_lcopy_value (const GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	EnchantProvider ** object_p;
	object_p = collect_values[0].v_pointer;
#line 85 "provider.vala"
	if (!object_p) {
#line 85 "provider.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 842 "provider.c"
	}
#line 85 "provider.vala"
	if (!value->data[0].v_pointer) {
#line 85 "provider.vala"
		*object_p = NULL;
#line 848 "provider.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 85 "provider.vala"
		*object_p = value->data[0].v_pointer;
#line 852 "provider.c"
	} else {
#line 85 "provider.vala"
		*object_p = enchant_provider_ref (value->data[0].v_pointer);
#line 856 "provider.c"
	}
#line 85 "provider.vala"
	return NULL;
#line 860 "provider.c"
}

GParamSpec*
param_spec_enchant_provider (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags)
{
	ParamSpecEnchantProvider* spec;
#line 85 "provider.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ENCHANT_PROVIDER), NULL);
#line 85 "provider.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 85 "provider.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 85 "provider.vala"
	return G_PARAM_SPEC (spec);
#line 879 "provider.c"
}

gpointer
value_get_enchant_provider (const GValue* value)
{
#line 85 "provider.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_PROVIDER), NULL);
#line 85 "provider.vala"
	return value->data[0].v_pointer;
#line 889 "provider.c"
}

void
value_set_enchant_provider (GValue* value,
                            gpointer v_object)
{
	EnchantProvider * old;
#line 85 "provider.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_PROVIDER));
#line 85 "provider.vala"
	old = value->data[0].v_pointer;
#line 85 "provider.vala"
	if (v_object) {
#line 85 "provider.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENCHANT_PROVIDER));
#line 85 "provider.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 85 "provider.vala"
		value->data[0].v_pointer = v_object;
#line 85 "provider.vala"
		enchant_provider_ref (value->data[0].v_pointer);
#line 911 "provider.c"
	} else {
#line 85 "provider.vala"
		value->data[0].v_pointer = NULL;
#line 915 "provider.c"
	}
#line 85 "provider.vala"
	if (old) {
#line 85 "provider.vala"
		enchant_provider_unref (old);
#line 921 "provider.c"
	}
}

void
value_take_enchant_provider (GValue* value,
                             gpointer v_object)
{
	EnchantProvider * old;
#line 85 "provider.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_PROVIDER));
#line 85 "provider.vala"
	old = value->data[0].v_pointer;
#line 85 "provider.vala"
	if (v_object) {
#line 85 "provider.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENCHANT_PROVIDER));
#line 85 "provider.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 85 "provider.vala"
		value->data[0].v_pointer = v_object;
#line 942 "provider.c"
	} else {
#line 85 "provider.vala"
		value->data[0].v_pointer = NULL;
#line 946 "provider.c"
	}
#line 85 "provider.vala"
	if (old) {
#line 85 "provider.vala"
		enchant_provider_unref (old);
#line 952 "provider.c"
	}
}

static void
enchant_provider_class_init (EnchantProviderClass * klass,
                             gpointer klass_data)
{
#line 85 "provider.vala"
	enchant_provider_parent_class = g_type_class_peek_parent (klass);
#line 85 "provider.vala"
	((EnchantProviderClass *) klass)->finalize = enchant_provider_finalize;
#line 964 "provider.c"
}

static void
enchant_provider_instance_init (EnchantProvider * self,
                                gpointer klass)
{
#line 85 "provider.vala"
	self->ref_count = 1;
#line 973 "provider.c"
}

static void
enchant_provider_finalize (EnchantProvider * obj)
{
	EnchantProvider * self;
	GModule* module = NULL;
	GModule* _tmp0_;
	ProviderDispose _tmp1_;
	GModule* _tmp3_;
#line 85 "provider.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ENCHANT_PROVIDER, EnchantProvider);
#line 85 "provider.vala"
	g_signal_handlers_destroy (self);
#line 98 "provider.vala"
	_tmp0_ = self->module;
#line 98 "provider.vala"
	self->module = NULL;
#line 98 "provider.vala"
	module = _tmp0_;
#line 99 "provider.vala"
	_tmp1_ = self->dispose;
#line 99 "provider.vala"
	if (_tmp1_ != NULL) {
#line 998 "provider.c"
		ProviderDispose _tmp2_;
#line 100 "provider.vala"
		_tmp2_ = self->dispose;
#line 100 "provider.vala"
		_tmp2_ (self);
#line 1004 "provider.c"
	}
#line 102 "provider.vala"
	_tmp3_ = module;
#line 102 "provider.vala"
	module = NULL;
#line 102 "provider.vala"
	g_module_close (_tmp3_);
#line 85 "provider.vala"
	_g_module_close0 (module);
#line 87 "provider.vala"
	_g_module_close0 (self->module);
#line 1016 "provider.c"
}

static GType
enchant_provider_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_enchant_provider_init, value_enchant_provider_free_value, value_enchant_provider_copy_value, value_enchant_provider_peek_pointer, "p", value_enchant_provider_collect_value, "p", value_enchant_provider_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (EnchantProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enchant_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EnchantProvider), 0, (GInstanceInitFunc) enchant_provider_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType enchant_provider_type_id;
	enchant_provider_type_id = g_type_register_fundamental (g_type_fundamental_next (), "EnchantProvider", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return enchant_provider_type_id;
}

GType
enchant_provider_get_type (void)
{
	static volatile gsize enchant_provider_type_id__once = 0;
	if (g_once_init_enter (&enchant_provider_type_id__once)) {
		GType enchant_provider_type_id;
		enchant_provider_type_id = enchant_provider_get_type_once ();
		g_once_init_leave (&enchant_provider_type_id__once, enchant_provider_type_id);
	}
	return enchant_provider_type_id__once;
}

gpointer
enchant_provider_ref (gpointer instance)
{
	EnchantProvider * self;
	self = instance;
#line 85 "provider.vala"
	g_atomic_int_inc (&self->ref_count);
#line 85 "provider.vala"
	return instance;
#line 1051 "provider.c"
}

void
enchant_provider_unref (gpointer instance)
{
	EnchantProvider * self;
	self = instance;
#line 85 "provider.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 85 "provider.vala"
		ENCHANT_PROVIDER_GET_CLASS (self)->finalize (self);
#line 85 "provider.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1065 "provider.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

