"/* The standard CSS for doxygen */\n"
"\n"
"body, table, div, p, dl {\n"
"	font: 400 14px/19px Roboto,sans-serif;\n"
"}\n"
"\n"
"/* @group Heading Levels */\n"
"\n"
"h1.groupheader {\n"
"	font-size: 150%;\n"
"}\n"
"\n"
".title {\n"
"	font-size: 150%;\n"
"	font-weight: bold;\n"
"	margin: 10px 2px;\n"
"}\n"
"\n"
"h2.groupheader {\n"
"	border-bottom: 1px solid ##99;\n"
"	color: ##44;\n"
"	font-size: 150%;\n"
"	font-weight: normal;\n"
"	margin-top: 1.75em;\n"
"	padding-top: 8px;\n"
"	padding-bottom: 4px;\n"
"	width: 100%;\n"
"}\n"
"\n"
"h3.groupheader {\n"
"	font-size: 100%;\n"
"}\n"
"\n"
"h1, h2, h3, h4, h5, h6 {\n"
"	-webkit-transition: text-shadow 0.5s linear;\n"
"	-moz-transition: text-shadow 0.5s linear;\n"
"	-ms-transition: text-shadow 0.5s linear;\n"
"	-o-transition: text-shadow 0.5s linear;\n"
"	transition: text-shadow 0.5s linear;\n"
"	margin-right: 15px;\n"
"}\n"
"\n"
"h1.glow, h2.glow, h3.glow, h4.glow, h5.glow, h6.glow {\n"
"	text-shadow: 0 0 15px cyan;\n"
"}\n"
"\n"
"dt {\n"
"	font-weight: bold;\n"
"}\n"
"\n"
"div.multicol {\n"
"	-moz-column-gap: 1em;\n"
"	-webkit-column-gap: 1em;\n"
"	-moz-column-count: 3;\n"
"	-webkit-column-count: 3;\n"
"}\n"
"\n"
"p.startli, p.startdd, p.starttd {\n"
"	margin-top: 2px;\n"
"}\n"
"\n"
"p.endli {\n"
"	margin-bottom: 0px;\n"
"}\n"
"\n"
"p.enddd {\n"
"	margin-bottom: 4px;\n"
"}\n"
"\n"
"p.endtd {\n"
"	margin-bottom: 2px;\n"
"}\n"
"\n"
"/* @end */\n"
"\n"
"caption {\n"
"	font-weight: bold;\n"
"}\n"
"\n"
"span.legend {\n"
"        font-size: 70%;\n"
"        text-align: center;\n"
"}\n"
"\n"
"h3.version {\n"
"        font-size: 90%;\n"
"        text-align: center;\n"
"}\n"
"\n"
"div.qindex, div.navtab{\n"
"	background-color: ##ee;\n"
"	border: 1px solid ##b0;\n"
"	text-align: center;\n"
"}\n"
"\n"
"div.qindex, div.navpath {\n"
"	width: 100%;\n"
"	line-height: 140%;\n"
"}\n"
"\n"
"div.navtab {\n"
"	margin-right: 15px;\n"
"}\n"
"\n"
"/* @group Link Styling */\n"
"\n"
"a {\n"
"	color: ##50;\n"
"	font-weight: normal;\n"
"	text-decoration: none;\n"
"}\n"
"\n"
".contents a:visited {\n"
"	color: ##60;\n"
"}\n"
"\n"
"a:hover {\n"
"	text-decoration: underline;\n"
"}\n"
"\n"
"a.qindex {\n"
"	font-weight: bold;\n"
"}\n"
"\n"
"a.qindexHL {\n"
"	font-weight: bold;\n"
"	background-color: ##AA;\n"
"	color: #ffffff;\n"
"	border: 1px double ##98;\n"
"}\n"
"\n"
".contents a.qindexHL:visited {\n"
"        color: #ffffff;\n"
"}\n"
"\n"
"a.el {\n"
"	font-weight: bold;\n"
"}\n"
"\n"
"a.elRef {\n"
"}\n"
"\n"
"a.code, a.code:visited {\n"
"	color: #4665A2; \n"
"}\n"
"\n"
"a.codeRef, a.codeRef:visited {\n"
"	color: #4665A2; \n"
"}\n"
"\n"
"/* @end */\n"
"\n"
"dl.el {\n"
"	margin-left: -1cm;\n"
"}\n"
"\n"
"pre.fragment {\n"
"        border: 1px solid #C4CFE5;\n"
"        background-color: #FBFCFD;\n"
"        padding: 4px 6px;\n"
"        margin: 4px 8px 4px 2px;\n"
"        overflow: auto;\n"
"        word-wrap: break-word;\n"
"        font-size:  9pt;\n"
"        line-height: 125%;\n"
"        font-family: monospace, fixed;\n"
"        font-size: 105%;\n"
"}\n"
"\n"
"div.fragment {\n"
"        padding: 4px;\n"
"        margin: 4px;\n"
"	background-color: ##FC;\n"
"	border: 1px solid ##CC;\n"
"}\n"
"\n"
"div.line {\n"
"	font-family: monospace, fixed;\n"
"        font-size: 13px;\n"
"	min-height: 13px;\n"
"	line-height: 1.0;\n"
"	text-wrap: unrestricted;\n"
"	white-space: -moz-pre-wrap; /* Moz */\n"
"	white-space: -pre-wrap;     /* Opera 4-6 */\n"
"	white-space: -o-pre-wrap;   /* Opera 7 */\n"
"	white-space: pre-wrap;      /* CSS3  */\n"
"	word-wrap: break-word;      /* IE 5.5+ */\n"
"	text-indent: -53px;\n"
"	padding-left: 53px;\n"
"	padding-bottom: 0px;\n"
"	margin: 0px;\n"
"	-webkit-transition-property: background-color, box-shadow;\n"
"	-webkit-transition-duration: 0.5s;\n"
"	-moz-transition-property: background-color, box-shadow;\n"
"	-moz-transition-duration: 0.5s;\n"
"	-ms-transition-property: background-color, box-shadow;\n"
"	-ms-transition-duration: 0.5s;\n"
"	-o-transition-property: background-color, box-shadow;\n"
"	-o-transition-duration: 0.5s;\n"
"	transition-property: background-color, box-shadow;\n"
"	transition-duration: 0.5s;\n"
"}\n"
"\n"
"div.line.glow {\n"
"	background-color: cyan;\n"
"	box-shadow: 0 0 10px cyan;\n"
"}\n"
"\n"
"\n"
"span.lineno {\n"
"	padding-right: 4px;\n"
"	text-align: right;\n"
"	border-right: 2px solid #0F0;\n"
"	background-color: #E8E8E8;\n"
"        white-space: pre;\n"
"}\n"
"span.lineno a {\n"
"	background-color: #D8D8D8;\n"
"}\n"
"\n"
"span.lineno a:hover {\n"
"	background-color: #C8C8C8;\n"
"}\n"
"\n"
"div.ah {\n"
"	background-color: black;\n"
"	font-weight: bold;\n"
"	color: #ffffff;\n"
"	margin-bottom: 3px;\n"
"	margin-top: 3px;\n"
"	padding: 0.2em;\n"
"	border: solid thin #333;\n"
"	border-radius: 0.5em;\n"
"	-webkit-border-radius: .5em;\n"
"	-moz-border-radius: .5em;\n"
"	box-shadow: 2px 2px 3px #999;\n"
"	-webkit-box-shadow: 2px 2px 3px #999;\n"
"	-moz-box-shadow: rgba(0, 0, 0, 0.15) 2px 2px 2px;\n"
"	background-image: -webkit-gradient(linear, left top, left bottom, from(#eee), to(#000),color-stop(0.3, #444));\n"
"	background-image: -moz-linear-gradient(center top, #eee 0%, #444 40%, #000);\n"
"}\n"
"\n"
"div.groupHeader {\n"
"	margin-left: 16px;\n"
"	margin-top: 12px;\n"
"	font-weight: bold;\n"
"}\n"
"\n"
"div.groupText {\n"
"	margin-left: 16px;\n"
"	font-style: italic;\n"
"}\n"
"\n"
"body {\n"
"	background-color: white;\n"
"	color: black;\n"
"        margin: 0;\n"
"}\n"
"\n"
"div.contents {\n"
"	margin-top: 10px;\n"
"	margin-left: 12px;\n"
"	margin-right: 8px;\n"
"}\n"
"\n"
"td.indexkey {\n"
"	background-color: ##ee;\n"
"	font-weight: bold;\n"
"	border: 1px solid ##cc;\n"
"	margin: 2px 0px 2px 0;\n"
"	padding: 2px 10px;\n"
"        white-space: nowrap;\n"
"        vertical-align: top;\n"
"}\n"
"\n"
"td.indexvalue {\n"
"	background-color: ##ee;\n"
"	border: 1px solid ##cc;\n"
"	padding: 2px 10px;\n"
"	margin: 2px 0px;\n"
"}\n"
"\n"
"tr.memlist {\n"
"	background-color: ##f0;\n"
"}\n"
"\n"
"p.formulaDsp {\n"
"	text-align: center;\n"
"}\n"
"\n"
"img.formulaDsp {\n"
"	\n"
"}\n"
"\n"
"img.formulaInl {\n"
"	vertical-align: middle;\n"
"}\n"
"\n"
"div.center {\n"
"	text-align: center;\n"
"        margin-top: 0px;\n"
"        margin-bottom: 0px;\n"
"        padding: 0px;\n"
"}\n"
"\n"
"div.center img {\n"
"	border: 0px;\n"
"}\n"
"\n"
"address.footer {\n"
"	text-align: right;\n"
"	padding-right: 12px;\n"
"}\n"
"\n"
"img.footer {\n"
"	border: 0px;\n"
"	vertical-align: middle;\n"
"}\n"
"\n"
"/* @group Code Colorization */\n"
"\n"
"span.keyword {\n"
"	color: #008000\n"
"}\n"
"\n"
"span.keywordtype {\n"
"	color: #604020\n"
"}\n"
"\n"
"span.keywordflow {\n"
"	color: #e08000\n"
"}\n"
"\n"
"span.comment {\n"
"	color: #800000\n"
"}\n"
"\n"
"span.preprocessor {\n"
"	color: #806020\n"
"}\n"
"\n"
"span.stringliteral {\n"
"	color: #002080\n"
"}\n"
"\n"
"span.charliteral {\n"
"	color: #008080\n"
"}\n"
"\n"
"span.vhdldigit { \n"
"	color: #ff00ff \n"
"}\n"
"\n"
"span.vhdlchar { \n"
"	color: #000000 \n"
"}\n"
"\n"
"span.vhdlkeyword { \n"
"	color: #700070 \n"
"}\n"
"\n"
"span.vhdllogic { \n"
"	color: #ff0000 \n"
"}\n"
"\n"
"blockquote {\n"
"        background-color: ##F8;\n"
"        border-left: 2px solid ##AA;\n"
"        margin: 0 24px 0 4px;\n"
"        padding: 0 12px 0 16px;\n"
"}\n"
"\n"
"/* @end */\n"
"\n"
"/*\n"
".search {\n"
"	color: #003399;\n"
"	font-weight: bold;\n"
"}\n"
"\n"
"form.search {\n"
"	margin-bottom: 0px;\n"
"	margin-top: 0px;\n"
"}\n"
"\n"
"input.search {\n"
"	font-size: 75%;\n"
"	color: #000080;\n"
"	font-weight: normal;\n"
"	background-color: #e8eef2;\n"
"}\n"
"*/\n"
"\n"
"td.tiny {\n"
"	font-size: 75%;\n"
"}\n"
"\n"
".dirtab {\n"
"	padding: 4px;\n"
"	border-collapse: collapse;\n"
"	border: 1px solid ##b0;\n"
"}\n"
"\n"
"th.dirtab {\n"
"	background: ##ee;\n"
"	font-weight: bold;\n"
"}\n"
"\n"
"hr {\n"
"	height: 0px;\n"
"	border: none;\n"
"	border-top: 1px solid ##66;\n"
"}\n"
"\n"
"hr.footer {\n"
"	height: 1px;\n"
"}\n"
"\n"
"/* @group Member Descriptions */\n"
"\n"
"table.memberdecls {\n"
"	border-spacing: 0px;\n"
"	padding: 0px;\n"
"}\n"
"\n"
".memberdecls td, .fieldtable tr {\n"
"	-webkit-transition-property: background-color, box-shadow;\n"
"	-webkit-transition-duration: 0.5s;\n"
"	-moz-transition-property: background-color, box-shadow;\n"
"	-moz-transition-duration: 0.5s;\n"
"	-ms-transition-property: background-color, box-shadow;\n"
"	-ms-transition-duration: 0.5s;\n"
"	-o-transition-property: background-color, box-shadow;\n"
"	-o-transition-duration: 0.5s;\n"
"	transition-property: background-color, box-shadow;\n"
"	transition-duration: 0.5s;\n"
"}\n"
"\n"
".memberdecls td.glow, .fieldtable tr.glow {\n"
"	background-color: cyan;\n"
"	box-shadow: 0 0 15px cyan;\n"
"}\n"
"\n"
".mdescLeft, .mdescRight,\n"
".memItemLeft, .memItemRight,\n"
".memTemplItemLeft, .memTemplItemRight, .memTemplParams {\n"
"	background-color: ##FA;\n"
"	border: none;\n"
"	margin: 4px;\n"
"	padding: 1px 0 0 8px;\n"
"}\n"
"\n"
".mdescLeft, .mdescRight {\n"
"	padding: 0px 8px 4px 8px;\n"
"	color: #555;\n"
"}\n"
"\n"
".memSeparator {\n"
"        border-bottom: 1px solid #DEE4F0;\n"
"        line-height: 1px;\n"
"        margin: 0px;\n"
"        padding: 0px;\n"
"}\n"
"\n"
".memItemLeft, .memTemplItemLeft {\n"
"        white-space: nowrap;\n"
"}\n"
"\n"
".memItemRight {\n"
"	width: 100%;\n"
"}\n"
"\n"
".memTemplParams {\n"
"	color: ##60;\n"
"        white-space: nowrap;\n"
"	font-size: 80%;\n"
"}\n"
"\n"
"/* @end */\n"
"\n"
"/* @group Member Details */\n"
"\n"
"/* Styles for detailed member documentation */\n"
"\n"
".memtemplate {\n"
"	font-size: 80%;\n"
"	color: ##60;\n"
"	font-weight: normal;\n"
"	margin-left: 9px;\n"
"}\n"
"\n"
".memnav {\n"
"	background-color: ##ee;\n"
"	border: 1px solid ##b0;\n"
"	text-align: center;\n"
"	margin: 2px;\n"
"	margin-right: 15px;\n"
"	padding: 2px;\n"
"}\n"
"\n"
".mempage {\n"
"	width: 100%;\n"
"}\n"
"\n"
".memitem {\n"
"	padding: 0;\n"
"	margin-bottom: 10px;\n"
"	margin-right: 5px;\n"
"        -webkit-transition: box-shadow 0.5s linear;\n"
"        -moz-transition: box-shadow 0.5s linear;\n"
"        -ms-transition: box-shadow 0.5s linear;\n"
"        -o-transition: box-shadow 0.5s linear;\n"
"        transition: box-shadow 0.5s linear;\n"
"        display: table !important;\n"
"        width: 100%;\n"
"}\n"
"\n"
".memitem.glow {\n"
"         box-shadow: 0 0 15px cyan;\n"
"}\n"
"\n"
".memname {\n"
"        font-weight: bold;\n"
"        margin-left: 6px;\n"
"}\n"
"\n"
".memname td {\n"
"	vertical-align: bottom;\n"
"}\n"
"\n"
".memproto, dl.reflist dt {\n"
"        border-top: 1px solid ##B4;\n"
"        border-left: 1px solid ##B4;\n"
"        border-right: 1px solid ##B4;\n"
"        padding: 6px 0px 6px 0px;\n"
"        color: ##2b;\n"
"        font-weight: bold;\n"
"        text-shadow: 0px 1px 1px rgba(255, 255, 255, 0.9);\n"
"        background-image:url('nav_f.png');\n"
"        background-repeat:repeat-x;\n"
"        background-color: ##E6;\n"
"        /* opera specific markup */\n"
"        box-shadow: 5px 5px 5px rgba(0, 0, 0, 0.15);\n"
"        border-top-right-radius: 4px;\n"
"        border-top-left-radius: 4px;\n"
"        /* firefox specific markup */\n"
"        -moz-box-shadow: rgba(0, 0, 0, 0.15) 5px 5px 5px;\n"
"        -moz-border-radius-topright: 4px;\n"
"        -moz-border-radius-topleft: 4px;\n"
"        /* webkit specific markup */\n"
"        -webkit-box-shadow: 5px 5px 5px rgba(0, 0, 0, 0.15);\n"
"        -webkit-border-top-right-radius: 4px;\n"
"        -webkit-border-top-left-radius: 4px;\n"
"\n"
"}\n"
"\n"
".memdoc, dl.reflist dd {\n"
"        border-bottom: 1px solid ##B4;      \n"
"        border-left: 1px solid ##B4;      \n"
"        border-right: 1px solid ##B4; \n"
"        padding: 6px 10px 2px 10px;\n"
"        background-color: ##FC;\n"
"        border-top-width: 0;\n"
"        background-image:url('nav_g.png');\n"
"        background-repeat:repeat-x;\n"
"        background-color: #FFFFFF;\n"
"        /* opera specific markup */\n"
"        border-bottom-left-radius: 4px;\n"
"        border-bottom-right-radius: 4px;\n"
"        box-shadow: 5px 5px 5px rgba(0, 0, 0, 0.15);\n"
"        /* firefox specific markup */\n"
"        -moz-border-radius-bottomleft: 4px;\n"
"        -moz-border-radius-bottomright: 4px;\n"
"        -moz-box-shadow: rgba(0, 0, 0, 0.15) 5px 5px 5px;\n"
"        /* webkit specific markup */\n"
"        -webkit-border-bottom-left-radius: 4px;\n"
"        -webkit-border-bottom-right-radius: 4px;\n"
"        -webkit-box-shadow: 5px 5px 5px rgba(0, 0, 0, 0.15);\n"
"}\n"
"\n"
"dl.reflist dt {\n"
"        padding: 5px;\n"
"}\n"
"\n"
"dl.reflist dd {\n"
"        margin: 0px 0px 10px 0px;\n"
"        padding: 5px;\n"
"}\n"
"\n"
".paramkey {\n"
"	text-align: right;\n"
"}\n"
"\n"
".paramtype {\n"
"	white-space: nowrap;\n"
"}\n"
"\n"
".paramname {\n"
"	color: #602020;\n"
"	white-space: nowrap;\n"
"}\n"
".paramname em {\n"
"	font-style: normal;\n"
"}\n"
".paramname code {\n"
"        line-height: 14px;\n"
"}\n"
"\n"
".params, .retval, .exception, .tparams {\n"
"        margin-left: 0px;\n"
"        padding-left: 0px;\n"
"}       \n"
"\n"
".params .paramname, .retval .paramname {\n"
"        font-weight: bold;\n"
"        vertical-align: top;\n"
"}\n"
"        \n"
".params .paramtype {\n"
"        font-style: italic;\n"
"        vertical-align: top;\n"
"}       \n"
"        \n"
".params .paramdir {\n"
"        font-family: \"courier new\",courier,monospace;\n"
"        vertical-align: top;\n"
"}\n"
"\n"
"table.mlabels {\n"
"	border-spacing: 0px;\n"
"}\n"
"\n"
"td.mlabels-left {\n"
"	width: 100%;\n"
"	padding: 0px;\n"
"}\n"
"\n"
"td.mlabels-right {\n"
"	vertical-align: bottom;\n"
"	padding: 0px;\n"
"	white-space: nowrap;\n"
"}\n"
"\n"
"span.mlabels {\n"
"        margin-left: 8px;\n"
"}\n"
"\n"
"span.mlabel {\n"
"        background-color: ##88;\n"
"        border-top:1px solid ##70;\n"
"        border-left:1px solid ##70;\n"
"        border-right:1px solid ##CC;\n"
"        border-bottom:1px solid ##CC;\n"
"	text-shadow: none;\n"
"	color: white;\n"
"	margin-right: 4px;\n"
"	padding: 2px 3px;\n"
"	border-radius: 3px;\n"
"	font-size: 7pt;\n"
"	white-space: nowrap;\n"
"	vertical-align: middle;\n"
"}\n"
"\n"
"\n"
"\n"
"/* @end */\n"
"\n"
"/* these are for tree view when not used as main index */\n"
"\n"
"div.directory {\n"
"        margin: 10px 0px;\n"
"        border-top: 1px solid #A8B8D9;\n"
"        border-bottom: 1px solid #A8B8D9;\n"
"        width: 100%;\n"
"}\n"
"\n"
".directory table {\n"
"        border-collapse:collapse;\n"
"}\n"
"\n"
".directory td {\n"
"        margin: 0px;\n"
"        padding: 0px;\n"
"	vertical-align: top;\n"
"}\n"
"\n"
".directory td.entry {\n"
"        white-space: nowrap;\n"
"        padding-right: 6px;\n"
"}\n"
"\n"
".directory td.entry a {\n"
"        outline:none;\n"
"}\n"
"\n"
".directory td.entry a img {\n"
"        border: none;\n"
"}\n"
"\n"
".directory td.desc {\n"
"        width: 100%;\n"
"        padding-left: 6px;\n"
"	padding-right: 6px;\n"
"	padding-top: 3px;\n"
"	border-left: 1px solid rgba(0,0,0,0.05);\n"
"}\n"
"\n"
".directory tr.even {\n"
"	padding-left: 6px;\n"
"	background-color: ##F8;\n"
"}\n"
"\n"
".directory img {\n"
"	vertical-align: -30%;\n"
"}\n"
"\n"
".directory .levels {\n"
"        white-space: nowrap;\n"
"        width: 100%;\n"
"        text-align: right;\n"
"        font-size: 9pt;\n"
"}\n"
"\n"
".directory .levels span {\n"
"        cursor: pointer;\n"
"        padding-left: 2px;\n"
"        padding-right: 2px;\n"
"	color: ##50;\n"
"}\n"
"\n"
"div.dynheader {\n"
"        margin-top: 8px;\n"
"	-webkit-touch-callout: none;\n"
"	-webkit-user-select: none;\n"
"	-khtml-user-select: none;\n"
"	-moz-user-select: none;\n"
"	-ms-user-select: none;\n"
"	user-select: none;\n"
"}\n"
"\n"
"address {\n"
"	font-style: normal;\n"
"	color: ##33;\n"
"}\n"
"\n"
"table.doxtable {\n"
"	border-collapse:collapse;\n"
"        margin-top: 4px;\n"
"        margin-bottom: 4px;\n"
"}\n"
"\n"
"table.doxtable td, table.doxtable th {\n"
"	border: 1px solid ##37;\n"
"	padding: 3px 7px 2px;\n"
"}\n"
"\n"
"table.doxtable th {\n"
"	background-color: ##47;\n"
"	color: #FFFFFF;\n"
"	font-size: 110%;\n"
"	padding-bottom: 4px;\n"
"	padding-top: 5px;\n"
"}\n"
"\n"
"table.fieldtable {\n"
"        width: 100%;\n"
"        margin-bottom: 10px;\n"
"        border: 1px solid ##B4;\n"
"        border-spacing: 0px;\n"
"        -moz-border-radius: 4px;\n"
"        -webkit-border-radius: 4px;\n"
"        border-radius: 4px;\n"
"        -moz-box-shadow: rgba(0, 0, 0, 0.15) 2px 2px 2px;\n"
"        -webkit-box-shadow: 2px 2px 2px rgba(0, 0, 0, 0.15);\n"
"        box-shadow: 2px 2px 2px rgba(0, 0, 0, 0.15);\n"
"}\n"
"\n"
".fieldtable td, .fieldtable th {\n"
"        padding: 3px 7px 2px;\n"
"}\n"
"\n"
".fieldtable td.fieldtype, .fieldtable td.fieldname {\n"
"        white-space: nowrap;\n"
"        border-right: 1px solid ##B4;\n"
"        border-bottom: 1px solid ##B4;\n"
"        vertical-align: top;\n"
"}\n"
"\n"
".fieldtable td.fielddoc {\n"
"        border-bottom: 1px solid ##B4;\n"
"        width: 100%;\n"
"}\n"
"\n"
".fieldtable tr:last-child td {\n"
"        border-bottom: none;\n"
"}\n"
"\n"
".fieldtable th {\n"
"        background-image:url('nav_f.png');\n"
"        background-repeat:repeat-x;\n"
"        background-color: ##E6;\n"
"        font-size: 90%;\n"
"        color: ##2B;\n"
"        padding-bottom: 4px;\n"
"        padding-top: 5px;\n"
"        text-align:left;\n"
"        -moz-border-radius-topleft: 4px;\n"
"        -moz-border-radius-topright: 4px;\n"
"        -webkit-border-top-left-radius: 4px;\n"
"        -webkit-border-top-right-radius: 4px;\n"
"        border-top-left-radius: 4px;\n"
"        border-top-right-radius: 4px;\n"
"        border-bottom: 1px solid ##B4;\n"
"}\n"
"\n"
"\n"
".tabsearch {\n"
"	top: 0px;\n"
"	left: 10px;\n"
"	height: 36px;\n"
"	background-image: url('tab_b.png');\n"
"	z-index: 101;\n"
"	overflow: hidden;\n"
"	font-size: 13px;\n"
"}\n"
"\n"
".navpath ul\n"
"{\n"
"	font-size: 11px;\n"
"	background-image:url('tab_b.png');\n"
"	background-repeat:repeat-x;\n"
"	background-position: 0 -5px;\n"
"	height:30px;\n"
"	line-height:30px;\n"
"	color:##9b;\n"
"	border:solid 1px ##ca;\n"
"	overflow:hidden;\n"
"	margin:0px;\n"
"	padding:0px;\n"
"}\n"
"\n"
".navpath li\n"
"{\n"
"	list-style-type:none;\n"
"	float:left;\n"
"	padding-left:10px;\n"
"	padding-right:15px;\n"
"	background-image:url('bc_s.png');\n"
"	background-repeat:no-repeat;\n"
"	background-position:right;\n"
"	color:##45;\n"
"}\n"
"\n"
".navpath li.navelem a\n"
"{\n"
"	height:32px;\n"
"	display:block;\n"
"	text-decoration: none;\n"
"	outline: none;\n"
"	color: ##30;\n"
"	font-family: 'Lucida Grande',Geneva,Helvetica,Arial,sans-serif;\n"
"	text-shadow: 0px 1px 1px rgba(255, 255, 255, 0.9);\n"
"	text-decoration: none;        \n"
"}\n"
"\n"
".navpath li.navelem a:hover\n"
"{\n"
"	color:##80;\n"
"}\n"
"\n"
".navpath li.footer\n"
"{\n"
"        list-style-type:none;\n"
"        float:right;\n"
"        padding-left:10px;\n"
"        padding-right:15px;\n"
"        background-image:none;\n"
"        background-repeat:no-repeat;\n"
"        background-position:right;\n"
"        color:##45;\n"
"        font-size: 8pt;\n"
"}\n"
"\n"
"\n"
"div.summary\n"
"{\n"
"	float: right;\n"
"	font-size: 8pt;\n"
"	padding-right: 5px;\n"
"	width: 50%;\n"
"	text-align: right;\n"
"}       \n"
"\n"
"div.summary a\n"
"{\n"
"	white-space: nowrap;\n"
"}\n"
"\n"
"div.ingroups\n"
"{\n"
"	font-size: 8pt;\n"
"	width: 50%;\n"
"	text-align: left;\n"
"}\n"
"\n"
"div.ingroups a\n"
"{\n"
"	white-space: nowrap;\n"
"}\n"
"\n"
"div.header\n"
"{\n"
"        background-image:url('nav_h.png');\n"
"        background-repeat:repeat-x;\n"
"	background-color: ##FA;\n"
"	margin:  0px;\n"
"	border-bottom: 1px solid ##CC;\n"
"}\n"
"\n"
"div.headertitle\n"
"{\n"
"	padding: 5px 5px 5px 10px;\n"
"}\n"
"\n"
"dl\n"
"{\n"
"        padding: 0 0 0 10px;\n"
"}\n"
"\n"
"/* dl.note, dl.warning, dl.attention, dl.pre, dl.post, dl.invariant, dl.deprecated, dl.todo, dl.test, dl.bug */\n"
"dl.section\n"
"{\n"
"	margin-left: 0px;\n"
"	padding-left: 0px;\n"
"}\n"
"\n"
"dl.note\n"
"{\n"
"        margin-left:-7px;\n"
"        padding-left: 3px;\n"
"        border-left:4px solid;\n"
"        border-color: #D0C000;\n"
"}\n"
"\n"
"dl.warning, dl.attention\n"
"{\n"
"        margin-left:-7px;\n"
"        padding-left: 3px;\n"
"        border-left:4px solid;\n"
"        border-color: #FF0000;\n"
"}\n"
"\n"
"dl.pre, dl.post, dl.invariant\n"
"{\n"
"        margin-left:-7px;\n"
"        padding-left: 3px;\n"
"        border-left:4px solid;\n"
"        border-color: #00D000;\n"
"}\n"
"\n"
"dl.deprecated\n"
"{\n"
"        margin-left:-7px;\n"
"        padding-left: 3px;\n"
"        border-left:4px solid;\n"
"        border-color: #505050;\n"
"}\n"
"\n"
"dl.todo\n"
"{\n"
"        margin-left:-7px;\n"
"        padding-left: 3px;\n"
"        border-left:4px solid;\n"
"        border-color: #00C0E0;\n"
"}\n"
"\n"
"dl.test\n"
"{\n"
"        margin-left:-7px;\n"
"        padding-left: 3px;\n"
"        border-left:4px solid;\n"
"        border-color: #3030E0;\n"
"}\n"
"\n"
"dl.bug\n"
"{\n"
"        margin-left:-7px;\n"
"        padding-left: 3px;\n"
"        border-left:4px solid;\n"
"        border-color: #C08050;\n"
"}\n"
"\n"
"dl.section dd {\n"
"	margin-bottom: 6px;\n"
"}\n"
"\n"
"\n"
"#projectlogo\n"
"{\n"
"	text-align: center;\n"
"	vertical-align: bottom;\n"
"	border-collapse: separate;\n"
"}\n"
" \n"
"#projectlogo img\n"
"{ \n"
"	border: 0px none;\n"
"}\n"
" \n"
"#projectname\n"
"{\n"
"	font: 300% Tahoma, Arial,sans-serif;\n"
"	margin: 0px;\n"
"	padding: 2px 0px;\n"
"}\n"
"    \n"
"#projectbrief\n"
"{\n"
"	font: 120% Tahoma, Arial,sans-serif;\n"
"	margin: 0px;\n"
"	padding: 0px;\n"
"}\n"
"\n"
"#projectnumber\n"
"{\n"
"	font: 50% Tahoma, Arial,sans-serif;\n"
"	margin: 0px;\n"
"	padding: 0px;\n"
"}\n"
"\n"
"#titlearea\n"
"{\n"
"	padding: 0px;\n"
"	margin: 0px;\n"
"	width: 100%;\n"
"	border-bottom: 1px solid ##70;\n"
"}\n"
"\n"
".image\n"
"{\n"
"        text-align: center;\n"
"}\n"
"\n"
".dotgraph\n"
"{\n"
"        text-align: center;\n"
"}\n"
"\n"
".mscgraph\n"
"{\n"
"        text-align: center;\n"
"}\n"
"\n"
".caption\n"
"{\n"
"	font-weight: bold;\n"
"}\n"
"\n"
"div.zoom\n"
"{\n"
"	border: 1px solid ##A0;\n"
"}\n"
"\n"
"dl.citelist {\n"
"        margin-bottom:50px;\n"
"}\n"
"\n"
"dl.citelist dt {\n"
"        color:##40;\n"
"        float:left;\n"
"        font-weight:bold;\n"
"        margin-right:10px;\n"
"        padding:5px;\n"
"}\n"
"\n"
"dl.citelist dd {\n"
"        margin:2px 0;\n"
"        padding:5px 0;\n"
"}\n"
"\n"
"div.toc {\n"
"        padding: 14px 25px;\n"
"        background-color: ##F6;\n"
"        border: 1px solid ##DD;\n"
"        border-radius: 7px 7px 7px 7px;\n"
"        float: right;\n"
"        height: auto;\n"
"        margin: 0 20px 10px 10px;\n"
"        width: 200px;\n"
"}\n"
"\n"
"div.toc li {\n"
"        background: url(\"bdwn.png\") no-repeat scroll 0 5px transparent;\n"
"        font: 10px/1.2 Verdana,DejaVu Sans,Geneva,sans-serif;\n"
"        margin-top: 5px;\n"
"        padding-left: 10px;\n"
"        padding-top: 2px;\n"
"}\n"
"\n"
"div.toc h3 {\n"
"        font: bold 12px/1.2 Arial,FreeSans,sans-serif;\n"
"	color: ##60;\n"
"        border-bottom: 0 none;\n"
"        margin: 0;\n"
"}\n"
"\n"
"div.toc ul {\n"
"        list-style: none outside none;\n"
"        border: medium none;\n"
"        padding: 0px;\n"
"}       \n"
"\n"
"div.toc li.level1 {\n"
"        margin-left: 0px;\n"
"}\n"
"\n"
"div.toc li.level2 {\n"
"        margin-left: 15px;\n"
"}\n"
"\n"
"div.toc li.level3 {\n"
"        margin-left: 30px;\n"
"}\n"
"\n"
"div.toc li.level4 {\n"
"        margin-left: 45px;\n"
"}\n"
"\n"
".inherit_header {\n"
"        font-weight: bold;\n"
"        color: gray;\n"
"        cursor: pointer;\n"
"	-webkit-touch-callout: none;\n"
"	-webkit-user-select: none;\n"
"	-khtml-user-select: none;\n"
"	-moz-user-select: none;\n"
"	-ms-user-select: none;\n"
"	user-select: none;\n"
"}\n"
"\n"
".inherit_header td {\n"
"        padding: 6px 0px 2px 5px;\n"
"}\n"
"\n"
".inherit {\n"
"        display: none;\n"
"}\n"
"\n"
"tr.heading h2 {\n"
"        margin-top: 12px;\n"
"        margin-bottom: 4px;\n"
"}\n"
"\n"
"@media print\n"
"{\n"
"  #top { display: none; }\n"
"  #side-nav { display: none; }\n"
"  #nav-path { display: none; }\n"
"  body { overflow:visible; }\n"
"  h1, h2, h3, h4, h5, h6 { page-break-after: avoid; }\n"
"  .summary { display: none; }\n"
"  .memitem { page-break-inside: avoid; }\n"
"  #doc-content\n"
"  {\n"
"    margin-left:0 !important;\n"
"    height:auto !important;\n"
"    width:auto !important;\n"
"    overflow:inherit;\n"
"    display:inline;\n"
"  }\n"
"}\n"
"\n"
