"%% doxygen.bst\n"
"%% This is a modification of plainhtml.bst; the original copyright notice\n"
"%% follows.\n"
"\n"
"%% ORIGINAL COPYRIGHT NOTICE OF plainhtml.bst\n"
"%%\n"
"%% plainhtml.bst\n"
"%%\n"
"%% Part of bibhtml, version 2.0.1, released 2009 November 2\n"
"%% Hg node 6ca3807543d6.\n"
"%% See <http://purl.org/nxg/dist/bibhtml>\n"
"%%\n"
"%% Copyright 1999, 2005, 2006, 2009, Norman Gray <norman@astro.gla.ac.uk>\n"
"%%\n"
"%% This is a modification of a modification!\n"
"%%\n"
"%%% Modification of BibTeX style file /usr/local/texlive/2008/texmf-dist/bibtex/bst/base/plain.bst\n"
"%%% ... by urlbst, version 0.6-4 (marked with \"% urlbst\")\n"
"%%% See <http://purl.org/nxg/dist/urlbst>\n"
"%%% Added webpage entry type, and url and lastchecked fields.\n"
"%%% Added eprint support.\n"
"%%% Added DOI support.\n"
"%%% Added PUBMED support.\n"
"%%% Added hyperref support.\n"
"%%% Original headers follow...\n"
"\n"
"% BibTeX standard bibliography style `plain'\n"
"	% version 0.99a for BibTeX versions 0.99a or later, LaTeX version 2.09.\n"
"	% Copyright (C) 1985, all rights reserved.\n"
"	% Copying of this file is authorized only if either\n"
"	% (1) you make absolutely no changes to your copy, including name, or\n"
"	% (2) if you do make changes, you name it something other than\n"
"	% btxbst.doc, plain.bst, unsrt.bst, alpha.bst, and abbrv.bst.\n"
"	% This restriction helps ensure that all standard styles are identical.\n"
"	% The file btxbst.doc has the documentation for this style.\n"
"\n"
"ENTRY\n"
"  { address\n"
"    author\n"
"    booktitle\n"
"    chapter\n"
"    edition\n"
"    editor\n"
"    howpublished\n"
"    institution\n"
"    journal\n"
"    key\n"
"    month\n"
"    note\n"
"    number\n"
"    organization\n"
"    pages\n"
"    publisher\n"
"    school\n"
"    series\n"
"    title\n"
"    type\n"
"    volume\n"
"    year\n"
"    eprint % urlbst\n"
"    doi % urlbst\n"
"    pubmed % urlbst\n"
"    url % urlbst\n"
"    lastchecked % urlbst\n"
"  }\n"
"  {}\n"
"  { label }\n"
"\n"
"INTEGERS { output.state before.all mid.sentence after.sentence after.block doiform }\n"
"\n"
"STRINGS { urlintro eprinturl eprintprefix doiprefix doiurl pubmedprefix pubmedurl openinlinelink closeinlinelink } % urlbst...\n"
"INTEGERS { inlinelinks makeinlinelink addeprints adddoiresolver addpubmedresolver }\n"
"% Following constants may be adjusted by hand, if desired\n"
"FUNCTION {init.urlbst.variables}\n"
"{\n"
"  \"Available from: \" 'urlintro := % prefix before URL\n"
"  \"http://arxiv.org/abs/\" 'eprinturl := % prefix to make URL from eprint ref\n"
"  \"arXiv:\" 'eprintprefix := % text prefix printed before eprint ref\n"
"  \"http://dx.doi.org/\" 'doiurl := % prefix to make URL from DOI\n"
"  \"doi:\" 'doiprefix :=      % text prefix printed before DOI ref\n"
"  \"http://www.ncbi.nlm.nih.gov/pubmed/\" 'pubmedurl := % prefix to make URL from PUBMED\n"
"  \"PMID:\" 'pubmedprefix :=      % text prefix printed before PUBMED ref\n"
"  #1 'addeprints :=         % 0=no eprints; 1=include eprints\n"
"  #1 'adddoiresolver :=     % 0=no DOI resolver; 1=include it\n"
"  #1 'addpubmedresolver :=     % 0=no PUBMED resolver; 1=include it\n"
"  #1 'inlinelinks :=        % 0=URLs explicit; 1=URLs attached to titles\n"
"  #1 'doiform :=            % 0=simple, but can produce invalid HTML; 1=needs post-processing\n"
"  % the following are internal state variables, not config constants\n"
"  #0 'makeinlinelink :=     % state variable managed by possibly.setup.inlinelink\n"
"  \"\" 'openinlinelink :=     % ditto\n"
"  \"\" 'closeinlinelink :=    % ditto\n"
"}\n"
"INTEGERS { \n"
"  bracket.state\n"
"  outside.brackets\n"
"  open.brackets\n"
"  within.brackets\n"
"  close.brackets\n"
"  close.first.block\n"
"}\n"
"% ...urlbst to here\n"
"FUNCTION {init.state.consts}\n"
"{ #0 'outside.brackets := % urlbst\n"
"  #1 'open.brackets :=\n"
"  #2 'within.brackets :=\n"
"  #3 'close.brackets :=\n"
"\n"
"  #0 'before.all :=\n"
"  #1 'mid.sentence :=\n"
"  #2 'after.sentence :=\n"
"  #3 'after.block :=\n"
"  #0 'close.first.block :=\n"
"}\n"
"\n"
"STRINGS { s t }\n"
"\n"
"% urlbst\n"
"FUNCTION {output.nonnull.original}\n"
"{ 's :=\n"
"  output.state mid.sentence =\n"
"    { \", \" * write$ }\n"
"    { output.state after.block =\n"
"	{ add.period$ write$\n"
"          % close the <dt> after the end of the first block\n"
"          close.first.block\n"
"            { newline$\n"
"              #0 'close.first.block := }\n"
"	    { newline$ }\n"
"          if$\n"
"	}\n"
"	{ output.state before.all =\n"
"	    'write$\n"
"	    { add.period$ \" \" * write$ }\n"
"	  if$\n"
"	}\n"
"      if$\n"
"      mid.sentence 'output.state :=\n"
"    }\n"
"  if$\n"
"  s\n"
"}\n"
"\n"
"% urlbst...\n"
"% The following three functions are for handling inlinelink.  They wrap\n"
"% a block of text which is potentially output with write$ by multiple\n"
"% other functions, so we don't know the content a priori.\n"
"% They communicate between each other using the variables makeinlinelink\n"
"% (which is true if a link should be made), and closeinlinelink (which holds\n"
"% the string which should close any current link.  They can be called\n"
"% at any time, but start.inlinelink will be a no-op unless something has\n"
"% previously set makeinlinelink true, and the two ...end.inlinelink functions\n"
"% will only do their stuff if start.inlinelink has previously set\n"
"% closeinlinelink to be non-empty.\n"
"FUNCTION {possibly.setup.inlinelink}\n"
"{ makeinlinelink\n"
"   { \"\\rev CITEREF_\" quote$ * url * quote$ * \" [\" * 'openinlinelink :=\n"
"     \"]\" 'closeinlinelink :=\n"
"     #0 'makeinlinelink := }\n"
"   'skip$\n"
" if$ % makeinlinelink\n"
"}\n"
"FUNCTION {add.inlinelink}\n"
"{ openinlinelink empty$\n"
"    'skip$\n"
"    { openinlinelink swap$ * closeinlinelink *\n"
"      \"\" 'openinlinelink :=\n"
"      }\n"
"  if$\n"
"}\n"
"FUNCTION {output.nonnull}\n"
"{ % Save the thing we've been asked to output\n"
"  's :=\n"
"  % If the bracket-state is close.brackets, then add a close-bracket to\n"
"  % what is currently at the top of the stack, and set bracket.state\n"
"  % to outside.brackets\n"
"  bracket.state close.brackets =\n"
"    { \"]\" *\n"
"      outside.brackets 'bracket.state :=\n"
"    }\n"
"    'skip$\n"
"  if$\n"
"  bracket.state outside.brackets =\n"
"    { % We're outside all brackets -- this is the normal situation.\n"
"      % Write out what's currently at the top of the stack, using the\n"
"      % original output.nonnull function.\n"
"      s\n"
"      add.inlinelink\n"
"      output.nonnull.original % invoke the original output.nonnull\n"
"    }\n"
"    { % Still in brackets.  Add open-bracket or (continuation) comma, add the\n"
"      % new text (in s) to the top of the stack, and move to the close-brackets\n"
"      % state, ready for next time (unless inbrackets resets it).  If we come\n"
"      % into this branch, then output.state is carefully undisturbed.\n"
"      bracket.state open.brackets =\n"
"        { \" [\" * }\n"
"        { \", \" * } % bracket.state will be within.brackets\n"
"      if$ \n"
"      s * \n"
"      close.brackets 'bracket.state :=\n"
"    }\n"
"  if$\n"
"}\n"
"\n"
"% Call this function just before adding something which should be presented in \n"
"% brackets.  bracket.state is handled specially within output.nonnull.\n"
"FUNCTION {inbrackets}\n"
"{ bracket.state close.brackets =\n"
"    { within.brackets 'bracket.state := } % reset the state: not open nor closed\n"
"    { open.brackets 'bracket.state := }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {format.lastchecked}\n"
"{ lastchecked empty$\n"
"    { \"\" }\n"
"    { inbrackets \"cited \" lastchecked * }\n"
"  if$\n"
"}\n"
"% ...urlbst to here\n"
"\n"
"FUNCTION {output}\n"
"{ duplicate$ empty$\n"
"    'pop$\n"
"    'output.nonnull\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {output.check}\n"
"{ 't :=\n"
"  duplicate$ empty$\n"
"    { pop$ \"empty \" t * \" in \" * cite$ * warning$ }\n"
"    'output.nonnull\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {output.bibitem.original}\n"
"{ newline$\n"
"  cite$ write$\n"
"  newline$\n"
"  \"[\" label * \"] \" * write$\n"
"  % the <dt> is closed within output.nonnull, as long as close.first.block is true\n"
"  #1 'close.first.block :=\n"
"  newline$\n"
"  \"\"\n"
"  before.all 'output.state :=\n"
"}\n"
"\n"
"FUNCTION {fin.entry.original}\n"
"{ add.period$\n"
"  write$\n"
"  newline$\n"
"}\n"
"\n"
"FUNCTION {new.block}\n"
"{ output.state before.all =\n"
"    'skip$\n"
"    { after.block 'output.state := }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {new.sentence}\n"
"{ output.state after.block =\n"
"    'skip$\n"
"    { output.state before.all =\n"
"	'skip$\n"
"	{ after.sentence 'output.state := }\n"
"      if$\n"
"    }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {not}\n"
"{   { #0 }\n"
"    { #1 }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {and}\n"
"{   'skip$\n"
"    { pop$ #0 }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {or}\n"
"{   { pop$ #1 }\n"
"    'skip$\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {new.block.checka}\n"
"{ empty$\n"
"    'skip$\n"
"    'new.block\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {new.block.checkb}\n"
"{ empty$\n"
"  swap$ empty$\n"
"  and\n"
"    'skip$\n"
"    'new.block\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {new.sentence.checka}\n"
"{ empty$\n"
"    'skip$\n"
"    'new.sentence\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {new.sentence.checkb}\n"
"{ empty$\n"
"  swap$ empty$\n"
"  and\n"
"    'skip$\n"
"    'new.sentence\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {field.or.null}\n"
"{ duplicate$ empty$\n"
"    { pop$ \"\" }\n"
"    'skip$\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {bold}\n"
"{ duplicate$ empty$\n"
"    { pop$ \"\" }\n"
"    { \"<b>\" swap$ * \"</b>\" * }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {emphasize}\n"
"{ duplicate$ empty$\n"
"    { pop$ \"\" }\n"
"    { \"<em>\" swap$ * \"</em>\" * }\n"
"  if$\n"
"}\n"
"\n"
"INTEGERS { nameptr namesleft numnames }\n"
"\n"
"FUNCTION {format.names}\n"
"{ 's :=\n"
"  #1 'nameptr :=\n"
"  s num.names$ 'numnames :=\n"
"  numnames 'namesleft :=\n"
"    { namesleft #0 > }\n"
"    { s nameptr \"{ff~}{vv~}{ll}{, jj}\" format.name$ 't :=\n"
"      nameptr #1 >\n"
"	{ namesleft #1 >\n"
"	    { \", \" * t * }\n"
"	    { numnames #2 >\n"
"		{ \",\" * }\n"
"		'skip$\n"
"	      if$\n"
"	      t \"others\" =\n"
"		{ \" et~al.\" * }\n"
"		{ \" and \" * t * }\n"
"	      if$\n"
"	    }\n"
"	  if$\n"
"	}\n"
"	't\n"
"      if$\n"
"      nameptr #1 + 'nameptr :=\n"
"      namesleft #1 - 'namesleft :=\n"
"    }\n"
"  while$\n"
"}\n"
"\n"
"FUNCTION {format.authors}\n"
"{ author empty$\n"
"    { \"\" }\n"
"    { author format.names }\n"
"  if$\n"
"  bold\n"
"}\n"
"\n"
"FUNCTION {format.editors}\n"
"{ editor empty$\n"
"    { \"\" }\n"
"    { editor format.names\n"
"      editor num.names$ #1 >\n"
"	{ \", editors\" * }\n"
"	{ \", editor\" * }\n"
"      if$\n"
"    }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {format.title}\n"
"{ title empty$\n"
"    { \"\" }\n"
"    { title \"t\" change.case$ }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {n.dashify}\n"
"{ 't :=\n"
"  \"\"\n"
"    { t empty$ not }\n"
"    { t #1 #1 substring$ \"-\" =\n"
"	{ t #1 #2 substring$ \"--\" = not\n"
"	    { \"--\" *\n"
"	      t #2 global.max$ substring$ 't :=\n"
"	    }\n"
"	    {   { t #1 #1 substring$ \"-\" = }\n"
"		{ \"-\" *\n"
"		  t #2 global.max$ substring$ 't :=\n"
"		}\n"
"	      while$\n"
"	    }\n"
"	  if$\n"
"	}\n"
"	{ t #1 #1 substring$ *\n"
"	  t #2 global.max$ substring$ 't :=\n"
"	}\n"
"      if$\n"
"    }\n"
"  while$\n"
"}\n"
"\n"
"FUNCTION {format.date}\n"
"{ year empty$\n"
"    { month empty$\n"
"	{ \"\" }\n"
"	{ \"there's a month but no year in \" cite$ * warning$\n"
"	  month\n"
"	}\n"
"      if$\n"
"    }\n"
"    { month empty$\n"
"	'year\n"
"	{ month \" \" * year * }\n"
"      if$\n"
"    }\n"
"  if$\n"
"  bold\n"
"}\n"
"\n"
"FUNCTION {format.btitle}\n"
"{ title emphasize\n"
"}\n"
"\n"
"FUNCTION {tie.or.space.connect}\n"
"{ duplicate$ text.length$ #3 <\n"
"    { \"~\" }\n"
"    { \" \" }\n"
"  if$\n"
"  swap$ * *\n"
"}\n"
"\n"
"FUNCTION {either.or.check}\n"
"{ empty$\n"
"    'pop$\n"
"    { \"can't use both \" swap$ * \" fields in \" * cite$ * warning$ }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {format.bvolume}\n"
"{ volume empty$\n"
"    { \"\" }\n"
"    { \"volume\" volume tie.or.space.connect\n"
"      series empty$\n"
"	'skip$\n"
"	{ \" of \" * series emphasize * }\n"
"      if$\n"
"      \"volume and number\" number either.or.check\n"
"    }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {format.number.series}\n"
"{ volume empty$\n"
"    { number empty$\n"
"	{ series field.or.null }\n"
"	{ output.state mid.sentence =\n"
"	    { \"number\" }\n"
"	    { \"Number\" }\n"
"	  if$\n"
"	  number tie.or.space.connect\n"
"	  series empty$\n"
"	    { \"there's a number but no series in \" cite$ * warning$ }\n"
"	    { \" in \" * series * }\n"
"	  if$\n"
"	}\n"
"      if$\n"
"    }\n"
"    { \"\" }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {format.edition}\n"
"{ edition empty$\n"
"    { \"\" }\n"
"    { output.state mid.sentence =\n"
"	{ edition \"l\" change.case$ \" edition\" * }\n"
"	{ edition \"t\" change.case$ \" edition\" * }\n"
"      if$\n"
"    }\n"
"  if$\n"
"}\n"
"\n"
"INTEGERS { multiresult }\n"
"\n"
"FUNCTION {multi.page.check}\n"
"{ 't :=\n"
"  #0 'multiresult :=\n"
"    { multiresult not\n"
"      t empty$ not\n"
"      and\n"
"    }\n"
"    { t #1 #1 substring$\n"
"      duplicate$ \"-\" =\n"
"      swap$ duplicate$ \",\" =\n"
"      swap$ \"+\" =\n"
"      or or\n"
"	{ #1 'multiresult := }\n"
"	{ t #2 global.max$ substring$ 't := }\n"
"      if$\n"
"    }\n"
"  while$\n"
"  multiresult\n"
"}\n"
"\n"
"FUNCTION {format.pages}\n"
"{ pages empty$\n"
"    { \"\" }\n"
"    { pages multi.page.check\n"
"	{ \"pages\" pages n.dashify tie.or.space.connect }\n"
"	{ \"page\" pages tie.or.space.connect }\n"
"      if$\n"
"    }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {format.vol.num.pages}\n"
"{ volume field.or.null\n"
"  number empty$\n"
"    'skip$\n"
"    { \"(\" number * \")\" * *\n"
"      volume empty$\n"
"	{ \"there's a number but no volume in \" cite$ * warning$ }\n"
"	'skip$\n"
"      if$\n"
"    }\n"
"  if$\n"
"  pages empty$\n"
"    'skip$\n"
"    { duplicate$ empty$\n"
"	{ pop$ format.pages }\n"
"	{ \":\" * pages n.dashify * }\n"
"      if$\n"
"    }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {format.chapter.pages}\n"
"{ chapter empty$\n"
"    'format.pages\n"
"    { type empty$\n"
"	{ \"chapter\" }\n"
"	{ type \"l\" change.case$ }\n"
"      if$\n"
"      chapter tie.or.space.connect\n"
"      pages empty$\n"
"	'skip$\n"
"	{ \", \" * format.pages * }\n"
"      if$\n"
"    }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {format.in.ed.booktitle}\n"
"{ booktitle empty$\n"
"    { \"\" }\n"
"    { editor empty$\n"
"	{ \"In \" booktitle emphasize * }\n"
"	{ \"In \" format.editors * \", \" * booktitle emphasize * }\n"
"      if$\n"
"    }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {empty.misc.check}\n"
"{ author empty$ title empty$ howpublished empty$\n"
"  month empty$ year empty$ note empty$\n"
"  and and and and and\n"
"  key empty$ not and\n"
"    { \"all relevant fields are empty in \" cite$ * warning$ }\n"
"    'skip$\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {format.thesis.type}\n"
"{ type empty$\n"
"    'skip$\n"
"    { pop$\n"
"      type \"t\" change.case$\n"
"    }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {format.tr.number}\n"
"{ type empty$\n"
"    { \"Technical Report\" }\n"
"    'type\n"
"  if$\n"
"  number empty$\n"
"    { \"t\" change.case$ }\n"
"    { number tie.or.space.connect }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {format.article.crossref}\n"
"{ key empty$\n"
"    { journal empty$\n"
"	{ \"need key or journal for \" cite$ * \" to crossref \" * crossref *\n"
"	  warning$\n"
"	  \"\"\n"
"	}\n"
"	{ \"In <em>\" journal * \"</em>\" * }\n"
"      if$\n"
"    }\n"
"    { \"In \" key * }\n"
"  if$\n"
"  \" <span class='cite'>\" * crossref * \"</span>\" *\n"
"}\n"
"\n"
"FUNCTION {format.crossref.editor}\n"
"{ editor #1 \"{vv~}{ll}\" format.name$\n"
"  editor num.names$ duplicate$\n"
"  #2 >\n"
"    { pop$ \" et~al.\" * }\n"
"    { #2 <\n"
"	'skip$\n"
"	{ editor #2 \"{ff }{vv }{ll}{ jj}\" format.name$ \"others\" =\n"
"	    { \" et~al.\" * }\n"
"	    { \" and \" * editor #2 \"{vv~}{ll}\" format.name$ * }\n"
"	  if$\n"
"	}\n"
"      if$\n"
"    }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {format.book.crossref}\n"
"{ volume empty$\n"
"    { \"empty volume in \" cite$ * \"'s crossref of \" * crossref * warning$\n"
"      \"In \"\n"
"    }\n"
"    { \"Volume\" volume tie.or.space.connect\n"
"      \" of \" *\n"
"    }\n"
"  if$\n"
"  editor empty$\n"
"  editor field.or.null author field.or.null =\n"
"  or\n"
"    { key empty$\n"
"	{ series empty$\n"
"	    { \"need editor, key, or series for \" cite$ * \" to crossref \" *\n"
"	      crossref * warning$\n"
"	      \"\" *\n"
"	    }\n"
"	    { \"<em>\" * series * \"</em>\" * }\n"
"	  if$\n"
"	}\n"
"	{ key * }\n"
"      if$\n"
"    }\n"
"    { format.crossref.editor * }\n"
"  if$\n"
"  \" <span class='cite'>\" * crossref * \"</span>\" *\n"
"}\n"
"\n"
"FUNCTION {format.incoll.inproc.crossref}\n"
"{ editor empty$\n"
"  editor field.or.null author field.or.null =\n"
"  or\n"
"    { key empty$\n"
"	{ booktitle empty$\n"
"	    { \"need editor, key, or booktitle for \" cite$ * \" to crossref \" *\n"
"	      crossref * warning$\n"
"	      \"\"\n"
"	    }\n"
"	    { \"In <em>\" booktitle * \"</em>\" * }\n"
"	  if$\n"
"	}\n"
"	{ \"In \" key * }\n"
"      if$\n"
"    }\n"
"    { \"In \" format.crossref.editor * }\n"
"  if$\n"
"  \" <span class='cite'>\" * crossref * \"</span>\" *\n"
"}\n"
"\n"
"% urlbst...\n"
"% Functions for making hypertext links.\n"
"FUNCTION {make.href}\n"
"{ \n"
"  \"<a href='\" swap$ * \"'><code>\" * swap$ * \"</code></a>\" *\n"
"}\n"
"\n"
"% If inlinelinks is true, then format.url should be a no-op, since it's\n"
"% (a) redundant, and (b) could end up as a link-within-a-link.\n"
"FUNCTION {format.url}\n"
"{ inlinelinks #1 = url empty$ or\n"
"    { \"\" }\n"
"    { urlintro \"<code>\" * url * \"</code>\" * }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {format.eprint}\n"
"{ eprint empty$\n"
"    { \"\" }\n"
"    { eprintprefix eprint * eprinturl eprint * make.href }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {format.doi}\n"
"{ doi empty$\n"
"    { \"\" }\n"
"    { doiform #0 =\n"
"        { doiprefix doi * doiurl doi * make.href }\n"
"        { \"DOI:{\" doi * \"}\" * }\n"
"      if$\n"
"    }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {format.pubmed}\n"
"{ pubmed empty$\n"
"    { \"\" }\n"
"    { pubmedprefix pubmed * pubmedurl pubmed * make.href }\n"
"  if$\n"
"}\n"
"\n"
"% Output a URL.  We can't use the more normal idiom (something like\n"
"% `format.url output'), because the `inbrackets' within\n"
"% format.lastchecked applies to everything between calls to `output',\n"
"% so that `format.url format.lastchecked * output' ends up with both\n"
"% the URL and the lastchecked in brackets.\n"
"FUNCTION {output.url}\n"
"{ url empty$\n"
"    'skip$ \n"
"    { new.block \n"
"      format.url output\n"
"      format.lastchecked output \n"
"    }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {output.web.refs}\n"
"{\n"
"  new.block\n"
"  output.url\n"
"  addeprints eprint empty$ not and\n"
"    { format.eprint output.nonnull }\n"
"    'skip$\n"
"  if$\n"
"  adddoiresolver doi empty$ not and\n"
"    { format.doi output.nonnull }\n"
"    'skip$\n"
"  if$\n"
"  addpubmedresolver pubmed empty$ not and\n"
"    { format.pubmed output.nonnull }\n"
"    'skip$\n"
"  if$\n"
"}\n"
"\n"
"% Wrapper for output.bibitem.original.\n"
"% If the URL field is not empty, set makeinlinelink to be true,\n"
"% so that an inline link will be started at the next opportunity\n"
"FUNCTION {output.bibitem}\n"
"{ outside.brackets 'bracket.state :=\n"
"  output.bibitem.original\n"
"  inlinelinks url empty$ not and\n"
"    { #1 'makeinlinelink := }\n"
"    { #0 'makeinlinelink := }\n"
"  if$\n"
"}\n"
"\n"
"% Wrapper for fin.entry.original\n"
"FUNCTION {fin.entry}\n"
"{ output.web.refs  % urlbst\n"
"  makeinlinelink       % ooops, it appears we didn't have a title for inlinelink\n"
"    { possibly.setup.inlinelink % add some artificial link text here, as a fallback\n"
"      \"[link]\" output.nonnull }\n"
"    'skip$\n"
"  if$\n"
"  bracket.state close.brackets = % urlbst\n"
"    { \"]\" * }\n"
"    'skip$\n"
"  if$\n"
"  fin.entry.original\n"
"}\n"
"\n"
"% Webpage entry type.\n"
"% Title and url fields required;\n"
"% author, note, year, month, and lastchecked fields optional\n"
"% See references \n"
"%   ISO 690-2 http://www.nlc-bnc.ca/iso/tc46sc9/standard/690-2e.htm\n"
"%   http://www.classroom.net/classroom/CitingNetResources.html\n"
"%   http://neal.ctstateu.edu/history/cite.html\n"
"%   http://www.cas.usf.edu/english/walker/mla.html\n"
"% for citation formats for web pages.\n"
"FUNCTION {webpage}\n"
"{ output.bibitem\n"
"  author empty$\n"
"    { editor empty$\n"
"        'skip$  % author and editor both optional\n"
"        { format.editors output.nonnull }\n"
"      if$\n"
"    }\n"
"    { editor empty$\n"
"        { format.authors output.nonnull }\n"
"        { \"can't use both author and editor fields in \" cite$ * warning$ }\n"
"      if$\n"
"    }\n"
"  if$\n"
"  new.block\n"
"  title empty$ 'skip$ 'possibly.setup.inlinelink if$\n"
"  format.title \"title\" output.check\n"
"  inbrackets \"online\" output\n"
"  new.block\n"
"  year empty$\n"
"    'skip$\n"
"    { format.date \"year\" output.check }\n"
"  if$\n"
"  % We don't need to output the URL details ('lastchecked' and 'url'),\n"
"  % because fin.entry does that for us, using output.web.refs.  The only\n"
"  % reason we would want to put them here is if we were to decide that\n"
"  % they should go in front of the rather miscellaneous information in 'note'.\n"
"  new.block\n"
"  note output\n"
"  fin.entry\n"
"}\n"
"% ...urlbst to here\n"
"\n"
"\n"
"FUNCTION {article}\n"
"{ output.bibitem\n"
"  format.authors \"author\" output.check\n"
"  new.block\n"
"  title empty$ 'skip$ 'possibly.setup.inlinelink if$ % urlbst\n"
"  format.title \"title\" output.check\n"
"  new.block\n"
"  crossref missing$\n"
"    { journal emphasize \"journal\" output.check\n"
"      possibly.setup.inlinelink format.vol.num.pages output% urlbst\n"
"      format.date \"year\" output.check\n"
"    }\n"
"    { format.article.crossref output.nonnull\n"
"      format.pages output\n"
"    }\n"
"  if$\n"
"  new.block\n"
"  note output\n"
"  fin.entry\n"
"}\n"
"\n"
"FUNCTION {book}\n"
"{ output.bibitem\n"
"  author empty$\n"
"    { format.editors \"author and editor\" output.check }\n"
"    { format.authors output.nonnull\n"
"      crossref missing$\n"
"	{ \"author and editor\" editor either.or.check }\n"
"	'skip$\n"
"      if$\n"
"    }\n"
"  if$\n"
"  new.block\n"
"  title empty$ 'skip$ 'possibly.setup.inlinelink if$ % urlbst\n"
"  format.btitle \"title\" output.check\n"
"  crossref missing$\n"
"    { format.bvolume output\n"
"      new.block\n"
"      format.number.series output\n"
"      new.sentence\n"
"      publisher \"publisher\" output.check\n"
"      address output\n"
"    }\n"
"    { new.block\n"
"      format.book.crossref output.nonnull\n"
"    }\n"
"  if$\n"
"  format.edition output\n"
"  format.date \"year\" output.check\n"
"  new.block\n"
"  note output\n"
"  fin.entry\n"
"}\n"
"\n"
"FUNCTION {booklet}\n"
"{ output.bibitem\n"
"  format.authors output\n"
"  new.block\n"
"  title empty$ 'skip$ 'possibly.setup.inlinelink if$ % urlbst\n"
"  format.title \"title\" output.check\n"
"  howpublished address new.block.checkb\n"
"  howpublished output\n"
"  address output\n"
"  format.date output\n"
"  new.block\n"
"  note output\n"
"  fin.entry\n"
"}\n"
"\n"
"FUNCTION {inbook}\n"
"{ output.bibitem\n"
"  author empty$\n"
"    { format.editors \"author and editor\" output.check }\n"
"    { format.authors output.nonnull\n"
"      crossref missing$\n"
"	{ \"author and editor\" editor either.or.check }\n"
"	'skip$\n"
"      if$\n"
"    }\n"
"  if$\n"
"  new.block\n"
"  title empty$ 'skip$ 'possibly.setup.inlinelink if$ % urlbst\n"
"  format.btitle \"title\" output.check\n"
"  crossref missing$\n"
"    { format.bvolume output\n"
"      format.chapter.pages \"chapter and pages\" output.check\n"
"      new.block\n"
"      format.number.series output\n"
"      new.sentence\n"
"      publisher \"publisher\" output.check\n"
"      address output\n"
"    }\n"
"    { format.chapter.pages \"chapter and pages\" output.check\n"
"      new.block\n"
"      format.book.crossref output.nonnull\n"
"    }\n"
"  if$\n"
"  format.edition output\n"
"  format.date \"year\" output.check\n"
"  new.block\n"
"  note output\n"
"  fin.entry\n"
"}\n"
"\n"
"FUNCTION {incollection}\n"
"{ output.bibitem\n"
"  format.authors \"author\" output.check\n"
"  new.block\n"
"  title empty$ 'skip$ 'possibly.setup.inlinelink if$ % urlbst\n"
"  format.title \"title\" output.check\n"
"  new.block\n"
"  crossref missing$\n"
"    { format.in.ed.booktitle \"booktitle\" output.check\n"
"      format.bvolume output\n"
"      format.number.series output\n"
"      format.chapter.pages output\n"
"      new.sentence\n"
"      publisher \"publisher\" output.check\n"
"      address output\n"
"      format.edition output\n"
"      format.date \"year\" output.check\n"
"    }\n"
"    { format.incoll.inproc.crossref output.nonnull\n"
"      format.chapter.pages output\n"
"    }\n"
"  if$\n"
"  new.block\n"
"  note output\n"
"  fin.entry\n"
"}\n"
"\n"
"FUNCTION {inproceedings}\n"
"{ output.bibitem\n"
"  format.authors \"author\" output.check\n"
"  new.block\n"
"  title empty$ 'skip$ 'possibly.setup.inlinelink if$ % urlbst\n"
"  format.title \"title\" output.check\n"
"  new.block\n"
"  crossref missing$\n"
"    { format.in.ed.booktitle \"booktitle\" output.check\n"
"      format.bvolume output\n"
"      format.number.series output\n"
"      format.pages output\n"
"      address empty$\n"
"	{ organization publisher new.sentence.checkb\n"
"	  organization output\n"
"	  publisher output\n"
"	  format.date \"year\" output.check\n"
"	}\n"
"	{ address output.nonnull\n"
"	  format.date \"year\" output.check\n"
"	  new.sentence\n"
"	  organization output\n"
"	  publisher output\n"
"	}\n"
"      if$\n"
"    }\n"
"    { format.incoll.inproc.crossref output.nonnull\n"
"      format.pages output\n"
"    }\n"
"  if$\n"
"  new.block\n"
"  note output\n"
"  fin.entry\n"
"}\n"
"\n"
"FUNCTION {conference} { inproceedings }\n"
"\n"
"FUNCTION {manual}\n"
"{ output.bibitem\n"
"  author empty$\n"
"    { organization empty$\n"
"	'skip$\n"
"	{ organization output.nonnull\n"
"	  address output\n"
"	}\n"
"      if$\n"
"    }\n"
"    { format.authors output.nonnull }\n"
"  if$\n"
"  new.block\n"
"  title empty$ 'skip$ 'possibly.setup.inlinelink if$ % urlbst\n"
"  format.btitle \"title\" output.check\n"
"  author empty$\n"
"    { organization empty$\n"
"	{ address new.block.checka\n"
"	  address output\n"
"	}\n"
"	'skip$\n"
"      if$\n"
"    }\n"
"    { organization address new.block.checkb\n"
"      organization output\n"
"      address output\n"
"    }\n"
"  if$\n"
"  format.edition output\n"
"  format.date output\n"
"  new.block\n"
"  note output\n"
"  fin.entry\n"
"}\n"
"\n"
"FUNCTION {mastersthesis}\n"
"{ output.bibitem\n"
"  format.authors \"author\" output.check\n"
"  new.block\n"
"  title empty$ 'skip$ 'possibly.setup.inlinelink if$ % urlbst\n"
"  format.title \"title\" output.check\n"
"  new.block\n"
"  \"Master's thesis\" format.thesis.type output.nonnull\n"
"  school \"school\" output.check\n"
"  address output\n"
"  format.date \"year\" output.check\n"
"  new.block\n"
"  note output\n"
"  fin.entry\n"
"}\n"
"\n"
"FUNCTION {misc}\n"
"{ output.bibitem\n"
"  format.authors output\n"
"  title howpublished new.block.checkb\n"
"  title empty$ 'skip$ 'possibly.setup.inlinelink if$ % urlbst\n"
"  format.title output\n"
"  howpublished new.block.checka\n"
"  howpublished output\n"
"  format.date output\n"
"  new.block\n"
"  note output\n"
"  fin.entry\n"
"  empty.misc.check\n"
"}\n"
"\n"
"FUNCTION {phdthesis}\n"
"{ output.bibitem\n"
"  format.authors \"author\" output.check\n"
"  new.block\n"
"  title empty$ 'skip$ 'possibly.setup.inlinelink if$ % urlbst\n"
"  format.btitle \"title\" output.check\n"
"  new.block\n"
"  \"PhD thesis\" format.thesis.type output.nonnull\n"
"  school \"school\" output.check\n"
"  address output\n"
"  format.date \"year\" output.check\n"
"  new.block\n"
"  note output\n"
"  fin.entry\n"
"}\n"
"\n"
"FUNCTION {proceedings}\n"
"{ output.bibitem\n"
"  editor empty$\n"
"    { organization output }\n"
"    { format.editors output.nonnull }\n"
"  if$\n"
"  new.block\n"
"  title empty$ 'skip$ 'possibly.setup.inlinelink if$ % urlbst\n"
"  format.btitle \"title\" output.check\n"
"  format.bvolume output\n"
"  format.number.series output\n"
"  address empty$\n"
"    { editor empty$\n"
"	{ publisher new.sentence.checka }\n"
"	{ organization publisher new.sentence.checkb\n"
"	  organization output\n"
"	}\n"
"      if$\n"
"      publisher output\n"
"      format.date \"year\" output.check\n"
"    }\n"
"    { address output.nonnull\n"
"      format.date \"year\" output.check\n"
"      new.sentence\n"
"      editor empty$\n"
"	'skip$\n"
"	{ organization output }\n"
"      if$\n"
"      publisher output\n"
"    }\n"
"  if$\n"
"  new.block\n"
"  note output\n"
"  fin.entry\n"
"}\n"
"\n"
"FUNCTION {techreport}\n"
"{ output.bibitem\n"
"  format.authors \"author\" output.check\n"
"  new.block\n"
"  title empty$ 'skip$ 'possibly.setup.inlinelink if$ % urlbst\n"
"  format.title \"title\" output.check\n"
"  new.block\n"
"  format.tr.number output.nonnull\n"
"  institution \"institution\" output.check\n"
"  address output\n"
"  format.date \"year\" output.check\n"
"  new.block\n"
"  note output\n"
"  fin.entry\n"
"}\n"
"\n"
"FUNCTION {unpublished}\n"
"{ output.bibitem\n"
"  format.authors \"author\" output.check\n"
"  new.block\n"
"  title empty$ 'skip$ 'possibly.setup.inlinelink if$ % urlbst\n"
"  format.title \"title\" output.check\n"
"  new.block\n"
"  note \"note\" output.check\n"
"  format.date output\n"
"  fin.entry\n"
"}\n"
"\n"
"FUNCTION {default.type} { misc }\n"
"MACRO {jan} {\"January\"}\n"
"MACRO {feb} {\"February\"}\n"
"MACRO {mar} {\"March\"}\n"
"MACRO {apr} {\"April\"}\n"
"MACRO {may} {\"May\"}\n"
"MACRO {jun} {\"June\"}\n"
"MACRO {jul} {\"July\"}\n"
"MACRO {aug} {\"August\"}\n"
"MACRO {sep} {\"September\"}\n"
"MACRO {oct} {\"October\"}\n"
"MACRO {nov} {\"November\"}\n"
"MACRO {dec} {\"December\"}\n"
"MACRO {acmcs} {\"ACM Computing Surveys\"}\n"
"MACRO {acta} {\"Acta Informatica\"}\n"
"MACRO {cacm} {\"Communications of the ACM\"}\n"
"MACRO {ibmjrd} {\"IBM Journal of Research and Development\"}\n"
"MACRO {ibmsj} {\"IBM Systems Journal\"}\n"
"MACRO {ieeese} {\"IEEE Transactions on Software Engineering\"}\n"
"MACRO {ieeetc} {\"IEEE Transactions on Computers\"}\n"
"MACRO {ieeetcad} {\"IEEE Transactions on Computer-Aided Design of Integrated Circuits\"}\n"
"MACRO {ipl} {\"Information Processing Letters\"}\n"
"MACRO {jacm} {\"Journal of the ACM\"}\n"
"MACRO {jcss} {\"Journal of Computer and System Sciences\"}\n"
"MACRO {scp} {\"Science of Computer Programming\"}\n"
"MACRO {sicomp} {\"SIAM Journal on Computing\"}\n"
"MACRO {tocs} {\"ACM Transactions on Computer Systems\"}\n"
"MACRO {tods} {\"ACM Transactions on Database Systems\"}\n"
"MACRO {tog} {\"ACM Transactions on Graphics\"}\n"
"MACRO {toms} {\"ACM Transactions on Mathematical Software\"}\n"
"MACRO {toois} {\"ACM Transactions on Office Information Systems\"}\n"
"MACRO {toplas} {\"ACM Transactions on Programming Languages and Systems\"}\n"
"MACRO {tcs} {\"Theoretical Computer Science\"}\n"
"\n"
"READ\n"
"\n"
"FUNCTION {sortify}\n"
"{ purify$\n"
"  \"l\" change.case$\n"
"}\n"
"\n"
"INTEGERS { len }\n"
"\n"
"FUNCTION {chop.word}\n"
"{ 's :=\n"
"  'len :=\n"
"  s #1 len substring$ =\n"
"    { s len #1 + global.max$ substring$ }\n"
"    's\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {sort.format.names}\n"
"{ 's :=\n"
"  #1 'nameptr :=\n"
"  \"\"\n"
"  s num.names$ 'numnames :=\n"
"  numnames 'namesleft :=\n"
"    { namesleft #0 > }\n"
"    { nameptr #1 >\n"
"	{ \"   \" * }\n"
"	'skip$\n"
"      if$\n"
"      s nameptr \"{vv{ } }{ll{ }}{  ff{ }}{  jj{ }}\" format.name$ 't :=\n"
"      nameptr numnames = t \"others\" = and\n"
"	{ \"et al\" * }\n"
"	{ t sortify * }\n"
"      if$\n"
"      nameptr #1 + 'nameptr :=\n"
"      namesleft #1 - 'namesleft :=\n"
"    }\n"
"  while$\n"
"}\n"
"\n"
"FUNCTION {sort.format.title}\n"
"{ 't :=\n"
"  \"A \" #2\n"
"    \"An \" #3\n"
"      \"The \" #4 t chop.word\n"
"    chop.word\n"
"  chop.word\n"
"  sortify\n"
"  #1 global.max$ substring$\n"
"}\n"
"\n"
"FUNCTION {author.sort}\n"
"{ author empty$\n"
"    { key empty$\n"
"	{ \"to sort, need author or key in \" cite$ * warning$\n"
"	  \"\"\n"
"	}\n"
"	{ key sortify }\n"
"      if$\n"
"    }\n"
"    { author sort.format.names }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {author.editor.sort}\n"
"{ author empty$\n"
"    { editor empty$\n"
"	{ key empty$\n"
"	    { \"to sort, need author, editor, or key in \" cite$ * warning$\n"
"	      \"\"\n"
"	    }\n"
"	    { key sortify }\n"
"	  if$\n"
"	}\n"
"	{ editor sort.format.names }\n"
"      if$\n"
"    }\n"
"    { author sort.format.names }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {author.organization.sort}\n"
"{ author empty$\n"
"    { organization empty$\n"
"	{ key empty$\n"
"	    { \"to sort, need author, organization, or key in \" cite$ * warning$\n"
"	      \"\"\n"
"	    }\n"
"	    { key sortify }\n"
"	  if$\n"
"	}\n"
"	{ \"The \" #4 organization chop.word sortify }\n"
"      if$\n"
"    }\n"
"    { author sort.format.names }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {editor.organization.sort}\n"
"{ editor empty$\n"
"    { organization empty$\n"
"	{ key empty$\n"
"	    { \"to sort, need editor, organization, or key in \" cite$ * warning$\n"
"	      \"\"\n"
"	    }\n"
"	    { key sortify }\n"
"	  if$\n"
"	}\n"
"	{ \"The \" #4 organization chop.word sortify }\n"
"      if$\n"
"    }\n"
"    { editor sort.format.names }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {presort.by.author}\n"
"{ type$ \"book\" =\n"
"  type$ \"inbook\" =\n"
"  or\n"
"    'author.editor.sort\n"
"    { type$ \"proceedings\" =\n"
"	'editor.organization.sort\n"
"	{ type$ \"manual\" =\n"
"	    'author.organization.sort\n"
"	    'author.sort\n"
"	  if$\n"
"	}\n"
"      if$\n"
"    }\n"
"  if$\n"
"  \"    \"\n"
"  *\n"
"  year field.or.null sortify\n"
"  *\n"
"  \"    \"\n"
"  *\n"
"  title field.or.null\n"
"  sort.format.title\n"
"  *\n"
"  #1 entry.max$ substring$\n"
"  'sort.key$ :=\n"
"}\n"
"\n"
"FUNCTION {presort.by.year}\n"
"{ year field.or.null sortify\n"
"  \"    \"\n"
"  *\n"
"  type$ \"book\" =\n"
"  type$ \"inbook\" =\n"
"  or\n"
"    'author.editor.sort\n"
"    { type$ \"proceedings\" =\n"
"	'editor.organization.sort\n"
"	{ type$ \"manual\" =\n"
"	    'author.organization.sort\n"
"	    'author.sort\n"
"	  if$\n"
"	}\n"
"      if$\n"
"    }\n"
"  if$\n"
"  *\n"
"  \"    \"\n"
"  *\n"
"  title field.or.null\n"
"  sort.format.title\n"
"  *\n"
"  #1 entry.max$ substring$\n"
"  'sort.key$ :=\n"
"}\n"
"\n"
"ITERATE {presort.by.author}\n"
"\n"
"SORT\n"
"\n"
"STRINGS { longest.label }\n"
"\n"
"INTEGERS { number.label longest.label.width }\n"
"\n"
"FUNCTION {initialize.longest.label}\n"
"{ \"\" 'longest.label :=\n"
"  #1 'number.label :=\n"
"  #0 'longest.label.width :=\n"
"}\n"
"\n"
"FUNCTION {longest.label.pass}\n"
"{ number.label int.to.str$ 'label :=\n"
"  number.label #1 + 'number.label :=\n"
"  label width$ longest.label.width >\n"
"    { label 'longest.label :=\n"
"      label width$ 'longest.label.width :=\n"
"    }\n"
"    'skip$\n"
"  if$\n"
"}\n"
"\n"
"EXECUTE {initialize.longest.label}\n"
"\n"
"ITERATE {longest.label.pass}\n"
"\n"
"FUNCTION {begin.bib}\n"
"{ preamble$ empty$\n"
"    'skip$\n"
"    { preamble$ write$ newline$ }\n"
"  if$\n"
"  %\"/** \\page bibref References\" write$ newline$\n"
"  newline$\n"
"}\n"
"\n"
"EXECUTE {begin.bib}\n"
"\n"
"EXECUTE {init.urlbst.variables}\n"
"EXECUTE {init.state.consts}\n"
"\n"
"ITERATE {call.type$}\n"
"\n"
"FUNCTION {end.bib}\n"
"{ newline$\n"
"  %\"*/\" write$ newline$\n"
"}\n"
"\n"
"EXECUTE {end.bib}\n"
"\n"
