/* -*- C++ -*-
 *
 * Copyright (C) 2006 Trolltech AS. All rights reserved.
 *    Author: Thiago Macieira <thiago.macieira@trolltech.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

/*
 * This file was generated by dbusidl2cpp version 0.3
 * when processing input file -
 *
 * dbusidl2cpp is Copyright (C) 2006 Trolltech AS. All rights reserved.
 *
 * This file has been hand-edited! Be careful when re-generating it!
 *
 */

#ifndef QDBUSBUS_H
#define QDBUSBUS_H

#include <QtCore/qstringlist.h>

#include "qdbusabstractinterface.h"
#include "qdbusreply.h"

class QDBusConnection;
class QString;
class QByteArray;

/*
 * Proxy class for interface org.freedesktop.DBus
 */
class QDBUS_EXPORT QDBusBusService: public QDBusAbstractInterface
{
    Q_OBJECT
    friend class QDBusConnection;
    static inline const char *staticInterfaceName();

    explicit QDBusBusService(QDBusAbstractInterfacePrivate *p);

    ~QDBusBusService();

public:
    // taken out of http://dbus.freedesktop.org/doc/dbus-specification.html
    // update if the standard updates
    enum RequestNameOption {
        QueueName = 0x0,
        AllowReplacingName = 0x1,
        ReplaceExistingName = 0x2,
        DoNotQueueName = 0x4
    };
    Q_DECLARE_FLAGS(RequestNameOptions, RequestNameOption)

    enum RequestNameReply {
        PrimaryOwnerReply = 1,
        InQueueReply = 2,
        NameExistsReply = 3,
        AlreadyOwnerReply = 4
    };

    enum ReleaseNameReply {
        NameReleasedReply = 1,
        NameNonExistentReply = 2,
        NotOwnerReply = 3
    };

    enum StartServiceReply {
        Success = 1,
        AlreadyRunning = 2
    };    

#ifndef Q_QDOC
    // D-Bus names
public: // METHODS
    QDBusReply<QString> Hello();
    QDBusReply<void> ReloadConfig();

    QDBusReply<QStringList> ListNames();
        
    QDBusReply<bool> NameHasOwner(const QString &service);
    QDBusReply<QString> GetNameOwner(const QString &name);
    QDBusReply<ReleaseNameReply> ReleaseName(const QString &service);    
    QDBusReply<RequestNameReply> RequestName(const QString &service, RequestNameOptions flags);
    QDBusReply<QStringList> ListQueuedOwners(const QString &service);

    QDBusReply<void> AddMatch(const QString &rule);
    QDBusReply<void> RemoveMatch(const QString &rule);

    QDBusReply<QByteArray> GetConnectionSELinuxSecurityContext(const QString &service);
    QDBusReply<uint> GetConnectionUnixProcessID(const QString &service);
    QDBusReply<uint> GetConnectionUnixUser(const QString &service);

    QDBusReply<StartServiceReply> StartServiceByName(const QString &name, uint flags);

Q_SIGNALS: // SIGNALS
    void NameAcquired(const QString &service);
    void NameLost(const QString &service);
    void NameOwnerChanged(const QString &name, const QString &oldOwner, const QString &newOwner);
#endif

    // Qt-style naming    
public Q_SLOTS:
    QDBusReply<QString> hello()
    { return Hello(); }
    QDBusReply<void> reloadConfig()
    { return ReloadConfig(); }

    QDBusReply<QStringList> listNames()
    { return ListNames(); }
        
    QDBusReply<bool> nameHasOwner(const QString &serviceName)
    { return NameHasOwner(serviceName); }
    QDBusReply<QString> nameOwner(const QString &name)
    { return GetNameOwner(name); }
    QDBusReply<ReleaseNameReply> releaseName(const QString &serviceName)
    { return ReleaseName(serviceName); }
    QDBusReply<RequestNameReply> requestName(const QString &serviceName, RequestNameOptions flags = QueueName)
    { return RequestName(serviceName, flags); }
    QDBusReply<QStringList> listQueuedOwners(const QString &serviceName)
    { return ListQueuedOwners(serviceName); }

    QDBusReply<void> addMatch(const QString &rule)
    { return AddMatch(rule); }
    QDBusReply<void> removeMatch(const QString &rule)
    { return RemoveMatch(rule); }

    QDBusReply<QByteArray> connectionSELinuxSecurityContext(const QString &serviceName)
    { return GetConnectionSELinuxSecurityContext(serviceName); }
    QDBusReply<uint> connectionUnixProcessID(const QString &serviceName)
    { return GetConnectionUnixProcessID(serviceName); }
    QDBusReply<uint> connectionUnixUser(const QString &serviceName)
    { return GetConnectionUnixUser(serviceName); }

    QDBusReply<StartServiceReply> startServiceByName(const QString &name, uint flags)
    { return StartServiceByName(name, flags); }

Q_SIGNALS:
    void nameAcquired(const QString &service);
    void nameLost(const QString &service);
    void nameOwnerChanged(const QString &name, const QString &oldOwner, const QString &newOwner);
};

Q_DECLARE_OPERATORS_FOR_FLAGS(QDBusBusService::RequestNameOptions)

#endif
