/*
 *   CUPS/PWG Raster utilities header file for CUPS.
 *
 *   Copyright 2013 by Till Kamppeter.
 *
 *   Distribution and use rights are outlined in the file "COPYING"
 *   which should have been included with this file.
 */

#ifndef _CUPSFILTERS_RASTER_H_
#  define _CUPSFILTERS_RASTER_H_

#  ifdef __cplusplus
extern "C" {
#  endif /* __cplusplus */

/*
 * Include necessary headers...
 */

#  include <stdio.h>
#  include <stdlib.h>
#  include <time.h>
#  include <math.h>

#  if defined(WIN32) || defined(__EMX__)
#    include <io.h>
#  else
#    include <unistd.h>
#    include <fcntl.h>
#  endif /* WIN32 || __EMX__ */

#  include <cups/cups.h>
#  include <cups/raster.h>

/*
 * Prototypes...
 */

extern int              cupsRasterParseIPPOptions(cups_page_header2_t *h,
						  int num_options,
						  cups_option_t *options,
						  int pwg_raster,
						  int set_defaults);

#  ifdef __cplusplus
}
#  endif /* __cplusplus */

#endif /* !_CUPSFILTERS_RASTER_H_ */

/*
 * End
 */

