// Boost.Geometry (aka GGL, Generic Geometry Library)
//
// Copyright (c) 2011-2012 Barend Gehrels, Amsterdam, the Netherlands.

// Use, modification and distribution is subject to the Boost Software License,
// Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)
// File defining groups for Doxygen.
// Note that group descriptions are (currently) not used.

/*!
\defgroup access access: get/set coordinate values, make objects, clear geometries, append point(s)
\defgroup append append: append points to geometries
\defgroup area area: calculate area of a Geometry
\defgroup arithmetic arithmetic: arithmetic operations on points
\defgroup assign assign: assign values to geometries
\defgroup buffer buffer: calculate buffer of a geometry
\defgroup centroid centroid: calculate centroid (center of gravity) of a geometry
\defgroup clear clear: clear geometries
\defgroup compare compare: define compare functors for points
\defgroup concepts geometry concepts: defines and checks concepts for geometries
\defgroup convert convert: convert geometries from one type to another
\defgroup convex_hull convex hull: calculate the convex hull of a geometry
\defgroup core core: meta-functions for geometry types
\defgroup correct correct: correct geometries
\defgroup covered_by covered_by: detect if a geometry is inside or on the border of another geometry, a.o. point-in-polygon (border included)
\defgroup cs coordinate systems
\defgroup difference difference: difference of two geometries
\defgroup disjoint disjoint: detect if geometries are not spatially related
\defgroup distance distance: calculate distance between two geometries
\defgroup enum enum: enumerations
\defgroup envelope envelope: calculate envelope (minimum bounding rectangle) of a geometry
\defgroup equals equals: detect if two geometries are spatially equal
\defgroup expand expand: add a geometry to a bounding box
\defgroup exterior_ring exterior_ring: exterior_ring
\defgroup for_each for_each: apply a functor to each point or segment of a geometry
\defgroup geometries geometries: geometries provided by default
\defgroup get get: get geometries
\defgroup interior_rings interior_rings: interior_rings
\defgroup intersection intersection: calculate new geometry
\defgroup intersects intersects: detect if a geometry self-intersects or if two geometries intersect
\defgroup iterators iterators: iterators
\defgroup length length: calculate length of a linear geometry
\defgroup make make: construct geometries
\defgroup num_geometries number of geometries: calculate the number of geometries in a multi-geometry
\defgroup num_interior_rings number of interior rings: calculate the number of interior rings
\defgroup num_points number of points: calculate number of points of a geometry
\defgroup overlaps overlaps: detect overlap between two geometries
\defgroup perimeter perimeter: calculate perimeter of a geometry
\defgroup projection projection: Projection struct's, classes
\defgroup projections projections: Projections
\defgroup ranges ranges: ranges
\defgroup register register: Macros for registration
\defgroup reverse reverse: reverse a geometry
\defgroup selected selection: check if a geometry is "selected" by a point
\defgroup set set: set geometries
\defgroup simplify simplify: remove points from a geometry, keeping shape (simplification or generalization)
\defgroup strategies strategies: strategies
\defgroup svg x Extension svg: Stream SVG (Scalable Vector Graphics)
\defgroup sym_difference sym_difference: sym_difference of two geometries
\defgroup touches touches: detect if a geometry self-touches or if two geometries touch
\defgroup traits traits: adapt geometries
\defgroup transform transform: apply transformations on geometries
\defgroup union union: calculate new geometry containing geometries A or B
\defgroup unique unique: make a geometry unique w.r.t. points,
\defgroup within within: detect if a geometry is inside another geometry, a.o. point-in-polygon
\defgroup wkt wkt: parse and stream WKT (Well-Known Text)
*/
