/*
 * Decompiled with CFR 0.152.
 */
package org.netrexx.process;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Vector;
import netrexx.lang.Rexx;
import netrexx.lang.RexxIO;
import org.netrexx.process.RxChunk;
import org.netrexx.process.RxParser;
import org.netrexx.process.RxProgram;
import org.netrexx.process.RxQuit;
import org.netrexx.process.RxTranslator;
import org.netrexx.process.RxWarn;

public class RxStreamer {
    private static final Rexx $01 = Rexx.toRexx(".java");
    private static final Rexx $02 = Rexx.toRexx(".crossref");
    private static final Rexx $03 = Rexx.toRexx("# *** out:");
    private static final Rexx $04 = new Rexx('0');
    private static final Rexx $05 = Rexx.toRexx("#      ---");
    private static final Rexx $06 = Rexx.toRexx("[null]");
    private static final Rexx $07 = Rexx.toRexx("");
    private static final Rexx $08 = new Rexx('[');
    private static final Rexx $09 = new Rexx(']');
    private static final String $0 = "RxStreamer.nrx";
    private static final Rexx blank = new Rexx(' ');
    private static final Rexx linesep = new Rexx(System.getProperty("line.separator"));
    private static final char[] linesepchars = linesep.toCharArray();
    private static final char[] jcomstart = "//".toCharArray();
    private static final char[] jncomstart = "(-".toCharArray();
    private static final char[] jncomend = "-)".toCharArray();
    public Rexx outfile = Rexx.toRexx("");
    public Rexx outfilefull = Rexx.toRexx("");
    public int chunks = 0;
    public ByteArrayOutputStream byteoutstream = null;
    private File outfileob;
    private OutputStreamWriter outhandle;
    private int lastinlineno = 0;
    private Vector chunklist = new Vector(250, 500);
    private boolean outnewline = true;
    private int maxindent = 1;
    private Rexx xrffile = Rexx.toRexx("");
    private File xrffileob;
    private OutputStreamWriter xrfhandle;
    private RxTranslator rxt;
    private RxProgram program;

    public RxStreamer(RxTranslator rxTranslator, RxProgram rxProgram) {
        this.rxt = rxTranslator;
        this.program = rxProgram;
    }

    public void openfiles(Rexx rexx, Rexx rexx2) {
        int n;
        Rexx rexx3 = null;
        if (!this.program.flag.java && !this.program.flag.crossref) {
            return;
        }
        Rexx rexx4 = Rexx.toRexx(this.program.source.getName());
        String string = this.program.source.getPath();
        if (string == null) {
            string = "";
        }
        rexx3 = (n = rexx4.lastpos(new Rexx('.')).toint()) == 0 ? rexx4 : rexx4.left(new Rexx(n - 1));
        if (this.program.flag.java) {
            this.outfile = rexx != null ? rexx : rexx3.OpCc(null, $01);
            if (this.outfile.pos(new Rexx('.')).toint() == 0) {
                this.outfile = this.outfile.OpCc(null, $01);
            }
            if (this.outfile.right(new Rexx(5)).OpNotEqS(null, $01)) {
                throw new RxQuit(this.rxt, null, "output.extension.not.java", this.outfile);
            }
            this.outfilefull = Rexx.toRexx(string).OpCc(null, this.outfile);
            this.outfileob = new File(Rexx.toString(this.outfilefull));
        }
        this.xrffileob = this.createCrossrefFile(rexx2);
    }

    public File createCrossrefFile(Rexx rexx) {
        Rexx rexx2 = null;
        String string = null;
        int n = 0;
        Rexx rexx3 = null;
        if (this.program.flag.crossref) {
            rexx2 = Rexx.toRexx(this.program.source.getName());
            string = this.program.source.getPath();
            if (string == null) {
                string = "";
            }
            rexx3 = (n = rexx2.lastpos(new Rexx('.')).toint()) == 0 ? rexx2 : rexx2.left(new Rexx(n - 1));
            this.xrffile = rexx == null ? rexx3.OpCc(null, $02) : rexx;
            if (this.xrffile.pos(new Rexx('.')).toint() == 0) {
                this.xrffile = this.xrffile.OpCc(null, $02);
            }
            this.xrffileob = new File(Rexx.toString(Rexx.toRexx(string).OpCc(null, this.xrffile)));
        }
        return this.xrffileob;
    }

    public void outinsert(Rexx rexx, int n, int n2) {
        RxParser rxParser = null;
        if (!this.program.flag.java) {
            return;
        }
        if (!this.rxt.pass2) {
            if (this.program.flag.diag) {
                RexxIO.Say(Rexx.toRexx("# *** outi:").OpCcblank(null, rexx));
            }
            return;
        }
        if (this.program.flag.format) {
            rxParser = this.program.parser;
            if (rxParser.cursor.curclass != null) {
                n2 += rxParser.cursor.curclass.classinfo.parents;
            }
            rexx = linesep.OpCc(null, blank.copies(new Rexx(n2))).OpCc(null, rexx);
        }
        this.outinsertpart(rexx, n);
    }

    public void outinsertpart(Rexx rexx, int n) {
        if (!this.program.flag.java) {
            return;
        }
        if (!this.rxt.pass2) {
            if (this.program.flag.diag) {
                RexxIO.Say(Rexx.toRexx("# *** outip:").OpCcblank(null, rexx));
            }
            return;
        }
        if (n == 0) {
            return;
        }
        RxChunk rxChunk = (RxChunk)this.chunklist.elementAt(n - 1);
        rxChunk.insert = rxChunk.insert == null ? Rexx.toString(rexx) : Rexx.toString(Rexx.toRexx(rxChunk.insert).OpCc(null, rexx));
    }

    public void out(Rexx rexx) {
        this.out(rexx, false);
    }

    public void out(Rexx rexx, boolean bl) {
        if (!this.program.flag.java) {
            return;
        }
        if (!this.rxt.pass2) {
            if (this.program.flag.diag) {
                RexxIO.Say($03.OpCcblank(null, rexx));
            }
            return;
        }
        this.chunk(rexx, true, bl);
    }

    public void outpart(Rexx rexx) {
        this.outpart(rexx, false);
    }

    public void outpart(Rexx rexx, boolean bl) {
        if (!this.program.flag.java) {
            return;
        }
        if (!this.rxt.pass2) {
            if (this.program.flag.diag) {
                RexxIO.Say(Rexx.toRexx("# *** outp:").OpCcblank(null, rexx));
            }
            return;
        }
        this.chunk(rexx, false, bl);
    }

    private void chunk(Rexx rexx, boolean bl, boolean bl2) {
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        RxParser rxParser = this.program.parser;
        if (!bl2 && rxParser.cursor != null && rxParser.cursor.curclause != null && rxParser.cursor.curclause.tokens != null) {
            n = rxParser.cursor.curclause.tokens[0].line;
        }
        if (this.program.flag.format) {
            if (this.outnewline) {
                n2 = rxParser.indention;
                if (rxParser.cursor.curclass != null) {
                    n2 += rxParser.cursor.curclass.classinfo.parents;
                }
                if (n2 > this.maxindent) {
                    this.maxindent = n2;
                }
            }
            if (bl) {
                if (n != this.lastinlineno && n != 0 && rexx != null && !rexx.verify(Rexx.toRexx(" }{")).OpEqS(null, $04)) {
                    this.lastinlineno = n;
                }
                this.outnewline = true;
                n3 = rxParser.level;
                if (n3 > this.maxindent) {
                    this.maxindent = n3;
                }
            } else {
                this.outnewline = false;
            }
        }
        this.chunklist.addElement(new RxChunk(Rexx.tochararray(rexx), n, bl, n2, n3));
        ++this.chunks;
        if (this.program.flag.diag) {
            if (rexx == null) {
                RexxIO.Say($05.OpCcblank(null, blank.copies(new Rexx(rxParser.indention))).OpCc(null, $06));
            } else if (rexx.OpNotEqS(null, $07)) {
                rexx = rexx.changestr(new Rexx('\r'), new Rexx(' '));
                rexx = rexx.changestr(new Rexx('\n'), new Rexx(' '));
                RexxIO.Say($05.OpCcblank(null, blank.copies(new Rexx(rxParser.indention))).OpCc(null, rexx.strip()));
            } else {
                RexxIO.Say($05.OpCcblank(null, blank.copies(new Rexx(rxParser.indention))).OpCc(null, $08).OpCc(null, rexx).OpCc(null, $09));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void outwrite() {
        var1_1 = null;
        var2_2 = null;
        var4_3 = null;
        var5_4 = 0;
        var11_5 = 0;
        var12_6 = 0;
        var13_7 = 0;
        var14_8 = 0;
        var15_9 = null;
        var16_10 = 0;
        var17_11 = 0;
        var18_12 = null;
        var19_13 = 0;
        var20_14 = 0;
        var21_15 = null;
        var22_16 = null;
        if (!this.program.flag.java) {
            return;
        }
        if (this.chunks == 0) {
            return;
        }
        if (this.outhandle == null) {
            try {
                if (this.outfileob == null) {
                    return;
                }
                if (this.rxt.keep || this.rxt.keepasjava) {
                    var1_1 = new FileOutputStream(this.outfileob);
                }
                this.byteoutstream = new ByteArrayOutputStream(5000);
                this.outhandle = new OutputStreamWriter(this.byteoutstream);
            }
            catch (IOException var23_17) {
                var2_2 = var23_17;
                this.outfileob = null;
                throw new RxQuit(this.rxt, null, "error.opening.file", this.outfile, Rexx.toRexx(var2_2.getMessage()));
            }
        }
        var3_20 = true;
        if (this.program.flag.format) {
            var3_20 = false;
            var4_3 = new char[this.maxindent];
            var23_18 = this.maxindent;
            var5_4 = 0;
            while (var23_18 > 0) {
                var4_3[var5_4] = 32;
                --var23_18;
                ++var5_4;
            }
        }
        var6_21 = 1;
        var7_22 = null;
        var8_23 = false;
        var9_24 = 0;
        var10_25 = this.program.flag.comments;
        if (var10_25) {
            var11_5 = 1;
            var12_6 = 0;
            var13_7 = 0;
            this.chunklist.addElement(new RxChunk("".toCharArray(), this.program.source.getLineCount() + 1));
            ++this.chunks;
            if (var4_3 == null) {
                var4_3 = new char[]{' '};
            }
        }
        try {
            var23_18 = this.chunks;
            var14_8 = 0;
            while (var23_18 > 0) {
                block47: {
                    var15_9 = (RxChunk)this.chunklist.elementAt(var14_8);
                    if (!var10_25) break block47;
                    var16_10 = var15_9.line;
                    if (var16_10 == 0 && !var3_20 && var7_22 != null && var7_22.sep) {
                        var16_10 = var7_22.line + 1;
                    }
                    if (var16_10 <= var11_5) break block47;
                    if (var15_9.datachars == null && !var3_20) {
                        this.outhandle.write(RxStreamer.linesepchars, 0, RxStreamer.linesepchars.length);
                    }
                    var8_23 = false;
                    var17_11 = 0;
                    while ((var18_12 = this.program.source.getLine(var11_5)) != null) {
                        var13_7 = var17_11;
                        var24_26 = var18_12.length;
                        var5_4 = 0;
                        while (var24_26 > 0) {
                            if (var18_12[var5_4] != ' ') {
                                if (var13_7 <= var5_4) break;
                                var13_7 = var5_4;
                                break;
                            }
                            --var24_26;
                            ++var5_4;
                        }
                        if (var8_23) {
                            this.outhandle.write(var4_3, 0, var9_24);
                        }
                        var19_13 = 32;
                        var24_26 = var18_12.length - 2;
                        var5_4 = 0;
                        while (var5_4 <= var24_26) {
                            block49: {
                                block50: {
                                    block48: {
                                        var20_14 = var18_12[var5_4];
                                        if (var19_13 == 32) break block48;
                                        if (var20_14 == var19_13 && var18_12[var5_4 - 1] != '\\') {
                                            var19_13 = 32;
                                        }
                                        break block49;
                                    }
                                    if (var12_6 <= 0) break block50;
                                    var8_23 = false;
                                    if (var20_14 != 42 || var18_12[var5_4 + 1] != '/') ** GOTO lbl106
                                    if (--var12_6 == 0) {
                                        this.outhandle.write(var18_12, var13_7, var5_4 + 2 - var13_7);
                                        ++var5_4;
                                    } else {
                                        this.outhandle.write(var18_12, var13_7, var5_4 - var13_7);
                                        this.outhandle.write(RxStreamer.jncomend, 0, RxStreamer.jncomend.length);
                                        var13_7 = ++var5_4 + 1;
lbl106:
                                        // 2 sources

                                        if (var20_14 == 47 && var18_12[var5_4 + 1] == '*') {
                                            ++var12_6;
                                            this.outhandle.write(var18_12, var13_7, var5_4 - var13_7);
                                            this.outhandle.write(RxStreamer.jncomstart, 0, RxStreamer.jncomstart.length);
                                            var13_7 = ++var5_4 + 1;
                                        }
                                        if (var5_4 >= var18_12.length - 2) {
                                            this.outhandle.write(var18_12, var13_7, var18_12.length - var13_7);
                                            break;
                                        }
                                    }
                                    break block49;
                                }
                                if (var20_14 == 39 | var20_14 == 34) {
                                    var19_13 = var20_14;
                                } else {
                                    if (var20_14 == 45 && var18_12[var5_4 + 1] == '-') {
                                        if (!var8_23) {
                                            var21_15 = var4_3;
                                            this.outhandle.write(var21_15, 0, 1);
                                        }
                                        this.outhandle.write(RxStreamer.jcomstart, 0, RxStreamer.jcomstart.length);
                                        this.outhandle.write(var18_12, var5_4 + 2, var18_12.length - (var5_4 + 2));
                                        var8_23 = false;
                                        break;
                                    }
                                    if (var20_14 == 47 && var18_12[var5_4 + 1] == '*') {
                                        var17_11 = var5_4;
                                        var13_7 = var5_4++;
                                        var12_6 = 1;
                                        if (var5_4 >= var18_12.length - 2) {
                                            this.outhandle.write(var18_12, var13_7, var18_12.length - var13_7);
                                            var8_23 = false;
                                            break;
                                        }
                                    }
                                }
                            }
                            ++var5_4;
                        }
                        if (++var11_5 <= var15_9.line) {
                            this.outhandle.write(RxStreamer.linesepchars, 0, RxStreamer.linesepchars.length);
                            var8_23 = true;
                        }
                        if (var11_5 < var15_9.line || var12_6 != 0) continue;
                    }
                    var6_21 = var11_5;
                }
                if (!var3_20) {
                    if (var7_22 != null && var7_22.sep && !var8_23) {
                        this.outhandle.write(RxStreamer.linesepchars, 0, RxStreamer.linesepchars.length);
                    }
                    var7_22 = var15_9;
                }
                if (var15_9.line > var6_21) {
                    if (var3_20) {
                        var24_26 = var15_9.line - var6_21;
                        while (var24_26 > 0) {
                            this.outhandle.write(RxStreamer.linesepchars, 0, RxStreamer.linesepchars.length);
                            --var24_26;
                        }
                    }
                    var6_21 = var15_9.line;
                }
                if (var15_9.indent >= 0) {
                    this.outhandle.write(var4_3, 0, var15_9.indent);
                    var9_24 = var15_9.indent;
                }
                if ((var22_16 = var15_9.datachars) != null) {
                    this.outhandle.write(var22_16, 0, var22_16.length);
                }
                if (var15_9.insert != null) {
                    var22_16 = var15_9.insert.toCharArray();
                    this.outhandle.write(var22_16, 0, var22_16.length);
                }
                var8_23 = false;
                if (var15_9.postindent >= 0) {
                    var9_24 = var15_9.postindent;
                }
                --var23_18;
                ++var14_8;
            }
        }
        catch (IOException var23_19) {
            var2_2 = var23_19;
            throw new RxQuit(this.rxt, null, "error.writing.file", this.outfile, Rexx.toRexx(var2_2.getMessage()));
        }
        try {
            this.outhandle.close();
        }
        catch (IOException v0) {}
        if (this.rxt.keep || this.rxt.keepasjava) {
            try {
                this.byteoutstream.writeTo(var1_1);
                var1_1.close();
            }
            catch (IOException v1) {}
        }
        this.outhandle = null;
        this.chunklist = null;
    }

    public void postindent(int n) {
        int n2 = this.chunklist.size();
        if (n2 == 0) {
            return;
        }
        RxChunk rxChunk = (RxChunk)this.chunklist.elementAt(n2 - 1);
        rxChunk.postindent = n;
    }

    public void checkoutfile() {
        if (!this.rxt.keep & !this.rxt.keepasjava) {
            return;
        }
        if (this.outfileob == null) {
            return;
        }
        if (!this.outfileob.exists()) {
            return;
        }
        if (!this.program.flag.replace) {
            this.outfileob = null;
            throw new RxQuit(this.rxt, null, "output.file.already.exists", this.outfile);
        }
        if (!this.outfileob.canWrite()) {
            this.outfileob = null;
            throw new RxQuit(this.rxt, null, "file.may.not.be.written", this.outfile);
        }
    }

    public void disposeoutputfile(boolean bl) {
        this.disposeoutputfile(bl, false);
    }

    public void disposeoutputfile(boolean bl, boolean bl2) {
        File file2 = null;
        if (this.outfileob == null || !this.outfileob.exists()) {
            return;
        }
        if (bl) {
            this.outfileob.delete();
            return;
        }
        if (!bl2) {
            file2 = new File(String.valueOf(this.outfileob.getAbsolutePath()) + ".keep");
            file2.delete();
            this.outfileob.renameTo(file2);
        }
    }

    public void crossref(Rexx rexx) {
        FileOutputStream fileOutputStream = null;
        IOException iOException = null;
        char[] cArray = null;
        if (this.xrfhandle == null) {
            try {
                try {
                    fileOutputStream = new FileOutputStream(this.xrffileob);
                }
                catch (NullPointerException nullPointerException) {
                    new RxWarn(this.rxt, null, "conflicting.crossref.options", this.outfile);
                    this.xrffileob = this.createCrossrefFile(null);
                    fileOutputStream = new FileOutputStream(this.xrffileob);
                }
                this.xrfhandle = new OutputStreamWriter(fileOutputStream);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                throw new RxQuit(this.rxt, null, "error.opening.file", this.xrffile, Rexx.toRexx(iOException.getMessage()));
            }
        }
        rexx = linesep.OpCc(null, rexx);
        try {
            cArray = rexx.toCharArray();
            this.xrfhandle.write(cArray, 0, cArray.length);
        }
        catch (IOException iOException3) {
            iOException = iOException3;
            throw new RxQuit(this.rxt, null, "error.writing.file", this.xrffile, Rexx.toRexx(iOException.getMessage()));
        }
    }

    public void closefiles() {
        block13: {
            if (this.program.flag.diag) {
                RexxIO.Say("# closefiles");
            }
            if (this.outhandle != null) {
                try {
                    try {
                        this.outhandle.close();
                    }
                    catch (IOException iOException) {
                        this.outhandle = null;
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    this.outhandle = null;
                    throw throwable;
                }
                this.outhandle = null;
            }
        }
        if (this.xrfhandle != null) {
            try {
                try {
                    this.xrfhandle.close();
                }
                catch (IOException iOException) {
                    this.xrfhandle = null;
                }
            }
            finally {
                this.xrfhandle = null;
            }
        }
    }
}

