#ifndef lint
static const char yysccsid[] = "@(#)yaccpar	1.9 (Berkeley) 02/21/93";
#endif

#define YYBYACC 1
#define YYMAJOR 1
#define YYMINOR 9
#define YYPATCH 20110908

#define YYEMPTY        (-1)
#define yyclearin      (yychar = YYEMPTY)
#define yyerrok        (yyerrflag = 0)
#define YYRECOVERING() (yyerrflag != 0)


#ifndef yyparse
#define yyparse    itex2MML_yyparse
#endif /* yyparse */

#ifndef yylex
#define yylex      itex2MML_yylex
#endif /* yylex */

#ifndef yyerror
#define yyerror    itex2MML_yyerror
#endif /* yyerror */

#ifndef yychar
#define yychar     itex2MML_yychar
#endif /* yychar */

#ifndef yyval
#define yyval      itex2MML_yyval
#endif /* yyval */

#ifndef yylval
#define yylval     itex2MML_yylval
#endif /* yylval */

#ifndef yydebug
#define yydebug    itex2MML_yydebug
#endif /* yydebug */

#ifndef yynerrs
#define yynerrs    itex2MML_yynerrs
#endif /* yynerrs */

#ifndef yyerrflag
#define yyerrflag  itex2MML_yyerrflag
#endif /* yyerrflag */

#ifndef yylhs
#define yylhs      itex2MML_yylhs
#endif /* yylhs */

#ifndef yylen
#define yylen      itex2MML_yylen
#endif /* yylen */

#ifndef yydefred
#define yydefred   itex2MML_yydefred
#endif /* yydefred */

#ifndef yydgoto
#define yydgoto    itex2MML_yydgoto
#endif /* yydgoto */

#ifndef yysindex
#define yysindex   itex2MML_yysindex
#endif /* yysindex */

#ifndef yyrindex
#define yyrindex   itex2MML_yyrindex
#endif /* yyrindex */

#ifndef yygindex
#define yygindex   itex2MML_yygindex
#endif /* yygindex */

#ifndef yytable
#define yytable    itex2MML_yytable
#endif /* yytable */

#ifndef yycheck
#define yycheck    itex2MML_yycheck
#endif /* yycheck */

#ifndef yyname
#define yyname     itex2MML_yyname
#endif /* yyname */

#ifndef yyrule
#define yyrule     itex2MML_yyrule
#endif /* yyrule */
#define YYPREFIX "itex2MML_yy"

#define YYPURE 0

#line 6 "itex2MML.y"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "itex2MML.h"

#define YYSTYPE char *
#define YYPARSE_PARAM_TYPE char **
#define YYPARSE_PARAM ret_str

#define yytext itex2MML_yytext

 extern int yylex ();

 extern char * yytext;

 static void itex2MML_default_error (const char * msg)
   {
     if (msg)
       fprintf(stderr, "Line: %d Error: %s\n", itex2MML_lineno, msg);
   }

 void (*itex2MML_error) (const char * msg) = itex2MML_default_error;

 static void yyerror (char * s)
   {
     char * msg = itex2MML_copy3 (s, " at token ", yytext);
     if (itex2MML_error)
       (*itex2MML_error) (msg);
     itex2MML_free_string (msg);
   }

 /* Note: If length is 0, then buffer is treated like a string; otherwise only length bytes are written.
  */
 static void itex2MML_default_write (const char * buffer, unsigned long length)
   {
     if (buffer)
       {
	 if (length)
	   fwrite (buffer, 1, length, stdout);
	 else
	   fputs (buffer, stdout);
       }
   }

 static void itex2MML_default_write_mathml (const char * mathml)
   {
     if (itex2MML_write)
       (*itex2MML_write) (mathml, 0);
   }

#ifdef itex2MML_CAPTURE
    static char * itex2MML_output_string = "" ;

    const char * itex2MML_output ()
    {
        char * copy = (char *) malloc((itex2MML_output_string ? strlen(itex2MML_output_string) : 0) + 1);
        if (copy)
          {
           if (itex2MML_output_string)
             {
               strcpy(copy, itex2MML_output_string);
               if (*itex2MML_output_string != '\0')
                   free(itex2MML_output_string);
             }
           else
             copy[0] = 0;
           itex2MML_output_string = "";
          }
        return copy;
    }

 static void itex2MML_capture (const char * buffer, unsigned long length)
    {
     if (buffer)
       {
         if (length)
           {
              unsigned long first_length = itex2MML_output_string ? strlen(itex2MML_output_string) : 0;
              char * copy  = (char *) malloc(first_length + length + 1);
              if (copy)
                {
                  if (itex2MML_output_string)
                    {
                       strcpy(copy, itex2MML_output_string);
                       if (*itex2MML_output_string != '\0')
                          free(itex2MML_output_string);
                    }
                  else
                     copy[0] = 0;
                  strncat(copy, buffer, length);
                  itex2MML_output_string = copy;
                 }
            }
         else
            {
              char * copy = itex2MML_copy2(itex2MML_output_string, buffer);
              if (*itex2MML_output_string != '\0')
                 free(itex2MML_output_string);
              itex2MML_output_string = copy;
            }
        }
    }

    static void itex2MML_capture_mathml (const char * buffer)
    {
       char * temp = itex2MML_copy2(itex2MML_output_string, buffer);
       if (*itex2MML_output_string != '\0')
         free(itex2MML_output_string);
       itex2MML_output_string = temp;
    }
    void (*itex2MML_write) (const char * buffer, unsigned long length) = itex2MML_capture;
    void (*itex2MML_write_mathml) (const char * mathml) = itex2MML_capture_mathml;
#else
    void (*itex2MML_write) (const char * buffer, unsigned long length) = itex2MML_default_write;
    void (*itex2MML_write_mathml) (const char * mathml) = itex2MML_default_write_mathml;
#endif

 char * itex2MML_empty_string = "";

 /* Create a copy of a string, adding space for extra chars
  */
 char * itex2MML_copy_string_extra (const char * str, unsigned extra)
   {
     char * copy = (char *) malloc(extra + (str ? strlen (str) : 0) + 1);
     if (copy)
       {
	 if (str)
	   strcpy(copy, str);
	 else
	   copy[0] = 0;
       }
     return copy ? copy : itex2MML_empty_string;
   }

 /* Create a copy of a string, appending two strings
  */
 char * itex2MML_copy3 (const char * first, const char * second, const char * third)
   {
     int  first_length =  first ? strlen( first) : 0;
     int second_length = second ? strlen(second) : 0;
     int  third_length =  third ? strlen( third) : 0;

     char * copy = (char *) malloc(first_length + second_length + third_length + 1);

     if (copy)
       {
	 if (first)
	   strcpy(copy, first);
	 else
	   copy[0] = 0;

	 if (second) strcat(copy, second);
	 if ( third) strcat(copy,  third);
       }
     return copy ? copy : itex2MML_empty_string;
   }

 /* Create a copy of a string, appending a second string
  */
 char * itex2MML_copy2 (const char * first, const char * second)
   {
     return itex2MML_copy3(first, second, 0);
   }

 /* Create a copy of a string
  */
 char * itex2MML_copy_string (const char * str)
   {
     return itex2MML_copy3(str, 0, 0);
   }

 /* Create a copy of a string, escaping unsafe characters for XML
  */
 char * itex2MML_copy_escaped (const char * str)
   {
     unsigned long length = 0;

     const char * ptr1 = str;

     char * ptr2 = 0;
     char * copy = 0;

     if ( str == 0) return itex2MML_empty_string;
     if (*str == 0) return itex2MML_empty_string;

     while (*ptr1)
       {
	 switch (*ptr1)
	   {
	   case '<':  /* &lt;   */
	   case '>':  /* &gt;   */
	     length += 4;
	     break;
	   case '&':  /* &amp;  */
	     length += 5;
	     break;
	   case '\'': /* &apos; */
	   case '"':  /* &quot; */
	   case '-':  /* &#x2d; */
	     length += 6;
	     break;
	   default:
	     length += 1;
	     break;
	   }
	 ++ptr1;
       }

     copy = (char *) malloc (length + 1);

     if (copy)
       {
	 ptr1 = str;
	 ptr2 = copy;

	 while (*ptr1)
	   {
	     switch (*ptr1)
	       {
	       case '<':
		 strcpy (ptr2, "&lt;");
		 ptr2 += 4;
		 break;
	       case '>':
		 strcpy (ptr2, "&gt;");
		 ptr2 += 4;
		 break;
	       case '&':  /* &amp;  */
		 strcpy (ptr2, "&amp;");
		 ptr2 += 5;
		 break;
	       case '\'': /* &apos; */
		 strcpy (ptr2, "&apos;");
		 ptr2 += 6;
		 break;
	       case '"':  /* &quot; */
		 strcpy (ptr2, "&quot;");
		 ptr2 += 6;
		 break;
	       case '-':  /* &#x2d; */
		 strcpy (ptr2, "&#x2d;");
		 ptr2 += 6;
		 break;
	       default:
		 *ptr2++ = *ptr1;
		 break;
	       }
	     ++ptr1;
	   }
	 *ptr2 = 0;
       }
     return copy ? copy : itex2MML_empty_string;
   }

 /* Create a hex character reference string corresponding to code
  */
 char * itex2MML_character_reference (unsigned long int code)
   {
#define ENTITY_LENGTH 10
     char * entity = (char *) malloc(ENTITY_LENGTH);
     sprintf(entity, "&#x%05lx;", code);
     return entity;
   }

 void itex2MML_free_string (char * str)
   {
     if (str && str != itex2MML_empty_string)
       free(str);
   }

#line 371 "y.tab.c"

#ifndef YYSTYPE
typedef int YYSTYPE;
#endif

/* compatibility with bison */
#ifdef YYPARSE_PARAM
/* compatibility with FreeBSD */
# ifdef YYPARSE_PARAM_TYPE
#  define YYPARSE_DECL() yyparse(YYPARSE_PARAM_TYPE YYPARSE_PARAM)
# else
#  define YYPARSE_DECL() yyparse(void *YYPARSE_PARAM)
# endif
#else
# define YYPARSE_DECL() yyparse(void)
#endif

/* Parameters sent to lex. */
#ifdef YYLEX_PARAM
# define YYLEX_DECL() yylex(void *YYLEX_PARAM)
# define YYLEX yylex(YYLEX_PARAM)
#else
# define YYLEX_DECL() yylex(void)
# define YYLEX yylex()
#endif

/* Parameters sent to yyerror. */
#define YYERROR_DECL() yyerror(const char *s)
#define YYERROR_CALL(msg) yyerror(msg)

extern int YYPARSE_DECL();

#define TEXOVER 257
#define TEXATOP 258
#define CHAR 259
#define STARTMATH 260
#define STARTDMATH 261
#define ENDMATH 262
#define MI 263
#define MIB 264
#define MN 265
#define MO 266
#define SUP 267
#define SUB 268
#define MROWOPEN 269
#define MROWCLOSE 270
#define LEFT 271
#define RIGHT 272
#define BIG 273
#define BBIG 274
#define BIGG 275
#define BBIGG 276
#define BIGL 277
#define BBIGL 278
#define BIGGL 279
#define BBIGGL 280
#define FRAC 281
#define TFRAC 282
#define OPERATORNAME 283
#define MATHOP 284
#define MATHBIN 285
#define MATHREL 286
#define MOP 287
#define MOL 288
#define MOLL 289
#define MOF 290
#define MOR 291
#define PERIODDELIM 292
#define OTHERDELIM 293
#define LEFTDELIM 294
#define RIGHTDELIM 295
#define MOS 296
#define MOB 297
#define SQRT 298
#define ROOT 299
#define BINOM 300
#define TBINOM 301
#define UNDER 302
#define OVER 303
#define OVERBRACE 304
#define UNDERLINE 305
#define UNDERBRACE 306
#define UNDEROVER 307
#define TENSOR 308
#define MULTI 309
#define ARRAYALIGN 310
#define COLUMNALIGN 311
#define ARRAY 312
#define COLSEP 313
#define ROWSEP 314
#define ARRAYOPTS 315
#define COLLAYOUT 316
#define COLALIGN 317
#define ROWALIGN 318
#define ALIGN 319
#define EQROWS 320
#define EQCOLS 321
#define ROWLINES 322
#define COLLINES 323
#define FRAME 324
#define PADDING 325
#define ATTRLIST 326
#define ITALICS 327
#define BOLD 328
#define BOXED 329
#define SLASHED 330
#define RM 331
#define BB 332
#define ST 333
#define END 334
#define BBLOWERCHAR 335
#define BBUPPERCHAR 336
#define BBDIGIT 337
#define CALCHAR 338
#define FRAKCHAR 339
#define CAL 340
#define FRAK 341
#define CLAP 342
#define LLAP 343
#define RLAP 344
#define ROWOPTS 345
#define TEXTSIZE 346
#define SCSIZE 347
#define SCSCSIZE 348
#define DISPLAY 349
#define TEXTSTY 350
#define TEXTBOX 351
#define TEXTSTRING 352
#define XMLSTRING 353
#define CELLOPTS 354
#define ROWSPAN 355
#define COLSPAN 356
#define THINSPACE 357
#define MEDSPACE 358
#define THICKSPACE 359
#define QUAD 360
#define QQUAD 361
#define NEGSPACE 362
#define PHANTOM 363
#define HREF 364
#define UNKNOWNCHAR 365
#define EMPTYMROW 366
#define STATLINE 367
#define TOOLTIP 368
#define TOGGLE 369
#define FGHIGHLIGHT 370
#define BGHIGHLIGHT 371
#define SPACE 372
#define INTONE 373
#define INTTWO 374
#define INTTHREE 375
#define BAR 376
#define WIDEBAR 377
#define VEC 378
#define WIDEVEC 379
#define HAT 380
#define WIDEHAT 381
#define CHECK 382
#define WIDECHECK 383
#define TILDE 384
#define WIDETILDE 385
#define DOT 386
#define DDOT 387
#define DDDOT 388
#define DDDDOT 389
#define UNARYMINUS 390
#define UNARYPLUS 391
#define BEGINENV 392
#define ENDENV 393
#define MATRIX 394
#define PMATRIX 395
#define BMATRIX 396
#define BBMATRIX 397
#define VMATRIX 398
#define VVMATRIX 399
#define SVG 400
#define ENDSVG 401
#define SMALLMATRIX 402
#define CASES 403
#define ALIGNED 404
#define GATHERED 405
#define SUBSTACK 406
#define PMOD 407
#define RMCHAR 408
#define COLOR 409
#define BGCOLOR 410
#define XARROW 411
#define OPTARGOPEN 412
#define OPTARGCLOSE 413
#define ITEXNUM 414
#define RAISEBOX 415
#define NEG 416
#define YYERRCODE 256
static const short itex2MML_yylhs[] = {                  -1,
    0,    1,    1,    1,    1,    1,    2,    3,    3,    3,
    3,    4,    4,    5,    5,    5,    5,    5,    5,    5,
    5,    5,    5,    5,    5,    5,    5,    5,    7,    7,
    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
   73,   73,   73,   74,   74,   74,   79,   79,   79,   79,
   79,   79,   79,   79,   79,   79,   79,   79,   79,   79,
   79,   79,   79,   79,   79,   79,   78,   10,   11,   12,
    8,   13,   13,    6,   14,   14,   14,   14,   14,   14,
   14,   14,   14,   14,   14,   14,   14,   14,   14,   14,
   14,   55,   65,   66,   67,   68,   69,   70,   70,   40,
   39,   38,   56,   41,   42,   43,   44,   45,   46,   52,
   53,   47,   48,   49,   49,   50,   80,   80,   81,   81,
   81,   51,   82,   82,   83,   54,   84,   84,   85,   57,
   58,   59,   60,   61,   62,   63,   64,   15,   15,   16,
   16,   16,   86,   86,   87,   87,   87,   87,   17,   17,
   77,   71,   71,   72,   72,   18,   18,   34,   35,   33,
   24,   24,   25,   25,   27,   28,   29,   30,   32,   32,
   31,   31,   26,   26,   19,   20,   20,   21,   21,   21,
   21,   21,   21,   22,   22,   23,   23,   36,   36,   37,
   75,   75,   75,   75,   75,   75,   75,   75,   75,   75,
   75,   75,   75,   75,   89,   89,   76,    9,    9,   90,
   90,   91,   91,   91,   91,   91,   91,   91,   91,   91,
   91,   92,   93,   94,   95,   96,   97,   98,   99,  100,
  101,   88,   88,  102,  102,  103,  103,  104,  106,  106,
  107,  107,  105,  105,  105,  108,  108,  109,  109,  109,
  109,  110,  111,
};
static const short itex2MML_yylen[] = {                   2,
    1,    0,    1,    1,    2,    2,    1,    2,    2,    3,
    3,    1,    2,    5,    3,    5,    3,    5,    3,    5,
    3,    5,    5,    3,    3,    2,    2,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    3,    3,    3,    1,    1,    1,    1,
    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
    2,    2,    2,    2,    2,    2,    1,    1,    1,    1,
    1,    1,    2,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    2,    2,    2,
    2,   10,    3,    3,    3,    3,    3,    3,    3,    2,
    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
    2,    2,    4,    1,    2,    4,    1,    2,    1,    1,
    1,    4,    1,    2,    1,    4,    1,    2,    1,    1,
    1,    1,    1,    1,    1,    2,    3,    5,    3,    8,
    6,    6,    1,    2,    4,    2,    2,    3,    3,    3,
    2,    5,    5,    5,    5,    3,    3,    2,    2,    2,
    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
    2,    2,    2,    2,    2,    5,    3,    5,    6,    4,
    5,    3,    4,    5,    3,    2,    3,    5,    4,    1,
    5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
    9,    8,    4,    3,    2,    1,    4,    4,    8,    1,
    2,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    2,    2,    2,    2,    2,    2,    2,    2,    2,
    2,    1,    3,    1,    1,    1,    3,    5,    1,    2,
    1,    1,    0,    1,    5,    1,    2,    1,    1,    1,
    1,    2,    2,
};
static const short itex2MML_yydefred[] = {                0,
    7,    0,    0,    0,    0,    3,    4,    8,  130,  131,
  132,  137,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  146,  138,  139,  143,  147,  144,  142,  141,  140,  145,
  134,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  190,  191,  192,  193,  194,  195,    0,    0,  127,
  250,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  128,  129,    0,    0,    0,  174,    0,    0,    0,
    0,    0,    0,   12,    0,    0,    0,   29,   30,   31,
   33,   34,   35,   36,   37,   38,   39,   40,   41,   42,
   43,   44,   45,   46,   47,   48,   49,   50,   51,   52,
   53,   54,   55,   56,   57,   58,   59,   60,   61,   62,
   63,   64,   65,   66,   67,   68,   69,    0,   71,   72,
   73,   74,   75,   76,   77,   78,   79,   80,   81,   82,
   83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
   93,    0,   97,   98,   99,  100,  136,    9,    0,    5,
    6,  135,   27,   32,   26,    0,    0,  103,  102,  101,
  109,  107,  108,  112,  110,  111,  115,  113,  114,  118,
  116,  117,  120,  119,  122,  121,  124,  123,  126,  125,
    0,    0,  148,  149,  150,  151,    0,  235,    0,    0,
    0,    0,    0,  220,  219,  218,    0,    0,    0,    0,
    0,  169,  172,  171,  170,    0,    0,    0,    0,  162,
  161,  160,    0,    0,    0,    0,    0,  163,  196,    0,
    0,    0,    0,    0,    0,    0,  221,  222,  223,  224,
  233,  234,  231,  232,  229,  230,  225,  226,  227,  228,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  211,    0,    0,    0,  246,  133,    0,
    0,   10,   13,    0,    0,    0,    0,    0,    0,  175,
    0,   11,    0,    0,   95,   94,  209,  210,    0,  237,
  216,  217,  245,  247,    0,    0,    0,    0,    0,  203,
    0,    0,    0,    0,    0,    0,    0,  292,    0,  295,
  296,    0,  179,  180,  181,    0,  177,  189,    0,  187,
  185,    0,  183,  197,  153,  154,  155,  156,  157,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  264,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  242,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   96,    0,    0,    0,  249,  207,    0,    0,    0,  204,
    0,    0,    0,    0,    0,  268,    0,    0,  173,  176,
  178,  186,  188,  182,  184,    0,    0,  266,    0,    0,
    0,    0,    0,    0,    0,  263,    0,    0,    0,    0,
  267,    0,    0,  240,    0,  243,    0,    0,    0,    0,
    0,    0,    0,    0,  106,  105,  104,  212,  214,  236,
  208,    0,  198,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  270,  272,  273,  274,
  275,  276,  277,  278,  279,  280,  281,  301,  302,    0,
  299,    0,    0,  308,  309,    0,  306,  310,  311,  293,
  297,    0,    0,  265,    0,  251,  253,  254,  256,  255,
  257,  258,  259,  260,  252,  244,  248,  238,    0,  241,
   16,   14,   23,   22,   20,   18,  213,  215,  205,    0,
  201,  202,  282,  283,  284,  285,  286,  287,  288,  289,
  290,  291,    0,  271,    0,  300,  312,  313,    0,  307,
    0,    0,    0,  239,    0,    0,    0,    0,    0,    0,
    0,  200,  269,    0,    0,  262,    0,  261,  152,
};
static const short itex2MML_yydgoto[] = {                 4,
    5,    6,    7,  336,  114,  192,  116,  194,  118,  119,
  120,  121,  122,  123,  124,  125,  126,  127,  128,  129,
  130,  131,  132,  133,  134,  135,  136,  137,  138,  139,
  140,  141,  142,  143,  144,  145,  146,  147,  148,  149,
  150,  151,  152,  153,  154,  155,  156,  157,  158,  159,
  160,  161,  162,  163,  164,  165,  166,  167,  168,  169,
  170,  171,  172,  173,  174,  175,  176,  177,  178,  179,
  180,  181,  182,  391,  183,  184,  185,  186,  187,  346,
  347,  352,  353,  349,  350,  329,  330,  337,  419,  466,
  467,  468,  469,  470,  471,  472,  473,  474,  475,  476,
  477,  338,  339,  340,  341,  480,  481,  486,  487,  488,
  489,
};
static const short itex2MML_yysindex[] = {              -89,
    0, 3098, 3252,    0,  -89,    0,    0,    0,    0,    0,
    0,    0, 6161, 6161, 4937,  -16,   31,   51,   57,   66,
 -141,  -31,   28,   60, 6161, 6161, -345, -340, -230, -215,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 5090, 6161, 6161, 6161, 6161, 6161, 6161, 6161, 6161,
 6161, 6161, -261, -189, 6161, 6161, 6161, 6161, -208, -201,
 -173, -170, 6161, 6161, 6161, 4937, 4937, 4937, 4937, 4937,
 -203,    0,    0,    0,    0,    0,    0, 6161, -187,    0,
    0, -185, -162, 6161, -182, -133, -138, 6161, 6161, 6161,
 6161, 6161, 6161, 6161, 6161, 6161, 6161, 6161, 6161, 6161,
 6161,    0,    0, -130,  -68, 6161,    0, -118, -114, 5243,
 -136, -273, 3406,    0, -244, -228,  -22,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, -177,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 4937,    0,    0,    0,    0,    0,    0, 3560,    0,
    0,    0,    0,    0,    0, 2634,  -57,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 6161, 6161,    0,    0,    0,    0, 4937,    0, 6161, 6161,
 6161, 6161, 6161,    0,    0,    0, 6161,   63,   72, 6161,
 3713,    0,    0,    0,    0, -159,   32, -124, -113,    0,
    0,    0, 4937, 4937, 4937, 4937, 4937,    0,    0, 6161,
 6161, 6161, 6161, 6161, 6161, -152,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 -197, 3866, 3866, 3866, 3866, 3866, 3866, -226, 3866, 3866,
 3866, 3866, 3866,    0, 4937, 4937, 4937,    0,    0, 5396,
  -96,    0,    0, 6161, 6161, 6161, 6161, 6161, 6161,    0,
 2789,    0, 4937, 4937,    0,    0,    0,    0, 4019,    0,
    0,    0,    0,    0, 6161, 6161, 5549,   72,   72,    0,
  -48,   -9,    2,   17,   41, 4937, -163,    0,  -75,    0,
    0, -299,    0,    0,    0, -137,    0,    0, -200,    0,
    0, -325,    0,    0,    0,    0,    0,    0,    0,  -42,
  -36,    4, -297, -272, -270, -269, -260, -245,  -99,    0,
 -237, -231, -227, -220, -155, 4937, 4937, 4172, 5702,    0,
 5855,   67,   75,   98,  105,  109,  106, 4937, 4937,  -65,
    0, 4325, 4478, 6161,    0,    0, 6161,  111,   33,    0,
 6161,   72,  149,   39, -132,    0, 3866, 4631,    0,    0,
    0,    0,    0,    0,    0,   48,    4,    0, -194,  -12,
   -7,   -4,  -14,   10,  -10,    0,   -8,    6,    9,    5,
    0, 6314, 6161,    0, 6008,    0, 6161, 6161, 6161, 6161,
 6161, 6161, 4784, 4784,    0,    0,    0,    0,    0,    0,
    0, 6161,    0, -258,   37,   88,   89,   90,   91,   92,
   99,  100,  101,  102,  103,   79,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, -171,
    0,  107,  108,    0,    0, -236,    0,    0,    0,    0,
    0,   50, -180,    0, 3866,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 6161,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   72,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 3866,    0, 4631,    0,    0,    0, 4937,    0,
  104, 3866, -219,    0,   46, -135,  -75, 4937,  110, -216,
  120,    0,    0,   61,  123,    0,  112,    0,    0,
};
static const short itex2MML_yyrindex[] = {              437,
    0,    0,    0,    0,  439,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1998, 2157, 2316,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  726,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 2944,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 -125,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, -252, -229, -184, -156,  -66,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, -283, -283, -283, -283, -283, -283,    0, -283, -283,
 -283, -283, -125,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 2475,    0,
    0,    0,    0,    0,    0, -267,    0,    0, -254,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  -55,   71,    0,    0,    0,
    0,  885, 1044, 1203, 1362, 1521, 1680,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1839,    0,    0,
    0,    0,    0,    0,    0,    0, -243, -243,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, -283,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, -125,    0, -243,    0,    0,    0,    0,    0,
    0, -283,    0,    0,    0,    0, -251, -238,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,
};
static const short itex2MML_yygindex[] = {                0,
    0,  435,  440,   23,  -13,   -2,  535,  166,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  198,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  -73,    0,    0,    0,    0,    0,    0,
  114,    0,   95,    0,  126, -224, -327, -234,   59,    0,
   12,    0, -383, -368,    0,    0,    0,    0,    0,    0,
    0,   47,  -54,    0,   74,    0,    3,    0,    1,    0,
    0,
};
#define YYTABLESIZE 6729
static const short itex2MML_yytable[] = {               115,
  115,  400,  304,  400,  166,  166,  223,  239,  414,  166,
  520,  224,  115,  351,  331,  294,  407,  166,  298,  166,
  478,  484,  304,  305,  113,  189,  303,  167,  167,  303,
  303,  305,  167,  539,  409,  479,  485,  196,  306,  307,
  167,  407,  167,  407,  407,  304,  304,  363,  364,  365,
  366,  367,  368,  407,  371,  372,  373,  374,  375,  294,
  166,  166,  298,  115,  115,  115,  115,  115,  407,  303,
  303,  400,  168,  168,  305,  305,  407,  168,  300,  241,
  457,  458,  407,  167,  167,  168,  407,  168,  253,  254,
  255,  256,  257,  407,  407,  420,  478,  407,  535,  303,
  164,  164,  484,  399,  240,  164,  406,  521,  310,  303,
  115,  479,  361,  164,  431,  164,  494,  485,  482,  483,
  421,  225,  422,  423,  246,  304,  369,  400,  168,  168,
  494,  247,  424,  412,  553,  362,  226,  348,  294,  495,
  166,  298,  301,  264,  303,  457,  458,  425,  258,  303,
  407,  213,  214,  542,  305,  427,  164,  164,  407,  248,
  166,  428,  249,  167,  260,  429,  261,  117,  117,    1,
    2,    3,  430,  551,  370,  303,  555,  455,  407,  115,
  117,  281,  303,  167,  457,  458,  115,  303,  303,  262,
  165,  165,  265,  115,  266,  165,  410,  343,  344,  345,
  293,  158,  158,  165,  311,  165,  158,  295,  168,  306,
  307,  296,  316,  348,  158,  299,  158,  400,  326,  327,
  360,  401,  482,  483,  115,  351,  445,  446,  168,  447,
  310,  117,  117,  117,  117,  117,  164,  408,  115,  303,
  303,  303,  303,  303,  308,  309,  165,  165,  107,  319,
  115,  115,  115,  115,  115,  381,  164,  158,  158,  402,
  543,  215,  216,  282,  283,  284,  285,  286,  287,  288,
  403,  289,  290,  291,  292,  198,  199,  200,  117,  115,
  115,  115,  115,  115,  115,  404,  115,  115,  115,  115,
  115,  416,  115,  115,  115,  545,  417,  303,  546,  326,
  327,  426,  453,  326,  327,  303,  522,  550,  115,  405,
  115,  115,  326,  327,  418,  552,  115,  376,  377,  378,
  217,  218,  303,  201,  202,  203,  165,  159,  159,  326,
  327,  328,  159,  115,  437,  392,  393,  158,  326,  327,
  159,  438,  159,  204,  205,  206,  165,  117,  533,  207,
  208,  209,  219,  220,  117,  457,  458,  158,  210,  211,
  212,  117,  303,  303,  303,  439,  343,  344,  345,  517,
  518,  440,  442,  115,  115,  115,  441,  452,  303,  303,
  492,  496,  499,  159,  159,  115,  115,  497,  501,  115,
  115,  498,  117,  502,  456,  457,  458,  459,  460,  461,
  462,  463,  464,  465,  115,  115,  117,  500,  503,  505,
  443,  444,  504,  523,  524,  525,  526,  527,  117,  117,
  117,  117,  117,  541,  528,  529,  530,  531,  532,  303,
  303,  556,  537,  538,  558,  557,    2,  549,    1,  190,
  115,  115,  554,  342,  191,  559,  415,  117,  117,  117,
  117,  117,  117,  490,  117,  117,  117,  117,  117,  411,
  117,  117,  117,  159,  456,  457,  458,  459,  460,  461,
  462,  463,  464,  465,  413,  493,  117,  534,  117,  117,
  547,  491,  536,  159,  117,    0,  540,    0,    0,    0,
    0,    0,  115,    0,    0,    0,    0,    0,    0,    0,
    0,  117,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  115,    0,  115,    0,  303,    0,  115,    0,    0,  115,
    0,  117,  117,  117,    0,  115,    0,  193,  195,  197,
    0,    0,    0,  117,  117,    0,    0,  117,  117,  221,
  222,  548,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  117,  117,    0,    0,  228,  229,  230,  231,
  232,  233,  234,  235,  236,  237,  238,    0,    0,  242,
  243,  244,  245,    0,    0,    0,    0,  250,  251,  252,
    0,    0,    0,    0,    0,    0,    0,    0,  117,  117,
    0,    0,  259,    0,    0,    0,    0,    0,  263,    0,
    0,    0,  267,  268,  269,  270,  271,  272,  273,  274,
  275,  276,  277,  278,  279,  280,    0,    0,    0,    0,
  294,    0,    0,    0,  298,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  117,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  117,    0,
  117,    0,    0,    0,  117,    0,    0,  117,    0,    0,
    0,    0,    0,  117,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  317,  318,    0,    0,    0,
    0,    0,    0,  320,  321,  322,  323,  324,    0,    0,
    0,  325,    0,    0,  332,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  354,  355,  356,  357,  358,  359,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  380,    0,    0,    0,  382,  383,
  384,  385,  386,  387,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  395,
  396,  398,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  434,    0,  436,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  450,    0,
    0,  451,    0,    0,    0,  454,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  507,  508,    0,  510,
    0,  511,  512,  513,  514,  515,  516,    0,    0,    0,
    0,    0,   70,   70,    0,    0,  519,   70,   70,   70,
   70,   70,   70,   70,   70,   70,   70,   70,   70,   70,
   70,   70,   70,   70,   70,   70,   70,   70,   70,   70,
   70,   70,   70,   70,   70,   70,   70,   70,   70,   70,
   70,   70,   70,   70,   70,   70,   70,   70,   70,   70,
   70,   70,   70,   70,   70,    0,    0,   70,   70,   70,
    0,    0,    0,  544,    0,    0,    0,    0,    0,    0,
    0,    0,   70,   70,   70,   70,   70,   70,    0,    0,
    0,    0,    0,    0,    0,   70,   70,   70,   70,   70,
    0,   70,   70,   70,   70,   70,   70,    0,    0,    0,
    0,    0,   70,   70,   70,   70,   70,   70,   70,   70,
   70,   70,   70,   70,   70,   70,   70,   70,    0,    0,
    0,   70,   70,   70,   70,   70,   70,   70,   70,   70,
   70,   70,   70,   70,   70,   70,   70,   70,   70,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   70,   70,    0,   70,   70,   70,    0,   70,   70,
   70,   17,   17,    0,    0,    0,   17,   17,   17,   17,
   17,   17,    0,   17,   17,   17,   17,   17,   17,   17,
   17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
   17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
   17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
   17,   17,   17,   17,    0,    0,   17,   17,   17,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   17,   17,   17,   17,   17,   17,    0,    0,    0,
    0,    0,    0,    0,   17,   17,   17,   17,   17,    0,
   17,   17,   17,   17,   17,   17,    0,    0,    0,    0,
    0,   17,   17,   17,   17,   17,   17,   17,   17,   17,
   17,   17,   17,   17,   17,   17,   17,    0,    0,    0,
   17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
   17,   17,   17,   17,   17,   17,   17,   17,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   17,   17,   17,   17,   17,   17,    0,   17,   17,   17,
   15,   15,    0,    0,    0,   15,   15,   15,   15,   15,
    0,   15,   15,   15,   15,   15,   15,   15,   15,   15,
   15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
   15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
   15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
   15,   15,   15,    0,    0,   15,   15,   15,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   15,   15,   15,   15,   15,   15,    0,    0,    0,    0,
    0,    0,    0,   15,   15,   15,   15,   15,    0,   15,
   15,   15,   15,   15,   15,    0,    0,    0,    0,    0,
   15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
   15,   15,   15,   15,   15,   15,    0,    0,    0,   15,
   15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
   15,   15,   15,   15,   15,   15,   15,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   15,
   15,   15,   15,   15,   15,    0,   15,   15,   15,   25,
   25,    0,    0,    0,   25,   25,   25,   25,   25,   25,
    0,   25,   25,   25,   25,   25,   25,   25,   25,   25,
   25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
   25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
   25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
   25,   25,    0,    0,   25,   25,   25,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   25,
   25,   25,   25,   25,   25,    0,    0,    0,    0,    0,
    0,    0,   25,   25,   25,   25,   25,    0,   25,   25,
   25,   25,   25,   25,    0,    0,    0,    0,    0,   25,
   25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
   25,   25,   25,   25,   25,    0,    0,    0,   25,   25,
   25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
   25,   25,   25,   25,   25,   25,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   25,   25,
   25,   25,   25,   25,    0,   25,   25,   25,   24,   24,
    0,    0,    0,   24,   24,   24,   24,   24,    0,   24,
   24,   24,   24,   24,   24,   24,   24,   24,   24,   24,
   24,   24,   24,   24,   24,   24,   24,   24,   24,   24,
   24,   24,   24,   24,   24,   24,   24,   24,   24,   24,
   24,   24,   24,   24,   24,   24,   24,   24,   24,   24,
   24,    0,    0,   24,   24,   24,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   24,   24,
   24,   24,   24,   24,    0,    0,    0,    0,    0,    0,
    0,   24,   24,   24,   24,   24,    0,   24,   24,   24,
   24,   24,   24,    0,    0,    0,    0,    0,   24,   24,
   24,   24,   24,   24,   24,   24,   24,   24,   24,   24,
   24,   24,   24,   24,    0,    0,    0,   24,   24,   24,
   24,   24,   24,   24,   24,   24,   24,   24,   24,   24,
   24,   24,   24,   24,   24,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   24,   24,   24,
   24,   24,   24,    0,   24,   24,   24,   21,   21,    0,
    0,    0,   21,   21,   21,   21,   21,   21,    0,   21,
   21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
   21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
   21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
   21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
    0,    0,   21,   21,   21,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   21,   21,   21,
   21,   21,   21,    0,    0,    0,    0,    0,    0,    0,
   21,   21,   21,   21,   21,    0,   21,   21,   21,   21,
   21,   21,    0,    0,    0,    0,    0,   21,   21,   21,
   21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
   21,   21,   21,    0,    0,    0,   21,   21,   21,   21,
   21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
   21,   21,   21,   21,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   21,   21,   21,   21,
   21,   21,    0,   21,   21,   21,   19,   19,    0,    0,
    0,   19,   19,   19,   19,   19,    0,   19,   19,   19,
   19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
   19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
   19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
   19,   19,   19,   19,   19,   19,   19,   19,   19,    0,
    0,   19,   19,   19,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   19,   19,   19,   19,
   19,   19,    0,    0,    0,    0,    0,    0,    0,   19,
   19,   19,   19,   19,    0,   19,   19,   19,   19,   19,
   19,    0,    0,    0,    0,    0,   19,   19,   19,   19,
   19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
   19,   19,    0,    0,    0,   19,   19,   19,   19,   19,
   19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
   19,   19,   19,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   19,   19,   19,   19,   19,
   19,    0,   19,   19,   19,  206,  206,    0,    0,    0,
  206,  206,  206,  206,  206,    0,  206,  206,  206,  206,
  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,
  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,
  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,
  206,  206,  206,  206,  206,  206,  206,  206,    0,    0,
  206,  206,  206,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  206,  206,  206,  206,  206,
  206,    0,    0,    0,    0,    0,    0,    0,  206,  206,
  206,  206,  206,    0,  206,  206,  206,  206,  206,  206,
    0,    0,    0,    0,    0,  206,  206,  206,  206,  206,
  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,
  206,    0,    0,    0,  206,  206,  206,  206,  206,  206,
  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,
  206,  206,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  206,  206,  206,  206,  206,  206,
    0,  206,  206,  206,  135,  135,    0,    0,    0,  135,
  135,  135,  135,  135,    0,    0,  135,  135,  135,  135,
  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
  135,  135,  135,  135,  135,  135,  135,    0,    0,  135,
  135,  135,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  135,  135,  135,  135,  135,  135,
    0,    0,    0,    0,    0,    0,    0,  135,  135,  135,
  135,  135,    0,  135,  135,  135,  135,  135,  135,    0,
    0,    0,    0,    0,  135,  135,  135,  135,  135,  135,
  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
    0,    0,    0,  135,  135,  135,  135,  135,  135,  135,
  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
  135,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  135,  135,  135,  135,  135,  135,    0,
  135,  135,  135,   28,   28,    0,    0,    0,   28,   28,
   28,   28,   28,    0,    0,   28,   28,   28,   28,   28,
   28,   28,   28,   28,   28,   28,   28,   28,   28,   28,
   28,   28,   28,   28,   28,   28,   28,   28,   28,   28,
   28,   28,   28,   28,   28,   28,   28,   28,   28,   28,
   28,   28,   28,   28,   28,   28,    0,    0,   28,   28,
   28,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   28,   28,   28,   28,   28,   28,    0,
    0,    0,    0,    0,    0,    0,   28,   28,   28,   28,
   28,    0,   28,   28,   28,   28,   28,   28,    0,    0,
    0,    0,    0,   28,   28,   28,   28,   28,   28,   28,
   28,   28,   28,   28,   28,   28,   28,   28,   28,    0,
    0,    0,   28,   28,   28,   28,   28,   28,   28,   28,
   28,   28,   28,   28,   28,   28,   28,   28,   28,   28,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   28,   28,   28,   28,   28,   28,    0,   28,
   28,   28,   32,   32,    0,    0,    0,   32,   32,   32,
   32,   32,    0,    0,   32,   32,   32,   32,   32,   32,
   32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
   32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
   32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
   32,   32,   32,   32,   32,    0,    0,   32,   32,   32,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   32,   32,   32,   32,   32,   32,    0,    0,
    0,    0,    0,    0,    0,   32,   32,   32,   32,   32,
    0,   32,   32,   32,   32,   32,   32,    0,    0,    0,
    0,    0,   32,   32,   32,   32,   32,   32,   32,   32,
   32,   32,   32,   32,   32,   32,   32,   32,    0,    0,
    0,   32,   32,   32,   32,   32,   32,   32,   32,   32,
   32,   32,   32,   32,   32,   32,   32,   32,   32,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   32,   32,   32,   32,   32,   32,    0,   32,   32,
   32,  199,  199,    0,    0,    0,  199,  199,  199,  199,
  199,    0,    0,  199,  199,  199,  199,  199,  199,  199,
  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,
  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,
  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,
  199,  199,  199,  199,    0,    0,  199,  199,  199,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  199,  199,  199,  199,  199,  199,    0,    0,    0,
    0,    0,    0,    0,  199,  199,  199,  199,  199,    0,
  199,  199,  199,  199,  199,  199,    0,    0,    0,    0,
    0,  199,  199,  199,  199,  199,  199,  199,  199,  199,
  199,  199,  199,  199,  199,  199,  199,    0,    0,    0,
  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,
  199,  199,  199,  199,  199,  199,  199,  199,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  199,  199,  199,  199,  199,  199,    0,  199,  199,  199,
  313,  314,    0,    0,    0,    0,    9,   10,   11,   12,
   13,   14,   15,  315,   16,    0,   17,   18,   19,   20,
   21,   22,   23,   24,   25,   26,   27,   28,   29,   30,
   31,   32,   33,   34,   35,   36,   37,   38,   39,   40,
   41,   42,   43,   44,   45,   46,   47,   48,   49,   50,
   51,   52,   53,    0,    0,   54,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   55,   56,   57,   58,   59,   60,    0,    0,    0,    0,
    0,    0,    0,   61,   62,   63,   64,   65,    0,   66,
   67,   68,   69,   70,   71,    0,    0,    0,    0,    0,
   72,   73,   74,   75,   76,   77,   78,   79,   80,   81,
   82,   83,   84,   85,   86,   87,    0,    0,    0,   88,
   89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
   99,  100,  101,  102,  103,  104,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  105,
  106,  107,  108,  109,  110,  388,  389,  111,  112,    0,
    0,    9,   10,   11,   12,   13,   14,   15,    0,   16,
  390,   17,   18,   19,   20,   21,   22,   23,   24,   25,
   26,   27,   28,   29,   30,   31,   32,   33,   34,   35,
   36,   37,   38,   39,   40,   41,   42,   43,   44,   45,
   46,   47,   48,   49,   50,   51,   52,   53,    0,    0,
   54,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   55,   56,   57,   58,   59,
   60,    0,    0,    0,    0,    0,    0,    0,   61,   62,
   63,   64,   65,    0,   66,   67,   68,   69,   70,   71,
    0,    0,    0,    0,    0,   72,   73,   74,   75,   76,
   77,   78,   79,   80,   81,   82,   83,   84,   85,   86,
   87,    0,    0,    0,   88,   89,   90,   91,   92,   93,
   94,   95,   96,   97,   98,   99,  100,  101,  102,  103,
  104,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  105,  106,  107,  108,  109,  110,
   28,   28,  111,  112,    0,    0,   28,   28,   28,   28,
    0,    0,   28,    0,   28,    0,   28,   28,   28,   28,
   28,   28,   28,   28,   28,   28,   28,   28,   28,   28,
   28,   28,   28,   28,   28,   28,   28,   28,   28,   28,
   28,   28,   28,   28,   28,   28,   28,   28,   28,   28,
   28,   28,   28,    0,    0,   28,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   28,   28,   28,   28,   28,   28,    0,    0,    0,    0,
    0,    0,    0,   28,   28,   28,   28,   28,    0,   28,
   28,   28,   28,   28,   28,    0,    0,    0,    0,    0,
   28,   28,   28,   28,   28,   28,   28,   28,   28,   28,
   28,   28,   28,   28,   28,   28,    0,    0,    0,   28,
   28,   28,   28,   28,   28,   28,   28,   28,   28,   28,
   28,   28,   28,   28,   28,   28,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   28,
   28,   28,   28,   28,   28,    0,    0,   28,   28,    8,
    9,   10,   11,   12,   13,   14,   15,    0,   16,    0,
   17,   18,   19,   20,   21,   22,   23,   24,   25,   26,
   27,   28,   29,   30,   31,   32,   33,   34,   35,   36,
   37,   38,   39,   40,   41,   42,   43,   44,   45,   46,
   47,   48,   49,   50,   51,   52,   53,    0,    0,   54,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   55,   56,   57,   58,   59,   60,
    0,    0,    0,    0,    0,    0,    0,   61,   62,   63,
   64,   65,    0,   66,   67,   68,   69,   70,   71,    0,
    0,    0,    0,    0,   72,   73,   74,   75,   76,   77,
   78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
    0,    0,    0,   88,   89,   90,   91,   92,   93,   94,
   95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  105,  106,  107,  108,  109,  110,    0,
    0,  111,  112,  188,    9,   10,   11,   12,   13,   14,
   15,    0,   16,    0,   17,   18,   19,   20,   21,   22,
   23,   24,   25,   26,   27,   28,   29,   30,   31,   32,
   33,   34,   35,   36,   37,   38,   39,   40,   41,   42,
   43,   44,   45,   46,   47,   48,   49,   50,   51,   52,
   53,    0,    0,   54,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   55,   56,
   57,   58,   59,   60,    0,    0,    0,    0,    0,    0,
    0,   61,   62,   63,   64,   65,    0,   66,   67,   68,
   69,   70,   71,    0,    0,    0,    0,    0,   72,   73,
   74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
   84,   85,   86,   87,    0,    0,    0,   88,   89,   90,
   91,   92,   93,   94,   95,   96,   97,   98,   99,  100,
  101,  102,  103,  104,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  105,  106,  107,
  108,  109,  110,    0,    0,  111,  112,  302,    9,   10,
   11,   12,   13,   14,   15,    0,   16,    0,   17,   18,
   19,   20,   21,   22,   23,   24,   25,   26,   27,   28,
   29,   30,   31,   32,   33,   34,   35,   36,   37,   38,
   39,   40,   41,   42,   43,   44,   45,   46,   47,   48,
   49,   50,   51,   52,   53,    0,    0,   54,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   55,   56,   57,   58,   59,   60,    0,    0,
    0,    0,    0,    0,    0,   61,   62,   63,   64,   65,
    0,   66,   67,   68,   69,   70,   71,    0,    0,    0,
    0,    0,   72,   73,   74,   75,   76,   77,   78,   79,
   80,   81,   82,   83,   84,   85,   86,   87,    0,    0,
    0,   88,   89,   90,   91,   92,   93,   94,   95,   96,
   97,   98,   99,  100,  101,  102,  103,  104,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  105,  106,  107,  108,  109,  110,    0,    0,  111,
  112,  312,    9,   10,   11,   12,   13,   14,   15,    0,
   16,    0,   17,   18,   19,   20,   21,   22,   23,   24,
   25,   26,   27,   28,   29,   30,   31,   32,   33,   34,
   35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
   45,   46,   47,   48,   49,   50,   51,   52,   53,    0,
    0,   54,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   55,   56,   57,   58,
   59,   60,    0,    0,    0,    0,    0,    0,    0,   61,
   62,   63,   64,   65,    0,   66,   67,   68,   69,   70,
   71,    0,    0,    0,    0,    0,   72,   73,   74,   75,
   76,   77,   78,   79,   80,   81,   82,   83,   84,   85,
   86,   87,    0,    0,    0,   88,   89,   90,   91,   92,
   93,   94,   95,   96,   97,   98,   99,  100,  101,  102,
  103,  104,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  105,  106,  107,  108,  109,
  110,    0,    0,  111,  112,    9,   10,   11,   12,   13,
   14,   15,    0,   16,    0,   17,   18,   19,   20,   21,
   22,   23,   24,   25,   26,   27,   28,   29,   30,   31,
   32,   33,   34,   35,   36,   37,   38,   39,   40,   41,
   42,   43,   44,   45,   46,   47,   48,   49,   50,   51,
   52,   53,    0,    0,   54,    0,    0,  333,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   55,
   56,   57,   58,   59,   60,    0,    0,    0,    0,    0,
    0,    0,   61,   62,   63,   64,   65,  334,   66,   67,
   68,   69,   70,   71,    0,    0,  335,    0,    0,   72,
   73,   74,   75,   76,   77,   78,   79,   80,   81,   82,
   83,   84,   85,   86,   87,    0,    0,    0,   88,   89,
   90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
  100,  101,  102,  103,  104,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  105,  106,
  107,  108,  109,  110,    0,    0,  111,  112,    9,   10,
   11,   12,   13,   14,   15,    0,   16,    0,   17,   18,
   19,   20,   21,   22,   23,   24,   25,   26,   27,   28,
   29,   30,   31,   32,   33,   34,   35,   36,   37,   38,
   39,   40,   41,   42,   43,   44,   45,   46,   47,   48,
   49,   50,   51,   52,   53,    0,    0,   54,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   55,   56,   57,   58,   59,   60,    0,    0,
    0,    0,    0,    0,    0,   61,   62,   63,   64,   65,
  334,   66,   67,   68,   69,   70,   71,    0,    0,  335,
    0,    0,   72,   73,   74,   75,   76,   77,   78,   79,
   80,   81,   82,   83,   84,   85,   86,   87,    0,    0,
    0,   88,   89,   90,   91,   92,   93,   94,   95,   96,
   97,   98,   99,  100,  101,  102,  103,  104,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  105,  106,  107,  108,  109,  110,    0,    0,  111,
  112,    9,   10,   11,   12,   13,   14,   15,    0,   16,
    0,   17,   18,   19,   20,   21,   22,   23,   24,   25,
   26,   27,   28,   29,   30,   31,   32,   33,   34,   35,
   36,   37,   38,   39,   40,   41,   42,   43,   44,   45,
   46,   47,   48,   49,   50,   51,   52,   53,    0,    0,
   54,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   55,   56,   57,   58,   59,
   60,    0,    0,    0,    0,    0,    0,    0,   61,   62,
   63,   64,   65,    0,   66,   67,   68,   69,   70,   71,
    0,    0,    0,    0,    0,   72,   73,   74,   75,   76,
   77,   78,   79,   80,   81,   82,   83,   84,   85,   86,
   87,    0,    0,    0,   88,   89,   90,   91,   92,   93,
   94,   95,   96,   97,   98,   99,  100,  101,  102,  103,
  104,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  105,  106,  107,  108,  109,  110,
    0,  394,  111,  112,    9,   10,   11,   12,   13,   14,
   15,    0,   16,    0,   17,   18,   19,   20,   21,   22,
   23,   24,   25,   26,   27,   28,   29,   30,   31,   32,
   33,   34,   35,   36,   37,   38,   39,   40,   41,   42,
   43,   44,   45,   46,   47,   48,   49,   50,   51,   52,
   53,    0,    0,   54,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   55,   56,
   57,   58,   59,   60,    0,    0,    0,    0,    0,    0,
    0,   61,   62,   63,   64,   65,    0,   66,   67,   68,
   69,   70,   71,    0,    0,    0,    0,    0,   72,   73,
   74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
   84,   85,   86,   87,    0,    0,    0,   88,   89,   90,
   91,   92,   93,   94,   95,   96,   97,   98,   99,  100,
  101,  102,  103,  104,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  105,  106,  107,
  108,  109,  110,    0,  432,  111,  112,    9,   10,   11,
   12,   13,   14,   15,  448,   16,    0,   17,   18,   19,
   20,   21,   22,   23,   24,   25,   26,   27,   28,   29,
   30,   31,   32,   33,   34,   35,   36,   37,   38,   39,
   40,   41,   42,   43,   44,   45,   46,   47,   48,   49,
   50,   51,   52,   53,    0,    0,   54,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   55,   56,   57,   58,   59,   60,    0,    0,    0,
    0,    0,    0,    0,   61,   62,   63,   64,   65,    0,
   66,   67,   68,   69,   70,   71,    0,    0,    0,    0,
    0,   72,   73,   74,   75,   76,   77,   78,   79,   80,
   81,   82,   83,   84,   85,   86,   87,    0,    0,    0,
   88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
   98,   99,  100,  101,  102,  103,  104,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  105,  106,  107,  108,  109,  110,    0,    0,  111,  112,
    9,   10,   11,   12,   13,   14,   15,  449,   16,    0,
   17,   18,   19,   20,   21,   22,   23,   24,   25,   26,
   27,   28,   29,   30,   31,   32,   33,   34,   35,   36,
   37,   38,   39,   40,   41,   42,   43,   44,   45,   46,
   47,   48,   49,   50,   51,   52,   53,    0,    0,   54,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   55,   56,   57,   58,   59,   60,
    0,    0,    0,    0,    0,    0,    0,   61,   62,   63,
   64,   65,    0,   66,   67,   68,   69,   70,   71,    0,
    0,    0,    0,    0,   72,   73,   74,   75,   76,   77,
   78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
    0,    0,    0,   88,   89,   90,   91,   92,   93,   94,
   95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  105,  106,  107,  108,  109,  110,    0,
    0,  111,  112,    9,   10,   11,   12,   13,   14,   15,
    0,   16,    0,   17,   18,   19,   20,   21,   22,   23,
   24,   25,   26,   27,   28,   29,   30,   31,   32,   33,
   34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
   44,   45,   46,   47,   48,   49,   50,   51,   52,   53,
    0,    0,   54,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   55,   56,   57,
   58,   59,   60,    0,    0,    0,    0,    0,    0,    0,
   61,   62,   63,   64,   65,    0,   66,   67,   68,   69,
   70,   71,    0,    0,  335,    0,    0,   72,   73,   74,
   75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
   85,   86,   87,    0,    0,    0,   88,   89,   90,   91,
   92,   93,   94,   95,   96,   97,   98,   99,  100,  101,
  102,  103,  104,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  105,  106,  107,  108,
  109,  110,    0,    0,  111,  112,    9,   10,   11,   12,
   13,   14,   15,    0,   16,  390,   17,   18,   19,   20,
   21,   22,   23,   24,   25,   26,   27,   28,   29,   30,
   31,   32,   33,   34,   35,   36,   37,   38,   39,   40,
   41,   42,   43,   44,   45,   46,   47,   48,   49,   50,
   51,   52,   53,    0,    0,   54,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   55,   56,   57,   58,   59,   60,    0,    0,    0,    0,
    0,    0,    0,   61,   62,   63,   64,   65,    0,   66,
   67,   68,   69,   70,   71,    0,    0,    0,    0,    0,
   72,   73,   74,   75,   76,   77,   78,   79,   80,   81,
   82,   83,   84,   85,   86,   87,    0,    0,    0,   88,
   89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
   99,  100,  101,  102,  103,  104,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  105,
  106,  107,  108,  109,  110,    0,    0,  111,  112,    9,
   10,   11,   12,   13,   14,   15,    0,   16,    0,   17,
   18,   19,   20,   21,   22,   23,   24,   25,   26,   27,
   28,   29,   30,   31,   32,   33,   34,   35,   36,   37,
   38,   39,   40,   41,   42,   43,   44,   45,   46,   47,
   48,   49,   50,   51,   52,   53,    0,    0,   54,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   55,   56,   57,   58,   59,   60,    0,
    0,    0,    0,    0,    0,    0,   61,   62,   63,   64,
   65,    0,   66,   67,   68,   69,   70,   71,    0,    0,
    0,    0,    0,   72,   73,   74,   75,   76,   77,   78,
   79,   80,   81,   82,   83,   84,   85,   86,   87,    0,
    0,    0,   88,   89,   90,   91,   92,   93,   94,   95,
   96,   97,   98,   99,  100,  101,  102,  103,  104,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  105,  106,  107,  108,  109,  110,    0,    0,
  111,  112,    9,   10,   11,   12,    0,    0,   15,    0,
   16,    0,   17,   18,   19,   20,   21,   22,   23,   24,
   25,   26,   27,   28,   29,   30,   31,   32,   33,   34,
   35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
   45,   46,   47,   48,   49,   50,   51,   52,   53,    0,
    0,   54,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   55,   56,   57,   58,
   59,   60,    0,    0,    0,    0,    0,    0,    0,   61,
   62,   63,   64,   65,    0,   66,   67,   68,   69,   70,
   71,    0,    0,    0,    0,    0,   72,   73,   74,   75,
   76,   77,   78,   79,   80,   81,   82,   83,   84,   85,
   86,   87,    0,    0,    0,   88,   89,   90,   91,   92,
   93,   94,   95,   96,   97,   98,   99,  100,  101,  102,
  103,  104,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  105,  106,  107,  108,  109,
  110,  227,    0,  111,  112,    9,   10,   11,   12,    0,
    0,   15,    0,   16,    0,   17,   18,   19,   20,   21,
   22,   23,   24,   25,   26,   27,   28,   29,   30,   31,
   32,   33,   34,   35,   36,   37,   38,   39,   40,   41,
   42,   43,   44,   45,   46,   47,   48,   49,   50,   51,
   52,   53,    0,    0,   54,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   55,
   56,   57,   58,   59,   60,    0,    0,    0,    0,    0,
    0,    0,   61,   62,   63,   64,   65,    0,   66,   67,
   68,   69,   70,   71,    0,    0,    0,    0,    0,   72,
   73,   74,   75,   76,   77,   78,   79,   80,   81,   82,
   83,   84,   85,   86,   87,    0,    0,    0,   88,   89,
   90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
  100,  101,  102,  103,  104,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  105,  106,
  107,  108,  109,  110,  297,    0,  111,  112,    9,   10,
   11,   12,    0,    0,   15,    0,   16,    0,   17,   18,
   19,   20,   21,   22,   23,   24,   25,   26,   27,   28,
   29,   30,   31,   32,   33,   34,   35,   36,   37,   38,
   39,   40,   41,   42,   43,   44,   45,   46,   47,   48,
   49,   50,   51,   52,   53,    0,    0,   54,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   55,   56,   57,   58,   59,   60,    0,    0,
    0,    0,    0,    0,    0,   61,   62,   63,   64,   65,
    0,   66,   67,   68,   69,   70,   71,  379,    0,    0,
    0,    0,   72,   73,   74,   75,   76,   77,   78,   79,
   80,   81,   82,   83,   84,   85,   86,   87,    0,    0,
    0,   88,   89,   90,   91,   92,   93,   94,   95,   96,
   97,   98,   99,  100,  101,  102,  103,  104,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  105,  106,  107,  108,  109,  110,    0,    0,  111,
  112,    9,   10,   11,   12,  397,    0,   15,    0,   16,
    0,   17,   18,   19,   20,   21,   22,   23,   24,   25,
   26,   27,   28,   29,   30,   31,   32,   33,   34,   35,
   36,   37,   38,   39,   40,   41,   42,   43,   44,   45,
   46,   47,   48,   49,   50,   51,   52,   53,    0,    0,
   54,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   55,   56,   57,   58,   59,
   60,    0,    0,    0,    0,    0,    0,    0,   61,   62,
   63,   64,   65,    0,   66,   67,   68,   69,   70,   71,
    0,    0,    0,    0,    0,   72,   73,   74,   75,   76,
   77,   78,   79,   80,   81,   82,   83,   84,   85,   86,
   87,    0,    0,    0,   88,   89,   90,   91,   92,   93,
   94,   95,   96,   97,   98,   99,  100,  101,  102,  103,
  104,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  105,  106,  107,  108,  109,  110,
    0,    0,  111,  112,    9,   10,   11,   12,    0,    0,
   15,    0,   16,    0,   17,   18,   19,   20,   21,   22,
   23,   24,   25,   26,   27,   28,   29,   30,   31,   32,
   33,   34,   35,   36,   37,   38,   39,   40,   41,   42,
   43,   44,   45,   46,   47,   48,   49,   50,   51,   52,
   53,    0,    0,   54,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   55,   56,
   57,   58,   59,   60,    0,    0,    0,    0,    0,    0,
    0,   61,   62,   63,   64,   65,    0,   66,   67,   68,
   69,   70,   71,  433,    0,    0,    0,    0,   72,   73,
   74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
   84,   85,   86,   87,    0,    0,    0,   88,   89,   90,
   91,   92,   93,   94,   95,   96,   97,   98,   99,  100,
  101,  102,  103,  104,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  105,  106,  107,
  108,  109,  110,    0,    0,  111,  112,    9,   10,   11,
   12,    0,    0,   15,    0,   16,    0,   17,   18,   19,
   20,   21,   22,   23,   24,   25,   26,   27,   28,   29,
   30,   31,   32,   33,   34,   35,   36,   37,   38,   39,
   40,   41,   42,   43,   44,   45,   46,   47,   48,   49,
   50,   51,   52,   53,    0,    0,   54,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   55,   56,   57,   58,   59,   60,    0,    0,    0,
    0,    0,    0,    0,   61,   62,   63,   64,   65,    0,
   66,   67,   68,   69,   70,   71,  435,    0,    0,    0,
    0,   72,   73,   74,   75,   76,   77,   78,   79,   80,
   81,   82,   83,   84,   85,   86,   87,    0,    0,    0,
   88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
   98,   99,  100,  101,  102,  103,  104,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  105,  106,  107,  108,  109,  110,    0,    0,  111,  112,
    9,   10,   11,   12,    0,    0,   15,    0,   16,    0,
   17,   18,   19,   20,   21,   22,   23,   24,   25,   26,
   27,   28,   29,   30,   31,   32,   33,   34,   35,   36,
   37,   38,   39,   40,   41,   42,   43,   44,   45,   46,
   47,   48,   49,   50,   51,   52,   53,    0,    0,   54,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   55,   56,   57,   58,   59,   60,
    0,    0,    0,    0,    0,    0,    0,   61,   62,   63,
   64,   65,    0,   66,   67,   68,   69,   70,   71,  509,
    0,    0,    0,    0,   72,   73,   74,   75,   76,   77,
   78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
    0,    0,    0,   88,   89,   90,   91,   92,   93,   94,
   95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  105,  106,  107,  108,  109,  110,    0,
    0,  111,  112,    9,   10,   11,   12,    0,    0,   15,
    0,   16,    0,   17,   18,   19,   20,   21,   22,   23,
   24,   25,   26,   27,   28,   29,   30,   31,   32,   33,
   34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
   44,   45,   46,   47,   48,   49,   50,   51,   52,   53,
    0,    0,   54,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   55,   56,   57,
   58,   59,   60,    0,    0,    0,    0,    0,    0,    0,
   61,   62,   63,   64,   65,    0,   66,   67,   68,   69,
   70,   71,    0,    0,    0,    0,    0,   72,   73,   74,
   75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
   85,   86,   87,    0,    0,    0,   88,   89,   90,   91,
   92,   93,   94,   95,   96,   97,   98,   99,  100,  101,
  102,  103,  104,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  105,  106,  107,  108,
  109,  110,    0,    0,  111,  112,    9,   10,   11,   12,
    0,    0,   15,    0,   16,    0,   17,   18,   19,   20,
   21,   22,   23,   24,   25,   26,   27,   28,   29,   30,
   31,   32,   33,   34,   35,   36,   37,   38,   39,   40,
   41,   42,   43,   44,   45,   46,   47,   48,   49,   50,
   51,   52,   53,    0,    0,   54,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   55,   56,   57,   58,   59,   60,    0,    0,    0,    0,
    0,    0,    0,   61,   62,   63,   64,   65,    0,   66,
   67,   68,   69,   70,   71,    0,    0,    0,    0,    0,
   72,   73,   74,   75,   76,   77,   78,   79,   80,  506,
   82,   83,   84,   85,   86,   87,    0,    0,    0,   88,
   89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
   99,  100,  101,  102,  103,  104,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  105,
  106,  107,  108,  109,  110,    0,    0,  111,  112,
};
static const short itex2MML_yycheck[] = {                 2,
    3,  329,  270,  331,  257,  258,  352,  269,  334,  262,
  269,  352,   15,  339,  239,  270,  314,  270,  270,  272,
  404,  405,  267,  268,    2,    3,  270,  257,  258,  313,
  314,  270,  262,  270,  334,  404,  405,   15,  267,  268,
  270,  314,  272,  314,  314,  313,  314,  282,  283,  284,
  285,  286,  287,  314,  289,  290,  291,  292,  293,  314,
  313,  314,  314,   66,   67,   68,   69,   70,  314,  313,
  314,  399,  257,  258,  313,  314,  314,  262,  352,  269,
  317,  318,  314,  313,  314,  270,  314,  272,   66,   67,
   68,   69,   70,  314,  314,  393,  480,  314,  270,  113,
  257,  258,  486,  328,  366,  262,  270,  366,  408,  393,
  113,  480,  310,  270,  270,  272,  311,  486,  355,  356,
  393,  352,  393,  393,  333,  393,  353,  455,  313,  314,
  311,  333,  393,  334,  270,  333,  352,  338,  393,  334,
  393,  393,  416,  326,  270,  317,  318,  393,  352,  393,
  314,  293,  294,  334,  393,  393,  313,  314,  314,  333,
  413,  393,  333,  393,  352,  393,  352,    2,    3,  259,
  260,  261,  393,  393,  401,  189,  393,  402,  314,  182,
   15,  312,  196,  413,  317,  318,  189,  313,  314,  352,
  257,  258,  326,  196,  333,  262,  334,  335,  336,  337,
  269,  257,  258,  270,  182,  272,  262,  326,  393,  267,
  268,  326,  270,  338,  270,  352,  272,  545,  267,  268,
  373,  270,  355,  356,  227,  339,  292,  293,  413,  295,
  408,   66,   67,   68,   69,   70,  393,  313,  241,  253,
  254,  255,  256,  257,  267,  268,  313,  314,  408,  227,
  253,  254,  255,  256,  257,  352,  413,  313,  314,  269,
  495,  293,  294,  394,  395,  396,  397,  398,  399,  400,
  269,  402,  403,  404,  405,  292,  293,  294,  113,  282,
  283,  284,  285,  286,  287,  269,  289,  290,  291,  292,
  293,  334,  295,  296,  297,  520,  333,  311,  533,  267,
  268,  401,  270,  267,  268,  319,  270,  542,  311,  269,
  313,  314,  267,  268,  311,  270,  319,  295,  296,  297,
  293,  294,  336,  293,  294,  295,  393,  257,  258,  267,
  268,  269,  262,  336,  268,  313,  314,  393,  267,  268,
  270,  267,  272,  293,  294,  295,  413,  182,  270,  293,
  294,  295,  293,  294,  189,  317,  318,  413,  293,  294,
  295,  196,  376,  377,  378,  268,  335,  336,  337,  443,
  444,  267,  267,  376,  377,  378,  268,  267,  392,  393,
  333,  394,  397,  313,  314,  388,  389,  395,  399,  392,
  393,  396,  227,  402,  316,  317,  318,  319,  320,  321,
  322,  323,  324,  325,  407,  408,  241,  398,  403,  405,
  388,  389,  404,  326,  326,  326,  326,  326,  253,  254,
  255,  256,  257,  374,  326,  326,  326,  326,  326,  443,
  444,  312,  326,  326,  312,  375,    0,  334,    0,    5,
  443,  444,  333,  246,    5,  334,  352,  282,  283,  284,
  285,  286,  287,  407,  289,  290,  291,  292,  293,  346,
  295,  296,  297,  393,  316,  317,  318,  319,  320,  321,
  322,  323,  324,  325,  349,  417,  311,  466,  313,  314,
  535,  408,  480,  413,  319,   -1,  486,   -1,   -1,   -1,
   -1,   -1,  495,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  336,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  533,   -1,  535,   -1,  548,   -1,  539,   -1,   -1,  542,
   -1,  376,  377,  378,   -1,  548,   -1,   13,   14,   15,
   -1,   -1,   -1,  388,  389,   -1,   -1,  392,  393,   25,
   26,  539,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  407,  408,   -1,   -1,   42,   43,   44,   45,
   46,   47,   48,   49,   50,   51,   52,   -1,   -1,   55,
   56,   57,   58,   -1,   -1,   -1,   -1,   63,   64,   65,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  443,  444,
   -1,   -1,   78,   -1,   -1,   -1,   -1,   -1,   84,   -1,
   -1,   -1,   88,   89,   90,   91,   92,   93,   94,   95,
   96,   97,   98,   99,  100,  101,   -1,   -1,   -1,   -1,
  106,   -1,   -1,   -1,  110,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  495,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  533,   -1,
  535,   -1,   -1,   -1,  539,   -1,   -1,  542,   -1,   -1,
   -1,   -1,   -1,  548,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  221,  222,   -1,   -1,   -1,
   -1,   -1,   -1,  229,  230,  231,  232,  233,   -1,   -1,
   -1,  237,   -1,   -1,  240,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  260,  261,  262,  263,  264,  265,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  300,   -1,   -1,   -1,  304,  305,
  306,  307,  308,  309,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  325,
  326,  327,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  379,   -1,  381,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  394,   -1,
   -1,  397,   -1,   -1,   -1,  401,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  432,  433,   -1,  435,
   -1,  437,  438,  439,  440,  441,  442,   -1,   -1,   -1,
   -1,   -1,  257,  258,   -1,   -1,  452,  262,  263,  264,
  265,  266,  267,  268,  269,  270,  271,  272,  273,  274,
  275,  276,  277,  278,  279,  280,  281,  282,  283,  284,
  285,  286,  287,  288,  289,  290,  291,  292,  293,  294,
  295,  296,  297,  298,  299,  300,  301,  302,  303,  304,
  305,  306,  307,  308,  309,   -1,   -1,  312,  313,  314,
   -1,   -1,   -1,  509,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  327,  328,  329,  330,  331,  332,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  340,  341,  342,  343,  344,
   -1,  346,  347,  348,  349,  350,  351,   -1,   -1,   -1,
   -1,   -1,  357,  358,  359,  360,  361,  362,  363,  364,
  365,  366,  367,  368,  369,  370,  371,  372,   -1,   -1,
   -1,  376,  377,  378,  379,  380,  381,  382,  383,  384,
  385,  386,  387,  388,  389,  390,  391,  392,  393,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  406,  407,   -1,  409,  410,  411,   -1,  413,  414,
  415,  257,  258,   -1,   -1,   -1,  262,  263,  264,  265,
  266,  267,   -1,  269,  270,  271,  272,  273,  274,  275,
  276,  277,  278,  279,  280,  281,  282,  283,  284,  285,
  286,  287,  288,  289,  290,  291,  292,  293,  294,  295,
  296,  297,  298,  299,  300,  301,  302,  303,  304,  305,
  306,  307,  308,  309,   -1,   -1,  312,  313,  314,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  327,  328,  329,  330,  331,  332,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  340,  341,  342,  343,  344,   -1,
  346,  347,  348,  349,  350,  351,   -1,   -1,   -1,   -1,
   -1,  357,  358,  359,  360,  361,  362,  363,  364,  365,
  366,  367,  368,  369,  370,  371,  372,   -1,   -1,   -1,
  376,  377,  378,  379,  380,  381,  382,  383,  384,  385,
  386,  387,  388,  389,  390,  391,  392,  393,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  406,  407,  408,  409,  410,  411,   -1,  413,  414,  415,
  257,  258,   -1,   -1,   -1,  262,  263,  264,  265,  266,
   -1,  268,  269,  270,  271,  272,  273,  274,  275,  276,
  277,  278,  279,  280,  281,  282,  283,  284,  285,  286,
  287,  288,  289,  290,  291,  292,  293,  294,  295,  296,
  297,  298,  299,  300,  301,  302,  303,  304,  305,  306,
  307,  308,  309,   -1,   -1,  312,  313,  314,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  327,  328,  329,  330,  331,  332,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  340,  341,  342,  343,  344,   -1,  346,
  347,  348,  349,  350,  351,   -1,   -1,   -1,   -1,   -1,
  357,  358,  359,  360,  361,  362,  363,  364,  365,  366,
  367,  368,  369,  370,  371,  372,   -1,   -1,   -1,  376,
  377,  378,  379,  380,  381,  382,  383,  384,  385,  386,
  387,  388,  389,  390,  391,  392,  393,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  406,
  407,  408,  409,  410,  411,   -1,  413,  414,  415,  257,
  258,   -1,   -1,   -1,  262,  263,  264,  265,  266,  267,
   -1,  269,  270,  271,  272,  273,  274,  275,  276,  277,
  278,  279,  280,  281,  282,  283,  284,  285,  286,  287,
  288,  289,  290,  291,  292,  293,  294,  295,  296,  297,
  298,  299,  300,  301,  302,  303,  304,  305,  306,  307,
  308,  309,   -1,   -1,  312,  313,  314,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  327,
  328,  329,  330,  331,  332,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  340,  341,  342,  343,  344,   -1,  346,  347,
  348,  349,  350,  351,   -1,   -1,   -1,   -1,   -1,  357,
  358,  359,  360,  361,  362,  363,  364,  365,  366,  367,
  368,  369,  370,  371,  372,   -1,   -1,   -1,  376,  377,
  378,  379,  380,  381,  382,  383,  384,  385,  386,  387,
  388,  389,  390,  391,  392,  393,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  406,  407,
  408,  409,  410,  411,   -1,  413,  414,  415,  257,  258,
   -1,   -1,   -1,  262,  263,  264,  265,  266,   -1,  268,
  269,  270,  271,  272,  273,  274,  275,  276,  277,  278,
  279,  280,  281,  282,  283,  284,  285,  286,  287,  288,
  289,  290,  291,  292,  293,  294,  295,  296,  297,  298,
  299,  300,  301,  302,  303,  304,  305,  306,  307,  308,
  309,   -1,   -1,  312,  313,  314,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  327,  328,
  329,  330,  331,  332,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  340,  341,  342,  343,  344,   -1,  346,  347,  348,
  349,  350,  351,   -1,   -1,   -1,   -1,   -1,  357,  358,
  359,  360,  361,  362,  363,  364,  365,  366,  367,  368,
  369,  370,  371,  372,   -1,   -1,   -1,  376,  377,  378,
  379,  380,  381,  382,  383,  384,  385,  386,  387,  388,
  389,  390,  391,  392,  393,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  406,  407,  408,
  409,  410,  411,   -1,  413,  414,  415,  257,  258,   -1,
   -1,   -1,  262,  263,  264,  265,  266,  267,   -1,  269,
  270,  271,  272,  273,  274,  275,  276,  277,  278,  279,
  280,  281,  282,  283,  284,  285,  286,  287,  288,  289,
  290,  291,  292,  293,  294,  295,  296,  297,  298,  299,
  300,  301,  302,  303,  304,  305,  306,  307,  308,  309,
   -1,   -1,  312,  313,  314,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  327,  328,  329,
  330,  331,  332,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  340,  341,  342,  343,  344,   -1,  346,  347,  348,  349,
  350,  351,   -1,   -1,   -1,   -1,   -1,  357,  358,  359,
  360,  361,  362,  363,  364,  365,  366,  367,  368,  369,
  370,  371,  372,   -1,   -1,   -1,  376,  377,  378,  379,
  380,  381,  382,  383,  384,  385,  386,  387,  388,  389,
  390,  391,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  406,  407,  408,  409,
  410,  411,   -1,  413,  414,  415,  257,  258,   -1,   -1,
   -1,  262,  263,  264,  265,  266,   -1,  268,  269,  270,
  271,  272,  273,  274,  275,  276,  277,  278,  279,  280,
  281,  282,  283,  284,  285,  286,  287,  288,  289,  290,
  291,  292,  293,  294,  295,  296,  297,  298,  299,  300,
  301,  302,  303,  304,  305,  306,  307,  308,  309,   -1,
   -1,  312,  313,  314,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  327,  328,  329,  330,
  331,  332,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,
  341,  342,  343,  344,   -1,  346,  347,  348,  349,  350,
  351,   -1,   -1,   -1,   -1,   -1,  357,  358,  359,  360,
  361,  362,  363,  364,  365,  366,  367,  368,  369,  370,
  371,  372,   -1,   -1,   -1,  376,  377,  378,  379,  380,
  381,  382,  383,  384,  385,  386,  387,  388,  389,  390,
  391,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  406,  407,  408,  409,  410,
  411,   -1,  413,  414,  415,  257,  258,   -1,   -1,   -1,
  262,  263,  264,  265,  266,   -1,  268,  269,  270,  271,
  272,  273,  274,  275,  276,  277,  278,  279,  280,  281,
  282,  283,  284,  285,  286,  287,  288,  289,  290,  291,
  292,  293,  294,  295,  296,  297,  298,  299,  300,  301,
  302,  303,  304,  305,  306,  307,  308,  309,   -1,   -1,
  312,  313,  314,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  327,  328,  329,  330,  331,
  332,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,  341,
  342,  343,  344,   -1,  346,  347,  348,  349,  350,  351,
   -1,   -1,   -1,   -1,   -1,  357,  358,  359,  360,  361,
  362,  363,  364,  365,  366,  367,  368,  369,  370,  371,
  372,   -1,   -1,   -1,  376,  377,  378,  379,  380,  381,
  382,  383,  384,  385,  386,  387,  388,  389,  390,  391,
  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  406,  407,  408,  409,  410,  411,
   -1,  413,  414,  415,  257,  258,   -1,   -1,   -1,  262,
  263,  264,  265,  266,   -1,   -1,  269,  270,  271,  272,
  273,  274,  275,  276,  277,  278,  279,  280,  281,  282,
  283,  284,  285,  286,  287,  288,  289,  290,  291,  292,
  293,  294,  295,  296,  297,  298,  299,  300,  301,  302,
  303,  304,  305,  306,  307,  308,  309,   -1,   -1,  312,
  313,  314,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  327,  328,  329,  330,  331,  332,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,  341,  342,
  343,  344,   -1,  346,  347,  348,  349,  350,  351,   -1,
   -1,   -1,   -1,   -1,  357,  358,  359,  360,  361,  362,
  363,  364,  365,  366,  367,  368,  369,  370,  371,  372,
   -1,   -1,   -1,  376,  377,  378,  379,  380,  381,  382,
  383,  384,  385,  386,  387,  388,  389,  390,  391,  392,
  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  406,  407,  408,  409,  410,  411,   -1,
  413,  414,  415,  257,  258,   -1,   -1,   -1,  262,  263,
  264,  265,  266,   -1,   -1,  269,  270,  271,  272,  273,
  274,  275,  276,  277,  278,  279,  280,  281,  282,  283,
  284,  285,  286,  287,  288,  289,  290,  291,  292,  293,
  294,  295,  296,  297,  298,  299,  300,  301,  302,  303,
  304,  305,  306,  307,  308,  309,   -1,   -1,  312,  313,
  314,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  327,  328,  329,  330,  331,  332,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  340,  341,  342,  343,
  344,   -1,  346,  347,  348,  349,  350,  351,   -1,   -1,
   -1,   -1,   -1,  357,  358,  359,  360,  361,  362,  363,
  364,  365,  366,  367,  368,  369,  370,  371,  372,   -1,
   -1,   -1,  376,  377,  378,  379,  380,  381,  382,  383,
  384,  385,  386,  387,  388,  389,  390,  391,  392,  393,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  406,  407,  408,  409,  410,  411,   -1,  413,
  414,  415,  257,  258,   -1,   -1,   -1,  262,  263,  264,
  265,  266,   -1,   -1,  269,  270,  271,  272,  273,  274,
  275,  276,  277,  278,  279,  280,  281,  282,  283,  284,
  285,  286,  287,  288,  289,  290,  291,  292,  293,  294,
  295,  296,  297,  298,  299,  300,  301,  302,  303,  304,
  305,  306,  307,  308,  309,   -1,   -1,  312,  313,  314,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  327,  328,  329,  330,  331,  332,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  340,  341,  342,  343,  344,
   -1,  346,  347,  348,  349,  350,  351,   -1,   -1,   -1,
   -1,   -1,  357,  358,  359,  360,  361,  362,  363,  364,
  365,  366,  367,  368,  369,  370,  371,  372,   -1,   -1,
   -1,  376,  377,  378,  379,  380,  381,  382,  383,  384,
  385,  386,  387,  388,  389,  390,  391,  392,  393,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  406,  407,  408,  409,  410,  411,   -1,  413,  414,
  415,  257,  258,   -1,   -1,   -1,  262,  263,  264,  265,
  266,   -1,   -1,  269,  270,  271,  272,  273,  274,  275,
  276,  277,  278,  279,  280,  281,  282,  283,  284,  285,
  286,  287,  288,  289,  290,  291,  292,  293,  294,  295,
  296,  297,  298,  299,  300,  301,  302,  303,  304,  305,
  306,  307,  308,  309,   -1,   -1,  312,  313,  314,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  327,  328,  329,  330,  331,  332,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  340,  341,  342,  343,  344,   -1,
  346,  347,  348,  349,  350,  351,   -1,   -1,   -1,   -1,
   -1,  357,  358,  359,  360,  361,  362,  363,  364,  365,
  366,  367,  368,  369,  370,  371,  372,   -1,   -1,   -1,
  376,  377,  378,  379,  380,  381,  382,  383,  384,  385,
  386,  387,  388,  389,  390,  391,  392,  393,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  406,  407,  408,  409,  410,  411,   -1,  413,  414,  415,
  257,  258,   -1,   -1,   -1,   -1,  263,  264,  265,  266,
  267,  268,  269,  270,  271,   -1,  273,  274,  275,  276,
  277,  278,  279,  280,  281,  282,  283,  284,  285,  286,
  287,  288,  289,  290,  291,  292,  293,  294,  295,  296,
  297,  298,  299,  300,  301,  302,  303,  304,  305,  306,
  307,  308,  309,   -1,   -1,  312,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  327,  328,  329,  330,  331,  332,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  340,  341,  342,  343,  344,   -1,  346,
  347,  348,  349,  350,  351,   -1,   -1,   -1,   -1,   -1,
  357,  358,  359,  360,  361,  362,  363,  364,  365,  366,
  367,  368,  369,  370,  371,  372,   -1,   -1,   -1,  376,
  377,  378,  379,  380,  381,  382,  383,  384,  385,  386,
  387,  388,  389,  390,  391,  392,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  406,
  407,  408,  409,  410,  411,  257,  258,  414,  415,   -1,
   -1,  263,  264,  265,  266,  267,  268,  269,   -1,  271,
  272,  273,  274,  275,  276,  277,  278,  279,  280,  281,
  282,  283,  284,  285,  286,  287,  288,  289,  290,  291,
  292,  293,  294,  295,  296,  297,  298,  299,  300,  301,
  302,  303,  304,  305,  306,  307,  308,  309,   -1,   -1,
  312,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  327,  328,  329,  330,  331,
  332,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,  341,
  342,  343,  344,   -1,  346,  347,  348,  349,  350,  351,
   -1,   -1,   -1,   -1,   -1,  357,  358,  359,  360,  361,
  362,  363,  364,  365,  366,  367,  368,  369,  370,  371,
  372,   -1,   -1,   -1,  376,  377,  378,  379,  380,  381,
  382,  383,  384,  385,  386,  387,  388,  389,  390,  391,
  392,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  406,  407,  408,  409,  410,  411,
  257,  258,  414,  415,   -1,   -1,  263,  264,  265,  266,
   -1,   -1,  269,   -1,  271,   -1,  273,  274,  275,  276,
  277,  278,  279,  280,  281,  282,  283,  284,  285,  286,
  287,  288,  289,  290,  291,  292,  293,  294,  295,  296,
  297,  298,  299,  300,  301,  302,  303,  304,  305,  306,
  307,  308,  309,   -1,   -1,  312,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  327,  328,  329,  330,  331,  332,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  340,  341,  342,  343,  344,   -1,  346,
  347,  348,  349,  350,  351,   -1,   -1,   -1,   -1,   -1,
  357,  358,  359,  360,  361,  362,  363,  364,  365,  366,
  367,  368,  369,  370,  371,  372,   -1,   -1,   -1,  376,
  377,  378,  379,  380,  381,  382,  383,  384,  385,  386,
  387,  388,  389,  390,  391,  392,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  406,
  407,  408,  409,  410,  411,   -1,   -1,  414,  415,  262,
  263,  264,  265,  266,  267,  268,  269,   -1,  271,   -1,
  273,  274,  275,  276,  277,  278,  279,  280,  281,  282,
  283,  284,  285,  286,  287,  288,  289,  290,  291,  292,
  293,  294,  295,  296,  297,  298,  299,  300,  301,  302,
  303,  304,  305,  306,  307,  308,  309,   -1,   -1,  312,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  327,  328,  329,  330,  331,  332,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,  341,  342,
  343,  344,   -1,  346,  347,  348,  349,  350,  351,   -1,
   -1,   -1,   -1,   -1,  357,  358,  359,  360,  361,  362,
  363,  364,  365,  366,  367,  368,  369,  370,  371,  372,
   -1,   -1,   -1,  376,  377,  378,  379,  380,  381,  382,
  383,  384,  385,  386,  387,  388,  389,  390,  391,  392,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  406,  407,  408,  409,  410,  411,   -1,
   -1,  414,  415,  262,  263,  264,  265,  266,  267,  268,
  269,   -1,  271,   -1,  273,  274,  275,  276,  277,  278,
  279,  280,  281,  282,  283,  284,  285,  286,  287,  288,
  289,  290,  291,  292,  293,  294,  295,  296,  297,  298,
  299,  300,  301,  302,  303,  304,  305,  306,  307,  308,
  309,   -1,   -1,  312,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  327,  328,
  329,  330,  331,  332,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  340,  341,  342,  343,  344,   -1,  346,  347,  348,
  349,  350,  351,   -1,   -1,   -1,   -1,   -1,  357,  358,
  359,  360,  361,  362,  363,  364,  365,  366,  367,  368,
  369,  370,  371,  372,   -1,   -1,   -1,  376,  377,  378,
  379,  380,  381,  382,  383,  384,  385,  386,  387,  388,
  389,  390,  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  406,  407,  408,
  409,  410,  411,   -1,   -1,  414,  415,  262,  263,  264,
  265,  266,  267,  268,  269,   -1,  271,   -1,  273,  274,
  275,  276,  277,  278,  279,  280,  281,  282,  283,  284,
  285,  286,  287,  288,  289,  290,  291,  292,  293,  294,
  295,  296,  297,  298,  299,  300,  301,  302,  303,  304,
  305,  306,  307,  308,  309,   -1,   -1,  312,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  327,  328,  329,  330,  331,  332,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  340,  341,  342,  343,  344,
   -1,  346,  347,  348,  349,  350,  351,   -1,   -1,   -1,
   -1,   -1,  357,  358,  359,  360,  361,  362,  363,  364,
  365,  366,  367,  368,  369,  370,  371,  372,   -1,   -1,
   -1,  376,  377,  378,  379,  380,  381,  382,  383,  384,
  385,  386,  387,  388,  389,  390,  391,  392,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  406,  407,  408,  409,  410,  411,   -1,   -1,  414,
  415,  262,  263,  264,  265,  266,  267,  268,  269,   -1,
  271,   -1,  273,  274,  275,  276,  277,  278,  279,  280,
  281,  282,  283,  284,  285,  286,  287,  288,  289,  290,
  291,  292,  293,  294,  295,  296,  297,  298,  299,  300,
  301,  302,  303,  304,  305,  306,  307,  308,  309,   -1,
   -1,  312,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  327,  328,  329,  330,
  331,  332,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,
  341,  342,  343,  344,   -1,  346,  347,  348,  349,  350,
  351,   -1,   -1,   -1,   -1,   -1,  357,  358,  359,  360,
  361,  362,  363,  364,  365,  366,  367,  368,  369,  370,
  371,  372,   -1,   -1,   -1,  376,  377,  378,  379,  380,
  381,  382,  383,  384,  385,  386,  387,  388,  389,  390,
  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  406,  407,  408,  409,  410,
  411,   -1,   -1,  414,  415,  263,  264,  265,  266,  267,
  268,  269,   -1,  271,   -1,  273,  274,  275,  276,  277,
  278,  279,  280,  281,  282,  283,  284,  285,  286,  287,
  288,  289,  290,  291,  292,  293,  294,  295,  296,  297,
  298,  299,  300,  301,  302,  303,  304,  305,  306,  307,
  308,  309,   -1,   -1,  312,   -1,   -1,  315,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  327,
  328,  329,  330,  331,  332,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  340,  341,  342,  343,  344,  345,  346,  347,
  348,  349,  350,  351,   -1,   -1,  354,   -1,   -1,  357,
  358,  359,  360,  361,  362,  363,  364,  365,  366,  367,
  368,  369,  370,  371,  372,   -1,   -1,   -1,  376,  377,
  378,  379,  380,  381,  382,  383,  384,  385,  386,  387,
  388,  389,  390,  391,  392,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  406,  407,
  408,  409,  410,  411,   -1,   -1,  414,  415,  263,  264,
  265,  266,  267,  268,  269,   -1,  271,   -1,  273,  274,
  275,  276,  277,  278,  279,  280,  281,  282,  283,  284,
  285,  286,  287,  288,  289,  290,  291,  292,  293,  294,
  295,  296,  297,  298,  299,  300,  301,  302,  303,  304,
  305,  306,  307,  308,  309,   -1,   -1,  312,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  327,  328,  329,  330,  331,  332,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  340,  341,  342,  343,  344,
  345,  346,  347,  348,  349,  350,  351,   -1,   -1,  354,
   -1,   -1,  357,  358,  359,  360,  361,  362,  363,  364,
  365,  366,  367,  368,  369,  370,  371,  372,   -1,   -1,
   -1,  376,  377,  378,  379,  380,  381,  382,  383,  384,
  385,  386,  387,  388,  389,  390,  391,  392,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  406,  407,  408,  409,  410,  411,   -1,   -1,  414,
  415,  263,  264,  265,  266,  267,  268,  269,   -1,  271,
   -1,  273,  274,  275,  276,  277,  278,  279,  280,  281,
  282,  283,  284,  285,  286,  287,  288,  289,  290,  291,
  292,  293,  294,  295,  296,  297,  298,  299,  300,  301,
  302,  303,  304,  305,  306,  307,  308,  309,   -1,   -1,
  312,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  327,  328,  329,  330,  331,
  332,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,  341,
  342,  343,  344,   -1,  346,  347,  348,  349,  350,  351,
   -1,   -1,   -1,   -1,   -1,  357,  358,  359,  360,  361,
  362,  363,  364,  365,  366,  367,  368,  369,  370,  371,
  372,   -1,   -1,   -1,  376,  377,  378,  379,  380,  381,
  382,  383,  384,  385,  386,  387,  388,  389,  390,  391,
  392,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  406,  407,  408,  409,  410,  411,
   -1,  413,  414,  415,  263,  264,  265,  266,  267,  268,
  269,   -1,  271,   -1,  273,  274,  275,  276,  277,  278,
  279,  280,  281,  282,  283,  284,  285,  286,  287,  288,
  289,  290,  291,  292,  293,  294,  295,  296,  297,  298,
  299,  300,  301,  302,  303,  304,  305,  306,  307,  308,
  309,   -1,   -1,  312,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  327,  328,
  329,  330,  331,  332,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  340,  341,  342,  343,  344,   -1,  346,  347,  348,
  349,  350,  351,   -1,   -1,   -1,   -1,   -1,  357,  358,
  359,  360,  361,  362,  363,  364,  365,  366,  367,  368,
  369,  370,  371,  372,   -1,   -1,   -1,  376,  377,  378,
  379,  380,  381,  382,  383,  384,  385,  386,  387,  388,
  389,  390,  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  406,  407,  408,
  409,  410,  411,   -1,  413,  414,  415,  263,  264,  265,
  266,  267,  268,  269,  270,  271,   -1,  273,  274,  275,
  276,  277,  278,  279,  280,  281,  282,  283,  284,  285,
  286,  287,  288,  289,  290,  291,  292,  293,  294,  295,
  296,  297,  298,  299,  300,  301,  302,  303,  304,  305,
  306,  307,  308,  309,   -1,   -1,  312,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  327,  328,  329,  330,  331,  332,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  340,  341,  342,  343,  344,   -1,
  346,  347,  348,  349,  350,  351,   -1,   -1,   -1,   -1,
   -1,  357,  358,  359,  360,  361,  362,  363,  364,  365,
  366,  367,  368,  369,  370,  371,  372,   -1,   -1,   -1,
  376,  377,  378,  379,  380,  381,  382,  383,  384,  385,
  386,  387,  388,  389,  390,  391,  392,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  406,  407,  408,  409,  410,  411,   -1,   -1,  414,  415,
  263,  264,  265,  266,  267,  268,  269,  270,  271,   -1,
  273,  274,  275,  276,  277,  278,  279,  280,  281,  282,
  283,  284,  285,  286,  287,  288,  289,  290,  291,  292,
  293,  294,  295,  296,  297,  298,  299,  300,  301,  302,
  303,  304,  305,  306,  307,  308,  309,   -1,   -1,  312,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  327,  328,  329,  330,  331,  332,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,  341,  342,
  343,  344,   -1,  346,  347,  348,  349,  350,  351,   -1,
   -1,   -1,   -1,   -1,  357,  358,  359,  360,  361,  362,
  363,  364,  365,  366,  367,  368,  369,  370,  371,  372,
   -1,   -1,   -1,  376,  377,  378,  379,  380,  381,  382,
  383,  384,  385,  386,  387,  388,  389,  390,  391,  392,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  406,  407,  408,  409,  410,  411,   -1,
   -1,  414,  415,  263,  264,  265,  266,  267,  268,  269,
   -1,  271,   -1,  273,  274,  275,  276,  277,  278,  279,
  280,  281,  282,  283,  284,  285,  286,  287,  288,  289,
  290,  291,  292,  293,  294,  295,  296,  297,  298,  299,
  300,  301,  302,  303,  304,  305,  306,  307,  308,  309,
   -1,   -1,  312,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  327,  328,  329,
  330,  331,  332,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  340,  341,  342,  343,  344,   -1,  346,  347,  348,  349,
  350,  351,   -1,   -1,  354,   -1,   -1,  357,  358,  359,
  360,  361,  362,  363,  364,  365,  366,  367,  368,  369,
  370,  371,  372,   -1,   -1,   -1,  376,  377,  378,  379,
  380,  381,  382,  383,  384,  385,  386,  387,  388,  389,
  390,  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  406,  407,  408,  409,
  410,  411,   -1,   -1,  414,  415,  263,  264,  265,  266,
  267,  268,  269,   -1,  271,  272,  273,  274,  275,  276,
  277,  278,  279,  280,  281,  282,  283,  284,  285,  286,
  287,  288,  289,  290,  291,  292,  293,  294,  295,  296,
  297,  298,  299,  300,  301,  302,  303,  304,  305,  306,
  307,  308,  309,   -1,   -1,  312,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  327,  328,  329,  330,  331,  332,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  340,  341,  342,  343,  344,   -1,  346,
  347,  348,  349,  350,  351,   -1,   -1,   -1,   -1,   -1,
  357,  358,  359,  360,  361,  362,  363,  364,  365,  366,
  367,  368,  369,  370,  371,  372,   -1,   -1,   -1,  376,
  377,  378,  379,  380,  381,  382,  383,  384,  385,  386,
  387,  388,  389,  390,  391,  392,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  406,
  407,  408,  409,  410,  411,   -1,   -1,  414,  415,  263,
  264,  265,  266,  267,  268,  269,   -1,  271,   -1,  273,
  274,  275,  276,  277,  278,  279,  280,  281,  282,  283,
  284,  285,  286,  287,  288,  289,  290,  291,  292,  293,
  294,  295,  296,  297,  298,  299,  300,  301,  302,  303,
  304,  305,  306,  307,  308,  309,   -1,   -1,  312,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  327,  328,  329,  330,  331,  332,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  340,  341,  342,  343,
  344,   -1,  346,  347,  348,  349,  350,  351,   -1,   -1,
   -1,   -1,   -1,  357,  358,  359,  360,  361,  362,  363,
  364,  365,  366,  367,  368,  369,  370,  371,  372,   -1,
   -1,   -1,  376,  377,  378,  379,  380,  381,  382,  383,
  384,  385,  386,  387,  388,  389,  390,  391,  392,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  406,  407,  408,  409,  410,  411,   -1,   -1,
  414,  415,  263,  264,  265,  266,   -1,   -1,  269,   -1,
  271,   -1,  273,  274,  275,  276,  277,  278,  279,  280,
  281,  282,  283,  284,  285,  286,  287,  288,  289,  290,
  291,  292,  293,  294,  295,  296,  297,  298,  299,  300,
  301,  302,  303,  304,  305,  306,  307,  308,  309,   -1,
   -1,  312,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  327,  328,  329,  330,
  331,  332,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,
  341,  342,  343,  344,   -1,  346,  347,  348,  349,  350,
  351,   -1,   -1,   -1,   -1,   -1,  357,  358,  359,  360,
  361,  362,  363,  364,  365,  366,  367,  368,  369,  370,
  371,  372,   -1,   -1,   -1,  376,  377,  378,  379,  380,
  381,  382,  383,  384,  385,  386,  387,  388,  389,  390,
  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  406,  407,  408,  409,  410,
  411,  412,   -1,  414,  415,  263,  264,  265,  266,   -1,
   -1,  269,   -1,  271,   -1,  273,  274,  275,  276,  277,
  278,  279,  280,  281,  282,  283,  284,  285,  286,  287,
  288,  289,  290,  291,  292,  293,  294,  295,  296,  297,
  298,  299,  300,  301,  302,  303,  304,  305,  306,  307,
  308,  309,   -1,   -1,  312,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  327,
  328,  329,  330,  331,  332,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  340,  341,  342,  343,  344,   -1,  346,  347,
  348,  349,  350,  351,   -1,   -1,   -1,   -1,   -1,  357,
  358,  359,  360,  361,  362,  363,  364,  365,  366,  367,
  368,  369,  370,  371,  372,   -1,   -1,   -1,  376,  377,
  378,  379,  380,  381,  382,  383,  384,  385,  386,  387,
  388,  389,  390,  391,  392,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  406,  407,
  408,  409,  410,  411,  412,   -1,  414,  415,  263,  264,
  265,  266,   -1,   -1,  269,   -1,  271,   -1,  273,  274,
  275,  276,  277,  278,  279,  280,  281,  282,  283,  284,
  285,  286,  287,  288,  289,  290,  291,  292,  293,  294,
  295,  296,  297,  298,  299,  300,  301,  302,  303,  304,
  305,  306,  307,  308,  309,   -1,   -1,  312,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  327,  328,  329,  330,  331,  332,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  340,  341,  342,  343,  344,
   -1,  346,  347,  348,  349,  350,  351,  352,   -1,   -1,
   -1,   -1,  357,  358,  359,  360,  361,  362,  363,  364,
  365,  366,  367,  368,  369,  370,  371,  372,   -1,   -1,
   -1,  376,  377,  378,  379,  380,  381,  382,  383,  384,
  385,  386,  387,  388,  389,  390,  391,  392,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  406,  407,  408,  409,  410,  411,   -1,   -1,  414,
  415,  263,  264,  265,  266,  267,   -1,  269,   -1,  271,
   -1,  273,  274,  275,  276,  277,  278,  279,  280,  281,
  282,  283,  284,  285,  286,  287,  288,  289,  290,  291,
  292,  293,  294,  295,  296,  297,  298,  299,  300,  301,
  302,  303,  304,  305,  306,  307,  308,  309,   -1,   -1,
  312,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  327,  328,  329,  330,  331,
  332,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,  341,
  342,  343,  344,   -1,  346,  347,  348,  349,  350,  351,
   -1,   -1,   -1,   -1,   -1,  357,  358,  359,  360,  361,
  362,  363,  364,  365,  366,  367,  368,  369,  370,  371,
  372,   -1,   -1,   -1,  376,  377,  378,  379,  380,  381,
  382,  383,  384,  385,  386,  387,  388,  389,  390,  391,
  392,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  406,  407,  408,  409,  410,  411,
   -1,   -1,  414,  415,  263,  264,  265,  266,   -1,   -1,
  269,   -1,  271,   -1,  273,  274,  275,  276,  277,  278,
  279,  280,  281,  282,  283,  284,  285,  286,  287,  288,
  289,  290,  291,  292,  293,  294,  295,  296,  297,  298,
  299,  300,  301,  302,  303,  304,  305,  306,  307,  308,
  309,   -1,   -1,  312,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  327,  328,
  329,  330,  331,  332,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  340,  341,  342,  343,  344,   -1,  346,  347,  348,
  349,  350,  351,  352,   -1,   -1,   -1,   -1,  357,  358,
  359,  360,  361,  362,  363,  364,  365,  366,  367,  368,
  369,  370,  371,  372,   -1,   -1,   -1,  376,  377,  378,
  379,  380,  381,  382,  383,  384,  385,  386,  387,  388,
  389,  390,  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  406,  407,  408,
  409,  410,  411,   -1,   -1,  414,  415,  263,  264,  265,
  266,   -1,   -1,  269,   -1,  271,   -1,  273,  274,  275,
  276,  277,  278,  279,  280,  281,  282,  283,  284,  285,
  286,  287,  288,  289,  290,  291,  292,  293,  294,  295,
  296,  297,  298,  299,  300,  301,  302,  303,  304,  305,
  306,  307,  308,  309,   -1,   -1,  312,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  327,  328,  329,  330,  331,  332,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  340,  341,  342,  343,  344,   -1,
  346,  347,  348,  349,  350,  351,  352,   -1,   -1,   -1,
   -1,  357,  358,  359,  360,  361,  362,  363,  364,  365,
  366,  367,  368,  369,  370,  371,  372,   -1,   -1,   -1,
  376,  377,  378,  379,  380,  381,  382,  383,  384,  385,
  386,  387,  388,  389,  390,  391,  392,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  406,  407,  408,  409,  410,  411,   -1,   -1,  414,  415,
  263,  264,  265,  266,   -1,   -1,  269,   -1,  271,   -1,
  273,  274,  275,  276,  277,  278,  279,  280,  281,  282,
  283,  284,  285,  286,  287,  288,  289,  290,  291,  292,
  293,  294,  295,  296,  297,  298,  299,  300,  301,  302,
  303,  304,  305,  306,  307,  308,  309,   -1,   -1,  312,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  327,  328,  329,  330,  331,  332,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,  341,  342,
  343,  344,   -1,  346,  347,  348,  349,  350,  351,  352,
   -1,   -1,   -1,   -1,  357,  358,  359,  360,  361,  362,
  363,  364,  365,  366,  367,  368,  369,  370,  371,  372,
   -1,   -1,   -1,  376,  377,  378,  379,  380,  381,  382,
  383,  384,  385,  386,  387,  388,  389,  390,  391,  392,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  406,  407,  408,  409,  410,  411,   -1,
   -1,  414,  415,  263,  264,  265,  266,   -1,   -1,  269,
   -1,  271,   -1,  273,  274,  275,  276,  277,  278,  279,
  280,  281,  282,  283,  284,  285,  286,  287,  288,  289,
  290,  291,  292,  293,  294,  295,  296,  297,  298,  299,
  300,  301,  302,  303,  304,  305,  306,  307,  308,  309,
   -1,   -1,  312,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  327,  328,  329,
  330,  331,  332,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  340,  341,  342,  343,  344,   -1,  346,  347,  348,  349,
  350,  351,   -1,   -1,   -1,   -1,   -1,  357,  358,  359,
  360,  361,  362,  363,  364,  365,  366,  367,  368,  369,
  370,  371,  372,   -1,   -1,   -1,  376,  377,  378,  379,
  380,  381,  382,  383,  384,  385,  386,  387,  388,  389,
  390,  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  406,  407,  408,  409,
  410,  411,   -1,   -1,  414,  415,  263,  264,  265,  266,
   -1,   -1,  269,   -1,  271,   -1,  273,  274,  275,  276,
  277,  278,  279,  280,  281,  282,  283,  284,  285,  286,
  287,  288,  289,  290,  291,  292,  293,  294,  295,  296,
  297,  298,  299,  300,  301,  302,  303,  304,  305,  306,
  307,  308,  309,   -1,   -1,  312,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  327,  328,  329,  330,  331,  332,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  340,  341,  342,  343,  344,   -1,  346,
  347,  348,  349,  350,  351,   -1,   -1,   -1,   -1,   -1,
  357,  358,  359,  360,  361,  362,  363,  364,  365,  366,
  367,  368,  369,  370,  371,  372,   -1,   -1,   -1,  376,
  377,  378,  379,  380,  381,  382,  383,  384,  385,  386,
  387,  388,  389,  390,  391,  392,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  406,
  407,  408,  409,  410,  411,   -1,   -1,  414,  415,
};
#define YYFINAL 4
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 416
#if YYDEBUG
static const char *yyname[] = {

"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"TEXOVER","TEXATOP","CHAR",
"STARTMATH","STARTDMATH","ENDMATH","MI","MIB","MN","MO","SUP","SUB","MROWOPEN",
"MROWCLOSE","LEFT","RIGHT","BIG","BBIG","BIGG","BBIGG","BIGL","BBIGL","BIGGL",
"BBIGGL","FRAC","TFRAC","OPERATORNAME","MATHOP","MATHBIN","MATHREL","MOP","MOL",
"MOLL","MOF","MOR","PERIODDELIM","OTHERDELIM","LEFTDELIM","RIGHTDELIM","MOS",
"MOB","SQRT","ROOT","BINOM","TBINOM","UNDER","OVER","OVERBRACE","UNDERLINE",
"UNDERBRACE","UNDEROVER","TENSOR","MULTI","ARRAYALIGN","COLUMNALIGN","ARRAY",
"COLSEP","ROWSEP","ARRAYOPTS","COLLAYOUT","COLALIGN","ROWALIGN","ALIGN",
"EQROWS","EQCOLS","ROWLINES","COLLINES","FRAME","PADDING","ATTRLIST","ITALICS",
"BOLD","BOXED","SLASHED","RM","BB","ST","END","BBLOWERCHAR","BBUPPERCHAR",
"BBDIGIT","CALCHAR","FRAKCHAR","CAL","FRAK","CLAP","LLAP","RLAP","ROWOPTS",
"TEXTSIZE","SCSIZE","SCSCSIZE","DISPLAY","TEXTSTY","TEXTBOX","TEXTSTRING",
"XMLSTRING","CELLOPTS","ROWSPAN","COLSPAN","THINSPACE","MEDSPACE","THICKSPACE",
"QUAD","QQUAD","NEGSPACE","PHANTOM","HREF","UNKNOWNCHAR","EMPTYMROW","STATLINE",
"TOOLTIP","TOGGLE","FGHIGHLIGHT","BGHIGHLIGHT","SPACE","INTONE","INTTWO",
"INTTHREE","BAR","WIDEBAR","VEC","WIDEVEC","HAT","WIDEHAT","CHECK","WIDECHECK",
"TILDE","WIDETILDE","DOT","DDOT","DDDOT","DDDDOT","UNARYMINUS","UNARYPLUS",
"BEGINENV","ENDENV","MATRIX","PMATRIX","BMATRIX","BBMATRIX","VMATRIX",
"VVMATRIX","SVG","ENDSVG","SMALLMATRIX","CASES","ALIGNED","GATHERED","SUBSTACK",
"PMOD","RMCHAR","COLOR","BGCOLOR","XARROW","OPTARGOPEN","OPTARGCLOSE","ITEXNUM",
"RAISEBOX","NEG",
};
static const char *yyrule[] = {
"$accept : doc",
"doc : xmlmmlTermList",
"xmlmmlTermList :",
"xmlmmlTermList : char",
"xmlmmlTermList : expression",
"xmlmmlTermList : xmlmmlTermList char",
"xmlmmlTermList : xmlmmlTermList expression",
"char : CHAR",
"expression : STARTMATH ENDMATH",
"expression : STARTDMATH ENDMATH",
"expression : STARTMATH compoundTermList ENDMATH",
"expression : STARTDMATH compoundTermList ENDMATH",
"compoundTermList : compoundTerm",
"compoundTermList : compoundTermList compoundTerm",
"compoundTerm : mob SUB closedTerm SUP closedTerm",
"compoundTerm : mob SUB closedTerm",
"compoundTerm : mob SUP closedTerm SUB closedTerm",
"compoundTerm : mob SUP closedTerm",
"compoundTerm : mib SUB closedTerm SUP closedTerm",
"compoundTerm : mib SUB closedTerm",
"compoundTerm : mib SUP closedTerm SUB closedTerm",
"compoundTerm : mib SUP closedTerm",
"compoundTerm : closedTerm SUB closedTerm SUP closedTerm",
"compoundTerm : closedTerm SUP closedTerm SUB closedTerm",
"compoundTerm : closedTerm SUB closedTerm",
"compoundTerm : closedTerm SUP closedTerm",
"compoundTerm : SUB closedTerm",
"compoundTerm : SUP closedTerm",
"compoundTerm : closedTerm",
"closedTerm : array",
"closedTerm : unaryminus",
"closedTerm : unaryplus",
"closedTerm : mib",
"closedTerm : mi",
"closedTerm : mn",
"closedTerm : mo",
"closedTerm : tensor",
"closedTerm : multi",
"closedTerm : mfrac",
"closedTerm : binom",
"closedTerm : msqrt",
"closedTerm : mroot",
"closedTerm : raisebox",
"closedTerm : munder",
"closedTerm : mover",
"closedTerm : bar",
"closedTerm : vec",
"closedTerm : hat",
"closedTerm : dot",
"closedTerm : ddot",
"closedTerm : dddot",
"closedTerm : ddddot",
"closedTerm : check",
"closedTerm : tilde",
"closedTerm : moverbrace",
"closedTerm : munderbrace",
"closedTerm : munderline",
"closedTerm : munderover",
"closedTerm : emptymrow",
"closedTerm : mathclap",
"closedTerm : mathllap",
"closedTerm : mathrlap",
"closedTerm : displaystyle",
"closedTerm : textstyle",
"closedTerm : textsize",
"closedTerm : scriptsize",
"closedTerm : scriptscriptsize",
"closedTerm : italics",
"closedTerm : bold",
"closedTerm : roman",
"closedTerm : rmchars",
"closedTerm : bbold",
"closedTerm : frak",
"closedTerm : slashed",
"closedTerm : boxed",
"closedTerm : cal",
"closedTerm : space",
"closedTerm : textstring",
"closedTerm : thinspace",
"closedTerm : medspace",
"closedTerm : thickspace",
"closedTerm : quad",
"closedTerm : qquad",
"closedTerm : negspace",
"closedTerm : phantom",
"closedTerm : href",
"closedTerm : statusline",
"closedTerm : tooltip",
"closedTerm : toggle",
"closedTerm : fghighlight",
"closedTerm : bghighlight",
"closedTerm : color",
"closedTerm : texover",
"closedTerm : texatop",
"closedTerm : MROWOPEN closedTerm MROWCLOSE",
"closedTerm : MROWOPEN compoundTermList MROWCLOSE",
"closedTerm : left compoundTermList right",
"closedTerm : mathenv",
"closedTerm : substack",
"closedTerm : pmod",
"closedTerm : unrecognized",
"left : LEFT LEFTDELIM",
"left : LEFT OTHERDELIM",
"left : LEFT PERIODDELIM",
"right : RIGHT RIGHTDELIM",
"right : RIGHT OTHERDELIM",
"right : RIGHT PERIODDELIM",
"bigdelim : BIG LEFTDELIM",
"bigdelim : BIG RIGHTDELIM",
"bigdelim : BIG OTHERDELIM",
"bigdelim : BBIG LEFTDELIM",
"bigdelim : BBIG RIGHTDELIM",
"bigdelim : BBIG OTHERDELIM",
"bigdelim : BIGG LEFTDELIM",
"bigdelim : BIGG RIGHTDELIM",
"bigdelim : BIGG OTHERDELIM",
"bigdelim : BBIGG LEFTDELIM",
"bigdelim : BBIGG RIGHTDELIM",
"bigdelim : BBIGG OTHERDELIM",
"bigdelim : BIGL LEFTDELIM",
"bigdelim : BIGL OTHERDELIM",
"bigdelim : BBIGL LEFTDELIM",
"bigdelim : BBIGL OTHERDELIM",
"bigdelim : BIGGL LEFTDELIM",
"bigdelim : BIGGL OTHERDELIM",
"bigdelim : BBIGGL LEFTDELIM",
"bigdelim : BBIGGL OTHERDELIM",
"unrecognized : UNKNOWNCHAR",
"unaryminus : UNARYMINUS",
"unaryplus : UNARYPLUS",
"mi : MI",
"mib : MIB",
"mn : MN",
"mn : ITEXNUM TEXTSTRING",
"mob : MOB",
"mo : mob",
"mo : bigdelim",
"mo : MO",
"mo : MOL",
"mo : MOLL",
"mo : RIGHTDELIM",
"mo : LEFTDELIM",
"mo : OTHERDELIM",
"mo : MOF",
"mo : PERIODDELIM",
"mo : MOS",
"mo : MOP",
"mo : MOR",
"mo : OPERATORNAME TEXTSTRING",
"mo : MATHOP TEXTSTRING",
"mo : MATHBIN TEXTSTRING",
"mo : MATHREL TEXTSTRING",
"space : SPACE ST INTONE END ST INTTWO END ST INTTHREE END",
"statusline : STATLINE TEXTSTRING closedTerm",
"tooltip : TOOLTIP TEXTSTRING closedTerm",
"toggle : TOGGLE closedTerm closedTerm",
"fghighlight : FGHIGHLIGHT ATTRLIST closedTerm",
"bghighlight : BGHIGHLIGHT ATTRLIST closedTerm",
"color : COLOR ATTRLIST compoundTermList",
"color : BGCOLOR ATTRLIST compoundTermList",
"mathrlap : RLAP closedTerm",
"mathllap : LLAP closedTerm",
"mathclap : CLAP closedTerm",
"textstring : TEXTBOX TEXTSTRING",
"displaystyle : DISPLAY compoundTermList",
"textstyle : TEXTSTY compoundTermList",
"textsize : TEXTSIZE compoundTermList",
"scriptsize : SCSIZE compoundTermList",
"scriptscriptsize : SCSCSIZE compoundTermList",
"italics : ITALICS closedTerm",
"slashed : SLASHED closedTerm",
"boxed : BOXED closedTerm",
"bold : BOLD closedTerm",
"roman : RM ST rmchars END",
"rmchars : RMCHAR",
"rmchars : rmchars RMCHAR",
"bbold : BB ST bbchars END",
"bbchars : bbchar",
"bbchars : bbchars bbchar",
"bbchar : BBLOWERCHAR",
"bbchar : BBUPPERCHAR",
"bbchar : BBDIGIT",
"frak : FRAK ST frakletters END",
"frakletters : frakletter",
"frakletters : frakletters frakletter",
"frakletter : FRAKCHAR",
"cal : CAL ST calletters END",
"calletters : calletter",
"calletters : calletters calletter",
"calletter : CALCHAR",
"thinspace : THINSPACE",
"medspace : MEDSPACE",
"thickspace : THICKSPACE",
"quad : QUAD",
"qquad : QQUAD",
"negspace : NEGSPACE",
"phantom : PHANTOM closedTerm",
"href : HREF TEXTSTRING closedTerm",
"tensor : TENSOR closedTerm MROWOPEN subsupList MROWCLOSE",
"tensor : TENSOR closedTerm subsupList",
"multi : MULTI MROWOPEN subsupList MROWCLOSE closedTerm MROWOPEN subsupList MROWCLOSE",
"multi : MULTI MROWOPEN subsupList MROWCLOSE closedTerm EMPTYMROW",
"multi : MULTI EMPTYMROW closedTerm MROWOPEN subsupList MROWCLOSE",
"subsupList : subsupTerm",
"subsupList : subsupList subsupTerm",
"subsupTerm : SUB closedTerm SUP closedTerm",
"subsupTerm : SUB closedTerm",
"subsupTerm : SUP closedTerm",
"subsupTerm : SUB SUP closedTerm",
"mfrac : FRAC closedTerm closedTerm",
"mfrac : TFRAC closedTerm closedTerm",
"pmod : PMOD closedTerm",
"texover : MROWOPEN compoundTermList TEXOVER compoundTermList MROWCLOSE",
"texover : left compoundTermList TEXOVER compoundTermList right",
"texatop : MROWOPEN compoundTermList TEXATOP compoundTermList MROWCLOSE",
"texatop : left compoundTermList TEXATOP compoundTermList right",
"binom : BINOM closedTerm closedTerm",
"binom : TBINOM closedTerm closedTerm",
"munderbrace : UNDERBRACE closedTerm",
"munderline : UNDERLINE closedTerm",
"moverbrace : OVERBRACE closedTerm",
"bar : BAR closedTerm",
"bar : WIDEBAR closedTerm",
"vec : VEC closedTerm",
"vec : WIDEVEC closedTerm",
"dot : DOT closedTerm",
"ddot : DDOT closedTerm",
"dddot : DDDOT closedTerm",
"ddddot : DDDDOT closedTerm",
"tilde : TILDE closedTerm",
"tilde : WIDETILDE closedTerm",
"check : CHECK closedTerm",
"check : WIDECHECK closedTerm",
"hat : HAT closedTerm",
"hat : WIDEHAT closedTerm",
"msqrt : SQRT closedTerm",
"mroot : SQRT OPTARGOPEN compoundTermList OPTARGCLOSE closedTerm",
"mroot : ROOT closedTerm closedTerm",
"raisebox : RAISEBOX TEXTSTRING TEXTSTRING TEXTSTRING closedTerm",
"raisebox : RAISEBOX NEG TEXTSTRING TEXTSTRING TEXTSTRING closedTerm",
"raisebox : RAISEBOX TEXTSTRING TEXTSTRING closedTerm",
"raisebox : RAISEBOX NEG TEXTSTRING TEXTSTRING closedTerm",
"raisebox : RAISEBOX TEXTSTRING closedTerm",
"raisebox : RAISEBOX NEG TEXTSTRING closedTerm",
"munder : XARROW OPTARGOPEN compoundTermList OPTARGCLOSE EMPTYMROW",
"munder : UNDER closedTerm closedTerm",
"mover : XARROW closedTerm",
"mover : OVER closedTerm closedTerm",
"munderover : XARROW OPTARGOPEN compoundTermList OPTARGCLOSE closedTerm",
"munderover : UNDEROVER closedTerm closedTerm closedTerm",
"emptymrow : EMPTYMROW",
"mathenv : BEGINENV MATRIX tableRowList ENDENV MATRIX",
"mathenv : BEGINENV GATHERED tableRowList ENDENV GATHERED",
"mathenv : BEGINENV PMATRIX tableRowList ENDENV PMATRIX",
"mathenv : BEGINENV BMATRIX tableRowList ENDENV BMATRIX",
"mathenv : BEGINENV VMATRIX tableRowList ENDENV VMATRIX",
"mathenv : BEGINENV BBMATRIX tableRowList ENDENV BBMATRIX",
"mathenv : BEGINENV VVMATRIX tableRowList ENDENV VVMATRIX",
"mathenv : BEGINENV SMALLMATRIX tableRowList ENDENV SMALLMATRIX",
"mathenv : BEGINENV CASES tableRowList ENDENV CASES",
"mathenv : BEGINENV ALIGNED tableRowList ENDENV ALIGNED",
"mathenv : BEGINENV ARRAY ARRAYALIGN ST columnAlignList END tableRowList ENDENV ARRAY",
"mathenv : BEGINENV ARRAY ST columnAlignList END tableRowList ENDENV ARRAY",
"mathenv : BEGINENV SVG XMLSTRING ENDSVG",
"mathenv : BEGINENV SVG ENDSVG",
"columnAlignList : columnAlignList COLUMNALIGN",
"columnAlignList : COLUMNALIGN",
"substack : SUBSTACK MROWOPEN tableRowList MROWCLOSE",
"array : ARRAY MROWOPEN tableRowList MROWCLOSE",
"array : ARRAY MROWOPEN ARRAYOPTS MROWOPEN arrayopts MROWCLOSE tableRowList MROWCLOSE",
"arrayopts : anarrayopt",
"arrayopts : arrayopts anarrayopt",
"anarrayopt : collayout",
"anarrayopt : colalign",
"anarrayopt : rowalign",
"anarrayopt : align",
"anarrayopt : eqrows",
"anarrayopt : eqcols",
"anarrayopt : rowlines",
"anarrayopt : collines",
"anarrayopt : frame",
"anarrayopt : padding",
"collayout : COLLAYOUT ATTRLIST",
"colalign : COLALIGN ATTRLIST",
"rowalign : ROWALIGN ATTRLIST",
"align : ALIGN ATTRLIST",
"eqrows : EQROWS ATTRLIST",
"eqcols : EQCOLS ATTRLIST",
"rowlines : ROWLINES ATTRLIST",
"collines : COLLINES ATTRLIST",
"frame : FRAME ATTRLIST",
"padding : PADDING ATTRLIST",
"tableRowList : tableRow",
"tableRowList : tableRowList ROWSEP tableRow",
"tableRow : simpleTableRow",
"tableRow : optsTableRow",
"simpleTableRow : tableCell",
"simpleTableRow : simpleTableRow COLSEP tableCell",
"optsTableRow : ROWOPTS MROWOPEN rowopts MROWCLOSE simpleTableRow",
"rowopts : arowopt",
"rowopts : rowopts arowopt",
"arowopt : colalign",
"arowopt : rowalign",
"tableCell :",
"tableCell : compoundTermList",
"tableCell : CELLOPTS MROWOPEN cellopts MROWCLOSE compoundTermList",
"cellopts : acellopt",
"cellopts : cellopts acellopt",
"acellopt : colalign",
"acellopt : rowalign",
"acellopt : rowspan",
"acellopt : colspan",
"rowspan : ROWSPAN ATTRLIST",
"colspan : COLSPAN ATTRLIST",

};
#endif

int      yydebug;
int      yynerrs;

int      yyerrflag;
int      yychar;
YYSTYPE  yyval;
YYSTYPE  yylval;

/* define the initial stack-sizes */
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH  YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 500
#define YYMAXDEPTH  500
#endif
#endif

#define YYINITSTACKSIZE 500

typedef struct {
    unsigned stacksize;
    short    *s_base;
    short    *s_mark;
    short    *s_last;
    YYSTYPE  *l_base;
    YYSTYPE  *l_mark;
} YYSTACKDATA;
/* variables for the parser stack */
static YYSTACKDATA yystack;
#line 1761 "itex2MML.y"

char * itex2MML_parse (const char * buffer, unsigned long length)
{
  char * mathml = 0;

  int result;

  itex2MML_setup (buffer, length);
  itex2MML_restart ();

  result = itex2MML_yyparse (&mathml);

  if (result && mathml) /* shouldn't happen? */
    {
      itex2MML_free_string (mathml);
      mathml = 0;
    }
  return mathml;
}

int itex2MML_filter (const char * buffer, unsigned long length)
{
  itex2MML_setup (buffer, length);
  itex2MML_restart ();

  return itex2MML_yyparse (0);
}

#define ITEX_DELIMITER_DOLLAR 0
#define ITEX_DELIMITER_DOUBLE 1
#define ITEX_DELIMITER_SQUARE 2

static char * itex2MML_last_error = 0;

static void itex2MML_keep_error (const char * msg)
{
  if (itex2MML_last_error)
    {
      itex2MML_free_string (itex2MML_last_error);
      itex2MML_last_error = 0;
    }
  itex2MML_last_error = itex2MML_copy_escaped (msg);
}

int itex2MML_html_filter (const char * buffer, unsigned long length)
{
  return itex2MML_do_html_filter (buffer, length, 0);
}

int itex2MML_strict_html_filter (const char * buffer, unsigned long length)
{
  return itex2MML_do_html_filter (buffer, length, 1);
}

int itex2MML_do_html_filter (const char * buffer, unsigned long length, const int forbid_markup)
{
  int result = 0;

  int type = 0;
  int skip = 0;
  int match = 0;

  const char * ptr1 = buffer;
  const char * ptr2 = 0;

  const char * end = buffer + length;

  char * mathml = 0;

  void (*save_error_fn) (const char * msg) = itex2MML_error;

  itex2MML_error = itex2MML_keep_error;

 _until_math:
  ptr2 = ptr1;

  while (ptr2 < end)
    {
      if (*ptr2 == '$') break;
      if ((*ptr2 == '\\') && (ptr2 + 1 < end))
	{
	  if (*(ptr2+1) == '[') break;
	}
      ++ptr2;
    }
  if (itex2MML_write && ptr2 > ptr1)
    (*itex2MML_write) (ptr1, ptr2 - ptr1);

  if (ptr2 == end) goto _finish;

 _until_html:
  ptr1 = ptr2;

  if (ptr2 + 1 < end)
    {
      if ((*ptr2 == '\\') && (*(ptr2+1) == '['))
	{
	  type = ITEX_DELIMITER_SQUARE;
	  ptr2 += 2;
	}
      else if ((*ptr2 == '$') && (*(ptr2+1) == '$'))
	{
	  type = ITEX_DELIMITER_DOUBLE;
	  ptr2 += 2;
	}
      else
	{
	  type = ITEX_DELIMITER_DOLLAR;
	  ptr2 += 2;
	}
    }
  else goto _finish;

  skip = 0;
  match = 0;

  while (ptr2 < end)
    {
      switch (*ptr2)
	{
	case '<':
	case '>':
	  if (forbid_markup == 1) skip = 1;
	  break;

	case '\\':
	  if (ptr2 + 1 < end)
	    {
	      if (*(ptr2 + 1) == '[')
		{
		  skip = 1;
		}
	      else if (*(ptr2 + 1) == ']')
		{
		  if (type == ITEX_DELIMITER_SQUARE)
		    {
		      ptr2 += 2;
		      match = 1;
		    }
		  else
		    {
		      skip = 1;
		    }
		}
	    }
	  break;

	case '$':
	  if (type == ITEX_DELIMITER_SQUARE)
	    {
	      skip = 1;
	    }
	  else if (ptr2 + 1 < end)
	    {
	      if (*(ptr2 + 1) == '$')
		{
		  if (type == ITEX_DELIMITER_DOLLAR)
		    {
		      ptr2++;
		      match = 1;
		    }
		  else
		    {
		      ptr2 += 2;
		      match = 1;
		    }
		}
	      else
		{
		  if (type == ITEX_DELIMITER_DOLLAR)
		    {
		      ptr2++;
		      match = 1;
		    }
		  else
		    {
		      skip = 1;
		    }
		}
	    }
	  else
	    {
	      if (type == ITEX_DELIMITER_DOLLAR)
		{
		  ptr2++;
		  match = 1;
		}
	      else
		{
		  skip = 1;
		}
	    }
	  break;

	default:
	  break;
	}
      if (skip || match) break;

      ++ptr2;
    }
  if (skip)
    {
      if (type == ITEX_DELIMITER_DOLLAR)
	{
	  if (itex2MML_write)
	    (*itex2MML_write) (ptr1, 1);
	  ptr1++;
	}
      else
	{
	  if (itex2MML_write)
	    (*itex2MML_write) (ptr1, 2);
	  ptr1 += 2;
	}
      goto _until_math;
    }
  if (match)
    {
      mathml = itex2MML_parse (ptr1, ptr2 - ptr1);

      if (mathml)
	{
	  if (itex2MML_write_mathml)
	    (*itex2MML_write_mathml) (mathml);
	  itex2MML_free_string (mathml);
	  mathml = 0;
	}
      else
	{
	  ++result;
	  if (itex2MML_write)
	    {
	      if (type == ITEX_DELIMITER_DOLLAR)
		(*itex2MML_write) ("<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'><merror><mtext>", 0);
	      else
		(*itex2MML_write) ("<math xmlns='http://www.w3.org/1998/Math/MathML' display='block'><merror><mtext>", 0);

	      (*itex2MML_write) (itex2MML_last_error, 0);
	      (*itex2MML_write) ("</mtext></merror></math>", 0);
	    }
	}
      ptr1 = ptr2;

      goto _until_math;
    }
  if (itex2MML_write)
    (*itex2MML_write) (ptr1, ptr2 - ptr1);

 _finish:
  if (itex2MML_last_error)
    {
      itex2MML_free_string (itex2MML_last_error);
      itex2MML_last_error = 0;
    }
  itex2MML_error = save_error_fn;

  return result;
}
#line 2834 "y.tab.c"

#if YYDEBUG
#include <stdio.h>		/* needed for printf */
#endif

#include <stdlib.h>	/* needed for malloc, etc */
#include <string.h>	/* needed for memset */

/* allocate initial stack or double stack size, up to YYMAXDEPTH */
static int yygrowstack(YYSTACKDATA *data)
{
    int i;
    unsigned newsize;
    short *newss;
    YYSTYPE *newvs;

    if ((newsize = data->stacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return -1;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;

    i = data->s_mark - data->s_base;
    newss = (short *)realloc(data->s_base, newsize * sizeof(*newss));
    if (newss == 0)
        return -1;

    data->s_base = newss;
    data->s_mark = newss + i;

    newvs = (YYSTYPE *)realloc(data->l_base, newsize * sizeof(*newvs));
    if (newvs == 0)
        return -1;

    data->l_base = newvs;
    data->l_mark = newvs + i;

    data->stacksize = newsize;
    data->s_last = data->s_base + newsize - 1;
    return 0;
}

#if YYPURE || defined(YY_NO_LEAKS)
static void yyfreestack(YYSTACKDATA *data)
{
    free(data->s_base);
    free(data->l_base);
    memset(data, 0, sizeof(*data));
}
#else
#define yyfreestack(data) /* nothing */
#endif

#define YYABORT  goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR  goto yyerrlab

int
YYPARSE_DECL()
{
    int yym, yyn, yystate;
#if YYDEBUG
    const char *yys;

    if ((yys = getenv("YYDEBUG")) != 0)
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = YYEMPTY;
    yystate = 0;

#if YYPURE
    memset(&yystack, 0, sizeof(yystack));
#endif

    if (yystack.s_base == NULL && yygrowstack(&yystack)) goto yyoverflow;
    yystack.s_mark = yystack.s_base;
    yystack.l_mark = yystack.l_base;
    yystate = 0;
    *yystack.s_mark = 0;

yyloop:
    if ((yyn = yydefred[yystate]) != 0) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = YYLEX) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack))
        {
            goto yyoverflow;
        }
        yystate = yytable[yyn];
        *++yystack.s_mark = yytable[yyn];
        *++yystack.l_mark = yylval;
        yychar = YYEMPTY;
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;

    yyerror("syntax error");

    goto yyerrlab;

yyerrlab:
    ++yynerrs;

yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yystack.s_mark]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yystack.s_mark, yytable[yyn]);
#endif
                if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack))
                {
                    goto yyoverflow;
                }
                yystate = yytable[yyn];
                *++yystack.s_mark = yytable[yyn];
                *++yystack.l_mark = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yystack.s_mark);
#endif
                if (yystack.s_mark <= yystack.s_base) goto yyabort;
                --yystack.s_mark;
                --yystack.l_mark;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
        yychar = YYEMPTY;
        goto yyloop;
    }

yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    if (yym)
        yyval = yystack.l_mark[1-yym];
    else
        memset(&yyval, 0, sizeof yyval);
    switch (yyn)
    {
case 1:
#line 284 "itex2MML.y"
	{/* all processing done in body*/}
break;
case 2:
#line 287 "itex2MML.y"
	{/* nothing - do nothing*/}
break;
case 3:
#line 288 "itex2MML.y"
	{/* proc done in body*/}
break;
case 4:
#line 289 "itex2MML.y"
	{/* all proc. in body*/}
break;
case 5:
#line 290 "itex2MML.y"
	{/* all proc. in body*/}
break;
case 6:
#line 291 "itex2MML.y"
	{/* all proc. in body*/}
break;
case 7:
#line 293 "itex2MML.y"
	{printf("%s", yystack.l_mark[0]);}
break;
case 8:
#line 295 "itex2MML.y"
	{/* empty math group - ignore*/}
break;
case 9:
#line 296 "itex2MML.y"
	{/* ditto */}
break;
case 10:
#line 297 "itex2MML.y"
	{
  char ** r = (char **) ret_str;
  char * s = itex2MML_copy3("<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>", yystack.l_mark[-1], "</math>");
  itex2MML_free_string(yystack.l_mark[-1]);
  if (r) {
    (*r) = (s == itex2MML_empty_string) ? 0 : s;
  }
  else {
    if (itex2MML_write_mathml)
      (*itex2MML_write_mathml) (s);
    itex2MML_free_string(s);
  }
}
break;
case 11:
#line 310 "itex2MML.y"
	{
  char ** r = (char **) ret_str;
  char * s = itex2MML_copy3("<math xmlns='http://www.w3.org/1998/Math/MathML' display='block'>", yystack.l_mark[-1], "</math>");
  itex2MML_free_string(yystack.l_mark[-1]);
  if (r) {
    (*r) = (s == itex2MML_empty_string) ? 0 : s;
  }
  else {
    if (itex2MML_write_mathml)
      (*itex2MML_write_mathml) (s);
    itex2MML_free_string(s);
  }
}
break;
case 12:
#line 324 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 13:
#line 328 "itex2MML.y"
	{
  yyval = itex2MML_copy2(yystack.l_mark[-1], yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 14:
#line 334 "itex2MML.y"
	{
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<munderover>", yystack.l_mark[-4], " ");
    char * s2 = itex2MML_copy3(yystack.l_mark[-2], " ", yystack.l_mark[0]);
    yyval = itex2MML_copy3(s1, s2, "</munderover>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  else {
    char * s1 = itex2MML_copy3("<msubsup>", yystack.l_mark[-4], " ");
    char * s2 = itex2MML_copy3(yystack.l_mark[-2], " ", yystack.l_mark[0]);
    yyval = itex2MML_copy3(s1, s2, "</msubsup>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 15:
#line 353 "itex2MML.y"
	{
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<munder>", yystack.l_mark[-2], " ");
    yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</munder>");
    itex2MML_free_string(s1);
  }
  else {
    char * s1 = itex2MML_copy3("<msub>", yystack.l_mark[-2], " ");
    yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</msub>");
    itex2MML_free_string(s1);
  }
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 16:
#line 367 "itex2MML.y"
	{
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<munderover>", yystack.l_mark[-4], " ");
    char * s2 = itex2MML_copy3(yystack.l_mark[0], " ", yystack.l_mark[-2]);
    yyval = itex2MML_copy3(s1, s2, "</munderover>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  else {
    char * s1 = itex2MML_copy3("<msubsup>", yystack.l_mark[-4], " ");
    char * s2 = itex2MML_copy3(yystack.l_mark[0], " ", yystack.l_mark[-2]);
    yyval = itex2MML_copy3(s1, s2, "</msubsup>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 17:
#line 386 "itex2MML.y"
	{
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<mover>", yystack.l_mark[-2], " ");
    yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</mover>");
    itex2MML_free_string(s1);
  }
  else {
    char * s1 = itex2MML_copy3("<msup>", yystack.l_mark[-2], " ");
    yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</msup>");
    itex2MML_free_string(s1);
  }
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 18:
#line 400 "itex2MML.y"
	{
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<munderover>", yystack.l_mark[-4], " ");
    char * s2 = itex2MML_copy3(yystack.l_mark[-2], " ", yystack.l_mark[0]);
    yyval = itex2MML_copy3(s1, s2, "</munderover>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  else {
    char * s1 = itex2MML_copy3("<msubsup>", yystack.l_mark[-4], " ");
    char * s2 = itex2MML_copy3(yystack.l_mark[-2], " ", yystack.l_mark[0]);
    yyval = itex2MML_copy3(s1, s2, "</msubsup>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 19:
#line 419 "itex2MML.y"
	{
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<munder>", yystack.l_mark[-2], " ");
    yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</munder>");
    itex2MML_free_string(s1);
  }
  else {
    char * s1 = itex2MML_copy3("<msub>", yystack.l_mark[-2], " ");
    yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</msub>");
    itex2MML_free_string(s1);
  }
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 20:
#line 433 "itex2MML.y"
	{
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<munderover>", yystack.l_mark[-4], " ");
    char * s2 = itex2MML_copy3(yystack.l_mark[0], " ", yystack.l_mark[-2]);
    yyval = itex2MML_copy3(s1, s2, "</munderover>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  else {
    char * s1 = itex2MML_copy3("<msubsup>", yystack.l_mark[-4], " ");
    char * s2 = itex2MML_copy3(yystack.l_mark[0], " ", yystack.l_mark[-2]);
    yyval = itex2MML_copy3(s1, s2, "</msubsup>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 21:
#line 452 "itex2MML.y"
	{
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<mover>", yystack.l_mark[-2], " ");
    yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</mover>");
    itex2MML_free_string(s1);
  }
  else {
    char * s1 = itex2MML_copy3("<msup>", yystack.l_mark[-2], " ");
    yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</msup>");
    itex2MML_free_string(s1);
  }
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 22:
#line 466 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<msubsup>", yystack.l_mark[-4], " ");
  char * s2 = itex2MML_copy3(yystack.l_mark[-2], " ", yystack.l_mark[0]);
  yyval = itex2MML_copy3(s1, s2, "</msubsup>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 23:
#line 476 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<msubsup>", yystack.l_mark[-4], " ");
  char * s2 = itex2MML_copy3(yystack.l_mark[0], " ", yystack.l_mark[-2]);
  yyval = itex2MML_copy3(s1, s2, "</msubsup>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 24:
#line 486 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<msub>", yystack.l_mark[-2], " ");
  yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</msub>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 25:
#line 493 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<msup>", yystack.l_mark[-2], " ");
  yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</msup>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 26:
#line 500 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<msub><mo></mo>", yystack.l_mark[0], "</msub>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 27:
#line 504 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<msup><mo></mo>", yystack.l_mark[0], "</msup>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 28:
#line 508 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 33:
#line 517 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mi>", yystack.l_mark[0], "</mi>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 34:
#line 521 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mn>", yystack.l_mark[0], "</mn>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 94:
#line 584 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 95:
#line 588 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow>", yystack.l_mark[-1], "</mrow>");
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 96:
#line 592 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mrow>", yystack.l_mark[-2], yystack.l_mark[-1]);
  yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</mrow>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 101:
#line 605 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo>", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 102:
#line 610 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo>", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 103:
#line 615 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy_string("");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 104:
#line 621 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo>", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 105:
#line 625 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo>", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 106:
#line 629 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 107:
#line 634 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"1.2em\" minsize=\"1.2em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 108:
#line 639 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo maxsize=\"1.2em\" minsize=\"1.2em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 109:
#line 643 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo maxsize=\"1.2em\" minsize=\"1.2em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 110:
#line 647 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"1.8em\" minsize=\"1.8em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 111:
#line 652 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo maxsize=\"1.8em\" minsize=\"1.8em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 112:
#line 656 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo maxsize=\"1.8em\" minsize=\"1.8em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 113:
#line 660 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"2.4em\" minsize=\"2.4em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 114:
#line 665 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo maxsize=\"2.4em\" minsize=\"2.4em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 115:
#line 669 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo maxsize=\"2.4em\" minsize=\"2.4em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 116:
#line 673 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"3em\" minsize=\"3em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 117:
#line 678 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo maxsize=\"3em\" minsize=\"3em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 118:
#line 682 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo maxsize=\"3em\" minsize=\"3em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 119:
#line 686 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"1.2em\" minsize=\"1.2em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 120:
#line 691 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"1.2em\" minsize=\"1.2em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 121:
#line 696 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"1.8em\" minsize=\"1.8em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 122:
#line 701 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"1.8em\" minsize=\"1.8em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 123:
#line 706 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"2.4em\" minsize=\"2.4em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 124:
#line 711 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"2.4em\" minsize=\"2.4em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 125:
#line 716 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"3em\" minsize=\"3em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 126:
#line 721 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"3em\" minsize=\"3em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 127:
#line 727 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("<merror><mtext>Unknown character</mtext></merror>");
}
break;
case 128:
#line 731 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("<mo lspace=\"verythinmathspace\" rspace=\"0em\">&minus;</mo>");
}
break;
case 129:
#line 735 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("<mo lspace=\"verythinmathspace\" rspace=\"0em\">+</mo>");
}
break;
case 131:
#line 741 "itex2MML.y"
	{
  itex2MML_rowposn=2;
  yyval = itex2MML_copy3("<mi>", yystack.l_mark[0], "</mi>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 133:
#line 748 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 134:
#line 754 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo lspace=\"thinmathspace\" rspace=\"thinmathspace\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 137:
#line 762 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo>", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 138:
#line 767 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo>", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 139:
#line 772 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mstyle scriptlevel=\"0\"><mo>", yystack.l_mark[0], "</mo></mstyle>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 140:
#line 777 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo stretchy=\"false\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 141:
#line 781 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo stretchy=\"false\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 142:
#line 786 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo stretchy=\"false\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 143:
#line 790 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo stretchy=\"false\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 144:
#line 794 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo>", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 145:
#line 798 "itex2MML.y"
	{
  itex2MML_rowposn=2;
  yyval = itex2MML_copy3("<mo lspace=\"mediummathspace\" rspace=\"mediummathspace\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 146:
#line 803 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo lspace=\"0em\" rspace=\"thinmathspace\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 147:
#line 808 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo lspace=\"verythinmathspace\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 148:
#line 813 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo lspace=\"0em\" rspace=\"thinmathspace\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 149:
#line 818 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo lspace=\"thinmathspace\" rspace=\"thinmathspace\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 150:
#line 823 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo lspace=\"mediummathspace\" rspace=\"mediummathspace\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 151:
#line 828 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo lspace=\"thickmathspace\" rspace=\"thickmathspace\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 152:
#line 834 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mspace height=\"", yystack.l_mark[-7], "ex\" depth=\"");
  char * s2 = itex2MML_copy3(yystack.l_mark[-4], "ex\" width=\"", yystack.l_mark[-1]);
  yyval = itex2MML_copy3(s1, s2, "em\"></mspace>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(yystack.l_mark[-7]);
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 153:
#line 845 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<maction actiontype=\"statusline\">", yystack.l_mark[0], "<mtext>");
  yyval = itex2MML_copy3(s1, yystack.l_mark[-1], "</mtext></maction>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 154:
#line 853 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<maction actiontype=\"tooltip\">", yystack.l_mark[0], "<mtext>");
  yyval = itex2MML_copy3(s1, yystack.l_mark[-1], "</mtext></maction>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 155:
#line 861 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<maction actiontype=\"toggle\" selection=\"2\">", yystack.l_mark[-1], " ");
  yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</maction>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 156:
#line 869 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<maction actiontype=\"highlight\" other='color=", yystack.l_mark[-1], "'>");
  yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</maction>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 157:
#line 877 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<maction actiontype=\"highlight\" other='background=", yystack.l_mark[-1], "'>");
  yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</maction>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 158:
#line 885 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mstyle mathcolor=", yystack.l_mark[-1], ">");
  yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</mstyle>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 159:
#line 892 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mstyle mathbackground=", yystack.l_mark[-1], ">");
  yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</mstyle>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 160:
#line 900 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mpadded width=\"0\">", yystack.l_mark[0], "</mpadded>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 161:
#line 905 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mpadded width=\"0\" lspace=\"-100%width\">", yystack.l_mark[0], "</mpadded>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 162:
#line 910 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mpadded width=\"0\" lspace=\"-50%width\">", yystack.l_mark[0], "</mpadded>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 163:
#line 915 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mtext>", yystack.l_mark[0], "</mtext>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 164:
#line 920 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mstyle displaystyle=\"true\">", yystack.l_mark[0], "</mstyle>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 165:
#line 925 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mstyle displaystyle=\"false\">", yystack.l_mark[0], "</mstyle>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 166:
#line 930 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mstyle scriptlevel=\"0\">", yystack.l_mark[0], "</mstyle>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 167:
#line 935 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mstyle scriptlevel=\"1\">", yystack.l_mark[0], "</mstyle>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 168:
#line 940 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mstyle scriptlevel=\"2\">", yystack.l_mark[0], "</mstyle>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 169:
#line 945 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mstyle mathvariant=\"italic\">", yystack.l_mark[0], "</mstyle>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 170:
#line 950 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<menclose notation=\"updiagonalstrike\">", yystack.l_mark[0], "</menclose>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 171:
#line 955 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<menclose notation=\"box\">", yystack.l_mark[0], "</menclose>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 172:
#line 960 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mstyle mathvariant=\"bold\">", yystack.l_mark[0], "</mstyle>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 173:
#line 965 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mi mathvariant=\"normal\">", yystack.l_mark[-1], "</mi>");
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 174:
#line 970 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 175:
#line 974 "itex2MML.y"
	{
  yyval = itex2MML_copy2(yystack.l_mark[-1], yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 176:
#line 980 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mi>", yystack.l_mark[-1], "</mi>");
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 177:
#line 985 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 178:
#line 989 "itex2MML.y"
	{
  yyval = itex2MML_copy2(yystack.l_mark[-1], yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 179:
#line 995 "itex2MML.y"
	{
  yyval = itex2MML_copy3("&", yystack.l_mark[0], "opf;");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 180:
#line 999 "itex2MML.y"
	{
  yyval = itex2MML_copy3("&", yystack.l_mark[0], "opf;");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 181:
#line 1003 "itex2MML.y"
	{
  /* Blackboard digits 0-9 correspond to Unicode characters 0x1D7D8-0x1D7E1 */
  char * end = yystack.l_mark[0] + 1;
  int code = 0x1D7D8 + strtoul(yystack.l_mark[0], &end, 10);
  yyval = itex2MML_character_reference(code);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 182:
#line 1011 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mi>", yystack.l_mark[-1], "</mi>");
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 183:
#line 1016 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 184:
#line 1020 "itex2MML.y"
	{
  yyval = itex2MML_copy2(yystack.l_mark[-1], yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 185:
#line 1026 "itex2MML.y"
	{
  yyval = itex2MML_copy3("&", yystack.l_mark[0], "fr;");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 186:
#line 1031 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mi>", yystack.l_mark[-1], "</mi>");
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 187:
#line 1036 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 188:
#line 1040 "itex2MML.y"
	{
  yyval = itex2MML_copy2(yystack.l_mark[-1], yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 189:
#line 1046 "itex2MML.y"
	{
  yyval = itex2MML_copy3("&", yystack.l_mark[0], "scr;");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 190:
#line 1051 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("<mspace width=\"thinmathspace\"></mspace>");
}
break;
case 191:
#line 1055 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("<mspace width=\"mediummathspace\"></mspace>");
}
break;
case 192:
#line 1059 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("<mspace width=\"thickmathspace\"></mspace>");
}
break;
case 193:
#line 1063 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("<mspace width=\"1em\"></mspace>");
}
break;
case 194:
#line 1067 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("<mspace width=\"2em\"></mspace>");
}
break;
case 195:
#line 1071 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("<mspace width=\"-0.1667 em\"></mspace>");
}
break;
case 196:
#line 1075 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mphantom>", yystack.l_mark[0], "</mphantom>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 197:
#line 1080 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mrow href=\"", yystack.l_mark[-1], "\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:type=\"simple\" xlink:href=\"");
  char * s2 = itex2MML_copy3(s1, yystack.l_mark[-1], "\">");
  yyval = itex2MML_copy3(s2, yystack.l_mark[0], "</mrow>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 198:
#line 1090 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mmultiscripts>", yystack.l_mark[-3], yystack.l_mark[-1]);
  yyval = itex2MML_copy2(s1, "</mmultiscripts>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-3]);
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 199:
#line 1097 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mmultiscripts>", yystack.l_mark[-1], yystack.l_mark[0]);
  yyval = itex2MML_copy2(s1, "</mmultiscripts>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 200:
#line 1105 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mmultiscripts>", yystack.l_mark[-3], yystack.l_mark[-1]);
  char * s2 = itex2MML_copy3("<mprescripts></mprescripts>", yystack.l_mark[-5], "</mmultiscripts>");
  yyval = itex2MML_copy2(s1, s2);
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(yystack.l_mark[-5]);
  itex2MML_free_string(yystack.l_mark[-3]);
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 201:
#line 1115 "itex2MML.y"
	{
  char * s1 = itex2MML_copy2("<mmultiscripts>", yystack.l_mark[-1]);
  char * s2 = itex2MML_copy3("<mprescripts></mprescripts>", yystack.l_mark[-3], "</mmultiscripts>");
  yyval = itex2MML_copy2(s1, s2);
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(yystack.l_mark[-3]);
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 202:
#line 1124 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mmultiscripts>", yystack.l_mark[-3], yystack.l_mark[-1]);
  yyval = itex2MML_copy2(s1, "</mmultiscripts>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-3]);
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 203:
#line 1132 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 204:
#line 1136 "itex2MML.y"
	{
  yyval = itex2MML_copy3(yystack.l_mark[-1], " ", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 205:
#line 1142 "itex2MML.y"
	{
  yyval = itex2MML_copy3(yystack.l_mark[-2], " ", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 206:
#line 1147 "itex2MML.y"
	{
  yyval = itex2MML_copy2(yystack.l_mark[0], " <none></none>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 207:
#line 1151 "itex2MML.y"
	{
  yyval = itex2MML_copy2("<none></none> ", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 208:
#line 1155 "itex2MML.y"
	{
  yyval = itex2MML_copy2("<none></none> ", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 209:
#line 1160 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mfrac>", yystack.l_mark[-1], yystack.l_mark[0]);
  yyval = itex2MML_copy2(s1, "</mfrac>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 210:
#line 1167 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mstyle displaystyle=\"false\"><mfrac>", yystack.l_mark[-1], yystack.l_mark[0]);
  yyval = itex2MML_copy2(s1, "</mfrac></mstyle>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 211:
#line 1175 "itex2MML.y"
	{
  yyval = itex2MML_copy3( "<mo lspace=\"mediummathspace\">(</mo><mo rspace=\"thinmathspace\">mod</mo>", yystack.l_mark[0], "<mo rspace=\"mediummathspace\">)</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 212:
#line 1180 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mfrac><mrow>", yystack.l_mark[-3], "</mrow><mrow>");
  yyval = itex2MML_copy3(s1, yystack.l_mark[-1], "</mrow></mfrac>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-3]);
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 213:
#line 1187 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mrow>", yystack.l_mark[-4], "<mfrac><mrow>");
  char * s2 = itex2MML_copy3(yystack.l_mark[-3], "</mrow><mrow>", yystack.l_mark[-1]);
  char * s3 = itex2MML_copy3("</mrow></mfrac>", yystack.l_mark[0], "</mrow>");
  yyval = itex2MML_copy3(s1, s2, s3);
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(s3);
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-3]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 214:
#line 1201 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mfrac linethickness=\"0\"><mrow>", yystack.l_mark[-3], "</mrow><mrow>");
  yyval = itex2MML_copy3(s1, yystack.l_mark[-1], "</mrow></mfrac>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-3]);
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 215:
#line 1208 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mrow>", yystack.l_mark[-4], "<mfrac linethickness=\"0\"><mrow>");
  char * s2 = itex2MML_copy3(yystack.l_mark[-3], "</mrow><mrow>", yystack.l_mark[-1]);
  char * s3 = itex2MML_copy3("</mrow></mfrac>", yystack.l_mark[0], "</mrow>");
  yyval = itex2MML_copy3(s1, s2, s3);
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(s3);
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-3]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 216:
#line 1222 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mrow><mo>(</mo><mfrac linethickness=\"0\">", yystack.l_mark[-1], yystack.l_mark[0]);
  yyval = itex2MML_copy2(s1, "</mfrac><mo>)</mo></mrow>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 217:
#line 1229 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mrow><mo>(</mo><mstyle displaystyle=\"false\"><mfrac linethickness=\"0\">", yystack.l_mark[-1], yystack.l_mark[0]);
  yyval = itex2MML_copy2(s1, "</mfrac></mstyle><mo>)</mo></mrow>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 218:
#line 1237 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<munder>", yystack.l_mark[0], "<mo>&UnderBrace;</mo></munder>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 219:
#line 1242 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<munder>", yystack.l_mark[0], "<mo>&#x00332;</mo></munder>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 220:
#line 1247 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo>&OverBrace;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 221:
#line 1252 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo stretchy=\"false\">&#x000AF;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 222:
#line 1256 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo>&#x000AF;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 223:
#line 1261 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo stretchy=\"false\">&RightVector;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 224:
#line 1265 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo>&RightVector;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 225:
#line 1270 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo>&dot;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 226:
#line 1275 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo>&Dot;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 227:
#line 1280 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo>&tdot;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 228:
#line 1285 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo>&DotDot;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 229:
#line 1290 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo stretchy=\"false\">&tilde;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 230:
#line 1294 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo>&tilde;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 231:
#line 1299 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo stretchy=\"false\">&#x2c7;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 232:
#line 1303 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo>&#x2c7;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 233:
#line 1308 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo stretchy=\"false\">&#x5E;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 234:
#line 1312 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo>&#x5E;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 235:
#line 1317 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<msqrt>", yystack.l_mark[0], "</msqrt>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 236:
#line 1322 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mroot>", yystack.l_mark[0], yystack.l_mark[-2]);
  yyval = itex2MML_copy2(s1, "</mroot>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 237:
#line 1329 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mroot>", yystack.l_mark[0], yystack.l_mark[-1]);
  yyval = itex2MML_copy2(s1, "</mroot>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 238:
#line 1337 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mpadded voffset='", yystack.l_mark[-3], "' height='");
  char * s2 = itex2MML_copy3(s1, yystack.l_mark[-2], "' depth='");
  char * s3 = itex2MML_copy3(s2, yystack.l_mark[-1], "'>");
  yyval = itex2MML_copy3(s3, yystack.l_mark[0], "</mpadded>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(s3);
  itex2MML_free_string(yystack.l_mark[-3]);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 239:
#line 1350 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mpadded voffset='-", yystack.l_mark[-3], "' height='");
  char * s2 = itex2MML_copy3(s1, yystack.l_mark[-2], "' depth='");
  char * s3 = itex2MML_copy3(s2, yystack.l_mark[-1], "'>");
  yyval = itex2MML_copy3(s3, yystack.l_mark[0], "</mpadded>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(s3);
  itex2MML_free_string(yystack.l_mark[-3]);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 240:
#line 1363 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mpadded voffset='", yystack.l_mark[-2], "' height='");
  char * s2 = itex2MML_copy3(s1, yystack.l_mark[-1], "' depth='depth'>");
  yyval = itex2MML_copy3(s2, yystack.l_mark[0], "</mpadded>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 241:
#line 1373 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mpadded voffset='-", yystack.l_mark[-2], "' height='");
  char * s2 = itex2MML_copy3(s1, yystack.l_mark[-1], "' depth='+");
  char * s3 = itex2MML_copy3(s2, yystack.l_mark[-2], "'>");
  yyval = itex2MML_copy3(s3, yystack.l_mark[0], "</mpadded>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(s3);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 242:
#line 1385 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mpadded voffset='", yystack.l_mark[-1], "' height='+");
  char * s2 = itex2MML_copy3(s1, yystack.l_mark[-1], "' depth='depth'>");
  yyval = itex2MML_copy3(s2, yystack.l_mark[0], "</mpadded>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 243:
#line 1394 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mpadded voffset='-", yystack.l_mark[-1], "' height='0pt' depth='+");
  char * s2 = itex2MML_copy3(s1, yystack.l_mark[-1], "'>");
  yyval = itex2MML_copy3(s2, yystack.l_mark[0], "</mpadded>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 244:
#line 1404 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<munder><mo>", yystack.l_mark[-4], "</mo><mrow>");
  yyval = itex2MML_copy3(s1, yystack.l_mark[-2], "</mrow></munder>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 245:
#line 1411 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<munder>", yystack.l_mark[0], yystack.l_mark[-1]);
  yyval = itex2MML_copy2(s1, "</munder>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 246:
#line 1419 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mover><mo>", yystack.l_mark[-1], "</mo>");
  yyval =  itex2MML_copy3(s1, yystack.l_mark[0], "</mover>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 247:
#line 1426 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mover>", yystack.l_mark[0], yystack.l_mark[-1]);
  yyval = itex2MML_copy2(s1, "</mover>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 248:
#line 1434 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<munderover><mo>", yystack.l_mark[-4], "</mo><mrow>");
  char * s2 = itex2MML_copy3(s1, yystack.l_mark[-2], "</mrow>");
  yyval = itex2MML_copy3(s2, yystack.l_mark[0], "</munderover>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 249:
#line 1444 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<munderover>", yystack.l_mark[0], yystack.l_mark[-2]);
  yyval = itex2MML_copy3(s1, yystack.l_mark[-1], "</munderover>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 250:
#line 1453 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("<mrow></mrow>");
}
break;
case 251:
#line 1457 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow><mtable rowspacing=\"0.5ex\">", yystack.l_mark[-2], "</mtable></mrow>");
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 252:
#line 1461 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow><mtable rowspacing=\"1.0ex\">", yystack.l_mark[-2], "</mtable></mrow>");
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 253:
#line 1465 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow><mo>(</mo><mrow><mtable rowspacing=\"0.5ex\">", yystack.l_mark[-2], "</mtable></mrow><mo>)</mo></mrow>");
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 254:
#line 1469 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow><mo>[</mo><mrow><mtable rowspacing=\"0.5ex\">", yystack.l_mark[-2], "</mtable></mrow><mo>]</mo></mrow>");
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 255:
#line 1473 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow><mo>&VerticalBar;</mo><mrow><mtable rowspacing=\"0.5ex\">", yystack.l_mark[-2], "</mtable></mrow><mo>&VerticalBar;</mo></mrow>");
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 256:
#line 1477 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow><mo>{</mo><mrow><mtable rowspacing=\"0.5ex\">", yystack.l_mark[-2], "</mtable></mrow><mo>}</mo></mrow>");
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 257:
#line 1481 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow><mo>&DoubleVerticalBar;</mo><mrow><mtable rowspacing=\"0.5ex\">", yystack.l_mark[-2], "</mtable></mrow><mo>&DoubleVerticalBar;</mo></mrow>");
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 258:
#line 1485 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mstyle scriptlevel=\"2\"><mrow><mtable rowspacing=\"0.5ex\">", yystack.l_mark[-2], "</mtable></mrow></mstyle>");
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 259:
#line 1489 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow><mo>{</mo><mrow><mtable columnalign=\"left left\">", yystack.l_mark[-2], "</mtable></mrow></mrow>");
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 260:
#line 1493 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow><mtable columnalign=\"right left right left right left right left right left\" columnspacing=\"0em\">", yystack.l_mark[-2], "</mtable></mrow>");
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 261:
#line 1497 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mtable rowspacing=\"0.5ex\" align=\"", yystack.l_mark[-6], "\" columnalign=\"");
  char * s2 = itex2MML_copy3(s1, yystack.l_mark[-4], "\">");
  yyval = itex2MML_copy3(s2, yystack.l_mark[-2], "</mtable>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(yystack.l_mark[-6]);
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 262:
#line 1507 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mtable rowspacing=\"0.5ex\" columnalign=\"", yystack.l_mark[-4], "\">");
  yyval = itex2MML_copy3(s1, yystack.l_mark[-2], "</mtable>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 263:
#line 1514 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<semantics><annotation-xml encoding=\"SVG1.1\">", yystack.l_mark[-1], "</annotation-xml></semantics>");
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 264:
#line 1518 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(" ");
}
break;
case 265:
#line 1522 "itex2MML.y"
	{
  yyval = itex2MML_copy3(yystack.l_mark[-1], " ", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 266:
#line 1527 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 267:
#line 1532 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow><mtable columnalign=\"center\" rowspacing=\"0.5ex\">", yystack.l_mark[-1], "</mtable></mrow>");
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 268:
#line 1537 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow><mtable>", yystack.l_mark[-1], "</mtable></mrow>");
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 269:
#line 1541 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mrow><mtable ", yystack.l_mark[-3], ">");
  yyval = itex2MML_copy3(s1, yystack.l_mark[-1], "</mtable></mrow>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-3]);
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 270:
#line 1549 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 271:
#line 1553 "itex2MML.y"
	{
  yyval = itex2MML_copy3(yystack.l_mark[-1], " ", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 272:
#line 1559 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 273:
#line 1563 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 274:
#line 1567 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 275:
#line 1571 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 276:
#line 1575 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 277:
#line 1579 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 278:
#line 1583 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 279:
#line 1587 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 280:
#line 1591 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 281:
#line 1595 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 282:
#line 1600 "itex2MML.y"
	{
  yyval = itex2MML_copy2("columnalign=", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 283:
#line 1605 "itex2MML.y"
	{
  yyval = itex2MML_copy2("columnalign=", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 284:
#line 1610 "itex2MML.y"
	{
  yyval = itex2MML_copy2("rowalign=", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 285:
#line 1615 "itex2MML.y"
	{
  yyval = itex2MML_copy2("align=", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 286:
#line 1620 "itex2MML.y"
	{
  yyval = itex2MML_copy2("equalrows=", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 287:
#line 1625 "itex2MML.y"
	{
  yyval = itex2MML_copy2("equalcolumns=", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 288:
#line 1630 "itex2MML.y"
	{
  yyval = itex2MML_copy2("rowlines=", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 289:
#line 1635 "itex2MML.y"
	{
  yyval = itex2MML_copy2("columnlines=", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 290:
#line 1640 "itex2MML.y"
	{
  yyval = itex2MML_copy2("frame=", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 291:
#line 1645 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("rowspacing=", yystack.l_mark[0], " columnspacing=");
  yyval = itex2MML_copy2(s1, yystack.l_mark[0]);
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 292:
#line 1652 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 293:
#line 1656 "itex2MML.y"
	{
  yyval = itex2MML_copy3(yystack.l_mark[-2], " ", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 294:
#line 1662 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mtr>", yystack.l_mark[0], "</mtr>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 295:
#line 1666 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 296:
#line 1671 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 297:
#line 1675 "itex2MML.y"
	{
  yyval = itex2MML_copy3(yystack.l_mark[-2], " ", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 298:
#line 1681 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mtr ", yystack.l_mark[-2], ">");
  yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</mtr>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 299:
#line 1689 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 300:
#line 1693 "itex2MML.y"
	{
  yyval = itex2MML_copy3(yystack.l_mark[-1], " ", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 301:
#line 1699 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 302:
#line 1703 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 303:
#line 1708 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("<mtd></mtd>");
}
break;
case 304:
#line 1711 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mtd>", yystack.l_mark[0], "</mtd>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 305:
#line 1715 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mtd ", yystack.l_mark[-2], ">");
  yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</mtd>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 306:
#line 1723 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 307:
#line 1727 "itex2MML.y"
	{
  yyval = itex2MML_copy3(yystack.l_mark[-1], " ", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 308:
#line 1733 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 309:
#line 1737 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 310:
#line 1741 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 311:
#line 1745 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 312:
#line 1750 "itex2MML.y"
	{
  yyval = itex2MML_copy2("rowspan=", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 313:
#line 1755 "itex2MML.y"
	{
  yyval = itex2MML_copy2("columnspan=", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
#line 5058 "y.tab.c"
    }
    yystack.s_mark -= yym;
    yystate = *yystack.s_mark;
    yystack.l_mark -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yystack.s_mark = YYFINAL;
        *++yystack.l_mark = yyval;
        if (yychar < 0)
        {
            if ((yychar = YYLEX) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yystack.s_mark, yystate);
#endif
    if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack))
    {
        goto yyoverflow;
    }
    *++yystack.s_mark = (short) yystate;
    *++yystack.l_mark = yyval;
    goto yyloop;

yyoverflow:
    yyerror("yacc stack overflow");

yyabort:
    yyfreestack(&yystack);
    return (1);

yyaccept:
    yyfreestack(&yystack);
    return (0);
}
