.\" $XTermId: uxterm.man,v 1.7 2013/01/01 00:40:55 tom Exp $
.\"
.\" Copyright 2007-2012, 2018 Thomas E. Dickey
.\" Copyright 2001, 2004 Branden Robinson
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" SOFTWARE IN THE PUBLIC INTEREST, INC. BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.ds N Uxterm
.ds n uxterm
.\" Escape single quotes in literal strings from groff's Unicode transform.
.ie \n(.g .ds AQ \(aq
.el       .ds AQ '
.ie \n(.g .ds `` \(lq
.el       .ds `` ``
.ie \n(.g .ds '' \(rq
.el       .ds '' ''
.\"
.TH UXTERM 1 "__app_date__" "__app_version__" "X Window System"
.SH NAME
uxterm \- X terminal emulator for Unicode (UTF-8) environments
.SH SYNOPSIS
.B \*n
[
.I xterm-options
]
.SH DESCRIPTION
.B \*n
is a wrapper around the
.B xterm(1)
program that invokes the latter program
with the \*(``U__default_class__\*('' X resource class set.
All arguments to
.B \*n
are passed to
.B xterm
without processing; the
.B \-class
and
.B \-u8
options should not be specified because they are used by the wrapper.
See the
.B xterm
manual page for more information on
.IR xterm-options .
.PP
The environment's locale settings (see \*(``ENVIRONMENT\*('' below) are
used to discern the locale's character set.
If no current locale can be determined, the locale \*(``en_US\*('' (the
English language as used in the territory of the United States) is assumed.
The
.B locale(1)
utility is used to determine whether the system supports the selected
locale.
If it does not,
.B \*n
will exit with an error and report the output of
.BR locale .
.PP
.B Note: \*n
may produce unexpected results if the current locale is set to one in which
the UTF-8 character encoding is not supported, or if fonts using the ISO
10646-1 character set are not available.
In the Debian system, the \*(``xfonts\-base\*('' package provides the fonts
that
.B \*n
uses by default.
To change the fonts
.B \*n
uses, edit the
.I __apploaddir__/U__default_class__
file.
.PP
A similar wrapper,
.B koi8rxterm(1),
is available for KOI8-R environments.
.SH ENVIRONMENT
.TP
.B LC_ALL\fR, \fBLC_CTYPE\fR, \fBLANG
The values of these variables are checked, in order, to determine the
character set used by the current locale.
.SH AUTHOR
Thomas Dickey
.SH "SEE ALSO"
.B locale(1),
.B locale(7),
.B koi8rxterm(1),
.B xterm(1)
