'\" t
.\" $XTermId: xterm.man,v 1.798 2019/09/20 09:07:49 tom Exp $
.\"
.\" Copyright 1996-2018,2019 by Thomas E. Dickey
.\"
.\"                         All Rights Reserved
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE ABOVE LISTED COPYRIGHT HOLDER(S) BE LIABLE FOR ANY
.\" CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
.\" TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
.\" SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name(s) of the above copyright
.\" holders shall not be used in advertising or otherwise to promote the
.\" sale, use or other dealings in this Software without prior written
.\" authorization.
.\"
.\"
.\" Copyright 1989  X Consortium
.\"
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that
.\" copyright notice and this permission notice appear in supporting
.\" documentation.
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Updated by Thomas E. Dickey for XFree86, July 1996 - February 2006.
.\"
.ds N Xterm
.ds n xterm
.\"
.\" Bulleted paragraph
.de bP
.ie n  .IP \(bu 4
.el    .IP \(bu 2
..
.\" these would be fallbacks for DS/DE,
.\" but groff changed the meaning of the macros.
.de NS
.ie n  .sp
.el    .sp .5
.ie n  .in +4
.el    .in +2
.nf
.ft C			\" Courier
..
.de NE
.fi
.ft R
.ie n  .in -4
.el    .in -2
..
.\" Escape single quotes in literal strings from groff's Unicode transform.
.ie \n(.g .ds AQ \(aq
.el       .ds AQ '
.ie \n(.g .ds `` \(lq
.el       .ds `` ``
.ie \n(.g .ds '' \(rq
.el       .ds '' ''
.TH XTERM 1 "__app_date__" "__app_version__" "X Window System"
.SH NAME
xterm \- terminal emulator for X
.if n .hy 0
.if n .nh
.if n .na
.SH SYNOPSIS
.B \*n
[\-\fItoolkitoption\fP \&...\&] [\-\fIoption\fP \&...\&] [\fIshell\fP]
.SH DESCRIPTION
.hy 0
.nh
The \fI\*n\fP program is a terminal emulator for the X Window System.
It provides DEC VT102/VT220 and selected features from higher-level
terminals such as VT320/VT420/VT520 (VT\fIxxx\fP).
It also provides Tektronix 4014 emulation
for programs that cannot use the window system directly.
If the underlying operating system supports
terminal resizing capabilities (for example, the SIGWINCH signal in systems
derived from 4.3BSD), \fI\*n\fP will use the facilities to notify programs
running in the window whenever it is resized.
.
.PP
The VT\fIxxx\fP and Tektronix 4014 terminals each have their own window
so that you can edit text in one and
look at graphics in the other at the same time.
To maintain the correct aspect ratio (height/width), Tektronix graphics will
be restricted to the largest box with a 4014's aspect ratio that will fit in
the window.
This box is located in the upper left area of the window.
.
.PP
Although both windows may be displayed at the same time, one of them is
considered the \*(``active\*('' window for receiving keyboard input and terminal
output.
This is the window that contains the text cursor.
The active window can be chosen through escape sequences,
the \fBVT Options\fP menu in the VT\fIxxx\fP window,
and the \fBTek Options\fP menu in the 4014 window.
.
.SH EMULATIONS
\fI\*N\fP provides usable emulations of related DEC terminals:
.bP
VT52 emulation is complete.
.bP
VT102 emulation is fairly complete, but does not support autorepeat
(because that would affect the keyboard used by other X clients).
.IP
Double-size characters are displayed properly if your font server supports
scalable bitmap fonts.
.bP
VT220 emulation does not support soft fonts, it is otherwise complete.
.bP
VT420 emulation (the default) supports controls for manipulating rectangles
of characters as well as left/right margins.
.IP
\fI\*N\fP does not support some other features which
are not suitable for emulation, e.g., two-sessions.
.PP
Terminal database (\fIterminfo\fP (5) or \fItermcap\fP (5))
entries that work with \fI\*n\fP include
.IP
an optional platform-specific entry (\*(``__default_termname__\*(''),
.br
\*(``xterm\*('',
.br
\*(``vt102\*('',
.br
\*(``vt100\*('',
.br
\*(``ansi\*('' and
.br
\*(``dumb\*(''
.PP
\fI\*N\fP automatically searches the
terminal database in this order for these entries and then
sets the \*(``TERM\*('' variable
(and the \*(``TERMCAP\*('' environment variable on a few older systems).
The alternatives after \*(``xterm\*('' are very old,
from the late 1980s.
.PP
VT100 and VT102 emulations are commonly equated,
though they actually differ.
The VT102 provided controls for inserting and deleting lines.
.PP
Similarly,
\*(``ansi\*('' and
\*(``vt100\*('' are often equated.
These are not really the same.
For instance, they use different controls for scrolling
(but \fI\*n\fP supports both).
These features differ in an \*(``ansi\*('' terminal description
from \fI\*n\fP:
.TP 8
.B acsc
.br
Pseudo-graphics (line-drawing) uses a different mapping.
.TP 8
.B xenl
.br
\fI\*N\fP wraps text at the right margin using
the VT100 \*(``newline glitch\*('' behavior.
.PP
Because of the wrapping behavior, you would occasionally have to
repaint the screen when using a text editor with the \*(``ansi\*('' description.
.PP
You may also use descriptions corresponding to the various
supported emulations such as \*(``vt220\*('' or  \*(``vt420\*('',
but should set the terminal emulation level
with the \fBdecTerminalID\fP resource.
.PP
On most systems, \fI\*n\fP will use the terminfo database.
Some older systems use termcap.
(The \*(``TERMCAP\*('' environment variable is not set if \fI\*n\fP is linked
against a terminfo library, since the requisite information is not provided
by the termcap emulation of terminfo libraries).
.
.PP
Many of the special \fI\*n\fP features may be modified under program control
through a set of escape sequences different from the standard VT\fIxxx\fP escape
sequences (see \fIXterm Control Sequences\fP).
.
.PP
The Tektronix 4014 emulation is also fairly good.
It supports 12-bit graphics addressing, scaled to the window size.
Four different font sizes and five different lines types are supported.
There is no write-through or defocused mode support.
The Tektronix text and graphics commands are recorded internally by \fI\*n\fP
and may be written to a file by sending the COPY escape sequence
(or through the \fBTektronix\fP menu; see below).
The name of the file will be
.NS
\*(``COPY\fIyyyy\fR\-\fIMM\fR\-\fIdd\fR.\fIhh\fR:\fImm\fR:\fIss\fR\*(''
.NE
.PP
where
.IR yyyy ,
.IR MM ,
.IR dd ,
.IR hh ,
.I mm
and
.I ss
are the year, month, day, hour, minute and second when the COPY was performed
(the file is created in the directory \fI\*n\fP
is started in, or the home directory for a login \fI\*n\fP).
.
.PP
Not all of the features described in this manual are necessarily available in
this version of \fI\*n\fP.
Some (e.g., the non-VT220 extensions) are available
only if they were compiled in, though the most commonly-used are in the
default configuration.
.
.SH "OTHER FEATURES"
\fI\*N\fP automatically highlights the text cursor when the
pointer enters the window (selected) and unhighlights it when the pointer
leaves the window (unselected).
If the window is the focus window, then the text cursor is
highlighted no matter where the pointer is.
.
.PP
In VT\fIxxx\fP mode, there are escape sequences to activate and deactivate
an alternate screen buffer, which is the same size as the display area
of the window.
When activated, the current screen is saved and replaced with the alternate
screen.
Saving of lines scrolled off the top of the window is disabled until the
normal screen is restored.
The usual terminal description for \fI\*n\fP allows the visual editor
.IR vi (1)
to switch to the alternate screen for editing and to restore the screen
on exit.
A popup menu entry makes it simple to switch between the normal and
alternate screens for cut and paste.
.
.PP
In either VT\fIxxx\fP or Tektronix mode,
there are escape sequences to change the name of the windows.
Additionally, in VT\fIxxx\fP mode,
\fI\*n\fP implements the window-manipulation control
sequences from \fIdtterm\fP, such as resizing the window, setting its location
on the screen.
.
.PP
\fI\*N\fP allows character-based applications to receive mouse events (currently
button-press and release events, and button-motion events)
as keyboard control sequences.
See \fIXterm Control Sequences\fP for details.
.
.\" ***************************************************************************
.SH OPTIONS
Because \fI\*n\fP uses the X Toolkit library,
it accepts the standard X Toolkit command line options.
\fI\*N\fP also accepts many application-specific options.
.PP
By convention, if an option begins with a \*(``\fB+\fP\*(''
instead of a \*(``\fB\-\fP\*('',
the option is restored to its default value.
.\" ***************************************************************************
.PP
Most of the \fI\*n\fP options are actually parsed by the X Toolkit,
which sets resource values, and
overrides corresponding resource-settings in your X resource files.
\fI\*N\fP provides the X Toolkit with a table of options.
A few of these are marked, telling the X Toolkit to ignore them
(\fB\-help\fP,
\fB\-version\fP,
\fB\-class\fP,
\fB\-e\fP, and
\fB\-into\fP).
After the X Toolkit has parsed the command-line parameters,
it removes those which it handles,
leaving the specially-marked parameters for \fI\*n\fP to handle.
.\" ***************************************************************************
.PP
These options do not set a resource value,
and are handled specially:
.TP 8
.B \-version
This causes \fI\*n\fP to print a version number to the standard output,
and then exit.
.TP 8
.B \-help
This causes \fI\*n\fP to print out a verbose message describing its options,
one per line.
The message is written to the standard output.
After printing the message, \fI\*n\fP exits.
\fI\*N\fP generates this message, sorting it and noting whether
a \*(``\fB\-\fR\fIoption\fP\*(''
or a \*(``\fB+\fR\fIoption\fP\*('' turns the feature on or off,
since some features historically have been one or the other.
\fI\*N\fP generates a concise help message (multiple options per line)
when an unknown option is used, e.g.,
.NS
\*n \-z
.NE
.IP
If the logic for a particular option such as logging is not compiled
into \fI\*n\fP, the help text for that option also is not displayed
by the \fB\-help\fP option.
.PP
The \fB\-version\fP and \fB\-help\fP options are interpreted even if \fI\*n\fP
cannot open the display, and are useful for testing and configuration scripts.
Along with \fB\-class\fP, they are checked before other options.
To do this, \fI\*n\fP has its own (much simpler) argument parser,
along with a table of the X Toolkit's built-in list of options.
.PP
Relying upon the X Toolkit to parse the options and associated values
has the advantages of simplicity and good integration with the X resource
mechanism.
There are a few drawbacks
.bP
\fI\*N\fP cannot tell easily whether a resource value was set by
one of the external resource- or application-defaults files,
whether it was set using \fBxrdb\fP(1),
or if it was set through the \fB\-xrm\fP option
or via some directly relevant command-line option.
\fI\*N\fP sees only the end-result:
a value supplied when creating its widgets.
.bP
\fI\*N\fP does not know the order in which particular options and
items in resource files are evaluated.
Rather, it sees all of the values for a given widget at the same time.
In the design of these options,
some are deemed more important,
and can override other options.
.IP
The X Toolkit uses patterns (constants and wildcards) to match resources.
Once a particular pattern has been used,
it will not modify it.
To override a given setting,
a more-specific pattern must be used,
e.g., replacing \*(``*\*('' with \*(``.\*(''.
Some poorly-designed resource files are too specific
to allow the command-line options to affect the relevant widget values.
.bP
In a few cases,
the X Toolkit combines its standard options in ways which do not work
well with \fI\*n\fP.
This happens with the color (\fB\-fg\fP, \fB\-bg\fP) and reverse (\fB\-rv\fP)
options.
\fI\*N\fP makes a special case of these and
adjusts its sense of \*(``reverse\*(''
to lessen user surprise.
.\" ***************************************************************************
.PP
One parameter (after all options) may be given.
That overrides \fI\*n\fP's built-in choice of shell program:
.bP
If the parameter is not a relative path, i.e.,
beginning with \*(``./\*('' or \*(``../\*('',
\fI\*n\fP looks for the file in the user's PATH.
In either case, this check fails
if \fI\*n\fP cannot construct an absolute path.
.bP
If that check fails (or if no such parameter is given),
\fI\*n\fP next checks the \*(``SHELL\*('' variable.
If that specifies an executable file,
\fI\*n\fP will attempt to start that.
However, \fI\*n\fP additionally checks if it is a valid shell,
and will unset \*(``SHELL\*('' if it is not.
.bP
If \*(``SHELL\*('' is not set to an executable file,
\fI\*n\fP tries to use the shell program specified
in the user's password file entry.
As before, \fI\*n\fP verifies if this is a valid shell.
.bP
Finally, if the password file entry does not specify a valid shell,
\fI\*n\fP uses \fI/bin/sh\fP.
.PP
The \fB\-e\fP option cannot be used with this parameter since
it uses all parameters following the option.
.PP
\fI\*N\fP validates shell programs by finding their pathname in
the text file \fB/etc/shells\fP.
It treats the environment variable \*(``SHELL\*('' specially because
(like \*(``TERM\*(''), \fI\*n\fP both reads and updates the variable,
and because the program started by \fI\*n\fP is not necessarily a shell.
.\" ***************************************************************************
.PP
The other options are used to control the appearance and behavior.
Not all options are necessarily configured into your copy of \fI\*n\fP:
.TP 8
.B \-132
Normally, the VT102 DECCOLM escape sequence that switches between 80 and
132 column mode is ignored.
This option causes the DECCOLM escape sequence to be recognized,
and the \fI\*n\fP window will resize appropriately.
.TP 8
.B \-ah
This option indicates that \fI\*n\fP should always highlight the text cursor.
By default,
\fI\*n\fP will display a hollow text cursor whenever the focus is lost or the
pointer leaves the window.
.TP 8
.B +ah
This option indicates that
\fI\*n\fP should do text cursor highlighting based on focus.
.TP 8
.B \-ai
This option disables active icon support if that feature was compiled
into \fI\*n\fP.
This is equivalent to setting the \fIvt100\fP resource
\fBactiveIcon\fP to \*(``false\*(''.
.TP 8
.B +ai
This option enables active icon support if that feature was compiled
into \fI\*n\fP.
This is equivalent to setting the \fIvt100\fP resource
\fBactiveIcon\fP to \*(``true\*(''.
.TP 8
.B \-aw
This option indicates that auto-wraparound should be allowed,
and is equivalent to setting the \fIvt100\fP resource
\fBautoWrap\fP to \*(``false\*(''.
.IP
Auto-wraparound
allows the cursor to automatically wrap to the beginning of the next
line when it is at the rightmost position of a line and text is
output.
.TP 8
.B +aw
This option indicates that auto-wraparound should not be allowed,
and is equivalent to setting the \fIvt100\fP resource
\fBautoWrap\fP to \*(``false\*(''.
.TP 8
.BI \-b " number"
This option specifies the size of the inner border (the distance between
the outer edge of the characters and the window border) in pixels.
That is the \fIvt100\fP \fBinternalBorder\fP resource.
The
default is \*(``2\*(''.
.TP 8
.BI \-baudrate " number"
Set the line-speed, used to test the behavior of applications that
use the line-speed when optimizing their output to the screen.
The
default is \*(``38400\*(''.
.TP 8
.B +bc
turn off text cursor blinking.
This overrides the \fBcursorBlink\fR resource.
.TP 8
.B \-bc
turn on text cursor blinking.
This overrides the \fBcursorBlink\fR resource.
.TP 8
.BI \-bcf " milliseconds"
set the amount of time text cursor is off when blinking via the
\fBcursorOffTime\fP resource.
.TP 8
.BI \-bcn " milliseconds"
set the amount of time text cursor is on when blinking via the
\fBcursorOnTime\fP resource.
.TP 8
.B "\-bdc"
Set the \fIvt100\fP resource \fBcolorBDMode\fR to \*(``false\*('',
disabling the display of characters with bold attribute as color.
.TP 8
.B "+bdc"
Set the \fIvt100\fP resource \fBcolorBDMode\fR to \*(``true\*('',
enabling the display of characters with bold attribute as color
rather than bold.
.TP 8
.B "\-cb"
Set the \fIvt100\fP resource \fBcutToBeginningOfLine\fP to \*(``false\*(''.
.TP 8
.B "+cb"
Set the \fIvt100\fP resource \fBcutToBeginningOfLine\fP to \*(``true\*(''.
.TP 8
.B "\-cc \fIcharacterclassrange\fP:\fIvalue\fP[, \&...\&]"
This sets classes indicated by the given ranges for using in selecting by
words (see \fBCHARACTER CLASSES\fP and the \fBcharClass\fP resource).
.TP 8
.B "\-cjk_width"
Set the \fBcjkWidth\fP resource to \*(``true\*(''.
When turned on, characters with East Asian Ambiguous (A) category in UTR 11
have a column width of 2.
Otherwise, they have a column width of 1.
This may be useful for some legacy CJK text
terminal-based programs assuming box drawings and others to have a column
width of 2.
It also should be turned on when you specify a TrueType
CJK double-width (bi-width/monospace) font either with \fB\-fa\fP at
the command line or \fBfaceName\fP resource.
The default is \*(``false\*(''
.TP 8
.B "+cjk_width"
Reset the \fBcjkWidth\fP resource.
.TP 8
.BI \-class " string"
This option allows you to override \fI\*n\fP's resource class.
Normally it is \*(``__default_class__\*('', but
can be set to another class such as
\*(``U__default_class__\*('' to override selected resources.
.IP
X Toolkit sets the \fBWM_CLASS\fP property using the instance name
and this class value.
.TP 8
.B "\-cm"
This option disables recognition of ANSI color-change escape sequences.
It sets the \fBcolorMode\fP resource to \*(``false\*(''.
.TP 8
.B "+cm"
This option enables recognition of ANSI color-change escape sequences.
This is the same as the \fIvt100\fP resource \fBcolorMode\fP.
.TP 8
.B "\-cn"
This option indicates that newlines should not be cut in line-mode
selections.
It sets the \fBcutNewline\fP resource to \*(``false\*(''.
.TP 8
.B +cn
This option indicates that newlines should be cut in line-mode selections.
It sets the \fBcutNewline\fP resource to \*(``true\*(''.
.TP 8
.BI \-cr " color"
This option specifies the color to use for text cursor.
The default is to
use the same foreground color that is used for text.
It sets the \fBcursorColor\fP resource according to the parameter.
.TP 8
.B \-cu
This option indicates that \fI\*n\fP should work around a bug in the
.IR more (1)
program that causes it
to incorrectly display lines that are exactly the width of the window and
are followed by a line beginning with a tab
(the leading tabs are not displayed).
This option is so named because it was originally thought to be a bug
in the
.IR curses (3x)
cursor motion package.
.TP 8
.B +cu
This option indicates that \fI\*n\fP should not work around the
.IR more (1)
bug mentioned above.
.TP 8
.B "\-dc"
This option disables the escape sequence to change dynamic colors:
the vt100 foreground and background colors,
its text cursor color,
the pointer cursor foreground and background colors,
the Tektronix emulator foreground and background colors,
its text cursor color
and highlight color.
The option sets the \fBdynamicColors\fP option to \*(``false\*(''.
.TP 8
.B "+dc"
This option enables the escape sequence to change dynamic colors.
The option sets the \fBdynamicColors\fP option to \*(``true\*(''.
.TP 8
.BI \-e "\fI program \fP[ \fIarguments \fP\&.\|.\|.\& ]\fI"
This option specifies the program (and its command line arguments) to be
run in the \fI\*n\fP window.
It also sets the window title and icon
name to be the basename of the program being executed if neither \fI\-T\fP
nor \fI\-n\fP are given on the command line.
.IP
\fBNOTE:\fP This must be the \fBlast option\fP on the command line.
.TP 8
.BI \-en " encoding"
This option determines the encoding on which \fI\*n\fP runs.
It sets the \fBlocale\fR resource.
Encodings other than UTF-8 are supported by using \fIluit\fR.
The \fB\-lc\fR option should be used instead of \fB\-en\fR for
systems with locale support.
.TP 8
.BI \-fb " font"
This option specifies a font to be used when displaying bold text.
It sets the \fBboldFont\fR resource.
.IP
This font must be the same height and width as the normal font,
otherwise it is ignored.
If only one of the normal or bold fonts is specified, it will be used as the
normal font and the bold font will be produced by overstriking this font.
.IP
See also the discussion of \fBboldMode\fP and \fBalwaysBoldMode\fP resources.
.TP 8
.BI \-fa " pattern"
This option sets the pattern for fonts selected from the FreeType
library if support for that library was compiled into \fI\*n\fP.
This corresponds to the \fBfaceName\fP resource.
When a CJK
double-width font is specified, you also need to turn
on the \fBcjkWidth\fP resource.
.IP
If you specify both \fB\-fa\fP and the X Toolkit option \fB\-fn\fP,
the \fB\-fa\fP setting overrides the latter.
.IP
See also the \fBrenderFont\fP resource,
which combines with this to determine whether FreeType fonts are
initially active.
.TP 8
.B \-fbb
This option indicates that \fI\*n\fP should
compare normal and bold fonts bounding
boxes to ensure they are compatible.
It sets the \fBfreeBoldBox\fP resource to \*(``false\*(''.
.TP 8
.B +fbb
This option indicates that \fI\*n\fP should not
compare normal and bold fonts bounding
boxes to ensure they are compatible.
It sets the \fBfreeBoldBox\fP resource to \*(``true\*(''.
.TP 8
.B \-fbx
This option indicates that \fI\*n\fP should not assume that the
normal and bold fonts have VT100 line-drawing characters.
If any are missing, \fI\*n\fP will draw the characters directly.
It sets the \fBforceBoxChars\fP resource to \*(``false\*(''.
.TP 8
.B +fbx
This option indicates that \fI\*n\fP should assume that the
normal and bold fonts have VT100 line-drawing characters.
It sets the \fBforceBoxChars\fP resource to \*(``true\*(''.
.TP 8
.BI \-fd " pattern"
This option sets the pattern for double-width fonts selected from the FreeType
library if support for that library was compiled into \fI\*n\fP.
This corresponds to the \fBfaceNameDoublesize\fP resource.
.TP 8
.BI \-fi " font"
This option sets the font for active icons if that feature was compiled
into \fI\*n\fP.
.IP
See also the discussion of the \fBiconFont\fP resource.
.TP 8
.BI \-fs " size"
This option sets the pointsize for fonts selected from the FreeType
library if support for that library was compiled into \fI\*n\fP.
This corresponds to the \fBfaceSize\fP resource.
.TP 8
.B \-fullscreen
This option indicates that \fI\*n\fP should ask the window manager to
let it use the full-screen for display,
e.g., without window decorations.
It sets the \fBfullscreen\fP resource to \*(``true\*(''.
.TP 8
.B +fullscreen
This option indicates that \fI\*n\fP should not ask the window manager to
let it use the full-screen for display.
It sets the \fBfullscreen\fP resource to \*(``false\*(''.
.TP 8
.B \-fw \fIfont\fP
This option specifies the font to be used for displaying wide text.
By default,
it will attempt to use a font twice as wide as the font that will be used to
draw normal text.
If no double-width font is found, it will improvise, by stretching
the normal font.
This corresponds to the \fBwideFont\fP resource.
.TP 8
.B \-fwb \fIfont\fP
This option specifies the font to be used for displaying bold wide text.
By default,
it will attempt to use a font twice as wide as the font that will be used to
draw bold text.
If no double-width font is found, it will improvise, by stretching
the bold font.
This corresponds to the \fBwideBoldFont\fP resource.
.TP 8
.B \-fx \fIfont\fP
This option specifies the font to be used for displaying the preedit string
in the \*(``OverTheSpot\*('' input method.
.IP
See also the discussion of the \fBximFont\fP resource.
.TP 8
.BI \-hc " color"
(see \fB\-selbg\fP).
.TP 8
.B \-hf
This option indicates that HP function key escape codes should be generated
for function keys.
It sets the \fBhpFunctionKeys\fP resource to \*(``true\*(''.
.TP 8
.B +hf
This option indicates that HP function key escape codes should not be generated
for function keys.
It sets the \fBhpFunctionKeys\fP resource to \*(``false\*(''.
.TP 8
.B \-hm
Tells \fI\*n\fP to use
\fBhighlightTextColor\fP and \fBhighlightColor\fP
to override the reversed foreground/background colors in a selection.
It sets the \fBhighlightColorMode\fP resource to \*(``true\*(''.
.TP 8
.B +hm
Tells \fI\*n\fP not to use
\fBhighlightTextColor\fP and \fBhighlightColor\fP
to override the reversed foreground/background colors in a selection.
It sets the \fBhighlightColorMode\fP resource to \*(``false\*(''.
.TP 8
.B \-hold
Turn on the \fBhold\fP resource, i.e.,
\fI\*n\fP will not immediately destroy its window
when the shell command completes.
It will wait until you use the window manager to destroy/kill the window, or
if you use the menu entries that send a signal, e.g., HUP or KILL.
.TP 8
.B +hold
Turn off the \fBhold\fP resource, i.e.,
\fI\*n\fP will immediately destroy its window when the shell command completes.
.TP 8
.B \-ie
Turn on the \fBptyInitialErase\fP resource, i.e.,
use the pseudo-terminal's sense of the \fIstty\fP erase value.
.TP 8
.B +ie
Turn off the \fBptyInitialErase\fP resource, i.e.,
set the \fIstty\fP erase value using the \fBkb\fP string
from the termcap entry as a reference, if available.
.TP 8
.B \-im
Turn on the \fBuseInsertMode\fP resource,
which forces use of insert mode by adding appropriate entries to the TERMCAP
environment variable.
(This option is ignored on most systems, because TERMCAP is not used).
.TP 8
.B +im
Turn off the \fBuseInsertMode\fP resource.
.TP 8
.BI \-into " windowId"
Given an X window identifier (an integer, which can be hexadecimal,
octal or decimal according to whether it begins with "0x", "0" or neither),
\fI\*n\fP will reparent its top-level shell widget to that window.
This is used to embed \fI\*n\fP within other applications.
.IP
For instance, there are scripts for Tcl/Tk and Gtk which can be used
to demonstrate the feature.
When using Gtk, there is a limitation of that toolkit which requires
that \fI\*n\fP's \fBallowSendEvents\fP resource is enabled.
.TP 8
.B "\-itc"
Set the \fIvt100\fP resource \fBcolorITMode\fR to \*(``false\*('',
disabling the display of characters with italic attribute as color.
.TP 8
.B "+itc"
Set the \fIvt100\fP resource \fBcolorITMode\fR to \*(``true\*('',
enabling the display of characters with italic attribute as color
rather than italic.
.TP 8
.B \-j
This option indicates that \fI\*n\fP should do jump scrolling.
It corresponds to the \fBjumpScroll\fP resource.
Normally,
text is scrolled one line at a time; this option allows \fI\*n\fP to move
multiple lines at a time so that it does not fall as far behind.
Its use is
strongly recommended since it makes \fI\*n\fP much faster when scanning
through large amounts of text.
The VT100 escape sequences for enabling and
disabling smooth scroll as well as the \fBVT Options\fP
menu can be used to turn this
feature on or off.
.TP 8
.B +j
This option indicates that \fI\*n\fP should not do jump scrolling.
.TP 8
.B \-k8
This option sets the \fBallowC1Printable\fP resource.
When \fBallowC1Printable\fP is set, \fI\*n\fP overrides the mapping
of C1 control characters (code 128\(en159) to treat them as printable.
.TP 8
.B +k8
This option resets the \fBallowC1Printable\fP resource.
.TP 8
.BI \-kt " keyboardtype"
This option sets the \fBkeyboardType\fP resource.
Possible values include:
\*(``unknown\*('',
\*(``default\*('',
\*(``legacy\*('',
\*(``hp\*('',
\*(``sco\*('',
\*(``sun\*('',
\*(``tcap\*('' and
\*(``vt220\*(''.
.IP
The value \*(``unknown\*('',
causes the corresponding resource to be ignored.
.IP
The value \*(``default\*('',
suppresses the associated resources
.IP
\fBhpFunctionKeys\fP,
.br
\fBscoFunctionKeys\fP,
.br
\fBsunFunctionKeys\fP,
.br
\fBtcapFunctionKeys\fP,
.br
\fBoldXtermFKeys\fP
and
.br
\fBsunKeyboard\fP,
.IP
using the Sun/PC keyboard layout.
.TP 8
.B \-l
Turn logging on, unless disabled by the \fBlogInhibit\fP resource.
.IP
Some versions of \fI\*n\fP may have logging enabled.
However, normally logging is not supported,
due to security concerns in the early 1990s.
That was a problem in X11R4 \fBxterm\fP (1989) which was addressed by
a patch to X11R5 late in 1993.
X11R6 included these fixes.
The older version (when running with \fIroot\fP privilege) would create
the log file using \fIroot\fP privilege.
The reason why \fI\*n\fP ran with \fIroot\fP privileges
was to open pseudo-terminals.
Those privileges are now needed only on very old systems:
Unix98 pseudo-terminals made the BSD scheme unnecessary.
.IP
Unless overridden by the \fB\-lf\fP option or the \fBlogFile\fP resource:
.RS
.bP
If the filename is \*(``-\*('', then logging is sent to the standard output.
.bP
Otherwise a filename is generated, and
the log file is written to the directory from which \fI\*n\fP is invoked.
.bP
The generated filename is of the form
.NS
XtermLog.\fIXXXXXX\fR
.NE
.IP
or
.NS
Xterm.log.\fIhostname.yyyy.mm.dd.hh.mm.ss.XXXXXX\fR
.NE
.IP
depending on how \fI\*n\fP was built.
.RE
.TP 8
.B +l
Turn logging off.
.TP 8
.B \-lc
Turn on support of various encodings according to the users'
locale setting, i.e., LC_ALL, LC_CTYPE, or LANG environment variables.
This is achieved by turning on UTF-8 mode and by invoking \fIluit\fR for
conversion between locale encodings and UTF-8.
(\fIluit\fR is not invoked in UTF-8 locales.)
This corresponds to the \fBlocale\fR resource.
.IP
The actual list of encodings which are supported is determined by \fIluit\fR.
Consult the \fIluit\fR manual page for further details.
.IP
See also the discussion of the \fB\-u8\fP option which supports UTF-8 locales.
.TP 8
.B +lc
Turn off support of automatic selection of locale encodings.
Conventional 8bit mode or, in UTF-8 locales or with \fB\-u8\fP option,
UTF-8 mode will be used.
.TP 8
.BI \-lcc " path"
File name for the encoding converter from/to locale encodings
and UTF-8 which is used with \fB\-lc\fP option or \fBlocale\fR resource.
This corresponds to the \fBlocaleFilter\fR resource.
.TP 8
.B \-leftbar
Force scrollbar to the left side of VT100 screen.
This is the default, unless you have set the rightScrollBar resource.
.TP 8
.BI \-lf " filename"
Specify the log filename.
This sets the \fBlogFile\fP resource.
If set to \*(``-\*('',
\fI\*n\fP writes its log to the standard output.
See the \fB\-l\fP option.
.TP 8
.B \-ls
This option indicates that the shell that is started in the \fI\*n\fP window
will be a login shell (i.e., the first character of argv[0] will be a dash,
indicating to the shell that it should read the user's \&.login or \&.profile).
.IP
The \fB\-ls\fP flag and the \fBloginShell\fP resource
are ignored if \fB\-e\fP is also given,
because \fI\*n\fP does not know how to make the shell
start the given command after whatever it does when it is a login
shell \- the user's shell of choice need not be a Bourne shell after all.
Also, \fI\*n\ \-e\fP is supposed to provide a consistent
functionality for other applications that need to start text-mode
programs in a window, and if \fBloginShell\fP were not ignored, the
result of ~/.profile might interfere with that.
.IP
If you do want the effect of \fB\-ls\fP and \fB\-e\fP simultaneously, you
may get away with something like
.NS 15
\*n \-e /bin/bash \-l \-c "my command here"
.NE
.IP
Finally, \fB\-ls\fP is not completely ignored,
because \fI\*n\ \-ls\ \-e\fP does write a \fI/etc/wtmp\fP entry
(if configured to do so),
whereas \fI\*n\ \-e\fP does not.
.TP 8
.B \-maximized
This option indicates that \fI\*n\fP should ask the window manager to
maximize its layout on startup.
This corresponds to the \fBmaximized\fP resource.
.IP
Maximizing is not the reverse of iconifying;
it is possible to do both with certain window managers.
.TP 8
.B +maximized
This option indicates that \fI\*n\fP should ask the window manager to
not maximize its layout on startup.
.TP 8
.B +ls
This option indicates that the shell that is started should not be a login
shell (i.e., it will be a normal \*(``subshell\*('').
.TP 8
.B \-mb
This option indicates that \fI\*n\fP should ring a margin bell when
the user types near the right end of a line.
.TP 8
.B +mb
This option indicates that margin bell should not be rung.
.TP 8
.BI \-mc " milliseconds"
This option specifies the maximum time between multi-click selections.
.TP 8
.B \-mesg
Turn off the \fBmessages\fP resource, i.e.,
disallow write access to the terminal.
.TP 8
.B +mesg
Turn on the \fBmessages\fP resource, i.e.,
allow write access to the terminal.
.TP 8
.B "\-mk_width"
Set the \fBmkWidth\fP resource to \*(``true\*(''.
This makes \fI\*n\fP use a built-in version of the wide-character width
calculation.
The default is \*(``false\*(''
.TP 8
.B "+mk_width"
Reset the \fBmkWidth\fP resource.
.TP 8
.BI \-ms " color"
This option specifies the color to be used for the pointer cursor.
The default
is to use the foreground color.
This sets the \fBpointerColor\fP resource.
.TP 8
.BI \-nb " number"
This option specifies the number of characters from the right end of a line
at which the margin bell, if enabled, will ring.
The default is \*(``10\*(''.
.TP 8
.B "\-nul"
This option disables the display of underlining.
.TP 8
.B "+nul"
This option enables the display of underlining.
.TP 8
.B \-pc
This option enables the PC-style use of bold colors
(see \fBboldColors\fP resource).
.TP 8
.B +pc
This option disables the PC-style use of bold colors.
.TP 8
.B \-pob
This option indicates that the window should be raised whenever a
Control-G is received.
.TP 8
.B +pob
This option indicates that the window should not be raised whenever a
Control-G is received.
.TP 8
.B \-report\-charclass
Print a report to the standard output showing information about the
character-classes which can be altered using the \fBcharClass\fP resource.
.TP 8
.B \-report\-colors
Print a report to the standard output showing information about colors
as \fI\*n\fP allocates them.
This corresponds to the \fBreportColors\fP resource.
.TP 8
.B \-report\-fonts
Print a report to the standard output showing information about fonts
which are loaded.
This corresponds to the \fBreportFonts\fP resource.
.TP 8
.B \-report\-icons
Print a report to the standard output showing information about pixmap-icons
which are loaded.
This corresponds to the \fBreportIcons\fP resource.
.TP 8
.B \-rightbar
Force scrollbar to the right side of VT100 screen.
.TP 8
.B "\-rvc"
This option disables the display of characters with reverse attribute as color.
.TP 8
.B "+rvc"
This option enables the display of characters with reverse attribute as color.
.TP 8
.B \-rw
This option indicates that reverse-wraparound should be allowed.
This allows
the cursor to back up from the leftmost column of one line to the rightmost
column of the previous line.
This is very useful for editing long shell
command lines and is encouraged.
This option can be turned on and off from
the \fBVT Options\fP menu.
.TP 8
.B +rw
This option indicates that reverse-wraparound should not be allowed.
.TP 8
.B \-s
This option indicates that \fI\*n\fP may scroll asynchronously, meaning that
the screen does not have to be kept completely up to date while scrolling.
This allows \fI\*n\fP to run faster when network latencies are very high
and is typically useful when running across a very large internet or many
gateways.
.TP 8
.B +s
This option indicates that \fI\*n\fP should scroll synchronously.
.TP 8
.B \-samename
Does not send title and icon name change requests when the request
would have no effect: the name is not changed.
This has the advantage
of preventing flicker and the disadvantage of requiring an extra
round trip to the server to find out the previous value.
In practice
this should never be a problem.
.TP 8
.B +samename
Always send title and icon name change requests.
.TP 8
.B \-sb
This option indicates that some number of lines that are scrolled off the top
of the window should be saved and that a scrollbar should be displayed so that
those lines can be viewed.
This option may be turned on and off from the \fBVT Options\fP menu.
.TP 8
.B +sb
This option indicates that a scrollbar should not be displayed.
.TP 8
.BI \-selbg " color"
This option specifies the color to use for the background of selected text.
If not specified, reverse video is used.
See the discussion of the \fBhighlightColor\fP resource.
.TP 8
.BI \-selfg " color"
This option specifies the color to use for selected text.
If not specified, reverse video is used.
See the discussion of the \fBhighlightTextColor\fP resource.
.TP 8
.B \-sf
This option indicates that Sun function key escape codes should be generated
for function keys.
.TP 8
.B +sf
This option indicates that the standard escape codes should be generated for
function keys.
.TP 8
.BI \-sh " number"
scale line-height values by the given number.
See the discussion of the \fBscaleHeight\fP resource.
.TP 8
.B \-si
This option indicates that output to a window should not automatically
reposition the screen to the bottom of the scrolling region.
This option can be turned on and off from the \fBVT Options\fP menu.
.TP 8
.B +si
This option indicates that output to a window should cause it to
scroll to the bottom.
.TP 8
.B \-sk
This option indicates that pressing a key while
using the scrollbar to review previous lines of text should
cause the window to be repositioned automatically in the normal position at the
bottom of the scroll region.
.TP 8
.B +sk
This option indicates that pressing a key while using the scrollbar
should not cause the window to be repositioned.
.TP 8
.BI \-sl " number"
This option specifies the number of lines to save that have been scrolled
off the top of the screen.
This corresponds to the \fBsaveLines\fP resource.
The default is \*(``64\*(''.
.TP 8
.B \-sm
This option, corresponding to the \fBsessionMgt\fR resource,
indicates that \fI\*n\fR should
set up session manager callbacks.
.TP 8
.B +sm
This option indicates that \fI\*n\fR should
not set up session manager callbacks.
.TP 8
.B \-sp
This option indicates that Sun/PC keyboard should be assumed,
providing mapping for keypad \*(``+\*('' to \*(``,\*('', and
CTRL-F1 to F13, CTRL-F2 to F14, etc.
.TP 8
.B +sp
This option indicates that the standard escape codes should be generated for
keypad and function keys.
.TP 8
.B \-t
This option indicates that \fI\*n\fP should start in Tektronix mode, rather
than in VT\fIxxx\fP mode.
Switching between the two windows is done using the
\*(``Options\*('' menus.
.IP
Terminal database (\fIterminfo\fP (5) or \fItermcap\fP (5))
entries that work with \fI\*n\fR are:
.IP
\*(``tek4014\*('',
.br
\*(``tek4015\*('',
.br
\*(``tek4012\*('',
.br
\*(``tek4013\*('',
.br
\*(``tek4010\*('', and
.br
\*(``dumb\*(''.
.IP
\fI\*N\fP automatically searches the terminal database in this order
for these entries and then
sets the \*(``TERM\*('' variable
(and the \*(``TERMCAP\*('' environment variable, if relevant).
.TP 8
.B +t
This option indicates that \fI\*n\fP should start in VT\fIxxx\fP mode.
.TP 8
.B \-tb
This option, corresponding to the \fBtoolBar\fR resource,
indicates that \fI\*n\fR should display a toolbar (or menubar)
at the top of its window.
The buttons in the toolbar correspond to
the popup menus, e.g., control/left/mouse for \fBMain Options\fP.
.TP 8
.B +tb
This option indicates that \fI\*n\fR should
not set up a toolbar.
.TP 8
.BI \-ti " term_id"
Specify the name used by \fI\*n\fP to select the
correct response to terminal ID queries.
It also specifies the emulation level,
used to determine the type of response to a DA control sequence.
Valid values include vt52, vt100, vt101, vt102, vt220, and vt240
(the \*(``vt\*('' is optional).
The default is \*(``vt__default_termid__\*(''.
The \fIterm_id\fP argument specifies the terminal ID to use.
(This is the same as the \fBdecTerminalID\fP resource).
.TP 8
.BI \-tm " string"
This option specifies a series of terminal setting keywords followed by the
characters that should be bound to those functions, similar to the \fIstty\fP
program.
The keywords and their values are described in detail in the \fBttyModes\fP
resource.
.TP 8
.BI \-tn " name"
This option specifies the name of the terminal type to be set in the TERM
environment variable.
It corresponds to the \fBtermName\fP resource.
This terminal type must exist in the terminal
database
(termcap or terminfo, depending on how \fI\*n\fP is built)
and should have \fIli#\fP and \fIco#\fP entries.
If the terminal type is not found, \fI\*n\fP uses the built-in list
\*(``xterm\*('', \*(``vt102\*('', etc.
.TP 8
.B \-u8
This option sets the \fButf8\fP resource.
When \fButf8\fP is set, \fI\*n\fP interprets incoming data as UTF-8.
This sets the \fBwideChars\fP resource as a side-effect,
but the UTF-8 mode set by this option prevents it from being turned off.
If you must turn UTF-8 encoding on and off,
use the \fB\-wc\fP option or the corresponding \fBwideChars\fP resource,
rather than the \fB\-u8\fP option.
.IP
This option and the \fButf8\fR resource are overridden by
the \fB\-lc\fP and \fB\-en\fP options and \fBlocale\fR resource.
That is, if \fI\*n\fP has been compiled to support \fIluit\fR,
and the \fBlocale\fP resource is not \*(``false\*(''
this option is ignored.
We recommend using
the \fB\-lc\fR option or the \*(``\fBlocale:\ true\fR\*('' resource
in UTF-8 locales when your operating system supports locale,
or \fB\-en\ UTF-8\fP option or the \*(``\fBlocale:\ UTF-8\fR\*('' resource
when your operating system does not support locale.
.TP 8
.B +u8
This option resets the \fButf8\fP resource.
.TP 8
.B "\-uc"
This option makes the cursor underlined instead of a box.
.TP 8
.B "+uc"
This option makes the cursor a box instead of underlined.
.TP 8
.B "\-ulc"
This option disables the display of characters with underline attribute as
color rather than with underlining.
.TP 8
.B "+ulc"
This option enables the display of characters with underline attribute as
color rather than with underlining.
.TP 8
.B "\-ulit"
This option, corresponding to the \fBitalicULMode\fP resource,
disables the display of characters with underline attribute as
italics rather than with underlining.
.TP 8
.B "+ulit"
This option, corresponding to the \fBitalicULMode\fP resource,
enables the display of characters with underline attribute as
italics rather than with underlining.
.TP 8
.B \-ut
This option indicates that \fI\*n\fP should not write a record into
the system \fIutmp\fP log file.
.TP 8
.B +ut
This option indicates that \fI\*n\fP should write a record into
the system \fIutmp\fP log file.
.TP 8
.B \-vb
This option indicates that a visual bell is preferred over an audible one.
Instead of ringing the terminal bell whenever a Control-G is received, the
window will be flashed.
.TP 8
.B +vb
This option indicates that a visual bell should not be used.
.TP 8
.B \-wc
This option sets the \fBwideChars\fP resource.
.IP
When \fBwideChars\fP is set,
\fI\*n\fP maintains internal structures for 16-bit characters.
If \fI\*n\fP is not started in UTF-8 mode (or if this resource is not set),
initially it maintains those structures to support 8-bit characters.
\fI\*N\fP can later be switched,
using a menu entry or control sequence,
causing it to reallocate those structures to support 16-bit characters.
.IP
The default is \*(``false\*(''.
.TP 8
.B +wc
This option resets the \fBwideChars\fP resource.
.TP 8
.B \-wf
This option indicates that \fI\*n\fP should wait for the window to be mapped
the first time before starting the subprocess so that the initial terminal
size settings and environment variables are correct.
It is the application's
responsibility to catch subsequent terminal size changes.
.TP 8
.B +wf
This option indicates that \fI\*n\fP should not wait before starting the
subprocess.
.TP 8
.B \-ziconbeep \fIpercent\fP
Same as \fBzIconBeep\fP resource.
If percent is non-zero, xterms that produce output while iconified
will cause an XBell sound at the given volume
and have \*(``***\*('' prepended to their icon titles.
Most window managers will detect this change immediately, showing you
which window has the output.
(A similar feature was in x10 \fI\*n\fP.)
.TP 8
.B \-C
This option indicates that this window should receive console output.
This
is not supported on all systems.
To obtain console output, you must be the
owner of the console device, and you must have read and write permission
for it.
If you are running X under \fIxdm\fP on the console screen you may
need to have the session startup and reset programs explicitly change the
ownership of the console device in order to get this option to work.
.TP 8
.B \-S\fIccn\fP
This option allows \fI\*n\fP to be used as an input and
output channel for an existing program and is sometimes used in specialized
applications.
The option value specifies the last few letters of the name of a pseudo-terminal
to use in slave mode, plus the number of the inherited file descriptor.
If the option contains a \*(``/\*('' character, that delimits the characters
used for the pseudo-terminal name from the file descriptor.
Otherwise, exactly two characters are used from the option for
the pseudo-terminal name, the remainder is the file descriptor.
Examples
(the first two are equivalent
since the descriptor follows the last \*(``/\*(''):
.NS 15
\-S/dev/pts/123/45
\-S123/45
\-Sab34
.NE
.IP
Note that \fI\*n\fP does not close any file descriptor
which it did not open for its own use.
It is possible (though probably not portable) to have an application
which passes an open file descriptor down to \fI\*n\fP past the
initialization or the \fB\-S\fP option to a process running in the \fI\*n\fP.
.SS Old Options
.PP
The following command line arguments are provided for compatibility with
older versions.
They may not be supported in the next release as the X
Toolkit provides standard options that accomplish the same task.
.TP 8
.B "%\fIgeom\fP"
This option specifies the preferred size and position of the Tektronix window.
It is shorthand for specifying the \*(``\fBtekGeometry\fP\*('' resource.
.TP 8
.B "#\fIgeom\fP"
This option specifies the preferred position of the icon window.
It is shorthand for specifying the \*(``\fBiconGeometry\fP\*('' resource.
.TP 8
.BI \-T " string"
This option specifies the title for \fI\*n\fP's windows.
It is equivalent to \fB\-title\fP.
.TP 8
.BI \-n " string"
This option specifies the icon name for \fI\*n\fP's windows.
It is shorthand for specifying the \*(``\fBiconName\fP\*('' resource.
Note that this is not the same as the toolkit option \fB\-name\fP.
The default icon name is the application name.
.IP
If no suitable icon is found, \fI\*n\fP provides a compiled-in pixmap.
.IP
X Toolkit sets the \fBWM_ICON_NAME\fP property using this value.
.TP 8
.B \-r
This option indicates that reverse video should be simulated by swapping
the foreground and background colors.
It is equivalent to
\fB\-rv\fP.
.TP 8
.BI \-w " number"
This option specifies the width in pixels of the border surrounding the window.
It is equivalent to \fB\-borderwidth\fP or \fB\-bw\fP.
.
.SS X Toolkit Options
.PP
The following standard X Toolkit command line arguments are commonly used
with \fI\*n\fP:
.TP 8
.B \-bd \fIcolor\fP
This option specifies the color to use for the border of the window.
The corresponding resource name is \fBborderColor\fP.
\fI\*N\fP uses the X Toolkit default, which is \*(``XtDefaultForeground\*(''.
.IP
\fI\*N\fP's VT100 window has two borders:
the \fIinner\fP border \fBinternalBorder\fP
and the \fIouter\fP border \fBborderWidth\fP, managed by the X Toolkit.
.IP
Normally \fI\*n\fP fills the inner border using the VT100 window's
background color.
If the \fBcolorInnerBorder\fP resource is enabled,
then \fI\*n\fP may fill the inner border using the \fBborderColor\fP resource.
.TP 8
.B \-bg \fIcolor\fP
This option specifies the color to use for the background of the window.
The corresponding resource name is \fIbackground\fP.
The default is \*(``XtDefaultBackground\*(''.
.TP 8
.B \-bw \fInumber\fP
This option specifies the width in pixels of the border surrounding the window.
.IP
This appears to be a legacy of older X releases.
It sets the \fBborderWidth\fP resource of the shell widget,
and may provide advice to your window manager to set the thickness of the
window frame.
Most window managers do not use this information.
See the \fB\-b\fP option, which controls the inner border of the \fI\*n\fP
window.
.TP 8
.B \-display \fIdisplay\fP
This option specifies the X server to contact; see X(__miscmansuffix__).
.TP 8
.B \-fg \fIcolor\fP
This option specifies the color to use for displaying text.
The corresponding resource name is \fIforeground\fP.
The default is
\*(``XtDefaultForeground\*(''.
.TP 8
.B \-fn \fIfont\fP
This option specifies the font to be used for displaying normal text.
The corresponding resource name is \fIfont\fP.
The resource value default is \fIfixed\fP.
.TP 8
.B \-font \fIfont\fP
This is the same as \fB\-fn\fP.
.TP 8
.B \-geometry \fIgeometry\fP
This option specifies the preferred size and position of the VT\fIxxx\fP window;
see X(__miscmansuffix__).
.IP
The normal geometry specification can be suffixed with \fB@\fP followed by a
Xinerama screen specification; it can be either \fBg\fP for the global
screen (default), \fBc\fP for the current screen or a screen number.
.TP 8
.B \-iconic
.br
This option indicates that \fI\*n\fP should ask the window manager to
start it as an icon rather than as the normal window.
The corresponding resource name is \fIiconic\fP.
.TP 8
.B \-name \fIname\fP
This option specifies the application name under which resources are to be
obtained, rather than the default executable file name.
\fIName\fP should not contain \*(``.\*('' or \*(``*\*('' characters.
.TP 8
.B \-rv
This option indicates that reverse video should be simulated by swapping
the foreground and background colors.
The corresponding resource name is \fBreverseVideo\fP.
.TP 8
.B +rv
Disable the simulation of reverse video by swapping foreground and background
colors.
.TP 8
.B \-title \fIstring\fP
This option specifies the window title string, which may be displayed by
window managers if the user so chooses.
It is shorthand for specifying the \*(``\fBtitle\fP\*('' resource.
The default title is the command
line specified after the \fB\-e\fP option, if any, otherwise the application
name.
.IP
X Toolkit sets the \fBWM_NAME\fP property using this value.
.TP 8
.B \-xrm \fIresourcestring\fP
This option specifies a resource string to be used.
This is especially
useful for setting resources that do not have separate command line options.
.PP
X Toolkit accepts alternate names for a few of these options, e.g.,
.bP
\*(``\fB\-background\fP\*('' for \*(``\fB\-bg\fP\*(''
.bP
\*(``\fB\-font\fP\*('' for \*(``\fB\-fn\fP\*(''
.bP
\*(``\fB\-foreground\fP\*('' for \*(``\fB\-fg\fP\*(''
.PP
Abbreviated options also are supported, e.g.,
\*(``\fB\-v\fP\*('' for \*(``\fB\-verbose\fP.\*(''
.
.
.SH RESOURCES
\fI\*N\fP understands all of the core X Toolkit resource names and classes.
Application specific resources
(e.g., \*(``\fB__default_class__.\fP\fINAME\fP\*('') follow:
.SS Application Resources
.TP 8
.B "backarrowKeyIsErase\fP (class\fB BackarrowKeyIsErase\fP)"
Tie the VT\fIxxx\fP \fBbackarrowKey\fP and \fBptyInitialErase\fP resources
together by setting the DECBKM state according to whether
the \fIinitial erase\fP character is a backspace (8) or delete (127) character.
A \*(``false\*('' value disables this feature.
The default is \*(``__backarrow_is_erase__\*(''.
.IP
Here are tables showing how the initial settings for
.RS
.bP
.B backarrowKeyIsErase\fP (BKIE),
.bP
.B backarrowKey\fP (BK), and
.bP
.B ptyInitialErase\fP (PIE), along with the
.bP
\fIstty\fP erase character (^H for backspace, ^?\& for delete)
.RE
.IP
will affect DECBKM.
First, \fI\*n\fP obtains the initial \fIerase\fP character:
.RS
.bP
\fI\*n\fP's internal value is ^H
.bP
\fI\*n\fP asks the operating system for the value which \fBstty\fP shows
.bP
the \fBttyModes\fP resource may override \fIerase\fP
.bP
if \fBptyInitialErase\fP is false, \fI\*n\fP will look in the terminal database
.RE
.IP
Summarizing that as a table:
.TS
l l l l
_ _ _ _
l c c c.
\fBPIE\fR	\fBstty\fR	\fBtermcap\fR	\fIerase\fP
false	^H	^H	^H
false	^H	^?	^?
false	^?	^H	^H
false	^?	^?	^?
true	^H	^H	^H
true	^H	^?	^H
true	^?	^H	^?
true	^?	^?	^?
.TE
.IP
Using that \fIerase\fP character, \fI\*n\fP allows further choices:
.RS
.bP
if \fBbackarrowKeyIsErase\fP is true, \fI\*n\fP uses the \fIerase\fP
character for the initial state of \fBDECBKM\fP
.bP
if \fBbackarrowKeyIsErase\fP is false, \fI\*n\fP sets \fBDECBKM\fP
to 2 (internal).
This ties together \fBbackarrowKey\fP
and the control sequence for \fBDECBKM\fP.
.bP
applications can send a control sequence to set/reset \fBDECBKM\fP control set
.bP
the \*(``Backarrow Key (BS/DEL)\*('' menu entry toggles \fBDECBKM\fP
.RE
.IP
Summarizing the initialization details:
.TS
l l l l l
_ _ _ _ _
c l l c c.
\fIerase\fR	\fBBKIE\fR	\fBBK\fR	\fBDECBKM\fP	\fIresult\fP
^?	false	false	2	^H
^?	false	true	2	^?
^?	true	false	0	^?
^?	true	true	1	^?
^H	false	false	2	^H
^H	false	true	2	^?
^H	true	false	0	^H
^H	true	true	1	^H
.TE
.TP 8
.B "buffered\fP (class\fB Buffered\fP)"
Normally \fI\*n\fP is built with double-buffer support.
This resource can be used to turn it on or off.
Setting the resource to
\*(``true\*(''
turns double-buffering on.
The default value is \*(``__double_buffer__\*(''.
.TP 8
.B "bufferedFPS\fP (class\fB BufferedFPS\fP)"
When \fI\*n\fP is built with double-buffer support,
this gives the maximum number of frames/second.
The default is
\*(``40\*(''
and is limited to the range 1 through 100.
.TP 8
.B "fullscreen\fP (class\fB Fullscreen\fP)"
Specifies whether or not \fI\*n\fP should ask the window manager to
use a fullscreen layout on startup.
\fI\*N\fP accepts either a keyword (ignoring case)
or the number shown in parentheses:
.RS
.TP 3
false (0)
Fullscreen layout is not used initially,
but may be later via menu-selection or control sequence.
.TP 3
true (1)
Fullscreen layout is used initially,
but may be disabled later via menu-selection or control sequence.
.TP 3
always (2)
Fullscreen layout is used initially,
and cannot be disabled later via menu-selection or control sequence.
.TP 3
never (3)
Fullscreen layout is not used,
and cannot be enabled later via menu-selection or control sequence.
.RE
.IP
The default is
\*(``false\*(''.
.TP 8
.B "hold\fP (class\fB Hold\fP)"
If true,
\fI\*n\fP will not immediately destroy its window
when the shell command completes.
It will wait until you use the window manager to destroy/kill the window, or
if you use the menu entries that send a signal, e.g., HUP or KILL.
You may scroll back, select text, etc., to perform most graphical operations.
Resizing the display will lose data, however, since this involves interaction
with the shell which is no longer running.
.TP 8
.B "hpFunctionKeys\fP (class\fB HpFunctionKeys\fP)"
Specifies whether or not HP function key escape codes should be generated for
function keys.
The default is
\*(``false\*('', i.e., this feature is disabled.
.IP
The \fBkeyboardType\fP resource is the preferred mechanism
for selecting this mode.
.TP 8
.B "iconGeometry\fP (class\fB IconGeometry\fP)"
Specifies the preferred size and position of the application when iconified.
It is not necessarily obeyed by all window managers.
.TP 8
.B "iconHint\fP (class\fB IconHint\fP)"
Specifies an icon which will be added to the window manager hints.
\fI\*N\fP provides no default value.
.IP
Set this resource to \*(``none\*('' to omit the hint entirely,
using whatever the window manager may decide.
.IP
If the \fBiconHint\fP resource is given (or is set via the \fB\-n\fP option)
\fI\*n\fP searches for a pixmap file with that name,
in the current directory as well as in __pixmapsdir__.
if the resource does not specify an absolute pathname.
In each case, \fI\*n\fP adds \*(``_48x48\*(''
and/or \*(``.xpm\*('' to the filename
after trying without those suffixes.
If it is able to load the file, \fI\*n\fP sets the window manager
hint for the icon-pixmap.
These pixmaps are distributed with \fI\*n\fP, and can optionally be
compiled-in:
.RS
.bP
mini.\*n_16x16,
mini.\*n_32x32,
mini.\*n_48x48
.bP
filled-\*n_16x16,
filled-\*n_32x32,
filled-\*n_48x48
.bP
\*n_16x16,
\*n_32x32,
\*n_48x48
.bP
\*n-color_16x16,
\*n-color_32x32,
\*n-color_48x48
.RE
.IP
In either case, \fI\*n\fP allows for adding a \*(``_48x48\*('' to specify the
largest of the pixmaps as a default.
That is, \*(``mini.\*n\*('' is the same as \*(``mini.\*n_48x48\*(''.
.IP
If no explicit \fBiconHint\fP resource is given
(or if none of the compiled-in names matches),
\fI\*n\fP uses \*(``mini.\*n\*('' (which is always compiled-in).
.IP
The \fBiconHint\fP resource has no effect on \*(``desktop\*('' files,
including \*(``panel\*('' and \*(``menu\*(''.
Those are typically set via a \*(``.desktop\*('' file;
\fI\*n\fP provides samples for itself (and the \fIu\*n\fP script).
The more capable desktop systems allow changing the icon on a per-user basis.
.TP 8
.B "iconName\fP (class\fB IconName\fP)"
Specifies a label for \fI\*n\fP when iconified.
\fI\*N\fP provides no default value;
some window managers may assume the application name, e.g., \*(``\*n\*(''.
.IP
Setting the \fBiconName\fP resource sets the icon label
unless overridden by \fBzIconBeep\fP
or the control sequences which change the window and icon labels.
.TP 8
.B "keyboardType\fP (class\fB KeyboardType\fP)"
Enables one (or none) of the various keyboard-type resources:
\fBhpFunctionKeys\fP,
\fBscoFunctionKeys\fP,
\fBsunFunctionKeys\fP,
\fBtcapFunctionKeys\fP,
\fBoldXtermFKeys\fP and
\fBsunKeyboard\fP.
.IP
The resource's value should be one of the corresponding strings
\*(``hp\*('',
\*(``sco\*('',
\*(``sun\*('',
\*(``tcap\*('',
\*(``legacy\*('' or
\*(``vt220\*('', respectively.
.IP
The individual resources are provided for legacy support;
this resource is simpler to use.
\fI\*N\fP will use only one keyboard-type,
but if multiple resources are set, it warns and uses the last one it checks.
.IP
The default is
\*(``unknown\*('', i.e., none of the associated resources are set
via this resource.
.TP 8
.B "maxBufSize\fP (class\fB MaxBufSize\fP)"
Specify the maximum size of the input buffer.
The default is \*(``32768\*(''.
You cannot set this to a value less than the \fBminBufSize\fR resource.
It will be increased as needed to make that value evenly divide this one.
.IP
On some systems you may want to increase one or both of the
\fBmaxBufSize\fP and
\fBminBufSize\fP resource values to achieve better performance
if the operating system prefers larger buffer sizes.
.TP 8
.B "maximized\fP (class\fB Maximized\fP)"
Specifies whether or not \fI\*n\fP should ask the window manager to
maximize its layout on startup.
The default is
\*(``false\*(''.
.TP 8
.B "menuHeight\fP (class\fB MenuHeight\fP)"
Specifies the height of the toolbar,
which may be increased by the X toolkit layout widget depending upon
the fontsize used.
The default is
\*(``25\*(''.
.TP 8
.B "messages\fP (class\fB Messages\fP)"
Specifies whether write access to the terminal is allowed initially.
See \fBmesg\fP(1).
The default is \*(``true\*(''.
.TP 8
.B "menuLocale\fP (class\fB MenuLocale\fP)"
Specify the locale used for character-set computations when loading
the popup menus.
Use this to improve initialization performance of the Athena popup menus,
which may load unnecessary (and very large) fonts, e.g.,
in a locale having UTF-8 encoding.
The default is \*(``C\*('' (POSIX).
.IP
To use the current locale
(only useful if you have localized the resource settings for the menu entries),
set the resource to an empty string.
.TP 8
.B "minBufSize\fP (class\fB MinBufSize\fP)"
Specify the minimum size of the input buffer, i.e., the amount of data
that \fI\*n\fR requests on each read.
The default is \*(``4096\*(''.
You cannot set this to a value less than 64.
.TP 8
.B "omitTranslation\fP (class\fB OmitTranslation\fP)"
Selectively omit one or more parts of \fI\*n\fP's default translations
at startup.
The resource value is a comma-separated list of keywords,
which may be abbreviated:
.RS
.TP
default
ignore (mouse) button-down events which were not handled by other translations
.TP
fullscreen
assigns a key-binding to the \fBfullscreen()\fP action.
.TP
keypress
assigns keypresses by default to the
\fBinsert-seven-bit()\fP and
\fBinsert-eight-bit()\fP actions.
.TP
paging
assigns key bindings to the
\fBscroll-back()\fP and
\fBscroll-forw()\fP actions.
.TP
popup-menu
assigns mouse-buttons with the \fIcontrol\fP modifier to the popup-menus.
.TP
reset
assigns mouse-button 2
with the \fImeta\fP modifier to the \fBclear-saved-lines\fP action.
.TP
scroll-lock
assigns a key-binding to the \fBscroll-lock()\fP action.
.TP
select
assigns mouse- and keypress-combinations
to actions which manipulate the selection.
.TP
shift-fonts
assigns key-bindings to
\fBlarger-vt-font()\fP and
\fBsmaller-vt-font()\fP actions.
.TP
wheel-mouse
assigns buttons 4 and 5 with different modifiers to the
\fBscroll-back()\fP and
\fBscroll-forw()\fP actions.
.RE
.TP 8
.B ptyHandshake\fP (class\fB PtyHandshake\fP)
If \*(``true\*('', \fI\*n\fP will perform handshaking during initialization
to ensure that the parent and child processes update the \fIutmp\fP
and \fIstty\fP state.
.IP
See also \fBwaitForMap\fP which waits for the pseudo-terminal's notion
of the screen size,
and \fBptySttySize\fP which resets the screen size after other terminal
initialization is complete.
The default is \*(``true\*(''.
.TP 8
.B ptyInitialErase\fP (class\fB PtyInitialErase\fP)
If \*(``true\*('', \fI\*n\fP will use the pseudo-terminal's sense
of the \fIstty\fP erase value.
If \*(``false\*('', \fI\*n\fP will set the \fIstty\fP erase value
to match its own configuration,
using the \fBkb\fP string from the termcap entry as a reference, if available.
.IP
In either case, the result is applied to the TERMCAP variable
which \fI\*n\fP sets, if the system uses TERMCAP.
.IP
See also the \fBttyModes\fP resource, which may override this.
The default is \*(``__initial_erase__\*(''.
.TP 8
.B ptySttySize\fP (class\fB PtySttySize\fP)
If \*(``true\*('', \fI\*n\fP will reset the screen size after
terminal initialization is complete.
This is needed for some systems whose pseudo-terminals cannot
propagate terminal characteristics.
Where it is not needed, it can interfere with other methods for
setting the initial screen size, e.g., via window manager interaction.
.IP
See also \fBwaitForMap\fP which waits for a handshake-message
giving the pseudo-terminal's notion of the screen size.
The default is \*(``false\*('' on Linux and macOS systems,
\*(``true\*('' otherwise.
.TP 8
.B "reportColors\fP (class\fB ReportColors\fP)"
If true, \fI\*n\fP will print to the standard output a summary of
colors as it allocates them.
The default is \*(``false\*(''.
.TP 8
.B "reportFonts\fP (class\fB ReportFonts\fP)"
If true, \fI\*n\fP will print to the standard output a summary of
each font's metrics (size, number of glyphs, etc.), as it loads them.
The default is \*(``false\*(''.
.TP 8
.B "reportIcons\fP (class\fB ReportIcons\fP)"
If true, \fI\*n\fP will print to the standard output a summary of
each pixmap icon as it loads them.
The default is \*(``false\*(''.
.TP 8
.B "sameName\fP (class\fB SameName\fP)"
If the value of this resource is \*(``true\*('', \fI\*n\fP does not send
title and icon name change requests when the request
would have no effect: the name is not changed.
This has the advantage
of preventing flicker and the disadvantage of requiring an extra
round trip to the server to find out the previous value.
In practice
this should never be a problem.
The default is \*(``true\*(''.
.TP 8
.B "scaleHeight\fP (class\fB ScaleHeight\fP)"
Scale line-height values by the resource value,
which is limited to \*(``0.9\*('' to \*(``1.5\*(''.
The default value is \*(``1.0\*('',
.IP
While this resource applies to either bitmap or TrueType fonts,
its main purpose is to
help work around incompatible changes in the Xft library's font metrics.
\fI\*N\fP checks the font metrics to find what the library claims are
the bounding boxes for each glyph (character).
However, some of Xft's features (such as the autohinter) can cause the
glyphs to be scaled larger than the bounding boxes, and be partly overwritten
by the next row.
.IP
See \fBuseClipping\fP for a related resource.
.TP 8
.B "scoFunctionKeys\fP (class\fB ScoFunctionKeys\fP)"
Specifies whether or not SCO function key escape codes should be generated for
function keys.
The default is
\*(``false\*('', i.e., this feature is disabled.
.IP
The \fBkeyboardType\fP resource is the preferred mechanism
for selecting this mode.
.TP 8
.B "sessionMgt\fP (class\fB SessionMgt\fP)"
If the value of this resource is \*(``true\*('',
\fI\*n\fP sets up session manager callbacks
for \fBXtNdieCallback\fR and \fBXtNsaveCallback\fR.
The default is \*(``true\*(''.
.TP 8
.B "sunFunctionKeys\fP (class\fB SunFunctionKeys\fP)"
Specifies whether or not Sun function key escape codes should be generated for
function keys.
The default is
\*(``false\*('', i.e., this feature is disabled.
.IP
The \fBkeyboardType\fP resource is the preferred mechanism
for selecting this mode.
.TP 8
.B "sunKeyboard\fP (class\fB SunKeyboard\fP)"
\fI\*N\fP translates certain key symbols based on its assumptions about
your keyboard.
This resource
specifies whether or not Sun/PC keyboard layout (i.e., the PC keyboard's
numeric keypad together with 12 function keys) should be assumed rather
than DEC VT220.
This causes the keypad \*(``+\*('' to be mapped to \*(``,\*(''.
and
CTRL F1-F10 to F11-F20, depending on the setting of the \fBctrlFKeys\fP
resource, so \fI\*n\fP emulates a DEC VT220 more accurately.
Otherwise (the default, with \fBsunKeyboard\fP set to \*(``false\*(''),
\fI\*n\fP uses PC-style bindings for the function keys and keypad.
.IP
PC-style bindings
use the Shift, Alt, Control and Meta keys as modifiers for function-keys
and keypad
(see \fIXterm Control Sequences\fP for details).
The PC-style bindings are analogous to PCTerm, but not the same thing.
Normally these bindings do not conflict with the use of the Meta key
as described for the \fBeightBitInput\fP resource.
If they do, note that the PC-style bindings are evaluated first.
.IP
See also the \fBkeyboardType\fP resource.
.TP 8
.B "tcapFunctionKeys\fP (class\fB TcapFunctionKeys\fP)"
Specifies whether or not function key escape codes read from the
termcap/terminfo entry corresponding to the \fBTERM\fP environment variable
should be generated for
function keys instead of those configured
using \fBsunKeyboard\fP and \fBkeyboardType\fP.
The default is
\*(``false\*('', i.e., this feature is disabled.
.IP
The \fBkeyboardType\fP resource is the preferred mechanism
for selecting this mode.
.TP 8
.B "termName\fP (class\fB TermName\fP)"
Specifies the terminal type name to be set in the TERM environment variable.
.TP 8
.B "title\fP (class\fB Title\fP)"
Specifies a string that may be used by the window manager when displaying
this application.
.TP 8
.B "toolBar\fP (class\fB ToolBar\fP)"
Specifies whether or not the toolbar should be displayed.
The default is
\*(``true\*(''.
.TP 8
.B "ttyModes\fP (class\fB TtyModes\fP)"
Specifies a string containing terminal setting keywords.
Except where noted, they may be bound to \fIcharacters\fP.
Other keywords set \fImodes\fP.
Not all keywords are supported on a given system.
Allowable keywords include:
.TS
l l l
_ _ _
l l l.
\fBKeyword\fR	\fBPOSIX?\fR	\fBNotes\fR
brk	no	T{
\fICHAR\fP may send an \*(``interrupt\*('' signal,
as well as ending the input-line.
T}
dsusp	no	T{
\fICHAR\fP will send a terminal \*(``stop\*('' signal after input is flushed.
T}
eof	yes	T{
\fICHAR\fP will terminate input (i.e., an end of file).
T}
eol	yes	\fICHAR\fP will end the line.
eol2	no	alternate \fICHAR\fP for ending the line.
erase	yes	\fICHAR\fP will erase the last character typed.
erase2	no	T{
alternate \fICHAR\fP for erasing the last input-character.
T}
flush	no	T{
\fICHAR\fP will cause output to be discarded until another \fBflush\fP character is typed.
T}
intr	yes	\fICHAR\fP will send an \*(``interrupt\*('' signal.
kill	yes	\fICHAR\fP will erase the current line.
lnext	no	\fICHAR\fP will enter the next character quoted.
quit	yes	\fPCHAR\fP will send a \*(``quit\*('' signal.
rprnt	no	\fICHAR\fP will redraw the current line.
start	yes	T{
\fICHAR\fP will \fIrestart\fP the output after stopping it.
T}
status	no	T{
\fICHAR\fP will cause a system-generated status line to be printed.
T}
stop	yes	\fICHAR\fP will stop the output.
susp	yes	\fICHAR\fP will send a terminal \*(``stop\*('' signal
swtch	no	\fICHAR\fP will switch to a different shell layer.
tabs	yes	\fIMode\fP disables tab-expansion.
-tabs	yes	\fIMode\fP enables tab-expansion.
weras	no	\fICHAR\fP will erase the last word typed.
.TE
.IP
Control characters may be specified as ^char (e.g., ^c or ^u)
and \fB^?\fP may be used to indicate delete (127).
Use \fB^\-\fP to denote \fIundef\fP.
Use \fB\\034\fP to represent \fB^\\\fP, since a literal backslash in
an X resource escapes the next character.
.IP
This is very useful for overriding
the default terminal settings without having to run \fIstty\fP every time
an \fI\*n\fP is started.
Note, however, that the \fIstty\fP program on a given host may use different
keywords; \fI\*n\fR's table is built in.
The \fIPOSIX\fP column in the table indicates which keywords
are supported by a standard \fIstty\fP program.
.IP
If the \fBttyModes\fP resource specifies a value for \fBerase\fP,
that overrides the \fBptyInitialErase\fP resource setting,
i.e., \fI\*n\fP initializes the terminal to match that value.
.TP 8
.B "useInsertMode\fP (class\fB UseInsertMode\fP)"
Force use of insert mode by adding appropriate entries to the TERMCAP
environment variable.
This is useful if the system termcap is broken.
(This resource is ignored on most systems, because TERMCAP is not used).
The default is \*(``false\*(''.
.TP 8
.B "utmpDisplayId\fP (class\fB UtmpDisplayId\fP)"
Specifies whether or not \fI\*n\fP should try to record the display
identifier (display number and screen number) as well as the hostname in
the system \fIutmp\fP log file.
The default is \*(``true\*(''.
.TP 8
.B "utmpInhibit\fP (class\fB UtmpInhibit\fP)"
Specifies whether or not \fI\*n\fP should try to record the user's terminal
in
the system \fIutmp\fP log file.
If true, \fI\*n\fP will not try.
The default is \*(``false\*(''.
.TP 8
.B "validShells\fP (class\fB ValidShells\fP)"
Augment (add to) the system's \fI/etc/shells\fP,
when determining whether to set the \*(``SHELL\*('' environment
variable when running a given program.
.IP
The resource value is a list of lines (separated by newlines).
Each line holds one pathname.
\fI\*N\fP ignores any line beginning with \*(``#\*(''
after trimming leading/trailing whitespace from each line.
.IP
The default is an empty string.
.TP 8
.B "waitForMap\fP (class\fB WaitForMap\fP)"
Specifies whether or not \fI\*n\fP should wait for the initial window map
before starting the subprocess.
This is part of the \fBptyHandshake\fP logic.
When \fI\*n\fP is directed to wait in this fashion,
it passes the terminal size from the display end of the pseudo-terminal
to the terminal I/O connection, e.g.,
using the size according to the window manager.
Otherwise, it uses the size as given in resource values or command-line
option \fB\-geometry\fP.
The default is \*(``false\*(''.
.TP 8
.B "zIconBeep\fP (class\fB ZIconBeep\fP)"
Same as \-ziconbeep command line argument.
If the value of this resource is non-zero, xterms that produce output
while iconified will cause an XBell sound at the given volume
and have \*(``***\ \*('' prepended to their icon titles.
Most window managers will detect this change immediately, showing you
which window has the output.
(A similar feature was in x10 \fI\*n\fR.)
The default is \*(``false\*(''.
.TP 8
.B "zIconTitleFormat\fP (class\fB ZIconTitleFormat\fP)"
Allow customization of the string used in the \fBzIconBeep\fP feature.
The default value is \*(``***\ %s\*(''.
.IP
If the resource value contains a \*(``%s\*('',
then \fI\*n\fP inserts the icon title at that point rather
than prepending the string to the icon title.
(Only the first \*(``%s\*('' is used).
.\"
.SS VT100 Widget Resources
.PP
The following resources are specified as part
of the \fIvt100\fP widget (class \fIVT100\fP).
They are specified by patterns such as
\*(``\fB__default_class__.vt100.\fP\fINAME\fP\*(''.
.PP
If your \fI\*n\fP is configured to support the \*(``toolbar\*('', then those
patterns need an extra level for the form-widget which holds the
toolbar and vt100 widget.
A wildcard between the top-level \*(``__default_class__\*(''
and the \*(``vt100\*('' widget makes the resource settings work for either,
e.g., \*(``\fB__default_class__*vt100.\fP\fINAME\fP\*(''.
.TP 8
.B "activeIcon\fP (class\fB ActiveIcon\fP)"
Specifies whether or not active icon windows are to be used when the
\fI\*n\fP window is iconified, if this feature is compiled into \fI\*n\fR.
The active icon is a miniature representation of the content of the
window and will update as the content changes.
Not all window managers necessarily support application icon windows.
Some window managers
will allow you to enter keystrokes into the active icon window.
The default is \*(``default\*(''.
.IP
\fI\*N\fP accepts either a keyword (ignoring case)
or the number shown in parentheses:
.RS
.TP
false (0)
No active icon is shown.
.TP
true (1)
The active icon is shown.
If you are using \fItwm\fP, use this setting to enable active-icons.
.TP
default (2)
\fI\*N\fP checks at startup, and shows an active icon only for window
managers which it can identify and which are known to support the feature.
These are \fIfvwm\fP (full support), and \fIwindow maker\fP (limited).
A few other windows managers (such as \fItwm\fP and \fIctwm\fP)
support active icons,
but do not support the extensions which allow \fI\*n\fP
to identify the window manager.
.RE
.TP 8
.B "allowBoldFonts\fP (class\fB AllowBoldFonts\fP)"
When set to \*(``false\*('', \fI\*n\fP will not use bold fonts.
This overrides both the \fBalwaysBoldMode\fP and the \fBboldMode\fP resources.
.TP 8
.B "allowC1Printable\fP (class\fB AllowC1Printable\fP)"
If true, overrides the mapping of C1 controls
(codes 128\(en159) to make them be treated
as if they were printable characters.
Although this corresponds to no particular standard,
some users insist it is a VT100.
The default is \*(``false\*(''.
.TP
.B "allowColorOps\fP (class\fB AllowColorOps\fP)"
Specifies whether control sequences that
set/query the dynamic colors should be allowed.
ANSI colors are unaffected by this resource setting.
The default is \*(``true\*(''.
.TP
.B "allowFontOps\fP (class\fB AllowFontOps\fP)"
Specifies whether control sequences that set/query the font should be allowed.
The default is \*(``true\*(''.
.TP
.B "allowMouseOps\fP (class\fB AllowMouseOps\fP)"
Specifies whether control sequences that enable \fI\*n\fP to send
escape sequences to the host on mouse-clicks and movement.
The default is \*(``true\*(''.
.TP 8
.B "allowPasteControls\fP (class\fB AllowPasteControls\fP)"
If true, allow control characters such as BEL and CAN to be pasted.
Formatting characters (tab, newline) are always allowed.
Other C0 control characters are suppressed unless this resource is enabled.
The exact set of control characters (C0 and C1)
depends upon whether UTF-8 encoding is used,
as well as the \fBallowC1Printable\fP resource.
The default is \*(``false\*(''.
.TP 8
.B "allowScrollLock\fP (class\fB AllowScrollLock\fP)"
Specifies whether control sequences that set/query
the Scroll Lock key should be allowed,
as well as whether the Scroll Lock key responds to user's keypress.
The default is \*(``false\*(''.
.IP
When this feature is enabled, \fI\*n\fP will sense the state of the
Scroll Lock key each time it acquires focus.
Pressing the Scroll Lock key toggles \fI\*n\fP's internal state,
as well as toggling the associated LED.
While the Scroll Lock is active, \fI\*n\fP attempts to keep a viewport on the
same set of lines.
If the current viewport is scrolled past the limit set by the
\fBsaveLines\fP resource, then Scroll Lock has no further effect.
.IP
The reason for setting the default to \*(``false\*('' is to avoid
user surprise.
This key is generally unused in keyboard configurations,
and has not acquired a standard meaning even when it is used in that manner.
Consequently, users have assigned it for ad hoc purposes.
.TP 8
.B "allowSendEvents\fP (class\fB AllowSendEvents\fP)"
Specifies whether or not synthetic key and button events (generated using
the X protocol SendEvent request) should be interpreted or discarded.
The default is \*(``false\*('' meaning they are discarded.
Note that allowing such events would create a very large security hole,
therefore enabling this resource forcefully disables
the \fBallow\fP\fIXXX\fP\fBOps\fR resources.
The default is \*(``false\*(''.
.TP
.B "allowTcapOps\fP (class\fB AllowTcapOps\fP)"
Specifies whether control sequences that query the terminal's
notion of its function-key strings, as termcap or terminfo capabilities
should be allowed.
The default is \*(``true\*(''.
.IP
A few programs, e.g., \fIvim\fP, use this feature to get an accurate
description of the terminal's capabilities,
independent of the termcap/terminfo setting:
.RS
.bP
\fI\*N\fP can tell the querying program how many colors it supports.
This is a constant, depending on how it is compiled, typically 16.
It does not change if you alter resource settings,
e.g., the \fBboldColors\fP resource.
.bP
\fI\*N\fP can tell the querying program what strings are sent by modified
(shift-, control-, alt-) function- and keypad-keys.
Reporting control- and alt-modifiers is a feature that relies on the
\fIncurses\fP extended naming.
.RE
.TP
.B "allowTitleOps\fP (class\fB AllowTitleOps\fP)"
Specifies whether control sequences that modify the window title or icon name
should be allowed.
The default is \*(``true\*(''.
.TP
.B "allowWindowOps\fP (class\fB AllowWindowOps\fP)"
Specifies whether extended window control sequences
(as used in \fIdtterm\fP)
should be allowed.
These include several control sequences which manipulate the window size or
position, as well as reporting these values and the title or icon name.
Each of these can be abused in a script;
curiously enough most terminal emulators that implement these
restrict only a small part of the repertoire.
For fine-tuning, see \fBdisallowedWindowOps\fP.
The default is \*(``false\*(''.
.TP 8
.B "altIsNotMeta\fP (class\fB AltIsNotMeta\fP)"
If \*(``true\*('', treat the Alt-key as if it were the Meta-key.
Your keyboard may happen to be configured so they are the same.
But if they are not, this allows you to use the same prefix- and shifting
operations with the Alt-key as with the Meta-key.
See \fBaltSendsEscape\fP and \fBmetaSendsEscape\fP.
The default is \*(``false\*(''.
.TP 8
.B "altSendsEscape\fP (class\fB AltSendsEscape\fP)"
This is an additional keyboard operation that may be processed
after the logic for \fBmetaSendsEscape\fP.
It is only available if the \fBaltIsNotMeta\fP resource is set.
.RS
.bP
If \*(``true\*('', Alt characters
(a character combined with the modifier associated with left/right Alt-keys)
are converted into a two-character
sequence with the character itself preceded by ESC.
This applies as well to function key control sequences, unless \fI\*n\fP
sees that \fBAlt\fP is used in your key translations.
.bP
If \*(``false\*('', Alt characters input from the keyboard cause a shift to
8-bit characters (just like \fBmetaSendsEscape\fP).
By combining the Alt- and Meta-modifiers, you can create corresponding
combinations of ESC-prefix and 8-bit characters.
.RE
.IP
The default is \*(``__alt_sends_esc__\*(''.
\fI\*N\fP provides a menu option for toggling this resource.
.TP 8
.B "alternateScroll\fP (class\fB ScrollCond\fP)"
If \*(``true\*('',
the \fBscroll-back\fP and \fBscroll-forw\fP actions
send cursor\-up and \-down keys
when \fI\*n\fP is displaying the alternate screen.
The default is \*(``false\*(''.
.IP
The \fBalternateScroll\fP state can also be set using a control sequence.
.TP 8
.B "alwaysBoldMode\fP (class\fB AlwaysBoldMode\fP)"
Specifies whether \fI\*n\fP should check if the normal and bold
fonts are distinct before deciding whether to use overstriking to
simulate bold fonts.
If this resource is true,
\fI\*n\fP does not make the check for
distinct fonts when deciding how to handle the \fBboldMode\fP resource.
The default is \*(``false\*(''.
.ne 9
.TS
l l l l
_ _ _ _
l l l l.
\fIboldMode\fR	\fIalwaysBoldMode\fR	\fIComparison\fR	\fIAction\fP
false	false	ignored	use font
false	true	ignored	use font
true	false	same	overstrike
true	false	different	use font
true	true	ignored	overstrike
.TE
.RS
.LP
This resource is used only for bitmap fonts:
.bP
When using bitmap fonts, it is possible that the font server will
approximate the bold font by rescaling it from
a different font size than expected.
The \fBalwaysBoldMode\fP resource
allows the user to override the (sometimes poor)
resulting bold font with overstriking (which is at least consistent).
.bP
The problem does not occur with TrueType fonts (though there can be
other unnecessary issues such as different coverage of the normal
and bold fonts).
.RE
.IP
As an alternative, setting the \fBallowBoldFonts\fP resource to false
overrides both the \fBalwaysBoldMode\fP and the \fBboldMode\fP resources.
.TP 8
.B "alwaysHighlight\fP (class\fB AlwaysHighlight\fP)"
Specifies whether or not \fI\*n\fP should always display a highlighted
text cursor.
By default (if this resource is false),
a hollow text cursor is displayed whenever the
pointer moves out of the window or the window loses the input focus.
The default is \*(``false\*(''.
.TP 8
.B "alwaysUseMods\fP (class\fB AlwaysUseMods\fP)"
Override the \fBnumLock\fP resource, telling \fI\*n\fR to use the Alt and Meta
modifiers to construct parameters for function key sequences even if
those modifiers appear in the translations resource.
Normally \fI\*n\fP checks if Alt or Meta is used in a translation that
would conflict with function key modifiers, and will ignore these modifiers
in that special case.
The default is \*(``false\*(''.
.TP 8
.B "answerbackString\fP (class\fB AnswerbackString\fP)"
Specifies the string that \fI\*n\fR sends in response to an ENQ (control/E)
character from the host.
The default is a blank string, i.e., \*(``\*(''.
A hardware VT100 implements this feature as a setup option.
.TP 8
.B "appcursorDefault\fP (class\fB AppcursorDefault\fP)"
If \*(``true\*('', the cursor keys are initially in application mode.
This is the same as the VT102 private DECCKM mode,
The default is \*(``false\*(''.
.TP 8
.B "appkeypadDefault\fP (class\fB AppkeypadDefault\fP)"
If \*(``true\*('', the keypad keys are initially in application mode.
The default is \*(``false\*(''.
.TP 8
.B "assumeAllChars\fP (class\fB AssumeAllChars\fP)"
If \*(``true\*('', this enables a special case in bitmap fonts to
allow the font server to choose how to display missing glyphs.
The default is \*(``true\*(''.
.IP
The reason for this resource is to help with
certain quasi-automatically generated fonts
(such as the ISO-10646-1 encoding of Terminus)
which have incorrect font-metrics.
.TP 8
.B "autoWrap\fP (class\fB AutoWrap\fP)"
Specifies whether or not auto-wraparound should be enabled.
This is the same as the VT102 DECAWM.
The
default is \*(``true\*(''.
.TP 8
.B "awaitInput\fP (class\fB AwaitInput\fP)"
Specifies whether or not \fI\*n\fR uses a 50 millisecond timeout to
await input (i.e., to support the Xaw3d arrow scrollbar).
The default is \*(``false\*(''.
.TP 8
.B "backarrowKey\fP (class\fB BackarrowKey\fP)"
Specifies whether the backarrow key transmits
a backspace (8)
or delete (127) character.
This corresponds to the DECBKM control sequence.
A \*(``true\*('' value specifies backspace.
The default is \*(``__backarrow_is_bs__\*(''.
Pressing the control key toggles this behavior.
.TP 8
.B "background\fP (class\fB Background\fP)"
Specifies the color to use for the background of the window.
The default is
\*(``XtDefaultBackground\*(''.
.TP 8
.B "bellIsUrgent\fP (class\fB BellIsUrgent\fP)"
Specifies whether to set the Urgency hint for the window manager
when making a bell sound.
The default is \*(``false\*(''.
.TP 8
.B "bellOnReset\fP (class\fB BellOnReset\fP)"
Specifies whether to sound a bell when doing a hard reset.
The default is \*(``true\*(''.
.TP 8
.B "bellSuppressTime\fP (class\fB BellSuppressTime\fP)"
Number of milliseconds after a bell command is sent during which additional
bells will be suppressed.
Default is 200.
If set non-zero,
additional bells
will also be suppressed until the server reports that processing of
the first bell has been completed; this feature is most useful with
the visible bell.
.TP 8
.B "boldColors\fP (class\fB ColorMode\fP)"
Specifies whether to combine bold attribute with colors like the IBM PC,
i.e., map colors 0 through 7 to colors 8 through 15.
These normally are the brighter versions of the first 8 colors, hence bold.
The default is \*(``true\*(''.
.TP 8
.B "boldFont\fP (class\fB BoldFont\fP)"
Specifies the name of the bold font to use instead of overstriking.
There is no default for this resource.
.IP
This font must be the same height and width as the normal font,
otherwise it is ignored.
If only one of the normal or bold fonts is specified, it will be used as the
normal font and the bold font will be produced by overstriking this font.
.IP
See also the discussion of \fBboldMode\fP and \fBalwaysBoldMode\fP resources.
.TP 8
.B "boldMode\fP (class\fB BoldMode\fP)"
This specifies whether or not text with the bold attribute should be
overstruck to simulate bold fonts if the resolved bold font is the
same as the normal font.
It may be desirable to disable bold fonts when color is being
used for the bold attribute.
.IP
Note that \fI\*n\fP has one bold font which you may set explicitly.
\fI\*N\fP attempts to derive a bold font for the other font selections
(\fBfont1\fP through \fBfont6\fP).
If it cannot find a bold font, it will use the normal font.
In each case (whether the explicit resource or the derived font),
if the normal and bold fonts are distinct, this resource has no effect.
The default is \*(``true\*(''.
.IP
See the \fBalwaysBoldMode\fP resource which can modify the behavior
of this resource.
.IP
Although \fI\*n\fP attempts to derive a bold font for other font selections,
the font server may not cooperate.
Since X11R6, bitmap fonts have been scaled.
The font server claims to provide the bold font that \fI\*n\fP requests,
but the result is not always readable.
XFree86 introduced a feature which can be used to suppress the scaling.
In the X server's configuration file (e.g., \*(``/etc/X11/XFree86\*(''
or \*(``/etc/X11/xorg.conf\*(''), you
can add \*(``:unscaled\*('' to the end of the directory specification for the
\*(``misc\*('' fonts,
which comprise the fixed-pitch fonts that are used by \fI\*n\fP.
For example
.NS
FontPath	"/usr/lib/X11/fonts/misc/"
.NE
.IP
would become
.NS
FontPath	"/usr/lib/X11/fonts/misc/:unscaled"
.NE
.IP
Depending on your configuration, the font server may have its own configuration
file.
The same \*(``:unscaled\*('' can be added to its configuration file at the
end of the directory specification for \*(``misc\*(''.
.IP
The bitmap scaling feature is also used by \fI\*n\fP to implement
VT102 double-width and double-height characters.
.TP 8
.B "brokenLinuxOSC\fP (class\fB BrokenLinuxOSC\fP)"
If true, \fI\*n\fP applies a workaround to ignore malformed control
sequences that a Linux script might send.
Compare the palette control sequences documented in \fIconsole_codes\fR
with ECMA-48.
The default is \*(``true\*(''.
.TP 8
.B "brokenSelections\fP (class\fB BrokenSelections\fP)"
If true, \fI\*n\fP in 8-bit mode will interpret \fBSTRING\fP
selections as carrying text in the current locale's encoding.
Normally \fBSTRING\fP selections carry ISO-8859-1 encoded text.
Setting this resource to
\*(``true\*('' violates the ICCCM; it may, however, be useful for interacting
with some broken X clients.
The default is \*(``false\*(''.
.TP 8
.B "brokenStringTerm\fP (class\fB BrokenStringTerm\fP)"
provides a work-around for some ISDN routers which start an application
control string without completing it.
Set this to \*(``true\*('' if \fI\*n\fP appears to freeze when connecting.
The default is \*(``false\*(''.
.IP
\fI\*N\fP's state parser recognizes
several types of control strings which can contain text, e.g.,
.sp
.RS
\fBAPC\fP (Application Program Command),
.br
\fBDCS\fP (Device Control String),
.br
\fBOSC\fP (Operating System Command),
.br
\fBPM\fP (Privacy Message), and
.br
\fBSOS\fP (Start of String),
.RE
.IP
Each should end with a string-terminator (a special character which
cannot appear in these strings).
Ordinary control characters found within the string are not ignored;
they are processed without interfering with the process of accumulating
the control string's content.
\fI\*N\fP recognizes these controls in all modes,
although some of the functions may be suppressed after parsing the control.
.IP
When enabled, this feature allows the user to exit from an unterminated
control string when any of these ordinary control characters are found:
.sp
.RS
control/D (used as an end of file in many shells),
.br
control/H (backspace),
.br
control/I (tab-feed),
.br
control/J (line feed aka newline),
.br
control/K (vertical tab),
.br
control/L (form feed),
.br
control/M (carriage return),
.br
control/N (shift-out),
.br
control/O (shift-in),
.br
control/Q (XOFF),
.br
control/X (cancel)
.RE
.TP 8
.B "c132\fP (class\fB C132\fP)"
Specifies whether or not the VT102 DECCOLM escape sequence,
used to switch between 80 and 132 columns, should be honored.
The default is \*(``false\*(''.
.TP 8
.B "cacheDoublesize\fP (class\fB CacheDoublesize\fP)"
Tells whether to cache double-sized fonts by \fI\*n\fR.
Set this to zero to disable double-sized fonts altogether.
.TP 8
.B "cdXtraScroll\fP (class\fB CdXtraScroll\fP)"
Specifies whether \fI\*n\fP should scroll to a new page when clearing
the whole screen.
Like \fBtiXtraScroll\fP,
the intent of this option is to provide a picture of the full-screen
application's display on the scrollback before wiping out the text.
The default for this resource is \*(``false\*(''.
.TP 8
.B "charClass\fP (class\fB CharClass\fP)"
Specifies comma-separated lists of character class bindings of the form
.NS
\fIlow\fP[\-\fIhigh]\fP[:\fIvalue\fP].
.NE
.IP
These are used in determining which
sets of characters should be treated the same when doing cut and paste.
See the \fBCHARACTER CLASSES\fP section.
.TP 8
.B "checksumExtension\fP (class\fB ChecksumExtension\fP)"
DEC VT420 and up support a control sequence \fBDECRQCRA\fP which reports
the checksum of the characters in a rectangle.
\fI\*N\fP supports this, with extensions that can be configured with
bits of the \fBchecksumExtension\fP:
.RS
.TP 5
0
do not negate the result.
.TP 5
1
do not report the VT100 video attributes.
.TP 5
2
do not omit checksum for blanks.
.TP 5
3
omit checksum for cells not explicitly initialized.
.TP 5
4
do not mask cell value to 8 bits or ignore combining characters.
.TP 5
5
do not mask cell value to 7 bits.
.RE
.IP
With the default value (0),
\fI\*n\fP matches the behavior of DEC's terminals.
To use all extensions, set all bits, \*(``-1\*('' for example.
.TP 8
.B "cjkWidth\fP (class\fB CjkWidth\fP)"
Specifies whether \fI\*n\fP should follow
the traditional East Asian width convention.
When turned on, characters with East Asian Ambiguous (A) category in UTR
11 have a column width of 2.
You may have to set this option to \*(``true\*(''
if you have some old East Asian terminal based programs that assume that
line-drawing characters have a column width of 2.
If this resource is false, the \fBmkWidth\fP resource controls the
choice between the system's \fBwcwidth\fP and \fI\*n\fP's built-in tables.
The default is \*(``false\*(''.
.TP 8
.B "color0\fP (class\fB Color0\fP)"
.TP 8
.B "color1\fP (class\fB Color1\fP)"
.TP 8
.B "color2\fP (class\fB Color2\fP)"
.TP 8
.B "color3\fP (class\fB Color3\fP)"
.TP 8
.B "color4\fP (class\fB Color4\fP)"
.TP 8
.B "color5\fP (class\fB Color5\fP)"
.TP 8
.B "color6\fP (class\fB Color6\fP)"
.TP 8
.B "color7\fP (class\fB Color7\fP)"
These specify the colors for the ISO-6429 extension.
The defaults are,
respectively,
black,
red3,
green3,
yellow3,
a customizable dark blue,
magenta3,
cyan3,
and
gray90.
The default shades of color are chosen to allow the colors 8\(en15
to be used as brighter versions.
.TP 8
.B "color8\fP (class\fB Color8\fP)"
.TP 8
.B "color9\fP (class\fB Color9\fP)"
.TP 8
.B "color10\fP (class\fB Color10\fP)"
.TP 8
.B "color11\fP (class\fB Color11\fP)"
.TP 8
.B "color12\fP (class\fB Color12\fP)"
.TP 8
.B "color13\fP (class\fB Color13\fP)"
.TP 8
.B "color14\fP (class\fB Color14\fP)"
.TP 8
.B "color15\fP (class\fB Color15\fP)"
These specify the colors for the ISO-6429 extension if the bold attribute
is also enabled.
The default resource values are respectively,
gray50,
red,
green,
yellow,
a customized light blue,
magenta,
cyan,
and
white.
.TP 8
.B "color16\fP (class\fB Color16\fP)"
.TP 8
through
.TP 8
.B "color255\fP (class\fB Color255\fP)"
These specify the colors for the 256-color extension.
The default resource values
are for
.RS
.bP
colors 16 through 231 to make a 6x6x6 color cube, and
.bP
colors 232 through 255 to make a grayscale ramp.
.RE
.IP
Resources past \fBcolor15\fP are available as a compile-time option.
Due to a hardcoded limit in the X libraries on the total number of
resources (to 400), the resources for 256-colors
are omitted when wide-character support and \fIluit\fP are enabled.
Besides inconsistent behavior if only part of the resources were allowed,
determining the exact cutoff is difficult, and the X libraries tend
to crash if the number of resources exceeds the limit.
The color palette is still initialized to the same default values,
and can be modified via control sequences.
.IP
On the other hand, the resource limit does permit including the entire
range for 88-colors.
.TP 8
.B "colorAttrMode\fP (class\fB ColorAttrMode\fP)"
Specifies whether \fBcolorBD\fP, \fBcolorBL\fP, \fBcolorRV\fP, and
\fBcolorUL\fP should override ANSI colors.
If not, these are displayed only when no ANSI colors
have been set for the corresponding position.
The default is \*(``false\*(''.
.TP 8
.B "colorBD\fP (class\fB ColorBD\fP)"
This specifies the color to use to display bold characters if
the \*(``colorBDMode\*('' resource is enabled.
The default is \*(``XtDefaultForeground\*(''.
.IP
See also the \fBveryBoldColors\fP resource which allows combining
bold and color.
.TP 8
.B "colorBDMode\fP (class\fB ColorAttrMode\fP)"
Specifies whether characters with the bold attribute should be displayed in
color or as bold characters.
Note that setting \fBcolorMode\fR off disables
all colors, including bold.
The default is \*(``false\*(''.
.TP 8
.B "colorBL\fP (class\fB ColorBL\fP)"
This specifies the color to use to display blink characters if
the \*(``colorBLMode\*('' resource is enabled.
The default is \*(``XtDefaultForeground\*(''.
.IP
See also the \fBveryBoldColors\fP resource which allows combining
underline and color.
.TP 8
.B "colorBLMode\fP (class\fB ColorAttrMode\fP)"
Specifies whether characters with the blink attribute should be displayed in
color.
Note that setting \fBcolorMode\fR off disables all colors, including this.
The default is \*(``false\*(''.
.TP 8
.B "colorIT\fP (class\fB ColorIT\fP)"
This specifies the color to use to display italic characters if
the \*(``colorITMode\*('' resource is enabled.
The default is \*(``XtDefaultForeground\*(''.
.IP
See also the \fBveryBoldColors\fP resource which allows combining
attributes and color.
.TP 8
.B "colorITMode\fP (class\fB ColorAttrMode\fP)"
Specifies whether characters with the italic attribute should be displayed in
color or as italic characters.
The default is \*(``false\*(''.
.IP
Note that:
.RS
.bP
Setting \fBcolorMode\fR off disables all colors, including italic.
.bP
The \fBitalicULMode\fP resource overrides \fBcolorITMode\fP.
.RE
.TP 8
.B "colorInnerBorder\fP (class\fB ColorInnerBorder\fP)"
Normally, \fI\*n\fP fills the VT100 window's inner border
using the background color.
.IP
If the \fBcolorInnerBorder\fP resource is enabled,
at startup \fI\*n\fP will compare the \fBborderColor\fP and the
window's background color.
If those are different, \fI\*n\fP will use the \fBborderColor\fP 
resource to fill the inner border.
Otherwise, it will use the window's background color.
.IP
The default is \*(``false\*(''.
.TP 8
.B "colorMode\fP (class\fB ColorMode\fP)"
Specifies whether or not recognition of ANSI (ISO-6429)
color change escape sequences should be enabled.
The default is \*(``true\*(''.
.TP 8
.B "colorRV\fP (class\fB ColorRV\fP)"
This specifies the color to use to display reverse characters if
the \*(``colorRVMode\*('' resource is enabled.
The default is \*(``XtDefaultForeground\*(''.
.IP
See also the \fBveryBoldColors\fP resource which allows combining
reverse and color.
.TP 8
.B "colorRVMode\fP (class\fB ColorAttrMode\fP)"
Specifies whether characters with the reverse attribute should be displayed in
color.
Note that setting \fBcolorMode\fR off disables all colors, including this.
The default is \*(``false\*(''.
.TP 8
.B "colorUL\fP (class\fB ColorUL\fP)"
This specifies the color to use to display underlined characters if
the \*(``colorULMode\*('' resource is enabled.
The default is \*(``XtDefaultForeground\*(''.
.IP
See also the \fBveryBoldColors\fP resource which allows combining
underline and color.
.TP 8
.B "colorULMode\fP (class\fB ColorAttrMode\fP)"
Specifies whether characters with the underline attribute should be displayed
in color or as underlined characters.
Note that setting \fBcolorMode\fR off
disables all colors, including underlining.
The default is \*(``false\*(''.
.TP 8
.B "combiningChars\fP (class\fB CombiningChars\fP)"
Specifies the number of wide-characters which can be stored in a cell
to overstrike (combine) with the base character of the cell.
This can be set to values in the range 0 to 5.
The default is \*(``2\*(''.
.TP 8
.B "ctrlFKeys\fP (class\fB CtrlFKeys\fP)"
In VT220 keyboard mode (see \fBsunKeyboard\fP resource),
specifies the amount by which to shift F1-F12 given a control modifier (CTRL).
This allows you to generate key symbols for F10-F20 on a Sun/PC keyboard.
The default is \*(``10\*('', which means that CTRL F1 generates the key
symbol for F11.
.TP 8
.B "curses\fP (class\fB Curses\fP)"
Specifies whether or not the last column bug in
.IR more (1)
should be worked around.
See the \fB\-cu\fP option for details.
The default is \*(``false\*(''.
.TP 8
.B "cursorBlink\fP (class\fB CursorBlink\fP)"
Specifies whether to make the cursor blink.
\fI\*N\fP accepts either a keyword (ignoring case)
or the number shown in parentheses:
.RS
.TP 3
false (0)
The cursor will not blink, but may be combined with escape sequences
according to the \fBcursorBlinkXOR\fP resource.
.TP 3
true (1)
The cursor will blink, but may be combined with escape sequences
according to the \fBcursorBlinkXOR\fP resource.
.TP 3
always (2)
The cursor will always blink, ignoring escape sequences.
The menu entry will be disabled.
.TP 3
never (3)
The cursor will never blink, ignoring escape sequences.
The menu entry will be disabled.
.RE
.IP
The default is \*(``false\*(''.
.TP 8
.B "cursorBlinkXOR\fP (class\fB CursorBlinkXOR\fP)"
\fI\*N\fP uses two inputs to determine whether the cursor blinks:
.RS
.bP
The \fBcursorBlink\fP resource (which can be altered with a menu entry).
.bP
Control sequences (private mode 12 and DECSCUSR).
.RE
.IP
The \fBcursorBlinkXOR\fP resource determines how those inputs are combined:
.RS
.TP 5
false
.br
\fI\*N\fP uses the logical-OR of the two variables.
If either is set, \fI\*n\fP makes the cursor blink.
.TP 5
true
.br
\fI\*N\fP uses the logical-XOR of the two variables.
If only one is set, \fI\*n\fP makes the cursor blink.
.RE
.IP
The default is \*(``true\*(''.
.TP 8
.B "cursorColor\fP (class\fB CursorColor\fP)"
Specifies the color to use for the text cursor.
The default is \*(``XtDefaultForeground\*(''.
By default,
\fI\*n\fP attempts to keep this color from being the same as the background
color, since it draws the cursor by filling the background of a text cell.
The same restriction applies to control sequences which may change this color.
.IP
Setting this resource overrides
most of \fI\*n\fP's adjustments to cursor color.
It will still use reverse-video to disallow some cases, such as a black
cursor on a black background.
.TP 8
.B "cursorOffTime\fP (class\fB CursorOffTime\fP)"
Specifies the duration of the \*(``off\*('' part of the cursor blink cycle-time
in milliseconds.
The same timer is used for text blinking.
The default is \*(``300\*(''.
.TP 8
.B "cursorOnTime\fP (class\fB CursorOnTime\fP)"
Specifies the duration of the \*(``on\*('' part of the cursor blink cycle-time,
in milliseconds.
The same timer is used for text blinking.
The default is \*(``600\*(''.
.TP 8
.B "cursorUnderLine\fP (class\fB CursorUnderLine\fP)"
Specifies whether to make the cursor underlined or a box.
The default is \*(``false\*(''.
.TP 8
.B "cutNewline\fP (class\fB CutNewline\fP)"
If \*(``false\*('', triple clicking to select a line does not include
the \fInewline\fP at the end of the line.
If \*(``true\*('', the Newline is selected.
The default is \*(``true\*(''.
.TP 8
.B "cutToBeginningOfLine\fP (class\fB CutToBeginningOfLine\fP)"
If \*(``false\*('', triple clicking to select a line selects only from the
current word forward.
If \*(``true\*('', the entire line is selected.
The default is \*(``true\*(''.
.TP 8
.B "decTerminalID\fP (class\fB DecTerminalID\fP)"
Specifies the emulation level (100=VT100, 220=VT220, etc.), used to determine
the type of response to a DA control sequence.
Leading non-digit characters are ignored,
e.g., \*(``vt100\*('' and \*(``100\*('' are the same.
The default is \*(``__default_termid__\*(''.
.TP 8
.B "defaultString\fP (class\fB DefaultString\fP)"
Specify the character (or string) which \fI\*n\fP will substitute when
pasted text includes a character which cannot be represented in the
current encoding.
For instance, pasting UTF-8 text into a display of ISO-8859-1 characters
will only be able to display codes 0\(en255, while UTF-8 text can include
Unicode values above 255.
The default is \*(``#\*('' (a single pound sign).
.IP
If the undisplayable text would be double-width,
\fI\*n\fP will add a space after the \*(``#\*('' character, to give roughly
the same layout on the screen as the original text.
.TP 8
.B "deleteIsDEL\fP (class\fB DeleteIsDEL\fP)"
Specifies what the \fIDelete\fP key
on the editing keypad should send when pressed.
The resource value is a string, evaluated as a boolean after startup.
\fI\*N\fP uses it in conjunction with the \fBkeyboardType\fP resource:
.RS
.bP
If the keyboard type is
\*(``default\*('',
or
\*(``vt220\*(''
and the resource is either \*(``true\*('' or \*(``maybe\*('' 
send the VT220-style \fIRemove\fP escape sequence.
Otherwise, send DEL (127).
.bP
If the keyboard type is
\*(``legacy\*('',
and the resource is \*(``true\*(''
send DEL.
Otherwise, send the \fIRemove\fP sequence.
.bP
Otherwise, if the keyboard type is none of these special cases,
send DEL (127).
.RE
.IP
The default is \*(``__delete_is_del__\*(''.
The resource is allowed to be a non-boolean \*(``maybe\*(''
so that the popup menu \fBDelete is DEL\fP entry does
not override the keyboard type.
.TP 8
.B "directColor\fP (class\fB DirectColor\fP)"
Specifies whether to handle direct-color control sequences
using the X server's available colors,
or to approximate those using a color map with 256 entries.
A \*(``true\*('' value enables the former.
The default is \*(``true\*(''.
.TP 8
.B "disallowedColorOps\fP (class\fB DisallowedColorOps\fP)"
Specify which features will be disabled if \fBallowColorOps\fP is false.
This is a comma-separated list of names.
The default value is
.RS
SetColor,GetColor,GetAnsiColor
.RE
.IP
The names are listed below.
\fI\*N\fP ignores capitalization, but
they are shown in mixed-case for clarity.
.RS
.TP 5
SetColor
Set a specific dynamic color.
.TP 5
GetColor
Report the current setting of a given dynamic color.
.TP 5
GetAnsiColor
Report the current setting of a given ANSI color (actually any of the colors
set via ANSI-style controls).
.RE
.TP 8
.B "disallowedFontOps\fP (class\fB DisallowedFontOps\fP)"
Specify which features will be disabled if \fBallowFontOps\fP is false.
This is a comma-separated list of names.
The default value is
.NS
SetFont,GetFont
.NE
.IP
The names are listed below.
\fI\*N\fP ignores capitalization, but
they are shown in mixed-case for clarity.
.RS
.TP 5
SetFont
Set the specified font.
.TP 5
GetFont
Report the specified font.
.RE
.TP 8
.B "disallowedMouseOps\fP (class\fB DisallowedMouseOps\fP)"
Specify which features will be disabled if \fBallowMouseOps\fP is false.
This is a comma-separated list of names.
The default value is \*(``*\*('' which matches all names.
The names are listed below.
\fI\*N\fP ignores capitalization, but
they are shown in mixed-case for clarity.
.RS
.TP 5
X10
The original X10 mouse protocol.
.TP 5
Locator
DEC locator mode
.TP 5
VT200Click
X11 mouse-clicks only.
.TP 5
VT200Hilite
X11 mouse-clicks and highlighting.
.TP 5
AnyButton
XFree86 \fI\*n\fP any-button mode sends button-clicks as
well as motion events while the button is pressed.
.TP 5
AnyEvent
XFree86 \fI\*n\fP any-event mode sends button-clicks as
well as motion events whether or not a button is pressed.
.TP 5
FocusEvent
Send FocusIn/FocusOut events.
.TP 5
Extended
The first extension beyond X11 mouse protocol, this encodes
the coordinates in UTF-8.
It is deprecated in favor of \fISGR\fP, but provided for compatibility.
.TP 5
SGR
This is the recommended extension for mouse-coordinates
.TP 5
URXVT
Like \fIExtended\fP, this is provided for compatibility.
.TP 5
AlternateScroll
This overrides the \fBalternateScroll\fP resource.
.RE
.TP 8
.B "disallowedPasteControls\fP (class\fB DisallowedPasteControls\fP)"
The \fBallowPasteControls\fP resource is normally used to prevent
pasting C1 controls, as well as non-formatting C0 controls such
as the ASCII escape character.
Those characters are simply ignored.
This resource further extends the set of control characters
which cannot be pasted, converting each into a space.
.IP
The resource value is a comma-separated list of names.
\fI\*N\fP ignores capitalization.
The default value is
.NS
BS,HT,DEL,ESC
.NE
.IP
The names are listed below:
.RS
.TP 5
C0
all ASCII control characters.
.TP 5
BS
ASCII backspace
.TP 5
CR
ASCII carriage-return
.TP 5
DEL
ASCII delete
.TP 5
ESC
ASCII escape
.TP 5
FF
ASCII form-feed
.TP 5
HT
ASCII tab
.TP 5
NL
ASCII line-feed, i.e., \*(``newline\*(''.
.RE
.TP 8
.B "disallowedTcapOps\fP (class\fB DisallowedTcapOps\fP)"
Specify which features will be disabled if \fBallowTcapOps\fP is false.
This is a comma-separated list of names.
The default value is
.NS
SetTcap,GetTcap
.NE
.IP
The names are listed below.
\fI\*N\fP ignores capitalization, but
they are shown in mixed-case for clarity.
.RS
.TP 5
SetTcap
(not implemented)
.TP 5
GetTcap
Report specified function- and other special keys.
.RE
.TP 8
.B "disallowedWindowOps\fP (class\fB DisallowedWindowOps\fP)"
Specify which features will be disabled if \fBallowWindowOps\fP is false.
This is a comma-separated list of names, or (for the controls adapted
from \fIdtterm\fP the operation number).
The default value is
.NS
20,21,SetXprop,SetSelection
(i.e.\& no operations are allowed).
.NE
.IP
The names are listed below.
\fI\*N\fP ignores capitalization, but
they are shown in mixed-case for clarity.
Where a number can be used
as an alternative, it is given in parentheses after the name.
.RS
.TP 5
GetChecksum
Report checksum of characters in a rectangular region.
.TP 5
GetIconTitle (20)
Report \fI\*n\fP window's icon label as a string.
.TP 5
GetScreenSizeChars (19)
Report the size of the screen in characters as numbers.
.TP 5
GetSelection
Report selection data as a base64 string.
.TP 5
GetWinPosition (13)
Report \fI\*n\fP window position as numbers.
.TP 5
GetWinSizeChars (18)
Report the size of the text area in characters as numbers.
.TP 5
GetWinSizePixels (14)
Report \fI\*n\fP window in pixels as numbers.
.TP 5
GetWinState (11)
Report \fI\*n\fP window state as a number.
.TP 5
GetWinTitle (21)
Report \fI\*n\fP window's title as a string.
.TP 5
LowerWin (6)
Lower the \fI\*n\fP window to the bottom of the stacking order.
.TP 5
MaximizeWin (9)
Maximize window (i.e., resize to screen size).
.TP 5
FullscreenWin (10)
Use full screen (i.e., resize to screen size, without window decorations).
.TP 5
MinimizeWin (2)
Iconify window.
.TP 5
PopTitle (23)
Pop title from internal stack.
.TP 5
PushTitle (22)
Push title to internal stack.
.TP 5
RaiseWin (5)
Raise the \fI\*n\fP window to the front of the stacking order.
.TP 5
RefreshWin (7)
Refresh the \fI\*n\fP window.
.TP 5
RestoreWin (1)
De-iconify window.
.TP 5
SetChecksum
Modify algorithm for reporting checksum of characters in a rectangular region.
.TP 5
SetSelection
Set selection data.
.TP 5
SetWinLines
Resize to a given number of lines, at least 24.
.TP 5
SetWinPosition (3)
Move window to given coordinates.
.TP 5
SetWinSizeChars (8)
Resize the text area to given size in characters.
.TP 5
SetWinSizePixels (4)
Resize the \fI\*n\fP window to given size in pixels.
.TP 5
SetXprop
Set X property on top-level window.
.RE
.TP 8
.B "dynamicColors\fP (class\fB DynamicColors\fP)"
Specifies whether or not escape sequences to change colors assigned to
different attributes are recognized.
.TP 8
.B "eightBitControl\fP (class\fB EightBitControl\fP)"
Specifies whether or not control sequences sent by the
terminal should be eight-bit characters or escape sequences.
The default is \*(``false\*(''.
.TP 8
.B "eightBitInput\fP (class\fB EightBitInput\fP)"
If \*(``true\*('', Meta characters
(a single-byte character combined with the \fIMeta\fP modifier key)
input from the keyboard are presented as a
single character, modified according to the \fBeightBitMeta\fP resource.
If \*(``false\*('', Meta characters are converted into a two-character
sequence with the character itself preceded by ESC.
The default is \*(``true\*(''.
.IP
The \fBmetaSendsEscape\fP
and \fBaltSendsEscape\fP resources may override this feature.
Generally keyboards do not have a key labeled \*(``Meta\*('',
but \*(``Alt\*('' keys are common,
and they are conventionally used for \*(``Meta\*(''.
If they were synonymous, it would have been reasonable to name this
resource \*(``\fBaltSendsEscape\fP\*('', reversing its sense.
For more background on this, see the \fBmeta\fP(3x) function in curses.
.IP
Note that the \fIAlt\fP key is not necessarily the same as the
\fIMeta\fP modifier.
The \fIxmodmap\fP utility lists your key modifiers.
X defines modifiers for shift, (caps) lock and control,
as well as 5 additional modifiers which are generally used to configure
key modifiers.
\fI\*N\fP inspects the same information to find the modifier associated
with either \fIMeta\fP key (left or right),
and uses that key as the \fIMeta\fP modifier.
It also looks for the NumLock key,
to recognize the modifier which is associated with that.
.IP
If your \fIxmodmap\fP configuration
uses the same keycodes for Alt- and Meta-keys,
\fI\*n\fP will only see the Alt-key definitions, since those are tested
before Meta-keys.
NumLock is tested first.
It is important to keep these keys distinct;
otherwise some of \fI\*n\fP's functionality is not available.
.IP
The \fBeightBitInput\fP resource is tested at startup time.
If \*(``true\*('',
the \fI\*n\fP tries to put the terminal into 8-bit mode.
If \*(``false\*('',
on startup, \fI\*n\fP tries to put the terminal into 7-bit mode.
For some configurations this is unsuccessful; failure is ignored.
After startup, \fI\*n\fP does not
change the terminal between 8-bit and 7-bit mode.
.IP
As originally implemented in X11,
the resource value did not change after startup.
However
(since patch #216 in 2006)
\fI\*n\fP can modify \fBeightBitInput\fP after startup
via a control sequence.
The corresponding terminfo capabilities \fBsmm\fP (set meta mode)
and \fBrmm\fP (reset meta mode)
have been recognized by \fIbash\fP for some time.
Interestingly enough, \fIbash\fP's notion of \*(``meta mode\*(''
differs from the standard definition (in the \fIterminfo\fP manual),
which describes the change to the eighth bit of a character.
It happens that \fIbash\fP views \*(``meta mode\*(''
as the ESC character that \fI\*n\fP puts before a character when a
special meta key is pressed.
\fIbash\fP's early documentation talks about the ESC character
and ignores the eighth bit.
.TP 8
.B "eightBitMeta\fP (class\fB EightBitMeta\fP)"
This controls the way \fI\*n\fP modifies the eighth bit of a single-byte
key when the \fBeightBitInput\fP resource is set.
The default is \*(``locale\*(''.
.IP
The resource value is a string, evaluated as a boolean after startup.
.RS
.TP 5
false
The key is sent unmodified.
.TP 5
locale
The key is modified only if the locale uses eight-bit encoding.
.TP 5
true
The key is sent modified.
.TP 5
never
The key is always sent unmodified.
.RE
.IP
Except for the \fBnever\fP choice, \fI\*n\fP honors the
terminfo capabilities \fBsmm\fP (set meta mode)
and \fBrmm\fP (reset meta mode),
allowing the feature to be turned on or off dynamically.
.IP
If \fBeightBitMeta\fP is enabled when the locale uses UTF-8,
\fI\*n\fP encodes the value as UTF-8
(since patch #183 in 2003).
.TP 8
.B "eightBitOutput\fP (class\fB EightBitOutput\fP)"
Specifies whether or not eight-bit characters sent from the host should be
accepted as is or stripped when printed.
The default is \*(``true\*('',
which means that they are accepted as is.
.TP 8
.B "eightBitSelectTypes\fP (class\fB EightBitSelectTypes\fP)"
Override \fI\*n\fP's default selection target list
(see \fBSELECT/PASTE\fP) for selections in normal (ISO-8859-1) mode.
The default is an empty string, i.e., \*(``\*('',
which does not override anything.
.TP 8
.B "eraseSavedLines\fP (class\fB EraseSavedLines\fP)"
Specifies whether or not to allow
\fI\*n\fP extended ED/DECSED control sequences to erase the saved-line buffer.
The default is \*(``true\*(''.
.TP 8
.B "faceName\fP (class\fB FaceName\fP)"
Specify the pattern for scalable fonts selected from the FreeType
library if support for that library was compiled into \fI\*n\fR.
There is no default value.
.IP
One or more fonts can be specified, separated by commas.
If prefixed with \*(``x:\*('' or \*(``x11:\*('' the specification
applies to the XLFD \fBfont\fP resource.
A \*(``xft:\*('' prefix is accepted but unnecessary since
a missing prefix for \fBfaceName\fP means that it will be used for TrueType.
For example,
.NS
XTerm*faceName: x:fixed,xft:Bitstream Vera Sans Mono
.NE
.IP
If no \fBfaceName\fP resource is specified,
or if there is no match for both TrueType normal and bold fonts,
\fI\*n\fR uses the XLFD (bitmap) \fBfont\fP and related resources.
.IP
It is possible to select suitable bitmap fonts using a script such as this:
.NS
\&#!/bin/sh
\&FONT=`xfontsel \-print`
\&test \-n "$FONT" && xfd \-fn "$FONT"
.NE
.IP
However (even though \fIxfd\fP accepts a \*(``\fB\-fa\fP\*('' option
to denote FreeType fonts),
\fIxfontsel\fP has not been similarly extended.
As a workaround, you may try
.NS
fc\-list :scalable=true:spacing=mono: family
.NE
.IP
to find a list of scalable fixed-pitch fonts
which may be used for the \fBfaceName\fP resource value.
.TP 8
.B "faceNameDoublesize\fP (class\fB FaceNameDoublesize\fP)"
Specify a double-width scalable font for cases where an application requires
this, e.g., in CJK applications.
There is no default value.
.IP
Like the \fBfaceName\fP resource, this allows one or more comma-separated
font specifications to be applied to the \fIwide\fP TrueType or XLFD fonts.
.IP
If the application uses double-wide characters and this resource is not given,
\fI\*n\fP will use a scaled version of the font given by \fBfaceName\fP.
.TP 8
.B "faceSize\fP (class\fB FaceSize\fP)"
Specify the pointsize for fonts selected from the FreeType
library if support for that library was compiled into \fI\*n\fR.
The default is \*(``8.0\*(''
On the \fBVT\ Fonts\fP menu, this corresponds to the \fIDefault\fP entry.
.IP
Although the default is \*(``8.0\*('',
this may not be the same as the pointsize for the default bitmap font,
i.e., that assigned with the \fB\-fn\fP option,
or the \fBfont\fP resource.
The default value of \fBfaceSize\fP is chosen
to match the size of the \*(``fixed\*('' font,
making switching between bitmap and TrueType fonts via the font menu
give comparable sizes for the window.
If your \fB\-fn\fP option uses a different pointsize,
you might want to adjust the \fBfaceSize\fP resource to match.
.IP
You can specify the pointsize for TrueType fonts selected with the other
size-related menu entries such as Medium, Huge, etc., by using one of
the following resource values.
If you do not specify a value,
they default to \*(``0.0\*('',
which causes \fI\*n\fP to use the ratio of font sizes
from the corresponding bitmap
font resources to obtain a TrueType pointsize.
.IP
If all of the \fBfaceSize\fP resources are set, then \fI\*n\fP
will use this information to determine the next smaller/larger
TrueType font for the
\fBlarger-vt-font()\fP and
\fBsmaller-vt-font()\fP actions.
If any are not set, \fI\*n\fP will use only the areas of the bitmap fonts.
.TP 8
.B "faceSize1\fP (class\fB FaceSize1\fP)"
Specifies the pointsize of the first alternative font.
.TP 8
.B "faceSize2\fP (class\fB FaceSize2\fP)"
Specifies the pointsize of the second alternative font.
.TP 8
.B "faceSize3\fP (class\fB FaceSize3\fP)"
Specifies the pointsize of the third alternative font.
.TP 8
.B "faceSize4\fP (class\fB FaceSize4\fP)"
Specifies the pointsize of the fourth alternative font.
.TP 8
.B "faceSize5\fP (class\fB FaceSize5\fP)"
Specifies the pointsize of the fifth alternative font.
.TP 8
.B "faceSize6\fP (class\fB FaceSize6\fP)"
Specifies the pointsize of the sixth alternative font.
.TP 8
.B "font\fP (class\fB Font\fP)"
Specifies the name of the normal font.
The default is \*(``fixed\*(''.
.IP
See the discussion of the \fBlocale\fP resource,
which describes how this font may be overridden.
.IP
NOTE: some resource files use patterns such as
.NS
*font: fixed
.NE
.IP
which are overly broad, affecting both
.NS
xterm.vt100.font
.NE
.IP
and
.NS
xterm.vt100.utf8Fonts.font
.NE
.IP
which is probably not what you intended.
.TP 8
.B "fastScroll\fP (class\fB FastScroll\fP)"
Modifies the effect of jump scroll (\fBjumpScroll\fP)
by suppressing screen refreshes
for the special case when output to the screen has completely shifted
the contents off-screen.
For instance, \fIcat\fP'ing a large file to the screen does this.
.TP 8
.B "font1\fP (class\fB Font1\fP)"
Specifies the name of the first alternative font,
corresponding to \*(``Unreadable\*('' in the standard menu.
.TP 8
.B "font2\fP (class\fB Font2\fP)"
Specifies the name of the second alternative font,
corresponding to \*(``Tiny\*('' in the standard menu.
.TP 8
.B "font3\fP (class\fB Font3\fP)"
Specifies the name of the third alternative font,
corresponding to \*(``Small\*('' in the standard menu.
.TP 8
.B "font4\fP (class\fB Font4\fP)"
Specifies the name of the fourth alternative font,
corresponding to \*(``Medium\*('' in the standard menu.
.TP 8
.B "font5\fP (class\fB Font5\fP)"
Specifies the name of the fifth alternative font,
corresponding to \*(``Large\*('' in the standard menu.
.TP 8
.B "font6\fP (class\fB Font6\fP)"
Specifies the name of the sixth alternative font,
corresponding to \*(``Huge\*('' in the standard menu.
.TP 8
.B "fontDoublesize\fP (class\fB FontDoublesize\fP)"
Specifies whether \fI\*n\fP should attempt to use font scaling to draw
double-sized characters.
Some older font servers cannot do this properly, will return misleading
font metrics.
The default is \*(``true\*(''.
If disabled, \fI\*n\fP will simulate double-sized characters by drawing
normal characters with spaces between them.
.TP 8
.B "fontWarnings\fP (class\fB FontWarnings\fP)"
Specify whether \fI\*n\fP should report an error if it fails to load a font:
.RS
.TP 5
0
Never report an error (though the X libraries may).
.TP 5
1
Report an error if the font name was given as a resource setting.
.TP 5
2
Always report an error on failure to load a font.
.RE
.IP
The default is \*(``1\*(''.
.TP 8
.B "forceBoxChars\fP (class\fB ForceBoxChars\fP)"
Specifies whether \fI\*n\fP should assume the normal and bold fonts
have VT100 line-drawing characters:
.RS
.bP
The fixed-pitch ISO-8859-*-encoded fonts used by \fI\*n\fP
normally have the VT100 line-drawing glyphs in cells 1\(en31.
Other fixed-pitch fonts may be more attractive, but lack these glyphs.
.bP
When using an ISO-10646-1 font and the \fBwideChars\fP resource is true,
\fI\*n\fP uses the Unicode glyphs which match the VT100 line-drawing glyphs.
.RE
.IP
If \*(``false\*('', \fI\*n\fP checks for missing glyphs in the font
and makes line-drawing characters directly as needed.
If \*(``true\*('', \fI\*n\fP assumes the font does not contain the
line-drawing characters, and draws them directly.
The default is \*(``false\*(''.
.TP 8
.B "forcePackedFont\fP (class\fB ForcePackedFont\fP)"
Specifies whether \fI\*n\fP should use the maximum or minimum glyph
width when displaying using a bitmap font.
Use the maximum width to help with proportional fonts.
The default is \*(``true\*('', denoting the minimum width.
.TP 8
.B "foreground\fP (class\fB Foreground\fP)"
Specifies the color to use for displaying text in the window.
Setting the
class name instead of the instance name is an easy way to have everything
that would normally appear in the text color change color.
The default
is \*(``XtDefaultForeground\*(''.
.TP 8
.B "formatOtherKeys\fP (class\fB FormatOtherKeys\fP)"
Overrides the format of the escape sequence used to report modified keys
with the \fBmodifyOtherKeys\fP resource.
.RS
.TP 3
0
send modified keys as parameters for function-key 27 (default).
.TP 3
1
send modified keys as parameters for CSI\ u.
.RE
.TP 8
.B "freeBoldBox\fP (class\fB FreeBoldBox\fP)"
Specifies whether \fI\*n\fP should assume the bounding boxes for
normal and bold fonts are compatible.
If \*(``false\*('', \fI\*n\fP compares them and will reject choices of
bold fonts that do not match the size of the normal font.
The default is \*(``false\*('', which means that the comparison is performed.
.TP 8
.B "geometry\fP (class\fB Geometry\fP)"
Specifies the preferred size and position of the VT\fIxxx\fP window.
There is no default for this resource.
.TP 8
.B "highlightColor\fP (class\fB HighlightColor\fP)"
Specifies the color to use for the background of selected (highlighted) text.
If not specified (i.e., matching the default foreground), reverse video is used.
The default is \*(``XtDefaultForeground\*(''.
.TP 8
.B "highlightColorMode\fP (class\fB HighlightColorMode\fP)"
Specifies whether \fI\*n\fP should use
\fBhighlightTextColor\fP and \fBhighlightColor\fP
to override the reversed foreground/background colors in a selection.
The default is unspecified:
at startup, \fI\*n\fP checks if those resources are set to something
other than the default foreground and background colors.
Setting this resource disables the check.
.IP
The following table shows the interaction of the highlighting
resources, abbreviated as shown to fit in this page:
.RS
.TP 3
.I HCM
highlightColorMode
.TP 3
.I HR
highlightReverse
.TP 3
.I HBG
highlightColor
.TP 3
.I HFG
highlightTextColor
.RE
.IP
.ne 34
.TS
l l l l l
_ _ _ _ _
l l l l l.
\fIHCM\fR	\fIHR\fR	\fIHBG\fR	\fIHFG\fR	\fIHighlight\fP
false	false	default	default	bg/fg
false	false	default	set	bg/fg
false	false	set	default	fg/HBG
false	false	set	set	fg/HBG
=
false	true	default	default	bg/fg
false	true	default	set	bg/fg
false	true	set	default	fg/HBG
false	true	set	set	fg/HBG
=
true	false	default	default	bg/fg
true	false	default	set	HFG/fg
true	false	set	default	bg/HBG
true	false	set	set	HFG/HBG
=
true	true	default	default	bg/fg
true	true	default	set	HFG/fg
true	true	set	default	fg/HBG
true	true	set	set	HFG/HBG
=
default	false	default	default	bg/fg
default	false	default	set	bg/fg
default	false	set	default	fg/HBG
default	false	set	set	HFG/HBG
=
default	true	default	default	bg/fg
default	true	default	set	bg/fg
default	true	set	default	fg/HBG
default	true	set	set	HFG/HBG
=
.TE
.TP 8
.B "highlightReverse\fP (class\fB HighlightReverse\fP)"
Specifies whether \fI\*n\fP should reverse the selection foreground
and background colors when selecting text with reverse-video attribute.
This applies only to
the \fBhighlightColor\fP and \fBhighlightTextColor\fP resources,
e.g., to match the color scheme of \fIxwsh\fP.
If \*(``true\*('', \fI\*n\fP reverses the colors,
If \*(``false\*('', \fI\*n\fP does not reverse colors,
The default is \*(``true\*(''.
.TP 8
.B "highlightSelection\fP (class\fB HighlightSelection\fP)"
Tells \fI\*n\fP whether to highlight all of the selected positions,
or only the selected text:
.RS
.bP
If \*(``false\*('',
selecting with the mouse highlights all positions on the screen
between the beginning of the selection and the current position.
.bP
If \*(``true\*('',
\fI\*n\fP highlights only the positions that contain text that
can be selected.
.RE
.IP
The default is \*(``false\*(''.
.IP
Depending on the way your applications write to the screen, there may
be trailing blanks on a line.
\fI\*N\fP stores data as it is shown on the screen.
Erasing the display changes the internal state of each cell
so it is not considered a blank for the purpose of selection.
Blanks written since the last erase are selectable.
If you do not wish to have trailing blanks in a selection,
use the \fBtrimSelection\fP resource.
.TP 8
.B "highlightTextColor\fP (class\fB HighlightTextColor\fP)"
Specifies the color to use for the foreground of selected (highlighted) text.
If not specified (i.e., matching the default background), reverse video is used.
The default is \*(``XtDefaultBackground\*(''.
.TP 8
.B "hpLowerleftBugCompat\fP (class\fB HpLowerleftBugCompat\fP)"
Specifies whether to work around a bug in HP's \fIxdb\fP,
which ignores termcap and always sends
ESC F to move to the lower left corner.
\*(``true\*('' causes \fI\*n\fP to interpret ESC F as a request to move to the
lower left corner of the screen.
The default is \*(``false\*(''.
.TP 8
.B "i18nSelections\fP (class\fB I18nSelections\fP)"
If false, \fI\*n\fP will not request the targets
\fBCOMPOUND_TEXT\fP
or
\fBTEXT\fP.
The default is \*(``true\*(''.
It may be set to false in order to work around
ICCCM violations by other X clients.
.TP 8
.B "iconBorderColor\fP (class\fB BorderColor\fP)"
Specifies the border color for the active icon window if this feature
is compiled into \fI\*n\fR.
Not all window managers will make the icon
border visible.
.TP 8
.B "iconBorderWidth\fP (class\fB BorderWidth\fP)"
Specifies the border width for the active icon window if this feature
is compiled into \fI\*n\fR.
The default is \*(``2\*(''.
Not all window managers will make the border visible.
.TP 8
.B "iconFont\fP (class\fB IconFont\fP)"
Specifies the font for the miniature active icon window, if this feature
is compiled into \fI\*n\fR.
The default is \*(``nil2\*(''.
.TP 8
.B "initialFont\fP (class\fB InitialFont\fP)"
Specifies which of the VT100 fonts to use initially.
Values are the same as for the \fBset-vt-font\fP action.
The default is \*(``d\*('', i.e., \*(``default\*(''.
.TP 8
.B "inputMethod\fP (class\fB InputMethod\fP)"
Tells \fI\*n\fP which type of input method to use.
There is no default method.
.TP 8
.B "internalBorder\fP (class\fB BorderWidth\fP)"
Specifies the number of pixels between the characters and the window border.
The default is \*(``2\*(''.
.TP 8
.B "italicULMode\fP (class\fB ColorAttrMode\fP)"
Specifies whether characters with the underline attribute should be displayed
in an italic font or as underlined characters.
It is implemented only for TrueType fonts.
.TP 8
.B "jumpScroll\fP (class\fB JumpScroll\fP)"
Specifies whether or not jump scroll should be used.
This corresponds to the VT102 DECSCLM private mode.
The default is \*(``true\*(''.
See \fBfastScroll\fP for a variation.
.TP 8
.B "keepClipboard\fP (class\fB KeepClipboard\fP)"
Specifies whether \fI\*n\fR will reuse the selection data which it
copied to the clipboard rather than asking the clipboard for its
current contents when told to provide the selection.
The default is \*(``false\*(''.
.IP
The menu entry \fBKeep Clipboard\fP allows you to change this at runtime.
.TP 8
.B "keepSelection\fP (class\fB KeepSelection\fP)"
Specifies whether \fI\*n\fR will keep the selection even after the
selected area was touched by some output to the terminal.
The default is \*(``true\*(''.
.IP
The menu entry \fBKeep Selection\fP allows you to change this at runtime.
.TP 8
.B "keyboardDialect\fP (class\fB KeyboardDialect\fP)"
Specifies the initial keyboard dialect, as well as the default value when
the terminal is reset.
The value given is the same as the final character in the control sequences
which change character sets.
The default is \*(``B\*('', which corresponds to US ASCII.
.TP 8
.B "\fIname\fP\fBKeymap\fP (class\fB \fIName\fP\fBKeymap\fP)"
See the discussion of the \fBkeymap()\fP action.
.TP 8
.B "limitFontsets\fP (class\fB LimitFontsets\fP)"
Limits the number of TrueType fallback fonts (i.e., fontset) which can be used.
The default is \*(``50\*(''.
.IP
This limits the number of fallback fonts
which \fI\*n\fP uses to display characters.
Because TrueType fonts typically are small,
\fI\*n\fP may open several fonts for good coverage, and
may open additional fonts to obtain information.
You can see which font-files \fI\*n\fP opens by setting the
environment variable \fBXFT_DEBUG\fP to 3.
The Xft library and \fI\*n\fP write this debugging trace
to the standard output.
.IP
Set this to \*(``0\*('' to disable fallbacks entirely.
.TP 8
.B "limitResize\fP (class\fB LimitResize\fP)"
Limits resizing of the screen via control sequence to a given multiple of
the display dimensions.
The default is \*(``1\*(''.
.TP 8
.B "limitResponse\fP (class\fB LimitResponse\fP)"
Limits the buffer-size used when \fI\*n\fP
replies to various control sequences.
The default is \*(``1024\*(''.
The minimum value is \*(``256\*(''.
.TP 8
.B "locale\fP (class\fB Locale\fP)"
Specifies how to use \fIluit\fR, an encoding converter between UTF-8
and locale encodings.
The resource value (ignoring case) may be:
.RS
.TP 4
.I true
\fI\*N\fR will use the
encoding specified by the users' LC_CTYPE locale (i.e., LC_ALL,
LC_CTYPE, or LANG variables) as far as possible.
This is realized
by always enabling UTF-8 mode and invoking \fIluit\fR in non-UTF-8
locales.
.TP
.I medium
\fI\*N\fR will follow users'
LC_CTYPE locale only for UTF-8, east Asian, and Thai locales,
where the encodings were not supported by conventional 8bit mode
with changing fonts.
For other locales, \fI\*n\fR will use conventional 8bit mode.
.TP
.I checkfont
If mini-luit is compiled-in, \fI\*n\fR will check if a Unicode font has
been specified.
If so, it checks if the character encoding for the
current locale is POSIX, Latin-1 or Latin-9, uses the appropriate
mapping to support those with the Unicode font.
For other encodings, \fI\*n\fR assumes that UTF-8 encoding is required.
.TP
.I false
\fI\*N\fR will use conventional 8bit mode
or UTF-8 mode according to \fButf8\fR resource or \fB\-u8\fP option.
.RE
.IP
Any other value, e.g., \*(``UTF-8\*('' or \*(``ISO8859-2\*('',
is assumed to be an encoding name;
\fIluit\fR will be invoked to support the encoding.
The actual list of supported encodings depends on \fIluit\fR.
The default is \*(``medium\*(''.
.IP
Regardless of your locale and encoding,
you need an ISO-10646-1 font to display the result.
Your configuration may not include this font,
or locale-support by \fI\*n\fP may not be needed.
.IP
At startup, \fI\*n\fP uses a mechanism equivalent to
the \fBload-vt-fonts(utf8Fonts,\ Utf8Fonts)\fP action
to load font name subresources of the VT100 widget.
That is,
resource patterns such as \*(``\fB*vt100.utf8Fonts.font\fP\*('' will be loaded,
and (if this resource is enabled), override the normal fonts.
If no subresources are found,
the normal fonts such as \*(``\fB*vt100.font\fP\*('', etc., are used.
.IP
For instance, you could have this in your resource file:
.NS
*VT100.font: 12x24
*VT100.utf8Fonts.font:9x15
.NE
.IP
When started with a UTF-8 locale, \fI\*n\fP would use 9x15, but
allow you to switch to the 12x24 font
using the menu entry \*(``\fBUTF-8 Fonts\fP\*(''.
.IP
The resource files distributed with \fI\*n\fP use ISO-10646-1 fonts,
but do not rely on them unless you are using the locale mechanism.
.TP 8
.B "localeFilter\fP (class\fB LocaleFilter\fP)"
Specifies the file name for the encoding converter from/to locale
encodings and UTF-8 which is used with
the \fB\-lc\fR option or \fBlocale\fR resource.
The help message shown by \*(``\*n \-help\*('' lists the default value,
which depends on your system configuration.
.IP
If the encoding converter requires command-line parameters,
you can add those after the command, e.g.,
.NS
*localeFilter: xterm\-filter \-p
.NE
.IP
Alternatively,
you may put those parameter within a shell script to execute the converter,
and set this resource to point to the shell script.
.IP
When using a locale-filter, e.g., with the \fI\-e\fP option, or the shell,
\fI\*n\fP first tries passing control via that filter.
If it fails, \fI\*n\fP will retry without the locale-filter.
\fI\*N\fP warns about the failure before retrying.
.TP 8
.B "loginShell\fP (class\fB LoginShell\fP)"
Specifies whether or not the shell to be run in the window should be started
as a login shell.
The default is \*(``false\*(''.
.TP 8
.B "logFile\fP (class\fB Logfile\fP)"
Specify the name for \fI\*n\fP's log file.
If no name is specified, \fI\*n\fP will generate a name when
logging is enabled,
as described in the \fB\-l\fP option.
.TP 8
.B "logInhibit\fP (class\fB LogInhibit\fP)"
If \*(``true\*('', prevent the logging feature from being enabled,
whether by the command-line option \fB\-l\fP,
or the menu entry \fBLog to File\fP.
The default is \*(``false\*(''.
.TP 8
.B "logging\fP (class\fB Logging\fP)"
If \*(``true\*('', (and if \fBlogInhibit\fP is not set)
enable the logging feature.
This resource is set/updated by the \fB\-l\fP option and the
menu entry \fBLog to File\fP.
The default is \*(``false\*(''.
.TP 8
.B "marginBell\fP (class\fB MarginBell\fP)"
Specifies whether or not the bell should be rung when the user types near the
right margin.
The default is \*(``false\*(''.
.TP 8
.B "maxGraphicSize\fP (class\fB MaxGraphicSize\fP)"
If \fI\*n\fR is configured to support ReGIS or SIXEL graphics,
this resource controls the maximum size of a graph which can be displayed.
.IP
The default is \*(``1000x1000\*('' (given as \fIwidth\fP by \fIheight\fP).
.IP
If the resource is \*(``auto\*('' then \fI\*n\fR will use the
\fBdecTerminalID\fP resource:
.TS
l l
_ _
r r.
\fBResult\fR	\fBdecTerminalID\fR
768x400	125
800x460	240
800x460	241
800x480	330
800x480	340
860x750	382
800x480	\fIother\fP
.TE
.TP 8
.B "metaSendsEscape\fP (class\fB MetaSendsEscape\fP)"
Tells \fI\*n\fP what to do with input-characters modified by \fIMeta\fP:
.RS
.bP
If \*(``true\*('', Meta characters
(a character combined with the \fIMeta\fP modifier key)
are converted into a two-character
sequence with the character itself preceded by ESC.
This applies as well to function key control sequences, unless \fI\*n\fP
sees that \fBMeta\fP is used in your key translations.
.bP
If \*(``false\*('',
Meta characters input from the keyboard are handled according
to the \fBeightBitInput\fP resource.
.RE
.IP
The default is \*(``__meta_sends_esc__\*(''.
.TP 8
.B "mkSamplePass\fP (class\fB MkSamplePass\fP)"
If \fBmkSampleSize\fP is nonzero,
and \fBmkWidth\fP (and \fBcjkWidth\fP) are false,
on startup \fI\*n\fP compares its built-in tables to the system's
wide character width data to decide if it will use the system's data.
It tests the first \fBmkSampleSize\fP character values,
and allows up to \fBmkSamplePass\fP mismatches before the test fails.
The default (for the allowed number of mismatches) is 655
(one percent of the default value for \fBmkSampleSize\fP).
.TP 8
.B "mkSampleSize\fP (class\fB MkSampleSize\fP)"
With \fBmkSamplePass\fP, this specifies a startup test used for
initializing wide character width calculations.
The default (number of characters to check) is 65536.
.TP 8
.B "mkWidth\fP (class\fB MkWidth\fP)"
Specifies whether \fI\*n\fP should use a built-in version of the wide
character width calculation.
See also the \fBcjkWidth\fP resource which can override this.
The default is \*(``false\*(''.
.IP
Here is a summary of the resources which control the choice of
wide character width calculation:
.ne 8
.TS
l l l
_ _ _
l l l.
\fIcjkWidth\fR	\fImkWidth\fR	\fIAction\fP
false	false	use system tables subject to \fBmkSamplePass\fP
false	true	use built-in tables
true	false	use built-in CJK tables
true	true	use built-in CJK tables
.TE
.IP
To disable \fBmkWidth\fP, and use the system's tables,
set both \fBmkSampleSize\fP and \fBmkSamplePass\fP to \*(``0\*(''.
Doing that may make \fI\*n\fP more consistent
with applications running in \fI\*n\fP,
but may omit some font glyphs whose width correctly differs
from the system's character tables.
.TP 8
.B "modifyCursorKeys\fP (class\fB ModifyCursorKeys\fP)"
Tells how to handle the special case where
Control-, Shift-, Alt- or Meta-modifiers are used to add a parameter to
the escape sequence returned by a cursor-key.
The default is \*(``2\*('':
.RS
.TP 5
\-1
disables the feature.
.TP 5
0
uses the old/obsolete behavior, i.e., the modifier is the first parameter.
.TP 5
1
prefixes modified sequences with CSI.
.TP 5
2
forces the modifier to be the second parameter if it would
otherwise be the first.
.TP 5
3
marks the sequence with a \*(``>\*('' to hint that it is private.
.RE
.TP 8
.B "modifyFunctionKeys\fP (class\fB ModifyFunctionKeys\fP)"
Tells how to handle the special case where
Control-, Shift-, Alt- or Meta-modifiers are used to add a parameter to
the escape sequence returned by a (numbered) function-key.
The default is \*(``2\*(''.
The resource values are similar to \fBmodifyCursorKeys\fP:
.RS
.TP 5
\-1
permits the user to use shift- and control-modifiers
to construct function-key strings using the normal encoding scheme.
.TP 5
0
uses the old/obsolete behavior, i.e., the modifier is the first parameter.
.TP 5
1
prefixes modified sequences with CSI.
.TP 5
2
forces the modifier to be the second parameter if it would
otherwise be the first.
.TP 5
3
marks the sequence with a \*(``>\*('' to hint that it is private.
.RE
.IP
If \fBmodifyFunctionKeys\fP is zero,
\fI\*n\fP uses Control- and Shift-modifiers to allow the user to
construct numbered function-keys beyond the set provided by the
keyboard:
.RS
.TP 5
Control
adds the value given by the \fBctrlFKeys\fP resource.
.TP 5
Shift
adds twice the value given by the \fBctrlFKeys\fP resource.
.TP 5
Control/Shift
adds three times the value given by the \fBctrlFKeys\fP resource.
.RE
.IP
.TP 8
.B "modifyKeyboard\fP (class\fB ModifyKeyboard\fP)"
Normally \fI\*n\fP makes a special case regarding
modifiers (shift, control, etc.)
to handle special keyboard layouts (\fBlegacy\fP and \fBvt220\fP).
This is done to provide compatible keyboards for DEC VT220 and related
terminals that implement user-defined keys (UDK).
.IP
The bits of the resource value selectively enable
modification of the given category when these keyboards are selected.
The default is \*(``0\*('':
.RS
.TP 5
0
The legacy/vt220 keyboards interpret only the
Control-modifier when constructing numbered function-keys.
Other special keys are not modified.
.TP 5
1
allows modification of the numeric keypad
.TP 5
2
allows modification of the editing keypad
.TP 5
4
allows modification of function-keys,
overrides use of Shift-modifier for UDK.
.TP 5
8
allows modification of other special keys
.RE
.TP 8
.B "modifyOtherKeys\fP (class\fB ModifyOtherKeys\fP)"
Like \fBmodifyCursorKeys\fP, tells \fI\*n\fP to construct an
escape sequence for other keys (such as \*(``2\*('') when modified by
Control-, Alt- or Meta-modifiers.
This feature does not apply to function keys and well-defined
keys such as ESC or the control keys.
The default is \*(``0\*('':
.RS
.TP 5
0
disables this feature.
.TP 5
1
enables this feature for keys except for those with
well-known behavior, e.g., Tab, Backarrow and some special
control character cases, e.g., Control-Space to make a NUL.
.TP 5
2
enables this feature for keys including the exceptions listed.
.RE
.TP 8
.B "multiClickTime\fP (class\fB MultiClickTime\fP)"
Specifies the maximum time in milliseconds between multi-click select
events.
The default is \*(``250\*('' milliseconds.
.TP 8
.B "multiScroll\fP (class\fB MultiScroll\fP)"
Specifies whether or not scrolling should be done asynchronously.
The default is \*(``false\*(''.
.TP 8
.B "nMarginBell\fP (class\fB Column\fP)"
Specifies the number of characters from the right margin at which the margin
bell should be rung, when enabled by the \fBmarginBell\fP resource.
The default is \*(``10\*(''.
.TP 8
.B "nextEventDelay\fP (class\fB NextEventDelay\fP)"
Specifies a delay time in milliseconds before checking for new X events.
The default is \*(``1\*(''.
.TP 8
.B "numColorRegisters\fP (class\fB NumColorRegisters\fP)"
If \fI\*n\fR is configured to support ReGIS or SIXEL graphics,
this specifies the number of color-registers which are available.
.IP
If this resource is not specified, \fI\*n\fR uses a value determined
by the \fBdecTerminalID\fP resource:
.TS
l l
_ _
r r.
\fBResult\fR	\fBdecTerminalID\fR
4	125
4	240
4	241
4	330
16	340
2	382
1024	\fIother\fP
.TE
.TP 8
.B "numLock\fP (class\fB NumLock\fP)"
If \*(``true\*('', \fI\*n\fR checks if NumLock is used as a modifier
(see \fBxmodmap\fP(__mansuffix__)).
If so, this modifier is used to simplify the logic when implementing special
NumLock for the \fBsunKeyboard\fP resource.
Also (when \fBsunKeyboard\fP is false), similar logic is used to find the
modifier associated with the left and right Alt keys.
The default is \*(``true\*(''.
.TP 8
.B "oldXtermFKeys\fP (class\fB OldXtermFKeys\fP)"
If \*(``true\*('', \fI\*n\fR will use old-style (X11R5) escape sequences
for function keys F1 to F4,
for compatibility with X Consortium \fI\*n\fR.
Otherwise, it uses the VT100 codes for PF1 to PF4.
The default is \*(``false\*(''.
.IP
Setting this resource has the same effect as setting the \fBkeyboardType\fP
to \fBlegacy\fP.
The \fBkeyboardType\fP resource is the preferred mechanism for
selecting this mode.
.IP
The old-style escape sequences resemble VT220 keys,
but appear to have been invented for \fI\*n\fP in X11R4.
.TP 8
.B "on2Clicks\fP (class\fB On2Clicks\fP)"
.TP
.B "on3Clicks\fP (class\fB On3Clicks\fP)"
.TP
.B "on4Clicks\fP (class\fB On4Clicks\fP)"
.TP
.B "on5Clicks\fP (class\fB On5Clicks\fP)"
Specify selection behavior in response to multiple mouse clicks.
A single mouse click is always interpreted as described in
the \fBSelection Functions\fP section (see \fBPOINTER USAGE\fP).
Multiple mouse clicks (using the button which activates the \fBselect-start\fP
action) are interpreted according to the resource values of
\fBon2Clicks\fP, etc.
The resource value can be one of these:
.RS
.TP 3
.B word
Select a \*(``word\*('' as determined by the \fBcharClass\fP resource.
See the \fBCHARACTER CLASSES\fP section.
.TP
.B line
Select a line (counting wrapping).
.TP
.B group
Select a group of adjacent lines (counting wrapping).
The selection stops on a blank line,
and does not extend outside the current page.
.TP
.B page
Select all visible lines, i.e., the page.
.TP
.B all
.br
Select all lines, i.e., including the saved lines.
.TP
.B regex
Select the best match for the POSIX extended regular expression (ERE) which
follows in the resource value:
.RS
.bP
\fI\*N\fP matches the regular expression against a byte array
for the entire (possibly wrapped) line.
That byte array may be UTF-8 or ISO-8859-1,
depending on the mode in which \fI\*n\fP is running.
.bP
\fI\*N\fP steps through each byte-offset in this array,
keeping track of the best (longest) match.
If more than one match ties for the longest length, the first is used.
.IP
\fI\*N\fP does this to make it convenient to click anywhere in the area of
interest and cause the regular expression to match the entire word, etc.
.bP
The \*(``^\*('' and \*(``$\*('' anchors in a regular expression
denote the ends of the entire line.
.bP
If the regular expression contains backslashes \*(``\\\*('' those
should be escaped \*(``\\\\\*('' 
because the X libraries interpret backslashes in resource strings.
.RE
.TP
.B none
No selection action is associated with this resource.
\fI\*N\fP interprets it as the end of the list.
For example, you may use it to disable triple (and higher) clicking
by setting \fBon3Clicks\fP to \*(``none\*(''.
.RE
.IP
The default values for \fBon2Clicks\fP and \fBon3Clicks\fP are
\*(``word\*('' and \*(``line\*('', respectively.
There is no default value for \fBon4Clicks\fP or \fBon5Clicks\fP,
making those inactive.
On startup, \fI\*n\fP determines the maximum number of clicks
by the \fBon\fP\fIX\fP\fBClicks\fP resource values which are set.
.TP 8
.B "openIm\fP (class\fB OpenIm\fP)"
Tells \fI\*n\fP whether to open the input method at startup.
The default is \*(``true\*(''.
.TP 8
.B "pointerColor\fP (class\fB PointerColor\fP)"
Specifies the foreground color of the pointer.
The default is
\*(``XtDefaultForeground\*(''.
.TP 8
.B "pointerColorBackground\fP (class\fB PointerColorBackground\fP)"
Specifies the background color of the pointer.
The default is
\*(``XtDefaultBackground\*(''.
.TP 8
.B "pointerMode\fP (class\fB PointerMode\fP)"
Specifies when the pointer may be hidden as the user types.
It will be redisplayed if the user moves the mouse,
or clicks one of its buttons.
.RS
.TP 3
0
never
.TP 3
1
the application running in \fI\*n\fP has not activated mouse mode.
This is the default.
.TP 3
2
always.
.RE
.TP 8
.B "pointerShape\fP (class\fB Cursor\fP)"
Specifies the name of the shape of the pointer.
The default is \*(``xterm\*(''.
.TP 8
.B "popOnBell\fP (class\fB PopOnBell\fP)"
Specifies whether the window would be raised when Control-G is received.
The default is \*(``false\*(''.
.IP
If the window is iconified, this has no effect.
However, the \fBzIconBeep\fP resource provides you with the ability to
see which iconified windows have sounded a bell.
.TP 8
.B "precompose\fP (class\fB Precompose\fP)"
Tells \fI\*n\fP whether to precompose UTF-8 data into Normalization Form C,
which combines commonly-used accents onto base characters.
If it does not do this, accents are left as separate characters.
The default is \*(``true\*(''.
.TP 8
.B "preeditType\fP (class\fB PreeditType\fP)"
Tells \fI\*n\fP which types of preedit (preconversion) string to display.
The default is \*(``OverTheSpot,Root\*(''.
.TP 8
.B "printAttributes\fP (class\fB PrintAttributes\fP)"
Specifies whether to print graphic attributes along with the text.
A real DEC VT\fIxxx\fP terminal will print the underline, highlighting codes
but your printer may not handle these.
.RS
.bP
\*(``0\*('' disables the attributes.
.bP
\*(``1\*('' prints the normal set of attributes
(bold, underline, inverse and blink) as VT100-style control sequences.
.bP
\*(``2\*('' prints ANSI color attributes as well.
.RE
.IP
The default is \*(``1\*(''.
.TP 8
.B "printFileImmediate\fP (class \fBPrintFileImmediate\fP)"
When the \fBprint-immediate\fP action is invoked,
\fI\*n\fP prints the screen contents directly to a file.
Set this resource to the prefix of the filename
(a timestamp will be appended to the actual name).
.IP
The default is an empty string, i.e., \*(``\*('',
However, when the \fBprint-immediate\fP action is invoked,
if the string is empty, then \*(``__default_class__\*('' is used.
.TP 8
.B "printFileOnXError\fP (class \fBPrintFileOnXError\fP)"
If \fI\*n\fP exits with an X error,
e.g., your connection is broken when the server crashes,
it can be told to write the contents of the screen to a file.
To enable the feature, set this resource to the prefix of the filename
(a timestamp will be appended to the actual name).
.IP
The default is an empty string, i.e., \*(``\*('',
which disables this feature.
However, when the \fBprint-on-error\fP action is invoked,
if the string is empty, then \*(``XTermError\*('' is used.
.IP
These error codes are handled:
ERROR_XERROR,
ERROR_XIOERROR and
ERROR_ICEERROR.
.TP 8
.B "printModeImmediate\fP (class \fBPrintModeImmediate\fP)"
When the \fBprint-immediate\fP action is invoked,
\fI\*n\fP prints the screen contents directly to a file.
You can use the \fBprintModeImmediate\fP resource to tell it to
use escape sequences to reconstruct the video attributes and colors.
This uses the same values as the \fBprintAttributes\fP resource.
The default is \*(``0\*(''.
.TP 8
.B "printModeOnXError\fP (class \fBPrintModeOnXError\fP)"
\fI\*N\fP implements the \fBprintFileOnXError\fP feature using
the printer feature, although the output is written directly to a file.
You can use the \fBprintModeOnXError\fP resource to tell it to
use escape sequences to reconstruct the video attributes and colors.
This uses the same values as the \fBprintAttributes\fP resource.
The default is \*(``0\*(''.
.TP 8
.B "printOptsImmediate\fP (class \fBPrintOptsImmediate\fP)"
Specify the range of text which is printed to a file when
the \fBprint-immediate\fP action is invoked.
.RS
.bP
If zero (0), then this selects the current (visible screen) plus the
saved lines, except if the alternate screen is being used.
In that case, only the alternate screen is selected.
.bP
If nonzero,
the bits of this resource value (checked in descending order)
select the range:
.RS
.TP 3
8
selects the saved lines.
.TP 3
4
selects the alternate screen.
.TP 3
2
selects the normal screen.
.TP 3
1
selects the current screen,
which can be either the normal or alternate screen.
.RE
.RE
.IP
The default is \*(``9\*('', which selects the current visible screen
plus saved lines, with no special case for the alternated screen.
.TP 8
.B "printOptsOnXError\fP (class \fBPrintOptsOnXError\fP)"
Specify the range of text which is printed to a file when
the \fBprint-on-error\fP action is invoked.
The resource value is interpreted the same as in \fBprintOptsImmediate\fP.
.IP
The default is \*(``9\*('', which selects the current visible screen
plus saved lines, with no special case for the alternated screen.
.TP 8
.B "printerAutoClose\fP (class\fB PrinterAutoClose\fP)"
If \*(``true\*('', \fI\*n\fR will close the printer (a pipe) when the
application switches the printer offline with a Media Copy command.
The default is \*(``false\*(''.
.TP 8
.B "printerCommand\fP (class\fB PrinterCommand\fP)"
Specifies a shell command to which \fI\*n\fP will open a pipe when the first
MC (Media Copy) command is initiated.
The default is an empty string, i.e., \*(``\*(''.
If the resource value is given as an empty string, the printer is disabled.
.TP 8
.B "printerControlMode\fP (class\fB PrinterControlMode\fP)"
Specifies the printer control mode.
A \*(``1\*('' selects autoprint mode,
which causes \fI\*n\fP to print a line from the screen
when
.RS
.bP
you move the cursor off that
line with a line feed, form feed or vertical tab character, or
.bP
an autowrap occurs.
.RE
.IP
Autoprint mode is overridden by printer controller mode (a \*(``2\*(''),
which causes all of the output to be directed to the printer.
The default is \*(``0\*(''.
.TP 8
.B "printerExtent\fP (class\fB PrinterExtent\fP)"
Controls whether a print page function will print the entire page (true), or
only the portion within the scrolling margins (false).
The default is \*(``false\*(''.
.TP 8
.B "printerFormFeed\fP (class\fB PrinterFormFeed\fP)"
Controls whether a form feed is sent to the printer at the end of a print
page function.
The default is \*(``false\*(''.
.TP 8
.B "printerNewLine\fP (class\fB PrinterNewLine\fP)"
Controls whether a newline is sent to the printer at the end of a print
page function.
The default is \*(``true\*(''.
.TP 8
.B "privateColorRegisters\fP (class\fB PrivateColorRegisters\fP)"
If \fI\*n\fR is configured to support ReGIS or SIXEL graphics,
this controls whether \fI\*n\fR
allocates separate color registers for each sixel
device control string, e.g., for DECGCI.
If not true, color registers are allocated only once,
when the terminal is reset,
and color changes  in  any  graphic  affect all graphics.
The default is \*(``true\*(''.
.TP 8
.B "quietGrab\fP (class\fB QuietGrab\fP)"
Controls whether the cursor is repainted
when \fINotifyGrab\fP and \fINotifyUngrab\fP
event types are received during change of focus.
The default is \*(``false\*(''.
.TP 8
.B "regisDefaultFont\fP (class\fB RegisDefaultFont\fP)"
If \fI\*n\fR is configured to support ReGIS graphics,
this resource tells \fI\*n\fR which font to use if the ReGIS data does
not specify one.
No default value is specified;
\fI\*n\fR accepts a TrueType font specification
as in the \fBfaceName\fP resource.
.IP
If no value is specified,
\fI\*n\fR draws a bitmap indicating a missing character.
.TP 8
.B "regisScreenSize\fP (class\fB RegisScreenSize\fP)"
If \fI\*n\fR is configured to support ReGIS graphics,
this resource tells \fI\*n\fR the default size (in pixels) for these graphics,
which also sets the default coordinate space
to [0,0] (upper-left) and [\fIwidth\fP,\fIheight\fP] (lower-right).
.IP
The application using ReGIS may use the \*(``A\*('' option of
the \*(``S\*('' command to adjust the coordinate space or change the
addressable portion of the screen.
.IP
The default is \*(``1000x1000\*('' (given as \fIwidth\fP by \fIheight\fP).
.IP
\fI\*N\fR accepts a special resource value \*(``auto\*('',
which tells \fI\*n\fR to use the \fBdecTerminalID\fP resource to
set the default size based on the hardware terminal's limits.
Those limits are the same as for the \fBmaxGraphicSize\fP resource.
.TP 8
.B "renderFont\fP (class\fB RenderFont\fP)"
If \fI\*n\fR is built with the Xft library,
this controls whether the \fBfaceName\fR resource is used.
The default is \*(``default\*(''.
.IP
The resource values are strings, evaluated as booleans after startup.
.RS
.TP 5
false
.br
disable the feature and use the normal (bitmap) font.
.TP 5
true
.br
startup using the TrueType font specified by the \fBfaceName\fP and
\fBfaceSize\fP resource settings.
If there is no value for \fBfaceName\fP, disable the feature and use
the normal (bitmap) font.
.IP
After startup, you can still switch to/from the bitmap font using the
\*(``TrueType Fonts\*('' menu entry.
.TP 5
default
.br
Enable the \*(``TrueType Fonts\*(''
menu entry to allow runtime switching to/from TrueType fonts.
The initial font used depends upon whether the \fBfaceName\fP resource is set:
.RS
.bP
If the \fBfaceName\fP resource is not set,
start by using the normal (bitmap) font.
\fI\*N\fP has a separate compiled-in value for \fBfaceName\fP
for this special case.
That is normally \*(``mono\*(''.
.bP
If the \fBfaceName\fP resource is set,
then start by using the TrueType font rather than the bitmap font.
.RE
.RE
.TP 8
.B "resizeGravity\fP (class\fB ResizeGravity\fP)"
Affects the behavior when the window is resized to be taller or shorter.
\fBNorthWest\fP
specifies that the top line of text on the screen stay fixed.
If the window is made shorter,
lines are dropped from the bottom; if the window is
made taller, blank lines are added at the bottom.
This is compatible with the behavior in X11R4.
\fBSouthWest\fP (the default) specifies that
the bottom line of text on the screen stay fixed.
If the window is
made taller, additional saved lines will be scrolled down onto the
screen; if the window is made shorter, lines will be scrolled off the
top of the screen, and the top saved lines will be dropped.
.TP 8
.B "retryInputMethod\fP (class\fB RetryInputMethod\fP)"
Tells \fI\*n\fP how many times to retry,
in case the input-method server is not responding.
This is a different issue than unsupported preedit type, etc.
You may encounter retries if your X configuration (and its libraries)
are missing pieces.
Setting this resource to zero \*(``0\*('' will cancel the retrying.
The default is \*(``3\*(''.
.TP 8
.B "reverseVideo\fP (class\fB ReverseVideo\fP)"
Specifies whether or not reverse video should be simulated.
The default is
\*(``false\*(''.
.IP
There are several aspects to reverse video in \fI\*n\fP:
.RS
.bP
The command-line \fB\-rv\fP option tells the X libraries to reverse
the foreground and background colors.
\fI\*N\fP's command-line options set resource values.
In particular, the X Toolkit sets the \fBreverseVideo\fP resource
when the \fB\-rv\fP option is used.
.bP
If the user has also used command-line options \fB\-fg\fP or \fB\-bg\fP
to set the foreground and background colors,
\fI\*n\fP does not see these options directly.
Instead,
it examines the resource values to reconstruct the command-line options,
and determine which of the colors is the user's intended foreground, etc.
Their actual values are irrelevant to the reverse video function;
some users prefer the X defaults (black text on a white background),
others prefer white text on a black background.
.bP
After startup,
the user can toggle the \*(``Enable Reverse Video\*('' menu entry.
This exchanges the current foreground and background colors
of the VT100 widget,
and repaints the screen.
Because of the X resource hierarchy,
the \fBreverseVideo\fP resource applies to more than the VT100 widget.
.RE
.IP
Programs running in an \fI\*n\fP can also use control sequences
to enable the VT100 reverse video mode.
These are independent of the \fBreverseVideo\fP resource and the menu entry.
\fI\*N\fP exchanges the current foreground and background colors
when drawing text affected by these control sequences.
.IP
Other control sequences can alter the foreground and background colors
which are used:
.RS
.bP
Programs can also use the ANSI color control sequences to set the
foreground and background colors.
.bP
Extensions to the ANSI color controls (such as 16-, 88- or 256-colors)
are treated similarly to the ANSI control.
.bP
Using other control sequences (the \*(``\fIdynamic colors\fR\*('' feature),
a program can change the foreground and background colors.
.RE
.TP 8
.B "reverseWrap\fP (class\fB ReverseWrap\fP)"
Specifies whether or not reverse-wraparound should be enabled.
This corresponds to \fI\*n\fP's private mode 45.
The default is
\*(``false\*(''.
.TP 8
.B "rightScrollBar\fP (class\fB RightScrollBar\fP)"
Specifies whether or not the scrollbar should be displayed on the right
rather than the left.
The default is \*(``false\*(''.
.TP 8
.B "saveLines\fP (class\fB SaveLines\fP)"
Specifies the number of lines to save beyond the top of the screen when a
scrollbar is turned on.
The default is \*(``64\*(''.
.TP 8
.B "scrollBar\fP (class\fB ScrollBar\fP)"
Specifies whether or not the scrollbar should be displayed.
The default is
\*(``false\*(''.
.TP 8
.B "scrollBarBorder\fP (class\fB ScrollBarBorder\fP)"
Specifies the width of the scrollbar border.
Note that this is drawn to overlap the border of the \fI\*n\fP window.
Modifying the scrollbar's border affects only the line between the VT100
widget and the scrollbar.
The default value is 1.
.TP 8
.B "scrollKey\fP (class\fB ScrollCond\fP)"
Specifies whether or not pressing a key should automatically cause the
scrollbar to go to the bottom of the scrolling region.
This corresponds to \fI\*n\fP's private mode 1011.
The default is
\*(``false\*(''.
.TP 8
.B "scrollLines\fP (class\fB ScrollLines\fP)"
Specifies the number of lines that the \fBscroll-back\fP and
\fBscroll-forw\fP actions should use as a default.
The default value is 1.
.TP 8
.B "scrollTtyOutput\fP (class\fB ScrollCond\fP)"
Specifies whether or not output to the terminal should automatically cause
the scrollbar to go to the bottom of the scrolling region.
The default is \*(``true\*(''.
.TP
.B "selectToClipboard\fP (class\fB SelectToClipboard\fP)"
Tells \fI\*n\fP whether to use the \fBPRIMARY\fP or \fBCLIPBOARD\fP for
\fBSELECT\fP tokens in the selection mechanism.
The \fBset-select\fP action can change this at runtime,
allowing the user to work with programs that handle only one of these
mechanisms.
The default is \*(``false\*('', which tells it to use \fBPRIMARY\fP.
.TP 8
.B "shiftFonts\fP (class\fB ShiftFonts\fP)"
Specifies whether to enable the actions
\fBlarger-vt-font()\fP and
\fBsmaller-vt-font()\fP, which are normally bound to
the shifted KP_Add and KP_Subtract.
The default is \*(``true\*(''.
.TP 8
.B "showBlinkAsBold\fP (class\fB ShowBlinkAsBold\fP)"
Tells \fI\*n\fP whether to display text with blink-attribute the same
as bold.
If \fI\*n\fP has not been configured to support blinking text,
the default is \*(``true\*('', which corresponds to older versions of \fI\*n\fP,
otherwise the default is \*(``false\*(''.
.TP 8
.B "showMissingGlyphs\fP (class\fB ShowMissingGlyphs\fP)"
Tells \fI\*n\fP whether to display a box outlining places where
a character has been used that the font does not represent.
The default is \*(``false\*(''.
.TP 8
.B "showWrapMarks\fP (class\fB ShowWrapMarks\fP)"
For debugging \fI\*n\fP and applications that may manipulate the
wrapped-line flag by writing text at the right margin,
show a mark on the right inner-border of the window.
The mark shows which lines have the flag set.
.TP 8
.B "signalInhibit\fP (class\fB SignalInhibit\fP)"
Specifies whether or not the entries in the \fBMain Options\fP menu for sending
signals to \fI\*n\fP should be disallowed.
The default is \*(``false\*(''.
.TP 8
.B "sixelScrolling\fP (class\fB SixelScrolling\fP)"
If \fI\*n\fR is configured to support SIXEL graphics,
this resource tells it whether to
scroll up one line at a time when sixels would be written
past the bottom line on the window.
The default is \*(``false\*(''.
.TP 8
.B "sixelScrollsRight\fP (class\fB SixelScrollsRight\fP)"
If \fI\*n\fR is configured to support SIXEL graphics,
this resource tells it whether to
scroll to the right as needed to keep the current position visible
rather than truncate the plot on the on the right.
The default is \*(``false\*(''.
.TP 8
.B "tekGeometry\fP (class\fB Geometry\fP)"
Specifies the preferred size and position of the Tektronix window.
There is no default for this resource.
.TP 8
.B "tekInhibit\fP (class\fB TekInhibit\fP)"
Specifies whether or not
the escape sequence to enter
Tektronix mode should be ignored.
The default is
\*(``false\*(''.
.TP 8
.B "tekSmall\fP (class\fB TekSmall\fP)"
Specifies whether or not the Tektronix mode window should start in its smallest
size if no explicit geometry is given.
This is useful when running \fI\*n\fP
on displays with small screens.
The default is \*(``false\*(''.
.TP 8
.B "tekStartup\fP (class\fB TekStartup\fP)"
Specifies whether or not \fI\*n\fP should start up in Tektronix mode.
The default is \*(``false\*(''.
.TP 8
.B "tiXtraScroll\fP (class\fB TiXtraScroll\fP)"
Specifies whether \fI\*n\fP should scroll to a new page when processing
the \fIti\fP termcap entry, i.e., the private modes 47, 1047 or 1049.
This is only in effect if \fBtiteInhibit\fP is \*(``true\*('',
because the intent of this option is to provide a picture of the full-screen
application's display on the scrollback without wiping out the text that
would be shown before the application was initialized.
The default for this resource is \*(``false\*(''.
.TP 8
.B "titeInhibit\fP (class\fB TiteInhibit\fP)"
Originally specified whether or not \fI\*n\fP
should remove \fIti\fP and \fIte\fP
termcap entries (used to switch between alternate screens on startup of many
screen-oriented programs) from the TERMCAP string.
.IP
TERMCAP is used rarely now,
but \fI\*n\fP supports the feature on modern systems:
.RS
.bP
If set,
\fI\*n\fP also ignores the escape sequence to switch to the
alternate screen.
.bP
\fI\*N\fP supports terminfo in a different way, supporting composite control
sequences (also known as private modes) 1047, 1048 and 1049 which have the same
effect as the original 47 control sequence.
.RE
.IP
The default for this resource is \*(``false\*(''.
.TP 8
.B "titleModes\fP (class\fB TitleModes\fP)"
Tells \fI\*n\fP whether to accept or return
window- and icon-labels in ISO-8859-1
(the default) or UTF-8.
Either can be encoded in hexadecimal:
.RS
.bP
UTF-8 titles require special treatment,
because they may contain bytes which can be mistaken for control characters.
Hexadecimal-encoding is supported to eliminate that possibility.
.bP
As an alternative, you could use the \fBallowC1Printable\fP resource,
which suppresses \fI\*n\fP's parsing of the relevant control characters
(and as a result, treats those bytes as data).
.RE
.IP
The default for this resource is \*(``0\*(''.
.IP
Each bit (bit \*(``0\*('' is 1, bit \*(``1\*('' is 2, etc.)
corresponds to one of the
parameters set by the title modes control sequence:
.RS
.TP 5
0
Set window/icon labels using hexadecimal
.TP 5
1
Query window/icon labels using hexadecimal
.TP 5
2
Set window/icon labels using UTF-8
(gives the same effect as the \fButf8Title\fP resource).
.TP 5
3
Query window/icon labels using UTF-8
.RE
.TP 8
.B "translations\fP (class\fB Translations\fP)"
Specifies the key and button bindings for menus, selections, \*(``programmed
strings\*('', etc.
The \fBtranslations\fP resource,
which provides much of \fI\*n\fP's configurability,
is a feature of the X Toolkit Intrinsics library (Xt).
See the \fBActions\fP section.
.TP 8
.B "trimSelection\fP (class\fB TrimSelection\fP)"
If you set \fBhighlightSelection\fP,
you can see the text which is selected, including any trailing spaces.
Clearing the screen (or a line) resets it to a state containing no spaces.
Some lines may contain trailing spaces when an application writes them to
the screen.
However, you may not wish to paste lines with trailing spaces.
If this resource is true, \fI\*n\fP will trim trailing spaces from
text which is selected.
It does not affect spaces which result in a wrapped line, nor will it
trim the trailing newline from your selection.
The default is \*(``false\*(''.
.TP 8
.B "underLine\fP (class\fB UnderLine\fP)"
This specifies whether or not text with the underline attribute should be
underlined.
It may be desirable to disable underlining when color is being
used for the underline attribute.
The default is \*(``true\*(''.
.TP 8
.B "useBorderClipping\fP (class\fB UseBorderClipping\fP)"
Tell \fI\*n\fP whether to apply clipping when \fBuseClipping\fP is false.
Unlike \fBuseClipping\fP, this simply limits text to keep it within the
window borders, e.g., as a refinement to the \fBscaleHeight\fP workaround.
The default is \*(``false\*(''.
.TP 8
.B "useClipping\fP (class\fB UseClipping\fP)"
Tell \fI\*n\fP whether to use clipping to keep
from producing dots outside the text drawing area.
Originally used to work around for overstriking effects,
this is also needed to work with some incorrectly-sized fonts.
The default is \*(``true\*(''.
.TP 8
.B "utf8\fP (class\fB Utf8\fP)"
This specifies whether \fI\*n\fP will run in UTF-8 mode.
If you set this resource, \fI\*n\fP also sets the \fBwideChars\fP resource
as a side-effect.
The resource can be set via the menu entry \*(``UTF-8 Encoding\*(''.
The default is \*(``default\*(''.
.IP
\fI\*N\fP accepts either a keyword (ignoring case)
or the number shown in parentheses:
.RS
.TP 3
false (0)
UTF-8 mode is initially off.
The command-line option \fB+u8\fP sets the resource to this value.
Escape sequences for turning UTF-8 mode on/off are allowed.
.TP
true (1)
UTF-8 mode is initially on.
Escape sequences for turning UTF-8 mode on/off are allowed.
.TP
always (2)
The command-line option \fB\-u8\fP sets the resource to this value.
Escape sequences for turning UTF-8 mode on/off are ignored.
.TP
default (3)
This is the default value of the resource.
It is changed during initialization depending on
whether the \fBlocale\fP resource was set,
to false (0) or always (2).
See the \fBlocale\fR resource for additional discussion of non-UTF-8 locales.
.RE
.IP
If you want to set the value of \fButf8\fP, it should be in this range.
Other nonzero values are treated the same as \*(``1\*('',
i.e., UTF-8 mode is initially on, and
escape sequences for turning UTF-8 mode on/off are allowed.
.TP 8
.B "utf8Fonts\fP (class\fB Utf8Fonts\fP)"
See the discussion of the \fBlocale\fP resource.
This specifies whether \fI\*n\fP will use UTF-8 fonts specified via
resource patterns such as \*(``\fB*vt100.utf8Fonts.font\fP\*(''
or normal (ISO-8859-1) fonts via patterns such as \*(``\fB*vt100.font\fP\*(''.
The resource can be set via the menu entry \*(``\fBUTF-8 Fonts\fP\*(''.
The default is \*(``default\*(''.
.IP
\fI\*N\fP accepts either a keyword (ignoring case)
or the number shown in parentheses:
.RS
.TP
false (0)
Use the ISO-8859-1 fonts.
The menu entry is enabled, allowing the choice of fonts to be changed
at runtime.
.TP
true (1)
Use the UTF-8 fonts.
The menu entry is enabled, allowing the choice of fonts to be changed
at runtime.
.TP
always (2)
Always use the UTF-8 fonts.
This also disables the menu entry.
.TP
default (3)
At startup, the resource is set to true or false,
according to the effective value of the \fButf8\fP resource.
.RE
.TP 8
.B "utf8Latin1\fP (class\fB Utf8Latin1\fP)"
If true,
allow an ISO-8859-1 \fInormal\fP
font to be combined with an ISO-10646-1 font if the latter is given
via the \fB\-fw\fP option or its corresponding resource value.
The default is \*(``false\*(''.
.TP 8
.B "utf8SelectTypes\fP (class\fB Utf8SelectTypes\fP)"
Override \fI\*n\fP's default selection target list
(see \fBSELECT/PASTE\fP) for selections in wide-character (UTF-8) mode.
The default is an empty string, i.e., \*(``\*('',
which does not override anything.
.TP 8
.B "utf8Title\fP (class\fB Utf8Title\fP)"
Applications can set \fI\*n\fP's title by writing a control sequence.
Normally this control sequence follows the VT220 convention,
which encodes the string in ISO-8859-1 and
allows for an 8-bit string terminator.
If \fI\*n\fP is started in a UTF-8 locale,
it translates the ISO-8859-1 string to UTF-8 to work with the X libraries
which assume the string is UTF-8.
.IP
However, some users may wish to write a title string encoded in UTF-8.
The window manager is responsible for drawing window titles.
Some window managers (not all) support UTF-8 encoding of window titles.
Set this resource to \*(``true\*('' to also set UTF-8 encoded title strings
using the EWMH properties.
.IP
This feature is available as a menu entry, since it is related to
the particular applications you are running within \fI\*n\fP.
You can also use a control sequence
(see the discussion of \*(``Title Modes\*(''
in \fI\*N Control Sequences\fP), to set an equivalent flag
(which can also be set using the \fBtitleModes\fP resource).
.IP
\fI\*N\fP accepts either a keyword (ignoring case)
or the number shown in parentheses:
.RS
.TP
false (0)
Set only ISO-8859-1 title strings, e.g.,
using the ICCCM \fBWM_NAME\fP STRING property.
The menu entry is enabled, allowing the choice of title-strings to be changed
at runtime.
.TP
true (1)
Set both the EWMH (UTF-8 strings) and the ICCCM \fBWM_NAME\fP, etc.
The menu entry is enabled, allowing the choice to be changed at runtime.
.TP
always (2)
Always set both the EWMH (UTF-8 strings) and the ICCCM \fBWM_NAME\fP, etc.
This also disables the menu entry.
.TP
default (3)
At startup, the resource is set to true or false,
according to the effective value of the \fButf8\fP resource.
.RE
.IP
The default is \*(``default\*(''.
.TP 8
.B "veryBoldColors\fP (class\fB VeryBoldColors\fP)"
Specifies whether to combine video attributes with colors specified by
\fBcolorBD\fR,
\fBcolorBL\fR,
\fBcolorIT\fR,
\fBcolorRV\fR, and
\fBcolorUL\fR.
The resource value is the sum of values for each attribute:
.RS 10
.nf
1 for reverse,
2 for underline,
4 for bold,
8 for blink, and
512 for italic
.fi
.RE
.IP
The default is \*(``0\*(''.
.TP 8
.B "visualBell\fP (class\fB VisualBell\fP)"
Specifies whether or not a visible bell (i.e., flashing) should be used instead
of an audible bell when Control-G is received.
The default is \*(``false\*('', which tells \fI\*n\fP to use an audible bell.
.TP 8
.B "visualBellDelay\fP (class\fB VisualBellDelay\fP)"
Number of milliseconds to delay when displaying a visual bell.
Default is 100.
If set to zero, no visual bell is displayed.
This is useful for very slow displays, e.g., an LCD display on a laptop.
.TP 8
.B "visualBellLine\fP (class\fB VisualBellLine\fP)"
Specifies whether to flash only the current line when displaying a visual bell
rather than flashing the entire screen:
The default is \*(``false\*('',
which tells \fI\*n\fP to flash the entire screen.
.TP 8
.B "vt100Graphics\fP (class\fB VT100Graphics\fP)"
This specifies whether \fI\*n\fP will interpret VT100 graphic character
escape sequences while in UTF-8 mode.
The default is \*(``true\*('',
to provide support for various legacy applications.
.TP 8
.B "wideBoldFont\fP (class\fB WideBoldFont\fP)"
This option specifies the font to be used for displaying bold wide text.
By default,
it will attempt to use a font twice as wide as the font that will be used to
draw bold text.
If no double-width font is found, it will improvise, by stretching
the bold font.
.TP 8
.B "wideChars\fP (class\fB WideChars\fP)"
Specifies if \fI\*n\fP should respond to control sequences that
process 16-bit characters.
The default is \*(``false\*(''.
.TP 8
.B "wideFont\fP (class\fB WideFont\fP)"
This option specifies the font to be used for displaying wide text.
By default,
it will attempt to use a font twice as wide as the font that will be used to
draw normal text.
If no double-width font is found, it will improvise, by stretching
the normal font.
.TP 8
.B "ximFont\fP (class\fB XimFont\fP)"
This option specifies the font to be used for displaying the preedit string
in the \*(``OverTheSpot\*('' input method.
.IP
In \*(``OverTheSpot\*('' preedit type, the preedit (preconversion)
string is displayed at the position of the cursor.
It is the XIM server's responsibility to display the preedit string.
The XIM client must inform the XIM server of the cursor position.
For best results, the preedit string must be displayed with a proper font.
Therefore, \fI\*n\fP informs the XIM server of the proper font.
The font is be supplied by a "fontset", whose default value is \*(``*\*(''.
This matches every font, the X library automatically chooses fonts with
proper charsets.
The \fBximFont\fP resource is provided to override this default font setting.
.\"
.SS Tek4014 Widget Resources
.PP
The following resources are specified
as part of the \fItek4014\fP widget (class \fITek4014\fP).
These are specified by patterns
such as \*(``\fB__default_class__.tek4014.\fP\fINAME\fP\*('':
.TP 8
.B "font2\fP (class\fB Font\fP)"
Specifies font number 2 to use in the Tektronix window.
.TP 8
.B "font3\fP (class\fB Font\fP)"
Specifies font number 3 to use in the Tektronix window.
.TP 8
.B "fontLarge\fP (class\fB Font\fP)"
Specifies the large font to use in the Tektronix window.
.TP 8
.B "fontSmall\fP (class\fB Font\fP)"
Specifies the small font to use in the Tektronix window.
.TP 8
.B "ginTerminator\fP (class\fB GinTerminator\fP)"
Specifies what character(s) should follow a GIN report or status report.
The possibilities are \*(``none\*('', which sends no terminating characters,
\*(``CRonly\*('',
which sends CR, and
\*(``CR&EOT\*('',
which sends both CR and EOT.
The default is \*(``none\*(''.
.TP 8
.B "height\fP (class\fB Height\fP)"
Specifies the height of the Tektronix window in pixels.
.TP 8
.B "initialFont\fP (class\fB InitialFont\fP)"
Specifies which of the four Tektronix fonts to use initially.
Values are the same as for the \fBset-tek-text\fP action.
The default is \*(``large\*(''.
.TP 8
.B "width\fP (class\fB Width\fP)"
Specifies the width of the Tektronix window in pixels.
.\"
.SS Menu Resources
.PP
The resources that may be specified for the various menus are described in
the documentation for the Athena \fBSimpleMenu\fP widget.
The name and classes of the entries in each of the menus are listed below.
Resources named \*(``\fBline\fR\fIN\fR\*('' where \fIN\fR is a number
are separators with class \fBSmeLine\fR.
.PP
As with all X resource-based widgets,
the labels mentioned are customary defaults for the application.
.
.PP
The \fBMain Options\fP menu (widget name \fImainMenu\fP)
has the following entries:
.TP 8
.B "toolbar\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-toolbar(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "securekbd\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBsecure()\fP action.
.TP 8
.B "allowsends\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBallow-send-events(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "redraw\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBredraw()\fP action.
.TP 8
.B "logging\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBlogging(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "print-immediate\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBprint-immediate()\fP action.
.TP 8
.B "print-on-error\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBprint-on-error()\fP action.
.TP 8
.B "print\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBprint()\fP action.
.TP 8
.B "print-redir\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBprint-redir()\fP action.
.TP 8
.B "dump-html\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBdump-html()\fP action.
.TP 8
.B "dump-svg\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBdump-svg()\fP action.
.TP 8
.B "8-bit-control\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-8-bit-control(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "backarrow\ key\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-backarrow(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "num-lock\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-num-lock(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "alt-esc\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBalt-sends-escape(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "meta-esc\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBmeta-sends-escape(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "delete-is-del\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBdelete-is-del(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "oldFunctionKeys\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-old-function-keys(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "hpFunctionKeys\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-hp-function-keys(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "scoFunctionKeys\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-sco-function-keys(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "sunFunctionKeys\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-sun-function-keys(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "sunKeyboard\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBsunKeyboard(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "suspend\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBsend-signal(\fP\fItstp\fP\fB)\fP action
on systems that support job control.
.TP 8
.B "continue\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBsend-signal(\fP\fIcont\fP\fB)\fP action
on systems that support job control.
.TP 8
.B "interrupt\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBsend-signal(\fP\fIint\fP\fB)\fP action.
.TP 8
.B "hangup\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBsend-signal(\fP\fIhup\fP\fB)\fP action.
.TP 8
.B "terminate\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBsend-signal(\fP\fIterm\fP\fB)\fP action.
.TP 8
.B "kill\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBsend-signal(\fP\fIkill\fP\fB)\fP action.
.TP 8
.B "quit\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBquit()\fP action.
.
.PP
The \fBVT Options\fP menu (widget name \fIvtMenu\fP)
has the following entries:
.TP 8
.B "scrollbar\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-scrollbar(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "jumpscroll\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-jumpscroll(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "reversevideo\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-reverse-video(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "autowrap\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-autowrap(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "reversewrap\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-reversewrap(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "autolinefeed\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-autolinefeed(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "appcursor\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-appcursor(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "appkeypad\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-appkeypad(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "scrollkey\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-scroll-on-key(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "scrollttyoutput\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-scroll-on-tty-output(\fP\fItoggle\fP\fB)\fP
action.
.TP 8
.B "allow132\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-allow132(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "cursesemul\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-cursesemul(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "keepSelection\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-keep-selection(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "selectToClipboard\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-keep-clipboard(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "visualbell\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-visual-bell(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "bellIsUrgent\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-bellIsUrgent(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "poponbell\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-pop-on-bell(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "cursorblink\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-cursorblink(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "titeInhibit\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-titeInhibit(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "activeicon\fP (class\fB SmeBSB\fP)"
This entry toggles active icons on and off if this feature was
compiled into \fI\*n\fP.
It is enabled only if \fI\*n\fP
was started with the command line option +ai or the \fBactiveIcon\fP
resource is set to \*(``true\*(''.
.TP 8
.B "softreset\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBsoft-reset()\fP action.
.TP 8
.B "hardreset\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBhard-reset()\fP action.
.TP 8
.B "clearsavedlines\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBclear-saved-lines()\fP action.
.TP 8
.B "tekshow\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-visibility(\fP\fItek,toggle\fP\fB)\fP action.
.TP 8
.B "tekmode\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-terminal-type(\fP\fItek\fP\fB)\fP action.
.TP 8
.B "vthide\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-visibility(\fP\fIvt,off\fP\fB)\fP action.
.TP 8
.B "altscreen\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-altscreen(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "sixelScrolling\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-sixel-scrolling(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "privateColorRegisters\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-private-colors(\fP\fItoggle\fP\fB)\fP action.
.
.PP
The \fBVT Fonts\fP menu (widget name \fIfontMenu\fP)
has the following entries:
.TP 8
.B "fontdefault\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-vt-font(\fP\fId\fP\fB)\fP action,
setting the font using the \fBfont\fP (default) resource,
e.g., \*(``Default\*('' in the menu.
.TP 8
.B "font1\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-vt-font(\fP\fI1\fP\fB)\fP action,
setting the font using the \fBfont1\fP resource,
e.g., \*(``Unreadable\*('' in the menu.
.TP 8
.B "font2\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-vt-font(\fP\fI2\fP\fB)\fP action,
setting the font using the \fBfont2\fP resource,
e.g., \*(``Tiny\*('' in the menu.
.TP 8
.B "font3\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-vt-font(\fP\fI3\fP\fB)\fP action,
setting the font using the \fBfont3\fP resource,
e.g., \*(``Small\*('' in the menu.
.TP 8
.B "font4\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-vt-font(\fP\fI4\fP\fB)\fP action,
letting the font using the \fBfont4\fP resource,
e.g., \*(``Medium\*('' in the menu.
.TP 8
.B "font5\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-vt-font(\fP\fI5\fP\fB)\fP action,
letting the font using the \fBfont5\fP resource,
e.g., \*(``Large\*('' in the menu.
.TP 8
.B "font6\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-vt-font(\fP\fI6\fP\fB)\fP action,
letting the font using the \fBfont6\fP resource,
e.g., \*(``Huge\*('' in the menu.
.TP 8
.B "fontescape\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-vt-font(\fP\fIe\fP\fB)\fP action.
.TP 8
.B "fontsel\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-vt-font(\fP\fIs\fP\fB)\fP action.
.TP 8
.B "allow-bold-fonts\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBallow-bold-fonts(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "font-linedrawing\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-font-linedrawing(\fP\fIs\fP\fB)\fP action.
.TP 8
.B "font-packed\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-font-packed(\fP\fIs\fP\fB)\fP action.
.TP 8
.B "font-doublesize\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-font-doublesize(\fP\fIs\fP\fB)\fP action.
.TP 8
.B "render-font\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-render-font(\fP\fIs\fP\fB)\fP action.
.TP 8
.B "utf8-fonts\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-utf8-fonts(\fP\fIs\fP\fB)\fP action.
.TP 8
.B "utf8-mode\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-utf8-mode(\fP\fIs\fP\fB)\fP action.
.TP 8
.B "utf8-title\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-utf8-title(\fP\fIs\fP\fB)\fP action.
.TP 8
.B "allow-color-ops\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBallow-color-ops(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "allow-font-ops\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBallow-fonts-ops(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "allow-tcap-ops\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBallow-tcap-ops(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "allow-title-ops\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBallow-title-ops(\fP\fItoggle\fP\fB)\fP action.
.TP 8
.B "allow-window-ops\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBallow-window-ops(\fP\fItoggle\fP\fB)\fP action.
.
.PP
The \fBTek Options\fP menu (widget name \fItekMenu\fP)
has the following entries:
.TP 8
.B "tektextlarge\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-tek-text(\fP\fIlarge\fP\fB)\fP action.
.TP 8
.B "tektext2\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-tek-text(\fP\fI2\fP\fB)\fP action.
.TP 8
.B "tektext3\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-tek-text(\fP\fI3\fP\fB)\fP action.
.TP 8
.B "tektextsmall\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-tek-text(\fP\fIsmall\fP\fB)\fP action.
.TP 8
.B "tekpage\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBtek-page()\fP action.
.TP 8
.B "tekreset\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBtek-reset()\fP action.
.TP 8
.B "tekcopy\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBtek-copy()\fP action.
.TP 8
.B "vtshow\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-visibility(\fP\fIvt,toggle\fP\fB)\fP action.
.TP 8
.B "vtmode\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-terminal-type(\fP\fIvt\fP\fB)\fP action.
.TP 8
.B "tekhide\fP (class\fB SmeBSB\fP)"
This entry invokes the \fBset-visibility(\fP\fItek,toggle\fP\fB)\fP action.
.\"
.SS Scrollbar Resources
.PP
The following resources are useful when specified for the Athena Scrollbar
widget:
.TP 8
.B "thickness\fP (class\fB Thickness\fP)"
Specifies the width in pixels of the scrollbar.
.TP 8
.B "background\fP (class\fB Background\fP)"
Specifies the color to use for the background of the scrollbar.
.TP 8
.B "foreground\fP (class\fB Foreground\fP)"
Specifies the color to use for the foreground of the scrollbar.
The \*(``thumb\*(''
of the scrollbar is a simple checkerboard pattern alternating pixels for
foreground and background color.
.
.
.SH "POINTER USAGE"
.
.PP
Once the VT\fIxxx\fP window is created,
\fI\*n\fP allows you to select text and copy it within the same or other windows
using the \fIpointer\fP or the keyboard.
.
.PP
A \*(``pointer\*('' could be a mouse, touchpad or similar device.
X applications generally do not care,
since they see only \fIbutton events\fP which have
.bP
position and
.bP
button up/down state
.PP
\fI\*N\fP can see these events as long as it has \fIfocus\fP.
.PP
The keyboard also supplies events, but it is less flexible than
the pointer for selecting/copying text.
.PP
\fIEvents\fP are applied to \fIactions\fP using the \fBtranslations\fP resource.
See \fBActions\fP for a complete list, and \fBDefault Key Bindings\fP
for the built-in set of \fBtranslations\fP resources.
.
.SS "Selection Functions"
.PP
The selection functions are invoked when the pointer buttons are used with no
modifiers, and when they are used with the \*(``shift\*('' key.
The assignment of the functions described below to keys and buttons may
be changed through the resource database; see \fBActions\fP below.
.
.TP 5
Pointer button one (usually left)
is used to save text into the cut buffer:
.NS
~Meta <Btn1Down>:\fBselect\-start\fP()
.NE
.IP
Move the cursor to beginning of the text,
and then hold the button down while moving the cursor to the end of the region
and releasing the button.
The selected text is highlighted and is saved in the global \fIcut buffer\fP
and made the selection when the button is released:
.NS
<BtnUp>:\fBselect\-end\fP(\fBSELECT\fP, \fBCUT_BUFFER0\fP) \en
.NE
.IP
Normally (but see the discussion of \fBon2Clicks\fP, etc):
.RS
.bP
Double-clicking selects by words.
.bP
Triple-clicking
selects by lines.
.bP
Quadruple-clicking goes back to characters, etc.
.RE
.IP
Multiple-click is determined by the time from button up to
button down, so you can change the selection unit in the middle of a selection.
Logical words and lines selected by double- or triple-clicking may wrap
across more than one screen line if lines were wrapped by \fI\*n\fP
itself rather than by the application running in the window.
If the key/button bindings specify that an X selection is to be made,
\fI\*n\fP will leave the selected text highlighted for as long as it
is the selection owner.
.
.TP 5
Pointer button two (usually middle)
\*(``types\*('' (\fIpastes\fP) the text from
the given selection, if any,
otherwise from the cut buffer, inserting it as keyboard input:
.NS
~Ctrl ~Meta <Btn2Up>:\fB\fBinsert\-selection\fP\fP(\fBSELECT\fP, \fBCUT_BUFFER0\fP)
.NE
.
.TP 5
Pointer button three (usually right)
\fIextends\fP the current selection.
.NS
~Ctrl ~Meta <Btn3Down>:\fB\fBstart\-extend\fP\fP()
.NE
.IP
(Without loss of generality,
you can swap \*(``right\*('' and \*(``left\*('' everywhere in the rest of this
paragraph.)  If pressed while closer to
the right edge of the selection than the left, it extends/contracts the
right edge of the selection.
If you contract the selection past
the left edge of the selection,
\fI\*n\fP assumes you really meant the left edge,
restores the original selection, then
extends/contracts the left edge of the selection.
Extension starts in the
selection unit mode
that the last selection or extension was performed in; you can multiple-click
to cycle through them.
.
.PP
By cutting and pasting pieces of text without trailing new lines,
you can take text from several places in different windows and form a command
to the shell, for example, or take output from a program and insert it into
your favorite editor.
Since cut buffers are globally shared among different applications,
you may regard each as a \*(``file\*('' whose contents you know.
The terminal emulator and other text programs should be treating it as if it
were a text file, i.e., the text is delimited by new lines.
.
.SS "Scrolling"
.PP
The scroll region displays the position and amount of text currently showing
in the window (highlighted) relative to the amount of text actually saved.
As more text is saved (up to the maximum), the size of the highlighted area
decreases.
.
.PP
Clicking button one with the pointer in the scroll region moves the
adjacent line to the top of the display window.
.
.PP
Clicking button three moves the top line of the display window down to the
pointer position.
.
.PP
Clicking button two moves the display to a position in the saved text
that corresponds to the pointer's position in the scrollbar.
.
.SS "Tektronix Pointer"
.PP
Unlike the VT\fIxxx\fP window,
the Tektronix window does not allow the copying of text.
It does allow Tektronix GIN mode, and in this mode
the cursor will change from an arrow to a cross.
Pressing any key will send that key and the current coordinate of the
cross cursor.
Pressing button one, two, or three
will return the letters \*(``l\*('', \*(``m\*('', and
\*(``r\*('', respectively.
If the \*(``shift\*('' key is pressed when a pointer button is pressed,
the corresponding upper case letter is sent.
To distinguish a pointer button from a key, the high bit of the character is
set (but this is bit is normally stripped unless the terminal mode is RAW;
see
.IR tty (4)
for details).
.
.
.SH SELECT/PASTE
X clients provide select and paste support by responding to requests conveyed
by the X server.
The X server holds data in \*(``atoms\*('' which correspond
to the different types of selection
(\fBPRIMARY\fP, \fBSECONDARY\fP, \fBCLIPBOARD\fP)
as well as the similar cut buffer mechanism
(\fBCUT_BUFFER0\fP to \fBCUT_BUFFER7\fP).
Those are documented in the ICCCM.
.PP
The ICCCM deals with the underlying mechanism for select/paste.
It does not mention \fIhighlighting\fP.
The \fIselection\fP is not the same as \fIhighlighting\fP.
\fI\*N\fP (like many applications) uses highlighting to show you
the currently selected text.
An X application may \fIown\fP a selection,
which allows it to be the source of data copied using a given selection atom
\fI\*N\fP may continue owning a selection after it stops highlighting
(see \fBkeepSelection\fP).
.SS PRIMARY
When configured to use the primary selection (the default),
\fI\*n\fP can provide the selection data in ways
which help to retain character
encoding information as it is pasted.
.PP
The \fBPRIMARY\fP token is a standard X feature, documented in the ICCCM
(\fIInter-Client Communication Conventions Manual\fR),
which states
.RS 3
.PP
The selection named by the atom \fBPRIMARY\fP is used for all commands
that take only a single argument and is the principal means of
communication between clients that use the selection mechanism.
.RE
.PP
A user \*(``selects\*('' text on \fI\*n\fP, which highlights the selected text.
A subsequent \*(``paste\*('' to another client forwards
a request to the client owning the selection.
If \fI\*n\fP owns the primary selection, it makes the data
available in the form of one or more \*(``selection targets\*(''.
If it does not own the primary selection,
e.g., if it has released it or another client has
asserted ownership, it relies on cut-buffers to pass the data.
But cut-buffers handle only ISO-8859-1 data
(officially \- some clients ignore the rules).
.
.SS CLIPBOARD
.PP
When configured to use the clipboard
(using the \fBselectToClipboard\fP resource),
the problem with persistence of ownership is bypassed.
Otherwise, there is no difference regarding the data which can be
passed via selection.
.PP
The \fBselectToClipboard\fP resource is a compromise,
allowing \fBCLIPBOARD\fP to be treated almost like \fBPRIMARY\fP,
unlike the ICCCM, which describes \fBCLIPBOARD\fP in different terms
than \fBPRIMARY\fP or \fBSECONDARY\fP.
Its lengthy explanation begins with the essential points:
.RS 3
.PP
The selection named by the atom CLIPBOARD is used to hold data
that is being transferred between clients, 
that is, data that usually is being cut and then pasted
or copied and then pasted.
Whenever a client wants to transfer data to the clipboard:
.bP
It should assert ownership of the CLIPBOARD.
.bP
If it succeeds in acquiring ownership,
it should be prepared to respond to a request for the contents of the CLIPBOARD
in the usual way (retaining the data to be able to return it).
The request may be generated by the clipboard client described below.
.RE
.SS SELECT
.PP
However, many applications use \fBCLIPBOARD\fP in imitation of other windowing
systems.
The \fBselectToClipboard\fP resource (and corresponding menu entry
\fBSelect to Clipboard\fP) introduce the \fBSELECT\fP token (known only
to \fI\*n\fP) which chooses between
the \fBPRIMARY\fP and \fBCLIPBOARD\fP tokens.
.PP
Without using this feature, one can use workarounds such as the
\fIxclip\fP program to show the contents of the X clipboard within an
\fI\*n\fP window.
.SS SECONDARY
.PP
This is used less often than \fBPRIMARY\fP or \fBCLIPBOARD\fP.
According to the ICCCM, it is used
.bP
As the second argument to commands taking two arguments 
(for example, \*(``exchange primary and secondary selections\*('')
.bP
As a means of obtaining data when there is a primary selection
and the user does not want to disturb it
.
.SS Selection Targets
The different types of data which are passed depend on what the receiving
client asks for.
These are termed \fIselection targets\fP.
.PP
When asking for the selection data,
\fI\*n\fP tries the following types in this order:
.RS 5
.TP 5
UTF8_STRING
This is an XFree86 extension, which denotes that the data is encoded in UTF-8.
When \fI\*n\fP is built with wide-character support,
it both accepts and provides this type.
.TP 5
TEXT
the text is in the encoding which corresponds to your current locale.
.TP 5
.\" see xc/doc/specs/CTEXT/ctext.tbl.ms
.\" (it says the data is stored as a type of ISO 2022)
COMPOUND_TEXT
this is a format for multiple character set data, such as multi-lingual text.
It can store UTF-8 data as a special case.
.TP 5
STRING
This is Latin 1 (ISO-8859-1) data.
.RE
.PP
The middle two (TEXT and COMPOUND_TEXT) are added if \fI\*n\fP
is configured with the \fBi18nSelections\fP resource set to \*(``true\*(''.
.PP
UTF8_STRING is preferred (therefore first in the list)
since \fI\*n\fP stores text as Unicode data when
running in wide-character mode, and no translation is needed.
On the other hand, TEXT and COMPOUND_TEXT may require translation.
If the translation is incomplete, they will insert X's \*(``defaultString\*(''
whose value cannot be set, and may simply be empty.
\fI\*N\fP's \fBdefaultString\fP resource specifies the string to
use for incomplete translations of the UTF8_STRING.
.PP
You can alter the types which \fI\*n\fP tries using the
\fBeightBitSelectTypes\fP or \fButf8SelectTypes\fP resources.
For instance, you might have some specific locale setting
which does not use UTF-8 encoding.
The resource value is a comma-separated list of the selection targets,
which consist of the names shown.
You can use the special name I18N
to denote the optional inclusion of TEXT and COMPOUND_TEXT.
The names are matched ignoring case, and can be abbreviated.
The default list can be expressed in several ways, e.g.,
.sp
.RS
.nf
UTF8_STRING,I18N,STRING
utf8,i18n,string
u,i,s
.fi
.RE
.
.SS Mouse Protocol
.PP
Applications can send escape sequences to \fI\*n\fP to cause it to send
escape sequences back to the computer when you press a pointer button,
or even (depending on which escape sequence) send escape sequences back
to the computer as you move the pointer.
.PP
These escape sequences and the responses, called the \fImouse protocol\fP,
are documented in \fIXTerm Control Sequences\fP.
They do not appear in the \fIactions\fP invoked by the \fBtranslations\fP
resource because the resource does not change while you run \fI\*n\fP,
whereas applications can change the mouse prototol
(i.e., enable, disable, use different modes).
.PP
However, the mouse protocol is interpreted within the \fIactions\fP
that are usually associated with the pointer buttons.
\fI\*N\fP ignores the mouse protocol in the \fBinsert-selection\fP action
if the shift-key is pressed at the same time.
It also modifies a few other actions if the shift-key is pressed,
e.g., suppressing the response with the pointer position,
though not eliminating changes to the selected text.
.
.SH MENUS
.
.PP
\fI\*N\fP has four menus, named
.IR mainMenu ,
.IR vtMenu ,
.IR fontMenu ,
and
.IR tekMenu .
Each menu pops up under the correct combinations of key and button presses.
Each menu is divided into sections, separated by a horizontal line.
Some menu entries correspond to modes that can be altered.
A check mark appears next to a mode that is currently active.
Selecting one of these modes toggles its state.
Other menu entries are commands;
selecting one of these performs the indicated function.
.PP
All of the menu entries correspond to X actions.
In the list below, the menu label is shown followed by the action's
name in parenthesis.
.
.\" ************************************************************************
.SS "Main Options"
.PP
The \fI\*n\fP \fImainMenu\fP pops up
when the \*(``control\*('' key and pointer button one are pressed in a window.
This menu contains items that apply to
both the VT\fIxxx\fP and Tektronix windows.
There are several sections:
.TP
Commands for managing X events:
.RS
.TP
.B Toolbar\fP (resource \fBtoolbar\fP)
Clicking on the \*(``Toolbar\*('' menu entry hides the toolbar if it is visible,
and shows it if it is not.
.TP
.B Secure Keyboard\fP (resource \fBsecurekbd\fP)
The \fBSecure Keyboard\fP
mode is helpful when typing in passwords or other sensitive data in an
unsecure environment
(see \fBSECURITY\fP below, but read the limitations carefully).
.TP
.B Allow SendEvents\fP (resource \fBallowsends\fP)
Specifies whether or not synthetic key and button events generated using
the X protocol SendEvent request should be interpreted or discarded.
This corresponds to the \fBallowSendEvents\fP resource.
.TP
.B Redraw Window\fP (resource \fBredraw\fP)
Forces the X display to repaint;
useful in some environments.
.RE
.TP
Commands for capturing output:
.RS
.TP
.B Log to File\fP (resource \fBlogging\fP)
Captures text sent to the screen in a log file,
as in the \fB\-l\fP logging option.
.TP
.B Print-All Immediately\fP (resource \fBprint-immediate\fP)
Invokes the \fBprint-immediate\fP action,
sending the text of the current window directly to a file,
as specified by the
\fBprintFileImmediate\fP,
\fBprintModeImmediate\fP and
\fBprintOptsImmediate\fP
resources.
.TP
.B Print-All on Error\fP (resource \fBprint-on-error\fP)
Invokes the \fBprint-on-error\fP action,
which toggles a flag telling \fI\*n\fP that if it exits with an X error,
to send the text of the current window directly to a file,
as specified by the
\fBprintFileOnXError\fP,
\fBprintModeOnXError\fP and
\fBprintOptsOnXError\fP
resources.
.TP
.B Print Window\fP (resource \fBprint\fP)
Sends the text of the current window to the program given in the
\fBprinterCommand\fP resource.
.TP
.B Redirect to Printer\fP (resource \fBprint-redir\fP)
This sets the \fBprinterControlMode\fR to 0 or 2.
You can use this to turn the printer on as if an application had sent
the appropriate control sequence.
It is also useful for switching the printer
off if an application turns it on without resetting the print control mode.
.TP
.B XHTML Screen Dump\fP (resource \fBdump-html\fP)
Available only when compiled with screen dump support.
Invokes the \fBdump-html\fP action.
This creates an XHTML file matching the contents of the current screen,
including the border, internal border, colors and most attributes: bold, italic,
underline, faint, strikeout, reverse; blink is rendered as white-on-red;
double underline is rendered the same as underline since
there is no portable equivalent
in CSS 2.2.
.IP
The font is whatever your browser uses for preformatted (<pre>)
elements.
The XHTML file references a cascading style sheet (CSS)
named \*(``\fBxterm.css\fP\*('' that you can create to select a font or
override properties.
.RS
.LP
The following CSS selectors are used with
the expected default behavior in the XHTML file:
.sp
\fI.ul\fP for underline,
.br
\fI.bd\fP for bold,
.br
\fI.it\fP for italic,
.br
\fI.st\fP for strikeout,
.br
\fI.lu\fP for strikeout combined with underline.
.LP
In addition you may use
.sp
\fI.ev\fP to affect even numbered lines and
.br
\fI.od\fP to affect odd numbered lines.
.RE
.IP
Attributes faint, reverse and blink are implemented as \fIstyle\fP attributes
setting color properties.
All colors are specified as RGB percentages
in order to support displays with 10 bits per RGB.
.IP
The name of the file will be
.NS
\fBxterm.\fIyyyy\fB\.\fIMM\fB\.\fIdd\fB.\fIhh\fB.\fImm\fB.\fIss\fR\.xhtml
.NE
.IP
where
.IR yyyy ,
.IR MM ,
.IR dd ,
.IR hh ,
.I mm
and
.I ss
are the year, month, day, hour, minute and second
when the screen dump was performed
(the file is created in the directory
\fI\*n\fP is started in, or the home directory for a login \fI\*n\fP).
.IP
The \fBdump-html\fP action can also be triggered using the Media Copy
control sequence CSI 1 0 i, for example from a shell script with
.NS
printf \*(AQ\\033[10i\*(AQ
.NE
.sp
Only the UTF-8 encoding is supported.
.TP
.B SVG Screen Dump\fP (resource \fBdump-svg\fP)
Available only when compiled with screen dump support.
Invokes the \fBdump-svg\fP action.
This creates a Scalable Vector Graphics (SVG) file matching
the contents of the current screen, including the border,
internal border, colors and most attributes: bold, italic,
underline, double underline, faint, strikeout, reverse;
blink is rendered as white-on-red.
The font is whatever your renderer uses for the \fImonospace\fP font-family.
All colors are specified as RGB percentages
in order to support displays with 10 bits per RGB.
.IP
The name of the file will be
.NS
\fBxterm.\fIyyyy\fB\.\fIMM\fB\.\fIdd\fB.\fIhh\fB.\fImm\fB.\fIss\fR\.svg
.NE
.IP
where
.IR yyyy ,
.IR MM ,
.IR dd ,
.IR hh ,
.I mm
and
.I ss
are the year, month, day, hour, minute and second
when the screen dump was performed
(the file is created in the directory
\fI\*n\fP is started in, or the home directory for a login \fI\*n\fP).
.IP
The \fBdump-svg\fP action can also be triggered using the Media Copy
control sequence CSI 1 1 i, for example from a shell script with
.NS
printf \*(AQ\\033[11i\*(AQ
.NE
.sp
Only the UTF-8 encoding is supported.
.RE
.TP
Modes for setting keyboard style:
.RS
.TP
.B 8-Bit Controls\fP (resource \fB8-bit-control\fP)
Enabled for VT220 emulation, this controls whether \fI\*n\fP will send
8-bit control sequences rather than using 7-bit (ASCII) controls,
e.g., sending a byte in the range 128\(en159 rather than the escape character
followed by a second byte.
\fI\*N\fP always interprets both 8-bit and 7-bit control sequences
(see \fI\*N Control Sequences\fP).
This corresponds to the \fBeightBitControl\fP resource.
.TP
.B Backarrow Key (BS/DEL)\fP (resource \fBbackarrow\ key\fP)
Modifies the behavior of the backarrow key, making it transmit
either a backspace (8)
or delete (127) character.
This corresponds to the \fBbackarrowKey\fP resource.
.TP
.B Alt/NumLock Modifiers\fP (resource \fBnum-lock\fP)
Controls the treatment of Alt- and NumLock-key modifiers.
This corresponds to the \fBnumLock\fP resource.
.TP
.B Meta Sends Escape\fP (resource \fBmeta-esc\fP)
Controls whether \fIMeta\fP keys are converted into a two-character
sequence with the character itself preceded by ESC.
This corresponds to the \fBmetaSendsEscape\fP resource.
.TP
.B Delete is DEL\fP (resource \fBdelete-is-del\fP)
Controls whether the Delete key on the editing keypad should send DEL (127)
or the VT220-style Remove escape sequence.
This corresponds to the \fBdeleteIsDEL\fP resource.
.TP
.B Old Function-Keys\fP (resource \fBoldFunctionKeys\fP)
.TP
.B HP Function-Keys\fP (resource \fBhpFunctionKeys\fP)
.TP
.B SCO Function-Keys\fP (resource \fBscoFunctionKeys\fP)
.TP
.B Sun Function-Keys\fP (resource \fBsunFunctionKeys\fP)
.TP
.B VT220 Keyboard\fP (resource \fBsunKeyboard\fP)
These act as a radio-button, selecting one style for the keyboard layout.
The layout corresponds to more than one resource setting:
\fBsunKeyboard\fP,
\fBsunFunctionKeys\fP,
\fBscoFunctionKeys\fP and
\fBhpFunctionKeys\fP.
.RE
.TP
Commands for process signalling:
.RS
.TP
.B Send STOP Signal\fP (resource \fBsuspend\fP)
.TP
.B Send CONT Signal\fP (resource \fBcontinue\fP)
.TP
.B Send INT Signal\fP (resource \fBinterrupt\fP)
.TP
.B Send HUP Signal\fP (resource \fBhangup\fP)
.TP
.B Send TERM Signal\fP (resource \fBterminate\fP)
.TP
.B Send KILL Signal\fP (resource \fBkill\fP)
These send the SIGTSTP, SIGCONT, SIGINT, SIGHUP, SIGTERM and SIGKILL
signals respectively, to
the process group of the process running under \fI\*n\fP (usually the shell).
The \fBSIGCONT\fP
function is especially useful if the user has accidentally typed CTRL-Z,
suspending the process.
.TP
.B Quit\fP (resource \fBquit\fP)
Stop processing X events except to support the \fB-hold\fP option,
and then send a SIGHUP signal to
the process group of the process running under \fI\*n\fP (usually the shell).
.RE
.PP
.
.\" ************************************************************************
.SS "VT Options"
.PP
The \fI\*n\fP \fIvtMenu\fP
sets various modes in the VT\fIxxx\fP emulation, and is popped up when the
\*(``control\*('' key and pointer button two
are pressed in the VT\fIxxx\fP window.
.TP
VT\fIxxx\fP Modes:
.RS
.
.TP
.B Enable Scrollbar\fP (resource \fBscrollbar\fP)
Enable (or disable) the scrollbar.
This corresponds to the \fB\-sb\fP option and the \fBscrollBar\fP resource.
.
.TP
.B Enable Jump Scroll\fP (resource \fBjumpscroll\fP)
Enable (or disable) jump scrolling.
This corresponds to the \fB\-j\fP option and the \fBjumpScroll\fP resource.
.
.TP
.B Enable Reverse Video\fP (resource \fBreversevideo\fP)
Enable (or disable) reverse-video.
This corresponds to the \fB\-rv\fP option and the \fBreverseVideo\fP resource.
.
.TP
.B Enable Auto Wraparound\fP (resource \fBautowrap\fP)
Enable (or disable) auto-wraparound.
This corresponds to the \fB\-aw\fP option and the \fBautoWrap\fP resource.
.
.TP
.B Enable Reverse Wraparound\fP (resource \fBreversewrap\fP)
Enable (or disable) reverse wraparound.
This corresponds to the \fB\-rw\fP option and the \fBreverseWrap\fP resource.
.
.TP
.B Enable Auto Linefeed\fP (resource \fBautolinefeed\fP)
Enable (or disable) auto-linefeed.
This is the VT102 NEL function,
which causes the emulator to emit a line feed after each carriage return.
There is no corresponding command-line option or resource setting.
.
.TP
.B Enable Application Cursor Keys\fP (resource \fBappcursor\fP)
Enable (or disable) application cursor keys.
This corresponds to the \fBappcursorDefault\fP resource.
There is no corresponding command-line option.
.
.TP
.B Enable Application Keypad\fP (resource \fBappkeypad\fP)
Enable (or disable) application keypad keys.
This corresponds to the \fBappkeypadDefault\fP resource.
There is no corresponding command-line option.
.
.TP
.B Scroll to Bottom on Key Press\fP (resource \fBscrollkey\fP)
Enable (or disable) scrolling to the bottom of the scrolling region
on a keypress.
This corresponds to the \fB\-sk\fP option and the \fBscrollKey\fP resource.
.IP
As a special case, the XON / XOFF keys (control/S and control/Q) are ignored.
.
.TP
.B Scroll to Bottom on Tty Output\fP (resource \fBscrollttyoutput\fP)
Enable (or disable) scrolling to the bottom of the scrolling region on
output to the terminal.
This corresponds to the \fB\-si\fP option and
the \fBscrollTtyOutput\fP resource.
.
.TP
.B Allow 80/132 Column Switching\fP (resource \fBallow132\fP)
Enable (or disable) switching between 80 and 132 columns.
This corresponds to the \fB\-132\fP option and the \fBc132\fP resource.
.
.TP
.B Keep Selection\fP (resource \fBkeepSelection\fP)
Tell \fI\*n\fP whether to disown the selection when it stops highlighting it,
e.g., when an application modifies the display so that it no longer matches
the text which has been highlighted.
As long as \fI\*n\fP continues to own the selection for a given atom,
it can provide the corresponding text to other clients which request
the selection using that atom.
.IP
This corresponds to the \fBkeepSelection\fP resource.
There is no corresponding command-line option.
.IP
Telling \fI\*n\fP to not disown the selection
does not prevent other applications from taking ownership of the selection.
When that happens, \fI\*n\fP receives notification that this has happened,
and removes its highlighting.
.IP
See \fBSELECT/PASTE\fP for more information.
.
.TP
.B Select to Clipboard\fP (resource \fBselectToClipboard\fP)
Tell \fI\*n\fP whether to use the \fBPRIMARY\fP or \fBCLIPBOARD\fP
for \fBSELECT\fP tokens in the \fBtranslations\fP resource which
maps keyboard and mouse actions to select/paste actions.
.IP
This corresponds to the \fBselectToClipboard\fP resource.
There is no corresponding command-line option.
.IP
The \fBkeepSelection\fP resource setting applies
to \fBCLIPBOARD\fP selections just as it does for \fBPRIMARY\fP selections.
However some window managers treat the clipboard specially.
For instance, XQuartz's synchronization between the OSX \fIpasteboard\fP
and the X11 \fIclipboard\fP causes applications
to lose the selection ownership
for that atom when a selection is copied to the clipboard.
.IP
See \fBSELECT/PASTE\fP for more information.
.
.TP
.B Enable Visual Bell\fP (resource \fBvisualbell\fP)
Enable (or disable) visible bell (i.e., flashing) instead of an audible bell.
This corresponds to the \fB\-vb\fP option and the \fBvisualBell\fP resource.
.
.TP
.B Enable Bell Urgency\fP (resource \fBbellIsUrgent\fP)
Enable (or disable) Urgency window manager hint when Control-G is received.
This corresponds to the \fBbellIsUrgent\fP resource.
.
.TP
.B Enable Pop on Bell\fP (resource \fBpoponbell\fP)
Enable (or disable) raising of the window when Control-G is received.
This corresponds to the \fB\-pop\fP option and the \fBpopOnBell\fP resource.
.
.TP
.B Enable Blinking Cursor\fP (resource \fBcursorblink\fP)
Enable (or disable) the blinking-cursor feature.
This corresponds to the \fB\-bc\fP option and the \fBcursorBlink\fP resource.
There are also escape sequences
(see \fI\*N Control Sequences\fP):
.RS
.bP
If the \fBcursorBlinkXOR\fP resource is set,
the menu entry and the escape sequence states will be XOR'd:
if both are enabled, the cursor will not blink,
if only one is enabled, the cursor will blink.
.bP
If the \fBcursorBlinkXOR\fP is not set;
if either the menu entry or the escape sequence states are set,
the cursor will blink.
.RE
.IP
In either case, the checkbox for the menu shows the state of the
\fBcursorBlink\fP resource,
which may not correspond to what the cursor is actually doing.
.
.TP
.B Enable Alternate Screen Switching\fP (resource \fBtiteInhibit\fP)
Enable (or disable) switching between the normal and alternate screens.
This corresponds to the \fBtiteInhibit\fP resource.
There is no corresponding command-line option.
.
.TP
.B Enable Active Icon\fP (resource \fBactiveicon\fP)
Enable (or disable) the active-icon feature.
This corresponds to the \fB\-ai\fP option and the \fBactiveIcon\fP resource.
.
.TP
.B Sixel Scrolling\fP (resource \fBsixelScrolling\fP)
When enabled,
sixel graphics are positioned at the current text cursor location, scroll
the image vertically if larger than the screen, and leave the text cursor
at the start of the next complete line after the image when returning to text
mode (this is the default).
When disabled,
sixel graphics are positioned at the upper left of the screen, are
cropped to fit the screen, and do not affect the text cursor location.
This corresponds to the \fBsixelScrolling\fP resource.
There is no corresponding command-line option.
.
.TP
.B Private Color Registers\fP (resource \fBprivateColorRegisters\fP)
If \fI\*n\fR is configured to support ReGIS graphics,
this controls whether a private color palette can be used.
.IP
When enabled,
each graphic image uses a separate set of color registers, so that it
essentially has a private palette (this is the default).
If it is not set,
all graphics images share a common set of registers which is how sixel and
ReGIS graphics worked on actual hardware.
The default is likely a more
useful mode on modern TrueColor hardware.
.IP
This corresponds to the \fBprivateColorRegisters\fP resource.
There is no corresponding command-line option.
.RE
.
.TP
VT\fIxxx\fP Commands:
.RS
.TP
.B Do Soft Reset\fP (resource \fBsoftreset\fP)
Reset scroll regions.
This can be convenient when some program has left the scroll regions
set incorrectly (often a problem when using VMS or TOPS-20).
This corresponds to the VT220 DECSTR control sequence.
.
.TP
.B Do Full Reset\fP (resource \fBhardreset\fP)
The full reset entry will clear the screen, reset tabs to every
eight columns, and reset the terminal modes (such as wrap and smooth scroll)
to their initial states just after
\fI\*n\fP has finished processing the command line options.
This corresponds to the VT102 RIS control sequence,
with a few obvious differences.
For example, your session is not disconnected as a real VT102 would do.
.
.TP
.B Reset and Clear Saved Lines\fP (resource \fBclearsavedlines\fP)
Perform a full reset,
and also clear the saved lines.
.RE
.
.TP
Commands for setting the current screen:
.RS
.
.TP
.B Show Tek Window\fP (resource \fBtekshow\fP)
When enabled,
pops the Tektronix 4014 window up (makes it visible).
When disabled,
hides the Tektronix 4014 window.
.
.TP
.B Switch to Tek Mode\fP (resource \fBtekmode\fP)
When enabled,
pops the Tektronix 4014 window up if it is not already visible,
and switches the input stream to that window.
When disabled,
hides the Tektronix 4014 window and
switches input back to the VT\fIxxx\fP window.
.
.TP
.B Hide VT Window\fP (resource \fBvthide\fP)
When enabled,
hides the VT\fIxxx\fP window,
shows the Tektronix 4014 window if
it was not already visible
and switches the input stream to that window.
When disabled,
shows the VT\fIxxx\fP window,
and switches the input stream to that window.
.
.TP
.B Show Alternate Screen\fP (resource \fBaltscreen\fP)
When enabled,
shows the alternate screen.
When disabled,
shows the normal screen.
Note that the normal screen may have saved lines;
the alternate screen does not.
.RE
.PP
.
.SS "VT Fonts"
.PP
The \fI\*n\fP \fIfontMenu\fP pops up when
the \*(``control\*('' key and pointer button three are pressed in a window.
It sets the font used in the VT\fIxxx\fP window,
or modifies the way the font is specified or displayed.
There are several sections.
.PP
The first section allows you to select the font from a set of alternatives:
.RS
.TP
.B Default\fP (resource \fBfontdefault\fP)
Set the font to the default, i.e., that given by the \fB*VT100.font\fP resource.
.TP
.B Unreadable\fP (resource \fBfont1\fP)
Set the font to that given by the \fB*VT100.font1\fP resource.
.TP
.B Tiny\fP (resource \fBfont2\fP)
Set the font to that given by the \fB*VT100.font2\fP resource.
.TP
.B Small\fP (resource \fBfont3\fP)
Set the font to that given by the \fB*VT100.font3\fP resource.
.TP
.B Medium\fP (resource \fBfont4\fP)
Set the font to that given by the \fB*VT100.font4\fP resource.
.TP
.B Large\fP (resource \fBfont5\fP)
Set the font to that given by the \fB*VT100.font5\fP resource.
.TP
.B Huge\fP (resource \fBfont6\fP)
Set the font to that given by the \fB*VT100.font6\fP resource.
.TP
.B Escape Sequence\fP (resource \fBfontescape\fP)
This allows you to set the font last specified by the Set
Font escape sequence (see \fI\*N Control Sequences\fP).
.TP
.B Selection\fP (resource \fBfontsel\fP)
This allows you to set the font specified
the current selection as a font name (if the \fBPRIMARY\fP selection is owned).
.RE
.PP
The second section allows you to modify the way it is displayed:
.RS
.TP
.B Bold Fonts\fP (resource \fBallow-bold-fonts\fP)
This is normally checked (enabled).
When unchecked, \fI\*n\fP will not use bold fonts.
The setting corresponds to the \fBallowBoldFonts\fP resource.
.TP
.B Line-Drawing Characters\fP (resource \fBfont-linedrawing\fP)
When set, tells \fI\*n\fP to draw its own line-drawing characters.
Otherwise it relies on the font containing these.
Compare to the \fBforceBoxChars\fP resource.
.TP
.B Packed Font\fP (resource \fBfont-packed\fP)
When set, tells \fI\*n\fP to use the minimum glyph-width from a font
when displaying characters.
Use the maximum width (unchecked) to help display proportional fonts.
Compare to the \fBforcePackedFont\fP resource.
.TP
.B Doublesized Characters\fP (resource \fBfont-doublesize\fP)
When set, \fI\*n\fP may ask the font server to produce scaled versions
of the normal font, for VT102 double-size characters.
.RE
.PP
The third section allows you to modify the way it is specified:
.RS
.TP
.B TrueType Fonts\fP (resource \fBrender-font\fP)
If the \fBrenderFont\fP and corresponding resources were set,
this is a further control whether \fI\*n\fP will actually use the
Xft library calls to obtain a font.
.TP
.B UTF-8 Encoding\fP (resource \fButf8-mode\fP)
This controls whether \fI\*n\fP uses UTF-8 encoding of input/output.
It is useful for temporarily switching \fI\*n\fP to display
text from an application which does not follow the locale settings.
It corresponds to the \fButf8\fP resource.
.TP
.B UTF-8 Fonts\fP (resource \fButf8-fonts\fP)
This controls whether \fI\*n\fP uses UTF-8 fonts for display.
It is useful for temporarily switching \fI\*n\fP to display
text from an application which does not follow the locale settings.
It combines the \fButf8\fP and \fButf8Fonts\fP resources,
subject to the \fBlocale\fP resource.
.TP
.B UTF-8 Titles\fP (resource \fButf8-title\fP)
This controls whether \fI\*n\fP accepts UTF-8 encoding for
title control sequences.
It corresponds to the \fButf8Fonts\fP resource.
.IP
Initially the checkmark is set according to both the \fButf8\fP
and \fButf8Fonts\fP resource values.
If the latter is set to \*(``always\*('', the checkmark is disabled.
Likewise, if there are no fonts given in the \fButf8Fonts\fP
subresources, then the checkmark also is disabled.
.IP
The standard \fB__default_class__\fP app-defaults file defines
both sets of fonts,
while the \fBU__default_class__\fP app-defaults file defines only one set.
Assuming the standard app-defaults files,
this command will launch \fI\*n\fP able to switch between UTF-8
and ISO-8859-1 encoded fonts:
.NS
u\*n \-class __default_class__
.NE
.RE
.PP
The fourth section allows you to enable or disable special operations
which can be controlled by writing escape sequences to the terminal.
These are disabled if the SendEvents feature is enabled:
.RS
.TP
.B Allow Color Ops\fP (resource \fBallow-font-ops\fP)
This corresponds to the \fBallowColorOps\fP resource.
Enable or disable control sequences that set/query the colors.
.TP
.B Allow Font Ops\fP (resource \fBallow-font-ops\fP)
This corresponds to the \fBallowFontOps\fP resource.
Enable or disable control sequences that set/query the font.
.TP
.B Allow Mouse Ops\fP (resource \fBallow-mouse-ops\fP)
Enable or disable control sequences that cause the terminal to
send escape sequences on pointer-clicks and movement.
This corresponds to the \fBallowMouseOps\fP resource.
.TP
.B Allow Tcap Ops\fP (resource \fBallow-tcap-ops\fP)
Enable or disable control sequences that query the terminal's
notion of its function-key strings, as termcap or terminfo capabilities.
This corresponds to the \fBallowTcapOps\fP resource.
.TP
.B Allow Title Ops\fP (resource \fBallow-title-ops\fP)
Enable or disable control sequences that modify the window title or icon name.
This corresponds to the \fBallowTitleOps\fP resource.
.TP
.B Allow Window Ops\fP (resource \fBallow-window-ops\fP)
Enable or disable extended window control sequences (as used in dtterm).
This corresponds to the \fBallowWindowOps\fP resource.
.RE
.
.SS "Tek Options"
.PP
The \fI\*n\fP \fItekMenu\fP sets various modes in the Tektronix emulation,
and is popped up when the
\*(``control\*('' key and pointer button two
are pressed in the Tektronix window.
The current font size is checked in the modes section of the menu.
.RS
.TP
.B Large Characters\fP (resource \fBtektextlarge\fP)
.TP
.B \&#2 Size Characters\fP (resource \fBtektext2\fP)
.TP
.B \&#3 Size Characters\fP (resource \fBtektext3\fP)
.TP
.B Small Characters\fP (resource \fBtektextsmall\fP)
.RE
.PP
Commands:
.RS
.TP
.B PAGE\fP (resource \fBtekpage\fP)
Simulates the Tektronix \*(``PAGE\*('' button by
.RS
.bP
clearing the window,
.bP
cancelling the graphics input-mode, and
.bP
moving the cursor to the \fIhome\fP position.
.RE
.TP
.B RESET\fP (resource \fBtekreset\fP)
Unlike the similarly-named Tektronix \*(``RESET\*('' button,
this does everything that \fBPAGE\fP does
as well as resetting the line-type and font-size to their default values.
.TP
.B COPY\fP (resource \fBtekcopy\fP)
Simulates the Tektronix \*(``COPY\*('' button
(which makes a hard-copy of the screen)
by writing the information to a text file.
.RE
.PP
Windows:
.RS
.TP
.B Show VT Window\fP (resource \fBvtshow\fP)
.TP
.B Switch to VT Mode\fP (resource \fBvtmode\fP)
.TP
.B Hide Tek Window\fP (resource \fBtekhide\fP)
.RE
.
.
.SH SECURITY
.
.PP
X environments differ in their security consciousness.
.bP
Most servers,
run under \fIxdm\fP,
are capable of using a \*(``magic cookie\*('' authorization
scheme that can provide a reasonable level of security for many people.
If your server is only using a host-based mechanism to control access to
the server (see \fBxhost(__mansuffix__)\fP),
then if you enable access for a host and
other users are also permitted to run clients on that same host,
it is possible that someone can run an application which uses the
basic services of the X protocol to snoop on your activities,
potentially capturing a transcript of everything you type at the keyboard.
.bP
Any process which has access to your X display can manipulate it
in ways that you might not anticipate,
even redirecting your keyboard to itself
and sending events to your application's windows.
This is true even with the \*(``magic cookie\*('' authorization scheme.
While the \fBallowSendEvents\fP provides some protection against
rogue applications tampering with your programs,
guarding against a snooper is harder.
.
.bP
The X input extension for instance allows an application to bypass
all of the other (limited) authorization and security features,
including the GrabKeyboard protocol.
.
.bP
The possibility of an application spying on your keystrokes
is of particular concern when you want to type in a password
or other sensitive data.
The best solution to this problem is to use a better
authorization mechanism than is provided by X.
.PP
Subject to all of these caveats,
a simple mechanism exists for protecting keyboard input in \fI\*n\fP.
.
.PP
The \fI\*n\fP menu (see \fBMENUS\fP above) contains a \fBSecure Keyboard\fP
entry which, when enabled,
attempts to ensure that all keyboard input is directed
\fIonly\fP to \fI\*n\fP (using the GrabKeyboard protocol request).
When an application prompts you for a password
(or other sensitive data), you can enable \fBSecure Keyboard\fP using the
menu, type in the data, and then disable \fBSecure Keyboard\fP using
the menu again.
.bP
This ensures that you know which window is accepting your keystrokes.
.bP
It cannot ensure that there are no processes which have access to your
X display that might be observing the keystrokes as well.
.
.PP
Only one X client at a time can grab the keyboard,
so when you attempt to enable \fBSecure Keyboard\fP it may fail.
In this case, the bell will sound.
If the \fBSecure Keyboard\fP succeeds,
the foreground and background colors will be exchanged (as if you
selected the \fBEnable Reverse Video\fP entry in the \fBModes\fP menu);
they will be exchanged again when you exit secure mode.
If the colors
do \fInot\fP switch, then
you should be \fIvery\fP suspicious that you are being spoofed.
If the application you are running displays a prompt before asking for
the password, it is safest to enter secure mode \fIbefore\fP the
prompt gets displayed, and to make sure that the prompt gets displayed
correctly (in the new colors), to minimize the probability of
spoofing.
You can also bring up the menu again and make sure that a check
mark appears next to the entry.
.
.PP
\fBSecure Keyboard\fP mode will be disabled automatically if your \fI\*n\fP
window becomes iconified (or otherwise unmapped), or if you start up
a reparenting window manager (that places a title bar or other decoration
around the window) while in \fBSecure Keyboard\fP mode.
(This is a
feature of the X protocol not easily overcome.)  When this happens,
the foreground and background colors will be switched back and the bell
will sound in warning.
.
.
.SH "CHARACTER CLASSES"
Clicking the left pointer button twice in rapid succession
(double-clicking) causes all characters of the same class
(e.g., letters, white space, punctuation) to be selected as a \*(``word\*(''.
Since different people have different preferences for what should
be selected (for example, should filenames be selected as a whole or only
the separate subnames), the default mapping can be overridden through the use
of the \fBcharClass\fP (class \fICharClass\fP) resource.
.
.PP
This resource is a
series of comma-separated
\fIrange\fP:\fIvalue\fP pairs.
.bP
The
\fIrange\fP is either a single number or \fIlow\fP-\fIhigh\fP in the range of 0
to 65535, corresponding to the code for the character or characters to be
set.
.bP
The \fIvalue\fP is arbitrary.
For example, the default table uses the
character number of the first character occurring in the set.
When not in
UTF-8 mode, only the first 256 entries of this table will be used.
.
.PP
The default table starts as follows \-
.NS
static int charClass[256] = {
/\(** NUL  SOH  STX  ETX  EOT  ENQ  ACK  BEL */
    32,   1,   1,   1,   1,   1,   1,   1,
/\(**  BS   HT   NL   VT   NP   CR   SO   SI */
     1,  32,   1,   1,   1,   1,   1,   1,
/\(** DLE  DC1  DC2  DC3  DC4  NAK  SYN  ETB */
     1,   1,   1,   1,   1,   1,   1,   1,
/\(** CAN   EM  SUB  ESC   FS   GS   RS   US */
     1,   1,   1,   1,   1,   1,   1,   1,
/\(**  SP    !    "    #    $    %    &    \*(AQ */
.\"   " <- for emacs autocolor to work well :-)
    32,  33,  34,  35,  36,  37,  38,  39,
/\(**   (    )    *    +    ,    \-    .    / */
    40,  41,  42,  43,  44,  45,  46,  47,
/\(**   0    1    2    3    4    5    6    7 */
    48,  48,  48,  48,  48,  48,  48,  48,
/\(**   8    9    :    ;    <    =    >    ? */
    48,  48,  58,  59,  60,  61,  62,  63,
/\(**   @    A    B    C    D    E    F    G */
    64,  48,  48,  48,  48,  48,  48,  48,
/\(**   H    I    J    K    L    M    N    O */
    48,  48,  48,  48,  48,  48,  48,  48,
/\(**   P    Q    R    S    T    U    V    W */
    48,  48,  48,  48,  48,  48,  48,  48,
/\(**   X    Y    Z    [    \\    ]    ^    _ */
    48,  48,  48,  91,  92,  93,  94,  48,
/\(**   `    a    b    c    d    e    f    g */
    96,  48,  48,  48,  48,  48,  48,  48,
/\(**   h    i    j    k    l    m    n    o */
    48,  48,  48,  48,  48,  48,  48,  48,
/\(**   p    q    r    s    t    u    v    w */
    48,  48,  48,  48,  48,  48,  48,  48,
/\(**   x    y    z    {    |    }    ~  DEL */
    48,  48,  48, 123, 124, 125, 126,   1,
/\(** x80  x81  x82  x83  IND  NEL  SSA  ESA */
     1,   1,   1,   1,   1,   1,   1,   1,
/\(** HTS  HTJ  VTS  PLD  PLU   RI  SS2  SS3 */
     1,   1,   1,   1,   1,   1,   1,   1,
/\(** DCS  PU1  PU2  STS  CCH   MW  SPA  EPA */
     1,   1,   1,   1,   1,   1,   1,   1,
/\(** x98  x99  x9A  CSI   ST  OSC   PM  APC */
     1,   1,   1,   1,   1,   1,   1,   1,
/\(**   \-    i   c/    L   ox   Y\-    |   So */
   160, 161, 162, 163, 164, 165, 166, 167,
/\(**  ..   c0   ip   <<    _        R0    \- */
   168, 169, 170, 171, 172, 173, 174, 175,
/\(**   o   +\-    2    3    \*(AQ    u   q|    . */
   176, 177, 178, 179, 180, 181, 182, 183,
/\(**   ,    1    2   >>  1/4  1/2  3/4    ? */
   184, 185, 186, 187, 188, 189, 190, 191,
/\(**  A`   A\*(AQ   A^   A~   A:   Ao   AE   C, */
    48,  48,  48,  48,  48,  48,  48,  48,
/\(**  E`   E\*(AQ   E^   E:   I`   I\*(AQ   I^   I: */
    48,  48,  48,  48,  48,  48,  48,  48,
/\(**  D\-   N~   O`   O\*(AQ   O^   O~   O:    X */
    48,  48,  48,  48,  48,  48,  48, 215,
/\(**  O/   U`   U\*(AQ   U^   U:   Y\*(AQ    P    B */
    48,  48,  48,  48,  48,  48,  48,  48,
/\(**  a`   a\*(AQ   a^   a~   a:   ao   ae   c, */
    48,  48,  48,  48,  48,  48,  48,  48,
/\(**  e`   e\*(AQ   e^   e:   i`   i\*(AQ   i^   i: */
    48,  48,  48,  48,  48,  48,  48,  48,
/\(**   d   n~   o`   o\*(AQ   o^   o~   o:   \-: */
    48,  48,  48,  48,  48,  48,  48, 247,
/\(**  o/   u`   u\*(AQ   u^   u:   y\*(AQ    P   y: */
    48,  48,  48,  48,  48,  48,  48,  48};
.NE
.IP
For example, the string \*(``33:48,37:48,45\-47:48,38:48\*('' indicates that the
exclamation mark, percent sign, dash, period, slash, and ampersand characters
should be treated the same way as characters and numbers.
This is useful
for cutting and pasting electronic mailing addresses and filenames.
.
.
.SH KEY BINDINGS
.PP
It is possible to rebind keys (or sequences of keys) to arbitrary strings
for input, by changing the \fBtranslations\fP resources
for the vt100 or tek4014 widgets.
Changing the \fBtranslations\fP resource
for events other than key and button events is not expected,
and will cause unpredictable behavior.
.SS Actions
The following
actions are provided for use within the \fIvt100\fP or \fItek4014\fP
\fBtranslations\fP resources:
.TP 8
.B "allow-bold-fonts(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBallowBoldFonts\fP resource
and is also invoked by the \fBallow-bold-fonts\fP entry in \fIfontMenu\fP.
.TP 8
.B "allow-color-ops(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBallowColorOps\fP resource and is also
invoked by the \fBallow-color-ops\fP entry in \fIfontMenu\fP.
.TP 8
.B "allow-font-ops(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBallowFontOps\fP resource and is also
invoked by the \fBallow-font-ops\fP entry in \fIfontMenu\fP.
.TP 8
.B "allow-mouse-ops(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBallowMousepOps\fP resource
and is also invoked by the \fBallow-mouse-ops\fP entry in \fIfontMenu\fP.
.TP 8
.B "allow-send-events(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBallowSendEvents\fP resource
and is also invoked by the \fBallowsends\fP entry in \fImainMenu\fP.
.TP 8
.B "allow-tcap-ops(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBallowTcapOps\fP resource
and is also invoked by the \fBallow-tcap-ops\fP entry in \fIfontMenu\fP.
.TP 8
.B "allow-title-ops(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBallowTitleOps\fP resource
and is also invoked by the \fBallow-title-ops\fP entry in \fIfontMenu\fP.
.TP 8
.B "allow-window-ops(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBallowWindowOps\fP resource
and is also invoked by the \fBallow-window-ops\fP entry in \fIfontMenu\fP.
.TP 8
.B "alt-sends-escape()"
This action toggles the state of the \fBaltSendsEscape\fP resource.
.TP 8
.B "bell([\fIpercent\fP])"
This action rings the keyboard bell at the specified percentage
above or below the base volume.
.TP 8
.B "clear-saved-lines()"
This action does \fBhard-reset()\fP and also clears the history
of lines saved off the top of the screen.
It is also invoked from the \fBclearsavedlines\fP entry in \fIvtMenu\fP.
The effect is identical to a hardware reset (RIS) control sequence.
.TP 8
.B "copy-selection(\fIdestname\fP [, \&...\&])"
This action puts the currently selected text into all of the selections or
cutbuffers specified by \fIdestname\fP.
Unlike \fBselect-end\fP, it does not send a mouse position or otherwise
modify the internal selection state.
.TP 8
.B "create-menu(\fIm/v/f/t\fP)"
This action creates one of the menus used by \fI\*n\fP,
if it has not been previously created.
The parameter values are the menu names:
\fImainMenu\fP, \fIvtMenu\fP, \fIfontMenu\fP, \fItekMenu\fP, respectively.
.TP 8
.B "dabbrev-expand()"
Expands the word before cursor by searching in the preceding text on the
screen and in the scrollback buffer for words starting with that
abbreviation.
Repeating \fBdabbrev-expand()\fP several times in sequence searches for an
alternative expansion by looking farther back.
Lack of more matches is signaled by a bell.
Attempts to expand an empty word
(i.e., when cursor is preceded by a space) yield successively all previous
words.
Consecutive identical expansions are ignored.
The word here is defined as a sequence of non-whitespace characters.
This feature partially emulates the behavior
of \*(``dynamic abbreviation\*('' expansion in Emacs (bound there to M\-/).
Here is a resource setting for \fI\*n\fP which will do the same thing:
.NS
*VT100*translations:    #override \\n\\\&
        Meta <KeyPress> /:\fBdabbrev\-expand\fP()
.NE
.TP 8
.B "deiconify()"
Changes the window state back to normal, if it was iconified.
.TP 8
.B "delete-is-del()"
This action toggles the state of the \fBdeleteIsDEL\fP resource.
.TP 8
.B "dired-button()"
Handles a button event (other than press and release)
by echoing the event's position
(i.e., character line and column) in the following format:
.NS
^X ESC G <line+\*(`` \*(''> <col+\*(`` \*(''>
.NE
.TP 8
.B "dump-html()"
Invokes the \fBXHTML Screen Dump\fP feature.
.TP 8
.B "dump-svg()"
Invokes the \fBSVG Screen Dump\fP feature.
.TP 8
.B "exec-formatted(\fIformat\fP, \fIsourcename\fP [, \&...\&])"
Execute an external command,
using the current selection for part of the command's parameters.
The first parameter, \fIformat\fP gives the basic command.
Succeeding parameters specify the selection source as in \fBinsert-selection\fP.
.IP
The \fIformat\fP parameter allows these substitutions:
.RS
.TP 5
%%
inserts a "%".
.TP 5
%P
the screen-position at the beginning of the highlighted region,
as a semicolon-separated pair of integers using the
values that the CUP control sequence would use.
.TP 5
%p
the screen-position after the beginning of the highlighted region,
using the same convention as \*(``%P\*(''.
.TP 5
%S
the length of the string that \*(``%s\*('' would insert.
.TP 5
%s
the content of the selection, unmodified.
.TP 5
%T
the length of the string that \*(``%t\*('' would insert.
.TP 5
%t
the selection, trimmed of leading/trailing whitespace.
Embedded spaces (and newlines) are copied as is.
.TP 5
%R
the length of the string that \*(``%r\*('' would insert.
.TP 5
%r
the selection, trimmed of trailing whitespace.
.TP 5
%V
the video attributes at the beginning of the highlighted region,
as a semicolon-separated list of integers using the
values that the SGR control sequence would use.
.TP 5
%v
the video attributes after the end of the highlighted region,
using the same convention as \*(``%V\*(''.
.RE
.IP
After constructing the command-string,
\fI\*n\fP forks a subprocess and executes the command,
which completes independently of \fI\*n\fP.
.IP
For example, this translation would invoke a new \fI\*n\fP process
to view a file whose name is selected while holding the shift key down.
The new process is started when the mouse button is released:
.NS
*VT100*translations: #override Shift \\\&
    <Btn1Up>:\fBexec\-formatted\fP("xterm \-e view \*(AQ%t\*(AQ", \fBSELECT\fP)
.NE
.TP 8
.B "exec-selectable(\fIformat\fP, \fIonClicks\fP)"
Execute an external command,
using data copied from the screen for part of the command's parameters.
The first parameter, \fIformat\fP gives
the basic command as in \fBexec-formatted\fP.
The second parameter specifies the method for copying
the data as in the \fBon2Clicks\fP resource.
.TP 8
.B "fullscreen(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBfullscreen\fP resource.
.TP 8
.B "iconify()"
Iconifies the window.
.TP 8
.B "hard-reset()"
This action resets the scrolling region, tabs, window size, and cursor keys
and clears the screen.
It is also invoked from the \fBhardreset\fP
entry in \fIvtMenu\fP.
.TP 8
.B "ignore()"
This action ignores the event but checks for special pointer position
escape sequences.
.TP 8
.B "insert()"
This action inserts the character or string associated with
the key that was pressed.
.TP 8
.B "insert-eight-bit()"
This action inserts an eight-bit (Meta) version of the character or string
associated with the key that was pressed.
Only single-byte values are treated specially.
The exact action depends on the value of
the \fBaltSendsEscape\fP and
the \fBmetaSendsEscape\fP and
the \fBeightBitInput\fP resources.
The \fBmetaSendsEscape\fP resource is tested first.
See the \fBeightBitInput\fP resource for a full discussion.
.IP
The term \*(``eight-bit\*('' is misleading:
\fI\*n\fP checks if the key is in the range 128 to 255
(the eighth bit is set).
If the value is in that range,
depending on the resource values,
\fI\*n\fP may then do one of the following:
.RS
.bP
add 128 to the value, setting its eighth bit,
.bP
send an ESC byte before the key, or
.bP
send the key unaltered.
.RE
.TP 8
.B "insert-formatted(\fIformat\fP, \fIsourcename\fP [, \&...\&])"
Insert the current selection or data related to it, formatted.
The first parameter, \fIformat\fP gives the template for the data
as in \fBexec-formatted\fP.
Succeeding parameters specify the selection source as in \fBinsert-selection\fP.
.TP 8
.B "insert-selectable(\fIformat\fP, \fIonClicks\fP)"
Insert data copied from the screen, formatted.
The first parameter, \fIformat\fP gives the template for the data
as in \fBexec-formatted\fP.
The second parameter specifies the method for copying
the data as in the \fBon2Clicks\fP resource.
.TP 8
.B "insert-selection(\fIsourcename\fP [, \&...\&])"
This action inserts the string found in the selection or cutbuffer indicated
by \fIsourcename\fP.
Sources are checked in the order given (case is
significant) until one is found.
Commonly-used selections include:
\fBPRIMARY\fP, \fBSECONDARY\fP, and \fBCLIPBOARD\fP.
Cut buffers are
typically named \fBCUT_BUFFER0\fP through \fBCUT_BUFFER7\fP.
.TP 8
.B "insert-seven-bit()"
This action is a synonym for \fBinsert()\fP.
The term \*(``seven-bit\*('' is misleading:
it only implies that \fI\*n\fP does not try to add 128 to the key's value
as in \fBinsert-eight-bit()\fP.
.TP 8
.B "interpret(\fIcontrol-sequence\fP)"
Interpret the given control sequence locally, i.e., without passing it to
the host.
This works by inserting the control sequence at the front
of the input buffer.
Use \*(``\\\*('' to escape octal digits in the string.
Xt does not allow you to put a null character
(i.e., \*(``\\000\*('') in the string.
.TP 8
.B "keymap(\fIname\fP)"
This action dynamically defines a new translation table whose resource
name is \fIname\fP with the suffix \*(``\fIKeymap\fP\*(''
(i.e., \fIname\fP\fBKeymap\fP, where case is significant).
The name \fINone\fP restores the original translation table.
.TP 8
.B "larger-vt-font()"
Set the font to the next larger one, based on the font dimensions.
See also \fBset-vt-font()\fP.
.TP 8
.B "load-vt-fonts(\fIname\fP[,\fIclass\fP])"
Load fontnames from the given subresource name and class.
That is, load the \*(``*VT100.\fIname\fP.font\*('',
resource as \*(``*VT100.font\*('' etc.
If no name is given, the original set of fontnames is restored.
.IP
Unlike \fBset-vt-font()\fR, this does not affect the escape- and select-fonts,
since those are not based on resource values.
It does affect the fonts loosely organized under the \*(``Default\*('' menu
entry, including \fBfont\fP, \fBboldFont\fP, \fBwideFont\fP
and \fBwideBoldFont\fP.
.TP 8
.B "maximize()"
Resizes the window to fill the screen.
.TP 8
.B "meta-sends-escape()"
This action toggles the state of the \fBmetaSendsEscape\fP resource.
.TP 8
.B "popup-menu(\fImenuname\fP)"
This action displays the specified popup menu.
Valid names (case is
significant) include:  \fImainMenu\fP, \fIvtMenu\fP, \fIfontMenu\fP,
and \fItekMenu\fP.
.TP 8
.B "print(\fIprinter-flags\fP)"
This action prints the window.
It is also invoked by the \fBprint\fP entry in \fImainMenu\fP.
.IP
The action accepts optional parameters, which temporarily override
resource settings.
The parameter values are matched ignoring case:
.RS
.TP 5
noFormFeed
no form feed will be sent at the end of the last line printed
(i.e., \fBprinterFormFeed\fP is \*(``false\*('').
.TP 5
FormFeed
a form feed will be sent at the end of the last line printed
(i.e., \fBprinterFormFeed\fP is \*(``true\*('').
.TP 5
noNewLine
no newline will be sent at the end of the last line printed,
and wrapped lines will be combined into long lines
(i.e., \fBprinterNewLine\fP is \*(``false\*('').
.TP 5
NewLine
a newline will be sent at the end of the last line printed,
and each line will be limited (by adding a newline) to the screen width
(i.e., \fBprinterNewLine\fP is \*(``true\*('').
.TP 5
noAttrs
the page is printed without attributes
(i.e., \fBprintAttributes\fP is \*(``0\*('').
.TP 5
monoAttrs
the page is printed with monochrome (vt220) attributes
(i.e., \fBprintAttributes\fP is \*(``1\*('').
.TP 5
colorAttrs
the page is printed with ANSI color attributes
(i.e., \fBprintAttributes\fP is \*(``2\*('').
.RE
.TP 8
.B "print-everything(\fIprinter-flags\fP)"
This action sends the entire text history, in addition to the text
currently visible, to the program given in the \fBprinterCommand\fP resource.
It allows the same optional parameters as the \fBprint\fP action.
With a suitable printer command, the action can be used to load the text
history in an editor.
.TP 8
.B "print-immediate()"
Sends the text of the current window directly to a file,
as specified by the
\fBprintFileImmediate\fP,
\fBprintModeImmediate\fP and
\fBprintOptsImmediate\fP
resources.
.TP 8
.B "print-on-error()"
Toggles a flag telling \fI\*n\fP that if it exits with an X error,
to send the text of the current window directly to a file,
as specified by the
\fBprintFileOnXError\fP,
\fBprintModeOnXError\fP and
\fBprintOptsOnXError\fP
resources.
.TP 8
.B "print-redir()"
This action toggles the \fBprinterControlMode\fR between 0 and 2.
The corresponding popup menu entry is useful for switching the printer
off if you happen to change your mind after deciding to print random
binary files on the terminal.
.TP 8
.B "quit()"
.br
This action sends a SIGHUP to the subprogram and exits.
It is also invoked
by the \fBquit\fP entry in \fImainMenu\fP.
.TP 8
.B "readline-button()"
Supports the optional readline feature by echoing repeated cursor forward
or backward control sequences on button release event,
to request that the host application update its notion of the cursor's
position to match the button event.
.TP 8
.B "redraw()"
This action redraws the window.
It is also invoked by the \fBredraw\fP entry in \fImainMenu\fP.
.TP 8
.B "restore()"
Restores the window to the size before it was last maximized.
.TP 8
.B "scroll-back(\fIcount\fP [,\fIunits\fP [,\fImouse\fP] ])"
This action scrolls the text window backward so that text that had previously
scrolled off the top of the screen is now visible.
.IP
The \fIcount\fP argument
indicates the number of \fIunits\fP (which may be \fIpage\fP, \fIhalfpage\fP,
\fIpixel\fP, or \fIline\fP) by which to scroll.
If no \fIcount\fP parameter is given, \fI\*n\fP uses the number of lines
given by the \fBscrollLines\fP resource.
.IP
An adjustment can be specified for the \fIpage\fP or \fIhalfpage\fP units
by appending a \*(``+\*('' or \*(``\-\*(''
sign followed by a number,
e.g., \fIpage\-2\fP to specify 2 lines less than a page.
.IP
If the second parameter is omitted \*(``lines\*('' is used.
.IP
If the third parameter \fImouse\fP is given, the action is ignored when
mouse reporting is enabled.
.TP 8
.B "scroll-forw(\fIcount\fP [,\fIunits\fP [,\fImouse\fP] ])"
This action is similar to \fBscroll-back\fP except that it scrolls
in the other direction.
.TP 8
.B "secure()"
This action toggles the \fISecure Keyboard\fP mode
(see \fBSECURITY\fP), and is invoked from the \fBsecurekbd\fP
entry in \fImainMenu\fP.
.TP 8
.B "scroll-lock(\fIon/off/toggle\fP)"
This action sets, unsets or toggles internal state which tells
\fI\*n\fP whether Scroll Lock is active,
subject to the \fBallowScrollLock\fP resource.
.TP 8
.B "scroll-to(\fIcount\fP)"
Scroll to the given line relative to the beginning of the saved-lines.
For instance, \*(``\fBscroll-to(0)\fP\*('' would scroll to the beginning.
Two special nonnumeric parameters are recognized:
.RS
.TP 8
.B scroll-to(begin)
Scroll to the beginning of the saved lines.
.TP 8
.B scroll-to(end)
Scroll to the end of the saved lines, i.e., to the currently active page.
.RE
.TP 8
.B "select-cursor-end(\fIdestname\fP [, \&...\&])"
This action is similar to \fBselect-end\fP except that it should be used
with \fBselect-cursor-start\fP.
.TP 8
.B "select-cursor-extend()"
This action is similar to \fBselect-extend\fP except that it should be used
with \fBselect-cursor-start\fP.
.TP 8
.B "select-cursor-start()"
This action is similar to \fBselect-start\fP except that it begins the
selection at the current text cursor position.
.TP 8
.B "select-end(\fIdestname\fP [, \&...\&])"
This action puts the currently selected text into all of the selections or
cutbuffers specified by \fIdestname\fP.
It also sends a mouse position and updates the internal selection state
to reflect the end of the selection process.
.TP 8
.B "select-extend()"
This action tracks the pointer and extends the selection.
It should only be bound to Motion events.
.TP 8
.B "select-set()"
This action stores text that corresponds to the current selection,
without affecting the selection mode.
.TP 8
.B "select-start()"
This action begins text selection at the current pointer location.
See
the section on \fBPOINTER USAGE\fP for information on making selections.
.TP 8
.B "send-signal(\fIsigname\fP)"
This action sends the signal named by \fIsigname\fP
to the \fI\*n\fP subprocess (the shell or program specified with
the \fI\-e\fP command line option).
It is also invoked by the
\fBsuspend\fP,
\fBcontinue\fP,
\fBinterrupt\fP,
\fBhangup\fP,
\fBterminate\fP,
and
\fBkill\fP
entries in \fImainMenu\fP.
Allowable signal names are (case is
not significant):
\fItstp\fP (if supported by the operating system), \fIsuspend\fP (same
as \fItstp\fP), \fIcont\fP
(if supported by the operating system), \fIint\fP, \fIhup\fP, \fIterm\fP,
\fIquit\fP,
\fIalrm\fP, \fIalarm\fP (same as \fIalrm\fP) and \fIkill\fP.
.TP 8
.B "set-8-bit-control(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBeightBitControl\fP resource.
It is also invoked from the \fB8-bit-control\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-allow132(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBc132\fP resource.
It is also invoked from the \fBallow132\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-altscreen(\fIon/off/toggle\fP)"
This action sets, unsets or toggles between the alternate and current screens.
.TP 8
.B "set-appcursor(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the handling Application Cursor Key mode
and is also invoked by the \fBappcursor\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-appkeypad(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the handling of Application Keypad mode
and is also invoked by the \fBappkeypad\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-autolinefeed(\fIon/off/toggle\fP)"
This action sets, unsets or toggles automatic insertion of line feeds.
It is also invoked by the \fBautolinefeed\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-autowrap(\fIon/off/toggle\fP)"
This action sets, unsets or toggles automatic wrapping of long lines.
It is also invoked by the \fBautowrap\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-backarrow(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBbackarrowKey\fP resource.
It is also invoked from the \fBbackarrow key\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-bellIsUrgent(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBbellIsUrgent\fP resource.
It is also invoked by the \fBbellIsUrgent\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-cursorblink(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBcursorBlink\fP resource.
It is also invoked from the \fBcursorblink\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-cursesemul(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBcurses\fP resource.
It is also invoked from the \fBcursesemul\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-font-doublesize(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBfontDoublesize\fP resource.
It is also invoked by the \fBfont-doublesize\fP entry in \fIfontMenu\fP.
.TP 8
.B "set-hp-function-keys(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBhpFunctionKeys\fP resource.
It is also invoked by the \fBhpFunctionKeys\fP entry in \fImainMenu\fP.
.TP 8
.B "set-jumpscroll(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBjumpscroll\fP resource.
It is also invoked by the \fBjumpscroll\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-font-linedrawing(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fI\*n\fR's state regarding whether
the current font has line-drawing characters and whether it should draw them
directly.
It is also invoked by the \fBfont-linedrawing\fP entry in \fIfontMenu\fP.
.\" .\" not implemented
.\" .TP 8
.\" .B "set-font-loading(\fIon/off/toggle\fP)"
.\" This action sets, unsets or toggles the TBD resource
.\" which controls the ability to load VT220 soft fonts.
.\" It is also invoked by the \fBfont-loadable\fP entry in \fIfontMenu\fP.
.TP 8
.B "set-font-packed(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBforcePackedFont\fR resource
which controls use of the font's minimum or maximum glyph width.
It is also invoked by the \fBfont-packed\fP entry in \fIfontMenu\fP.
.TP 8
.B "set-keep-clipboard(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBkeepClipboard\fP resource.
.TP 8
.B "set-keep-selection(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBkeepSelection\fP resource.
It is also invoked by the \fBkeepSelection\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-logging(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the state of the logging option.
.TP 8
.B "set-old-function-keys(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the state of legacy function keys.
It is also invoked by the \fBoldFunctionKeys\fP entry in \fImainMenu\fP.
.TP 8
.B "set-marginbell(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBmarginBell\fP resource.
.TP 8
.B "set-num-lock(\fIon/off/toggle\fP)"
This action toggles the state of the \fBnumLock\fP resource.
.TP 8
.B "set-pop-on-bell(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBpopOnBell\fP resource.
It is also invoked by the \fBpoponbell\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-private-colors(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBprivateColorRegisters\fP resource.
.TP 8
.B "set-render-font(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBrenderFont\fP resource.
It is also invoked by the \fBrender-font\fP entry in \fIfontMenu\fP.
.TP 8
.B "set-reverse-video(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBreverseVideo\fP resource.
It is also invoked by the \fBreversevideo\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-reversewrap(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBreverseWrap\fP resource.
It is also invoked by the \fBreversewrap\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-scroll-on-key(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBscrollKey\fP resource.
It is also invoked from the \fBscrollkey\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-scroll-on-tty-output(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBscrollTtyOutput\fP resource.
It is also invoked from the \fBscrollttyoutput\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-scrollbar(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBscrollbar\fP resource.
It is also invoked by the \fBscrollbar\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-sco-function-keys(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBscoFunctionKeys\fP resource.
It is also invoked by the \fBscoFunctionKeys\fP entry in \fImainMenu\fP.
.TP 8
.B "set-select(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBselectToClipboard\fP resource.
It is also invoked by the \fBselectToClipboard\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-sixel-scrolling(\fIon/off/toggle\fP)"
This action toggles between inline (sixel scrolling) and absolute positioning.
It can also be controlled via DEC private mode 80 (DECSDM) or from
the \fBsixelScrolling\fP entry in the \fIbtMenu\fP.
.TP 8
.B "set-sun-function-keys(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBsunFunctionKeys\fP resource.
It is also invoked by the \fBsunFunctionKeys\fP entry in \fImainMenu\fP.
.TP 8
.B "set-sun-keyboard(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBsunKeyboard\fP resource.
It is also invoked by the \fBsunKeyboard\fP entry in \fImainMenu\fP.
.TP 8
.B "set-tek-text(\fIlarge/2/3/small\fP)"
This action sets the font used in the Tektronix window to the value of the
selected resource according to the argument.
The argument can be either a keyword or single-letter alias,
as shown in parentheses:
.RS
.TP 5
large (l)
Use resource \fBfontLarge\fP, same as menu entry \fBtektextlarge\fP.
.TP 5
two (2)
Use resource \fBfont2\fP, same as menu entry \fBtektext2\fP.
.TP 5
three (3)
Use resource \fBfont3\fP, same as menu entry \fBtektext3\fP.
.TP 5
small (s)
Use resource \fBfontSmall\fP, same as menu entry \fBtektextsmall\fP.
.RE
.TP 8
.B "set-terminal-type(\fItype\fP)"
This action directs output to either the \fIvt\fP or \fItek\fP windows,
according to the \fItype\fP string.
It is also invoked by the
\fBtekmode\fP entry in \fIvtMenu\fP and the \fBvtmode\fP entry in
\fItekMenu\fP.
.TP 8
.B "set-titeInhibit(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBtiteInhibit\fP resource,
which controls switching between the alternate and current screens.
.TP 8
.B "set-toolbar(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the toolbar feature.
It is also invoked by the \fBtoolbar\fP entry in \fImainMenu\fP.
.TP 8
.B "set-utf8-fonts(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fButf8Fonts\fP resource.
It is also invoked by the \fButf8-fonts\fP entry in \fIfontMenu\fP.
.TP 8
.B "set-utf8-mode(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fButf8\fP resource.
It is also invoked by the \fButf8-mode\fP entry in \fIfontMenu\fP.
.TP 8
.B "set-utf8-title(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fButf8Title\fP resource.
It is also invoked by the \fButf8-title\fP entry in \fIfontMenu\fP.
.TP 8
.B "set-visibility(\fIvt/tek\fP,\fIon/off/toggle\fP)"
This action sets, unsets or toggles whether or not
the \fIvt\fP or \fItek\fP windows are visible.
It is also invoked from the \fBtekshow\fP and \fBvthide\fP entries
in \fIvtMenu\fP and the \fBvtshow\fP and \fBtekhide\fP entries in
\fItekMenu\fP.
.TP 8
.B "set-visual-bell(\fIon/off/toggle\fP)"
This action sets, unsets or toggles the \fBvisualBell\fP resource.
It is also invoked by the \fBvisualbell\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-vt-font(\fId/1/2/3/4/5/6/e/s\fP [,\fInormalfont\fP [, \fIboldfont\fP]])"
This action sets the font or fonts currently being used
in the VT\fIxxx\fP window.
The first argument is a single character that specifies the font to be used:
.RS 8
.HP
\fId\fP or \fID\fP indicate the default font (the font initially
used when
\fI\*n\fP was started),
.HP
\fI1\fP through \fI6\fP indicate the fonts
specified by the \fBfont1\fP through \fBfont6\fP resources,
.HP
\fIe\fP or \fIE\fP
indicate the normal and bold fonts that have been set through escape codes
(or specified as the second and third action arguments, respectively), and
.HP
\fIs\fP or \fIS\fP indicate the font selection (as made by programs such as
\fBxfontsel(__mansuffix__)\fP) indicated by the second action argument.
.RE
.IP
If \fI\*n\fR is configured to support wide characters, an
additional two optional parameters are recognized for the \fIe\fP argument:
wide font and wide bold font.
.TP 8
.B "smaller-vt-font()"
Set the font to the next smaller one, based on the font dimensions.
See also \fBset-vt-font()\fP.
.TP 8
.B "soft-reset()"
This action resets the scrolling region.
It is also invoked from the \fBsoftreset\fP entry in \fIvtMenu\fP.
The effect is identical to a soft reset (DECSTR) control sequence.
.TP 8
.B "spawn-new-terminal(\fIparams\fP)"
Spawn a new \fI\*n\fP process.
This is available on systems which have a modern version of the
process filesystem, e.g., \*(``/proc\*('', which \fI\*n\fP can read.
.IP
Use the \*(``cwd\*('' process entry, e.g., /proc/12345/cwd to obtain the
working directory of the process which is running in the current \fI\*n\fP.
.IP
On systems which have the \*(``exe\*('' process entry, e.g., /proc/12345/exe,
use this to obtain the actual executable.
Otherwise, use the \fB$PATH\fP variable to find \fI\*n\fP.
.IP
If parameters are given in the action,
pass them to the new \fI\*n\fP process.
.TP 8
.B "start-extend()"
This action is similar to \fBselect-start\fP except that the
selection is extended to the current pointer location.
.TP 8
.B "start-cursor-extend()"
This action is similar to \fBselect-extend\fP except that the
selection is extended to the current text cursor position.
.TP 8
.B "string(\fIstring\fP)"
This action inserts the specified text string as if it had been typed.
Quotation is necessary if the string contains whitespace or
non-alphanumeric characters.
If the string argument begins with the
characters \*(``0x\*('', it is interpreted
as a hex character constant.
.TP 8
.B "tek-copy()"
This action copies the escape codes used to generate the current window
contents to a file in the current directory beginning with the name COPY.
It is also invoked from the \fBtekcopy\fP entry in \fItekMenu\fP.
.TP 8
.B "tek-page()"
This action clears the Tektronix window.
It is also invoked by the \fBtekpage\fP entry in \fItekMenu\fP.
.TP 8
.B "tek-reset()"
This action resets the Tektronix window.
It is also invoked by the \fBtekreset\fP entry in \fItekMenu\fP.
.TP 8
.B "vi-button()"
Handles a button event (other than press and release)
by echoing a control sequence computed from the event's line number
in the screen relative to the current line:
.NS
ESC ^P
.NE
.IP
or
.NS
ESC ^N
.NE
.IP
according to whether the event is before, or after the current line,
respectively.
The ^N (or ^P) is repeated once for each line that the event differs
from the current line.
The control sequence is omitted altogether if the button event is on the
current line.
.TP 8
.B "visual-bell()"
This action flashes the window quickly.
.
.PP
The Tektronix window also has the following action:
.TP 8
.B "gin-press(\fIl/L/m/M/r/R\fP)"
This action sends the indicated graphics input code.
.
.SS Default Key Bindings
.PP
The default bindings in the VT\fIxxx\fP window use the \fBSELECT\fP token,
which is set by the \fBselectToClipboard\fP resource.
These are for the \fIvt100\fP widget:
.NS
          Shift <KeyPress> Prior:\fBscroll\-back\fP(1,halfpage) \\n\\\&
           Shift <KeyPress> Next:\fBscroll\-forw\fP(1,halfpage) \\n\\\&
         Shift <KeyPress> Select:\fBselect\-cursor\-start\fP() \\\&
                                 \fBselect\-cursor\-end\fP(\fBSELECT\fP, \fBCUT_BUFFER0\fP) \\n\\\&
         Shift <KeyPress> Insert:\fBinsert\-selection\fP(\fBSELECT\fP, \fBCUT_BUFFER0\fP) \\n\\\&
                 Alt <Key>Return:\fBfullscreen\fP() \\n\\\&
        <KeyRelease> Scroll_Lock:\fBscroll\-lock\fP() \\n\\\&
    Shift~Ctrl <KeyPress> KP_Add:\fBlarger\-vt\-font\fP() \\n\\\&
    Shift Ctrl <KeyPress> KP_Add:\fBsmaller\-vt\-font\fP() \\n\\\&
    Shift <KeyPress> KP_Subtract:\fBsmaller\-vt\-font\fP() \\n\\\&
                ~Meta <KeyPress>:\fBinsert\-seven\-bit\fP() \\n\\\&
                 Meta <KeyPress>:\fBinsert\-eight\-bit\fP() \\n\\\&
                !Ctrl <Btn1Down>:\fBpopup\-menu\fP(mainMenu) \\n\\\&
           !Lock Ctrl <Btn1Down>:\fBpopup\-menu\fP(mainMenu) \\n\\\&
 !Lock Ctrl @Num_Lock <Btn1Down>:\fBpopup\-menu\fP(mainMenu) \\n\\\&
     ! @Num_Lock Ctrl <Btn1Down>:\fBpopup\-menu\fP(mainMenu) \\n\\\&
                ~Meta <Btn1Down>:\fBselect\-start\fP() \\n\\\&
              ~Meta <Btn1Motion>:\fBselect\-extend\fP() \\n\\\&
                !Ctrl <Btn2Down>:\fBpopup\-menu\fP(vtMenu) \\n\\\&
           !Lock Ctrl <Btn2Down>:\fBpopup\-menu\fP(vtMenu) \\n\\\&
 !Lock Ctrl @Num_Lock <Btn2Down>:\fBpopup\-menu\fP(vtMenu) \\n\\\&
     ! @Num_Lock Ctrl <Btn2Down>:\fBpopup\-menu\fP(vtMenu) \\n\\\&
          ~Ctrl ~Meta <Btn2Down>:\fBignore\fP() \\n\\\&
                 Meta <Btn2Down>:\fBclear\-saved\-lines\fP() \\n\\\&
            ~Ctrl ~Meta <Btn2Up>:\fBinsert\-selection\fP(\fBSELECT\fP, \fBCUT_BUFFER0\fP) \\n\\\&
                !Ctrl <Btn3Down>:\fBpopup\-menu\fP(fontMenu) \\n\\\&
           !Lock Ctrl <Btn3Down>:\fBpopup\-menu\fP(fontMenu) \\n\\\&
 !Lock Ctrl @Num_Lock <Btn3Down>:\fBpopup\-menu\fP(fontMenu) \\n\\\&
     ! @Num_Lock Ctrl <Btn3Down>:\fBpopup\-menu\fP(fontMenu) \\n\\\&
          ~Ctrl ~Meta <Btn3Down>:\fBstart\-extend\fP() \\n\\\&
              ~Meta <Btn3Motion>:\fBselect\-extend\fP() \\n\\\&
                 Ctrl <Btn4Down>:\fBscroll\-back\fP(1,halfpage,m) \\n\\\&
            Lock Ctrl <Btn4Down>:\fBscroll\-back\fP(1,halfpage,m) \\n\\\&
  Lock @Num_Lock Ctrl <Btn4Down>:\fBscroll\-back\fP(1,halfpage,m) \\n\\\&
       @Num_Lock Ctrl <Btn4Down>:\fBscroll\-back\fP(1,halfpage,m) \\n\\\&
                      <Btn4Down>:\fBscroll\-back\fP(5,line,m)     \\n\\\&
                 Ctrl <Btn5Down>:\fBscroll\-forw\fP(1,halfpage,m) \\n\\\&
            Lock Ctrl <Btn5Down>:\fBscroll\-forw\fP(1,halfpage,m) \\n\\\&
  Lock @Num_Lock Ctrl <Btn5Down>:\fBscroll\-forw\fP(1,halfpage,m) \\n\\\&
       @Num_Lock Ctrl <Btn5Down>:\fBscroll\-forw\fP(1,halfpage,m) \\n\\\&
                      <Btn5Down>:\fBscroll\-forw\fP(5,line,m)     \\n\\\&
                         <BtnUp>:\fBselect\-end\fP(\fBSELECT\fP, \fBCUT_BUFFER0\fP) \\n\\\&
                       <BtnDown>:\fBignore\fP()
.NE
.PP
The default bindings in the Tektronix window are analogous but less extensive.
These are for the \fItek4014\fP widget:
.NS
                 ~Meta<KeyPress>: \fBinsert\-seven\-bit\fP() \\n\\\&
                  Meta<KeyPress>: \fBinsert\-eight\-bit\fP() \\n\\\&
                !Ctrl <Btn1Down>: \fBpopup\-menu\fP(mainMenu) \\n\\\&
           !Lock Ctrl <Btn1Down>: \fBpopup\-menu\fP(mainMenu) \\n\\\&
 !Lock Ctrl @Num_Lock <Btn1Down>: \fBpopup\-menu\fP(mainMenu) \\n\\\&
      !Ctrl @Num_Lock <Btn1Down>: \fBpopup\-menu\fP(mainMenu) \\n\\\&
                !Ctrl <Btn2Down>: \fBpopup\-menu\fP(tekMenu) \\n\\\&
           !Lock Ctrl <Btn2Down>: \fBpopup\-menu\fP(tekMenu) \\n\\\&
 !Lock Ctrl @Num_Lock <Btn2Down>: \fBpopup\-menu\fP(tekMenu) \\n\\\&
      !Ctrl @Num_Lock <Btn2Down>: \fBpopup\-menu\fP(tekMenu) \\n\\\&
           Shift ~Meta<Btn1Down>: \fBgin\-press\fP(L) \\n\\\&
                 ~Meta<Btn1Down>: \fBgin\-press\fP(l) \\n\\\&
           Shift ~Meta<Btn2Down>: \fBgin\-press\fP(M) \\n\\\&
                 ~Meta<Btn2Down>: \fBgin\-press\fP(m) \\n\\\&
           Shift ~Meta<Btn3Down>: \fBgin\-press\fP(R) \\n\\\&
                 ~Meta<Btn3Down>: \fBgin\-press\fP(r)
.NE
.SS Custom Key Bindings
.PP
You can modify the \fBtranslations\fP resource by overriding parts
of it, or merging your resources with it.
.PP
Here is an example which uses shifted select/paste to copy to the clipboard,
and unshifted select/paste for the primary selection.
In each case, a (different) cut buffer is
also a target or source of the select/paste operation.
It is important to remember however,
that cut buffers store data in ISO-8859-1 encoding,
while selections can store data in a variety of formats and encodings.
While \fI\*n\fP owns the selection, it highlights it.
When it loses the selection, it removes the corresponding highlight.
But you can still paste from the corresponding cut buffer.
.NS
*VT100*translations:    #override \\n\\\&
   ~Shift~Ctrl<Btn2Up>: \fBinsert\-selection\fP(\fBPRIMARY\fP, \fBCUT_BUFFER0\fP) \\n\\\&
    Shift~Ctrl<Btn2Up>: \fBinsert\-selection\fP(\fBCLIPBOARD\fP, \fBCUT_BUFFER1\fP) \\n\\\&
   ~Shift     <BtnUp> : \fBselect\-end\fP(\fBPRIMARY\fP, \fBCUT_BUFFER0\fP) \\n\\\&
    Shift     <BtnUp> : \fBselect\-end\fP(\fBCLIPBOARD\fP, \fBCUT_BUFFER1\fP)
.NE
.PP
In the example, the class name \fBVT100\fP is used rather than the widget name.
These are different; a class name could apply to more than one widget.
A leading \*(``*\*('' is used because the widget hierarchy above the
\fIvt100\fP widget depends on
whether the toolbar support is compiled into \fI\*n\fP.
.PP
Most of the predefined translations are related to the mouse,
with a few that use some of the special keys on the keyboard.
Applications use special keys (function-keys, cursor-keys, keypad-keys)
with modifiers (shift, control, alt).
If \fI\*n\fP defines a translation for a given combination of
special key and modifier, that makes it unavailable for use
by applications within the terminal.
For instance, one might extend the use of \fIPage Up\fP and \fIPage Down\fP
keys seen here:
.NS
    Shift <KeyPress> Prior : \fBscroll\-back\fP(1,halfpage) \\n\\\&
    Shift <KeyPress> Next  : \fBscroll\-forw\fP(1,halfpage) \\n\\\&
.NE
.PP
to the \fIHome\fP and \fIEnd\fP keys:
.NS
    Shift <KeyPress> Home : \fBscroll\-to\fP(begin) \\n\\\&
    Shift <KeyPress> End  : \fBscroll\-to\fP(end)
.NE
.PP
but then shift\-\fIHome\fP and shift\-\fIEnd\fP would then
be unavailable to applications.
.PP
Not everyone finds the three-button mouse bindings easy to use.
In a wheel mouse, the middle button might be the wheel.
As an alternative, you could add a binding using shifted keys:
.NS
*VT100*translations:      #override \\n\\\&
    Shift <Key>Home:    \fBcopy\-selection\fP(\fBSELECT\fP) \\n\\\&
    Shift <Key>Insert:  \fBcopy\-selection\fP(\fBSELECT\fP) \\n\\\&
    Ctrl Shift <Key>C:  \fBcopy\-selection\fP(\fBSELECT\fP) \\n\\\&
    Ctrl Shift <Key>V:  \fBinsert\-selection\fP(\fBSELECT\fP)
.NE
.PP
You would still use the left- and right-mouse buttons (typically 1 and 3)
for beginning and extending selections.
.PP
Besides mouse problems, there are also keyboards with inconvenient layouts.
Some lack a numeric keypad, making it hard to use the shifted keypad plus
and minus bindings for switching between font sizes.
You can work around that by assigning the actions to more readily accessed
keys:
.NS
*VT100*translations:      #override \\n\\\&
    Ctrl <Key> +:       \fBlarger\-vt\-font\fP() \\n\\\&
    Ctrl <Key> \-:       \fBsmaller\-vt\-font\fP()
.NE
.PP
The keymap feature allows you to switch between sets of translations.
The sample below shows
how the \fBkeymap()\fP action may be used to add special
keys for entering commonly-typed words:
.NS
*VT100.Translations: #override <Key>F13: keymap(dbx)
*VT100.dbxKeymap.translations: \\\&
        <Key>F14:       \fBkeymap\fP(None) \\n\\\&
        <Key>F17:       \fBstring\fP("next") \\n\\\&
                        \fBstring\fP(0x0d) \\n\\\&
        <Key>F18:       \fBstring\fP("step") \\n\\\&
                        \fBstring\fP(0x0d) \\n\\\&
        <Key>F19:       \fBstring\fP("continue") \\n\\\&
                        \fBstring\fP(0x0d) \\n\\\&
        <Key>F20:       \fBstring\fP("print ") \\n\\\&
                        \fBinsert\-selection\fP(\fBPRIMARY\fP, \fBCUT_BUFFER0\fP)
.NE
.SS Default Scrollbar Bindings
.PP
Key bindings are normally associated with the \fIvt100\fP or \fItek4014\fP
widgets which act as terminal emulators.
\fI\*N\fP's scrollbar (and toolbar if it is configured) are separate widgets.
Because all of these use the X Toolkit,
they have corresponding \fBtranslations\fP resources.
Those resources are distinct,
and match different patterns, e.g., the differences in widget-name and
number of levels of widgets which they may contain.
.PP
The \fIscrollbar\fP widget is a child of the \fIvt100\fP widget.
It is positioned on top of the \fIvt100\fP widget.
Toggling the scrollbar on and off causes the \fIvt100\fP widget to resize.
.PP
The default bindings for the scrollbar widget use only mouse-button events:
.NS
   <Btn5Down>: StartScroll(Forward) \\n\\\&
   <Btn1Down>: StartScroll(Forward) \\n\\\&
   <Btn2Down>: StartScroll(Continuous) MoveThumb() NotifyThumb() \\n\\\&
   <Btn3Down>: StartScroll(Backward) \\n\\\&
   <Btn4Down>: StartScroll(Backward) \\n\\\&
   <Btn2Motion>: MoveThumb() NotifyThumb() \\n\\\&
   <BtnUp>:    NotifyScroll(Proportional) EndScroll()
.NE
.PP
Events which the \fIscrollbar\fP widget does not recognize at all are lost.
.PP
However, at startup, \fI\*n\fP augments these translations with the default
translations used for the \fIvt100\fP widget,
together with the resource \*(``actions\*('' which those translations use.
Because the \fIscrollbar\fP (or \fImenubar\fP) widgets do not recognize these
actions (but because it has a corresponding translation),
they are passed on to the \fIvt100\fP widget.
.PP
This augmenting of the scrollbar's translations has a few limitations:
.bP
\fI\*N\fP knows what the default translations are,
but there is no suitable library interface for determining what
customizations a user may have added to the \fIvt100\fP widget.
All that \fI\*n\fP can do is augment the \fIscrollbar\fP widget to
give it the same starting point for further customization by the user.
.bP
Events in the gap between the widgets may be lost.
.bP
Compose sequences begun in one widget cannot be completed in the other,
because the input methods for each widget do not share context information.
.PP
Most customizations of the scrollbar translations do not concern key bindings.
Rather, users are generally more interested in changing the bindings of the
mouse buttons.
For example, some people prefer using the left pointer button
for dragging the scrollbar thumb.
That can be set up by altering the translations resource, e.g.,
.NS
*VT100.scrollbar.translations:  #override \\n\\\&
   <Btn5Down>:     StartScroll(Forward) \\n\\\&
   <Btn1Down>:     StartScroll(Continuous) MoveThumb() NotifyThumb() \\n\\\&
   <Btn4Down>:     StartScroll(Backward) \\n\\\&
   <Btn1Motion>:   MoveThumb() NotifyThumb() \\n\\\&
   <BtnUp>:        NotifyScroll(Proportional) EndScroll()
.NE
.SH "CONTROL SEQUENCES AND KEYBOARD"
Applications can send sequences of characters to the terminal to change its
behavior.
Often they are referred to as
\*(``ANSI escape sequences\*('' or just plain
\*(``escape sequences\*('' but both terms are misleading:
.bP
ANSI x3.64 (obsolete) which was replaced by ISO 6429 (ECMA-48) gave rules
for the \fIformat\fP of these sequences of characters.
.bP
While the original VT100 was claimed to be ANSI-compatible (against x3.64),
there is no freely available version of the ANSI standard to show where
the VT100 differs.
Most of the documents which mention the ANSI standard have
additions not found in the original (such as those
based on \fBansi.sys\fP).
So this discussion focuses on the ISO standards.
.bP
The standard describes only sequences sent from the host to the terminal.
There is no standard for sequences sent by special keys from the terminal
to the host.
By convention (and referring to existing terminals), the format of those
sequences usually conforms to the host-to-terminal standard.
.bP
Some of \fI\*n\fP's sequences do not fit into the standard scheme.
Technically those are \*(``unspecified\*(''.
As an example,
DEC Screen Alignment Test (DECALN) is this three-character sequence:
.NS
\fIESC\fP # 8
.NE
.PP
.bP
Some sequences fit into the standard format,
but are not listed in the standard.
These include the sequences used for setting up scrolling margins
and doing forward/reverse scrolling.
.bP
Some of the sequences (in particular, the single-character functions
such as tab and backspace)
do not include the \fIescape\fP character.
.PP
With all of that in mind, the standard refers to these sequences of
characters as \*(``control sequences\*(''.
.PP
\fI\*N Control Sequences\fP lists the control sequences which
an application can send \fI\*n\fP to make it perform various operations.
Most of these operations are standardized, from either the DEC or Tektronix
terminals, or from more widely used standards such as ISO-6429.
.PP
A few examples of usage are given in this section.
.SS Window and Icon Titles
.PP
Some scripts use \fBecho\fP with options \fB\-e\fP and \fB\-n\fP to tell
the shell to interpret the string \*(``\\e\*('' as
the \fIescape\fP character and
to suppress a trailing newline on output.
Those are not portable, nor recommended.
Instead, use \fBprintf\fP (POSIX).
.PP
For example, to set the \fIwindow title\fP to \*(``Hello world!\*('',
you could use one of these commands in a script:
.NS
printf \*(AQ\\033]2;Hello world!\\033\\\*(AQ
printf \*(AQ\\033]2;Hello world!\\007\*(AQ
printf \*(AQ\\033]2;%s\\033\\\*(AQ "Hello world!"
printf \*(AQ\\033]2;%s\\007\*(AQ "Hello world!"
.NE
.PP
The \fBprintf\fP command interprets the octal value \*(``\\033\*('' for
\fIescape\fP, and (since it was not given in the format) omits a trailing
newline from the output.
.PP
Some programs (such as \fBscreen\fP(1)) set both window- and icon-titles
at the same time, using a slightly different control sequence:
.NS
printf \*(AQ\\033]0;Hello world!\\033\\\*(AQ
printf \*(AQ\\033]0;Hello world!\\007\*(AQ
printf \*(AQ\\033]0;%s\\033\\\*(AQ "Hello world!"
printf \*(AQ\\033]0;%s\\007\*(AQ "Hello world!"
.NE
.PP
The difference is the \fIparameter\fP \*(``0\*('' in each command.
Most window managers will honor either window title or icon title.
Some will make a distinction and allow you to set just the icon title.
You can tell \fI\*n\fP to ask for this with a different parameter
in the control sequence:
.NS
printf \*(AQ\\033]1;Hello world!\\033\\\*(AQ
printf \*(AQ\\033]1;Hello world!\\007\*(AQ
printf \*(AQ\\033]1;%s\\033\\\*(AQ "Hello world!"
printf \*(AQ\\033]1;%s\\007\*(AQ "Hello world!"
.NE
.
.SS Special Keys
.PP
\fI\*N\fP, like any VT100-compatible terminal emulator,
has two modes for the \fIspecial keys\fP (cursor-keys, numeric keypad,
and certain function-keys):
.bP
\fInormal mode\fP, which makes the special keys transmit
\*(``useful\*('' sequences such as the control sequence for cursor-up
when pressing the up-arrow, and
.bP
\fIapplication mode\fP,
which uses a different control sequence that cannot be mistaken for
the
\*(``useful\*('' sequences.
.PP
The main difference between the two modes is that normal mode sequences
start with \fICSI\fP (\fIescape\ [\fP) and application mode sequences
start with \fISS3\fP (\fIescape\ O\fP).
.PP
The terminal is initialized into one of these two modes (usually the
normal mode), based on the terminal description (termcap or terminfo).
The terminal description also has capabilities (strings) defined for
the keypad mode used in curses applications.
.PP
There is a problem in using the terminal description for applications
that are not intended to be full-screen curses applications:
the definitions of special keys are only correct for this keypad mode.
For example, some shells
(unlike \fBksh\fP(1), which appears to be hard-coded, not even using termcap)
allow their users to customize key-bindings,
assigning shell actions to special keys.
.bP
\fBbash\fP(1) allows \fIconstant\fP strings to be assigned
to functions.
This is only successful if the terminal is initialized to application
mode by default,
because \fBbash\fP lacks flexibility in this area.
It uses a (less expressive than \fBbash\fP's)
\fBreadline\fP scripting language for setting up key bindings,
which relies upon the user to statically enumerate the possible bindings for
given values of \fB$TERM\fP.
.bP
\fBzsh\fP(1) provides an analogous feature,
but it accepts runtime expressions,
as well as providing a \fB$terminfo\fP array for scripts.
In particular, one can use the terminal database,
transforming when defining a key-binding.
By transforming the output so that \fICSI\fP and \fISS3\fP are equated,
\fBzsh\fP can use the terminal database to obtain useful definitions
for its command-line use regardless of whether the terminal uses
normal or application mode initially.
Here is an example:
.NS
[[ "$terminfo[kcuu1]" == "^[O"* ]] && \\\&
bindkey \-M viins "${terminfo[kcuu1]/O/[}" \\\&
vi\-up\-line\-or\-history
.NE
.
.
.SS Changing Colors
.PP
A few shell programs provide the ability for users to add color and other
video attributes to the shell prompt strings.
Users can do this by setting \fB$PS1\fP (the primary prompt string).
Again, \fBbash\fP and \fBzsh\fP have provided features not found in \fBksh\fP.
There is a problem, however: the prompt's width on the screen will not
necessarily be the same as the number of characters.
Because there is no guidance in the POSIX standard, each shell addresses
the problem in a different way:
.bP
\fBbash\fP treats characters within
\*(``\\[\*('' and
\*(``\\]\*(''
as nonprinting (using no width on the screen).
.bP
\fBzsh\fP treats characters within
\*(``%{\*('' and
\*(``%}\*(''
as nonprinting.
.PP
In addition to the difference in syntax,
the shells provide different methods for obtaining useful escape sequences:
.bP
As noted in \fBSpecial Keys\fP, \fBzsh\fP initializes the $terminfo array
with the terminal capabilities.
.IP
It also provides a function \fBechoti\fP which works like \fBtput\fP(1)
to convert a terminal capability with its parameters into a string
that can be written to the terminal.
.bP
Shells lacking a comparable feature (such as \fBbash\fP) can always
use the program \fBtput\fP to do this transformation.
.PP
Hard-coded escape sequences are supported by each shell,
but are not recommended because those rely upon particular configurations
and cannot be easily moved between different user environments.
.
.
.SH ENVIRONMENT
\fI\*N\fP sets several environment variables.
.SS System Independent
.PP
Some variables are used on every system:
.TP 5
.B DISPLAY
is the display name,
pointing to the X server (see \fIDISPLAY NAMES\fP in X(__miscmansuffix__)).
.TP 5
.B TERM
.br
is set according to the terminfo (or termcap) entry which it is using as
a reference.
.IP
On some systems, you may encounter situations where the shell which you
use and \fI\*n\fP are built using libraries with different terminal databases.
In that situation, \fI\*n\fP may choose a terminal description not known
to the shell.
.TP 5
.B WINDOWID
is set to the X window id number of the \fI\*n\fP window.
.TP 5
.B XTERM_FILTER
is set if a locale-filter is used.
The value is the pathname of the filter.
.TP 5
.B XTERM_LOCALE
shows the locale which was used by \fI\*n\fP on startup.
Some shell initialization scripts may set a different locale.
.TP 5
.B XTERM_SHELL
is set to the pathname of the program which is invoked.
Usually that is a shell program, e.g., \fI/bin/sh\fP.
Since it is not necessarily a shell program however,
it is distinct from \*(``SHELL\*(''.
.TP 5
.B XTERM_VERSION
is set to the string displayed by the \fB\-version\fP option.
That is normally an identifier for the X Window libraries used to
build \fI\*n\fP, followed by
\fI\*n\fP's patch number in parenthesis.
The patch number is also part of the response to a Secondary Device Attributes
(DA) control sequence (see \fIXterm Control Sequences\fP).
.
.SS System Dependent
.
.PP
Depending on your system configuration, \fI\*n\fP may also set the
following:
.TP 5
.B COLUMNS
the width of the \fI\*n\fP in characters (cf: \*(``stty columns\*('').
.IP
When this variable is set, \fIcurses\fP applications (and most
terminal programs) will assume that the terminal has this many columns.
.IP
\fI\*N\fP would do this for systems which have no ability
to tell the size of the terminal.
Those are very rare, none newer than the mid 1990s when SVR4 became prevalent.
.TP 5
.B HOME
.br
when \fI\*n\fP is configured (at build-time) to update utmp.
.TP 5
.B LINES
the height of the \fI\*n\fP in characters (cf: \*(``stty rows\*('').
.IP
When this variable is set, \fIcurses\fP applications (and most
terminal programs) will assume that the terminal has this many lines (rows).
.IP
\fI\*N\fP would do this for systems which have no ability
to tell the size of the terminal.
Those are very rare, none newer than the mid 1990s when SVR4 became prevalent.
.TP 5
.B LOGNAME
when \fI\*n\fP is configured (at build-time) to update utmp.
.IP
Your configuration may have set \fBLOGNAME\fP; \fI\*n\fP does not modify that.
If it is unset, \fI\*n\fP will use \fBUSER\fP if it is set.
Finally, if neither is set, \fI\*n\fP will use the \fBgetlogin\fP(3) function.
.TP 5
.B SHELL
when \fI\*n\fP is configured (at build-time) to update utmp.
It is also set if you provide a valid shell name as the optional parameter.
.IP
\fI\*N\fP sets this to an absolute pathname.
If you have set the variable to a relative pathname,
\fI\*n\fP may set it to a different shell pathname.
.IP
If you have set this to an pathname which does not correspond to a valid
shell, \fI\*n\fP may unset it, to avoid confusion.
.TP 5
.B TERMCAP
the contents of the termcap entry corresponding to \fB$TERM\fP,
with lines and columns values substituted
for the actual size window you have created.
.IP
This feature is, like \fBLINES\fP and \fBCOLUMNS\fP, used rarely.
It addresses the same limitation of a few older systems
by providing a way for \fItermcap\fP-based applications to get the initial
screen size.
.TP 5
.B TERMINFO
may be defined to a nonstandard location using the configure script.
.\"
.
.
.SH WINDOW PROPERTIES
.PP
In the output from \fBxprop\fP(1), there are several properties.
.SS Properties set by X Toolkit
.TP 5
.B WM_CLASS
This shows the \fIinstance name\fP and the X resource \fIclass\fP,
passed to X Toolkit during initialization of \fI\*n\fP,
e.g.,
.NS
WM_CLASS(STRING) = "xterm", "UXTerm"
.NE
.TP 5
.B WM_CLIENT_LEADER
This shows the window-id which \fI\*n\fP provides
with an environment variable (\fBWINDOWID\fP),
e.g.,
.NS
WM_CLIENT_LEADER(WINDOW): window id # 0x800023
.NE
.TP 5
.B WM_COMMAND
This shows the command-line arguments for \fI\*n\fP
which are passed to X Toolkit during initialization, e.g.,
.NS
WM_COMMAND(STRING) = { "xterm", "-class", "UXTerm", "-title", "uxterm", "-u8" }
.NE
.TP 5
.B WM_ICON_NAME
This holds the icon title,
which different window managers handle in various ways.
It is set via the \fBiconName\fP resource.
Applications can change this using control sequences.
.TP 5
.B WM_LOCALE_NAME
This shows the result from the \fBsetlocale\fP(3) function
for the \fILC_CTYPE\fP category,
e.g.,
.NS
WM_LOCALE_NAME(STRING) = "en_US.UTF-8"
.NE
.TP 5
.B WM_NAME
This holds the window title, normally at the top of \fI\*n\fP's window.
It is set via the \fBtitle\fP resource.
Applications can change this using control sequences.
.SS Properties set by Xterm
X Toolkit does not manage EWMH properties.
\*N does this directly.
.TP 5
.B _NET_WM_ICON_NAME
stores the icon name.
.TP 5
.B _NET_WM_NAME
stores the title string.
.TP 5
.B _NET_WM_PID
stores the process identifier for \fI\*n\fP's display.
.SS Properties used by Xterm
.TP 5
.B _NET_SUPPORTED
\*N checks this property on the \fIsupporting window\fP
to decide if the window manager supports
specific maximizing styles.
That may include other window manager hints;
\fI\*n\fP uses the X library calls to manage those.
.TP 5
.B _NET_SUPPORTING_WM_CHECK
\*N checks this to ensure that it will only update the EWMH
properties for a window manager which claims EWMH compliance.
.TP 5
.B _NET_WM_STATE
This tells \fI\*n\fP whether its window has been maximized by the window manager,
and if so, what type of maximizing:
.RS
.TP 5
.B _NET_WM_STATE_FULLSCREEN
.TP 5
.B _NET_WM_STATE_MAXIMIZED_HORZ
.TP 5
.B _NET_WM_STATE_MAXIMIZED_VERT
.RE
.PP
.
.
.SH FILES
The actual pathnames given may differ on your system.
.TP 5
\fI/etc/shells\fP
contains a list of valid shell programs,
used by \fI\*n\fP to decide if the \*(``SHELL\*('' environment
variable should be set for the process started by \fI\*n\fP.
.IP
On systems which have the \fIgetusershell\fP function,
\fI\*n\fP will use that function rather than directly reading the file,
since the file may not be present if the system uses default settings.
.TP 5
\fI/etc/utmp\fP
the system log file, which records user logins.
.TP 5
\fI/etc/wtmp\fP
the system log file, which records user logins and logouts.
.TP 5
.I __apploaddir__/__default_class__
the \fI\*n\fP default application resources.
.TP 5
.I __apploaddir__/__default_class__\-color
the \fI\*n\fP color application resources.
If your display supports color, use this
.NS
*customization: \-color
.NE
.IP
in your \&.Xdefaults file to
automatically use this resource file rather than
.IR __apploaddir__/__default_class__ .
If you do not do this,
\fI\*n\fP uses its compiled-in default resource settings for colors.
.TP 5
.I __pixmapsdir__
the directory in which \fI\*n\fP's pixmap icon files are installed.
.
.
.SH ERROR MESSAGES
Most of the fatal error messages from \fI\*n\fP use the following format:
.NS
\*n: Error \fIXXX\fP, errno \fIYYY\fP: \fIZZZ\fR
.NE
.PP
The \fIXXX\fP codes (which are used by \fI\*n\fP as its exit-code)
are listed below, with a brief explanation.
.TP 5
1
is used for miscellaneous errors, usually accompanied by a specific message,
.TP
11
ERROR_FIONBIO
.br
main: ioctl() failed on FIONBIO
.TP
12
ERROR_F_GETFL
.br
main: ioctl() failed on F_GETFL
.TP
13
ERROR_F_SETFL
.br
main: ioctl() failed on F_SETFL
.TP
14
ERROR_OPDEVTTY
.br
spawn: open() failed on /dev/tty
.TP
15
ERROR_TIOCGETP
.br
spawn: ioctl() failed on TIOCGETP
.TP
17
ERROR_PTSNAME
.br
spawn: ptsname() failed
.TP
18
ERROR_OPPTSNAME
.br
spawn: open() failed on ptsname
.TP
19
ERROR_PTEM
.br
spawn: ioctl() failed on I_PUSH/"ptem"
.TP
20
ERROR_CONSEM
.br
spawn: ioctl() failed on I_PUSH/"consem"
.TP
21
ERROR_LDTERM
.br
spawn: ioctl() failed on I_PUSH/"ldterm"
.TP
22
ERROR_TTCOMPAT
.br
spawn: ioctl() failed on I_PUSH/"ttcompat"
.TP
23
ERROR_TIOCSETP
.br
spawn: ioctl() failed on TIOCSETP
.TP
24
ERROR_TIOCSETC
.br
spawn: ioctl() failed on TIOCSETC
.TP
25
ERROR_TIOCSETD
.br
spawn: ioctl() failed on TIOCSETD
.TP
26
ERROR_TIOCSLTC
.br
spawn: ioctl() failed on TIOCSLTC
.TP
27
ERROR_TIOCLSET
.br
spawn: ioctl() failed on TIOCLSET
.TP
28
ERROR_INIGROUPS
.br
spawn: initgroups() failed
.TP
29
ERROR_FORK
.br
spawn: fork() failed
.TP
30
ERROR_EXEC
.br
spawn: exec() failed
.TP
32
ERROR_PTYS
.br
get_pty: not enough ptys
.TP
34
ERROR_PTY_EXEC
.br
waiting for initial map
.TP
35
ERROR_SETUID
.br
spawn: setuid() failed
.TP
36
ERROR_INIT
.br
spawn: can't initialize window
.TP
46
ERROR_TIOCKSET
.br
spawn: ioctl() failed on TIOCKSET
.TP
47
ERROR_TIOCKSETC
.br
spawn: ioctl() failed on TIOCKSETC
.TP
49
ERROR_LUMALLOC
.br
luit: command-line malloc failed
.TP
50
ERROR_SELECT
.br
in_put: select() failed
.TP
54
ERROR_VINIT
.br
VTInit: can't initialize window
.TP
57
ERROR_KMMALLOC1
.br
HandleKeymapChange: malloc failed
.TP
60
ERROR_TSELECT
.br
Tinput: select() failed
.TP
64
ERROR_TINIT
.br
TekInit: can't initialize window
.TP
71
ERROR_BMALLOC2
.br
SaltTextAway: malloc() failed
.TP
80
ERROR_LOGEXEC
.br
StartLog: exec() failed
.TP
83
ERROR_XERROR
.br
xerror: XError event
.TP
84
ERROR_XIOERROR
.br
xioerror: X I/O error
.TP
85
ERROR_ICEERROR
.br
ICE I/O error
.TP
90
ERROR_SCALLOC
.br
Alloc: calloc() failed on base
.TP
91
ERROR_SCALLOC2
.br
Alloc: calloc() failed on rows
.TP
102
ERROR_SAVE_PTR
.br
ScrnPointers: malloc/realloc() failed
.
.
.SH BUGS
.
.PP
Large pastes do not work on some systems.
This is not a bug in
\fI\*n\fP; it is a bug in the pseudo terminal driver of those
systems.
\fI\*N\fP feeds large pastes to the pty only as fast as the pty
will accept data, but some pty drivers do not return enough information
to know if the write has succeeded.
.
.PP
When connected to an input method, it is possible for \fI\*n\fP to hang
if the XIM server is suspended or killed.
.
.PP
Many of the options are not resettable after \fI\*n\fP starts.
.
.PP
This program still needs to be rewritten.
It should be split into very
modular sections, with the various emulators being completely separate
widgets that do not know about each other.
Ideally, you'd like to be able to
pick and choose emulator widgets and stick them into a single control widget.
.
.PP
There needs to be a dialog box to allow entry of the Tek COPY file name.
.
.
.SH "SEE ALSO"
.na
resize(__mansuffix__),
luit(__mansuffix__),
u\*n(__mansuffix__),
X(__miscmansuffix__),
pty(4),
tty(4)
.ad
.PP
\fIXterm Control Sequences\fP
(this is the file ctlseqs.ms).
.RS 4n
.sp
https://invisible\-island.net/xterm/xterm.html
.br
https://invisible\-island.net/xterm/manpage/xterm.html
.br
https://invisible\-island.net/xterm/ctlseqs/ctlseqs.html
.br
https://invisible\-island.net/xterm/xterm.faq.html
.br
https://invisible\-island.net/xterm/xterm.log.html
.RE
.PP
\fIX Toolkit Intrinsics \(en C Language Interface\fP,
.br
Joel McCormack, Paul Asente, Ralph R. Swick (1994),
.br
Thomas E. Dickey (2019).
.PP
\fIInter-Client Communication Conventions Manual\fR (ICCCM),
.br
David Rosenthal and
Stuart W. Marks (version 2.0, 1994).
.PP
\fIExtended Window Manager Hints\fP (EWMH),
.br
X Desktop Group (version 1.3, 2005).
.PP
EWMH uses \fIUTF8_STRING\fP pervasively without defining it,
but does mention the ICCCM.
Version 2.0 of the ICCCM does not address UTF-8.
That is an extension added in XFree86.
.bP
Markus Kuhn summarized this in 
\fIUTF-8 and Unicode FAQ for Unix/Linux\fP (2001),
in the section \*(``Is X11 ready for Unicode?\*(''
.IP
https://www.cl.cam.ac.uk/~mgk25/unicode.html
.bP
Juliusz Chroboczek proposed the UTF8_STRING selection atom in 1999/2000,
which became part of the ICCCM in XFree86.
.IP
https://www.irif.fr/~jch/software/UTF8_STRING/
.IP
An Xorg developer removed that part of the documentation in 2004
when incorporating other work from XFree86 into Xorg.
The feature is still supported in Xorg, though undocumented as of 2019.
.
.SH AUTHORS
Far too many people.
.PP
These contributed to the X Consortium:
Loretta Guarino Reid (DEC-UEG-WSL),
Joel McCormack (DEC-UEG-WSL), Terry Weissman (DEC-UEG-WSL),
Edward Moy (Berkeley), Ralph R.\& Swick (MIT-Athena),
Mark Vandevoorde (MIT-Athena), Bob McNamara (DEC-MAD),
Jim Gettys (MIT-Athena), Bob Scheifler (MIT X Consortium), Doug Mink (SAO),
Steve Pitschke (Stellar), Ron Newman (MIT-Athena), Jim Fulton (MIT X
Consortium), Dave Serisky (HP), Jonathan Kamens (MIT-Athena).
.PP
Beginning with XFree86, there were far more identifiable contributors.
The \fITHANKS\fP file in \fI\*n\fP's source lists 211 at the end of 2018.
Keep in mind these:
Jason Bacon,
Jens Schweikhardt,
Ross Combs,
Stephen P.\& Wall,
David Wexelblat, and
Thomas Dickey (invisible-island.net).
