#ifndef INTEL_DRIVER_H
#define INTEL_DRIVER_H

struct xf86_platform_device;

#define INTEL_VERSION 4000
#define INTEL_NAME "intel"
#define INTEL_DRIVER_NAME "intel"

#define INTEL_VERSION_MAJOR PACKAGE_VERSION_MAJOR
#define INTEL_VERSION_MINOR PACKAGE_VERSION_MINOR
#define INTEL_VERSION_PATCH PACKAGE_VERSION_PATCHLEVEL

#define PCI_CHIP_I810		0x7121
#define PCI_CHIP_I810_DC100	0x7123
#define PCI_CHIP_I810_E		0x7125
#define PCI_CHIP_I815		0x1132

#define PCI_CHIP_I830_M		0x3577
#define PCI_CHIP_845_G		0x2562
#define PCI_CHIP_I854		0x358E
#define PCI_CHIP_I855_GM	0x3582
#define PCI_CHIP_I865_G		0x2572

#define PCI_CHIP_I915_G		0x2582
#define PCI_CHIP_I915_GM	0x2592
#define PCI_CHIP_E7221_G	0x258A
#define PCI_CHIP_I945_G		0x2772
#define PCI_CHIP_I945_GM        0x27A2
#define PCI_CHIP_I945_GME	0x27AE
#define PCI_CHIP_PINEVIEW_M	0xA011
#define PCI_CHIP_PINEVIEW_G	0xA001
#define PCI_CHIP_Q35_G		0x29B2
#define PCI_CHIP_G33_G		0x29C2
#define PCI_CHIP_Q33_G		0x29D2

#define PCI_CHIP_G35_G		0x2982
#define PCI_CHIP_I965_Q		0x2992
#define PCI_CHIP_I965_G		0x29A2
#define PCI_CHIP_I946_GZ	0x2972
#define PCI_CHIP_I965_GM        0x2A02
#define PCI_CHIP_I965_GME       0x2A12
#define PCI_CHIP_GM45_GM	0x2A42
#define PCI_CHIP_G45_E_G	0x2E02
#define PCI_CHIP_G45_G		0x2E22
#define PCI_CHIP_Q45_G		0x2E12
#define PCI_CHIP_G41_G		0x2E32
#define PCI_CHIP_B43_G		0x2E42
#define PCI_CHIP_B43_G1		0x2E92

#define PCI_CHIP_IRONLAKE_D_G		0x0042
#define PCI_CHIP_IRONLAKE_M_G		0x0046

#define PCI_CHIP_SANDYBRIDGE_GT1	0x0102
#define PCI_CHIP_SANDYBRIDGE_GT2	0x0112
#define PCI_CHIP_SANDYBRIDGE_GT2_PLUS	0x0122
#define PCI_CHIP_SANDYBRIDGE_M_GT1	0x0106
#define PCI_CHIP_SANDYBRIDGE_M_GT2	0x0116
#define PCI_CHIP_SANDYBRIDGE_M_GT2_PLUS	0x0126
#define PCI_CHIP_SANDYBRIDGE_S_GT	0x010A

#define PCI_CHIP_IVYBRIDGE_M_GT1	0x0156
#define PCI_CHIP_IVYBRIDGE_M_GT2	0x0166
#define PCI_CHIP_IVYBRIDGE_D_GT1	0x0152
#define PCI_CHIP_IVYBRIDGE_D_GT2	0x0162
#define PCI_CHIP_IVYBRIDGE_S_GT1	0x015a
#define PCI_CHIP_IVYBRIDGE_S_GT2	0x016a

#define PCI_CHIP_HASWELL_D_GT1		0x0402
#define PCI_CHIP_HASWELL_D_GT2		0x0412
#define PCI_CHIP_HASWELL_D_GT3		0x0422
#define PCI_CHIP_HASWELL_M_GT1		0x0406
#define PCI_CHIP_HASWELL_M_GT2		0x0416
#define PCI_CHIP_HASWELL_M_GT3		0x0426
#define PCI_CHIP_HASWELL_S_GT1		0x040A
#define PCI_CHIP_HASWELL_S_GT2		0x041A
#define PCI_CHIP_HASWELL_S_GT3		0x042A
#define PCI_CHIP_HASWELL_B_GT1		0x040B
#define PCI_CHIP_HASWELL_B_GT2		0x041B
#define PCI_CHIP_HASWELL_B_GT3		0x042B
#define PCI_CHIP_HASWELL_E_GT1		0x040E
#define PCI_CHIP_HASWELL_E_GT2		0x041E
#define PCI_CHIP_HASWELL_E_GT3		0x042E

#define PCI_CHIP_HASWELL_ULT_D_GT1	0x0A02
#define PCI_CHIP_HASWELL_ULT_D_GT2	0x0A12
#define PCI_CHIP_HASWELL_ULT_D_GT3	0x0A22
#define PCI_CHIP_HASWELL_ULT_M_GT1	0x0A06
#define PCI_CHIP_HASWELL_ULT_M_GT2	0x0A16
#define PCI_CHIP_HASWELL_ULT_M_GT3	0x0A26
#define PCI_CHIP_HASWELL_ULT_S_GT1	0x0A0A
#define PCI_CHIP_HASWELL_ULT_S_GT2	0x0A1A
#define PCI_CHIP_HASWELL_ULT_S_GT3	0x0A2A
#define PCI_CHIP_HASWELL_ULT_B_GT1	0x0A0B
#define PCI_CHIP_HASWELL_ULT_B_GT2	0x0A1B
#define PCI_CHIP_HASWELL_ULT_B_GT3	0x0A2B
#define PCI_CHIP_HASWELL_ULT_E_GT1	0x0A0E
#define PCI_CHIP_HASWELL_ULT_E_GT2	0x0A1E
#define PCI_CHIP_HASWELL_ULT_E_GT3	0x0A2E

#define PCI_CHIP_HASWELL_CRW_D_GT1	0x0D02
#define PCI_CHIP_HASWELL_CRW_D_GT2	0x0D12
#define PCI_CHIP_HASWELL_CRW_D_GT3	0x0D22
#define PCI_CHIP_HASWELL_CRW_M_GT1	0x0D06
#define PCI_CHIP_HASWELL_CRW_M_GT2	0x0D16
#define PCI_CHIP_HASWELL_CRW_M_GT3	0x0D26
#define PCI_CHIP_HASWELL_CRW_S_GT1	0x0D0A
#define PCI_CHIP_HASWELL_CRW_S_GT2	0x0D1A
#define PCI_CHIP_HASWELL_CRW_S_GT3	0x0D2A
#define PCI_CHIP_HASWELL_CRW_B_GT1	0x0D0B
#define PCI_CHIP_HASWELL_CRW_B_GT2	0x0D1B
#define PCI_CHIP_HASWELL_CRW_B_GT3	0x0D2B
#define PCI_CHIP_HASWELL_CRW_E_GT1	0x0D0E
#define PCI_CHIP_HASWELL_CRW_E_GT2	0x0D1E
#define PCI_CHIP_HASWELL_CRW_E_GT3	0x0D2E

struct intel_device_info {
	int gen;
};

int intel_entity_get_devid(int index);

void intel_detect_chipset(ScrnInfoPtr scrn, EntityInfoPtr ent);

int intel_open_device(int entity_num,
		      const struct pci_device *pci,
		      struct xf86_platform_device *dev);
int intel_get_device(ScrnInfoPtr scrn);
const char *intel_get_client_name(ScrnInfoPtr scrn);
int intel_get_device_id(ScrnInfoPtr scrn);
int intel_get_master(ScrnInfoPtr scrn);
int intel_put_master(ScrnInfoPtr scrn);
void intel_put_device(ScrnInfoPtr scrn);

#define hosted() (0)

#endif /* INTEL_DRIVER_H */
