/*
* Copyright (c) 2020-2023, Intel Corporation
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
* THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
* OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*/
//!
//! \file     encode_avc_vdenc_const_settings.cpp
//! \brief    Defines the common interface for avc vdenc const settings
//! \details  The encode feature manager is further sub-divided by platform type
//!           this file is for the base interface which is shared by all components.
//!

#include "encode_avc_vdenc_const_settings.h"
#include "encode_utils.h"
#include "mos_utilities.h"
#include "codec_def_encode.h"

namespace encode
{

const uint8_t AvcVdencCMD3ConstSettings::AvcVdencCMD3ConstSettings_0[8][52] = {
    {
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    },
    {
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    },
    {
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    },
    {
        5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
        5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
        5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
        5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    },
    {
        10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
        10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
        10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
        10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    },
    {
        10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
        10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
        10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
        10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    },
    {
        26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
        26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
        26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
        26, 26, 26, 26, 26, 31, 31, 31, 31, 31, 31, 31, 31,
    },
    {
        26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
        26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
        26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
        26, 26, 26, 31, 42, 45, 45, 45, 45, 45, 45, 45, 45,
    }
};

const uint8_t AvcVdencCMD3ConstSettings::AvcVdencCMD3ConstSettings_1[3][12] =
{
    {0,   0,    0,    0,    0,     0,    0,    0,    0,    0,     0,    0},
    {4,  12,   20,   28,   36,    44,   52,   60,   68,   76,    84,   92},
    {0,   8,    8,   24,   40,    48,   56,   64,   72,   88,   104,  120},
};

const uint8_t AvcVdencCMD3ConstSettings::AvcVdencCMD3ConstSettings_2[3][13] =
{
    {12,  28,  24,  72,    0,   0,   0,  0,   0,  0,  4,  0,  0},
    {12,  32,  40,  88,   16,  10,  18,  8,   0,  4,  4,  0,  0},
    {12,  40,  56,  104,  32,  22,  33,  16,  4,  4,  4,  0,  8},
};

const uint8_t AvcVdencCMD3ConstSettings::AvcVdencCMD3ConstSettings_3[3][52] =
{
    {
        28,   28,   28,   28,   28,   28,   28,   28,   28,   28,   28,   28,   28,
        32,   36,   44,   48,   26,   30,   32,   36,   26,   30,   30,   24,   28,
        24,   24,   20,   20,   22,   20,   20,   20,   18,   18,   16,   16,   16,
        16,   16,   16,   16,   16,   16,   16,   16,   14,   14,   14,   14,   14,
    },
    {
        12,   12,   12,   12,   12,   12,   12,   12,   12,   12,   12,   12,   12,
        14,   16,   18,   20,   10,   12,   14,   16,   12,   14,   14,   14,   14,
        12,   14,   14,   12,   14,   14,   14,   14,   14,   14,   14,   14,   14,
        14,   14,   14,   14,   14,   14,   14,   14,   14,   14,   14,   14,   14,
    },
    {
        14,   14,   14,   14,   14,   14,   14,   14,   14,   14,   14,   14,   14,
        14,   14,   14,   14,   14,   14,   14,   14,   14,   14,   14,   14,   14,
        14,   14,   14,   14,   14,   14,   14,   14,   14,   14,   14,   14,   14,
        14,   14,   14,   14,   14,   14,   14,   14,   14,   14,   14,   14,   14,
    }
};

const uint8_t AvcVdencCMD3ConstSettings::AvcVdencCMD3ConstSettings_4[52] =
{
    45,   45,   45,   45,   45,   45,   45,   45,   45,   45,   45,  45,   45,
    47,   56,   57,   59,   44,   45,   47,   56,   44,   47,   47,  45,   47,
    47,   47,   47,   45,   47,   47,   56,   47,   47,   47,   47,  47,   47,
    47,   47,   47,   47,   47,   47,   47,   47,   47,   47,   47,  47,   47,
};

const uint16_t AvcVdencCMD3ConstSettings::AvcVdencCMD3ConstSettings_5[4][2][40] =
{
    {
        {
                 2,    3,    4,    5,    6,    8,    10,    13,    16,    20,
                26,   33,   41,   52,   66,   83,   104,   132,   166,   209,  
               264,  332,  419,  528,  665,  838,  1056,  1331,  1677,  2113,
              2662, 3354, 4226, 5324, 6708, 8452, 10649, 13417, 16905, 21299,
        },
        {
                 2,    3,    4,    5,    6,    8,    10,    13,    16,    20,
                26,   33,   41,   52,   66,   83,   104,   132,   166,   209,
               264,  332,  419,  528,  665,  838,  1056,  1331,  1677,  2113,
              2662, 3354, 4226, 5324, 6708, 8452, 10649, 13417, 16905, 21299,
        },
    },
    {
        {
                  2,    2,    3,    4,    5,    6,    8,    10,    12,    16,
                 20,   25,   32,   40,   50,   64,   80,   101,   128,   161,
                203,  256,  322,  406,  512,  645,  812,  1024,  1290,  1625,
               2048, 2580, 3250, 4096, 5160, 6501, 8192, 10321, 13003, 16384,
        },
        {
                  3,    4,    5,    6,    8,    10,    12,    16,    20,    25,
                 32,   40,   51,   64,   81,   102,   129,   162,   204,   258,
                325,  409,  516,  650,  819,  1032,  1300,  1638,  2064,  2600,
               3276, 4128, 5201, 6553, 8257, 10403, 13107, 16514, 20806, 26214, 
        },
    },
    {
        {
                  4,    6,    7,    9,    12,    15,    19,    24,    30,    38,
                 48,   60,   76,   96,   121,   153,   193,   243,   307,   387,
                487,  614,  774,  975,  1228,  1548,  1950,  2457,  3096,  3901,
               4915, 6192, 7802, 9830, 12385, 15604, 19660, 24771, 31209, 39321, 
        },
        {
                  4,    6,    7,    9,    12,    15,    19,    24,    30,    38,
                 48,   60,   76,   96,   121,   153,   193,   243,   307,   387,
                487,  614,  774,  975,  1228,  1548,  1950,  2457,  3096,  3901,
               4915, 6192, 7802, 9830, 12385, 15604, 19660, 24771, 31209, 39321, 
        },
    },
    {
        {
                   3,    4,    5,    7,    9,    11,    14,    18,    22,    28,
                  36,   45,   57,   72,   91,   115,   145,   182,   230,   290,
                 365,  460,  580,  731,  921,  1161,  1462,  1843,  2322,  2925,
                3686, 4644, 5851, 7372, 9289, 11703, 14745, 18578, 23407, 29491,
        },
        {
                   3,    4,    5,    7,    9,    11,    14,    18,    22,    28,
                  36,   45,   57,   72,   91,   115,   145,   182,   230,   290,
                 365,  460,  580,  731,  921,  1161,  1462,  1843,  2322,  2925,
                3686, 4644, 5851, 7372, 9289, 11703, 14745, 18578, 23407, 29491,
        },
    }
};

const uint16_t AvcVdencCMD3ConstSettings::AvcVdencCMD3ConstSettings_6[4][2][40] =
{
    {
        {
             2,  2,   3,   3,   4,   4,   5,   5,   6,   7,
             8,  9,  10,  11,  13,  14,  16,  18,  20,  23,
            26, 29,  33,  37,  41,  46,  52,  58,  66,  74,
            83, 93, 104, 117, 132, 148, 166, 186, 209, 235, 
        },
        {
             2,  2,   3,   3,   4,   4,   5,   5,   6,   7,
             8,  9,  10,  11,  13,  14,  16,  18,  20,  23,
            26, 29,  33,  37,  41,  46,  52,  58,  66,  74,
            83, 93, 104, 117, 132, 148, 166, 186, 209, 235, 
        },
    },
    {
        {
              3,   3,   3,   4,   4,   5,   6,   6,   7,   8,
              9,  10,  12,  13,  15,  16,  19,  21,  24,  26,
             30,  33,  38,  42,  48,  53,  60,  67,  76,  85,
             96, 107, 120, 135, 152, 171, 192, 215, 241, 271, 
        },
        {
               3,   4,   4,   5,   5,   6,   7,   8,   9,  10,
              11,  12,  14,  16,  18,  20,  22,  25,  28,  32,
              36,  40,  45,  51,  57,  64,  72,  81,  91, 102,
             115, 129, 145, 162, 182, 205, 230, 258, 290, 325, 
        },
    },
    {
        {
                4,   4,   5,   6,   6,   7,   8,   9,  11,  12,
               13,  15,  17,  19,  22,  24,  27,  31,  35,  39,
               44,  49,  55,  62,  70,  79,  88,  99, 111, 125,
              140, 158, 177, 199, 223, 250, 281, 316, 354, 398,
        },
        {
                4,   4,   5,   6,   6,   7,   8,   9,  11,  12,
               13,  15,  17,  19,  22,  24,  27,  31,  35,  39,
               44,  49,  55,  62,  70,  79,  88,  99, 111, 125,
              140, 158, 177, 199, 223, 250, 281, 316, 354, 398,
        },
    },
    {
        {
                3,   4,   4,   5,   5,   6,   7,   8,   9,  10,
               11,  12,  14,  16,  18,  20,  22,  25,  28,  32,
               36,  40,  45,  51,  57,  64,  72,  81,  91, 102,
              115, 129, 145, 162, 182, 205, 230, 258, 290, 325,
        },
        {
                3,   4,   4,   5,   5,   6,   7,   8,   9,  10,
               11,  12,  14,  16,  18,  20,  22,  25,  28,  32,
               36,  40,  45,  51,  57,  64,  72,  81,  91, 102,
              115, 129, 145, 162, 182, 205, 230, 258, 290, 325,
        },
    }
};

const uint16_t AvcVdencCMD3ConstSettings::par31Table[2][3][2][52] =
{
    {
        {
            {
                   2,    2,    2,    2,    2,    2,    2,    2,    2,     2,     2,     2,     2,
                   3,    4,    5,    6,    8,   10,   13,   16,   20,    26,    33,    41,    52,
                  66,   83,  104,  132,  166,  209,  264,  332,  419,   528,   665,   838,  1056,
                1331, 1677, 2113, 2662, 3354, 4226, 5324, 6708, 8452, 10649, 13417, 16905, 21299,
            },
            {
                   2,    2,    2,    2,    2,    2,    2,    2,    2,     2,     2,     2,     2,
                   3,    4,    5,    6,    8,   10,   13,   16,   20,    26,    33,    41,    52,
                  66,   83,  104,  132,  166,  209,  264,  332,  419,   528,   665,   838,  1056,
                1331, 1677, 2113, 2662, 3354, 4226, 5324, 6708, 8452, 10649, 13417, 16905, 21299,
            },
        },
        {
            {
                   2,    2,    2,    2,    2,    2,    2,    2,    2,    2,     2,     2,     2,
                   2,    3,    4,    5,    6,    8,   10,   12,   16,   20,    25,    32,    40,
                  50,   64,   80,  101,  128,  161,  203,  256,  322,  406,   512,   645,   812,
                1024, 1290, 1625, 2048, 2580, 3250, 4096, 5160, 6501, 8192, 10321, 13003, 16384,
            },
            {
                   2,    2,    2,    2,    2,    2,    2,    2,    2,    2,     2,     2,     2,
                   2,    3,    4,    5,    6,    8,   10,   12,   16,   20,    25,    32,    40,
                  50,   64,   80,  101,  128,  161,  203,  256,  322,  406,   512,   645,   812,
                1024, 1290, 1625, 2048, 2580, 3250, 4096, 5160, 6501, 8192, 10321, 13003, 16384,
            },
        },
        {
            {
                   4,    4,    4,    4,    4,    4,    4,     4,     4,     4,     4,     4,     4,
                   6,    7,    9,   12,   15,   19,   24,    30,    38,    48,    60,    76,    96,
                 121,  153,  193,  243,  307,  387,  487,   614,   774,   975,  1228,  1548,  1950,
                2457, 3096, 3901, 4915, 6192, 7802, 9830, 12385, 15604, 19660, 24771, 31209, 39321,
            },
            {
                   3,    3,    3,    3,    3,    3,    3,    3,     3,     3,     3,     3,     3,
                   4,    5,    7,    9,   11,   14,   18,   22,    28,    36,    45,    57,    72,
                  91,  115,  145,  182,  230,  290,  365,  460,   580,   731,   921,  1161,  1462,
                1843, 2322, 2925, 3686, 4644, 5851, 7372, 9289, 11703, 14745, 18578, 23407, 29491,
            },
        },
    },
    {
        {
            {
                   2,    2,    2,    2,    2,    2,    2,    2,    2,     2,     2,     2,     2,
                   3,    4,    5,    6,    8,   10,   13,   16,   20,    26,    33,    41,    52,
                  66,   83,  104,  132,  166,  209,  264,  332,  419,   528,   665,   838,  1056,
                1331, 1677, 2113, 2662, 3354, 4226, 5324, 6708, 8452, 10649, 13417, 16905, 21299,
            },
            {
                   2,    2,    2,    2,    2,    2,    2,    2,    2,     2,     2,     2,     2,
                   3,    4,    5,    6,    8,   10,   13,   16,   20,    26,    33,    41,    52,
                  66,   83,  104,  132,  166,  209,  264,  332,  419,   528,   665,   838,  1056,
                1331, 1677, 2113, 2662, 3354, 4226, 5324, 6708, 8452, 10649, 13417, 16905, 21299,
            },
        },
        {
            {
                   3,    3,    3,    3,    3,    3,    3,    3,    3,     3,     3,     3,     3,
                   4,    5,    6,    8,   10,   12,   16,   20,   25,    32,    40,    51,    64,
                  81,  102,  129,  162,  204,  258,  325,  409,  516,   650,   819,   1032,  1300,
                1638, 2064, 2600, 3276, 4128, 5201, 6553, 8257, 10403, 13107, 16514, 20806, 26214,
            },
            {
                   3,    3,    3,    3,    3,    3,    3,    3,     3,     3,     3,     3,     3,
                   4,    5,    6,    8,   10,   12,   16,   20,    25,    32,    40,    51,    64,
                  81,  102,  129,  162,  204,  258,  325,  409,   516,   650,   819,  1032,  1300,
                1638, 2064, 2600, 3276, 4128, 5201, 6553, 8257, 10403, 13107, 16514, 20806, 26214,
            },
        },
        {
            {
                   4,    4,    4,    4,    4,    4,    4,    4,     4,     4,     4,     4,     4,
                   6,    7,    9,   12,   15,   19,   24,   30,    38,    48,    60,    76,    96,
                 121,  153,  193,  243,  307,  387,  487,  614,   774,   975,   1228,  1548,  1950,
                2457, 3096, 3901, 4915, 6192, 7802, 9830, 12385, 15604, 19660, 24771, 31209, 39321,
            },
            {
                   3,    3,    3,    3,    3,    3,    3,    3,    3,     3,     3,     3,     3,
                   4,    5,    7,    9,   11,   14,   18,   22,   28,    36,    45,    57,    72,
                  91,  115,  145,  182,  230,  290,  365,  460,  580,   731,   921,   1161,  1462,
                1843, 2322, 2925, 3686, 4644, 5851, 7372, 9289, 11703, 14745, 18578, 23407, 29491,
            },
        },
    }
};

const uint16_t AvcVdencCMD3ConstSettings::par32Table[2][3][2][52] =
{
    {
        {
            {
                2,  2,  2,  2,  2,  2,   2,   2,   2,   2,   2,   2,   2,
                2,  3,  3,  4,  4,  5,   5,   6,   7,   8,   9,   10,  11,
                13, 14, 16, 18, 20, 23,  26,  29,  33,  37,  41,  46,  52,
                58, 66, 74, 83, 93, 104, 117, 132, 148, 166, 186, 209, 235,
            },
            {
                2,  2,  2,  2,  2,  2,   2,   2,   2,   2,   2,   2,   2,
                2,  3,  3,  4,  4,  5,   5,   6,   7,   8,   9,   10,  11,
                13, 14, 16, 18, 20, 23,  26,  29,  33,  37,  41,  46,  52,
                58, 66, 74, 83, 93, 104, 117, 132, 148, 166, 186, 209, 235,
            },
        },
        {
            {
                3,  3,  3,  3,  3,   3,   3,   3,   3,   3,   3,   3,   3,
                3,  3,  4,  4,  5,   6,   6,   7,   8,   9,   10,  12,  13,
                15, 16, 19, 21, 24,  26,  30,  33,  38,  42,  48,  53,  60,
                67, 76, 85, 96, 107, 120, 135, 152, 171, 192, 215, 241, 271,
            },
            {
                3,  3,  3,  3,  3,   3,   3,   3,   3,   3,   3,   3,   3,
                3,  3,  4,  4,  5,   6,   6,   7,   8,   9,   10,  12,  13,
                15, 16, 19, 21, 24,  26,  30,  33,  38,  42,  48,  53,  60,
                67, 76, 85, 96, 107, 120, 135, 152, 171, 192, 215, 241, 271,
            },
        },
        {
            {
                4,  4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
                4,  5,   6,   6,   7,   8,   9,   11,  12,  13,  15,  17,  19,
                22, 24,  27,  31,  35,  39,  44,  49,  55,  62,  70,  79,  88,
                99, 111, 125, 140, 158, 177, 199, 223, 250, 281, 316, 354, 398,
            },
            {
                3,  3,  3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
                4,  4,  5,   5,   6,   7,   8,   9,   10,  11,  12,  14,  16,
                18, 20, 22,  25,  28,  32,  36,  40,  45,  51,  57,  64,  72,
                81, 91, 102, 115, 129, 145, 162, 182, 205, 230, 258, 290, 325,
            },
        },
    },
    {
        {
            {
                2,  2,  2,  2,  2,  2,   2,   2,   2,   2,   2,   2,   2,
                2,  3,  3,  4,  4,  5,   5,   6,   7,   8,   9,   10,  11,
                13, 14, 16, 18, 20, 23,  26,  29,  33,  37,  41,  46,  52,
                58, 66, 74, 83, 93, 104, 117, 132, 148, 166, 186, 209, 235,
            },
            {
                2,  2,  2,  2,  2,  2,   2,   2,   2,   2,   2,   2,   2,
                2,  3,  3,  4,  4,  5,   5,   6,   7,   8,   9,   10,  11,
                13, 14, 16, 18, 20, 23,  26,  29,  33,  37,  41,  46,  52,
                58, 66, 74, 83, 93, 104, 117, 132, 148, 166, 186, 209, 235,
            },
        },
        {
            {
                3,  3,  3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
                4,  4,  5,   5,   6,   7,   8,   9,   10,  11,  12,  14,  16,
                18, 20, 22,  25,  28,  32,  36,  40,  45,  51,  57,  64,  72,
                81, 91, 102, 115, 129, 145, 162, 182, 205, 230, 258, 290, 325,
            },
            {
                3,  3,  3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
                4,  4,  5,   5,   6,   7,   8,   9,   10,  11,  12,  14,  16,
                18, 20, 22,  25,  28,  32,  36,  40,  45,  51,  57,  64,  72,
                81, 91, 102, 115, 129, 145, 162, 182, 205, 230, 258, 290, 325,
            },
        },
        {
            {
                4,  4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
                4,  5,   6,   6,   7,   8,   9,   11,  12,  13,  15,  17,  19,
                22, 24,  27,  31,  35,  39,  44,  49,  55,  62,  70,  79,  88,
                99, 111, 125, 140, 158, 177, 199, 223, 250, 281, 316, 354, 398,
            },
            {
                3,  3,  3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
                4,  4,  5,   5,   6,   7,   8,   9,   10,  11,  12,  14,  16,
                18, 20, 22,  25,  28,  32,  36,  40,  45,  51,  57,  64,  72,
                81, 91, 102, 115, 129, 145, 162, 182, 205, 230, 258, 290, 325,
            },
        },
    }
};

const bool EncodeAvcVdencConstSettings::m_perfModeEnabled[NUM_VDENC_TARGET_USAGE_MODES] =
{
    0, 0, 0, 0, 0, 0, 1, 1
};

const uint8_t EncodeAvcVdencConstSettings::adaptiveRoundingIntra_P_G1[CODEC_AVC_NUM_QP] =
{
    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    //QP=[0~12]
    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    //QP=[13~25]
    4,    4,    4,    4,    4,    4,    4,    4,    4,    3,    3,    3,    3,    //QP=[26~38]
    2,    2,    2,    2,    1,    1,    1,    1,    0,    0,    0,    0,    0     //QP=[39~51]
};

const uint8_t EncodeAvcVdencConstSettings::adaptiveRoundingIntra_P[CODEC_AVC_NUM_QP] =
{
    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    //QP=[0~12]
    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    //QP=[13~25]
    4,    4,    4,    4,    4,    4,    4,    3,    3,    3,    3,    3,    3,    //QP=[26~38]
    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3     //QP=[39~51]
};

const uint8_t EncodeAvcVdencConstSettings::adaptiveRoundingIntra_BR[CODEC_AVC_NUM_QP] =
{
    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    //QP=[0~12]
    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    //QP=[13~25]
    4,    4,    4,    4,    4,    4,    4,    4,    3,    3,    3,    3,    3,    //QP=[26~38]
    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3     //QP=[39~51]
};

const uint8_t EncodeAvcVdencConstSettings::adaptiveRoundingIntra_B[CODEC_AVC_NUM_QP] =
{
    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    //QP=[0~12]
    4,    4,    4,    4,    4,    4,    3,    3,    3,    3,    3,    3,    3,    //QP=[13~25]
    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    //QP=[26~38]
    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2     //QP=[39~51]
};

const uint8_t EncodeAvcVdencConstSettings::adaptiveRoundingInter_P_G1[CODEC_AVC_NUM_QP] =
{
    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    //QP=[0~12]
    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    //QP=[13~25]
    3,    3,    3,    3,    3,    2,    2,    2,    2,    2,    2,    2,    2,    //QP=[26~38]
    1,    1,    1,    1,    0,    0,    0,    0,    0,    0,    0,    0,    0     //QP=[39~51]
};

const uint8_t EncodeAvcVdencConstSettings::adaptiveRoundingInter_P[CODEC_AVC_NUM_QP] =
{
    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    //QP=[0~12]
    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    3,    //QP=[13~25]
    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    //QP=[26~38]
    3,    3,    3,    3,    3,    3,    3,    2,    2,    2,    2,    2,    2     //QP=[39~51]
};

const uint8_t EncodeAvcVdencConstSettings::adaptiveRoundingInter_BR[CODEC_AVC_NUM_QP] =
{
    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    //QP=[0~12]
    3,    3,    3,    3,    3,    2,    2,    2,    2,    2,    2,    2,    2,    //QP=[13~25]
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    //QP=[26~38]
    1,    1,    1,    1,    1,    1,    1,    1,    1,    0,    0,    0,    0     //QP=[39~51]
};

const uint8_t EncodeAvcVdencConstSettings::adaptiveRoundingInter_B[CODEC_AVC_NUM_QP] =
{
    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    //QP=[0~12]
    3,    3,    3,    3,    3,    3,    2,    2,    2,    2,    1,    1,    1,    //QP=[13~25]
    1,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    //QP=[26~38]
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0     //QP=[39~51]
};

const uint16_t EncodeAvcVdencConstSettings::m_SliceSizeThrsholdsP[52] =  // slice size threshold delta for P frame targeted for 99% compliance
{
    850, 850, 850, 850, 850, 850, 850, 850, 850, 850,  //[ 0- 9]
    525, 525, 325, 325, 325, 325, 325, 325, 325, 325,  //[10-19]
    250, 250, 250, 250, 250, 250, 250, 250, 250, 250,  //[20-29]
    250, 250, 250, 250, 250, 125, 125, 125, 125, 125,  //[30-39]
    125, 125, 125, 125, 125, 125, 125, 125, 125, 125,  //[40-49]
    125, 125  //[50-51]
};

const uint16_t EncodeAvcVdencConstSettings::m_SliceSizeThrsholdsI[52] =  // slice size threshold delta for I frame targeted for 99% compliance
{
    850, 850, 850, 850, 850, 850, 850, 850, 850, 850,  //[ 0- 9]
    525, 525, 325, 325, 325, 325, 325, 325, 325, 325,  //[10-19]
    250, 250, 250, 250, 250, 250, 250, 250, 250, 250,  //[20-29]
    250, 250, 250, 250, 250, 125, 125, 125, 125, 125,  //[30-39]
    125, 125, 125, 125, 125, 125, 125, 125, 125, 125,  //[40-49]
    125, 125  //[50-51]
};

const uint32_t EncodeAvcVdencConstSettings::m_trellisQuantizationRounding[NUM_VDENC_TARGET_USAGE_MODES] =
{
    0, 3, 3, 3, 3, 3, 3, 3
};

const bool EncodeAvcVdencConstSettings::m_trellisQuantizationEnable[NUM_VDENC_TARGET_USAGE_MODES] =
{
    0, 1, 1, 0, 0, 0, 0, 0
};

const uint8_t EncodeAvcVdencConstSettings::m_columnScan4x4[16] =
{
    0, 4, 8, 12, 1, 5, 9, 13, 2, 6, 10, 14, 3, 7, 11, 15
};

const uint8_t EncodeAvcVdencConstSettings::m_columnScan8x8[64] =
{
    0, 8, 16, 24, 32, 40, 48, 56, 1, 9, 17, 25, 33, 41, 49, 57,
    2, 10, 18, 26, 34, 42, 50, 58, 3, 11, 19, 27, 35, 43, 51, 59,
    4, 12, 20, 28, 36, 44, 52, 60, 5, 13, 21, 29, 37, 45, 53, 61,
    6, 14, 22, 30, 38, 46, 54, 62, 7, 15, 23, 31, 39, 47, 55, 63
};

/* real thresholds are computed as multiplication on -50 and casting to int */
const double AvcVdencBrcConstSettings::m_BRC_DevThreshI0_FP_NEG[m_numDevThreshlds / 2] = {0.80, 0.60, 0.34, 0.2};

/* real thresholds are computed as multiplication on 50 and casting to int */
const double AvcVdencBrcConstSettings::m_BRC_DevThreshI0_FP_POS[m_numDevThreshlds / 2] = {0.2, 0.4, 0.66, 0.9};

/* real thresholds are computed as multiplication on 50 and casting to int */
const double AvcVdencBrcConstSettings::m_BRC_DevThreshPB0_FP_NEG[m_numDevThreshlds / 2] = {0.90, 0.66, 0.46, 0.3};

/* real thresholds are computed as multiplication on 50 and casting to int */
const double AvcVdencBrcConstSettings::m_BRC_DevThreshPB0_FP_POS[m_numDevThreshlds / 2] = {0.3, 0.46, 0.70, 0.90};

/* real negative thresholds are computed as multiplication on -50 and casting to int */
const double AvcVdencBrcConstSettings::m_BRC_DevThreshVBR0_NEG[m_numDevThreshlds / 2] = {0.90, 0.70, 0.50, 0.3};

/* positive thresholds are computed as multiplication on 100 and casting to int */
const double AvcVdencBrcConstSettings::m_BRC_DevThreshVBR0_POS[m_numDevThreshlds / 2] = {0.4, 0.5, 0.75, 0.90};

const int8_t  AvcVdencBrcConstSettings::m_BRC_LowDelay_DevThreshPB0_S8[8]  = {-45, -33, -23, -15, -8, 0, 15, 25};
const int8_t  AvcVdencBrcConstSettings::m_BRC_LowDelay_DevThreshI0_S8[8]   = {-40, -30, -17, -10, -5, 0, 10, 20};
const int8_t  AvcVdencBrcConstSettings::m_BRC_LowDelay_DevThreshVBR0_S8[8] = {-45, -35, -25, -15, -8, 0, 20, 40};
const int8_t  AvcVdencBrcConstSettings::m_BRC_INIT_DistQPDelta_I8[4]       = {-5, -2, 2, 5};
const uint8_t AvcVdencBrcConstSettings::m_BRC_EstRateThreshP0_U8[7]        = {4, 8, 12, 16, 20, 24, 28};
const uint8_t AvcVdencBrcConstSettings::m_BRC_EstRateThreshI0_U8[7]        = {4, 8, 12, 16, 20, 24, 28};
const int8_t  AvcVdencBrcConstSettings::m_brcInitDistQpDeltaI8[4]          = {0, 0, 0, 0};
const int8_t  AvcVdencBrcConstSettings::m_brcInitDistQpDeltaI8LowDelay[4]   ={-5, -2, 2, 5};

const uint16_t AvcVdencBrcConstSettings::m_BRC_UPD_start_global_adjust_frame[4]         = {10, 50, 100, 150};
const uint8_t  AvcVdencBrcConstSettings::m_BRC_UPD_global_rate_ratio_threshold[7]       = {80, 90, 95, 101, 105, 115, 130};
const uint8_t  AvcVdencBrcConstSettings::m_BRC_UPD_slwin_global_rate_ratio_threshold[7] = {80, 90, 95, 101, 105, 110, 120};
const uint8_t  AvcVdencBrcConstSettings::m_BRC_UPD_start_global_adjust_mult[5]          = {1, 1, 3, 2, 1};
const uint8_t  AvcVdencBrcConstSettings::m_BRC_UPD_start_global_adjust_div[5]           = {40, 5, 5, 3, 1};
const int8_t   AvcVdencBrcConstSettings::m_BRC_UPD_global_rate_ratio_threshold_qp[8]    = {-3, -2, -1, 0, 1, 1, 2, 3};

const int8_t AvcVdencBrcConstSettings::m_BRC_UPD_GlobalRateQPAdjTabI_U8[64] =
{
    48,  40,  32,  24,  16,   8,   0,  -8,
    40,  32,  24,  16,   8,   0,  -8, -16,
    32,  24,  16,   8,   0,  -8, -16, -24,
    24,  16,   8,   0,  -8, -16, -24, -32,
    16,   8,   0,  -8, -16, -24, -32, -40,
     8,   0,  -8, -16, -24, -32, -40, -48,
     0,  -8, -16, -24, -32, -40, -48, -56,
    48,  40,  32,  24,  16,   8,   0,  -8,
};

const int8_t AvcVdencBrcConstSettings::m_BRC_UPD_GlobalRateQPAdjTabP_U8[64] =
{
     48,  40,  32,  24,  16,   8,   0,  -8,
     40,  32,  24,  16,   8,   0,  -8, -16,
     16,   8,   8,   4,  -8, -16, -16, -24,
      8,   0,   0,  -8, -16, -16, -16, -24,
      8,   0,   0, -24, -32, -32, -32, -48,
      0, -16, -16, -24, -32, -48, -56, -64,
     -8, -16, -32, -32, -48, -48, -56, -64,
    -16, -32, -48, -48, -48, -56, -64, -80,
};

// P picture global rate QP Adjustment table for sliding window BRC
const int8_t AvcVdencBrcConstSettings::m_BRC_UPD_SlWinGlobalRateQPAdjTabP_U8[64] =
{
     48,  40,  32,  24,  16,   8,   0,  -8,
     40,  32,  24,  16,   8,   0,  -8, -16,
     16,   8,   8,   4,  -8, -16, -16, -24,
      8,   0,   0,  -8, -16, -16, -16, -24,
      8,   0,   0, -24, -32, -32, -32, -48,
      0, -16, -24, -32, -40, -56, -64, -72,
     -8, -16, -32, -40, -48, -56, -64, -64,
    -16, -32, -48, -48, -48, -56, -64, -80,
};

const int8_t AvcVdencBrcConstSettings::m_BRC_UPD_GlobalRateQPAdjTabB_U8[64] =
{
    48,  40,  32,  24,  16,   8,   0,  -8,
    40,  32,  24,  16,   8,   0,  -8, -16,
    32,  24,  16,   8,   0,  -8, -16, -24,
    24,  16,   8,   0,  -8,  -8, -16, -24,
    16,   8,   0,   0,  -8, -16, -24, -32,
    16,   8,   0,   0,  -8, -16, -24, -32,
     0,  -8,  -8, -16, -32, -48, -56, -64,
     0,  -8,  -8, -16, -32, -48, -56, -64,
};

const uint8_t AvcVdencBrcConstSettings::m_BRC_UPD_DistThreshldI_U8[10] = {2, 4, 8, 12, 19, 32, 64, 128, 0, 0};
const uint8_t AvcVdencBrcConstSettings::m_BRC_UPD_DistThreshldP_U8[10] = {2, 4, 8, 12, 19, 32, 64, 128, 0, 0};

const int8_t AvcVdencBrcConstSettings::m_CBR_UPD_DistQPAdjTabI_U8[81] =
{
     0, 0, 0, 0, 0, 3, 4, 6, 8,
     0, 0, 0, 0, 0, 2, 3, 5, 7,
    -1, 0, 0, 0, 0, 2, 2, 4, 5,
    -1,-1, 0, 0, 0, 1, 2, 2, 4,
    -2,-2,-1, 0, 0, 0, 1, 2, 4,
    -2,-2,-1, 0, 0, 0, 1, 2, 4,
    -3,-2,-1,-1, 0, 0, 1, 2, 5,
    -3,-2,-1,-1, 0, 0, 2, 4, 7,
    -4,-3,-2,-1, 0, 1, 3, 5, 8,
};

const int8_t AvcVdencBrcConstSettings::m_CBR_UPD_DistQPAdjTabP_U8[81] =
{
    -1, 0, 0, 0, 0, 1, 1, 2, 3,
    -1,-1, 0, 0, 0, 1, 1, 2, 3,
    -2,-1,-1, 0, 0, 1, 1, 2, 3,
    -3,-2,-2,-1, 0, 0, 1, 2, 3,
    -3,-2,-1,-1, 0, 0, 1, 2, 3,
    -3,-2,-1,-1, 0, 0, 1, 2, 3,
    -3,-2,-1,-1, 0, 0, 1, 2, 3,
    -3,-2,-1,-1, 0, 0, 1, 2, 3,
    -3,-2,-1,-1, 0, 0, 1, 2, 3,
};

const int8_t AvcVdencBrcConstSettings::m_CBR_UPD_DistQPAdjTabB_U8[81] =
{
     0, 0, 0, 0, 0, 2, 3, 3, 4,
     0, 0, 0, 0, 0, 2, 3, 3, 4,
    -1, 0, 0, 0, 0, 2, 2, 3, 3,
    -1,-1, 0, 0, 0, 1, 2, 2, 2,
    -1,-1,-1, 0, 0, 0, 1, 2, 2,
    -2,-1,-1, 0, 0, 0, 0, 1, 2,
    -2,-1,-1,-1, 0, 0, 0, 1, 3,
    -2,-2,-1,-1, 0, 0, 1, 1, 3,
    -2,-2,-1,-1, 0, 1, 1, 2, 4,
};

const int8_t AvcVdencBrcConstSettings::m_VBR_UPD_DistQPAdjTabI_U8[81] =
{
     0, 0, 0, 0, 0, 3, 4, 6, 8,
     0, 0, 0, 0, 0, 2, 3, 5, 7,
    -1, 0, 0, 0, 0, 2, 2, 4, 5,
    -1,-1, 0, 0, 0, 1, 2, 2, 4,
    -2,-2,-1, 0, 0, 0, 1, 2, 4,
    -2,-2,-1, 0, 0, 0, 1, 2, 4,
    -3,-2,-1,-1, 0, 0, 1, 2, 5,
    -3,-2,-1,-1, 0, 0, 2, 4, 7,
    -4,-3,-2,-1, 0, 1, 3, 5, 8,
};

const int8_t AvcVdencBrcConstSettings::m_VBR_UPD_DistQPAdjTabP_U8[81] =
{
    -1, 0, 0, 0, 0, 1, 1, 2, 3,
    -1,-1, 0, 0, 0, 1, 1, 2, 3,
    -2,-1,-1, 0, 0, 1, 1, 2, 3,
    -3,-2,-2,-1, 0, 0, 1, 2, 3,
    -3,-2,-1,-1, 0, 0, 1, 2, 3,
    -3,-2,-1,-1, 0, 0, 1, 2, 3,
    -3,-2,-1,-1, 0, 0, 1, 2, 3,
    -3,-2,-1,-1, 0, 0, 1, 2, 3,
    -3,-2,-1,-1, 0, 0, 1, 2, 3,
};

const int8_t AvcVdencBrcConstSettings::m_VBR_UPD_DistQPAdjTabB_U8[81] =
{
     0, 0, 0, 0, 0, 2, 3, 3, 4,
     0, 0, 0, 0, 0, 2, 3, 3, 4,
    -1, 0, 0, 0, 0, 2, 2, 3, 3,
    -1,-1, 0, 0, 0, 1, 2, 2, 2,
    -1,-1,-1, 0, 0, 0, 1, 2, 2,
    -2,-1,-1, 0, 0, 0, 0, 1, 2,
    -2,-1,-1,-1, 0, 0, 0, 1, 3,
    -2,-2,-1,-1, 0, 0, 1, 1, 3,
    -2,-2,-1,-1, 0, 1, 1, 2, 4,
};

const int8_t AvcVdencBrcConstSettings::m_CBR_UPD_FrmSzAdjTabI_S8[72] =
{
    -4, -20, -28, -36, -40, -44, -48, -80,
     0,  -8, -12, -20, -24, -28, -32, -36,
     0,   0,  -8, -16, -20, -24, -28, -32,
     8,   4,   0,   0,  -8, -16, -24, -28,
    32,  24,  16,   2,  -4,  -8, -16, -20,
    36,  32,  28,  16,   8,   0,  -4,  -8,
    40,  36,  24,  20,  16,   8,   0,  -8,
    48,  40,  28,  24,  20,  12,   0,  -4,
    64,  48,  28,  20,  16,  12,   8,   4,
};

const int8_t AvcVdencBrcConstSettings::m_CBR_UPD_FrmSzAdjTabP_S8[72] =
{
    -8, -24, -32, -44, -48, -56, -64, -80,
    -8, -16, -32, -40, -44, -52, -56, -64,
     0,   0, -16, -28, -36, -40, -44, -48,
     8,   4,   0,   0,  -8, -16, -24, -36,
    20,  12,   4,   0,  -8,  -8,  -8, -16,
    24,  16,   8,   8,   8,   0,  -4,  -8,
    40,  36,  24,  20,  16,   8,   0,  -8,
    48,  40,  28,  24,  20,  12,   0,  -4,
    64,  48,  28,  20,  16,  12,   8,   4,
};

const int8_t AvcVdencBrcConstSettings::m_CBR_UPD_FrmSzAdjTabB_S8[72] =
{
     0,  -4,  -8, -16, -24, -32, -40, -48,
     1,   0,  -4,  -8, -16, -24, -32, -40,
     4,   2,   0,  -1,  -3,  -8, -16, -24,
     8,   4,   2,   0,  -1,  -4,  -8, -16,
    20,  16,   4,   0,  -1,  -4,  -8, -16,
    24,  20,  16,   8,   4,   0,  -4,  -8,
    28,  24,  20,  16,   8,   4,   0,  -8,
    32,  24,  20,  16,   8,   4,   0,  -4,
    64,  48,  28,  20,  16,  12,   8,   4,
};

const int8_t AvcVdencBrcConstSettings::m_VBR_UPD_FrmSzAdjTabI_S8[72] =
{
    -4, -20, -28, -36, -40, -44, -48, -80,
     0,  -8, -12, -20, -24, -28, -32, -36,
     0,   0,  -8, -16, -20, -24, -28, -32,
     8,   4,   0,   0,  -8, -16, -24, -28,
    32,  24,  16,   2,  -4,  -8, -16, -20,
    36,  32,  28,  16,   8,   0,  -4,  -8,
    40,  36,  24,  20,  16,   8,   0,  -8,
    48,  40,  28,  24,  20,  12,   0,  -4,
    64,  48,  28,  20,  16,  12,   8,   4,
};

const int8_t AvcVdencBrcConstSettings::m_VBR_UPD_FrmSzAdjTabP_S8[72] =
{
    -8, -24, -32, -44, -48, -56, -64, -80,
    -8, -16, -32, -40, -44, -52, -56, -64,
     0,   0, -16, -28, -36, -40, -44, -48,
     8,   4,   0,   0,  -8, -16, -24, -36,
    20,  12,   4,   0,  -8,  -8,  -8, -16,
    24,  16,   8,   8,   8,   0,  -4,  -8,
    40,  36,  24,  20,  16,   8,   0,  -8,
    48,  40,  28,  24,  20,  12,   0,  -4,
    64,  48,  28,  20,  16,  12,   8,   4,
};

const int8_t AvcVdencBrcConstSettings::m_VBR_UPD_FrmSzAdjTabB_S8[72] =
{
     0,  -4,  -8, -16, -24, -32, -40, -48,
     1,   0,  -4,  -8, -16, -24, -32, -40,
     4,   2,   0,  -1,  -3,  -8, -16, -24,
     8,   4,   2,   0,  -1,  -4,  -8, -16,
    20,  16,   4,   0,  -1,  -4,  -8, -16,
    24,  20,  16,   8,   4,   0,  -4,  -8,
    28,  24,  20,  16,   8,   4,   0,  -8,
    32,  24,  20,  16,   8,   4,   0,  -4,
    64,  48,  28,  20,  16,  12,   8,   4,
};

const int8_t AvcVdencBrcConstSettings::m_QVBR_UPD_FrmSzAdjTabP_S8[72] =
{
    -8, -24, -32, -44, -48, -56, -64, -80,
    -8, -16, -32, -40, -44, -52, -56, -64,
     0,   0, -16, -28, -36, -40, -44, -48,
    16,  16,   8,   0,  -8, -16, -24, -36,
    20,  16,   8,   0,  -8,  -8,  -8, -16,
    24,  16,   8,   8,   8,   0,  -4,  -8,
    40,  36,  24,  20,  16,   8,   0,  -8,
    48,  40,  28,  24,  20,  12,   0,  -4,
    64,  48,  28,  20,  16,  12,   8,   4,
};

const int8_t AvcVdencBrcConstSettings::m_LOW_DELAY_UPD_FrmSzAdjTabI_S8[72] =
{
     0,   0,  -8, -12, -16, -20, -28, -36,
     0,   0,  -4,  -8, -12, -16, -24, -32,
     4,   2,   0,  -1,  -3,  -8, -16, -24,
     8,   4,   2,   0,  -1,  -4,  -8, -16,
    20,  16,   4,   0,  -1,  -4,  -8, -16,
    24,  20,  16,   8,   4,   0,  -4,  -8,
    28,  24,  20,  16,   8,   4,   0,  -8,
    32,  24,  20,  16,   8,   4,   0,  -4,
    64,  48,  28,  20,  16,  12,   8,   4,
};

const int8_t AvcVdencBrcConstSettings::m_LOW_DELAY_UPD_FrmSzAdjTabP_S8[72] =
{
    -8, -24, -32, -40, -44, -48, -52, -80,
    -8, -16, -32, -40, -40, -44, -44, -56,
     0,   0, -12, -20, -24, -28, -32, -36,
     8,   4,   0,   0,  -8, -16, -24, -32,
    32,  16,   8,   4,  -4,  -8, -16, -20,
    36,  24,  16,   8,   4,  -2,  -4,  -8,
    40,  36,  24,  20,  16,   8,   0,  -8,
    48,  40,  28,  24,  20,  12,   0,  -4,
    64,  48,  28,  20,  16,  12,   8,   4,
};

const int8_t AvcVdencBrcConstSettings::m_LOW_DELAY_UPD_FrmSzAdjTabB_S8[72] =
{
     0,  -4,  -8, -16, -24, -32, -40, -48,
     1,   0,  -4,  -8, -16, -24, -32, -40,
     4,   2,   0,  -1,  -3,  -8, -16, -24,
     8,   4,   2,   0,  -1,  -4,  -8, -16,
    20,  16,   4,   0,  -1,  -4,  -8, -16,
    24,  20,  16,   8,   4,   0,  -4,  -8,
    28,  24,  20,  16,   8,   4,   0,  -8,
    32,  24,  20,  16,   8,   4,   0,  -4,
    64,  48,  28,  20,  16,  12,   8,   4,
};

const uint8_t AvcVdencBrcConstSettings::m_BRC_UPD_FrmSzMinTabP_U8[9] = {1, 2, 4, 6, 8, 10, 16, 16, 16};
const uint8_t AvcVdencBrcConstSettings::m_BRC_UPD_FrmSzMinTabI_U8[9] = {1, 2, 4, 8, 16, 20, 24, 32, 36};
const uint8_t AvcVdencBrcConstSettings::m_BRC_UPD_FrmSzMaxTabP_U8[9] = {48, 64, 80, 96, 112, 128, 144, 160, 160};
const uint8_t AvcVdencBrcConstSettings::m_BRC_UPD_FrmSzMaxTabI_U8[9] = {48, 64, 80, 96, 112, 128, 144, 160, 160};
const uint8_t AvcVdencBrcConstSettings::m_BRC_UPD_FrmSzSCGTabP_U8[9] = {4, 8, 12, 16, 20, 24, 24, 0, 0};
const uint8_t AvcVdencBrcConstSettings::m_BRC_UPD_FrmSzSCGTabI_U8[9] = {4, 8, 12, 16, 20, 24, 24, 0, 0};

const uint8_t AvcVdencBrcConstSettings::m_BRC_UPD_I_IntraNonPred[42] =
{
    0x0e, 0x0e, 0x0e, 0x18, 0x19, 0x1b, 0x1c,
    0x0d, 0x0f, 0x18, 0x19, 0x0d, 0x0f, 0x0f,
    0x0c, 0x0e, 0x0c, 0x0c, 0x0a, 0x0a, 0x0b,
    0x0a, 0x0a, 0x0a, 0x09, 0x09, 0x08, 0x08,
    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
    0x08, 0x08, 0x07, 0x07, 0x07, 0x07, 0x07
};

const uint8_t AvcVdencBrcConstSettings::m_BRC_UPD_I_Intra8x8[42] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06,
    0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
    0x06, 0x06, 0x07, 0x07, 0x07, 0x07, 0x07,
};

const uint8_t AvcVdencBrcConstSettings::m_BRC_UPD_I_Intra4x4[42] =
{
    0x2e, 0x2e, 0x2e, 0x38, 0x39, 0x3a, 0x3b,
    0x2c, 0x2e, 0x38, 0x39, 0x2d, 0x2f, 0x38,
    0x2e, 0x38, 0x2e, 0x38, 0x2f, 0x2e, 0x38,
    0x38, 0x38, 0x38, 0x2f, 0x2f, 0x2f, 0x2e,
    0x2d, 0x2c, 0x2b, 0x2a, 0x29, 0x28, 0x1e,
    0x1c, 0x1b, 0x1a, 0x19, 0x18, 0x0e, 0x0d
};

const uint8_t AvcVdencBrcConstSettings::m_BRC_UPD_P_IntraNonPred[42] =
{
    0x06, 0x06, 0x06, 0x07, 0x08, 0x09, 0x0a,
    0x05, 0x06, 0x07, 0x08, 0x06, 0x07, 0x07,
    0x07, 0x07, 0x06, 0x07, 0x07, 0x06, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07
};

const uint8_t AvcVdencBrcConstSettings::m_BRC_UPD_P_Intra16x16[42] =
{
    0x1b, 0x1b, 0x1b, 0x1c, 0x1e, 0x28, 0x29,
    0x1a, 0x1b, 0x1c, 0x1e, 0x1a, 0x1c, 0x1d,
    0x1b, 0x1c, 0x1c, 0x1c, 0x1c, 0x1b, 0x1c,
    0x1c, 0x1d, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c,
    0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c,
    0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c
};

const uint8_t AvcVdencBrcConstSettings::m_BRC_UPD_P_Intra8x8[42] =
{
    0x1d, 0x1d, 0x1d, 0x1e, 0x28, 0x29, 0x2a,
    0x1b, 0x1d, 0x1e, 0x28, 0x1c, 0x1d, 0x1f,
    0x1d, 0x1e, 0x1d, 0x1e, 0x1d, 0x1d, 0x1f,
    0x1e, 0x1e, 0x1e, 0x1d, 0x1e, 0x1e, 0x1d,
    0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e,
    0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e,
};

const uint8_t AvcVdencBrcConstSettings::m_BRC_UPD_P_Intra4x4[42] =
{
    0x38, 0x38, 0x38, 0x39, 0x3a, 0x3b, 0x3d,
    0x2e, 0x38, 0x39, 0x3a, 0x2f, 0x39, 0x3a,
    0x38, 0x39, 0x38, 0x39, 0x39, 0x38, 0x39,
    0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39,
    0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39,
    0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39,
};

const uint8_t AvcVdencBrcConstSettings::m_BRC_UPD_P_Inter16x8[42] =
{
    0x07, 0x07, 0x07, 0x08, 0x09, 0x0b, 0x0c,
    0x06, 0x07, 0x09, 0x0a, 0x07, 0x08, 0x09,
    0x08, 0x09, 0x08, 0x09, 0x08, 0x08, 0x09,
    0x09, 0x09, 0x09, 0x08, 0x08, 0x08, 0x08,
    0x08, 0x08, 0x08, 0x08, 0x09, 0x09, 0x09,
    0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
};

const uint8_t AvcVdencBrcConstSettings::m_BRC_UPD_P_Inter8x8[42] =
{
    0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03,
    0x02, 0x02, 0x02, 0x03, 0x02, 0x02, 0x02,
    0x02, 0x03, 0x02, 0x02, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
};

const uint8_t AvcVdencBrcConstSettings::m_BRC_UPD_P_Inter16x16[42] =
{
    0x05, 0x05, 0x05, 0x06, 0x06, 0x06, 0x06,
    0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
    0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
    0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
    0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
    0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
};

const uint8_t AvcVdencBrcConstSettings::m_BRC_UPD_P_RefId[42] =
{
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
};

EncodeAvcVdencConstSettings::EncodeAvcVdencConstSettings(PMOS_INTERFACE osInterface) : VdencConstSettings(osInterface)
{
    m_featureSetting = MOS_New(AvcVdencFeatureSettings);
}

MOS_STATUS EncodeAvcVdencConstSettings::PrepareConstSettings()
{
    ENCODE_FUNC_CALL();

    ENCODE_CHK_STATUS_RETURN(SetCommonSettings());
    ENCODE_CHK_STATUS_RETURN(SetBrcSettings());
    ENCODE_CHK_STATUS_RETURN(SetVdencCmd3Settings());
    ENCODE_CHK_STATUS_RETURN(SetVdencAvcImgStateSettings());

    return MOS_STATUS_SUCCESS;
}

MOS_STATUS EncodeAvcVdencConstSettings::SetCommonSettings()
{
    ENCODE_FUNC_CALL();
    ENCODE_CHK_NULL_RETURN(m_featureSetting);

    auto setting = static_cast<AvcVdencFeatureSettings *>(m_featureSetting);
    ENCODE_CHK_NULL_RETURN(setting);

    setting->singlePassMinFrameWidth = m_singlePassMinFrameWidth;
    setting->singlePassMinFrameHeight = m_singlePassMinFrameHeight;
    setting->singlePassMinFramePer100s = m_singlePassMinFramePer100s;

    setting->interMbMaxSize = m_interMbMaxSize;
    setting->intraMbMaxSize = m_intraMbMaxSize;

    setting->perfModeEnabled = (bool*) m_perfModeEnabled;

    setting->DefaultIntraRounding   = defIntraRounding;
    setting->StaticIntraRounding[0] = defIntraRounding;
    setting->StaticIntraRounding[1] = defIntraRounding;
    setting->StaticIntraRounding[2] = defIntraRounding;
    setting->StaticIntraRounding[3] = defIntraRounding;

    setting->DefaultInterRounding   = defInterRounding;
    setting->StaticInterRounding[0] = interRoundingB;
    setting->StaticInterRounding[1] = interRoundingBR;
    setting->StaticInterRounding[2] = interRoundingP;
    setting->StaticInterRounding[3] = interRoundingP;

    setting->AdaptiveIntraRounding[0] = static_cast<const uint8_t *>(adaptiveRoundingIntra_B);
    setting->AdaptiveIntraRounding[1] = static_cast<const uint8_t *>(adaptiveRoundingIntra_BR);
    setting->AdaptiveIntraRounding[2] = static_cast<const uint8_t *>(adaptiveRoundingIntra_P);
    setting->AdaptiveIntraRounding[3] = static_cast<const uint8_t *>(adaptiveRoundingIntra_P_G1);

    setting->AdaptiveInterRounding[0] = static_cast<const uint8_t *>(adaptiveRoundingInter_B);
    setting->AdaptiveInterRounding[1] = static_cast<const uint8_t *>(adaptiveRoundingInter_BR);
    setting->AdaptiveInterRounding[2] = static_cast<const uint8_t *>(adaptiveRoundingInter_P);
    setting->AdaptiveInterRounding[3] = static_cast<const uint8_t *>(adaptiveRoundingInter_P_G1);

    setting->SliceSizeThrsholdsI = (uint16_t *)m_SliceSizeThrsholdsI;
    setting->SliceSizeThrsholdsP = (uint16_t *)m_SliceSizeThrsholdsP;

    setting->TrellisQuantizationRounding = (uint32_t*)m_trellisQuantizationRounding;
    setting->TrellisQuantizationEnable = (bool*)m_trellisQuantizationEnable;

    setting->columnScan4x4 = (uint8_t*)m_columnScan4x4;
    setting->columnScan8x8 = (uint8_t*)m_columnScan8x8;

    setting->vdencCMD3Table = (AvcVdencCMD3ConstSettings*)&m_CMD3Settings;

    return MOS_STATUS_SUCCESS;
}

MOS_STATUS EncodeAvcVdencConstSettings::SetBrcSettings()
{
    ENCODE_FUNC_CALL();
    ENCODE_CHK_NULL_RETURN(m_featureSetting);

    auto setting = static_cast<AvcVdencFeatureSettings *>(m_featureSetting);
    ENCODE_CHK_NULL_RETURN(setting);

    setting->brcSettings.vdencBrcPakStatsBufferSize = m_brcSettings.m_vdencBrcPakStatsBufferSize;
    setting->brcSettings.vdencBrcStatsBufferSize    = m_brcSettings.m_vdencBrcStatsBufferSize;
    setting->brcSettings.vdencBrcDbgBufferSize      = m_brcSettings.m_vdencBrcDbgBufferSize;
    setting->brcSettings.vdencBrcHistoryBufferSize  = m_brcSettings.m_vdencBrcHistoryBufferSize;

    setting->brcSettings.vdboxHucVdencBrcInitKernelDescriptor   = m_brcSettings.m_vdboxHucVdencBrcInitKernelDescriptor;
    setting->brcSettings.vdboxHucVdencBrcUpdateKernelDescriptor = m_brcSettings.m_vdboxHucVdencBrcUpdateKernelDescriptor;

    setting->brcSettings.BRC_DevThreshI0_FP_NEG  = (double*)m_brcSettings.m_BRC_DevThreshI0_FP_NEG;
    setting->brcSettings.BRC_DevThreshI0_FP_POS  = (double*)m_brcSettings.m_BRC_DevThreshI0_FP_POS;
    setting->brcSettings.BRC_DevThreshPB0_FP_NEG = (double*)m_brcSettings.m_BRC_DevThreshPB0_FP_NEG;
    setting->brcSettings.BRC_DevThreshPB0_FP_POS = (double*)m_brcSettings.m_BRC_DevThreshPB0_FP_POS;
    setting->brcSettings.BRC_DevThreshVBR0_NEG   = (double*)m_brcSettings.m_BRC_DevThreshVBR0_NEG;
    setting->brcSettings.BRC_DevThreshVBR0_POS   = (double*)m_brcSettings.m_BRC_DevThreshVBR0_POS;

    setting->brcSettings.BRC_LowDelay_DevThreshPB0_S8  = (int8_t*)m_brcSettings.m_BRC_LowDelay_DevThreshPB0_S8;
    setting->brcSettings.BRC_LowDelay_DevThreshI0_S8   = (int8_t*)m_brcSettings.m_BRC_LowDelay_DevThreshI0_S8;
    setting->brcSettings.BRC_LowDelay_DevThreshVBR0_S8 = (int8_t*)m_brcSettings.m_BRC_LowDelay_DevThreshVBR0_S8;
    setting->brcSettings.BRC_INIT_DistQPDelta_I8       = (int8_t*)m_brcSettings.m_BRC_INIT_DistQPDelta_I8;
    setting->brcSettings.BRC_EstRateThreshP0_U8        = (uint8_t*)m_brcSettings.m_BRC_EstRateThreshP0_U8;
    setting->brcSettings.BRC_EstRateThreshI0_U8        = (uint8_t*)m_brcSettings.m_BRC_EstRateThreshI0_U8;

    setting->brcSettings.brcInitDistQpDeltaI8          = (int8_t*)m_brcSettings.m_brcInitDistQpDeltaI8;
    setting->brcSettings.brcInitDistQpDeltaI8LowDelay  = (int8_t*)m_brcSettings.m_brcInitDistQpDeltaI8LowDelay;

    setting->brcSettings.BRC_UPD_start_global_adjust_frame         = (uint16_t*)m_brcSettings.m_BRC_UPD_start_global_adjust_frame;
    setting->brcSettings.BRC_UPD_global_rate_ratio_threshold       = (uint8_t*)m_brcSettings.m_BRC_UPD_global_rate_ratio_threshold;
    setting->brcSettings.BRC_UPD_slwin_global_rate_ratio_threshold = (uint8_t*)m_brcSettings.m_BRC_UPD_slwin_global_rate_ratio_threshold;
    setting->brcSettings.BRC_UPD_start_global_adjust_mult          = (uint8_t*)m_brcSettings.m_BRC_UPD_start_global_adjust_mult;
    setting->brcSettings.BRC_UPD_start_global_adjust_div           = (uint8_t*)m_brcSettings.m_BRC_UPD_start_global_adjust_div;
    setting->brcSettings.BRC_UPD_global_rate_ratio_threshold_qp    = (int8_t*)m_brcSettings.m_BRC_UPD_global_rate_ratio_threshold_qp;

    setting->brcSettings.BRC_UPD_GlobalRateQPAdjTabI_U8      = (int8_t*)m_brcSettings.m_BRC_UPD_GlobalRateQPAdjTabI_U8;
    setting->brcSettings.BRC_UPD_GlobalRateQPAdjTabP_U8      = (int8_t*)m_brcSettings.m_BRC_UPD_GlobalRateQPAdjTabP_U8;
    setting->brcSettings.BRC_UPD_SlWinGlobalRateQPAdjTabP_U8 = (int8_t*)m_brcSettings.m_BRC_UPD_SlWinGlobalRateQPAdjTabP_U8;
    setting->brcSettings.BRC_UPD_GlobalRateQPAdjTabB_U8      = (int8_t*)m_brcSettings.m_BRC_UPD_GlobalRateQPAdjTabB_U8;
    setting->brcSettings.BRC_UPD_DistThreshldI_U8            = (uint8_t*)m_brcSettings.m_BRC_UPD_DistThreshldI_U8;
    setting->brcSettings.BRC_UPD_DistThreshldP_U8            = (uint8_t*)m_brcSettings.m_BRC_UPD_DistThreshldP_U8;
    setting->brcSettings.CBR_UPD_DistQPAdjTabI_U8            = (int8_t*)m_brcSettings.m_CBR_UPD_DistQPAdjTabI_U8;
    setting->brcSettings.CBR_UPD_DistQPAdjTabP_U8            = (int8_t*)m_brcSettings.m_CBR_UPD_DistQPAdjTabP_U8;
    setting->brcSettings.CBR_UPD_DistQPAdjTabB_U8            = (int8_t*)m_brcSettings.m_CBR_UPD_DistQPAdjTabB_U8;
    setting->brcSettings.VBR_UPD_DistQPAdjTabI_U8            = (int8_t*)m_brcSettings.m_VBR_UPD_DistQPAdjTabI_U8;
    setting->brcSettings.VBR_UPD_DistQPAdjTabP_U8            = (int8_t*)m_brcSettings.m_VBR_UPD_DistQPAdjTabP_U8;
    setting->brcSettings.VBR_UPD_DistQPAdjTabB_U8            = (int8_t*)m_brcSettings.m_VBR_UPD_DistQPAdjTabB_U8;
    setting->brcSettings.CBR_UPD_FrmSzAdjTabI_S8             = (int8_t*)m_brcSettings.m_CBR_UPD_FrmSzAdjTabI_S8;
    setting->brcSettings.CBR_UPD_FrmSzAdjTabP_S8             = (int8_t*)m_brcSettings.m_CBR_UPD_FrmSzAdjTabP_S8;
    setting->brcSettings.CBR_UPD_FrmSzAdjTabB_S8             = (int8_t*)m_brcSettings.m_CBR_UPD_FrmSzAdjTabB_S8;
    setting->brcSettings.VBR_UPD_FrmSzAdjTabI_S8             = (int8_t*)m_brcSettings.m_VBR_UPD_FrmSzAdjTabI_S8;
    setting->brcSettings.VBR_UPD_FrmSzAdjTabP_S8             = (int8_t*)m_brcSettings.m_VBR_UPD_FrmSzAdjTabP_S8;
    setting->brcSettings.VBR_UPD_FrmSzAdjTabB_S8             = (int8_t*)m_brcSettings.m_VBR_UPD_FrmSzAdjTabB_S8;
    setting->brcSettings.QVBR_UPD_FrmSzAdjTabP_S8            = (int8_t*)m_brcSettings.m_QVBR_UPD_FrmSzAdjTabP_S8;
    setting->brcSettings.LOW_DELAY_UPD_FrmSzAdjTabI_S8       = (int8_t*)m_brcSettings.m_LOW_DELAY_UPD_FrmSzAdjTabI_S8;
    setting->brcSettings.LOW_DELAY_UPD_FrmSzAdjTabP_S8       = (int8_t*)m_brcSettings.m_LOW_DELAY_UPD_FrmSzAdjTabP_S8;
    setting->brcSettings.LOW_DELAY_UPD_FrmSzAdjTabB_S8       = (int8_t*)m_brcSettings.m_LOW_DELAY_UPD_FrmSzAdjTabB_S8;
    setting->brcSettings.BRC_UPD_FrmSzMinTabP_U8             = (uint8_t*)m_brcSettings.m_BRC_UPD_FrmSzMinTabP_U8;
    setting->brcSettings.BRC_UPD_FrmSzMinTabI_U8             = (uint8_t*)m_brcSettings.m_BRC_UPD_FrmSzMinTabI_U8;
    setting->brcSettings.BRC_UPD_FrmSzMaxTabP_U8             = (uint8_t*)m_brcSettings.m_BRC_UPD_FrmSzMaxTabP_U8;
    setting->brcSettings.BRC_UPD_FrmSzMaxTabI_U8             = (uint8_t*)m_brcSettings.m_BRC_UPD_FrmSzMaxTabI_U8;
    setting->brcSettings.BRC_UPD_FrmSzSCGTabP_U8             = (uint8_t*)m_brcSettings.m_BRC_UPD_FrmSzSCGTabP_U8;
    setting->brcSettings.BRC_UPD_FrmSzSCGTabI_U8             = (uint8_t*)m_brcSettings.m_BRC_UPD_FrmSzSCGTabI_U8;

    setting->brcSettings.BRC_UPD_I_IntraNonPred = (uint8_t*)m_brcSettings.m_BRC_UPD_I_IntraNonPred;
    setting->brcSettings.BRC_UPD_I_Intra8x8     = (uint8_t*)m_brcSettings.m_BRC_UPD_I_Intra8x8;
    setting->brcSettings.BRC_UPD_I_Intra4x4     = (uint8_t*)m_brcSettings.m_BRC_UPD_I_Intra4x4;
    setting->brcSettings.BRC_UPD_P_IntraNonPred = (uint8_t*)m_brcSettings.m_BRC_UPD_P_IntraNonPred;
    setting->brcSettings.BRC_UPD_P_Intra16x16   = (uint8_t*)m_brcSettings.m_BRC_UPD_P_Intra16x16;
    setting->brcSettings.BRC_UPD_P_Intra8x8     = (uint8_t*)m_brcSettings.m_BRC_UPD_P_Intra8x8;
    setting->brcSettings.BRC_UPD_P_Intra4x4     = (uint8_t*)m_brcSettings.m_BRC_UPD_P_Intra4x4;
    setting->brcSettings.BRC_UPD_P_Inter16x8    = (uint8_t*)m_brcSettings.m_BRC_UPD_P_Inter16x8;
    setting->brcSettings.BRC_UPD_P_Inter8x8     = (uint8_t*)m_brcSettings.m_BRC_UPD_P_Inter8x8;
    setting->brcSettings.BRC_UPD_P_Inter16x16   = (uint8_t*)m_brcSettings.m_BRC_UPD_P_Inter16x16;
    setting->brcSettings.BRC_UPD_P_RefId        = (uint8_t*)m_brcSettings.m_BRC_UPD_P_RefId;

    return MOS_STATUS_SUCCESS;
}

MOS_STATUS EncodeAvcVdencConstSettings::Update(void *params)
{
    EncoderParams* encodeParams = (EncoderParams*)params;

    PCODEC_AVC_ENCODE_SEQUENCE_PARAMS avcSeqParams = 
        static_cast<PCODEC_AVC_ENCODE_SEQUENCE_PARAMS>(encodeParams->pSeqParams);
    ENCODE_CHK_NULL_RETURN(avcSeqParams);
    m_avcSeqParams = avcSeqParams;

    PCODEC_AVC_ENCODE_PIC_PARAMS avcPicParams =
        static_cast<PCODEC_AVC_ENCODE_PIC_PARAMS>(encodeParams->pPicParams);
    ENCODE_CHK_NULL_RETURN(avcPicParams);
    m_avcPicParams = avcPicParams;

    PCODEC_AVC_ENCODE_SLICE_PARAMS avcSliceParams =
        static_cast<PCODEC_AVC_ENCODE_SLICE_PARAMS>(encodeParams->pSliceParams);
    ENCODE_CHK_NULL_RETURN(avcSliceParams);
    m_avcSliceParams = avcSliceParams;

    return MOS_STATUS_SUCCESS;
}

MOS_STATUS EncodeAvcVdencConstSettings::SetVdencCmd3Settings()
{
    ENCODE_FUNC_CALL();

    ENCODE_CHK_NULL_RETURN(m_featureSetting);

    auto setting = static_cast<AvcVdencFeatureSettings *>(m_featureSetting);
    ENCODE_CHK_NULL_RETURN(setting);

    setting->vdencCmd3Settings = {
        VDENC_CMD3_LAMBDA()
        {
            auto     pictureType   = CodecHal_Clip3(0, 2, m_avcPicParams->CodingType - 1);
            uint16_t picWidthInMb  = CODECHAL_GET_WIDTH_IN_MACROBLOCKS(m_avcSeqParams->FrameWidth);
            uint16_t picHeightInMb = CODECHAL_GET_HEIGHT_IN_MACROBLOCKS(m_avcSeqParams->FrameHeight);
            m_qp = CodecHal_Clip3(10, 51, m_avcPicParams->QpY + m_avcSliceParams->slice_qp_delta);

            // Only do this lambda offset for lower resolution and high QP range.
            uint16_t gopP = (m_avcSeqParams->GopRefDist) ? ((m_avcSeqParams->GopPicSize - 1) / m_avcSeqParams->GopRefDist) : 0;
            uint16_t gopB = m_avcSeqParams->GopPicSize - 1 - gopP;
            uint16_t numB = ((gopP > 0) ? (gopB / gopP) : 0);
            if ((numB != 0) && (picWidthInMb * 16 < 1920) && (picHeightInMb * 16 < 1080) && (m_qp >= 32))
            {
                uint8_t index0 = m_avcPicParams->RefPicFlag ? 0 : 1;
                static const std::array<
                    std::array<
                        uint8_t,
                        3>,
                    2> 
                    table = {{
                    {0, 1, 1},
                    {0, 1, 2},
                    }};
                m_qp += table[index0][pictureType];
                m_qp = CodecHal_Clip3(0, 51, m_qp);
            }
            return MOS_STATUS_SUCCESS;
        },
        VDENC_CMD3_LAMBDA()
        {
            for (auto i = 0; i < 8; i++)
            {
                par.vdencCmd3Par0[i] = m_CMD3Settings.AvcVdencCMD3ConstSettings_0[i][m_qp];
            }
            return MOS_STATUS_SUCCESS;
        },
        VDENC_CMD3_LAMBDA()
        {
            auto codingType  = m_avcPicParams->CodingType;
            auto pictureType = CodecHal_Clip3(0, 2, m_avcPicParams->CodingType - 1);

            if (codingType == P_TYPE || codingType == B_TYPE)
            {
                for (auto i = 0; i < 12; i++)
                {
                    static const uint8_t cmd3Par1_ptype[12] = {4, 12, 20, 28, 36, 44, 52, 60, 68, 76, 84, 92};
                    static const uint8_t cmd3Par2_ptype[12] = {3, 10, 16, 22, 29, 35, 42, 48, 54, 61, 67, 74};

                    static const uint8_t cmd3Par1_btype[12] = {4, 12, 20, 28, 36, 44, 52, 60, 68, 76, 84, 92};
                    static const uint8_t cmd3Par2_btype[12] = {2, 5,  8,  11, 14, 17, 20, 23, 26, 29, 32, 35};

                    par.vdencCmd3Par1[i] = codingType == P_TYPE ? cmd3Par1_ptype[i] : cmd3Par1_btype[i];
                    par.vdencCmd3Par2[i] = codingType == P_TYPE ? cmd3Par2_ptype[i] : cmd3Par2_btype[i];
                }
            }
            else
            {
                for (auto i = 0; i < 12; i++)
                {
                    par.vdencCmd3Par1[i] = m_CMD3Settings.AvcVdencCMD3ConstSettings_1[pictureType][i];
                    par.vdencCmd3Par2[i] = par.vdencCmd3Par1[i];
                }
            }
            return MOS_STATUS_SUCCESS;
        },
        VDENC_CMD3_LAMBDA()
        {
            auto codingType  = m_avcPicParams->CodingType;
            auto isIPGOP     = m_avcSeqParams->GopRefDist == 1;
            auto pictureType = CodecHal_Clip3(0, 2, m_avcPicParams->CodingType - 1);
            if (codingType == P_TYPE)
            {
                par.vdencCmd3Par3  = 0;
                par.vdencCmd3Par4  = 0;
                par.vdencCmd3Par5  = isIPGOP ? 29 : 23;
                par.vdencCmd3Par6  = 6;
                par.vdencCmd3Par7  = isIPGOP ? 26 : 21;
                par.vdencCmd3Par8  = isIPGOP ? 16 : 13;
                par.vdencCmd3Par10 = 0;
                par.vdencCmd3Par11 = 4;

                par.vdencCmd3Par9  = isIPGOP ? 0 : 2;
                par.vdencCmd3Par12 = isIPGOP ? 12 : 4;

                par.vdencCmd3Par19 = m_CMD3Settings.AvcVdencCMD3ConstSettings_3[pictureType][m_qp];

                par.vdencCmd3Par20 = 6;
                par.vdencCmd3Par23 = isIPGOP ? 53 : 44;
                par.vdencCmd3Par21 = 16;
                par.vdencCmd3Par22 = isIPGOP ? 32 : 18;
            }
            else if (codingType == B_TYPE)
            {
                par.vdencCmd3Par3  = 0;
                par.vdencCmd3Par4  = 0;
                par.vdencCmd3Par5  = 36;
                par.vdencCmd3Par6  = 12;
                par.vdencCmd3Par7  = 35;
                par.vdencCmd3Par8  = 24;
                par.vdencCmd3Par10 = 4;
                par.vdencCmd3Par11 = 4;

                par.vdencCmd3Par9  = 2;
                par.vdencCmd3Par12 = 4;

                par.vdencCmd3Par19 = 14;
                par.vdencCmd3Par20 = 6;
                par.vdencCmd3Par23 = 42;
                par.vdencCmd3Par21 = 16;
                par.vdencCmd3Par22 = 22;
            }
            else if (codingType == I_TYPE)
            {
                par.vdencCmd3Par3 = m_CMD3Settings.AvcVdencCMD3ConstSettings_2[pictureType][RdModeConstSettings::SKIP_16X16];
                par.vdencCmd3Par4 = m_CMD3Settings.AvcVdencCMD3ConstSettings_2[pictureType][RdModeConstSettings::DIRECT_16X16];

                par.vdencCmd3Par5 = m_CMD3Settings.AvcVdencCMD3ConstSettings_2[pictureType][RdModeConstSettings::INTER_8X4];
                par.vdencCmd3Par6 = m_CMD3Settings.AvcVdencCMD3ConstSettings_2[pictureType][RdModeConstSettings::INTER_16X16];
                par.vdencCmd3Par7 = m_CMD3Settings.AvcVdencCMD3ConstSettings_2[pictureType][RdModeConstSettings::INTER_16X8];
                par.vdencCmd3Par8 = m_CMD3Settings.AvcVdencCMD3ConstSettings_2[pictureType][RdModeConstSettings::INTER_8X8];

                par.vdencCmd3Par9  = 4;
                par.vdencCmd3Par10 = m_CMD3Settings.AvcVdencCMD3ConstSettings_2[pictureType][RdModeConstSettings::INTER_BWD];
                par.vdencCmd3Par11 = m_avcSliceParams->num_ref_idx_l0_active_minus1 == 0 ? 0 : m_CMD3Settings.AvcVdencCMD3ConstSettings_2[pictureType][RdModeConstSettings::REF_ID];
                par.vdencCmd3Par12 = 0;

                par.vdencCmd3Par19 = m_CMD3Settings.AvcVdencCMD3ConstSettings_3[pictureType][m_qp];

                par.vdencCmd3Par20 = 6;
                par.vdencCmd3Par23 = 36;
                par.vdencCmd3Par21 = 14;
                par.vdencCmd3Par22 = 12;
            }
            return MOS_STATUS_SUCCESS;
        },
        VDENC_CMD3_LAMBDA()
        {
            par.vdencCmd3Par13 = 4;
            par.vdencCmd3Par14 = 36;
            par.vdencCmd3Par15 = 12;

            par.vdencCmd3Par16 = 0;
            par.vdencCmd3Par17 = 0;
            par.vdencCmd3Par18 = 0;

            par.vdencCmd3Par27 = 0;
            par.vdencCmd3Par28 = 0;

            par.vdencCmd3Par29 = 0;
            par.vdencCmd3Par30 = 0;

            return MOS_STATUS_SUCCESS;
        },
        VDENC_CMD3_LAMBDA()
        {
            uint8_t isIPGOP          = m_avcSeqParams->GopRefDist == 1 ? 1 : 0;
            uint8_t codingTypeMinus1 = m_avcPicParams->CodingType - 1;
            uint8_t refPic           = m_avcPicParams->RefPicFlag;

            par.vdencCmd3Par31 = m_CMD3Settings.par31Table[isIPGOP][codingTypeMinus1][refPic][m_qp];
            par.vdencCmd3Par32 = m_CMD3Settings.par32Table[isIPGOP][codingTypeMinus1][refPic][m_qp];

            return MOS_STATUS_SUCCESS;
        }
    };

    return MOS_STATUS_SUCCESS;
}

}  // namespace encode
