/*************************************************************************
 *
 *  $RCSfile: sdataf.cpp,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRUNTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRUNTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define INCL_PM
#define INCL_SPLDOSPRINT
#define INCL_DOS
#define INCL_DOSERRORS
#include <os2.h>

#include <som.xh>
#include <somcls.xh>
#include <wpdataf.xh>
#include <wppgmf.xh>

#include <wpdataf.xh>
#include <sdataf.h>

#include <stdio.h>

#define PRE_PRINTER	'@'

struct startData {
    WPDataFile *pObject;
    PSZ         pszProgram;
    PSZ         pszArguments;
    CHAR        szBuffer[1000];
};

/************************************************************************************
 *
 * queryVersionString - search for .VERSION EA in file
 *
 ************************************************************************************
 */

PSZ queryVersionString(PSZ pszFileName, PSZ pszBuffer, ULONG ulBufSize)
{
    static CHAR  szVersionEA[] = ".VERSION";
    static ULONG nfeaSize      = CCHMAXPATHCOMP;

    EAOP2 eaop;
    PSZ   pszRet = NULL;

    // allocate and fill GEA2List structure
    ULONG ulSize = sizeof(GEA2LIST) + sizeof(szVersionEA) - 1;

    if(DosAllocMem((PPVOID) &eaop.fpGEA2List, ulSize + nfeaSize, PAG_COMMIT | PAG_WRITE))
        return NULL;

    eaop.fpGEA2List->cbList = ulSize;
    eaop.fpGEA2List->list[0].oNextEntryOffset = 0L;  // no more entries;
    eaop.fpGEA2List->list[0].cbName  = sizeof(szVersionEA) - 1;

    strncpy(eaop.fpGEA2List->list[0].szName, szVersionEA, eaop.fpGEA2List->list[0].cbName);
    eaop.fpGEA2List->list[0].szName[eaop.fpGEA2List->list[0].cbName] = '\0';

    // allocate and fill FEA2List structure
    eaop.fpFEA2List = (PFEA2LIST) ((PBYTE) eaop.fpGEA2List + ulSize);
    eaop.fpFEA2List->cbList = nfeaSize;

    // query EA from file
    if(NO_ERROR == DosQueryPathInfo(pszFileName, FIL_QUERYEASFROMLIST,(PVOID) &eaop, sizeof(EAOP2)))
    {
        BYTE *pMem = (BYTE *) &eaop.fpFEA2List->list[1] + eaop.fpFEA2List->list[0].cbName;

        if(eaop.fpFEA2List->list[0].cbValue)
        {
            USHORT *pId  = (USHORT *) pMem;

            if((*pId == EAT_ASCII) && (pId[1] < ulBufSize ))
            {
                strncpy(pszBuffer, (const char *)(pId + 2), pId[1]);
                pszBuffer[pId[1]] = '\0';
                pszRet = pszBuffer;
            }
        }
    }

    DosFreeMem(eaop.fpGEA2List);
    return pszRet;
}

/************************************************************************************
 *
 * startApplication - thread main routine to start soffice.exe
 *
 ************************************************************************************
 */

void _Optlink startApplication(void *pData)
{
    HAB hab = WinInitialize(0);
    if (hab)
    {
        /* create message queue for this thread */
        HMQ hmq = WinCreateMsgQueue(hab, 0);
        if (hmq)
        {
            /* allow WM_QUIT events */
            WinCancelShutdown(hmq, TRUE);

            if(pData)
            {
                startData *pStartData = (startData *) pData;
                USEITEM   *pInUseItem = (USEITEM *) pStartData->pObject->wpAllocMem(sizeof(USEITEM) + sizeof(VIEWFILE), NULL);

                if(pInUseItem)
                {
                    // add to object list and set "in use" emphasis
                    VIEWFILE *pViewFile = (VIEWFILE *)((PBYTE) pInUseItem + sizeof(USEITEM));

                    pInUseItem->type = USAGE_OPENFILE;
                    pViewFile->ulMenuId = 0;
                    pViewFile->handle   = HWND_DESKTOP;

                    pStartData->pObject->wpAddToObjUseList(pInUseItem);
                    pStartData->pObject->wpCnrSetEmphasis (CRA_INUSE, TRUE);
                }

				STARTDATA sd;

				/* enclose file name in "" if it contains blanks */
				CHAR szArguments[260];
				if(strchr(pStartData->pszArguments, ' '))
				{
					sprintf(szArguments, "\"%s\"", pStartData->pszArguments);
					pStartData->pszArguments = szArguments;
				}

                /* initialize data structure */
                memset(&sd, 0, sizeof(STARTDATA));
                sd.Length = sizeof(STARTDATA);

                /* inherit options from parent */
                sd.InheritOpt = SSF_INHERTOPT_PARENT;
                sd.SessionType = SSF_TYPE_DEFAULT;

                /* start a child session and set Termination Queue */
                sd.FgBg	= SSF_FGBG_FORE;	  /* start session in foreground  */
                sd.TraceOpt = SSF_TRACEOPT_NONE;	  /* No trace				 */
                sd.PgmControl = SSF_CONTROL_VISIBLE;

                sd.PgmInputs = pStartData->pszArguments;
                sd.PgmName = pStartData->pszProgram;

                CHAR achObjBuf[256];
                sd.ObjectBuffer  = achObjBuf;
                sd.ObjectBuffLen = (ULONG) sizeof(achObjBuf);

                CHAR SessionTermQueueName[] = "\\QUEUES\\SOAGENT.QUE";
                HQUEUE SessionTermQueue;
                ULONG ulSessID;
                PID pidProcess;
                APIRET rc;

                /*
                 * the most probably reason for a failure is an office already running.
                 * in this case, the session will end directly anyway, so start it independent
                 */
                 
                if(NO_ERROR == DosCreateQueue(&SessionTermQueue, QUE_FIFO, SessionTermQueueName))
                {
                    sd.Related = SSF_RELATED_CHILD;
                    sd.TermQ = SessionTermQueueName;
                }
                else
                    sd.Related = SSF_RELATED_INDEPENDENT;
                     

                /* Start the session */
                rc = DosStartSession( &sd, &ulSessID, &pidProcess );

                if((rc == ERROR_SMG_START_IN_BACKGROUND) || (rc == NO_ERROR))
                {
                    ULONG pcbData, ulElement = 0;
                    REQUESTDATA rdData;
                    BYTE bPriority;
                    struct {
                        USHORT SessionID;
                        USHORT ReturnValue;
                    } *pvBuffer;

                    /* search/wait for the correct entry in termination queue */
                    while(( rc = DosPeekQueue( SessionTermQueue, &rdData, &pcbData,
                                               (PPVOID) &pvBuffer, &ulElement, DCWW_WAIT,
                                               &bPriority, NULLHANDLE )) == NO_ERROR )
                    {

                        if(pvBuffer->SessionID == ulSessID)
                        {
                            /* remove item from queue */
                            rc = DosReadQueue( SessionTermQueue, &rdData, &pcbData,
                                               (PPVOID)&pvBuffer, ulElement, DCWW_WAIT,
                                               &bPriority, NULLHANDLE );

                            break;
                        }
                    } /* while */
                }

                if(sd.Related == SSF_RELATED_CHILD)
                    DosCloseQueue(SessionTermQueue);

                if(pInUseItem)
                {
                    pStartData->pObject->wpDeleteFromObjUseList((PUSEITEM) pInUseItem);

                    // remove emphasis if not in use any longer
                    if(!(pStartData->pObject->wpFindUseItem(USAGE_OPENVIEW, NULL) ||
                         pStartData->pObject->wpFindUseItem(USAGE_OPENFILE, NULL)))
                    {
                        pStartData->pObject->wpCnrSetEmphasis(CRA_INUSE, FALSE );
                    }

                    pStartData->pObject->wpFreeMem((PBYTE) pInUseItem);
                }

                /* free memory block */
                pStartData->pObject->wpFreeMem((PBYTE) pData);
            }

            /* cleanup */
            WinDestroyMsgQueue(hmq);
        }
        /* free all PM-resources for this thread */
        WinTerminate(hab);
    }
}

/************************************************************************************
 *
 * queryExecutable - find suitable executable name from sversion.ini
 *
 ************************************************************************************
 */

BOOL queryExecutable(PSZ pszVersion, PSZ pszExecutable, ULONG ulSize)
{
    CHAR szBuffer[260];

    // query installed Office Versions
    if(PrfQueryProfileString(HINI_PROFILE, "StarOffice", NULL, NULL,
                             szBuffer, sizeof(szBuffer)))
    {
        float fMin = 0;
        float fBestFit = 0;
        PSZ   pszBestFit;
        PSZ   pszKey;

        if(*pszVersion)
            fMin = atof(pszVersion);

        // search version string
        for(pszKey = szBuffer; *pszKey; pszKey += strlen(pszKey) + 1)
        {
            float fActual;

            // get the actual version number
            fActual = atof(pszKey);

            if(!fBestFit ||
               (fMin && fActual >= fMin && fActual < fBestFit) ||
               (!fMin && fActual > fBestFit))
            {
                fBestFit   = fActual;
                pszBestFit = pszKey;
            }
        }

        if(pszBestFit && PrfQueryProfileString(HINI_PROFILE, "StarOffice",
                                               pszBestFit, NULL,
                                               szBuffer, sizeof(szBuffer)))

        {
            FILESTATUS3 fsStatus;
            APIRET      rc;
            PSZ         pszPath = szBuffer + strlen(szBuffer);

            strcpy(pszPath, "\\soffice.exe");
            rc = DosQueryPathInfo(szBuffer, FIL_STANDARD, &fsStatus, sizeof(fsStatus));

            if(rc == NO_ERROR && strlen(szBuffer) < ulSize)
            {
                strcpy(pszExecutable, szBuffer);
                return TRUE;
            }

            strcpy(pszPath, "\\program\\soffice.exe");
            rc = DosQueryPathInfo(szBuffer, FIL_STANDARD, &fsStatus, sizeof(fsStatus));

            if(rc == NO_ERROR && strlen(szBuffer) < ulSize)
            {
                strcpy(pszExecutable, szBuffer);
                return TRUE;
            }

            strcpy(pszPath, "\\bin\\soffice.exe");
            rc = DosQueryPathInfo(szBuffer, FIL_STANDARD, &fsStatus, sizeof(fsStatus));

            if(rc == NO_ERROR && strlen(szBuffer) < ulSize)
            {
                strcpy(pszExecutable, szBuffer);
                return TRUE;
            }
        }
    }

    return FALSE;
}

/************************************************************************************
 *
 * openObject
 *
 ************************************************************************************
 */

HWND openObject(WPDataFile *pObject, HWND hwndCnr)
{
    startData *pStartData = (startData *) pObject->wpAllocMem(sizeof(startData), NULL);

    if(pStartData)
    {
        ULONG ulSize = CCHMAXPATHCOMP;

        // query object path for use as parameter
        if(pObject->wpQueryRealName(pStartData->szBuffer, &ulSize, TRUE))
        {
            CHAR  szVersion [20];

            pStartData->pszArguments = pStartData->szBuffer;
            pStartData->pszProgram   = pStartData->szBuffer + ulSize + 1;

            if(!queryVersionString(pStartData->pszArguments, szVersion, sizeof(szVersion)))
                szVersion[0] = '\0';

            if(queryExecutable(szVersion, pStartData->pszProgram, CCHMAXPATHCOMP))
            {
                // set object parameter
                pStartData->pObject = pObject;

                // create application starter thread
                _beginthread(startApplication, 0, 16384, (void *) pStartData);

                // return a default window handle
                return hwndCnr;
            }
        }
    }

    return NULLHANDLE;
}

/************************************************************************************
 *
 * printObject
 *
 ************************************************************************************
 */

BOOL printObject(WPDataFile *pObject, PPRINTDEST pPrintDest)
{
    BOOL bRet = FALSE;
    CHAR szDeviceName[CCHMAXPATHCOMP];

    // search for the printer description parsed as argument to soffice.exe
    ULONG ulNeeded = 0;
    ULONG ulQueues;
    ULONG ulReturned;

    // query number of queues and buffer size needed
    SplEnumQueue(NULL, 3, 0, 0, &ulReturned, &ulQueues, &ulNeeded, NULL );

    PSZ pszQueueBuf = pObject->wpAllocMem(ulNeeded, NULL);
    if(pszQueueBuf)
    {
        // query available printer queues
        SplEnumQueue(NULL, 3, pszQueueBuf, ulNeeded, &ulReturned, &ulQueues, &ulNeeded, NULL);

        PPRQINFO3 pQueueInfo = (PPRQINFO3)pszQueueBuf;
        for (ULONG i=0; i < ulQueues; i++)
        {
            // copy device name for possible modification
            strcpy(szDeviceName, (pQueueInfo[i].pszPrinters));

            // device name ends at ','
            char *cp = strchr(szDeviceName, ',');
            if(cp) *cp = '\0';

            // query size of info buffer needed
            SplQueryDevice(NULL, szDeviceName, 3, NULL, 0, &ulNeeded);

            PPRDINFO3 pInfoBuf = (PPRDINFO3) pObject->wpAllocMem(ulNeeded, NULL);
            if(pInfoBuf)
            {
                // query device information for the queue
                SplQueryDevice(NULL, szDeviceName, 3, pInfoBuf, ulNeeded, &ulNeeded);

                // compare printer name to given value
                if(strcmp(pInfoBuf->pszPrinterName, pPrintDest->pszPrinter) == 0)
                {
                    // pQueueInfo->pszComment == Name Workplace Objekt
                    szDeviceName[0] = PRE_PRINTER;
                    strcpy(&szDeviceName[1], pQueueInfo[i].pszComment);

                    bRet = TRUE;
                }

                pObject->wpFreeMem((PBYTE) pInfoBuf);
            }

            // exit loop if device found
            if(bRet) break;
        }

        pObject->wpFreeMem((PBYTE) pszQueueBuf);
    }

    if(bRet)
    {
        startData *pStartData = (startData *) pObject->wpAllocMem(sizeof(startData), NULL);
        if(pStartData)
        {
            ULONG ulSize = CCHMAXPATHCOMP;

            sprintf(pStartData->szBuffer, "-p \"%s\" ", szDeviceName);
            ULONG ulTmp = strlen(pStartData->szBuffer);

            // query object path for use as parameter
            if(pObject->wpQueryRealName(pStartData->szBuffer + ulTmp , &ulSize, TRUE))
            {
                CHAR  szVersion [20];

                pStartData->pszArguments = pStartData->szBuffer;
                pStartData->pszProgram   = pStartData->szBuffer + ulSize + ulTmp + 1;

                if(!queryVersionString(pStartData->pszArguments, szVersion, sizeof(szVersion)))
                    szVersion[0] = '\0';

                if(queryExecutable(szVersion, pStartData->pszProgram, CCHMAXPATHCOMP))
                {
                    // set object parameter
                    pStartData->pObject = pObject;

                    // create application starter thread
                    _beginthread(startApplication, 0, 16384, (void *) pStartData);

                    return TRUE;
                }
            }
        }
    }

    return FALSE;
}
