/*************************************************************************
 *
 *  $RCSfile: optionhelper.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: lla $ $Date: 2003/01/28 10:13:34 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "cppunit/result/optionhelper.hxx"
// #include <sstream>
// #include <string>
#include <osl/time.h>

// -----------------------------------------------------------------------------

namespace 
{
	void split( const rtl::OString& opt,
				const rtl::OString& _sSeparator,
				OStringList& optLine )
	{
		optLine.clear();
		// const sal_Int32 cSetLen = cSet.getLength();
		sal_Int32 index = 0;
		sal_Int32 oldIndex = 0;
		
		// sal_Int32 i;
		// sal_Int32 j = 0;
		while ( opt.getLength() > 0)
		{
			// for ( i = 0; i < cSetLen; i++ ) 
			// {
			index = opt.indexOf( _sSeparator, oldIndex);
			if( index != -1 ) 
			{
				optLine.push_back( opt.copy( oldIndex, index - oldIndex ) );
				oldIndex = index + _sSeparator.getLength();
			}
			// }
			else // if (index == -1)
			{
				optLine.push_back( opt.copy( oldIndex ) );
				break;
			}
		}
	} ///< split
	
	bool match(OStringList const& _aFilter, OStringList const& _aName)
	{
		OStringList::const_iterator aFilterIter = _aFilter.begin();
		OStringList::const_iterator aValueIter = _aName.begin();
		
		bool bMatch = false;
		
		while (aFilterIter != _aFilter.end() && aValueIter != _aName.end())
		{
			rtl::OString sFilter = *aFilterIter;
			rtl::OString sName   = *aValueIter;
			
			if (sFilter == sName)
			{
				bMatch = true;
				++aFilterIter;
				++aValueIter;
			}
			else if (sFilter == "*")
			{
				bMatch = true;
				break;
			}
			else
			{
				// Filter does not match
				bMatch = false;
				break;
			}
		}
		return bMatch;
	}
}

std::string OptionHelper::integerToAscii(sal_Int32 nValue)
{
	sal_Char cBuf[20];
	sal_Char *pBuf = cBuf;
	sprintf(pBuf, "%d", nValue);
//# 	std::ostringstream sBuf;
//# 	sBuf << nValue;
 	return std::string(pBuf);
}

std::string OptionHelper::createDateTag(std::string const& _sProjectId, std::string const& _sBuildId)
{
    TimeValue tmv;
    oslDateTime dt;
    osl_getSystemTime( &tmv );
    osl_getDateTimeFromTimeValue( &tmv, &dt );

	sal_Int32 nYear = dt.Year;
	sal_Int32 nMonth = dt.Month;
	sal_Int32 nDay = dt.Day;

	std::string sDate("[");

	// sDate += rtl::OString::valueOf(nYear);
	sDate.append(integerToAscii(nYear));
	sDate += ".";
	if (nMonth < 10)
		sDate += "0";
	// sDate += rtl::OString::valueOf(nMonth);
	sDate.append(integerToAscii(nMonth));
	sDate += ".";
	if (nDay < 10)
		sDate += "0";
	// sDate += rtl::OString::valueOf(nDay);
	sDate += std::string(integerToAscii(nDay));
	sDate += "/";
        sDate += _sProjectId;
        sDate += "/";
        sDate += _sBuildId;
        sDate += "]";

	return sDate;
}

//# rtl::OString createDateTag()
//# {
//# 	TimeValue tmv;
//# 	oslDateTime dt;
//# 	osl_getSystemTime( &tmv );
//# 	osl_getDateTimeFromTimeValue( &tmv, &dt );
//# 
//# 	sal_Int32 nYear = dt.Year;
//# 	sal_Int32 nMonth = dt.Month;
//# 	sal_Int32 nDay = dt.Day;
//# 
//# 	rtl::OString sDate("[");
//# 	sDate += rtl::OString::valueOf(nYear);
//# 	sDate += ".";
//# 	if (nMonth < 10)
//# 		sDate += "0";
//# 	sDate += rtl::OString::valueOf(nMonth);
//# 	sDate += ".";
//# 	if (nDay < 10)
//# 		sDate += "0";
//# 	sDate += rtl::OString::valueOf(nDay);
//# 	sDate += "//]";
//# 
//# 	return sDate;
//# }

std::string OptionHelper::createDateTag()
{
	return createDateTag(m_sProjectId, m_sBuildId);
}

bool OptionHelper::showErrors()
{
    bool bRetValue = true; // default, show all
    if (m_aOption.hasOpt("-noerrors"))
    {
        bRetValue = false;
    }
    return bRetValue;
}

bool OptionHelper::showTests()
{
    bool bRetValue = true; // default, show all
    if (m_aOption.hasOpt("-onlyerrors"))
    {
        bRetValue = false;
    }
    return bRetValue;
}


void OptionHelper::handleJobs()
{
    // load job file, the file contains the functions which we only want to test.
    if (m_aOption.hasOpt("-jobonly"))
    {
        rtl::OString sJobFile = m_aOption.getOpt("-jobonly");
        
        m_aJobOnlyList.readfile(sJobFile.getStr());
    }

    // 
    if (m_aOption.hasOpt("-jobfilter"))
    {
        rtl::OString sJobFilter = m_aOption.getOpt("-jobfilter");
		split(sJobFilter, ".", m_aJobFilter);
    }
}

// -----------------------------------------------------------------------------
bool OptionHelper::isAllowedToExecute(std::string const& _sNodeName, std::string const& _sName)
{
    std::string sJobName = _sNodeName + "." + _sName;
    
    if (isOnlyShowJobs())
    {
        m_aJobOnlyList.setJobListEntry(sJobName, JOB_ACCESS);
        return false;
    }
    
    if (m_aJobOnlyList.size())
    {
        if (m_aJobOnlyList.getJobListEntry(sJobName) != JOB_NOT_FOUND)
        {
            m_aJobOnlyList.setJobListEntry(sJobName, JOB_ACCESS);
            return true;
        }
        return false;
    }
    else if (m_aJobFilter.size() > 0)
    {
		OStringList aSplitName;
		split(sJobName.c_str(), ".", aSplitName);
		if (! match(m_aJobFilter, aSplitName))
		{
			return false;
		}
    }
    else
	{
        //! not handled yet
	}
	
    return true;
}

