/*************************************************************************
 *
 *  $RCSfile: dlgtest.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: dr $ $Date: 2001/06/15 12:20:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#define ITEMID_BRUSH			0
#define ITEMID_TABSTOP			0
#define ITEMID_FONT				0
#define ITEMID_POSTURE			0
#define ITEMID_WEIGHT			0
#define ITEMID_SHADOWED			0
#define ITEMID_WORDLINEMODE		0
#define ITEMID_CONTOUR			0
#define ITEMID_CROSSEDOUT		0
#define ITEMID_UNDERLINE		0
#define ITEMID_FONTHEIGHT		0
#define ITEMID_PROPSIZE			0
#define ITEMID_COLOR			0
#define ITEMID_KERNING			0
#define ITEMID_CASEMAP			0
#define ITEMID_LANGUAGE			0
#define ITEMID_ESCAPEMENT		0
#define ITEMID_FONTLIST			0
#define ITEMID_BOX				0
#define ITEMID_BOXINFO			0
#define ITEMID_SHADOW			0
#define ITEMID_LINESPACING		0
#define ITEMID_ADJUST			0
#define ITEMID_ULSPACE			0
#define ITEMID_LRSPACE			0
#define ITEMID_HYPHENZONE		0
#define ITEMID_WIDOWS			0
#define ITEMID_ORPHANS	   		0
#define ITEMID_FMTSPLIT			0
#define ITEMID_FMTBREAK			0
#define ITEMID_FMTKEEP			0
#define ITEMID_PAGEMODEL		0
#define ITEMID_AUTHOR			0
#define ITEMID_DATE				0
#define ITEMID_TEXT				0
#define ITEMID_SEARCH			0
#define ITEMID_SIZE				0
#define ITEMID_PAPERBIN			0
#define ITEMID_PAGE				0
#define ITEMID_NUMBERINFO		0
#define ITEMID_AUTOKERN			0

#define ITEMID_SPELLCHECK		0
#define ITEMID_HYPHENREGION		0

#include <lingwrap.hxx>
#include <numbers.hxx>
#include <svdraw.hxx>

#include "dialogs.hxx"
#include "svxitems.hxx"
#include "drawdlgs.hxx"
#include "dbitems.hxx"
#include "dbdlgs.hxx"

#include "dialogs.hrc"
#include "dlgtest.hrc"

// define ----------------------------------------------------------------

#define MID_FILE			   100
#define MID_QUIT			   101

#define MID_DIALOG 			   110
#define MID_ZOOM 			   111
#define MID_TAB 			   112
#define MID_GRAF 			   113
#define MID_CLIP 			   114
#define MID_CHAR 			   115
#define MID_POSTIT 			   116
#define MID_SEARCH 			   117
#define MID_HYPHEN 			   118
#define MID_THES			   119
#define MID_SPELL			   120
#define MID_DBCONNECT		   121
#define MID_BITMAP			   122

#define MID_STARDRAW		   130
#define MID_LINE			   131
#define MID_AREA			   132
#define MID_TRANSFORM		   133

// Attribute -------------------------------------------------------------

#define ATTR_STARTINDEX			SID_ATTR_ZOOM	// Anfang Attribute

#define ATTR_ZOOM				(SID_ATTR_ZOOM)

#define ATTR_BACKGROUND	 		(SID_ATTR_BRUSH)

#define ATTR_TABULATOR	 		(SID_ATTR_TABSTOP)
#define ATTR_DEFTABS			(SID_ATTR_TABSTOP_DEFAULTS)
#define ATTR_TABPOS				(SID_ATTR_TABSTOP_POS)
#define ATTR_TABOFFSET			(SID_ATTR_TABSTOP_OFFSET)

#define ATTR_FONT	 			(SID_ATTR_CHAR_FONT)
#define ATTR_POSTURE			(SID_ATTR_CHAR_POSTURE)
#define ATTR_WEIGHT				(SID_ATTR_CHAR_WEIGHT)
#define ATTR_SHADOWED			(SID_ATTR_CHAR_SHADOWED)
#define ATTR_WORDLINEMODE		(SID_ATTR_CHAR_WORDLINEMODE)
#define ATTR_CONTOUR			(SID_ATTR_CHAR_CONTOUR)
#define ATTR_CROSSEDOUT			(SID_ATTR_CHAR_STRIKEOUT)
#define ATTR_UNDERLINE			(SID_ATTR_CHAR_UNDERLINE)
#define ATTR_FONTHEIGHT			(SID_ATTR_CHAR_FONTHEIGHT)
#define ATTR_PROPSIZE			(SID_ATTR_CHAR_PROPSIZE)
#define ATTR_COLOR	 			(SID_ATTR_CHAR_COLOR)
#define ATTR_KERNING			(SID_ATTR_CHAR_KERNING)
#define ATTR_CASEMAP			(SID_ATTR_CHAR_CASEMAP)
#define ATTR_LANGUAGE			(SID_ATTR_CHAR_LANGUAGE)
#define ATTR_ESCAPEMENT			(SID_ATTR_CHAR_ESCAPEMENT)
#define ATTR_FONTLIST			(SID_ATTR_CHAR_FONTLIST)
#define ATTR_AUTOKERN			(SID_ATTR_CHAR_AUTOKERN)

#define ATTR_BORDERINNER		(SID_ATTR_BORDER_INNER)
#define ATTR_BORDEROUTER		(SID_ATTR_BORDER_OUTER)
#define ATTR_BORDERSHADOW		(SID_ATTR_BORDER_SHADOW)

#define ATTR_PARAADJUST			(SID_ATTR_PARA_ADJUST)
#define ATTR_PARALINESPACE		(SID_ATTR_PARA_LINESPACE)
#define ATTR_PARAPAGEBREAK		(SID_ATTR_PARA_PAGEBREAK)
#define ATTR_PARAHYPHENZONE		(SID_ATTR_PARA_HYPHENZONE)
#define ATTR_PARASPLIT			(SID_ATTR_PARA_SPLIT)
#define ATTR_PARAWIDOWS			(SID_ATTR_PARA_WIDOWS)
#define ATTR_PARAORPHANS		(SID_ATTR_PARA_ORPHANS)
#define ATTR_PARAULSPACE		(SID_ATTR_PARA_ULSPACE)
#define ATTR_PARALRSPACE		(SID_ATTR_PARA_LRSPACE)

#define ATTR_POSTITAUTHOR		(SID_ATTR_POSTIT_AUTHOR)
#define ATTR_POSTITDATE			(SID_ATTR_POSTIT_DATE)
#define ATTR_POSTITTEXT			(SID_ATTR_POSTIT_TEXT)
#define ATTR_SEARCH				(SID_ATTR_SEARCH)

#define ATTR_LRSPACE			(SID_ATTR_LRSPACE)
#define ATTR_ULSPACE			(SID_ATTR_ULSPACE)
#define ATTR_PAGE				(SID_ATTR_PAGE)
#define ATTR_SIZE				(SID_ATTR_PAGE_SIZE)
#define ATTR_MAXSIZE			(SID_ATTR_PAGE_MAXSIZE)
#define ATTR_PAPERTRAY			(SID_ATTR_PAGE_PAPERTRAY)
#define ATTR_PAPERBIN			(SID_ATTR_PAGE_PAPERBIN)
#define ATTR_APP				(SID_ATTR_PAGE_APP)
#define ATTR_EXT1				(SID_ATTR_PAGE_EXT1)
#define ATTR_EXT2				(SID_ATTR_PAGE_EXT2)
#define ATTR_HEADERSET			(SID_ATTR_PAGE_HEADERSET)
#define ATTR_FOOTERSET			(SID_ATTR_PAGE_FOOTERSET)
#define ATTR_ON					(SID_ATTR_PAGE_ON)
#define ATTR_DYNAMIC			(SID_ATTR_PAGE_DYNAMIC)
#define ATTR_SHARED				(SID_ATTR_PAGE_SHARED)
#define ATTR_BSP				(SID_ATTR_PAGE_BSP)

#define ATTR_DBSESS_SERVERTYPE	(SID_ATTR_DBSESS_SERVERTYPE)
#define ATTR_DBSESS_SERVEROPTS	(SID_ATTR_DBSESS_SERVEROPTS)
#define ATTR_DBSESS_USERNAME 	(SID_ATTR_DBSESS_USERNAME)
#define ATTR_DBSESS_PASSWORD	(SID_ATTR_DBSESS_PASSWORD)
#define ATTR_DBSESS_SAVESESS	(SID_ATTR_DBSESS_SAVESESS)
#define ATTR_DBSESS_SAVEUSER	(SID_ATTR_DBSESS_SAVEUSER)
#define ATTR_DBSESS_SERVERNAME	(SID_ATTR_DBSESS_SERVERNAME)
#define ATTR_DBSESS_ENABLETYPE	(SID_ATTR_DBSESS_ENABLETYPE)

#define ATTR_VALUEFORMAT		(SID_ATTR_NUMBERFORMAT_VALUE)
#define ATTR_NUMBERINFO			(SID_ATTR_NUMBERFORMAT_INFO)

#define ATTR_TRANSF_POS_X		(SID_ATTR_TRANSFORM_POS_X)
#define ATTR_TRANSF_POS_Y		(SID_ATTR_TRANSFORM_POS_Y)
#define ATTR_TRANSF_WIDTH		(SID_ATTR_TRANSFORM_WIDTH)
#define ATTR_TRANSF_HEIGHT		(SID_ATTR_TRANSFORM_HEIGHT)
#define ATTR_TRANSF_SIZE_POINT	(SID_ATTR_TRANSFORM_SIZE_POINT)
#define ATTR_TRANSF_ROT_X		(SID_ATTR_TRANSFORM_ROT_X)
#define ATTR_TRANSF_ROT_Y		(SID_ATTR_TRANSFORM_ROT_Y)
#define ATTR_TRANSF_ANGLE		(SID_ATTR_TRANSFORM_ANGLE)

#define ATTR_ENDINDEX			ATTR_TRANSF_ANGLE  // Ende Attribute

// static ----------------------------------------------------------------

static SpellCheck* 			pSpeller 	= 0;
static SvNumberFormatter* 	pNumFmt 	= 0;
static FontList*			pFontList 	= 0;
static SvxSearchItem*		pSItem		= 0;

// class MyPool ----------------------------------------------------------

class MyPool : public SfxItemPool
{
public:
	MyPool( USHORT nStart, USHORT nEnd,	SfxPoolItem **pDefaults = 0 );

	virtual SfxMapUnit	GetMetric( USHORT nWhich ) const;
};

MyPool::MyPool( USHORT nStart, USHORT nEnd, SfxPoolItem** pDef ) :

	SfxItemPool( "dlgtest.svx", nStart, nEnd, pDef )
{
}

SfxMapUnit MyPool::GetMetric( USHORT nWhich ) const
{
	if ( nWhich == ATTR_FONTHEIGHT )
		return SFX_MAPUNIT_100TH_MM;
	return SFX_MAPUNIT_TWIP;
}

// class MyApp -----------------------------------------------------------

class MyApp : public Application
{
public:
	virtual void 	Main( int, char*[] );

	SfxItemPool*	GetPool();
	void			GetAttributes( SfxItemSet& rSet);
	void			SetAttributes( const SfxItemSet& rSet );
	void			DrawItems( Window* pWin );

private:
	MyPool*			pPool;
	SfxItemSet*		pItemSet;
};

// class AppWin ----------------------------------------------------------

class AppWin: public WorkWindow
{
public:
	AppWin();

	void			Paint( const Rectangle& rRect );

	DECL_LINK( FileSelect, Menu * );
	DECL_LINK( DialogSelect, Menu * );
	DECL_LINK( DrawSelect, Menu * );
};

// class MyTabDlg --------------------------------------------------------

class MyTabDlg : public SfxTabDialog
{
public:
	MyTabDlg( Window* pParent, const SfxItemSet* pCoreSet );
protected:
	virtual void PageCreated( USHORT nId, SfxTabPage &rPage );
};

// MyTabDlg::MyTabDlg ----------------------------------------------------

MyTabDlg::MyTabDlg( Window* pParent, const SfxItemSet* pCoreSet ) :

	SfxTabDialog( pParent, ResId( TABDLG_ATTR ), pCoreSet )

{
	AddTabPage( RID_SVXPAGE_BORDER, SvxBorderTabPage::Create, 0 );
	AddTabPage( RID_SVXPAGE_STD_PARAGRAPH, SvxStdParagraphTabPage::Create, 0 );
	AddTabPage( RID_SVXPAGE_EXT_PARAGRAPH, SvxExtParagraphTabPage::Create, 0 );
	AddTabPage( RID_SVXPAGE_TABULATOR, SvxTabulatorTabPage::Create, 0 );
	AddTabPage( RID_SVXPAGE_BACKGROUND, SvxBackgroundTabPage::Create, 0 );
	AddTabPage( RID_SVXPAGE_PAGE, SvxPageDescPage::Create, 0 );
	AddTabPage( RID_SVXPAGE_HEADER, SvxHeaderPage::Create, 0 );
	AddTabPage( RID_SVXPAGE_FOOTER, SvxFooterPage::Create, 0 );
	AddTabPage( RID_SVXPAGE_NUMBERFORMAT, SvxNumberFormatTabPage::Create, 0 );

	FreeResource();
}

// MyTabDlg::PageCreated -------------------------------------------------

void MyTabDlg::PageCreated( USHORT nId, SfxTabPage& rPage )
{
	switch ( nId )
	{
        case RID_SVXPAGE_CHAR_NAME:
		{
            ( (SvxCharNamePage&)rPage ).
				SetFontList( SvxFontListItem( pFontList ) );
//!			( (SvxCharStdPage&)rPage ).EnableRelativeMode();
			break;

		}
		case RID_SVXPAGE_NUMBERFORMAT:
		{
			( (SvxNumberFormatTabPage&)rPage ).
				SetNumberFormatList( SvxNumberInfoItem( pNumFmt ) );
			break;

		}
		case RID_SVXPAGE_STD_PARAGRAPH:
		{
//!			( (SvxStdParagraphTabPage&)rPage ).EnableRelativeMode();
			break;
		}
		case RID_SVXPAGE_EXT_PARAGRAPH:
		{
			SvStringsDtor aList;
			String* pStr = new String( "Standard" );
			aList.Insert( pStr, aList.Count() );
			pStr = new String( "Erste Seite" );
			aList.Insert( pStr, aList.Count() );
			pStr = new String( "Linke Seite" );
			aList.Insert( pStr, aList.Count() );
			pStr = new String( "Rechte Seite" );
			aList.Insert( pStr, aList.Count() );
			pStr = new String( "Umschlag" );
			aList.Insert( pStr, aList.Count() );
			pStr = new String( "Verzeichnis" );
			aList.Insert( pStr, aList.Count() );
			( (SvxExtParagraphTabPage&)rPage ).SetPageModels( aList );
			break;
		}
	}
}

// AppWin::AppWin() ------------------------------------------------------

AppWin::AppWin() :

	WorkWindow( 0, WinBits( WB_APP | WB_STDWORK ) )
{
}

// AppWin::FileSelect() --------------------------------------------------

IMPL_LINK( AppWin, FileSelect, Menu *, pMenu )
{
	switch ( pMenu->GetCurItemId() )
	{
		case MID_QUIT:
			Close();
			break;
	}
	return TRUE;
}

// AppWin::DialogSelect() ------------------------------------------------

IMPL_LINK( AppWin, DialogSelect, Menu *, pMenu )
{
	MyApp* pMyApp = (MyApp*)pApp;
	SfxItemSet aSet( *pMyApp->GetPool() );
	pMyApp->GetAttributes( aSet );

	switch ( pMenu->GetCurItemId() )
	{
		case MID_ZOOM:
		{
			SvxZoomDialog* pDlg = new SvxZoomDialog( this, aSet );
//!			pDlg->SetLimits( 10, 650 );

			if ( pDlg->Execute() == RET_OK )
				pMyApp->SetAttributes( *pDlg->GetOutputItemSet() );

			delete pDlg;
		}
		break;

		case MID_CLIP:
		{
			SvxImportClipboardDialog* pDlg =
				new SvxImportClipboardDialog( this );
			pDlg->Execute();
			delete pDlg;
		}
		break;

		case MID_TAB:
		{
			DBG_ASSERT( pNumFmt, "kein Zahlen-Formatierer" );

			MyTabDlg* pDlg = new MyTabDlg( this, &aSet );

			if ( pDlg->Execute() == RET_OK )
				pMyApp->SetAttributes( *pDlg->GetOutputItemSet() );

			delete pDlg;
		}
		break;

		case MID_GRAF:
		{
/*!!!
			SvxImportGraphicDialog* pDlg =
				new SvxImportGraphicDialog( this, "HALLO", "e:\\temp" );
			pDlg->Execute();
			delete pDlg;
			SfxItemSet aTmpSet( *pMyApp->GetPool(),
								SID_ATTR_SPELL,			SID_ATTR_SPELL,
								SID_ATTR_HYPHENREGION,	SID_ATTR_HYPHENREGION,
								0L );
			aTmpSet.Put( SfxSpellCheckItem( pSpeller, SID_ATTR_SPELL ) );
			aTmpSet.Put( SfxHyphenRegionItem( SID_ATTR_HYPHENREGION ) );


			SfxModalDialog* pDlg = new SfxModalDialog( this, aTmpSet );
			SfxTabPage* pPage = SfxHyphenTabPage::Create( pDlg, aTmpSet );
			pDlg->SetTabPage( pPage );

			if ( pDlg->Execute() == RET_OK )
				pMyApp->SetAttributes( *pDlg->GetOutputItemSet() );
*/
			SfxItemSet aTmpSet( *pMyApp->GetPool(),
								SID_ATTR_LANGUAGE, SID_ATTR_METRIC );
			aTmpSet.Put( SfxUInt16Item( SID_ATTR_LANGUAGE, 1 ) );
			aTmpSet.Put( SfxUInt16Item( SID_ATTR_METRIC, 1 ) );

			SfxModalDialog* pDlg =
				new SfxModalDialog( this, aTmpSet, RID_SFXPAGE_GENERAL );
			SfxTabPage* pPage = SfxGeneralTabPage::Create( pDlg, aTmpSet );
			pDlg->SetTabPage( pPage );

			if ( pDlg->Execute() == RET_OK )
			{
				const SfxItemSet* pSet = pDlg->GetOutputItemSet();
				const SfxUInt16Item& rLItem =
					(const SfxUInt16Item&)pSet->Get(SID_ATTR_LANGUAGE);
				const SfxUInt16Item& rMItem =
					(const SfxUInt16Item&)pSet->Get(SID_ATTR_METRIC);
				pMyApp->SetAttributes( *pSet );
			}

			delete pDlg; // loescht auch die Page!!!
		}
		break;

		case MID_CHAR:
		{
			SvxCharacterMap* pDlg = new SvxCharacterMap( this, FALSE );
			pDlg->ChangeFont( Font( "Times New Roman", Size( 0, 240 ) ) );
			pDlg->Execute();
			delete pDlg;
		}
		break;

		case MID_POSTIT:
		{
			SvxPostItDialog* pDlg = new SvxPostItDialog( this, aSet, TRUE );

			if ( pDlg->Execute() == RET_OK )
				pMyApp->SetAttributes( *pDlg->GetOutputItemSet() );
			delete pDlg;
		}
		break;

		case MID_SEARCH:
		{
			if ( !pSItem )
				pSItem = new SvxSearchItem( SID_ATTR_SEARCH );
//!			SvxSearchDialog* pDlg = new SvxSearchDialog( this, *pSItem );
		}
		break;

		case MID_HYPHEN:
		{
			DBG_ASSERT( pSpeller, "kein Speller" );
			DBG_ASSERT( pSpeller->SetActualLanguage( LANGUAGE_GERMAN ), "kein Deutsch" );
			DBG_ASSERT( pSpeller->HyphenateWord( "Autobahn" ), "kein Wort" );
			SvxHyphenator* pHyphen = new SvxHyphenator( this, pSpeller, TRUE, TRUE );
			delete pHyphen;
		}
		break;

		case MID_THES:
		{
			if( !LinguBase::LoadDll() )
			{
				InfoBox( this, "Load LinguDll failed!" ).Execute();
				break;
			}

			Thesaurus* pThes = new Thesaurus( pSpeller );
			DBG_ASSERT( pThes, "kein Thesaurus" );

			if ( pThes->HasError() )
			{
				InfoBox( this, "Thesaurus has errors!" ).Execute();
				delete pThes;
				break;
			}

			pApp->Wait(TRUE);
			DBG_ASSERT( pThes->LookUp( "Liebhaber" ), "false lookup" );
			pApp->Wait(FALSE);

			SvxThesaurusDialog* pDlg =
				new SvxThesaurusDialog( this, pThes, FALSE );
			pDlg->Execute();
			pThes->EndLookUp();
			delete pDlg;
			delete pThes;
		}
		break;

		case MID_SPELL:
		{
			DBG_ASSERT( pSpeller, "kein Speller" );
			DBG_ASSERT( pSpeller->SetActualLanguage( LANGUAGE_GERMAN ), "kein Deutsch" );
			pSpeller->SpellWord( "ersezen" );
			SvxSpellWrapper* pWrp = new SvxSpellWrapper( this, pSpeller,
				SVX_DOCPOS_START, SVX_DOCPOS_END, FALSE, FALSE );
			delete pWrp;
		}
		break;

		case MID_DBCONNECT:
		{
			SvxDbConnectDialog* pDlg = new SvxDbConnectDialog( this, aSet );
			if ( pDlg->Execute() == RET_OK )
				pMyApp->SetAttributes( *pDlg->GetOutputItemSet() );
			delete pDlg;
		}
		break;

		case MID_BITMAP:
		{
			SfxItemSet aTmpSet( *pMyApp->GetPool(),
				SID_ATTR_CHAR_FONT,
				SID_ATTR_CHAR_FONT );
			pMyApp->GetAttributes( aTmpSet );

			MyTabDlg* pDlg = new MyTabDlg( this, &aTmpSet );

			if ( pDlg->Execute() == RET_OK )
				pMyApp->SetAttributes( *pDlg->GetOutputItemSet() );

			delete pDlg;
/*!!!
			Bitmap aBitmap;
			DirEntry aPath( "d:\\temp\\bitmaps" );
			Dir aFileDir( aPath, FSYS_KIND_FILE );
			DirEntry aBmp;

			InfoBox( this, String( "Nun konvertieren wir " ) +
						   String( aFileDir.Count() ) +
						   String( " Bitmaps." ) ).Execute();

			for ( USHORT i = 0; i < aFileDir.Count(); ++i )
			{
				aBmp = aFileDir[i];
				SvFileStream aSvFileStrm( aBmp.GetFull().GetStr(), STREAM_READ );
				aSvFileStrm >> aBitmap;
				Size aSize = aBitmap.GetSizePixel();

				if ( aSize.Width() < 18 || aSize.Height() < 17 )
				{
					DrawText( Point( 10, 300 ), String(i) );

					VirtualDevice aNewBitmap;
					aNewBitmap.SetOutputSizePixel( Size( 18, 17 ) );
					Rectangle aRect( Point( 0, 0 ), Size( 18, 17 ) );
					Pen aPen( PEN_NULL );
					aNewBitmap.ChangePen( aPen );
					aNewBitmap.ChangeFillInBrush( Brush( Color( COL_LIGHTGRAY ) ) );
					aNewBitmap.DrawRect( aRect );

					short nDeltaX = (short)( 18 - aSize.Width() ) / 2;
					short nDeltaY = (short)( 17 - aSize.Height() ) / 2;

					aNewBitmap.DrawBitmap(
						Point( nDeltaX >= 0 ? nDeltaX : 0,
							   nDeltaY >= 0 ? nDeltaY : 0 ), aBitmap );
					Bitmap aTmp = aNewBitmap.GetBitmap( Point( 0, 0 ), Size( 18, 17 ) );
					String aName( aBmp.GetName() );
					DirEntry aOutput( "d:\\temp\\bitmaps\\new" );
					aOutput += DirEntry( aName );
					SvFileStream aSvOutStrm( aOutput.GetFull().GetStr(), STREAM_WRITE );
					aSvOutStrm << aTmp;
				}
			}
*/
		}
		break;
	}
	return TRUE;
}

// AppWin::DrawSelect() -----------------------------------------------------

IMPL_LINK( AppWin, DrawSelect, Menu *, pMenu )
{
	MyApp* pMyApp = (MyApp*)pApp;
	SdrItemPool* pSdrPool = new SdrItemPool();
	SfxItemSet aSet( *pSdrPool );

	switch ( pMenu->GetCurItemId() )
	{
		case MID_LINE:
		{
			XColorTable 	aXColTbl;
			XDashList		aXDshLst;
			XLineEndList	aXLLst;

			SvxLineTabDialog* pDlg = new SvxLineTabDialog(
					this, &aSet, &aXColTbl, &aXDshLst, &aXLLst );

			if ( pDlg->Execute() == RET_OK )
			{
				pMyApp->SetAttributes( *pDlg->GetOutputItemSet() );
			}
			delete pDlg;
		}
		break;

		case MID_AREA:
		{
			XColorTable 	aXColTbl;
			XGradientList	aXGrdLst;
			XHatchList		aXHtchLst;
			XBitmapList		aXBmpLst;

			SvxAreaTabDialog* pDlg = new SvxAreaTabDialog(
					this, &aSet, &aXColTbl, &aXGrdLst, &aXHtchLst, &aXBmpLst );

			if ( pDlg->Execute() == RET_OK )
			{
				pMyApp->SetAttributes( *pDlg->GetOutputItemSet() );
			}
			delete pDlg;
		}
		break;

		case MID_TRANSFORM:
		{
			SfxItemSet aTmpSet( *pMyApp->GetPool() );
			pMyApp->GetAttributes( aTmpSet );

			Rectangle aRect( Point( 0, 0 ), Size( 18, 17 ) );
			SvxTransformTabDialog* pDlg =
				new SvxTransformTabDialog( this, &aTmpSet, aRect );

			if ( pDlg->Execute() == RET_OK )
			{
				pMyApp->SetAttributes( *pDlg->GetOutputItemSet() );
			}
			delete pDlg;
		}
		break;
	}
	delete pSdrPool;
	return TRUE;
}

// AppWin::Paint() -------------------------------------------------------

void AppWin::Paint( const Rectangle& rRect )
{
	Pen aOldPen = ChangePen( Pen( PEN_NULL ) );
	DrawRect( rRect );
	( (MyApp*)pApp )->DrawItems( this );
	SetPen( aOldPen );
}

// MyApp::GetPool() ------------------------------------------------------

SfxItemPool* MyApp::GetPool()
{
	if ( pPool )
		return pPool;
	return 0;
}

// MyApp::GetAttributes() ------------------------------------------------

void MyApp::GetAttributes( SfxItemSet& rSet )
{
	DBG_ASSERT( pItemSet, "invalid itemset" );
	rSet.Put( *pItemSet );
}

// MyApp::SetAttributes() ------------------------------------------------

void MyApp::SetAttributes( const SfxItemSet& rSet )
{
	DBG_ASSERT( pItemSet, "invalid itemset" );
	pItemSet->Put( rSet );
	GetAppWindow()->Invalidate();
}

// MyApp::DrawItems() ----------------------------------------------------

void MyApp::DrawItems( Window* pWin )
{
	Point aPnt1( 10, 10 ), aPnt2( 100, 10 );
	short nDelta = 20;
	const SfxPoolItem* pItem = 0;

	if ( !pItemSet->Count() )
		return;

	SfxItemIter aIter( *pItemSet );

	while ( TRUE )
	{
		BOOL bEnd = aIter.IsAtEnd();
		pItem = aIter.GetCurItem();

		aPnt1.Y() += nDelta;
		aPnt2.Y() += nDelta;

		pWin->DrawText( aPnt1, String( pItem->Which() ) );
		pWin->DrawText( aPnt2, pItem->GetValueText() );

		if ( pItem->ISA(SvxBrushItem) )
		{
			Brush aBrush( ( (SvxBrushItem*)pItem )->GetBrush() );
			Brush aOldBrush = pWin->ChangeFillInBrush( aBrush );
			Point aPnt3( 200, aPnt1.Y() );
			Rectangle aRect( aPnt3, Size( 50, 50 ) );
			pWin->DrawRect( aRect );
			pWin->ChangeFillInBrush( aOldBrush );
		}

		if ( bEnd )
			break;
		aIter.NextItem();
	}
}

// MyApp::Main() ---------------------------------------------------------

void MyApp::Main( int, char*[] )
{
	pSpeller = new SpellCheck( DirEntry( "s:\\swgnet.win" ),
							   DirEntry( "d:\\temp" ) );
	pNumFmt = new SvNumberFormatter( COUNTRY_GERMANY, LANGUAGE_GERMAN );
	// erstmal ein Printer besorgen, dann von dem die Fontlist
	Printer MyPrinter( System::GetDefaultPrinterName() );
	pFontList = new FontList( &MyPrinter );

	// default items
	USHORT nAttrCnt = ATTR_ENDINDEX - ATTR_STARTINDEX;
	SfxPoolItem** ppDefaults = new SfxPoolItem*[nAttrCnt];

	ppDefaults[ 0] = new SfxUInt16Item( ATTR_ZOOM, 100 );

	ppDefaults[ 1] = new SvxBrushItem( FALSE, COL_WHITE, COL_BLACK,
									  BRUSH_SOLID, ATTR_BACKGROUND );

	ppDefaults[ 2] = new SvxTabStopItem( ATTR_TABULATOR );
	ppDefaults[ 3] = new SfxUInt16Item( ATTR_DEFTABS, 1134 );
	ppDefaults[ 4] = new SfxUInt16Item( ATTR_TABPOS, 0 );
	ppDefaults[ 5] = new SfxUInt16Item( ATTR_TABOFFSET, 0 );

	ppDefaults[ 6] = new SfxBoolItem( ATTR_TABOFFSET + 1 );
	ppDefaults[ 7] = new SvxFontItem( FAMILY_DONTKNOW, "Arial",
									  "Standard", PITCH_VARIABLE,
									  CHARSET_DONTKNOW, ATTR_FONT );
	ppDefaults[ 8] = new SvxPostureItem( ITALIC_NONE, ATTR_POSTURE );
	ppDefaults[ 9] = new SvxWeightItem( WEIGHT_NORMAL, ATTR_WEIGHT );
	ppDefaults[10] = new SvxShadowedItem( FALSE, ATTR_SHADOWED );
	ppDefaults[11] = new SvxWordLineModeItem( FALSE, ATTR_WORDLINEMODE );
	ppDefaults[12] = new SvxContourItem( FALSE, ATTR_CONTOUR );
	ppDefaults[13] = new SvxCrossedOutItem( STRIKEOUT_NONE, ATTR_CROSSEDOUT );
	ppDefaults[14] = new SvxUnderlineItem( UNDERLINE_NONE, ATTR_UNDERLINE );
	ppDefaults[15] = new SvxFontHeightItem( 847, 100, ATTR_FONTHEIGHT );
	ppDefaults[16] = new SvxPropSizeItem( 100, ATTR_PROPSIZE );
	ppDefaults[17] = new SvxColorItem( Color( COL_BLACK ),ATTR_COLOR );
	ppDefaults[18] = new SvxKerningItem( 0, ATTR_KERNING );
	ppDefaults[19] = new SvxCaseMapItem( RES_NOTCASEMAPPED, ATTR_CASEMAP );
	ppDefaults[20] = new SvxLanguageItem( LANGUAGE_GERMAN, ATTR_LANGUAGE );
	ppDefaults[21] = new SvxEscapementItem( ATTR_ESCAPEMENT );

	// erstmal ein Printer besorgen, dann von dem die Fontlist
	FontList* pList = new FontList( &MyPrinter );
	ppDefaults[22] = new SvxFontListItem( pList, ATTR_FONTLIST );

	SvxBoxInfoItem* pBoxInfo = new SvxBoxInfoItem( ATTR_BORDERINNER );
	pBoxInfo->SetTable( TRUE );
	pBoxInfo->SetDist( TRUE );
	pBoxInfo->SetTopValid( FALSE );
	pBoxInfo->SetRightValid( FALSE );
	pBoxInfo->SetHorizontalValid( FALSE );
	pBoxInfo->SetVerticalValid( FALSE );
	pBoxInfo->SetDistanceValid( TRUE );
	pBoxInfo->SetDisableDontCare( TRUE );
	ppDefaults[23] = pBoxInfo;
	SvxBoxItem* pBox = new SvxBoxItem( ATTR_BORDEROUTER );
	pBox->SetDistance( 567 );
	ppDefaults[24] = pBox;
	SvxShadowItem* pShadow = new SvxShadowItem( ATTR_BORDERSHADOW );
	ppDefaults[25] = pShadow;

	ppDefaults[26] = new SfxBoolItem( ATTR_BORDERSHADOW + 1 );
	ppDefaults[27] = new SvxAdjustItem( ADJLEFT, ATTR_PARAADJUST );
	ppDefaults[28] = new SfxBoolItem( ATTR_PARAADJUST + 1 );
	ppDefaults[29] = new SfxBoolItem( ATTR_PARAADJUST + 2 );
	ppDefaults[30] = new SfxBoolItem( ATTR_PARAADJUST + 3 );
	ppDefaults[31] = new SfxBoolItem( ATTR_PARAADJUST + 4 );
	ppDefaults[32] = new SfxBoolItem( ATTR_PARAADJUST + 5 );
	ppDefaults[33] = new SvxLineSpacingItem( 200, ATTR_PARALINESPACE );
	ppDefaults[34] = new SfxBoolItem( ATTR_PARALINESPACE + 1 );
	ppDefaults[35] = new SfxBoolItem( ATTR_PARALINESPACE + 2 );
	ppDefaults[36] = new SfxBoolItem( ATTR_PARALINESPACE + 3 );
	ppDefaults[37] = new SvxFmtBreakItem( ATTR_PARAPAGEBREAK );
	ppDefaults[38] = new SvxHyphenZoneItem( FALSE, ATTR_PARAHYPHENZONE );
	ppDefaults[39] = new SvxFmtSplitItem( TRUE, ATTR_PARASPLIT );
	ppDefaults[40] = new SvxWidowsItem( 0, ATTR_PARAWIDOWS );
	ppDefaults[41] = new SvxOrphansItem( 0, ATTR_PARAORPHANS );
	ppDefaults[42] = new SvxULSpaceItem( ATTR_PARAULSPACE );
	SvxLRSpaceItem* pLRSItem = new SvxLRSpaceItem( ATTR_PARALRSPACE );
	pLRSItem->SetTxtLeft( 1100 );
	ppDefaults[43] = pLRSItem;

	ppDefaults[44] = new SvxPostItAuthorItem( "PB", ATTR_POSTITAUTHOR );
	ppDefaults[45] = new SvxPostItDateItem( "25.11.1994", ATTR_POSTITDATE );
	ppDefaults[46] = new SvxPostItTextItem( "Auch sehr nett.", ATTR_POSTITTEXT );

	SvxSearchItem* pSrchItem = new SvxSearchItem( ATTR_SEARCH );
	pSrchItem->SetAppFlag(SVX_SEARCHAPP_WRITER);
	ppDefaults[47] = pSrchItem;

	ppDefaults[48] = new SvxLRSpaceItem( ATTR_LRSPACE );
	ppDefaults[49] = new SvxULSpaceItem( ATTR_ULSPACE );

	ppDefaults[50] = new SvxPageItem( ATTR_PAGE );
	ppDefaults[51] = new SvxSizeItem( ATTR_SIZE );
	ppDefaults[52] = new SvxSizeItem( ATTR_MAXSIZE );
	ppDefaults[53] = new SfxAllEnumItem( ATTR_PAPERTRAY );
	ppDefaults[54] = new SvxPaperBinItem( ATTR_PAPERBIN );
	ppDefaults[55] = new SfxUInt16Item( ATTR_APP );
	ppDefaults[56] = new SfxStringItem( ATTR_EXT1, String() );
	ppDefaults[57] = new SfxBoolItem( ATTR_EXT2 );
	ppDefaults[58] = new SfxBoolItem( ATTR_HEADERSET );
	ppDefaults[59] = new SfxBoolItem( ATTR_FOOTERSET );
	ppDefaults[60] = new SfxBoolItem( ATTR_ON );
	ppDefaults[61] = new SfxBoolItem( ATTR_DYNAMIC );
	ppDefaults[62] = new SfxBoolItem( ATTR_SHARED );
	ppDefaults[63] = new SfxBoolItem( ATTR_BSP );

	ppDefaults[64] = new SfxBoolItem( ATTR_BSP + 1 );
	ppDefaults[65] = new SvxPageModelItem( "Peter", ATTR_BSP + 2 );
	ppDefaults[66] = new SvxFmtKeepItem( TRUE, ATTR_BSP + 3 );
	ppDefaults[67] = new SvxAutoKernItem( TRUE, ATTR_AUTOKERN );
	ppDefaults[68] = new SfxBoolItem( ATTR_BSP + 5 );
	ppDefaults[69] = new SfxBoolItem( ATTR_BSP + 6 );

	ppDefaults[70] = new SvxDbTypeItem( SID_ATTR_DBSESS_SERVERTYPE );
	ppDefaults[71] = new SfxStringItem( SID_ATTR_DBSESS_SERVEROPTS, String() );
	ppDefaults[72] = new SfxStringItem( SID_ATTR_DBSESS_USERNAME, "PB" );
	ppDefaults[73] = new SfxStringItem(	SID_ATTR_DBSESS_PASSWORD, "boris" );
	ppDefaults[74] = new SfxBoolItem( SID_ATTR_DBSESS_SAVESESS );
	ppDefaults[75] = new SfxBoolItem( SID_ATTR_DBSESS_SAVEUSER );
	ppDefaults[76] = new SfxStringItem( SID_ATTR_DBSESS_SERVERNAME, String() );
	ppDefaults[77] = new SfxBoolItem( SID_ATTR_DBSESS_ENABLETYPE, TRUE );

	ppDefaults[78] = new SfxBoolItem( ATTR_DBSESS_ENABLETYPE + 1 );
	ppDefaults[79] = new SfxBoolItem( ATTR_DBSESS_ENABLETYPE + 2 );
	ppDefaults[80] = new SfxBoolItem( ATTR_DBSESS_ENABLETYPE + 3 );
	ppDefaults[81] = new SfxBoolItem( ATTR_DBSESS_ENABLETYPE + 4 );
	ppDefaults[82] = new SfxBoolItem( ATTR_DBSESS_ENABLETYPE + 5 );
	ppDefaults[83] = new SfxBoolItem( ATTR_DBSESS_ENABLETYPE + 6 );
	ppDefaults[84] = new SfxBoolItem( ATTR_DBSESS_ENABLETYPE + 7 );

	ppDefaults[85] = new SfxUInt32Item( ATTR_VALUEFORMAT, 0 );
	ppDefaults[86] = new SvxNumberInfoItem( (USHORT)ATTR_NUMBERINFO );

	ppDefaults[87] = new SfxBoolItem( ATTR_DBSESS_ENABLETYPE + 10 );
	ppDefaults[88] = new SfxUInt32Item( ATTR_TRANSF_POS_X, 0 );
	ppDefaults[89] = new SfxUInt32Item( ATTR_TRANSF_POS_Y, 0 );
	ppDefaults[90] = new SfxUInt32Item( ATTR_TRANSF_WIDTH, 0 );
	ppDefaults[91] = new SfxUInt32Item( ATTR_TRANSF_HEIGHT, 0 );
	ppDefaults[92] = new SfxAllEnumItem( ATTR_TRANSF_SIZE_POINT );
	ppDefaults[93] = new SfxUInt32Item( ATTR_TRANSF_ROT_X, 0 );
	ppDefaults[94] = new SfxUInt32Item( ATTR_TRANSF_ROT_Y, 0 );
	ppDefaults[95] = new SfxUInt32Item( ATTR_TRANSF_ANGLE, 0 );

	pPool = new MyPool( ATTR_STARTINDEX, ATTR_ENDINDEX, ppDefaults );
	pItemSet = new SfxItemSet( *pPool );

	ChangeAppFont( Font( ResId( RID_APPFONT ) ) );
	EnableSVLook();

	AppWin aMainWin;
	aMainWin.SetText( "SVX Example" );
	aMainWin.ChangeIcon( Icon( ResId( RID_APPWINDOWICON ) ) );
	aMainWin.Show();

	MenuBar aMenuBar;

	PopupMenu aFileMenu;
	PopupMenu aDialogMenu;
	PopupMenu aDrawMenu;

	aMenuBar.InsertItem( MID_FILE,		String( ResId( RID_FILE ) ) );
	aMenuBar.InsertItem( MID_DIALOG, 	String( ResId( RID_DIALOG ) ) );
	aMenuBar.InsertItem( MID_STARDRAW, 	String( ResId( RID_DRAW ) ) );

	aMenuBar.ChangePopupMenu( MID_FILE,		&aFileMenu );
	aMenuBar.ChangePopupMenu( MID_DIALOG,	&aDialogMenu );
	aMenuBar.ChangePopupMenu( MID_STARDRAW,	&aDrawMenu );

	aFileMenu.InsertItem	( MID_QUIT,		String( ResId( RID_FILE_QUIT ) ) );

	aDialogMenu.InsertItem	( MID_ZOOM,		String( ResId( RID_DIALOG_ZOOM ) ) );
	aDialogMenu.InsertItem	( MID_TAB,		String( ResId( RID_DIALOG_TABDLG ) ) );
	aDialogMenu.InsertItem	( MID_GRAF,		String( ResId( RID_DIALOG_IMPGRF ) ) );
	aDialogMenu.InsertItem	( MID_CLIP,		String( ResId( RID_DIALOG_IMPCLP ) ) );
	aDialogMenu.InsertItem	( MID_CHAR,		String( ResId( RID_DIALOG_CHARMAP ) ) );
	aDialogMenu.InsertItem	( MID_POSTIT,	String( ResId( RID_DIALOG_POSTIT ) ) );
	aDialogMenu.InsertItem	( MID_SEARCH,	String( ResId( RID_DIALOG_SEARCH ) ) );
	aDialogMenu.InsertItem	( MID_HYPHEN,	String( ResId( RID_DIALOG_HYPHEN ) ) );
	aDialogMenu.InsertItem	( MID_THES,		String( ResId( RID_DIALOG_THESAU ) ) );
	aDialogMenu.InsertItem	( MID_SPELL,	String( ResId( RID_DIALOG_SPELL ) ) );
	aDialogMenu.InsertItem	( MID_DBCONNECT,String( ResId( RID_DIALOG_DB ) ) );
	aDialogMenu.InsertItem	( MID_BITMAP,	String( ResId( RID_DIALOG_BITMAP ) ) );

	aDrawMenu.InsertItem	( MID_LINE,		String( ResId( RID_DRAW_LINE ) ) );
	aDrawMenu.InsertItem	( MID_AREA,		String( ResId( RID_DRAW_AREA ) ) );
	aDrawMenu.InsertItem	( MID_TRANSFORM,String( ResId( RID_DRAW_TRANSF ) ) );

	aFileMenu.PushSelectHdl( LINK( &aMainWin, AppWin, FileSelect ) );
	aDialogMenu.PushSelectHdl( LINK( &aMainWin, AppWin, DialogSelect ) );
	aDrawMenu.PushSelectHdl( LINK( &aMainWin, AppWin, DrawSelect ) );

	ChangeAppMenu( &aMenuBar );

	Execute();

	delete pSpeller;
	delete pNumFmt;
	delete pFontList;
	delete pSItem;
}

// aMyApp ----------------------------------------------------------------

MyApp aMyApp;

