/*************************************************************************
 *
 *  $RCSfile: plicense.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: dv $ $Date: 2002/09/25 12:56:46 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _PLICENSE_HXX
#define _PLICENSE_HXX

#ifndef _AGENTPG_HXX
#include "agentpg.hxx"
#endif

#ifndef _SV_FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif
#ifndef _SV_SCRBAR_HXX
#include <vcl/scrbar.hxx>
#endif

#ifndef _SVEDIT_HXX //autogen
#include <svtools/svmedit.hxx>
#endif
#ifndef _SFXLSTNER_HXX
#include <svtools/lstner.hxx>
#endif

#define RETURN_LIC_NORMAL   1
#define RETURN_LIC_UPDATE   2

//------------------------------------------------------------------------
class LicenceView : public MultiLineEdit, public SfxListener
{
    BOOL            mbEndReached;
    Link            maEndReachedHdl;
    Link            maScrolledHdl;

public:
                    LicenceView( Window* pParent, const ResId& rResId );
                   ~LicenceView();

    void            ScrollDown( ScrollType eScroll );

    BOOL            IsEndReached() const;
    BOOL            EndReached() const { return mbEndReached; }
    void            SetEndReached( BOOL bEnd ) { mbEndReached = bEnd; }

    void            SetEndReachedHdl( const Link& rHdl )  { maEndReachedHdl = rHdl; }
    const Link&     GetAutocompleteHdl() const { return maEndReachedHdl; }

    void            SetScrolledHdl( const Link& rHdl )  { maScrolledHdl = rHdl; }
    const Link&     GetScrolledHdl() const { return maScrolledHdl; }

    virtual void    Notify( SfxBroadcaster& rBC, const SfxHint& rHint );
};

//------------------------------------------------------------------------
class PageLicense : public SvAgentPage
{
    LicenceView         aTextEdit;
    FixedText           aFTInfo1;
    FixedText           aFTInfo2a;
    FixedText           aFTInfo2b;
    FixedText           aFTInfo3a;
    FixedText           aFTInfo3b;
    CheckBox            aCBAccept;
    PushButton          aPBPageDown;
    FixedImage          aArrow;
    String              aStrAccept;
    String              aStrNotAccept;
    String              aOldCancelText;
    BOOL                bEndReached     : 1;
    BOOL                bHasFile        : 1;

    void                EnableControls();

    DECL_LINK(          AcceptHdl, CheckBox * );
    DECL_LINK(          PageDownHdl, PushButton * );
    DECL_LINK(          EndReachedHdl, LicenceView * );
    DECL_LINK(          ScrolledHdl, LicenceView * );
    DECL_LINK(          PrintHdl, SvAgentPage * );

public:
		PageLicense( SvAgentDlg* pParent, const ResId& rResId );
		~PageLicense();

	static SvAgentPage*	Create(SvAgentDlg* pParent, const ResId& rResId);

	virtual BOOL		AllowNext();

    const String&		GetNextText() const { return aStrAccept; }
	const String&		GetBackText() const { return aStrNotAccept; }

    BOOL				SetLicenseFile( const String& rFileName );
	virtual USHORT 		GetReturnVal();

    virtual ULONG		GetProperty();
	virtual void		InitProperty( ULONG nProp );

    virtual long        PreNotify( NotifyEvent& rNEvt );
};

#endif //_PLICENSE_HXX

