/*************************************************************************
 *
 *  $RCSfile: viewsect.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:02:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _TOOLKIT_UNOIFACE_HXX //autogen wg. CreateControlContainer
#include <toolkit/unoiface.hxx>
#endif

#ifndef _SMART_COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HXX_
#include <smart/com/sun/star/lang/XMultiServiceFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XSINGLESERVICEFACTORY_HXX_
#include <smart/com/sun/star/lang/XSingleServiceFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LOADER_XIMPLEMENTATIONLOADER_HXX_
#include <smart/com/sun/star/loader/XImplementationLoader.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LOADER_CANNOTACTIVATEFACTORYEXCEPTION_HXX_
#include <smart/com/sun/star/loader/CannotActivateFactoryException.hxx>
#endif

#ifndef _SV_EXCHANGE_HXX //autogen wg. Exchange
#include <vcl/exchange.hxx>
#endif

#ifndef _TOOLS_DEBUG_HXX //autogen wg. DBG_ERROR
#include <tools/debug.hxx>
#endif

#ifndef _SV_SVAPP_HXX //autogen wg. Application
#include <vcl/svapp.hxx>
#endif

#ifndef _TOOLS_INTN_HXX //autogen wg. International
#include <tools/intn.hxx>
#endif

#ifndef _SV_SOUND_HXX //autogen wg. Sound
#include <vcl/sound.hxx>
#endif

#include <usr/weak.hxx>
#include <usr/reflserv.hxx>
#include <usr/factoryhlp.hxx>
#include <usr/services.hxx>
#include <usr/smart2uno.hxx>

#include "datman.hxx"
#include "viewsect.hxx"
#include "sections.hrc"
#include "adrresid.hxx"
#include "adrmod.hxx"
#include "adrexch.hxx"
#include "adrprop.hrc"

#define LABEL_OFFSET  20

SMART_UNO_IMPLEMENTATION( AdrControlContainer, UsrObject );

AdrControlContainer::AdrControlContainer(Window* pParent,AdrDataManagerHdl pDM,
										 WinBits nStyle):
	DockingWindow(pParent,nStyle | WB_DIALOGCONTROL),
	aFixedText(this),
	nLabelWidth(LABEL_OFFSET),
	ppDatMan(pDM)
{
	aFixedText.SetPosPixel(Point(LABEL_OFFSET,2));
	aFixedText.Show();

	aCtrContainer = CreateControlContainer(this);
}

AdrControlContainer::~AdrControlContainer()
{
	if ( xControl.is() )
	{
		aCtrContainer->removeControl(xControl);
		xControl->dispose();
	}
}

long AdrControlContainer::PreNotify( NotifyEvent& rNEvt )
{	
	if(rNEvt.GetType() == EVENT_LOSEFOCUS)
	{		
		TRY
		{
			XBoundComponentRef xBound = XBoundComponentRef(xControl, USR_QUERY);
			
			if (!xBound.is())
				xBound  = XBoundComponentRef(xCtrModel, USR_QUERY);

			// Commit erfolgreich
			if (xBound->commit())
			{
				//pDatMan->saveRecord();
				return DockingWindow::PreNotify(rNEvt);
			}
		}
		CATCH_ALL()
		{
		}
		Sound::Beep();
		return TRUE;
	}
	return DockingWindow::PreNotify(rNEvt);
}

void AdrControlContainer::Resize()
{
	Size aSize = GetOutputSizePixel();

	long nCtrWidth = aSize.Width()-nLabelWidth;
	aSize.Width() = nLabelWidth;
	aFixedText.SetSizePixel(aSize);

	if(xCtrWin.is())
	{
		xCtrWin->setPosSize(nLabelWidth, 0, nCtrWidth,aSize.Height(), PosSize_SIZE);
	}
}


void AdrControlContainer::SetLabel(const String& aStr)
{
	aFixedText.SetText(aStr);
}

String AdrControlContainer::GetLabel()
{
	return aFixedText.GetText();
}

void AdrControlContainer::SetLabelWidth(long nWidth)
{
	nLabelWidth=nWidth+LABEL_OFFSET;	

	
	Size aSize = GetOutputSizePixel();
		
	long nCtrWidth = aSize.Width()-nLabelWidth;
	aSize.Width() = nLabelWidth;
	aFixedText.SetSizePixel(aSize);

	if(xCtrWin.is())
	{
		xCtrWin->setPosSize(nLabelWidth, 0, nCtrWidth 
				,aSize.Height(), PosSize_POSSIZE);
	}
}

long AdrControlContainer::GetLabelWidth()
{
	return nLabelWidth-LABEL_OFFSET;
}


void AdrControlContainer::createXControl(const XControlModelRef& xGModel)
{
	xCtrModel=xGModel;

	if( aCtrContainer.is())
	{
		XMultiServiceFactoryRef xMgr( NAMESPACE_USR( getProcessServiceManager )() );
		
		if ( xCtrModel.is() && xMgr.is())
		{
			XPropertySetRef xPropSet( xCtrModel, USR_QUERY );

			if ( xPropSet.is())
			{
				XPropertySetInfoRef xPropInfo = xPropSet->getPropertySetInfo();
				if(xPropInfo->hasPropertyByName(FM_PROP_TEXT))
				{
					xPropSet->addPropertyChangeListener(FM_PROP_TEXT, this);
				}
				else if(xPropInfo->hasPropertyByName(FM_PROP_VALUE))
				{
					xPropSet->addPropertyChangeListener(FM_PROP_VALUE, this);
				}
				
				UsrAny aAny = xPropSet->getPropertyValue( L"DefaultControl" );
				UString aControlName = aAny.getString();

				xControl=XControlRef(xMgr->createInstance( aControlName ), USR_QUERY );
				if ( xControl.is() )
				{
					xControl->setModel( xCtrModel);
				}
			}
			
			if ( xControl.is() )
			{
				// Peer als Child zu dem FrameWindow
				aCtrContainer->addControl(L"Bla", xControl);
				xCtrWin=XWindowRef(xControl, USR_QUERY );
				xCtrWin->setVisible( TRUE );
				xControl->setDesignMode(FALSE);
				Size aSize = GetOutputSizePixel();
				xCtrWin->setPosSize(nLabelWidth, 0, aSize.Width()-nLabelWidth,
									aSize.Height(), PosSize_POSSIZE);
			}
		}
	}
}

BOOL AdrControlContainer::queryInterface( UsrUik aUIK, XInterfaceRef& xRet )
{
	if( aUIK == XPropertyChangeListener::getSmartUik() )
		xRet = (XPropertyChangeListener*) this;
	else if( aUIK == XEventListener::getSmartUik() )
		xRet = (XEventListener*) this;
	else return UsrObject::queryInterface( aUIK, xRet );
	return xRet.is();
}

void AdrControlContainer::disposing( const EventObject& Source )
{
	TRY
	{	
		if ( xCtrModel.is())
		{
			XPropertySetRef aPropSet(xCtrModel, USR_QUERY );
			aPropSet->removePropertyChangeListener(FM_PROP_VALUE, this);
		}

	}
	CATCH_ALL()
	{
		DBG_ERROR("::propertyChange: something went wrong !");
	}
	END_CATCH
}

void AdrControlContainer::propertyChange(const PropertyChangeEvent& evt) THROWS( (UsrSystemException) )
{
	TRY
	{	
		if(evt.PropertyName == FM_PROP_VALUE ||
			evt.PropertyName == FM_PROP_TEXT)
		{
			if(ppDatMan!=NULL && *ppDatMan!=NULL )
				(*ppDatMan)->editRecord();
		}
	}
	CATCH_ALL()
	{
		DBG_ERROR("::propertyChange: something went wrong !");
	}
	END_CATCH

}


//===================================================================

long nLineHeight = 0;

AdrViewSection::AdrViewSection(Window* pParent,AdrDataManagerHdl	pDM,  WinBits nStyle):
	SplitWindow(pParent, nStyle | WB_NOSPLITDRAW ),
	ppDatMan(pDM),
	nStdLabelWidth(0),
	nNextID(1)
{
	if(!nLineHeight)
	{
		ListBox aListBox(this, WB_DROPDOWN);

		aListBox.SetPosSizePixel(Point(0,0),Size(100,100));
		nLineHeight=aListBox.GetSizePixel().Height();
		//nLineHeight+=5;
	}
//	SetAlign(WINDOWALIGN_LEFT);
	EnableDrop();

	DockingWindow* pWindow=new DockingWindow(this);

	InsertItem( 30000,pWindow,50,0, 0, SWIB_RELATIVESIZE);
}

AdrViewSection::~AdrViewSection()
{
	USHORT nCount= GetItemCount();

	for(short i=nCount-1; i>= 0;i--)
	{
		USHORT nID=GetItemId(i);
		DockingWindow* pWindow=GetItemWindow(nID);
		if(pWindow!=NULL)
		{
			RemoveItem(nID);
			delete pWindow;
		}
		else
		{
			USHORT nSetCount= GetItemCount(nID);
			for(short j=nSetCount-1; i>= 0;i--)
			{
				USHORT nChildID=GetItemId(j,nID);
				DockingWindow* pWindow=GetItemWindow(nID);
				if(pWindow!=NULL)
				{
					RemoveItem(nID);
					delete pWindow;
				}
			}
			RemoveItem(nID);
		}
	}
}
void AdrViewSection::Resize()
{
	SplitWindow::Resize();
}

static ULONG nFormat = 0;

BOOL AdrViewSection::Drop( const DropEvent& rEvt )
{
	TRY
	{
		if (!nFormat)
			 nFormat = Exchange::RegisterFormatName(ADR_FIELD_EXCH);

		SvDataObjectRef xDataObj = SvDataObject::PasteDragServer( rEvt );
		SvData aData(nFormat);
		xDataObj->GetData( &aData );
		String aDataExchStr;
		if (!aData.GetData(aDataExchStr))
			return FALSE;

		// SBA_FIELDEXCHANGE_FORMAT
		// "Datenbankname";"Tabellen/QueryName";1/0(fuer Tabelle/Abfrage);"Feldname"
		String aDatabaseName = aDataExchStr.GetToken(0,char(11));
		String aObjectName	 = aDataExchStr.GetToken(1,char(11));
		UINT16 nObjectType	 = aDataExchStr.GetToken(2,char(11));
		String aFieldName	 = aDataExchStr.GetToken(3,char(11));

		if(	ppDatMan==NULL || *ppDatMan==NULL ||
			!aFieldName.Len() || !aObjectName.Len() || !aDatabaseName.Len() ||
			aObjectName!= U2S((*ppDatMan)->getActivDataSource()))
			return FALSE;

		USHORT nID=GetItemId(GetPointerPosPixel());

		USHORT nPos= GetItemPos(nID);
		
		AdrControlContainer* pControl= new AdrControlContainer(this,ppDatMan,0);

		XControlModelRef aModel = (*ppDatMan)->loadControlModel(S2U(aFieldName));
		pControl->createXControl(aModel);
		
		long nTextWidth = pControl->GetTextSize(aFieldName).Width()+5;

		if(nTextWidth > nStdLabelWidth) 
		{
			nStdLabelWidth = nTextWidth;
			UpdateLabelWidth(nStdLabelWidth);
		}
		else
			nTextWidth = nStdLabelWidth;

		String aString=Application::GetAppInternational().Upper(aFieldName.Copy(0,1));
		aString+=Application::GetAppInternational().Lower(aFieldName.Copy(1));
		pControl->SetLabel(aString);
		pControl->SetLabelWidth(nTextWidth);
		if(nID!=30000)
		{
			USHORT nSetId;
			BOOL bFlag=GetSet(nID, nSetId, nPos);
			InsertItem( nNextID,pControl,50,nPos, nSetId);
			SetSplitSize(nNextID++, 0);
		}
		else
		{
			//SWIB_FIXED,SWIB_RELATIVESIZE,SWIB_PERCENTSIZE,SWIB_COLSET,SWIB_INVISIBLE			

			InsertItem( nNextID,NULL,nLineHeight,nPos, 0, SWIB_FIXED | SWIB_COLSET);
			SetSplitSize(nNextID, 0);
			USHORT nSetId = nNextID;
			nNextID++;
			InsertItem( nNextID,pControl,50,0, nSetId, 0);
			SetSplitSize(nNextID++, 0);
		}
			
	}		
	CATCH_ALL()
	{
		DBG_ERROR("AdrViewSection::Drop: something went wrong !");
		return FALSE;
	}
	END_CATCH
	return TRUE;
}

BOOL AdrViewSection::QueryDrop( const DropEvent& rEvt )
{
	TRY
	{
		if (!nFormat)
			 nFormat = Exchange::RegisterFormatName(ADR_FIELD_EXCH);

		SvDataObjectRef xDataObj = SvDataObject::PasteDragServer( rEvt );
		SvData aData(nFormat);
		xDataObj->GetData( &aData );
		String aDataExchStr;
		if (!aData.GetData(aDataExchStr))
			return FALSE;

		// SBA_FIELDEXCHANGE_FORMAT
		// "Datenbankname";"Tabellen/QueryName";1/0(fuer Tabelle/Abfrage);"Feldname"
		String aDatabaseName = aDataExchStr.GetToken(0,char(11));
		String aObjectName	 = aDataExchStr.GetToken(1,char(11));
		UINT16 nObjectType	 = aDataExchStr.GetToken(2,char(11));
		String aFieldName	 = aDataExchStr.GetToken(3,char(11));

		if(	ppDatMan==NULL || *ppDatMan==NULL ||
			!aFieldName.Len() || !aObjectName.Len() || !aDatabaseName.Len() ||
			aObjectName!= U2S((*ppDatMan)->getActivDataSource()))
			return FALSE;
	}
	CATCH_ALL()
	{
		DBG_ERROR("AdrViewSection::QueryDrop: something went wrong !");
		return FALSE;
	}
	END_CATCH
	return TRUE;

}

long AdrViewSection::PreNotify( NotifyEvent& rNEvt )
{	
	if(rNEvt.GetType() == EVENT_COMMAND)
	{
		int bla=5;
	}
	else if(rNEvt.GetType() == EVENT_QUERYDROP)
	{
		DropEvent*	pDrop=rNEvt.GetDropEvent();
		rNEvt.SetReturnValue(QueryDrop(*pDrop));
		return TRUE;
	}
	else if(rNEvt.GetType() == EVENT_DROP)
	{
		DropEvent*	pDrop=rNEvt.GetDropEvent();

		rNEvt.SetReturnValue(Drop(*pDrop));
		return TRUE;
	}
	return SplitWindow::PreNotify(rNEvt );
}

void AdrViewSection::UpdateLabelWidth(long nLabelWidth)
{
	USHORT nCount= GetItemCount();

	for(short i=nCount-1; i>= 0;i--)
	{
		USHORT nID=GetItemId(i);
		DockingWindow* pWindow=GetItemWindow(nID);
		if(pWindow==NULL)
		{
			USHORT nSetCount= GetItemCount(nID);
			for(short j=nSetCount-1; j>= 0;j--)
			{
				USHORT nChildID=GetItemId(j,nID);
				AdrControlContainer* pControl = 
					(AdrControlContainer*) GetItemWindow(nChildID);
				if(pControl!=NULL)
				{
					pControl->SetLabelWidth(nLabelWidth);
				}
			}
		}
	}
}


