/*************************************************************************
 *
 *  $RCSfile: pkgchk_misc.h,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: vg $ $Date: 2003/06/12 10:46:35 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2002 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#if ! defined INCLUDED_PKGCHK_MISC_H
#define INCLUDED_PKGCHK_MISC_H

#include "rtl/string.hxx"
#include "rtl/ustrbuf.hxx"
#include "rtl/bootstrap.hxx"
#include "osl/file.hxx"

#define OUSTR(x) ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM(x) )

#if defined SAL_W32
#define LF "\r\n"
#else
#define LF "\n"
#endif


namespace pkgchk
{

class pkgchk_env;

//
// path name handling
//

//==============================================================================
inline bool ends_with_ignore_ascii_case(
    ::rtl::OUString const & str, char const * end, sal_Int32 end_len )
{
    sal_Int32 len = str.getLength();
    return (end_len <= len &&
            0 == rtl_ustr_ascii_compareIgnoreAsciiCase(
                str.pData->buffer + len - end_len, end ));
}

//==============================================================================
inline ::rtl::OUString path_concat(
    ::rtl::OUString const & dir, ::rtl::OUString const & file )
{
    ::rtl::OUStringBuffer buf( dir.getLength() + 1 + file.getLength() );
    buf.append( dir );
    buf.append( (sal_Unicode)'/' );
    buf.append( file );
    return buf.makeStringAndClear();
}

//==============================================================================
inline ::rtl::OUString path_concat(
    ::rtl::OUString const & dir, char const * file, sal_Int32 file_len )
{
    ::rtl::OUStringBuffer buf( dir.getLength() + 1 + file_len );
    buf.append( dir );
    buf.append( (sal_Unicode)'/' );
    buf.appendAscii( file, file_len );
    return buf.makeStringAndClear();
}

//==============================================================================
::rtl::OUString const & path_get_executable();

//==============================================================================
::rtl::OUString path_make_absolute( ::rtl::OUString const & path );

//==============================================================================
inline bool path_exists( ::rtl::OUString const & path )
{
    ::osl::DirectoryItem dirItem;
    return (::osl::DirectoryItem::E_None ==
            ::osl::DirectoryItem::get( path, dirItem ));
}

//
// file, path handling
//

sal_uInt32 const c_default_file_status_mask =
    FileStatusMask_Type |
    FileStatusMask_FileName | FileStatusMask_FileURL |
    FileStatusMask_ModifyTime;

//==============================================================================
void file_write(
    oslFileHandle file, ::rtl::OString const & text,
    ::rtl::OUString const & fileName );

//==============================================================================
inline void file_write(
    ::osl::File const & file, ::rtl::OString const & text,
    ::rtl::OUString const & fileName )
{
    file_write(
        *reinterpret_cast< oslFileHandle const * >( &file ), text, fileName );
}

//==============================================================================
sal_uInt64 file_get_size( oslFileHandle file );

//==============================================================================
inline sal_uInt64 file_get_size( ::osl::File const & file )
{
    return file_get_size(
        *reinterpret_cast< oslFileHandle const * >( &file ) );
}


//==============================================================================
void path_get_status(
    ::osl::FileStatus * status,
    ::rtl::OUString const & path, sal_uInt32 mask );

//==============================================================================
void diritem_get_status(
    ::osl::FileStatus * status,
    ::osl::DirectoryItem & dirItem, sal_uInt32 mask );

//==============================================================================
::rtl::OUString file_status_get_encoded_name(
    ::osl::FileStatus const & status );

//==============================================================================
void dir_create( ::rtl::OUString const & path );

//==============================================================================
inline void dir_ensure( ::rtl::OUString const & path )
{
    if (! path_exists( path ))
        dir_create( path );
}

//==============================================================================
void dir_open(
    ::osl::Directory & dir, ::rtl::OUString const & path,
    bool create = false );

//==============================================================================
void path_copy(
    ::rtl::OUString const & dest_path_, ::rtl::OUString const & src_path,
    pkgchk_env const & env, bool overwrite = false );

//==============================================================================
void path_erase(
    ::rtl::OUString const & path );

//==============================================================================
void zip_inflate(
    ::rtl::OUString const & dest_path,
    ::rtl::OUString const & src_path, pkgchk_env const & env );

//
// bootstrap variables
//

//==============================================================================
::rtl::OUString get_from_bootstrap(
    ::rtl::OUString const & key, ::rtl::Bootstrap const & bstrap );

//
// checks whether concurrent office process is running
//

//==============================================================================
bool office_is_running( ::rtl::Bootstrap const & unorc );


//
// supported platforms
//

#if defined (WIN32)
#define THIS_PLATFORM_PATH "/windows.plt"
#elif defined (SOLARIS) && defined (SPARC)
#define THIS_PLATFORM_PATH "/solaris_sparc.plt"
#elif defined (SOLARIS) && defined (INTEL)
#define THIS_PLATFORM_PATH "/solaris_x86.plt"
#elif defined (LINUX) && defined (INTEL)
#define THIS_PLATFORM_PATH "/linux_x86.plt"
#elif defined (LINUX) && defined (POWERPC)
#define THIS_PLATFORM_PATH "/linux_powerpc.plt"
#elif defined (LINUX) && defined (S390)
#define THIS_PLATFORM_PATH "/linux_s390.plt"
#elif defined (LINUX) && defined (SPARC)
#define THIS_PLATFORM_PATH "/linux_sparc.plt"
#elif defined (MACOSX) && defined (POWERPC)
#define THIS_PLATFORM_PATH "/macosx_powerpc.plt"
#elif defined (NETBSD) && defined (SPARC)
#define THIS_PLATFORM_PATH "/netbsd_sparc.plt"
#elif defined (FREEBSD) && defined (INTEL)
#define THIS_PLATFORM_PATH "/freebsd_x86.plt"
#elif defined (IRIX)
#define THIS_PLATFORM_PATH "/irix_mips.plt"
#else
#error "unknown platform"
insert your platform identifier above; inserted for the case the preprocessor ignores error
#endif

//
// checks whether path is to be ignored
//

//==============================================================================
inline bool platform_ignore_path( ::rtl::OUString const & path )
{
    // check if platform path
    if (! ends_with_ignore_ascii_case(
            path, RTL_CONSTASCII_STRINGPARAM(".plt") ))
    {
        return false;
    }
    // check if this platform path
    if (ends_with_ignore_ascii_case(
            path, RTL_CONSTASCII_STRINGPARAM(THIS_PLATFORM_PATH) ))
    {
        return false;
    }
    return true;
}

}

#endif
